/* valaccodemethodcallmodule.c generated by valac, the Vala compiler
 * generated from valaccodemethodcallmodule.vala, do not modify */

/* valaccodemethodcallmodule.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include "valacodegen.h"
#include <vala.h>
#include <valaccode.h>
#include <valagee.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>

#define _vala_ccode_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
#define _vala_target_value_unref0(var) ((var == NULL) ? NULL : (var = (vala_target_value_unref (var), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define VALA_TYPE_GLIB_VALUE (vala_glib_value_get_type ())
#define VALA_GLIB_VALUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GLIB_VALUE, ValaGLibValue))
#define VALA_GLIB_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GLIB_VALUE, ValaGLibValueClass))
#define VALA_IS_GLIB_VALUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GLIB_VALUE))
#define VALA_IS_GLIB_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GLIB_VALUE))
#define VALA_GLIB_VALUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GLIB_VALUE, ValaGLibValueClass))

typedef struct _ValaGLibValue ValaGLibValue;
typedef struct _ValaGLibValueClass ValaGLibValueClass;
typedef struct _ValaGLibValuePrivate ValaGLibValuePrivate;
#define _vala_ccode_base_module_emit_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_base_module_emit_context_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValaGLibValue {
	ValaTargetValue parent_instance;
	ValaGLibValuePrivate * priv;
	ValaCCodeExpression* cvalue;
	gboolean lvalue;
	gboolean non_null;
	gchar* ctype;
	ValaList* array_length_cvalues;
	ValaCCodeExpression* array_size_cvalue;
	gboolean array_null_terminated;
	ValaCCodeExpression* array_length_cexpr;
	ValaCCodeExpression* delegate_target_cvalue;
	ValaCCodeExpression* delegate_target_destroy_notify_cvalue;
};

struct _ValaGLibValueClass {
	ValaTargetValueClass parent_class;
};


static gpointer vala_ccode_method_call_module_parent_class = NULL;

static void vala_ccode_method_call_module_real_visit_method_call (ValaCodeVisitor* base,
                                                           ValaMethodCall* expr);
static gchar* vala_ccode_method_call_module_generate_enum_tostring_function (ValaCCodeMethodCallModule* self,
                                                                      ValaEnum* en);
G_GNUC_INTERNAL ValaGLibValue* vala_glib_value_new (ValaDataType* value_type,
                                    ValaCCodeExpression* cvalue,
                                    gboolean lvalue);
G_GNUC_INTERNAL ValaGLibValue* vala_glib_value_construct (GType object_type,
                                          ValaDataType* value_type,
                                          ValaCCodeExpression* cvalue,
                                          gboolean lvalue);
G_GNUC_INTERNAL GType vala_glib_value_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static gboolean vala_ccode_method_call_module_has_ref_out_param (ValaCCodeMethodCallModule* self,
                                                          ValaCallable* c);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static gpointer
_vala_map_ref0 (gpointer self)
{
	return self ? vala_map_ref (self) : NULL;
}


static gpointer
_vala_ccode_node_ref0 (gpointer self)
{
	return self ? vala_ccode_node_ref (self) : NULL;
}


static gpointer
_vala_target_value_ref0 (gpointer self)
{
	return self ? vala_target_value_ref (self) : NULL;
}


static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  int str_array_length1)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp20_;
		gint _tmp22_;
		gint _tmp23_;
		gsize _tmp24_;
		gint _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		const gchar* res = NULL;
		gsize _tmp28_;
		void* _tmp29_;
		void* ptr = NULL;
		const gchar* _tmp30_;
		const gchar* _tmp31_;
		void* _tmp32_;
		const gchar* _tmp45_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp12_ = 0;
				gint _tmp13_;
				const gchar* _tmp14_;
				gsize _tmp19_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					gint _tmp8_;
					_tmp8_ = i;
					_tmp7_ = _tmp8_ < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp9_ = FALSE;
					if (str_array_length1 == -1) {
						gint _tmp10_;
						const gchar* _tmp11_;
						_tmp10_ = i;
						_tmp11_ = str_array[_tmp10_];
						_tmp9_ = _tmp11_ != NULL;
					} else {
						_tmp9_ = FALSE;
					}
					_tmp6_ = _tmp9_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp13_ = i;
				_tmp14_ = str_array[_tmp13_];
				if (_tmp14_ != NULL) {
					gint _tmp15_;
					const gchar* _tmp16_;
					gint _tmp17_;
					gint _tmp18_;
					_tmp15_ = i;
					_tmp16_ = str_array[_tmp15_];
					_tmp17_ = strlen ((const gchar*) _tmp16_);
					_tmp18_ = _tmp17_;
					_tmp12_ = _tmp18_;
				} else {
					_tmp12_ = 0;
				}
				_tmp19_ = len;
				len = _tmp19_ + _tmp12_;
			}
		}
		_tmp20_ = i;
		if (_tmp20_ == 0) {
			gchar* _tmp21_;
			_tmp21_ = g_strdup ("");
			result = _tmp21_;
			return result;
		}
		_tmp22_ = i;
		str_array_length1 = _tmp22_;
		_tmp23_ = str_array_length1;
		_tmp24_ = len;
		_tmp25_ = strlen ((const gchar*) separator);
		_tmp26_ = _tmp25_;
		_tmp27_ = i;
		len = _tmp24_ + (_tmp26_ * (_tmp27_ - 1));
		_tmp28_ = len;
		_tmp29_ = g_malloc (_tmp28_);
		res = _tmp29_;
		_tmp30_ = res;
		_tmp31_ = str_array[0];
		_tmp32_ = g_stpcpy ((void*) _tmp30_, (const gchar*) _tmp31_);
		ptr = _tmp32_;
		{
			gboolean _tmp33_ = FALSE;
			i = 1;
			_tmp33_ = TRUE;
			while (TRUE) {
				gint _tmp35_;
				void* _tmp36_;
				void* _tmp37_;
				const gchar* _tmp38_ = NULL;
				gint _tmp39_;
				const gchar* _tmp40_;
				void* _tmp43_;
				void* _tmp44_;
				if (!_tmp33_) {
					gint _tmp34_;
					_tmp34_ = i;
					i = _tmp34_ + 1;
				}
				_tmp33_ = FALSE;
				_tmp35_ = i;
				if (!(_tmp35_ < str_array_length1)) {
					break;
				}
				_tmp36_ = ptr;
				_tmp37_ = g_stpcpy (_tmp36_, (const gchar*) separator);
				ptr = _tmp37_;
				_tmp39_ = i;
				_tmp40_ = str_array[_tmp39_];
				if (_tmp40_ != NULL) {
					gint _tmp41_;
					const gchar* _tmp42_;
					_tmp41_ = i;
					_tmp42_ = str_array[_tmp41_];
					_tmp38_ = (const gchar*) _tmp42_;
				} else {
					_tmp38_ = "";
				}
				_tmp43_ = ptr;
				_tmp44_ = g_stpcpy (_tmp43_, _tmp38_);
				ptr = _tmp44_;
			}
		}
		_tmp45_ = res;
		res = NULL;
		result = (gchar*) _tmp45_;
		return result;
	} else {
		gchar* _tmp46_;
		_tmp46_ = g_strdup ("");
		result = _tmp46_;
		return result;
	}
}


static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}


static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp6_;
	gchar* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		glong _tmp3_;
		_tmp3_ = string_length;
		offset = _tmp3_ + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		glong _tmp4_;
		_tmp4_ = string_length;
		g_return_val_if_fail (offset <= _tmp4_, NULL);
	}
	if (len < ((glong) 0)) {
		glong _tmp5_;
		_tmp5_ = string_length;
		len = _tmp5_ - offset;
	}
	_tmp6_ = string_length;
	g_return_val_if_fail ((offset + len) <= _tmp6_, NULL);
	_tmp7_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp7_;
	return result;
}


static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch6_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch6_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally6;
	__catch6_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally6:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static void
vala_ccode_method_call_module_real_visit_method_call (ValaCodeVisitor* base,
                                                      ValaMethodCall* expr)
{
	ValaCCodeMethodCallModule * self;
	ValaCCodeFunctionCall* ccall = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaCCodeExpression* _tmp2_;
	ValaCCodeExpression* _tmp3_;
	ValaCCodeFunctionCall* _tmp4_;
	ValaCCodeFunctionCall* _tmp5_;
	ValaCCodeFunctionCall* async_call = NULL;
	ValaCCodeFunctionCall* finish_call = NULL;
	ValaMethod* m = NULL;
	ValaDelegate* deleg = NULL;
	ValaList* params = NULL;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp6_;
	ValaExpression* _tmp7_;
	ValaMemberAccess* _tmp8_;
	ValaDataType* itype = NULL;
	ValaExpression* _tmp9_;
	ValaExpression* _tmp10_;
	ValaDataType* _tmp11_;
	ValaDataType* _tmp12_;
	ValaDataType* _tmp13_;
	ValaDataType* _tmp14_;
	ValaList* _tmp15_;
	ValaDataType* _tmp16_;
	ValaHashMap* in_arg_map = NULL;
	GHashFunc _tmp130_;
	GEqualFunc _tmp131_;
	GEqualFunc _tmp132_;
	ValaHashMap* _tmp133_;
	ValaHashMap* out_arg_map = NULL;
	ValaHashMap* _tmp134_;
	ValaHashMap* _tmp135_;
	gboolean _tmp136_ = FALSE;
	ValaMethod* _tmp137_;
	gboolean _tmp282_ = FALSE;
	ValaMethod* _tmp283_;
	ValaCCodeExpression* ccall_expr = NULL;
	ValaCCodeFunctionCall* _tmp452_;
	ValaCCodeExpression* _tmp453_;
	ValaMethod* _tmp454_;
	ValaCCodeExpression* instance = NULL;
	gboolean _tmp478_ = FALSE;
	ValaMethod* _tmp479_;
	gboolean _tmp635_ = FALSE;
	ValaMethod* _tmp636_;
	ValaMethod* _tmp688_;
	gboolean ellipsis = FALSE;
	gint i = 0;
	gint arg_pos = 0;
	ValaIterator* params_it = NULL;
	ValaList* _tmp884_;
	ValaIterator* _tmp885_;
	ValaIterator* _tmp1226_;
	gboolean _tmp1236_ = FALSE;
	gboolean _tmp1237_ = FALSE;
	ValaMethod* _tmp1238_;
	gboolean _tmp1365_ = FALSE;
	ValaDelegate* _tmp1366_;
	gboolean _tmp1465_ = FALSE;
	ValaMethod* _tmp1466_;
	gboolean _tmp1482_;
	gboolean _tmp1483_;
	gboolean _tmp1489_;
	ValaDataType* _tmp1514_;
	gboolean return_result_via_out_param = FALSE;
	ValaDataType* _tmp1538_;
	ValaDataType* _tmp1539_;
	ValaDataType* _tmp1540_;
	gboolean _tmp1541_;
	gboolean _tmp1542_ = FALSE;
	ValaDataType* _tmp1543_;
	ValaCCodeFunctionCall* _tmp1572_;
	ValaCCodeFunctionCall* _tmp1573_;
	ValaCCodeExpression* out_param_ref = NULL;
	gboolean _tmp1574_;
	gint last_pos = 0;
	gint min_pos = 0;
	ValaCCodeFunctionCall* _tmp1589_;
	ValaCCodeFunctionCall* _tmp1590_;
	ValaCCodeFunctionCall* _tmp1614_;
	gboolean _tmp1638_;
	gboolean _tmp1639_;
	gboolean _tmp1665_;
	gboolean _tmp1666_;
	gboolean _tmp1696_;
	gboolean _tmp1702_ = FALSE;
	gboolean _tmp1703_ = FALSE;
	ValaMethod* _tmp1704_;
	gboolean _tmp1742_ = FALSE;
	gboolean _tmp1743_ = FALSE;
	ValaMethod* _tmp1744_;
	ValaMethod* _tmp1763_;
	gboolean _tmp1880_ = FALSE;
	ValaCodeNode* _tmp1881_;
	ValaCodeNode* _tmp1882_;
	ValaList* _tmp1965_;
	ValaIterator* _tmp1966_;
	gboolean _tmp2051_ = FALSE;
	gboolean _tmp2052_ = FALSE;
	ValaMethod* _tmp2053_;
	self = (ValaCCodeMethodCallModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_method_call_get_call (expr);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_ccode_function_call_new (_tmp3_);
	_tmp5_ = _tmp4_;
	_vala_ccode_node_unref0 (_tmp3_);
	ccall = _tmp5_;
	async_call = NULL;
	finish_call = NULL;
	m = NULL;
	deleg = NULL;
	_tmp6_ = vala_method_call_get_call (expr);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp7_) : NULL);
	ma = _tmp8_;
	_tmp9_ = vala_method_call_get_call (expr);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_expression_get_value_type (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _vala_code_node_ref0 (_tmp12_);
	itype = _tmp13_;
	_tmp14_ = itype;
	_tmp15_ = vala_data_type_get_parameters (_tmp14_);
	_vala_iterable_unref0 (params);
	params = _tmp15_;
	_tmp16_ = itype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, VALA_TYPE_METHOD_TYPE)) {
		ValaMemberAccess* _tmp17_;
		ValaDataType* _tmp18_;
		ValaMethod* _tmp19_;
		ValaMethod* _tmp20_;
		ValaMethod* _tmp21_;
		ValaMethod* _tmp22_;
		gboolean _tmp24_ = FALSE;
		gboolean _tmp25_ = FALSE;
		ValaMemberAccess* _tmp26_;
		ValaExpression* _tmp27_;
		ValaExpression* _tmp28_;
		_tmp17_ = ma;
		_vala_assert (_tmp17_ != NULL, "ma != null");
		_tmp18_ = itype;
		_tmp19_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp20_ = _tmp19_;
		_tmp21_ = _vala_code_node_ref0 (_tmp20_);
		_vala_code_node_unref0 (m);
		m = _tmp21_;
		_tmp22_ = m;
		if (!vala_get_ccode_simple_generics (_tmp22_)) {
			ValaMemberAccess* _tmp23_;
			_tmp23_ = ma;
			vala_ccode_base_module_check_type_arguments ((ValaCCodeBaseModule*) self, _tmp23_);
		}
		_tmp26_ = ma;
		_tmp27_ = vala_member_access_get_inner (_tmp26_);
		_tmp28_ = _tmp27_;
		if (_tmp28_ != NULL) {
			ValaMemberAccess* _tmp29_;
			ValaExpression* _tmp30_;
			ValaExpression* _tmp31_;
			ValaDataType* _tmp32_;
			ValaDataType* _tmp33_;
			_tmp29_ = ma;
			_tmp30_ = vala_member_access_get_inner (_tmp29_);
			_tmp31_ = _tmp30_;
			_tmp32_ = vala_expression_get_value_type (_tmp31_);
			_tmp33_ = _tmp32_;
			_tmp25_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp33_, VALA_TYPE_ENUM_VALUE_TYPE);
		} else {
			_tmp25_ = FALSE;
		}
		if (_tmp25_) {
			ValaMemberAccess* _tmp34_;
			ValaExpression* _tmp35_;
			ValaExpression* _tmp36_;
			ValaDataType* _tmp37_;
			ValaDataType* _tmp38_;
			ValaMethod* _tmp39_;
			ValaMethod* _tmp40_;
			ValaMethod* _tmp41_;
			_tmp34_ = ma;
			_tmp35_ = vala_member_access_get_inner (_tmp34_);
			_tmp36_ = _tmp35_;
			_tmp37_ = vala_expression_get_value_type (_tmp36_);
			_tmp38_ = _tmp37_;
			_tmp39_ = vala_enum_value_type_get_to_string_method (G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, VALA_TYPE_ENUM_VALUE_TYPE, ValaEnumValueType));
			_tmp40_ = _tmp39_;
			_tmp41_ = m;
			_tmp24_ = _tmp40_ == _tmp41_;
			_vala_code_node_unref0 (_tmp40_);
		} else {
			_tmp24_ = FALSE;
		}
		if (_tmp24_) {
			ValaEnum* en = NULL;
			ValaMemberAccess* _tmp42_;
			ValaExpression* _tmp43_;
			ValaExpression* _tmp44_;
			ValaDataType* _tmp45_;
			ValaDataType* _tmp46_;
			ValaTypeSymbol* _tmp47_;
			ValaTypeSymbol* _tmp48_;
			ValaEnum* _tmp49_;
			ValaCCodeFunctionCall* _tmp50_;
			ValaEnum* _tmp51_;
			gchar* _tmp52_;
			gchar* _tmp53_;
			ValaCCodeIdentifier* _tmp54_;
			ValaCCodeIdentifier* _tmp55_;
			_tmp42_ = ma;
			_tmp43_ = vala_member_access_get_inner (_tmp42_);
			_tmp44_ = _tmp43_;
			_tmp45_ = vala_expression_get_value_type (_tmp44_);
			_tmp46_ = _tmp45_;
			_tmp47_ = vala_data_type_get_data_type (_tmp46_);
			_tmp48_ = _tmp47_;
			_tmp49_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, VALA_TYPE_ENUM, ValaEnum));
			en = _tmp49_;
			_tmp50_ = ccall;
			_tmp51_ = en;
			_tmp52_ = vala_ccode_method_call_module_generate_enum_tostring_function (self, _tmp51_);
			_tmp53_ = _tmp52_;
			_tmp54_ = vala_ccode_identifier_new (_tmp53_);
			_tmp55_ = _tmp54_;
			vala_ccode_function_call_set_call (_tmp50_, (ValaCCodeExpression*) _tmp55_);
			_vala_ccode_node_unref0 (_tmp55_);
			_g_free0 (_tmp53_);
			_vala_code_node_unref0 (en);
		} else {
			gboolean _tmp56_;
			gboolean _tmp57_;
			_tmp56_ = vala_method_call_get_is_constructv_chainup (expr);
			_tmp57_ = _tmp56_;
			if (_tmp57_) {
				ValaCCodeFunctionCall* _tmp58_;
				ValaMethod* _tmp59_;
				gchar* _tmp60_;
				gchar* _tmp61_;
				ValaCCodeIdentifier* _tmp62_;
				ValaCCodeIdentifier* _tmp63_;
				_tmp58_ = ccall;
				_tmp59_ = m;
				_tmp60_ = vala_get_ccode_constructv_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp59_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
				_tmp61_ = _tmp60_;
				_tmp62_ = vala_ccode_identifier_new (_tmp61_);
				_tmp63_ = _tmp62_;
				vala_ccode_function_call_set_call (_tmp58_, (ValaCCodeExpression*) _tmp63_);
				_vala_ccode_node_unref0 (_tmp63_);
				_g_free0 (_tmp61_);
			}
		}
	} else {
		ValaDataType* _tmp64_;
		_tmp64_ = itype;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp64_, VALA_TYPE_SIGNAL_TYPE)) {
			ValaSignalType* sig_type = NULL;
			ValaDataType* _tmp65_;
			ValaSignalType* _tmp66_;
			gboolean _tmp67_ = FALSE;
			gboolean _tmp68_ = FALSE;
			ValaMemberAccess* _tmp69_;
			_tmp65_ = itype;
			_tmp66_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp65_, VALA_TYPE_SIGNAL_TYPE, ValaSignalType));
			sig_type = _tmp66_;
			_tmp69_ = ma;
			if (_tmp69_ != NULL) {
				ValaMemberAccess* _tmp70_;
				ValaExpression* _tmp71_;
				ValaExpression* _tmp72_;
				_tmp70_ = ma;
				_tmp71_ = vala_member_access_get_inner (_tmp70_);
				_tmp72_ = _tmp71_;
				_tmp68_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp72_, VALA_TYPE_BASE_ACCESS);
			} else {
				_tmp68_ = FALSE;
			}
			if (_tmp68_) {
				ValaSignalType* _tmp73_;
				ValaSignal* _tmp74_;
				ValaSignal* _tmp75_;
				gboolean _tmp76_;
				gboolean _tmp77_;
				_tmp73_ = sig_type;
				_tmp74_ = vala_signal_type_get_signal_symbol (_tmp73_);
				_tmp75_ = _tmp74_;
				_tmp76_ = vala_signal_get_is_virtual (_tmp75_);
				_tmp77_ = _tmp76_;
				_tmp67_ = _tmp77_;
			} else {
				_tmp67_ = FALSE;
			}
			if (_tmp67_) {
				ValaSignalType* _tmp78_;
				ValaSignal* _tmp79_;
				ValaSignal* _tmp80_;
				ValaMethod* _tmp81_;
				ValaMethod* _tmp82_;
				ValaMethod* _tmp83_;
				_tmp78_ = sig_type;
				_tmp79_ = vala_signal_type_get_signal_symbol (_tmp78_);
				_tmp80_ = _tmp79_;
				_tmp81_ = vala_signal_get_default_handler (_tmp80_);
				_tmp82_ = _tmp81_;
				_tmp83_ = _vala_code_node_ref0 (_tmp82_);
				_vala_code_node_unref0 (m);
				m = _tmp83_;
			} else {
				ValaExpression* _tmp84_;
				ValaExpression* _tmp85_;
				ValaCCodeExpression* _tmp86_;
				_tmp84_ = vala_method_call_get_call (expr);
				_tmp85_ = _tmp84_;
				_tmp86_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp85_);
				_vala_ccode_node_unref0 (ccall);
				ccall = G_TYPE_CHECK_INSTANCE_CAST (_tmp86_, VALA_TYPE_CCODE_FUNCTION_CALL, ValaCCodeFunctionCall);
			}
			_vala_code_node_unref0 (sig_type);
		} else {
			ValaDataType* _tmp87_;
			_tmp87_ = itype;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp87_, VALA_TYPE_OBJECT_TYPE)) {
				ValaClass* cl = NULL;
				ValaDataType* _tmp88_;
				ValaObjectTypeSymbol* _tmp89_;
				ValaObjectTypeSymbol* _tmp90_;
				ValaClass* _tmp91_;
				ValaClass* _tmp92_;
				ValaCreationMethod* _tmp93_;
				ValaCreationMethod* _tmp94_;
				ValaMethod* _tmp95_;
				ValaMethod* _tmp96_;
				ValaCCodeFile* _tmp97_;
				gchar* real_name = NULL;
				ValaMethod* _tmp98_;
				gchar* _tmp99_;
				gboolean _tmp100_;
				gboolean _tmp101_;
				const gchar* _tmp104_;
				ValaCCodeIdentifier* _tmp105_;
				ValaCCodeIdentifier* _tmp106_;
				ValaCCodeFunctionCall* _tmp107_;
				_tmp88_ = itype;
				_tmp89_ = vala_object_type_get_type_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp88_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
				_tmp90_ = _tmp89_;
				_tmp91_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp90_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp91_;
				_tmp92_ = cl;
				_tmp93_ = vala_class_get_default_construction_method (_tmp92_);
				_tmp94_ = _tmp93_;
				_tmp95_ = _vala_code_node_ref0 ((ValaMethod*) _tmp94_);
				_vala_code_node_unref0 (m);
				m = _tmp95_;
				_tmp96_ = m;
				_tmp97_ = ((ValaCCodeBaseModule*) self)->cfile;
				vala_ccode_base_module_generate_method_declaration ((ValaCCodeBaseModule*) self, _tmp96_, _tmp97_);
				_tmp98_ = m;
				_tmp99_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp98_);
				real_name = _tmp99_;
				_tmp100_ = vala_method_call_get_is_constructv_chainup (expr);
				_tmp101_ = _tmp100_;
				if (_tmp101_) {
					ValaMethod* _tmp102_;
					gchar* _tmp103_;
					_tmp102_ = m;
					_tmp103_ = vala_get_ccode_constructv_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp102_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
					_g_free0 (real_name);
					real_name = _tmp103_;
				}
				_tmp104_ = real_name;
				_tmp105_ = vala_ccode_identifier_new (_tmp104_);
				_tmp106_ = _tmp105_;
				_tmp107_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp106_);
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp107_;
				_vala_ccode_node_unref0 (_tmp106_);
				_g_free0 (real_name);
				_vala_code_node_unref0 (cl);
			} else {
				ValaDataType* _tmp108_;
				_tmp108_ = itype;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp108_, VALA_TYPE_STRUCT_VALUE_TYPE)) {
					ValaStruct* st = NULL;
					ValaDataType* _tmp109_;
					ValaTypeSymbol* _tmp110_;
					ValaTypeSymbol* _tmp111_;
					ValaStruct* _tmp112_;
					ValaStruct* _tmp113_;
					ValaMethod* _tmp114_;
					ValaMethod* _tmp115_;
					ValaMethod* _tmp116_;
					ValaMethod* _tmp117_;
					ValaCCodeFile* _tmp118_;
					ValaMethod* _tmp119_;
					gchar* _tmp120_;
					gchar* _tmp121_;
					ValaCCodeIdentifier* _tmp122_;
					ValaCCodeIdentifier* _tmp123_;
					ValaCCodeFunctionCall* _tmp124_;
					_tmp109_ = itype;
					_tmp110_ = vala_value_type_get_type_symbol ((ValaValueType*) G_TYPE_CHECK_INSTANCE_CAST (_tmp109_, VALA_TYPE_STRUCT_VALUE_TYPE, ValaStructValueType));
					_tmp111_ = _tmp110_;
					_tmp112_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp111_, VALA_TYPE_STRUCT, ValaStruct));
					st = _tmp112_;
					_tmp113_ = st;
					_tmp114_ = vala_struct_get_default_construction_method (_tmp113_);
					_tmp115_ = _tmp114_;
					_tmp116_ = _vala_code_node_ref0 (_tmp115_);
					_vala_code_node_unref0 (m);
					m = _tmp116_;
					_tmp117_ = m;
					_tmp118_ = ((ValaCCodeBaseModule*) self)->cfile;
					vala_ccode_base_module_generate_method_declaration ((ValaCCodeBaseModule*) self, _tmp117_, _tmp118_);
					_tmp119_ = m;
					_tmp120_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp119_);
					_tmp121_ = _tmp120_;
					_tmp122_ = vala_ccode_identifier_new (_tmp121_);
					_tmp123_ = _tmp122_;
					_tmp124_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp123_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp124_;
					_vala_ccode_node_unref0 (_tmp123_);
					_g_free0 (_tmp121_);
					_vala_code_node_unref0 (st);
				} else {
					ValaDataType* _tmp125_;
					_tmp125_ = itype;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp125_, VALA_TYPE_DELEGATE_TYPE)) {
						ValaDataType* _tmp126_;
						ValaDelegate* _tmp127_;
						ValaDelegate* _tmp128_;
						ValaDelegate* _tmp129_;
						_tmp126_ = itype;
						_tmp127_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp126_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
						_tmp128_ = _tmp127_;
						_tmp129_ = _vala_code_node_ref0 (_tmp128_);
						_vala_code_node_unref0 (deleg);
						deleg = _tmp129_;
					}
				}
			}
		}
	}
	_tmp130_ = g_direct_hash;
	_tmp131_ = g_direct_equal;
	_tmp132_ = g_direct_equal;
	_tmp133_ = vala_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, (GDestroyNotify) vala_ccode_node_unref, _tmp130_, _tmp131_, _tmp132_);
	in_arg_map = _tmp133_;
	_tmp134_ = in_arg_map;
	_tmp135_ = _vala_map_ref0 (_tmp134_);
	out_arg_map = _tmp135_;
	_tmp137_ = m;
	if (_tmp137_ != NULL) {
		ValaMethod* _tmp138_;
		gboolean _tmp139_;
		gboolean _tmp140_;
		_tmp138_ = m;
		_tmp139_ = vala_method_get_coroutine (_tmp138_);
		_tmp140_ = _tmp139_;
		_tmp136_ = _tmp140_;
	} else {
		_tmp136_ = FALSE;
	}
	if (_tmp136_) {
		ValaMethod* _tmp141_;
		gchar* _tmp142_;
		gchar* _tmp143_;
		ValaCCodeIdentifier* _tmp144_;
		ValaCCodeIdentifier* _tmp145_;
		ValaCCodeFunctionCall* _tmp146_;
		ValaMethod* _tmp147_;
		gchar* _tmp148_;
		gchar* _tmp149_;
		ValaCCodeIdentifier* _tmp150_;
		ValaCCodeIdentifier* _tmp151_;
		ValaCCodeFunctionCall* _tmp152_;
		ValaMemberAccess* _tmp153_;
		ValaExpression* _tmp154_;
		ValaExpression* _tmp155_;
		gboolean _tmp233_ = FALSE;
		ValaMemberAccess* _tmp234_;
		const gchar* _tmp235_;
		const gchar* _tmp236_;
		_tmp141_ = m;
		_tmp142_ = vala_get_ccode_name ((ValaCodeNode*) _tmp141_);
		_tmp143_ = _tmp142_;
		_tmp144_ = vala_ccode_identifier_new (_tmp143_);
		_tmp145_ = _tmp144_;
		_tmp146_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp145_);
		_vala_ccode_node_unref0 (async_call);
		async_call = _tmp146_;
		_vala_ccode_node_unref0 (_tmp145_);
		_g_free0 (_tmp143_);
		_tmp147_ = m;
		_tmp148_ = vala_get_ccode_finish_name (_tmp147_);
		_tmp149_ = _tmp148_;
		_tmp150_ = vala_ccode_identifier_new (_tmp149_);
		_tmp151_ = _tmp150_;
		_tmp152_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp151_);
		_vala_ccode_node_unref0 (finish_call);
		finish_call = _tmp152_;
		_vala_ccode_node_unref0 (_tmp151_);
		_g_free0 (_tmp149_);
		_tmp153_ = ma;
		_tmp154_ = vala_member_access_get_inner (_tmp153_);
		_tmp155_ = _tmp154_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp155_, VALA_TYPE_BASE_ACCESS)) {
			ValaMethod* _tmp156_;
			ValaMethod* _tmp157_;
			ValaMethod* _tmp158_;
			_tmp156_ = m;
			_tmp157_ = vala_method_get_base_method (_tmp156_);
			_tmp158_ = _tmp157_;
			if (_tmp158_ != NULL) {
				ValaClass* base_class = NULL;
				ValaMethod* _tmp159_;
				ValaMethod* _tmp160_;
				ValaMethod* _tmp161_;
				ValaSymbol* _tmp162_;
				ValaSymbol* _tmp163_;
				ValaClass* _tmp164_;
				ValaCCodeFunctionCall* vcast = NULL;
				ValaClass* _tmp165_;
				gchar* _tmp166_;
				gchar* _tmp167_;
				gchar* _tmp168_;
				gchar* _tmp169_;
				ValaCCodeIdentifier* _tmp170_;
				ValaCCodeIdentifier* _tmp171_;
				ValaCCodeFunctionCall* _tmp172_;
				ValaCCodeFunctionCall* _tmp173_;
				ValaCCodeFunctionCall* _tmp174_;
				ValaClass* _tmp175_;
				ValaClass* _tmp176_;
				gchar* _tmp177_;
				gchar* _tmp178_;
				gchar* _tmp179_;
				gchar* _tmp180_;
				ValaCCodeIdentifier* _tmp181_;
				ValaCCodeIdentifier* _tmp182_;
				ValaCCodeFunctionCall* _tmp183_;
				ValaCCodeFunctionCall* _tmp184_;
				ValaMethod* _tmp185_;
				gchar* _tmp186_;
				gchar* _tmp187_;
				ValaCCodeMemberAccess* _tmp188_;
				ValaCCodeMemberAccess* _tmp189_;
				ValaCCodeFunctionCall* _tmp190_;
				ValaCCodeFunctionCall* _tmp191_;
				ValaMethod* _tmp192_;
				gchar* _tmp193_;
				gchar* _tmp194_;
				ValaCCodeMemberAccess* _tmp195_;
				ValaCCodeMemberAccess* _tmp196_;
				_tmp159_ = m;
				_tmp160_ = vala_method_get_base_method (_tmp159_);
				_tmp161_ = _tmp160_;
				_tmp162_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp161_);
				_tmp163_ = _tmp162_;
				_tmp164_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp163_, VALA_TYPE_CLASS, ValaClass));
				base_class = _tmp164_;
				_tmp165_ = base_class;
				_tmp166_ = vala_get_ccode_upper_case_name ((ValaSymbol*) _tmp165_, NULL);
				_tmp167_ = _tmp166_;
				_tmp168_ = g_strdup_printf ("%s_CLASS", _tmp167_);
				_tmp169_ = _tmp168_;
				_tmp170_ = vala_ccode_identifier_new (_tmp169_);
				_tmp171_ = _tmp170_;
				_tmp172_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp171_);
				_tmp173_ = _tmp172_;
				_vala_ccode_node_unref0 (_tmp171_);
				_g_free0 (_tmp169_);
				_g_free0 (_tmp167_);
				vcast = _tmp173_;
				_tmp174_ = vcast;
				_tmp175_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp176_ = _tmp175_;
				_tmp177_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp176_, NULL);
				_tmp178_ = _tmp177_;
				_tmp179_ = g_strdup_printf ("%s_parent_class", _tmp178_);
				_tmp180_ = _tmp179_;
				_tmp181_ = vala_ccode_identifier_new (_tmp180_);
				_tmp182_ = _tmp181_;
				vala_ccode_function_call_add_argument (_tmp174_, (ValaCCodeExpression*) _tmp182_);
				_vala_ccode_node_unref0 (_tmp182_);
				_g_free0 (_tmp180_);
				_g_free0 (_tmp178_);
				_tmp183_ = async_call;
				_tmp184_ = vcast;
				_tmp185_ = m;
				_tmp186_ = vala_get_ccode_vfunc_name (_tmp185_);
				_tmp187_ = _tmp186_;
				_tmp188_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp184_, _tmp187_);
				_tmp189_ = _tmp188_;
				vala_ccode_function_call_set_call (_tmp183_, (ValaCCodeExpression*) _tmp189_);
				_vala_ccode_node_unref0 (_tmp189_);
				_g_free0 (_tmp187_);
				_tmp190_ = finish_call;
				_tmp191_ = vcast;
				_tmp192_ = m;
				_tmp193_ = vala_get_ccode_finish_vfunc_name (_tmp192_);
				_tmp194_ = _tmp193_;
				_tmp195_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp191_, _tmp194_);
				_tmp196_ = _tmp195_;
				vala_ccode_function_call_set_call (_tmp190_, (ValaCCodeExpression*) _tmp196_);
				_vala_ccode_node_unref0 (_tmp196_);
				_g_free0 (_tmp194_);
				_vala_ccode_node_unref0 (vcast);
				_vala_code_node_unref0 (base_class);
			} else {
				ValaMethod* _tmp197_;
				ValaMethod* _tmp198_;
				ValaMethod* _tmp199_;
				_tmp197_ = m;
				_tmp198_ = vala_method_get_base_interface_method (_tmp197_);
				_tmp199_ = _tmp198_;
				if (_tmp199_ != NULL) {
					ValaInterface* base_iface = NULL;
					ValaMethod* _tmp200_;
					ValaMethod* _tmp201_;
					ValaMethod* _tmp202_;
					ValaSymbol* _tmp203_;
					ValaSymbol* _tmp204_;
					ValaInterface* _tmp205_;
					gchar* parent_iface_var = NULL;
					ValaClass* _tmp206_;
					ValaClass* _tmp207_;
					gchar* _tmp208_;
					gchar* _tmp209_;
					ValaInterface* _tmp210_;
					gchar* _tmp211_;
					gchar* _tmp212_;
					gchar* _tmp213_;
					gchar* _tmp214_;
					ValaCCodeFunctionCall* _tmp215_;
					const gchar* _tmp216_;
					ValaCCodeIdentifier* _tmp217_;
					ValaCCodeIdentifier* _tmp218_;
					ValaMethod* _tmp219_;
					gchar* _tmp220_;
					gchar* _tmp221_;
					ValaCCodeMemberAccess* _tmp222_;
					ValaCCodeMemberAccess* _tmp223_;
					ValaCCodeFunctionCall* _tmp224_;
					const gchar* _tmp225_;
					ValaCCodeIdentifier* _tmp226_;
					ValaCCodeIdentifier* _tmp227_;
					ValaMethod* _tmp228_;
					gchar* _tmp229_;
					gchar* _tmp230_;
					ValaCCodeMemberAccess* _tmp231_;
					ValaCCodeMemberAccess* _tmp232_;
					_tmp200_ = m;
					_tmp201_ = vala_method_get_base_interface_method (_tmp200_);
					_tmp202_ = _tmp201_;
					_tmp203_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp202_);
					_tmp204_ = _tmp203_;
					_tmp205_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp204_, VALA_TYPE_INTERFACE, ValaInterface));
					base_iface = _tmp205_;
					_tmp206_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp207_ = _tmp206_;
					_tmp208_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp207_, NULL);
					_tmp209_ = _tmp208_;
					_tmp210_ = base_iface;
					_tmp211_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp210_, NULL);
					_tmp212_ = _tmp211_;
					_tmp213_ = g_strdup_printf ("%s_%s_parent_iface", _tmp209_, _tmp212_);
					_tmp214_ = _tmp213_;
					_g_free0 (_tmp212_);
					_g_free0 (_tmp209_);
					parent_iface_var = _tmp214_;
					_tmp215_ = async_call;
					_tmp216_ = parent_iface_var;
					_tmp217_ = vala_ccode_identifier_new (_tmp216_);
					_tmp218_ = _tmp217_;
					_tmp219_ = m;
					_tmp220_ = vala_get_ccode_vfunc_name (_tmp219_);
					_tmp221_ = _tmp220_;
					_tmp222_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp218_, _tmp221_);
					_tmp223_ = _tmp222_;
					vala_ccode_function_call_set_call (_tmp215_, (ValaCCodeExpression*) _tmp223_);
					_vala_ccode_node_unref0 (_tmp223_);
					_g_free0 (_tmp221_);
					_vala_ccode_node_unref0 (_tmp218_);
					_tmp224_ = finish_call;
					_tmp225_ = parent_iface_var;
					_tmp226_ = vala_ccode_identifier_new (_tmp225_);
					_tmp227_ = _tmp226_;
					_tmp228_ = m;
					_tmp229_ = vala_get_ccode_finish_vfunc_name (_tmp228_);
					_tmp230_ = _tmp229_;
					_tmp231_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp227_, _tmp230_);
					_tmp232_ = _tmp231_;
					vala_ccode_function_call_set_call (_tmp224_, (ValaCCodeExpression*) _tmp232_);
					_vala_ccode_node_unref0 (_tmp232_);
					_g_free0 (_tmp230_);
					_vala_ccode_node_unref0 (_tmp227_);
					_g_free0 (parent_iface_var);
					_vala_code_node_unref0 (base_iface);
				}
			}
		}
		_tmp234_ = ma;
		_tmp235_ = vala_member_access_get_member_name (_tmp234_);
		_tmp236_ = _tmp235_;
		if (g_strcmp0 (_tmp236_, "begin") == 0) {
			ValaMemberAccess* _tmp237_;
			ValaExpression* _tmp238_;
			ValaExpression* _tmp239_;
			ValaSymbol* _tmp240_;
			ValaSymbol* _tmp241_;
			ValaMemberAccess* _tmp242_;
			ValaSymbol* _tmp243_;
			ValaSymbol* _tmp244_;
			_tmp237_ = ma;
			_tmp238_ = vala_member_access_get_inner (_tmp237_);
			_tmp239_ = _tmp238_;
			_tmp240_ = vala_expression_get_symbol_reference (_tmp239_);
			_tmp241_ = _tmp240_;
			_tmp242_ = ma;
			_tmp243_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp242_);
			_tmp244_ = _tmp243_;
			_tmp233_ = _tmp241_ == _tmp244_;
		} else {
			_tmp233_ = FALSE;
		}
		if (_tmp233_) {
			ValaCCodeFunctionCall* _tmp245_;
			ValaCCodeFunctionCall* _tmp246_;
			ValaMethod* _tmp247_;
			ValaList* _tmp248_;
			_tmp245_ = async_call;
			_tmp246_ = _vala_ccode_node_ref0 (_tmp245_);
			_vala_ccode_node_unref0 (ccall);
			ccall = _tmp246_;
			_tmp247_ = m;
			_tmp248_ = vala_method_get_async_begin_parameters (_tmp247_);
			_vala_iterable_unref0 (params);
			params = _tmp248_;
		} else {
			gboolean _tmp249_ = FALSE;
			ValaMemberAccess* _tmp250_;
			const gchar* _tmp251_;
			const gchar* _tmp252_;
			_tmp250_ = ma;
			_tmp251_ = vala_member_access_get_member_name (_tmp250_);
			_tmp252_ = _tmp251_;
			if (g_strcmp0 (_tmp252_, "end") == 0) {
				ValaMemberAccess* _tmp253_;
				ValaExpression* _tmp254_;
				ValaExpression* _tmp255_;
				ValaSymbol* _tmp256_;
				ValaSymbol* _tmp257_;
				ValaMemberAccess* _tmp258_;
				ValaSymbol* _tmp259_;
				ValaSymbol* _tmp260_;
				_tmp253_ = ma;
				_tmp254_ = vala_member_access_get_inner (_tmp253_);
				_tmp255_ = _tmp254_;
				_tmp256_ = vala_expression_get_symbol_reference (_tmp255_);
				_tmp257_ = _tmp256_;
				_tmp258_ = ma;
				_tmp259_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp258_);
				_tmp260_ = _tmp259_;
				_tmp249_ = _tmp257_ == _tmp260_;
			} else {
				_tmp249_ = FALSE;
			}
			if (_tmp249_) {
				ValaCCodeFunctionCall* _tmp261_;
				ValaCCodeFunctionCall* _tmp262_;
				ValaMethod* _tmp263_;
				ValaList* _tmp264_;
				_tmp261_ = finish_call;
				_tmp262_ = _vala_ccode_node_ref0 (_tmp261_);
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp262_;
				_tmp263_ = m;
				_tmp264_ = vala_method_get_async_end_parameters (_tmp263_);
				_vala_iterable_unref0 (params);
				params = _tmp264_;
			} else {
				gboolean _tmp265_;
				gboolean _tmp266_;
				_tmp265_ = vala_method_call_get_is_yield_expression (expr);
				_tmp266_ = _tmp265_;
				if (!_tmp266_) {
					ValaCCodeFunctionCall* _tmp267_;
					ValaCCodeFunctionCall* _tmp268_;
					ValaMethod* _tmp269_;
					ValaList* _tmp270_;
					_tmp267_ = async_call;
					_tmp268_ = _vala_ccode_node_ref0 (_tmp267_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp268_;
					_tmp269_ = m;
					_tmp270_ = vala_method_get_async_begin_parameters (_tmp269_);
					_vala_iterable_unref0 (params);
					params = _tmp270_;
				} else {
					ValaCCodeFunctionCall* _tmp271_;
					ValaCCodeFunctionCall* _tmp272_;
					GHashFunc _tmp273_;
					GEqualFunc _tmp274_;
					GEqualFunc _tmp275_;
					ValaHashMap* _tmp276_;
					ValaHashMap* _tmp277_;
					ValaCCodeIdentifier* _tmp278_;
					ValaCCodeIdentifier* _tmp279_;
					ValaCCodeMemberAccess* _tmp280_;
					ValaCCodeMemberAccess* _tmp281_;
					_tmp271_ = finish_call;
					_tmp272_ = _vala_ccode_node_ref0 (_tmp271_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp272_;
					_tmp273_ = g_direct_hash;
					_tmp274_ = g_direct_equal;
					_tmp275_ = g_direct_equal;
					_tmp276_ = vala_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, (GDestroyNotify) vala_ccode_node_unref, _tmp273_, _tmp274_, _tmp275_);
					_vala_map_unref0 (out_arg_map);
					out_arg_map = _tmp276_;
					_tmp277_ = out_arg_map;
					_tmp278_ = vala_ccode_identifier_new ("_data_");
					_tmp279_ = _tmp278_;
					_tmp280_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp279_, "_res_");
					_tmp281_ = _tmp280_;
					vala_map_set ((ValaMap*) _tmp277_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, 0.1, FALSE)), (ValaCCodeExpression*) _tmp281_);
					_vala_ccode_node_unref0 (_tmp281_);
					_vala_ccode_node_unref0 (_tmp279_);
				}
			}
		}
	}
	_tmp283_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp283_, VALA_TYPE_CREATION_METHOD)) {
		ValaMethod* _tmp284_;
		ValaSymbol* _tmp285_;
		ValaSymbol* _tmp286_;
		_tmp284_ = m;
		_tmp285_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp284_);
		_tmp286_ = _tmp285_;
		_tmp282_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp286_, VALA_TYPE_CLASS);
	} else {
		_tmp282_ = FALSE;
	}
	if (_tmp282_) {
		ValaMethod* _tmp287_;
		ValaSymbol* _tmp288_;
		ValaSymbol* _tmp289_;
		gboolean _tmp290_;
		gboolean _tmp291_;
		ValaClass* _tmp295_;
		ValaClass* _tmp296_;
		gboolean _tmp297_;
		gboolean _tmp298_;
		_tmp287_ = m;
		_tmp288_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp287_);
		_tmp289_ = _tmp288_;
		_tmp290_ = vala_class_get_is_compact (G_TYPE_CHECK_INSTANCE_CAST (_tmp289_, VALA_TYPE_CLASS, ValaClass));
		_tmp291_ = _tmp290_;
		if (!_tmp291_) {
			ValaCCodeFunctionCall* _tmp292_;
			ValaCCodeExpression* _tmp293_;
			ValaCCodeExpression* _tmp294_;
			_tmp292_ = ccall;
			_tmp293_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, "object_type");
			_tmp294_ = _tmp293_;
			vala_ccode_function_call_add_argument (_tmp292_, _tmp294_);
			_vala_ccode_node_unref0 (_tmp294_);
		}
		_tmp295_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp296_ = _tmp295_;
		_tmp297_ = vala_class_get_is_compact (_tmp296_);
		_tmp298_ = _tmp297_;
		if (!_tmp298_) {
			ValaClass* _tmp299_;
			ValaClass* _tmp300_;
			ValaMethod* _tmp301_;
			ValaSymbol* _tmp302_;
			ValaSymbol* _tmp303_;
			_tmp299_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp300_ = _tmp299_;
			_tmp301_ = m;
			_tmp302_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp301_);
			_tmp303_ = _tmp302_;
			if (G_TYPE_CHECK_INSTANCE_CAST (_tmp300_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp303_) {
				{
					ValaList* _base_type_list = NULL;
					ValaClass* _tmp304_;
					ValaClass* _tmp305_;
					ValaList* _tmp306_;
					gint _base_type_size = 0;
					ValaList* _tmp307_;
					gint _tmp308_;
					gint _tmp309_;
					gint _base_type_index = 0;
					_tmp304_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp305_ = _tmp304_;
					_tmp306_ = vala_class_get_base_types (_tmp305_);
					_base_type_list = _tmp306_;
					_tmp307_ = _base_type_list;
					_tmp308_ = vala_collection_get_size ((ValaCollection*) _tmp307_);
					_tmp309_ = _tmp308_;
					_base_type_size = _tmp309_;
					_base_type_index = -1;
					while (TRUE) {
						gint _tmp310_;
						gint _tmp311_;
						gint _tmp312_;
						ValaDataType* base_type = NULL;
						ValaList* _tmp313_;
						gint _tmp314_;
						gpointer _tmp315_;
						ValaDataType* _tmp316_;
						ValaTypeSymbol* _tmp317_;
						ValaTypeSymbol* _tmp318_;
						_tmp310_ = _base_type_index;
						_base_type_index = _tmp310_ + 1;
						_tmp311_ = _base_type_index;
						_tmp312_ = _base_type_size;
						if (!(_tmp311_ < _tmp312_)) {
							break;
						}
						_tmp313_ = _base_type_list;
						_tmp314_ = _base_type_index;
						_tmp315_ = vala_list_get (_tmp313_, _tmp314_);
						base_type = (ValaDataType*) _tmp315_;
						_tmp316_ = base_type;
						_tmp317_ = vala_data_type_get_data_type (_tmp316_);
						_tmp318_ = _tmp317_;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp318_, VALA_TYPE_CLASS)) {
							ValaList* type_parameters = NULL;
							ValaMethod* _tmp319_;
							gchar* _tmp320_;
							gchar* _tmp321_;
							gboolean _tmp322_;
							ValaHashMap* _tmp327_;
							ValaDataType* _tmp328_;
							ValaList* _tmp329_;
							ValaList* _tmp330_;
							ValaList* _tmp331_;
							type_parameters = NULL;
							_tmp319_ = m;
							_tmp320_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp319_);
							_tmp321_ = _tmp320_;
							_tmp322_ = g_strcmp0 (_tmp321_, "g_object_new") == 0;
							_g_free0 (_tmp321_);
							if (_tmp322_) {
								ValaDataType* _tmp323_;
								ValaTypeSymbol* _tmp324_;
								ValaTypeSymbol* _tmp325_;
								ValaList* _tmp326_;
								_tmp323_ = base_type;
								_tmp324_ = vala_data_type_get_data_type (_tmp323_);
								_tmp325_ = _tmp324_;
								_tmp326_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp325_, VALA_TYPE_CLASS, ValaClass));
								_vala_iterable_unref0 (type_parameters);
								type_parameters = _tmp326_;
							}
							_tmp327_ = in_arg_map;
							_tmp328_ = base_type;
							_tmp329_ = vala_data_type_get_type_arguments (_tmp328_);
							_tmp330_ = _tmp329_;
							_tmp331_ = type_parameters;
							vala_ccode_base_module_add_generic_type_arguments ((ValaCCodeBaseModule*) self, (ValaMap*) _tmp327_, _tmp330_, (ValaCodeNode*) expr, TRUE, _tmp331_);
							_vala_iterable_unref0 (_tmp330_);
							_vala_iterable_unref0 (type_parameters);
							_vala_code_node_unref0 (base_type);
							break;
						}
						_vala_code_node_unref0 (base_type);
					}
					_vala_iterable_unref0 (_base_type_list);
				}
			} else {
				gint type_param_index = 0;
				ValaClass* cl = NULL;
				ValaMethod* _tmp332_;
				ValaSymbol* _tmp333_;
				ValaSymbol* _tmp334_;
				ValaClass* _tmp335_;
				type_param_index = 0;
				_tmp332_ = m;
				_tmp333_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp332_);
				_tmp334_ = _tmp333_;
				_tmp335_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp334_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp335_;
				{
					ValaList* _type_param_list = NULL;
					ValaClass* _tmp336_;
					ValaList* _tmp337_;
					gint _type_param_size = 0;
					ValaList* _tmp338_;
					gint _tmp339_;
					gint _tmp340_;
					gint _type_param_index = 0;
					_tmp336_ = cl;
					_tmp337_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) _tmp336_);
					_type_param_list = _tmp337_;
					_tmp338_ = _type_param_list;
					_tmp339_ = vala_collection_get_size ((ValaCollection*) _tmp338_);
					_tmp340_ = _tmp339_;
					_type_param_size = _tmp340_;
					_type_param_index = -1;
					while (TRUE) {
						gint _tmp341_;
						gint _tmp342_;
						gint _tmp343_;
						ValaTypeParameter* type_param = NULL;
						ValaList* _tmp344_;
						gint _tmp345_;
						gpointer _tmp346_;
						ValaHashMap* _tmp347_;
						gint _tmp348_;
						ValaTypeParameter* _tmp349_;
						const gchar* _tmp350_;
						const gchar* _tmp351_;
						gchar* _tmp352_;
						gchar* _tmp353_;
						gchar* _tmp354_;
						gchar* _tmp355_;
						ValaCCodeIdentifier* _tmp356_;
						ValaCCodeIdentifier* _tmp357_;
						ValaHashMap* _tmp358_;
						gint _tmp359_;
						ValaTypeParameter* _tmp360_;
						const gchar* _tmp361_;
						const gchar* _tmp362_;
						gchar* _tmp363_;
						gchar* _tmp364_;
						gchar* _tmp365_;
						gchar* _tmp366_;
						ValaCCodeIdentifier* _tmp367_;
						ValaCCodeIdentifier* _tmp368_;
						ValaHashMap* _tmp369_;
						gint _tmp370_;
						ValaTypeParameter* _tmp371_;
						const gchar* _tmp372_;
						const gchar* _tmp373_;
						gchar* _tmp374_;
						gchar* _tmp375_;
						gchar* _tmp376_;
						gchar* _tmp377_;
						ValaCCodeIdentifier* _tmp378_;
						ValaCCodeIdentifier* _tmp379_;
						gint _tmp380_;
						_tmp341_ = _type_param_index;
						_type_param_index = _tmp341_ + 1;
						_tmp342_ = _type_param_index;
						_tmp343_ = _type_param_size;
						if (!(_tmp342_ < _tmp343_)) {
							break;
						}
						_tmp344_ = _type_param_list;
						_tmp345_ = _type_param_index;
						_tmp346_ = vala_list_get (_tmp344_, _tmp345_);
						type_param = (ValaTypeParameter*) _tmp346_;
						_tmp347_ = in_arg_map;
						_tmp348_ = type_param_index;
						_tmp349_ = type_param;
						_tmp350_ = vala_symbol_get_name ((ValaSymbol*) _tmp349_);
						_tmp351_ = _tmp350_;
						_tmp352_ = g_utf8_strdown (_tmp351_, (gssize) -1);
						_tmp353_ = _tmp352_;
						_tmp354_ = g_strdup_printf ("%s_type", _tmp353_);
						_tmp355_ = _tmp354_;
						_tmp356_ = vala_ccode_identifier_new (_tmp355_);
						_tmp357_ = _tmp356_;
						vala_map_set ((ValaMap*) _tmp347_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * _tmp348_) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp357_);
						_vala_ccode_node_unref0 (_tmp357_);
						_g_free0 (_tmp355_);
						_g_free0 (_tmp353_);
						_tmp358_ = in_arg_map;
						_tmp359_ = type_param_index;
						_tmp360_ = type_param;
						_tmp361_ = vala_symbol_get_name ((ValaSymbol*) _tmp360_);
						_tmp362_ = _tmp361_;
						_tmp363_ = g_utf8_strdown (_tmp362_, (gssize) -1);
						_tmp364_ = _tmp363_;
						_tmp365_ = g_strdup_printf ("%s_dup_func", _tmp364_);
						_tmp366_ = _tmp365_;
						_tmp367_ = vala_ccode_identifier_new (_tmp366_);
						_tmp368_ = _tmp367_;
						vala_map_set ((ValaMap*) _tmp358_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * _tmp359_) + 0.02, FALSE)), (ValaCCodeExpression*) _tmp368_);
						_vala_ccode_node_unref0 (_tmp368_);
						_g_free0 (_tmp366_);
						_g_free0 (_tmp364_);
						_tmp369_ = in_arg_map;
						_tmp370_ = type_param_index;
						_tmp371_ = type_param;
						_tmp372_ = vala_symbol_get_name ((ValaSymbol*) _tmp371_);
						_tmp373_ = _tmp372_;
						_tmp374_ = g_utf8_strdown (_tmp373_, (gssize) -1);
						_tmp375_ = _tmp374_;
						_tmp376_ = g_strdup_printf ("%s_destroy_func", _tmp375_);
						_tmp377_ = _tmp376_;
						_tmp378_ = vala_ccode_identifier_new (_tmp377_);
						_tmp379_ = _tmp378_;
						vala_map_set ((ValaMap*) _tmp369_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * _tmp370_) + 0.03, FALSE)), (ValaCCodeExpression*) _tmp379_);
						_vala_ccode_node_unref0 (_tmp379_);
						_g_free0 (_tmp377_);
						_g_free0 (_tmp375_);
						_tmp380_ = type_param_index;
						type_param_index = _tmp380_ + 1;
						_vala_code_node_unref0 (type_param);
					}
					_vala_iterable_unref0 (_type_param_list);
				}
				_vala_code_node_unref0 (cl);
			}
		} else {
			ValaClass* _tmp381_;
			ValaClass* _tmp382_;
			ValaClass* _tmp383_;
			ValaClass* _tmp384_;
			ValaClass* _tmp385_;
			_tmp381_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp382_ = _tmp381_;
			_tmp383_ = vala_class_get_base_class (_tmp382_);
			_tmp384_ = _tmp383_;
			_tmp385_ = ((ValaCCodeBaseModule*) self)->gsource_type;
			if (_tmp384_ == _tmp385_) {
				gchar* class_prefix = NULL;
				ValaClass* _tmp386_;
				ValaClass* _tmp387_;
				gchar* _tmp388_;
				ValaCCodeDeclaration* funcs = NULL;
				ValaCCodeDeclaration* _tmp389_;
				ValaCCodeDeclaration* _tmp390_;
				ValaCCodeDeclaration* _tmp391_;
				const gchar* _tmp392_;
				const gchar* _tmp393_;
				const gchar* _tmp394_;
				const gchar* _tmp395_;
				gchar* _tmp396_;
				gchar* _tmp397_;
				ValaCCodeConstant* _tmp398_;
				ValaCCodeConstant* _tmp399_;
				ValaCCodeVariableDeclarator* _tmp400_;
				ValaCCodeVariableDeclarator* _tmp401_;
				ValaCCodeFunction* _tmp402_;
				ValaCCodeFunction* _tmp403_;
				ValaCCodeDeclaration* _tmp404_;
				ValaCCodeFunctionCall* _tmp405_;
				ValaCCodeIdentifier* _tmp406_;
				ValaCCodeIdentifier* _tmp407_;
				ValaCCodeUnaryExpression* _tmp408_;
				ValaCCodeUnaryExpression* _tmp409_;
				ValaCCodeFunctionCall* csizeof = NULL;
				ValaCCodeIdentifier* _tmp410_;
				ValaCCodeIdentifier* _tmp411_;
				ValaCCodeFunctionCall* _tmp412_;
				ValaCCodeFunctionCall* _tmp413_;
				ValaCCodeFunctionCall* _tmp414_;
				ValaClass* _tmp415_;
				ValaClass* _tmp416_;
				gchar* _tmp417_;
				gchar* _tmp418_;
				ValaCCodeIdentifier* _tmp419_;
				ValaCCodeIdentifier* _tmp420_;
				ValaCCodeFunctionCall* _tmp421_;
				ValaCCodeFunctionCall* _tmp422_;
				_tmp386_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp387_ = _tmp386_;
				_tmp388_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp387_, NULL);
				class_prefix = _tmp388_;
				_tmp389_ = vala_ccode_declaration_new ("const GSourceFuncs");
				funcs = _tmp389_;
				_tmp390_ = funcs;
				vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp390_, VALA_CCODE_MODIFIERS_STATIC);
				_tmp391_ = funcs;
				_tmp392_ = class_prefix;
				_tmp393_ = class_prefix;
				_tmp394_ = class_prefix;
				_tmp395_ = class_prefix;
				_tmp396_ = g_strdup_printf ("{ %s_real_prepare, %s_real_check, %s_real_dispatch, %s_finalize}", _tmp392_, _tmp393_, _tmp394_, _tmp395_);
				_tmp397_ = _tmp396_;
				_tmp398_ = vala_ccode_constant_new (_tmp397_);
				_tmp399_ = _tmp398_;
				_tmp400_ = vala_ccode_variable_declarator_new ("_source_funcs", (ValaCCodeExpression*) _tmp399_, NULL);
				_tmp401_ = _tmp400_;
				vala_ccode_declaration_add_declarator (_tmp391_, (ValaCCodeDeclarator*) _tmp401_);
				_vala_ccode_node_unref0 (_tmp401_);
				_vala_ccode_node_unref0 (_tmp399_);
				_g_free0 (_tmp397_);
				_tmp402_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp403_ = _tmp402_;
				_tmp404_ = funcs;
				vala_ccode_function_add_statement (_tmp403_, (ValaCCodeNode*) _tmp404_);
				_tmp405_ = ccall;
				_tmp406_ = vala_ccode_identifier_new ("_source_funcs");
				_tmp407_ = _tmp406_;
				_tmp408_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp407_);
				_tmp409_ = _tmp408_;
				vala_ccode_function_call_add_argument (_tmp405_, (ValaCCodeExpression*) _tmp409_);
				_vala_ccode_node_unref0 (_tmp409_);
				_vala_ccode_node_unref0 (_tmp407_);
				_tmp410_ = vala_ccode_identifier_new ("sizeof");
				_tmp411_ = _tmp410_;
				_tmp412_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp411_);
				_tmp413_ = _tmp412_;
				_vala_ccode_node_unref0 (_tmp411_);
				csizeof = _tmp413_;
				_tmp414_ = csizeof;
				_tmp415_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp416_ = _tmp415_;
				_tmp417_ = vala_get_ccode_name ((ValaCodeNode*) _tmp416_);
				_tmp418_ = _tmp417_;
				_tmp419_ = vala_ccode_identifier_new (_tmp418_);
				_tmp420_ = _tmp419_;
				vala_ccode_function_call_add_argument (_tmp414_, (ValaCCodeExpression*) _tmp420_);
				_vala_ccode_node_unref0 (_tmp420_);
				_g_free0 (_tmp418_);
				_tmp421_ = ccall;
				_tmp422_ = csizeof;
				vala_ccode_function_call_add_argument (_tmp421_, (ValaCCodeExpression*) _tmp422_);
				_vala_ccode_node_unref0 (csizeof);
				_vala_ccode_node_unref0 (funcs);
				_g_free0 (class_prefix);
			}
		}
	} else {
		gboolean _tmp423_ = FALSE;
		ValaMethod* _tmp424_;
		_tmp424_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp424_, VALA_TYPE_CREATION_METHOD)) {
			ValaMethod* _tmp425_;
			ValaSymbol* _tmp426_;
			ValaSymbol* _tmp427_;
			_tmp425_ = m;
			_tmp426_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp425_);
			_tmp427_ = _tmp426_;
			_tmp423_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp427_, VALA_TYPE_STRUCT);
		} else {
			_tmp423_ = FALSE;
		}
		if (_tmp423_) {
			ValaCCodeFunctionCall* _tmp428_;
			ValaCCodeExpression* _tmp429_;
			ValaCCodeExpression* _tmp430_;
			_tmp428_ = ccall;
			_tmp429_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
			_tmp430_ = _tmp429_;
			vala_ccode_function_call_add_argument (_tmp428_, _tmp430_);
			_vala_ccode_node_unref0 (_tmp430_);
		} else {
			gboolean _tmp431_ = FALSE;
			gboolean _tmp432_ = FALSE;
			gboolean _tmp433_ = FALSE;
			gboolean _tmp434_ = FALSE;
			ValaMethod* _tmp435_;
			_tmp435_ = m;
			if (_tmp435_ != NULL) {
				ValaMethod* _tmp436_;
				ValaList* _tmp437_;
				ValaList* _tmp438_;
				gint _tmp439_;
				gint _tmp440_;
				_tmp436_ = m;
				_tmp437_ = vala_method_get_type_parameters (_tmp436_);
				_tmp438_ = _tmp437_;
				_tmp439_ = vala_collection_get_size ((ValaCollection*) _tmp438_);
				_tmp440_ = _tmp439_;
				_tmp434_ = _tmp440_ > 0;
				_vala_iterable_unref0 (_tmp438_);
			} else {
				_tmp434_ = FALSE;
			}
			if (_tmp434_) {
				ValaMethod* _tmp441_;
				_tmp441_ = m;
				_tmp433_ = !vala_get_ccode_has_generic_type_parameter (_tmp441_);
			} else {
				_tmp433_ = FALSE;
			}
			if (_tmp433_) {
				ValaMethod* _tmp442_;
				_tmp442_ = m;
				_tmp432_ = !vala_get_ccode_simple_generics (_tmp442_);
			} else {
				_tmp432_ = FALSE;
			}
			if (_tmp432_) {
				gboolean _tmp443_ = FALSE;
				ValaCCodeFunctionCall* _tmp444_;
				ValaCCodeFunctionCall* _tmp445_;
				_tmp444_ = ccall;
				_tmp445_ = finish_call;
				if (_tmp444_ != _tmp445_) {
					_tmp443_ = TRUE;
				} else {
					gboolean _tmp446_;
					gboolean _tmp447_;
					_tmp446_ = vala_method_call_get_is_yield_expression (expr);
					_tmp447_ = _tmp446_;
					_tmp443_ = _tmp447_;
				}
				_tmp431_ = _tmp443_;
			} else {
				_tmp431_ = FALSE;
			}
			if (_tmp431_) {
				ValaHashMap* _tmp448_;
				ValaMemberAccess* _tmp449_;
				ValaList* _tmp450_;
				ValaList* _tmp451_;
				_tmp448_ = in_arg_map;
				_tmp449_ = ma;
				_tmp450_ = vala_member_access_get_type_arguments (_tmp449_);
				_tmp451_ = _tmp450_;
				vala_ccode_base_module_add_generic_type_arguments ((ValaCCodeBaseModule*) self, (ValaMap*) _tmp448_, _tmp451_, (ValaCodeNode*) expr, FALSE, NULL);
				_vala_iterable_unref0 (_tmp451_);
			}
		}
	}
	_tmp452_ = ccall;
	_tmp453_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp452_);
	ccall_expr = _tmp453_;
	_tmp454_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp454_, VALA_TYPE_ARRAY_RESIZE_METHOD)) {
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp455_;
		ValaExpression* _tmp456_;
		ValaExpression* _tmp457_;
		ValaDataType* _tmp458_;
		ValaDataType* _tmp459_;
		ValaArrayType* _tmp460_;
		ValaHashMap* _tmp461_;
		ValaArrayType* _tmp462_;
		ValaDataType* _tmp463_;
		ValaDataType* _tmp464_;
		gchar* _tmp465_;
		gchar* _tmp466_;
		ValaCCodeIdentifier* _tmp467_;
		ValaCCodeIdentifier* _tmp468_;
		_tmp455_ = ma;
		_tmp456_ = vala_member_access_get_inner (_tmp455_);
		_tmp457_ = _tmp456_;
		_tmp458_ = vala_expression_get_value_type (_tmp457_);
		_tmp459_ = _tmp458_;
		_tmp460_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp459_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp460_;
		_tmp461_ = in_arg_map;
		_tmp462_ = array_type;
		_tmp463_ = vala_array_type_get_element_type (_tmp462_);
		_tmp464_ = _tmp463_;
		_tmp465_ = vala_get_ccode_name ((ValaCodeNode*) _tmp464_);
		_tmp466_ = _tmp465_;
		_tmp467_ = vala_ccode_identifier_new (_tmp466_);
		_tmp468_ = _tmp467_;
		vala_map_set ((ValaMap*) _tmp461_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) 0, FALSE)), (ValaCCodeExpression*) _tmp468_);
		_vala_ccode_node_unref0 (_tmp468_);
		_g_free0 (_tmp466_);
		_vala_code_node_unref0 (array_type);
	} else {
		ValaMethod* _tmp469_;
		_tmp469_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp469_, VALA_TYPE_ARRAY_MOVE_METHOD)) {
			((ValaCCodeBaseModule*) self)->requires_array_move = TRUE;
		} else {
			ValaMethod* _tmp470_;
			_tmp470_ = m;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp470_, VALA_TYPE_ARRAY_COPY_METHOD)) {
				ValaMemberAccess* _tmp471_;
				ValaExpression* _tmp472_;
				ValaExpression* _tmp473_;
				ValaTargetValue* _tmp474_;
				ValaTargetValue* _tmp475_;
				ValaTargetValue* _tmp476_;
				ValaTargetValue* _tmp477_;
				_tmp471_ = ma;
				_tmp472_ = vala_member_access_get_inner (_tmp471_);
				_tmp473_ = _tmp472_;
				_tmp474_ = vala_expression_get_target_value (_tmp473_);
				_tmp475_ = _tmp474_;
				_tmp476_ = vala_ccode_base_module_copy_value ((ValaCCodeBaseModule*) self, _tmp475_, (ValaCodeNode*) expr);
				_tmp477_ = _tmp476_;
				vala_expression_set_target_value ((ValaExpression*) expr, _tmp477_);
				_vala_target_value_unref0 (_tmp477_);
				_vala_ccode_node_unref0 (ccall_expr);
				_vala_map_unref0 (out_arg_map);
				_vala_map_unref0 (in_arg_map);
				_vala_code_node_unref0 (itype);
				_vala_code_node_unref0 (ma);
				_vala_iterable_unref0 (params);
				_vala_code_node_unref0 (deleg);
				_vala_code_node_unref0 (m);
				_vala_ccode_node_unref0 (finish_call);
				_vala_ccode_node_unref0 (async_call);
				_vala_ccode_node_unref0 (ccall);
				return;
			}
		}
	}
	instance = NULL;
	_tmp479_ = m;
	if (_tmp479_ != NULL) {
		ValaMethod* _tmp480_;
		gboolean _tmp481_;
		gboolean _tmp482_;
		_tmp480_ = m;
		_tmp481_ = vala_method_get_is_async_callback (_tmp480_);
		_tmp482_ = _tmp481_;
		_tmp478_ = _tmp482_;
	} else {
		_tmp478_ = FALSE;
	}
	if (_tmp478_) {
		ValaMethod* _tmp483_;
		ValaMethod* _tmp484_;
		gboolean _tmp485_;
		gboolean _tmp486_;
		ValaHashMap* _tmp500_;
		ValaMethod* _tmp501_;
		ValaCCodeExpression* _tmp502_;
		ValaHashMap* _tmp503_;
		ValaMethod* _tmp504_;
		ValaCCodeExpression* _tmp505_;
		_tmp483_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
		_tmp484_ = _tmp483_;
		_tmp485_ = vala_method_get_closure (_tmp484_);
		_tmp486_ = _tmp485_;
		if (_tmp486_) {
			ValaBlock* block = NULL;
			ValaMethod* _tmp487_;
			ValaSymbol* _tmp488_;
			ValaSymbol* _tmp489_;
			ValaBlock* _tmp490_;
			ValaBlock* _tmp491_;
			ValaBlock* _tmp492_;
			ValaBlock* _tmp493_;
			gchar* _tmp494_;
			gchar* _tmp495_;
			ValaCCodeExpression* _tmp496_;
			ValaCCodeExpression* _tmp497_;
			ValaCCodeMemberAccess* _tmp498_;
			_tmp487_ = m;
			_tmp488_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp487_);
			_tmp489_ = _tmp488_;
			_tmp490_ = vala_subroutine_get_body ((ValaSubroutine*) G_TYPE_CHECK_INSTANCE_CAST (_tmp489_, VALA_TYPE_METHOD, ValaMethod));
			_tmp491_ = _tmp490_;
			_tmp492_ = _vala_code_node_ref0 (_tmp491_);
			block = _tmp492_;
			_tmp493_ = block;
			_tmp494_ = g_strdup_printf ("_data%d_", vala_ccode_base_module_get_block_id ((ValaCCodeBaseModule*) self, _tmp493_));
			_tmp495_ = _tmp494_;
			_tmp496_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp495_);
			_tmp497_ = _tmp496_;
			_tmp498_ = vala_ccode_member_access_new_pointer (_tmp497_, "_async_data_");
			_vala_ccode_node_unref0 (instance);
			instance = (ValaCCodeExpression*) _tmp498_;
			_vala_ccode_node_unref0 (_tmp497_);
			_g_free0 (_tmp495_);
			_vala_code_node_unref0 (block);
		} else {
			ValaCCodeIdentifier* _tmp499_;
			_tmp499_ = vala_ccode_identifier_new ("_data_");
			_vala_ccode_node_unref0 (instance);
			instance = (ValaCCodeExpression*) _tmp499_;
		}
		_tmp500_ = in_arg_map;
		_tmp501_ = m;
		_tmp502_ = instance;
		vala_map_set ((ValaMap*) _tmp500_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp501_), FALSE)), _tmp502_);
		_tmp503_ = out_arg_map;
		_tmp504_ = m;
		_tmp505_ = instance;
		vala_map_set ((ValaMap*) _tmp503_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp504_), FALSE)), _tmp505_);
	} else {
		gboolean _tmp506_ = FALSE;
		gboolean _tmp507_ = FALSE;
		ValaMethod* _tmp508_;
		_tmp508_ = m;
		if (_tmp508_ != NULL) {
			ValaMethod* _tmp509_;
			ValaMemberBinding _tmp510_;
			ValaMemberBinding _tmp511_;
			_tmp509_ = m;
			_tmp510_ = vala_method_get_binding (_tmp509_);
			_tmp511_ = _tmp510_;
			_tmp507_ = _tmp511_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp507_ = FALSE;
		}
		if (_tmp507_) {
			ValaMethod* _tmp512_;
			_tmp512_ = m;
			_tmp506_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp512_, VALA_TYPE_CREATION_METHOD);
		} else {
			_tmp506_ = FALSE;
		}
		if (_tmp506_) {
			ValaTargetValue* instance_value = NULL;
			ValaMemberAccess* _tmp513_;
			ValaExpression* _tmp514_;
			ValaExpression* _tmp515_;
			ValaTargetValue* _tmp516_;
			ValaTargetValue* _tmp517_;
			ValaTargetValue* _tmp518_;
			gboolean _tmp519_ = FALSE;
			gboolean _tmp520_ = FALSE;
			ValaMemberAccess* _tmp521_;
			const gchar* _tmp522_;
			const gchar* _tmp523_;
			ValaTargetValue* _tmp545_;
			ValaCCodeExpression* _tmp546_;
			ValaStruct* st = NULL;
			ValaMethod* _tmp547_;
			ValaSymbol* _tmp548_;
			ValaSymbol* _tmp549_;
			ValaStruct* _tmp550_;
			gboolean _tmp551_ = FALSE;
			ValaStruct* _tmp552_;
			gboolean _tmp561_;
			gboolean _tmp562_;
			_tmp513_ = ma;
			_tmp514_ = vala_member_access_get_inner (_tmp513_);
			_tmp515_ = _tmp514_;
			_tmp516_ = vala_expression_get_target_value (_tmp515_);
			_tmp517_ = _tmp516_;
			_tmp518_ = _vala_target_value_ref0 (_tmp517_);
			instance_value = _tmp518_;
			_tmp521_ = ma;
			_tmp522_ = vala_member_access_get_member_name (_tmp521_);
			_tmp523_ = _tmp522_;
			if (g_strcmp0 (_tmp523_, "begin") == 0) {
				_tmp520_ = TRUE;
			} else {
				ValaMemberAccess* _tmp524_;
				const gchar* _tmp525_;
				const gchar* _tmp526_;
				_tmp524_ = ma;
				_tmp525_ = vala_member_access_get_member_name (_tmp524_);
				_tmp526_ = _tmp525_;
				_tmp520_ = g_strcmp0 (_tmp526_, "end") == 0;
			}
			if (_tmp520_) {
				ValaMemberAccess* _tmp527_;
				ValaExpression* _tmp528_;
				ValaExpression* _tmp529_;
				ValaSymbol* _tmp530_;
				ValaSymbol* _tmp531_;
				ValaMemberAccess* _tmp532_;
				ValaSymbol* _tmp533_;
				ValaSymbol* _tmp534_;
				_tmp527_ = ma;
				_tmp528_ = vala_member_access_get_inner (_tmp527_);
				_tmp529_ = _tmp528_;
				_tmp530_ = vala_expression_get_symbol_reference (_tmp529_);
				_tmp531_ = _tmp530_;
				_tmp532_ = ma;
				_tmp533_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp532_);
				_tmp534_ = _tmp533_;
				_tmp519_ = _tmp531_ == _tmp534_;
			} else {
				_tmp519_ = FALSE;
			}
			if (_tmp519_) {
				ValaMemberAccess* inner_ma = NULL;
				ValaMemberAccess* _tmp535_;
				ValaExpression* _tmp536_;
				ValaExpression* _tmp537_;
				ValaMemberAccess* _tmp538_;
				ValaMemberAccess* _tmp539_;
				ValaExpression* _tmp540_;
				ValaExpression* _tmp541_;
				ValaTargetValue* _tmp542_;
				ValaTargetValue* _tmp543_;
				ValaTargetValue* _tmp544_;
				_tmp535_ = ma;
				_tmp536_ = vala_member_access_get_inner (_tmp535_);
				_tmp537_ = _tmp536_;
				_tmp538_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp537_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
				inner_ma = _tmp538_;
				_tmp539_ = inner_ma;
				_tmp540_ = vala_member_access_get_inner (_tmp539_);
				_tmp541_ = _tmp540_;
				_tmp542_ = vala_expression_get_target_value (_tmp541_);
				_tmp543_ = _tmp542_;
				_tmp544_ = _vala_target_value_ref0 (_tmp543_);
				_vala_target_value_unref0 (instance_value);
				instance_value = _tmp544_;
				_vala_code_node_unref0 (inner_ma);
			}
			_tmp545_ = instance_value;
			_tmp546_ = vala_ccode_base_module_get_cvalue_ ((ValaCCodeBaseModule*) self, _tmp545_);
			_vala_ccode_node_unref0 (instance);
			instance = _tmp546_;
			_tmp547_ = m;
			_tmp548_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp547_);
			_tmp549_ = _tmp548_;
			_tmp550_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp549_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp549_) : NULL);
			st = _tmp550_;
			_tmp552_ = st;
			if (_tmp552_ != NULL) {
				ValaStruct* _tmp553_;
				_tmp553_ = st;
				_tmp551_ = !vala_struct_is_simple_type (_tmp553_);
			} else {
				_tmp551_ = FALSE;
			}
			if (_tmp551_) {
				ValaTargetValue* _tmp554_;
				ValaTargetValue* _tmp557_;
				ValaCCodeExpression* _tmp558_;
				ValaCCodeExpression* _tmp559_;
				ValaCCodeUnaryExpression* _tmp560_;
				_tmp554_ = instance_value;
				if (!vala_ccode_base_module_get_lvalue ((ValaCCodeBaseModule*) self, _tmp554_)) {
					ValaTargetValue* _tmp555_;
					ValaTargetValue* _tmp556_;
					_tmp555_ = instance_value;
					_tmp556_ = vala_ccode_base_module_store_temp_value ((ValaCCodeBaseModule*) self, _tmp555_, (ValaCodeNode*) expr, NULL);
					_vala_target_value_unref0 (instance_value);
					instance_value = _tmp556_;
				}
				_tmp557_ = instance_value;
				_tmp558_ = vala_ccode_base_module_get_cvalue_ ((ValaCCodeBaseModule*) self, _tmp557_);
				_tmp559_ = _tmp558_;
				_tmp560_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp559_);
				_vala_ccode_node_unref0 (instance);
				instance = (ValaCCodeExpression*) _tmp560_;
				_vala_ccode_node_unref0 (_tmp559_);
			}
			_tmp561_ = vala_method_call_get_is_yield_expression (expr);
			_tmp562_ = _tmp561_;
			if (_tmp562_) {
				ValaHashMap* _tmp563_;
				ValaMethod* _tmp564_;
				ValaCCodeExpression* _tmp565_;
				ValaMethod* _tmp566_;
				_tmp563_ = in_arg_map;
				_tmp564_ = m;
				_tmp565_ = instance;
				vala_map_set ((ValaMap*) _tmp563_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp564_), FALSE)), _tmp565_);
				_tmp566_ = m;
				if (vala_get_ccode_finish_instance ((ValaCodeNode*) _tmp566_)) {
					ValaHashMap* _tmp567_;
					ValaMethod* _tmp568_;
					ValaCCodeExpression* _tmp569_;
					_tmp567_ = out_arg_map;
					_tmp568_ = m;
					_tmp569_ = instance;
					vala_map_set ((ValaMap*) _tmp567_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp568_), FALSE)), _tmp569_);
				}
			} else {
				gboolean _tmp570_ = FALSE;
				ValaMemberAccess* _tmp571_;
				const gchar* _tmp572_;
				const gchar* _tmp573_;
				_tmp571_ = ma;
				_tmp572_ = vala_member_access_get_member_name (_tmp571_);
				_tmp573_ = _tmp572_;
				if (g_strcmp0 (_tmp573_, "end") != 0) {
					_tmp570_ = TRUE;
				} else {
					ValaMethod* _tmp574_;
					_tmp574_ = m;
					_tmp570_ = vala_get_ccode_finish_instance ((ValaCodeNode*) _tmp574_);
				}
				if (_tmp570_) {
					ValaHashMap* _tmp575_;
					ValaMethod* _tmp576_;
					ValaCCodeExpression* _tmp577_;
					ValaHashMap* _tmp578_;
					ValaMethod* _tmp579_;
					ValaCCodeExpression* _tmp580_;
					_tmp575_ = out_arg_map;
					_tmp576_ = m;
					_tmp577_ = instance;
					vala_map_set ((ValaMap*) _tmp575_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp576_), FALSE)), _tmp577_);
					_tmp578_ = in_arg_map;
					_tmp579_ = m;
					_tmp580_ = instance;
					vala_map_set ((ValaMap*) _tmp578_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp579_), FALSE)), _tmp580_);
				}
			}
			_vala_code_node_unref0 (st);
			_vala_target_value_unref0 (instance_value);
		} else {
			gboolean _tmp581_ = FALSE;
			ValaMethod* _tmp582_;
			_tmp582_ = m;
			if (_tmp582_ != NULL) {
				ValaMethod* _tmp583_;
				ValaMemberBinding _tmp584_;
				ValaMemberBinding _tmp585_;
				_tmp583_ = m;
				_tmp584_ = vala_method_get_binding (_tmp583_);
				_tmp585_ = _tmp584_;
				_tmp581_ = _tmp585_ == VALA_MEMBER_BINDING_CLASS;
			} else {
				_tmp581_ = FALSE;
			}
			if (_tmp581_) {
				ValaClass* cl = NULL;
				ValaMethod* _tmp586_;
				ValaSymbol* _tmp587_;
				ValaSymbol* _tmp588_;
				ValaClass* _tmp589_;
				ValaCCodeFunctionCall* cast = NULL;
				ValaClass* _tmp590_;
				gchar* _tmp591_;
				gchar* _tmp592_;
				gchar* _tmp593_;
				gchar* _tmp594_;
				ValaCCodeIdentifier* _tmp595_;
				ValaCCodeIdentifier* _tmp596_;
				ValaCCodeFunctionCall* _tmp597_;
				ValaCCodeFunctionCall* _tmp598_;
				ValaCCodeExpression* klass = NULL;
				ValaMemberAccess* _tmp599_;
				ValaExpression* _tmp600_;
				ValaExpression* _tmp601_;
				ValaCCodeFunctionCall* _tmp627_;
				ValaCCodeExpression* _tmp628_;
				ValaHashMap* _tmp629_;
				ValaMethod* _tmp630_;
				ValaCCodeFunctionCall* _tmp631_;
				ValaHashMap* _tmp632_;
				ValaMethod* _tmp633_;
				ValaCCodeFunctionCall* _tmp634_;
				_tmp586_ = m;
				_tmp587_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp586_);
				_tmp588_ = _tmp587_;
				_tmp589_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp588_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp589_;
				_tmp590_ = cl;
				_tmp591_ = vala_get_ccode_upper_case_name ((ValaSymbol*) _tmp590_, NULL);
				_tmp592_ = _tmp591_;
				_tmp593_ = g_strconcat (_tmp592_, "_CLASS", NULL);
				_tmp594_ = _tmp593_;
				_tmp595_ = vala_ccode_identifier_new (_tmp594_);
				_tmp596_ = _tmp595_;
				_tmp597_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp596_);
				_tmp598_ = _tmp597_;
				_vala_ccode_node_unref0 (_tmp596_);
				_g_free0 (_tmp594_);
				_g_free0 (_tmp592_);
				cast = _tmp598_;
				_tmp599_ = ma;
				_tmp600_ = vala_member_access_get_inner (_tmp599_);
				_tmp601_ = _tmp600_;
				if (_tmp601_ == NULL) {
					ValaDataType* _tmp602_;
					ValaDataType* _tmp603_;
					gboolean _tmp604_;
					_tmp602_ = vala_ccode_base_module_get_this_type ((ValaCCodeBaseModule*) self);
					_tmp603_ = _tmp602_;
					_tmp604_ = _tmp603_ == NULL;
					_vala_code_node_unref0 (_tmp603_);
					if (_tmp604_) {
						ValaCCodeIdentifier* _tmp605_;
						_tmp605_ = vala_ccode_identifier_new ("klass");
						_vala_ccode_node_unref0 (klass);
						klass = (ValaCCodeExpression*) _tmp605_;
					} else {
						ValaCCodeFunctionCall* k = NULL;
						ValaCCodeIdentifier* _tmp606_;
						ValaCCodeIdentifier* _tmp607_;
						ValaCCodeFunctionCall* _tmp608_;
						ValaCCodeFunctionCall* _tmp609_;
						ValaCCodeFunctionCall* _tmp610_;
						ValaCCodeExpression* _tmp611_;
						ValaCCodeExpression* _tmp612_;
						ValaCCodeFunctionCall* _tmp613_;
						ValaCCodeExpression* _tmp614_;
						_tmp606_ = vala_ccode_identifier_new ("G_OBJECT_GET_CLASS");
						_tmp607_ = _tmp606_;
						_tmp608_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp607_);
						_tmp609_ = _tmp608_;
						_vala_ccode_node_unref0 (_tmp607_);
						k = _tmp609_;
						_tmp610_ = k;
						_tmp611_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
						_tmp612_ = _tmp611_;
						vala_ccode_function_call_add_argument (_tmp610_, _tmp612_);
						_vala_ccode_node_unref0 (_tmp612_);
						_tmp613_ = k;
						_tmp614_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp613_);
						_vala_ccode_node_unref0 (klass);
						klass = _tmp614_;
						_vala_ccode_node_unref0 (k);
					}
				} else {
					ValaCCodeFunctionCall* k = NULL;
					ValaCCodeIdentifier* _tmp615_;
					ValaCCodeIdentifier* _tmp616_;
					ValaCCodeFunctionCall* _tmp617_;
					ValaCCodeFunctionCall* _tmp618_;
					ValaCCodeFunctionCall* _tmp619_;
					ValaMemberAccess* _tmp620_;
					ValaExpression* _tmp621_;
					ValaExpression* _tmp622_;
					ValaCCodeExpression* _tmp623_;
					ValaCCodeExpression* _tmp624_;
					ValaCCodeFunctionCall* _tmp625_;
					ValaCCodeExpression* _tmp626_;
					_tmp615_ = vala_ccode_identifier_new ("G_OBJECT_GET_CLASS");
					_tmp616_ = _tmp615_;
					_tmp617_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp616_);
					_tmp618_ = _tmp617_;
					_vala_ccode_node_unref0 (_tmp616_);
					k = _tmp618_;
					_tmp619_ = k;
					_tmp620_ = ma;
					_tmp621_ = vala_member_access_get_inner (_tmp620_);
					_tmp622_ = _tmp621_;
					_tmp623_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp622_);
					_tmp624_ = _tmp623_;
					vala_ccode_function_call_add_argument (_tmp619_, _tmp624_);
					_vala_ccode_node_unref0 (_tmp624_);
					_tmp625_ = k;
					_tmp626_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp625_);
					_vala_ccode_node_unref0 (klass);
					klass = _tmp626_;
					_vala_ccode_node_unref0 (k);
				}
				_tmp627_ = cast;
				_tmp628_ = klass;
				vala_ccode_function_call_add_argument (_tmp627_, _tmp628_);
				_tmp629_ = in_arg_map;
				_tmp630_ = m;
				_tmp631_ = cast;
				vala_map_set ((ValaMap*) _tmp629_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp630_), FALSE)), (ValaCCodeExpression*) _tmp631_);
				_tmp632_ = out_arg_map;
				_tmp633_ = m;
				_tmp634_ = cast;
				vala_map_set ((ValaMap*) _tmp632_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp633_), FALSE)), (ValaCCodeExpression*) _tmp634_);
				_vala_ccode_node_unref0 (klass);
				_vala_ccode_node_unref0 (cast);
				_vala_code_node_unref0 (cl);
			}
		}
	}
	_tmp636_ = m;
	if (_tmp636_ != NULL) {
		ValaMethod* _tmp637_;
		_tmp637_ = m;
		_tmp635_ = vala_get_ccode_has_generic_type_parameter (_tmp637_);
	} else {
		_tmp635_ = FALSE;
	}
	if (_tmp635_) {
		ValaMethod* _tmp638_;
		ValaList* _tmp639_;
		ValaList* _tmp640_;
		gint _tmp641_;
		gint _tmp642_;
		gboolean _tmp643_;
		_tmp638_ = m;
		_tmp639_ = vala_method_get_type_parameters (_tmp638_);
		_tmp640_ = _tmp639_;
		_tmp641_ = vala_collection_get_size ((ValaCollection*) _tmp640_);
		_tmp642_ = _tmp641_;
		_tmp643_ = _tmp642_ > 0;
		_vala_iterable_unref0 (_tmp640_);
		if (_tmp643_) {
			gint type_param_index = 0;
			type_param_index = 0;
			{
				ValaList* _type_arg_list = NULL;
				ValaMemberAccess* _tmp644_;
				ValaList* _tmp645_;
				gint _type_arg_size = 0;
				ValaList* _tmp646_;
				gint _tmp647_;
				gint _tmp648_;
				gint _type_arg_index = 0;
				_tmp644_ = ma;
				_tmp645_ = vala_member_access_get_type_arguments (_tmp644_);
				_type_arg_list = _tmp645_;
				_tmp646_ = _type_arg_list;
				_tmp647_ = vala_collection_get_size ((ValaCollection*) _tmp646_);
				_tmp648_ = _tmp647_;
				_type_arg_size = _tmp648_;
				_type_arg_index = -1;
				while (TRUE) {
					gint _tmp649_;
					gint _tmp650_;
					gint _tmp651_;
					ValaDataType* type_arg = NULL;
					ValaList* _tmp652_;
					gint _tmp653_;
					gpointer _tmp654_;
					ValaHashMap* _tmp655_;
					ValaMethod* _tmp656_;
					gint _tmp657_;
					ValaDataType* _tmp658_;
					gchar* _tmp659_;
					gchar* _tmp660_;
					ValaCCodeIdentifier* _tmp661_;
					ValaCCodeIdentifier* _tmp662_;
					gint _tmp663_;
					_tmp649_ = _type_arg_index;
					_type_arg_index = _tmp649_ + 1;
					_tmp650_ = _type_arg_index;
					_tmp651_ = _type_arg_size;
					if (!(_tmp650_ < _tmp651_)) {
						break;
					}
					_tmp652_ = _type_arg_list;
					_tmp653_ = _type_arg_index;
					_tmp654_ = vala_list_get (_tmp652_, _tmp653_);
					type_arg = (ValaDataType*) _tmp654_;
					_tmp655_ = in_arg_map;
					_tmp656_ = m;
					_tmp657_ = type_param_index;
					_tmp658_ = type_arg;
					_tmp659_ = vala_get_ccode_name ((ValaCodeNode*) _tmp658_);
					_tmp660_ = _tmp659_;
					_tmp661_ = vala_ccode_identifier_new (_tmp660_);
					_tmp662_ = _tmp661_;
					vala_map_set ((ValaMap*) _tmp655_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_generic_type_pos (_tmp656_) + (0.01 * _tmp657_), FALSE)), (ValaCCodeExpression*) _tmp662_);
					_vala_ccode_node_unref0 (_tmp662_);
					_g_free0 (_tmp660_);
					_tmp663_ = type_param_index;
					type_param_index = _tmp663_ + 1;
					_vala_code_node_unref0 (type_arg);
				}
				_vala_iterable_unref0 (_type_arg_list);
			}
		} else {
			gint type_param_index = 0;
			type_param_index = 0;
			{
				ValaList* _type_arg_list = NULL;
				ValaMemberAccess* _tmp664_;
				ValaExpression* _tmp665_;
				ValaExpression* _tmp666_;
				ValaDataType* _tmp667_;
				ValaDataType* _tmp668_;
				ValaList* _tmp669_;
				gint _type_arg_size = 0;
				ValaList* _tmp670_;
				gint _tmp671_;
				gint _tmp672_;
				gint _type_arg_index = 0;
				_tmp664_ = ma;
				_tmp665_ = vala_member_access_get_inner (_tmp664_);
				_tmp666_ = _tmp665_;
				_tmp667_ = vala_expression_get_value_type (_tmp666_);
				_tmp668_ = _tmp667_;
				_tmp669_ = vala_data_type_get_type_arguments (_tmp668_);
				_type_arg_list = _tmp669_;
				_tmp670_ = _type_arg_list;
				_tmp671_ = vala_collection_get_size ((ValaCollection*) _tmp670_);
				_tmp672_ = _tmp671_;
				_type_arg_size = _tmp672_;
				_type_arg_index = -1;
				while (TRUE) {
					gint _tmp673_;
					gint _tmp674_;
					gint _tmp675_;
					ValaDataType* type_arg = NULL;
					ValaList* _tmp676_;
					gint _tmp677_;
					gpointer _tmp678_;
					ValaHashMap* _tmp679_;
					ValaMethod* _tmp680_;
					gint _tmp681_;
					ValaDataType* _tmp682_;
					gchar* _tmp683_;
					gchar* _tmp684_;
					ValaCCodeIdentifier* _tmp685_;
					ValaCCodeIdentifier* _tmp686_;
					gint _tmp687_;
					_tmp673_ = _type_arg_index;
					_type_arg_index = _tmp673_ + 1;
					_tmp674_ = _type_arg_index;
					_tmp675_ = _type_arg_size;
					if (!(_tmp674_ < _tmp675_)) {
						break;
					}
					_tmp676_ = _type_arg_list;
					_tmp677_ = _type_arg_index;
					_tmp678_ = vala_list_get (_tmp676_, _tmp677_);
					type_arg = (ValaDataType*) _tmp678_;
					_tmp679_ = in_arg_map;
					_tmp680_ = m;
					_tmp681_ = type_param_index;
					_tmp682_ = type_arg;
					_tmp683_ = vala_get_ccode_name ((ValaCodeNode*) _tmp682_);
					_tmp684_ = _tmp683_;
					_tmp685_ = vala_ccode_identifier_new (_tmp684_);
					_tmp686_ = _tmp685_;
					vala_map_set ((ValaMap*) _tmp679_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_generic_type_pos (_tmp680_) + (0.01 * _tmp681_), FALSE)), (ValaCCodeExpression*) _tmp686_);
					_vala_ccode_node_unref0 (_tmp686_);
					_g_free0 (_tmp684_);
					_tmp687_ = type_param_index;
					type_param_index = _tmp687_ + 1;
					_vala_code_node_unref0 (type_arg);
				}
				_vala_iterable_unref0 (_type_arg_list);
			}
		}
	}
	_tmp688_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp688_, VALA_TYPE_ARRAY_MOVE_METHOD)) {
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp689_;
		ValaExpression* _tmp690_;
		ValaExpression* _tmp691_;
		ValaDataType* _tmp692_;
		ValaDataType* _tmp693_;
		ValaArrayType* _tmp694_;
		ValaCCodeFunctionCall* csizeof = NULL;
		ValaCCodeIdentifier* _tmp695_;
		ValaCCodeIdentifier* _tmp696_;
		ValaCCodeFunctionCall* _tmp697_;
		ValaCCodeFunctionCall* _tmp698_;
		ValaCCodeFunctionCall* _tmp699_;
		ValaArrayType* _tmp700_;
		ValaDataType* _tmp701_;
		ValaDataType* _tmp702_;
		gchar* _tmp703_;
		gchar* _tmp704_;
		ValaCCodeIdentifier* _tmp705_;
		ValaCCodeIdentifier* _tmp706_;
		ValaHashMap* _tmp707_;
		ValaCCodeFunctionCall* _tmp708_;
		_tmp689_ = ma;
		_tmp690_ = vala_member_access_get_inner (_tmp689_);
		_tmp691_ = _tmp690_;
		_tmp692_ = vala_expression_get_value_type (_tmp691_);
		_tmp693_ = _tmp692_;
		_tmp694_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp693_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp694_;
		_tmp695_ = vala_ccode_identifier_new ("sizeof");
		_tmp696_ = _tmp695_;
		_tmp697_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp696_);
		_tmp698_ = _tmp697_;
		_vala_ccode_node_unref0 (_tmp696_);
		csizeof = _tmp698_;
		_tmp699_ = csizeof;
		_tmp700_ = array_type;
		_tmp701_ = vala_array_type_get_element_type (_tmp700_);
		_tmp702_ = _tmp701_;
		_tmp703_ = vala_get_ccode_name ((ValaCodeNode*) _tmp702_);
		_tmp704_ = _tmp703_;
		_tmp705_ = vala_ccode_identifier_new (_tmp704_);
		_tmp706_ = _tmp705_;
		vala_ccode_function_call_add_argument (_tmp699_, (ValaCCodeExpression*) _tmp706_);
		_vala_ccode_node_unref0 (_tmp706_);
		_g_free0 (_tmp704_);
		_tmp707_ = in_arg_map;
		_tmp708_ = csizeof;
		vala_map_set ((ValaMap*) _tmp707_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, 0.1, FALSE)), (ValaCCodeExpression*) _tmp708_);
		_vala_ccode_node_unref0 (csizeof);
		_vala_code_node_unref0 (array_type);
	} else {
		ValaMethod* _tmp709_;
		_tmp709_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp709_, VALA_TYPE_DYNAMIC_METHOD)) {
			ValaMethod* _tmp710_;
			gint param_nr = 0;
			ValaMethod* _tmp781_;
			_tmp710_ = m;
			vala_method_clear_parameters (_tmp710_);
			param_nr = 1;
			{
				ValaList* _arg_list = NULL;
				ValaList* _tmp711_;
				gint _arg_size = 0;
				ValaList* _tmp712_;
				gint _tmp713_;
				gint _tmp714_;
				gint _arg_index = 0;
				_tmp711_ = vala_method_call_get_argument_list (expr);
				_arg_list = _tmp711_;
				_tmp712_ = _arg_list;
				_tmp713_ = vala_collection_get_size ((ValaCollection*) _tmp712_);
				_tmp714_ = _tmp713_;
				_arg_size = _tmp714_;
				_arg_index = -1;
				while (TRUE) {
					gint _tmp715_;
					gint _tmp716_;
					gint _tmp717_;
					ValaExpression* arg = NULL;
					ValaList* _tmp718_;
					gint _tmp719_;
					gpointer _tmp720_;
					ValaUnaryExpression* unary = NULL;
					ValaExpression* _tmp721_;
					ValaUnaryExpression* _tmp722_;
					gboolean _tmp723_ = FALSE;
					ValaUnaryExpression* _tmp724_;
					gint _tmp768_;
					_tmp715_ = _arg_index;
					_arg_index = _tmp715_ + 1;
					_tmp716_ = _arg_index;
					_tmp717_ = _arg_size;
					if (!(_tmp716_ < _tmp717_)) {
						break;
					}
					_tmp718_ = _arg_list;
					_tmp719_ = _arg_index;
					_tmp720_ = vala_list_get (_tmp718_, _tmp719_);
					arg = (ValaExpression*) _tmp720_;
					_tmp721_ = arg;
					_tmp722_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp721_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp721_) : NULL);
					unary = _tmp722_;
					_tmp724_ = unary;
					if (_tmp724_ != NULL) {
						ValaUnaryExpression* _tmp725_;
						ValaUnaryOperator _tmp726_;
						ValaUnaryOperator _tmp727_;
						_tmp725_ = unary;
						_tmp726_ = vala_unary_expression_get_operator (_tmp725_);
						_tmp727_ = _tmp726_;
						_tmp723_ = _tmp727_ == VALA_UNARY_OPERATOR_OUT;
					} else {
						_tmp723_ = FALSE;
					}
					if (_tmp723_) {
						ValaParameter* param = NULL;
						gint _tmp728_;
						gchar* _tmp729_;
						gchar* _tmp730_;
						ValaUnaryExpression* _tmp731_;
						ValaExpression* _tmp732_;
						ValaExpression* _tmp733_;
						ValaDataType* _tmp734_;
						ValaDataType* _tmp735_;
						ValaParameter* _tmp736_;
						ValaParameter* _tmp737_;
						ValaParameter* _tmp738_;
						ValaMethod* _tmp739_;
						ValaParameter* _tmp740_;
						_tmp728_ = param_nr;
						_tmp729_ = g_strdup_printf ("param%d", _tmp728_);
						_tmp730_ = _tmp729_;
						_tmp731_ = unary;
						_tmp732_ = vala_unary_expression_get_inner (_tmp731_);
						_tmp733_ = _tmp732_;
						_tmp734_ = vala_expression_get_value_type (_tmp733_);
						_tmp735_ = _tmp734_;
						_tmp736_ = vala_parameter_new (_tmp730_, _tmp735_, NULL);
						_tmp737_ = _tmp736_;
						_g_free0 (_tmp730_);
						param = _tmp737_;
						_tmp738_ = param;
						vala_parameter_set_direction (_tmp738_, VALA_PARAMETER_DIRECTION_OUT);
						_tmp739_ = m;
						_tmp740_ = param;
						vala_callable_add_parameter ((ValaCallable*) _tmp739_, _tmp740_);
						_vala_code_node_unref0 (param);
					} else {
						gboolean _tmp741_ = FALSE;
						ValaUnaryExpression* _tmp742_;
						_tmp742_ = unary;
						if (_tmp742_ != NULL) {
							ValaUnaryExpression* _tmp743_;
							ValaUnaryOperator _tmp744_;
							ValaUnaryOperator _tmp745_;
							_tmp743_ = unary;
							_tmp744_ = vala_unary_expression_get_operator (_tmp743_);
							_tmp745_ = _tmp744_;
							_tmp741_ = _tmp745_ == VALA_UNARY_OPERATOR_REF;
						} else {
							_tmp741_ = FALSE;
						}
						if (_tmp741_) {
							ValaParameter* param = NULL;
							gint _tmp746_;
							gchar* _tmp747_;
							gchar* _tmp748_;
							ValaUnaryExpression* _tmp749_;
							ValaExpression* _tmp750_;
							ValaExpression* _tmp751_;
							ValaDataType* _tmp752_;
							ValaDataType* _tmp753_;
							ValaParameter* _tmp754_;
							ValaParameter* _tmp755_;
							ValaParameter* _tmp756_;
							ValaMethod* _tmp757_;
							ValaParameter* _tmp758_;
							_tmp746_ = param_nr;
							_tmp747_ = g_strdup_printf ("param%d", _tmp746_);
							_tmp748_ = _tmp747_;
							_tmp749_ = unary;
							_tmp750_ = vala_unary_expression_get_inner (_tmp749_);
							_tmp751_ = _tmp750_;
							_tmp752_ = vala_expression_get_value_type (_tmp751_);
							_tmp753_ = _tmp752_;
							_tmp754_ = vala_parameter_new (_tmp748_, _tmp753_, NULL);
							_tmp755_ = _tmp754_;
							_g_free0 (_tmp748_);
							param = _tmp755_;
							_tmp756_ = param;
							vala_parameter_set_direction (_tmp756_, VALA_PARAMETER_DIRECTION_REF);
							_tmp757_ = m;
							_tmp758_ = param;
							vala_callable_add_parameter ((ValaCallable*) _tmp757_, _tmp758_);
							_vala_code_node_unref0 (param);
						} else {
							ValaMethod* _tmp759_;
							gint _tmp760_;
							gchar* _tmp761_;
							gchar* _tmp762_;
							ValaExpression* _tmp763_;
							ValaDataType* _tmp764_;
							ValaDataType* _tmp765_;
							ValaParameter* _tmp766_;
							ValaParameter* _tmp767_;
							_tmp759_ = m;
							_tmp760_ = param_nr;
							_tmp761_ = g_strdup_printf ("param%d", _tmp760_);
							_tmp762_ = _tmp761_;
							_tmp763_ = arg;
							_tmp764_ = vala_expression_get_value_type (_tmp763_);
							_tmp765_ = _tmp764_;
							_tmp766_ = vala_parameter_new (_tmp762_, _tmp765_, NULL);
							_tmp767_ = _tmp766_;
							vala_callable_add_parameter ((ValaCallable*) _tmp759_, _tmp767_);
							_vala_code_node_unref0 (_tmp767_);
							_g_free0 (_tmp762_);
						}
					}
					_tmp768_ = param_nr;
					param_nr = _tmp768_ + 1;
					_vala_code_node_unref0 (unary);
					_vala_code_node_unref0 (arg);
				}
				_vala_iterable_unref0 (_arg_list);
			}
			{
				ValaList* _param_list = NULL;
				ValaMethod* _tmp769_;
				ValaList* _tmp770_;
				gint _param_size = 0;
				ValaList* _tmp771_;
				gint _tmp772_;
				gint _tmp773_;
				gint _param_index = 0;
				_tmp769_ = m;
				_tmp770_ = vala_callable_get_parameters ((ValaCallable*) _tmp769_);
				_param_list = _tmp770_;
				_tmp771_ = _param_list;
				_tmp772_ = vala_collection_get_size ((ValaCollection*) _tmp771_);
				_tmp773_ = _tmp772_;
				_param_size = _tmp773_;
				_param_index = -1;
				while (TRUE) {
					gint _tmp774_;
					gint _tmp775_;
					gint _tmp776_;
					ValaParameter* param = NULL;
					ValaList* _tmp777_;
					gint _tmp778_;
					gpointer _tmp779_;
					ValaParameter* _tmp780_;
					_tmp774_ = _param_index;
					_param_index = _tmp774_ + 1;
					_tmp775_ = _param_index;
					_tmp776_ = _param_size;
					if (!(_tmp775_ < _tmp776_)) {
						break;
					}
					_tmp777_ = _param_list;
					_tmp778_ = _param_index;
					_tmp779_ = vala_list_get (_tmp777_, _tmp778_);
					param = (ValaParameter*) _tmp779_;
					_tmp780_ = param;
					vala_code_node_accept ((ValaCodeNode*) _tmp780_, (ValaCodeVisitor*) self);
					_vala_code_node_unref0 (param);
				}
				_vala_iterable_unref0 (_param_list);
			}
			_tmp781_ = m;
			vala_ccode_base_module_generate_dynamic_method_wrapper ((ValaCCodeBaseModule*) self, G_TYPE_CHECK_INSTANCE_CAST (_tmp781_, VALA_TYPE_DYNAMIC_METHOD, ValaDynamicMethod));
		} else {
			gboolean _tmp782_ = FALSE;
			ValaMethod* _tmp783_;
			_tmp783_ = m;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp783_, VALA_TYPE_CREATION_METHOD)) {
				ValaMethod* _tmp784_;
				ValaSymbol* _tmp785_;
				ValaSymbol* _tmp786_;
				_tmp784_ = m;
				_tmp785_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp784_);
				_tmp786_ = _tmp785_;
				_tmp782_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp786_, VALA_TYPE_CLASS);
			} else {
				_tmp782_ = FALSE;
			}
			if (_tmp782_) {
				ValaCCodeFunction* _tmp787_;
				ValaCCodeFunction* _tmp788_;
				ValaCCodeExpression* _tmp789_;
				ValaCCodeExpression* _tmp790_;
				ValaCCodeFunctionCall* _tmp791_;
				ValaClass* _tmp792_;
				ValaClass* _tmp793_;
				gchar* _tmp794_;
				gchar* _tmp795_;
				gchar* _tmp796_;
				gchar* _tmp797_;
				ValaCCodeCastExpression* _tmp798_;
				ValaCCodeCastExpression* _tmp799_;
				ValaMethod* _tmp800_;
				ValaMethod* _tmp801_;
				ValaBlock* _tmp802_;
				ValaBlock* _tmp803_;
				gboolean _tmp804_;
				gboolean _tmp805_;
				gboolean _tmp832_ = FALSE;
				ValaClass* _tmp833_;
				ValaClass* _tmp834_;
				gboolean _tmp835_;
				gboolean _tmp836_;
				_tmp787_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp788_ = _tmp787_;
				_tmp789_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
				_tmp790_ = _tmp789_;
				_tmp791_ = ccall;
				_tmp792_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp793_ = _tmp792_;
				_tmp794_ = vala_get_ccode_name ((ValaCodeNode*) _tmp793_);
				_tmp795_ = _tmp794_;
				_tmp796_ = g_strconcat (_tmp795_, "*", NULL);
				_tmp797_ = _tmp796_;
				_tmp798_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp791_, _tmp797_);
				_tmp799_ = _tmp798_;
				vala_ccode_function_add_assignment (_tmp788_, _tmp790_, (ValaCCodeExpression*) _tmp799_);
				_vala_ccode_node_unref0 (_tmp799_);
				_g_free0 (_tmp797_);
				_g_free0 (_tmp795_);
				_vala_ccode_node_unref0 (_tmp790_);
				_tmp800_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
				_tmp801_ = _tmp800_;
				_tmp802_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp801_);
				_tmp803_ = _tmp802_;
				_tmp804_ = vala_block_get_captured (_tmp803_);
				_tmp805_ = _tmp804_;
				if (_tmp805_) {
					ValaCCodeFunctionCall* ref_call = NULL;
					ValaClass* _tmp806_;
					ValaClass* _tmp807_;
					ValaObjectType* _tmp808_;
					ValaObjectType* _tmp809_;
					ValaSourceReference* _tmp810_;
					ValaSourceReference* _tmp811_;
					ValaCCodeExpression* _tmp812_;
					ValaCCodeExpression* _tmp813_;
					ValaCCodeFunctionCall* _tmp814_;
					ValaCCodeFunctionCall* _tmp815_;
					ValaCCodeFunctionCall* _tmp816_;
					ValaCCodeExpression* _tmp817_;
					ValaCCodeExpression* _tmp818_;
					ValaCCodeFunction* _tmp819_;
					ValaCCodeFunction* _tmp820_;
					ValaMethod* _tmp821_;
					ValaMethod* _tmp822_;
					ValaBlock* _tmp823_;
					ValaBlock* _tmp824_;
					gchar* _tmp825_;
					gchar* _tmp826_;
					ValaCCodeExpression* _tmp827_;
					ValaCCodeExpression* _tmp828_;
					ValaCCodeMemberAccess* _tmp829_;
					ValaCCodeMemberAccess* _tmp830_;
					ValaCCodeFunctionCall* _tmp831_;
					_tmp806_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp807_ = _tmp806_;
					_tmp808_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp807_);
					_tmp809_ = _tmp808_;
					_tmp810_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
					_tmp811_ = _tmp810_;
					_tmp812_ = vala_ccode_base_module_get_dup_func_expression ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp809_, _tmp811_, FALSE);
					_tmp813_ = _tmp812_;
					_tmp814_ = vala_ccode_function_call_new (_tmp813_);
					_tmp815_ = _tmp814_;
					_vala_ccode_node_unref0 (_tmp813_);
					_vala_code_node_unref0 (_tmp809_);
					ref_call = _tmp815_;
					_tmp816_ = ref_call;
					_tmp817_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
					_tmp818_ = _tmp817_;
					vala_ccode_function_call_add_argument (_tmp816_, _tmp818_);
					_vala_ccode_node_unref0 (_tmp818_);
					_tmp819_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
					_tmp820_ = _tmp819_;
					_tmp821_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
					_tmp822_ = _tmp821_;
					_tmp823_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp822_);
					_tmp824_ = _tmp823_;
					_tmp825_ = g_strdup_printf ("_data%d_", vala_ccode_base_module_get_block_id ((ValaCCodeBaseModule*) self, _tmp824_));
					_tmp826_ = _tmp825_;
					_tmp827_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp826_);
					_tmp828_ = _tmp827_;
					_tmp829_ = vala_ccode_member_access_new_pointer (_tmp828_, "self");
					_tmp830_ = _tmp829_;
					_tmp831_ = ref_call;
					vala_ccode_function_add_assignment (_tmp820_, (ValaCCodeExpression*) _tmp830_, (ValaCCodeExpression*) _tmp831_);
					_vala_ccode_node_unref0 (_tmp830_);
					_vala_ccode_node_unref0 (_tmp828_);
					_g_free0 (_tmp826_);
					_vala_ccode_node_unref0 (ref_call);
				}
				_tmp833_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp834_ = _tmp833_;
				_tmp835_ = vala_class_get_is_compact (_tmp834_);
				_tmp836_ = _tmp835_;
				if (!_tmp836_) {
					ValaClass* _tmp837_;
					ValaClass* _tmp838_;
					ValaList* _tmp839_;
					ValaList* _tmp840_;
					gint _tmp841_;
					gint _tmp842_;
					_tmp837_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp838_ = _tmp837_;
					_tmp839_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) _tmp838_);
					_tmp840_ = _tmp839_;
					_tmp841_ = vala_collection_get_size ((ValaCollection*) _tmp840_);
					_tmp842_ = _tmp841_;
					_tmp832_ = _tmp842_ > 0;
					_vala_iterable_unref0 (_tmp840_);
				} else {
					_tmp832_ = FALSE;
				}
				if (_tmp832_) {
					gchar** suffices = NULL;
					gchar* _tmp843_;
					gchar* _tmp844_;
					gchar* _tmp845_;
					gchar** _tmp846_;
					gint suffices_length1;
					gint _suffices_size_;
					_tmp843_ = g_strdup ("type");
					_tmp844_ = g_strdup ("dup_func");
					_tmp845_ = g_strdup ("destroy_func");
					_tmp846_ = g_new0 (gchar*, 3 + 1);
					_tmp846_[0] = _tmp843_;
					_tmp846_[1] = _tmp844_;
					_tmp846_[2] = _tmp845_;
					suffices = _tmp846_;
					suffices_length1 = 3;
					_suffices_size_ = suffices_length1;
					{
						ValaList* _type_param_list = NULL;
						ValaClass* _tmp847_;
						ValaClass* _tmp848_;
						ValaList* _tmp849_;
						gint _type_param_size = 0;
						ValaList* _tmp850_;
						gint _tmp851_;
						gint _tmp852_;
						gint _type_param_index = 0;
						_tmp847_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
						_tmp848_ = _tmp847_;
						_tmp849_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) _tmp848_);
						_type_param_list = _tmp849_;
						_tmp850_ = _type_param_list;
						_tmp851_ = vala_collection_get_size ((ValaCollection*) _tmp850_);
						_tmp852_ = _tmp851_;
						_type_param_size = _tmp852_;
						_type_param_index = -1;
						while (TRUE) {
							gint _tmp853_;
							gint _tmp854_;
							gint _tmp855_;
							ValaTypeParameter* type_param = NULL;
							ValaList* _tmp856_;
							gint _tmp857_;
							gpointer _tmp858_;
							ValaCCodeMemberAccess* priv_access = NULL;
							ValaCCodeIdentifier* _tmp859_;
							ValaCCodeIdentifier* _tmp860_;
							ValaCCodeMemberAccess* _tmp861_;
							ValaCCodeMemberAccess* _tmp862_;
							gchar** _tmp863_;
							gint _tmp863__length1;
							_tmp853_ = _type_param_index;
							_type_param_index = _tmp853_ + 1;
							_tmp854_ = _type_param_index;
							_tmp855_ = _type_param_size;
							if (!(_tmp854_ < _tmp855_)) {
								break;
							}
							_tmp856_ = _type_param_list;
							_tmp857_ = _type_param_index;
							_tmp858_ = vala_list_get (_tmp856_, _tmp857_);
							type_param = (ValaTypeParameter*) _tmp858_;
							_tmp859_ = vala_ccode_identifier_new ("self");
							_tmp860_ = _tmp859_;
							_tmp861_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp860_, "priv");
							_tmp862_ = _tmp861_;
							_vala_ccode_node_unref0 (_tmp860_);
							priv_access = _tmp862_;
							_tmp863_ = suffices;
							_tmp863__length1 = suffices_length1;
							{
								gchar** suffix_collection = NULL;
								gint suffix_collection_length1 = 0;
								gint _suffix_collection_size_ = 0;
								gint suffix_it = 0;
								suffix_collection = _tmp863_;
								suffix_collection_length1 = _tmp863__length1;
								for (suffix_it = 0; suffix_it < _tmp863__length1; suffix_it = suffix_it + 1) {
									gchar* _tmp864_;
									gchar* suffix = NULL;
									_tmp864_ = g_strdup (suffix_collection[suffix_it]);
									suffix = _tmp864_;
									{
										ValaCCodeIdentifier* param_name = NULL;
										ValaTypeParameter* _tmp865_;
										const gchar* _tmp866_;
										const gchar* _tmp867_;
										gchar* _tmp868_;
										gchar* _tmp869_;
										const gchar* _tmp870_;
										gchar* _tmp871_;
										gchar* _tmp872_;
										ValaCCodeIdentifier* _tmp873_;
										ValaCCodeIdentifier* _tmp874_;
										ValaCCodeFunction* _tmp875_;
										ValaCCodeFunction* _tmp876_;
										ValaCCodeMemberAccess* _tmp877_;
										ValaCCodeIdentifier* _tmp878_;
										const gchar* _tmp879_;
										const gchar* _tmp880_;
										ValaCCodeMemberAccess* _tmp881_;
										ValaCCodeMemberAccess* _tmp882_;
										ValaCCodeIdentifier* _tmp883_;
										_tmp865_ = type_param;
										_tmp866_ = vala_symbol_get_name ((ValaSymbol*) _tmp865_);
										_tmp867_ = _tmp866_;
										_tmp868_ = g_utf8_strdown (_tmp867_, (gssize) -1);
										_tmp869_ = _tmp868_;
										_tmp870_ = suffix;
										_tmp871_ = g_strdup_printf ("%s_%s", _tmp869_, _tmp870_);
										_tmp872_ = _tmp871_;
										_tmp873_ = vala_ccode_identifier_new (_tmp872_);
										_tmp874_ = _tmp873_;
										_g_free0 (_tmp872_);
										_g_free0 (_tmp869_);
										param_name = _tmp874_;
										_tmp875_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
										_tmp876_ = _tmp875_;
										_tmp877_ = priv_access;
										_tmp878_ = param_name;
										_tmp879_ = vala_ccode_identifier_get_name (_tmp878_);
										_tmp880_ = _tmp879_;
										_tmp881_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp877_, _tmp880_);
										_tmp882_ = _tmp881_;
										_tmp883_ = param_name;
										vala_ccode_function_add_assignment (_tmp876_, (ValaCCodeExpression*) _tmp882_, (ValaCCodeExpression*) _tmp883_);
										_vala_ccode_node_unref0 (_tmp882_);
										_vala_ccode_node_unref0 (param_name);
										_g_free0 (suffix);
									}
								}
							}
							_vala_ccode_node_unref0 (priv_access);
							_vala_code_node_unref0 (type_param);
						}
						_vala_iterable_unref0 (_type_param_list);
					}
					suffices = (_vala_array_free (suffices, suffices_length1, (GDestroyNotify) g_free), NULL);
				}
				_vala_ccode_node_unref0 (ccall_expr);
				ccall_expr = NULL;
			}
		}
	}
	ellipsis = FALSE;
	i = 1;
	_tmp884_ = params;
	_tmp885_ = vala_iterable_iterator ((ValaIterable*) _tmp884_);
	params_it = _tmp885_;
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp886_;
		gint _arg_size = 0;
		ValaList* _tmp887_;
		gint _tmp888_;
		gint _tmp889_;
		gint _arg_index = 0;
		_tmp886_ = vala_method_call_get_argument_list (expr);
		_arg_list = _tmp886_;
		_tmp887_ = _arg_list;
		_tmp888_ = vala_collection_get_size ((ValaCollection*) _tmp887_);
		_tmp889_ = _tmp888_;
		_arg_size = _tmp889_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp890_;
			gint _tmp891_;
			gint _tmp892_;
			ValaExpression* arg = NULL;
			ValaList* _tmp893_;
			gint _tmp894_;
			gpointer _tmp895_;
			ValaCCodeExpression* cexpr = NULL;
			ValaExpression* _tmp896_;
			ValaCCodeExpression* _tmp897_;
			ValaHashMap* carg_map = NULL;
			ValaHashMap* _tmp898_;
			ValaHashMap* _tmp899_;
			ValaIterator* _tmp900_;
			ValaHashMap* _tmp1201_;
			gint _tmp1202_;
			ValaCCodeExpression* _tmp1203_;
			gboolean _tmp1204_ = FALSE;
			ValaExpression* _tmp1205_;
			gint _tmp1225_;
			_tmp890_ = _arg_index;
			_arg_index = _tmp890_ + 1;
			_tmp891_ = _arg_index;
			_tmp892_ = _arg_size;
			if (!(_tmp891_ < _tmp892_)) {
				break;
			}
			_tmp893_ = _arg_list;
			_tmp894_ = _arg_index;
			_tmp895_ = vala_list_get (_tmp893_, _tmp894_);
			arg = (ValaExpression*) _tmp895_;
			_tmp896_ = arg;
			_tmp897_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp896_);
			cexpr = _tmp897_;
			_tmp898_ = in_arg_map;
			_tmp899_ = _vala_map_ref0 (_tmp898_);
			carg_map = _tmp899_;
			_tmp900_ = params_it;
			if (vala_iterator_next (_tmp900_)) {
				ValaParameter* param = NULL;
				ValaIterator* _tmp901_;
				gpointer _tmp902_;
				gboolean _tmp903_ = FALSE;
				ValaParameter* _tmp904_;
				gboolean _tmp905_;
				gboolean _tmp906_;
				gboolean _tmp910_;
				ValaParameter* _tmp1194_;
				gboolean _tmp1195_;
				_tmp901_ = params_it;
				_tmp902_ = vala_iterator_get (_tmp901_);
				param = (ValaParameter*) _tmp902_;
				_tmp904_ = param;
				_tmp905_ = vala_parameter_get_params_array (_tmp904_);
				_tmp906_ = _tmp905_;
				if (_tmp906_) {
					_tmp903_ = TRUE;
				} else {
					ValaParameter* _tmp907_;
					gboolean _tmp908_;
					gboolean _tmp909_;
					_tmp907_ = param;
					_tmp908_ = vala_parameter_get_ellipsis (_tmp907_);
					_tmp909_ = _tmp908_;
					_tmp903_ = _tmp909_;
				}
				ellipsis = _tmp903_;
				_tmp910_ = ellipsis;
				if (!_tmp910_) {
					ValaParameter* _tmp911_;
					ValaParameterDirection _tmp912_;
					ValaParameterDirection _tmp913_;
					ValaUnaryExpression* unary = NULL;
					ValaExpression* _tmp916_;
					ValaUnaryExpression* _tmp917_;
					gboolean _tmp918_ = FALSE;
					ValaUnaryExpression* _tmp919_;
					ValaParameter* _tmp1182_;
					gchar* _tmp1183_;
					gchar* _tmp1184_;
					gboolean _tmp1185_;
					_tmp911_ = param;
					_tmp912_ = vala_parameter_get_direction (_tmp911_);
					_tmp913_ = _tmp912_;
					if (_tmp913_ == VALA_PARAMETER_DIRECTION_OUT) {
						ValaHashMap* _tmp914_;
						ValaHashMap* _tmp915_;
						_tmp914_ = out_arg_map;
						_tmp915_ = _vala_map_ref0 (_tmp914_);
						_vala_map_unref0 (carg_map);
						carg_map = _tmp915_;
					}
					_tmp916_ = arg;
					_tmp917_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp916_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp916_) : NULL);
					unary = _tmp917_;
					_tmp919_ = unary;
					if (_tmp919_ == NULL) {
						_tmp918_ = TRUE;
					} else {
						ValaUnaryExpression* _tmp920_;
						ValaUnaryOperator _tmp921_;
						ValaUnaryOperator _tmp922_;
						_tmp920_ = unary;
						_tmp921_ = vala_unary_expression_get_operator (_tmp920_);
						_tmp922_ = _tmp921_;
						_tmp918_ = _tmp922_ != VALA_UNARY_OPERATOR_OUT;
					}
					if (_tmp918_) {
						gboolean _tmp923_ = FALSE;
						ValaParameter* _tmp924_;
						ValaParameter* _tmp1056_;
						ValaExpression* _tmp1057_;
						ValaCCodeExpression* _tmp1058_;
						ValaCCodeExpression* _tmp1059_;
						_tmp924_ = param;
						if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp924_)) {
							ValaParameter* _tmp925_;
							ValaDataType* _tmp926_;
							ValaDataType* _tmp927_;
							_tmp925_ = param;
							_tmp926_ = vala_variable_get_variable_type ((ValaVariable*) _tmp925_);
							_tmp927_ = _tmp926_;
							_tmp923_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp927_, VALA_TYPE_ARRAY_TYPE);
						} else {
							_tmp923_ = FALSE;
						}
						if (_tmp923_) {
							ValaArrayType* array_type = NULL;
							ValaParameter* _tmp928_;
							ValaDataType* _tmp929_;
							ValaDataType* _tmp930_;
							ValaArrayType* _tmp931_;
							_tmp928_ = param;
							_tmp929_ = vala_variable_get_variable_type ((ValaVariable*) _tmp928_);
							_tmp930_ = _tmp929_;
							_tmp931_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp930_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
							array_type = _tmp931_;
							{
								gint dim = 0;
								dim = 1;
								{
									gboolean _tmp932_ = FALSE;
									_tmp932_ = TRUE;
									while (TRUE) {
										gint _tmp934_;
										ValaArrayType* _tmp935_;
										gint _tmp936_;
										gint _tmp937_;
										ValaCCodeExpression* array_length_expr = NULL;
										ValaParameter* _tmp938_;
										gchar* _tmp939_;
										gchar* _tmp940_;
										gboolean _tmp941_;
										ValaHashMap* _tmp953_;
										ValaParameter* _tmp954_;
										gint _tmp955_;
										ValaCCodeExpression* _tmp956_;
										if (!_tmp932_) {
											gint _tmp933_;
											_tmp933_ = dim;
											dim = _tmp933_ + 1;
										}
										_tmp932_ = FALSE;
										_tmp934_ = dim;
										_tmp935_ = array_type;
										_tmp936_ = vala_array_type_get_rank (_tmp935_);
										_tmp937_ = _tmp936_;
										if (!(_tmp934_ <= _tmp937_)) {
											break;
										}
										array_length_expr = NULL;
										_tmp938_ = param;
										_tmp939_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp938_);
										_tmp940_ = _tmp939_;
										_tmp941_ = _tmp940_ != NULL;
										_g_free0 (_tmp940_);
										if (_tmp941_) {
											ValaExpression* _tmp942_;
											gint _tmp943_;
											ValaCCodeExpression* _tmp944_;
											ValaCCodeExpression* _tmp945_;
											ValaParameter* _tmp946_;
											gchar* _tmp947_;
											gchar* _tmp948_;
											ValaCCodeCastExpression* _tmp949_;
											_tmp942_ = arg;
											_tmp943_ = dim;
											_tmp944_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp942_, _tmp943_);
											_tmp945_ = _tmp944_;
											_tmp946_ = param;
											_tmp947_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp946_);
											_tmp948_ = _tmp947_;
											_tmp949_ = vala_ccode_cast_expression_new (_tmp945_, _tmp948_);
											_vala_ccode_node_unref0 (array_length_expr);
											array_length_expr = (ValaCCodeExpression*) _tmp949_;
											_g_free0 (_tmp948_);
											_vala_ccode_node_unref0 (_tmp945_);
										} else {
											ValaExpression* _tmp950_;
											gint _tmp951_;
											ValaCCodeExpression* _tmp952_;
											_tmp950_ = arg;
											_tmp951_ = dim;
											_tmp952_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp950_, _tmp951_);
											_vala_ccode_node_unref0 (array_length_expr);
											array_length_expr = _tmp952_;
										}
										_tmp953_ = carg_map;
										_tmp954_ = param;
										_tmp955_ = dim;
										_tmp956_ = array_length_expr;
										vala_map_set ((ValaMap*) _tmp953_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp954_) + (0.01 * _tmp955_), FALSE)), _tmp956_);
										_vala_ccode_node_unref0 (array_length_expr);
									}
								}
							}
							_vala_code_node_unref0 (array_type);
						} else {
							ValaParameter* _tmp957_;
							ValaDataType* _tmp958_;
							ValaDataType* _tmp959_;
							_tmp957_ = param;
							_tmp958_ = vala_variable_get_variable_type ((ValaVariable*) _tmp957_);
							_tmp959_ = _tmp958_;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp959_, VALA_TYPE_DELEGATE_TYPE)) {
								ValaDelegateType* deleg_type = NULL;
								ValaParameter* _tmp960_;
								ValaDataType* _tmp961_;
								ValaDataType* _tmp962_;
								ValaDelegateType* _tmp963_;
								ValaDelegate* d = NULL;
								ValaDelegateType* _tmp964_;
								ValaDelegate* _tmp965_;
								ValaDelegate* _tmp966_;
								ValaDelegate* _tmp967_;
								ValaDelegate* _tmp968_;
								gboolean _tmp969_;
								gboolean _tmp970_;
								_tmp960_ = param;
								_tmp961_ = vala_variable_get_variable_type ((ValaVariable*) _tmp960_);
								_tmp962_ = _tmp961_;
								_tmp963_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp962_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
								deleg_type = _tmp963_;
								_tmp964_ = deleg_type;
								_tmp965_ = vala_delegate_type_get_delegate_symbol (_tmp964_);
								_tmp966_ = _tmp965_;
								_tmp967_ = _vala_code_node_ref0 (_tmp966_);
								d = _tmp967_;
								_tmp968_ = d;
								_tmp969_ = vala_delegate_get_has_target (_tmp968_);
								_tmp970_ = _tmp969_;
								if (_tmp970_) {
									ValaCCodeExpression* delegate_target_destroy_notify = NULL;
									ValaCCodeExpression* delegate_target = NULL;
									ValaExpression* _tmp971_;
									ValaCCodeExpression* _tmp972_ = NULL;
									ValaCCodeExpression* _tmp973_;
									ValaCCodeExpression* _tmp974_;
									ValaParameter* _tmp975_;
									gchar* _tmp976_;
									gchar* _tmp977_;
									gboolean _tmp978_;
									_tmp971_ = arg;
									_tmp973_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp971_, &_tmp972_);
									_vala_ccode_node_unref0 (delegate_target_destroy_notify);
									delegate_target_destroy_notify = _tmp972_;
									delegate_target = _tmp973_;
									_tmp974_ = delegate_target;
									_vala_assert (_tmp974_ != NULL, "delegate_target != null");
									_tmp975_ = param;
									_tmp976_ = vala_get_ccode_type ((ValaCodeNode*) _tmp975_);
									_tmp977_ = _tmp976_;
									_tmp978_ = g_strcmp0 (_tmp977_, "GClosure*") == 0;
									_g_free0 (_tmp977_);
									if (_tmp978_) {
										ValaCCodeFunctionCall* closure_new = NULL;
										ValaCCodeIdentifier* _tmp979_;
										ValaCCodeIdentifier* _tmp980_;
										ValaCCodeFunctionCall* _tmp981_;
										ValaCCodeFunctionCall* _tmp982_;
										ValaCCodeFunctionCall* _tmp983_;
										ValaCCodeExpression* _tmp984_;
										ValaCCodeCastExpression* _tmp985_;
										ValaCCodeCastExpression* _tmp986_;
										ValaCCodeFunctionCall* _tmp987_;
										ValaCCodeExpression* _tmp988_;
										ValaCCodeFunctionCall* _tmp989_;
										ValaCCodeExpression* _tmp990_;
										ValaCCodeCastExpression* _tmp991_;
										ValaCCodeCastExpression* _tmp992_;
										ValaCCodeExpression* _tmp993_;
										ValaCCodeIdentifier* _tmp994_;
										ValaCCodeIdentifier* _tmp995_;
										ValaCCodeBinaryExpression* _tmp996_;
										ValaCCodeBinaryExpression* _tmp997_;
										ValaCCodeIdentifier* _tmp998_;
										ValaCCodeIdentifier* _tmp999_;
										ValaCCodeFunctionCall* _tmp1000_;
										ValaCCodeConditionalExpression* _tmp1001_;
										_tmp979_ = vala_ccode_identifier_new ("g_cclosure_new");
										_tmp980_ = _tmp979_;
										_tmp981_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp980_);
										_tmp982_ = _tmp981_;
										_vala_ccode_node_unref0 (_tmp980_);
										closure_new = _tmp982_;
										_tmp983_ = closure_new;
										_tmp984_ = cexpr;
										_tmp985_ = vala_ccode_cast_expression_new (_tmp984_, "GCallback");
										_tmp986_ = _tmp985_;
										vala_ccode_function_call_add_argument (_tmp983_, (ValaCCodeExpression*) _tmp986_);
										_vala_ccode_node_unref0 (_tmp986_);
										_tmp987_ = closure_new;
										_tmp988_ = delegate_target;
										vala_ccode_function_call_add_argument (_tmp987_, _tmp988_);
										_tmp989_ = closure_new;
										_tmp990_ = delegate_target_destroy_notify;
										_tmp991_ = vala_ccode_cast_expression_new (_tmp990_, "GClosureNotify");
										_tmp992_ = _tmp991_;
										vala_ccode_function_call_add_argument (_tmp989_, (ValaCCodeExpression*) _tmp992_);
										_vala_ccode_node_unref0 (_tmp992_);
										_tmp993_ = cexpr;
										_tmp994_ = vala_ccode_identifier_new ("NULL");
										_tmp995_ = _tmp994_;
										_tmp996_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, _tmp993_, (ValaCCodeExpression*) _tmp995_);
										_tmp997_ = _tmp996_;
										_tmp998_ = vala_ccode_identifier_new ("NULL");
										_tmp999_ = _tmp998_;
										_tmp1000_ = closure_new;
										_tmp1001_ = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) _tmp997_, (ValaCCodeExpression*) _tmp999_, (ValaCCodeExpression*) _tmp1000_);
										_vala_ccode_node_unref0 (cexpr);
										cexpr = (ValaCCodeExpression*) _tmp1001_;
										_vala_ccode_node_unref0 (_tmp999_);
										_vala_ccode_node_unref0 (_tmp997_);
										_vala_ccode_node_unref0 (_tmp995_);
										_vala_ccode_node_unref0 (closure_new);
									} else {
										ValaHashMap* _tmp1002_;
										ValaParameter* _tmp1003_;
										ValaCCodeExpression* _tmp1004_;
										ValaDelegateType* _tmp1005_;
										_tmp1002_ = carg_map;
										_tmp1003_ = param;
										_tmp1004_ = delegate_target;
										vala_map_set ((ValaMap*) _tmp1002_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1003_), FALSE)), _tmp1004_);
										_tmp1005_ = deleg_type;
										if (vala_data_type_is_disposable ((ValaDataType*) _tmp1005_)) {
											ValaCCodeExpression* _tmp1006_;
											ValaHashMap* _tmp1007_;
											ValaParameter* _tmp1008_;
											ValaCCodeExpression* _tmp1009_;
											_tmp1006_ = delegate_target_destroy_notify;
											_vala_assert (_tmp1006_ != NULL, "delegate_target_destroy_notify != null");
											_tmp1007_ = carg_map;
											_tmp1008_ = param;
											_tmp1009_ = delegate_target_destroy_notify;
											vala_map_set ((ValaMap*) _tmp1007_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1008_) + 0.01, FALSE)), _tmp1009_);
										}
									}
									_vala_ccode_node_unref0 (delegate_target);
									_vala_ccode_node_unref0 (delegate_target_destroy_notify);
								}
								_vala_code_node_unref0 (d);
								_vala_code_node_unref0 (deleg_type);
							} else {
								ValaParameter* _tmp1010_;
								ValaDataType* _tmp1011_;
								ValaDataType* _tmp1012_;
								_tmp1010_ = param;
								_tmp1011_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1010_);
								_tmp1012_ = _tmp1011_;
								if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1012_, VALA_TYPE_METHOD_TYPE)) {
									ValaCCodeExpression* delegate_target_destroy_notify = NULL;
									ValaHashMap* _tmp1013_;
									ValaParameter* _tmp1014_;
									ValaExpression* _tmp1015_;
									ValaCCodeExpression* _tmp1016_ = NULL;
									ValaCCodeExpression* _tmp1017_;
									ValaCCodeExpression* _tmp1018_;
									_tmp1013_ = carg_map;
									_tmp1014_ = param;
									_tmp1015_ = arg;
									_tmp1017_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1015_, &_tmp1016_);
									_vala_ccode_node_unref0 (delegate_target_destroy_notify);
									delegate_target_destroy_notify = _tmp1016_;
									_tmp1018_ = _tmp1017_;
									vala_map_set ((ValaMap*) _tmp1013_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1014_), FALSE)), _tmp1018_);
									_vala_ccode_node_unref0 (_tmp1018_);
									_vala_ccode_node_unref0 (delegate_target_destroy_notify);
								} else {
									ValaParameter* _tmp1019_;
									ValaDataType* _tmp1020_;
									ValaDataType* _tmp1021_;
									_tmp1019_ = param;
									_tmp1020_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1019_);
									_tmp1021_ = _tmp1020_;
									if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1021_, VALA_TYPE_GENERIC_TYPE)) {
										gboolean _tmp1022_ = FALSE;
										ValaMethod* _tmp1023_;
										_tmp1023_ = m;
										if (_tmp1023_ != NULL) {
											ValaMethod* _tmp1024_;
											_tmp1024_ = m;
											_tmp1022_ = vala_get_ccode_simple_generics (_tmp1024_);
										} else {
											_tmp1022_ = FALSE;
										}
										if (_tmp1022_) {
											ValaGenericType* generic_type = NULL;
											ValaParameter* _tmp1025_;
											ValaDataType* _tmp1026_;
											ValaDataType* _tmp1027_;
											ValaGenericType* _tmp1028_;
											gint type_param_index = 0;
											ValaMethod* _tmp1029_;
											ValaGenericType* _tmp1030_;
											ValaTypeParameter* _tmp1031_;
											ValaTypeParameter* _tmp1032_;
											const gchar* _tmp1033_;
											const gchar* _tmp1034_;
											ValaDataType* type_arg = NULL;
											ValaMemberAccess* _tmp1035_;
											ValaList* _tmp1036_;
											ValaList* _tmp1037_;
											gint _tmp1038_;
											gpointer _tmp1039_;
											ValaDataType* _tmp1040_;
											ValaParameter* _tmp1041_;
											ValaDataType* _tmp1042_;
											ValaDataType* _tmp1043_;
											gboolean _tmp1044_;
											gboolean _tmp1045_;
											_tmp1025_ = param;
											_tmp1026_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1025_);
											_tmp1027_ = _tmp1026_;
											_tmp1028_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1027_, VALA_TYPE_GENERIC_TYPE, ValaGenericType));
											generic_type = _tmp1028_;
											_tmp1029_ = m;
											_tmp1030_ = generic_type;
											_tmp1031_ = vala_generic_type_get_type_parameter (_tmp1030_);
											_tmp1032_ = _tmp1031_;
											_tmp1033_ = vala_symbol_get_name ((ValaSymbol*) _tmp1032_);
											_tmp1034_ = _tmp1033_;
											type_param_index = vala_method_get_type_parameter_index (_tmp1029_, _tmp1034_);
											_tmp1035_ = ma;
											_tmp1036_ = vala_member_access_get_type_arguments (_tmp1035_);
											_tmp1037_ = _tmp1036_;
											_tmp1038_ = type_param_index;
											_tmp1039_ = vala_list_get (_tmp1037_, _tmp1038_);
											_tmp1040_ = (ValaDataType*) _tmp1039_;
											_vala_iterable_unref0 (_tmp1037_);
											type_arg = _tmp1040_;
											_tmp1041_ = param;
											_tmp1042_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1041_);
											_tmp1043_ = _tmp1042_;
											_tmp1044_ = vala_data_type_get_value_owned (_tmp1043_);
											_tmp1045_ = _tmp1044_;
											if (_tmp1045_) {
												ValaDataType* _tmp1046_;
												_tmp1046_ = type_arg;
												if (vala_ccode_base_module_requires_copy ((ValaCCodeBaseModule*) self, _tmp1046_)) {
													ValaHashMap* _tmp1047_;
													ValaParameter* _tmp1048_;
													ValaDataType* _tmp1049_;
													ValaCCodeExpression* _tmp1050_;
													ValaCCodeExpression* _tmp1051_;
													_tmp1047_ = carg_map;
													_tmp1048_ = param;
													_tmp1049_ = type_arg;
													_tmp1050_ = vala_ccode_base_module_get_destroy_func_expression ((ValaCCodeBaseModule*) self, _tmp1049_, FALSE);
													_tmp1051_ = _tmp1050_;
													vala_map_set ((ValaMap*) _tmp1047_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_destroy_notify_pos ((ValaCodeNode*) _tmp1048_), FALSE)), _tmp1051_);
													_vala_ccode_node_unref0 (_tmp1051_);
												} else {
													ValaHashMap* _tmp1052_;
													ValaParameter* _tmp1053_;
													ValaCCodeConstant* _tmp1054_;
													ValaCCodeConstant* _tmp1055_;
													_tmp1052_ = carg_map;
													_tmp1053_ = param;
													_tmp1054_ = vala_ccode_constant_new ("NULL");
													_tmp1055_ = _tmp1054_;
													vala_map_set ((ValaMap*) _tmp1052_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_destroy_notify_pos ((ValaCodeNode*) _tmp1053_), FALSE)), (ValaCCodeExpression*) _tmp1055_);
													_vala_ccode_node_unref0 (_tmp1055_);
												}
											}
											_vala_code_node_unref0 (type_arg);
											_vala_code_node_unref0 (generic_type);
										}
									}
								}
							}
						}
						_tmp1056_ = param;
						_tmp1057_ = arg;
						_tmp1058_ = cexpr;
						_tmp1059_ = vala_ccode_base_module_handle_struct_argument ((ValaCCodeBaseModule*) self, _tmp1056_, _tmp1057_, _tmp1058_);
						_vala_ccode_node_unref0 (cexpr);
						cexpr = _tmp1059_;
					} else {
						ValaExpression* _tmp1060_;
						ValaLocalVariable* temp_var = NULL;
						ValaParameter* _tmp1061_;
						ValaDataType* _tmp1062_;
						ValaDataType* _tmp1063_;
						ValaParameter* _tmp1064_;
						ValaDataType* _tmp1065_;
						ValaDataType* _tmp1066_;
						gboolean _tmp1067_;
						gboolean _tmp1068_;
						ValaLocalVariable* _tmp1069_;
						ValaLocalVariable* _tmp1070_;
						ValaExpression* _tmp1071_;
						ValaLocalVariable* _tmp1072_;
						const gchar* _tmp1073_;
						const gchar* _tmp1074_;
						ValaCCodeExpression* _tmp1075_;
						ValaCCodeExpression* _tmp1076_;
						ValaExpression* _tmp1077_;
						ValaTargetValue* _tmp1078_;
						ValaTargetValue* _tmp1079_;
						ValaExpression* _tmp1080_;
						ValaDataType* _tmp1081_;
						ValaDataType* _tmp1082_;
						ValaExpression* _tmp1083_;
						ValaCCodeExpression* _tmp1084_;
						ValaCCodeExpression* _tmp1085_;
						ValaCCodeUnaryExpression* _tmp1086_;
						gboolean _tmp1087_ = FALSE;
						ValaParameter* _tmp1088_;
						_tmp1060_ = arg;
						vala_expression_set_target_value (_tmp1060_, NULL);
						_tmp1061_ = param;
						_tmp1062_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1061_);
						_tmp1063_ = _tmp1062_;
						_tmp1064_ = param;
						_tmp1065_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1064_);
						_tmp1066_ = _tmp1065_;
						_tmp1067_ = vala_data_type_get_value_owned (_tmp1066_);
						_tmp1068_ = _tmp1067_;
						_tmp1069_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1063_, _tmp1068_, NULL, TRUE);
						temp_var = _tmp1069_;
						_tmp1070_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1070_);
						_tmp1071_ = arg;
						_tmp1072_ = temp_var;
						_tmp1073_ = vala_symbol_get_name ((ValaSymbol*) _tmp1072_);
						_tmp1074_ = _tmp1073_;
						_tmp1075_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1074_);
						_tmp1076_ = _tmp1075_;
						vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, _tmp1071_, _tmp1076_);
						_vala_ccode_node_unref0 (_tmp1076_);
						_tmp1077_ = arg;
						_tmp1078_ = vala_expression_get_target_value (_tmp1077_);
						_tmp1079_ = _tmp1078_;
						_tmp1080_ = arg;
						_tmp1081_ = vala_expression_get_target_type (_tmp1080_);
						_tmp1082_ = _tmp1081_;
						vala_target_value_set_value_type (_tmp1079_, _tmp1082_);
						_tmp1083_ = arg;
						_tmp1084_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1083_);
						_tmp1085_ = _tmp1084_;
						_tmp1086_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1085_);
						_vala_ccode_node_unref0 (cexpr);
						cexpr = (ValaCCodeExpression*) _tmp1086_;
						_vala_ccode_node_unref0 (_tmp1085_);
						_tmp1088_ = param;
						if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1088_)) {
							ValaParameter* _tmp1089_;
							ValaDataType* _tmp1090_;
							ValaDataType* _tmp1091_;
							_tmp1089_ = param;
							_tmp1090_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1089_);
							_tmp1091_ = _tmp1090_;
							_tmp1087_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1091_, VALA_TYPE_ARRAY_TYPE);
						} else {
							_tmp1087_ = FALSE;
						}
						if (_tmp1087_) {
							ValaArrayType* array_type = NULL;
							ValaParameter* _tmp1092_;
							ValaDataType* _tmp1093_;
							ValaDataType* _tmp1094_;
							ValaArrayType* _tmp1095_;
							ValaDataType* array_length_type = NULL;
							ValaDataType* _tmp1096_;
							ValaDataType* _tmp1097_;
							ValaParameter* _tmp1098_;
							gchar* _tmp1099_;
							gchar* _tmp1100_;
							gboolean _tmp1101_;
							_tmp1092_ = param;
							_tmp1093_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1092_);
							_tmp1094_ = _tmp1093_;
							_tmp1095_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1094_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
							array_type = _tmp1095_;
							_tmp1096_ = ((ValaCCodeBaseModule*) self)->int_type;
							_tmp1097_ = _vala_code_node_ref0 (_tmp1096_);
							array_length_type = _tmp1097_;
							_tmp1098_ = param;
							_tmp1099_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1098_);
							_tmp1100_ = _tmp1099_;
							_tmp1101_ = _tmp1100_ != NULL;
							_g_free0 (_tmp1100_);
							if (_tmp1101_) {
								ValaParameter* _tmp1102_;
								gchar* _tmp1103_;
								gchar* _tmp1104_;
								ValaCType* _tmp1105_;
								_tmp1102_ = param;
								_tmp1103_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1102_);
								_tmp1104_ = _tmp1103_;
								_tmp1105_ = vala_ctype_new (_tmp1104_);
								_vala_code_node_unref0 (array_length_type);
								array_length_type = (ValaDataType*) _tmp1105_;
								_g_free0 (_tmp1104_);
							}
							{
								gint dim = 0;
								dim = 1;
								{
									gboolean _tmp1106_ = FALSE;
									_tmp1106_ = TRUE;
									while (TRUE) {
										gint _tmp1108_;
										ValaArrayType* _tmp1109_;
										gint _tmp1110_;
										gint _tmp1111_;
										ValaLocalVariable* temp_array_length = NULL;
										ValaDataType* _tmp1112_;
										ValaLocalVariable* _tmp1113_;
										ValaLocalVariable* _tmp1114_;
										ValaExpression* _tmp1115_;
										ValaLocalVariable* _tmp1116_;
										const gchar* _tmp1117_;
										const gchar* _tmp1118_;
										ValaCCodeExpression* _tmp1119_;
										ValaCCodeExpression* _tmp1120_;
										ValaHashMap* _tmp1121_;
										ValaParameter* _tmp1122_;
										gint _tmp1123_;
										ValaExpression* _tmp1124_;
										ValaList* _tmp1125_;
										ValaList* _tmp1126_;
										gint _tmp1127_;
										gpointer _tmp1128_;
										ValaCCodeExpression* _tmp1129_;
										ValaCCodeUnaryExpression* _tmp1130_;
										ValaCCodeUnaryExpression* _tmp1131_;
										if (!_tmp1106_) {
											gint _tmp1107_;
											_tmp1107_ = dim;
											dim = _tmp1107_ + 1;
										}
										_tmp1106_ = FALSE;
										_tmp1108_ = dim;
										_tmp1109_ = array_type;
										_tmp1110_ = vala_array_type_get_rank (_tmp1109_);
										_tmp1111_ = _tmp1110_;
										if (!(_tmp1108_ <= _tmp1111_)) {
											break;
										}
										_tmp1112_ = array_length_type;
										_tmp1113_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1112_, TRUE, NULL, FALSE);
										temp_array_length = _tmp1113_;
										_tmp1114_ = temp_array_length;
										vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1114_);
										_tmp1115_ = arg;
										_tmp1116_ = temp_array_length;
										_tmp1117_ = vala_symbol_get_name ((ValaSymbol*) _tmp1116_);
										_tmp1118_ = _tmp1117_;
										_tmp1119_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1118_);
										_tmp1120_ = _tmp1119_;
										vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, _tmp1115_, _tmp1120_);
										_vala_ccode_node_unref0 (_tmp1120_);
										_tmp1121_ = carg_map;
										_tmp1122_ = param;
										_tmp1123_ = dim;
										_tmp1124_ = arg;
										_tmp1125_ = vala_ccode_base_module_get_array_lengths ((ValaCCodeBaseModule*) self, _tmp1124_);
										_tmp1126_ = _tmp1125_;
										_tmp1127_ = dim;
										_tmp1128_ = vala_list_get (_tmp1126_, _tmp1127_ - 1);
										_tmp1129_ = (ValaCCodeExpression*) _tmp1128_;
										_tmp1130_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1129_);
										_tmp1131_ = _tmp1130_;
										vala_map_set ((ValaMap*) _tmp1121_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1122_) + (0.01 * _tmp1123_), FALSE)), (ValaCCodeExpression*) _tmp1131_);
										_vala_ccode_node_unref0 (_tmp1131_);
										_vala_ccode_node_unref0 (_tmp1129_);
										_vala_iterable_unref0 (_tmp1126_);
										_vala_code_node_unref0 (temp_array_length);
									}
								}
							}
							_vala_code_node_unref0 (array_length_type);
							_vala_code_node_unref0 (array_type);
						} else {
							ValaParameter* _tmp1132_;
							ValaDataType* _tmp1133_;
							ValaDataType* _tmp1134_;
							_tmp1132_ = param;
							_tmp1133_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1132_);
							_tmp1134_ = _tmp1133_;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1134_, VALA_TYPE_DELEGATE_TYPE)) {
								ValaDelegateType* deleg_type = NULL;
								ValaParameter* _tmp1135_;
								ValaDataType* _tmp1136_;
								ValaDataType* _tmp1137_;
								ValaDelegateType* _tmp1138_;
								ValaDelegate* d = NULL;
								ValaDelegateType* _tmp1139_;
								ValaDelegate* _tmp1140_;
								ValaDelegate* _tmp1141_;
								ValaDelegate* _tmp1142_;
								ValaDelegate* _tmp1143_;
								gboolean _tmp1144_;
								gboolean _tmp1145_;
								_tmp1135_ = param;
								_tmp1136_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1135_);
								_tmp1137_ = _tmp1136_;
								_tmp1138_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1137_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
								deleg_type = _tmp1138_;
								_tmp1139_ = deleg_type;
								_tmp1140_ = vala_delegate_type_get_delegate_symbol (_tmp1139_);
								_tmp1141_ = _tmp1140_;
								_tmp1142_ = _vala_code_node_ref0 (_tmp1141_);
								d = _tmp1142_;
								_tmp1143_ = d;
								_tmp1144_ = vala_delegate_get_has_target (_tmp1143_);
								_tmp1145_ = _tmp1144_;
								if (_tmp1145_) {
									ValaVoidType* _tmp1146_;
									ValaVoidType* _tmp1147_;
									ValaPointerType* _tmp1148_;
									ValaPointerType* _tmp1149_;
									ValaLocalVariable* _tmp1150_;
									ValaLocalVariable* _tmp1151_;
									ValaExpression* _tmp1152_;
									ValaLocalVariable* _tmp1153_;
									const gchar* _tmp1154_;
									const gchar* _tmp1155_;
									ValaCCodeExpression* _tmp1156_;
									ValaCCodeExpression* _tmp1157_;
									ValaHashMap* _tmp1158_;
									ValaParameter* _tmp1159_;
									ValaExpression* _tmp1160_;
									ValaCCodeExpression* _tmp1161_;
									ValaCCodeExpression* _tmp1162_;
									ValaCCodeUnaryExpression* _tmp1163_;
									ValaCCodeUnaryExpression* _tmp1164_;
									ValaDelegateType* _tmp1165_;
									_tmp1146_ = vala_void_type_new (NULL);
									_tmp1147_ = _tmp1146_;
									_tmp1148_ = vala_pointer_type_new ((ValaDataType*) _tmp1147_, NULL);
									_tmp1149_ = _tmp1148_;
									_tmp1150_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1149_, TRUE, NULL, TRUE);
									_vala_code_node_unref0 (temp_var);
									temp_var = _tmp1150_;
									_vala_code_node_unref0 (_tmp1149_);
									_vala_code_node_unref0 (_tmp1147_);
									_tmp1151_ = temp_var;
									vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1151_);
									_tmp1152_ = arg;
									_tmp1153_ = temp_var;
									_tmp1154_ = vala_symbol_get_name ((ValaSymbol*) _tmp1153_);
									_tmp1155_ = _tmp1154_;
									_tmp1156_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1155_);
									_tmp1157_ = _tmp1156_;
									vala_ccode_base_module_set_delegate_target ((ValaCCodeBaseModule*) self, _tmp1152_, _tmp1157_);
									_vala_ccode_node_unref0 (_tmp1157_);
									_tmp1158_ = carg_map;
									_tmp1159_ = param;
									_tmp1160_ = arg;
									_tmp1161_ = vala_ccode_base_module_get_delegate_target ((ValaCCodeBaseModule*) self, _tmp1160_);
									_tmp1162_ = _tmp1161_;
									_tmp1163_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1162_);
									_tmp1164_ = _tmp1163_;
									vala_map_set ((ValaMap*) _tmp1158_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1159_), FALSE)), (ValaCCodeExpression*) _tmp1164_);
									_vala_ccode_node_unref0 (_tmp1164_);
									_vala_ccode_node_unref0 (_tmp1162_);
									_tmp1165_ = deleg_type;
									if (vala_data_type_is_disposable ((ValaDataType*) _tmp1165_)) {
										ValaDataType* _tmp1166_;
										ValaLocalVariable* _tmp1167_;
										ValaLocalVariable* _tmp1168_;
										ValaExpression* _tmp1169_;
										ValaLocalVariable* _tmp1170_;
										const gchar* _tmp1171_;
										const gchar* _tmp1172_;
										ValaCCodeExpression* _tmp1173_;
										ValaCCodeExpression* _tmp1174_;
										ValaHashMap* _tmp1175_;
										ValaParameter* _tmp1176_;
										ValaExpression* _tmp1177_;
										ValaCCodeExpression* _tmp1178_;
										ValaCCodeExpression* _tmp1179_;
										ValaCCodeUnaryExpression* _tmp1180_;
										ValaCCodeUnaryExpression* _tmp1181_;
										_tmp1166_ = ((ValaCCodeBaseModule*) self)->gdestroynotify_type;
										_tmp1167_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1166_, TRUE, NULL, TRUE);
										_vala_code_node_unref0 (temp_var);
										temp_var = _tmp1167_;
										_tmp1168_ = temp_var;
										vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1168_);
										_tmp1169_ = arg;
										_tmp1170_ = temp_var;
										_tmp1171_ = vala_symbol_get_name ((ValaSymbol*) _tmp1170_);
										_tmp1172_ = _tmp1171_;
										_tmp1173_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1172_);
										_tmp1174_ = _tmp1173_;
										vala_ccode_base_module_set_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, _tmp1169_, _tmp1174_);
										_vala_ccode_node_unref0 (_tmp1174_);
										_tmp1175_ = carg_map;
										_tmp1176_ = param;
										_tmp1177_ = arg;
										_tmp1178_ = vala_ccode_base_module_get_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, _tmp1177_);
										_tmp1179_ = _tmp1178_;
										_tmp1180_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1179_);
										_tmp1181_ = _tmp1180_;
										vala_map_set ((ValaMap*) _tmp1175_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1176_) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp1181_);
										_vala_ccode_node_unref0 (_tmp1181_);
										_vala_ccode_node_unref0 (_tmp1179_);
									}
								}
								_vala_code_node_unref0 (d);
								_vala_code_node_unref0 (deleg_type);
							}
						}
						_vala_code_node_unref0 (temp_var);
					}
					_tmp1182_ = param;
					_tmp1183_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1182_);
					_tmp1184_ = _tmp1183_;
					_tmp1185_ = _tmp1184_ != NULL;
					_g_free0 (_tmp1184_);
					if (_tmp1185_) {
						ValaCCodeExpression* _tmp1186_;
						ValaParameter* _tmp1187_;
						gchar* _tmp1188_;
						gchar* _tmp1189_;
						ValaCCodeCastExpression* _tmp1190_;
						_tmp1186_ = cexpr;
						_tmp1187_ = param;
						_tmp1188_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1187_);
						_tmp1189_ = _tmp1188_;
						_tmp1190_ = vala_ccode_cast_expression_new (_tmp1186_, _tmp1189_);
						_vala_ccode_node_unref0 (cexpr);
						cexpr = (ValaCCodeExpression*) _tmp1190_;
						_g_free0 (_tmp1189_);
					}
					_vala_code_node_unref0 (unary);
				} else {
					ValaExpression* _tmp1191_;
					ValaCCodeExpression* _tmp1192_;
					ValaCCodeExpression* _tmp1193_;
					_tmp1191_ = arg;
					_tmp1192_ = cexpr;
					_tmp1193_ = vala_ccode_base_module_handle_struct_argument ((ValaCCodeBaseModule*) self, NULL, _tmp1191_, _tmp1192_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = _tmp1193_;
				}
				_tmp1194_ = param;
				_tmp1195_ = ellipsis;
				arg_pos = vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_pos (_tmp1194_), _tmp1195_);
				_vala_code_node_unref0 (param);
			} else {
				ValaExpression* _tmp1196_;
				ValaCCodeExpression* _tmp1197_;
				ValaCCodeExpression* _tmp1198_;
				gint _tmp1199_;
				gboolean _tmp1200_;
				_tmp1196_ = arg;
				_tmp1197_ = cexpr;
				_tmp1198_ = vala_ccode_base_module_handle_struct_argument ((ValaCCodeBaseModule*) self, NULL, _tmp1196_, _tmp1197_);
				_vala_ccode_node_unref0 (cexpr);
				cexpr = _tmp1198_;
				_tmp1199_ = i;
				_tmp1200_ = ellipsis;
				arg_pos = vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) _tmp1199_, _tmp1200_);
			}
			_tmp1201_ = carg_map;
			_tmp1202_ = arg_pos;
			_tmp1203_ = cexpr;
			vala_map_set ((ValaMap*) _tmp1201_, (gpointer) ((gintptr) _tmp1202_), _tmp1203_);
			_tmp1205_ = arg;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1205_, VALA_TYPE_NAMED_ARGUMENT)) {
				gboolean _tmp1206_;
				_tmp1206_ = ellipsis;
				_tmp1204_ = _tmp1206_;
			} else {
				_tmp1204_ = FALSE;
			}
			if (_tmp1204_) {
				ValaNamedArgument* named_arg = NULL;
				ValaExpression* _tmp1207_;
				ValaNamedArgument* _tmp1208_;
				gchar* name = NULL;
				ValaNamedArgument* _tmp1209_;
				const gchar* _tmp1210_;
				const gchar* _tmp1211_;
				gchar** _tmp1212_;
				gchar** _tmp1213_;
				gchar** _tmp1214_;
				gint _tmp1214__length1;
				gchar* _tmp1215_;
				gchar* _tmp1216_;
				ValaHashMap* _tmp1217_;
				gint _tmp1218_;
				gboolean _tmp1219_;
				const gchar* _tmp1220_;
				gchar* _tmp1221_;
				gchar* _tmp1222_;
				ValaCCodeConstant* _tmp1223_;
				ValaCCodeConstant* _tmp1224_;
				_tmp1207_ = arg;
				_tmp1208_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1207_, VALA_TYPE_NAMED_ARGUMENT, ValaNamedArgument));
				named_arg = _tmp1208_;
				_tmp1209_ = named_arg;
				_tmp1210_ = vala_named_argument_get_name (_tmp1209_);
				_tmp1211_ = _tmp1210_;
				_tmp1213_ = _tmp1212_ = g_strsplit (_tmp1211_, "_", 0);
				_tmp1214_ = _tmp1213_;
				_tmp1214__length1 = _vala_array_length (_tmp1212_);
				_tmp1215_ = _vala_g_strjoinv ("-", _tmp1214_, _vala_array_length (_tmp1212_));
				_tmp1216_ = _tmp1215_;
				_tmp1214_ = (_vala_array_free (_tmp1214_, _tmp1214__length1, (GDestroyNotify) g_free), NULL);
				name = _tmp1216_;
				_tmp1217_ = carg_map;
				_tmp1218_ = i;
				_tmp1219_ = ellipsis;
				_tmp1220_ = name;
				_tmp1221_ = g_strdup_printf ("\"%s\"", _tmp1220_);
				_tmp1222_ = _tmp1221_;
				_tmp1223_ = vala_ccode_constant_new (_tmp1222_);
				_tmp1224_ = _tmp1223_;
				vala_map_set ((ValaMap*) _tmp1217_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, _tmp1218_ - 0.1, _tmp1219_)), (ValaCCodeExpression*) _tmp1224_);
				_vala_ccode_node_unref0 (_tmp1224_);
				_g_free0 (_tmp1222_);
				_g_free0 (name);
				_vala_code_node_unref0 (named_arg);
			}
			_tmp1225_ = i;
			i = _tmp1225_ + 1;
			_vala_map_unref0 (carg_map);
			_vala_ccode_node_unref0 (cexpr);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	_tmp1226_ = params_it;
	if (vala_iterator_next (_tmp1226_)) {
		ValaParameter* param = NULL;
		ValaIterator* _tmp1227_;
		gpointer _tmp1228_;
		gboolean _tmp1229_ = FALSE;
		ValaParameter* _tmp1230_;
		gboolean _tmp1231_;
		gboolean _tmp1232_;
		_tmp1227_ = params_it;
		_tmp1228_ = vala_iterator_get (_tmp1227_);
		param = (ValaParameter*) _tmp1228_;
		_tmp1230_ = param;
		_tmp1231_ = vala_parameter_get_params_array (_tmp1230_);
		_tmp1232_ = _tmp1231_;
		if (_tmp1232_) {
			_tmp1229_ = TRUE;
		} else {
			ValaParameter* _tmp1233_;
			gboolean _tmp1234_;
			gboolean _tmp1235_;
			_tmp1233_ = param;
			_tmp1234_ = vala_parameter_get_ellipsis (_tmp1233_);
			_tmp1235_ = _tmp1234_;
			_tmp1229_ = _tmp1235_;
		}
		_vala_assert (_tmp1229_, "param.params_array || param.ellipsis");
		ellipsis = TRUE;
		_vala_code_node_unref0 (param);
	}
	_tmp1238_ = m;
	if (_tmp1238_ != NULL) {
		ValaMethod* _tmp1239_;
		ValaDataType* _tmp1240_;
		ValaDataType* _tmp1241_;
		_tmp1239_ = m;
		_tmp1240_ = vala_callable_get_return_type ((ValaCallable*) _tmp1239_);
		_tmp1241_ = _tmp1240_;
		_tmp1237_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1241_, VALA_TYPE_ARRAY_TYPE);
	} else {
		_tmp1237_ = FALSE;
	}
	if (_tmp1237_) {
		ValaCCodeFunctionCall* _tmp1242_;
		ValaCCodeFunctionCall* _tmp1243_;
		_tmp1242_ = async_call;
		_tmp1243_ = ccall;
		_tmp1236_ = _tmp1242_ != _tmp1243_;
	} else {
		_tmp1236_ = FALSE;
	}
	if (_tmp1236_) {
		ValaArrayType* array_type = NULL;
		ValaMethod* _tmp1244_;
		ValaDataType* _tmp1245_;
		ValaDataType* _tmp1246_;
		ValaArrayType* _tmp1247_;
		_tmp1244_ = m;
		_tmp1245_ = vala_callable_get_return_type ((ValaCallable*) _tmp1244_);
		_tmp1246_ = _tmp1245_;
		_tmp1247_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1246_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp1247_;
		{
			gint dim = 0;
			dim = 1;
			{
				gboolean _tmp1248_ = FALSE;
				_tmp1248_ = TRUE;
				while (TRUE) {
					gint _tmp1250_;
					ValaArrayType* _tmp1251_;
					gint _tmp1252_;
					gint _tmp1253_;
					ValaMethod* _tmp1254_;
					if (!_tmp1248_) {
						gint _tmp1249_;
						_tmp1249_ = dim;
						dim = _tmp1249_ + 1;
					}
					_tmp1248_ = FALSE;
					_tmp1250_ = dim;
					_tmp1251_ = array_type;
					_tmp1252_ = vala_array_type_get_rank (_tmp1251_);
					_tmp1253_ = _tmp1252_;
					if (!(_tmp1250_ <= _tmp1253_)) {
						break;
					}
					_tmp1254_ = m;
					if (vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp1254_)) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp1255_;
						ValaDataType* _tmp1256_;
						ValaDataType* _tmp1257_;
						ValaLocalVariable* _tmp1258_;
						ValaLocalVariable* _tmp1259_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp1260_;
						const gchar* _tmp1261_;
						const gchar* _tmp1262_;
						ValaCCodeExpression* _tmp1263_;
						ValaLocalVariable* _tmp1264_;
						ValaCCodeExpression* _tmp1265_;
						ValaCCodeExpression* _tmp1266_;
						ValaCCodeAssignment* _tmp1267_;
						ValaCCodeFunctionCall* len_call = NULL;
						ValaCCodeIdentifier* _tmp1268_;
						ValaCCodeIdentifier* _tmp1269_;
						ValaCCodeFunctionCall* _tmp1270_;
						ValaCCodeFunctionCall* _tmp1271_;
						ValaCCodeFunctionCall* _tmp1272_;
						ValaCCodeExpression* _tmp1273_;
						ValaCCodeFunctionCall* _tmp1274_;
						_tmp1255_ = itype;
						_tmp1256_ = vala_data_type_get_return_type (_tmp1255_);
						_tmp1257_ = _tmp1256_;
						_tmp1258_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1257_, TRUE, NULL, FALSE);
						_tmp1259_ = _tmp1258_;
						_vala_code_node_unref0 (_tmp1257_);
						temp_var = _tmp1259_;
						_tmp1260_ = temp_var;
						_tmp1261_ = vala_symbol_get_name ((ValaSymbol*) _tmp1260_);
						_tmp1262_ = _tmp1261_;
						_tmp1263_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1262_);
						temp_ref = _tmp1263_;
						_tmp1264_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1264_);
						_tmp1265_ = temp_ref;
						_tmp1266_ = ccall_expr;
						_tmp1267_ = vala_ccode_assignment_new (_tmp1265_, _tmp1266_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
						_vala_ccode_node_unref0 (ccall_expr);
						ccall_expr = (ValaCCodeExpression*) _tmp1267_;
						((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
						_tmp1268_ = vala_ccode_identifier_new ("_vala_array_length");
						_tmp1269_ = _tmp1268_;
						_tmp1270_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1269_);
						_tmp1271_ = _tmp1270_;
						_vala_ccode_node_unref0 (_tmp1269_);
						len_call = _tmp1271_;
						_tmp1272_ = len_call;
						_tmp1273_ = temp_ref;
						vala_ccode_function_call_add_argument (_tmp1272_, _tmp1273_);
						_tmp1274_ = len_call;
						vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1274_);
						_vala_ccode_node_unref0 (len_call);
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaMethod* _tmp1275_;
						_tmp1275_ = m;
						if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1275_)) {
							ValaLocalVariable* temp_var = NULL;
							ValaMethod* _tmp1276_;
							gchar* _tmp1277_;
							gchar* _tmp1278_;
							gboolean _tmp1279_;
							ValaCCodeExpression* temp_ref = NULL;
							ValaLocalVariable* _tmp1288_;
							const gchar* _tmp1289_;
							const gchar* _tmp1290_;
							ValaCCodeExpression* _tmp1291_;
							ValaLocalVariable* _tmp1292_;
							ValaHashMap* _tmp1293_;
							ValaMethod* _tmp1294_;
							gint _tmp1295_;
							ValaCCodeExpression* _tmp1296_;
							ValaCCodeUnaryExpression* _tmp1297_;
							ValaCCodeUnaryExpression* _tmp1298_;
							ValaCCodeExpression* _tmp1299_;
							_tmp1276_ = m;
							_tmp1277_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1276_);
							_tmp1278_ = _tmp1277_;
							_tmp1279_ = _tmp1278_ == NULL;
							_g_free0 (_tmp1278_);
							if (_tmp1279_) {
								ValaDataType* _tmp1280_;
								ValaLocalVariable* _tmp1281_;
								_tmp1280_ = ((ValaCCodeBaseModule*) self)->int_type;
								_tmp1281_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1280_, TRUE, NULL, FALSE);
								_vala_code_node_unref0 (temp_var);
								temp_var = _tmp1281_;
							} else {
								ValaMethod* _tmp1282_;
								gchar* _tmp1283_;
								gchar* _tmp1284_;
								ValaCType* _tmp1285_;
								ValaCType* _tmp1286_;
								ValaLocalVariable* _tmp1287_;
								_tmp1282_ = m;
								_tmp1283_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1282_);
								_tmp1284_ = _tmp1283_;
								_tmp1285_ = vala_ctype_new (_tmp1284_);
								_tmp1286_ = _tmp1285_;
								_tmp1287_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1286_, TRUE, NULL, FALSE);
								_vala_code_node_unref0 (temp_var);
								temp_var = _tmp1287_;
								_vala_code_node_unref0 (_tmp1286_);
								_g_free0 (_tmp1284_);
							}
							_tmp1288_ = temp_var;
							_tmp1289_ = vala_symbol_get_name ((ValaSymbol*) _tmp1288_);
							_tmp1290_ = _tmp1289_;
							_tmp1291_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1290_);
							temp_ref = _tmp1291_;
							_tmp1292_ = temp_var;
							vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1292_);
							_tmp1293_ = out_arg_map;
							_tmp1294_ = m;
							_tmp1295_ = dim;
							_tmp1296_ = temp_ref;
							_tmp1297_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1296_);
							_tmp1298_ = _tmp1297_;
							vala_map_set ((ValaMap*) _tmp1293_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1294_) + (0.01 * _tmp1295_), FALSE)), (ValaCCodeExpression*) _tmp1298_);
							_vala_ccode_node_unref0 (_tmp1298_);
							_tmp1299_ = temp_ref;
							vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1299_);
							_vala_ccode_node_unref0 (temp_ref);
							_vala_code_node_unref0 (temp_var);
						} else {
							ValaMethod* _tmp1300_;
							gchar* _tmp1301_;
							gchar* _tmp1302_;
							gboolean _tmp1303_;
							_tmp1300_ = m;
							_tmp1301_ = vala_get_ccode_array_length_expr ((ValaCodeNode*) _tmp1300_);
							_tmp1302_ = _tmp1301_;
							_tmp1303_ = _tmp1302_ != NULL;
							_g_free0 (_tmp1302_);
							if (_tmp1303_) {
								ValaMethod* _tmp1304_;
								gchar* _tmp1305_;
								gchar* _tmp1306_;
								ValaCCodeConstant* _tmp1307_;
								ValaCCodeConstant* _tmp1308_;
								_tmp1304_ = m;
								_tmp1305_ = vala_get_ccode_array_length_expr ((ValaCodeNode*) _tmp1304_);
								_tmp1306_ = _tmp1305_;
								_tmp1307_ = vala_ccode_constant_new (_tmp1306_);
								_tmp1308_ = _tmp1307_;
								vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1308_);
								_vala_ccode_node_unref0 (_tmp1308_);
								_g_free0 (_tmp1306_);
							} else {
								ValaCCodeConstant* _tmp1309_;
								ValaCCodeConstant* _tmp1310_;
								_tmp1309_ = vala_ccode_constant_new ("-1");
								_tmp1310_ = _tmp1309_;
								vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1310_);
								_vala_ccode_node_unref0 (_tmp1310_);
							}
						}
					}
				}
			}
		}
		_vala_code_node_unref0 (array_type);
	} else {
		gboolean _tmp1311_ = FALSE;
		gboolean _tmp1312_ = FALSE;
		ValaMethod* _tmp1313_;
		_tmp1313_ = m;
		if (_tmp1313_ != NULL) {
			ValaMethod* _tmp1314_;
			ValaDataType* _tmp1315_;
			ValaDataType* _tmp1316_;
			_tmp1314_ = m;
			_tmp1315_ = vala_callable_get_return_type ((ValaCallable*) _tmp1314_);
			_tmp1316_ = _tmp1315_;
			_tmp1312_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1316_, VALA_TYPE_DELEGATE_TYPE);
		} else {
			_tmp1312_ = FALSE;
		}
		if (_tmp1312_) {
			ValaCCodeFunctionCall* _tmp1317_;
			ValaCCodeFunctionCall* _tmp1318_;
			_tmp1317_ = async_call;
			_tmp1318_ = ccall;
			_tmp1311_ = _tmp1317_ != _tmp1318_;
		} else {
			_tmp1311_ = FALSE;
		}
		if (_tmp1311_) {
			ValaDelegateType* deleg_type = NULL;
			ValaMethod* _tmp1319_;
			ValaDataType* _tmp1320_;
			ValaDataType* _tmp1321_;
			ValaDelegateType* _tmp1322_;
			ValaDelegate* d = NULL;
			ValaDelegateType* _tmp1323_;
			ValaDelegate* _tmp1324_;
			ValaDelegate* _tmp1325_;
			ValaDelegate* _tmp1326_;
			ValaDelegate* _tmp1327_;
			gboolean _tmp1328_;
			gboolean _tmp1329_;
			_tmp1319_ = m;
			_tmp1320_ = vala_callable_get_return_type ((ValaCallable*) _tmp1319_);
			_tmp1321_ = _tmp1320_;
			_tmp1322_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1321_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
			deleg_type = _tmp1322_;
			_tmp1323_ = deleg_type;
			_tmp1324_ = vala_delegate_type_get_delegate_symbol (_tmp1323_);
			_tmp1325_ = _tmp1324_;
			_tmp1326_ = _vala_code_node_ref0 (_tmp1325_);
			d = _tmp1326_;
			_tmp1327_ = d;
			_tmp1328_ = vala_delegate_get_has_target (_tmp1327_);
			_tmp1329_ = _tmp1328_;
			if (_tmp1329_) {
				ValaLocalVariable* temp_var = NULL;
				ValaVoidType* _tmp1330_;
				ValaVoidType* _tmp1331_;
				ValaPointerType* _tmp1332_;
				ValaPointerType* _tmp1333_;
				ValaLocalVariable* _tmp1334_;
				ValaLocalVariable* _tmp1335_;
				ValaCCodeExpression* temp_ref = NULL;
				ValaLocalVariable* _tmp1336_;
				const gchar* _tmp1337_;
				const gchar* _tmp1338_;
				ValaCCodeExpression* _tmp1339_;
				ValaLocalVariable* _tmp1340_;
				ValaHashMap* _tmp1341_;
				ValaMethod* _tmp1342_;
				ValaCCodeExpression* _tmp1343_;
				ValaCCodeUnaryExpression* _tmp1344_;
				ValaCCodeUnaryExpression* _tmp1345_;
				ValaCCodeExpression* _tmp1346_;
				ValaDelegateType* _tmp1347_;
				_tmp1330_ = vala_void_type_new (NULL);
				_tmp1331_ = _tmp1330_;
				_tmp1332_ = vala_pointer_type_new ((ValaDataType*) _tmp1331_, NULL);
				_tmp1333_ = _tmp1332_;
				_tmp1334_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1333_, TRUE, NULL, FALSE);
				_tmp1335_ = _tmp1334_;
				_vala_code_node_unref0 (_tmp1333_);
				_vala_code_node_unref0 (_tmp1331_);
				temp_var = _tmp1335_;
				_tmp1336_ = temp_var;
				_tmp1337_ = vala_symbol_get_name ((ValaSymbol*) _tmp1336_);
				_tmp1338_ = _tmp1337_;
				_tmp1339_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1338_);
				temp_ref = _tmp1339_;
				_tmp1340_ = temp_var;
				vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1340_);
				_tmp1341_ = out_arg_map;
				_tmp1342_ = m;
				_tmp1343_ = temp_ref;
				_tmp1344_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1343_);
				_tmp1345_ = _tmp1344_;
				vala_map_set ((ValaMap*) _tmp1341_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1342_), FALSE)), (ValaCCodeExpression*) _tmp1345_);
				_vala_ccode_node_unref0 (_tmp1345_);
				_tmp1346_ = temp_ref;
				vala_ccode_base_module_set_delegate_target ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1346_);
				_tmp1347_ = deleg_type;
				if (vala_data_type_is_disposable ((ValaDataType*) _tmp1347_)) {
					ValaDataType* _tmp1348_;
					ValaLocalVariable* _tmp1349_;
					ValaLocalVariable* _tmp1350_;
					const gchar* _tmp1351_;
					const gchar* _tmp1352_;
					ValaCCodeExpression* _tmp1353_;
					ValaLocalVariable* _tmp1354_;
					ValaHashMap* _tmp1355_;
					ValaMethod* _tmp1356_;
					ValaCCodeExpression* _tmp1357_;
					ValaCCodeUnaryExpression* _tmp1358_;
					ValaCCodeUnaryExpression* _tmp1359_;
					ValaCCodeExpression* _tmp1360_;
					_tmp1348_ = ((ValaCCodeBaseModule*) self)->gdestroynotify_type;
					_tmp1349_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1348_, TRUE, NULL, FALSE);
					_vala_code_node_unref0 (temp_var);
					temp_var = _tmp1349_;
					_tmp1350_ = temp_var;
					_tmp1351_ = vala_symbol_get_name ((ValaSymbol*) _tmp1350_);
					_tmp1352_ = _tmp1351_;
					_tmp1353_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1352_);
					_vala_ccode_node_unref0 (temp_ref);
					temp_ref = _tmp1353_;
					_tmp1354_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1354_);
					_tmp1355_ = out_arg_map;
					_tmp1356_ = m;
					_tmp1357_ = temp_ref;
					_tmp1358_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1357_);
					_tmp1359_ = _tmp1358_;
					vala_map_set ((ValaMap*) _tmp1355_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1356_) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp1359_);
					_vala_ccode_node_unref0 (_tmp1359_);
					_tmp1360_ = temp_ref;
					vala_ccode_base_module_set_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1360_);
				} else {
					ValaCCodeConstant* _tmp1361_;
					ValaCCodeConstant* _tmp1362_;
					_tmp1361_ = vala_ccode_constant_new ("NULL");
					_tmp1362_ = _tmp1361_;
					vala_ccode_base_module_set_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1362_);
					_vala_ccode_node_unref0 (_tmp1362_);
				}
				_vala_ccode_node_unref0 (temp_ref);
				_vala_code_node_unref0 (temp_var);
			} else {
				ValaCCodeConstant* _tmp1363_;
				ValaCCodeConstant* _tmp1364_;
				_tmp1363_ = vala_ccode_constant_new ("NULL");
				_tmp1364_ = _tmp1363_;
				vala_ccode_base_module_set_delegate_target ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1364_);
				_vala_ccode_node_unref0 (_tmp1364_);
			}
			_vala_code_node_unref0 (d);
			_vala_code_node_unref0 (deleg_type);
		}
	}
	_tmp1366_ = deleg;
	if (_tmp1366_ != NULL) {
		ValaDelegate* _tmp1367_;
		ValaDataType* _tmp1368_;
		ValaDataType* _tmp1369_;
		_tmp1367_ = deleg;
		_tmp1368_ = vala_callable_get_return_type ((ValaCallable*) _tmp1367_);
		_tmp1369_ = _tmp1368_;
		_tmp1365_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1369_, VALA_TYPE_ARRAY_TYPE);
	} else {
		_tmp1365_ = FALSE;
	}
	if (_tmp1365_) {
		ValaArrayType* array_type = NULL;
		ValaDelegate* _tmp1370_;
		ValaDataType* _tmp1371_;
		ValaDataType* _tmp1372_;
		ValaArrayType* _tmp1373_;
		_tmp1370_ = deleg;
		_tmp1371_ = vala_callable_get_return_type ((ValaCallable*) _tmp1370_);
		_tmp1372_ = _tmp1371_;
		_tmp1373_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1372_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp1373_;
		{
			gint dim = 0;
			dim = 1;
			{
				gboolean _tmp1374_ = FALSE;
				_tmp1374_ = TRUE;
				while (TRUE) {
					gint _tmp1376_;
					ValaArrayType* _tmp1377_;
					gint _tmp1378_;
					gint _tmp1379_;
					ValaDelegate* _tmp1380_;
					if (!_tmp1374_) {
						gint _tmp1375_;
						_tmp1375_ = dim;
						dim = _tmp1375_ + 1;
					}
					_tmp1374_ = FALSE;
					_tmp1376_ = dim;
					_tmp1377_ = array_type;
					_tmp1378_ = vala_array_type_get_rank (_tmp1377_);
					_tmp1379_ = _tmp1378_;
					if (!(_tmp1376_ <= _tmp1379_)) {
						break;
					}
					_tmp1380_ = deleg;
					if (vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp1380_)) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp1381_;
						ValaDataType* _tmp1382_;
						ValaDataType* _tmp1383_;
						ValaLocalVariable* _tmp1384_;
						ValaLocalVariable* _tmp1385_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp1386_;
						const gchar* _tmp1387_;
						const gchar* _tmp1388_;
						ValaCCodeExpression* _tmp1389_;
						ValaLocalVariable* _tmp1390_;
						ValaCCodeExpression* _tmp1391_;
						ValaCCodeExpression* _tmp1392_;
						ValaCCodeAssignment* _tmp1393_;
						ValaCCodeFunctionCall* len_call = NULL;
						ValaCCodeIdentifier* _tmp1394_;
						ValaCCodeIdentifier* _tmp1395_;
						ValaCCodeFunctionCall* _tmp1396_;
						ValaCCodeFunctionCall* _tmp1397_;
						ValaCCodeFunctionCall* _tmp1398_;
						ValaCCodeExpression* _tmp1399_;
						ValaCCodeFunctionCall* _tmp1400_;
						_tmp1381_ = itype;
						_tmp1382_ = vala_data_type_get_return_type (_tmp1381_);
						_tmp1383_ = _tmp1382_;
						_tmp1384_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1383_, TRUE, NULL, FALSE);
						_tmp1385_ = _tmp1384_;
						_vala_code_node_unref0 (_tmp1383_);
						temp_var = _tmp1385_;
						_tmp1386_ = temp_var;
						_tmp1387_ = vala_symbol_get_name ((ValaSymbol*) _tmp1386_);
						_tmp1388_ = _tmp1387_;
						_tmp1389_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1388_);
						temp_ref = _tmp1389_;
						_tmp1390_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1390_);
						_tmp1391_ = temp_ref;
						_tmp1392_ = ccall_expr;
						_tmp1393_ = vala_ccode_assignment_new (_tmp1391_, _tmp1392_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
						_vala_ccode_node_unref0 (ccall_expr);
						ccall_expr = (ValaCCodeExpression*) _tmp1393_;
						((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
						_tmp1394_ = vala_ccode_identifier_new ("_vala_array_length");
						_tmp1395_ = _tmp1394_;
						_tmp1396_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1395_);
						_tmp1397_ = _tmp1396_;
						_vala_ccode_node_unref0 (_tmp1395_);
						len_call = _tmp1397_;
						_tmp1398_ = len_call;
						_tmp1399_ = temp_ref;
						vala_ccode_function_call_add_argument (_tmp1398_, _tmp1399_);
						_tmp1400_ = len_call;
						vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1400_);
						_vala_ccode_node_unref0 (len_call);
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaDelegate* _tmp1401_;
						_tmp1401_ = deleg;
						if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1401_)) {
							ValaLocalVariable* temp_var = NULL;
							ValaDataType* _tmp1402_;
							ValaLocalVariable* _tmp1403_;
							ValaCCodeExpression* temp_ref = NULL;
							ValaLocalVariable* _tmp1404_;
							const gchar* _tmp1405_;
							const gchar* _tmp1406_;
							ValaCCodeExpression* _tmp1407_;
							ValaLocalVariable* _tmp1408_;
							ValaHashMap* _tmp1409_;
							ValaDelegate* _tmp1410_;
							gint _tmp1411_;
							ValaCCodeExpression* _tmp1412_;
							ValaCCodeUnaryExpression* _tmp1413_;
							ValaCCodeUnaryExpression* _tmp1414_;
							ValaCCodeExpression* _tmp1415_;
							_tmp1402_ = ((ValaCCodeBaseModule*) self)->int_type;
							_tmp1403_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1402_, TRUE, NULL, FALSE);
							temp_var = _tmp1403_;
							_tmp1404_ = temp_var;
							_tmp1405_ = vala_symbol_get_name ((ValaSymbol*) _tmp1404_);
							_tmp1406_ = _tmp1405_;
							_tmp1407_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1406_);
							temp_ref = _tmp1407_;
							_tmp1408_ = temp_var;
							vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1408_);
							_tmp1409_ = out_arg_map;
							_tmp1410_ = deleg;
							_tmp1411_ = dim;
							_tmp1412_ = temp_ref;
							_tmp1413_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1412_);
							_tmp1414_ = _tmp1413_;
							vala_map_set ((ValaMap*) _tmp1409_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1410_) + (0.01 * _tmp1411_), FALSE)), (ValaCCodeExpression*) _tmp1414_);
							_vala_ccode_node_unref0 (_tmp1414_);
							_tmp1415_ = temp_ref;
							vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1415_);
							_vala_ccode_node_unref0 (temp_ref);
							_vala_code_node_unref0 (temp_var);
						} else {
							ValaCCodeConstant* _tmp1416_;
							ValaCCodeConstant* _tmp1417_;
							_tmp1416_ = vala_ccode_constant_new ("-1");
							_tmp1417_ = _tmp1416_;
							vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1417_);
							_vala_ccode_node_unref0 (_tmp1417_);
						}
					}
				}
			}
		}
		_vala_code_node_unref0 (array_type);
	} else {
		gboolean _tmp1418_ = FALSE;
		ValaDelegate* _tmp1419_;
		_tmp1419_ = deleg;
		if (_tmp1419_ != NULL) {
			ValaDelegate* _tmp1420_;
			ValaDataType* _tmp1421_;
			ValaDataType* _tmp1422_;
			_tmp1420_ = deleg;
			_tmp1421_ = vala_callable_get_return_type ((ValaCallable*) _tmp1420_);
			_tmp1422_ = _tmp1421_;
			_tmp1418_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1422_, VALA_TYPE_DELEGATE_TYPE);
		} else {
			_tmp1418_ = FALSE;
		}
		if (_tmp1418_) {
			ValaDelegateType* deleg_type = NULL;
			ValaDelegate* _tmp1423_;
			ValaDataType* _tmp1424_;
			ValaDataType* _tmp1425_;
			ValaDelegateType* _tmp1426_;
			ValaDelegate* d = NULL;
			ValaDelegateType* _tmp1427_;
			ValaDelegate* _tmp1428_;
			ValaDelegate* _tmp1429_;
			ValaDelegate* _tmp1430_;
			ValaDelegate* _tmp1431_;
			gboolean _tmp1432_;
			gboolean _tmp1433_;
			_tmp1423_ = deleg;
			_tmp1424_ = vala_callable_get_return_type ((ValaCallable*) _tmp1423_);
			_tmp1425_ = _tmp1424_;
			_tmp1426_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1425_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
			deleg_type = _tmp1426_;
			_tmp1427_ = deleg_type;
			_tmp1428_ = vala_delegate_type_get_delegate_symbol (_tmp1427_);
			_tmp1429_ = _tmp1428_;
			_tmp1430_ = _vala_code_node_ref0 (_tmp1429_);
			d = _tmp1430_;
			_tmp1431_ = d;
			_tmp1432_ = vala_delegate_get_has_target (_tmp1431_);
			_tmp1433_ = _tmp1432_;
			if (_tmp1433_) {
				ValaLocalVariable* temp_var = NULL;
				ValaVoidType* _tmp1434_;
				ValaVoidType* _tmp1435_;
				ValaPointerType* _tmp1436_;
				ValaPointerType* _tmp1437_;
				ValaLocalVariable* _tmp1438_;
				ValaLocalVariable* _tmp1439_;
				ValaCCodeExpression* temp_ref = NULL;
				ValaLocalVariable* _tmp1440_;
				const gchar* _tmp1441_;
				const gchar* _tmp1442_;
				ValaCCodeExpression* _tmp1443_;
				ValaLocalVariable* _tmp1444_;
				ValaHashMap* _tmp1445_;
				ValaDelegate* _tmp1446_;
				ValaCCodeExpression* _tmp1447_;
				ValaCCodeUnaryExpression* _tmp1448_;
				ValaCCodeUnaryExpression* _tmp1449_;
				ValaCCodeExpression* _tmp1450_;
				ValaDelegateType* _tmp1451_;
				_tmp1434_ = vala_void_type_new (NULL);
				_tmp1435_ = _tmp1434_;
				_tmp1436_ = vala_pointer_type_new ((ValaDataType*) _tmp1435_, NULL);
				_tmp1437_ = _tmp1436_;
				_tmp1438_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1437_, TRUE, NULL, FALSE);
				_tmp1439_ = _tmp1438_;
				_vala_code_node_unref0 (_tmp1437_);
				_vala_code_node_unref0 (_tmp1435_);
				temp_var = _tmp1439_;
				_tmp1440_ = temp_var;
				_tmp1441_ = vala_symbol_get_name ((ValaSymbol*) _tmp1440_);
				_tmp1442_ = _tmp1441_;
				_tmp1443_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1442_);
				temp_ref = _tmp1443_;
				_tmp1444_ = temp_var;
				vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1444_);
				_tmp1445_ = out_arg_map;
				_tmp1446_ = deleg;
				_tmp1447_ = temp_ref;
				_tmp1448_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1447_);
				_tmp1449_ = _tmp1448_;
				vala_map_set ((ValaMap*) _tmp1445_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1446_), FALSE)), (ValaCCodeExpression*) _tmp1449_);
				_vala_ccode_node_unref0 (_tmp1449_);
				_tmp1450_ = temp_ref;
				vala_ccode_base_module_set_delegate_target ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1450_);
				_tmp1451_ = deleg_type;
				if (vala_data_type_is_disposable ((ValaDataType*) _tmp1451_)) {
					ValaDataType* _tmp1452_;
					ValaLocalVariable* _tmp1453_;
					ValaLocalVariable* _tmp1454_;
					const gchar* _tmp1455_;
					const gchar* _tmp1456_;
					ValaCCodeExpression* _tmp1457_;
					ValaLocalVariable* _tmp1458_;
					ValaHashMap* _tmp1459_;
					ValaDelegate* _tmp1460_;
					ValaCCodeExpression* _tmp1461_;
					ValaCCodeUnaryExpression* _tmp1462_;
					ValaCCodeUnaryExpression* _tmp1463_;
					ValaCCodeExpression* _tmp1464_;
					_tmp1452_ = ((ValaCCodeBaseModule*) self)->gdestroynotify_type;
					_tmp1453_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1452_, TRUE, NULL, FALSE);
					_vala_code_node_unref0 (temp_var);
					temp_var = _tmp1453_;
					_tmp1454_ = temp_var;
					_tmp1455_ = vala_symbol_get_name ((ValaSymbol*) _tmp1454_);
					_tmp1456_ = _tmp1455_;
					_tmp1457_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1456_);
					_vala_ccode_node_unref0 (temp_ref);
					temp_ref = _tmp1457_;
					_tmp1458_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1458_);
					_tmp1459_ = out_arg_map;
					_tmp1460_ = deleg;
					_tmp1461_ = temp_ref;
					_tmp1462_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1461_);
					_tmp1463_ = _tmp1462_;
					vala_map_set ((ValaMap*) _tmp1459_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1460_) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp1463_);
					_vala_ccode_node_unref0 (_tmp1463_);
					_tmp1464_ = temp_ref;
					vala_ccode_base_module_set_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1464_);
				}
				_vala_ccode_node_unref0 (temp_ref);
				_vala_code_node_unref0 (temp_var);
			}
			_vala_code_node_unref0 (d);
			_vala_code_node_unref0 (deleg_type);
		}
	}
	_tmp1466_ = m;
	if (_tmp1466_ != NULL) {
		ValaMethod* _tmp1467_;
		gboolean _tmp1468_;
		gboolean _tmp1469_;
		_tmp1467_ = m;
		_tmp1468_ = vala_method_get_coroutine (_tmp1467_);
		_tmp1469_ = _tmp1468_;
		_tmp1465_ = _tmp1469_;
	} else {
		_tmp1465_ = FALSE;
	}
	if (_tmp1465_) {
		gboolean _tmp1470_;
		gboolean _tmp1471_;
		_tmp1470_ = vala_method_call_get_is_yield_expression (expr);
		_tmp1471_ = _tmp1470_;
		if (_tmp1471_) {
			ValaHashMap* _tmp1472_;
			ValaMethod* _tmp1473_;
			ValaMethod* _tmp1474_;
			gchar* _tmp1475_;
			gchar* _tmp1476_;
			ValaCCodeIdentifier* _tmp1477_;
			ValaCCodeIdentifier* _tmp1478_;
			ValaHashMap* _tmp1479_;
			ValaCCodeIdentifier* _tmp1480_;
			ValaCCodeIdentifier* _tmp1481_;
			_tmp1472_ = in_arg_map;
			_tmp1473_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
			_tmp1474_ = _tmp1473_;
			_tmp1475_ = vala_ccode_base_module_generate_ready_function ((ValaCCodeBaseModule*) self, _tmp1474_);
			_tmp1476_ = _tmp1475_;
			_tmp1477_ = vala_ccode_identifier_new (_tmp1476_);
			_tmp1478_ = _tmp1477_;
			vala_map_set ((ValaMap*) _tmp1472_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, FALSE)), (ValaCCodeExpression*) _tmp1478_);
			_vala_ccode_node_unref0 (_tmp1478_);
			_g_free0 (_tmp1476_);
			_tmp1479_ = in_arg_map;
			_tmp1480_ = vala_ccode_identifier_new ("_data_");
			_tmp1481_ = _tmp1480_;
			vala_map_set ((ValaMap*) _tmp1479_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, -0.9, FALSE)), (ValaCCodeExpression*) _tmp1481_);
			_vala_ccode_node_unref0 (_tmp1481_);
		}
	}
	_tmp1482_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) expr);
	_tmp1483_ = _tmp1482_;
	if (_tmp1483_) {
		ValaHashMap* _tmp1484_;
		ValaCCodeExpression* _tmp1485_;
		ValaCCodeExpression* _tmp1486_;
		ValaCCodeUnaryExpression* _tmp1487_;
		ValaCCodeUnaryExpression* _tmp1488_;
		vala_ccode_base_module_set_current_method_inner_error ((ValaCCodeBaseModule*) self, TRUE);
		_tmp1484_ = out_arg_map;
		_tmp1485_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, "_inner_error_");
		_tmp1486_ = _tmp1485_;
		_tmp1487_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1486_);
		_tmp1488_ = _tmp1487_;
		vala_map_set ((ValaMap*) _tmp1484_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, FALSE)), (ValaCCodeExpression*) _tmp1488_);
		_vala_ccode_node_unref0 (_tmp1488_);
		_vala_ccode_node_unref0 (_tmp1486_);
	}
	_tmp1489_ = ellipsis;
	if (_tmp1489_) {
		ValaMethod* _tmp1490_;
		_tmp1490_ = m;
		if (_tmp1490_ == NULL) {
			ValaHashMap* _tmp1491_;
			ValaCCodeConstant* _tmp1492_;
			ValaCCodeConstant* _tmp1493_;
			_tmp1491_ = in_arg_map;
			_tmp1492_ = vala_ccode_constant_new ("NULL");
			_tmp1493_ = _tmp1492_;
			vala_map_set ((ValaMap*) _tmp1491_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, TRUE)), (ValaCCodeExpression*) _tmp1493_);
			_vala_ccode_node_unref0 (_tmp1493_);
		} else {
			gboolean _tmp1494_ = FALSE;
			gboolean _tmp1495_ = FALSE;
			gboolean _tmp1496_ = FALSE;
			ValaMethod* _tmp1497_;
			gboolean _tmp1498_;
			gboolean _tmp1499_;
			_tmp1497_ = m;
			_tmp1498_ = vala_method_get_printf_format (_tmp1497_);
			_tmp1499_ = _tmp1498_;
			if (!_tmp1499_) {
				ValaMethod* _tmp1500_;
				gboolean _tmp1501_;
				gboolean _tmp1502_;
				_tmp1500_ = m;
				_tmp1501_ = vala_method_get_scanf_format (_tmp1500_);
				_tmp1502_ = _tmp1501_;
				_tmp1496_ = !_tmp1502_;
			} else {
				_tmp1496_ = FALSE;
			}
			if (_tmp1496_) {
				ValaMethod* _tmp1503_;
				gchar* _tmp1504_;
				gchar* _tmp1505_;
				_tmp1503_ = m;
				_tmp1504_ = vala_get_ccode_sentinel (_tmp1503_);
				_tmp1505_ = _tmp1504_;
				_tmp1495_ = g_strcmp0 (_tmp1505_, "") != 0;
				_g_free0 (_tmp1505_);
			} else {
				_tmp1495_ = FALSE;
			}
			if (_tmp1495_) {
				gboolean _tmp1506_;
				gboolean _tmp1507_;
				_tmp1506_ = vala_method_call_get_is_constructv_chainup (expr);
				_tmp1507_ = _tmp1506_;
				_tmp1494_ = !_tmp1507_;
			} else {
				_tmp1494_ = FALSE;
			}
			if (_tmp1494_) {
				ValaHashMap* _tmp1508_;
				ValaMethod* _tmp1509_;
				gchar* _tmp1510_;
				gchar* _tmp1511_;
				ValaCCodeConstant* _tmp1512_;
				ValaCCodeConstant* _tmp1513_;
				_tmp1508_ = in_arg_map;
				_tmp1509_ = m;
				_tmp1510_ = vala_get_ccode_sentinel (_tmp1509_);
				_tmp1511_ = _tmp1510_;
				_tmp1512_ = vala_ccode_constant_new (_tmp1511_);
				_tmp1513_ = _tmp1512_;
				vala_map_set ((ValaMap*) _tmp1508_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, TRUE)), (ValaCCodeExpression*) _tmp1513_);
				_vala_ccode_node_unref0 (_tmp1513_);
				_g_free0 (_tmp1511_);
			}
		}
	}
	_tmp1514_ = itype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1514_, VALA_TYPE_DELEGATE_TYPE)) {
		ValaDelegateType* deleg_type = NULL;
		ValaDataType* _tmp1515_;
		ValaDelegateType* _tmp1516_;
		ValaDelegate* d = NULL;
		ValaDelegateType* _tmp1517_;
		ValaDelegate* _tmp1518_;
		ValaDelegate* _tmp1519_;
		ValaDelegate* _tmp1520_;
		ValaDelegate* _tmp1521_;
		gboolean _tmp1522_;
		gboolean _tmp1523_;
		_tmp1515_ = itype;
		_tmp1516_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1515_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
		deleg_type = _tmp1516_;
		_tmp1517_ = deleg_type;
		_tmp1518_ = vala_delegate_type_get_delegate_symbol (_tmp1517_);
		_tmp1519_ = _tmp1518_;
		_tmp1520_ = _vala_code_node_ref0 (_tmp1519_);
		d = _tmp1520_;
		_tmp1521_ = d;
		_tmp1522_ = vala_delegate_get_has_target (_tmp1521_);
		_tmp1523_ = _tmp1522_;
		if (_tmp1523_) {
			ValaCCodeExpression* delegate_target_destroy_notify = NULL;
			ValaHashMap* _tmp1524_;
			ValaDelegate* _tmp1525_;
			ValaExpression* _tmp1526_;
			ValaExpression* _tmp1527_;
			ValaCCodeExpression* _tmp1528_ = NULL;
			ValaCCodeExpression* _tmp1529_;
			ValaCCodeExpression* _tmp1530_;
			ValaHashMap* _tmp1531_;
			ValaDelegate* _tmp1532_;
			ValaExpression* _tmp1533_;
			ValaExpression* _tmp1534_;
			ValaCCodeExpression* _tmp1535_ = NULL;
			ValaCCodeExpression* _tmp1536_;
			ValaCCodeExpression* _tmp1537_;
			_tmp1524_ = in_arg_map;
			_tmp1525_ = d;
			_tmp1526_ = vala_method_call_get_call (expr);
			_tmp1527_ = _tmp1526_;
			_tmp1529_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1527_, &_tmp1528_);
			_vala_ccode_node_unref0 (delegate_target_destroy_notify);
			delegate_target_destroy_notify = _tmp1528_;
			_tmp1530_ = _tmp1529_;
			vala_map_set ((ValaMap*) _tmp1524_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp1525_), FALSE)), _tmp1530_);
			_vala_ccode_node_unref0 (_tmp1530_);
			_tmp1531_ = out_arg_map;
			_tmp1532_ = d;
			_tmp1533_ = vala_method_call_get_call (expr);
			_tmp1534_ = _tmp1533_;
			_tmp1536_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1534_, &_tmp1535_);
			_vala_ccode_node_unref0 (delegate_target_destroy_notify);
			delegate_target_destroy_notify = _tmp1535_;
			_tmp1537_ = _tmp1536_;
			vala_map_set ((ValaMap*) _tmp1531_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp1532_), FALSE)), _tmp1537_);
			_vala_ccode_node_unref0 (_tmp1537_);
			_vala_ccode_node_unref0 (delegate_target_destroy_notify);
		}
		_vala_code_node_unref0 (d);
		_vala_code_node_unref0 (deleg_type);
	}
	_tmp1538_ = itype;
	_tmp1539_ = vala_data_type_get_return_type (_tmp1538_);
	_tmp1540_ = _tmp1539_;
	_tmp1541_ = vala_data_type_is_real_non_null_struct_type (_tmp1540_);
	_vala_code_node_unref0 (_tmp1540_);
	return_result_via_out_param = _tmp1541_;
	_tmp1543_ = itype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1543_, VALA_TYPE_SIGNAL_TYPE)) {
		ValaDataType* _tmp1544_;
		ValaDataType* _tmp1545_;
		ValaDataType* _tmp1546_;
		_tmp1544_ = itype;
		_tmp1545_ = vala_data_type_get_return_type (_tmp1544_);
		_tmp1546_ = _tmp1545_;
		_tmp1542_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1546_, VALA_TYPE_VOID_TYPE);
		_vala_code_node_unref0 (_tmp1546_);
	} else {
		_tmp1542_ = FALSE;
	}
	if (_tmp1542_) {
		ValaSignal* sig = NULL;
		ValaDataType* _tmp1547_;
		ValaSignal* _tmp1548_;
		ValaSignal* _tmp1549_;
		ValaSignal* _tmp1550_;
		gboolean _tmp1551_ = FALSE;
		gboolean _tmp1552_ = FALSE;
		ValaMemberAccess* _tmp1553_;
		_tmp1547_ = itype;
		_tmp1548_ = vala_signal_type_get_signal_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp1547_, VALA_TYPE_SIGNAL_TYPE, ValaSignalType));
		_tmp1549_ = _tmp1548_;
		_tmp1550_ = _vala_code_node_ref0 (_tmp1549_);
		sig = _tmp1550_;
		_tmp1553_ = ma;
		if (_tmp1553_ != NULL) {
			ValaMemberAccess* _tmp1554_;
			ValaExpression* _tmp1555_;
			ValaExpression* _tmp1556_;
			_tmp1554_ = ma;
			_tmp1555_ = vala_member_access_get_inner (_tmp1554_);
			_tmp1556_ = _tmp1555_;
			_tmp1552_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1556_, VALA_TYPE_BASE_ACCESS);
		} else {
			_tmp1552_ = FALSE;
		}
		if (_tmp1552_) {
			ValaSignal* _tmp1557_;
			gboolean _tmp1558_;
			gboolean _tmp1559_;
			_tmp1557_ = sig;
			_tmp1558_ = vala_signal_get_is_virtual (_tmp1557_);
			_tmp1559_ = _tmp1558_;
			_tmp1551_ = _tmp1559_;
		} else {
			_tmp1551_ = FALSE;
		}
		if (_tmp1551_) {
		} else {
			gboolean _tmp1560_ = FALSE;
			ValaSignal* _tmp1561_;
			_tmp1561_ = sig;
			if (!vala_ccode_base_module_get_signal_has_emitter ((ValaCCodeBaseModule*) self, _tmp1561_)) {
				_tmp1560_ = TRUE;
			} else {
				ValaMemberAccess* _tmp1562_;
				ValaSourceReference* _tmp1563_;
				ValaSourceReference* _tmp1564_;
				ValaSourceFile* _tmp1565_;
				ValaSourceFile* _tmp1566_;
				ValaSignal* _tmp1567_;
				ValaSourceReference* _tmp1568_;
				ValaSourceReference* _tmp1569_;
				ValaSourceFile* _tmp1570_;
				ValaSourceFile* _tmp1571_;
				_tmp1562_ = ma;
				_tmp1563_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1562_);
				_tmp1564_ = _tmp1563_;
				_tmp1565_ = vala_source_reference_get_file (_tmp1564_);
				_tmp1566_ = _tmp1565_;
				_tmp1567_ = sig;
				_tmp1568_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1567_);
				_tmp1569_ = _tmp1568_;
				_tmp1570_ = vala_source_reference_get_file (_tmp1569_);
				_tmp1571_ = _tmp1570_;
				_tmp1560_ = _tmp1566_ == _tmp1571_;
			}
			if (_tmp1560_) {
				return_result_via_out_param = TRUE;
			}
		}
		_vala_code_node_unref0 (sig);
	}
	_tmp1572_ = async_call;
	_tmp1573_ = ccall;
	if (_tmp1572_ == _tmp1573_) {
		return_result_via_out_param = FALSE;
	}
	out_param_ref = NULL;
	_tmp1574_ = return_result_via_out_param;
	if (_tmp1574_) {
		ValaLocalVariable* out_param_var = NULL;
		ValaDataType* _tmp1575_;
		ValaDataType* _tmp1576_;
		ValaDataType* _tmp1577_;
		ValaLocalVariable* _tmp1578_;
		ValaLocalVariable* _tmp1579_;
		ValaLocalVariable* _tmp1580_;
		const gchar* _tmp1581_;
		const gchar* _tmp1582_;
		ValaCCodeExpression* _tmp1583_;
		ValaLocalVariable* _tmp1584_;
		ValaHashMap* _tmp1585_;
		ValaCCodeExpression* _tmp1586_;
		ValaCCodeUnaryExpression* _tmp1587_;
		ValaCCodeUnaryExpression* _tmp1588_;
		_tmp1575_ = itype;
		_tmp1576_ = vala_data_type_get_return_type (_tmp1575_);
		_tmp1577_ = _tmp1576_;
		_tmp1578_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1577_, TRUE, NULL, TRUE);
		_tmp1579_ = _tmp1578_;
		_vala_code_node_unref0 (_tmp1577_);
		out_param_var = _tmp1579_;
		_tmp1580_ = out_param_var;
		_tmp1581_ = vala_symbol_get_name ((ValaSymbol*) _tmp1580_);
		_tmp1582_ = _tmp1581_;
		_tmp1583_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1582_);
		_vala_ccode_node_unref0 (out_param_ref);
		out_param_ref = _tmp1583_;
		_tmp1584_ = out_param_var;
		vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1584_);
		_tmp1585_ = out_arg_map;
		_tmp1586_ = out_param_ref;
		_tmp1587_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1586_);
		_tmp1588_ = _tmp1587_;
		vala_map_set ((ValaMap*) _tmp1585_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -3, FALSE)), (ValaCCodeExpression*) _tmp1588_);
		_vala_ccode_node_unref0 (_tmp1588_);
		_vala_code_node_unref0 (out_param_var);
	}
	_tmp1589_ = async_call;
	_tmp1590_ = ccall;
	if (_tmp1589_ != _tmp1590_) {
		last_pos = -1;
		while (TRUE) {
			gint _tmp1607_;
			ValaCCodeFunctionCall* _tmp1608_;
			ValaHashMap* _tmp1609_;
			gint _tmp1610_;
			gpointer _tmp1611_;
			ValaCCodeExpression* _tmp1612_;
			gint _tmp1613_;
			min_pos = -1;
			{
				ValaIterator* _pos_it = NULL;
				ValaHashMap* _tmp1591_;
				ValaSet* _tmp1592_;
				ValaSet* _tmp1593_;
				ValaIterator* _tmp1594_;
				ValaIterator* _tmp1595_;
				_tmp1591_ = out_arg_map;
				_tmp1592_ = vala_map_get_keys ((ValaMap*) _tmp1591_);
				_tmp1593_ = _tmp1592_;
				_tmp1594_ = vala_iterable_iterator ((ValaIterable*) _tmp1593_);
				_tmp1595_ = _tmp1594_;
				_vala_iterable_unref0 (_tmp1593_);
				_pos_it = _tmp1595_;
				while (TRUE) {
					ValaIterator* _tmp1596_;
					gint pos = 0;
					ValaIterator* _tmp1597_;
					gpointer _tmp1598_;
					gboolean _tmp1599_ = FALSE;
					gint _tmp1600_;
					gint _tmp1601_;
					_tmp1596_ = _pos_it;
					if (!vala_iterator_next (_tmp1596_)) {
						break;
					}
					_tmp1597_ = _pos_it;
					_tmp1598_ = vala_iterator_get (_tmp1597_);
					pos = (gint) ((gintptr) _tmp1598_);
					_tmp1600_ = pos;
					_tmp1601_ = last_pos;
					if (_tmp1600_ > _tmp1601_) {
						gboolean _tmp1602_ = FALSE;
						gint _tmp1603_;
						_tmp1603_ = min_pos;
						if (_tmp1603_ == -1) {
							_tmp1602_ = TRUE;
						} else {
							gint _tmp1604_;
							gint _tmp1605_;
							_tmp1604_ = pos;
							_tmp1605_ = min_pos;
							_tmp1602_ = _tmp1604_ < _tmp1605_;
						}
						_tmp1599_ = _tmp1602_;
					} else {
						_tmp1599_ = FALSE;
					}
					if (_tmp1599_) {
						gint _tmp1606_;
						_tmp1606_ = pos;
						min_pos = _tmp1606_;
					}
				}
				_vala_iterator_unref0 (_pos_it);
			}
			_tmp1607_ = min_pos;
			if (_tmp1607_ == -1) {
				break;
			}
			_tmp1608_ = ccall;
			_tmp1609_ = out_arg_map;
			_tmp1610_ = min_pos;
			_tmp1611_ = vala_map_get ((ValaMap*) _tmp1609_, (gpointer) ((gintptr) _tmp1610_));
			_tmp1612_ = (ValaCCodeExpression*) _tmp1611_;
			vala_ccode_function_call_add_argument (_tmp1608_, _tmp1612_);
			_vala_ccode_node_unref0 (_tmp1612_);
			_tmp1613_ = min_pos;
			last_pos = _tmp1613_;
		}
	}
	_tmp1614_ = async_call;
	if (_tmp1614_ != NULL) {
		last_pos = -1;
		while (TRUE) {
			gint _tmp1631_;
			ValaCCodeFunctionCall* _tmp1632_;
			ValaHashMap* _tmp1633_;
			gint _tmp1634_;
			gpointer _tmp1635_;
			ValaCCodeExpression* _tmp1636_;
			gint _tmp1637_;
			min_pos = -1;
			{
				ValaIterator* _pos_it = NULL;
				ValaHashMap* _tmp1615_;
				ValaSet* _tmp1616_;
				ValaSet* _tmp1617_;
				ValaIterator* _tmp1618_;
				ValaIterator* _tmp1619_;
				_tmp1615_ = in_arg_map;
				_tmp1616_ = vala_map_get_keys ((ValaMap*) _tmp1615_);
				_tmp1617_ = _tmp1616_;
				_tmp1618_ = vala_iterable_iterator ((ValaIterable*) _tmp1617_);
				_tmp1619_ = _tmp1618_;
				_vala_iterable_unref0 (_tmp1617_);
				_pos_it = _tmp1619_;
				while (TRUE) {
					ValaIterator* _tmp1620_;
					gint pos = 0;
					ValaIterator* _tmp1621_;
					gpointer _tmp1622_;
					gboolean _tmp1623_ = FALSE;
					gint _tmp1624_;
					gint _tmp1625_;
					_tmp1620_ = _pos_it;
					if (!vala_iterator_next (_tmp1620_)) {
						break;
					}
					_tmp1621_ = _pos_it;
					_tmp1622_ = vala_iterator_get (_tmp1621_);
					pos = (gint) ((gintptr) _tmp1622_);
					_tmp1624_ = pos;
					_tmp1625_ = last_pos;
					if (_tmp1624_ > _tmp1625_) {
						gboolean _tmp1626_ = FALSE;
						gint _tmp1627_;
						_tmp1627_ = min_pos;
						if (_tmp1627_ == -1) {
							_tmp1626_ = TRUE;
						} else {
							gint _tmp1628_;
							gint _tmp1629_;
							_tmp1628_ = pos;
							_tmp1629_ = min_pos;
							_tmp1626_ = _tmp1628_ < _tmp1629_;
						}
						_tmp1623_ = _tmp1626_;
					} else {
						_tmp1623_ = FALSE;
					}
					if (_tmp1623_) {
						gint _tmp1630_;
						_tmp1630_ = pos;
						min_pos = _tmp1630_;
					}
				}
				_vala_iterator_unref0 (_pos_it);
			}
			_tmp1631_ = min_pos;
			if (_tmp1631_ == -1) {
				break;
			}
			_tmp1632_ = async_call;
			_tmp1633_ = in_arg_map;
			_tmp1634_ = min_pos;
			_tmp1635_ = vala_map_get ((ValaMap*) _tmp1633_, (gpointer) ((gintptr) _tmp1634_));
			_tmp1636_ = (ValaCCodeExpression*) _tmp1635_;
			vala_ccode_function_call_add_argument (_tmp1632_, _tmp1636_);
			_vala_ccode_node_unref0 (_tmp1636_);
			_tmp1637_ = min_pos;
			last_pos = _tmp1637_;
		}
	}
	_tmp1638_ = vala_method_call_get_is_yield_expression (expr);
	_tmp1639_ = _tmp1638_;
	if (_tmp1639_) {
		gint state = 0;
		ValaCCodeBaseModuleEmitContext* _tmp1640_;
		gint _tmp1641_;
		ValaCCodeFunction* _tmp1642_;
		ValaCCodeFunction* _tmp1643_;
		ValaCCodeIdentifier* _tmp1644_;
		ValaCCodeIdentifier* _tmp1645_;
		ValaCCodeMemberAccess* _tmp1646_;
		ValaCCodeMemberAccess* _tmp1647_;
		gint _tmp1648_;
		gchar* _tmp1649_;
		gchar* _tmp1650_;
		ValaCCodeConstant* _tmp1651_;
		ValaCCodeConstant* _tmp1652_;
		ValaCCodeFunction* _tmp1653_;
		ValaCCodeFunction* _tmp1654_;
		ValaCCodeFunctionCall* _tmp1655_;
		ValaCCodeFunction* _tmp1656_;
		ValaCCodeFunction* _tmp1657_;
		ValaCCodeConstant* _tmp1658_;
		ValaCCodeConstant* _tmp1659_;
		ValaCCodeFunction* _tmp1660_;
		ValaCCodeFunction* _tmp1661_;
		gint _tmp1662_;
		gchar* _tmp1663_;
		gchar* _tmp1664_;
		_tmp1640_ = ((ValaCCodeBaseModule*) self)->emit_context;
		_tmp1641_ = _tmp1640_->next_coroutine_state;
		_tmp1640_->next_coroutine_state = _tmp1641_ + 1;
		state = _tmp1641_;
		_tmp1642_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1643_ = _tmp1642_;
		_tmp1644_ = vala_ccode_identifier_new ("_data_");
		_tmp1645_ = _tmp1644_;
		_tmp1646_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp1645_, "_state_");
		_tmp1647_ = _tmp1646_;
		_tmp1648_ = state;
		_tmp1649_ = g_strdup_printf ("%i", _tmp1648_);
		_tmp1650_ = _tmp1649_;
		_tmp1651_ = vala_ccode_constant_new (_tmp1650_);
		_tmp1652_ = _tmp1651_;
		vala_ccode_function_add_assignment (_tmp1643_, (ValaCCodeExpression*) _tmp1647_, (ValaCCodeExpression*) _tmp1652_);
		_vala_ccode_node_unref0 (_tmp1652_);
		_g_free0 (_tmp1650_);
		_vala_ccode_node_unref0 (_tmp1647_);
		_vala_ccode_node_unref0 (_tmp1645_);
		_tmp1653_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1654_ = _tmp1653_;
		_tmp1655_ = async_call;
		vala_ccode_function_add_expression (_tmp1654_, (ValaCCodeExpression*) _tmp1655_);
		_tmp1656_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1657_ = _tmp1656_;
		_tmp1658_ = vala_ccode_constant_new ("FALSE");
		_tmp1659_ = _tmp1658_;
		vala_ccode_function_add_return (_tmp1657_, (ValaCCodeExpression*) _tmp1659_);
		_vala_ccode_node_unref0 (_tmp1659_);
		_tmp1660_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1661_ = _tmp1660_;
		_tmp1662_ = state;
		_tmp1663_ = g_strdup_printf ("_state_%d", _tmp1662_);
		_tmp1664_ = _tmp1663_;
		vala_ccode_function_add_label (_tmp1661_, _tmp1664_);
		_g_free0 (_tmp1664_);
	}
	_tmp1665_ = vala_method_call_get_is_assert (expr);
	_tmp1666_ = _tmp1665_;
	if (_tmp1666_) {
		gchar* message = NULL;
		ValaSourceReference* _tmp1667_;
		ValaSourceReference* _tmp1668_;
		ValaSourceLocation _tmp1669_ = {0};
		ValaSourceLocation _tmp1670_;
		gchar* _tmp1671_;
		ValaSourceReference* _tmp1672_;
		ValaSourceReference* _tmp1673_;
		ValaSourceLocation _tmp1674_ = {0};
		ValaSourceLocation _tmp1675_;
		gchar* _tmp1676_;
		ValaSourceReference* _tmp1677_;
		ValaSourceReference* _tmp1678_;
		ValaSourceLocation _tmp1679_ = {0};
		ValaSourceLocation _tmp1680_;
		gchar* _tmp1681_;
		gchar* _tmp1682_;
		ValaCCodeFunctionCall* _tmp1683_;
		ValaCCodeIdentifier* _tmp1684_;
		ValaCCodeIdentifier* _tmp1685_;
		ValaCCodeFunctionCall* _tmp1686_;
		const gchar* _tmp1687_;
		gchar* _tmp1688_;
		gchar* _tmp1689_;
		gchar* _tmp1690_;
		gchar* _tmp1691_;
		gchar* _tmp1692_;
		gchar* _tmp1693_;
		ValaCCodeConstant* _tmp1694_;
		ValaCCodeConstant* _tmp1695_;
		_tmp1667_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1668_ = _tmp1667_;
		vala_source_reference_get_begin (_tmp1668_, &_tmp1669_);
		_tmp1670_ = _tmp1669_;
		_tmp1671_ = _tmp1670_.pos;
		_tmp1672_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1673_ = _tmp1672_;
		vala_source_reference_get_end (_tmp1673_, &_tmp1674_);
		_tmp1675_ = _tmp1674_;
		_tmp1676_ = _tmp1675_.pos;
		_tmp1677_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1678_ = _tmp1677_;
		vala_source_reference_get_begin (_tmp1678_, &_tmp1679_);
		_tmp1680_ = _tmp1679_;
		_tmp1681_ = _tmp1680_.pos;
		_tmp1682_ = string_substring ((const gchar*) _tmp1671_, (glong) 0, (glong) ((gint) (_tmp1676_ - _tmp1681_)));
		message = _tmp1682_;
		_tmp1683_ = ccall;
		_tmp1684_ = vala_ccode_identifier_new ("_vala_assert");
		_tmp1685_ = _tmp1684_;
		vala_ccode_function_call_set_call (_tmp1683_, (ValaCCodeExpression*) _tmp1685_);
		_vala_ccode_node_unref0 (_tmp1685_);
		_tmp1686_ = ccall;
		_tmp1687_ = message;
		_tmp1688_ = string_replace (_tmp1687_, "\n", " ");
		_tmp1689_ = _tmp1688_;
		_tmp1690_ = g_strescape (_tmp1689_, "");
		_tmp1691_ = _tmp1690_;
		_tmp1692_ = g_strdup_printf ("\"%s\"", _tmp1691_);
		_tmp1693_ = _tmp1692_;
		_tmp1694_ = vala_ccode_constant_new (_tmp1693_);
		_tmp1695_ = _tmp1694_;
		vala_ccode_function_call_add_argument (_tmp1686_, (ValaCCodeExpression*) _tmp1695_);
		_vala_ccode_node_unref0 (_tmp1695_);
		_g_free0 (_tmp1693_);
		_g_free0 (_tmp1691_);
		_g_free0 (_tmp1689_);
		((ValaCCodeBaseModule*) self)->requires_assert = TRUE;
		_g_free0 (message);
	}
	_tmp1696_ = return_result_via_out_param;
	if (_tmp1696_) {
		ValaCCodeFunction* _tmp1697_;
		ValaCCodeFunction* _tmp1698_;
		ValaCCodeExpression* _tmp1699_;
		ValaCCodeExpression* _tmp1700_;
		ValaCCodeExpression* _tmp1701_;
		_tmp1697_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1698_ = _tmp1697_;
		_tmp1699_ = ccall_expr;
		vala_ccode_function_add_expression (_tmp1698_, _tmp1699_);
		_tmp1700_ = out_param_ref;
		_tmp1701_ = _vala_ccode_node_ref0 (_tmp1700_);
		_vala_ccode_node_unref0 (ccall_expr);
		ccall_expr = _tmp1701_;
	}
	_tmp1704_ = m;
	if (_tmp1704_ != NULL) {
		ValaMethod* _tmp1705_;
		ValaMemberBinding _tmp1706_;
		ValaMemberBinding _tmp1707_;
		_tmp1705_ = m;
		_tmp1706_ = vala_method_get_binding (_tmp1705_);
		_tmp1707_ = _tmp1706_;
		_tmp1703_ = _tmp1707_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp1703_ = FALSE;
	}
	if (_tmp1703_) {
		ValaMethod* _tmp1708_;
		gboolean _tmp1709_;
		gboolean _tmp1710_;
		_tmp1708_ = m;
		_tmp1709_ = vala_method_get_returns_modified_pointer (_tmp1708_);
		_tmp1710_ = _tmp1709_;
		_tmp1702_ = _tmp1710_;
	} else {
		_tmp1702_ = FALSE;
	}
	if (_tmp1702_) {
		gboolean _tmp1711_ = FALSE;
		gboolean _tmp1712_ = FALSE;
		ValaMemberAccess* _tmp1713_;
		_tmp1713_ = ma;
		if (_tmp1713_ != NULL) {
			ValaMemberAccess* _tmp1714_;
			ValaExpression* _tmp1715_;
			ValaExpression* _tmp1716_;
			ValaSymbol* _tmp1717_;
			ValaSymbol* _tmp1718_;
			_tmp1714_ = ma;
			_tmp1715_ = vala_member_access_get_inner (_tmp1714_);
			_tmp1716_ = _tmp1715_;
			_tmp1717_ = vala_expression_get_symbol_reference (_tmp1716_);
			_tmp1718_ = _tmp1717_;
			_tmp1712_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1718_, VALA_TYPE_PROPERTY);
		} else {
			_tmp1712_ = FALSE;
		}
		if (_tmp1712_) {
			ValaMemberAccess* _tmp1719_;
			ValaExpression* _tmp1720_;
			ValaExpression* _tmp1721_;
			_tmp1719_ = ma;
			_tmp1720_ = vala_member_access_get_inner (_tmp1719_);
			_tmp1721_ = _tmp1720_;
			_tmp1711_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1721_, VALA_TYPE_MEMBER_ACCESS);
		} else {
			_tmp1711_ = FALSE;
		}
		if (_tmp1711_) {
			ValaProperty* prop = NULL;
			ValaMemberAccess* _tmp1722_;
			ValaExpression* _tmp1723_;
			ValaExpression* _tmp1724_;
			ValaSymbol* _tmp1725_;
			ValaSymbol* _tmp1726_;
			ValaProperty* _tmp1727_;
			ValaProperty* _tmp1728_;
			ValaMemberAccess* _tmp1729_;
			ValaExpression* _tmp1730_;
			ValaExpression* _tmp1731_;
			ValaExpression* _tmp1732_;
			ValaExpression* _tmp1733_;
			ValaDataType* _tmp1734_;
			ValaDataType* _tmp1735_;
			ValaCCodeExpression* _tmp1736_;
			ValaGLibValue* _tmp1737_;
			ValaGLibValue* _tmp1738_;
			_tmp1722_ = ma;
			_tmp1723_ = vala_member_access_get_inner (_tmp1722_);
			_tmp1724_ = _tmp1723_;
			_tmp1725_ = vala_expression_get_symbol_reference (_tmp1724_);
			_tmp1726_ = _tmp1725_;
			_tmp1727_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1726_, VALA_TYPE_PROPERTY, ValaProperty));
			prop = _tmp1727_;
			_tmp1728_ = prop;
			_tmp1729_ = ma;
			_tmp1730_ = vala_member_access_get_inner (_tmp1729_);
			_tmp1731_ = _tmp1730_;
			_tmp1732_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp1731_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp1733_ = _tmp1732_;
			_tmp1734_ = vala_expression_get_value_type ((ValaExpression*) expr);
			_tmp1735_ = _tmp1734_;
			_tmp1736_ = ccall_expr;
			_tmp1737_ = vala_glib_value_new (_tmp1735_, _tmp1736_, FALSE);
			_tmp1738_ = _tmp1737_;
			vala_ccode_base_module_store_property ((ValaCCodeBaseModule*) self, _tmp1728_, _tmp1733_, (ValaTargetValue*) _tmp1738_);
			_vala_target_value_unref0 (_tmp1738_);
			_vala_ccode_node_unref0 (ccall_expr);
			ccall_expr = NULL;
			_vala_code_node_unref0 (prop);
		} else {
			ValaCCodeExpression* _tmp1739_;
			ValaCCodeExpression* _tmp1740_;
			ValaCCodeAssignment* _tmp1741_;
			_tmp1739_ = instance;
			_tmp1740_ = ccall_expr;
			_tmp1741_ = vala_ccode_assignment_new (_tmp1739_, _tmp1740_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
			_vala_ccode_node_unref0 (ccall_expr);
			ccall_expr = (ValaCCodeExpression*) _tmp1741_;
		}
	}
	_tmp1744_ = m;
	if (_tmp1744_ != NULL) {
		ValaMethod* _tmp1745_;
		gchar* _tmp1746_;
		gchar* _tmp1747_;
		_tmp1745_ = m;
		_tmp1746_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1745_);
		_tmp1747_ = _tmp1746_;
		_tmp1743_ = _tmp1747_ != NULL;
		_g_free0 (_tmp1747_);
	} else {
		_tmp1743_ = FALSE;
	}
	if (_tmp1743_) {
		ValaMethod* _tmp1748_;
		gchar* _tmp1749_;
		gchar* _tmp1750_;
		ValaMethod* _tmp1751_;
		ValaDataType* _tmp1752_;
		ValaDataType* _tmp1753_;
		gchar* _tmp1754_;
		gchar* _tmp1755_;
		_tmp1748_ = m;
		_tmp1749_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1748_);
		_tmp1750_ = _tmp1749_;
		_tmp1751_ = m;
		_tmp1752_ = vala_callable_get_return_type ((ValaCallable*) _tmp1751_);
		_tmp1753_ = _tmp1752_;
		_tmp1754_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1753_);
		_tmp1755_ = _tmp1754_;
		_tmp1742_ = g_strcmp0 (_tmp1750_, _tmp1755_) != 0;
		_g_free0 (_tmp1755_);
		_g_free0 (_tmp1750_);
	} else {
		_tmp1742_ = FALSE;
	}
	if (_tmp1742_) {
		ValaCCodeExpression* _tmp1756_;
		ValaMethod* _tmp1757_;
		ValaDataType* _tmp1758_;
		ValaDataType* _tmp1759_;
		gchar* _tmp1760_;
		gchar* _tmp1761_;
		ValaCCodeCastExpression* _tmp1762_;
		_tmp1756_ = ccall_expr;
		_tmp1757_ = m;
		_tmp1758_ = vala_callable_get_return_type ((ValaCallable*) _tmp1757_);
		_tmp1759_ = _tmp1758_;
		_tmp1760_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1759_);
		_tmp1761_ = _tmp1760_;
		_tmp1762_ = vala_ccode_cast_expression_new (_tmp1756_, _tmp1761_);
		_vala_ccode_node_unref0 (ccall_expr);
		ccall_expr = (ValaCCodeExpression*) _tmp1762_;
		_g_free0 (_tmp1761_);
	}
	_tmp1763_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1763_, VALA_TYPE_ARRAY_RESIZE_METHOD)) {
		ValaIterator* arg_it = NULL;
		ValaList* _tmp1764_;
		ValaList* _tmp1765_;
		ValaIterator* _tmp1766_;
		ValaIterator* _tmp1767_;
		ValaIterator* _tmp1768_;
		ValaCCodeExpression* new_size = NULL;
		ValaIterator* _tmp1769_;
		gpointer _tmp1770_;
		ValaExpression* _tmp1771_;
		ValaCCodeExpression* _tmp1772_;
		ValaCCodeExpression* _tmp1773_;
		ValaLocalVariable* temp_decl = NULL;
		ValaDataType* _tmp1774_;
		ValaLocalVariable* _tmp1775_;
		ValaCCodeExpression* temp_ref = NULL;
		ValaLocalVariable* _tmp1776_;
		const gchar* _tmp1777_;
		const gchar* _tmp1778_;
		ValaCCodeExpression* _tmp1779_;
		ValaLocalVariable* _tmp1780_;
		ValaCCodeFile* _tmp1781_;
		ValaCCodeExpression* clen = NULL;
		ValaMemberAccess* _tmp1782_;
		ValaExpression* _tmp1783_;
		ValaExpression* _tmp1784_;
		ValaCCodeExpression* _tmp1785_;
		ValaCCodeExpression* celems = NULL;
		ValaMemberAccess* _tmp1786_;
		ValaExpression* _tmp1787_;
		ValaExpression* _tmp1788_;
		ValaCCodeExpression* _tmp1789_;
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp1790_;
		ValaExpression* _tmp1791_;
		ValaExpression* _tmp1792_;
		ValaDataType* _tmp1793_;
		ValaDataType* _tmp1794_;
		ValaArrayType* _tmp1795_;
		ValaCCodeIdentifier* csizeof = NULL;
		ValaArrayType* _tmp1796_;
		ValaDataType* _tmp1797_;
		ValaDataType* _tmp1798_;
		gchar* _tmp1799_;
		gchar* _tmp1800_;
		gchar* _tmp1801_;
		gchar* _tmp1802_;
		ValaCCodeIdentifier* _tmp1803_;
		ValaCCodeIdentifier* _tmp1804_;
		ValaCCodeBinaryExpression* cdelta = NULL;
		ValaCCodeExpression* _tmp1805_;
		ValaCCodeExpression* _tmp1806_;
		ValaCCodeBinaryExpression* _tmp1807_;
		ValaCCodeBinaryExpression* ccheck = NULL;
		ValaCCodeExpression* _tmp1808_;
		ValaCCodeExpression* _tmp1809_;
		ValaCCodeBinaryExpression* _tmp1810_;
		ValaCCodeFunctionCall* czero = NULL;
		ValaCCodeIdentifier* _tmp1811_;
		ValaCCodeIdentifier* _tmp1812_;
		ValaCCodeFunctionCall* _tmp1813_;
		ValaCCodeFunctionCall* _tmp1814_;
		ValaCCodeFunctionCall* _tmp1815_;
		ValaCCodeExpression* _tmp1816_;
		ValaCCodeExpression* _tmp1817_;
		ValaCCodeBinaryExpression* _tmp1818_;
		ValaCCodeBinaryExpression* _tmp1819_;
		ValaCCodeFunctionCall* _tmp1820_;
		ValaCCodeConstant* _tmp1821_;
		ValaCCodeConstant* _tmp1822_;
		ValaCCodeFunctionCall* _tmp1823_;
		ValaCCodeIdentifier* _tmp1824_;
		ValaCCodeBinaryExpression* _tmp1825_;
		ValaCCodeBinaryExpression* _tmp1826_;
		ValaCCodeBinaryExpression* _tmp1827_;
		ValaCCodeFunction* _tmp1828_;
		ValaCCodeFunction* _tmp1829_;
		ValaCCodeExpression* _tmp1830_;
		ValaCCodeExpression* _tmp1831_;
		ValaCCodeFunction* _tmp1832_;
		ValaCCodeFunction* _tmp1833_;
		ValaCCodeExpression* _tmp1834_;
		ValaCCodeFunction* _tmp1835_;
		ValaCCodeFunction* _tmp1836_;
		ValaCCodeBinaryExpression* _tmp1837_;
		ValaCCodeFunctionCall* _tmp1838_;
		ValaCCodeConstant* _tmp1839_;
		ValaCCodeConstant* _tmp1840_;
		ValaCCodeConditionalExpression* _tmp1841_;
		ValaCCodeConditionalExpression* _tmp1842_;
		ValaCCodeFunction* _tmp1843_;
		ValaCCodeFunction* _tmp1844_;
		ValaMemberAccess* _tmp1845_;
		ValaExpression* _tmp1846_;
		ValaExpression* _tmp1847_;
		ValaCCodeExpression* _tmp1848_;
		ValaCCodeExpression* _tmp1849_;
		ValaCCodeExpression* _tmp1850_;
		ValaSymbol* array_var = NULL;
		ValaMemberAccess* _tmp1851_;
		ValaExpression* _tmp1852_;
		ValaExpression* _tmp1853_;
		ValaSymbol* _tmp1854_;
		ValaSymbol* _tmp1855_;
		ValaSymbol* _tmp1856_;
		ValaLocalVariable* array_local = NULL;
		ValaSymbol* _tmp1857_;
		ValaLocalVariable* _tmp1858_;
		gboolean _tmp1859_ = FALSE;
		gboolean _tmp1860_ = FALSE;
		ValaSymbol* _tmp1861_;
		_tmp1764_ = vala_method_call_get_argument_list (expr);
		_tmp1765_ = _tmp1764_;
		_tmp1766_ = vala_iterable_iterator ((ValaIterable*) _tmp1765_);
		_tmp1767_ = _tmp1766_;
		_vala_iterable_unref0 (_tmp1765_);
		arg_it = _tmp1767_;
		_tmp1768_ = arg_it;
		vala_iterator_next (_tmp1768_);
		_tmp1769_ = arg_it;
		_tmp1770_ = vala_iterator_get (_tmp1769_);
		_tmp1771_ = (ValaExpression*) _tmp1770_;
		_tmp1772_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1771_);
		_tmp1773_ = _tmp1772_;
		_vala_code_node_unref0 (_tmp1771_);
		new_size = _tmp1773_;
		_tmp1774_ = ((ValaCCodeBaseModule*) self)->int_type;
		_tmp1775_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1774_, TRUE, NULL, FALSE);
		temp_decl = _tmp1775_;
		_tmp1776_ = temp_decl;
		_tmp1777_ = vala_symbol_get_name ((ValaSymbol*) _tmp1776_);
		_tmp1778_ = _tmp1777_;
		_tmp1779_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1778_);
		temp_ref = _tmp1779_;
		_tmp1780_ = temp_decl;
		vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1780_);
		_tmp1781_ = ((ValaCCodeBaseModule*) self)->cfile;
		vala_ccode_file_add_include (_tmp1781_, "string.h", FALSE);
		_tmp1782_ = ma;
		_tmp1783_ = vala_member_access_get_inner (_tmp1782_);
		_tmp1784_ = _tmp1783_;
		_tmp1785_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp1784_, 1);
		clen = _tmp1785_;
		_tmp1786_ = ma;
		_tmp1787_ = vala_member_access_get_inner (_tmp1786_);
		_tmp1788_ = _tmp1787_;
		_tmp1789_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1788_);
		celems = _tmp1789_;
		_tmp1790_ = ma;
		_tmp1791_ = vala_member_access_get_inner (_tmp1790_);
		_tmp1792_ = _tmp1791_;
		_tmp1793_ = vala_expression_get_value_type (_tmp1792_);
		_tmp1794_ = _tmp1793_;
		_tmp1795_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1794_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp1795_;
		_tmp1796_ = array_type;
		_tmp1797_ = vala_array_type_get_element_type (_tmp1796_);
		_tmp1798_ = _tmp1797_;
		_tmp1799_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1798_);
		_tmp1800_ = _tmp1799_;
		_tmp1801_ = g_strdup_printf ("sizeof (%s)", _tmp1800_);
		_tmp1802_ = _tmp1801_;
		_tmp1803_ = vala_ccode_identifier_new (_tmp1802_);
		_tmp1804_ = _tmp1803_;
		_g_free0 (_tmp1802_);
		_g_free0 (_tmp1800_);
		csizeof = _tmp1804_;
		_tmp1805_ = temp_ref;
		_tmp1806_ = clen;
		_tmp1807_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MINUS, _tmp1805_, _tmp1806_);
		cdelta = _tmp1807_;
		_tmp1808_ = temp_ref;
		_tmp1809_ = clen;
		_tmp1810_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_GREATER_THAN, _tmp1808_, _tmp1809_);
		ccheck = _tmp1810_;
		_tmp1811_ = vala_ccode_identifier_new ("memset");
		_tmp1812_ = _tmp1811_;
		_tmp1813_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1812_);
		_tmp1814_ = _tmp1813_;
		_vala_ccode_node_unref0 (_tmp1812_);
		czero = _tmp1814_;
		_tmp1815_ = czero;
		_tmp1816_ = celems;
		_tmp1817_ = clen;
		_tmp1818_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, _tmp1816_, _tmp1817_);
		_tmp1819_ = _tmp1818_;
		vala_ccode_function_call_add_argument (_tmp1815_, (ValaCCodeExpression*) _tmp1819_);
		_vala_ccode_node_unref0 (_tmp1819_);
		_tmp1820_ = czero;
		_tmp1821_ = vala_ccode_constant_new ("0");
		_tmp1822_ = _tmp1821_;
		vala_ccode_function_call_add_argument (_tmp1820_, (ValaCCodeExpression*) _tmp1822_);
		_vala_ccode_node_unref0 (_tmp1822_);
		_tmp1823_ = czero;
		_tmp1824_ = csizeof;
		_tmp1825_ = cdelta;
		_tmp1826_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) _tmp1824_, (ValaCCodeExpression*) _tmp1825_);
		_tmp1827_ = _tmp1826_;
		vala_ccode_function_call_add_argument (_tmp1823_, (ValaCCodeExpression*) _tmp1827_);
		_vala_ccode_node_unref0 (_tmp1827_);
		_tmp1828_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1829_ = _tmp1828_;
		_tmp1830_ = temp_ref;
		_tmp1831_ = new_size;
		vala_ccode_function_add_assignment (_tmp1829_, _tmp1830_, _tmp1831_);
		_tmp1832_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1833_ = _tmp1832_;
		_tmp1834_ = ccall_expr;
		vala_ccode_function_add_expression (_tmp1833_, _tmp1834_);
		_tmp1835_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1836_ = _tmp1835_;
		_tmp1837_ = ccheck;
		_tmp1838_ = czero;
		_tmp1839_ = vala_ccode_constant_new ("NULL");
		_tmp1840_ = _tmp1839_;
		_tmp1841_ = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) _tmp1837_, (ValaCCodeExpression*) _tmp1838_, (ValaCCodeExpression*) _tmp1840_);
		_tmp1842_ = _tmp1841_;
		vala_ccode_function_add_expression (_tmp1836_, (ValaCCodeExpression*) _tmp1842_);
		_vala_ccode_node_unref0 (_tmp1842_);
		_vala_ccode_node_unref0 (_tmp1840_);
		_tmp1843_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1844_ = _tmp1843_;
		_tmp1845_ = ma;
		_tmp1846_ = vala_member_access_get_inner (_tmp1845_);
		_tmp1847_ = _tmp1846_;
		_tmp1848_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp1847_, 1);
		_tmp1849_ = _tmp1848_;
		_tmp1850_ = temp_ref;
		vala_ccode_function_add_assignment (_tmp1844_, _tmp1849_, _tmp1850_);
		_vala_ccode_node_unref0 (_tmp1849_);
		_tmp1851_ = ma;
		_tmp1852_ = vala_member_access_get_inner (_tmp1851_);
		_tmp1853_ = _tmp1852_;
		_tmp1854_ = vala_expression_get_symbol_reference (_tmp1853_);
		_tmp1855_ = _tmp1854_;
		_tmp1856_ = _vala_code_node_ref0 (_tmp1855_);
		array_var = _tmp1856_;
		_tmp1857_ = array_var;
		_tmp1858_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1857_, VALA_TYPE_LOCAL_VARIABLE) ? ((ValaLocalVariable*) _tmp1857_) : NULL);
		array_local = _tmp1858_;
		_tmp1861_ = array_var;
		if (_tmp1861_ != NULL) {
			ValaSymbol* _tmp1862_;
			_tmp1862_ = array_var;
			_tmp1860_ = vala_symbol_is_internal_symbol (_tmp1862_);
		} else {
			_tmp1860_ = FALSE;
		}
		if (_tmp1860_) {
			gboolean _tmp1863_ = FALSE;
			gboolean _tmp1864_ = FALSE;
			ValaSymbol* _tmp1865_;
			_tmp1865_ = array_var;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1865_, VALA_TYPE_LOCAL_VARIABLE)) {
				ValaLocalVariable* _tmp1866_;
				gboolean _tmp1867_;
				gboolean _tmp1868_;
				_tmp1866_ = array_local;
				_tmp1867_ = vala_local_variable_get_captured (_tmp1866_);
				_tmp1868_ = _tmp1867_;
				_tmp1864_ = !_tmp1868_;
			} else {
				_tmp1864_ = FALSE;
			}
			if (_tmp1864_) {
				_tmp1863_ = TRUE;
			} else {
				ValaSymbol* _tmp1869_;
				_tmp1869_ = array_var;
				_tmp1863_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1869_, VALA_TYPE_FIELD);
			}
			_tmp1859_ = _tmp1863_;
		} else {
			_tmp1859_ = FALSE;
		}
		if (_tmp1859_) {
			ValaCCodeFunction* _tmp1870_;
			ValaCCodeFunction* _tmp1871_;
			ValaMemberAccess* _tmp1872_;
			ValaExpression* _tmp1873_;
			ValaExpression* _tmp1874_;
			ValaTargetValue* _tmp1875_;
			ValaTargetValue* _tmp1876_;
			ValaCCodeExpression* _tmp1877_;
			ValaCCodeExpression* _tmp1878_;
			ValaCCodeExpression* _tmp1879_;
			_tmp1870_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp1871_ = _tmp1870_;
			_tmp1872_ = ma;
			_tmp1873_ = vala_member_access_get_inner (_tmp1872_);
			_tmp1874_ = _tmp1873_;
			_tmp1875_ = vala_expression_get_target_value (_tmp1874_);
			_tmp1876_ = _tmp1875_;
			_tmp1877_ = vala_ccode_base_module_get_array_size_cvalue ((ValaCCodeBaseModule*) self, _tmp1876_);
			_tmp1878_ = _tmp1877_;
			_tmp1879_ = temp_ref;
			vala_ccode_function_add_assignment (_tmp1871_, _tmp1878_, _tmp1879_);
			_vala_ccode_node_unref0 (_tmp1878_);
		}
		_vala_code_node_unref0 (array_local);
		_vala_code_node_unref0 (array_var);
		_vala_ccode_node_unref0 (czero);
		_vala_ccode_node_unref0 (ccheck);
		_vala_ccode_node_unref0 (cdelta);
		_vala_ccode_node_unref0 (csizeof);
		_vala_code_node_unref0 (array_type);
		_vala_ccode_node_unref0 (celems);
		_vala_ccode_node_unref0 (clen);
		_vala_ccode_node_unref0 (temp_ref);
		_vala_code_node_unref0 (temp_decl);
		_vala_ccode_node_unref0 (new_size);
		_vala_iterator_unref0 (arg_it);
		_vala_ccode_node_unref0 (out_param_ref);
		_vala_iterator_unref0 (params_it);
		_vala_ccode_node_unref0 (instance);
		_vala_ccode_node_unref0 (ccall_expr);
		_vala_map_unref0 (out_arg_map);
		_vala_map_unref0 (in_arg_map);
		_vala_code_node_unref0 (itype);
		_vala_code_node_unref0 (ma);
		_vala_iterable_unref0 (params);
		_vala_code_node_unref0 (deleg);
		_vala_code_node_unref0 (m);
		_vala_ccode_node_unref0 (finish_call);
		_vala_ccode_node_unref0 (async_call);
		_vala_ccode_node_unref0 (ccall);
		return;
	}
	_tmp1881_ = vala_code_node_get_parent_node ((ValaCodeNode*) expr);
	_tmp1882_ = _tmp1881_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1882_, VALA_TYPE_EXPRESSION_STATEMENT)) {
		ValaDataType* _tmp1883_;
		ValaDataType* _tmp1884_;
		_tmp1883_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp1884_ = _tmp1883_;
		_tmp1880_ = !vala_data_type_is_disposable (_tmp1884_);
	} else {
		_tmp1880_ = FALSE;
	}
	if (_tmp1880_) {
		gboolean _tmp1885_ = FALSE;
		ValaCCodeExpression* _tmp1886_;
		_tmp1886_ = ccall_expr;
		if (_tmp1886_ != NULL) {
			gboolean _tmp1887_;
			_tmp1887_ = return_result_via_out_param;
			_tmp1885_ = !_tmp1887_;
		} else {
			_tmp1885_ = FALSE;
		}
		if (_tmp1885_) {
			ValaCCodeFunction* _tmp1888_;
			ValaCCodeFunction* _tmp1889_;
			ValaCCodeExpression* _tmp1890_;
			_tmp1888_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp1889_ = _tmp1888_;
			_tmp1890_ = ccall_expr;
			vala_ccode_function_add_expression (_tmp1889_, _tmp1890_);
		}
	} else {
		ValaDataType* result_type = NULL;
		ValaDataType* _tmp1891_;
		ValaDataType* _tmp1892_;
		gboolean _tmp1893_ = FALSE;
		ValaDataType* _tmp1894_;
		ValaDataType* _tmp1895_;
		gboolean _tmp1922_ = FALSE;
		ValaMethod* _tmp1923_;
		_tmp1891_ = itype;
		_tmp1892_ = vala_data_type_get_return_type (_tmp1891_);
		result_type = _tmp1892_;
		_tmp1894_ = vala_expression_get_formal_value_type ((ValaExpression*) expr);
		_tmp1895_ = _tmp1894_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1895_, VALA_TYPE_GENERIC_TYPE)) {
			ValaDataType* _tmp1896_;
			ValaDataType* _tmp1897_;
			_tmp1896_ = vala_expression_get_value_type ((ValaExpression*) expr);
			_tmp1897_ = _tmp1896_;
			_tmp1893_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1897_, VALA_TYPE_GENERIC_TYPE);
		} else {
			_tmp1893_ = FALSE;
		}
		if (_tmp1893_) {
			ValaTypeParameter* type_parameter = NULL;
			ValaDataType* _tmp1898_;
			ValaDataType* _tmp1899_;
			ValaTypeParameter* _tmp1900_;
			ValaTypeParameter* _tmp1901_;
			ValaTypeParameter* _tmp1902_;
			ValaStruct* st = NULL;
			ValaTypeParameter* _tmp1903_;
			ValaSymbol* _tmp1904_;
			ValaSymbol* _tmp1905_;
			ValaSymbol* _tmp1906_;
			ValaSymbol* _tmp1907_;
			ValaStruct* _tmp1908_;
			gboolean _tmp1909_ = FALSE;
			ValaTypeParameter* _tmp1910_;
			ValaSymbol* _tmp1911_;
			ValaSymbol* _tmp1912_;
			ValaTypeSymbol* _tmp1913_;
			_tmp1898_ = vala_expression_get_formal_value_type ((ValaExpression*) expr);
			_tmp1899_ = _tmp1898_;
			_tmp1900_ = vala_generic_type_get_type_parameter (G_TYPE_CHECK_INSTANCE_CAST (_tmp1899_, VALA_TYPE_GENERIC_TYPE, ValaGenericType));
			_tmp1901_ = _tmp1900_;
			_tmp1902_ = _vala_code_node_ref0 (_tmp1901_);
			type_parameter = _tmp1902_;
			_tmp1903_ = type_parameter;
			_tmp1904_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1903_);
			_tmp1905_ = _tmp1904_;
			_tmp1906_ = vala_symbol_get_parent_symbol (_tmp1905_);
			_tmp1907_ = _tmp1906_;
			_tmp1908_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1907_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp1907_) : NULL);
			st = _tmp1908_;
			_tmp1910_ = type_parameter;
			_tmp1911_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1910_);
			_tmp1912_ = _tmp1911_;
			_tmp1913_ = ((ValaCCodeBaseModule*) self)->garray_type;
			if (_tmp1912_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1913_, VALA_TYPE_SYMBOL, ValaSymbol)) {
				_tmp1909_ = TRUE;
			} else {
				gboolean _tmp1914_ = FALSE;
				ValaStruct* _tmp1915_;
				_tmp1915_ = st;
				if (_tmp1915_ != NULL) {
					ValaStruct* _tmp1916_;
					gchar* _tmp1917_;
					gchar* _tmp1918_;
					_tmp1916_ = st;
					_tmp1917_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1916_);
					_tmp1918_ = _tmp1917_;
					_tmp1914_ = g_strcmp0 (_tmp1918_, "va_list") == 0;
					_g_free0 (_tmp1918_);
				} else {
					_tmp1914_ = FALSE;
				}
				_tmp1909_ = _tmp1914_;
			}
			if (_tmp1909_) {
				ValaDataType* _tmp1919_;
				ValaDataType* _tmp1920_;
				ValaDataType* _tmp1921_;
				_tmp1919_ = vala_expression_get_value_type ((ValaExpression*) expr);
				_tmp1920_ = _tmp1919_;
				_tmp1921_ = _vala_code_node_ref0 (_tmp1920_);
				_vala_code_node_unref0 (result_type);
				result_type = _tmp1921_;
			}
			_vala_code_node_unref0 (st);
			_vala_code_node_unref0 (type_parameter);
		}
		_tmp1923_ = m;
		if (_tmp1923_ != NULL) {
			ValaMethod* _tmp1924_;
			_tmp1924_ = m;
			_tmp1922_ = vala_method_get_format_arg_index (_tmp1924_) >= 0;
		} else {
			_tmp1922_ = FALSE;
		}
		if (_tmp1922_) {
			ValaCCodeExpression* _tmp1925_;
			_tmp1925_ = ccall_expr;
			vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1925_);
		} else {
			gboolean _tmp1926_ = FALSE;
			ValaMethod* _tmp1927_;
			_tmp1927_ = m;
			if (_tmp1927_ != NULL) {
				ValaMethod* _tmp1928_;
				_tmp1928_ = m;
				_tmp1926_ = vala_code_node_get_attribute_bool ((ValaCodeNode*) _tmp1928_, "CCode", "use_inplace", FALSE);
			} else {
				_tmp1926_ = FALSE;
			}
			if (_tmp1926_) {
				ValaCCodeExpression* _tmp1929_;
				_tmp1929_ = ccall_expr;
				vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1929_);
			} else {
				gboolean _tmp1930_ = FALSE;
				gboolean _tmp1931_ = FALSE;
				gboolean _tmp1932_;
				_tmp1932_ = return_result_via_out_param;
				if (!_tmp1932_) {
					gboolean _tmp1933_ = FALSE;
					gboolean _tmp1934_ = FALSE;
					ValaMethod* _tmp1935_;
					_tmp1935_ = m;
					if (_tmp1935_ != NULL) {
						ValaMethod* _tmp1936_;
						_tmp1936_ = m;
						_tmp1934_ = !vala_ccode_method_call_module_has_ref_out_param (self, (ValaCallable*) _tmp1936_);
					} else {
						_tmp1934_ = FALSE;
					}
					if (_tmp1934_) {
						_tmp1933_ = TRUE;
					} else {
						gboolean _tmp1937_ = FALSE;
						ValaDelegate* _tmp1938_;
						_tmp1938_ = deleg;
						if (_tmp1938_ != NULL) {
							ValaDelegate* _tmp1939_;
							_tmp1939_ = deleg;
							_tmp1937_ = !vala_ccode_method_call_module_has_ref_out_param (self, (ValaCallable*) _tmp1939_);
						} else {
							_tmp1937_ = FALSE;
						}
						_tmp1933_ = _tmp1937_;
					}
					_tmp1931_ = _tmp1933_;
				} else {
					_tmp1931_ = FALSE;
				}
				if (_tmp1931_) {
					gboolean _tmp1940_ = FALSE;
					ValaDataType* _tmp1941_;
					_tmp1941_ = result_type;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1941_, VALA_TYPE_VALUE_TYPE)) {
						ValaDataType* _tmp1942_;
						_tmp1942_ = result_type;
						_tmp1940_ = !vala_data_type_is_disposable (_tmp1942_);
					} else {
						_tmp1940_ = FALSE;
					}
					_tmp1930_ = _tmp1940_;
				} else {
					_tmp1930_ = FALSE;
				}
				if (_tmp1930_) {
					ValaCCodeExpression* _tmp1943_;
					_tmp1943_ = ccall_expr;
					vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1943_);
				} else {
					gboolean _tmp1944_;
					_tmp1944_ = return_result_via_out_param;
					if (!_tmp1944_) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp1945_;
						ValaDataType* _tmp1946_;
						gboolean _tmp1947_;
						gboolean _tmp1948_;
						ValaLocalVariable* _tmp1949_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp1950_;
						const gchar* _tmp1951_;
						const gchar* _tmp1952_;
						ValaCCodeExpression* _tmp1953_;
						ValaLocalVariable* _tmp1954_;
						ValaCCodeFunction* _tmp1955_;
						ValaCCodeFunction* _tmp1956_;
						ValaCCodeExpression* _tmp1957_;
						ValaCCodeExpression* _tmp1958_;
						ValaCCodeExpression* _tmp1959_;
						ValaTargetValue* _tmp1960_;
						ValaTargetValue* _tmp1961_;
						_tmp1945_ = result_type;
						_tmp1946_ = result_type;
						_tmp1947_ = vala_data_type_get_value_owned (_tmp1946_);
						_tmp1948_ = _tmp1947_;
						_tmp1949_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1945_, _tmp1948_, NULL, FALSE);
						temp_var = _tmp1949_;
						_tmp1950_ = temp_var;
						_tmp1951_ = vala_symbol_get_name ((ValaSymbol*) _tmp1950_);
						_tmp1952_ = _tmp1951_;
						_tmp1953_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1952_);
						temp_ref = _tmp1953_;
						_tmp1954_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1954_);
						_tmp1955_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
						_tmp1956_ = _tmp1955_;
						_tmp1957_ = temp_ref;
						_tmp1958_ = ccall_expr;
						vala_ccode_function_add_assignment (_tmp1956_, _tmp1957_, _tmp1958_);
						_tmp1959_ = temp_ref;
						vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1959_);
						_tmp1960_ = vala_expression_get_target_value ((ValaExpression*) expr);
						_tmp1961_ = _tmp1960_;
						G_TYPE_CHECK_INSTANCE_CAST (_tmp1961_, VALA_TYPE_GLIB_VALUE, ValaGLibValue)->lvalue = TRUE;
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaCCodeExpression* _tmp1962_;
						ValaTargetValue* _tmp1963_;
						ValaTargetValue* _tmp1964_;
						_tmp1962_ = ccall_expr;
						vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1962_);
						_tmp1963_ = vala_expression_get_target_value ((ValaExpression*) expr);
						_tmp1964_ = _tmp1963_;
						G_TYPE_CHECK_INSTANCE_CAST (_tmp1964_, VALA_TYPE_GLIB_VALUE, ValaGLibValue)->lvalue = TRUE;
					}
				}
			}
		}
		_vala_code_node_unref0 (result_type);
	}
	_tmp1965_ = params;
	_tmp1966_ = vala_iterable_iterator ((ValaIterable*) _tmp1965_);
	_vala_iterator_unref0 (params_it);
	params_it = _tmp1966_;
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp1967_;
		gint _arg_size = 0;
		ValaList* _tmp1968_;
		gint _tmp1969_;
		gint _tmp1970_;
		gint _arg_index = 0;
		_tmp1967_ = vala_method_call_get_argument_list (expr);
		_arg_list = _tmp1967_;
		_tmp1968_ = _arg_list;
		_tmp1969_ = vala_collection_get_size ((ValaCollection*) _tmp1968_);
		_tmp1970_ = _tmp1969_;
		_arg_size = _tmp1970_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp1971_;
			gint _tmp1972_;
			gint _tmp1973_;
			ValaExpression* arg = NULL;
			ValaList* _tmp1974_;
			gint _tmp1975_;
			gpointer _tmp1976_;
			ValaParameter* param = NULL;
			ValaIterator* _tmp1977_;
			ValaUnaryExpression* unary = NULL;
			ValaExpression* _tmp1987_;
			ValaUnaryExpression* _tmp1988_;
			gboolean _tmp1989_ = FALSE;
			ValaUnaryExpression* _tmp1990_;
			ValaUnaryExpression* _tmp1994_;
			ValaExpression* _tmp1995_;
			ValaExpression* _tmp1996_;
			ValaDataType* _tmp1997_;
			ValaDataType* _tmp1998_;
			ValaUnaryExpression* _tmp2008_;
			ValaExpression* _tmp2009_;
			ValaExpression* _tmp2010_;
			ValaTargetValue* _tmp2011_;
			ValaTargetValue* _tmp2012_;
			ValaUnaryExpression* _tmp2013_;
			ValaTargetValue* _tmp2014_;
			ValaTargetValue* _tmp2015_;
			ValaUnaryExpression* _tmp2016_;
			ValaExpression* _tmp2017_;
			ValaExpression* _tmp2018_;
			ValaDataType* _tmp2019_;
			ValaDataType* _tmp2020_;
			ValaExpression* _tmp2021_;
			ValaTargetValue* _tmp2022_;
			ValaTargetValue* _tmp2023_;
			ValaSourceReference* _tmp2024_;
			ValaSourceReference* _tmp2025_;
			gboolean _tmp2026_ = FALSE;
			ValaParameter* _tmp2027_;
			_tmp1971_ = _arg_index;
			_arg_index = _tmp1971_ + 1;
			_tmp1972_ = _arg_index;
			_tmp1973_ = _arg_size;
			if (!(_tmp1972_ < _tmp1973_)) {
				break;
			}
			_tmp1974_ = _arg_list;
			_tmp1975_ = _arg_index;
			_tmp1976_ = vala_list_get (_tmp1974_, _tmp1975_);
			arg = (ValaExpression*) _tmp1976_;
			param = NULL;
			_tmp1977_ = params_it;
			if (vala_iterator_next (_tmp1977_)) {
				ValaIterator* _tmp1978_;
				gpointer _tmp1979_;
				gboolean _tmp1980_ = FALSE;
				ValaParameter* _tmp1981_;
				gboolean _tmp1982_;
				gboolean _tmp1983_;
				_tmp1978_ = params_it;
				_tmp1979_ = vala_iterator_get (_tmp1978_);
				_vala_code_node_unref0 (param);
				param = (ValaParameter*) _tmp1979_;
				_tmp1981_ = param;
				_tmp1982_ = vala_parameter_get_params_array (_tmp1981_);
				_tmp1983_ = _tmp1982_;
				if (_tmp1983_) {
					_tmp1980_ = TRUE;
				} else {
					ValaParameter* _tmp1984_;
					gboolean _tmp1985_;
					gboolean _tmp1986_;
					_tmp1984_ = param;
					_tmp1985_ = vala_parameter_get_ellipsis (_tmp1984_);
					_tmp1986_ = _tmp1985_;
					_tmp1980_ = _tmp1986_;
				}
				if (_tmp1980_) {
					_vala_code_node_unref0 (param);
					_vala_code_node_unref0 (arg);
					break;
				}
			}
			_tmp1987_ = arg;
			_tmp1988_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1987_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp1987_) : NULL);
			unary = _tmp1988_;
			_tmp1990_ = unary;
			if (_tmp1990_ == NULL) {
				_tmp1989_ = TRUE;
			} else {
				ValaUnaryExpression* _tmp1991_;
				ValaUnaryOperator _tmp1992_;
				ValaUnaryOperator _tmp1993_;
				_tmp1991_ = unary;
				_tmp1992_ = vala_unary_expression_get_operator (_tmp1991_);
				_tmp1993_ = _tmp1992_;
				_tmp1989_ = _tmp1993_ != VALA_UNARY_OPERATOR_OUT;
			}
			if (_tmp1989_) {
				_vala_code_node_unref0 (unary);
				_vala_code_node_unref0 (param);
				_vala_code_node_unref0 (arg);
				continue;
			}
			_tmp1994_ = unary;
			_tmp1995_ = vala_unary_expression_get_inner (_tmp1994_);
			_tmp1996_ = _tmp1995_;
			_tmp1997_ = vala_expression_get_value_type (_tmp1996_);
			_tmp1998_ = _tmp1997_;
			if (vala_ccode_base_module_requires_destroy ((ValaCCodeBaseModule*) self, _tmp1998_)) {
				ValaCCodeFunction* _tmp1999_;
				ValaCCodeFunction* _tmp2000_;
				ValaUnaryExpression* _tmp2001_;
				ValaExpression* _tmp2002_;
				ValaExpression* _tmp2003_;
				ValaTargetValue* _tmp2004_;
				ValaTargetValue* _tmp2005_;
				ValaCCodeExpression* _tmp2006_;
				ValaCCodeExpression* _tmp2007_;
				_tmp1999_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp2000_ = _tmp1999_;
				_tmp2001_ = unary;
				_tmp2002_ = vala_unary_expression_get_inner (_tmp2001_);
				_tmp2003_ = _tmp2002_;
				_tmp2004_ = vala_expression_get_target_value (_tmp2003_);
				_tmp2005_ = _tmp2004_;
				_tmp2006_ = vala_ccode_base_module_destroy_value ((ValaCCodeBaseModule*) self, _tmp2005_, FALSE);
				_tmp2007_ = _tmp2006_;
				vala_ccode_function_add_expression (_tmp2000_, _tmp2007_);
				_vala_ccode_node_unref0 (_tmp2007_);
			}
			_tmp2008_ = unary;
			_tmp2009_ = vala_unary_expression_get_inner (_tmp2008_);
			_tmp2010_ = _tmp2009_;
			_tmp2011_ = vala_expression_get_target_value (_tmp2010_);
			_tmp2012_ = _tmp2011_;
			_tmp2013_ = unary;
			_tmp2014_ = vala_expression_get_target_value ((ValaExpression*) _tmp2013_);
			_tmp2015_ = _tmp2014_;
			_tmp2016_ = unary;
			_tmp2017_ = vala_unary_expression_get_inner (_tmp2016_);
			_tmp2018_ = _tmp2017_;
			_tmp2019_ = vala_expression_get_value_type (_tmp2018_);
			_tmp2020_ = _tmp2019_;
			_tmp2021_ = arg;
			_tmp2022_ = vala_ccode_base_module_transform_value ((ValaCCodeBaseModule*) self, _tmp2015_, _tmp2020_, (ValaCodeNode*) _tmp2021_);
			_tmp2023_ = _tmp2022_;
			_tmp2024_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
			_tmp2025_ = _tmp2024_;
			vala_ccode_base_module_store_value ((ValaCCodeBaseModule*) self, _tmp2012_, _tmp2023_, _tmp2025_);
			_vala_target_value_unref0 (_tmp2023_);
			_tmp2027_ = param;
			if (_tmp2027_ != NULL) {
				ValaParameter* _tmp2028_;
				_tmp2028_ = param;
				_tmp2026_ = vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp2028_);
			} else {
				_tmp2026_ = FALSE;
			}
			if (_tmp2026_) {
				ValaCCodeFunctionCall* len_call = NULL;
				ValaCCodeIdentifier* _tmp2029_;
				ValaCCodeIdentifier* _tmp2030_;
				ValaCCodeFunctionCall* _tmp2031_;
				ValaCCodeFunctionCall* _tmp2032_;
				ValaCCodeFunctionCall* _tmp2033_;
				ValaUnaryExpression* _tmp2034_;
				ValaExpression* _tmp2035_;
				ValaExpression* _tmp2036_;
				ValaTargetValue* _tmp2037_;
				ValaTargetValue* _tmp2038_;
				ValaCCodeExpression* _tmp2039_;
				ValaCCodeExpression* _tmp2040_;
				ValaCCodeFunction* _tmp2041_;
				ValaCCodeFunction* _tmp2042_;
				ValaUnaryExpression* _tmp2043_;
				ValaExpression* _tmp2044_;
				ValaExpression* _tmp2045_;
				ValaTargetValue* _tmp2046_;
				ValaTargetValue* _tmp2047_;
				ValaCCodeExpression* _tmp2048_;
				ValaCCodeExpression* _tmp2049_;
				ValaCCodeFunctionCall* _tmp2050_;
				((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
				_tmp2029_ = vala_ccode_identifier_new ("_vala_array_length");
				_tmp2030_ = _tmp2029_;
				_tmp2031_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp2030_);
				_tmp2032_ = _tmp2031_;
				_vala_ccode_node_unref0 (_tmp2030_);
				len_call = _tmp2032_;
				_tmp2033_ = len_call;
				_tmp2034_ = unary;
				_tmp2035_ = vala_unary_expression_get_inner (_tmp2034_);
				_tmp2036_ = _tmp2035_;
				_tmp2037_ = vala_expression_get_target_value (_tmp2036_);
				_tmp2038_ = _tmp2037_;
				_tmp2039_ = vala_ccode_base_module_get_cvalue_ ((ValaCCodeBaseModule*) self, _tmp2038_);
				_tmp2040_ = _tmp2039_;
				vala_ccode_function_call_add_argument (_tmp2033_, _tmp2040_);
				_vala_ccode_node_unref0 (_tmp2040_);
				_tmp2041_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp2042_ = _tmp2041_;
				_tmp2043_ = unary;
				_tmp2044_ = vala_unary_expression_get_inner (_tmp2043_);
				_tmp2045_ = _tmp2044_;
				_tmp2046_ = vala_expression_get_target_value (_tmp2045_);
				_tmp2047_ = _tmp2046_;
				_tmp2048_ = vala_ccode_base_module_get_array_length_cvalue ((ValaCCodeBaseModule*) self, _tmp2047_, 1);
				_tmp2049_ = _tmp2048_;
				_tmp2050_ = len_call;
				vala_ccode_function_add_assignment (_tmp2042_, _tmp2049_, (ValaCCodeExpression*) _tmp2050_);
				_vala_ccode_node_unref0 (_tmp2049_);
				_vala_ccode_node_unref0 (len_call);
			}
			_vala_code_node_unref0 (unary);
			_vala_code_node_unref0 (param);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	_tmp2053_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2053_, VALA_TYPE_CREATION_METHOD)) {
		ValaMethod* _tmp2054_;
		ValaSymbol* _tmp2055_;
		ValaSymbol* _tmp2056_;
		_tmp2054_ = m;
		_tmp2055_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp2054_);
		_tmp2056_ = _tmp2055_;
		_tmp2052_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2056_, VALA_TYPE_CLASS);
	} else {
		_tmp2052_ = FALSE;
	}
	if (_tmp2052_) {
		ValaClass* _tmp2057_;
		ValaClass* _tmp2058_;
		ValaClass* _tmp2059_;
		ValaClass* _tmp2060_;
		ValaClass* _tmp2061_;
		_tmp2057_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp2058_ = _tmp2057_;
		_tmp2059_ = vala_class_get_base_class (_tmp2058_);
		_tmp2060_ = _tmp2059_;
		_tmp2061_ = ((ValaCCodeBaseModule*) self)->gsource_type;
		_tmp2051_ = _tmp2060_ == _tmp2061_;
	} else {
		_tmp2051_ = FALSE;
	}
	if (_tmp2051_) {
		ValaCCodeFunctionCall* cinitcall = NULL;
		ValaClass* _tmp2062_;
		ValaClass* _tmp2063_;
		gchar* _tmp2064_;
		gchar* _tmp2065_;
		gchar* _tmp2066_;
		gchar* _tmp2067_;
		ValaCCodeIdentifier* _tmp2068_;
		ValaCCodeIdentifier* _tmp2069_;
		ValaCCodeFunctionCall* _tmp2070_;
		ValaCCodeFunctionCall* _tmp2071_;
		ValaCCodeFunctionCall* _tmp2072_;
		ValaCCodeExpression* _tmp2073_;
		ValaCCodeExpression* _tmp2074_;
		ValaCCodeFunction* _tmp2075_;
		ValaCCodeFunction* _tmp2076_;
		ValaCCodeFunctionCall* _tmp2077_;
		_tmp2062_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp2063_ = _tmp2062_;
		_tmp2064_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp2063_, NULL);
		_tmp2065_ = _tmp2064_;
		_tmp2066_ = g_strdup_printf ("%s_instance_init", _tmp2065_);
		_tmp2067_ = _tmp2066_;
		_tmp2068_ = vala_ccode_identifier_new (_tmp2067_);
		_tmp2069_ = _tmp2068_;
		_tmp2070_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp2069_);
		_tmp2071_ = _tmp2070_;
		_vala_ccode_node_unref0 (_tmp2069_);
		_g_free0 (_tmp2067_);
		_g_free0 (_tmp2065_);
		cinitcall = _tmp2071_;
		_tmp2072_ = cinitcall;
		_tmp2073_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
		_tmp2074_ = _tmp2073_;
		vala_ccode_function_call_add_argument (_tmp2072_, _tmp2074_);
		_vala_ccode_node_unref0 (_tmp2074_);
		_tmp2075_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp2076_ = _tmp2075_;
		_tmp2077_ = cinitcall;
		vala_ccode_function_add_expression (_tmp2076_, (ValaCCodeExpression*) _tmp2077_);
		_vala_ccode_node_unref0 (cinitcall);
	}
	_vala_ccode_node_unref0 (out_param_ref);
	_vala_iterator_unref0 (params_it);
	_vala_ccode_node_unref0 (instance);
	_vala_ccode_node_unref0 (ccall_expr);
	_vala_map_unref0 (out_arg_map);
	_vala_map_unref0 (in_arg_map);
	_vala_code_node_unref0 (itype);
	_vala_code_node_unref0 (ma);
	_vala_iterable_unref0 (params);
	_vala_code_node_unref0 (deleg);
	_vala_code_node_unref0 (m);
	_vala_ccode_node_unref0 (finish_call);
	_vala_ccode_node_unref0 (async_call);
	_vala_ccode_node_unref0 (ccall);
}


static gchar*
vala_ccode_method_call_module_generate_enum_tostring_function (ValaCCodeMethodCallModule* self,
                                                               ValaEnum* en)
{
	gchar* result = NULL;
	gchar* to_string_func = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	ValaCCodeFunction* function = NULL;
	const gchar* _tmp5_;
	ValaCCodeFunction* _tmp6_;
	ValaCCodeFunction* _tmp7_;
	ValaCCodeFunction* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	ValaCCodeParameter* _tmp11_;
	ValaCCodeParameter* _tmp12_;
	ValaCCodeBaseModuleEmitContext* _tmp13_;
	ValaCCodeBaseModuleEmitContext* _tmp14_;
	ValaCCodeFunction* _tmp15_;
	ValaCCodeFunction* _tmp16_;
	ValaCCodeFunction* _tmp17_;
	ValaCCodeConstant* _tmp18_;
	ValaCCodeConstant* _tmp19_;
	ValaCCodeFunction* _tmp48_;
	ValaCCodeFunction* _tmp49_;
	ValaCCodeFunction* _tmp50_;
	ValaCCodeFunction* _tmp51_;
	ValaCCodeConstant* _tmp52_;
	ValaCCodeConstant* _tmp53_;
	ValaCCodeFile* _tmp54_;
	ValaCCodeFunction* _tmp55_;
	ValaCCodeFile* _tmp56_;
	ValaCCodeFunction* _tmp57_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (en != NULL, NULL);
	_tmp0_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) en, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("_%s_to_string", _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	to_string_func = _tmp3_;
	_tmp4_ = to_string_func;
	if (!vala_ccode_base_module_add_wrapper ((ValaCCodeBaseModule*) self, _tmp4_)) {
		result = to_string_func;
		return result;
	}
	_tmp5_ = to_string_func;
	_tmp6_ = vala_ccode_function_new (_tmp5_, "const char*");
	function = _tmp6_;
	_tmp7_ = function;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp7_, VALA_CCODE_MODIFIERS_STATIC);
	_tmp8_ = function;
	_tmp9_ = vala_get_ccode_name ((ValaCodeNode*) en);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_ccode_parameter_new ("value", _tmp10_);
	_tmp12_ = _tmp11_;
	vala_ccode_function_add_parameter (_tmp8_, _tmp12_);
	_vala_ccode_node_unref0 (_tmp12_);
	_g_free0 (_tmp10_);
	_tmp13_ = vala_ccode_base_module_emit_context_new (NULL);
	_tmp14_ = _tmp13_;
	vala_ccode_base_module_push_context ((ValaCCodeBaseModule*) self, _tmp14_);
	_vala_ccode_base_module_emit_context_unref0 (_tmp14_);
	_tmp15_ = function;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp15_);
	_tmp16_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp17_ = _tmp16_;
	_tmp18_ = vala_ccode_constant_new ("value");
	_tmp19_ = _tmp18_;
	vala_ccode_function_open_switch (_tmp17_, (ValaCCodeExpression*) _tmp19_);
	_vala_ccode_node_unref0 (_tmp19_);
	{
		ValaList* _enum_value_list = NULL;
		ValaList* _tmp20_;
		gint _enum_value_size = 0;
		ValaList* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		gint _enum_value_index = 0;
		_tmp20_ = vala_enum_get_values (en);
		_enum_value_list = _tmp20_;
		_tmp21_ = _enum_value_list;
		_tmp22_ = vala_collection_get_size ((ValaCollection*) _tmp21_);
		_tmp23_ = _tmp22_;
		_enum_value_size = _tmp23_;
		_enum_value_index = -1;
		while (TRUE) {
			gint _tmp24_;
			gint _tmp25_;
			gint _tmp26_;
			ValaEnumValue* enum_value = NULL;
			ValaList* _tmp27_;
			gint _tmp28_;
			gpointer _tmp29_;
			ValaCCodeFunction* _tmp30_;
			ValaCCodeFunction* _tmp31_;
			ValaEnumValue* _tmp32_;
			gchar* _tmp33_;
			gchar* _tmp34_;
			ValaCCodeIdentifier* _tmp35_;
			ValaCCodeIdentifier* _tmp36_;
			ValaCCodeFunction* _tmp37_;
			ValaCCodeFunction* _tmp38_;
			ValaEnumValue* _tmp39_;
			gchar* _tmp40_;
			gchar* _tmp41_;
			gchar* _tmp42_;
			gchar* _tmp43_;
			gchar* _tmp44_;
			gchar* _tmp45_;
			ValaCCodeConstant* _tmp46_;
			ValaCCodeConstant* _tmp47_;
			_tmp24_ = _enum_value_index;
			_enum_value_index = _tmp24_ + 1;
			_tmp25_ = _enum_value_index;
			_tmp26_ = _enum_value_size;
			if (!(_tmp25_ < _tmp26_)) {
				break;
			}
			_tmp27_ = _enum_value_list;
			_tmp28_ = _enum_value_index;
			_tmp29_ = vala_list_get (_tmp27_, _tmp28_);
			enum_value = (ValaEnumValue*) _tmp29_;
			_tmp30_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp31_ = _tmp30_;
			_tmp32_ = enum_value;
			_tmp33_ = vala_get_ccode_name ((ValaCodeNode*) _tmp32_);
			_tmp34_ = _tmp33_;
			_tmp35_ = vala_ccode_identifier_new (_tmp34_);
			_tmp36_ = _tmp35_;
			vala_ccode_function_add_case (_tmp31_, (ValaCCodeExpression*) _tmp36_);
			_vala_ccode_node_unref0 (_tmp36_);
			_g_free0 (_tmp34_);
			_tmp37_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp38_ = _tmp37_;
			_tmp39_ = enum_value;
			_tmp40_ = vala_get_ccode_name ((ValaCodeNode*) _tmp39_);
			_tmp41_ = _tmp40_;
			_tmp42_ = g_strconcat ("\"", _tmp41_, NULL);
			_tmp43_ = _tmp42_;
			_tmp44_ = g_strconcat (_tmp43_, "\"", NULL);
			_tmp45_ = _tmp44_;
			_tmp46_ = vala_ccode_constant_new (_tmp45_);
			_tmp47_ = _tmp46_;
			vala_ccode_function_add_return (_tmp38_, (ValaCCodeExpression*) _tmp47_);
			_vala_ccode_node_unref0 (_tmp47_);
			_g_free0 (_tmp45_);
			_g_free0 (_tmp43_);
			_g_free0 (_tmp41_);
			_vala_code_node_unref0 (enum_value);
		}
		_vala_iterable_unref0 (_enum_value_list);
	}
	_tmp48_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp49_ = _tmp48_;
	vala_ccode_function_close (_tmp49_);
	_tmp50_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp51_ = _tmp50_;
	_tmp52_ = vala_ccode_constant_new ("NULL");
	_tmp53_ = _tmp52_;
	vala_ccode_function_add_return (_tmp51_, (ValaCCodeExpression*) _tmp53_);
	_vala_ccode_node_unref0 (_tmp53_);
	_tmp54_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp55_ = function;
	vala_ccode_file_add_function_declaration (_tmp54_, _tmp55_);
	_tmp56_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp57_ = function;
	vala_ccode_file_add_function (_tmp56_, _tmp57_);
	vala_ccode_base_module_pop_context ((ValaCCodeBaseModule*) self);
	result = to_string_func;
	_vala_ccode_node_unref0 (function);
	return result;
}


static gboolean
vala_ccode_method_call_module_has_ref_out_param (ValaCCodeMethodCallModule* self,
                                                 ValaCallable* c)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (c != NULL, FALSE);
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp0_;
		gint _param_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _param_index = 0;
		_tmp0_ = vala_callable_get_parameters (c);
		_param_list = _tmp0_;
		_tmp1_ = _param_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_param_size = _tmp3_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			gint _tmp6_;
			ValaParameter* param = NULL;
			ValaList* _tmp7_;
			gint _tmp8_;
			gpointer _tmp9_;
			ValaParameter* _tmp10_;
			ValaParameterDirection _tmp11_;
			ValaParameterDirection _tmp12_;
			_tmp4_ = _param_index;
			_param_index = _tmp4_ + 1;
			_tmp5_ = _param_index;
			_tmp6_ = _param_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _param_list;
			_tmp8_ = _param_index;
			_tmp9_ = vala_list_get (_tmp7_, _tmp8_);
			param = (ValaParameter*) _tmp9_;
			_tmp10_ = param;
			_tmp11_ = vala_parameter_get_direction (_tmp10_);
			_tmp12_ = _tmp11_;
			if (_tmp12_ != VALA_PARAMETER_DIRECTION_IN) {
				result = TRUE;
				_vala_code_node_unref0 (param);
				_vala_iterable_unref0 (_param_list);
				return result;
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	result = FALSE;
	return result;
}


ValaCCodeMethodCallModule*
vala_ccode_method_call_module_construct (GType object_type)
{
	ValaCCodeMethodCallModule* self = NULL;
	self = (ValaCCodeMethodCallModule*) vala_ccode_assignment_module_construct (object_type);
	return self;
}


ValaCCodeMethodCallModule*
vala_ccode_method_call_module_new (void)
{
	return vala_ccode_method_call_module_construct (VALA_TYPE_CCODE_METHOD_CALL_MODULE);
}


static void
vala_ccode_method_call_module_class_init (ValaCCodeMethodCallModuleClass * klass)
{
	vala_ccode_method_call_module_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeVisitorClass *) klass)->visit_method_call = (void (*) (ValaCodeVisitor *, ValaMethodCall*)) vala_ccode_method_call_module_real_visit_method_call;
}


static void
vala_ccode_method_call_module_instance_init (ValaCCodeMethodCallModule * self)
{
}


GType
vala_ccode_method_call_module_get_type (void)
{
	static volatile gsize vala_ccode_method_call_module_type_id__volatile = 0;
	if (g_once_init_enter (&vala_ccode_method_call_module_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeMethodCallModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_method_call_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeMethodCallModule), 0, (GInstanceInitFunc) vala_ccode_method_call_module_instance_init, NULL };
		GType vala_ccode_method_call_module_type_id;
		vala_ccode_method_call_module_type_id = g_type_register_static (VALA_TYPE_CCODE_ASSIGNMENT_MODULE, "ValaCCodeMethodCallModule", &g_define_type_info, 0);
		g_once_init_leave (&vala_ccode_method_call_module_type_id__volatile, vala_ccode_method_call_module_type_id);
	}
	return vala_ccode_method_call_module_type_id__volatile;
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



