/* valamethod.c generated by valac, the Vala compiler
 * generated from valamethod.vala, do not modify */

/* valamethod.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <valagee.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>

enum  {
	VALA_METHOD_0_PROPERTY,
	VALA_METHOD_NUM_PROPERTIES
};
static GParamSpec* vala_method_properties[VALA_METHOD_NUM_PROPERTIES];
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValaMethodPrivate {
	ValaList* type_parameters;
	ValaMemberBinding _binding;
	gboolean _is_abstract;
	gboolean _is_virtual;
	gboolean _overrides;
	gboolean _is_inline;
	gboolean _entry_point;
	ValaParameter* _this_parameter;
	ValaSignal* _signal_reference;
	gboolean _closure;
	gboolean _coroutine;
	gboolean _is_async_callback;
	ValaList* parameters;
	ValaList* preconditions;
	ValaList* postconditions;
	ValaDataType* _return_type;
	ValaMethod* _base_method;
	ValaMethod* _base_interface_method;
	ValaDataType* _base_interface_type;
	gboolean base_methods_valid;
	ValaMethod* callback_method;
	ValaMethod* end_method;
	ValaList* captured_variables;
};


static gpointer vala_method_parent_class = NULL;
static ValaList* vala_method__empty_expression_list;
static ValaList* vala_method__empty_expression_list = NULL;
static ValaList* vala_method__empty_type_parameter_list;
static ValaList* vala_method__empty_type_parameter_list = NULL;
static ValaCallableIface * vala_method_vala_callable_parent_iface = NULL;

#define VALA_METHOD_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_METHOD, ValaMethodPrivate))
static void vala_method_real_add_parameter (ValaCallable* base, 
                                     ValaParameter* param);
static ValaList* vala_method_real_get_parameters (ValaCallable* base);
static void vala_method_real_accept (ValaCodeNode* base, 
                              ValaCodeVisitor* visitor);
static void vala_method_real_accept_children (ValaCodeNode* base, 
                                       ValaCodeVisitor* visitor);
static void vala_method_real_replace_type (ValaCodeNode* base, 
                                    ValaDataType* old_type, 
                                    ValaDataType* new_type);
static void vala_method_find_base_methods (ValaMethod* self);
static void vala_method_find_base_interface_method (ValaMethod* self, 
                                             ValaClass* cl);
static void vala_method_find_base_class_method (ValaMethod* self, 
                                         ValaClass* cl);
static gboolean vala_method_real_check (ValaCodeNode* base, 
                                 ValaCodeContext* context);
static gboolean vala_method_is_possible_entry_point (ValaMethod* self, 
                                              ValaCodeContext* context);
static void vala_method_set_entry_point (ValaMethod* self, 
                                  gboolean value);
static void vala_method_real_get_defined_variables (ValaCodeNode* base, 
                                             ValaCollection* collection);
static void vala_method_finalize (ValaCodeNode * obj);


/**
 * Creates a new method.
 *
 * @param name              method name
 * @param return_type       method return type
 * @param source_reference  reference to source code
 * @return                  newly created method
 */
ValaMethod*
vala_method_construct (GType object_type, 
                       const gchar* name, 
                       ValaDataType* return_type, 
                       ValaSourceReference* source_reference, 
                       ValaComment* comment)
{
	ValaMethod* self = NULL;
	g_return_val_if_fail (return_type != NULL, NULL);
	self = (ValaMethod*) vala_subroutine_construct (object_type, name, source_reference, comment);
	vala_callable_set_return_type ((ValaCallable*) self, return_type);
	return self;
}


ValaMethod*
vala_method_new (const gchar* name, 
                 ValaDataType* return_type, 
                 ValaSourceReference* source_reference, 
                 ValaComment* comment)
{
	return vala_method_construct (VALA_TYPE_METHOD, name, return_type, source_reference, comment);
}


/**
 * Appends parameter to this method.
 *
 * @param param a formal parameter
 */
static void
vala_method_real_add_parameter (ValaCallable* base, 
                                ValaParameter* param)
{
	ValaMethod * self;
	ValaList* _tmp0_;
	ValaScope* _tmp1_;
	ValaScope* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	self = (ValaMethod*) base;
	g_return_if_fail (param != NULL);
	_tmp0_ = self->priv->parameters;
	vala_collection_add ((ValaCollection*) _tmp0_, param);
	_tmp1_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_symbol_get_name ((ValaSymbol*) param);
	_tmp4_ = _tmp3_;
	vala_scope_add (_tmp2_, _tmp4_, (ValaSymbol*) param);
}


static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}


static ValaList*
vala_method_real_get_parameters (ValaCallable* base)
{
	ValaMethod * self;
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	self = (ValaMethod*) base;
	_tmp0_ = self->priv->parameters;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Remove all parameters from this method.
 */
void
vala_method_clear_parameters (ValaMethod* self)
{
	ValaList* _tmp19_;
	g_return_if_fail (self != NULL);
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _param_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _param_index = 0;
		_tmp0_ = self->priv->parameters;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_param_list = _tmp1_;
		_tmp2_ = _param_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_param_size = _tmp4_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaParameter* param = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValaParameter* _tmp11_;
			gboolean _tmp12_;
			gboolean _tmp13_;
			_tmp5_ = _param_index;
			_param_index = _tmp5_ + 1;
			_tmp6_ = _param_index;
			_tmp7_ = _param_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _param_list;
			_tmp9_ = _param_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			param = (ValaParameter*) _tmp10_;
			_tmp11_ = param;
			_tmp12_ = vala_parameter_get_ellipsis (_tmp11_);
			_tmp13_ = _tmp12_;
			if (!_tmp13_) {
				ValaScope* _tmp14_;
				ValaScope* _tmp15_;
				ValaParameter* _tmp16_;
				const gchar* _tmp17_;
				const gchar* _tmp18_;
				_tmp14_ = vala_symbol_get_scope ((ValaSymbol*) self);
				_tmp15_ = _tmp14_;
				_tmp16_ = param;
				_tmp17_ = vala_symbol_get_name ((ValaSymbol*) _tmp16_);
				_tmp18_ = _tmp17_;
				vala_scope_remove (_tmp15_, _tmp18_);
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp19_ = self->priv->parameters;
	vala_collection_clear ((ValaCollection*) _tmp19_);
}


gboolean
vala_method_is_variadic (ValaMethod* self)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _param_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _param_index = 0;
		_tmp0_ = self->priv->parameters;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_param_list = _tmp1_;
		_tmp2_ = _param_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_param_size = _tmp4_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaParameter* param = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValaParameter* _tmp11_;
			gboolean _tmp12_;
			gboolean _tmp13_;
			_tmp5_ = _param_index;
			_param_index = _tmp5_ + 1;
			_tmp6_ = _param_index;
			_tmp7_ = _param_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _param_list;
			_tmp9_ = _param_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			param = (ValaParameter*) _tmp10_;
			_tmp11_ = param;
			_tmp12_ = vala_parameter_get_ellipsis (_tmp11_);
			_tmp13_ = _tmp12_;
			if (_tmp13_) {
				result = TRUE;
				_vala_code_node_unref0 (param);
				_vala_iterable_unref0 (_param_list);
				return result;
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	result = FALSE;
	return result;
}


static void
vala_method_real_accept (ValaCodeNode* base, 
                         ValaCodeVisitor* visitor)
{
	ValaMethod * self;
	self = (ValaMethod*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_method (visitor, self);
}


static void
vala_method_real_accept_children (ValaCodeNode* base, 
                                  ValaCodeVisitor* visitor)
{
	ValaMethod * self;
	ValaDataType* _tmp11_;
	ValaDataType* _tmp12_;
	ValaDataType* _tmp15_;
	ValaDataType* _tmp16_;
	ValaLocalVariable* _tmp42_;
	ValaLocalVariable* _tmp43_;
	ValaList* _tmp46_;
	ValaList* _tmp59_;
	ValaBlock* _tmp72_;
	ValaBlock* _tmp73_;
	self = (ValaMethod*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp0_;
		gint _p_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _p_index = 0;
		_tmp0_ = vala_method_get_type_parameters (self);
		_p_list = _tmp0_;
		_tmp1_ = _p_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_p_size = _tmp3_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			gint _tmp6_;
			ValaTypeParameter* p = NULL;
			ValaList* _tmp7_;
			gint _tmp8_;
			gpointer _tmp9_;
			ValaTypeParameter* _tmp10_;
			_tmp4_ = _p_index;
			_p_index = _tmp4_ + 1;
			_tmp5_ = _p_index;
			_tmp6_ = _p_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _p_list;
			_tmp8_ = _p_index;
			_tmp9_ = vala_list_get (_tmp7_, _tmp8_);
			p = (ValaTypeParameter*) _tmp9_;
			_tmp10_ = p;
			vala_code_node_accept ((ValaCodeNode*) _tmp10_, visitor);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	_tmp11_ = vala_method_get_base_interface_type (self);
	_tmp12_ = _tmp11_;
	if (_tmp12_ != NULL) {
		ValaDataType* _tmp13_;
		ValaDataType* _tmp14_;
		_tmp13_ = vala_method_get_base_interface_type (self);
		_tmp14_ = _tmp13_;
		vala_code_node_accept ((ValaCodeNode*) _tmp14_, visitor);
	}
	_tmp15_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp16_ = _tmp15_;
	if (_tmp16_ != NULL) {
		ValaDataType* _tmp17_;
		ValaDataType* _tmp18_;
		_tmp17_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp18_ = _tmp17_;
		vala_code_node_accept ((ValaCodeNode*) _tmp18_, visitor);
	}
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp19_;
		ValaList* _tmp20_;
		gint _param_size = 0;
		ValaList* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		gint _param_index = 0;
		_tmp19_ = self->priv->parameters;
		_tmp20_ = _vala_iterable_ref0 (_tmp19_);
		_param_list = _tmp20_;
		_tmp21_ = _param_list;
		_tmp22_ = vala_collection_get_size ((ValaCollection*) _tmp21_);
		_tmp23_ = _tmp22_;
		_param_size = _tmp23_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp24_;
			gint _tmp25_;
			gint _tmp26_;
			ValaParameter* param = NULL;
			ValaList* _tmp27_;
			gint _tmp28_;
			gpointer _tmp29_;
			ValaParameter* _tmp30_;
			_tmp24_ = _param_index;
			_param_index = _tmp24_ + 1;
			_tmp25_ = _param_index;
			_tmp26_ = _param_size;
			if (!(_tmp25_ < _tmp26_)) {
				break;
			}
			_tmp27_ = _param_list;
			_tmp28_ = _param_index;
			_tmp29_ = vala_list_get (_tmp27_, _tmp28_);
			param = (ValaParameter*) _tmp29_;
			_tmp30_ = param;
			vala_code_node_accept ((ValaCodeNode*) _tmp30_, visitor);
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	{
		ValaList* _error_type_list = NULL;
		ValaList* _tmp31_;
		gint _error_type_size = 0;
		ValaList* _tmp32_;
		gint _tmp33_;
		gint _tmp34_;
		gint _error_type_index = 0;
		_tmp31_ = vala_code_node_get_error_types ((ValaCodeNode*) self);
		_error_type_list = _tmp31_;
		_tmp32_ = _error_type_list;
		_tmp33_ = vala_collection_get_size ((ValaCollection*) _tmp32_);
		_tmp34_ = _tmp33_;
		_error_type_size = _tmp34_;
		_error_type_index = -1;
		while (TRUE) {
			gint _tmp35_;
			gint _tmp36_;
			gint _tmp37_;
			ValaDataType* error_type = NULL;
			ValaList* _tmp38_;
			gint _tmp39_;
			gpointer _tmp40_;
			ValaDataType* _tmp41_;
			_tmp35_ = _error_type_index;
			_error_type_index = _tmp35_ + 1;
			_tmp36_ = _error_type_index;
			_tmp37_ = _error_type_size;
			if (!(_tmp36_ < _tmp37_)) {
				break;
			}
			_tmp38_ = _error_type_list;
			_tmp39_ = _error_type_index;
			_tmp40_ = vala_list_get (_tmp38_, _tmp39_);
			error_type = (ValaDataType*) _tmp40_;
			_tmp41_ = error_type;
			vala_code_node_accept ((ValaCodeNode*) _tmp41_, visitor);
			_vala_code_node_unref0 (error_type);
		}
		_vala_iterable_unref0 (_error_type_list);
	}
	_tmp42_ = vala_subroutine_get_result_var ((ValaSubroutine*) self);
	_tmp43_ = _tmp42_;
	if (_tmp43_ != NULL) {
		ValaLocalVariable* _tmp44_;
		ValaLocalVariable* _tmp45_;
		_tmp44_ = vala_subroutine_get_result_var ((ValaSubroutine*) self);
		_tmp45_ = _tmp44_;
		vala_code_node_accept ((ValaCodeNode*) _tmp45_, visitor);
	}
	_tmp46_ = self->priv->preconditions;
	if (_tmp46_ != NULL) {
		{
			ValaList* _precondition_list = NULL;
			ValaList* _tmp47_;
			ValaList* _tmp48_;
			gint _precondition_size = 0;
			ValaList* _tmp49_;
			gint _tmp50_;
			gint _tmp51_;
			gint _precondition_index = 0;
			_tmp47_ = self->priv->preconditions;
			_tmp48_ = _vala_iterable_ref0 (_tmp47_);
			_precondition_list = _tmp48_;
			_tmp49_ = _precondition_list;
			_tmp50_ = vala_collection_get_size ((ValaCollection*) _tmp49_);
			_tmp51_ = _tmp50_;
			_precondition_size = _tmp51_;
			_precondition_index = -1;
			while (TRUE) {
				gint _tmp52_;
				gint _tmp53_;
				gint _tmp54_;
				ValaExpression* precondition = NULL;
				ValaList* _tmp55_;
				gint _tmp56_;
				gpointer _tmp57_;
				ValaExpression* _tmp58_;
				_tmp52_ = _precondition_index;
				_precondition_index = _tmp52_ + 1;
				_tmp53_ = _precondition_index;
				_tmp54_ = _precondition_size;
				if (!(_tmp53_ < _tmp54_)) {
					break;
				}
				_tmp55_ = _precondition_list;
				_tmp56_ = _precondition_index;
				_tmp57_ = vala_list_get (_tmp55_, _tmp56_);
				precondition = (ValaExpression*) _tmp57_;
				_tmp58_ = precondition;
				vala_code_node_accept ((ValaCodeNode*) _tmp58_, visitor);
				_vala_code_node_unref0 (precondition);
			}
			_vala_iterable_unref0 (_precondition_list);
		}
	}
	_tmp59_ = self->priv->postconditions;
	if (_tmp59_ != NULL) {
		{
			ValaList* _postcondition_list = NULL;
			ValaList* _tmp60_;
			ValaList* _tmp61_;
			gint _postcondition_size = 0;
			ValaList* _tmp62_;
			gint _tmp63_;
			gint _tmp64_;
			gint _postcondition_index = 0;
			_tmp60_ = self->priv->postconditions;
			_tmp61_ = _vala_iterable_ref0 (_tmp60_);
			_postcondition_list = _tmp61_;
			_tmp62_ = _postcondition_list;
			_tmp63_ = vala_collection_get_size ((ValaCollection*) _tmp62_);
			_tmp64_ = _tmp63_;
			_postcondition_size = _tmp64_;
			_postcondition_index = -1;
			while (TRUE) {
				gint _tmp65_;
				gint _tmp66_;
				gint _tmp67_;
				ValaExpression* postcondition = NULL;
				ValaList* _tmp68_;
				gint _tmp69_;
				gpointer _tmp70_;
				ValaExpression* _tmp71_;
				_tmp65_ = _postcondition_index;
				_postcondition_index = _tmp65_ + 1;
				_tmp66_ = _postcondition_index;
				_tmp67_ = _postcondition_size;
				if (!(_tmp66_ < _tmp67_)) {
					break;
				}
				_tmp68_ = _postcondition_list;
				_tmp69_ = _postcondition_index;
				_tmp70_ = vala_list_get (_tmp68_, _tmp69_);
				postcondition = (ValaExpression*) _tmp70_;
				_tmp71_ = postcondition;
				vala_code_node_accept ((ValaCodeNode*) _tmp71_, visitor);
				_vala_code_node_unref0 (postcondition);
			}
			_vala_iterable_unref0 (_postcondition_list);
		}
	}
	_tmp72_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp73_ = _tmp72_;
	if (_tmp73_ != NULL) {
		ValaBlock* _tmp74_;
		ValaBlock* _tmp75_;
		_tmp74_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp75_ = _tmp74_;
		vala_code_node_accept ((ValaCodeNode*) _tmp75_, visitor);
	}
}


/**
 * Checks whether the parameters and return type of this method are
 * compatible with the specified method
 *
 * @param base_method a method
 * @param invalid_match error string about which check failed
 * @return true if the specified method is compatible to this method
 */
gboolean
vala_method_compatible (ValaMethod* self, 
                        ValaMethod* base_method, 
                        gchar* * invalid_match)
{
	gchar* _vala_invalid_match = NULL;
	gboolean result = FALSE;
	ValaMemberBinding _tmp0_;
	ValaMemberBinding _tmp1_;
	ValaObjectType* object_type = NULL;
	ValaSymbol* _tmp3_;
	ValaSymbol* _tmp4_;
	ValaList* _tmp26_;
	ValaList* _tmp27_;
	gint _tmp28_;
	gint _tmp29_;
	ValaList* _tmp30_;
	ValaList* _tmp31_;
	gint _tmp32_;
	gint _tmp33_;
	gboolean _tmp34_;
	ValaList* method_type_args = NULL;
	ValaList* _tmp46_;
	ValaList* _tmp47_;
	gint _tmp48_;
	gint _tmp49_;
	gboolean _tmp50_;
	ValaDataType* actual_base_type = NULL;
	ValaDataType* _tmp68_;
	ValaDataType* _tmp69_;
	ValaObjectType* _tmp70_;
	ValaList* _tmp71_;
	ValaDataType* _tmp72_;
	ValaDataType* _tmp73_;
	ValaDataType* _tmp74_;
	ValaDataType* _tmp75_;
	ValaIterator* method_params_it = NULL;
	ValaList* _tmp84_;
	ValaIterator* _tmp85_;
	gint param_index = 0;
	ValaIterator* _tmp132_;
	gboolean _tmp161_;
	gboolean _tmp162_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (base_method != NULL, FALSE);
	if (self == base_method) {
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = NULL;
		result = TRUE;
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	}
	_tmp0_ = self->priv->_binding;
	_tmp1_ = base_method->priv->_binding;
	if (_tmp0_ != _tmp1_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("incompatible binding");
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = _tmp2_;
		result = FALSE;
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	}
	object_type = NULL;
	_tmp3_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp4_ = _tmp3_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, VALA_TYPE_OBJECT_TYPE_SYMBOL)) {
		ValaSymbol* _tmp5_;
		ValaSymbol* _tmp6_;
		ValaObjectType* _tmp7_;
		_tmp5_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_object_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
		_vala_code_node_unref0 (object_type);
		object_type = _tmp7_;
		{
			ValaList* _type_parameter_list = NULL;
			ValaObjectType* _tmp8_;
			ValaObjectTypeSymbol* _tmp9_;
			ValaObjectTypeSymbol* _tmp10_;
			ValaList* _tmp11_;
			gint _type_parameter_size = 0;
			ValaList* _tmp12_;
			gint _tmp13_;
			gint _tmp14_;
			gint _type_parameter_index = 0;
			_tmp8_ = object_type;
			_tmp9_ = vala_object_type_get_type_symbol (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = vala_object_type_symbol_get_type_parameters (_tmp10_);
			_type_parameter_list = _tmp11_;
			_tmp12_ = _type_parameter_list;
			_tmp13_ = vala_collection_get_size ((ValaCollection*) _tmp12_);
			_tmp14_ = _tmp13_;
			_type_parameter_size = _tmp14_;
			_type_parameter_index = -1;
			while (TRUE) {
				gint _tmp15_;
				gint _tmp16_;
				gint _tmp17_;
				ValaTypeParameter* type_parameter = NULL;
				ValaList* _tmp18_;
				gint _tmp19_;
				gpointer _tmp20_;
				ValaGenericType* type_arg = NULL;
				ValaTypeParameter* _tmp21_;
				ValaGenericType* _tmp22_;
				ValaGenericType* _tmp23_;
				ValaObjectType* _tmp24_;
				ValaGenericType* _tmp25_;
				_tmp15_ = _type_parameter_index;
				_type_parameter_index = _tmp15_ + 1;
				_tmp16_ = _type_parameter_index;
				_tmp17_ = _type_parameter_size;
				if (!(_tmp16_ < _tmp17_)) {
					break;
				}
				_tmp18_ = _type_parameter_list;
				_tmp19_ = _type_parameter_index;
				_tmp20_ = vala_list_get (_tmp18_, _tmp19_);
				type_parameter = (ValaTypeParameter*) _tmp20_;
				_tmp21_ = type_parameter;
				_tmp22_ = vala_generic_type_new (_tmp21_);
				type_arg = _tmp22_;
				_tmp23_ = type_arg;
				vala_data_type_set_value_owned ((ValaDataType*) _tmp23_, TRUE);
				_tmp24_ = object_type;
				_tmp25_ = type_arg;
				vala_data_type_add_type_argument ((ValaDataType*) _tmp24_, (ValaDataType*) _tmp25_);
				_vala_code_node_unref0 (type_arg);
				_vala_code_node_unref0 (type_parameter);
			}
			_vala_iterable_unref0 (_type_parameter_list);
		}
	}
	_tmp26_ = vala_method_get_type_parameters (self);
	_tmp27_ = _tmp26_;
	_tmp28_ = vala_collection_get_size ((ValaCollection*) _tmp27_);
	_tmp29_ = _tmp28_;
	_tmp30_ = vala_method_get_type_parameters (base_method);
	_tmp31_ = _tmp30_;
	_tmp32_ = vala_collection_get_size ((ValaCollection*) _tmp31_);
	_tmp33_ = _tmp32_;
	_tmp34_ = _tmp29_ < _tmp33_;
	_vala_iterable_unref0 (_tmp31_);
	_vala_iterable_unref0 (_tmp27_);
	if (_tmp34_) {
		gchar* _tmp35_;
		_tmp35_ = g_strdup ("too few type parameters");
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = _tmp35_;
		result = FALSE;
		_vala_code_node_unref0 (object_type);
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	} else {
		ValaList* _tmp36_;
		ValaList* _tmp37_;
		gint _tmp38_;
		gint _tmp39_;
		ValaList* _tmp40_;
		ValaList* _tmp41_;
		gint _tmp42_;
		gint _tmp43_;
		gboolean _tmp44_;
		_tmp36_ = vala_method_get_type_parameters (self);
		_tmp37_ = _tmp36_;
		_tmp38_ = vala_collection_get_size ((ValaCollection*) _tmp37_);
		_tmp39_ = _tmp38_;
		_tmp40_ = vala_method_get_type_parameters (base_method);
		_tmp41_ = _tmp40_;
		_tmp42_ = vala_collection_get_size ((ValaCollection*) _tmp41_);
		_tmp43_ = _tmp42_;
		_tmp44_ = _tmp39_ > _tmp43_;
		_vala_iterable_unref0 (_tmp41_);
		_vala_iterable_unref0 (_tmp37_);
		if (_tmp44_) {
			gchar* _tmp45_;
			_tmp45_ = g_strdup ("too many type parameters");
			_g_free0 (_vala_invalid_match);
			_vala_invalid_match = _tmp45_;
			result = FALSE;
			_vala_code_node_unref0 (object_type);
			if (invalid_match) {
				*invalid_match = _vala_invalid_match;
			} else {
				_g_free0 (_vala_invalid_match);
			}
			return result;
		}
	}
	method_type_args = NULL;
	_tmp46_ = vala_method_get_type_parameters (self);
	_tmp47_ = _tmp46_;
	_tmp48_ = vala_collection_get_size ((ValaCollection*) _tmp47_);
	_tmp49_ = _tmp48_;
	_tmp50_ = _tmp49_ > 0;
	_vala_iterable_unref0 (_tmp47_);
	if (_tmp50_) {
		GEqualFunc _tmp51_;
		ValaArrayList* _tmp52_;
		_tmp51_ = g_direct_equal;
		_tmp52_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp51_);
		_vala_iterable_unref0 (method_type_args);
		method_type_args = (ValaList*) _tmp52_;
		{
			ValaList* _type_parameter_list = NULL;
			ValaList* _tmp53_;
			gint _type_parameter_size = 0;
			ValaList* _tmp54_;
			gint _tmp55_;
			gint _tmp56_;
			gint _type_parameter_index = 0;
			_tmp53_ = vala_method_get_type_parameters (self);
			_type_parameter_list = _tmp53_;
			_tmp54_ = _type_parameter_list;
			_tmp55_ = vala_collection_get_size ((ValaCollection*) _tmp54_);
			_tmp56_ = _tmp55_;
			_type_parameter_size = _tmp56_;
			_type_parameter_index = -1;
			while (TRUE) {
				gint _tmp57_;
				gint _tmp58_;
				gint _tmp59_;
				ValaTypeParameter* type_parameter = NULL;
				ValaList* _tmp60_;
				gint _tmp61_;
				gpointer _tmp62_;
				ValaGenericType* type_arg = NULL;
				ValaTypeParameter* _tmp63_;
				ValaGenericType* _tmp64_;
				ValaGenericType* _tmp65_;
				ValaList* _tmp66_;
				ValaGenericType* _tmp67_;
				_tmp57_ = _type_parameter_index;
				_type_parameter_index = _tmp57_ + 1;
				_tmp58_ = _type_parameter_index;
				_tmp59_ = _type_parameter_size;
				if (!(_tmp58_ < _tmp59_)) {
					break;
				}
				_tmp60_ = _type_parameter_list;
				_tmp61_ = _type_parameter_index;
				_tmp62_ = vala_list_get (_tmp60_, _tmp61_);
				type_parameter = (ValaTypeParameter*) _tmp62_;
				_tmp63_ = type_parameter;
				_tmp64_ = vala_generic_type_new (_tmp63_);
				type_arg = _tmp64_;
				_tmp65_ = type_arg;
				vala_data_type_set_value_owned ((ValaDataType*) _tmp65_, TRUE);
				_tmp66_ = method_type_args;
				_tmp67_ = type_arg;
				vala_collection_add ((ValaCollection*) _tmp66_, (ValaDataType*) _tmp67_);
				_vala_code_node_unref0 (type_arg);
				_vala_code_node_unref0 (type_parameter);
			}
			_vala_iterable_unref0 (_type_parameter_list);
		}
	}
	_tmp68_ = vala_callable_get_return_type ((ValaCallable*) base_method);
	_tmp69_ = _tmp68_;
	_tmp70_ = object_type;
	_tmp71_ = method_type_args;
	_tmp72_ = vala_data_type_get_actual_type (_tmp69_, (ValaDataType*) _tmp70_, _tmp71_, (ValaCodeNode*) self);
	actual_base_type = _tmp72_;
	_tmp73_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp74_ = _tmp73_;
	_tmp75_ = actual_base_type;
	if (!vala_data_type_equals (_tmp74_, _tmp75_)) {
		ValaDataType* _tmp76_;
		gchar* _tmp77_;
		gchar* _tmp78_;
		ValaDataType* _tmp79_;
		ValaDataType* _tmp80_;
		gchar* _tmp81_;
		gchar* _tmp82_;
		gchar* _tmp83_;
		_tmp76_ = actual_base_type;
		_tmp77_ = vala_data_type_to_prototype_string (_tmp76_, NULL);
		_tmp78_ = _tmp77_;
		_tmp79_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp80_ = _tmp79_;
		_tmp81_ = vala_data_type_to_prototype_string (_tmp80_, NULL);
		_tmp82_ = _tmp81_;
		_tmp83_ = g_strdup_printf ("Base method expected return type `%s', but `%s' was provided", _tmp78_, _tmp82_);
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = _tmp83_;
		_g_free0 (_tmp82_);
		_g_free0 (_tmp78_);
		result = FALSE;
		_vala_code_node_unref0 (actual_base_type);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (object_type);
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	}
	_tmp84_ = self->priv->parameters;
	_tmp85_ = vala_iterable_iterator ((ValaIterable*) _tmp84_);
	method_params_it = _tmp85_;
	param_index = 1;
	{
		ValaList* _base_param_list = NULL;
		ValaList* _tmp86_;
		ValaList* _tmp87_;
		gint _base_param_size = 0;
		ValaList* _tmp88_;
		gint _tmp89_;
		gint _tmp90_;
		gint _base_param_index = 0;
		_tmp86_ = base_method->priv->parameters;
		_tmp87_ = _vala_iterable_ref0 (_tmp86_);
		_base_param_list = _tmp87_;
		_tmp88_ = _base_param_list;
		_tmp89_ = vala_collection_get_size ((ValaCollection*) _tmp88_);
		_tmp90_ = _tmp89_;
		_base_param_size = _tmp90_;
		_base_param_index = -1;
		while (TRUE) {
			gint _tmp91_;
			gint _tmp92_;
			gint _tmp93_;
			ValaParameter* base_param = NULL;
			ValaList* _tmp94_;
			gint _tmp95_;
			gpointer _tmp96_;
			ValaIterator* _tmp97_;
			ValaParameter* param = NULL;
			ValaIterator* _tmp99_;
			gpointer _tmp100_;
			ValaParameter* _tmp101_;
			gboolean _tmp102_;
			gboolean _tmp103_;
			ValaParameter* _tmp104_;
			gboolean _tmp105_;
			gboolean _tmp106_;
			ValaParameter* _tmp108_;
			gboolean _tmp109_;
			gboolean _tmp110_;
			gint _tmp131_;
			_tmp91_ = _base_param_index;
			_base_param_index = _tmp91_ + 1;
			_tmp92_ = _base_param_index;
			_tmp93_ = _base_param_size;
			if (!(_tmp92_ < _tmp93_)) {
				break;
			}
			_tmp94_ = _base_param_list;
			_tmp95_ = _base_param_index;
			_tmp96_ = vala_list_get (_tmp94_, _tmp95_);
			base_param = (ValaParameter*) _tmp96_;
			_tmp97_ = method_params_it;
			if (!vala_iterator_next (_tmp97_)) {
				gchar* _tmp98_;
				_tmp98_ = g_strdup ("too few parameters");
				_g_free0 (_vala_invalid_match);
				_vala_invalid_match = _tmp98_;
				result = FALSE;
				_vala_code_node_unref0 (base_param);
				_vala_iterable_unref0 (_base_param_list);
				_vala_iterator_unref0 (method_params_it);
				_vala_code_node_unref0 (actual_base_type);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (object_type);
				if (invalid_match) {
					*invalid_match = _vala_invalid_match;
				} else {
					_g_free0 (_vala_invalid_match);
				}
				return result;
			}
			_tmp99_ = method_params_it;
			_tmp100_ = vala_iterator_get (_tmp99_);
			param = (ValaParameter*) _tmp100_;
			_tmp101_ = base_param;
			_tmp102_ = vala_parameter_get_ellipsis (_tmp101_);
			_tmp103_ = _tmp102_;
			_tmp104_ = param;
			_tmp105_ = vala_parameter_get_ellipsis (_tmp104_);
			_tmp106_ = _tmp105_;
			if (_tmp103_ != _tmp106_) {
				gchar* _tmp107_;
				_tmp107_ = g_strdup ("ellipsis parameter mismatch");
				_g_free0 (_vala_invalid_match);
				_vala_invalid_match = _tmp107_;
				result = FALSE;
				_vala_code_node_unref0 (param);
				_vala_code_node_unref0 (base_param);
				_vala_iterable_unref0 (_base_param_list);
				_vala_iterator_unref0 (method_params_it);
				_vala_code_node_unref0 (actual_base_type);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (object_type);
				if (invalid_match) {
					*invalid_match = _vala_invalid_match;
				} else {
					_g_free0 (_vala_invalid_match);
				}
				return result;
			}
			_tmp108_ = base_param;
			_tmp109_ = vala_parameter_get_ellipsis (_tmp108_);
			_tmp110_ = _tmp109_;
			if (!_tmp110_) {
				ValaParameter* _tmp111_;
				ValaParameterDirection _tmp112_;
				ValaParameterDirection _tmp113_;
				ValaParameter* _tmp114_;
				ValaParameterDirection _tmp115_;
				ValaParameterDirection _tmp116_;
				ValaParameter* _tmp119_;
				ValaDataType* _tmp120_;
				ValaDataType* _tmp121_;
				ValaObjectType* _tmp122_;
				ValaList* _tmp123_;
				ValaDataType* _tmp124_;
				ValaDataType* _tmp125_;
				ValaParameter* _tmp126_;
				ValaDataType* _tmp127_;
				ValaDataType* _tmp128_;
				_tmp111_ = base_param;
				_tmp112_ = vala_parameter_get_direction (_tmp111_);
				_tmp113_ = _tmp112_;
				_tmp114_ = param;
				_tmp115_ = vala_parameter_get_direction (_tmp114_);
				_tmp116_ = _tmp115_;
				if (_tmp113_ != _tmp116_) {
					gint _tmp117_;
					gchar* _tmp118_;
					_tmp117_ = param_index;
					_tmp118_ = g_strdup_printf ("incompatible direction of parameter %d", _tmp117_);
					_g_free0 (_vala_invalid_match);
					_vala_invalid_match = _tmp118_;
					result = FALSE;
					_vala_code_node_unref0 (param);
					_vala_code_node_unref0 (base_param);
					_vala_iterable_unref0 (_base_param_list);
					_vala_iterator_unref0 (method_params_it);
					_vala_code_node_unref0 (actual_base_type);
					_vala_iterable_unref0 (method_type_args);
					_vala_code_node_unref0 (object_type);
					if (invalid_match) {
						*invalid_match = _vala_invalid_match;
					} else {
						_g_free0 (_vala_invalid_match);
					}
					return result;
				}
				_tmp119_ = base_param;
				_tmp120_ = vala_variable_get_variable_type ((ValaVariable*) _tmp119_);
				_tmp121_ = _tmp120_;
				_tmp122_ = object_type;
				_tmp123_ = method_type_args;
				_tmp124_ = vala_data_type_get_actual_type (_tmp121_, (ValaDataType*) _tmp122_, _tmp123_, (ValaCodeNode*) self);
				_vala_code_node_unref0 (actual_base_type);
				actual_base_type = _tmp124_;
				_tmp125_ = actual_base_type;
				_tmp126_ = param;
				_tmp127_ = vala_variable_get_variable_type ((ValaVariable*) _tmp126_);
				_tmp128_ = _tmp127_;
				if (!vala_data_type_equals (_tmp125_, _tmp128_)) {
					gint _tmp129_;
					gchar* _tmp130_;
					_tmp129_ = param_index;
					_tmp130_ = g_strdup_printf ("incompatible type of parameter %d", _tmp129_);
					_g_free0 (_vala_invalid_match);
					_vala_invalid_match = _tmp130_;
					result = FALSE;
					_vala_code_node_unref0 (param);
					_vala_code_node_unref0 (base_param);
					_vala_iterable_unref0 (_base_param_list);
					_vala_iterator_unref0 (method_params_it);
					_vala_code_node_unref0 (actual_base_type);
					_vala_iterable_unref0 (method_type_args);
					_vala_code_node_unref0 (object_type);
					if (invalid_match) {
						*invalid_match = _vala_invalid_match;
					} else {
						_g_free0 (_vala_invalid_match);
					}
					return result;
				}
			}
			_tmp131_ = param_index;
			param_index = _tmp131_ + 1;
			_vala_code_node_unref0 (param);
			_vala_code_node_unref0 (base_param);
		}
		_vala_iterable_unref0 (_base_param_list);
	}
	_tmp132_ = method_params_it;
	if (vala_iterator_next (_tmp132_)) {
		gchar* _tmp133_;
		_tmp133_ = g_strdup ("too many parameters");
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = _tmp133_;
		result = FALSE;
		_vala_iterator_unref0 (method_params_it);
		_vala_code_node_unref0 (actual_base_type);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (object_type);
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	}
	{
		ValaList* _method_error_type_list = NULL;
		ValaList* _tmp134_;
		gint _method_error_type_size = 0;
		ValaList* _tmp135_;
		gint _tmp136_;
		gint _tmp137_;
		gint _method_error_type_index = 0;
		_tmp134_ = vala_code_node_get_error_types ((ValaCodeNode*) self);
		_method_error_type_list = _tmp134_;
		_tmp135_ = _method_error_type_list;
		_tmp136_ = vala_collection_get_size ((ValaCollection*) _tmp135_);
		_tmp137_ = _tmp136_;
		_method_error_type_size = _tmp137_;
		_method_error_type_index = -1;
		while (TRUE) {
			gint _tmp138_;
			gint _tmp139_;
			gint _tmp140_;
			ValaDataType* method_error_type = NULL;
			ValaList* _tmp141_;
			gint _tmp142_;
			gpointer _tmp143_;
			gboolean match = FALSE;
			gboolean _tmp156_;
			_tmp138_ = _method_error_type_index;
			_method_error_type_index = _tmp138_ + 1;
			_tmp139_ = _method_error_type_index;
			_tmp140_ = _method_error_type_size;
			if (!(_tmp139_ < _tmp140_)) {
				break;
			}
			_tmp141_ = _method_error_type_list;
			_tmp142_ = _method_error_type_index;
			_tmp143_ = vala_list_get (_tmp141_, _tmp142_);
			method_error_type = (ValaDataType*) _tmp143_;
			match = FALSE;
			{
				ValaList* _base_method_error_type_list = NULL;
				ValaList* _tmp144_;
				gint _base_method_error_type_size = 0;
				ValaList* _tmp145_;
				gint _tmp146_;
				gint _tmp147_;
				gint _base_method_error_type_index = 0;
				_tmp144_ = vala_code_node_get_error_types ((ValaCodeNode*) base_method);
				_base_method_error_type_list = _tmp144_;
				_tmp145_ = _base_method_error_type_list;
				_tmp146_ = vala_collection_get_size ((ValaCollection*) _tmp145_);
				_tmp147_ = _tmp146_;
				_base_method_error_type_size = _tmp147_;
				_base_method_error_type_index = -1;
				while (TRUE) {
					gint _tmp148_;
					gint _tmp149_;
					gint _tmp150_;
					ValaDataType* base_method_error_type = NULL;
					ValaList* _tmp151_;
					gint _tmp152_;
					gpointer _tmp153_;
					ValaDataType* _tmp154_;
					ValaDataType* _tmp155_;
					_tmp148_ = _base_method_error_type_index;
					_base_method_error_type_index = _tmp148_ + 1;
					_tmp149_ = _base_method_error_type_index;
					_tmp150_ = _base_method_error_type_size;
					if (!(_tmp149_ < _tmp150_)) {
						break;
					}
					_tmp151_ = _base_method_error_type_list;
					_tmp152_ = _base_method_error_type_index;
					_tmp153_ = vala_list_get (_tmp151_, _tmp152_);
					base_method_error_type = (ValaDataType*) _tmp153_;
					_tmp154_ = method_error_type;
					_tmp155_ = base_method_error_type;
					if (vala_data_type_compatible (_tmp154_, _tmp155_)) {
						match = TRUE;
						_vala_code_node_unref0 (base_method_error_type);
						break;
					}
					_vala_code_node_unref0 (base_method_error_type);
				}
				_vala_iterable_unref0 (_base_method_error_type_list);
			}
			_tmp156_ = match;
			if (!_tmp156_) {
				ValaDataType* _tmp157_;
				gchar* _tmp158_;
				gchar* _tmp159_;
				gchar* _tmp160_;
				_tmp157_ = method_error_type;
				_tmp158_ = vala_code_node_to_string ((ValaCodeNode*) _tmp157_);
				_tmp159_ = _tmp158_;
				_tmp160_ = g_strdup_printf ("incompatible error type `%s'", _tmp159_);
				_g_free0 (_vala_invalid_match);
				_vala_invalid_match = _tmp160_;
				_g_free0 (_tmp159_);
				result = FALSE;
				_vala_code_node_unref0 (method_error_type);
				_vala_iterable_unref0 (_method_error_type_list);
				_vala_iterator_unref0 (method_params_it);
				_vala_code_node_unref0 (actual_base_type);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (object_type);
				if (invalid_match) {
					*invalid_match = _vala_invalid_match;
				} else {
					_g_free0 (_vala_invalid_match);
				}
				return result;
			}
			_vala_code_node_unref0 (method_error_type);
		}
		_vala_iterable_unref0 (_method_error_type_list);
	}
	_tmp161_ = base_method->priv->_coroutine;
	_tmp162_ = self->priv->_coroutine;
	if (_tmp161_ != _tmp162_) {
		gchar* _tmp163_;
		_tmp163_ = g_strdup ("async mismatch");
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = _tmp163_;
		result = FALSE;
		_vala_iterator_unref0 (method_params_it);
		_vala_code_node_unref0 (actual_base_type);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (object_type);
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	}
	_g_free0 (_vala_invalid_match);
	_vala_invalid_match = NULL;
	result = TRUE;
	_vala_iterator_unref0 (method_params_it);
	_vala_code_node_unref0 (actual_base_type);
	_vala_iterable_unref0 (method_type_args);
	_vala_code_node_unref0 (object_type);
	if (invalid_match) {
		*invalid_match = _vala_invalid_match;
	} else {
		_g_free0 (_vala_invalid_match);
	}
	return result;
}


/**
 * Appends the specified parameter to the list of type parameters.
 *
 * @param p a type parameter
 */
void
vala_method_add_type_parameter (ValaMethod* self, 
                                ValaTypeParameter* p)
{
	ValaList* _tmp0_;
	ValaList* _tmp3_;
	ValaScope* _tmp4_;
	ValaScope* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = self->priv->type_parameters;
	if (_tmp0_ == NULL) {
		GEqualFunc _tmp1_;
		ValaArrayList* _tmp2_;
		_tmp1_ = g_direct_equal;
		_tmp2_ = vala_array_list_new (VALA_TYPE_TYPEPARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp1_);
		_vala_iterable_unref0 (self->priv->type_parameters);
		self->priv->type_parameters = (ValaList*) _tmp2_;
	}
	_tmp3_ = self->priv->type_parameters;
	vala_collection_add ((ValaCollection*) _tmp3_, p);
	_tmp4_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_symbol_get_name ((ValaSymbol*) p);
	_tmp7_ = _tmp6_;
	vala_scope_add (_tmp5_, _tmp7_, (ValaSymbol*) p);
}


/**
 * Returns a copy of the type parameter list.
 *
 * @return list of type parameters
 */
ValaList*
vala_method_get_type_parameters (ValaMethod* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp3_;
	ValaList* _tmp6_;
	ValaList* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->type_parameters;
	if (_tmp0_ != NULL) {
		ValaList* _tmp1_;
		ValaList* _tmp2_;
		_tmp1_ = self->priv->type_parameters;
		_tmp2_ = _vala_iterable_ref0 (_tmp1_);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = vala_method__empty_type_parameter_list;
	if (_tmp3_ == NULL) {
		GEqualFunc _tmp4_;
		ValaArrayList* _tmp5_;
		_tmp4_ = g_direct_equal;
		_tmp5_ = vala_array_list_new (VALA_TYPE_TYPEPARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp4_);
		_vala_iterable_unref0 (vala_method__empty_type_parameter_list);
		vala_method__empty_type_parameter_list = (ValaList*) _tmp5_;
	}
	_tmp6_ = vala_method__empty_type_parameter_list;
	_tmp7_ = _vala_iterable_ref0 (_tmp6_);
	result = _tmp7_;
	return result;
}


gint
vala_method_get_type_parameter_index (ValaMethod* self, 
                                      const gchar* name)
{
	gint result = 0;
	ValaList* _tmp0_;
	gint i = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (name != NULL, 0);
	_tmp0_ = self->priv->type_parameters;
	if (_tmp0_ == NULL) {
		result = -1;
		return result;
	}
	i = 0;
	{
		ValaList* _parameter_list = NULL;
		ValaList* _tmp1_;
		ValaList* _tmp2_;
		gint _parameter_size = 0;
		ValaList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _parameter_index = 0;
		_tmp1_ = self->priv->type_parameters;
		_tmp2_ = _vala_iterable_ref0 (_tmp1_);
		_parameter_list = _tmp2_;
		_tmp3_ = _parameter_list;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_parameter_size = _tmp5_;
		_parameter_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			ValaTypeParameter* parameter = NULL;
			ValaList* _tmp9_;
			gint _tmp10_;
			gpointer _tmp11_;
			ValaTypeParameter* _tmp12_;
			const gchar* _tmp13_;
			const gchar* _tmp14_;
			gint _tmp15_;
			_tmp6_ = _parameter_index;
			_parameter_index = _tmp6_ + 1;
			_tmp7_ = _parameter_index;
			_tmp8_ = _parameter_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _parameter_list;
			_tmp10_ = _parameter_index;
			_tmp11_ = vala_list_get (_tmp9_, _tmp10_);
			parameter = (ValaTypeParameter*) _tmp11_;
			_tmp12_ = parameter;
			_tmp13_ = vala_symbol_get_name ((ValaSymbol*) _tmp12_);
			_tmp14_ = _tmp13_;
			if (g_strcmp0 (_tmp14_, name) == 0) {
				result = i;
				_vala_code_node_unref0 (parameter);
				_vala_iterable_unref0 (_parameter_list);
				return result;
			}
			_tmp15_ = i;
			i = _tmp15_ + 1;
			_vala_code_node_unref0 (parameter);
		}
		_vala_iterable_unref0 (_parameter_list);
	}
	result = -1;
	return result;
}


/**
 * Adds a precondition to this method.
 *
 * @param precondition a boolean precondition expression
 */
void
vala_method_add_precondition (ValaMethod* self, 
                              ValaExpression* precondition)
{
	ValaList* _tmp0_;
	ValaList* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (precondition != NULL);
	_tmp0_ = self->priv->preconditions;
	if (_tmp0_ == NULL) {
		GEqualFunc _tmp1_;
		ValaArrayList* _tmp2_;
		_tmp1_ = g_direct_equal;
		_tmp2_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp1_);
		_vala_iterable_unref0 (self->priv->preconditions);
		self->priv->preconditions = (ValaList*) _tmp2_;
	}
	_tmp3_ = self->priv->preconditions;
	vala_collection_add ((ValaCollection*) _tmp3_, precondition);
	vala_code_node_set_parent_node ((ValaCodeNode*) precondition, (ValaCodeNode*) self);
}


/**
 * Returns a copy of the list of preconditions of this method.
 *
 * @return list of preconditions
 */
ValaList*
vala_method_get_preconditions (ValaMethod* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp3_;
	ValaList* _tmp6_;
	ValaList* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->preconditions;
	if (_tmp0_ != NULL) {
		ValaList* _tmp1_;
		ValaList* _tmp2_;
		_tmp1_ = self->priv->preconditions;
		_tmp2_ = _vala_iterable_ref0 (_tmp1_);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = vala_method__empty_expression_list;
	if (_tmp3_ == NULL) {
		GEqualFunc _tmp4_;
		ValaArrayList* _tmp5_;
		_tmp4_ = g_direct_equal;
		_tmp5_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp4_);
		_vala_iterable_unref0 (vala_method__empty_expression_list);
		vala_method__empty_expression_list = (ValaList*) _tmp5_;
	}
	_tmp6_ = vala_method__empty_expression_list;
	_tmp7_ = _vala_iterable_ref0 (_tmp6_);
	result = _tmp7_;
	return result;
}


/**
 * Adds a postcondition to this method.
 *
 * @param postcondition a boolean postcondition expression
 */
void
vala_method_add_postcondition (ValaMethod* self, 
                               ValaExpression* postcondition)
{
	ValaList* _tmp0_;
	ValaList* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (postcondition != NULL);
	_tmp0_ = self->priv->postconditions;
	if (_tmp0_ == NULL) {
		GEqualFunc _tmp1_;
		ValaArrayList* _tmp2_;
		_tmp1_ = g_direct_equal;
		_tmp2_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp1_);
		_vala_iterable_unref0 (self->priv->postconditions);
		self->priv->postconditions = (ValaList*) _tmp2_;
	}
	_tmp3_ = self->priv->postconditions;
	vala_collection_add ((ValaCollection*) _tmp3_, postcondition);
	vala_code_node_set_parent_node ((ValaCodeNode*) postcondition, (ValaCodeNode*) self);
}


/**
 * Returns a copy of the list of postconditions of this method.
 *
 * @return list of postconditions
 */
ValaList*
vala_method_get_postconditions (ValaMethod* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp3_;
	ValaList* _tmp6_;
	ValaList* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->postconditions;
	if (_tmp0_ != NULL) {
		ValaList* _tmp1_;
		ValaList* _tmp2_;
		_tmp1_ = self->priv->postconditions;
		_tmp2_ = _vala_iterable_ref0 (_tmp1_);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = vala_method__empty_expression_list;
	if (_tmp3_ == NULL) {
		GEqualFunc _tmp4_;
		ValaArrayList* _tmp5_;
		_tmp4_ = g_direct_equal;
		_tmp5_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp4_);
		_vala_iterable_unref0 (vala_method__empty_expression_list);
		vala_method__empty_expression_list = (ValaList*) _tmp5_;
	}
	_tmp6_ = vala_method__empty_expression_list;
	_tmp7_ = _vala_iterable_ref0 (_tmp6_);
	result = _tmp7_;
	return result;
}


static void
vala_method_real_replace_type (ValaCodeNode* base, 
                               ValaDataType* old_type, 
                               ValaDataType* new_type)
{
	ValaMethod * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	ValaList* error_types = NULL;
	ValaList* _tmp4_;
	self = (ValaMethod*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_method_get_base_interface_type (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_method_set_base_interface_type (self, new_type);
		return;
	}
	_tmp2_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == old_type) {
		vala_callable_set_return_type ((ValaCallable*) self, new_type);
		return;
	}
	_tmp4_ = vala_code_node_get_error_types ((ValaCodeNode*) self);
	error_types = _tmp4_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				gint _tmp7_;
				ValaList* _tmp8_;
				gint _tmp9_;
				gint _tmp10_;
				ValaList* _tmp11_;
				gint _tmp12_;
				gpointer _tmp13_;
				ValaDataType* _tmp14_;
				gboolean _tmp15_;
				if (!_tmp5_) {
					gint _tmp6_;
					_tmp6_ = i;
					i = _tmp6_ + 1;
				}
				_tmp5_ = FALSE;
				_tmp7_ = i;
				_tmp8_ = error_types;
				_tmp9_ = vala_collection_get_size ((ValaCollection*) _tmp8_);
				_tmp10_ = _tmp9_;
				if (!(_tmp7_ < _tmp10_)) {
					break;
				}
				_tmp11_ = error_types;
				_tmp12_ = i;
				_tmp13_ = vala_list_get (_tmp11_, _tmp12_);
				_tmp14_ = (ValaDataType*) _tmp13_;
				_tmp15_ = _tmp14_ == old_type;
				_vala_code_node_unref0 (_tmp14_);
				if (_tmp15_) {
					ValaList* _tmp16_;
					gint _tmp17_;
					_tmp16_ = error_types;
					_tmp17_ = i;
					vala_list_set (_tmp16_, _tmp17_, new_type);
					_vala_iterable_unref0 (error_types);
					return;
				}
			}
		}
	}
	_vala_iterable_unref0 (error_types);
}


static void
vala_method_find_base_methods (ValaMethod* self)
{
	gboolean _tmp0_;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->base_methods_valid;
	if (_tmp0_) {
		return;
	}
	_tmp1_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp2_ = _tmp1_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, VALA_TYPE_CLASS)) {
		if (!G_TYPE_CHECK_INSTANCE_TYPE (self, VALA_TYPE_CREATION_METHOD)) {
			ValaSymbol* _tmp3_;
			ValaSymbol* _tmp4_;
			gboolean _tmp5_ = FALSE;
			gboolean _tmp6_ = FALSE;
			gboolean _tmp7_;
			_tmp3_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp4_ = _tmp3_;
			vala_method_find_base_interface_method (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, VALA_TYPE_CLASS, ValaClass));
			_tmp7_ = self->priv->_is_virtual;
			if (_tmp7_) {
				_tmp6_ = TRUE;
			} else {
				gboolean _tmp8_;
				_tmp8_ = self->priv->_is_abstract;
				_tmp6_ = _tmp8_;
			}
			if (_tmp6_) {
				_tmp5_ = TRUE;
			} else {
				gboolean _tmp9_;
				_tmp9_ = self->priv->_overrides;
				_tmp5_ = _tmp9_;
			}
			if (_tmp5_) {
				ValaSymbol* _tmp10_;
				ValaSymbol* _tmp11_;
				_tmp10_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
				_tmp11_ = _tmp10_;
				vala_method_find_base_class_method (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, VALA_TYPE_CLASS, ValaClass));
			}
		}
	} else {
		ValaSymbol* _tmp12_;
		ValaSymbol* _tmp13_;
		_tmp12_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp13_ = _tmp12_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp13_, VALA_TYPE_INTERFACE)) {
			gboolean _tmp14_ = FALSE;
			gboolean _tmp15_;
			_tmp15_ = self->priv->_is_virtual;
			if (_tmp15_) {
				_tmp14_ = TRUE;
			} else {
				gboolean _tmp16_;
				_tmp16_ = self->priv->_is_abstract;
				_tmp14_ = _tmp16_;
			}
			if (_tmp14_) {
				self->priv->_base_interface_method = self;
			}
		}
	}
	self->priv->base_methods_valid = TRUE;
}


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static void
vala_method_find_base_class_method (ValaMethod* self, 
                                    ValaClass* cl)
{
	ValaSymbol* sym = NULL;
	ValaScope* _tmp0_;
	ValaScope* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	ValaSymbol* _tmp4_;
	ValaSymbol* _tmp5_;
	ValaSymbol* _tmp12_;
	ValaClass* _tmp36_;
	ValaClass* _tmp37_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	_tmp0_ = vala_symbol_get_scope ((ValaSymbol*) cl);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_symbol_get_name ((ValaSymbol*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_scope_lookup (_tmp1_, _tmp3_);
	sym = _tmp4_;
	_tmp5_ = sym;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, VALA_TYPE_SIGNAL)) {
		ValaSignal* sig = NULL;
		ValaSymbol* _tmp6_;
		ValaSignal* _tmp7_;
		ValaSignal* _tmp8_;
		ValaMethod* _tmp9_;
		ValaMethod* _tmp10_;
		ValaSymbol* _tmp11_;
		_tmp6_ = sym;
		_tmp7_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, VALA_TYPE_SIGNAL, ValaSignal));
		sig = _tmp7_;
		_tmp8_ = sig;
		_tmp9_ = vala_signal_get_default_handler (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp10_);
		_vala_code_node_unref0 (sym);
		sym = _tmp11_;
		_vala_code_node_unref0 (sig);
	}
	_tmp12_ = sym;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, VALA_TYPE_METHOD)) {
		ValaMethod* base_method = NULL;
		ValaSymbol* _tmp13_;
		ValaMethod* _tmp14_;
		gboolean _tmp15_ = FALSE;
		ValaMethod* _tmp16_;
		gboolean _tmp17_;
		_tmp13_ = sym;
		_tmp14_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, VALA_TYPE_METHOD, ValaMethod));
		base_method = _tmp14_;
		_tmp16_ = base_method;
		_tmp17_ = _tmp16_->priv->_is_abstract;
		if (_tmp17_) {
			_tmp15_ = TRUE;
		} else {
			ValaMethod* _tmp18_;
			gboolean _tmp19_;
			_tmp18_ = base_method;
			_tmp19_ = _tmp18_->priv->_is_virtual;
			_tmp15_ = _tmp19_;
		}
		if (_tmp15_) {
			gchar* invalid_match = NULL;
			ValaMethod* _tmp20_;
			gchar* _tmp21_ = NULL;
			gboolean _tmp22_;
			ValaMethod* _tmp35_;
			_tmp20_ = base_method;
			_tmp22_ = vala_method_compatible (self, _tmp20_, &_tmp21_);
			_g_free0 (invalid_match);
			invalid_match = _tmp21_;
			if (!_tmp22_) {
				ValaMethodType* base_method_type = NULL;
				ValaMethod* _tmp23_;
				ValaMethodType* _tmp24_;
				ValaSourceReference* _tmp25_;
				ValaSourceReference* _tmp26_;
				gchar* _tmp27_;
				gchar* _tmp28_;
				ValaMethodType* _tmp29_;
				gchar* _tmp30_;
				gchar* _tmp31_;
				const gchar* _tmp32_;
				gchar* _tmp33_;
				gchar* _tmp34_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp23_ = base_method;
				_tmp24_ = vala_method_type_new (_tmp23_);
				base_method_type = _tmp24_;
				_tmp25_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp26_ = _tmp25_;
				_tmp27_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp28_ = _tmp27_;
				_tmp29_ = base_method_type;
				_tmp30_ = vala_data_type_to_prototype_string ((ValaDataType*) _tmp29_, NULL);
				_tmp31_ = _tmp30_;
				_tmp32_ = invalid_match;
				_tmp33_ = g_strdup_printf ("overriding method `%s' is incompatible with base method `%s': %s.", _tmp28_, _tmp31_, _tmp32_);
				_tmp34_ = _tmp33_;
				vala_report_error (_tmp26_, _tmp34_);
				_g_free0 (_tmp34_);
				_g_free0 (_tmp31_);
				_g_free0 (_tmp28_);
				_vala_code_node_unref0 (base_method_type);
				_g_free0 (invalid_match);
				_vala_code_node_unref0 (base_method);
				_vala_code_node_unref0 (sym);
				return;
			}
			_tmp35_ = base_method;
			self->priv->_base_method = _tmp35_;
			_g_free0 (invalid_match);
			_vala_code_node_unref0 (base_method);
			_vala_code_node_unref0 (sym);
			return;
		}
		_vala_code_node_unref0 (base_method);
	}
	_tmp36_ = vala_class_get_base_class (cl);
	_tmp37_ = _tmp36_;
	if (_tmp37_ != NULL) {
		ValaClass* _tmp38_;
		ValaClass* _tmp39_;
		_tmp38_ = vala_class_get_base_class (cl);
		_tmp39_ = _tmp38_;
		vala_method_find_base_class_method (self, _tmp39_);
	}
	_vala_code_node_unref0 (sym);
}


static void
vala_method_find_base_interface_method (ValaMethod* self, 
                                        ValaClass* cl)
{
	ValaDataType* _tmp83_;
	ValaDataType* _tmp84_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	{
		ValaList* _type_list = NULL;
		ValaList* _tmp0_;
		gint _type_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _type_index = 0;
		_tmp0_ = vala_class_get_base_types (cl);
		_type_list = _tmp0_;
		_tmp1_ = _type_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_type_size = _tmp3_;
		_type_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			gint _tmp6_;
			ValaDataType* type = NULL;
			ValaList* _tmp7_;
			gint _tmp8_;
			gpointer _tmp9_;
			ValaDataType* _tmp10_;
			ValaTypeSymbol* _tmp11_;
			ValaTypeSymbol* _tmp12_;
			_tmp4_ = _type_index;
			_type_index = _tmp4_ + 1;
			_tmp5_ = _type_index;
			_tmp6_ = _type_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _type_list;
			_tmp8_ = _type_index;
			_tmp9_ = vala_list_get (_tmp7_, _tmp8_);
			type = (ValaDataType*) _tmp9_;
			_tmp10_ = type;
			_tmp11_ = vala_data_type_get_data_type (_tmp10_);
			_tmp12_ = _tmp11_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, VALA_TYPE_INTERFACE)) {
				gboolean _tmp13_ = FALSE;
				ValaDataType* _tmp14_;
				ValaDataType* _tmp15_;
				ValaSymbol* sym = NULL;
				ValaDataType* _tmp23_;
				ValaTypeSymbol* _tmp24_;
				ValaTypeSymbol* _tmp25_;
				ValaScope* _tmp26_;
				ValaScope* _tmp27_;
				const gchar* _tmp28_;
				const gchar* _tmp29_;
				ValaSymbol* _tmp30_;
				ValaSymbol* _tmp31_;
				ValaSymbol* _tmp38_;
				_tmp14_ = vala_method_get_base_interface_type (self);
				_tmp15_ = _tmp14_;
				if (_tmp15_ != NULL) {
					ValaDataType* _tmp16_;
					ValaDataType* _tmp17_;
					ValaTypeSymbol* _tmp18_;
					ValaTypeSymbol* _tmp19_;
					ValaDataType* _tmp20_;
					ValaTypeSymbol* _tmp21_;
					ValaTypeSymbol* _tmp22_;
					_tmp16_ = vala_method_get_base_interface_type (self);
					_tmp17_ = _tmp16_;
					_tmp18_ = vala_data_type_get_data_type (_tmp17_);
					_tmp19_ = _tmp18_;
					_tmp20_ = type;
					_tmp21_ = vala_data_type_get_data_type (_tmp20_);
					_tmp22_ = _tmp21_;
					_tmp13_ = _tmp19_ != _tmp22_;
				} else {
					_tmp13_ = FALSE;
				}
				if (_tmp13_) {
					_vala_code_node_unref0 (type);
					continue;
				}
				_tmp23_ = type;
				_tmp24_ = vala_data_type_get_data_type (_tmp23_);
				_tmp25_ = _tmp24_;
				_tmp26_ = vala_symbol_get_scope ((ValaSymbol*) _tmp25_);
				_tmp27_ = _tmp26_;
				_tmp28_ = vala_symbol_get_name ((ValaSymbol*) self);
				_tmp29_ = _tmp28_;
				_tmp30_ = vala_scope_lookup (_tmp27_, _tmp29_);
				sym = _tmp30_;
				_tmp31_ = sym;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp31_, VALA_TYPE_SIGNAL)) {
					ValaSignal* sig = NULL;
					ValaSymbol* _tmp32_;
					ValaSignal* _tmp33_;
					ValaSignal* _tmp34_;
					ValaMethod* _tmp35_;
					ValaMethod* _tmp36_;
					ValaSymbol* _tmp37_;
					_tmp32_ = sym;
					_tmp33_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, VALA_TYPE_SIGNAL, ValaSignal));
					sig = _tmp33_;
					_tmp34_ = sig;
					_tmp35_ = vala_signal_get_default_handler (_tmp34_);
					_tmp36_ = _tmp35_;
					_tmp37_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp36_);
					_vala_code_node_unref0 (sym);
					sym = _tmp37_;
					_vala_code_node_unref0 (sig);
				}
				_tmp38_ = sym;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp38_, VALA_TYPE_METHOD)) {
					ValaMethod* base_method = NULL;
					ValaSymbol* _tmp39_;
					ValaMethod* _tmp40_;
					gboolean _tmp41_ = FALSE;
					ValaMethod* _tmp42_;
					gboolean _tmp43_;
					_tmp39_ = sym;
					_tmp40_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp39_, VALA_TYPE_METHOD, ValaMethod));
					base_method = _tmp40_;
					_tmp42_ = base_method;
					_tmp43_ = _tmp42_->priv->_is_abstract;
					if (_tmp43_) {
						_tmp41_ = TRUE;
					} else {
						ValaMethod* _tmp44_;
						gboolean _tmp45_;
						_tmp44_ = base_method;
						_tmp45_ = _tmp44_->priv->_is_virtual;
						_tmp41_ = _tmp45_;
					}
					if (_tmp41_) {
						ValaDataType* _tmp46_;
						ValaDataType* _tmp47_;
						gchar* invalid_match = NULL;
						ValaMethod* _tmp67_;
						gchar* _tmp68_ = NULL;
						gboolean _tmp69_;
						ValaMethod* _tmp82_;
						_tmp46_ = vala_method_get_base_interface_type (self);
						_tmp47_ = _tmp46_;
						if (_tmp47_ == NULL) {
							gboolean has_explicit_implementation = FALSE;
							gboolean _tmp66_;
							has_explicit_implementation = FALSE;
							{
								ValaList* _m_list = NULL;
								ValaList* _tmp48_;
								gint _m_size = 0;
								ValaList* _tmp49_;
								gint _tmp50_;
								gint _tmp51_;
								gint _m_index = 0;
								_tmp48_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) cl);
								_m_list = _tmp48_;
								_tmp49_ = _m_list;
								_tmp50_ = vala_collection_get_size ((ValaCollection*) _tmp49_);
								_tmp51_ = _tmp50_;
								_m_size = _tmp51_;
								_m_index = -1;
								while (TRUE) {
									gint _tmp52_;
									gint _tmp53_;
									gint _tmp54_;
									ValaMethod* m = NULL;
									ValaList* _tmp55_;
									gint _tmp56_;
									gpointer _tmp57_;
									gboolean _tmp58_ = FALSE;
									ValaMethod* _tmp59_;
									ValaDataType* _tmp60_;
									ValaDataType* _tmp61_;
									_tmp52_ = _m_index;
									_m_index = _tmp52_ + 1;
									_tmp53_ = _m_index;
									_tmp54_ = _m_size;
									if (!(_tmp53_ < _tmp54_)) {
										break;
									}
									_tmp55_ = _m_list;
									_tmp56_ = _m_index;
									_tmp57_ = vala_list_get (_tmp55_, _tmp56_);
									m = (ValaMethod*) _tmp57_;
									_tmp59_ = m;
									_tmp60_ = vala_method_get_base_interface_type (_tmp59_);
									_tmp61_ = _tmp60_;
									if (_tmp61_ != NULL) {
										ValaMethod* _tmp62_;
										ValaMethod* _tmp63_;
										ValaMethod* _tmp64_;
										ValaMethod* _tmp65_;
										_tmp62_ = base_method;
										_tmp63_ = m;
										_tmp64_ = vala_method_get_base_interface_method (_tmp63_);
										_tmp65_ = _tmp64_;
										_tmp58_ = _tmp62_ == _tmp65_;
									} else {
										_tmp58_ = FALSE;
									}
									if (_tmp58_) {
										has_explicit_implementation = TRUE;
										_vala_code_node_unref0 (m);
										break;
									}
									_vala_code_node_unref0 (m);
								}
								_vala_iterable_unref0 (_m_list);
							}
							_tmp66_ = has_explicit_implementation;
							if (_tmp66_) {
								_vala_code_node_unref0 (base_method);
								_vala_code_node_unref0 (sym);
								_vala_code_node_unref0 (type);
								continue;
							}
						}
						invalid_match = NULL;
						_tmp67_ = base_method;
						_tmp69_ = vala_method_compatible (self, _tmp67_, &_tmp68_);
						_g_free0 (invalid_match);
						invalid_match = _tmp68_;
						if (!_tmp69_) {
							ValaMethodType* base_method_type = NULL;
							ValaMethod* _tmp70_;
							ValaMethodType* _tmp71_;
							ValaSourceReference* _tmp72_;
							ValaSourceReference* _tmp73_;
							gchar* _tmp74_;
							gchar* _tmp75_;
							ValaMethodType* _tmp76_;
							gchar* _tmp77_;
							gchar* _tmp78_;
							const gchar* _tmp79_;
							gchar* _tmp80_;
							gchar* _tmp81_;
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
							_tmp70_ = base_method;
							_tmp71_ = vala_method_type_new (_tmp70_);
							base_method_type = _tmp71_;
							_tmp72_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp73_ = _tmp72_;
							_tmp74_ = vala_symbol_get_full_name ((ValaSymbol*) self);
							_tmp75_ = _tmp74_;
							_tmp76_ = base_method_type;
							_tmp77_ = vala_data_type_to_prototype_string ((ValaDataType*) _tmp76_, NULL);
							_tmp78_ = _tmp77_;
							_tmp79_ = invalid_match;
							_tmp80_ = g_strdup_printf ("overriding method `%s' is incompatible with base method `%s': %s.", _tmp75_, _tmp78_, _tmp79_);
							_tmp81_ = _tmp80_;
							vala_report_error (_tmp73_, _tmp81_);
							_g_free0 (_tmp81_);
							_g_free0 (_tmp78_);
							_g_free0 (_tmp75_);
							_vala_code_node_unref0 (base_method_type);
							_g_free0 (invalid_match);
							_vala_code_node_unref0 (base_method);
							_vala_code_node_unref0 (sym);
							_vala_code_node_unref0 (type);
							_vala_iterable_unref0 (_type_list);
							return;
						}
						_tmp82_ = base_method;
						self->priv->_base_interface_method = _tmp82_;
						_g_free0 (invalid_match);
						_vala_code_node_unref0 (base_method);
						_vala_code_node_unref0 (sym);
						_vala_code_node_unref0 (type);
						_vala_iterable_unref0 (_type_list);
						return;
					}
					_vala_code_node_unref0 (base_method);
				}
				_vala_code_node_unref0 (sym);
			}
			_vala_code_node_unref0 (type);
		}
		_vala_iterable_unref0 (_type_list);
	}
	_tmp83_ = vala_method_get_base_interface_type (self);
	_tmp84_ = _tmp83_;
	if (_tmp84_ != NULL) {
		ValaSourceReference* _tmp85_;
		ValaSourceReference* _tmp86_;
		gchar* _tmp87_;
		gchar* _tmp88_;
		gchar* _tmp89_;
		gchar* _tmp90_;
		_tmp85_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp86_ = _tmp85_;
		_tmp87_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp88_ = _tmp87_;
		_tmp89_ = g_strdup_printf ("`%s': no suitable interface method found to implement", _tmp88_);
		_tmp90_ = _tmp89_;
		vala_report_error (_tmp86_, _tmp90_);
		_g_free0 (_tmp90_);
		_g_free0 (_tmp88_);
	}
}


static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}


static gboolean
vala_method_real_check (ValaCodeNode* base, 
                        ValaCodeContext* context)
{
	ValaMethod * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaAttribute* _tmp4_;
	ValaAttribute* _tmp5_;
	gboolean _tmp6_;
	ValaAttribute* _tmp10_;
	ValaAttribute* _tmp11_;
	gboolean _tmp12_;
	gboolean _tmp15_;
	gboolean _tmp67_ = FALSE;
	gboolean _tmp68_;
	gboolean _tmp108_ = FALSE;
	gboolean _tmp109_ = FALSE;
	gboolean _tmp110_;
	ValaSourceFile* old_source_file = NULL;
	ValaSemanticAnalyzer* _tmp115_;
	ValaSemanticAnalyzer* _tmp116_;
	ValaSourceFile* _tmp117_;
	ValaSourceFile* _tmp118_;
	ValaSourceFile* _tmp119_;
	ValaSymbol* old_symbol = NULL;
	ValaSemanticAnalyzer* _tmp120_;
	ValaSemanticAnalyzer* _tmp121_;
	ValaSymbol* _tmp122_;
	ValaSymbol* _tmp123_;
	ValaSymbol* _tmp124_;
	ValaSourceReference* _tmp125_;
	ValaSourceReference* _tmp126_;
	ValaSemanticAnalyzer* _tmp133_;
	ValaSemanticAnalyzer* _tmp134_;
	ValaDataType* _tmp135_;
	ValaDataType* _tmp136_;
	ValaAttribute* init_attr = NULL;
	ValaAttribute* _tmp137_;
	ValaAttribute* _tmp138_;
	ValaDataType* _tmp145_;
	ValaDataType* _tmp146_;
	gboolean _tmp149_ = FALSE;
	gboolean _tmp150_ = FALSE;
	gboolean _tmp151_ = FALSE;
	ValaList* _tmp152_;
	gint _tmp153_;
	gint _tmp154_;
	gboolean _tmp168_;
	ValaLocalVariable* _tmp227_;
	ValaLocalVariable* _tmp228_;
	ValaList* _tmp231_;
	ValaList* _tmp244_;
	ValaBlock* _tmp257_;
	ValaBlock* _tmp258_;
	ValaSemanticAnalyzer* _tmp261_;
	ValaSemanticAnalyzer* _tmp262_;
	ValaStruct* _tmp263_;
	ValaStruct* _tmp264_;
	gboolean _tmp300_ = FALSE;
	gboolean _tmp301_ = FALSE;
	ValaDataType* _tmp302_;
	ValaDataType* _tmp303_;
	ValaSemanticAnalyzer* _tmp351_;
	ValaSemanticAnalyzer* _tmp352_;
	ValaSourceFile* _tmp353_;
	ValaSemanticAnalyzer* _tmp354_;
	ValaSemanticAnalyzer* _tmp355_;
	ValaSymbol* _tmp356_;
	gboolean _tmp357_ = FALSE;
	gboolean _tmp358_ = FALSE;
	gboolean _tmp359_ = FALSE;
	gboolean _tmp360_;
	gboolean _tmp361_;
	ValaSemanticAnalyzer* _tmp377_;
	ValaSemanticAnalyzer* _tmp378_;
	ValaDataType* _tmp379_;
	ValaDataType* _tmp380_;
	ValaBlock* _tmp435_;
	ValaBlock* _tmp436_;
	ValaAttribute* _tmp497_;
	ValaAttribute* _tmp498_;
	gboolean _tmp499_;
	gboolean _tmp500_;
	gboolean _tmp501_;
	self = (ValaMethod*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "DestroysInstance");
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_ != NULL;
	_vala_code_node_unref0 (_tmp5_);
	if (_tmp6_) {
		ValaParameter* _tmp7_;
		ValaDataType* _tmp8_;
		ValaDataType* _tmp9_;
		_tmp7_ = self->priv->_this_parameter;
		_tmp8_ = vala_variable_get_variable_type ((ValaVariable*) _tmp7_);
		_tmp9_ = _tmp8_;
		vala_data_type_set_value_owned (_tmp9_, TRUE);
	}
	_tmp10_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "NoThrow");
	_tmp11_ = _tmp10_;
	_tmp12_ = _tmp11_ != NULL;
	_vala_code_node_unref0 (_tmp11_);
	if (_tmp12_) {
		ValaList* _tmp13_;
		ValaList* _tmp14_;
		_tmp13_ = vala_code_node_get_error_types ((ValaCodeNode*) self);
		_tmp14_ = _tmp13_;
		vala_collection_clear ((ValaCollection*) _tmp14_);
		_vala_iterable_unref0 (_tmp14_);
	}
	_tmp15_ = self->priv->_is_abstract;
	if (_tmp15_) {
		ValaSymbol* _tmp16_;
		ValaSymbol* _tmp17_;
		_tmp16_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp17_ = _tmp16_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp17_, VALA_TYPE_CLASS)) {
			ValaClass* cl = NULL;
			ValaSymbol* _tmp18_;
			ValaSymbol* _tmp19_;
			ValaClass* _tmp20_;
			ValaClass* _tmp21_;
			gboolean _tmp22_;
			gboolean _tmp23_;
			_tmp18_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp19_ = _tmp18_;
			_tmp20_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, VALA_TYPE_CLASS, ValaClass));
			cl = _tmp20_;
			_tmp21_ = cl;
			_tmp22_ = vala_class_get_is_abstract (_tmp21_);
			_tmp23_ = _tmp22_;
			if (!_tmp23_) {
				ValaSourceReference* _tmp24_;
				ValaSourceReference* _tmp25_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp24_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp25_ = _tmp24_;
				vala_report_error (_tmp25_, "Abstract methods may not be declared in non-abstract classes");
				result = FALSE;
				_vala_code_node_unref0 (cl);
				return result;
			}
			_vala_code_node_unref0 (cl);
		} else {
			ValaSymbol* _tmp26_;
			ValaSymbol* _tmp27_;
			_tmp26_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp27_ = _tmp26_;
			if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp27_, VALA_TYPE_INTERFACE)) {
				ValaSourceReference* _tmp28_;
				ValaSourceReference* _tmp29_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp28_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp29_ = _tmp28_;
				vala_report_error (_tmp29_, "Abstract methods may not be declared outside of classes and interfaces");
				result = FALSE;
				return result;
			}
		}
	} else {
		gboolean _tmp30_;
		_tmp30_ = self->priv->_is_virtual;
		if (_tmp30_) {
			gboolean _tmp31_ = FALSE;
			ValaSymbol* _tmp32_;
			ValaSymbol* _tmp33_;
			ValaSymbol* _tmp38_;
			ValaSymbol* _tmp39_;
			_tmp32_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp33_ = _tmp32_;
			if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp33_, VALA_TYPE_CLASS)) {
				ValaSymbol* _tmp34_;
				ValaSymbol* _tmp35_;
				_tmp34_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
				_tmp35_ = _tmp34_;
				_tmp31_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp35_, VALA_TYPE_INTERFACE);
			} else {
				_tmp31_ = FALSE;
			}
			if (_tmp31_) {
				ValaSourceReference* _tmp36_;
				ValaSourceReference* _tmp37_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp36_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp37_ = _tmp36_;
				vala_report_error (_tmp37_, "Virtual methods may not be declared outside of classes and interfaces");
				result = FALSE;
				return result;
			}
			_tmp38_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp39_ = _tmp38_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp39_, VALA_TYPE_CLASS)) {
				ValaClass* cl = NULL;
				ValaSymbol* _tmp40_;
				ValaSymbol* _tmp41_;
				ValaClass* _tmp42_;
				gboolean _tmp43_ = FALSE;
				ValaClass* _tmp44_;
				gboolean _tmp45_;
				gboolean _tmp46_;
				_tmp40_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
				_tmp41_ = _tmp40_;
				_tmp42_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp41_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp42_;
				_tmp44_ = cl;
				_tmp45_ = vala_class_get_is_compact (_tmp44_);
				_tmp46_ = _tmp45_;
				if (_tmp46_) {
					ValaClass* _tmp47_;
					ValaSemanticAnalyzer* _tmp48_;
					ValaSemanticAnalyzer* _tmp49_;
					ValaClass* _tmp50_;
					_tmp47_ = cl;
					_tmp48_ = vala_code_context_get_analyzer (context);
					_tmp49_ = _tmp48_;
					_tmp50_ = _tmp49_->gsource_type;
					_tmp43_ = _tmp47_ != _tmp50_;
				} else {
					_tmp43_ = FALSE;
				}
				if (_tmp43_) {
					ValaSourceReference* _tmp51_;
					ValaSourceReference* _tmp52_;
					_tmp51_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp52_ = _tmp51_;
					vala_report_error (_tmp52_, "Virtual methods may not be declared in compact classes");
					result = FALSE;
					_vala_code_node_unref0 (cl);
					return result;
				}
				_vala_code_node_unref0 (cl);
			}
		} else {
			gboolean _tmp53_;
			_tmp53_ = self->priv->_overrides;
			if (_tmp53_) {
				ValaSymbol* _tmp54_;
				ValaSymbol* _tmp55_;
				_tmp54_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
				_tmp55_ = _tmp54_;
				if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp55_, VALA_TYPE_CLASS)) {
					ValaSourceReference* _tmp56_;
					ValaSourceReference* _tmp57_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp56_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp57_ = _tmp56_;
					vala_report_error (_tmp57_, "Methods may not be overridden outside of classes");
					result = FALSE;
					return result;
				}
			} else {
				ValaSymbolAccessibility _tmp58_;
				ValaSymbolAccessibility _tmp59_;
				_tmp58_ = vala_symbol_get_access ((ValaSymbol*) self);
				_tmp59_ = _tmp58_;
				if (_tmp59_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
					gboolean _tmp60_ = FALSE;
					ValaSymbol* _tmp61_;
					ValaSymbol* _tmp62_;
					_tmp61_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
					_tmp62_ = _tmp61_;
					if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp62_, VALA_TYPE_CLASS)) {
						ValaSymbol* _tmp63_;
						ValaSymbol* _tmp64_;
						_tmp63_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
						_tmp64_ = _tmp63_;
						_tmp60_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp64_, VALA_TYPE_INTERFACE);
					} else {
						_tmp60_ = FALSE;
					}
					if (_tmp60_) {
						ValaSourceReference* _tmp65_;
						ValaSourceReference* _tmp66_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp65_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp66_ = _tmp65_;
						vala_report_error (_tmp66_, "Protected methods may not be declared outside of classes and interface" \
"s");
						result = FALSE;
						return result;
					}
				}
			}
		}
	}
	_tmp68_ = self->priv->_is_abstract;
	if (_tmp68_) {
		ValaBlock* _tmp69_;
		ValaBlock* _tmp70_;
		_tmp69_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp70_ = _tmp69_;
		_tmp67_ = _tmp70_ != NULL;
	} else {
		_tmp67_ = FALSE;
	}
	if (_tmp67_) {
		ValaSourceReference* _tmp71_;
		ValaSourceReference* _tmp72_;
		_tmp71_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp72_ = _tmp71_;
		vala_report_error (_tmp72_, "Abstract methods cannot have bodies");
	} else {
		gboolean _tmp73_ = FALSE;
		gboolean _tmp74_ = FALSE;
		gboolean _tmp75_ = FALSE;
		gboolean _tmp76_ = FALSE;
		gboolean _tmp77_;
		_tmp77_ = self->priv->_is_abstract;
		if (_tmp77_) {
			_tmp76_ = TRUE;
		} else {
			gboolean _tmp78_;
			_tmp78_ = self->priv->_is_virtual;
			_tmp76_ = _tmp78_;
		}
		if (_tmp76_) {
			gboolean _tmp79_;
			gboolean _tmp80_;
			_tmp79_ = vala_symbol_get_external ((ValaSymbol*) self);
			_tmp80_ = _tmp79_;
			_tmp75_ = _tmp80_;
		} else {
			_tmp75_ = FALSE;
		}
		if (_tmp75_) {
			gboolean _tmp81_;
			gboolean _tmp82_;
			_tmp81_ = vala_symbol_get_external_package ((ValaSymbol*) self);
			_tmp82_ = _tmp81_;
			_tmp74_ = !_tmp82_;
		} else {
			_tmp74_ = FALSE;
		}
		if (_tmp74_) {
			ValaSymbol* _tmp83_;
			ValaSymbol* _tmp84_;
			gboolean _tmp85_;
			gboolean _tmp86_;
			_tmp83_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp84_ = _tmp83_;
			_tmp85_ = vala_symbol_get_external (_tmp84_);
			_tmp86_ = _tmp85_;
			_tmp73_ = !_tmp86_;
		} else {
			_tmp73_ = FALSE;
		}
		if (_tmp73_) {
			ValaSourceReference* _tmp87_;
			ValaSourceReference* _tmp88_;
			_tmp87_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp88_ = _tmp87_;
			vala_report_error (_tmp88_, "Extern methods cannot be abstract or virtual");
		} else {
			gboolean _tmp89_ = FALSE;
			gboolean _tmp90_;
			gboolean _tmp91_;
			_tmp90_ = vala_symbol_get_external ((ValaSymbol*) self);
			_tmp91_ = _tmp90_;
			if (_tmp91_) {
				ValaBlock* _tmp92_;
				ValaBlock* _tmp93_;
				_tmp92_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp93_ = _tmp92_;
				_tmp89_ = _tmp93_ != NULL;
			} else {
				_tmp89_ = FALSE;
			}
			if (_tmp89_) {
				ValaSourceReference* _tmp94_;
				ValaSourceReference* _tmp95_;
				_tmp94_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp95_ = _tmp94_;
				vala_report_error (_tmp95_, "Extern methods cannot have bodies");
			} else {
				gboolean _tmp96_ = FALSE;
				gboolean _tmp97_ = FALSE;
				gboolean _tmp98_ = FALSE;
				gboolean _tmp99_;
				_tmp99_ = self->priv->_is_abstract;
				if (!_tmp99_) {
					gboolean _tmp100_;
					gboolean _tmp101_;
					_tmp100_ = vala_symbol_get_external ((ValaSymbol*) self);
					_tmp101_ = _tmp100_;
					_tmp98_ = !_tmp101_;
				} else {
					_tmp98_ = FALSE;
				}
				if (_tmp98_) {
					ValaSourceFileType _tmp102_;
					ValaSourceFileType _tmp103_;
					_tmp102_ = vala_symbol_get_source_type ((ValaSymbol*) self);
					_tmp103_ = _tmp102_;
					_tmp97_ = _tmp103_ == VALA_SOURCE_FILE_TYPE_SOURCE;
				} else {
					_tmp97_ = FALSE;
				}
				if (_tmp97_) {
					ValaBlock* _tmp104_;
					ValaBlock* _tmp105_;
					_tmp104_ = vala_subroutine_get_body ((ValaSubroutine*) self);
					_tmp105_ = _tmp104_;
					_tmp96_ = _tmp105_ == NULL;
				} else {
					_tmp96_ = FALSE;
				}
				if (_tmp96_) {
					ValaSourceReference* _tmp106_;
					ValaSourceReference* _tmp107_;
					_tmp106_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp107_ = _tmp106_;
					vala_report_error (_tmp107_, "Non-abstract, non-extern methods must have bodies");
				}
			}
		}
	}
	_tmp110_ = self->priv->_coroutine;
	if (_tmp110_) {
		gboolean _tmp111_;
		gboolean _tmp112_;
		_tmp111_ = vala_symbol_get_external_package ((ValaSymbol*) self);
		_tmp112_ = _tmp111_;
		_tmp109_ = !_tmp112_;
	} else {
		_tmp109_ = FALSE;
	}
	if (_tmp109_) {
		_tmp108_ = !vala_code_context_has_package (context, "gio-2.0");
	} else {
		_tmp108_ = FALSE;
	}
	if (_tmp108_) {
		ValaSourceReference* _tmp113_;
		ValaSourceReference* _tmp114_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp113_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp114_ = _tmp113_;
		vala_report_error (_tmp114_, "gio-2.0 package required for async methods");
		result = FALSE;
		return result;
	}
	_tmp115_ = vala_code_context_get_analyzer (context);
	_tmp116_ = _tmp115_;
	_tmp117_ = vala_semantic_analyzer_get_current_source_file (_tmp116_);
	_tmp118_ = _tmp117_;
	_tmp119_ = _vala_source_file_ref0 (_tmp118_);
	old_source_file = _tmp119_;
	_tmp120_ = vala_code_context_get_analyzer (context);
	_tmp121_ = _tmp120_;
	_tmp122_ = vala_semantic_analyzer_get_current_symbol (_tmp121_);
	_tmp123_ = _tmp122_;
	_tmp124_ = _vala_code_node_ref0 (_tmp123_);
	old_symbol = _tmp124_;
	_tmp125_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp126_ = _tmp125_;
	if (_tmp126_ != NULL) {
		ValaSemanticAnalyzer* _tmp127_;
		ValaSemanticAnalyzer* _tmp128_;
		ValaSourceReference* _tmp129_;
		ValaSourceReference* _tmp130_;
		ValaSourceFile* _tmp131_;
		ValaSourceFile* _tmp132_;
		_tmp127_ = vala_code_context_get_analyzer (context);
		_tmp128_ = _tmp127_;
		_tmp129_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp130_ = _tmp129_;
		_tmp131_ = vala_source_reference_get_file (_tmp130_);
		_tmp132_ = _tmp131_;
		vala_semantic_analyzer_set_current_source_file (_tmp128_, _tmp132_);
	}
	_tmp133_ = vala_code_context_get_analyzer (context);
	_tmp134_ = _tmp133_;
	vala_semantic_analyzer_set_current_symbol (_tmp134_, (ValaSymbol*) self);
	_tmp135_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp136_ = _tmp135_;
	vala_code_node_check ((ValaCodeNode*) _tmp136_, context);
	_tmp137_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "ModuleInit");
	init_attr = _tmp137_;
	_tmp138_ = init_attr;
	if (_tmp138_ != NULL) {
		ValaSourceReference* _tmp139_;
		ValaSourceReference* _tmp140_;
		ValaSourceFile* _tmp141_;
		ValaSourceFile* _tmp142_;
		ValaCodeContext* _tmp143_;
		ValaCodeContext* _tmp144_;
		_tmp139_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp140_ = _tmp139_;
		_tmp141_ = vala_source_reference_get_file (_tmp140_);
		_tmp142_ = _tmp141_;
		_tmp143_ = vala_source_file_get_context (_tmp142_);
		_tmp144_ = _tmp143_;
		vala_code_context_set_module_init_method (_tmp144_, self);
	}
	_tmp145_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp146_ = _tmp145_;
	if (_tmp146_ != NULL) {
		ValaDataType* _tmp147_;
		ValaDataType* _tmp148_;
		_tmp147_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp148_ = _tmp147_;
		vala_code_node_check ((ValaCodeNode*) _tmp148_, context);
	}
	_tmp152_ = self->priv->parameters;
	_tmp153_ = vala_collection_get_size ((ValaCollection*) _tmp152_);
	_tmp154_ = _tmp153_;
	if (_tmp154_ == 1) {
		ValaList* _tmp155_;
		gpointer _tmp156_;
		ValaParameter* _tmp157_;
		gboolean _tmp158_;
		gboolean _tmp159_;
		_tmp155_ = self->priv->parameters;
		_tmp156_ = vala_list_get (_tmp155_, 0);
		_tmp157_ = (ValaParameter*) _tmp156_;
		_tmp158_ = vala_parameter_get_ellipsis (_tmp157_);
		_tmp159_ = _tmp158_;
		_tmp151_ = _tmp159_;
		_vala_code_node_unref0 (_tmp157_);
	} else {
		_tmp151_ = FALSE;
	}
	if (_tmp151_) {
		ValaBlock* _tmp160_;
		ValaBlock* _tmp161_;
		_tmp160_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp161_ = _tmp160_;
		_tmp150_ = _tmp161_ != NULL;
	} else {
		_tmp150_ = FALSE;
	}
	if (_tmp150_) {
		ValaMemberBinding _tmp162_;
		_tmp162_ = self->priv->_binding;
		_tmp149_ = _tmp162_ != VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp149_ = FALSE;
	}
	if (_tmp149_) {
		ValaList* _tmp163_;
		gpointer _tmp164_;
		ValaParameter* _tmp165_;
		ValaSourceReference* _tmp166_;
		ValaSourceReference* _tmp167_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp163_ = self->priv->parameters;
		_tmp164_ = vala_list_get (_tmp163_, 0);
		_tmp165_ = (ValaParameter*) _tmp164_;
		_tmp166_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp165_);
		_tmp167_ = _tmp166_;
		vala_report_error (_tmp167_, "Named parameter required before `...'");
		_vala_code_node_unref0 (_tmp165_);
	}
	_tmp168_ = self->priv->_coroutine;
	if (!_tmp168_) {
		gboolean optional_param = FALSE;
		optional_param = FALSE;
		{
			ValaList* _param_list = NULL;
			ValaList* _tmp169_;
			ValaList* _tmp170_;
			gint _param_size = 0;
			ValaList* _tmp171_;
			gint _tmp172_;
			gint _tmp173_;
			gint _param_index = 0;
			_tmp169_ = self->priv->parameters;
			_tmp170_ = _vala_iterable_ref0 (_tmp169_);
			_param_list = _tmp170_;
			_tmp171_ = _param_list;
			_tmp172_ = vala_collection_get_size ((ValaCollection*) _tmp171_);
			_tmp173_ = _tmp172_;
			_param_size = _tmp173_;
			_param_index = -1;
			while (TRUE) {
				gint _tmp174_;
				gint _tmp175_;
				gint _tmp176_;
				ValaParameter* param = NULL;
				ValaList* _tmp177_;
				gint _tmp178_;
				gpointer _tmp179_;
				ValaParameter* _tmp180_;
				gboolean _tmp181_ = FALSE;
				gboolean _tmp182_;
				gboolean _tmp189_ = FALSE;
				gboolean _tmp190_ = FALSE;
				gboolean _tmp191_;
				_tmp174_ = _param_index;
				_param_index = _tmp174_ + 1;
				_tmp175_ = _param_index;
				_tmp176_ = _param_size;
				if (!(_tmp175_ < _tmp176_)) {
					break;
				}
				_tmp177_ = _param_list;
				_tmp178_ = _param_index;
				_tmp179_ = vala_list_get (_tmp177_, _tmp178_);
				param = (ValaParameter*) _tmp179_;
				_tmp180_ = param;
				vala_code_node_check ((ValaCodeNode*) _tmp180_, context);
				_tmp182_ = self->priv->_coroutine;
				if (_tmp182_) {
					ValaParameter* _tmp183_;
					ValaParameterDirection _tmp184_;
					ValaParameterDirection _tmp185_;
					_tmp183_ = param;
					_tmp184_ = vala_parameter_get_direction (_tmp183_);
					_tmp185_ = _tmp184_;
					_tmp181_ = _tmp185_ == VALA_PARAMETER_DIRECTION_REF;
				} else {
					_tmp181_ = FALSE;
				}
				if (_tmp181_) {
					ValaParameter* _tmp186_;
					ValaSourceReference* _tmp187_;
					ValaSourceReference* _tmp188_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp186_ = param;
					_tmp187_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp186_);
					_tmp188_ = _tmp187_;
					vala_report_error (_tmp188_, "Reference parameters are not supported for async methods");
				}
				_tmp191_ = optional_param;
				if (_tmp191_) {
					ValaParameter* _tmp192_;
					ValaExpression* _tmp193_;
					ValaExpression* _tmp194_;
					_tmp192_ = param;
					_tmp193_ = vala_variable_get_initializer ((ValaVariable*) _tmp192_);
					_tmp194_ = _tmp193_;
					_tmp190_ = _tmp194_ == NULL;
				} else {
					_tmp190_ = FALSE;
				}
				if (_tmp190_) {
					ValaParameter* _tmp195_;
					gboolean _tmp196_;
					gboolean _tmp197_;
					_tmp195_ = param;
					_tmp196_ = vala_parameter_get_ellipsis (_tmp195_);
					_tmp197_ = _tmp196_;
					_tmp189_ = !_tmp197_;
				} else {
					_tmp189_ = FALSE;
				}
				if (_tmp189_) {
					ValaParameter* _tmp198_;
					ValaSourceReference* _tmp199_;
					ValaSourceReference* _tmp200_;
					_tmp198_ = param;
					_tmp199_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp198_);
					_tmp200_ = _tmp199_;
					vala_report_warning (_tmp200_, "parameter without default follows parameter with default");
				} else {
					ValaParameter* _tmp201_;
					ValaExpression* _tmp202_;
					ValaExpression* _tmp203_;
					_tmp201_ = param;
					_tmp202_ = vala_variable_get_initializer ((ValaVariable*) _tmp201_);
					_tmp203_ = _tmp202_;
					if (_tmp203_ != NULL) {
						optional_param = TRUE;
					}
				}
				_vala_code_node_unref0 (param);
			}
			_vala_iterable_unref0 (_param_list);
		}
	}
	{
		ValaList* _error_type_list = NULL;
		ValaList* _tmp204_;
		gint _error_type_size = 0;
		ValaList* _tmp205_;
		gint _tmp206_;
		gint _tmp207_;
		gint _error_type_index = 0;
		_tmp204_ = vala_code_node_get_error_types ((ValaCodeNode*) self);
		_error_type_list = _tmp204_;
		_tmp205_ = _error_type_list;
		_tmp206_ = vala_collection_get_size ((ValaCollection*) _tmp205_);
		_tmp207_ = _tmp206_;
		_error_type_size = _tmp207_;
		_error_type_index = -1;
		while (TRUE) {
			gint _tmp208_;
			gint _tmp209_;
			gint _tmp210_;
			ValaDataType* error_type = NULL;
			ValaList* _tmp211_;
			gint _tmp212_;
			gpointer _tmp213_;
			ValaDataType* _tmp214_;
			ValaSemanticAnalyzer* _tmp215_;
			ValaSemanticAnalyzer* _tmp216_;
			ValaDataType* _tmp217_;
			_tmp208_ = _error_type_index;
			_error_type_index = _tmp208_ + 1;
			_tmp209_ = _error_type_index;
			_tmp210_ = _error_type_size;
			if (!(_tmp209_ < _tmp210_)) {
				break;
			}
			_tmp211_ = _error_type_list;
			_tmp212_ = _error_type_index;
			_tmp213_ = vala_list_get (_tmp211_, _tmp212_);
			error_type = (ValaDataType*) _tmp213_;
			_tmp214_ = error_type;
			vala_code_node_check ((ValaCodeNode*) _tmp214_, context);
			_tmp215_ = vala_code_context_get_analyzer (context);
			_tmp216_ = _tmp215_;
			_tmp217_ = error_type;
			if (!vala_semantic_analyzer_is_type_accessible (_tmp216_, (ValaSymbol*) self, _tmp217_)) {
				ValaSourceReference* _tmp218_;
				ValaSourceReference* _tmp219_;
				ValaDataType* _tmp220_;
				gchar* _tmp221_;
				gchar* _tmp222_;
				gchar* _tmp223_;
				gchar* _tmp224_;
				gchar* _tmp225_;
				gchar* _tmp226_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp218_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp219_ = _tmp218_;
				_tmp220_ = error_type;
				_tmp221_ = vala_code_node_to_string ((ValaCodeNode*) _tmp220_);
				_tmp222_ = _tmp221_;
				_tmp223_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp224_ = _tmp223_;
				_tmp225_ = g_strdup_printf ("error type `%s` is less accessible than method `%s`", _tmp222_, _tmp224_);
				_tmp226_ = _tmp225_;
				vala_report_error (_tmp219_, _tmp226_);
				_g_free0 (_tmp226_);
				_g_free0 (_tmp224_);
				_g_free0 (_tmp222_);
				result = FALSE;
				_vala_code_node_unref0 (error_type);
				_vala_iterable_unref0 (_error_type_list);
				_vala_code_node_unref0 (init_attr);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_vala_code_node_unref0 (error_type);
		}
		_vala_iterable_unref0 (_error_type_list);
	}
	_tmp227_ = vala_subroutine_get_result_var ((ValaSubroutine*) self);
	_tmp228_ = _tmp227_;
	if (_tmp228_ != NULL) {
		ValaLocalVariable* _tmp229_;
		ValaLocalVariable* _tmp230_;
		_tmp229_ = vala_subroutine_get_result_var ((ValaSubroutine*) self);
		_tmp230_ = _tmp229_;
		vala_code_node_check ((ValaCodeNode*) _tmp230_, context);
	}
	_tmp231_ = self->priv->preconditions;
	if (_tmp231_ != NULL) {
		{
			ValaList* _precondition_list = NULL;
			ValaList* _tmp232_;
			ValaList* _tmp233_;
			gint _precondition_size = 0;
			ValaList* _tmp234_;
			gint _tmp235_;
			gint _tmp236_;
			gint _precondition_index = 0;
			_tmp232_ = self->priv->preconditions;
			_tmp233_ = _vala_iterable_ref0 (_tmp232_);
			_precondition_list = _tmp233_;
			_tmp234_ = _precondition_list;
			_tmp235_ = vala_collection_get_size ((ValaCollection*) _tmp234_);
			_tmp236_ = _tmp235_;
			_precondition_size = _tmp236_;
			_precondition_index = -1;
			while (TRUE) {
				gint _tmp237_;
				gint _tmp238_;
				gint _tmp239_;
				ValaExpression* precondition = NULL;
				ValaList* _tmp240_;
				gint _tmp241_;
				gpointer _tmp242_;
				ValaExpression* _tmp243_;
				_tmp237_ = _precondition_index;
				_precondition_index = _tmp237_ + 1;
				_tmp238_ = _precondition_index;
				_tmp239_ = _precondition_size;
				if (!(_tmp238_ < _tmp239_)) {
					break;
				}
				_tmp240_ = _precondition_list;
				_tmp241_ = _precondition_index;
				_tmp242_ = vala_list_get (_tmp240_, _tmp241_);
				precondition = (ValaExpression*) _tmp242_;
				_tmp243_ = precondition;
				vala_code_node_check ((ValaCodeNode*) _tmp243_, context);
				_vala_code_node_unref0 (precondition);
			}
			_vala_iterable_unref0 (_precondition_list);
		}
	}
	_tmp244_ = self->priv->postconditions;
	if (_tmp244_ != NULL) {
		{
			ValaList* _postcondition_list = NULL;
			ValaList* _tmp245_;
			ValaList* _tmp246_;
			gint _postcondition_size = 0;
			ValaList* _tmp247_;
			gint _tmp248_;
			gint _tmp249_;
			gint _postcondition_index = 0;
			_tmp245_ = self->priv->postconditions;
			_tmp246_ = _vala_iterable_ref0 (_tmp245_);
			_postcondition_list = _tmp246_;
			_tmp247_ = _postcondition_list;
			_tmp248_ = vala_collection_get_size ((ValaCollection*) _tmp247_);
			_tmp249_ = _tmp248_;
			_postcondition_size = _tmp249_;
			_postcondition_index = -1;
			while (TRUE) {
				gint _tmp250_;
				gint _tmp251_;
				gint _tmp252_;
				ValaExpression* postcondition = NULL;
				ValaList* _tmp253_;
				gint _tmp254_;
				gpointer _tmp255_;
				ValaExpression* _tmp256_;
				_tmp250_ = _postcondition_index;
				_postcondition_index = _tmp250_ + 1;
				_tmp251_ = _postcondition_index;
				_tmp252_ = _postcondition_size;
				if (!(_tmp251_ < _tmp252_)) {
					break;
				}
				_tmp253_ = _postcondition_list;
				_tmp254_ = _postcondition_index;
				_tmp255_ = vala_list_get (_tmp253_, _tmp254_);
				postcondition = (ValaExpression*) _tmp255_;
				_tmp256_ = postcondition;
				vala_code_node_check ((ValaCodeNode*) _tmp256_, context);
				_vala_code_node_unref0 (postcondition);
			}
			_vala_iterable_unref0 (_postcondition_list);
		}
	}
	_tmp257_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp258_ = _tmp257_;
	if (_tmp258_ != NULL) {
		ValaBlock* _tmp259_;
		ValaBlock* _tmp260_;
		_tmp259_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp260_ = _tmp259_;
		vala_code_node_check ((ValaCodeNode*) _tmp260_, context);
	}
	_tmp261_ = vala_code_context_get_analyzer (context);
	_tmp262_ = _tmp261_;
	_tmp263_ = vala_semantic_analyzer_get_current_struct (_tmp262_);
	_tmp264_ = _tmp263_;
	if (_tmp264_ != NULL) {
		gboolean _tmp265_ = FALSE;
		gboolean _tmp266_ = FALSE;
		gboolean _tmp267_;
		_tmp267_ = self->priv->_is_abstract;
		if (_tmp267_) {
			_tmp266_ = TRUE;
		} else {
			gboolean _tmp268_;
			_tmp268_ = self->priv->_is_virtual;
			_tmp266_ = _tmp268_;
		}
		if (_tmp266_) {
			_tmp265_ = TRUE;
		} else {
			gboolean _tmp269_;
			_tmp269_ = self->priv->_overrides;
			_tmp265_ = _tmp269_;
		}
		if (_tmp265_) {
			ValaSourceReference* _tmp270_;
			ValaSourceReference* _tmp271_;
			gchar* _tmp272_;
			gchar* _tmp273_;
			gchar* _tmp274_;
			gchar* _tmp275_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp270_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp271_ = _tmp270_;
			_tmp272_ = vala_symbol_get_full_name ((ValaSymbol*) self);
			_tmp273_ = _tmp272_;
			_tmp274_ = g_strdup_printf ("A struct member `%s' cannot be marked as override, virtual, or abstrac" \
"t", _tmp273_);
			_tmp275_ = _tmp274_;
			vala_report_error (_tmp271_, _tmp275_);
			_g_free0 (_tmp275_);
			_g_free0 (_tmp273_);
			result = FALSE;
			_vala_code_node_unref0 (init_attr);
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
	} else {
		gboolean _tmp276_ = FALSE;
		gboolean _tmp277_;
		_tmp277_ = self->priv->_overrides;
		if (_tmp277_) {
			ValaMethod* _tmp278_;
			ValaMethod* _tmp279_;
			_tmp278_ = vala_method_get_base_method (self);
			_tmp279_ = _tmp278_;
			_tmp276_ = _tmp279_ == NULL;
		} else {
			_tmp276_ = FALSE;
		}
		if (_tmp276_) {
			ValaSourceReference* _tmp280_;
			ValaSourceReference* _tmp281_;
			gchar* _tmp282_;
			gchar* _tmp283_;
			gchar* _tmp284_;
			gchar* _tmp285_;
			_tmp280_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp281_ = _tmp280_;
			_tmp282_ = vala_symbol_get_full_name ((ValaSymbol*) self);
			_tmp283_ = _tmp282_;
			_tmp284_ = g_strdup_printf ("`%s': no suitable method found to override", _tmp283_);
			_tmp285_ = _tmp284_;
			vala_report_error (_tmp281_, _tmp285_);
			_g_free0 (_tmp285_);
			_g_free0 (_tmp283_);
		} else {
			gboolean _tmp286_ = FALSE;
			gboolean _tmp287_ = FALSE;
			gboolean _tmp288_ = FALSE;
			gboolean _tmp289_;
			_tmp289_ = self->priv->_is_abstract;
			if (_tmp289_) {
				_tmp288_ = TRUE;
			} else {
				gboolean _tmp290_;
				_tmp290_ = self->priv->_is_virtual;
				_tmp288_ = _tmp290_;
			}
			if (_tmp288_) {
				_tmp287_ = TRUE;
			} else {
				gboolean _tmp291_;
				_tmp291_ = self->priv->_overrides;
				_tmp287_ = _tmp291_;
			}
			if (_tmp287_) {
				ValaSymbolAccessibility _tmp292_;
				ValaSymbolAccessibility _tmp293_;
				_tmp292_ = vala_symbol_get_access ((ValaSymbol*) self);
				_tmp293_ = _tmp292_;
				_tmp286_ = _tmp293_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE;
			} else {
				_tmp286_ = FALSE;
			}
			if (_tmp286_) {
				ValaSourceReference* _tmp294_;
				ValaSourceReference* _tmp295_;
				gchar* _tmp296_;
				gchar* _tmp297_;
				gchar* _tmp298_;
				gchar* _tmp299_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp294_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp295_ = _tmp294_;
				_tmp296_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp297_ = _tmp296_;
				_tmp298_ = g_strdup_printf ("Private member `%s' cannot be marked as override, virtual, or abstract", _tmp297_);
				_tmp299_ = _tmp298_;
				vala_report_error (_tmp295_, _tmp299_);
				_g_free0 (_tmp299_);
				_g_free0 (_tmp297_);
				result = FALSE;
				_vala_code_node_unref0 (init_attr);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
		}
	}
	_tmp302_ = vala_method_get_base_interface_type (self);
	_tmp303_ = _tmp302_;
	if (_tmp303_ != NULL) {
		ValaMethod* _tmp304_;
		ValaMethod* _tmp305_;
		_tmp304_ = vala_method_get_base_interface_method (self);
		_tmp305_ = _tmp304_;
		_tmp301_ = _tmp305_ != NULL;
	} else {
		_tmp301_ = FALSE;
	}
	if (_tmp301_) {
		ValaSymbol* _tmp306_;
		ValaSymbol* _tmp307_;
		_tmp306_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp307_ = _tmp306_;
		_tmp300_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp307_, VALA_TYPE_CLASS);
	} else {
		_tmp300_ = FALSE;
	}
	if (_tmp300_) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp308_;
		ValaSymbol* _tmp309_;
		ValaClass* _tmp310_;
		_tmp308_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp309_ = _tmp308_;
		_tmp310_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp309_, VALA_TYPE_CLASS, ValaClass));
		cl = _tmp310_;
		{
			ValaList* _m_list = NULL;
			ValaClass* _tmp311_;
			ValaList* _tmp312_;
			gint _m_size = 0;
			ValaList* _tmp313_;
			gint _tmp314_;
			gint _tmp315_;
			gint _m_index = 0;
			_tmp311_ = cl;
			_tmp312_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) _tmp311_);
			_m_list = _tmp312_;
			_tmp313_ = _m_list;
			_tmp314_ = vala_collection_get_size ((ValaCollection*) _tmp313_);
			_tmp315_ = _tmp314_;
			_m_size = _tmp315_;
			_m_index = -1;
			while (TRUE) {
				gint _tmp316_;
				gint _tmp317_;
				gint _tmp318_;
				ValaMethod* m = NULL;
				ValaList* _tmp319_;
				gint _tmp320_;
				gpointer _tmp321_;
				gboolean _tmp322_ = FALSE;
				ValaMethod* _tmp323_;
				_tmp316_ = _m_index;
				_m_index = _tmp316_ + 1;
				_tmp317_ = _m_index;
				_tmp318_ = _m_size;
				if (!(_tmp317_ < _tmp318_)) {
					break;
				}
				_tmp319_ = _m_list;
				_tmp320_ = _m_index;
				_tmp321_ = vala_list_get (_tmp319_, _tmp320_);
				m = (ValaMethod*) _tmp321_;
				_tmp323_ = m;
				if (_tmp323_ != self) {
					ValaMethod* _tmp324_;
					ValaMethod* _tmp325_;
					ValaMethod* _tmp326_;
					ValaMethod* _tmp327_;
					ValaMethod* _tmp328_;
					_tmp324_ = m;
					_tmp325_ = vala_method_get_base_interface_method (_tmp324_);
					_tmp326_ = _tmp325_;
					_tmp327_ = vala_method_get_base_interface_method (self);
					_tmp328_ = _tmp327_;
					_tmp322_ = _tmp326_ == _tmp328_;
				} else {
					_tmp322_ = FALSE;
				}
				if (_tmp322_) {
					ValaMethod* _tmp329_;
					ValaMethod* _tmp330_;
					ValaSourceReference* _tmp331_;
					ValaSourceReference* _tmp332_;
					ValaClass* _tmp333_;
					gchar* _tmp334_;
					gchar* _tmp335_;
					ValaMethod* _tmp336_;
					ValaMethod* _tmp337_;
					gchar* _tmp338_;
					gchar* _tmp339_;
					gchar* _tmp340_;
					gchar* _tmp341_;
					ValaMethod* _tmp342_;
					ValaSourceReference* _tmp343_;
					ValaSourceReference* _tmp344_;
					ValaMethod* _tmp345_;
					ValaMethod* _tmp346_;
					gchar* _tmp347_;
					gchar* _tmp348_;
					gchar* _tmp349_;
					gchar* _tmp350_;
					_tmp329_ = m;
					vala_code_node_set_checked ((ValaCodeNode*) _tmp329_, TRUE);
					_tmp330_ = m;
					vala_code_node_set_error ((ValaCodeNode*) _tmp330_, TRUE);
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp331_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp332_ = _tmp331_;
					_tmp333_ = cl;
					_tmp334_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp333_);
					_tmp335_ = _tmp334_;
					_tmp336_ = vala_method_get_base_interface_method (self);
					_tmp337_ = _tmp336_;
					_tmp338_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp337_);
					_tmp339_ = _tmp338_;
					_tmp340_ = g_strdup_printf ("`%s' already contains an implementation for `%s'", _tmp335_, _tmp339_);
					_tmp341_ = _tmp340_;
					vala_report_error (_tmp332_, _tmp341_);
					_g_free0 (_tmp341_);
					_g_free0 (_tmp339_);
					_g_free0 (_tmp335_);
					_tmp342_ = m;
					_tmp343_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp342_);
					_tmp344_ = _tmp343_;
					_tmp345_ = vala_method_get_base_interface_method (self);
					_tmp346_ = _tmp345_;
					_tmp347_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp346_);
					_tmp348_ = _tmp347_;
					_tmp349_ = g_strdup_printf ("previous implementation of `%s' was here", _tmp348_);
					_tmp350_ = _tmp349_;
					vala_report_notice (_tmp344_, _tmp350_);
					_g_free0 (_tmp350_);
					_g_free0 (_tmp348_);
					result = FALSE;
					_vala_code_node_unref0 (m);
					_vala_iterable_unref0 (_m_list);
					_vala_code_node_unref0 (cl);
					_vala_code_node_unref0 (init_attr);
					_vala_code_node_unref0 (old_symbol);
					_vala_source_file_unref0 (old_source_file);
					return result;
				}
				_vala_code_node_unref0 (m);
			}
			_vala_iterable_unref0 (_m_list);
		}
		_vala_code_node_unref0 (cl);
	}
	_tmp351_ = vala_code_context_get_analyzer (context);
	_tmp352_ = _tmp351_;
	_tmp353_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp352_, _tmp353_);
	_tmp354_ = vala_code_context_get_analyzer (context);
	_tmp355_ = _tmp354_;
	_tmp356_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp355_, _tmp356_);
	_tmp360_ = vala_symbol_get_external_package ((ValaSymbol*) self);
	_tmp361_ = _tmp360_;
	if (!_tmp361_) {
		gboolean _tmp362_;
		_tmp362_ = self->priv->_overrides;
		_tmp359_ = !_tmp362_;
	} else {
		_tmp359_ = FALSE;
	}
	if (_tmp359_) {
		gboolean _tmp363_;
		gboolean _tmp364_;
		_tmp363_ = vala_symbol_get_hides ((ValaSymbol*) self);
		_tmp364_ = _tmp363_;
		_tmp358_ = !_tmp364_;
	} else {
		_tmp358_ = FALSE;
	}
	if (_tmp358_) {
		ValaSymbol* _tmp365_;
		ValaSymbol* _tmp366_;
		_tmp365_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp366_ = _tmp365_;
		_tmp357_ = _tmp366_ != NULL;
		_vala_code_node_unref0 (_tmp366_);
	} else {
		_tmp357_ = FALSE;
	}
	if (_tmp357_) {
		ValaSourceReference* _tmp367_;
		ValaSourceReference* _tmp368_;
		gchar* _tmp369_;
		gchar* _tmp370_;
		ValaSymbol* _tmp371_;
		ValaSymbol* _tmp372_;
		gchar* _tmp373_;
		gchar* _tmp374_;
		gchar* _tmp375_;
		gchar* _tmp376_;
		_tmp367_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp368_ = _tmp367_;
		_tmp369_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp370_ = _tmp369_;
		_tmp371_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp372_ = _tmp371_;
		_tmp373_ = vala_symbol_get_full_name (_tmp372_);
		_tmp374_ = _tmp373_;
		_tmp375_ = g_strdup_printf ("%s hides inherited method `%s'. Use the `new' keyword if hiding was in" \
"tentional", _tmp370_, _tmp374_);
		_tmp376_ = _tmp375_;
		vala_report_warning (_tmp368_, _tmp376_);
		_g_free0 (_tmp376_);
		_g_free0 (_tmp374_);
		_vala_code_node_unref0 (_tmp372_);
		_g_free0 (_tmp370_);
	}
	_tmp377_ = vala_code_context_get_analyzer (context);
	_tmp378_ = _tmp377_;
	_tmp379_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp380_ = _tmp379_;
	if (!vala_semantic_analyzer_is_type_accessible (_tmp378_, (ValaSymbol*) self, _tmp380_)) {
		ValaSourceReference* _tmp381_;
		ValaSourceReference* _tmp382_;
		ValaDataType* _tmp383_;
		ValaDataType* _tmp384_;
		gchar* _tmp385_;
		gchar* _tmp386_;
		gchar* _tmp387_;
		gchar* _tmp388_;
		gchar* _tmp389_;
		gchar* _tmp390_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp381_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp382_ = _tmp381_;
		_tmp383_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp384_ = _tmp383_;
		_tmp385_ = vala_code_node_to_string ((ValaCodeNode*) _tmp384_);
		_tmp386_ = _tmp385_;
		_tmp387_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp388_ = _tmp387_;
		_tmp389_ = g_strdup_printf ("return type `%s` is less accessible than method `%s`", _tmp386_, _tmp388_);
		_tmp390_ = _tmp389_;
		vala_report_error (_tmp382_, _tmp390_);
		_g_free0 (_tmp390_);
		_g_free0 (_tmp388_);
		_g_free0 (_tmp386_);
		result = FALSE;
		_vala_code_node_unref0 (init_attr);
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	{
		ValaList* _precondition_list = NULL;
		ValaList* _tmp391_;
		gint _precondition_size = 0;
		ValaList* _tmp392_;
		gint _tmp393_;
		gint _tmp394_;
		gint _precondition_index = 0;
		_tmp391_ = vala_method_get_preconditions (self);
		_precondition_list = _tmp391_;
		_tmp392_ = _precondition_list;
		_tmp393_ = vala_collection_get_size ((ValaCollection*) _tmp392_);
		_tmp394_ = _tmp393_;
		_precondition_size = _tmp394_;
		_precondition_index = -1;
		while (TRUE) {
			gint _tmp395_;
			gint _tmp396_;
			gint _tmp397_;
			ValaExpression* precondition = NULL;
			ValaList* _tmp398_;
			gint _tmp399_;
			gpointer _tmp400_;
			ValaExpression* _tmp401_;
			gboolean _tmp402_;
			gboolean _tmp403_;
			ValaExpression* _tmp404_;
			ValaDataType* _tmp405_;
			ValaDataType* _tmp406_;
			ValaSemanticAnalyzer* _tmp407_;
			ValaSemanticAnalyzer* _tmp408_;
			ValaDataType* _tmp409_;
			_tmp395_ = _precondition_index;
			_precondition_index = _tmp395_ + 1;
			_tmp396_ = _precondition_index;
			_tmp397_ = _precondition_size;
			if (!(_tmp396_ < _tmp397_)) {
				break;
			}
			_tmp398_ = _precondition_list;
			_tmp399_ = _precondition_index;
			_tmp400_ = vala_list_get (_tmp398_, _tmp399_);
			precondition = (ValaExpression*) _tmp400_;
			_tmp401_ = precondition;
			_tmp402_ = vala_code_node_get_error ((ValaCodeNode*) _tmp401_);
			_tmp403_ = _tmp402_;
			if (_tmp403_) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_code_node_unref0 (precondition);
				_vala_iterable_unref0 (_precondition_list);
				_vala_code_node_unref0 (init_attr);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp404_ = precondition;
			_tmp405_ = vala_expression_get_value_type (_tmp404_);
			_tmp406_ = _tmp405_;
			_tmp407_ = vala_code_context_get_analyzer (context);
			_tmp408_ = _tmp407_;
			_tmp409_ = _tmp408_->bool_type;
			if (!vala_data_type_compatible (_tmp406_, _tmp409_)) {
				ValaExpression* _tmp410_;
				ValaSourceReference* _tmp411_;
				ValaSourceReference* _tmp412_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp410_ = precondition;
				_tmp411_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp410_);
				_tmp412_ = _tmp411_;
				vala_report_error (_tmp412_, "Precondition must be boolean");
				result = FALSE;
				_vala_code_node_unref0 (precondition);
				_vala_iterable_unref0 (_precondition_list);
				_vala_code_node_unref0 (init_attr);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_vala_code_node_unref0 (precondition);
		}
		_vala_iterable_unref0 (_precondition_list);
	}
	{
		ValaList* _postcondition_list = NULL;
		ValaList* _tmp413_;
		gint _postcondition_size = 0;
		ValaList* _tmp414_;
		gint _tmp415_;
		gint _tmp416_;
		gint _postcondition_index = 0;
		_tmp413_ = vala_method_get_postconditions (self);
		_postcondition_list = _tmp413_;
		_tmp414_ = _postcondition_list;
		_tmp415_ = vala_collection_get_size ((ValaCollection*) _tmp414_);
		_tmp416_ = _tmp415_;
		_postcondition_size = _tmp416_;
		_postcondition_index = -1;
		while (TRUE) {
			gint _tmp417_;
			gint _tmp418_;
			gint _tmp419_;
			ValaExpression* postcondition = NULL;
			ValaList* _tmp420_;
			gint _tmp421_;
			gpointer _tmp422_;
			ValaExpression* _tmp423_;
			gboolean _tmp424_;
			gboolean _tmp425_;
			ValaExpression* _tmp426_;
			ValaDataType* _tmp427_;
			ValaDataType* _tmp428_;
			ValaSemanticAnalyzer* _tmp429_;
			ValaSemanticAnalyzer* _tmp430_;
			ValaDataType* _tmp431_;
			_tmp417_ = _postcondition_index;
			_postcondition_index = _tmp417_ + 1;
			_tmp418_ = _postcondition_index;
			_tmp419_ = _postcondition_size;
			if (!(_tmp418_ < _tmp419_)) {
				break;
			}
			_tmp420_ = _postcondition_list;
			_tmp421_ = _postcondition_index;
			_tmp422_ = vala_list_get (_tmp420_, _tmp421_);
			postcondition = (ValaExpression*) _tmp422_;
			_tmp423_ = postcondition;
			_tmp424_ = vala_code_node_get_error ((ValaCodeNode*) _tmp423_);
			_tmp425_ = _tmp424_;
			if (_tmp425_) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_code_node_unref0 (postcondition);
				_vala_iterable_unref0 (_postcondition_list);
				_vala_code_node_unref0 (init_attr);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp426_ = postcondition;
			_tmp427_ = vala_expression_get_value_type (_tmp426_);
			_tmp428_ = _tmp427_;
			_tmp429_ = vala_code_context_get_analyzer (context);
			_tmp430_ = _tmp429_;
			_tmp431_ = _tmp430_->bool_type;
			if (!vala_data_type_compatible (_tmp428_, _tmp431_)) {
				ValaExpression* _tmp432_;
				ValaSourceReference* _tmp433_;
				ValaSourceReference* _tmp434_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp432_ = postcondition;
				_tmp433_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp432_);
				_tmp434_ = _tmp433_;
				vala_report_error (_tmp434_, "Postcondition must be boolean");
				result = FALSE;
				_vala_code_node_unref0 (postcondition);
				_vala_iterable_unref0 (_postcondition_list);
				_vala_code_node_unref0 (init_attr);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_vala_code_node_unref0 (postcondition);
		}
		_vala_iterable_unref0 (_postcondition_list);
	}
	_tmp435_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp436_ = _tmp435_;
	if (_tmp436_ != NULL) {
		{
			ValaList* _body_error_type_list = NULL;
			ValaBlock* _tmp437_;
			ValaBlock* _tmp438_;
			ValaList* _tmp439_;
			gint _body_error_type_size = 0;
			ValaList* _tmp440_;
			gint _tmp441_;
			gint _tmp442_;
			gint _body_error_type_index = 0;
			_tmp437_ = vala_subroutine_get_body ((ValaSubroutine*) self);
			_tmp438_ = _tmp437_;
			_tmp439_ = vala_code_node_get_error_types ((ValaCodeNode*) _tmp438_);
			_body_error_type_list = _tmp439_;
			_tmp440_ = _body_error_type_list;
			_tmp441_ = vala_collection_get_size ((ValaCollection*) _tmp440_);
			_tmp442_ = _tmp441_;
			_body_error_type_size = _tmp442_;
			_body_error_type_index = -1;
			while (TRUE) {
				gint _tmp443_;
				gint _tmp444_;
				gint _tmp445_;
				ValaDataType* body_error_type = NULL;
				ValaList* _tmp446_;
				gint _tmp447_;
				gpointer _tmp448_;
				gboolean can_propagate_error = FALSE;
				gboolean _tmp461_ = FALSE;
				ValaDataType* _tmp462_;
				gboolean is_dynamic_error = FALSE;
				gboolean _tmp466_ = FALSE;
				gboolean _tmp467_;
				_tmp443_ = _body_error_type_index;
				_body_error_type_index = _tmp443_ + 1;
				_tmp444_ = _body_error_type_index;
				_tmp445_ = _body_error_type_size;
				if (!(_tmp444_ < _tmp445_)) {
					break;
				}
				_tmp446_ = _body_error_type_list;
				_tmp447_ = _body_error_type_index;
				_tmp448_ = vala_list_get (_tmp446_, _tmp447_);
				body_error_type = (ValaDataType*) _tmp448_;
				can_propagate_error = FALSE;
				{
					ValaList* _method_error_type_list = NULL;
					ValaList* _tmp449_;
					gint _method_error_type_size = 0;
					ValaList* _tmp450_;
					gint _tmp451_;
					gint _tmp452_;
					gint _method_error_type_index = 0;
					_tmp449_ = vala_code_node_get_error_types ((ValaCodeNode*) self);
					_method_error_type_list = _tmp449_;
					_tmp450_ = _method_error_type_list;
					_tmp451_ = vala_collection_get_size ((ValaCollection*) _tmp450_);
					_tmp452_ = _tmp451_;
					_method_error_type_size = _tmp452_;
					_method_error_type_index = -1;
					while (TRUE) {
						gint _tmp453_;
						gint _tmp454_;
						gint _tmp455_;
						ValaDataType* method_error_type = NULL;
						ValaList* _tmp456_;
						gint _tmp457_;
						gpointer _tmp458_;
						ValaDataType* _tmp459_;
						ValaDataType* _tmp460_;
						_tmp453_ = _method_error_type_index;
						_method_error_type_index = _tmp453_ + 1;
						_tmp454_ = _method_error_type_index;
						_tmp455_ = _method_error_type_size;
						if (!(_tmp454_ < _tmp455_)) {
							break;
						}
						_tmp456_ = _method_error_type_list;
						_tmp457_ = _method_error_type_index;
						_tmp458_ = vala_list_get (_tmp456_, _tmp457_);
						method_error_type = (ValaDataType*) _tmp458_;
						_tmp459_ = body_error_type;
						_tmp460_ = method_error_type;
						if (vala_data_type_compatible (_tmp459_, _tmp460_)) {
							can_propagate_error = TRUE;
						}
						_vala_code_node_unref0 (method_error_type);
					}
					_vala_iterable_unref0 (_method_error_type_list);
				}
				_tmp462_ = body_error_type;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp462_, VALA_TYPE_ERROR_TYPE)) {
					ValaDataType* _tmp463_;
					gboolean _tmp464_;
					gboolean _tmp465_;
					_tmp463_ = body_error_type;
					_tmp464_ = vala_error_type_get_dynamic_error (G_TYPE_CHECK_INSTANCE_CAST (_tmp463_, VALA_TYPE_ERROR_TYPE, ValaErrorType));
					_tmp465_ = _tmp464_;
					_tmp461_ = _tmp465_;
				} else {
					_tmp461_ = FALSE;
				}
				is_dynamic_error = _tmp461_;
				_tmp467_ = can_propagate_error;
				if (!_tmp467_) {
					gboolean _tmp468_;
					_tmp468_ = is_dynamic_error;
					_tmp466_ = !_tmp468_;
				} else {
					_tmp466_ = FALSE;
				}
				if (_tmp466_) {
					ValaDataType* _tmp469_;
					ValaSourceReference* _tmp470_;
					ValaSourceReference* _tmp471_;
					ValaDataType* _tmp472_;
					gchar* _tmp473_;
					gchar* _tmp474_;
					gchar* _tmp475_;
					gchar* _tmp476_;
					_tmp469_ = body_error_type;
					_tmp470_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp469_);
					_tmp471_ = _tmp470_;
					_tmp472_ = body_error_type;
					_tmp473_ = vala_code_node_to_string ((ValaCodeNode*) _tmp472_);
					_tmp474_ = _tmp473_;
					_tmp475_ = g_strdup_printf ("unhandled error `%s'", _tmp474_);
					_tmp476_ = _tmp475_;
					vala_report_warning (_tmp471_, _tmp476_);
					_g_free0 (_tmp476_);
					_g_free0 (_tmp474_);
				}
				_vala_code_node_unref0 (body_error_type);
			}
			_vala_iterable_unref0 (_body_error_type_list);
		}
	}
	if (vala_method_is_possible_entry_point (self, context)) {
		ValaMethod* _tmp477_;
		ValaMethod* _tmp478_;
		gboolean _tmp487_;
		gboolean _tmp488_;
		gboolean _tmp491_;
		gboolean _tmp494_;
		_tmp477_ = vala_code_context_get_entry_point (context);
		_tmp478_ = _tmp477_;
		if (_tmp478_ != NULL) {
			ValaSourceReference* _tmp479_;
			ValaSourceReference* _tmp480_;
			ValaMethod* _tmp481_;
			ValaMethod* _tmp482_;
			gchar* _tmp483_;
			gchar* _tmp484_;
			gchar* _tmp485_;
			gchar* _tmp486_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp479_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp480_ = _tmp479_;
			_tmp481_ = vala_code_context_get_entry_point (context);
			_tmp482_ = _tmp481_;
			_tmp483_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp482_);
			_tmp484_ = _tmp483_;
			_tmp485_ = g_strdup_printf ("program already has an entry point `%s'", _tmp484_);
			_tmp486_ = _tmp485_;
			vala_report_error (_tmp480_, _tmp486_);
			_g_free0 (_tmp486_);
			_g_free0 (_tmp484_);
			result = FALSE;
			_vala_code_node_unref0 (init_attr);
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		vala_method_set_entry_point (self, TRUE);
		vala_code_context_set_entry_point (context, self);
		_tmp487_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) self);
		_tmp488_ = _tmp487_;
		if (_tmp488_) {
			ValaSourceReference* _tmp489_;
			ValaSourceReference* _tmp490_;
			_tmp489_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp490_ = _tmp489_;
			vala_report_error (_tmp490_, "\"main\" method cannot throw errors");
		}
		_tmp491_ = self->priv->_is_inline;
		if (_tmp491_) {
			ValaSourceReference* _tmp492_;
			ValaSourceReference* _tmp493_;
			_tmp492_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp493_ = _tmp492_;
			vala_report_error (_tmp493_, "\"main\" method cannot be inline");
		}
		_tmp494_ = self->priv->_coroutine;
		if (_tmp494_) {
			ValaSourceReference* _tmp495_;
			ValaSourceReference* _tmp496_;
			_tmp495_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp496_ = _tmp495_;
			vala_report_error (_tmp496_, "\"main\" method cannot be async");
		}
	}
	_tmp497_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "GtkCallback");
	_tmp498_ = _tmp497_;
	_tmp499_ = _tmp498_ != NULL;
	_vala_code_node_unref0 (_tmp498_);
	if (_tmp499_) {
		vala_symbol_set_used ((ValaSymbol*) self, TRUE);
	}
	_tmp500_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp501_ = _tmp500_;
	result = !_tmp501_;
	_vala_code_node_unref0 (init_attr);
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}


static gboolean
vala_method_is_possible_entry_point (ValaMethod* self, 
                                     ValaCodeContext* context)
{
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	ValaMemberBinding _tmp14_;
	ValaDataType* _tmp15_;
	ValaDataType* _tmp16_;
	ValaList* params = NULL;
	ValaList* _tmp26_;
	ValaList* _tmp27_;
	gint _tmp28_;
	gint _tmp29_;
	ValaList* _tmp30_;
	gint _tmp31_;
	gint _tmp32_;
	ValaIterator* params_it = NULL;
	ValaList* _tmp33_;
	ValaIterator* _tmp34_;
	ValaIterator* _tmp35_;
	ValaParameter* param = NULL;
	ValaIterator* _tmp36_;
	gpointer _tmp37_;
	ValaParameter* _tmp38_;
	ValaParameterDirection _tmp39_;
	ValaParameterDirection _tmp40_;
	ValaParameter* _tmp41_;
	ValaDataType* _tmp42_;
	ValaDataType* _tmp43_;
	ValaArrayType* array_type = NULL;
	ValaParameter* _tmp44_;
	ValaDataType* _tmp45_;
	ValaDataType* _tmp46_;
	ValaArrayType* _tmp47_;
	ValaArrayType* _tmp48_;
	ValaDataType* _tmp49_;
	ValaDataType* _tmp50_;
	ValaTypeSymbol* _tmp51_;
	ValaTypeSymbol* _tmp52_;
	ValaSemanticAnalyzer* _tmp53_;
	ValaSemanticAnalyzer* _tmp54_;
	ValaDataType* _tmp55_;
	ValaTypeSymbol* _tmp56_;
	ValaTypeSymbol* _tmp57_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_symbol_get_external_package ((ValaSymbol*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		result = FALSE;
		return result;
	}
	_tmp2_ = vala_code_context_get_entry_point_name (context);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		gboolean _tmp4_ = FALSE;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		_tmp5_ = vala_symbol_get_name ((ValaSymbol*) self);
		_tmp6_ = _tmp5_;
		if (_tmp6_ == NULL) {
			_tmp4_ = TRUE;
		} else {
			const gchar* _tmp7_;
			const gchar* _tmp8_;
			_tmp7_ = vala_symbol_get_name ((ValaSymbol*) self);
			_tmp8_ = _tmp7_;
			_tmp4_ = g_strcmp0 (_tmp8_, "main") != 0;
		}
		if (_tmp4_) {
			result = FALSE;
			return result;
		}
	} else {
		gchar* _tmp9_;
		gchar* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		gboolean _tmp13_;
		_tmp9_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp10_ = _tmp9_;
		_tmp11_ = vala_code_context_get_entry_point_name (context);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_strcmp0 (_tmp10_, _tmp12_) != 0;
		_g_free0 (_tmp10_);
		if (_tmp13_) {
			result = FALSE;
			return result;
		}
	}
	_tmp14_ = self->priv->_binding;
	if (_tmp14_ == VALA_MEMBER_BINDING_INSTANCE) {
		result = FALSE;
		return result;
	}
	_tmp15_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp16_ = _tmp15_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, VALA_TYPE_VOID_TYPE)) {
	} else {
		ValaDataType* _tmp17_;
		ValaDataType* _tmp18_;
		ValaTypeSymbol* _tmp19_;
		ValaTypeSymbol* _tmp20_;
		ValaSemanticAnalyzer* _tmp21_;
		ValaSemanticAnalyzer* _tmp22_;
		ValaDataType* _tmp23_;
		ValaTypeSymbol* _tmp24_;
		ValaTypeSymbol* _tmp25_;
		_tmp17_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp18_ = _tmp17_;
		_tmp19_ = vala_data_type_get_data_type (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_code_context_get_analyzer (context);
		_tmp22_ = _tmp21_;
		_tmp23_ = _tmp22_->int_type;
		_tmp24_ = vala_data_type_get_data_type (_tmp23_);
		_tmp25_ = _tmp24_;
		if (_tmp20_ == _tmp25_) {
		} else {
			result = FALSE;
			return result;
		}
	}
	_tmp26_ = vala_callable_get_parameters ((ValaCallable*) self);
	params = _tmp26_;
	_tmp27_ = params;
	_tmp28_ = vala_collection_get_size ((ValaCollection*) _tmp27_);
	_tmp29_ = _tmp28_;
	if (_tmp29_ == 0) {
		result = TRUE;
		_vala_iterable_unref0 (params);
		return result;
	}
	_tmp30_ = params;
	_tmp31_ = vala_collection_get_size ((ValaCollection*) _tmp30_);
	_tmp32_ = _tmp31_;
	if (_tmp32_ > 1) {
		result = FALSE;
		_vala_iterable_unref0 (params);
		return result;
	}
	_tmp33_ = params;
	_tmp34_ = vala_iterable_iterator ((ValaIterable*) _tmp33_);
	params_it = _tmp34_;
	_tmp35_ = params_it;
	vala_iterator_next (_tmp35_);
	_tmp36_ = params_it;
	_tmp37_ = vala_iterator_get (_tmp36_);
	param = (ValaParameter*) _tmp37_;
	_tmp38_ = param;
	_tmp39_ = vala_parameter_get_direction (_tmp38_);
	_tmp40_ = _tmp39_;
	if (_tmp40_ == VALA_PARAMETER_DIRECTION_OUT) {
		result = FALSE;
		_vala_code_node_unref0 (param);
		_vala_iterator_unref0 (params_it);
		_vala_iterable_unref0 (params);
		return result;
	}
	_tmp41_ = param;
	_tmp42_ = vala_variable_get_variable_type ((ValaVariable*) _tmp41_);
	_tmp43_ = _tmp42_;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp43_, VALA_TYPE_ARRAY_TYPE)) {
		result = FALSE;
		_vala_code_node_unref0 (param);
		_vala_iterator_unref0 (params_it);
		_vala_iterable_unref0 (params);
		return result;
	}
	_tmp44_ = param;
	_tmp45_ = vala_variable_get_variable_type ((ValaVariable*) _tmp44_);
	_tmp46_ = _tmp45_;
	_tmp47_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp46_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
	array_type = _tmp47_;
	_tmp48_ = array_type;
	_tmp49_ = vala_array_type_get_element_type (_tmp48_);
	_tmp50_ = _tmp49_;
	_tmp51_ = vala_data_type_get_data_type (_tmp50_);
	_tmp52_ = _tmp51_;
	_tmp53_ = vala_code_context_get_analyzer (context);
	_tmp54_ = _tmp53_;
	_tmp55_ = _tmp54_->string_type;
	_tmp56_ = vala_data_type_get_data_type (_tmp55_);
	_tmp57_ = _tmp56_;
	if (_tmp52_ != _tmp57_) {
		result = FALSE;
		_vala_code_node_unref0 (array_type);
		_vala_code_node_unref0 (param);
		_vala_iterator_unref0 (params_it);
		_vala_iterable_unref0 (params);
		return result;
	}
	result = TRUE;
	_vala_code_node_unref0 (array_type);
	_vala_code_node_unref0 (param);
	_vala_iterator_unref0 (params_it);
	_vala_iterable_unref0 (params);
	return result;
}


gint
vala_method_get_required_arguments (ValaMethod* self)
{
	gint result = 0;
	gint n = 0;
	g_return_val_if_fail (self != NULL, 0);
	n = 0;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _param_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _param_index = 0;
		_tmp0_ = self->priv->parameters;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_param_list = _tmp1_;
		_tmp2_ = _param_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_param_size = _tmp4_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaParameter* param = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			gboolean _tmp11_ = FALSE;
			ValaParameter* _tmp12_;
			ValaExpression* _tmp13_;
			ValaExpression* _tmp14_;
			gint _tmp18_;
			_tmp5_ = _param_index;
			_param_index = _tmp5_ + 1;
			_tmp6_ = _param_index;
			_tmp7_ = _param_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _param_list;
			_tmp9_ = _param_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			param = (ValaParameter*) _tmp10_;
			_tmp12_ = param;
			_tmp13_ = vala_variable_get_initializer ((ValaVariable*) _tmp12_);
			_tmp14_ = _tmp13_;
			if (_tmp14_ != NULL) {
				_tmp11_ = TRUE;
			} else {
				ValaParameter* _tmp15_;
				gboolean _tmp16_;
				gboolean _tmp17_;
				_tmp15_ = param;
				_tmp16_ = vala_parameter_get_ellipsis (_tmp15_);
				_tmp17_ = _tmp16_;
				_tmp11_ = _tmp17_;
			}
			if (_tmp11_) {
				_vala_code_node_unref0 (param);
				break;
			}
			_tmp18_ = n;
			n = _tmp18_ + 1;
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	result = n;
	return result;
}


ValaMethod*
vala_method_get_end_method (ValaMethod* self)
{
	ValaMethod* result = NULL;
	gboolean _tmp0_;
	ValaMethod* _tmp1_;
	ValaMethod* _tmp38_;
	ValaMethod* _tmp39_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_coroutine;
	_vala_assert (_tmp0_, "this.coroutine");
	_tmp1_ = self->priv->end_method;
	if (_tmp1_ == NULL) {
		ValaDataType* _tmp2_;
		ValaDataType* _tmp3_;
		ValaSourceReference* _tmp4_;
		ValaSourceReference* _tmp5_;
		ValaMethod* _tmp6_;
		ValaMethod* _tmp7_;
		ValaMethod* _tmp8_;
		ValaMethod* _tmp9_;
		ValaScope* _tmp10_;
		ValaScope* _tmp11_;
		_tmp2_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_method_new ("end", _tmp3_, _tmp5_, NULL);
		_vala_code_node_unref0 (self->priv->end_method);
		self->priv->end_method = _tmp6_;
		_tmp7_ = self->priv->end_method;
		vala_symbol_set_access ((ValaSymbol*) _tmp7_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		_tmp8_ = self->priv->end_method;
		vala_symbol_set_external ((ValaSymbol*) _tmp8_, TRUE);
		_tmp9_ = self->priv->end_method;
		_tmp10_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp11_ = _tmp10_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp9_, _tmp11_);
		{
			ValaList* _param_list = NULL;
			ValaList* _tmp12_;
			gint _param_size = 0;
			ValaList* _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
			gint _param_index = 0;
			_tmp12_ = vala_method_get_async_end_parameters (self);
			_param_list = _tmp12_;
			_tmp13_ = _param_list;
			_tmp14_ = vala_collection_get_size ((ValaCollection*) _tmp13_);
			_tmp15_ = _tmp14_;
			_param_size = _tmp15_;
			_param_index = -1;
			while (TRUE) {
				gint _tmp16_;
				gint _tmp17_;
				gint _tmp18_;
				ValaParameter* param = NULL;
				ValaList* _tmp19_;
				gint _tmp20_;
				gpointer _tmp21_;
				ValaMethod* _tmp22_;
				ValaParameter* _tmp23_;
				ValaParameter* _tmp24_;
				ValaParameter* _tmp25_;
				_tmp16_ = _param_index;
				_param_index = _tmp16_ + 1;
				_tmp17_ = _param_index;
				_tmp18_ = _param_size;
				if (!(_tmp17_ < _tmp18_)) {
					break;
				}
				_tmp19_ = _param_list;
				_tmp20_ = _param_index;
				_tmp21_ = vala_list_get (_tmp19_, _tmp20_);
				param = (ValaParameter*) _tmp21_;
				_tmp22_ = self->priv->end_method;
				_tmp23_ = param;
				_tmp24_ = vala_parameter_copy (_tmp23_);
				_tmp25_ = _tmp24_;
				vala_callable_add_parameter ((ValaCallable*) _tmp22_, _tmp25_);
				_vala_code_node_unref0 (_tmp25_);
				_vala_code_node_unref0 (param);
			}
			_vala_iterable_unref0 (_param_list);
		}
		{
			ValaList* _param_list = NULL;
			ValaList* _tmp26_;
			gint _param_size = 0;
			ValaList* _tmp27_;
			gint _tmp28_;
			gint _tmp29_;
			gint _param_index = 0;
			_tmp26_ = vala_method_get_type_parameters (self);
			_param_list = _tmp26_;
			_tmp27_ = _param_list;
			_tmp28_ = vala_collection_get_size ((ValaCollection*) _tmp27_);
			_tmp29_ = _tmp28_;
			_param_size = _tmp29_;
			_param_index = -1;
			while (TRUE) {
				gint _tmp30_;
				gint _tmp31_;
				gint _tmp32_;
				ValaTypeParameter* param = NULL;
				ValaList* _tmp33_;
				gint _tmp34_;
				gpointer _tmp35_;
				ValaMethod* _tmp36_;
				ValaTypeParameter* _tmp37_;
				_tmp30_ = _param_index;
				_param_index = _tmp30_ + 1;
				_tmp31_ = _param_index;
				_tmp32_ = _param_size;
				if (!(_tmp31_ < _tmp32_)) {
					break;
				}
				_tmp33_ = _param_list;
				_tmp34_ = _param_index;
				_tmp35_ = vala_list_get (_tmp33_, _tmp34_);
				param = (ValaTypeParameter*) _tmp35_;
				_tmp36_ = self->priv->end_method;
				_tmp37_ = param;
				vala_method_add_type_parameter (_tmp36_, _tmp37_);
				_vala_code_node_unref0 (param);
			}
			_vala_iterable_unref0 (_param_list);
		}
	}
	_tmp38_ = self->priv->end_method;
	_tmp39_ = _vala_code_node_ref0 (_tmp38_);
	result = _tmp39_;
	return result;
}


ValaMethod*
vala_method_get_callback_method (ValaMethod* self)
{
	ValaMethod* result = NULL;
	gboolean _tmp0_;
	ValaMethod* _tmp1_;
	ValaMethod* _tmp24_;
	ValaMethod* _tmp25_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_coroutine;
	_vala_assert (_tmp0_, "this.coroutine");
	_tmp1_ = self->priv->callback_method;
	if (_tmp1_ == NULL) {
		ValaBooleanType* bool_type = NULL;
		ValaCodeContext* _tmp2_;
		ValaCodeContext* _tmp3_;
		ValaNamespace* _tmp4_;
		ValaNamespace* _tmp5_;
		ValaScope* _tmp6_;
		ValaScope* _tmp7_;
		ValaSymbol* _tmp8_;
		ValaStruct* _tmp9_;
		ValaBooleanType* _tmp10_;
		ValaBooleanType* _tmp11_;
		ValaBooleanType* _tmp12_;
		ValaBooleanType* _tmp13_;
		ValaSourceReference* _tmp14_;
		ValaSourceReference* _tmp15_;
		ValaMethod* _tmp16_;
		ValaMethod* _tmp17_;
		ValaMethod* _tmp18_;
		ValaMethod* _tmp19_;
		ValaMethod* _tmp20_;
		ValaScope* _tmp21_;
		ValaScope* _tmp22_;
		ValaMethod* _tmp23_;
		_tmp2_ = vala_code_context_get ();
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_code_context_get_root (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_symbol_get_scope ((ValaSymbol*) _tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_scope_lookup (_tmp7_, "bool");
		_tmp9_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, VALA_TYPE_STRUCT, ValaStruct);
		_tmp10_ = vala_boolean_type_new (_tmp9_);
		_tmp11_ = _tmp10_;
		_vala_code_node_unref0 (_tmp9_);
		_vala_code_context_unref0 (_tmp3_);
		bool_type = _tmp11_;
		_tmp12_ = bool_type;
		vala_data_type_set_value_owned ((ValaDataType*) _tmp12_, TRUE);
		_tmp13_ = bool_type;
		_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp15_ = _tmp14_;
		_tmp16_ = vala_method_new ("callback", (ValaDataType*) _tmp13_, _tmp15_, NULL);
		_vala_code_node_unref0 (self->priv->callback_method);
		self->priv->callback_method = _tmp16_;
		_tmp17_ = self->priv->callback_method;
		vala_symbol_set_access ((ValaSymbol*) _tmp17_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		_tmp18_ = self->priv->callback_method;
		vala_symbol_set_external ((ValaSymbol*) _tmp18_, TRUE);
		_tmp19_ = self->priv->callback_method;
		vala_method_set_binding (_tmp19_, VALA_MEMBER_BINDING_INSTANCE);
		_tmp20_ = self->priv->callback_method;
		_tmp21_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp22_ = _tmp21_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp20_, _tmp22_);
		_tmp23_ = self->priv->callback_method;
		vala_method_set_is_async_callback (_tmp23_, TRUE);
		_vala_code_node_unref0 (bool_type);
	}
	_tmp24_ = self->priv->callback_method;
	_tmp25_ = _vala_code_node_ref0 (_tmp24_);
	result = _tmp25_;
	return result;
}


ValaList*
vala_method_get_async_begin_parameters (ValaMethod* self)
{
	ValaList* result = NULL;
	gboolean _tmp0_;
	ValaSymbol* glib_ns = NULL;
	ValaCodeContext* _tmp1_;
	ValaCodeContext* _tmp2_;
	ValaNamespace* _tmp3_;
	ValaNamespace* _tmp4_;
	ValaScope* _tmp5_;
	ValaScope* _tmp6_;
	ValaSymbol* _tmp7_;
	ValaSymbol* _tmp8_;
	ValaArrayList* params = NULL;
	GEqualFunc _tmp9_;
	ValaArrayList* _tmp10_;
	ValaParameter* ellipsis = NULL;
	ValaDelegateType* callback_type = NULL;
	ValaSymbol* _tmp32_;
	ValaScope* _tmp33_;
	ValaScope* _tmp34_;
	ValaSymbol* _tmp35_;
	ValaDelegate* _tmp36_;
	ValaDelegateType* _tmp37_;
	ValaDelegateType* _tmp38_;
	ValaDelegateType* _tmp39_;
	ValaDelegateType* _tmp40_;
	ValaDelegateType* _tmp41_;
	ValaParameter* callback_param = NULL;
	ValaDelegateType* _tmp42_;
	ValaParameter* _tmp43_;
	ValaParameter* _tmp44_;
	ValaSourceReference* _tmp45_;
	ValaSourceReference* _tmp46_;
	ValaNullLiteral* _tmp47_;
	ValaNullLiteral* _tmp48_;
	ValaParameter* _tmp49_;
	ValaExpression* _tmp50_;
	ValaExpression* _tmp51_;
	ValaDelegateType* _tmp52_;
	ValaDataType* _tmp53_;
	ValaDataType* _tmp54_;
	ValaParameter* _tmp55_;
	ValaParameter* _tmp56_;
	ValaArrayList* _tmp57_;
	ValaParameter* _tmp58_;
	ValaParameter* _tmp59_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_coroutine;
	_vala_assert (_tmp0_, "this.coroutine");
	_tmp1_ = vala_code_context_get ();
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_code_context_get_root (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = vala_symbol_get_scope ((ValaSymbol*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_scope_lookup (_tmp6_, "GLib");
	_tmp8_ = _tmp7_;
	_vala_code_context_unref0 (_tmp2_);
	glib_ns = _tmp8_;
	_tmp9_ = g_direct_equal;
	_tmp10_ = vala_array_list_new (VALA_TYPE_PARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp9_);
	params = _tmp10_;
	ellipsis = NULL;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp11_;
		ValaList* _tmp12_;
		gint _param_size = 0;
		ValaList* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gint _param_index = 0;
		_tmp11_ = self->priv->parameters;
		_tmp12_ = _vala_iterable_ref0 (_tmp11_);
		_param_list = _tmp12_;
		_tmp13_ = _param_list;
		_tmp14_ = vala_collection_get_size ((ValaCollection*) _tmp13_);
		_tmp15_ = _tmp14_;
		_param_size = _tmp15_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp16_;
			gint _tmp17_;
			gint _tmp18_;
			ValaParameter* param = NULL;
			ValaList* _tmp19_;
			gint _tmp20_;
			gpointer _tmp21_;
			ValaParameter* _tmp22_;
			gboolean _tmp23_;
			gboolean _tmp24_;
			_tmp16_ = _param_index;
			_param_index = _tmp16_ + 1;
			_tmp17_ = _param_index;
			_tmp18_ = _param_size;
			if (!(_tmp17_ < _tmp18_)) {
				break;
			}
			_tmp19_ = _param_list;
			_tmp20_ = _param_index;
			_tmp21_ = vala_list_get (_tmp19_, _tmp20_);
			param = (ValaParameter*) _tmp21_;
			_tmp22_ = param;
			_tmp23_ = vala_parameter_get_ellipsis (_tmp22_);
			_tmp24_ = _tmp23_;
			if (_tmp24_) {
				ValaParameter* _tmp25_;
				ValaParameter* _tmp26_;
				_tmp25_ = param;
				_tmp26_ = _vala_code_node_ref0 (_tmp25_);
				_vala_code_node_unref0 (ellipsis);
				ellipsis = _tmp26_;
			} else {
				ValaParameter* _tmp27_;
				ValaParameterDirection _tmp28_;
				ValaParameterDirection _tmp29_;
				_tmp27_ = param;
				_tmp28_ = vala_parameter_get_direction (_tmp27_);
				_tmp29_ = _tmp28_;
				if (_tmp29_ == VALA_PARAMETER_DIRECTION_IN) {
					ValaArrayList* _tmp30_;
					ValaParameter* _tmp31_;
					_tmp30_ = params;
					_tmp31_ = param;
					vala_collection_add ((ValaCollection*) _tmp30_, _tmp31_);
				}
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp32_ = glib_ns;
	_tmp33_ = vala_symbol_get_scope (_tmp32_);
	_tmp34_ = _tmp33_;
	_tmp35_ = vala_scope_lookup (_tmp34_, "AsyncReadyCallback");
	_tmp36_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, VALA_TYPE_DELEGATE, ValaDelegate);
	_tmp37_ = vala_delegate_type_new (_tmp36_);
	_tmp38_ = _tmp37_;
	_vala_code_node_unref0 (_tmp36_);
	callback_type = _tmp38_;
	_tmp39_ = callback_type;
	vala_data_type_set_nullable ((ValaDataType*) _tmp39_, TRUE);
	_tmp40_ = callback_type;
	vala_data_type_set_value_owned ((ValaDataType*) _tmp40_, TRUE);
	_tmp41_ = callback_type;
	vala_delegate_type_set_is_called_once (_tmp41_, TRUE);
	_tmp42_ = callback_type;
	_tmp43_ = vala_parameter_new ("_callback_", (ValaDataType*) _tmp42_, NULL);
	callback_param = _tmp43_;
	_tmp44_ = callback_param;
	_tmp45_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp46_ = _tmp45_;
	_tmp47_ = vala_null_literal_new (_tmp46_);
	_tmp48_ = _tmp47_;
	vala_variable_set_initializer ((ValaVariable*) _tmp44_, (ValaExpression*) _tmp48_);
	_vala_code_node_unref0 (_tmp48_);
	_tmp49_ = callback_param;
	_tmp50_ = vala_variable_get_initializer ((ValaVariable*) _tmp49_);
	_tmp51_ = _tmp50_;
	_tmp52_ = callback_type;
	_tmp53_ = vala_data_type_copy ((ValaDataType*) _tmp52_);
	_tmp54_ = _tmp53_;
	vala_expression_set_target_type (_tmp51_, _tmp54_);
	_vala_code_node_unref0 (_tmp54_);
	_tmp55_ = callback_param;
	vala_code_node_set_attribute_double ((ValaCodeNode*) _tmp55_, "CCode", "pos", (gdouble) -1, NULL);
	_tmp56_ = callback_param;
	vala_code_node_set_attribute_double ((ValaCodeNode*) _tmp56_, "CCode", "delegate_target_pos", -0.9, NULL);
	_tmp57_ = params;
	_tmp58_ = callback_param;
	vala_collection_add ((ValaCollection*) _tmp57_, _tmp58_);
	_tmp59_ = ellipsis;
	if (_tmp59_ != NULL) {
		ValaArrayList* _tmp60_;
		ValaParameter* _tmp61_;
		_tmp60_ = params;
		_tmp61_ = ellipsis;
		vala_collection_add ((ValaCollection*) _tmp60_, _tmp61_);
	}
	result = (ValaList*) params;
	_vala_code_node_unref0 (callback_param);
	_vala_code_node_unref0 (callback_type);
	_vala_code_node_unref0 (ellipsis);
	_vala_code_node_unref0 (glib_ns);
	return result;
}


ValaList*
vala_method_get_async_end_parameters (ValaMethod* self)
{
	ValaList* result = NULL;
	gboolean _tmp0_;
	ValaArrayList* params = NULL;
	GEqualFunc _tmp1_;
	ValaArrayList* _tmp2_;
	ValaSymbol* glib_ns = NULL;
	ValaCodeContext* _tmp3_;
	ValaCodeContext* _tmp4_;
	ValaNamespace* _tmp5_;
	ValaNamespace* _tmp6_;
	ValaScope* _tmp7_;
	ValaScope* _tmp8_;
	ValaSymbol* _tmp9_;
	ValaSymbol* _tmp10_;
	ValaObjectType* result_type = NULL;
	ValaSymbol* _tmp11_;
	ValaScope* _tmp12_;
	ValaScope* _tmp13_;
	ValaSymbol* _tmp14_;
	ValaObjectTypeSymbol* _tmp15_;
	ValaObjectType* _tmp16_;
	ValaObjectType* _tmp17_;
	ValaParameter* result_param = NULL;
	ValaObjectType* _tmp18_;
	ValaParameter* _tmp19_;
	ValaParameter* _tmp20_;
	ValaArrayList* _tmp21_;
	ValaParameter* _tmp22_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_coroutine;
	_vala_assert (_tmp0_, "this.coroutine");
	_tmp1_ = g_direct_equal;
	_tmp2_ = vala_array_list_new (VALA_TYPE_PARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp1_);
	params = _tmp2_;
	_tmp3_ = vala_code_context_get ();
	_tmp4_ = _tmp3_;
	_tmp5_ = vala_code_context_get_root (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_symbol_get_scope ((ValaSymbol*) _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = vala_scope_lookup (_tmp8_, "GLib");
	_tmp10_ = _tmp9_;
	_vala_code_context_unref0 (_tmp4_);
	glib_ns = _tmp10_;
	_tmp11_ = glib_ns;
	_tmp12_ = vala_symbol_get_scope (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = vala_scope_lookup (_tmp13_, "AsyncResult");
	_tmp15_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol);
	_tmp16_ = vala_object_type_new (_tmp15_);
	_tmp17_ = _tmp16_;
	_vala_code_node_unref0 (_tmp15_);
	result_type = _tmp17_;
	_tmp18_ = result_type;
	_tmp19_ = vala_parameter_new ("_res_", (ValaDataType*) _tmp18_, NULL);
	result_param = _tmp19_;
	_tmp20_ = result_param;
	vala_code_node_set_attribute_double ((ValaCodeNode*) _tmp20_, "CCode", "pos", 0.1, NULL);
	_tmp21_ = params;
	_tmp22_ = result_param;
	vala_collection_add ((ValaCollection*) _tmp21_, _tmp22_);
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp23_;
		ValaList* _tmp24_;
		gint _param_size = 0;
		ValaList* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		gint _param_index = 0;
		_tmp23_ = self->priv->parameters;
		_tmp24_ = _vala_iterable_ref0 (_tmp23_);
		_param_list = _tmp24_;
		_tmp25_ = _param_list;
		_tmp26_ = vala_collection_get_size ((ValaCollection*) _tmp25_);
		_tmp27_ = _tmp26_;
		_param_size = _tmp27_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp28_;
			gint _tmp29_;
			gint _tmp30_;
			ValaParameter* param = NULL;
			ValaList* _tmp31_;
			gint _tmp32_;
			gpointer _tmp33_;
			ValaParameter* _tmp34_;
			ValaParameterDirection _tmp35_;
			ValaParameterDirection _tmp36_;
			_tmp28_ = _param_index;
			_param_index = _tmp28_ + 1;
			_tmp29_ = _param_index;
			_tmp30_ = _param_size;
			if (!(_tmp29_ < _tmp30_)) {
				break;
			}
			_tmp31_ = _param_list;
			_tmp32_ = _param_index;
			_tmp33_ = vala_list_get (_tmp31_, _tmp32_);
			param = (ValaParameter*) _tmp33_;
			_tmp34_ = param;
			_tmp35_ = vala_parameter_get_direction (_tmp34_);
			_tmp36_ = _tmp35_;
			if (_tmp36_ == VALA_PARAMETER_DIRECTION_OUT) {
				ValaArrayList* _tmp37_;
				ValaParameter* _tmp38_;
				_tmp37_ = params;
				_tmp38_ = param;
				vala_collection_add ((ValaCollection*) _tmp37_, _tmp38_);
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	result = (ValaList*) params;
	_vala_code_node_unref0 (result_param);
	_vala_code_node_unref0 (result_type);
	_vala_code_node_unref0 (glib_ns);
	return result;
}


void
vala_method_add_captured_variable (ValaMethod* self, 
                                   ValaLocalVariable* local)
{
	gboolean _tmp0_;
	ValaList* _tmp1_;
	ValaList* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (local != NULL);
	_tmp0_ = self->priv->_closure;
	_vala_assert (_tmp0_, "this.closure");
	_tmp1_ = self->priv->captured_variables;
	if (_tmp1_ == NULL) {
		GEqualFunc _tmp2_;
		ValaArrayList* _tmp3_;
		_tmp2_ = g_direct_equal;
		_tmp3_ = vala_array_list_new (VALA_TYPE_LOCAL_VARIABLE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp2_);
		_vala_iterable_unref0 (self->priv->captured_variables);
		self->priv->captured_variables = (ValaList*) _tmp3_;
	}
	_tmp4_ = self->priv->captured_variables;
	vala_collection_add ((ValaCollection*) _tmp4_, local);
}


void
vala_method_get_captured_variables (ValaMethod* self, 
                                    ValaCollection* variables)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (variables != NULL);
	_tmp0_ = self->priv->captured_variables;
	if (_tmp0_ != NULL) {
		{
			ValaList* _local_list = NULL;
			ValaList* _tmp1_;
			ValaList* _tmp2_;
			gint _local_size = 0;
			ValaList* _tmp3_;
			gint _tmp4_;
			gint _tmp5_;
			gint _local_index = 0;
			_tmp1_ = self->priv->captured_variables;
			_tmp2_ = _vala_iterable_ref0 (_tmp1_);
			_local_list = _tmp2_;
			_tmp3_ = _local_list;
			_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
			_tmp5_ = _tmp4_;
			_local_size = _tmp5_;
			_local_index = -1;
			while (TRUE) {
				gint _tmp6_;
				gint _tmp7_;
				gint _tmp8_;
				ValaLocalVariable* local = NULL;
				ValaList* _tmp9_;
				gint _tmp10_;
				gpointer _tmp11_;
				ValaLocalVariable* _tmp12_;
				_tmp6_ = _local_index;
				_local_index = _tmp6_ + 1;
				_tmp7_ = _local_index;
				_tmp8_ = _local_size;
				if (!(_tmp7_ < _tmp8_)) {
					break;
				}
				_tmp9_ = _local_list;
				_tmp10_ = _local_index;
				_tmp11_ = vala_list_get (_tmp9_, _tmp10_);
				local = (ValaLocalVariable*) _tmp11_;
				_tmp12_ = local;
				vala_collection_add (variables, _tmp12_);
				_vala_code_node_unref0 (local);
			}
			_vala_iterable_unref0 (_local_list);
		}
	}
}


static void
vala_method_real_get_defined_variables (ValaCodeNode* base, 
                                        ValaCollection* collection)
{
	ValaMethod * self;
	gboolean _tmp0_;
	self = (ValaMethod*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = self->priv->_closure;
	if (_tmp0_) {
		vala_method_get_captured_variables (self, G_TYPE_CHECK_INSTANCE_CAST (collection, VALA_TYPE_COLLECTION, ValaCollection));
	}
}


gint
vala_method_get_format_arg_index (ValaMethod* self)
{
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				ValaList* _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				ValaList* _tmp6_;
				gint _tmp7_;
				gpointer _tmp8_;
				ValaParameter* _tmp9_;
				gboolean _tmp10_;
				gboolean _tmp11_;
				gboolean _tmp12_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->priv->parameters;
				_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
				_tmp5_ = _tmp4_;
				if (!(_tmp2_ < _tmp5_)) {
					break;
				}
				_tmp6_ = self->priv->parameters;
				_tmp7_ = i;
				_tmp8_ = vala_list_get (_tmp6_, _tmp7_);
				_tmp9_ = (ValaParameter*) _tmp8_;
				_tmp10_ = vala_parameter_get_format_arg (_tmp9_);
				_tmp11_ = _tmp10_;
				_tmp12_ = _tmp11_;
				_vala_code_node_unref0 (_tmp9_);
				if (_tmp12_) {
					result = i;
					return result;
				}
			}
		}
	}
	result = -1;
	return result;
}


static ValaDataType*
vala_method_real_get_return_type (ValaCallable* base)
{
	ValaDataType* result;
	ValaMethod* self;
	ValaDataType* _tmp0_;
	self = (ValaMethod*) base;
	_tmp0_ = self->priv->_return_type;
	result = _tmp0_;
	return result;
}


static void
vala_method_real_set_return_type (ValaCallable* base, 
                                  ValaDataType* value)
{
	ValaMethod* self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaMethod*) base;
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_return_type);
	self->priv->_return_type = _tmp0_;
	_tmp1_ = self->priv->_return_type;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}


static gboolean
vala_method_real_get_has_result (ValaSubroutine* base)
{
	gboolean result;
	ValaMethod* self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaMethod*) base;
	_tmp0_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp1_ = _tmp0_;
	result = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_VOID_TYPE);
	return result;
}


ValaMemberBinding
vala_method_get_binding (ValaMethod* self)
{
	ValaMemberBinding result;
	ValaMemberBinding _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_binding;
	result = _tmp0_;
	return result;
}


void
vala_method_set_binding (ValaMethod* self, 
                         ValaMemberBinding value)
{
	g_return_if_fail (self != NULL);
	self->priv->_binding = value;
}


gboolean
vala_method_get_is_abstract (ValaMethod* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_abstract;
	result = _tmp0_;
	return result;
}


void
vala_method_set_is_abstract (ValaMethod* self, 
                             gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_abstract = value;
}


gboolean
vala_method_get_is_virtual (ValaMethod* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_virtual;
	result = _tmp0_;
	return result;
}


void
vala_method_set_is_virtual (ValaMethod* self, 
                            gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_virtual = value;
}


gboolean
vala_method_get_overrides (ValaMethod* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_overrides;
	result = _tmp0_;
	return result;
}


void
vala_method_set_overrides (ValaMethod* self, 
                           gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_overrides = value;
}


gboolean
vala_method_get_is_inline (ValaMethod* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_inline;
	result = _tmp0_;
	return result;
}


void
vala_method_set_is_inline (ValaMethod* self, 
                           gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_inline = value;
}


gboolean
vala_method_get_returns_floating_reference (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = vala_code_node_get_attribute_bool ((ValaCodeNode*) self, "CCode", "returns_floating_reference", FALSE);
	return result;
}


void
vala_method_set_returns_floating_reference (ValaMethod* self, 
                                            gboolean value)
{
	g_return_if_fail (self != NULL);
	vala_code_node_set_attribute_bool ((ValaCodeNode*) self, "CCode", "returns_floating_reference", value, NULL);
}


gboolean
vala_method_get_returns_modified_pointer (ValaMethod* self)
{
	gboolean result;
	ValaAttribute* _tmp0_;
	ValaAttribute* _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "ReturnsModifiedPointer");
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_ != NULL;
	_vala_code_node_unref0 (_tmp1_);
	result = _tmp2_;
	return result;
}


void
vala_method_set_returns_modified_pointer (ValaMethod* self, 
                                          gboolean value)
{
	g_return_if_fail (self != NULL);
	vala_code_node_set_attribute ((ValaCodeNode*) self, "ReturnsModifiedPointer", value, NULL);
}


ValaMethod*
vala_method_get_base_method (ValaMethod* self)
{
	ValaMethod* result;
	ValaMethod* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	vala_method_find_base_methods (self);
	_tmp0_ = self->priv->_base_method;
	result = _tmp0_;
	return result;
}


ValaMethod*
vala_method_get_base_interface_method (ValaMethod* self)
{
	ValaMethod* result;
	ValaMethod* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	vala_method_find_base_methods (self);
	_tmp0_ = self->priv->_base_interface_method;
	result = _tmp0_;
	return result;
}


ValaDataType*
vala_method_get_base_interface_type (ValaMethod* self)
{
	ValaDataType* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_base_interface_type;
	result = _tmp0_;
	return result;
}


void
vala_method_set_base_interface_type (ValaMethod* self, 
                                     ValaDataType* value)
{
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_base_interface_type);
	self->priv->_base_interface_type = _tmp0_;
	_tmp1_ = self->priv->_base_interface_type;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}


gboolean
vala_method_get_entry_point (ValaMethod* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_entry_point;
	result = _tmp0_;
	return result;
}


static void
vala_method_set_entry_point (ValaMethod* self, 
                             gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_entry_point = value;
}


ValaParameter*
vala_method_get_this_parameter (ValaMethod* self)
{
	ValaParameter* result;
	ValaParameter* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_this_parameter;
	result = _tmp0_;
	return result;
}


void
vala_method_set_this_parameter (ValaMethod* self, 
                                ValaParameter* value)
{
	ValaParameter* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_this_parameter);
	self->priv->_this_parameter = _tmp0_;
}


gboolean
vala_method_get_printf_format (ValaMethod* self)
{
	gboolean result;
	ValaAttribute* _tmp0_;
	ValaAttribute* _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "PrintfFormat");
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_ != NULL;
	_vala_code_node_unref0 (_tmp1_);
	result = _tmp2_;
	return result;
}


void
vala_method_set_printf_format (ValaMethod* self, 
                               gboolean value)
{
	g_return_if_fail (self != NULL);
	vala_code_node_set_attribute ((ValaCodeNode*) self, "PrintfFormat", value, NULL);
}


gboolean
vala_method_get_scanf_format (ValaMethod* self)
{
	gboolean result;
	ValaAttribute* _tmp0_;
	ValaAttribute* _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "ScanfFormat");
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_ != NULL;
	_vala_code_node_unref0 (_tmp1_);
	result = _tmp2_;
	return result;
}


void
vala_method_set_scanf_format (ValaMethod* self, 
                              gboolean value)
{
	g_return_if_fail (self != NULL);
	vala_code_node_set_attribute ((ValaCodeNode*) self, "ScanfFormat", value, NULL);
}


gboolean
vala_method_get_has_construct_function (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = vala_code_node_get_attribute_bool ((ValaCodeNode*) self, "CCode", "has_construct_function", TRUE);
	return result;
}


void
vala_method_set_has_construct_function (ValaMethod* self, 
                                        gboolean value)
{
	g_return_if_fail (self != NULL);
	vala_code_node_set_attribute_bool ((ValaCodeNode*) self, "CCode", "has_construct_function", value, NULL);
}


ValaSignal*
vala_method_get_signal_reference (ValaMethod* self)
{
	ValaSignal* result;
	ValaSignal* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_signal_reference;
	result = _tmp0_;
	return result;
}


void
vala_method_set_signal_reference (ValaMethod* self, 
                                  ValaSignal* value)
{
	g_return_if_fail (self != NULL);
	self->priv->_signal_reference = value;
}


gboolean
vala_method_get_closure (ValaMethod* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_closure;
	result = _tmp0_;
	return result;
}


void
vala_method_set_closure (ValaMethod* self, 
                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_closure = value;
}


gboolean
vala_method_get_coroutine (ValaMethod* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_coroutine;
	result = _tmp0_;
	return result;
}


void
vala_method_set_coroutine (ValaMethod* self, 
                           gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_coroutine = value;
}


gboolean
vala_method_get_is_async_callback (ValaMethod* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_async_callback;
	result = _tmp0_;
	return result;
}


void
vala_method_set_is_async_callback (ValaMethod* self, 
                                   gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_async_callback = value;
}


static void
vala_method_class_init (ValaMethodClass * klass)
{
	vala_method_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_method_finalize;
	g_type_class_add_private (klass, sizeof (ValaMethodPrivate));
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_method_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_method_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode *, ValaDataType*, ValaDataType*)) vala_method_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode *, ValaCodeContext*)) vala_method_real_check;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode *, ValaCollection*)) vala_method_real_get_defined_variables;
	VALA_SUBROUTINE_CLASS (klass)->get_has_result = vala_method_real_get_has_result;
}


static void
vala_method_vala_callable_interface_init (ValaCallableIface * iface)
{
	vala_method_vala_callable_parent_iface = g_type_interface_peek_parent (iface);
	iface->add_parameter = (void (*) (ValaCallable *, ValaParameter*)) vala_method_real_add_parameter;
	iface->get_parameters = (ValaList* (*) (ValaCallable *)) vala_method_real_get_parameters;
	iface->get_return_type = vala_method_real_get_return_type;
	iface->set_return_type = vala_method_real_set_return_type;
}


static void
vala_method_instance_init (ValaMethod * self)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = VALA_METHOD_GET_PRIVATE (self);
	self->priv->_binding = VALA_MEMBER_BINDING_INSTANCE;
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_PARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->parameters = (ValaList*) _tmp1_;
}


static void
vala_method_finalize (ValaCodeNode * obj)
{
	ValaMethod * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_METHOD, ValaMethod);
	_vala_iterable_unref0 (self->priv->type_parameters);
	_vala_code_node_unref0 (self->priv->_this_parameter);
	_vala_iterable_unref0 (self->priv->parameters);
	_vala_iterable_unref0 (self->priv->preconditions);
	_vala_iterable_unref0 (self->priv->postconditions);
	_vala_code_node_unref0 (self->priv->_return_type);
	_vala_code_node_unref0 (self->priv->_base_interface_type);
	_vala_code_node_unref0 (self->priv->callback_method);
	_vala_code_node_unref0 (self->priv->end_method);
	_vala_iterable_unref0 (self->priv->captured_variables);
	VALA_CODE_NODE_CLASS (vala_method_parent_class)->finalize (obj);
}


/**
 * Represents a type or namespace method.
 */
GType
vala_method_get_type (void)
{
	static volatile gsize vala_method_type_id__volatile = 0;
	if (g_once_init_enter (&vala_method_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaMethodClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_method_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMethod), 0, (GInstanceInitFunc) vala_method_instance_init, NULL };
		static const GInterfaceInfo vala_callable_info = { (GInterfaceInitFunc) vala_method_vala_callable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType vala_method_type_id;
		vala_method_type_id = g_type_register_static (VALA_TYPE_SUBROUTINE, "ValaMethod", &g_define_type_info, 0);
		g_type_add_interface_static (vala_method_type_id, VALA_TYPE_CALLABLE, &vala_callable_info);
		g_once_init_leave (&vala_method_type_id__volatile, vala_method_type_id);
	}
	return vala_method_type_id__volatile;
}



