/* valamemberaccess.c generated by valac, the Vala compiler
 * generated from valamemberaccess.vala, do not modify */

/* valamemberaccess.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <valagee.h>

enum  {
	VALA_MEMBER_ACCESS_0_PROPERTY,
	VALA_MEMBER_ACCESS_NUM_PROPERTIES
};
static GParamSpec* vala_member_access_properties[VALA_MEMBER_ACCESS_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))

struct _ValaMemberAccessPrivate {
	gchar* _member_name;
	gboolean _pointer_member_access;
	gboolean _prototype_access;
	gboolean _creation_member;
	gboolean _qualified;
	ValaExpression* _inner;
	ValaList* type_argument_list;
};


static gpointer vala_member_access_parent_class = NULL;

#define VALA_MEMBER_ACCESS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_MEMBER_ACCESS, ValaMemberAccessPrivate))
static void vala_member_access_real_accept (ValaCodeNode* base, 
                                     ValaCodeVisitor* visitor);
static void vala_member_access_real_accept_children (ValaCodeNode* base, 
                                              ValaCodeVisitor* visitor);
static gchar* vala_member_access_real_to_string (ValaCodeNode* base);
static void vala_member_access_real_replace_expression (ValaCodeNode* base, 
                                                 ValaExpression* old_node, 
                                                 ValaExpression* new_node);
static gboolean vala_member_access_real_is_pure (ValaExpression* base);
static gboolean vala_member_access_real_is_accessible (ValaExpression* base, 
                                                ValaSymbol* sym);
static void vala_member_access_real_replace_type (ValaCodeNode* base, 
                                           ValaDataType* old_type, 
                                           ValaDataType* new_type);
static gboolean vala_member_access_real_is_constant (ValaExpression* base);
static gboolean vala_member_access_real_is_non_null (ValaExpression* base);
static gboolean vala_member_access_real_check (ValaCodeNode* base, 
                                        ValaCodeContext* context);
static gboolean vala_member_access_is_instance_symbol (ValaSymbol* symbol);
static void vala_member_access_real_emit (ValaCodeNode* base, 
                                   ValaCodeGenerator* codegen);
static void vala_member_access_real_get_defined_variables (ValaCodeNode* base, 
                                                    ValaCollection* collection);
static void vala_member_access_real_get_used_variables (ValaCodeNode* base, 
                                                 ValaCollection* collection);
static void vala_member_access_finalize (ValaCodeNode * obj);


/**
 * Creates a new member access expression.
 *
 * @param inner            parent of the member
 * @param member_name      member name
 * @param source_reference reference to source code
 * @return                 newly created member access expression
 */
ValaMemberAccess*
vala_member_access_construct (GType object_type, 
                              ValaExpression* inner, 
                              const gchar* member_name, 
                              ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, inner);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}


ValaMemberAccess*
vala_member_access_new (ValaExpression* inner, 
                        const gchar* member_name, 
                        ValaSourceReference* source_reference)
{
	return vala_member_access_construct (VALA_TYPE_MEMBER_ACCESS, inner, member_name, source_reference);
}


ValaMemberAccess*
vala_member_access_construct_simple (GType object_type, 
                                     const gchar* member_name, 
                                     ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}


ValaMemberAccess*
vala_member_access_new_simple (const gchar* member_name, 
                               ValaSourceReference* source_reference)
{
	return vala_member_access_construct_simple (VALA_TYPE_MEMBER_ACCESS, member_name, source_reference);
}


ValaMemberAccess*
vala_member_access_construct_pointer (GType object_type, 
                                      ValaExpression* inner, 
                                      const gchar* member_name, 
                                      ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (inner != NULL, NULL);
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, inner);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_member_access_set_pointer_member_access (self, TRUE);
	return self;
}


ValaMemberAccess*
vala_member_access_new_pointer (ValaExpression* inner, 
                                const gchar* member_name, 
                                ValaSourceReference* source_reference)
{
	return vala_member_access_construct_pointer (VALA_TYPE_MEMBER_ACCESS, inner, member_name, source_reference);
}


/**
 * Appends the specified type as generic type argument.
 *
 * @param arg a type reference
 */
void
vala_member_access_add_type_argument (ValaMemberAccess* self, 
                                      ValaDataType* arg)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (arg != NULL);
	_tmp0_ = self->priv->type_argument_list;
	vala_collection_add ((ValaCollection*) _tmp0_, arg);
	vala_code_node_set_parent_node ((ValaCodeNode*) arg, (ValaCodeNode*) self);
}


/**
 * Returns a copy of the list of generic type arguments.
 *
 * @return type argument list
 */
static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}


ValaList*
vala_member_access_get_type_arguments (ValaMemberAccess* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->type_argument_list;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


static void
vala_member_access_real_accept (ValaCodeNode* base, 
                                ValaCodeVisitor* visitor)
{
	ValaMemberAccess * self;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_member_access (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}


static void
vala_member_access_real_accept_children (ValaCodeNode* base, 
                                         ValaCodeVisitor* visitor)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
	}
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp4_;
		ValaList* _tmp5_;
		gint _type_arg_size = 0;
		ValaList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _type_arg_index = 0;
		_tmp4_ = self->priv->type_argument_list;
		_tmp5_ = _vala_iterable_ref0 (_tmp4_);
		_type_arg_list = _tmp5_;
		_tmp6_ = _type_arg_list;
		_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_type_arg_size = _tmp8_;
		_type_arg_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			ValaDataType* type_arg = NULL;
			ValaList* _tmp12_;
			gint _tmp13_;
			gpointer _tmp14_;
			ValaDataType* _tmp15_;
			_tmp9_ = _type_arg_index;
			_type_arg_index = _tmp9_ + 1;
			_tmp10_ = _type_arg_index;
			_tmp11_ = _type_arg_size;
			if (!(_tmp10_ < _tmp11_)) {
				break;
			}
			_tmp12_ = _type_arg_list;
			_tmp13_ = _type_arg_index;
			_tmp14_ = vala_list_get (_tmp12_, _tmp13_);
			type_arg = (ValaDataType*) _tmp14_;
			_tmp15_ = type_arg;
			vala_code_node_accept ((ValaCodeNode*) _tmp15_, visitor);
			_vala_code_node_unref0 (type_arg);
		}
		_vala_iterable_unref0 (_type_arg_list);
	}
}


static gchar*
vala_member_access_real_to_string (ValaCodeNode* base)
{
	ValaMemberAccess * self;
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp2_;
	self = (ValaMemberAccess*) base;
	_tmp1_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		ValaSymbol* _tmp3_;
		ValaSymbol* _tmp4_;
		_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp4_ = _tmp3_;
		_tmp0_ = vala_symbol_is_instance_member (_tmp4_);
	}
	if (_tmp0_) {
		ValaExpression* _tmp5_;
		ValaExpression* _tmp6_;
		_tmp5_ = vala_member_access_get_inner (self);
		_tmp6_ = _tmp5_;
		if (_tmp6_ == NULL) {
			const gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp7_ = self->priv->_member_name;
			_tmp8_ = g_strdup (_tmp7_);
			result = _tmp8_;
			return result;
		} else {
			ValaExpression* _tmp9_;
			ValaExpression* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			const gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			_tmp9_ = vala_member_access_get_inner (self);
			_tmp10_ = _tmp9_;
			_tmp11_ = vala_code_node_to_string ((ValaCodeNode*) _tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = self->priv->_member_name;
			_tmp14_ = g_strdup_printf ("%s.%s", _tmp12_, _tmp13_);
			_tmp15_ = _tmp14_;
			_g_free0 (_tmp12_);
			result = _tmp15_;
			return result;
		}
	} else {
		ValaSymbol* _tmp16_;
		ValaSymbol* _tmp17_;
		gchar* _tmp18_;
		_tmp16_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_symbol_get_full_name (_tmp17_);
		result = _tmp18_;
		return result;
	}
}


static void
vala_member_access_real_replace_expression (ValaCodeNode* base, 
                                            ValaExpression* old_node, 
                                            ValaExpression* new_node)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_member_access_set_inner (self, new_node);
	}
}


static gboolean
vala_member_access_real_is_pure (ValaExpression* base)
{
	ValaMemberAccess * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaMemberAccess*) base;
	_tmp2_ = vala_member_access_get_inner (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_member_access_get_inner (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = vala_expression_is_pure (_tmp5_);
	}
	if (_tmp1_) {
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		_tmp0_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_PROPERTY);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static gboolean
vala_member_access_real_is_accessible (ValaExpression* base, 
                                       ValaSymbol* sym)
{
	ValaMemberAccess * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaMemberAccess*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp2_ = vala_member_access_get_inner (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_member_access_get_inner (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = vala_expression_is_accessible (_tmp5_, sym);
	}
	if (_tmp1_) {
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		_tmp0_ = vala_symbol_is_accessible (_tmp7_, sym);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static void
vala_member_access_real_replace_type (ValaCodeNode* base, 
                                      ValaDataType* old_type, 
                                      ValaDataType* new_type)
{
	ValaMemberAccess * self;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				ValaList* _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				ValaList* _tmp6_;
				gint _tmp7_;
				gpointer _tmp8_;
				ValaDataType* _tmp9_;
				gboolean _tmp10_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->priv->type_argument_list;
				_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
				_tmp5_ = _tmp4_;
				if (!(_tmp2_ < _tmp5_)) {
					break;
				}
				_tmp6_ = self->priv->type_argument_list;
				_tmp7_ = i;
				_tmp8_ = vala_list_get (_tmp6_, _tmp7_);
				_tmp9_ = (ValaDataType*) _tmp8_;
				_tmp10_ = _tmp9_ == old_type;
				_vala_code_node_unref0 (_tmp9_);
				if (_tmp10_) {
					ValaList* _tmp11_;
					gint _tmp12_;
					_tmp11_ = self->priv->type_argument_list;
					_tmp12_ = i;
					vala_list_set (_tmp11_, _tmp12_, new_type);
					return;
				}
			}
		}
	}
}


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static gboolean
vala_member_access_real_is_constant (ValaExpression* base)
{
	ValaMemberAccess * self;
	gboolean result = FALSE;
	ValaMethod* method = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaMethod* _tmp2_;
	ValaSymbol* _tmp3_;
	ValaSymbol* _tmp4_;
	self = (ValaMemberAccess*) base;
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_METHOD) ? ((ValaMethod*) _tmp1_) : NULL);
	method = _tmp2_;
	_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp4_ = _tmp3_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, VALA_TYPE_CONSTANT)) {
		result = TRUE;
		_vala_code_node_unref0 (method);
		return result;
	} else {
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		ValaSymbol* _tmp7_;
		ValaSymbol* _tmp8_;
		_tmp7_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp8_ = _tmp7_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, VALA_TYPE_ARRAY_LENGTH_FIELD)) {
			ValaExpression* _tmp9_;
			ValaExpression* _tmp10_;
			_tmp9_ = vala_member_access_get_inner (self);
			_tmp10_ = _tmp9_;
			_tmp6_ = _tmp10_ != NULL;
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			ValaExpression* _tmp11_;
			ValaExpression* _tmp12_;
			ValaSymbol* _tmp13_;
			ValaSymbol* _tmp14_;
			_tmp11_ = vala_member_access_get_inner (self);
			_tmp12_ = _tmp11_;
			_tmp13_ = vala_expression_get_symbol_reference (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp5_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp14_, VALA_TYPE_CONSTANT);
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			result = TRUE;
			_vala_code_node_unref0 (method);
			return result;
		} else {
			gboolean _tmp15_ = FALSE;
			ValaMethod* _tmp16_;
			_tmp16_ = method;
			if (_tmp16_ != NULL) {
				gboolean _tmp17_ = FALSE;
				ValaMethod* _tmp18_;
				ValaMemberBinding _tmp19_;
				ValaMemberBinding _tmp20_;
				_tmp18_ = method;
				_tmp19_ = vala_method_get_binding (_tmp18_);
				_tmp20_ = _tmp19_;
				if (_tmp20_ == VALA_MEMBER_BINDING_STATIC) {
					_tmp17_ = TRUE;
				} else {
					gboolean _tmp21_;
					_tmp21_ = self->priv->_prototype_access;
					_tmp17_ = _tmp21_;
				}
				_tmp15_ = _tmp17_;
			} else {
				_tmp15_ = FALSE;
			}
			if (_tmp15_) {
				result = TRUE;
				_vala_code_node_unref0 (method);
				return result;
			} else {
				result = FALSE;
				_vala_code_node_unref0 (method);
				return result;
			}
		}
	}
	_vala_code_node_unref0 (method);
}


static gboolean
vala_member_access_real_is_non_null (ValaExpression* base)
{
	ValaMemberAccess * self;
	gboolean result = FALSE;
	ValaConstant* c = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaConstant* _tmp2_;
	ValaConstant* _tmp3_;
	self = (ValaMemberAccess*) base;
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_CONSTANT) ? ((ValaConstant*) _tmp1_) : NULL);
	c = _tmp2_;
	_tmp3_ = c;
	if (_tmp3_ != NULL) {
		gboolean _tmp4_ = FALSE;
		ValaConstant* _tmp5_;
		_tmp5_ = c;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, VALA_TYPE_ENUM_VALUE)) {
			_tmp4_ = TRUE;
		} else {
			ValaConstant* _tmp6_;
			ValaDataType* _tmp7_;
			ValaDataType* _tmp8_;
			gboolean _tmp9_;
			gboolean _tmp10_;
			_tmp6_ = c;
			_tmp7_ = vala_constant_get_type_reference (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = vala_data_type_get_nullable (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp4_ = !_tmp10_;
		}
		result = _tmp4_;
		_vala_code_node_unref0 (c);
		return result;
	} else {
		result = FALSE;
		_vala_code_node_unref0 (c);
		return result;
	}
	_vala_code_node_unref0 (c);
}


static gboolean
vala_member_access_real_check (ValaCodeNode* base, 
                               ValaCodeContext* context)
{
	ValaMemberAccess * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaSymbol* base_symbol = NULL;
	ValaParameter* this_parameter = NULL;
	gboolean may_access_instance_members = FALSE;
	gboolean may_access_klass_members = FALSE;
	gboolean _tmp20_;
	gboolean _tmp560_ = FALSE;
	gboolean _tmp561_ = FALSE;
	ValaSymbol* _tmp562_;
	ValaSymbol* _tmp563_;
	ValaSymbol* _tmp591_;
	ValaSymbol* _tmp592_;
	ValaSymbol* member = NULL;
	ValaSymbol* _tmp615_;
	ValaSymbol* _tmp616_;
	ValaSymbol* _tmp617_;
	ValaSymbolAccessibility access = 0;
	gboolean instance = FALSE;
	gboolean klass = FALSE;
	gboolean generics = FALSE;
	ValaSymbol* _tmp618_;
	ValaSymbol* _tmp619_;
	ValaSymbol* _tmp1037_;
	ValaSymbol* _tmp1038_;
	ValaVersionAttribute* _tmp1039_;
	ValaVersionAttribute* _tmp1040_;
	ValaSourceReference* _tmp1041_;
	ValaSourceReference* _tmp1042_;
	ValaSymbolAccessibility _tmp1043_;
	gboolean _tmp1101_ = FALSE;
	gboolean _tmp1102_;
	gboolean _tmp1141_ = FALSE;
	gboolean _tmp1142_ = FALSE;
	gboolean _tmp1143_;
	gboolean _tmp1407_;
	gboolean _tmp1408_;
	self = (ValaMemberAccess*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_member_access_get_inner (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaExpression* _tmp6_;
		ValaExpression* _tmp7_;
		_tmp6_ = vala_member_access_get_inner (self);
		_tmp7_ = _tmp6_;
		vala_code_node_check ((ValaCodeNode*) _tmp7_, context);
	}
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp8_;
		ValaList* _tmp9_;
		gint _type_arg_size = 0;
		ValaList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _type_arg_index = 0;
		_tmp8_ = self->priv->type_argument_list;
		_tmp9_ = _vala_iterable_ref0 (_tmp8_);
		_type_arg_list = _tmp9_;
		_tmp10_ = _type_arg_list;
		_tmp11_ = vala_collection_get_size ((ValaCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_type_arg_size = _tmp12_;
		_type_arg_index = -1;
		while (TRUE) {
			gint _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
			ValaDataType* type_arg = NULL;
			ValaList* _tmp16_;
			gint _tmp17_;
			gpointer _tmp18_;
			ValaDataType* _tmp19_;
			_tmp13_ = _type_arg_index;
			_type_arg_index = _tmp13_ + 1;
			_tmp14_ = _type_arg_index;
			_tmp15_ = _type_arg_size;
			if (!(_tmp14_ < _tmp15_)) {
				break;
			}
			_tmp16_ = _type_arg_list;
			_tmp17_ = _type_arg_index;
			_tmp18_ = vala_list_get (_tmp16_, _tmp17_);
			type_arg = (ValaDataType*) _tmp18_;
			_tmp19_ = type_arg;
			vala_code_node_check ((ValaCodeNode*) _tmp19_, context);
			_vala_code_node_unref0 (type_arg);
		}
		_vala_iterable_unref0 (_type_arg_list);
	}
	base_symbol = NULL;
	this_parameter = NULL;
	may_access_instance_members = FALSE;
	may_access_klass_members = FALSE;
	vala_expression_set_symbol_reference ((ValaExpression*) self, NULL);
	_tmp20_ = self->priv->_qualified;
	if (_tmp20_) {
		ValaSemanticAnalyzer* _tmp21_;
		ValaSemanticAnalyzer* _tmp22_;
		ValaSymbol* _tmp23_;
		ValaSymbol* _tmp24_;
		ValaSemanticAnalyzer* _tmp25_;
		ValaSemanticAnalyzer* _tmp26_;
		ValaSymbol* _tmp27_;
		ValaScope* _tmp28_;
		ValaScope* _tmp29_;
		const gchar* _tmp30_;
		ValaSymbol* _tmp31_;
		ValaSymbol* _tmp32_;
		_tmp21_ = vala_code_context_get_analyzer (context);
		_tmp22_ = _tmp21_;
		_tmp23_ = _tmp22_->root_symbol;
		_tmp24_ = _vala_code_node_ref0 (_tmp23_);
		_vala_code_node_unref0 (base_symbol);
		base_symbol = _tmp24_;
		_tmp25_ = vala_code_context_get_analyzer (context);
		_tmp26_ = _tmp25_;
		_tmp27_ = _tmp26_->root_symbol;
		_tmp28_ = vala_symbol_get_scope (_tmp27_);
		_tmp29_ = _tmp28_;
		_tmp30_ = self->priv->_member_name;
		_tmp31_ = vala_scope_lookup (_tmp29_, _tmp30_);
		_tmp32_ = _tmp31_;
		vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp32_);
		_vala_code_node_unref0 (_tmp32_);
	} else {
		ValaExpression* _tmp33_;
		ValaExpression* _tmp34_;
		_tmp33_ = vala_member_access_get_inner (self);
		_tmp34_ = _tmp33_;
		if (_tmp34_ == NULL) {
			const gchar* _tmp35_;
			ValaSemanticAnalyzer* _tmp40_;
			ValaSemanticAnalyzer* _tmp41_;
			ValaSymbol* _tmp42_;
			ValaSymbol* _tmp43_;
			ValaSymbol* _tmp44_;
			gboolean method_found = FALSE;
			ValaSymbol* sym = NULL;
			ValaSemanticAnalyzer* _tmp45_;
			ValaSemanticAnalyzer* _tmp46_;
			ValaSymbol* _tmp47_;
			ValaSymbol* _tmp48_;
			ValaSymbol* _tmp49_;
			gboolean _tmp161_ = FALSE;
			ValaSymbol* _tmp162_;
			ValaSymbol* _tmp163_;
			_tmp35_ = self->priv->_member_name;
			if (g_strcmp0 (_tmp35_, "this") == 0) {
				ValaSemanticAnalyzer* _tmp36_;
				ValaSemanticAnalyzer* _tmp37_;
				_tmp36_ = vala_code_context_get_analyzer (context);
				_tmp37_ = _tmp36_;
				if (!vala_semantic_analyzer_is_in_instance_method (_tmp37_)) {
					ValaSourceReference* _tmp38_;
					ValaSourceReference* _tmp39_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp38_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp39_ = _tmp38_;
					vala_report_error (_tmp39_, "This access invalid outside of instance methods");
					result = FALSE;
					_vala_code_node_unref0 (this_parameter);
					_vala_code_node_unref0 (base_symbol);
					return result;
				}
			}
			_tmp40_ = vala_code_context_get_analyzer (context);
			_tmp41_ = _tmp40_;
			_tmp42_ = vala_semantic_analyzer_get_current_symbol (_tmp41_);
			_tmp43_ = _tmp42_;
			_tmp44_ = _vala_code_node_ref0 (_tmp43_);
			_vala_code_node_unref0 (base_symbol);
			base_symbol = _tmp44_;
			method_found = FALSE;
			_tmp45_ = vala_code_context_get_analyzer (context);
			_tmp46_ = _tmp45_;
			_tmp47_ = vala_semantic_analyzer_get_current_symbol (_tmp46_);
			_tmp48_ = _tmp47_;
			_tmp49_ = _vala_code_node_ref0 (_tmp48_);
			sym = _tmp49_;
			while (TRUE) {
				gboolean _tmp50_ = FALSE;
				ValaSymbol* _tmp51_;
				gboolean _tmp54_;
				ValaSymbol* _tmp108_;
				const gchar* _tmp109_;
				ValaSymbol* _tmp110_;
				ValaSymbol* _tmp111_;
				gboolean _tmp112_ = FALSE;
				gboolean _tmp113_ = FALSE;
				ValaSymbol* _tmp114_;
				ValaSymbol* _tmp115_;
				ValaSymbol* _tmp154_;
				ValaSymbol* _tmp155_;
				ValaSymbol* _tmp157_;
				ValaSymbol* _tmp158_;
				ValaSymbol* _tmp159_;
				ValaSymbol* _tmp160_;
				_tmp51_ = sym;
				if (_tmp51_ != NULL) {
					ValaSymbol* _tmp52_;
					ValaSymbol* _tmp53_;
					_tmp52_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp53_ = _tmp52_;
					_tmp50_ = _tmp53_ == NULL;
				} else {
					_tmp50_ = FALSE;
				}
				if (!_tmp50_) {
					break;
				}
				_tmp54_ = method_found;
				if (!_tmp54_) {
					ValaSymbol* _tmp55_;
					_tmp55_ = sym;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp55_, VALA_TYPE_CREATION_METHOD)) {
						ValaCreationMethod* cm = NULL;
						ValaSymbol* _tmp56_;
						ValaCreationMethod* _tmp57_;
						ValaCreationMethod* _tmp58_;
						ValaParameter* _tmp59_;
						ValaParameter* _tmp60_;
						ValaParameter* _tmp61_;
						_tmp56_ = sym;
						_tmp57_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp56_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
						cm = _tmp57_;
						_tmp58_ = cm;
						_tmp59_ = vala_method_get_this_parameter ((ValaMethod*) _tmp58_);
						_tmp60_ = _tmp59_;
						_tmp61_ = _vala_code_node_ref0 (_tmp60_);
						_vala_code_node_unref0 (this_parameter);
						this_parameter = _tmp61_;
						may_access_instance_members = TRUE;
						may_access_klass_members = TRUE;
						method_found = TRUE;
						_vala_code_node_unref0 (cm);
					} else {
						ValaSymbol* _tmp62_;
						_tmp62_ = sym;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp62_, VALA_TYPE_PROPERTY)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp63_;
							ValaProperty* _tmp64_;
							ValaProperty* _tmp65_;
							ValaParameter* _tmp66_;
							ValaParameter* _tmp67_;
							ValaParameter* _tmp68_;
							ValaProperty* _tmp69_;
							ValaMemberBinding _tmp70_;
							ValaMemberBinding _tmp71_;
							ValaProperty* _tmp72_;
							ValaMemberBinding _tmp73_;
							ValaMemberBinding _tmp74_;
							_tmp63_ = sym;
							_tmp64_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp63_, VALA_TYPE_PROPERTY, ValaProperty));
							prop = _tmp64_;
							_tmp65_ = prop;
							_tmp66_ = vala_property_get_this_parameter (_tmp65_);
							_tmp67_ = _tmp66_;
							_tmp68_ = _vala_code_node_ref0 (_tmp67_);
							_vala_code_node_unref0 (this_parameter);
							this_parameter = _tmp68_;
							_tmp69_ = prop;
							_tmp70_ = vala_property_get_binding (_tmp69_);
							_tmp71_ = _tmp70_;
							may_access_instance_members = _tmp71_ == VALA_MEMBER_BINDING_INSTANCE;
							_tmp72_ = prop;
							_tmp73_ = vala_property_get_binding (_tmp72_);
							_tmp74_ = _tmp73_;
							may_access_klass_members = _tmp74_ != VALA_MEMBER_BINDING_STATIC;
							method_found = TRUE;
							_vala_code_node_unref0 (prop);
						} else {
							ValaSymbol* _tmp75_;
							_tmp75_ = sym;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp75_, VALA_TYPE_CONSTRUCTOR)) {
								ValaConstructor* c = NULL;
								ValaSymbol* _tmp76_;
								ValaConstructor* _tmp77_;
								ValaConstructor* _tmp78_;
								ValaParameter* _tmp79_;
								ValaParameter* _tmp80_;
								ValaParameter* _tmp81_;
								ValaConstructor* _tmp82_;
								ValaMemberBinding _tmp83_;
								ValaMemberBinding _tmp84_;
								_tmp76_ = sym;
								_tmp77_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp76_, VALA_TYPE_CONSTRUCTOR, ValaConstructor));
								c = _tmp77_;
								_tmp78_ = c;
								_tmp79_ = vala_constructor_get_this_parameter (_tmp78_);
								_tmp80_ = _tmp79_;
								_tmp81_ = _vala_code_node_ref0 (_tmp80_);
								_vala_code_node_unref0 (this_parameter);
								this_parameter = _tmp81_;
								_tmp82_ = c;
								_tmp83_ = vala_constructor_get_binding (_tmp82_);
								_tmp84_ = _tmp83_;
								may_access_instance_members = _tmp84_ == VALA_MEMBER_BINDING_INSTANCE;
								may_access_klass_members = TRUE;
								method_found = TRUE;
								_vala_code_node_unref0 (c);
							} else {
								ValaSymbol* _tmp85_;
								_tmp85_ = sym;
								if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp85_, VALA_TYPE_DESTRUCTOR)) {
									ValaDestructor* d = NULL;
									ValaSymbol* _tmp86_;
									ValaDestructor* _tmp87_;
									ValaDestructor* _tmp88_;
									ValaParameter* _tmp89_;
									ValaParameter* _tmp90_;
									ValaParameter* _tmp91_;
									ValaDestructor* _tmp92_;
									ValaMemberBinding _tmp93_;
									ValaMemberBinding _tmp94_;
									_tmp86_ = sym;
									_tmp87_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp86_, VALA_TYPE_DESTRUCTOR, ValaDestructor));
									d = _tmp87_;
									_tmp88_ = d;
									_tmp89_ = vala_destructor_get_this_parameter (_tmp88_);
									_tmp90_ = _tmp89_;
									_tmp91_ = _vala_code_node_ref0 (_tmp90_);
									_vala_code_node_unref0 (this_parameter);
									this_parameter = _tmp91_;
									_tmp92_ = d;
									_tmp93_ = vala_destructor_get_binding (_tmp92_);
									_tmp94_ = _tmp93_;
									may_access_instance_members = _tmp94_ == VALA_MEMBER_BINDING_INSTANCE;
									may_access_klass_members = TRUE;
									method_found = TRUE;
									_vala_code_node_unref0 (d);
								} else {
									ValaSymbol* _tmp95_;
									_tmp95_ = sym;
									if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp95_, VALA_TYPE_METHOD)) {
										ValaMethod* m = NULL;
										ValaSymbol* _tmp96_;
										ValaMethod* _tmp97_;
										ValaMethod* _tmp98_;
										ValaParameter* _tmp99_;
										ValaParameter* _tmp100_;
										ValaParameter* _tmp101_;
										ValaMethod* _tmp102_;
										ValaMemberBinding _tmp103_;
										ValaMemberBinding _tmp104_;
										ValaMethod* _tmp105_;
										ValaMemberBinding _tmp106_;
										ValaMemberBinding _tmp107_;
										_tmp96_ = sym;
										_tmp97_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp96_, VALA_TYPE_METHOD, ValaMethod));
										m = _tmp97_;
										_tmp98_ = m;
										_tmp99_ = vala_method_get_this_parameter (_tmp98_);
										_tmp100_ = _tmp99_;
										_tmp101_ = _vala_code_node_ref0 (_tmp100_);
										_vala_code_node_unref0 (this_parameter);
										this_parameter = _tmp101_;
										_tmp102_ = m;
										_tmp103_ = vala_method_get_binding (_tmp102_);
										_tmp104_ = _tmp103_;
										may_access_instance_members = _tmp104_ == VALA_MEMBER_BINDING_INSTANCE;
										_tmp105_ = m;
										_tmp106_ = vala_method_get_binding (_tmp105_);
										_tmp107_ = _tmp106_;
										may_access_klass_members = _tmp107_ != VALA_MEMBER_BINDING_STATIC;
										method_found = TRUE;
										_vala_code_node_unref0 (m);
									}
								}
							}
						}
					}
				}
				_tmp108_ = sym;
				_tmp109_ = self->priv->_member_name;
				_tmp110_ = vala_semantic_analyzer_symbol_lookup_inherited (_tmp108_, _tmp109_);
				_tmp111_ = _tmp110_;
				vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp111_);
				_vala_code_node_unref0 (_tmp111_);
				_tmp114_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp115_ = _tmp114_;
				if (_tmp115_ == NULL) {
					ValaSymbol* _tmp116_;
					_tmp116_ = sym;
					_tmp113_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp116_, VALA_TYPE_TYPESYMBOL);
				} else {
					_tmp113_ = FALSE;
				}
				if (_tmp113_) {
					gboolean _tmp117_;
					_tmp117_ = may_access_instance_members;
					_tmp112_ = _tmp117_;
				} else {
					_tmp112_ = FALSE;
				}
				if (_tmp112_) {
					ValaParameter* _tmp118_;
					ValaDataType* _tmp119_;
					ValaDataType* _tmp120_;
					const gchar* _tmp121_;
					ValaSymbol* _tmp122_;
					ValaSymbol* _tmp123_;
					gboolean _tmp124_ = FALSE;
					ValaSymbol* _tmp125_;
					ValaSymbol* _tmp126_;
					_tmp118_ = this_parameter;
					_tmp119_ = vala_variable_get_variable_type ((ValaVariable*) _tmp118_);
					_tmp120_ = _tmp119_;
					_tmp121_ = self->priv->_member_name;
					_tmp122_ = vala_data_type_get_member (_tmp120_, _tmp121_);
					_tmp123_ = _tmp122_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp123_);
					_vala_code_node_unref0 (_tmp123_);
					_tmp125_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp126_ = _tmp125_;
					if (_tmp126_ != NULL) {
						ValaSymbol* _tmp127_;
						ValaSymbol* _tmp128_;
						_tmp127_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
						_tmp128_ = _tmp127_;
						_tmp124_ = vala_member_access_is_instance_symbol (_tmp128_);
					} else {
						_tmp124_ = FALSE;
					}
					if (_tmp124_) {
						ValaSourceReference* _tmp129_;
						ValaSourceReference* _tmp130_;
						ValaMemberAccess* _tmp131_;
						ValaMemberAccess* _tmp132_;
						ValaExpression* _tmp133_;
						ValaExpression* _tmp134_;
						ValaParameter* _tmp135_;
						ValaDataType* _tmp136_;
						ValaDataType* _tmp137_;
						ValaDataType* _tmp138_;
						ValaDataType* _tmp139_;
						ValaExpression* _tmp140_;
						ValaExpression* _tmp141_;
						ValaDataType* _tmp142_;
						ValaDataType* _tmp143_;
						ValaExpression* _tmp144_;
						ValaExpression* _tmp145_;
						ValaParameter* _tmp146_;
						ValaExpression* _tmp147_;
						ValaExpression* _tmp148_;
						ValaDataType* _tmp149_;
						ValaDataType* _tmp150_;
						const gchar* _tmp151_;
						ValaSymbol* _tmp152_;
						ValaSymbol* _tmp153_;
						_tmp129_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp130_ = _tmp129_;
						_tmp131_ = vala_member_access_new (NULL, "this", _tmp130_);
						_tmp132_ = _tmp131_;
						vala_member_access_set_inner (self, (ValaExpression*) _tmp132_);
						_vala_code_node_unref0 (_tmp132_);
						_tmp133_ = vala_member_access_get_inner (self);
						_tmp134_ = _tmp133_;
						_tmp135_ = this_parameter;
						_tmp136_ = vala_variable_get_variable_type ((ValaVariable*) _tmp135_);
						_tmp137_ = _tmp136_;
						_tmp138_ = vala_data_type_copy (_tmp137_);
						_tmp139_ = _tmp138_;
						vala_expression_set_value_type (_tmp134_, _tmp139_);
						_vala_code_node_unref0 (_tmp139_);
						_tmp140_ = vala_member_access_get_inner (self);
						_tmp141_ = _tmp140_;
						_tmp142_ = vala_expression_get_value_type (_tmp141_);
						_tmp143_ = _tmp142_;
						vala_data_type_set_value_owned (_tmp143_, FALSE);
						_tmp144_ = vala_member_access_get_inner (self);
						_tmp145_ = _tmp144_;
						_tmp146_ = this_parameter;
						vala_expression_set_symbol_reference (_tmp145_, (ValaSymbol*) _tmp146_);
						_tmp147_ = vala_member_access_get_inner (self);
						_tmp148_ = _tmp147_;
						_tmp149_ = vala_expression_get_value_type (_tmp148_);
						_tmp150_ = _tmp149_;
						_tmp151_ = self->priv->_member_name;
						_tmp152_ = vala_data_type_get_member (_tmp150_, _tmp151_);
						_tmp153_ = _tmp152_;
						vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp153_);
						_vala_code_node_unref0 (_tmp153_);
					}
				}
				_tmp154_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp155_ = _tmp154_;
				if (_tmp155_ == NULL) {
					ValaSymbol* _tmp156_;
					_tmp156_ = sym;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp156_, VALA_TYPE_TYPESYMBOL)) {
						_vala_code_node_unref0 (this_parameter);
						this_parameter = NULL;
						may_access_instance_members = FALSE;
						may_access_klass_members = FALSE;
					}
				}
				_tmp157_ = sym;
				_tmp158_ = vala_symbol_get_parent_symbol (_tmp157_);
				_tmp159_ = _tmp158_;
				_tmp160_ = _vala_code_node_ref0 (_tmp159_);
				_vala_code_node_unref0 (sym);
				sym = _tmp160_;
			}
			_tmp162_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp163_ = _tmp162_;
			if (_tmp163_ == NULL) {
				ValaSourceReference* _tmp164_;
				ValaSourceReference* _tmp165_;
				_tmp164_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp165_ = _tmp164_;
				_tmp161_ = _tmp165_ != NULL;
			} else {
				_tmp161_ = FALSE;
			}
			if (_tmp161_) {
				{
					ValaList* _ns_list = NULL;
					ValaSourceReference* _tmp166_;
					ValaSourceReference* _tmp167_;
					ValaList* _tmp168_;
					ValaList* _tmp169_;
					ValaList* _tmp170_;
					gint _ns_size = 0;
					ValaList* _tmp171_;
					gint _tmp172_;
					gint _tmp173_;
					gint _ns_index = 0;
					_tmp166_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp167_ = _tmp166_;
					_tmp168_ = vala_source_reference_get_using_directives (_tmp167_);
					_tmp169_ = _tmp168_;
					_tmp170_ = _vala_iterable_ref0 (_tmp169_);
					_ns_list = _tmp170_;
					_tmp171_ = _ns_list;
					_tmp172_ = vala_collection_get_size ((ValaCollection*) _tmp171_);
					_tmp173_ = _tmp172_;
					_ns_size = _tmp173_;
					_ns_index = -1;
					while (TRUE) {
						gint _tmp174_;
						gint _tmp175_;
						gint _tmp176_;
						ValaUsingDirective* ns = NULL;
						ValaList* _tmp177_;
						gint _tmp178_;
						gpointer _tmp179_;
						ValaSymbol* local_sym = NULL;
						ValaUsingDirective* _tmp180_;
						ValaSymbol* _tmp181_;
						ValaSymbol* _tmp182_;
						ValaScope* _tmp183_;
						ValaScope* _tmp184_;
						const gchar* _tmp185_;
						ValaSymbol* _tmp186_;
						ValaSymbol* _tmp187_;
						_tmp174_ = _ns_index;
						_ns_index = _tmp174_ + 1;
						_tmp175_ = _ns_index;
						_tmp176_ = _ns_size;
						if (!(_tmp175_ < _tmp176_)) {
							break;
						}
						_tmp177_ = _ns_list;
						_tmp178_ = _ns_index;
						_tmp179_ = vala_list_get (_tmp177_, _tmp178_);
						ns = (ValaUsingDirective*) _tmp179_;
						_tmp180_ = ns;
						_tmp181_ = vala_using_directive_get_namespace_symbol (_tmp180_);
						_tmp182_ = _tmp181_;
						_tmp183_ = vala_symbol_get_scope (_tmp182_);
						_tmp184_ = _tmp183_;
						_tmp185_ = self->priv->_member_name;
						_tmp186_ = vala_scope_lookup (_tmp184_, _tmp185_);
						local_sym = _tmp186_;
						_tmp187_ = local_sym;
						if (_tmp187_ != NULL) {
							gboolean _tmp188_ = FALSE;
							ValaSymbol* _tmp189_;
							ValaSymbol* _tmp190_;
							ValaSymbol* _tmp206_;
							_tmp189_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
							_tmp190_ = _tmp189_;
							if (_tmp190_ != NULL) {
								ValaSymbol* _tmp191_;
								ValaSymbol* _tmp192_;
								ValaSymbol* _tmp193_;
								_tmp191_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp192_ = _tmp191_;
								_tmp193_ = local_sym;
								_tmp188_ = _tmp192_ != _tmp193_;
							} else {
								_tmp188_ = FALSE;
							}
							if (_tmp188_) {
								ValaSourceReference* _tmp194_;
								ValaSourceReference* _tmp195_;
								const gchar* _tmp196_;
								ValaSymbol* _tmp197_;
								ValaSymbol* _tmp198_;
								gchar* _tmp199_;
								gchar* _tmp200_;
								ValaSymbol* _tmp201_;
								gchar* _tmp202_;
								gchar* _tmp203_;
								gchar* _tmp204_;
								gchar* _tmp205_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp194_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp195_ = _tmp194_;
								_tmp196_ = self->priv->_member_name;
								_tmp197_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp198_ = _tmp197_;
								_tmp199_ = vala_symbol_get_full_name (_tmp198_);
								_tmp200_ = _tmp199_;
								_tmp201_ = local_sym;
								_tmp202_ = vala_symbol_get_full_name (_tmp201_);
								_tmp203_ = _tmp202_;
								_tmp204_ = g_strdup_printf ("`%s' is an ambiguous reference between `%s' and `%s'", _tmp196_, _tmp200_, _tmp203_);
								_tmp205_ = _tmp204_;
								vala_report_error (_tmp195_, _tmp205_);
								_g_free0 (_tmp205_);
								_g_free0 (_tmp203_);
								_g_free0 (_tmp200_);
								result = FALSE;
								_vala_code_node_unref0 (local_sym);
								_vala_code_node_unref0 (ns);
								_vala_iterable_unref0 (_ns_list);
								_vala_code_node_unref0 (sym);
								_vala_code_node_unref0 (this_parameter);
								_vala_code_node_unref0 (base_symbol);
								return result;
							}
							_tmp206_ = local_sym;
							vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp206_);
						}
						_vala_code_node_unref0 (local_sym);
						_vala_code_node_unref0 (ns);
					}
					_vala_iterable_unref0 (_ns_list);
				}
			}
			_vala_code_node_unref0 (sym);
		} else {
			ValaExpression* _tmp207_;
			ValaExpression* _tmp208_;
			gboolean _tmp209_;
			gboolean _tmp210_;
			ValaExpression* _tmp211_;
			ValaExpression* _tmp212_;
			ValaDataType* _tmp213_;
			ValaDataType* _tmp214_;
			ValaExpression* _tmp233_;
			ValaExpression* _tmp234_;
			gboolean _tmp250_ = FALSE;
			ValaExpression* _tmp251_;
			ValaExpression* _tmp252_;
			gboolean _tmp274_ = FALSE;
			ValaSymbol* _tmp275_;
			ValaSymbol* _tmp276_;
			gboolean _tmp311_ = FALSE;
			gboolean _tmp312_ = FALSE;
			ValaSymbol* _tmp313_;
			ValaSymbol* _tmp314_;
			_tmp207_ = vala_member_access_get_inner (self);
			_tmp208_ = _tmp207_;
			_tmp209_ = vala_code_node_get_error ((ValaCodeNode*) _tmp208_);
			_tmp210_ = _tmp209_;
			if (_tmp210_) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_code_node_unref0 (this_parameter);
				_vala_code_node_unref0 (base_symbol);
				return result;
			}
			_tmp211_ = vala_member_access_get_inner (self);
			_tmp212_ = _tmp211_;
			_tmp213_ = vala_expression_get_value_type (_tmp212_);
			_tmp214_ = _tmp213_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp214_, VALA_TYPE_POINTER_TYPE)) {
				ValaPointerType* pointer_type = NULL;
				ValaExpression* _tmp215_;
				ValaExpression* _tmp216_;
				ValaDataType* _tmp217_;
				ValaDataType* _tmp218_;
				ValaPointerType* _tmp219_;
				gboolean _tmp220_ = FALSE;
				ValaPointerType* _tmp221_;
				_tmp215_ = vala_member_access_get_inner (self);
				_tmp216_ = _tmp215_;
				_tmp217_ = vala_expression_get_value_type (_tmp216_);
				_tmp218_ = _tmp217_;
				_tmp219_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp218_, VALA_TYPE_POINTER_TYPE) ? ((ValaPointerType*) _tmp218_) : NULL);
				pointer_type = _tmp219_;
				_tmp221_ = pointer_type;
				if (_tmp221_ != NULL) {
					ValaPointerType* _tmp222_;
					ValaDataType* _tmp223_;
					ValaDataType* _tmp224_;
					_tmp222_ = pointer_type;
					_tmp223_ = vala_pointer_type_get_base_type (_tmp222_);
					_tmp224_ = _tmp223_;
					_tmp220_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp224_, VALA_TYPE_VALUE_TYPE);
				} else {
					_tmp220_ = FALSE;
				}
				if (_tmp220_) {
					ValaExpression* _tmp225_;
					ValaExpression* _tmp226_;
					ValaSourceReference* _tmp227_;
					ValaSourceReference* _tmp228_;
					ValaPointerIndirection* _tmp229_;
					ValaPointerIndirection* _tmp230_;
					ValaExpression* _tmp231_;
					ValaExpression* _tmp232_;
					_tmp225_ = vala_member_access_get_inner (self);
					_tmp226_ = _tmp225_;
					_tmp227_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp228_ = _tmp227_;
					_tmp229_ = vala_pointer_indirection_new (_tmp226_, _tmp228_);
					_tmp230_ = _tmp229_;
					vala_member_access_set_inner (self, (ValaExpression*) _tmp230_);
					_vala_code_node_unref0 (_tmp230_);
					_tmp231_ = vala_member_access_get_inner (self);
					_tmp232_ = _tmp231_;
					vala_code_node_check ((ValaCodeNode*) _tmp232_, context);
					vala_member_access_set_pointer_member_access (self, FALSE);
				}
				_vala_code_node_unref0 (pointer_type);
			}
			_tmp233_ = vala_member_access_get_inner (self);
			_tmp234_ = _tmp233_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp234_, VALA_TYPE_MEMBER_ACCESS)) {
				ValaMemberAccess* ma = NULL;
				ValaExpression* _tmp235_;
				ValaExpression* _tmp236_;
				ValaMemberAccess* _tmp237_;
				ValaMemberAccess* _tmp238_;
				gboolean _tmp239_;
				_tmp235_ = vala_member_access_get_inner (self);
				_tmp236_ = _tmp235_;
				_tmp237_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp236_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
				ma = _tmp237_;
				_tmp238_ = ma;
				_tmp239_ = _tmp238_->priv->_prototype_access;
				if (_tmp239_) {
					ValaSourceReference* _tmp240_;
					ValaSourceReference* _tmp241_;
					ValaExpression* _tmp242_;
					ValaExpression* _tmp243_;
					ValaSymbol* _tmp244_;
					ValaSymbol* _tmp245_;
					gchar* _tmp246_;
					gchar* _tmp247_;
					gchar* _tmp248_;
					gchar* _tmp249_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp240_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp241_ = _tmp240_;
					_tmp242_ = vala_member_access_get_inner (self);
					_tmp243_ = _tmp242_;
					_tmp244_ = vala_expression_get_symbol_reference (_tmp243_);
					_tmp245_ = _tmp244_;
					_tmp246_ = vala_symbol_get_full_name (_tmp245_);
					_tmp247_ = _tmp246_;
					_tmp248_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp247_);
					_tmp249_ = _tmp248_;
					vala_report_error (_tmp241_, _tmp249_);
					_g_free0 (_tmp249_);
					_g_free0 (_tmp247_);
					result = FALSE;
					_vala_code_node_unref0 (ma);
					_vala_code_node_unref0 (this_parameter);
					_vala_code_node_unref0 (base_symbol);
					return result;
				}
				_vala_code_node_unref0 (ma);
			}
			_tmp251_ = vala_member_access_get_inner (self);
			_tmp252_ = _tmp251_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp252_, VALA_TYPE_MEMBER_ACCESS)) {
				_tmp250_ = TRUE;
			} else {
				ValaExpression* _tmp253_;
				ValaExpression* _tmp254_;
				_tmp253_ = vala_member_access_get_inner (self);
				_tmp254_ = _tmp253_;
				_tmp250_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp254_, VALA_TYPE_BASE_ACCESS);
			}
			if (_tmp250_) {
				ValaExpression* _tmp255_;
				ValaExpression* _tmp256_;
				ValaSymbol* _tmp257_;
				ValaSymbol* _tmp258_;
				ValaSymbol* _tmp259_;
				gboolean _tmp260_ = FALSE;
				ValaSymbol* _tmp261_;
				ValaSymbol* _tmp262_;
				_tmp255_ = vala_member_access_get_inner (self);
				_tmp256_ = _tmp255_;
				_tmp257_ = vala_expression_get_symbol_reference (_tmp256_);
				_tmp258_ = _tmp257_;
				_tmp259_ = _vala_code_node_ref0 (_tmp258_);
				_vala_code_node_unref0 (base_symbol);
				base_symbol = _tmp259_;
				_tmp261_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp262_ = _tmp261_;
				if (_tmp262_ == NULL) {
					gboolean _tmp263_ = FALSE;
					ValaSymbol* _tmp264_;
					_tmp264_ = base_symbol;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp264_, VALA_TYPE_NAMESPACE)) {
						_tmp263_ = TRUE;
					} else {
						ValaSymbol* _tmp265_;
						_tmp265_ = base_symbol;
						_tmp263_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp265_, VALA_TYPE_TYPESYMBOL);
					}
					_tmp260_ = _tmp263_;
				} else {
					_tmp260_ = FALSE;
				}
				if (_tmp260_) {
					ValaSymbol* _tmp266_;
					ValaScope* _tmp267_;
					ValaScope* _tmp268_;
					const gchar* _tmp269_;
					ValaSymbol* _tmp270_;
					ValaSymbol* _tmp271_;
					ValaExpression* _tmp272_;
					ValaExpression* _tmp273_;
					_tmp266_ = base_symbol;
					_tmp267_ = vala_symbol_get_scope (_tmp266_);
					_tmp268_ = _tmp267_;
					_tmp269_ = self->priv->_member_name;
					_tmp270_ = vala_scope_lookup (_tmp268_, _tmp269_);
					_tmp271_ = _tmp270_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp271_);
					_vala_code_node_unref0 (_tmp271_);
					_tmp272_ = vala_member_access_get_inner (self);
					_tmp273_ = _tmp272_;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp273_, VALA_TYPE_BASE_ACCESS)) {
						may_access_instance_members = TRUE;
						may_access_klass_members = TRUE;
					}
				}
			}
			_tmp275_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp276_ = _tmp275_;
			if (_tmp276_ == NULL) {
				ValaExpression* _tmp277_;
				ValaExpression* _tmp278_;
				ValaDataType* _tmp279_;
				ValaDataType* _tmp280_;
				_tmp277_ = vala_member_access_get_inner (self);
				_tmp278_ = _tmp277_;
				_tmp279_ = vala_expression_get_value_type (_tmp278_);
				_tmp280_ = _tmp279_;
				_tmp274_ = _tmp280_ != NULL;
			} else {
				_tmp274_ = FALSE;
			}
			if (_tmp274_) {
				gboolean _tmp281_;
				ValaSymbol* _tmp309_;
				ValaSymbol* _tmp310_;
				_tmp281_ = self->priv->_pointer_member_access;
				if (_tmp281_) {
					ValaExpression* _tmp282_;
					ValaExpression* _tmp283_;
					ValaDataType* _tmp284_;
					ValaDataType* _tmp285_;
					const gchar* _tmp286_;
					ValaSymbol* _tmp287_;
					ValaSymbol* _tmp288_;
					_tmp282_ = vala_member_access_get_inner (self);
					_tmp283_ = _tmp282_;
					_tmp284_ = vala_expression_get_value_type (_tmp283_);
					_tmp285_ = _tmp284_;
					_tmp286_ = self->priv->_member_name;
					_tmp287_ = vala_data_type_get_pointer_member (_tmp285_, _tmp286_);
					_tmp288_ = _tmp287_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp288_);
					_vala_code_node_unref0 (_tmp288_);
				} else {
					ValaExpression* _tmp289_;
					ValaExpression* _tmp290_;
					ValaDataType* _tmp291_;
					ValaDataType* _tmp292_;
					ValaTypeSymbol* _tmp293_;
					ValaTypeSymbol* _tmp294_;
					ValaExpression* _tmp302_;
					ValaExpression* _tmp303_;
					ValaDataType* _tmp304_;
					ValaDataType* _tmp305_;
					const gchar* _tmp306_;
					ValaSymbol* _tmp307_;
					ValaSymbol* _tmp308_;
					_tmp289_ = vala_member_access_get_inner (self);
					_tmp290_ = _tmp289_;
					_tmp291_ = vala_expression_get_value_type (_tmp290_);
					_tmp292_ = _tmp291_;
					_tmp293_ = vala_data_type_get_data_type (_tmp292_);
					_tmp294_ = _tmp293_;
					if (_tmp294_ != NULL) {
						ValaExpression* _tmp295_;
						ValaExpression* _tmp296_;
						ValaDataType* _tmp297_;
						ValaDataType* _tmp298_;
						ValaTypeSymbol* _tmp299_;
						ValaTypeSymbol* _tmp300_;
						ValaSymbol* _tmp301_;
						_tmp295_ = vala_member_access_get_inner (self);
						_tmp296_ = _tmp295_;
						_tmp297_ = vala_expression_get_value_type (_tmp296_);
						_tmp298_ = _tmp297_;
						_tmp299_ = vala_data_type_get_data_type (_tmp298_);
						_tmp300_ = _tmp299_;
						_tmp301_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp300_);
						_vala_code_node_unref0 (base_symbol);
						base_symbol = _tmp301_;
					}
					_tmp302_ = vala_member_access_get_inner (self);
					_tmp303_ = _tmp302_;
					_tmp304_ = vala_expression_get_value_type (_tmp303_);
					_tmp305_ = _tmp304_;
					_tmp306_ = self->priv->_member_name;
					_tmp307_ = vala_data_type_get_member (_tmp305_, _tmp306_);
					_tmp308_ = _tmp307_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp308_);
					_vala_code_node_unref0 (_tmp308_);
				}
				_tmp309_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp310_ = _tmp309_;
				if (_tmp310_ != NULL) {
					may_access_instance_members = TRUE;
					may_access_klass_members = TRUE;
				}
			}
			_tmp313_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp314_ = _tmp313_;
			if (_tmp314_ == NULL) {
				ValaExpression* _tmp315_;
				ValaExpression* _tmp316_;
				ValaDataType* _tmp317_;
				ValaDataType* _tmp318_;
				_tmp315_ = vala_member_access_get_inner (self);
				_tmp316_ = _tmp315_;
				_tmp317_ = vala_expression_get_value_type (_tmp316_);
				_tmp318_ = _tmp317_;
				_tmp312_ = _tmp318_ != NULL;
			} else {
				_tmp312_ = FALSE;
			}
			if (_tmp312_) {
				ValaExpression* _tmp319_;
				ValaExpression* _tmp320_;
				ValaDataType* _tmp321_;
				ValaDataType* _tmp322_;
				gboolean _tmp323_;
				gboolean _tmp324_;
				_tmp319_ = vala_member_access_get_inner (self);
				_tmp320_ = _tmp319_;
				_tmp321_ = vala_expression_get_value_type (_tmp320_);
				_tmp322_ = _tmp321_;
				_tmp323_ = vala_data_type_get_is_dynamic (_tmp322_);
				_tmp324_ = _tmp323_;
				_tmp311_ = _tmp324_;
			} else {
				_tmp311_ = FALSE;
			}
			if (_tmp311_) {
				ValaObjectType* dynamic_object_type = NULL;
				ValaExpression* _tmp325_;
				ValaExpression* _tmp326_;
				ValaDataType* _tmp327_;
				ValaDataType* _tmp328_;
				ValaObjectType* _tmp329_;
				ValaCodeNode* _tmp330_;
				ValaCodeNode* _tmp331_;
				ValaSymbol* _tmp508_;
				ValaSymbol* _tmp509_;
				ValaSymbol* _tmp558_;
				ValaSymbol* _tmp559_;
				_tmp325_ = vala_member_access_get_inner (self);
				_tmp326_ = _tmp325_;
				_tmp327_ = vala_expression_get_value_type (_tmp326_);
				_tmp328_ = _tmp327_;
				_tmp329_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp328_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
				dynamic_object_type = _tmp329_;
				_tmp330_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp331_ = _tmp330_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp331_, VALA_TYPE_METHOD_CALL)) {
					ValaMethodCall* invoc = NULL;
					ValaCodeNode* _tmp332_;
					ValaCodeNode* _tmp333_;
					ValaMethodCall* _tmp334_;
					ValaMethodCall* _tmp335_;
					ValaExpression* _tmp336_;
					ValaExpression* _tmp337_;
					_tmp332_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp333_ = _tmp332_;
					_tmp334_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp333_, VALA_TYPE_METHOD_CALL, ValaMethodCall));
					invoc = _tmp334_;
					_tmp335_ = invoc;
					_tmp336_ = vala_method_call_get_call (_tmp335_);
					_tmp337_ = _tmp336_;
					if (_tmp337_ == G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression)) {
						ValaDataType* ret_type = NULL;
						ValaMethodCall* _tmp338_;
						ValaDataType* _tmp339_;
						ValaDataType* _tmp340_;
						ValaDynamicMethod* m = NULL;
						ValaExpression* _tmp355_;
						ValaExpression* _tmp356_;
						ValaDataType* _tmp357_;
						ValaDataType* _tmp358_;
						const gchar* _tmp359_;
						ValaDataType* _tmp360_;
						ValaSourceReference* _tmp361_;
						ValaSourceReference* _tmp362_;
						ValaDynamicMethod* _tmp363_;
						ValaDynamicMethod* _tmp364_;
						ValaMethodCall* _tmp365_;
						ValaErrorType* err = NULL;
						ValaErrorType* _tmp366_;
						ValaErrorType* _tmp367_;
						ValaDynamicMethod* _tmp368_;
						ValaErrorType* _tmp369_;
						ValaDynamicMethod* _tmp370_;
						ValaDynamicMethod* _tmp371_;
						ValaParameter* _tmp372_;
						ValaParameter* _tmp373_;
						ValaObjectType* _tmp374_;
						ValaObjectTypeSymbol* _tmp375_;
						ValaObjectTypeSymbol* _tmp376_;
						ValaScope* _tmp377_;
						ValaScope* _tmp378_;
						ValaDynamicMethod* _tmp379_;
						ValaDynamicMethod* _tmp380_;
						_tmp338_ = invoc;
						_tmp339_ = vala_expression_get_target_type ((ValaExpression*) _tmp338_);
						_tmp340_ = _tmp339_;
						if (_tmp340_ != NULL) {
							ValaMethodCall* _tmp341_;
							ValaDataType* _tmp342_;
							ValaDataType* _tmp343_;
							ValaDataType* _tmp344_;
							ValaDataType* _tmp345_;
							_tmp341_ = invoc;
							_tmp342_ = vala_expression_get_target_type ((ValaExpression*) _tmp341_);
							_tmp343_ = _tmp342_;
							_tmp344_ = vala_data_type_copy (_tmp343_);
							_vala_code_node_unref0 (ret_type);
							ret_type = _tmp344_;
							_tmp345_ = ret_type;
							vala_data_type_set_value_owned (_tmp345_, TRUE);
						} else {
							ValaMethodCall* _tmp346_;
							ValaCodeNode* _tmp347_;
							ValaCodeNode* _tmp348_;
							_tmp346_ = invoc;
							_tmp347_ = vala_code_node_get_parent_node ((ValaCodeNode*) _tmp346_);
							_tmp348_ = _tmp347_;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp348_, VALA_TYPE_EXPRESSION_STATEMENT)) {
								ValaVoidType* _tmp349_;
								_tmp349_ = vala_void_type_new (NULL);
								_vala_code_node_unref0 (ret_type);
								ret_type = (ValaDataType*) _tmp349_;
							} else {
								ValaExpression* _tmp350_;
								ValaExpression* _tmp351_;
								ValaDataType* _tmp352_;
								ValaDataType* _tmp353_;
								ValaDataType* _tmp354_;
								_tmp350_ = vala_member_access_get_inner (self);
								_tmp351_ = _tmp350_;
								_tmp352_ = vala_expression_get_value_type (_tmp351_);
								_tmp353_ = _tmp352_;
								_tmp354_ = vala_data_type_copy (_tmp353_);
								_vala_code_node_unref0 (ret_type);
								ret_type = _tmp354_;
							}
						}
						_tmp355_ = vala_member_access_get_inner (self);
						_tmp356_ = _tmp355_;
						_tmp357_ = vala_expression_get_value_type (_tmp356_);
						_tmp358_ = _tmp357_;
						_tmp359_ = self->priv->_member_name;
						_tmp360_ = ret_type;
						_tmp361_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp362_ = _tmp361_;
						_tmp363_ = vala_dynamic_method_new (_tmp358_, _tmp359_, _tmp360_, _tmp362_, NULL);
						m = _tmp363_;
						_tmp364_ = m;
						_tmp365_ = invoc;
						vala_dynamic_method_set_invocation (_tmp364_, _tmp365_);
						_tmp366_ = vala_error_type_new (NULL, NULL, NULL);
						err = _tmp366_;
						_tmp367_ = err;
						vala_error_type_set_dynamic_error (_tmp367_, TRUE);
						_tmp368_ = m;
						_tmp369_ = err;
						vala_code_node_add_error_type ((ValaCodeNode*) _tmp368_, (ValaDataType*) _tmp369_);
						_tmp370_ = m;
						vala_symbol_set_access ((ValaSymbol*) _tmp370_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
						_tmp371_ = m;
						_tmp372_ = vala_parameter_new_with_ellipsis (NULL);
						_tmp373_ = _tmp372_;
						vala_callable_add_parameter ((ValaCallable*) _tmp371_, _tmp373_);
						_vala_code_node_unref0 (_tmp373_);
						_tmp374_ = dynamic_object_type;
						_tmp375_ = vala_object_type_get_type_symbol (_tmp374_);
						_tmp376_ = _tmp375_;
						_tmp377_ = vala_symbol_get_scope ((ValaSymbol*) _tmp376_);
						_tmp378_ = _tmp377_;
						_tmp379_ = m;
						vala_scope_add (_tmp378_, NULL, (ValaSymbol*) _tmp379_);
						_tmp380_ = m;
						vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp380_);
						_vala_code_node_unref0 (err);
						_vala_code_node_unref0 (m);
						_vala_code_node_unref0 (ret_type);
					}
					_vala_code_node_unref0 (invoc);
				} else {
					ValaCodeNode* _tmp381_;
					ValaCodeNode* _tmp382_;
					_tmp381_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp382_ = _tmp381_;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp382_, VALA_TYPE_ASSIGNMENT)) {
						ValaAssignment* a = NULL;
						ValaCodeNode* _tmp383_;
						ValaCodeNode* _tmp384_;
						ValaAssignment* _tmp385_;
						gboolean _tmp386_ = FALSE;
						ValaAssignment* _tmp387_;
						ValaExpression* _tmp388_;
						ValaExpression* _tmp389_;
						_tmp383_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp384_ = _tmp383_;
						_tmp385_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp384_, VALA_TYPE_ASSIGNMENT, ValaAssignment));
						a = _tmp385_;
						_tmp387_ = a;
						_tmp388_ = vala_assignment_get_left (_tmp387_);
						_tmp389_ = _tmp388_;
						if (_tmp389_ == G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression)) {
							gboolean _tmp390_ = FALSE;
							ValaAssignment* _tmp391_;
							ValaAssignmentOperator _tmp392_;
							ValaAssignmentOperator _tmp393_;
							_tmp391_ = a;
							_tmp392_ = vala_assignment_get_operator (_tmp391_);
							_tmp393_ = _tmp392_;
							if (_tmp393_ == VALA_ASSIGNMENT_OPERATOR_ADD) {
								_tmp390_ = TRUE;
							} else {
								ValaAssignment* _tmp394_;
								ValaAssignmentOperator _tmp395_;
								ValaAssignmentOperator _tmp396_;
								_tmp394_ = a;
								_tmp395_ = vala_assignment_get_operator (_tmp394_);
								_tmp396_ = _tmp395_;
								_tmp390_ = _tmp396_ == VALA_ASSIGNMENT_OPERATOR_SUB;
							}
							_tmp386_ = _tmp390_;
						} else {
							_tmp386_ = FALSE;
						}
						if (_tmp386_) {
							ValaDynamicSignal* s = NULL;
							ValaExpression* _tmp397_;
							ValaExpression* _tmp398_;
							ValaDataType* _tmp399_;
							ValaDataType* _tmp400_;
							const gchar* _tmp401_;
							ValaVoidType* _tmp402_;
							ValaVoidType* _tmp403_;
							ValaSourceReference* _tmp404_;
							ValaSourceReference* _tmp405_;
							ValaDynamicSignal* _tmp406_;
							ValaDynamicSignal* _tmp407_;
							ValaDynamicSignal* _tmp408_;
							ValaAssignment* _tmp409_;
							ValaExpression* _tmp410_;
							ValaExpression* _tmp411_;
							ValaDynamicSignal* _tmp412_;
							ValaObjectType* _tmp413_;
							ValaObjectTypeSymbol* _tmp414_;
							ValaObjectTypeSymbol* _tmp415_;
							ValaScope* _tmp416_;
							ValaScope* _tmp417_;
							ValaDynamicSignal* _tmp418_;
							ValaDynamicSignal* _tmp419_;
							_tmp397_ = vala_member_access_get_inner (self);
							_tmp398_ = _tmp397_;
							_tmp399_ = vala_expression_get_value_type (_tmp398_);
							_tmp400_ = _tmp399_;
							_tmp401_ = self->priv->_member_name;
							_tmp402_ = vala_void_type_new (NULL);
							_tmp403_ = _tmp402_;
							_tmp404_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp405_ = _tmp404_;
							_tmp406_ = vala_dynamic_signal_new (_tmp400_, _tmp401_, (ValaDataType*) _tmp403_, _tmp405_, NULL);
							_tmp407_ = _tmp406_;
							_vala_code_node_unref0 (_tmp403_);
							s = _tmp407_;
							_tmp408_ = s;
							_tmp409_ = a;
							_tmp410_ = vala_assignment_get_right (_tmp409_);
							_tmp411_ = _tmp410_;
							vala_dynamic_signal_set_handler (_tmp408_, _tmp411_);
							_tmp412_ = s;
							vala_symbol_set_access ((ValaSymbol*) _tmp412_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
							_tmp413_ = dynamic_object_type;
							_tmp414_ = vala_object_type_get_type_symbol (_tmp413_);
							_tmp415_ = _tmp414_;
							_tmp416_ = vala_symbol_get_scope ((ValaSymbol*) _tmp415_);
							_tmp417_ = _tmp416_;
							_tmp418_ = s;
							vala_scope_add (_tmp417_, NULL, (ValaSymbol*) _tmp418_);
							_tmp419_ = s;
							vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp419_);
							_vala_code_node_unref0 (s);
						} else {
							ValaAssignment* _tmp420_;
							ValaExpression* _tmp421_;
							ValaExpression* _tmp422_;
							_tmp420_ = a;
							_tmp421_ = vala_assignment_get_left (_tmp420_);
							_tmp422_ = _tmp421_;
							if (_tmp422_ == G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression)) {
								ValaDynamicProperty* prop = NULL;
								ValaExpression* _tmp423_;
								ValaExpression* _tmp424_;
								ValaDataType* _tmp425_;
								ValaDataType* _tmp426_;
								const gchar* _tmp427_;
								ValaSourceReference* _tmp428_;
								ValaSourceReference* _tmp429_;
								ValaDynamicProperty* _tmp430_;
								ValaDynamicProperty* _tmp431_;
								ValaDynamicProperty* _tmp432_;
								ValaDynamicProperty* _tmp433_;
								ValaSourceReference* _tmp434_;
								ValaSourceReference* _tmp435_;
								ValaPropertyAccessor* _tmp436_;
								ValaPropertyAccessor* _tmp437_;
								ValaDynamicProperty* _tmp438_;
								ValaExpression* _tmp439_;
								ValaExpression* _tmp440_;
								ValaDataType* _tmp441_;
								ValaDataType* _tmp442_;
								ValaTypeSymbol* _tmp443_;
								ValaTypeSymbol* _tmp444_;
								ValaScope* _tmp445_;
								ValaScope* _tmp446_;
								ValaObjectType* _tmp447_;
								ValaObjectTypeSymbol* _tmp448_;
								ValaObjectTypeSymbol* _tmp449_;
								ValaScope* _tmp450_;
								ValaScope* _tmp451_;
								ValaDynamicProperty* _tmp452_;
								ValaDynamicProperty* _tmp453_;
								_tmp423_ = vala_member_access_get_inner (self);
								_tmp424_ = _tmp423_;
								_tmp425_ = vala_expression_get_value_type (_tmp424_);
								_tmp426_ = _tmp425_;
								_tmp427_ = self->priv->_member_name;
								_tmp428_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp429_ = _tmp428_;
								_tmp430_ = vala_dynamic_property_new (_tmp426_, _tmp427_, _tmp429_, NULL);
								prop = _tmp430_;
								_tmp431_ = prop;
								vala_symbol_set_access ((ValaSymbol*) _tmp431_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
								_tmp432_ = prop;
								_tmp433_ = prop;
								_tmp434_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp433_);
								_tmp435_ = _tmp434_;
								_tmp436_ = vala_property_accessor_new (FALSE, TRUE, FALSE, NULL, NULL, _tmp435_, NULL);
								_tmp437_ = _tmp436_;
								vala_property_set_set_accessor ((ValaProperty*) _tmp432_, _tmp437_);
								_vala_code_node_unref0 (_tmp437_);
								_tmp438_ = prop;
								_tmp439_ = vala_member_access_get_inner (self);
								_tmp440_ = _tmp439_;
								_tmp441_ = vala_expression_get_value_type (_tmp440_);
								_tmp442_ = _tmp441_;
								_tmp443_ = vala_data_type_get_data_type (_tmp442_);
								_tmp444_ = _tmp443_;
								_tmp445_ = vala_symbol_get_scope ((ValaSymbol*) _tmp444_);
								_tmp446_ = _tmp445_;
								vala_symbol_set_owner ((ValaSymbol*) _tmp438_, _tmp446_);
								_tmp447_ = dynamic_object_type;
								_tmp448_ = vala_object_type_get_type_symbol (_tmp447_);
								_tmp449_ = _tmp448_;
								_tmp450_ = vala_symbol_get_scope ((ValaSymbol*) _tmp449_);
								_tmp451_ = _tmp450_;
								_tmp452_ = prop;
								vala_scope_add (_tmp451_, NULL, (ValaSymbol*) _tmp452_);
								_tmp453_ = prop;
								vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp453_);
								_vala_code_node_unref0 (prop);
							}
						}
						_vala_code_node_unref0 (a);
					} else {
						gboolean _tmp454_ = FALSE;
						gboolean _tmp455_ = FALSE;
						ValaCodeNode* _tmp456_;
						ValaCodeNode* _tmp457_;
						_tmp456_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp457_ = _tmp456_;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp457_, VALA_TYPE_MEMBER_ACCESS)) {
							ValaExpression* _tmp458_;
							ValaExpression* _tmp459_;
							_tmp458_ = vala_member_access_get_inner (self);
							_tmp459_ = _tmp458_;
							_tmp455_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp459_, VALA_TYPE_MEMBER_ACCESS);
						} else {
							_tmp455_ = FALSE;
						}
						if (_tmp455_) {
							ValaCodeNode* _tmp460_;
							ValaCodeNode* _tmp461_;
							ValaCodeNode* _tmp462_;
							ValaCodeNode* _tmp463_;
							_tmp460_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp461_ = _tmp460_;
							_tmp462_ = vala_code_node_get_parent_node (_tmp461_);
							_tmp463_ = _tmp462_;
							_tmp454_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp463_, VALA_TYPE_METHOD_CALL);
						} else {
							_tmp454_ = FALSE;
						}
						if (_tmp454_) {
							ValaMemberAccess* ma = NULL;
							ValaCodeNode* _tmp464_;
							ValaCodeNode* _tmp465_;
							ValaMemberAccess* _tmp466_;
							gboolean _tmp467_ = FALSE;
							ValaMemberAccess* _tmp468_;
							const gchar* _tmp469_;
							_tmp464_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp465_ = _tmp464_;
							_tmp466_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp465_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
							ma = _tmp466_;
							_tmp468_ = ma;
							_tmp469_ = _tmp468_->priv->_member_name;
							if (g_strcmp0 (_tmp469_, "connect") == 0) {
								_tmp467_ = TRUE;
							} else {
								ValaMemberAccess* _tmp470_;
								const gchar* _tmp471_;
								_tmp470_ = ma;
								_tmp471_ = _tmp470_->priv->_member_name;
								_tmp467_ = g_strcmp0 (_tmp471_, "connect_after") == 0;
							}
							if (_tmp467_) {
								ValaDynamicSignal* s = NULL;
								ValaExpression* _tmp472_;
								ValaExpression* _tmp473_;
								ValaDataType* _tmp474_;
								ValaDataType* _tmp475_;
								const gchar* _tmp476_;
								ValaVoidType* _tmp477_;
								ValaVoidType* _tmp478_;
								ValaSourceReference* _tmp479_;
								ValaSourceReference* _tmp480_;
								ValaDynamicSignal* _tmp481_;
								ValaDynamicSignal* _tmp482_;
								ValaMethodCall* mcall = NULL;
								ValaCodeNode* _tmp483_;
								ValaCodeNode* _tmp484_;
								ValaCodeNode* _tmp485_;
								ValaCodeNode* _tmp486_;
								ValaMethodCall* _tmp487_;
								ValaMethodCall* _tmp488_;
								ValaList* _tmp489_;
								ValaList* _tmp490_;
								gint _tmp491_;
								gint _tmp492_;
								gboolean _tmp493_;
								ValaDynamicSignal* _tmp500_;
								ValaObjectType* _tmp501_;
								ValaObjectTypeSymbol* _tmp502_;
								ValaObjectTypeSymbol* _tmp503_;
								ValaScope* _tmp504_;
								ValaScope* _tmp505_;
								ValaDynamicSignal* _tmp506_;
								ValaDynamicSignal* _tmp507_;
								_tmp472_ = vala_member_access_get_inner (self);
								_tmp473_ = _tmp472_;
								_tmp474_ = vala_expression_get_value_type (_tmp473_);
								_tmp475_ = _tmp474_;
								_tmp476_ = self->priv->_member_name;
								_tmp477_ = vala_void_type_new (NULL);
								_tmp478_ = _tmp477_;
								_tmp479_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp480_ = _tmp479_;
								_tmp481_ = vala_dynamic_signal_new (_tmp475_, _tmp476_, (ValaDataType*) _tmp478_, _tmp480_, NULL);
								_tmp482_ = _tmp481_;
								_vala_code_node_unref0 (_tmp478_);
								s = _tmp482_;
								_tmp483_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
								_tmp484_ = _tmp483_;
								_tmp485_ = vala_code_node_get_parent_node (_tmp484_);
								_tmp486_ = _tmp485_;
								_tmp487_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp486_, VALA_TYPE_METHOD_CALL, ValaMethodCall));
								mcall = _tmp487_;
								_tmp488_ = mcall;
								_tmp489_ = vala_method_call_get_argument_list (_tmp488_);
								_tmp490_ = _tmp489_;
								_tmp491_ = vala_collection_get_size ((ValaCollection*) _tmp490_);
								_tmp492_ = _tmp491_;
								_tmp493_ = _tmp492_ > 0;
								_vala_iterable_unref0 (_tmp490_);
								if (_tmp493_) {
									ValaDynamicSignal* _tmp494_;
									ValaMethodCall* _tmp495_;
									ValaList* _tmp496_;
									ValaList* _tmp497_;
									gpointer _tmp498_;
									ValaExpression* _tmp499_;
									_tmp494_ = s;
									_tmp495_ = mcall;
									_tmp496_ = vala_method_call_get_argument_list (_tmp495_);
									_tmp497_ = _tmp496_;
									_tmp498_ = vala_list_get (_tmp497_, 0);
									_tmp499_ = (ValaExpression*) _tmp498_;
									vala_dynamic_signal_set_handler (_tmp494_, _tmp499_);
									_vala_code_node_unref0 (_tmp499_);
									_vala_iterable_unref0 (_tmp497_);
								}
								_tmp500_ = s;
								vala_symbol_set_access ((ValaSymbol*) _tmp500_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
								_tmp501_ = dynamic_object_type;
								_tmp502_ = vala_object_type_get_type_symbol (_tmp501_);
								_tmp503_ = _tmp502_;
								_tmp504_ = vala_symbol_get_scope ((ValaSymbol*) _tmp503_);
								_tmp505_ = _tmp504_;
								_tmp506_ = s;
								vala_scope_add (_tmp505_, NULL, (ValaSymbol*) _tmp506_);
								_tmp507_ = s;
								vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp507_);
								_vala_code_node_unref0 (mcall);
								_vala_code_node_unref0 (s);
							}
							_vala_code_node_unref0 (ma);
						}
					}
				}
				_tmp508_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp509_ = _tmp508_;
				if (_tmp509_ == NULL) {
					ValaDynamicProperty* prop = NULL;
					ValaExpression* _tmp510_;
					ValaExpression* _tmp511_;
					ValaDataType* _tmp512_;
					ValaDataType* _tmp513_;
					const gchar* _tmp514_;
					ValaSourceReference* _tmp515_;
					ValaSourceReference* _tmp516_;
					ValaDynamicProperty* _tmp517_;
					ValaDataType* _tmp518_;
					ValaDataType* _tmp519_;
					ValaDynamicProperty* _tmp530_;
					ValaDynamicProperty* _tmp531_;
					ValaDynamicProperty* _tmp532_;
					ValaDataType* _tmp533_;
					ValaDataType* _tmp534_;
					ValaDataType* _tmp535_;
					ValaDataType* _tmp536_;
					ValaDynamicProperty* _tmp537_;
					ValaSourceReference* _tmp538_;
					ValaSourceReference* _tmp539_;
					ValaPropertyAccessor* _tmp540_;
					ValaPropertyAccessor* _tmp541_;
					ValaDynamicProperty* _tmp542_;
					ValaExpression* _tmp543_;
					ValaExpression* _tmp544_;
					ValaDataType* _tmp545_;
					ValaDataType* _tmp546_;
					ValaTypeSymbol* _tmp547_;
					ValaTypeSymbol* _tmp548_;
					ValaScope* _tmp549_;
					ValaScope* _tmp550_;
					ValaObjectType* _tmp551_;
					ValaObjectTypeSymbol* _tmp552_;
					ValaObjectTypeSymbol* _tmp553_;
					ValaScope* _tmp554_;
					ValaScope* _tmp555_;
					ValaDynamicProperty* _tmp556_;
					ValaDynamicProperty* _tmp557_;
					_tmp510_ = vala_member_access_get_inner (self);
					_tmp511_ = _tmp510_;
					_tmp512_ = vala_expression_get_value_type (_tmp511_);
					_tmp513_ = _tmp512_;
					_tmp514_ = self->priv->_member_name;
					_tmp515_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp516_ = _tmp515_;
					_tmp517_ = vala_dynamic_property_new (_tmp513_, _tmp514_, _tmp516_, NULL);
					prop = _tmp517_;
					_tmp518_ = vala_expression_get_target_type ((ValaExpression*) self);
					_tmp519_ = _tmp518_;
					if (_tmp519_ != NULL) {
						ValaDynamicProperty* _tmp520_;
						ValaDataType* _tmp521_;
						ValaDataType* _tmp522_;
						_tmp520_ = prop;
						_tmp521_ = vala_expression_get_target_type ((ValaExpression*) self);
						_tmp522_ = _tmp521_;
						vala_property_set_property_type ((ValaProperty*) _tmp520_, _tmp522_);
					} else {
						ValaDynamicProperty* _tmp523_;
						ValaExpression* _tmp524_;
						ValaExpression* _tmp525_;
						ValaDataType* _tmp526_;
						ValaDataType* _tmp527_;
						ValaDataType* _tmp528_;
						ValaDataType* _tmp529_;
						_tmp523_ = prop;
						_tmp524_ = vala_member_access_get_inner (self);
						_tmp525_ = _tmp524_;
						_tmp526_ = vala_expression_get_value_type (_tmp525_);
						_tmp527_ = _tmp526_;
						_tmp528_ = vala_data_type_copy (_tmp527_);
						_tmp529_ = _tmp528_;
						vala_property_set_property_type ((ValaProperty*) _tmp523_, _tmp529_);
						_vala_code_node_unref0 (_tmp529_);
					}
					_tmp530_ = prop;
					vala_symbol_set_access ((ValaSymbol*) _tmp530_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
					_tmp531_ = prop;
					_tmp532_ = prop;
					_tmp533_ = vala_property_get_property_type ((ValaProperty*) _tmp532_);
					_tmp534_ = _tmp533_;
					_tmp535_ = vala_data_type_copy (_tmp534_);
					_tmp536_ = _tmp535_;
					_tmp537_ = prop;
					_tmp538_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp537_);
					_tmp539_ = _tmp538_;
					_tmp540_ = vala_property_accessor_new (TRUE, FALSE, FALSE, _tmp536_, NULL, _tmp539_, NULL);
					_tmp541_ = _tmp540_;
					vala_property_set_get_accessor ((ValaProperty*) _tmp531_, _tmp541_);
					_vala_code_node_unref0 (_tmp541_);
					_vala_code_node_unref0 (_tmp536_);
					_tmp542_ = prop;
					_tmp543_ = vala_member_access_get_inner (self);
					_tmp544_ = _tmp543_;
					_tmp545_ = vala_expression_get_value_type (_tmp544_);
					_tmp546_ = _tmp545_;
					_tmp547_ = vala_data_type_get_data_type (_tmp546_);
					_tmp548_ = _tmp547_;
					_tmp549_ = vala_symbol_get_scope ((ValaSymbol*) _tmp548_);
					_tmp550_ = _tmp549_;
					vala_symbol_set_owner ((ValaSymbol*) _tmp542_, _tmp550_);
					_tmp551_ = dynamic_object_type;
					_tmp552_ = vala_object_type_get_type_symbol (_tmp551_);
					_tmp553_ = _tmp552_;
					_tmp554_ = vala_symbol_get_scope ((ValaSymbol*) _tmp553_);
					_tmp555_ = _tmp554_;
					_tmp556_ = prop;
					vala_scope_add (_tmp555_, NULL, (ValaSymbol*) _tmp556_);
					_tmp557_ = prop;
					vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp557_);
					_vala_code_node_unref0 (prop);
				}
				_tmp558_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp559_ = _tmp558_;
				if (_tmp559_ != NULL) {
					may_access_instance_members = TRUE;
					may_access_klass_members = TRUE;
				}
				_vala_code_node_unref0 (dynamic_object_type);
			}
		}
	}
	_tmp562_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp563_ = _tmp562_;
	if (_tmp563_ == NULL) {
		ValaDataType* _tmp564_;
		ValaDataType* _tmp565_;
		_tmp564_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp565_ = _tmp564_;
		_tmp561_ = _tmp565_ != NULL;
	} else {
		_tmp561_ = FALSE;
	}
	if (_tmp561_) {
		ValaDataType* _tmp566_;
		ValaDataType* _tmp567_;
		ValaTypeSymbol* _tmp568_;
		ValaTypeSymbol* _tmp569_;
		_tmp566_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp567_ = _tmp566_;
		_tmp568_ = vala_data_type_get_data_type (_tmp567_);
		_tmp569_ = _tmp568_;
		_tmp560_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp569_, VALA_TYPE_ENUM);
	} else {
		_tmp560_ = FALSE;
	}
	if (_tmp560_) {
		ValaEnum* enum_type = NULL;
		ValaDataType* _tmp570_;
		ValaDataType* _tmp571_;
		ValaTypeSymbol* _tmp572_;
		ValaTypeSymbol* _tmp573_;
		ValaEnum* _tmp574_;
		_tmp570_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp571_ = _tmp570_;
		_tmp572_ = vala_data_type_get_data_type (_tmp571_);
		_tmp573_ = _tmp572_;
		_tmp574_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp573_, VALA_TYPE_ENUM, ValaEnum));
		enum_type = _tmp574_;
		{
			ValaList* _val_list = NULL;
			ValaEnum* _tmp575_;
			ValaList* _tmp576_;
			gint _val_size = 0;
			ValaList* _tmp577_;
			gint _tmp578_;
			gint _tmp579_;
			gint _val_index = 0;
			_tmp575_ = enum_type;
			_tmp576_ = vala_enum_get_values (_tmp575_);
			_val_list = _tmp576_;
			_tmp577_ = _val_list;
			_tmp578_ = vala_collection_get_size ((ValaCollection*) _tmp577_);
			_tmp579_ = _tmp578_;
			_val_size = _tmp579_;
			_val_index = -1;
			while (TRUE) {
				gint _tmp580_;
				gint _tmp581_;
				gint _tmp582_;
				ValaEnumValue* val = NULL;
				ValaList* _tmp583_;
				gint _tmp584_;
				gpointer _tmp585_;
				const gchar* _tmp586_;
				ValaEnumValue* _tmp587_;
				const gchar* _tmp588_;
				const gchar* _tmp589_;
				_tmp580_ = _val_index;
				_val_index = _tmp580_ + 1;
				_tmp581_ = _val_index;
				_tmp582_ = _val_size;
				if (!(_tmp581_ < _tmp582_)) {
					break;
				}
				_tmp583_ = _val_list;
				_tmp584_ = _val_index;
				_tmp585_ = vala_list_get (_tmp583_, _tmp584_);
				val = (ValaEnumValue*) _tmp585_;
				_tmp586_ = self->priv->_member_name;
				_tmp587_ = val;
				_tmp588_ = vala_symbol_get_name ((ValaSymbol*) _tmp587_);
				_tmp589_ = _tmp588_;
				if (g_strcmp0 (_tmp586_, _tmp589_) == 0) {
					ValaEnumValue* _tmp590_;
					_tmp590_ = val;
					vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp590_);
					_vala_code_node_unref0 (val);
					break;
				}
				_vala_code_node_unref0 (val);
			}
			_vala_iterable_unref0 (_val_list);
		}
		_vala_code_node_unref0 (enum_type);
	}
	_tmp591_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp592_ = _tmp591_;
	if (_tmp592_ == NULL) {
		gchar* base_type_name = NULL;
		gchar* _tmp593_;
		gboolean _tmp594_ = FALSE;
		ValaExpression* _tmp595_;
		ValaExpression* _tmp596_;
		ValaSourceReference* _tmp609_;
		ValaSourceReference* _tmp610_;
		const gchar* _tmp611_;
		const gchar* _tmp612_;
		gchar* _tmp613_;
		gchar* _tmp614_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp593_ = g_strdup ("(null)");
		base_type_name = _tmp593_;
		_tmp595_ = vala_member_access_get_inner (self);
		_tmp596_ = _tmp595_;
		if (_tmp596_ != NULL) {
			ValaExpression* _tmp597_;
			ValaExpression* _tmp598_;
			ValaDataType* _tmp599_;
			ValaDataType* _tmp600_;
			_tmp597_ = vala_member_access_get_inner (self);
			_tmp598_ = _tmp597_;
			_tmp599_ = vala_expression_get_value_type (_tmp598_);
			_tmp600_ = _tmp599_;
			_tmp594_ = _tmp600_ != NULL;
		} else {
			_tmp594_ = FALSE;
		}
		if (_tmp594_) {
			ValaExpression* _tmp601_;
			ValaExpression* _tmp602_;
			ValaDataType* _tmp603_;
			ValaDataType* _tmp604_;
			gchar* _tmp605_;
			_tmp601_ = vala_member_access_get_inner (self);
			_tmp602_ = _tmp601_;
			_tmp603_ = vala_expression_get_value_type (_tmp602_);
			_tmp604_ = _tmp603_;
			_tmp605_ = vala_code_node_to_string ((ValaCodeNode*) _tmp604_);
			_g_free0 (base_type_name);
			base_type_name = _tmp605_;
		} else {
			ValaSymbol* _tmp606_;
			_tmp606_ = base_symbol;
			if (_tmp606_ != NULL) {
				ValaSymbol* _tmp607_;
				gchar* _tmp608_;
				_tmp607_ = base_symbol;
				_tmp608_ = vala_symbol_get_full_name (_tmp607_);
				_g_free0 (base_type_name);
				base_type_name = _tmp608_;
			}
		}
		_tmp609_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp610_ = _tmp609_;
		_tmp611_ = self->priv->_member_name;
		_tmp612_ = base_type_name;
		_tmp613_ = g_strdup_printf ("The name `%s' does not exist in the context of `%s'", _tmp611_, _tmp612_);
		_tmp614_ = _tmp613_;
		vala_report_error (_tmp610_, _tmp614_);
		_g_free0 (_tmp614_);
		result = FALSE;
		_g_free0 (base_type_name);
		_vala_code_node_unref0 (this_parameter);
		_vala_code_node_unref0 (base_symbol);
		return result;
	}
	_tmp615_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp616_ = _tmp615_;
	_tmp617_ = _vala_code_node_ref0 (_tmp616_);
	member = _tmp617_;
	access = VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
	instance = FALSE;
	klass = FALSE;
	generics = FALSE;
	_tmp618_ = member;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp618_, context)) {
		result = FALSE;
		_vala_code_node_unref0 (member);
		_vala_code_node_unref0 (this_parameter);
		_vala_code_node_unref0 (base_symbol);
		return result;
	}
	_tmp619_ = member;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp619_, VALA_TYPE_LOCAL_VARIABLE)) {
		ValaLocalVariable* local = NULL;
		ValaSymbol* _tmp620_;
		ValaLocalVariable* _tmp621_;
		ValaBlock* block = NULL;
		ValaLocalVariable* _tmp622_;
		ValaSymbol* _tmp623_;
		ValaSymbol* _tmp624_;
		ValaBlock* _tmp625_;
		gboolean _tmp626_ = FALSE;
		ValaBlock* _tmp627_;
		_tmp620_ = member;
		_tmp621_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp620_, VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable));
		local = _tmp621_;
		_tmp622_ = local;
		_tmp623_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp622_);
		_tmp624_ = _tmp623_;
		_tmp625_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp624_, VALA_TYPE_BLOCK) ? ((ValaBlock*) _tmp624_) : NULL);
		block = _tmp625_;
		_tmp627_ = block;
		if (_tmp627_ != NULL) {
			ValaSemanticAnalyzer* _tmp628_;
			ValaSemanticAnalyzer* _tmp629_;
			ValaBlock* _tmp630_;
			ValaSymbol* _tmp631_;
			ValaSymbol* _tmp632_;
			ValaSemanticAnalyzer* _tmp633_;
			ValaSemanticAnalyzer* _tmp634_;
			ValaSymbol* _tmp635_;
			ValaSymbol* _tmp636_;
			_tmp628_ = vala_code_context_get_analyzer (context);
			_tmp629_ = _tmp628_;
			_tmp630_ = block;
			_tmp631_ = vala_semantic_analyzer_find_parent_method_or_property_accessor (_tmp629_, (ValaSymbol*) _tmp630_);
			_tmp632_ = _tmp631_;
			_tmp633_ = vala_code_context_get_analyzer (context);
			_tmp634_ = _tmp633_;
			_tmp635_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp634_);
			_tmp636_ = _tmp635_;
			_tmp626_ = _tmp632_ != _tmp636_;
			_vala_code_node_unref0 (_tmp632_);
		} else {
			_tmp626_ = FALSE;
		}
		if (_tmp626_) {
			ValaSymbol* sym = NULL;
			ValaSemanticAnalyzer* _tmp637_;
			ValaSemanticAnalyzer* _tmp638_;
			ValaSymbol* _tmp639_;
			ValaSymbol* _tmp640_;
			ValaSymbol* _tmp641_;
			ValaLocalVariable* _tmp654_;
			ValaBlock* _tmp655_;
			_tmp637_ = vala_code_context_get_analyzer (context);
			_tmp638_ = _tmp637_;
			_tmp639_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp638_);
			_tmp640_ = _tmp639_;
			_tmp641_ = _vala_code_node_ref0 (_tmp640_);
			sym = _tmp641_;
			while (TRUE) {
				ValaSymbol* _tmp642_;
				ValaBlock* _tmp643_;
				ValaMethod* method = NULL;
				ValaSymbol* _tmp644_;
				ValaMethod* _tmp645_;
				ValaMethod* _tmp646_;
				ValaSymbol* _tmp650_;
				ValaSymbol* _tmp651_;
				ValaSymbol* _tmp652_;
				ValaSymbol* _tmp653_;
				_tmp642_ = sym;
				_tmp643_ = block;
				if (!(_tmp642_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp643_, VALA_TYPE_SYMBOL, ValaSymbol))) {
					break;
				}
				_tmp644_ = sym;
				_tmp645_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp644_, VALA_TYPE_METHOD) ? ((ValaMethod*) _tmp644_) : NULL);
				method = _tmp645_;
				_tmp646_ = method;
				if (_tmp646_ != NULL) {
					ValaMethod* _tmp647_;
					ValaMethod* _tmp648_;
					ValaLocalVariable* _tmp649_;
					_tmp647_ = method;
					vala_method_set_closure (_tmp647_, TRUE);
					_tmp648_ = method;
					_tmp649_ = local;
					vala_method_add_captured_variable (_tmp648_, _tmp649_);
				}
				_tmp650_ = sym;
				_tmp651_ = vala_symbol_get_parent_symbol (_tmp650_);
				_tmp652_ = _tmp651_;
				_tmp653_ = _vala_code_node_ref0 (_tmp652_);
				_vala_code_node_unref0 (sym);
				sym = _tmp653_;
				_vala_code_node_unref0 (method);
			}
			_tmp654_ = local;
			vala_local_variable_set_captured (_tmp654_, TRUE);
			_tmp655_ = block;
			vala_block_set_captured (_tmp655_, TRUE);
			_vala_code_node_unref0 (sym);
		}
		_vala_code_node_unref0 (block);
		_vala_code_node_unref0 (local);
	} else {
		ValaSymbol* _tmp656_;
		_tmp656_ = member;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp656_, VALA_TYPE_PARAMETER)) {
			ValaParameter* param = NULL;
			ValaSymbol* _tmp657_;
			ValaParameter* _tmp658_;
			ValaMethod* m = NULL;
			ValaParameter* _tmp659_;
			ValaSymbol* _tmp660_;
			ValaSymbol* _tmp661_;
			ValaMethod* _tmp662_;
			gboolean _tmp663_ = FALSE;
			gboolean _tmp664_ = FALSE;
			ValaMethod* _tmp665_;
			_tmp657_ = member;
			_tmp658_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp657_, VALA_TYPE_PARAMETER, ValaParameter));
			param = _tmp658_;
			_tmp659_ = param;
			_tmp660_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp659_);
			_tmp661_ = _tmp660_;
			_tmp662_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp661_, VALA_TYPE_METHOD) ? ((ValaMethod*) _tmp661_) : NULL);
			m = _tmp662_;
			_tmp665_ = m;
			if (_tmp665_ != NULL) {
				ValaMethod* _tmp666_;
				ValaSemanticAnalyzer* _tmp667_;
				ValaSemanticAnalyzer* _tmp668_;
				ValaSymbol* _tmp669_;
				ValaSymbol* _tmp670_;
				_tmp666_ = m;
				_tmp667_ = vala_code_context_get_analyzer (context);
				_tmp668_ = _tmp667_;
				_tmp669_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp668_);
				_tmp670_ = _tmp669_;
				_tmp664_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp666_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp670_;
			} else {
				_tmp664_ = FALSE;
			}
			if (_tmp664_) {
				ValaParameter* _tmp671_;
				ValaMethod* _tmp672_;
				ValaParameter* _tmp673_;
				ValaParameter* _tmp674_;
				_tmp671_ = param;
				_tmp672_ = m;
				_tmp673_ = vala_method_get_this_parameter (_tmp672_);
				_tmp674_ = _tmp673_;
				_tmp663_ = _tmp671_ != _tmp674_;
			} else {
				_tmp663_ = FALSE;
			}
			if (_tmp663_) {
				ValaSymbol* sym = NULL;
				ValaSemanticAnalyzer* _tmp675_;
				ValaSemanticAnalyzer* _tmp676_;
				ValaSymbol* _tmp677_;
				ValaSymbol* _tmp678_;
				ValaSymbol* _tmp679_;
				ValaParameter* _tmp690_;
				ValaMethod* _tmp691_;
				ValaBlock* _tmp692_;
				ValaBlock* _tmp693_;
				ValaParameter* _tmp694_;
				ValaParameterDirection _tmp695_;
				ValaParameterDirection _tmp696_;
				_tmp675_ = vala_code_context_get_analyzer (context);
				_tmp676_ = _tmp675_;
				_tmp677_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp676_);
				_tmp678_ = _tmp677_;
				_tmp679_ = _vala_code_node_ref0 (_tmp678_);
				sym = _tmp679_;
				while (TRUE) {
					ValaSymbol* _tmp680_;
					ValaMethod* _tmp681_;
					ValaMethod* method = NULL;
					ValaSymbol* _tmp682_;
					ValaMethod* _tmp683_;
					ValaMethod* _tmp684_;
					ValaSymbol* _tmp686_;
					ValaSymbol* _tmp687_;
					ValaSymbol* _tmp688_;
					ValaSymbol* _tmp689_;
					_tmp680_ = sym;
					_tmp681_ = m;
					if (!(_tmp680_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp681_, VALA_TYPE_SYMBOL, ValaSymbol))) {
						break;
					}
					_tmp682_ = sym;
					_tmp683_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp682_, VALA_TYPE_METHOD) ? ((ValaMethod*) _tmp682_) : NULL);
					method = _tmp683_;
					_tmp684_ = method;
					if (_tmp684_ != NULL) {
						ValaMethod* _tmp685_;
						_tmp685_ = method;
						vala_method_set_closure (_tmp685_, TRUE);
					}
					_tmp686_ = sym;
					_tmp687_ = vala_symbol_get_parent_symbol (_tmp686_);
					_tmp688_ = _tmp687_;
					_tmp689_ = _vala_code_node_ref0 (_tmp688_);
					_vala_code_node_unref0 (sym);
					sym = _tmp689_;
					_vala_code_node_unref0 (method);
				}
				_tmp690_ = param;
				vala_parameter_set_captured (_tmp690_, TRUE);
				_tmp691_ = m;
				_tmp692_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp691_);
				_tmp693_ = _tmp692_;
				vala_block_set_captured (_tmp693_, TRUE);
				_tmp694_ = param;
				_tmp695_ = vala_parameter_get_direction (_tmp694_);
				_tmp696_ = _tmp695_;
				if (_tmp696_ != VALA_PARAMETER_DIRECTION_IN) {
					ValaSourceReference* _tmp697_;
					ValaSourceReference* _tmp698_;
					ValaParameter* _tmp699_;
					gchar* _tmp700_;
					gchar* _tmp701_;
					gchar* _tmp702_;
					gchar* _tmp703_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp697_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp698_ = _tmp697_;
					_tmp699_ = param;
					_tmp700_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp699_);
					_tmp701_ = _tmp700_;
					_tmp702_ = g_strdup_printf ("Cannot capture reference or output parameter `%s'", _tmp701_);
					_tmp703_ = _tmp702_;
					vala_report_error (_tmp698_, _tmp703_);
					_g_free0 (_tmp703_);
					_g_free0 (_tmp701_);
				}
				_vala_code_node_unref0 (sym);
			} else {
				ValaPropertyAccessor* acc = NULL;
				ValaParameter* _tmp704_;
				ValaSymbol* _tmp705_;
				ValaSymbol* _tmp706_;
				ValaSymbol* _tmp707_;
				ValaSymbol* _tmp708_;
				ValaPropertyAccessor* _tmp709_;
				gboolean _tmp710_ = FALSE;
				gboolean _tmp711_ = FALSE;
				ValaPropertyAccessor* _tmp712_;
				_tmp704_ = param;
				_tmp705_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp704_);
				_tmp706_ = _tmp705_;
				_tmp707_ = vala_symbol_get_parent_symbol (_tmp706_);
				_tmp708_ = _tmp707_;
				_tmp709_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp708_, VALA_TYPE_PROPERTY_ACCESSOR) ? ((ValaPropertyAccessor*) _tmp708_) : NULL);
				acc = _tmp709_;
				_tmp712_ = acc;
				if (_tmp712_ != NULL) {
					ValaPropertyAccessor* _tmp713_;
					ValaSemanticAnalyzer* _tmp714_;
					ValaSemanticAnalyzer* _tmp715_;
					ValaSymbol* _tmp716_;
					ValaSymbol* _tmp717_;
					_tmp713_ = acc;
					_tmp714_ = vala_code_context_get_analyzer (context);
					_tmp715_ = _tmp714_;
					_tmp716_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp715_);
					_tmp717_ = _tmp716_;
					_tmp711_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp713_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp717_;
				} else {
					_tmp711_ = FALSE;
				}
				if (_tmp711_) {
					ValaParameter* _tmp718_;
					ValaPropertyAccessor* _tmp719_;
					ValaProperty* _tmp720_;
					ValaProperty* _tmp721_;
					ValaParameter* _tmp722_;
					ValaParameter* _tmp723_;
					_tmp718_ = param;
					_tmp719_ = acc;
					_tmp720_ = vala_property_accessor_get_prop (_tmp719_);
					_tmp721_ = _tmp720_;
					_tmp722_ = vala_property_get_this_parameter (_tmp721_);
					_tmp723_ = _tmp722_;
					_tmp710_ = _tmp718_ != _tmp723_;
				} else {
					_tmp710_ = FALSE;
				}
				if (_tmp710_) {
					ValaSymbol* sym = NULL;
					ValaSemanticAnalyzer* _tmp724_;
					ValaSemanticAnalyzer* _tmp725_;
					ValaSymbol* _tmp726_;
					ValaSymbol* _tmp727_;
					ValaSymbol* _tmp728_;
					ValaParameter* _tmp739_;
					ValaPropertyAccessor* _tmp740_;
					ValaBlock* _tmp741_;
					ValaBlock* _tmp742_;
					_tmp724_ = vala_code_context_get_analyzer (context);
					_tmp725_ = _tmp724_;
					_tmp726_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp725_);
					_tmp727_ = _tmp726_;
					_tmp728_ = _vala_code_node_ref0 (_tmp727_);
					sym = _tmp728_;
					while (TRUE) {
						ValaSymbol* _tmp729_;
						ValaMethod* _tmp730_;
						ValaMethod* method = NULL;
						ValaSymbol* _tmp731_;
						ValaMethod* _tmp732_;
						ValaMethod* _tmp733_;
						ValaSymbol* _tmp735_;
						ValaSymbol* _tmp736_;
						ValaSymbol* _tmp737_;
						ValaSymbol* _tmp738_;
						_tmp729_ = sym;
						_tmp730_ = m;
						if (!(_tmp729_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp730_, VALA_TYPE_SYMBOL, ValaSymbol))) {
							break;
						}
						_tmp731_ = sym;
						_tmp732_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp731_, VALA_TYPE_METHOD) ? ((ValaMethod*) _tmp731_) : NULL);
						method = _tmp732_;
						_tmp733_ = method;
						if (_tmp733_ != NULL) {
							ValaMethod* _tmp734_;
							_tmp734_ = method;
							vala_method_set_closure (_tmp734_, TRUE);
						}
						_tmp735_ = sym;
						_tmp736_ = vala_symbol_get_parent_symbol (_tmp735_);
						_tmp737_ = _tmp736_;
						_tmp738_ = _vala_code_node_ref0 (_tmp737_);
						_vala_code_node_unref0 (sym);
						sym = _tmp738_;
						_vala_code_node_unref0 (method);
					}
					_tmp739_ = param;
					vala_parameter_set_captured (_tmp739_, TRUE);
					_tmp740_ = acc;
					_tmp741_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp740_);
					_tmp742_ = _tmp741_;
					vala_block_set_captured (_tmp742_, TRUE);
					_vala_code_node_unref0 (sym);
				}
				_vala_code_node_unref0 (acc);
			}
			_vala_code_node_unref0 (m);
			_vala_code_node_unref0 (param);
		} else {
			ValaSymbol* _tmp743_;
			_tmp743_ = member;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp743_, VALA_TYPE_FIELD)) {
				ValaField* f = NULL;
				ValaSymbol* _tmp744_;
				ValaField* _tmp745_;
				ValaField* _tmp746_;
				ValaSymbolAccessibility _tmp747_;
				ValaSymbolAccessibility _tmp748_;
				ValaField* _tmp749_;
				ValaMemberBinding _tmp750_;
				ValaMemberBinding _tmp751_;
				ValaField* _tmp752_;
				ValaMemberBinding _tmp753_;
				ValaMemberBinding _tmp754_;
				ValaField* _tmp755_;
				ValaDataType* _tmp756_;
				ValaDataType* _tmp757_;
				_tmp744_ = member;
				_tmp745_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp744_, VALA_TYPE_FIELD, ValaField));
				f = _tmp745_;
				_tmp746_ = f;
				_tmp747_ = vala_symbol_get_access ((ValaSymbol*) _tmp746_);
				_tmp748_ = _tmp747_;
				access = _tmp748_;
				_tmp749_ = f;
				_tmp750_ = vala_field_get_binding (_tmp749_);
				_tmp751_ = _tmp750_;
				instance = _tmp751_ == VALA_MEMBER_BINDING_INSTANCE;
				_tmp752_ = f;
				_tmp753_ = vala_field_get_binding (_tmp752_);
				_tmp754_ = _tmp753_;
				klass = _tmp754_ == VALA_MEMBER_BINDING_CLASS;
				_tmp755_ = f;
				_tmp756_ = vala_variable_get_variable_type ((ValaVariable*) _tmp755_);
				_tmp757_ = _tmp756_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp757_, VALA_TYPE_GENERIC_TYPE)) {
					generics = TRUE;
				}
				_vala_code_node_unref0 (f);
			} else {
				ValaSymbol* _tmp758_;
				_tmp758_ = member;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp758_, VALA_TYPE_CONSTANT)) {
					ValaConstant* c = NULL;
					ValaSymbol* _tmp759_;
					ValaConstant* _tmp760_;
					ValaConstant* _tmp761_;
					ValaSymbolAccessibility _tmp762_;
					ValaSymbolAccessibility _tmp763_;
					ValaBlock* block = NULL;
					ValaConstant* _tmp764_;
					ValaSymbol* _tmp765_;
					ValaSymbol* _tmp766_;
					ValaBlock* _tmp767_;
					gboolean _tmp768_ = FALSE;
					ValaBlock* _tmp769_;
					_tmp759_ = member;
					_tmp760_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp759_, VALA_TYPE_CONSTANT, ValaConstant));
					c = _tmp760_;
					_tmp761_ = c;
					_tmp762_ = vala_symbol_get_access ((ValaSymbol*) _tmp761_);
					_tmp763_ = _tmp762_;
					access = _tmp763_;
					_tmp764_ = c;
					_tmp765_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp764_);
					_tmp766_ = _tmp765_;
					_tmp767_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp766_, VALA_TYPE_BLOCK) ? ((ValaBlock*) _tmp766_) : NULL);
					block = _tmp767_;
					_tmp769_ = block;
					if (_tmp769_ != NULL) {
						ValaSemanticAnalyzer* _tmp770_;
						ValaSemanticAnalyzer* _tmp771_;
						ValaBlock* _tmp772_;
						ValaSymbol* _tmp773_;
						ValaSymbol* _tmp774_;
						ValaSemanticAnalyzer* _tmp775_;
						ValaSemanticAnalyzer* _tmp776_;
						ValaSymbol* _tmp777_;
						ValaSymbol* _tmp778_;
						_tmp770_ = vala_code_context_get_analyzer (context);
						_tmp771_ = _tmp770_;
						_tmp772_ = block;
						_tmp773_ = vala_semantic_analyzer_find_parent_method_or_property_accessor (_tmp771_, (ValaSymbol*) _tmp772_);
						_tmp774_ = _tmp773_;
						_tmp775_ = vala_code_context_get_analyzer (context);
						_tmp776_ = _tmp775_;
						_tmp777_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp776_);
						_tmp778_ = _tmp777_;
						_tmp768_ = _tmp774_ != _tmp778_;
						_vala_code_node_unref0 (_tmp774_);
					} else {
						_tmp768_ = FALSE;
					}
					if (_tmp768_) {
						ValaSourceReference* _tmp779_;
						ValaSourceReference* _tmp780_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp779_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp780_ = _tmp779_;
						vala_report_error (_tmp780_, "internal error: accessing local constants of outer methods is not supp" \
"orted yet");
						result = FALSE;
						_vala_code_node_unref0 (block);
						_vala_code_node_unref0 (c);
						_vala_code_node_unref0 (member);
						_vala_code_node_unref0 (this_parameter);
						_vala_code_node_unref0 (base_symbol);
						return result;
					}
					_vala_code_node_unref0 (block);
					_vala_code_node_unref0 (c);
				} else {
					ValaSymbol* _tmp781_;
					_tmp781_ = member;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp781_, VALA_TYPE_METHOD)) {
						ValaMethod* m = NULL;
						ValaSymbol* _tmp782_;
						ValaMethod* _tmp783_;
						ValaMethod* _tmp784_;
						gboolean _tmp785_;
						gboolean _tmp786_;
						ValaMethod* _tmp889_;
						ValaSymbolAccessibility _tmp890_;
						ValaSymbolAccessibility _tmp891_;
						ValaMethod* _tmp892_;
						ValaMethod* _tmp896_;
						ValaMemberBinding _tmp897_;
						ValaMemberBinding _tmp898_;
						ValaGenericType* generic_type = NULL;
						ValaMethod* _tmp921_;
						ValaDataType* _tmp922_;
						ValaDataType* _tmp923_;
						ValaGenericType* _tmp924_;
						gboolean _tmp925_ = FALSE;
						ValaGenericType* _tmp926_;
						_tmp782_ = member;
						_tmp783_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp782_, VALA_TYPE_METHOD, ValaMethod));
						m = _tmp783_;
						_tmp784_ = m;
						_tmp785_ = vala_method_get_is_async_callback (_tmp784_);
						_tmp786_ = _tmp785_;
						if (_tmp786_) {
							ValaMethod* async_method = NULL;
							ValaSemanticAnalyzer* _tmp787_;
							ValaSemanticAnalyzer* _tmp788_;
							ValaMethod* _tmp789_;
							ValaMethod* _tmp790_;
							ValaMethod* _tmp791_;
							gboolean is_valid_access = FALSE;
							ValaMethod* _tmp792_;
							gboolean _tmp818_;
							ValaMethod* _tmp826_;
							ValaSemanticAnalyzer* _tmp827_;
							ValaSemanticAnalyzer* _tmp828_;
							ValaMethod* _tmp829_;
							ValaMethod* _tmp830_;
							ValaMethod* _tmp849_;
							ValaMethod* _tmp850_;
							ValaMethod* _tmp851_;
							ValaSymbol* _tmp852_;
							ValaSymbol* _tmp853_;
							ValaSymbol* _tmp854_;
							_tmp787_ = vala_code_context_get_analyzer (context);
							_tmp788_ = _tmp787_;
							_tmp789_ = vala_semantic_analyzer_get_current_async_method (_tmp788_);
							_tmp790_ = _tmp789_;
							_tmp791_ = _vala_code_node_ref0 (_tmp790_);
							async_method = _tmp791_;
							is_valid_access = FALSE;
							_tmp792_ = async_method;
							if (_tmp792_ != NULL) {
								ValaMethod* _tmp793_;
								ValaMethod* _tmp794_;
								ValaMethod* _tmp795_;
								ValaMethod* _tmp796_;
								gboolean _tmp797_;
								_tmp793_ = m;
								_tmp794_ = async_method;
								_tmp795_ = vala_method_get_callback_method (_tmp794_);
								_tmp796_ = _tmp795_;
								_tmp797_ = _tmp793_ == _tmp796_;
								_vala_code_node_unref0 (_tmp796_);
								if (_tmp797_) {
									is_valid_access = TRUE;
								} else {
									gboolean _tmp798_ = FALSE;
									ValaMethod* _tmp799_;
									ValaMethod* _tmp800_;
									ValaMethod* _tmp801_;
									_tmp799_ = async_method;
									_tmp800_ = vala_method_get_base_method (_tmp799_);
									_tmp801_ = _tmp800_;
									if (_tmp801_ != NULL) {
										ValaMethod* _tmp802_;
										ValaMethod* _tmp803_;
										ValaMethod* _tmp804_;
										ValaMethod* _tmp805_;
										ValaMethod* _tmp806_;
										ValaMethod* _tmp807_;
										_tmp802_ = m;
										_tmp803_ = async_method;
										_tmp804_ = vala_method_get_base_method (_tmp803_);
										_tmp805_ = _tmp804_;
										_tmp806_ = vala_method_get_callback_method (_tmp805_);
										_tmp807_ = _tmp806_;
										_tmp798_ = _tmp802_ == _tmp807_;
										_vala_code_node_unref0 (_tmp807_);
									} else {
										_tmp798_ = FALSE;
									}
									if (_tmp798_) {
										is_valid_access = TRUE;
									} else {
										gboolean _tmp808_ = FALSE;
										ValaMethod* _tmp809_;
										ValaMethod* _tmp810_;
										ValaMethod* _tmp811_;
										_tmp809_ = async_method;
										_tmp810_ = vala_method_get_base_interface_method (_tmp809_);
										_tmp811_ = _tmp810_;
										if (_tmp811_ != NULL) {
											ValaMethod* _tmp812_;
											ValaMethod* _tmp813_;
											ValaMethod* _tmp814_;
											ValaMethod* _tmp815_;
											ValaMethod* _tmp816_;
											ValaMethod* _tmp817_;
											_tmp812_ = m;
											_tmp813_ = async_method;
											_tmp814_ = vala_method_get_base_interface_method (_tmp813_);
											_tmp815_ = _tmp814_;
											_tmp816_ = vala_method_get_callback_method (_tmp815_);
											_tmp817_ = _tmp816_;
											_tmp808_ = _tmp812_ == _tmp817_;
											_vala_code_node_unref0 (_tmp817_);
										} else {
											_tmp808_ = FALSE;
										}
										if (_tmp808_) {
											is_valid_access = TRUE;
										}
									}
								}
							}
							_tmp818_ = is_valid_access;
							if (!_tmp818_) {
								ValaSourceReference* _tmp819_;
								ValaSourceReference* _tmp820_;
								ValaMethod* _tmp821_;
								gchar* _tmp822_;
								gchar* _tmp823_;
								gchar* _tmp824_;
								gchar* _tmp825_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp819_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp820_ = _tmp819_;
								_tmp821_ = m;
								_tmp822_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp821_);
								_tmp823_ = _tmp822_;
								_tmp824_ = g_strdup_printf ("Access to async callback `%s' not allowed in this context", _tmp823_);
								_tmp825_ = _tmp824_;
								vala_report_error (_tmp820_, _tmp825_);
								_g_free0 (_tmp825_);
								_g_free0 (_tmp823_);
								result = FALSE;
								_vala_code_node_unref0 (async_method);
								_vala_code_node_unref0 (m);
								_vala_code_node_unref0 (member);
								_vala_code_node_unref0 (this_parameter);
								_vala_code_node_unref0 (base_symbol);
								return result;
							}
							_tmp826_ = async_method;
							_tmp827_ = vala_code_context_get_analyzer (context);
							_tmp828_ = _tmp827_;
							_tmp829_ = vala_semantic_analyzer_get_current_method (_tmp828_);
							_tmp830_ = _tmp829_;
							if (_tmp826_ != _tmp830_) {
								ValaSymbol* sym = NULL;
								ValaSemanticAnalyzer* _tmp831_;
								ValaSemanticAnalyzer* _tmp832_;
								ValaMethod* _tmp833_;
								ValaMethod* _tmp834_;
								ValaSymbol* _tmp835_;
								ValaMethod* _tmp846_;
								ValaBlock* _tmp847_;
								ValaBlock* _tmp848_;
								_tmp831_ = vala_code_context_get_analyzer (context);
								_tmp832_ = _tmp831_;
								_tmp833_ = vala_semantic_analyzer_get_current_method (_tmp832_);
								_tmp834_ = _tmp833_;
								_tmp835_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp834_);
								sym = _tmp835_;
								while (TRUE) {
									ValaSymbol* _tmp836_;
									ValaMethod* _tmp837_;
									ValaMethod* method = NULL;
									ValaSymbol* _tmp838_;
									ValaMethod* _tmp839_;
									ValaMethod* _tmp840_;
									ValaSymbol* _tmp842_;
									ValaSymbol* _tmp843_;
									ValaSymbol* _tmp844_;
									ValaSymbol* _tmp845_;
									_tmp836_ = sym;
									_tmp837_ = async_method;
									if (!(_tmp836_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp837_, VALA_TYPE_SYMBOL, ValaSymbol))) {
										break;
									}
									_tmp838_ = sym;
									_tmp839_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp838_, VALA_TYPE_METHOD) ? ((ValaMethod*) _tmp838_) : NULL);
									method = _tmp839_;
									_tmp840_ = method;
									if (_tmp840_ != NULL) {
										ValaMethod* _tmp841_;
										_tmp841_ = method;
										vala_method_set_closure (_tmp841_, TRUE);
									}
									_tmp842_ = sym;
									_tmp843_ = vala_symbol_get_parent_symbol (_tmp842_);
									_tmp844_ = _tmp843_;
									_tmp845_ = _vala_code_node_ref0 (_tmp844_);
									_vala_code_node_unref0 (sym);
									sym = _tmp845_;
									_vala_code_node_unref0 (method);
								}
								_tmp846_ = async_method;
								_tmp847_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp846_);
								_tmp848_ = _tmp847_;
								vala_block_set_captured (_tmp848_, TRUE);
								_vala_code_node_unref0 (sym);
							}
							_tmp849_ = async_method;
							_tmp850_ = vala_method_get_callback_method (_tmp849_);
							_vala_code_node_unref0 (m);
							m = _tmp850_;
							_tmp851_ = m;
							vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp851_);
							_tmp852_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
							_tmp853_ = _tmp852_;
							_tmp854_ = _vala_code_node_ref0 (_tmp853_);
							_vala_code_node_unref0 (member);
							member = _tmp854_;
							_vala_code_node_unref0 (async_method);
						} else {
							ValaMethod* _tmp855_;
							ValaMethod* _tmp856_;
							ValaMethod* _tmp857_;
							_tmp855_ = m;
							_tmp856_ = vala_method_get_base_method (_tmp855_);
							_tmp857_ = _tmp856_;
							if (_tmp857_ != NULL) {
								ValaMethod* _tmp858_;
								ValaMethod* _tmp859_;
								ValaMethod* _tmp860_;
								ValaMethod* _tmp861_;
								ValaMethod* _tmp862_;
								ValaSignal* _tmp863_;
								ValaSignal* _tmp864_;
								ValaSymbol* _tmp869_;
								ValaSymbol* _tmp870_;
								ValaSymbol* _tmp871_;
								_tmp858_ = m;
								_tmp859_ = vala_method_get_base_method (_tmp858_);
								_tmp860_ = _tmp859_;
								_tmp861_ = _vala_code_node_ref0 (_tmp860_);
								_vala_code_node_unref0 (m);
								m = _tmp861_;
								_tmp862_ = m;
								_tmp863_ = vala_method_get_signal_reference (_tmp862_);
								_tmp864_ = _tmp863_;
								if (_tmp864_ != NULL) {
									ValaMethod* _tmp865_;
									ValaSignal* _tmp866_;
									ValaSignal* _tmp867_;
									_tmp865_ = m;
									_tmp866_ = vala_method_get_signal_reference (_tmp865_);
									_tmp867_ = _tmp866_;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp867_);
								} else {
									ValaMethod* _tmp868_;
									_tmp868_ = m;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp868_);
								}
								_tmp869_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp870_ = _tmp869_;
								_tmp871_ = _vala_code_node_ref0 (_tmp870_);
								_vala_code_node_unref0 (member);
								member = _tmp871_;
							} else {
								ValaMethod* _tmp872_;
								ValaMethod* _tmp873_;
								ValaMethod* _tmp874_;
								_tmp872_ = m;
								_tmp873_ = vala_method_get_base_interface_method (_tmp872_);
								_tmp874_ = _tmp873_;
								if (_tmp874_ != NULL) {
									ValaMethod* _tmp875_;
									ValaMethod* _tmp876_;
									ValaMethod* _tmp877_;
									ValaMethod* _tmp878_;
									ValaMethod* _tmp879_;
									ValaSignal* _tmp880_;
									ValaSignal* _tmp881_;
									ValaSymbol* _tmp886_;
									ValaSymbol* _tmp887_;
									ValaSymbol* _tmp888_;
									_tmp875_ = m;
									_tmp876_ = vala_method_get_base_interface_method (_tmp875_);
									_tmp877_ = _tmp876_;
									_tmp878_ = _vala_code_node_ref0 (_tmp877_);
									_vala_code_node_unref0 (m);
									m = _tmp878_;
									_tmp879_ = m;
									_tmp880_ = vala_method_get_signal_reference (_tmp879_);
									_tmp881_ = _tmp880_;
									if (_tmp881_ != NULL) {
										ValaMethod* _tmp882_;
										ValaSignal* _tmp883_;
										ValaSignal* _tmp884_;
										_tmp882_ = m;
										_tmp883_ = vala_method_get_signal_reference (_tmp882_);
										_tmp884_ = _tmp883_;
										vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp884_);
									} else {
										ValaMethod* _tmp885_;
										_tmp885_ = m;
										vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp885_);
									}
									_tmp886_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp887_ = _tmp886_;
									_tmp888_ = _vala_code_node_ref0 (_tmp887_);
									_vala_code_node_unref0 (member);
									member = _tmp888_;
								}
							}
						}
						_tmp889_ = m;
						_tmp890_ = vala_symbol_get_access ((ValaSymbol*) _tmp889_);
						_tmp891_ = _tmp890_;
						access = _tmp891_;
						_tmp892_ = m;
						if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp892_, VALA_TYPE_CREATION_METHOD)) {
							ValaMethod* _tmp893_;
							ValaMemberBinding _tmp894_;
							ValaMemberBinding _tmp895_;
							_tmp893_ = m;
							_tmp894_ = vala_method_get_binding (_tmp893_);
							_tmp895_ = _tmp894_;
							instance = _tmp895_ == VALA_MEMBER_BINDING_INSTANCE;
						}
						_tmp896_ = m;
						_tmp897_ = vala_method_get_binding (_tmp896_);
						_tmp898_ = _tmp897_;
						klass = _tmp898_ == VALA_MEMBER_BINDING_CLASS;
						{
							ValaList* _param_list = NULL;
							ValaMethod* _tmp899_;
							ValaList* _tmp900_;
							gint _param_size = 0;
							ValaList* _tmp901_;
							gint _tmp902_;
							gint _tmp903_;
							gint _param_index = 0;
							_tmp899_ = m;
							_tmp900_ = vala_callable_get_parameters ((ValaCallable*) _tmp899_);
							_param_list = _tmp900_;
							_tmp901_ = _param_list;
							_tmp902_ = vala_collection_get_size ((ValaCollection*) _tmp901_);
							_tmp903_ = _tmp902_;
							_param_size = _tmp903_;
							_param_index = -1;
							while (TRUE) {
								gint _tmp904_;
								gint _tmp905_;
								gint _tmp906_;
								ValaParameter* param = NULL;
								ValaList* _tmp907_;
								gint _tmp908_;
								gpointer _tmp909_;
								ValaGenericType* generic_type = NULL;
								ValaParameter* _tmp910_;
								ValaDataType* _tmp911_;
								ValaDataType* _tmp912_;
								ValaGenericType* _tmp913_;
								gboolean _tmp914_ = FALSE;
								ValaGenericType* _tmp915_;
								_tmp904_ = _param_index;
								_param_index = _tmp904_ + 1;
								_tmp905_ = _param_index;
								_tmp906_ = _param_size;
								if (!(_tmp905_ < _tmp906_)) {
									break;
								}
								_tmp907_ = _param_list;
								_tmp908_ = _param_index;
								_tmp909_ = vala_list_get (_tmp907_, _tmp908_);
								param = (ValaParameter*) _tmp909_;
								_tmp910_ = param;
								_tmp911_ = vala_variable_get_variable_type ((ValaVariable*) _tmp910_);
								_tmp912_ = _tmp911_;
								_tmp913_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp912_, VALA_TYPE_GENERIC_TYPE) ? ((ValaGenericType*) _tmp912_) : NULL);
								generic_type = _tmp913_;
								_tmp915_ = generic_type;
								if (_tmp915_ != NULL) {
									ValaGenericType* _tmp916_;
									ValaTypeParameter* _tmp917_;
									ValaTypeParameter* _tmp918_;
									ValaSymbol* _tmp919_;
									ValaSymbol* _tmp920_;
									_tmp916_ = generic_type;
									_tmp917_ = vala_generic_type_get_type_parameter (_tmp916_);
									_tmp918_ = _tmp917_;
									_tmp919_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp918_);
									_tmp920_ = _tmp919_;
									_tmp914_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp920_, VALA_TYPE_TYPESYMBOL);
								} else {
									_tmp914_ = FALSE;
								}
								if (_tmp914_) {
									generics = TRUE;
									_vala_code_node_unref0 (generic_type);
									_vala_code_node_unref0 (param);
									break;
								}
								_vala_code_node_unref0 (generic_type);
								_vala_code_node_unref0 (param);
							}
							_vala_iterable_unref0 (_param_list);
						}
						_tmp921_ = m;
						_tmp922_ = vala_callable_get_return_type ((ValaCallable*) _tmp921_);
						_tmp923_ = _tmp922_;
						_tmp924_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp923_, VALA_TYPE_GENERIC_TYPE) ? ((ValaGenericType*) _tmp923_) : NULL);
						generic_type = _tmp924_;
						_tmp926_ = generic_type;
						if (_tmp926_ != NULL) {
							ValaGenericType* _tmp927_;
							ValaTypeParameter* _tmp928_;
							ValaTypeParameter* _tmp929_;
							ValaSymbol* _tmp930_;
							ValaSymbol* _tmp931_;
							_tmp927_ = generic_type;
							_tmp928_ = vala_generic_type_get_type_parameter (_tmp927_);
							_tmp929_ = _tmp928_;
							_tmp930_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp929_);
							_tmp931_ = _tmp930_;
							_tmp925_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp931_, VALA_TYPE_TYPESYMBOL);
						} else {
							_tmp925_ = FALSE;
						}
						if (_tmp925_) {
							generics = TRUE;
						}
						_vala_code_node_unref0 (generic_type);
						_vala_code_node_unref0 (m);
					} else {
						ValaSymbol* _tmp932_;
						_tmp932_ = member;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp932_, VALA_TYPE_PROPERTY)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp933_;
							ValaProperty* _tmp934_;
							ValaProperty* _tmp935_;
							ValaProperty* _tmp936_;
							ValaProperty* _tmp937_;
							ValaProperty* _tmp938_;
							ValaProperty* _tmp958_;
							ValaSymbolAccessibility _tmp959_;
							ValaSymbolAccessibility _tmp960_;
							gboolean _tmp961_;
							gboolean _tmp962_;
							ValaProperty* _tmp1027_;
							ValaMemberBinding _tmp1028_;
							ValaMemberBinding _tmp1029_;
							ValaProperty* _tmp1030_;
							ValaDataType* _tmp1031_;
							ValaDataType* _tmp1032_;
							_tmp933_ = member;
							_tmp934_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp933_, VALA_TYPE_PROPERTY, ValaProperty));
							prop = _tmp934_;
							_tmp935_ = prop;
							if (!vala_code_node_check ((ValaCodeNode*) _tmp935_, context)) {
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								result = FALSE;
								_vala_code_node_unref0 (prop);
								_vala_code_node_unref0 (member);
								_vala_code_node_unref0 (this_parameter);
								_vala_code_node_unref0 (base_symbol);
								return result;
							}
							_tmp936_ = prop;
							_tmp937_ = vala_property_get_base_property (_tmp936_);
							_tmp938_ = _tmp937_;
							if (_tmp938_ != NULL) {
								ValaProperty* _tmp939_;
								ValaProperty* _tmp940_;
								ValaProperty* _tmp941_;
								ValaProperty* _tmp942_;
								ValaProperty* _tmp943_;
								ValaSymbol* _tmp944_;
								ValaSymbol* _tmp945_;
								ValaSymbol* _tmp946_;
								_tmp939_ = prop;
								_tmp940_ = vala_property_get_base_property (_tmp939_);
								_tmp941_ = _tmp940_;
								_tmp942_ = _vala_code_node_ref0 (_tmp941_);
								_vala_code_node_unref0 (prop);
								prop = _tmp942_;
								_tmp943_ = prop;
								vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp943_);
								_tmp944_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp945_ = _tmp944_;
								_tmp946_ = _vala_code_node_ref0 (_tmp945_);
								_vala_code_node_unref0 (member);
								member = _tmp946_;
							} else {
								ValaProperty* _tmp947_;
								ValaProperty* _tmp948_;
								ValaProperty* _tmp949_;
								_tmp947_ = prop;
								_tmp948_ = vala_property_get_base_interface_property (_tmp947_);
								_tmp949_ = _tmp948_;
								if (_tmp949_ != NULL) {
									ValaProperty* _tmp950_;
									ValaProperty* _tmp951_;
									ValaProperty* _tmp952_;
									ValaProperty* _tmp953_;
									ValaProperty* _tmp954_;
									ValaSymbol* _tmp955_;
									ValaSymbol* _tmp956_;
									ValaSymbol* _tmp957_;
									_tmp950_ = prop;
									_tmp951_ = vala_property_get_base_interface_property (_tmp950_);
									_tmp952_ = _tmp951_;
									_tmp953_ = _vala_code_node_ref0 (_tmp952_);
									_vala_code_node_unref0 (prop);
									prop = _tmp953_;
									_tmp954_ = prop;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp954_);
									_tmp955_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp956_ = _tmp955_;
									_tmp957_ = _vala_code_node_ref0 (_tmp956_);
									_vala_code_node_unref0 (member);
									member = _tmp957_;
								}
							}
							_tmp958_ = prop;
							_tmp959_ = vala_symbol_get_access ((ValaSymbol*) _tmp958_);
							_tmp960_ = _tmp959_;
							access = _tmp960_;
							_tmp961_ = vala_expression_get_lvalue ((ValaExpression*) self);
							_tmp962_ = _tmp961_;
							if (_tmp962_) {
								ValaProperty* _tmp963_;
								ValaPropertyAccessor* _tmp964_;
								ValaPropertyAccessor* _tmp965_;
								ValaProperty* _tmp973_;
								ValaSymbolAccessibility _tmp974_;
								ValaSymbolAccessibility _tmp975_;
								_tmp963_ = prop;
								_tmp964_ = vala_property_get_set_accessor (_tmp963_);
								_tmp965_ = _tmp964_;
								if (_tmp965_ == NULL) {
									ValaSourceReference* _tmp966_;
									ValaSourceReference* _tmp967_;
									ValaProperty* _tmp968_;
									gchar* _tmp969_;
									gchar* _tmp970_;
									gchar* _tmp971_;
									gchar* _tmp972_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp966_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp967_ = _tmp966_;
									_tmp968_ = prop;
									_tmp969_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp968_);
									_tmp970_ = _tmp969_;
									_tmp971_ = g_strdup_printf ("Property `%s' is read-only", _tmp970_);
									_tmp972_ = _tmp971_;
									vala_report_error (_tmp967_, _tmp972_);
									_g_free0 (_tmp972_);
									_g_free0 (_tmp970_);
									result = FALSE;
									_vala_code_node_unref0 (prop);
									_vala_code_node_unref0 (member);
									_vala_code_node_unref0 (this_parameter);
									_vala_code_node_unref0 (base_symbol);
									return result;
								}
								_tmp973_ = prop;
								_tmp974_ = vala_symbol_get_access ((ValaSymbol*) _tmp973_);
								_tmp975_ = _tmp974_;
								if (_tmp975_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
									ValaProperty* _tmp976_;
									ValaPropertyAccessor* _tmp977_;
									ValaPropertyAccessor* _tmp978_;
									ValaSymbolAccessibility _tmp979_;
									ValaSymbolAccessibility _tmp980_;
									_tmp976_ = prop;
									_tmp977_ = vala_property_get_set_accessor (_tmp976_);
									_tmp978_ = _tmp977_;
									_tmp979_ = vala_symbol_get_access ((ValaSymbol*) _tmp978_);
									_tmp980_ = _tmp979_;
									access = _tmp980_;
								} else {
									gboolean _tmp981_ = FALSE;
									ValaProperty* _tmp982_;
									ValaSymbolAccessibility _tmp983_;
									ValaSymbolAccessibility _tmp984_;
									_tmp982_ = prop;
									_tmp983_ = vala_symbol_get_access ((ValaSymbol*) _tmp982_);
									_tmp984_ = _tmp983_;
									if (_tmp984_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
										ValaProperty* _tmp985_;
										ValaPropertyAccessor* _tmp986_;
										ValaPropertyAccessor* _tmp987_;
										ValaSymbolAccessibility _tmp988_;
										ValaSymbolAccessibility _tmp989_;
										_tmp985_ = prop;
										_tmp986_ = vala_property_get_set_accessor (_tmp985_);
										_tmp987_ = _tmp986_;
										_tmp988_ = vala_symbol_get_access ((ValaSymbol*) _tmp987_);
										_tmp989_ = _tmp988_;
										_tmp981_ = _tmp989_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
									} else {
										_tmp981_ = FALSE;
									}
									if (_tmp981_) {
										ValaProperty* _tmp990_;
										ValaPropertyAccessor* _tmp991_;
										ValaPropertyAccessor* _tmp992_;
										ValaSymbolAccessibility _tmp993_;
										ValaSymbolAccessibility _tmp994_;
										_tmp990_ = prop;
										_tmp991_ = vala_property_get_set_accessor (_tmp990_);
										_tmp992_ = _tmp991_;
										_tmp993_ = vala_symbol_get_access ((ValaSymbol*) _tmp992_);
										_tmp994_ = _tmp993_;
										access = _tmp994_;
									}
								}
							} else {
								ValaProperty* _tmp995_;
								ValaPropertyAccessor* _tmp996_;
								ValaPropertyAccessor* _tmp997_;
								ValaProperty* _tmp1005_;
								ValaSymbolAccessibility _tmp1006_;
								ValaSymbolAccessibility _tmp1007_;
								_tmp995_ = prop;
								_tmp996_ = vala_property_get_get_accessor (_tmp995_);
								_tmp997_ = _tmp996_;
								if (_tmp997_ == NULL) {
									ValaSourceReference* _tmp998_;
									ValaSourceReference* _tmp999_;
									ValaProperty* _tmp1000_;
									gchar* _tmp1001_;
									gchar* _tmp1002_;
									gchar* _tmp1003_;
									gchar* _tmp1004_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp998_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp999_ = _tmp998_;
									_tmp1000_ = prop;
									_tmp1001_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1000_);
									_tmp1002_ = _tmp1001_;
									_tmp1003_ = g_strdup_printf ("Property `%s' is write-only", _tmp1002_);
									_tmp1004_ = _tmp1003_;
									vala_report_error (_tmp999_, _tmp1004_);
									_g_free0 (_tmp1004_);
									_g_free0 (_tmp1002_);
									result = FALSE;
									_vala_code_node_unref0 (prop);
									_vala_code_node_unref0 (member);
									_vala_code_node_unref0 (this_parameter);
									_vala_code_node_unref0 (base_symbol);
									return result;
								}
								_tmp1005_ = prop;
								_tmp1006_ = vala_symbol_get_access ((ValaSymbol*) _tmp1005_);
								_tmp1007_ = _tmp1006_;
								if (_tmp1007_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
									ValaProperty* _tmp1008_;
									ValaPropertyAccessor* _tmp1009_;
									ValaPropertyAccessor* _tmp1010_;
									ValaSymbolAccessibility _tmp1011_;
									ValaSymbolAccessibility _tmp1012_;
									_tmp1008_ = prop;
									_tmp1009_ = vala_property_get_get_accessor (_tmp1008_);
									_tmp1010_ = _tmp1009_;
									_tmp1011_ = vala_symbol_get_access ((ValaSymbol*) _tmp1010_);
									_tmp1012_ = _tmp1011_;
									access = _tmp1012_;
								} else {
									gboolean _tmp1013_ = FALSE;
									ValaProperty* _tmp1014_;
									ValaSymbolAccessibility _tmp1015_;
									ValaSymbolAccessibility _tmp1016_;
									_tmp1014_ = prop;
									_tmp1015_ = vala_symbol_get_access ((ValaSymbol*) _tmp1014_);
									_tmp1016_ = _tmp1015_;
									if (_tmp1016_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
										ValaProperty* _tmp1017_;
										ValaPropertyAccessor* _tmp1018_;
										ValaPropertyAccessor* _tmp1019_;
										ValaSymbolAccessibility _tmp1020_;
										ValaSymbolAccessibility _tmp1021_;
										_tmp1017_ = prop;
										_tmp1018_ = vala_property_get_get_accessor (_tmp1017_);
										_tmp1019_ = _tmp1018_;
										_tmp1020_ = vala_symbol_get_access ((ValaSymbol*) _tmp1019_);
										_tmp1021_ = _tmp1020_;
										_tmp1013_ = _tmp1021_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
									} else {
										_tmp1013_ = FALSE;
									}
									if (_tmp1013_) {
										ValaProperty* _tmp1022_;
										ValaPropertyAccessor* _tmp1023_;
										ValaPropertyAccessor* _tmp1024_;
										ValaSymbolAccessibility _tmp1025_;
										ValaSymbolAccessibility _tmp1026_;
										_tmp1022_ = prop;
										_tmp1023_ = vala_property_get_get_accessor (_tmp1022_);
										_tmp1024_ = _tmp1023_;
										_tmp1025_ = vala_symbol_get_access ((ValaSymbol*) _tmp1024_);
										_tmp1026_ = _tmp1025_;
										access = _tmp1026_;
									}
								}
							}
							_tmp1027_ = prop;
							_tmp1028_ = vala_property_get_binding (_tmp1027_);
							_tmp1029_ = _tmp1028_;
							instance = _tmp1029_ == VALA_MEMBER_BINDING_INSTANCE;
							_tmp1030_ = prop;
							_tmp1031_ = vala_property_get_property_type (_tmp1030_);
							_tmp1032_ = _tmp1031_;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1032_, VALA_TYPE_GENERIC_TYPE)) {
								generics = TRUE;
							}
							_vala_code_node_unref0 (prop);
						} else {
							ValaSymbol* _tmp1033_;
							_tmp1033_ = member;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1033_, VALA_TYPE_SIGNAL)) {
								ValaSymbol* _tmp1034_;
								ValaSymbolAccessibility _tmp1035_;
								ValaSymbolAccessibility _tmp1036_;
								instance = TRUE;
								_tmp1034_ = member;
								_tmp1035_ = vala_symbol_get_access (_tmp1034_);
								_tmp1036_ = _tmp1035_;
								access = _tmp1036_;
							}
						}
					}
				}
			}
		}
	}
	_tmp1037_ = member;
	vala_symbol_set_used (_tmp1037_, TRUE);
	_tmp1038_ = member;
	_tmp1039_ = vala_symbol_get_version (_tmp1038_);
	_tmp1040_ = _tmp1039_;
	_tmp1041_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp1042_ = _tmp1041_;
	vala_version_attribute_check (_tmp1040_, _tmp1042_);
	_tmp1043_ = access;
	if (_tmp1043_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
		ValaTypeSymbol* target_type = NULL;
		ValaSymbol* _tmp1044_;
		ValaSymbol* _tmp1045_;
		ValaSymbol* _tmp1046_;
		ValaTypeSymbol* _tmp1047_;
		gboolean in_subtype = FALSE;
		gboolean _tmp1067_;
		_tmp1044_ = member;
		_tmp1045_ = vala_symbol_get_parent_symbol (_tmp1044_);
		_tmp1046_ = _tmp1045_;
		_tmp1047_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1046_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
		target_type = _tmp1047_;
		in_subtype = FALSE;
		{
			ValaSymbol* this_symbol = NULL;
			ValaSemanticAnalyzer* _tmp1048_;
			ValaSemanticAnalyzer* _tmp1049_;
			ValaSymbol* _tmp1050_;
			ValaSymbol* _tmp1051_;
			ValaSymbol* _tmp1052_;
			_tmp1048_ = vala_code_context_get_analyzer (context);
			_tmp1049_ = _tmp1048_;
			_tmp1050_ = vala_semantic_analyzer_get_current_symbol (_tmp1049_);
			_tmp1051_ = _tmp1050_;
			_tmp1052_ = _vala_code_node_ref0 (_tmp1051_);
			this_symbol = _tmp1052_;
			{
				gboolean _tmp1053_ = FALSE;
				_tmp1053_ = TRUE;
				while (TRUE) {
					ValaSymbol* _tmp1058_;
					ValaSymbol* _tmp1059_;
					ValaTypeSymbol* _tmp1060_;
					ValaClass* cl = NULL;
					ValaSymbol* _tmp1061_;
					ValaClass* _tmp1062_;
					gboolean _tmp1063_ = FALSE;
					ValaClass* _tmp1064_;
					if (!_tmp1053_) {
						ValaSymbol* _tmp1054_;
						ValaSymbol* _tmp1055_;
						ValaSymbol* _tmp1056_;
						ValaSymbol* _tmp1057_;
						_tmp1054_ = this_symbol;
						_tmp1055_ = vala_symbol_get_parent_symbol (_tmp1054_);
						_tmp1056_ = _tmp1055_;
						_tmp1057_ = _vala_code_node_ref0 (_tmp1056_);
						_vala_code_node_unref0 (this_symbol);
						this_symbol = _tmp1057_;
					}
					_tmp1053_ = FALSE;
					_tmp1058_ = this_symbol;
					if (!(_tmp1058_ != NULL)) {
						break;
					}
					_tmp1059_ = this_symbol;
					_tmp1060_ = target_type;
					if (_tmp1059_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1060_, VALA_TYPE_SYMBOL, ValaSymbol)) {
						in_subtype = TRUE;
						break;
					}
					_tmp1061_ = this_symbol;
					_tmp1062_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1061_, VALA_TYPE_CLASS) ? ((ValaClass*) _tmp1061_) : NULL);
					cl = _tmp1062_;
					_tmp1064_ = cl;
					if (_tmp1064_ != NULL) {
						ValaClass* _tmp1065_;
						ValaTypeSymbol* _tmp1066_;
						_tmp1065_ = cl;
						_tmp1066_ = target_type;
						_tmp1063_ = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp1065_, _tmp1066_);
					} else {
						_tmp1063_ = FALSE;
					}
					if (_tmp1063_) {
						in_subtype = TRUE;
						_vala_code_node_unref0 (cl);
						break;
					}
					_vala_code_node_unref0 (cl);
				}
			}
			_vala_code_node_unref0 (this_symbol);
		}
		_tmp1067_ = in_subtype;
		if (!_tmp1067_) {
			ValaSourceReference* _tmp1068_;
			ValaSourceReference* _tmp1069_;
			ValaSymbol* _tmp1070_;
			gchar* _tmp1071_;
			gchar* _tmp1072_;
			gchar* _tmp1073_;
			gchar* _tmp1074_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp1068_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1069_ = _tmp1068_;
			_tmp1070_ = member;
			_tmp1071_ = vala_symbol_get_full_name (_tmp1070_);
			_tmp1072_ = _tmp1071_;
			_tmp1073_ = g_strdup_printf ("Access to protected member `%s' denied", _tmp1072_);
			_tmp1074_ = _tmp1073_;
			vala_report_error (_tmp1069_, _tmp1074_);
			_g_free0 (_tmp1074_);
			_g_free0 (_tmp1072_);
			result = FALSE;
			_vala_code_node_unref0 (target_type);
			_vala_code_node_unref0 (member);
			_vala_code_node_unref0 (this_parameter);
			_vala_code_node_unref0 (base_symbol);
			return result;
		}
		_vala_code_node_unref0 (target_type);
	} else {
		ValaSymbolAccessibility _tmp1075_;
		_tmp1075_ = access;
		if (_tmp1075_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			ValaSymbol* target_type = NULL;
			ValaSymbol* _tmp1076_;
			ValaSymbol* _tmp1077_;
			ValaSymbol* _tmp1078_;
			ValaSymbol* _tmp1079_;
			gboolean in_target_type = FALSE;
			gboolean _tmp1093_;
			_tmp1076_ = member;
			_tmp1077_ = vala_symbol_get_parent_symbol (_tmp1076_);
			_tmp1078_ = _tmp1077_;
			_tmp1079_ = _vala_code_node_ref0 (_tmp1078_);
			target_type = _tmp1079_;
			in_target_type = FALSE;
			{
				ValaSymbol* this_symbol = NULL;
				ValaSemanticAnalyzer* _tmp1080_;
				ValaSemanticAnalyzer* _tmp1081_;
				ValaSymbol* _tmp1082_;
				ValaSymbol* _tmp1083_;
				ValaSymbol* _tmp1084_;
				_tmp1080_ = vala_code_context_get_analyzer (context);
				_tmp1081_ = _tmp1080_;
				_tmp1082_ = vala_semantic_analyzer_get_current_symbol (_tmp1081_);
				_tmp1083_ = _tmp1082_;
				_tmp1084_ = _vala_code_node_ref0 (_tmp1083_);
				this_symbol = _tmp1084_;
				{
					gboolean _tmp1085_ = FALSE;
					_tmp1085_ = TRUE;
					while (TRUE) {
						ValaSymbol* _tmp1090_;
						ValaSymbol* _tmp1091_;
						ValaSymbol* _tmp1092_;
						if (!_tmp1085_) {
							ValaSymbol* _tmp1086_;
							ValaSymbol* _tmp1087_;
							ValaSymbol* _tmp1088_;
							ValaSymbol* _tmp1089_;
							_tmp1086_ = this_symbol;
							_tmp1087_ = vala_symbol_get_parent_symbol (_tmp1086_);
							_tmp1088_ = _tmp1087_;
							_tmp1089_ = _vala_code_node_ref0 (_tmp1088_);
							_vala_code_node_unref0 (this_symbol);
							this_symbol = _tmp1089_;
						}
						_tmp1085_ = FALSE;
						_tmp1090_ = this_symbol;
						if (!(_tmp1090_ != NULL)) {
							break;
						}
						_tmp1091_ = target_type;
						_tmp1092_ = this_symbol;
						if (_tmp1091_ == _tmp1092_) {
							in_target_type = TRUE;
							break;
						}
					}
				}
				_vala_code_node_unref0 (this_symbol);
			}
			_tmp1093_ = in_target_type;
			if (!_tmp1093_) {
				ValaSourceReference* _tmp1094_;
				ValaSourceReference* _tmp1095_;
				ValaSymbol* _tmp1096_;
				gchar* _tmp1097_;
				gchar* _tmp1098_;
				gchar* _tmp1099_;
				gchar* _tmp1100_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp1094_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1095_ = _tmp1094_;
				_tmp1096_ = member;
				_tmp1097_ = vala_symbol_get_full_name (_tmp1096_);
				_tmp1098_ = _tmp1097_;
				_tmp1099_ = g_strdup_printf ("Access to private member `%s' denied", _tmp1098_);
				_tmp1100_ = _tmp1099_;
				vala_report_error (_tmp1095_, _tmp1100_);
				_g_free0 (_tmp1100_);
				_g_free0 (_tmp1098_);
				result = FALSE;
				_vala_code_node_unref0 (target_type);
				_vala_code_node_unref0 (member);
				_vala_code_node_unref0 (this_parameter);
				_vala_code_node_unref0 (base_symbol);
				return result;
			}
			_vala_code_node_unref0 (target_type);
		}
	}
	_tmp1102_ = generics;
	if (_tmp1102_) {
		ValaExpression* _tmp1103_;
		ValaExpression* _tmp1104_;
		_tmp1103_ = vala_member_access_get_inner (self);
		_tmp1104_ = _tmp1103_;
		_tmp1101_ = _tmp1104_ != NULL;
	} else {
		_tmp1101_ = FALSE;
	}
	if (_tmp1101_) {
		ValaDataType* instance_type = NULL;
		ValaExpression* _tmp1105_;
		ValaExpression* _tmp1106_;
		ValaDataType* _tmp1107_;
		ValaDataType* _tmp1108_;
		ValaDataType* _tmp1109_;
		ValaPointerType* pointer_type = NULL;
		ValaExpression* _tmp1110_;
		ValaExpression* _tmp1111_;
		ValaDataType* _tmp1112_;
		ValaDataType* _tmp1113_;
		ValaPointerType* _tmp1114_;
		ValaPointerType* _tmp1115_;
		ValaObjectType* object_type = NULL;
		ValaDataType* _tmp1120_;
		ValaObjectType* _tmp1121_;
		gboolean _tmp1122_ = FALSE;
		gboolean _tmp1123_ = FALSE;
		ValaObjectType* _tmp1124_;
		_tmp1105_ = vala_member_access_get_inner (self);
		_tmp1106_ = _tmp1105_;
		_tmp1107_ = vala_expression_get_value_type (_tmp1106_);
		_tmp1108_ = _tmp1107_;
		_tmp1109_ = _vala_code_node_ref0 (_tmp1108_);
		instance_type = _tmp1109_;
		_tmp1110_ = vala_member_access_get_inner (self);
		_tmp1111_ = _tmp1110_;
		_tmp1112_ = vala_expression_get_value_type (_tmp1111_);
		_tmp1113_ = _tmp1112_;
		_tmp1114_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1113_, VALA_TYPE_POINTER_TYPE) ? ((ValaPointerType*) _tmp1113_) : NULL);
		pointer_type = _tmp1114_;
		_tmp1115_ = pointer_type;
		if (_tmp1115_ != NULL) {
			ValaPointerType* _tmp1116_;
			ValaDataType* _tmp1117_;
			ValaDataType* _tmp1118_;
			ValaDataType* _tmp1119_;
			_tmp1116_ = pointer_type;
			_tmp1117_ = vala_pointer_type_get_base_type (_tmp1116_);
			_tmp1118_ = _tmp1117_;
			_tmp1119_ = _vala_code_node_ref0 (_tmp1118_);
			_vala_code_node_unref0 (instance_type);
			instance_type = _tmp1119_;
		}
		_tmp1120_ = instance_type;
		_tmp1121_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1120_, VALA_TYPE_OBJECT_TYPE) ? ((ValaObjectType*) _tmp1120_) : NULL);
		object_type = _tmp1121_;
		_tmp1124_ = object_type;
		if (_tmp1124_ != NULL) {
			ValaObjectType* _tmp1125_;
			ValaObjectTypeSymbol* _tmp1126_;
			ValaObjectTypeSymbol* _tmp1127_;
			ValaList* _tmp1128_;
			ValaList* _tmp1129_;
			gint _tmp1130_;
			gint _tmp1131_;
			_tmp1125_ = object_type;
			_tmp1126_ = vala_object_type_get_type_symbol (_tmp1125_);
			_tmp1127_ = _tmp1126_;
			_tmp1128_ = vala_object_type_symbol_get_type_parameters (_tmp1127_);
			_tmp1129_ = _tmp1128_;
			_tmp1130_ = vala_collection_get_size ((ValaCollection*) _tmp1129_);
			_tmp1131_ = _tmp1130_;
			_tmp1123_ = _tmp1131_ > 0;
			_vala_iterable_unref0 (_tmp1129_);
		} else {
			_tmp1123_ = FALSE;
		}
		if (_tmp1123_) {
			ValaDataType* _tmp1132_;
			ValaList* _tmp1133_;
			ValaList* _tmp1134_;
			gint _tmp1135_;
			gint _tmp1136_;
			_tmp1132_ = instance_type;
			_tmp1133_ = vala_data_type_get_type_arguments (_tmp1132_);
			_tmp1134_ = _tmp1133_;
			_tmp1135_ = vala_collection_get_size ((ValaCollection*) _tmp1134_);
			_tmp1136_ = _tmp1135_;
			_tmp1122_ = _tmp1136_ == 0;
			_vala_iterable_unref0 (_tmp1134_);
		} else {
			_tmp1122_ = FALSE;
		}
		if (_tmp1122_) {
			ValaExpression* _tmp1137_;
			ValaExpression* _tmp1138_;
			ValaSourceReference* _tmp1139_;
			ValaSourceReference* _tmp1140_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp1137_ = vala_member_access_get_inner (self);
			_tmp1138_ = _tmp1137_;
			_tmp1139_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1138_);
			_tmp1140_ = _tmp1139_;
			vala_report_error (_tmp1140_, "missing generic type arguments");
			result = FALSE;
			_vala_code_node_unref0 (object_type);
			_vala_code_node_unref0 (pointer_type);
			_vala_code_node_unref0 (instance_type);
			_vala_code_node_unref0 (member);
			_vala_code_node_unref0 (this_parameter);
			_vala_code_node_unref0 (base_symbol);
			return result;
		}
		_vala_code_node_unref0 (object_type);
		_vala_code_node_unref0 (pointer_type);
		_vala_code_node_unref0 (instance_type);
	}
	_tmp1143_ = instance;
	if (_tmp1143_) {
		gboolean _tmp1144_;
		_tmp1144_ = may_access_instance_members;
		_tmp1142_ = !_tmp1144_;
	} else {
		_tmp1142_ = FALSE;
	}
	if (_tmp1142_) {
		_tmp1141_ = TRUE;
	} else {
		gboolean _tmp1145_ = FALSE;
		gboolean _tmp1146_;
		_tmp1146_ = klass;
		if (_tmp1146_) {
			gboolean _tmp1147_;
			_tmp1147_ = may_access_klass_members;
			_tmp1145_ = !_tmp1147_;
		} else {
			_tmp1145_ = FALSE;
		}
		_tmp1141_ = _tmp1145_;
	}
	if (_tmp1141_) {
		ValaSymbol* _tmp1148_;
		ValaSymbol* _tmp1149_;
		ValaDataType* _tmp1166_;
		ValaDataType* _tmp1167_;
		vala_member_access_set_prototype_access (self, TRUE);
		_tmp1148_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1149_ = _tmp1148_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1149_, VALA_TYPE_METHOD)) {
			ValaSemanticAnalyzer* _tmp1150_;
			ValaSemanticAnalyzer* _tmp1151_;
			ValaSymbol* _tmp1152_;
			ValaSymbol* _tmp1153_;
			gboolean _tmp1154_;
			gboolean _tmp1155_;
			ValaDataType* _tmp1156_;
			ValaDataType* _tmp1157_;
			_tmp1150_ = vala_code_context_get_analyzer (context);
			_tmp1151_ = _tmp1150_;
			_tmp1152_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1153_ = _tmp1152_;
			_tmp1154_ = vala_expression_get_lvalue ((ValaExpression*) self);
			_tmp1155_ = _tmp1154_;
			_tmp1156_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp1151_, _tmp1153_, _tmp1155_);
			_tmp1157_ = _tmp1156_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1157_);
			_vala_code_node_unref0 (_tmp1157_);
		} else {
			ValaSymbol* _tmp1158_;
			ValaSymbol* _tmp1159_;
			_tmp1158_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1159_ = _tmp1158_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1159_, VALA_TYPE_FIELD)) {
				ValaSymbol* _tmp1160_;
				ValaSymbol* _tmp1161_;
				ValaFieldPrototype* _tmp1162_;
				ValaFieldPrototype* _tmp1163_;
				_tmp1160_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1161_ = _tmp1160_;
				_tmp1162_ = vala_field_prototype_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1161_, VALA_TYPE_FIELD, ValaField));
				_tmp1163_ = _tmp1162_;
				vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1163_);
				_vala_code_node_unref0 (_tmp1163_);
			} else {
				ValaInvalidType* _tmp1164_;
				ValaInvalidType* _tmp1165_;
				_tmp1164_ = vala_invalid_type_new ();
				_tmp1165_ = _tmp1164_;
				vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1165_);
				_vala_code_node_unref0 (_tmp1165_);
			}
		}
		_tmp1166_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp1167_ = _tmp1166_;
		if (_tmp1167_ != NULL) {
			ValaDataType* _tmp1168_;
			ValaDataType* _tmp1169_;
			ValaDataType* _tmp1170_;
			ValaDataType* _tmp1171_;
			gboolean _tmp1172_;
			gboolean _tmp1173_;
			_tmp1168_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp1169_ = _tmp1168_;
			_tmp1170_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp1171_ = _tmp1170_;
			_tmp1172_ = vala_data_type_get_value_owned (_tmp1171_);
			_tmp1173_ = _tmp1172_;
			vala_data_type_set_value_owned (_tmp1169_, _tmp1173_);
		}
	} else {
		gboolean _tmp1174_ = FALSE;
		gboolean _tmp1175_;
		gboolean _tmp1196_ = FALSE;
		gboolean _tmp1197_ = FALSE;
		gboolean _tmp1198_ = FALSE;
		gboolean _tmp1199_ = FALSE;
		gboolean _tmp1200_;
		gboolean _tmp1219_ = FALSE;
		gboolean _tmp1220_ = FALSE;
		gboolean _tmp1221_ = FALSE;
		gboolean _tmp1222_ = FALSE;
		gboolean _tmp1223_ = FALSE;
		gboolean _tmp1224_;
		gboolean _tmp1225_;
		ValaMethod* m = NULL;
		ValaSymbol* _tmp1253_;
		ValaSymbol* _tmp1254_;
		ValaMethod* _tmp1255_;
		ValaMemberAccess* inner_ma = NULL;
		ValaExpression* _tmp1256_;
		ValaExpression* _tmp1257_;
		ValaMemberAccess* _tmp1258_;
		gboolean _tmp1259_ = FALSE;
		gboolean _tmp1260_ = FALSE;
		gboolean _tmp1261_ = FALSE;
		gboolean _tmp1262_ = FALSE;
		gboolean _tmp1263_ = FALSE;
		ValaMethod* _tmp1264_;
		ValaSemanticAnalyzer* _tmp1305_;
		ValaSemanticAnalyzer* _tmp1306_;
		ValaSymbol* _tmp1307_;
		ValaSymbol* _tmp1308_;
		gboolean _tmp1309_;
		gboolean _tmp1310_;
		ValaDataType* _tmp1311_;
		ValaDataType* _tmp1312_;
		gboolean _tmp1313_ = FALSE;
		ValaExpression* _tmp1314_;
		ValaExpression* _tmp1315_;
		ValaSymbol* _tmp1328_;
		ValaSymbol* _tmp1329_;
		_tmp1175_ = instance;
		if (_tmp1175_) {
			ValaExpression* _tmp1176_;
			ValaExpression* _tmp1177_;
			_tmp1176_ = vala_member_access_get_inner (self);
			_tmp1177_ = _tmp1176_;
			_tmp1174_ = _tmp1177_ == NULL;
		} else {
			_tmp1174_ = FALSE;
		}
		if (_tmp1174_) {
			ValaSourceReference* _tmp1178_;
			ValaSourceReference* _tmp1179_;
			ValaMemberAccess* _tmp1180_;
			ValaMemberAccess* _tmp1181_;
			ValaExpression* _tmp1182_;
			ValaExpression* _tmp1183_;
			ValaParameter* _tmp1184_;
			ValaDataType* _tmp1185_;
			ValaDataType* _tmp1186_;
			ValaDataType* _tmp1187_;
			ValaDataType* _tmp1188_;
			ValaExpression* _tmp1189_;
			ValaExpression* _tmp1190_;
			ValaDataType* _tmp1191_;
			ValaDataType* _tmp1192_;
			ValaExpression* _tmp1193_;
			ValaExpression* _tmp1194_;
			ValaParameter* _tmp1195_;
			_tmp1178_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1179_ = _tmp1178_;
			_tmp1180_ = vala_member_access_new (NULL, "this", _tmp1179_);
			_tmp1181_ = _tmp1180_;
			vala_member_access_set_inner (self, (ValaExpression*) _tmp1181_);
			_vala_code_node_unref0 (_tmp1181_);
			_tmp1182_ = vala_member_access_get_inner (self);
			_tmp1183_ = _tmp1182_;
			_tmp1184_ = this_parameter;
			_tmp1185_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1184_);
			_tmp1186_ = _tmp1185_;
			_tmp1187_ = vala_data_type_copy (_tmp1186_);
			_tmp1188_ = _tmp1187_;
			vala_expression_set_value_type (_tmp1183_, _tmp1188_);
			_vala_code_node_unref0 (_tmp1188_);
			_tmp1189_ = vala_member_access_get_inner (self);
			_tmp1190_ = _tmp1189_;
			_tmp1191_ = vala_expression_get_value_type (_tmp1190_);
			_tmp1192_ = _tmp1191_;
			vala_data_type_set_value_owned (_tmp1192_, FALSE);
			_tmp1193_ = vala_member_access_get_inner (self);
			_tmp1194_ = _tmp1193_;
			_tmp1195_ = this_parameter;
			vala_expression_set_symbol_reference (_tmp1194_, (ValaSymbol*) _tmp1195_);
		} else {
			vala_member_access_check_lvalue_access (self);
		}
		_tmp1200_ = instance;
		if (!_tmp1200_) {
			gboolean _tmp1201_;
			_tmp1201_ = klass;
			_tmp1199_ = !_tmp1201_;
		} else {
			_tmp1199_ = FALSE;
		}
		if (_tmp1199_) {
			ValaSymbol* _tmp1202_;
			ValaSymbol* _tmp1203_;
			_tmp1202_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1203_ = _tmp1202_;
			_tmp1198_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1203_, VALA_TYPE_CREATION_METHOD);
		} else {
			_tmp1198_ = FALSE;
		}
		if (_tmp1198_) {
			gboolean _tmp1204_;
			_tmp1204_ = may_access_instance_members;
			_tmp1197_ = _tmp1204_;
		} else {
			_tmp1197_ = FALSE;
		}
		if (_tmp1197_) {
			ValaExpression* _tmp1205_;
			ValaExpression* _tmp1206_;
			_tmp1205_ = vala_member_access_get_inner (self);
			_tmp1206_ = _tmp1205_;
			_tmp1196_ = _tmp1206_ != NULL;
		} else {
			_tmp1196_ = FALSE;
		}
		if (_tmp1196_) {
			ValaExpression* _tmp1207_;
			ValaExpression* _tmp1208_;
			ValaSymbol* _tmp1209_;
			ValaSymbol* _tmp1210_;
			_tmp1207_ = vala_member_access_get_inner (self);
			_tmp1208_ = _tmp1207_;
			_tmp1209_ = vala_expression_get_symbol_reference (_tmp1208_);
			_tmp1210_ = _tmp1209_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1210_, VALA_TYPE_METHOD)) {
			} else {
				ValaSourceReference* _tmp1211_;
				ValaSourceReference* _tmp1212_;
				ValaSymbol* _tmp1213_;
				ValaSymbol* _tmp1214_;
				gchar* _tmp1215_;
				gchar* _tmp1216_;
				gchar* _tmp1217_;
				gchar* _tmp1218_;
				_tmp1211_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1212_ = _tmp1211_;
				_tmp1213_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1214_ = _tmp1213_;
				_tmp1215_ = vala_symbol_get_full_name (_tmp1214_);
				_tmp1216_ = _tmp1215_;
				_tmp1217_ = g_strdup_printf ("Access to static member `%s' with an instance reference", _tmp1216_);
				_tmp1218_ = _tmp1217_;
				vala_report_warning (_tmp1212_, _tmp1218_);
				_g_free0 (_tmp1218_);
				_g_free0 (_tmp1216_);
			}
		}
		_tmp1224_ = vala_code_context_get_experimental_non_null (context);
		_tmp1225_ = _tmp1224_;
		if (_tmp1225_) {
			gboolean _tmp1226_;
			_tmp1226_ = instance;
			_tmp1223_ = _tmp1226_;
		} else {
			_tmp1223_ = FALSE;
		}
		if (_tmp1223_) {
			ValaExpression* _tmp1227_;
			ValaExpression* _tmp1228_;
			ValaDataType* _tmp1229_;
			ValaDataType* _tmp1230_;
			gboolean _tmp1231_;
			gboolean _tmp1232_;
			_tmp1227_ = vala_member_access_get_inner (self);
			_tmp1228_ = _tmp1227_;
			_tmp1229_ = vala_expression_get_value_type (_tmp1228_);
			_tmp1230_ = _tmp1229_;
			_tmp1231_ = vala_data_type_get_nullable (_tmp1230_);
			_tmp1232_ = _tmp1231_;
			_tmp1222_ = _tmp1232_;
		} else {
			_tmp1222_ = FALSE;
		}
		if (_tmp1222_) {
			ValaExpression* _tmp1233_;
			ValaExpression* _tmp1234_;
			ValaDataType* _tmp1235_;
			ValaDataType* _tmp1236_;
			_tmp1233_ = vala_member_access_get_inner (self);
			_tmp1234_ = _tmp1233_;
			_tmp1235_ = vala_expression_get_value_type (_tmp1234_);
			_tmp1236_ = _tmp1235_;
			_tmp1221_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1236_, VALA_TYPE_POINTER_TYPE);
		} else {
			_tmp1221_ = FALSE;
		}
		if (_tmp1221_) {
			ValaExpression* _tmp1237_;
			ValaExpression* _tmp1238_;
			ValaDataType* _tmp1239_;
			ValaDataType* _tmp1240_;
			_tmp1237_ = vala_member_access_get_inner (self);
			_tmp1238_ = _tmp1237_;
			_tmp1239_ = vala_expression_get_value_type (_tmp1238_);
			_tmp1240_ = _tmp1239_;
			_tmp1220_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1240_, VALA_TYPE_GENERIC_TYPE);
		} else {
			_tmp1220_ = FALSE;
		}
		if (_tmp1220_) {
			ValaExpression* _tmp1241_;
			ValaExpression* _tmp1242_;
			ValaDataType* _tmp1243_;
			ValaDataType* _tmp1244_;
			_tmp1241_ = vala_member_access_get_inner (self);
			_tmp1242_ = _tmp1241_;
			_tmp1243_ = vala_expression_get_value_type (_tmp1242_);
			_tmp1244_ = _tmp1243_;
			_tmp1219_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1244_, VALA_TYPE_ARRAY_TYPE);
		} else {
			_tmp1219_ = FALSE;
		}
		if (_tmp1219_) {
			ValaSourceReference* _tmp1245_;
			ValaSourceReference* _tmp1246_;
			ValaSymbol* _tmp1247_;
			ValaSymbol* _tmp1248_;
			gchar* _tmp1249_;
			gchar* _tmp1250_;
			gchar* _tmp1251_;
			gchar* _tmp1252_;
			_tmp1245_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1246_ = _tmp1245_;
			_tmp1247_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1248_ = _tmp1247_;
			_tmp1249_ = vala_symbol_get_full_name (_tmp1248_);
			_tmp1250_ = _tmp1249_;
			_tmp1251_ = g_strdup_printf ("Access to instance member `%s' from nullable reference denied", _tmp1250_);
			_tmp1252_ = _tmp1251_;
			vala_report_error (_tmp1246_, _tmp1252_);
			_g_free0 (_tmp1252_);
			_g_free0 (_tmp1250_);
		}
		_tmp1253_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1254_ = _tmp1253_;
		_tmp1255_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1254_, VALA_TYPE_METHOD) ? ((ValaMethod*) _tmp1254_) : NULL);
		m = _tmp1255_;
		_tmp1256_ = vala_member_access_get_inner (self);
		_tmp1257_ = _tmp1256_;
		_tmp1258_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1257_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp1257_) : NULL);
		inner_ma = _tmp1258_;
		_tmp1264_ = m;
		if (_tmp1264_ != NULL) {
			ValaMethod* _tmp1265_;
			ValaMemberBinding _tmp1266_;
			ValaMemberBinding _tmp1267_;
			_tmp1265_ = m;
			_tmp1266_ = vala_method_get_binding (_tmp1265_);
			_tmp1267_ = _tmp1266_;
			_tmp1263_ = _tmp1267_ == VALA_MEMBER_BINDING_STATIC;
		} else {
			_tmp1263_ = FALSE;
		}
		if (_tmp1263_) {
			ValaMethod* _tmp1268_;
			ValaSymbol* _tmp1269_;
			ValaSymbol* _tmp1270_;
			_tmp1268_ = m;
			_tmp1269_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1268_);
			_tmp1270_ = _tmp1269_;
			_tmp1262_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1270_, VALA_TYPE_OBJECT_TYPE_SYMBOL);
		} else {
			_tmp1262_ = FALSE;
		}
		if (_tmp1262_) {
			ValaExpression* _tmp1271_;
			ValaExpression* _tmp1272_;
			_tmp1271_ = vala_member_access_get_inner (self);
			_tmp1272_ = _tmp1271_;
			_tmp1261_ = _tmp1272_ != NULL;
		} else {
			_tmp1261_ = FALSE;
		}
		if (_tmp1261_) {
			ValaExpression* _tmp1273_;
			ValaExpression* _tmp1274_;
			ValaDataType* _tmp1275_;
			ValaDataType* _tmp1276_;
			_tmp1273_ = vala_member_access_get_inner (self);
			_tmp1274_ = _tmp1273_;
			_tmp1275_ = vala_expression_get_value_type (_tmp1274_);
			_tmp1276_ = _tmp1275_;
			_tmp1260_ = _tmp1276_ == NULL;
		} else {
			_tmp1260_ = FALSE;
		}
		if (_tmp1260_) {
			ValaMemberAccess* _tmp1277_;
			ValaList* _tmp1278_;
			gint _tmp1279_;
			gint _tmp1280_;
			_tmp1277_ = inner_ma;
			_tmp1278_ = _tmp1277_->priv->type_argument_list;
			_tmp1279_ = vala_collection_get_size ((ValaCollection*) _tmp1278_);
			_tmp1280_ = _tmp1279_;
			_tmp1259_ = _tmp1280_ > 0;
		} else {
			_tmp1259_ = FALSE;
		}
		if (_tmp1259_) {
			ValaExpression* _tmp1281_;
			ValaExpression* _tmp1282_;
			ValaMethod* _tmp1283_;
			ValaSymbol* _tmp1284_;
			ValaSymbol* _tmp1285_;
			ValaObjectType* _tmp1286_;
			ValaObjectType* _tmp1287_;
			_tmp1281_ = vala_member_access_get_inner (self);
			_tmp1282_ = _tmp1281_;
			_tmp1283_ = m;
			_tmp1284_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1283_);
			_tmp1285_ = _tmp1284_;
			_tmp1286_ = vala_object_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1285_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
			_tmp1287_ = _tmp1286_;
			vala_expression_set_value_type (_tmp1282_, (ValaDataType*) _tmp1287_);
			_vala_code_node_unref0 (_tmp1287_);
			{
				ValaList* _type_argument_list = NULL;
				ValaMemberAccess* _tmp1288_;
				ValaList* _tmp1289_;
				ValaList* _tmp1290_;
				gint _type_argument_size = 0;
				ValaList* _tmp1291_;
				gint _tmp1292_;
				gint _tmp1293_;
				gint _type_argument_index = 0;
				_tmp1288_ = inner_ma;
				_tmp1289_ = _tmp1288_->priv->type_argument_list;
				_tmp1290_ = _vala_iterable_ref0 (_tmp1289_);
				_type_argument_list = _tmp1290_;
				_tmp1291_ = _type_argument_list;
				_tmp1292_ = vala_collection_get_size ((ValaCollection*) _tmp1291_);
				_tmp1293_ = _tmp1292_;
				_type_argument_size = _tmp1293_;
				_type_argument_index = -1;
				while (TRUE) {
					gint _tmp1294_;
					gint _tmp1295_;
					gint _tmp1296_;
					ValaDataType* type_argument = NULL;
					ValaList* _tmp1297_;
					gint _tmp1298_;
					gpointer _tmp1299_;
					ValaExpression* _tmp1300_;
					ValaExpression* _tmp1301_;
					ValaDataType* _tmp1302_;
					ValaDataType* _tmp1303_;
					ValaDataType* _tmp1304_;
					_tmp1294_ = _type_argument_index;
					_type_argument_index = _tmp1294_ + 1;
					_tmp1295_ = _type_argument_index;
					_tmp1296_ = _type_argument_size;
					if (!(_tmp1295_ < _tmp1296_)) {
						break;
					}
					_tmp1297_ = _type_argument_list;
					_tmp1298_ = _type_argument_index;
					_tmp1299_ = vala_list_get (_tmp1297_, _tmp1298_);
					type_argument = (ValaDataType*) _tmp1299_;
					_tmp1300_ = vala_member_access_get_inner (self);
					_tmp1301_ = _tmp1300_;
					_tmp1302_ = vala_expression_get_value_type (_tmp1301_);
					_tmp1303_ = _tmp1302_;
					_tmp1304_ = type_argument;
					vala_data_type_add_type_argument (_tmp1303_, _tmp1304_);
					_vala_code_node_unref0 (type_argument);
				}
				_vala_iterable_unref0 (_type_argument_list);
			}
		}
		_tmp1305_ = vala_code_context_get_analyzer (context);
		_tmp1306_ = _tmp1305_;
		_tmp1307_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1308_ = _tmp1307_;
		_tmp1309_ = vala_expression_get_lvalue ((ValaExpression*) self);
		_tmp1310_ = _tmp1309_;
		_tmp1311_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp1306_, _tmp1308_, _tmp1310_);
		_tmp1312_ = _tmp1311_;
		vala_expression_set_formal_value_type ((ValaExpression*) self, _tmp1312_);
		_vala_code_node_unref0 (_tmp1312_);
		_tmp1314_ = vala_member_access_get_inner (self);
		_tmp1315_ = _tmp1314_;
		if (_tmp1315_ != NULL) {
			ValaDataType* _tmp1316_;
			ValaDataType* _tmp1317_;
			_tmp1316_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1317_ = _tmp1316_;
			_tmp1313_ = _tmp1317_ != NULL;
		} else {
			_tmp1313_ = FALSE;
		}
		if (_tmp1313_) {
			ValaDataType* _tmp1318_;
			ValaDataType* _tmp1319_;
			ValaExpression* _tmp1320_;
			ValaExpression* _tmp1321_;
			ValaDataType* _tmp1322_;
			ValaDataType* _tmp1323_;
			ValaDataType* _tmp1324_;
			ValaDataType* _tmp1325_;
			_tmp1318_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1319_ = _tmp1318_;
			_tmp1320_ = vala_member_access_get_inner (self);
			_tmp1321_ = _tmp1320_;
			_tmp1322_ = vala_expression_get_value_type (_tmp1321_);
			_tmp1323_ = _tmp1322_;
			_tmp1324_ = vala_data_type_get_actual_type (_tmp1319_, _tmp1323_, NULL, (ValaCodeNode*) self);
			_tmp1325_ = _tmp1324_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1325_);
			_vala_code_node_unref0 (_tmp1325_);
		} else {
			ValaDataType* _tmp1326_;
			ValaDataType* _tmp1327_;
			_tmp1326_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1327_ = _tmp1326_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1327_);
		}
		_tmp1328_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1329_ = _tmp1328_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1329_, VALA_TYPE_METHOD)) {
			ValaMethod* method = NULL;
			ValaSymbol* _tmp1330_;
			ValaSymbol* _tmp1331_;
			ValaMethod* _tmp1332_;
			ValaDataType* _tmp1333_;
			ValaDataType* _tmp1334_;
			gboolean _tmp1341_ = FALSE;
			gboolean _tmp1342_;
			_tmp1330_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1331_ = _tmp1330_;
			_tmp1332_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1331_, VALA_TYPE_METHOD, ValaMethod));
			method = _tmp1332_;
			_tmp1333_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp1334_ = _tmp1333_;
			if (_tmp1334_ != NULL) {
				ValaDataType* _tmp1335_;
				ValaDataType* _tmp1336_;
				ValaDataType* _tmp1337_;
				ValaDataType* _tmp1338_;
				gboolean _tmp1339_;
				gboolean _tmp1340_;
				_tmp1335_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp1336_ = _tmp1335_;
				_tmp1337_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp1338_ = _tmp1337_;
				_tmp1339_ = vala_data_type_get_value_owned (_tmp1338_);
				_tmp1340_ = _tmp1339_;
				vala_data_type_set_value_owned (_tmp1336_, _tmp1340_);
			}
			_tmp1342_ = instance;
			if (_tmp1342_) {
				ValaMethod* _tmp1343_;
				ValaSymbol* _tmp1344_;
				ValaSymbol* _tmp1345_;
				_tmp1343_ = method;
				_tmp1344_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1343_);
				_tmp1345_ = _tmp1344_;
				_tmp1341_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1345_, VALA_TYPE_TYPESYMBOL);
			} else {
				_tmp1341_ = FALSE;
			}
			if (_tmp1341_) {
				ValaExpression* _tmp1346_;
				ValaExpression* _tmp1347_;
				ValaMethod* _tmp1348_;
				ValaSymbol* _tmp1349_;
				ValaSymbol* _tmp1350_;
				ValaDataType* _tmp1351_;
				ValaDataType* _tmp1352_;
				ValaExpression* _tmp1353_;
				ValaExpression* _tmp1354_;
				ValaDataType* _tmp1355_;
				ValaDataType* _tmp1356_;
				ValaMethod* _tmp1357_;
				ValaParameter* _tmp1358_;
				ValaParameter* _tmp1359_;
				ValaDataType* _tmp1360_;
				ValaDataType* _tmp1361_;
				gboolean _tmp1362_;
				gboolean _tmp1363_;
				_tmp1346_ = vala_member_access_get_inner (self);
				_tmp1347_ = _tmp1346_;
				_tmp1348_ = method;
				_tmp1349_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1348_);
				_tmp1350_ = _tmp1349_;
				_tmp1351_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1350_);
				_tmp1352_ = _tmp1351_;
				vala_expression_set_target_type (_tmp1347_, _tmp1352_);
				_vala_code_node_unref0 (_tmp1352_);
				_tmp1353_ = vala_member_access_get_inner (self);
				_tmp1354_ = _tmp1353_;
				_tmp1355_ = vala_expression_get_target_type (_tmp1354_);
				_tmp1356_ = _tmp1355_;
				_tmp1357_ = method;
				_tmp1358_ = vala_method_get_this_parameter (_tmp1357_);
				_tmp1359_ = _tmp1358_;
				_tmp1360_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1359_);
				_tmp1361_ = _tmp1360_;
				_tmp1362_ = vala_data_type_get_value_owned (_tmp1361_);
				_tmp1363_ = _tmp1362_;
				vala_data_type_set_value_owned (_tmp1356_, _tmp1363_);
			}
			_vala_code_node_unref0 (method);
		} else {
			ValaSymbol* _tmp1364_;
			ValaSymbol* _tmp1365_;
			_tmp1364_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1365_ = _tmp1364_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1365_, VALA_TYPE_PROPERTY)) {
				ValaProperty* prop = NULL;
				ValaSymbol* _tmp1366_;
				ValaSymbol* _tmp1367_;
				ValaProperty* _tmp1368_;
				gboolean _tmp1369_ = FALSE;
				gboolean _tmp1370_;
				_tmp1366_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1367_ = _tmp1366_;
				_tmp1368_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1367_, VALA_TYPE_PROPERTY, ValaProperty));
				prop = _tmp1368_;
				_tmp1370_ = instance;
				if (_tmp1370_) {
					ValaProperty* _tmp1371_;
					ValaSymbol* _tmp1372_;
					ValaSymbol* _tmp1373_;
					_tmp1371_ = prop;
					_tmp1372_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1371_);
					_tmp1373_ = _tmp1372_;
					_tmp1369_ = _tmp1373_ != NULL;
				} else {
					_tmp1369_ = FALSE;
				}
				if (_tmp1369_) {
					ValaExpression* _tmp1374_;
					ValaExpression* _tmp1375_;
					ValaProperty* _tmp1376_;
					ValaSymbol* _tmp1377_;
					ValaSymbol* _tmp1378_;
					ValaDataType* _tmp1379_;
					ValaDataType* _tmp1380_;
					_tmp1374_ = vala_member_access_get_inner (self);
					_tmp1375_ = _tmp1374_;
					_tmp1376_ = prop;
					_tmp1377_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1376_);
					_tmp1378_ = _tmp1377_;
					_tmp1379_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1378_);
					_tmp1380_ = _tmp1379_;
					vala_expression_set_target_type (_tmp1375_, _tmp1380_);
					_vala_code_node_unref0 (_tmp1380_);
				}
				_vala_code_node_unref0 (prop);
			} else {
				gboolean _tmp1381_ = FALSE;
				gboolean _tmp1382_ = FALSE;
				gboolean _tmp1383_ = FALSE;
				ValaSymbol* _tmp1384_;
				ValaSymbol* _tmp1385_;
				_tmp1384_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1385_ = _tmp1384_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1385_, VALA_TYPE_FIELD)) {
					_tmp1383_ = TRUE;
				} else {
					ValaSymbol* _tmp1386_;
					ValaSymbol* _tmp1387_;
					_tmp1386_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1387_ = _tmp1386_;
					_tmp1383_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1387_, VALA_TYPE_SIGNAL);
				}
				if (_tmp1383_) {
					gboolean _tmp1388_;
					_tmp1388_ = instance;
					_tmp1382_ = _tmp1388_;
				} else {
					_tmp1382_ = FALSE;
				}
				if (_tmp1382_) {
					ValaSymbol* _tmp1389_;
					ValaSymbol* _tmp1390_;
					ValaSymbol* _tmp1391_;
					ValaSymbol* _tmp1392_;
					_tmp1389_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1390_ = _tmp1389_;
					_tmp1391_ = vala_symbol_get_parent_symbol (_tmp1390_);
					_tmp1392_ = _tmp1391_;
					_tmp1381_ = _tmp1392_ != NULL;
				} else {
					_tmp1381_ = FALSE;
				}
				if (_tmp1381_) {
					ValaDataType* parent_type = NULL;
					ValaSymbol* _tmp1393_;
					ValaSymbol* _tmp1394_;
					ValaSymbol* _tmp1395_;
					ValaSymbol* _tmp1396_;
					ValaDataType* _tmp1397_;
					ValaExpression* _tmp1398_;
					ValaExpression* _tmp1399_;
					ValaDataType* _tmp1400_;
					ValaExpression* _tmp1401_;
					ValaExpression* _tmp1402_;
					ValaDataType* _tmp1403_;
					ValaDataType* _tmp1404_;
					ValaDataType* _tmp1405_;
					ValaDataType* _tmp1406_;
					_tmp1393_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1394_ = _tmp1393_;
					_tmp1395_ = vala_symbol_get_parent_symbol (_tmp1394_);
					_tmp1396_ = _tmp1395_;
					_tmp1397_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1396_);
					parent_type = _tmp1397_;
					_tmp1398_ = vala_member_access_get_inner (self);
					_tmp1399_ = _tmp1398_;
					_tmp1400_ = parent_type;
					_tmp1401_ = vala_member_access_get_inner (self);
					_tmp1402_ = _tmp1401_;
					_tmp1403_ = vala_expression_get_value_type (_tmp1402_);
					_tmp1404_ = _tmp1403_;
					_tmp1405_ = vala_data_type_get_actual_type (_tmp1400_, _tmp1404_, NULL, (ValaCodeNode*) self);
					_tmp1406_ = _tmp1405_;
					vala_expression_set_target_type (_tmp1399_, _tmp1406_);
					_vala_code_node_unref0 (_tmp1406_);
					_vala_code_node_unref0 (parent_type);
				}
			}
		}
		_vala_code_node_unref0 (inner_ma);
		_vala_code_node_unref0 (m);
	}
	_tmp1407_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp1408_ = _tmp1407_;
	result = !_tmp1408_;
	_vala_code_node_unref0 (member);
	_vala_code_node_unref0 (this_parameter);
	_vala_code_node_unref0 (base_symbol);
	return result;
}


static gboolean
vala_member_access_is_instance_symbol (ValaSymbol* symbol)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (symbol != NULL, FALSE);
	if (G_TYPE_CHECK_INSTANCE_TYPE (symbol, VALA_TYPE_FIELD)) {
		ValaMemberBinding _tmp1_;
		ValaMemberBinding _tmp2_;
		_tmp1_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_FIELD, ValaField));
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	} else {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		if (G_TYPE_CHECK_INSTANCE_TYPE (symbol, VALA_TYPE_METHOD)) {
			_tmp4_ = !G_TYPE_CHECK_INSTANCE_TYPE (symbol, VALA_TYPE_CREATION_METHOD);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			ValaMemberBinding _tmp5_;
			ValaMemberBinding _tmp6_;
			_tmp5_ = vala_method_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_METHOD, ValaMethod));
			_tmp6_ = _tmp5_;
			_tmp3_ = _tmp6_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			result = TRUE;
			return result;
		} else {
			gboolean _tmp7_ = FALSE;
			if (G_TYPE_CHECK_INSTANCE_TYPE (symbol, VALA_TYPE_PROPERTY)) {
				ValaMemberBinding _tmp8_;
				ValaMemberBinding _tmp9_;
				_tmp8_ = vala_property_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_PROPERTY, ValaProperty));
				_tmp9_ = _tmp8_;
				_tmp7_ = _tmp9_ == VALA_MEMBER_BINDING_INSTANCE;
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				result = TRUE;
				return result;
			} else {
				if (G_TYPE_CHECK_INSTANCE_TYPE (symbol, VALA_TYPE_SIGNAL)) {
					result = TRUE;
					return result;
				} else {
					result = FALSE;
					return result;
				}
			}
		}
	}
}


void
vala_member_access_check_lvalue_access (ValaMemberAccess* self)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaSymbol* _tmp3_;
	ValaSymbol* _tmp4_;
	gboolean instance = FALSE;
	gboolean _tmp9_;
	gboolean _tmp17_;
	gboolean _tmp25_ = FALSE;
	ValaExpression* _tmp26_;
	ValaExpression* _tmp27_;
	ValaSymbol* _tmp28_;
	ValaSymbol* _tmp29_;
	gboolean this_access = FALSE;
	gboolean _tmp36_ = FALSE;
	gboolean _tmp37_ = FALSE;
	ValaExpression* _tmp38_;
	ValaExpression* _tmp39_;
	ValaDataType* _tmp40_;
	ValaDataType* _tmp41_;
	gboolean struct_or_array = FALSE;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp52_;
	ValaExpression* _tmp53_;
	ValaMemberAccess* _tmp54_;
	gboolean _tmp55_ = FALSE;
	gboolean _tmp56_ = FALSE;
	ValaMemberAccess* _tmp57_;
	gboolean _tmp66_ = FALSE;
	gboolean _tmp67_ = FALSE;
	gboolean _tmp68_ = FALSE;
	gboolean _tmp69_ = FALSE;
	gboolean _tmp70_;
	g_return_if_fail (self != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp4_ = _tmp3_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, VALA_TYPE_FIELD)) {
		ValaSymbol* _tmp5_;
		ValaSymbol* _tmp6_;
		ValaMemberBinding _tmp7_;
		ValaMemberBinding _tmp8_;
		_tmp5_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, VALA_TYPE_FIELD, ValaField));
		_tmp8_ = _tmp7_;
		_tmp2_ = _tmp8_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp2_ = FALSE;
	}
	instance = _tmp2_;
	_tmp9_ = instance;
	if (!_tmp9_) {
		gboolean _tmp10_ = FALSE;
		ValaSymbol* _tmp11_;
		ValaSymbol* _tmp12_;
		_tmp11_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp12_ = _tmp11_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, VALA_TYPE_METHOD)) {
			ValaSymbol* _tmp13_;
			ValaSymbol* _tmp14_;
			ValaMemberBinding _tmp15_;
			ValaMemberBinding _tmp16_;
			_tmp13_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp14_ = _tmp13_;
			_tmp15_ = vala_method_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, VALA_TYPE_METHOD, ValaMethod));
			_tmp16_ = _tmp15_;
			_tmp10_ = _tmp16_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp10_ = FALSE;
		}
		instance = _tmp10_;
	}
	_tmp17_ = instance;
	if (!_tmp17_) {
		gboolean _tmp18_ = FALSE;
		ValaSymbol* _tmp19_;
		ValaSymbol* _tmp20_;
		_tmp19_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp20_ = _tmp19_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp20_, VALA_TYPE_PROPERTY)) {
			ValaSymbol* _tmp21_;
			ValaSymbol* _tmp22_;
			ValaMemberBinding _tmp23_;
			ValaMemberBinding _tmp24_;
			_tmp21_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp22_ = _tmp21_;
			_tmp23_ = vala_property_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, VALA_TYPE_PROPERTY, ValaProperty));
			_tmp24_ = _tmp23_;
			_tmp18_ = _tmp24_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp18_ = FALSE;
		}
		instance = _tmp18_;
	}
	_tmp26_ = vala_member_access_get_inner (self);
	_tmp27_ = _tmp26_;
	_tmp28_ = vala_expression_get_symbol_reference (_tmp27_);
	_tmp29_ = _tmp28_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp29_, VALA_TYPE_PARAMETER)) {
		ValaExpression* _tmp30_;
		ValaExpression* _tmp31_;
		ValaSymbol* _tmp32_;
		ValaSymbol* _tmp33_;
		const gchar* _tmp34_;
		const gchar* _tmp35_;
		_tmp30_ = vala_member_access_get_inner (self);
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_expression_get_symbol_reference (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp34_ = vala_symbol_get_name (_tmp33_);
		_tmp35_ = _tmp34_;
		_tmp25_ = g_strcmp0 (_tmp35_, "this") == 0;
	} else {
		_tmp25_ = FALSE;
	}
	this_access = _tmp25_;
	_tmp38_ = vala_member_access_get_inner (self);
	_tmp39_ = _tmp38_;
	_tmp40_ = vala_expression_get_value_type (_tmp39_);
	_tmp41_ = _tmp40_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp41_, VALA_TYPE_STRUCT_VALUE_TYPE)) {
		ValaExpression* _tmp42_;
		ValaExpression* _tmp43_;
		ValaDataType* _tmp44_;
		ValaDataType* _tmp45_;
		gboolean _tmp46_;
		gboolean _tmp47_;
		_tmp42_ = vala_member_access_get_inner (self);
		_tmp43_ = _tmp42_;
		_tmp44_ = vala_expression_get_value_type (_tmp43_);
		_tmp45_ = _tmp44_;
		_tmp46_ = vala_data_type_get_nullable (_tmp45_);
		_tmp47_ = _tmp46_;
		_tmp37_ = !_tmp47_;
	} else {
		_tmp37_ = FALSE;
	}
	if (_tmp37_) {
		_tmp36_ = TRUE;
	} else {
		ValaExpression* _tmp48_;
		ValaExpression* _tmp49_;
		ValaDataType* _tmp50_;
		ValaDataType* _tmp51_;
		_tmp48_ = vala_member_access_get_inner (self);
		_tmp49_ = _tmp48_;
		_tmp50_ = vala_expression_get_value_type (_tmp49_);
		_tmp51_ = _tmp50_;
		_tmp36_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp51_, VALA_TYPE_ARRAY_TYPE);
	}
	struct_or_array = _tmp36_;
	_tmp52_ = vala_member_access_get_inner (self);
	_tmp53_ = _tmp52_;
	_tmp54_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp53_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp53_) : NULL);
	ma = _tmp54_;
	_tmp57_ = ma;
	if (_tmp57_ == NULL) {
		gboolean _tmp58_;
		_tmp58_ = struct_or_array;
		_tmp56_ = _tmp58_;
	} else {
		_tmp56_ = FALSE;
	}
	if (_tmp56_) {
		ValaExpression* _tmp59_;
		ValaExpression* _tmp60_;
		_tmp59_ = vala_member_access_get_inner (self);
		_tmp60_ = _tmp59_;
		_tmp55_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp60_, VALA_TYPE_POINTER_INDIRECTION);
	} else {
		_tmp55_ = FALSE;
	}
	if (_tmp55_) {
		ValaExpression* _tmp61_;
		ValaExpression* _tmp62_;
		ValaExpression* _tmp63_;
		ValaExpression* _tmp64_;
		ValaMemberAccess* _tmp65_;
		_tmp61_ = vala_member_access_get_inner (self);
		_tmp62_ = _tmp61_;
		_tmp63_ = vala_pointer_indirection_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp62_, VALA_TYPE_POINTER_INDIRECTION, ValaPointerIndirection));
		_tmp64_ = _tmp63_;
		_tmp65_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp64_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp64_) : NULL);
		_vala_code_node_unref0 (ma);
		ma = _tmp65_;
	}
	_tmp70_ = instance;
	if (_tmp70_) {
		gboolean _tmp71_;
		_tmp71_ = struct_or_array;
		_tmp69_ = _tmp71_;
	} else {
		_tmp69_ = FALSE;
	}
	if (_tmp69_) {
		gboolean _tmp72_ = FALSE;
		ValaSymbol* _tmp73_;
		ValaSymbol* _tmp74_;
		_tmp73_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp74_ = _tmp73_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp74_, VALA_TYPE_METHOD)) {
			_tmp72_ = TRUE;
		} else {
			gboolean _tmp75_;
			gboolean _tmp76_;
			_tmp75_ = vala_expression_get_lvalue ((ValaExpression*) self);
			_tmp76_ = _tmp75_;
			_tmp72_ = _tmp76_;
		}
		_tmp68_ = _tmp72_;
	} else {
		_tmp68_ = FALSE;
	}
	if (_tmp68_) {
		gboolean _tmp77_ = FALSE;
		gboolean _tmp78_ = FALSE;
		ValaMemberAccess* _tmp79_;
		_tmp79_ = ma;
		if (_tmp79_ != NULL) {
			ValaMemberAccess* _tmp80_;
			ValaSymbol* _tmp81_;
			ValaSymbol* _tmp82_;
			_tmp80_ = ma;
			_tmp81_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp80_);
			_tmp82_ = _tmp81_;
			_tmp78_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp82_, VALA_TYPE_VARIABLE);
		} else {
			_tmp78_ = FALSE;
		}
		if (_tmp78_) {
			_tmp77_ = TRUE;
		} else {
			ValaExpression* _tmp83_;
			ValaExpression* _tmp84_;
			_tmp83_ = vala_member_access_get_inner (self);
			_tmp84_ = _tmp83_;
			_tmp77_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp84_, VALA_TYPE_ELEMENT_ACCESS);
		}
		_tmp67_ = _tmp77_;
	} else {
		_tmp67_ = FALSE;
	}
	if (_tmp67_) {
		gboolean _tmp85_;
		_tmp85_ = this_access;
		_tmp66_ = !_tmp85_;
	} else {
		_tmp66_ = FALSE;
	}
	if (_tmp66_) {
		ValaExpression* _tmp86_;
		ValaExpression* _tmp87_;
		ValaMemberAccess* _tmp88_;
		_tmp86_ = vala_member_access_get_inner (self);
		_tmp87_ = _tmp86_;
		vala_expression_set_lvalue (_tmp87_, TRUE);
		_tmp88_ = ma;
		if (_tmp88_ != NULL) {
			ValaMemberAccess* _tmp89_;
			ValaMemberAccess* _tmp90_;
			_tmp89_ = ma;
			vala_expression_set_lvalue ((ValaExpression*) _tmp89_, TRUE);
			_tmp90_ = ma;
			vala_member_access_check_lvalue_access (_tmp90_);
		}
	}
	_vala_code_node_unref0 (ma);
}


static void
vala_member_access_real_emit (ValaCodeNode* base, 
                              ValaCodeGenerator* codegen)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_emit ((ValaCodeNode*) _tmp3_, codegen);
	}
	vala_code_visitor_visit_member_access ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}


static void
vala_member_access_real_get_defined_variables (ValaCodeNode* base, 
                                               ValaCollection* collection)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp3_, collection);
	}
}


static void
vala_member_access_real_get_used_variables (ValaCodeNode* base, 
                                            ValaCollection* collection)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaLocalVariable* local = NULL;
	ValaSymbol* _tmp4_;
	ValaSymbol* _tmp5_;
	ValaLocalVariable* _tmp6_;
	ValaParameter* param = NULL;
	ValaSymbol* _tmp7_;
	ValaSymbol* _tmp8_;
	ValaParameter* _tmp9_;
	ValaLocalVariable* _tmp10_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_used_variables ((ValaCodeNode*) _tmp3_, collection);
	}
	_tmp4_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, VALA_TYPE_LOCAL_VARIABLE) ? ((ValaLocalVariable*) _tmp5_) : NULL);
	local = _tmp6_;
	_tmp7_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp8_ = _tmp7_;
	_tmp9_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, VALA_TYPE_PARAMETER) ? ((ValaParameter*) _tmp8_) : NULL);
	param = _tmp9_;
	_tmp10_ = local;
	if (_tmp10_ != NULL) {
		ValaLocalVariable* _tmp11_;
		_tmp11_ = local;
		vala_collection_add (collection, (ValaVariable*) _tmp11_);
	} else {
		gboolean _tmp12_ = FALSE;
		ValaParameter* _tmp13_;
		_tmp13_ = param;
		if (_tmp13_ != NULL) {
			ValaParameter* _tmp14_;
			ValaParameterDirection _tmp15_;
			ValaParameterDirection _tmp16_;
			_tmp14_ = param;
			_tmp15_ = vala_parameter_get_direction (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp12_ = _tmp16_ == VALA_PARAMETER_DIRECTION_OUT;
		} else {
			_tmp12_ = FALSE;
		}
		if (_tmp12_) {
			ValaParameter* _tmp17_;
			_tmp17_ = param;
			vala_collection_add (collection, (ValaVariable*) _tmp17_);
		}
	}
	_vala_code_node_unref0 (param);
	_vala_code_node_unref0 (local);
}


ValaExpression*
vala_member_access_get_inner (ValaMemberAccess* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_inner;
	result = _tmp0_;
	return result;
}


void
vala_member_access_set_inner (ValaMemberAccess* self, 
                              ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_inner);
	self->priv->_inner = _tmp0_;
	_tmp1_ = self->priv->_inner;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		_tmp2_ = self->priv->_inner;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
	}
}


const gchar*
vala_member_access_get_member_name (ValaMemberAccess* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_member_name;
	result = _tmp0_;
	return result;
}


void
vala_member_access_set_member_name (ValaMemberAccess* self, 
                                    const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_member_name);
	self->priv->_member_name = _tmp0_;
}


gboolean
vala_member_access_get_pointer_member_access (ValaMemberAccess* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_pointer_member_access;
	result = _tmp0_;
	return result;
}


void
vala_member_access_set_pointer_member_access (ValaMemberAccess* self, 
                                              gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_pointer_member_access = value;
}


gboolean
vala_member_access_get_prototype_access (ValaMemberAccess* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_prototype_access;
	result = _tmp0_;
	return result;
}


void
vala_member_access_set_prototype_access (ValaMemberAccess* self, 
                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_prototype_access = value;
}


gboolean
vala_member_access_get_creation_member (ValaMemberAccess* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_creation_member;
	result = _tmp0_;
	return result;
}


void
vala_member_access_set_creation_member (ValaMemberAccess* self, 
                                        gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_creation_member = value;
}


gboolean
vala_member_access_get_qualified (ValaMemberAccess* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_qualified;
	result = _tmp0_;
	return result;
}


void
vala_member_access_set_qualified (ValaMemberAccess* self, 
                                  gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_qualified = value;
}


static void
vala_member_access_class_init (ValaMemberAccessClass * klass)
{
	vala_member_access_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_member_access_finalize;
	g_type_class_add_private (klass, sizeof (ValaMemberAccessPrivate));
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_member_access_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_member_access_real_accept_children;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode *)) vala_member_access_real_to_string;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode *, ValaExpression*, ValaExpression*)) vala_member_access_real_replace_expression;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression *)) vala_member_access_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression *, ValaSymbol*)) vala_member_access_real_is_accessible;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode *, ValaDataType*, ValaDataType*)) vala_member_access_real_replace_type;
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression *)) vala_member_access_real_is_constant;
	((ValaExpressionClass *) klass)->is_non_null = (gboolean (*) (ValaExpression *)) vala_member_access_real_is_non_null;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode *, ValaCodeContext*)) vala_member_access_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode *, ValaCodeGenerator*)) vala_member_access_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode *, ValaCollection*)) vala_member_access_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode *, ValaCollection*)) vala_member_access_real_get_used_variables;
}


static void
vala_member_access_instance_init (ValaMemberAccess * self)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = VALA_MEMBER_ACCESS_GET_PRIVATE (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->type_argument_list = (ValaList*) _tmp1_;
}


static void
vala_member_access_finalize (ValaCodeNode * obj)
{
	ValaMemberAccess * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
	_g_free0 (self->priv->_member_name);
	_vala_code_node_unref0 (self->priv->_inner);
	_vala_iterable_unref0 (self->priv->type_argument_list);
	VALA_CODE_NODE_CLASS (vala_member_access_parent_class)->finalize (obj);
}


/**
 * Represents an access to a type member in the source code.
 */
GType
vala_member_access_get_type (void)
{
	static volatile gsize vala_member_access_type_id__volatile = 0;
	if (g_once_init_enter (&vala_member_access_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaMemberAccessClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_member_access_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMemberAccess), 0, (GInstanceInitFunc) vala_member_access_instance_init, NULL };
		GType vala_member_access_type_id;
		vala_member_access_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaMemberAccess", &g_define_type_info, 0);
		g_once_init_leave (&vala_member_access_type_id__volatile, vala_member_access_type_id);
	}
	return vala_member_access_type_id__volatile;
}



