/* valacodenode.c generated by valac, the Vala compiler
 * generated from valacodenode.vala, do not modify */

/* valacodenode.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <valagee.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gobject/gvaluecollector.h>

enum  {
	VALA_CODE_NODE_0_PROPERTY,
	VALA_CODE_NODE_NUM_PROPERTIES
};
static GParamSpec* vala_code_node_properties[VALA_CODE_NODE_NUM_PROPERTIES];
#define _vala_source_reference_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_reference_unref (var), NULL)))
#define __g_list_free__vala_code_node_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__vala_code_node_unref0_ (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_attribute_cache_unref0(var) ((var == NULL) ? NULL : (var = (vala_attribute_cache_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _ValaParamSpecCodeNode ValaParamSpecCodeNode;
enum  {
	VALA_ATTRIBUTE_CACHE_0_PROPERTY,
	VALA_ATTRIBUTE_CACHE_NUM_PROPERTIES
};
static GParamSpec* vala_attribute_cache_properties[VALA_ATTRIBUTE_CACHE_NUM_PROPERTIES];
typedef struct _ValaParamSpecAttributeCache ValaParamSpecAttributeCache;

struct _ValaCodeNodePrivate {
	ValaCodeNode* _parent_node;
	ValaSourceReference* _source_reference;
	gboolean _unreachable;
	gboolean _checked;
	gboolean _error;
	ValaList* _error_types;
	ValaAttributeCache** attributes_cache;
	gint attributes_cache_length1;
	gint _attributes_cache_size_;
};

struct _ValaParamSpecCodeNode {
	GParamSpec parent_instance;
};

struct _ValaParamSpecAttributeCache {
	GParamSpec parent_instance;
};


static gpointer vala_code_node_parent_class = NULL;
static ValaList* vala_code_node__empty_type_list;
static ValaList* vala_code_node__empty_type_list = NULL;
static gint vala_code_node_last_temp_nr;
static gint vala_code_node_last_temp_nr = 0;
static gint vala_code_node_next_attribute_cache_index;
static gint vala_code_node_next_attribute_cache_index = 0;
static gpointer vala_attribute_cache_parent_class = NULL;

#define VALA_CODE_NODE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CODE_NODE, ValaCodeNodePrivate))
static void _vala_code_node_unref0_ (gpointer var);
static inline void _g_list_free__vala_code_node_unref0_ (GList* self);
static void vala_code_node_real_accept (ValaCodeNode* self, 
                                 ValaCodeVisitor* visitor);
static void vala_code_node_real_accept_children (ValaCodeNode* self, 
                                          ValaCodeVisitor* visitor);
static gboolean vala_code_node_real_check (ValaCodeNode* self, 
                                    ValaCodeContext* context);
static void vala_code_node_real_emit (ValaCodeNode* self, 
                               ValaCodeGenerator* codegen);
static void vala_code_node_real_replace_type (ValaCodeNode* self, 
                                       ValaDataType* old_type, 
                                       ValaDataType* new_type);
static void vala_code_node_real_replace_expression (ValaCodeNode* self, 
                                             ValaExpression* old_node, 
                                             ValaExpression* new_node);
static gchar* vala_code_node_real_to_string (ValaCodeNode* self);
static void vala_code_node_real_get_defined_variables (ValaCodeNode* self, 
                                                ValaCollection* collection);
static void vala_code_node_real_get_used_variables (ValaCodeNode* self, 
                                             ValaCollection* collection);
static void vala_code_node_finalize (ValaCodeNode * obj);
static void vala_attribute_cache_finalize (ValaAttributeCache * obj);
static void _vala_array_destroy (gpointer array, 
                          gint array_length, 
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, 
                       gint array_length, 
                       GDestroyNotify destroy_func);


static void
_vala_code_node_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL));
}


static inline void
_g_list_free__vala_code_node_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _vala_code_node_unref0_);
}


/**
 * Specifies the exceptions that can be thrown by this node or a child node
 */
static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}


ValaList*
vala_code_node_get_error_types (ValaCodeNode* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp3_;
	ValaList* _tmp6_;
	ValaList* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_error_types;
	if (_tmp0_ != NULL) {
		ValaList* _tmp1_;
		ValaList* _tmp2_;
		_tmp1_ = self->priv->_error_types;
		_tmp2_ = _vala_iterable_ref0 (_tmp1_);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = vala_code_node__empty_type_list;
	if (_tmp3_ == NULL) {
		GEqualFunc _tmp4_;
		ValaArrayList* _tmp5_;
		_tmp4_ = g_direct_equal;
		_tmp5_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp4_);
		_vala_iterable_unref0 (vala_code_node__empty_type_list);
		vala_code_node__empty_type_list = (ValaList*) _tmp5_;
	}
	_tmp6_ = vala_code_node__empty_type_list;
	_tmp7_ = _vala_iterable_ref0 (_tmp6_);
	result = _tmp7_;
	return result;
}


/**
 * Adds an error type to the exceptions that can be thrown by this node
 * or a child node 
 */
void
vala_code_node_add_error_type (ValaCodeNode* self, 
                               ValaDataType* error_type)
{
	ValaList* _tmp0_;
	ValaList* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (error_type != NULL);
	_tmp0_ = self->priv->_error_types;
	if (_tmp0_ == NULL) {
		GEqualFunc _tmp1_;
		ValaArrayList* _tmp2_;
		_tmp1_ = g_direct_equal;
		_tmp2_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp1_);
		_vala_iterable_unref0 (self->priv->_error_types);
		self->priv->_error_types = (ValaList*) _tmp2_;
	}
	_tmp3_ = self->priv->_error_types;
	vala_collection_add ((ValaCollection*) _tmp3_, error_type);
	vala_code_node_set_parent_node ((ValaCodeNode*) error_type, self);
}


/**
 * Adds a collection of error types to the exceptions that can be thrown by this node
 * or a child node 
 */
void
vala_code_node_add_error_types (ValaCodeNode* self, 
                                ValaList* error_types)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (error_types != NULL);
	{
		ValaList* _error_type_list = NULL;
		ValaList* _tmp0_;
		gint _error_type_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _error_type_index = 0;
		_tmp0_ = _vala_iterable_ref0 (error_types);
		_error_type_list = _tmp0_;
		_tmp1_ = _error_type_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_error_type_size = _tmp3_;
		_error_type_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			gint _tmp6_;
			ValaDataType* error_type = NULL;
			ValaList* _tmp7_;
			gint _tmp8_;
			gpointer _tmp9_;
			ValaDataType* _tmp10_;
			_tmp4_ = _error_type_index;
			_error_type_index = _tmp4_ + 1;
			_tmp5_ = _error_type_index;
			_tmp6_ = _error_type_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _error_type_list;
			_tmp8_ = _error_type_index;
			_tmp9_ = vala_list_get (_tmp7_, _tmp8_);
			error_type = (ValaDataType*) _tmp9_;
			_tmp10_ = error_type;
			vala_code_node_add_error_type (self, _tmp10_);
			_vala_code_node_unref0 (error_type);
		}
		_vala_iterable_unref0 (_error_type_list);
	}
}


/**
 * Visits this code node with the specified CodeVisitor.
 *
 * @param visitor the visitor to be called while traversing
 */
static void
vala_code_node_real_accept (ValaCodeNode* self, 
                            ValaCodeVisitor* visitor)
{
	g_return_if_fail (visitor != NULL);
}


void
vala_code_node_accept (ValaCodeNode* self, 
                       ValaCodeVisitor* visitor)
{
	g_return_if_fail (self != NULL);
	VALA_CODE_NODE_GET_CLASS (self)->accept (self, visitor);
}


/**
 * Visits all children of this code node with the specified CodeVisitor.
 *
 * @param visitor the visitor to be called while traversing
 */
static void
vala_code_node_real_accept_children (ValaCodeNode* self, 
                                     ValaCodeVisitor* visitor)
{
	g_return_if_fail (visitor != NULL);
}


void
vala_code_node_accept_children (ValaCodeNode* self, 
                                ValaCodeVisitor* visitor)
{
	g_return_if_fail (self != NULL);
	VALA_CODE_NODE_GET_CLASS (self)->accept_children (self, visitor);
}


static gboolean
vala_code_node_real_check (ValaCodeNode* self, 
                           ValaCodeContext* context)
{
	gboolean result = FALSE;
	g_return_val_if_fail (context != NULL, FALSE);
	result = TRUE;
	return result;
}


gboolean
vala_code_node_check (ValaCodeNode* self, 
                      ValaCodeContext* context)
{
	g_return_val_if_fail (self != NULL, FALSE);
	return VALA_CODE_NODE_GET_CLASS (self)->check (self, context);
}


static void
vala_code_node_real_emit (ValaCodeNode* self, 
                          ValaCodeGenerator* codegen)
{
	g_return_if_fail (codegen != NULL);
}


void
vala_code_node_emit (ValaCodeNode* self, 
                     ValaCodeGenerator* codegen)
{
	g_return_if_fail (self != NULL);
	VALA_CODE_NODE_GET_CLASS (self)->emit (self, codegen);
}


static void
vala_code_node_real_replace_type (ValaCodeNode* self, 
                                  ValaDataType* old_type, 
                                  ValaDataType* new_type)
{
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
}


void
vala_code_node_replace_type (ValaCodeNode* self, 
                             ValaDataType* old_type, 
                             ValaDataType* new_type)
{
	g_return_if_fail (self != NULL);
	VALA_CODE_NODE_GET_CLASS (self)->replace_type (self, old_type, new_type);
}


static void
vala_code_node_real_replace_expression (ValaCodeNode* self, 
                                        ValaExpression* old_node, 
                                        ValaExpression* new_node)
{
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
}


void
vala_code_node_replace_expression (ValaCodeNode* self, 
                                   ValaExpression* old_node, 
                                   ValaExpression* new_node)
{
	g_return_if_fail (self != NULL);
	VALA_CODE_NODE_GET_CLASS (self)->replace_expression (self, old_node, new_node);
}


/**
 * Returns the specified attribute.
 *
 * @param name attribute name
 * @return     attribute
 */
static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


ValaAttribute*
vala_code_node_get_attribute (ValaCodeNode* self, 
                              const gchar* name)
{
	ValaAttribute* result = NULL;
	GList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = self->attributes;
	{
		GList* a_collection = NULL;
		GList* a_it = NULL;
		a_collection = _tmp0_;
		for (a_it = a_collection; a_it != NULL; a_it = a_it->next) {
			ValaAttribute* _tmp1_;
			ValaAttribute* a = NULL;
			_tmp1_ = _vala_code_node_ref0 ((ValaAttribute*) a_it->data);
			a = _tmp1_;
			{
				ValaAttribute* _tmp2_;
				const gchar* _tmp3_;
				const gchar* _tmp4_;
				_tmp2_ = a;
				_tmp3_ = vala_attribute_get_name (_tmp2_);
				_tmp4_ = _tmp3_;
				if (g_strcmp0 (_tmp4_, name) == 0) {
					result = a;
					return result;
				}
				_vala_code_node_unref0 (a);
			}
		}
	}
	result = NULL;
	return result;
}


/**
 * Returns true if the specified attribute argument is set.
 *
 * @param  attribute attribute name
 * @param  argument  argument name
 * @return           true if the attribute has the given argument
 */
gboolean
vala_code_node_has_attribute_argument (ValaCodeNode* self, 
                                       const gchar* attribute, 
                                       const gchar* argument)
{
	gboolean result = FALSE;
	ValaAttribute* a = NULL;
	ValaAttribute* _tmp0_;
	ValaAttribute* _tmp1_;
	ValaAttribute* _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (attribute != NULL, FALSE);
	g_return_val_if_fail (argument != NULL, FALSE);
	_tmp0_ = vala_code_node_get_attribute (self, attribute);
	a = _tmp0_;
	_tmp1_ = a;
	if (_tmp1_ == NULL) {
		result = FALSE;
		_vala_code_node_unref0 (a);
		return result;
	}
	_tmp2_ = a;
	result = vala_attribute_has_argument (_tmp2_, argument);
	_vala_code_node_unref0 (a);
	return result;
}


/**
 * Sets the specified named attribute to this code node.
 *
 * @param name  attribute name
 * @param value true to add the attribute, false to remove it
 */
void
vala_code_node_set_attribute (ValaCodeNode* self, 
                              const gchar* name, 
                              gboolean value, 
                              ValaSourceReference* source_reference)
{
	ValaAttribute* a = NULL;
	ValaAttribute* _tmp0_;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = vala_code_node_get_attribute (self, name);
	a = _tmp0_;
	if (value) {
		ValaAttribute* _tmp2_;
		_tmp2_ = a;
		_tmp1_ = _tmp2_ == NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		ValaAttribute* _tmp3_;
		_tmp3_ = vala_attribute_new (name, source_reference);
		self->attributes = g_list_append (self->attributes, _tmp3_);
	} else {
		gboolean _tmp4_ = FALSE;
		if (!value) {
			ValaAttribute* _tmp5_;
			_tmp5_ = a;
			_tmp4_ = _tmp5_ != NULL;
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			ValaAttribute* _tmp6_;
			_tmp6_ = a;
			self->attributes = g_list_remove (self->attributes, _tmp6_);
		}
	}
	_vala_code_node_unref0 (a);
}


/**
 * Remove the specified named attribute argument
 *
 * @param attribute attribute name
 * @param argument  argument name
 */
void
vala_code_node_remove_attribute_argument (ValaCodeNode* self, 
                                          const gchar* attribute, 
                                          const gchar* argument)
{
	ValaAttribute* a = NULL;
	ValaAttribute* _tmp0_;
	ValaAttribute* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (attribute != NULL);
	g_return_if_fail (argument != NULL);
	_tmp0_ = vala_code_node_get_attribute (self, attribute);
	a = _tmp0_;
	_tmp1_ = a;
	if (_tmp1_ != NULL) {
		ValaAttribute* _tmp2_;
		ValaMap* _tmp3_;
		ValaAttribute* _tmp4_;
		ValaMap* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		_tmp2_ = a;
		_tmp3_ = _tmp2_->args;
		vala_map_remove (_tmp3_, argument);
		_tmp4_ = a;
		_tmp5_ = _tmp4_->args;
		_tmp6_ = vala_map_get_size (_tmp5_);
		_tmp7_ = _tmp6_;
		if (_tmp7_ == 0) {
			ValaAttribute* _tmp8_;
			_tmp8_ = a;
			self->attributes = g_list_remove (self->attributes, _tmp8_);
		}
	}
	_vala_code_node_unref0 (a);
}


/**
 * Returns the string value of the specified attribute argument.
 *
 * @param attribute attribute name
 * @param argument  argument name
 * @return          string value
 */
gchar*
vala_code_node_get_attribute_string (ValaCodeNode* self, 
                                     const gchar* attribute, 
                                     const gchar* argument, 
                                     const gchar* default_value)
{
	gchar* result = NULL;
	ValaAttribute* a = NULL;
	ValaAttribute* _tmp0_;
	ValaAttribute* _tmp1_;
	ValaAttribute* _tmp3_;
	gchar* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (attribute != NULL, NULL);
	g_return_val_if_fail (argument != NULL, NULL);
	_tmp0_ = vala_code_node_get_attribute (self, attribute);
	a = _tmp0_;
	_tmp1_ = a;
	if (_tmp1_ == NULL) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (default_value);
		result = _tmp2_;
		_vala_code_node_unref0 (a);
		return result;
	}
	_tmp3_ = a;
	_tmp4_ = vala_attribute_get_string (_tmp3_, argument, default_value);
	result = _tmp4_;
	_vala_code_node_unref0 (a);
	return result;
}


/**
 * Returns the integer value of the specified attribute argument.
 *
 * @param attribute attribute name
 * @param argument  argument name
 * @return          integer value
 */
gint
vala_code_node_get_attribute_integer (ValaCodeNode* self, 
                                      const gchar* attribute, 
                                      const gchar* argument, 
                                      gint default_value)
{
	gint result = 0;
	ValaAttribute* a = NULL;
	ValaAttribute* _tmp0_;
	ValaAttribute* _tmp1_;
	ValaAttribute* _tmp2_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (attribute != NULL, 0);
	g_return_val_if_fail (argument != NULL, 0);
	_tmp0_ = vala_code_node_get_attribute (self, attribute);
	a = _tmp0_;
	_tmp1_ = a;
	if (_tmp1_ == NULL) {
		result = default_value;
		_vala_code_node_unref0 (a);
		return result;
	}
	_tmp2_ = a;
	result = vala_attribute_get_integer (_tmp2_, argument, default_value);
	_vala_code_node_unref0 (a);
	return result;
}


/**
 * Returns the double value of the specified attribute argument.
 *
 * @param attribute attribute name
 * @param argument  argument name
 * @return          double value
 */
gdouble
vala_code_node_get_attribute_double (ValaCodeNode* self, 
                                     const gchar* attribute, 
                                     const gchar* argument, 
                                     gdouble default_value)
{
	gdouble result = 0.0;
	GList* _tmp0_;
	ValaAttribute* a = NULL;
	ValaAttribute* _tmp1_;
	ValaAttribute* _tmp2_;
	ValaAttribute* _tmp3_;
	g_return_val_if_fail (self != NULL, 0.0);
	g_return_val_if_fail (attribute != NULL, 0.0);
	g_return_val_if_fail (argument != NULL, 0.0);
	_tmp0_ = self->attributes;
	if (_tmp0_ == NULL) {
		result = default_value;
		return result;
	}
	_tmp1_ = vala_code_node_get_attribute (self, attribute);
	a = _tmp1_;
	_tmp2_ = a;
	if (_tmp2_ == NULL) {
		result = default_value;
		_vala_code_node_unref0 (a);
		return result;
	}
	_tmp3_ = a;
	result = vala_attribute_get_double (_tmp3_, argument, default_value);
	_vala_code_node_unref0 (a);
	return result;
}


/**
 * Returns the bool value of the specified attribute argument.
 *
 * @param attribute attribute name
 * @param argument  argument name
 * @return          bool value
 */
gboolean
vala_code_node_get_attribute_bool (ValaCodeNode* self, 
                                   const gchar* attribute, 
                                   const gchar* argument, 
                                   gboolean default_value)
{
	gboolean result = FALSE;
	GList* _tmp0_;
	ValaAttribute* a = NULL;
	ValaAttribute* _tmp1_;
	ValaAttribute* _tmp2_;
	ValaAttribute* _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (attribute != NULL, FALSE);
	g_return_val_if_fail (argument != NULL, FALSE);
	_tmp0_ = self->attributes;
	if (_tmp0_ == NULL) {
		result = default_value;
		return result;
	}
	_tmp1_ = vala_code_node_get_attribute (self, attribute);
	a = _tmp1_;
	_tmp2_ = a;
	if (_tmp2_ == NULL) {
		result = default_value;
		_vala_code_node_unref0 (a);
		return result;
	}
	_tmp3_ = a;
	result = vala_attribute_get_bool (_tmp3_, argument, default_value);
	_vala_code_node_unref0 (a);
	return result;
}


/**
 * Sets the string value of the specified attribute argument.
 *
 * @param attribute attribute name
 * @param argument  argument name
 * @param value     string value
 */
void
vala_code_node_set_attribute_string (ValaCodeNode* self, 
                                     const gchar* attribute, 
                                     const gchar* argument, 
                                     const gchar* value, 
                                     ValaSourceReference* source_reference)
{
	ValaAttribute* a = NULL;
	ValaAttribute* _tmp0_;
	ValaAttribute* _tmp1_;
	ValaAttribute* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (attribute != NULL);
	g_return_if_fail (argument != NULL);
	if (value == NULL) {
		vala_code_node_remove_attribute_argument (self, attribute, argument);
		return;
	}
	_tmp0_ = vala_code_node_get_attribute (self, attribute);
	a = _tmp0_;
	_tmp1_ = a;
	if (_tmp1_ == NULL) {
		ValaAttribute* _tmp2_;
		ValaAttribute* _tmp3_;
		ValaAttribute* _tmp4_;
		_tmp2_ = vala_attribute_new (attribute, source_reference);
		_vala_code_node_unref0 (a);
		a = _tmp2_;
		_tmp3_ = a;
		_tmp4_ = _vala_code_node_ref0 (_tmp3_);
		self->attributes = g_list_append (self->attributes, _tmp4_);
	}
	_tmp5_ = a;
	_tmp6_ = g_strdup_printf ("\"%s\"", value);
	_tmp7_ = _tmp6_;
	vala_attribute_add_argument (_tmp5_, argument, _tmp7_);
	_g_free0 (_tmp7_);
	_vala_code_node_unref0 (a);
}


/**
 * Sets the integer value of the specified attribute argument.
 *
 * @param attribute attribute name
 * @param argument  argument name
 * @param value     integer value
 */
void
vala_code_node_set_attribute_integer (ValaCodeNode* self, 
                                      const gchar* attribute, 
                                      const gchar* argument, 
                                      gint value, 
                                      ValaSourceReference* source_reference)
{
	ValaAttribute* a = NULL;
	ValaAttribute* _tmp0_;
	ValaAttribute* _tmp1_;
	ValaAttribute* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (attribute != NULL);
	g_return_if_fail (argument != NULL);
	_tmp0_ = vala_code_node_get_attribute (self, attribute);
	a = _tmp0_;
	_tmp1_ = a;
	if (_tmp1_ == NULL) {
		ValaAttribute* _tmp2_;
		ValaAttribute* _tmp3_;
		ValaAttribute* _tmp4_;
		_tmp2_ = vala_attribute_new (attribute, source_reference);
		_vala_code_node_unref0 (a);
		a = _tmp2_;
		_tmp3_ = a;
		_tmp4_ = _vala_code_node_ref0 (_tmp3_);
		self->attributes = g_list_append (self->attributes, _tmp4_);
	}
	_tmp5_ = a;
	_tmp6_ = g_strdup_printf ("%i", value);
	_tmp7_ = _tmp6_;
	vala_attribute_add_argument (_tmp5_, argument, _tmp7_);
	_g_free0 (_tmp7_);
	_vala_code_node_unref0 (a);
}


/**
 * Sets the integer value of the specified attribute argument.
 *
 * @param attribute attribute name
 * @param argument  argument name
 * @param value     double value
 */
void
vala_code_node_set_attribute_double (ValaCodeNode* self, 
                                     const gchar* attribute, 
                                     const gchar* argument, 
                                     gdouble value, 
                                     ValaSourceReference* source_reference)
{
	ValaAttribute* a = NULL;
	ValaAttribute* _tmp0_;
	ValaAttribute* _tmp1_;
	ValaAttribute* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gint _tmp7__length1;
	const gchar* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (attribute != NULL);
	g_return_if_fail (argument != NULL);
	_tmp0_ = vala_code_node_get_attribute (self, attribute);
	a = _tmp0_;
	_tmp1_ = a;
	if (_tmp1_ == NULL) {
		ValaAttribute* _tmp2_;
		ValaAttribute* _tmp3_;
		ValaAttribute* _tmp4_;
		_tmp2_ = vala_attribute_new (attribute, source_reference);
		_vala_code_node_unref0 (a);
		a = _tmp2_;
		_tmp3_ = a;
		_tmp4_ = _vala_code_node_ref0 (_tmp3_);
		self->attributes = g_list_append (self->attributes, _tmp4_);
	}
	_tmp5_ = a;
	_tmp6_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
	_tmp7_ = _tmp6_;
	_tmp7__length1 = G_ASCII_DTOSTR_BUF_SIZE;
	_tmp8_ = g_ascii_formatd (_tmp7_, G_ASCII_DTOSTR_BUF_SIZE, "%g", value);
	vala_attribute_add_argument (_tmp5_, argument, _tmp8_);
	_tmp7_ = (g_free (_tmp7_), NULL);
	_vala_code_node_unref0 (a);
}


/**
 * Sets the boolean value of the specified attribute argument.
 *
 * @param attribute attribute name
 * @param argument  argument name
 * @param value     bool value
 */
static gchar*
bool_to_string (gboolean self)
{
	gchar* result = NULL;
	if (self) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("true");
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("false");
		result = _tmp1_;
		return result;
	}
}


void
vala_code_node_set_attribute_bool (ValaCodeNode* self, 
                                   const gchar* attribute, 
                                   const gchar* argument, 
                                   gboolean value, 
                                   ValaSourceReference* source_reference)
{
	ValaAttribute* a = NULL;
	ValaAttribute* _tmp0_;
	ValaAttribute* _tmp1_;
	ValaAttribute* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (attribute != NULL);
	g_return_if_fail (argument != NULL);
	_tmp0_ = vala_code_node_get_attribute (self, attribute);
	a = _tmp0_;
	_tmp1_ = a;
	if (_tmp1_ == NULL) {
		ValaAttribute* _tmp2_;
		ValaAttribute* _tmp3_;
		ValaAttribute* _tmp4_;
		_tmp2_ = vala_attribute_new (attribute, source_reference);
		_vala_code_node_unref0 (a);
		a = _tmp2_;
		_tmp3_ = a;
		_tmp4_ = _vala_code_node_ref0 (_tmp3_);
		self->attributes = g_list_append (self->attributes, _tmp4_);
	}
	_tmp5_ = a;
	_tmp6_ = bool_to_string (value);
	_tmp7_ = _tmp6_;
	vala_attribute_add_argument (_tmp5_, argument, _tmp7_);
	_g_free0 (_tmp7_);
	_vala_code_node_unref0 (a);
}


/**
 * Returns the attribute cache at the specified index.
 *
 * @param index attribute cache index
 * @return      attribute cache
 */
static gpointer
_vala_attribute_cache_ref0 (gpointer self)
{
	return self ? vala_attribute_cache_ref (self) : NULL;
}


ValaAttributeCache*
vala_code_node_get_attribute_cache (ValaCodeNode* self, 
                                    gint index)
{
	ValaAttributeCache* result = NULL;
	ValaAttributeCache** _tmp0_;
	gint _tmp0__length1;
	ValaAttributeCache** _tmp1_;
	gint _tmp1__length1;
	ValaAttributeCache* _tmp2_;
	ValaAttributeCache* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->attributes_cache;
	_tmp0__length1 = self->priv->attributes_cache_length1;
	if (index >= _tmp0__length1) {
		result = NULL;
		return result;
	}
	_tmp1_ = self->priv->attributes_cache;
	_tmp1__length1 = self->priv->attributes_cache_length1;
	_tmp2_ = _tmp1_[index];
	_tmp3_ = _vala_attribute_cache_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}


/**
 * Sets the specified attribute cache to this code node.
 *
 * @param index attribute cache index
 * @param cache attribute cache
 */
void
vala_code_node_set_attribute_cache (ValaCodeNode* self, 
                                    gint index, 
                                    ValaAttributeCache* cache)
{
	ValaAttributeCache** _tmp0_;
	gint _tmp0__length1;
	ValaAttributeCache** _tmp2_;
	gint _tmp2__length1;
	ValaAttributeCache* _tmp3_;
	ValaAttributeCache* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cache != NULL);
	_tmp0_ = self->priv->attributes_cache;
	_tmp0__length1 = self->priv->attributes_cache_length1;
	if (index >= _tmp0__length1) {
		gint _tmp1_;
		_tmp1_ = (index * 2) + 1;
		self->priv->attributes_cache = g_renew (ValaAttributeCache*, self->priv->attributes_cache, (index * 2) + 1);
		(_tmp1_ > self->priv->attributes_cache_length1) ? memset (self->priv->attributes_cache + self->priv->attributes_cache_length1, 0, sizeof (ValaAttributeCache*) * (_tmp1_ - self->priv->attributes_cache_length1)) : NULL;
		self->priv->attributes_cache_length1 = _tmp1_;
		self->priv->_attributes_cache_size_ = _tmp1_;
	}
	_tmp2_ = self->priv->attributes_cache;
	_tmp2__length1 = self->priv->attributes_cache_length1;
	_tmp3_ = _vala_attribute_cache_ref0 (cache);
	_vala_attribute_cache_unref0 (_tmp2_[index]);
	_tmp2_[index] = _tmp3_;
	_tmp4_ = _tmp2_[index];
}


/**
 * Returns a string that represents this code node.
 *
 * @return a string representation
 */
static gchar*
vala_code_node_real_to_string (ValaCodeNode* self)
{
	gchar* result = NULL;
	GString* str = NULL;
	GString* _tmp0_;
	GString* _tmp1_;
	ValaSourceReference* _tmp2_;
	GString* _tmp8_;
	GString* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	_tmp0_ = g_string_new ("");
	str = _tmp0_;
	_tmp1_ = str;
	g_string_append (_tmp1_, "/* ");
	_tmp2_ = self->priv->_source_reference;
	if (_tmp2_ != NULL) {
		GString* _tmp3_;
		GString* _tmp4_;
		ValaSourceReference* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp3_ = str;
		_tmp4_ = g_string_append (_tmp3_, "@");
		_tmp5_ = self->priv->_source_reference;
		_tmp6_ = vala_source_reference_to_string (_tmp5_);
		_tmp7_ = _tmp6_;
		g_string_append (_tmp4_, _tmp7_);
		_g_free0 (_tmp7_);
	}
	_tmp8_ = str;
	_tmp9_ = g_string_append (_tmp8_, " */");
	_tmp10_ = _tmp9_->str;
	_tmp11_ = g_strdup (_tmp10_);
	result = _tmp11_;
	_g_string_free0 (str);
	return result;
}


gchar*
vala_code_node_to_string (ValaCodeNode* self)
{
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_CODE_NODE_GET_CLASS (self)->to_string (self);
}


static void
vala_code_node_real_get_defined_variables (ValaCodeNode* self, 
                                           ValaCollection* collection)
{
	g_return_if_fail (collection != NULL);
}


void
vala_code_node_get_defined_variables (ValaCodeNode* self, 
                                      ValaCollection* collection)
{
	g_return_if_fail (self != NULL);
	VALA_CODE_NODE_GET_CLASS (self)->get_defined_variables (self, collection);
}


static void
vala_code_node_real_get_used_variables (ValaCodeNode* self, 
                                        ValaCollection* collection)
{
	g_return_if_fail (collection != NULL);
}


void
vala_code_node_get_used_variables (ValaCodeNode* self, 
                                   ValaCollection* collection)
{
	g_return_if_fail (self != NULL);
	VALA_CODE_NODE_GET_CLASS (self)->get_used_variables (self, collection);
}


gchar*
vala_code_node_get_temp_name (void)
{
	gchar* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	_tmp0_ = vala_code_node_last_temp_nr;
	vala_code_node_last_temp_nr = _tmp0_ + 1;
	_tmp1_ = vala_code_node_last_temp_nr;
	_tmp2_ = g_strdup_printf ("%i", _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat (".", _tmp3_, NULL);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	result = _tmp5_;
	return result;
}


/**
 * Returns a new cache index for accessing the attributes cache of code nodes
 *
 * @return a new cache index
 */
gint
vala_code_node_get_attribute_cache_index (void)
{
	gint result = 0;
	gint _tmp0_;
	_tmp0_ = vala_code_node_next_attribute_cache_index;
	vala_code_node_next_attribute_cache_index = _tmp0_ + 1;
	result = _tmp0_;
	return result;
}


ValaCodeNode*
vala_code_node_construct (GType object_type)
{
	ValaCodeNode* self = NULL;
	self = (ValaCodeNode*) g_type_create_instance (object_type);
	return self;
}


ValaCodeNode*
vala_code_node_get_parent_node (ValaCodeNode* self)
{
	ValaCodeNode* result;
	ValaCodeNode* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_parent_node;
	result = _tmp0_;
	return result;
}


void
vala_code_node_set_parent_node (ValaCodeNode* self, 
                                ValaCodeNode* value)
{
	g_return_if_fail (self != NULL);
	self->priv->_parent_node = value;
}


ValaSourceReference*
vala_code_node_get_source_reference (ValaCodeNode* self)
{
	ValaSourceReference* result;
	ValaSourceReference* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_source_reference;
	result = _tmp0_;
	return result;
}


static gpointer
_vala_source_reference_ref0 (gpointer self)
{
	return self ? vala_source_reference_ref (self) : NULL;
}


void
vala_code_node_set_source_reference (ValaCodeNode* self, 
                                     ValaSourceReference* value)
{
	ValaSourceReference* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_source_reference_ref0 (value);
	_vala_source_reference_unref0 (self->priv->_source_reference);
	self->priv->_source_reference = _tmp0_;
}


gboolean
vala_code_node_get_unreachable (ValaCodeNode* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_unreachable;
	result = _tmp0_;
	return result;
}


void
vala_code_node_set_unreachable (ValaCodeNode* self, 
                                gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_unreachable = value;
}


const gchar*
vala_code_node_get_type_name (ValaCodeNode* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_type_name (G_TYPE_FROM_INSTANCE (self));
	result = _tmp0_;
	return result;
}


gboolean
vala_code_node_get_checked (ValaCodeNode* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_checked;
	result = _tmp0_;
	return result;
}


void
vala_code_node_set_checked (ValaCodeNode* self, 
                            gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_checked = value;
}


gboolean
vala_code_node_get_error (ValaCodeNode* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_error;
	result = _tmp0_;
	return result;
}


void
vala_code_node_set_error (ValaCodeNode* self, 
                          gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_error = value;
}


gboolean
vala_code_node_get_tree_can_fail (ValaCodeNode* self)
{
	gboolean result;
	gboolean _tmp0_ = FALSE;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->_error_types;
	if (_tmp1_ != NULL) {
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		_tmp2_ = self->priv->_error_types;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ > 0;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static void
vala_value_code_node_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}


static void
vala_value_code_node_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		vala_code_node_unref (value->data[0].v_pointer);
	}
}


static void
vala_value_code_node_copy_value (const GValue* src_value, 
                                 GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_code_node_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer
vala_value_code_node_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}


static gchar*
vala_value_code_node_collect_value (GValue* value, 
                                    guint n_collect_values, 
                                    GTypeCValue* collect_values, 
                                    guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ValaCodeNode * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_code_node_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar*
vala_value_code_node_lcopy_value (const GValue* value, 
                                  guint n_collect_values, 
                                  GTypeCValue* collect_values, 
                                  guint collect_flags)
{
	ValaCodeNode ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_code_node_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec*
vala_param_spec_code_node (const gchar* name, 
                           const gchar* nick, 
                           const gchar* blurb, 
                           GType object_type, 
                           GParamFlags flags)
{
	ValaParamSpecCodeNode* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_TYPE_CODE_NODE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer
vala_value_get_code_node (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_CODE_NODE), NULL);
	return value->data[0].v_pointer;
}


void
vala_value_set_code_node (GValue* value, 
                          gpointer v_object)
{
	ValaCodeNode * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_CODE_NODE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_CODE_NODE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_code_node_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_code_node_unref (old);
	}
}


void
vala_value_take_code_node (GValue* value, 
                           gpointer v_object)
{
	ValaCodeNode * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_CODE_NODE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_CODE_NODE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_code_node_unref (old);
	}
}


static void
vala_code_node_class_init (ValaCodeNodeClass * klass)
{
	vala_code_node_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_code_node_finalize;
	g_type_class_add_private (klass, sizeof (ValaCodeNodePrivate));
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_code_node_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_code_node_real_accept_children;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode *, ValaCodeContext*)) vala_code_node_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode *, ValaCodeGenerator*)) vala_code_node_real_emit;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode *, ValaDataType*, ValaDataType*)) vala_code_node_real_replace_type;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode *, ValaExpression*, ValaExpression*)) vala_code_node_real_replace_expression;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode *)) vala_code_node_real_to_string;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode *, ValaCollection*)) vala_code_node_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode *, ValaCollection*)) vala_code_node_real_get_used_variables;
}


static void
vala_code_node_instance_init (ValaCodeNode * self)
{
	self->priv = VALA_CODE_NODE_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void
vala_code_node_finalize (ValaCodeNode * obj)
{
	ValaCodeNode * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_CODE_NODE, ValaCodeNode);
	g_signal_handlers_destroy (self);
	_vala_source_reference_unref0 (self->priv->_source_reference);
	__g_list_free__vala_code_node_unref0_0 (self->attributes);
	_vala_iterable_unref0 (self->priv->_error_types);
	self->priv->attributes_cache = (_vala_array_free (self->priv->attributes_cache, self->priv->attributes_cache_length1, (GDestroyNotify) vala_attribute_cache_unref), NULL);
}


/**
 * Represents a part of the parsed source code.
 *
 * Code nodes get created by the parser and are used throughout the whole
 * compilation process.
 */
GType
vala_code_node_get_type (void)
{
	static volatile gsize vala_code_node_type_id__volatile = 0;
	if (g_once_init_enter (&vala_code_node_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { vala_value_code_node_init, vala_value_code_node_free_value, vala_value_code_node_copy_value, vala_value_code_node_peek_pointer, "p", vala_value_code_node_collect_value, "p", vala_value_code_node_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValaCodeNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_code_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCodeNode), 0, (GInstanceInitFunc) vala_code_node_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType vala_code_node_type_id;
		vala_code_node_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaCodeNode", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&vala_code_node_type_id__volatile, vala_code_node_type_id);
	}
	return vala_code_node_type_id__volatile;
}


gpointer
vala_code_node_ref (gpointer instance)
{
	ValaCodeNode * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void
vala_code_node_unref (gpointer instance)
{
	ValaCodeNode * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_CODE_NODE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


ValaAttributeCache*
vala_attribute_cache_construct (GType object_type)
{
	ValaAttributeCache* self = NULL;
	self = (ValaAttributeCache*) g_type_create_instance (object_type);
	return self;
}


ValaAttributeCache*
vala_attribute_cache_new (void)
{
	return vala_attribute_cache_construct (VALA_TYPE_ATTRIBUTE_CACHE);
}


static void
vala_value_attribute_cache_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}


static void
vala_value_attribute_cache_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		vala_attribute_cache_unref (value->data[0].v_pointer);
	}
}


static void
vala_value_attribute_cache_copy_value (const GValue* src_value, 
                                       GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_attribute_cache_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer
vala_value_attribute_cache_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}


static gchar*
vala_value_attribute_cache_collect_value (GValue* value, 
                                          guint n_collect_values, 
                                          GTypeCValue* collect_values, 
                                          guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ValaAttributeCache * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_attribute_cache_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar*
vala_value_attribute_cache_lcopy_value (const GValue* value, 
                                        guint n_collect_values, 
                                        GTypeCValue* collect_values, 
                                        guint collect_flags)
{
	ValaAttributeCache ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_attribute_cache_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec*
vala_param_spec_attribute_cache (const gchar* name, 
                                 const gchar* nick, 
                                 const gchar* blurb, 
                                 GType object_type, 
                                 GParamFlags flags)
{
	ValaParamSpecAttributeCache* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_TYPE_ATTRIBUTE_CACHE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer
vala_value_get_attribute_cache (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_ATTRIBUTE_CACHE), NULL);
	return value->data[0].v_pointer;
}


void
vala_value_set_attribute_cache (GValue* value, 
                                gpointer v_object)
{
	ValaAttributeCache * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_ATTRIBUTE_CACHE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_ATTRIBUTE_CACHE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_attribute_cache_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_attribute_cache_unref (old);
	}
}


void
vala_value_take_attribute_cache (GValue* value, 
                                 gpointer v_object)
{
	ValaAttributeCache * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_ATTRIBUTE_CACHE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_ATTRIBUTE_CACHE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_attribute_cache_unref (old);
	}
}


static void
vala_attribute_cache_class_init (ValaAttributeCacheClass * klass)
{
	vala_attribute_cache_parent_class = g_type_class_peek_parent (klass);
	((ValaAttributeCacheClass *) klass)->finalize = vala_attribute_cache_finalize;
}


static void
vala_attribute_cache_instance_init (ValaAttributeCache * self)
{
	self->ref_count = 1;
}


static void
vala_attribute_cache_finalize (ValaAttributeCache * obj)
{
	ValaAttributeCache * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_ATTRIBUTE_CACHE, ValaAttributeCache);
	g_signal_handlers_destroy (self);
}


GType
vala_attribute_cache_get_type (void)
{
	static volatile gsize vala_attribute_cache_type_id__volatile = 0;
	if (g_once_init_enter (&vala_attribute_cache_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { vala_value_attribute_cache_init, vala_value_attribute_cache_free_value, vala_value_attribute_cache_copy_value, vala_value_attribute_cache_peek_pointer, "p", vala_value_attribute_cache_collect_value, "p", vala_value_attribute_cache_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValaAttributeCacheClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_attribute_cache_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaAttributeCache), 0, (GInstanceInitFunc) vala_attribute_cache_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType vala_attribute_cache_type_id;
		vala_attribute_cache_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaAttributeCache", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&vala_attribute_cache_type_id__volatile, vala_attribute_cache_type_id);
	}
	return vala_attribute_cache_type_id__volatile;
}


gpointer
vala_attribute_cache_ref (gpointer instance)
{
	ValaAttributeCache * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void
vala_attribute_cache_unref (gpointer instance)
{
	ValaAttributeCache * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_ATTRIBUTE_CACHE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void
_vala_array_destroy (gpointer array, 
                     gint array_length, 
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array, 
                  gint array_length, 
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



