/* valaobjectcreationexpression.c generated by valac, the Vala compiler
 * generated from valaobjectcreationexpression.vala, do not modify */

/* valaobjectcreationexpression.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <valagee.h>
#include <stdlib.h>
#include <string.h>

enum  {
	VALA_OBJECT_CREATION_EXPRESSION_0_PROPERTY,
	VALA_OBJECT_CREATION_EXPRESSION_NUM_PROPERTIES
};
static GParamSpec* vala_object_creation_expression_properties[VALA_OBJECT_CREATION_EXPRESSION_NUM_PROPERTIES];
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))

struct _ValaObjectCreationExpressionPrivate {
	ValaMemberAccess* _member_name;
	gboolean _is_yield_expression;
	gboolean _struct_creation;
	ValaList* argument_list;
	ValaList* object_initializer;
	ValaDataType* _data_type;
};


static gpointer vala_object_creation_expression_parent_class = NULL;

#define VALA_OBJECT_CREATION_EXPRESSION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_OBJECT_CREATION_EXPRESSION, ValaObjectCreationExpressionPrivate))
static void vala_object_creation_expression_real_accept (ValaCodeNode* base, 
                                                  ValaCodeVisitor* visitor);
static void vala_object_creation_expression_real_accept_children (ValaCodeNode* base, 
                                                           ValaCodeVisitor* visitor);
static void vala_object_creation_expression_real_replace_expression (ValaCodeNode* base, 
                                                              ValaExpression* old_node, 
                                                              ValaExpression* new_node);
static gboolean vala_object_creation_expression_real_is_pure (ValaExpression* base);
static gboolean vala_object_creation_expression_real_is_accessible (ValaExpression* base, 
                                                             ValaSymbol* sym);
static void vala_object_creation_expression_real_replace_type (ValaCodeNode* base, 
                                                        ValaDataType* old_type, 
                                                        ValaDataType* new_type);
static gboolean vala_object_creation_expression_real_check (ValaCodeNode* base, 
                                                     ValaCodeContext* context);
static void vala_object_creation_expression_real_emit (ValaCodeNode* base, 
                                                ValaCodeGenerator* codegen);
static void vala_object_creation_expression_real_get_defined_variables (ValaCodeNode* base, 
                                                                 ValaCollection* collection);
static void vala_object_creation_expression_real_get_used_variables (ValaCodeNode* base, 
                                                              ValaCollection* collection);
static void vala_object_creation_expression_finalize (ValaCodeNode * obj);


/**
 * Creates a new object creation expression.
 *
 * @param member_name      object type to create
 * @param source_reference reference to source code
 * @return                 newly created object creation expression
 */
ValaObjectCreationExpression*
vala_object_creation_expression_construct (GType object_type, 
                                           ValaMemberAccess* member_name, 
                                           ValaSourceReference* source_reference)
{
	ValaObjectCreationExpression* self = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	g_return_val_if_fail (source_reference != NULL, NULL);
	self = (ValaObjectCreationExpression*) vala_expression_construct (object_type);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_object_creation_expression_set_member_name (self, member_name);
	return self;
}


ValaObjectCreationExpression*
vala_object_creation_expression_new (ValaMemberAccess* member_name, 
                                     ValaSourceReference* source_reference)
{
	return vala_object_creation_expression_construct (VALA_TYPE_OBJECT_CREATION_EXPRESSION, member_name, source_reference);
}


/**
 * Appends the specified expression to the list of arguments.
 *
 * @param arg an argument
 */
void
vala_object_creation_expression_add_argument (ValaObjectCreationExpression* self, 
                                              ValaExpression* arg)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (arg != NULL);
	_tmp0_ = self->priv->argument_list;
	vala_collection_add ((ValaCollection*) _tmp0_, arg);
	vala_code_node_set_parent_node ((ValaCodeNode*) arg, (ValaCodeNode*) self);
}


/**
 * Returns a copy of the argument list.
 *
 * @return argument list
 */
static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}


ValaList*
vala_object_creation_expression_get_argument_list (ValaObjectCreationExpression* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->argument_list;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Appends the specified member initializer to the object initializer.
 *
 * @param init a member initializer
 */
void
vala_object_creation_expression_add_member_initializer (ValaObjectCreationExpression* self, 
                                                        ValaMemberInitializer* init)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (init != NULL);
	_tmp0_ = self->priv->object_initializer;
	vala_collection_add ((ValaCollection*) _tmp0_, init);
	vala_code_node_set_parent_node ((ValaCodeNode*) init, (ValaCodeNode*) self);
}


/**
 * Returns the object initializer.
 *
 * @return member initializer list
 */
ValaList*
vala_object_creation_expression_get_object_initializer (ValaObjectCreationExpression* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->object_initializer;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


static void
vala_object_creation_expression_real_accept (ValaCodeNode* base, 
                                             ValaCodeVisitor* visitor)
{
	ValaObjectCreationExpression * self;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_object_creation_expression (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}


static void
vala_object_creation_expression_real_accept_children (ValaCodeNode* base, 
                                                      ValaCodeVisitor* visitor)
{
	ValaObjectCreationExpression * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaMemberAccess* _tmp4_;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_object_creation_expression_get_type_reference (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaDataType* _tmp2_;
		ValaDataType* _tmp3_;
		_tmp2_ = vala_object_creation_expression_get_type_reference (self);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
	}
	_tmp4_ = self->priv->_member_name;
	if (_tmp4_ != NULL) {
		ValaMemberAccess* _tmp5_;
		_tmp5_ = self->priv->_member_name;
		vala_code_node_accept ((ValaCodeNode*) _tmp5_, visitor);
	}
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp6_;
		ValaList* _tmp7_;
		gint _arg_size = 0;
		ValaList* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gint _arg_index = 0;
		_tmp6_ = self->priv->argument_list;
		_tmp7_ = _vala_iterable_ref0 (_tmp6_);
		_arg_list = _tmp7_;
		_tmp8_ = _arg_list;
		_tmp9_ = vala_collection_get_size ((ValaCollection*) _tmp8_);
		_tmp10_ = _tmp9_;
		_arg_size = _tmp10_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp11_;
			gint _tmp12_;
			gint _tmp13_;
			ValaExpression* arg = NULL;
			ValaList* _tmp14_;
			gint _tmp15_;
			gpointer _tmp16_;
			ValaExpression* _tmp17_;
			_tmp11_ = _arg_index;
			_arg_index = _tmp11_ + 1;
			_tmp12_ = _arg_index;
			_tmp13_ = _arg_size;
			if (!(_tmp12_ < _tmp13_)) {
				break;
			}
			_tmp14_ = _arg_list;
			_tmp15_ = _arg_index;
			_tmp16_ = vala_list_get (_tmp14_, _tmp15_);
			arg = (ValaExpression*) _tmp16_;
			_tmp17_ = arg;
			vala_code_node_accept ((ValaCodeNode*) _tmp17_, visitor);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp18_;
		ValaList* _tmp19_;
		gint _init_size = 0;
		ValaList* _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		gint _init_index = 0;
		_tmp18_ = self->priv->object_initializer;
		_tmp19_ = _vala_iterable_ref0 (_tmp18_);
		_init_list = _tmp19_;
		_tmp20_ = _init_list;
		_tmp21_ = vala_collection_get_size ((ValaCollection*) _tmp20_);
		_tmp22_ = _tmp21_;
		_init_size = _tmp22_;
		_init_index = -1;
		while (TRUE) {
			gint _tmp23_;
			gint _tmp24_;
			gint _tmp25_;
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp26_;
			gint _tmp27_;
			gpointer _tmp28_;
			ValaMemberInitializer* _tmp29_;
			_tmp23_ = _init_index;
			_init_index = _tmp23_ + 1;
			_tmp24_ = _init_index;
			_tmp25_ = _init_size;
			if (!(_tmp24_ < _tmp25_)) {
				break;
			}
			_tmp26_ = _init_list;
			_tmp27_ = _init_index;
			_tmp28_ = vala_list_get (_tmp26_, _tmp27_);
			init = (ValaMemberInitializer*) _tmp28_;
			_tmp29_ = init;
			vala_code_node_accept ((ValaCodeNode*) _tmp29_, visitor);
			_vala_code_node_unref0 (init);
		}
		_vala_iterable_unref0 (_init_list);
	}
}


static void
vala_object_creation_expression_real_replace_expression (ValaCodeNode* base, 
                                                         ValaExpression* old_node, 
                                                         ValaExpression* new_node)
{
	ValaObjectCreationExpression * self;
	gint index = 0;
	ValaList* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gint _tmp2_;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = self->priv->argument_list;
	index = vala_list_index_of (_tmp0_, old_node);
	_tmp2_ = index;
	if (_tmp2_ >= 0) {
		ValaCodeNode* _tmp3_;
		ValaCodeNode* _tmp4_;
		_tmp3_ = vala_code_node_get_parent_node ((ValaCodeNode*) new_node);
		_tmp4_ = _tmp3_;
		_tmp1_ = _tmp4_ == NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		ValaList* _tmp5_;
		gint _tmp6_;
		_tmp5_ = self->priv->argument_list;
		_tmp6_ = index;
		vala_list_set (_tmp5_, _tmp6_, new_node);
		vala_code_node_set_parent_node ((ValaCodeNode*) new_node, (ValaCodeNode*) self);
	}
}


static gboolean
vala_object_creation_expression_real_is_pure (ValaExpression* base)
{
	ValaObjectCreationExpression * self;
	gboolean result = FALSE;
	self = (ValaObjectCreationExpression*) base;
	result = FALSE;
	return result;
}


static gboolean
vala_object_creation_expression_real_is_accessible (ValaExpression* base, 
                                                    ValaSymbol* sym)
{
	ValaObjectCreationExpression * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ValaMemberAccess* _tmp1_;
	self = (ValaObjectCreationExpression*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp1_ = self->priv->_member_name;
	if (_tmp1_ != NULL) {
		ValaMemberAccess* _tmp2_;
		_tmp2_ = self->priv->_member_name;
		_tmp0_ = !vala_expression_is_accessible ((ValaExpression*) _tmp2_, sym);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp3_;
		ValaList* _tmp4_;
		gint _arg_size = 0;
		ValaList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _arg_index = 0;
		_tmp3_ = self->priv->argument_list;
		_tmp4_ = _vala_iterable_ref0 (_tmp3_);
		_arg_list = _tmp4_;
		_tmp5_ = _arg_list;
		_tmp6_ = vala_collection_get_size ((ValaCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_arg_size = _tmp7_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			ValaExpression* arg = NULL;
			ValaList* _tmp11_;
			gint _tmp12_;
			gpointer _tmp13_;
			ValaExpression* _tmp14_;
			_tmp8_ = _arg_index;
			_arg_index = _tmp8_ + 1;
			_tmp9_ = _arg_index;
			_tmp10_ = _arg_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _arg_list;
			_tmp12_ = _arg_index;
			_tmp13_ = vala_list_get (_tmp11_, _tmp12_);
			arg = (ValaExpression*) _tmp13_;
			_tmp14_ = arg;
			if (!vala_expression_is_accessible (_tmp14_, sym)) {
				result = FALSE;
				_vala_code_node_unref0 (arg);
				_vala_iterable_unref0 (_arg_list);
				return result;
			}
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp15_;
		ValaList* _tmp16_;
		gint _init_size = 0;
		ValaList* _tmp17_;
		gint _tmp18_;
		gint _tmp19_;
		gint _init_index = 0;
		_tmp15_ = self->priv->object_initializer;
		_tmp16_ = _vala_iterable_ref0 (_tmp15_);
		_init_list = _tmp16_;
		_tmp17_ = _init_list;
		_tmp18_ = vala_collection_get_size ((ValaCollection*) _tmp17_);
		_tmp19_ = _tmp18_;
		_init_size = _tmp19_;
		_init_index = -1;
		while (TRUE) {
			gint _tmp20_;
			gint _tmp21_;
			gint _tmp22_;
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp23_;
			gint _tmp24_;
			gpointer _tmp25_;
			ValaMemberInitializer* _tmp26_;
			ValaExpression* _tmp27_;
			ValaExpression* _tmp28_;
			_tmp20_ = _init_index;
			_init_index = _tmp20_ + 1;
			_tmp21_ = _init_index;
			_tmp22_ = _init_size;
			if (!(_tmp21_ < _tmp22_)) {
				break;
			}
			_tmp23_ = _init_list;
			_tmp24_ = _init_index;
			_tmp25_ = vala_list_get (_tmp23_, _tmp24_);
			init = (ValaMemberInitializer*) _tmp25_;
			_tmp26_ = init;
			_tmp27_ = vala_member_initializer_get_initializer (_tmp26_);
			_tmp28_ = _tmp27_;
			if (!vala_expression_is_accessible (_tmp28_, sym)) {
				result = FALSE;
				_vala_code_node_unref0 (init);
				_vala_iterable_unref0 (_init_list);
				return result;
			}
			_vala_code_node_unref0 (init);
		}
		_vala_iterable_unref0 (_init_list);
	}
	result = TRUE;
	return result;
}


static void
vala_object_creation_expression_real_replace_type (ValaCodeNode* base, 
                                                   ValaDataType* old_type, 
                                                   ValaDataType* new_type)
{
	ValaObjectCreationExpression * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_object_creation_expression_get_type_reference (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_object_creation_expression_set_type_reference (self, new_type);
	}
}


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static gboolean
vala_object_creation_expression_real_check (ValaCodeNode* base, 
                                            ValaCodeContext* context)
{
	ValaObjectCreationExpression * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaMemberAccess* _tmp4_;
	ValaTypeSymbol* type = NULL;
	ValaDataType* _tmp6_;
	ValaDataType* _tmp7_;
	ValaDataType* _tmp102_;
	ValaDataType* _tmp103_;
	ValaDataType* _tmp104_;
	ValaDataType* _tmp105_;
	ValaDataType* _tmp106_;
	ValaDataType* _tmp107_;
	gboolean may_throw = FALSE;
	gint given_num_type_args = 0;
	ValaDataType* _tmp108_;
	ValaDataType* _tmp109_;
	ValaList* _tmp110_;
	ValaList* _tmp111_;
	gint _tmp112_;
	gint _tmp113_;
	gint _tmp114_;
	gint expected_num_type_args = 0;
	ValaTypeSymbol* _tmp115_;
	gint _tmp237_;
	gint _tmp238_;
	gboolean _tmp245_ = FALSE;
	ValaSymbol* _tmp246_;
	ValaSymbol* _tmp247_;
	ValaSymbol* _tmp259_;
	ValaSymbol* _tmp260_;
	gboolean _tmp502_;
	gboolean _tmp555_;
	gboolean _tmp556_;
	self = (ValaObjectCreationExpression*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = self->priv->_member_name;
	if (_tmp4_ != NULL) {
		ValaMemberAccess* _tmp5_;
		_tmp5_ = self->priv->_member_name;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp5_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			return result;
		}
	}
	type = NULL;
	_tmp6_ = vala_object_creation_expression_get_type_reference (self);
	_tmp7_ = _tmp6_;
	if (_tmp7_ == NULL) {
		ValaMemberAccess* _tmp8_;
		ValaMemberAccess* _tmp11_;
		ValaSymbol* _tmp12_;
		ValaSymbol* _tmp13_;
		ValaSymbol* constructor_sym = NULL;
		ValaMemberAccess* _tmp14_;
		ValaSymbol* _tmp15_;
		ValaSymbol* _tmp16_;
		ValaSymbol* _tmp17_;
		ValaSymbol* type_sym = NULL;
		ValaMemberAccess* _tmp18_;
		ValaSymbol* _tmp19_;
		ValaSymbol* _tmp20_;
		ValaSymbol* _tmp21_;
		ValaList* type_args = NULL;
		ValaMemberAccess* _tmp22_;
		ValaList* _tmp23_;
		ValaSymbol* _tmp24_;
		ValaSymbol* _tmp47_;
		_tmp8_ = self->priv->_member_name;
		if (_tmp8_ == NULL) {
			ValaSourceReference* _tmp9_;
			ValaSourceReference* _tmp10_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp9_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp10_ = _tmp9_;
			vala_report_error (_tmp10_, "Incomplete object creation expression");
			result = FALSE;
			_vala_code_node_unref0 (type);
			return result;
		}
		_tmp11_ = self->priv->_member_name;
		_tmp12_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp11_);
		_tmp13_ = _tmp12_;
		if (_tmp13_ == NULL) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (type);
			return result;
		}
		_tmp14_ = self->priv->_member_name;
		_tmp15_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = _vala_code_node_ref0 (_tmp16_);
		constructor_sym = _tmp17_;
		_tmp18_ = self->priv->_member_name;
		_tmp19_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = _vala_code_node_ref0 (_tmp20_);
		type_sym = _tmp21_;
		_tmp22_ = self->priv->_member_name;
		_tmp23_ = vala_member_access_get_type_arguments (_tmp22_);
		type_args = _tmp23_;
		_tmp24_ = constructor_sym;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp24_, VALA_TYPE_METHOD)) {
			ValaSymbol* _tmp25_;
			ValaSymbol* _tmp26_;
			ValaSymbol* _tmp27_;
			ValaSymbol* _tmp28_;
			ValaMethod* constructor = NULL;
			ValaSymbol* _tmp29_;
			ValaMethod* _tmp30_;
			ValaSymbol* _tmp31_;
			ValaMethod* _tmp39_;
			ValaMemberAccess* ma = NULL;
			ValaMemberAccess* _tmp40_;
			ValaExpression* _tmp41_;
			ValaExpression* _tmp42_;
			ValaMemberAccess* _tmp43_;
			ValaMemberAccess* _tmp44_;
			_tmp25_ = constructor_sym;
			_tmp26_ = vala_symbol_get_parent_symbol (_tmp25_);
			_tmp27_ = _tmp26_;
			_tmp28_ = _vala_code_node_ref0 (_tmp27_);
			_vala_code_node_unref0 (type_sym);
			type_sym = _tmp28_;
			_tmp29_ = constructor_sym;
			_tmp30_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, VALA_TYPE_METHOD, ValaMethod));
			constructor = _tmp30_;
			_tmp31_ = constructor_sym;
			if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp31_, VALA_TYPE_CREATION_METHOD)) {
				ValaSourceReference* _tmp32_;
				ValaSourceReference* _tmp33_;
				ValaMethod* _tmp34_;
				gchar* _tmp35_;
				gchar* _tmp36_;
				gchar* _tmp37_;
				gchar* _tmp38_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp32_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp33_ = _tmp32_;
				_tmp34_ = constructor;
				_tmp35_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp34_);
				_tmp36_ = _tmp35_;
				_tmp37_ = g_strdup_printf ("`%s' is not a creation method", _tmp36_);
				_tmp38_ = _tmp37_;
				vala_report_error (_tmp33_, _tmp38_);
				_g_free0 (_tmp38_);
				_g_free0 (_tmp36_);
				result = FALSE;
				_vala_code_node_unref0 (constructor);
				_vala_iterable_unref0 (type_args);
				_vala_code_node_unref0 (type_sym);
				_vala_code_node_unref0 (constructor_sym);
				_vala_code_node_unref0 (type);
				return result;
			}
			_tmp39_ = constructor;
			vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp39_);
			_tmp40_ = self->priv->_member_name;
			_tmp41_ = vala_member_access_get_inner (_tmp40_);
			_tmp42_ = _tmp41_;
			_tmp43_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp42_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp42_) : NULL);
			ma = _tmp43_;
			_tmp44_ = ma;
			if (_tmp44_ != NULL) {
				ValaMemberAccess* _tmp45_;
				ValaList* _tmp46_;
				_tmp45_ = ma;
				_tmp46_ = vala_member_access_get_type_arguments (_tmp45_);
				_vala_iterable_unref0 (type_args);
				type_args = _tmp46_;
			}
			_vala_code_node_unref0 (ma);
			_vala_code_node_unref0 (constructor);
		}
		_tmp47_ = type_sym;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp47_, VALA_TYPE_CLASS)) {
			ValaSymbol* _tmp48_;
			ValaTypeSymbol* _tmp49_;
			ValaTypeSymbol* _tmp50_;
			gboolean _tmp51_;
			gboolean _tmp52_;
			_tmp48_ = type_sym;
			_tmp49_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
			_vala_code_node_unref0 (type);
			type = _tmp49_;
			_tmp50_ = type;
			_tmp51_ = vala_class_get_is_error_base (G_TYPE_CHECK_INSTANCE_CAST (_tmp50_, VALA_TYPE_CLASS, ValaClass));
			_tmp52_ = _tmp51_;
			if (_tmp52_) {
				ValaSourceReference* _tmp53_;
				ValaSourceReference* _tmp54_;
				ValaErrorType* _tmp55_;
				ValaErrorType* _tmp56_;
				_tmp53_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp54_ = _tmp53_;
				_tmp55_ = vala_error_type_new (NULL, NULL, _tmp54_);
				_tmp56_ = _tmp55_;
				vala_object_creation_expression_set_type_reference (self, (ValaDataType*) _tmp56_);
				_vala_code_node_unref0 (_tmp56_);
			} else {
				ValaTypeSymbol* _tmp57_;
				ValaObjectType* _tmp58_;
				ValaObjectType* _tmp59_;
				_tmp57_ = type;
				_tmp58_ = vala_object_type_new ((ValaObjectTypeSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp57_, VALA_TYPE_CLASS, ValaClass));
				_tmp59_ = _tmp58_;
				vala_object_creation_expression_set_type_reference (self, (ValaDataType*) _tmp59_);
				_vala_code_node_unref0 (_tmp59_);
			}
		} else {
			ValaSymbol* _tmp60_;
			_tmp60_ = type_sym;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp60_, VALA_TYPE_STRUCT)) {
				ValaSymbol* _tmp61_;
				ValaTypeSymbol* _tmp62_;
				ValaTypeSymbol* _tmp63_;
				ValaStructValueType* _tmp64_;
				ValaStructValueType* _tmp65_;
				_tmp61_ = type_sym;
				_tmp62_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp61_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
				_vala_code_node_unref0 (type);
				type = _tmp62_;
				_tmp63_ = type;
				_tmp64_ = vala_struct_value_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp63_, VALA_TYPE_STRUCT, ValaStruct));
				_tmp65_ = _tmp64_;
				vala_object_creation_expression_set_type_reference (self, (ValaDataType*) _tmp65_);
				_vala_code_node_unref0 (_tmp65_);
			} else {
				ValaSymbol* _tmp66_;
				_tmp66_ = type_sym;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp66_, VALA_TYPE_ERROR_CODE)) {
					ValaSymbol* _tmp67_;
					ValaSymbol* _tmp68_;
					ValaSymbol* _tmp69_;
					ValaSymbol* _tmp70_;
					ValaSourceReference* _tmp71_;
					ValaSourceReference* _tmp72_;
					ValaErrorType* _tmp73_;
					ValaErrorType* _tmp74_;
					ValaSymbol* _tmp75_;
					_tmp67_ = type_sym;
					_tmp68_ = vala_symbol_get_parent_symbol (_tmp67_);
					_tmp69_ = _tmp68_;
					_tmp70_ = type_sym;
					_tmp71_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp72_ = _tmp71_;
					_tmp73_ = vala_error_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp69_, VALA_TYPE_ERROR_DOMAIN, ValaErrorDomain), G_TYPE_CHECK_INSTANCE_CAST (_tmp70_, VALA_TYPE_ERROR_CODE, ValaErrorCode), _tmp72_);
					_tmp74_ = _tmp73_;
					vala_object_creation_expression_set_type_reference (self, (ValaDataType*) _tmp74_);
					_vala_code_node_unref0 (_tmp74_);
					_tmp75_ = type_sym;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp75_);
				} else {
					ValaSourceReference* _tmp76_;
					ValaSourceReference* _tmp77_;
					ValaSymbol* _tmp78_;
					gchar* _tmp79_;
					gchar* _tmp80_;
					gchar* _tmp81_;
					gchar* _tmp82_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp76_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp77_ = _tmp76_;
					_tmp78_ = type_sym;
					_tmp79_ = vala_symbol_get_full_name (_tmp78_);
					_tmp80_ = _tmp79_;
					_tmp81_ = g_strdup_printf ("`%s' is not a class, struct, or error code", _tmp80_);
					_tmp82_ = _tmp81_;
					vala_report_error (_tmp77_, _tmp82_);
					_g_free0 (_tmp82_);
					_g_free0 (_tmp80_);
					result = FALSE;
					_vala_iterable_unref0 (type_args);
					_vala_code_node_unref0 (type_sym);
					_vala_code_node_unref0 (constructor_sym);
					_vala_code_node_unref0 (type);
					return result;
				}
			}
		}
		{
			ValaList* _type_arg_list = NULL;
			ValaList* _tmp83_;
			ValaList* _tmp84_;
			gint _type_arg_size = 0;
			ValaList* _tmp85_;
			gint _tmp86_;
			gint _tmp87_;
			gint _type_arg_index = 0;
			_tmp83_ = type_args;
			_tmp84_ = _vala_iterable_ref0 (_tmp83_);
			_type_arg_list = _tmp84_;
			_tmp85_ = _type_arg_list;
			_tmp86_ = vala_collection_get_size ((ValaCollection*) _tmp85_);
			_tmp87_ = _tmp86_;
			_type_arg_size = _tmp87_;
			_type_arg_index = -1;
			while (TRUE) {
				gint _tmp88_;
				gint _tmp89_;
				gint _tmp90_;
				ValaDataType* type_arg = NULL;
				ValaList* _tmp91_;
				gint _tmp92_;
				gpointer _tmp93_;
				ValaDataType* _tmp94_;
				ValaDataType* _tmp95_;
				ValaDataType* _tmp96_;
				_tmp88_ = _type_arg_index;
				_type_arg_index = _tmp88_ + 1;
				_tmp89_ = _type_arg_index;
				_tmp90_ = _type_arg_size;
				if (!(_tmp89_ < _tmp90_)) {
					break;
				}
				_tmp91_ = _type_arg_list;
				_tmp92_ = _type_arg_index;
				_tmp93_ = vala_list_get (_tmp91_, _tmp92_);
				type_arg = (ValaDataType*) _tmp93_;
				_tmp94_ = vala_object_creation_expression_get_type_reference (self);
				_tmp95_ = _tmp94_;
				_tmp96_ = type_arg;
				vala_data_type_add_type_argument (_tmp95_, _tmp96_);
				_vala_code_node_unref0 (type_arg);
			}
			_vala_iterable_unref0 (_type_arg_list);
		}
		_vala_iterable_unref0 (type_args);
		_vala_code_node_unref0 (type_sym);
		_vala_code_node_unref0 (constructor_sym);
	} else {
		ValaDataType* _tmp97_;
		ValaDataType* _tmp98_;
		ValaTypeSymbol* _tmp99_;
		ValaTypeSymbol* _tmp100_;
		ValaTypeSymbol* _tmp101_;
		_tmp97_ = vala_object_creation_expression_get_type_reference (self);
		_tmp98_ = _tmp97_;
		_tmp99_ = vala_data_type_get_data_type (_tmp98_);
		_tmp100_ = _tmp99_;
		_tmp101_ = _vala_code_node_ref0 (_tmp100_);
		_vala_code_node_unref0 (type);
		type = _tmp101_;
	}
	_tmp102_ = vala_object_creation_expression_get_type_reference (self);
	_tmp103_ = _tmp102_;
	_tmp104_ = vala_data_type_copy (_tmp103_);
	_tmp105_ = _tmp104_;
	vala_expression_set_value_type ((ValaExpression*) self, _tmp105_);
	_vala_code_node_unref0 (_tmp105_);
	_tmp106_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp107_ = _tmp106_;
	vala_data_type_set_value_owned (_tmp107_, TRUE);
	may_throw = FALSE;
	_tmp108_ = vala_object_creation_expression_get_type_reference (self);
	_tmp109_ = _tmp108_;
	_tmp110_ = vala_data_type_get_type_arguments (_tmp109_);
	_tmp111_ = _tmp110_;
	_tmp112_ = vala_collection_get_size ((ValaCollection*) _tmp111_);
	_tmp113_ = _tmp112_;
	_tmp114_ = _tmp113_;
	_vala_iterable_unref0 (_tmp111_);
	given_num_type_args = _tmp114_;
	expected_num_type_args = 0;
	_tmp115_ = type;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp115_, VALA_TYPE_CLASS)) {
		ValaClass* cl = NULL;
		ValaTypeSymbol* _tmp116_;
		ValaClass* _tmp117_;
		ValaClass* _tmp118_;
		ValaList* _tmp119_;
		ValaList* _tmp120_;
		gint _tmp121_;
		gint _tmp122_;
		gboolean _tmp123_;
		ValaClass* _tmp126_;
		gboolean _tmp127_;
		gboolean _tmp128_;
		ValaSymbol* _tmp136_;
		ValaSymbol* _tmp137_;
		gboolean _tmp158_ = FALSE;
		ValaSymbol* _tmp159_;
		ValaSymbol* _tmp160_;
		_tmp116_ = type;
		_tmp117_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp116_, VALA_TYPE_CLASS, ValaClass));
		cl = _tmp117_;
		_tmp118_ = cl;
		_tmp119_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) _tmp118_);
		_tmp120_ = _tmp119_;
		_tmp121_ = vala_collection_get_size ((ValaCollection*) _tmp120_);
		_tmp122_ = _tmp121_;
		expected_num_type_args = _tmp122_;
		_vala_iterable_unref0 (_tmp120_);
		_tmp123_ = self->priv->_struct_creation;
		if (_tmp123_) {
			ValaSourceReference* _tmp124_;
			ValaSourceReference* _tmp125_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp124_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp125_ = _tmp124_;
			vala_report_error (_tmp125_, "syntax error, use `new' to create new objects");
			result = FALSE;
			_vala_code_node_unref0 (cl);
			_vala_code_node_unref0 (type);
			return result;
		}
		_tmp126_ = cl;
		_tmp127_ = vala_class_get_is_abstract (_tmp126_);
		_tmp128_ = _tmp127_;
		if (_tmp128_) {
			ValaSourceReference* _tmp129_;
			ValaSourceReference* _tmp130_;
			ValaClass* _tmp131_;
			gchar* _tmp132_;
			gchar* _tmp133_;
			gchar* _tmp134_;
			gchar* _tmp135_;
			vala_expression_set_value_type ((ValaExpression*) self, NULL);
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp129_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp130_ = _tmp129_;
			_tmp131_ = cl;
			_tmp132_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp131_);
			_tmp133_ = _tmp132_;
			_tmp134_ = g_strdup_printf ("Can't create instance of abstract class `%s'", _tmp133_);
			_tmp135_ = _tmp134_;
			vala_report_error (_tmp130_, _tmp135_);
			_g_free0 (_tmp135_);
			_g_free0 (_tmp133_);
			result = FALSE;
			_vala_code_node_unref0 (cl);
			_vala_code_node_unref0 (type);
			return result;
		}
		_tmp136_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp137_ = _tmp136_;
		if (_tmp137_ == NULL) {
			ValaClass* _tmp138_;
			ValaCreationMethod* _tmp139_;
			ValaCreationMethod* _tmp140_;
			ValaSymbol* _tmp141_;
			ValaSymbol* _tmp142_;
			ValaSymbol* _tmp150_;
			ValaSymbol* _tmp151_;
			ValaSymbol* _tmp152_;
			ValaSymbol* _tmp153_;
			ValaVersionAttribute* _tmp154_;
			ValaVersionAttribute* _tmp155_;
			ValaSourceReference* _tmp156_;
			ValaSourceReference* _tmp157_;
			_tmp138_ = cl;
			_tmp139_ = vala_class_get_default_construction_method (_tmp138_);
			_tmp140_ = _tmp139_;
			vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp140_);
			_tmp141_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp142_ = _tmp141_;
			if (_tmp142_ == NULL) {
				ValaSourceReference* _tmp143_;
				ValaSourceReference* _tmp144_;
				ValaClass* _tmp145_;
				gchar* _tmp146_;
				gchar* _tmp147_;
				gchar* _tmp148_;
				gchar* _tmp149_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp143_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp144_ = _tmp143_;
				_tmp145_ = cl;
				_tmp146_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp145_);
				_tmp147_ = _tmp146_;
				_tmp148_ = g_strdup_printf ("`%s' does not have a default constructor", _tmp147_);
				_tmp149_ = _tmp148_;
				vala_report_error (_tmp144_, _tmp149_);
				_g_free0 (_tmp149_);
				_g_free0 (_tmp147_);
				result = FALSE;
				_vala_code_node_unref0 (cl);
				_vala_code_node_unref0 (type);
				return result;
			}
			_tmp150_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp151_ = _tmp150_;
			vala_symbol_set_used (_tmp151_, TRUE);
			_tmp152_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp153_ = _tmp152_;
			_tmp154_ = vala_symbol_get_version (_tmp153_);
			_tmp155_ = _tmp154_;
			_tmp156_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp157_ = _tmp156_;
			vala_version_attribute_check (_tmp155_, _tmp157_);
		}
		_tmp159_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp160_ = _tmp159_;
		if (_tmp160_ != NULL) {
			gboolean _tmp161_ = FALSE;
			ValaSymbol* _tmp162_;
			ValaSymbol* _tmp163_;
			ValaSymbolAccessibility _tmp164_;
			ValaSymbolAccessibility _tmp165_;
			_tmp162_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp163_ = _tmp162_;
			_tmp164_ = vala_symbol_get_access (_tmp163_);
			_tmp165_ = _tmp164_;
			if (_tmp165_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
				_tmp161_ = TRUE;
			} else {
				ValaSymbol* _tmp166_;
				ValaSymbol* _tmp167_;
				ValaSymbolAccessibility _tmp168_;
				ValaSymbolAccessibility _tmp169_;
				_tmp166_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp167_ = _tmp166_;
				_tmp168_ = vala_symbol_get_access (_tmp167_);
				_tmp169_ = _tmp168_;
				_tmp161_ = _tmp169_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED;
			}
			_tmp158_ = _tmp161_;
		} else {
			_tmp158_ = FALSE;
		}
		if (_tmp158_) {
			gboolean in_target_type = FALSE;
			gboolean _tmp183_;
			in_target_type = FALSE;
			{
				ValaSymbol* this_symbol = NULL;
				ValaSemanticAnalyzer* _tmp170_;
				ValaSemanticAnalyzer* _tmp171_;
				ValaSymbol* _tmp172_;
				ValaSymbol* _tmp173_;
				ValaSymbol* _tmp174_;
				_tmp170_ = vala_code_context_get_analyzer (context);
				_tmp171_ = _tmp170_;
				_tmp172_ = vala_semantic_analyzer_get_current_symbol (_tmp171_);
				_tmp173_ = _tmp172_;
				_tmp174_ = _vala_code_node_ref0 (_tmp173_);
				this_symbol = _tmp174_;
				{
					gboolean _tmp175_ = FALSE;
					_tmp175_ = TRUE;
					while (TRUE) {
						ValaSymbol* _tmp180_;
						ValaSymbol* _tmp181_;
						ValaClass* _tmp182_;
						if (!_tmp175_) {
							ValaSymbol* _tmp176_;
							ValaSymbol* _tmp177_;
							ValaSymbol* _tmp178_;
							ValaSymbol* _tmp179_;
							_tmp176_ = this_symbol;
							_tmp177_ = vala_symbol_get_parent_symbol (_tmp176_);
							_tmp178_ = _tmp177_;
							_tmp179_ = _vala_code_node_ref0 (_tmp178_);
							_vala_code_node_unref0 (this_symbol);
							this_symbol = _tmp179_;
						}
						_tmp175_ = FALSE;
						_tmp180_ = this_symbol;
						if (!(_tmp180_ != NULL)) {
							break;
						}
						_tmp181_ = this_symbol;
						_tmp182_ = cl;
						if (_tmp181_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp182_, VALA_TYPE_SYMBOL, ValaSymbol)) {
							in_target_type = TRUE;
							break;
						}
					}
				}
				_vala_code_node_unref0 (this_symbol);
			}
			_tmp183_ = in_target_type;
			if (!_tmp183_) {
				ValaSourceReference* _tmp184_;
				ValaSourceReference* _tmp185_;
				ValaSymbol* _tmp186_;
				ValaSymbol* _tmp187_;
				gchar* _tmp188_;
				gchar* _tmp189_;
				gchar* _tmp190_;
				gchar* _tmp191_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp184_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp185_ = _tmp184_;
				_tmp186_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp187_ = _tmp186_;
				_tmp188_ = vala_symbol_get_full_name (_tmp187_);
				_tmp189_ = _tmp188_;
				_tmp190_ = g_strdup_printf ("Access to non-public constructor `%s' denied", _tmp189_);
				_tmp191_ = _tmp190_;
				vala_report_error (_tmp185_, _tmp191_);
				_g_free0 (_tmp191_);
				_g_free0 (_tmp189_);
				result = FALSE;
				_vala_code_node_unref0 (cl);
				_vala_code_node_unref0 (type);
				return result;
			}
		}
		while (TRUE) {
			ValaClass* _tmp192_;
			ValaClass* _tmp193_;
			gchar* _tmp194_;
			gchar* _tmp195_;
			gboolean _tmp196_;
			ValaClass* _tmp199_;
			ValaClass* _tmp200_;
			ValaClass* _tmp201_;
			ValaClass* _tmp202_;
			_tmp192_ = cl;
			if (!(_tmp192_ != NULL)) {
				break;
			}
			_tmp193_ = cl;
			_tmp194_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp193_, "CCode", "ref_sink_function", NULL);
			_tmp195_ = _tmp194_;
			_tmp196_ = _tmp195_ != NULL;
			_g_free0 (_tmp195_);
			if (_tmp196_) {
				ValaDataType* _tmp197_;
				ValaDataType* _tmp198_;
				_tmp197_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp198_ = _tmp197_;
				vala_data_type_set_floating_reference (_tmp198_, TRUE);
				break;
			}
			_tmp199_ = cl;
			_tmp200_ = vala_class_get_base_class (_tmp199_);
			_tmp201_ = _tmp200_;
			_tmp202_ = _vala_code_node_ref0 (_tmp201_);
			_vala_code_node_unref0 (cl);
			cl = _tmp202_;
		}
		_vala_code_node_unref0 (cl);
	} else {
		ValaTypeSymbol* _tmp203_;
		_tmp203_ = type;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp203_, VALA_TYPE_STRUCT)) {
			ValaStruct* st = NULL;
			ValaTypeSymbol* _tmp204_;
			ValaStruct* _tmp205_;
			ValaStruct* _tmp206_;
			ValaList* _tmp207_;
			ValaList* _tmp208_;
			gint _tmp209_;
			gint _tmp210_;
			gboolean _tmp211_ = FALSE;
			gboolean _tmp212_;
			ValaSymbol* _tmp217_;
			ValaSymbol* _tmp218_;
			gboolean _tmp222_ = FALSE;
			gboolean _tmp223_ = FALSE;
			ValaStruct* _tmp224_;
			_tmp204_ = type;
			_tmp205_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp204_, VALA_TYPE_STRUCT, ValaStruct));
			st = _tmp205_;
			_tmp206_ = st;
			_tmp207_ = vala_struct_get_type_parameters (_tmp206_);
			_tmp208_ = _tmp207_;
			_tmp209_ = vala_collection_get_size ((ValaCollection*) _tmp208_);
			_tmp210_ = _tmp209_;
			expected_num_type_args = _tmp210_;
			_vala_iterable_unref0 (_tmp208_);
			_tmp212_ = self->priv->_struct_creation;
			if (!_tmp212_) {
				gboolean _tmp213_;
				gboolean _tmp214_;
				_tmp213_ = vala_code_context_get_deprecated (context);
				_tmp214_ = _tmp213_;
				_tmp211_ = !_tmp214_;
			} else {
				_tmp211_ = FALSE;
			}
			if (_tmp211_) {
				ValaSourceReference* _tmp215_;
				ValaSourceReference* _tmp216_;
				_tmp215_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp216_ = _tmp215_;
				vala_report_warning (_tmp216_, "deprecated syntax, don't use `new' to initialize structs");
			}
			_tmp217_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp218_ = _tmp217_;
			if (_tmp218_ == NULL) {
				ValaStruct* _tmp219_;
				ValaMethod* _tmp220_;
				ValaMethod* _tmp221_;
				_tmp219_ = st;
				_tmp220_ = vala_struct_get_default_construction_method (_tmp219_);
				_tmp221_ = _tmp220_;
				vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp221_);
			}
			_tmp224_ = st;
			if (vala_struct_is_simple_type (_tmp224_)) {
				ValaSymbol* _tmp225_;
				ValaSymbol* _tmp226_;
				_tmp225_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp226_ = _tmp225_;
				_tmp223_ = _tmp226_ == NULL;
			} else {
				_tmp223_ = FALSE;
			}
			if (_tmp223_) {
				ValaList* _tmp227_;
				gint _tmp228_;
				gint _tmp229_;
				_tmp227_ = self->priv->object_initializer;
				_tmp228_ = vala_collection_get_size ((ValaCollection*) _tmp227_);
				_tmp229_ = _tmp228_;
				_tmp222_ = _tmp229_ == 0;
			} else {
				_tmp222_ = FALSE;
			}
			if (_tmp222_) {
				ValaSourceReference* _tmp230_;
				ValaSourceReference* _tmp231_;
				ValaStruct* _tmp232_;
				gchar* _tmp233_;
				gchar* _tmp234_;
				gchar* _tmp235_;
				gchar* _tmp236_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp230_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp231_ = _tmp230_;
				_tmp232_ = st;
				_tmp233_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp232_);
				_tmp234_ = _tmp233_;
				_tmp235_ = g_strdup_printf ("`%s' does not have a default constructor", _tmp234_);
				_tmp236_ = _tmp235_;
				vala_report_error (_tmp231_, _tmp236_);
				_g_free0 (_tmp236_);
				_g_free0 (_tmp234_);
				result = FALSE;
				_vala_code_node_unref0 (st);
				_vala_code_node_unref0 (type);
				return result;
			}
			_vala_code_node_unref0 (st);
		}
	}
	_tmp237_ = expected_num_type_args;
	_tmp238_ = given_num_type_args;
	if (_tmp237_ > _tmp238_) {
		ValaSourceReference* _tmp239_;
		ValaSourceReference* _tmp240_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp239_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp240_ = _tmp239_;
		vala_report_error (_tmp240_, "too few type arguments");
		result = FALSE;
		_vala_code_node_unref0 (type);
		return result;
	} else {
		gint _tmp241_;
		gint _tmp242_;
		_tmp241_ = expected_num_type_args;
		_tmp242_ = given_num_type_args;
		if (_tmp241_ < _tmp242_) {
			ValaSourceReference* _tmp243_;
			ValaSourceReference* _tmp244_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp243_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp244_ = _tmp243_;
			vala_report_error (_tmp244_, "too many type arguments");
			result = FALSE;
			_vala_code_node_unref0 (type);
			return result;
		}
	}
	_tmp246_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp247_ = _tmp246_;
	if (_tmp247_ == NULL) {
		ValaList* _tmp248_;
		ValaList* _tmp249_;
		gint _tmp250_;
		gint _tmp251_;
		_tmp248_ = vala_object_creation_expression_get_argument_list (self);
		_tmp249_ = _tmp248_;
		_tmp250_ = vala_collection_get_size ((ValaCollection*) _tmp249_);
		_tmp251_ = _tmp250_;
		_tmp245_ = _tmp251_ != 0;
		_vala_iterable_unref0 (_tmp249_);
	} else {
		_tmp245_ = FALSE;
	}
	if (_tmp245_) {
		ValaSourceReference* _tmp252_;
		ValaSourceReference* _tmp253_;
		ValaTypeSymbol* _tmp254_;
		gchar* _tmp255_;
		gchar* _tmp256_;
		gchar* _tmp257_;
		gchar* _tmp258_;
		vala_expression_set_value_type ((ValaExpression*) self, NULL);
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp252_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp253_ = _tmp252_;
		_tmp254_ = type;
		_tmp255_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp254_);
		_tmp256_ = _tmp255_;
		_tmp257_ = g_strdup_printf ("No arguments allowed when constructing type `%s'", _tmp256_);
		_tmp258_ = _tmp257_;
		vala_report_error (_tmp253_, _tmp258_);
		_g_free0 (_tmp258_);
		_g_free0 (_tmp256_);
		result = FALSE;
		_vala_code_node_unref0 (type);
		return result;
	}
	_tmp259_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp260_ = _tmp259_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp260_, VALA_TYPE_METHOD)) {
		ValaMethod* m = NULL;
		ValaSymbol* _tmp261_;
		ValaSymbol* _tmp262_;
		ValaMethod* _tmp263_;
		gboolean _tmp264_;
		ValaExpression* last_arg = NULL;
		ValaList* args = NULL;
		ValaList* _tmp283_;
		ValaIterator* arg_it = NULL;
		ValaList* _tmp284_;
		ValaIterator* _tmp285_;
		ValaMethod* _tmp317_;
		gboolean _tmp318_;
		gboolean _tmp319_;
		ValaSemanticAnalyzer* _tmp383_;
		ValaSemanticAnalyzer* _tmp384_;
		ValaMethod* _tmp385_;
		ValaMethodType* _tmp386_;
		ValaMethodType* _tmp387_;
		ValaMethod* _tmp388_;
		ValaList* _tmp389_;
		ValaList* _tmp390_;
		ValaList* _tmp391_;
		_tmp261_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp262_ = _tmp261_;
		_tmp263_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp262_, VALA_TYPE_METHOD, ValaMethod));
		m = _tmp263_;
		_tmp264_ = self->priv->_is_yield_expression;
		if (_tmp264_) {
			ValaMethod* _tmp265_;
			gboolean _tmp266_;
			gboolean _tmp267_;
			gboolean _tmp270_ = FALSE;
			ValaSemanticAnalyzer* _tmp271_;
			ValaSemanticAnalyzer* _tmp272_;
			ValaMethod* _tmp273_;
			ValaMethod* _tmp274_;
			_tmp265_ = m;
			_tmp266_ = vala_method_get_coroutine (_tmp265_);
			_tmp267_ = _tmp266_;
			if (!_tmp267_) {
				ValaSourceReference* _tmp268_;
				ValaSourceReference* _tmp269_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp268_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp269_ = _tmp268_;
				vala_report_error (_tmp269_, "yield expression requires async method");
			}
			_tmp271_ = vala_code_context_get_analyzer (context);
			_tmp272_ = _tmp271_;
			_tmp273_ = vala_semantic_analyzer_get_current_method (_tmp272_);
			_tmp274_ = _tmp273_;
			if (_tmp274_ == NULL) {
				_tmp270_ = TRUE;
			} else {
				ValaSemanticAnalyzer* _tmp275_;
				ValaSemanticAnalyzer* _tmp276_;
				ValaMethod* _tmp277_;
				ValaMethod* _tmp278_;
				gboolean _tmp279_;
				gboolean _tmp280_;
				_tmp275_ = vala_code_context_get_analyzer (context);
				_tmp276_ = _tmp275_;
				_tmp277_ = vala_semantic_analyzer_get_current_method (_tmp276_);
				_tmp278_ = _tmp277_;
				_tmp279_ = vala_method_get_coroutine (_tmp278_);
				_tmp280_ = _tmp279_;
				_tmp270_ = !_tmp280_;
			}
			if (_tmp270_) {
				ValaSourceReference* _tmp281_;
				ValaSourceReference* _tmp282_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp281_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp282_ = _tmp281_;
				vala_report_error (_tmp282_, "yield expression not available outside async method");
			}
		}
		last_arg = NULL;
		_tmp283_ = vala_object_creation_expression_get_argument_list (self);
		args = _tmp283_;
		_tmp284_ = args;
		_tmp285_ = vala_iterable_iterator ((ValaIterable*) _tmp284_);
		arg_it = _tmp285_;
		{
			ValaList* _param_list = NULL;
			ValaMethod* _tmp286_;
			ValaList* _tmp287_;
			gint _param_size = 0;
			ValaList* _tmp288_;
			gint _tmp289_;
			gint _tmp290_;
			gint _param_index = 0;
			_tmp286_ = m;
			_tmp287_ = vala_callable_get_parameters ((ValaCallable*) _tmp286_);
			_param_list = _tmp287_;
			_tmp288_ = _param_list;
			_tmp289_ = vala_collection_get_size ((ValaCollection*) _tmp288_);
			_tmp290_ = _tmp289_;
			_param_size = _tmp290_;
			_param_index = -1;
			while (TRUE) {
				gint _tmp291_;
				gint _tmp292_;
				gint _tmp293_;
				ValaParameter* param = NULL;
				ValaList* _tmp294_;
				gint _tmp295_;
				gpointer _tmp296_;
				ValaParameter* _tmp297_;
				gboolean _tmp298_;
				gboolean _tmp299_;
				ValaIterator* _tmp300_;
				_tmp291_ = _param_index;
				_param_index = _tmp291_ + 1;
				_tmp292_ = _param_index;
				_tmp293_ = _param_size;
				if (!(_tmp292_ < _tmp293_)) {
					break;
				}
				_tmp294_ = _param_list;
				_tmp295_ = _param_index;
				_tmp296_ = vala_list_get (_tmp294_, _tmp295_);
				param = (ValaParameter*) _tmp296_;
				_tmp297_ = param;
				_tmp298_ = vala_parameter_get_ellipsis (_tmp297_);
				_tmp299_ = _tmp298_;
				if (_tmp299_) {
					_vala_code_node_unref0 (param);
					break;
				}
				_tmp300_ = arg_it;
				if (vala_iterator_next (_tmp300_)) {
					ValaExpression* arg = NULL;
					ValaIterator* _tmp301_;
					gpointer _tmp302_;
					ValaExpression* _tmp303_;
					ValaParameter* _tmp304_;
					ValaDataType* _tmp305_;
					ValaDataType* _tmp306_;
					ValaExpression* _tmp307_;
					ValaExpression* _tmp308_;
					ValaDataType* _tmp309_;
					ValaDataType* _tmp310_;
					ValaDataType* _tmp311_;
					ValaDataType* _tmp312_;
					ValaDataType* _tmp313_;
					ValaDataType* _tmp314_;
					ValaExpression* _tmp315_;
					ValaExpression* _tmp316_;
					_tmp301_ = arg_it;
					_tmp302_ = vala_iterator_get (_tmp301_);
					arg = (ValaExpression*) _tmp302_;
					_tmp303_ = arg;
					_tmp304_ = param;
					_tmp305_ = vala_variable_get_variable_type ((ValaVariable*) _tmp304_);
					_tmp306_ = _tmp305_;
					vala_expression_set_formal_target_type (_tmp303_, _tmp306_);
					_tmp307_ = arg;
					_tmp308_ = arg;
					_tmp309_ = vala_expression_get_formal_target_type (_tmp308_);
					_tmp310_ = _tmp309_;
					_tmp311_ = vala_expression_get_value_type ((ValaExpression*) self);
					_tmp312_ = _tmp311_;
					_tmp313_ = vala_data_type_get_actual_type (_tmp310_, _tmp312_, NULL, (ValaCodeNode*) self);
					_tmp314_ = _tmp313_;
					vala_expression_set_target_type (_tmp307_, _tmp314_);
					_vala_code_node_unref0 (_tmp314_);
					_tmp315_ = arg;
					_tmp316_ = _vala_code_node_ref0 (_tmp315_);
					_vala_code_node_unref0 (last_arg);
					last_arg = _tmp316_;
					_vala_code_node_unref0 (arg);
				}
				_vala_code_node_unref0 (param);
			}
			_vala_iterable_unref0 (_param_list);
		}
		_tmp317_ = m;
		_tmp318_ = vala_method_get_printf_format (_tmp317_);
		_tmp319_ = _tmp318_;
		if (_tmp319_) {
			ValaStringLiteral* format_literal = NULL;
			ValaExpression* _tmp320_;
			ValaStringLiteral* _tmp362_;
			format_literal = NULL;
			_tmp320_ = last_arg;
			if (_tmp320_ != NULL) {
				ValaExpression* _tmp321_;
				ValaStringLiteral* _tmp322_;
				gboolean _tmp323_ = FALSE;
				ValaStringLiteral* _tmp324_;
				_tmp321_ = last_arg;
				_tmp322_ = vala_string_literal_get_format_literal (_tmp321_);
				_vala_code_node_unref0 (format_literal);
				format_literal = _tmp322_;
				_tmp324_ = format_literal;
				if (_tmp324_ == NULL) {
					ValaList* _tmp325_;
					gint _tmp326_;
					gint _tmp327_;
					ValaMethod* _tmp328_;
					ValaList* _tmp329_;
					ValaList* _tmp330_;
					gint _tmp331_;
					gint _tmp332_;
					_tmp325_ = args;
					_tmp326_ = vala_collection_get_size ((ValaCollection*) _tmp325_);
					_tmp327_ = _tmp326_;
					_tmp328_ = m;
					_tmp329_ = vala_callable_get_parameters ((ValaCallable*) _tmp328_);
					_tmp330_ = _tmp329_;
					_tmp331_ = vala_collection_get_size ((ValaCollection*) _tmp330_);
					_tmp332_ = _tmp331_;
					_tmp323_ = _tmp327_ == (_tmp332_ - 1);
					_vala_iterable_unref0 (_tmp330_);
				} else {
					_tmp323_ = FALSE;
				}
				if (_tmp323_) {
					ValaStringLiteral* _tmp333_;
					ValaStringLiteral* _tmp334_;
					ValaSemanticAnalyzer* _tmp335_;
					ValaSemanticAnalyzer* _tmp336_;
					ValaDataType* _tmp337_;
					ValaDataType* _tmp338_;
					ValaDataType* _tmp339_;
					ValaList* _tmp340_;
					ValaList* _tmp341_;
					gint _tmp342_;
					gint _tmp343_;
					ValaStringLiteral* _tmp344_;
					ValaList* _tmp345_;
					ValaIterator* _tmp346_;
					_tmp333_ = vala_string_literal_new ("\"%s\"", NULL);
					_vala_code_node_unref0 (format_literal);
					format_literal = _tmp333_;
					_tmp334_ = format_literal;
					_tmp335_ = vala_code_context_get_analyzer (context);
					_tmp336_ = _tmp335_;
					_tmp337_ = _tmp336_->string_type;
					_tmp338_ = vala_data_type_copy (_tmp337_);
					_tmp339_ = _tmp338_;
					vala_expression_set_target_type ((ValaExpression*) _tmp334_, _tmp339_);
					_vala_code_node_unref0 (_tmp339_);
					_tmp340_ = self->priv->argument_list;
					_tmp341_ = args;
					_tmp342_ = vala_collection_get_size ((ValaCollection*) _tmp341_);
					_tmp343_ = _tmp342_;
					_tmp344_ = format_literal;
					vala_list_insert (_tmp340_, _tmp343_ - 1, (ValaExpression*) _tmp344_);
					_tmp345_ = self->priv->argument_list;
					_tmp346_ = vala_iterable_iterator ((ValaIterable*) _tmp345_);
					_vala_iterator_unref0 (arg_it);
					arg_it = _tmp346_;
					{
						ValaList* _param_list = NULL;
						ValaMethod* _tmp347_;
						ValaList* _tmp348_;
						gint _param_size = 0;
						ValaList* _tmp349_;
						gint _tmp350_;
						gint _tmp351_;
						gint _param_index = 0;
						_tmp347_ = m;
						_tmp348_ = vala_callable_get_parameters ((ValaCallable*) _tmp347_);
						_param_list = _tmp348_;
						_tmp349_ = _param_list;
						_tmp350_ = vala_collection_get_size ((ValaCollection*) _tmp349_);
						_tmp351_ = _tmp350_;
						_param_size = _tmp351_;
						_param_index = -1;
						while (TRUE) {
							gint _tmp352_;
							gint _tmp353_;
							gint _tmp354_;
							ValaParameter* param = NULL;
							ValaList* _tmp355_;
							gint _tmp356_;
							gpointer _tmp357_;
							ValaParameter* _tmp358_;
							gboolean _tmp359_;
							gboolean _tmp360_;
							ValaIterator* _tmp361_;
							_tmp352_ = _param_index;
							_param_index = _tmp352_ + 1;
							_tmp353_ = _param_index;
							_tmp354_ = _param_size;
							if (!(_tmp353_ < _tmp354_)) {
								break;
							}
							_tmp355_ = _param_list;
							_tmp356_ = _param_index;
							_tmp357_ = vala_list_get (_tmp355_, _tmp356_);
							param = (ValaParameter*) _tmp357_;
							_tmp358_ = param;
							_tmp359_ = vala_parameter_get_ellipsis (_tmp358_);
							_tmp360_ = _tmp359_;
							if (_tmp360_) {
								_vala_code_node_unref0 (param);
								break;
							}
							_tmp361_ = arg_it;
							vala_iterator_next (_tmp361_);
							_vala_code_node_unref0 (param);
						}
						_vala_iterable_unref0 (_param_list);
					}
				}
			}
			_tmp362_ = format_literal;
			if (_tmp362_ != NULL) {
				gchar* format = NULL;
				ValaStringLiteral* _tmp363_;
				gchar* _tmp364_;
				ValaSemanticAnalyzer* _tmp365_;
				ValaSemanticAnalyzer* _tmp366_;
				const gchar* _tmp367_;
				ValaIterator* _tmp368_;
				ValaSourceReference* _tmp369_;
				ValaSourceReference* _tmp370_;
				_tmp363_ = format_literal;
				_tmp364_ = vala_string_literal_eval (_tmp363_);
				format = _tmp364_;
				_tmp365_ = vala_code_context_get_analyzer (context);
				_tmp366_ = _tmp365_;
				_tmp367_ = format;
				_tmp368_ = arg_it;
				_tmp369_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp370_ = _tmp369_;
				if (!vala_semantic_analyzer_check_print_format (_tmp366_, _tmp367_, _tmp368_, _tmp370_)) {
					result = FALSE;
					_g_free0 (format);
					_vala_code_node_unref0 (format_literal);
					_vala_iterator_unref0 (arg_it);
					_vala_iterable_unref0 (args);
					_vala_code_node_unref0 (last_arg);
					_vala_code_node_unref0 (m);
					_vala_code_node_unref0 (type);
					return result;
				}
				_g_free0 (format);
			}
			_vala_code_node_unref0 (format_literal);
		}
		{
			ValaList* _arg_list = NULL;
			ValaList* _tmp371_;
			ValaList* _tmp372_;
			gint _arg_size = 0;
			ValaList* _tmp373_;
			gint _tmp374_;
			gint _tmp375_;
			gint _arg_index = 0;
			_tmp371_ = args;
			_tmp372_ = _vala_iterable_ref0 (_tmp371_);
			_arg_list = _tmp372_;
			_tmp373_ = _arg_list;
			_tmp374_ = vala_collection_get_size ((ValaCollection*) _tmp373_);
			_tmp375_ = _tmp374_;
			_arg_size = _tmp375_;
			_arg_index = -1;
			while (TRUE) {
				gint _tmp376_;
				gint _tmp377_;
				gint _tmp378_;
				ValaExpression* arg = NULL;
				ValaList* _tmp379_;
				gint _tmp380_;
				gpointer _tmp381_;
				ValaExpression* _tmp382_;
				_tmp376_ = _arg_index;
				_arg_index = _tmp376_ + 1;
				_tmp377_ = _arg_index;
				_tmp378_ = _arg_size;
				if (!(_tmp377_ < _tmp378_)) {
					break;
				}
				_tmp379_ = _arg_list;
				_tmp380_ = _arg_index;
				_tmp381_ = vala_list_get (_tmp379_, _tmp380_);
				arg = (ValaExpression*) _tmp381_;
				_tmp382_ = arg;
				vala_code_node_check ((ValaCodeNode*) _tmp382_, context);
				_vala_code_node_unref0 (arg);
			}
			_vala_iterable_unref0 (_arg_list);
		}
		_tmp383_ = vala_code_context_get_analyzer (context);
		_tmp384_ = _tmp383_;
		_tmp385_ = m;
		_tmp386_ = vala_method_type_new (_tmp385_);
		_tmp387_ = _tmp386_;
		_tmp388_ = m;
		_tmp389_ = vala_callable_get_parameters ((ValaCallable*) _tmp388_);
		_tmp390_ = _tmp389_;
		_tmp391_ = args;
		vala_semantic_analyzer_check_arguments (_tmp384_, (ValaExpression*) self, (ValaDataType*) _tmp387_, _tmp390_, _tmp391_);
		_vala_iterable_unref0 (_tmp390_);
		_vala_code_node_unref0 (_tmp387_);
		{
			ValaList* _error_type_list = NULL;
			ValaMethod* _tmp392_;
			ValaList* _tmp393_;
			gint _error_type_size = 0;
			ValaList* _tmp394_;
			gint _tmp395_;
			gint _tmp396_;
			gint _error_type_index = 0;
			_tmp392_ = m;
			_tmp393_ = vala_code_node_get_error_types ((ValaCodeNode*) _tmp392_);
			_error_type_list = _tmp393_;
			_tmp394_ = _error_type_list;
			_tmp395_ = vala_collection_get_size ((ValaCollection*) _tmp394_);
			_tmp396_ = _tmp395_;
			_error_type_size = _tmp396_;
			_error_type_index = -1;
			while (TRUE) {
				gint _tmp397_;
				gint _tmp398_;
				gint _tmp399_;
				ValaDataType* error_type = NULL;
				ValaList* _tmp400_;
				gint _tmp401_;
				gpointer _tmp402_;
				ValaDataType* call_error_type = NULL;
				ValaDataType* _tmp403_;
				ValaDataType* _tmp404_;
				ValaDataType* _tmp405_;
				ValaSourceReference* _tmp406_;
				ValaSourceReference* _tmp407_;
				ValaDataType* _tmp408_;
				_tmp397_ = _error_type_index;
				_error_type_index = _tmp397_ + 1;
				_tmp398_ = _error_type_index;
				_tmp399_ = _error_type_size;
				if (!(_tmp398_ < _tmp399_)) {
					break;
				}
				_tmp400_ = _error_type_list;
				_tmp401_ = _error_type_index;
				_tmp402_ = vala_list_get (_tmp400_, _tmp401_);
				error_type = (ValaDataType*) _tmp402_;
				may_throw = TRUE;
				_tmp403_ = error_type;
				_tmp404_ = vala_data_type_copy (_tmp403_);
				call_error_type = _tmp404_;
				_tmp405_ = call_error_type;
				_tmp406_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp407_ = _tmp406_;
				vala_code_node_set_source_reference ((ValaCodeNode*) _tmp405_, _tmp407_);
				_tmp408_ = call_error_type;
				vala_code_node_add_error_type ((ValaCodeNode*) self, _tmp408_);
				_vala_code_node_unref0 (call_error_type);
				_vala_code_node_unref0 (error_type);
			}
			_vala_iterable_unref0 (_error_type_list);
		}
		_vala_iterator_unref0 (arg_it);
		_vala_iterable_unref0 (args);
		_vala_code_node_unref0 (last_arg);
		_vala_code_node_unref0 (m);
	} else {
		ValaDataType* _tmp409_;
		ValaDataType* _tmp410_;
		_tmp409_ = vala_object_creation_expression_get_type_reference (self);
		_tmp410_ = _tmp409_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp410_, VALA_TYPE_ERROR_TYPE)) {
			ValaDataType* _tmp411_;
			ValaDataType* _tmp412_;
			ValaMemberAccess* _tmp415_;
			ValaList* _tmp441_;
			ValaList* _tmp442_;
			gint _tmp443_;
			gint _tmp444_;
			gboolean _tmp445_;
			_tmp411_ = vala_object_creation_expression_get_type_reference (self);
			_tmp412_ = _tmp411_;
			if (_tmp412_ != NULL) {
				ValaDataType* _tmp413_;
				ValaDataType* _tmp414_;
				_tmp413_ = vala_object_creation_expression_get_type_reference (self);
				_tmp414_ = _tmp413_;
				vala_code_node_check ((ValaCodeNode*) _tmp414_, context);
			}
			_tmp415_ = self->priv->_member_name;
			if (_tmp415_ != NULL) {
				ValaMemberAccess* _tmp416_;
				_tmp416_ = self->priv->_member_name;
				vala_code_node_check ((ValaCodeNode*) _tmp416_, context);
			}
			{
				ValaList* _arg_list = NULL;
				ValaList* _tmp417_;
				ValaList* _tmp418_;
				gint _arg_size = 0;
				ValaList* _tmp419_;
				gint _tmp420_;
				gint _tmp421_;
				gint _arg_index = 0;
				_tmp417_ = self->priv->argument_list;
				_tmp418_ = _vala_iterable_ref0 (_tmp417_);
				_arg_list = _tmp418_;
				_tmp419_ = _arg_list;
				_tmp420_ = vala_collection_get_size ((ValaCollection*) _tmp419_);
				_tmp421_ = _tmp420_;
				_arg_size = _tmp421_;
				_arg_index = -1;
				while (TRUE) {
					gint _tmp422_;
					gint _tmp423_;
					gint _tmp424_;
					ValaExpression* arg = NULL;
					ValaList* _tmp425_;
					gint _tmp426_;
					gpointer _tmp427_;
					ValaExpression* _tmp428_;
					_tmp422_ = _arg_index;
					_arg_index = _tmp422_ + 1;
					_tmp423_ = _arg_index;
					_tmp424_ = _arg_size;
					if (!(_tmp423_ < _tmp424_)) {
						break;
					}
					_tmp425_ = _arg_list;
					_tmp426_ = _arg_index;
					_tmp427_ = vala_list_get (_tmp425_, _tmp426_);
					arg = (ValaExpression*) _tmp427_;
					_tmp428_ = arg;
					vala_code_node_check ((ValaCodeNode*) _tmp428_, context);
					_vala_code_node_unref0 (arg);
				}
				_vala_iterable_unref0 (_arg_list);
			}
			{
				ValaList* _init_list = NULL;
				ValaList* _tmp429_;
				ValaList* _tmp430_;
				gint _init_size = 0;
				ValaList* _tmp431_;
				gint _tmp432_;
				gint _tmp433_;
				gint _init_index = 0;
				_tmp429_ = self->priv->object_initializer;
				_tmp430_ = _vala_iterable_ref0 (_tmp429_);
				_init_list = _tmp430_;
				_tmp431_ = _init_list;
				_tmp432_ = vala_collection_get_size ((ValaCollection*) _tmp431_);
				_tmp433_ = _tmp432_;
				_init_size = _tmp433_;
				_init_index = -1;
				while (TRUE) {
					gint _tmp434_;
					gint _tmp435_;
					gint _tmp436_;
					ValaMemberInitializer* init = NULL;
					ValaList* _tmp437_;
					gint _tmp438_;
					gpointer _tmp439_;
					ValaMemberInitializer* _tmp440_;
					_tmp434_ = _init_index;
					_init_index = _tmp434_ + 1;
					_tmp435_ = _init_index;
					_tmp436_ = _init_size;
					if (!(_tmp435_ < _tmp436_)) {
						break;
					}
					_tmp437_ = _init_list;
					_tmp438_ = _init_index;
					_tmp439_ = vala_list_get (_tmp437_, _tmp438_);
					init = (ValaMemberInitializer*) _tmp439_;
					_tmp440_ = init;
					vala_code_node_check ((ValaCodeNode*) _tmp440_, context);
					_vala_code_node_unref0 (init);
				}
				_vala_iterable_unref0 (_init_list);
			}
			_tmp441_ = vala_object_creation_expression_get_argument_list (self);
			_tmp442_ = _tmp441_;
			_tmp443_ = vala_collection_get_size ((ValaCollection*) _tmp442_);
			_tmp444_ = _tmp443_;
			_tmp445_ = _tmp444_ == 0;
			_vala_iterable_unref0 (_tmp442_);
			if (_tmp445_) {
				ValaSourceReference* _tmp446_;
				ValaSourceReference* _tmp447_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp446_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp447_ = _tmp446_;
				vala_report_error (_tmp447_, "Too few arguments, errors need at least 1 argument");
			} else {
				ValaIterator* arg_it = NULL;
				ValaList* _tmp448_;
				ValaList* _tmp449_;
				ValaIterator* _tmp450_;
				ValaIterator* _tmp451_;
				ValaIterator* _tmp452_;
				ValaExpression* ex = NULL;
				ValaIterator* _tmp453_;
				gpointer _tmp454_;
				gboolean _tmp455_ = FALSE;
				ValaExpression* _tmp456_;
				ValaDataType* _tmp457_;
				ValaDataType* _tmp458_;
				ValaStringLiteral* format_literal = NULL;
				ValaExpression* _tmp467_;
				ValaStringLiteral* _tmp468_;
				ValaStringLiteral* _tmp469_;
				ValaList* _tmp478_;
				ValaList* _tmp479_;
				ValaIterator* _tmp480_;
				ValaIterator* _tmp481_;
				ValaSemanticAnalyzer* _tmp482_;
				ValaSemanticAnalyzer* _tmp483_;
				ValaIterator* _tmp484_;
				ValaSourceReference* _tmp485_;
				ValaSourceReference* _tmp486_;
				_tmp448_ = vala_object_creation_expression_get_argument_list (self);
				_tmp449_ = _tmp448_;
				_tmp450_ = vala_iterable_iterator ((ValaIterable*) _tmp449_);
				_tmp451_ = _tmp450_;
				_vala_iterable_unref0 (_tmp449_);
				arg_it = _tmp451_;
				_tmp452_ = arg_it;
				vala_iterator_next (_tmp452_);
				_tmp453_ = arg_it;
				_tmp454_ = vala_iterator_get (_tmp453_);
				ex = (ValaExpression*) _tmp454_;
				_tmp456_ = ex;
				_tmp457_ = vala_expression_get_value_type (_tmp456_);
				_tmp458_ = _tmp457_;
				if (_tmp458_ == NULL) {
					_tmp455_ = TRUE;
				} else {
					ValaExpression* _tmp459_;
					ValaDataType* _tmp460_;
					ValaDataType* _tmp461_;
					ValaSemanticAnalyzer* _tmp462_;
					ValaSemanticAnalyzer* _tmp463_;
					ValaDataType* _tmp464_;
					_tmp459_ = ex;
					_tmp460_ = vala_expression_get_value_type (_tmp459_);
					_tmp461_ = _tmp460_;
					_tmp462_ = vala_code_context_get_analyzer (context);
					_tmp463_ = _tmp462_;
					_tmp464_ = _tmp463_->string_type;
					_tmp455_ = !vala_data_type_compatible (_tmp461_, _tmp464_);
				}
				if (_tmp455_) {
					ValaSourceReference* _tmp465_;
					ValaSourceReference* _tmp466_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp465_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp466_ = _tmp465_;
					vala_report_error (_tmp466_, "Invalid type for argument 1");
				}
				_tmp467_ = ex;
				_tmp468_ = vala_string_literal_get_format_literal (_tmp467_);
				format_literal = _tmp468_;
				_tmp469_ = format_literal;
				if (_tmp469_ != NULL) {
					gchar* format = NULL;
					ValaStringLiteral* _tmp470_;
					gchar* _tmp471_;
					ValaSemanticAnalyzer* _tmp472_;
					ValaSemanticAnalyzer* _tmp473_;
					const gchar* _tmp474_;
					ValaIterator* _tmp475_;
					ValaSourceReference* _tmp476_;
					ValaSourceReference* _tmp477_;
					_tmp470_ = format_literal;
					_tmp471_ = vala_string_literal_eval (_tmp470_);
					format = _tmp471_;
					_tmp472_ = vala_code_context_get_analyzer (context);
					_tmp473_ = _tmp472_;
					_tmp474_ = format;
					_tmp475_ = arg_it;
					_tmp476_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp477_ = _tmp476_;
					if (!vala_semantic_analyzer_check_print_format (_tmp473_, _tmp474_, _tmp475_, _tmp477_)) {
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						result = FALSE;
						_g_free0 (format);
						_vala_code_node_unref0 (format_literal);
						_vala_code_node_unref0 (ex);
						_vala_iterator_unref0 (arg_it);
						_vala_code_node_unref0 (type);
						return result;
					}
					_g_free0 (format);
				}
				_tmp478_ = vala_object_creation_expression_get_argument_list (self);
				_tmp479_ = _tmp478_;
				_tmp480_ = vala_iterable_iterator ((ValaIterable*) _tmp479_);
				_vala_iterator_unref0 (arg_it);
				arg_it = _tmp480_;
				_vala_iterable_unref0 (_tmp479_);
				_tmp481_ = arg_it;
				vala_iterator_next (_tmp481_);
				_tmp482_ = vala_code_context_get_analyzer (context);
				_tmp483_ = _tmp482_;
				_tmp484_ = arg_it;
				_tmp485_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp486_ = _tmp485_;
				if (!vala_semantic_analyzer_check_variadic_arguments (_tmp483_, _tmp484_, 1, _tmp486_)) {
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					result = FALSE;
					_vala_code_node_unref0 (format_literal);
					_vala_code_node_unref0 (ex);
					_vala_iterator_unref0 (arg_it);
					_vala_code_node_unref0 (type);
					return result;
				}
				_vala_code_node_unref0 (format_literal);
				_vala_code_node_unref0 (ex);
				_vala_iterator_unref0 (arg_it);
			}
		}
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp487_;
		gint _init_size = 0;
		ValaList* _tmp488_;
		gint _tmp489_;
		gint _tmp490_;
		gint _init_index = 0;
		_tmp487_ = vala_object_creation_expression_get_object_initializer (self);
		_init_list = _tmp487_;
		_tmp488_ = _init_list;
		_tmp489_ = vala_collection_get_size ((ValaCollection*) _tmp488_);
		_tmp490_ = _tmp489_;
		_init_size = _tmp490_;
		_init_index = -1;
		while (TRUE) {
			gint _tmp491_;
			gint _tmp492_;
			gint _tmp493_;
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp494_;
			gint _tmp495_;
			gpointer _tmp496_;
			ValaSemanticAnalyzer* _tmp497_;
			ValaSemanticAnalyzer* _tmp498_;
			ValaMemberInitializer* _tmp499_;
			ValaDataType* _tmp500_;
			ValaDataType* _tmp501_;
			_tmp491_ = _init_index;
			_init_index = _tmp491_ + 1;
			_tmp492_ = _init_index;
			_tmp493_ = _init_size;
			if (!(_tmp492_ < _tmp493_)) {
				break;
			}
			_tmp494_ = _init_list;
			_tmp495_ = _init_index;
			_tmp496_ = vala_list_get (_tmp494_, _tmp495_);
			init = (ValaMemberInitializer*) _tmp496_;
			_tmp497_ = vala_code_context_get_analyzer (context);
			_tmp498_ = _tmp497_;
			_tmp499_ = init;
			_tmp500_ = vala_object_creation_expression_get_type_reference (self);
			_tmp501_ = _tmp500_;
			vala_semantic_analyzer_visit_member_initializer (_tmp498_, _tmp499_, _tmp501_);
			_vala_code_node_unref0 (init);
		}
		_vala_iterable_unref0 (_init_list);
	}
	_tmp502_ = may_throw;
	if (_tmp502_) {
		gboolean _tmp503_ = FALSE;
		ValaCodeNode* _tmp504_;
		ValaCodeNode* _tmp505_;
		_tmp504_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp505_ = _tmp504_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp505_, VALA_TYPE_LOCAL_VARIABLE)) {
			_tmp503_ = TRUE;
		} else {
			ValaCodeNode* _tmp506_;
			ValaCodeNode* _tmp507_;
			_tmp506_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp507_ = _tmp506_;
			_tmp503_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp507_, VALA_TYPE_EXPRESSION_STATEMENT);
		}
		if (_tmp503_) {
		} else {
			ValaSemanticAnalyzer* _tmp508_;
			ValaSemanticAnalyzer* _tmp509_;
			ValaSymbol* _tmp510_;
			ValaSymbol* _tmp511_;
			_tmp508_ = vala_code_context_get_analyzer (context);
			_tmp509_ = _tmp508_;
			_tmp510_ = vala_semantic_analyzer_get_current_symbol (_tmp509_);
			_tmp511_ = _tmp510_;
			if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp511_, VALA_TYPE_BLOCK)) {
				ValaSourceReference* _tmp512_;
				ValaSourceReference* _tmp513_;
				_tmp512_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp513_ = _tmp512_;
				vala_report_error (_tmp513_, "Field initializers must not throw errors");
			} else {
				ValaCodeNode* old_parent_node = NULL;
				ValaCodeNode* _tmp514_;
				ValaCodeNode* _tmp515_;
				ValaCodeNode* _tmp516_;
				ValaLocalVariable* local = NULL;
				ValaDataType* _tmp517_;
				ValaDataType* _tmp518_;
				ValaDataType* _tmp519_;
				ValaDataType* _tmp520_;
				gchar* _tmp521_;
				gchar* _tmp522_;
				ValaSourceReference* _tmp523_;
				ValaSourceReference* _tmp524_;
				ValaLocalVariable* _tmp525_;
				ValaLocalVariable* _tmp526_;
				ValaDeclarationStatement* decl = NULL;
				ValaLocalVariable* _tmp527_;
				ValaSourceReference* _tmp528_;
				ValaSourceReference* _tmp529_;
				ValaDeclarationStatement* _tmp530_;
				ValaSemanticAnalyzer* _tmp531_;
				ValaSemanticAnalyzer* _tmp532_;
				ValaBlock* _tmp533_;
				ValaDeclarationStatement* _tmp534_;
				ValaExpression* temp_access = NULL;
				ValaLocalVariable* _tmp535_;
				ValaDataType* _tmp536_;
				ValaDataType* _tmp537_;
				ValaExpression* _tmp538_;
				ValaLocalVariable* _tmp539_;
				ValaDeclarationStatement* _tmp540_;
				ValaBlock* block = NULL;
				ValaSemanticAnalyzer* _tmp541_;
				ValaSemanticAnalyzer* _tmp542_;
				ValaSymbol* _tmp543_;
				ValaSymbol* _tmp544_;
				ValaBlock* _tmp545_;
				ValaBlock* _tmp546_;
				ValaLocalVariable* _tmp547_;
				ValaSemanticAnalyzer* _tmp548_;
				ValaSemanticAnalyzer* _tmp549_;
				ValaBlock* _tmp550_;
				ValaLocalVariable* _tmp551_;
				ValaCodeNode* _tmp552_;
				ValaExpression* _tmp553_;
				ValaExpression* _tmp554_;
				_tmp514_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp515_ = _tmp514_;
				_tmp516_ = _vala_code_node_ref0 (_tmp515_);
				old_parent_node = _tmp516_;
				_tmp517_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp518_ = _tmp517_;
				_tmp519_ = vala_data_type_copy (_tmp518_);
				_tmp520_ = _tmp519_;
				_tmp521_ = vala_code_node_get_temp_name ();
				_tmp522_ = _tmp521_;
				_tmp523_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp524_ = _tmp523_;
				_tmp525_ = vala_local_variable_new (_tmp520_, _tmp522_, NULL, _tmp524_);
				_tmp526_ = _tmp525_;
				_g_free0 (_tmp522_);
				_vala_code_node_unref0 (_tmp520_);
				local = _tmp526_;
				_tmp527_ = local;
				_tmp528_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp529_ = _tmp528_;
				_tmp530_ = vala_declaration_statement_new ((ValaSymbol*) _tmp527_, _tmp529_);
				decl = _tmp530_;
				_tmp531_ = vala_code_context_get_analyzer (context);
				_tmp532_ = _tmp531_;
				_tmp533_ = _tmp532_->insert_block;
				_tmp534_ = decl;
				vala_expression_insert_statement ((ValaExpression*) self, _tmp533_, (ValaStatement*) _tmp534_);
				_tmp535_ = local;
				_tmp536_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp537_ = _tmp536_;
				_tmp538_ = vala_semantic_analyzer_create_temp_access (_tmp535_, _tmp537_);
				temp_access = _tmp538_;
				_tmp539_ = local;
				vala_variable_set_initializer ((ValaVariable*) _tmp539_, (ValaExpression*) self);
				_tmp540_ = decl;
				vala_code_node_check ((ValaCodeNode*) _tmp540_, context);
				_tmp541_ = vala_code_context_get_analyzer (context);
				_tmp542_ = _tmp541_;
				_tmp543_ = vala_semantic_analyzer_get_current_symbol (_tmp542_);
				_tmp544_ = _tmp543_;
				_tmp545_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp544_, VALA_TYPE_BLOCK, ValaBlock));
				block = _tmp545_;
				_tmp546_ = block;
				_tmp547_ = local;
				vala_block_remove_local_variable (_tmp546_, _tmp547_);
				_tmp548_ = vala_code_context_get_analyzer (context);
				_tmp549_ = _tmp548_;
				_tmp550_ = _tmp549_->insert_block;
				_tmp551_ = local;
				vala_block_add_local_variable (_tmp550_, _tmp551_);
				_tmp552_ = old_parent_node;
				_tmp553_ = temp_access;
				vala_code_node_replace_expression (_tmp552_, (ValaExpression*) self, _tmp553_);
				_tmp554_ = temp_access;
				vala_code_node_check ((ValaCodeNode*) _tmp554_, context);
				_vala_code_node_unref0 (block);
				_vala_code_node_unref0 (temp_access);
				_vala_code_node_unref0 (decl);
				_vala_code_node_unref0 (local);
				_vala_code_node_unref0 (old_parent_node);
			}
		}
	}
	_tmp555_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp556_ = _tmp555_;
	result = !_tmp556_;
	_vala_code_node_unref0 (type);
	return result;
}


static void
vala_object_creation_expression_real_emit (ValaCodeNode* base, 
                                           ValaCodeGenerator* codegen)
{
	ValaObjectCreationExpression * self;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (codegen != NULL);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _arg_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _arg_index = 0;
		_tmp0_ = self->priv->argument_list;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_arg_list = _tmp1_;
		_tmp2_ = _arg_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_arg_size = _tmp4_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaExpression* arg = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValaExpression* _tmp11_;
			_tmp5_ = _arg_index;
			_arg_index = _tmp5_ + 1;
			_tmp6_ = _arg_index;
			_tmp7_ = _arg_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _arg_list;
			_tmp9_ = _arg_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			arg = (ValaExpression*) _tmp10_;
			_tmp11_ = arg;
			vala_code_node_emit ((ValaCodeNode*) _tmp11_, codegen);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp12_;
		ValaList* _tmp13_;
		gint _init_size = 0;
		ValaList* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gint _init_index = 0;
		_tmp12_ = self->priv->object_initializer;
		_tmp13_ = _vala_iterable_ref0 (_tmp12_);
		_init_list = _tmp13_;
		_tmp14_ = _init_list;
		_tmp15_ = vala_collection_get_size ((ValaCollection*) _tmp14_);
		_tmp16_ = _tmp15_;
		_init_size = _tmp16_;
		_init_index = -1;
		while (TRUE) {
			gint _tmp17_;
			gint _tmp18_;
			gint _tmp19_;
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp20_;
			gint _tmp21_;
			gpointer _tmp22_;
			ValaMemberInitializer* _tmp23_;
			_tmp17_ = _init_index;
			_init_index = _tmp17_ + 1;
			_tmp18_ = _init_index;
			_tmp19_ = _init_size;
			if (!(_tmp18_ < _tmp19_)) {
				break;
			}
			_tmp20_ = _init_list;
			_tmp21_ = _init_index;
			_tmp22_ = vala_list_get (_tmp20_, _tmp21_);
			init = (ValaMemberInitializer*) _tmp22_;
			_tmp23_ = init;
			vala_code_node_emit ((ValaCodeNode*) _tmp23_, codegen);
			_vala_code_node_unref0 (init);
		}
		_vala_iterable_unref0 (_init_list);
	}
	vala_code_visitor_visit_object_creation_expression ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}


static void
vala_object_creation_expression_real_get_defined_variables (ValaCodeNode* base, 
                                                            ValaCollection* collection)
{
	ValaObjectCreationExpression * self;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (collection != NULL);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _arg_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _arg_index = 0;
		_tmp0_ = self->priv->argument_list;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_arg_list = _tmp1_;
		_tmp2_ = _arg_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_arg_size = _tmp4_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaExpression* arg = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValaExpression* _tmp11_;
			_tmp5_ = _arg_index;
			_arg_index = _tmp5_ + 1;
			_tmp6_ = _arg_index;
			_tmp7_ = _arg_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _arg_list;
			_tmp9_ = _arg_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			arg = (ValaExpression*) _tmp10_;
			_tmp11_ = arg;
			vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp11_, collection);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
}


static void
vala_object_creation_expression_real_get_used_variables (ValaCodeNode* base, 
                                                         ValaCollection* collection)
{
	ValaObjectCreationExpression * self;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (collection != NULL);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _arg_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _arg_index = 0;
		_tmp0_ = self->priv->argument_list;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_arg_list = _tmp1_;
		_tmp2_ = _arg_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_arg_size = _tmp4_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaExpression* arg = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValaExpression* _tmp11_;
			_tmp5_ = _arg_index;
			_arg_index = _tmp5_ + 1;
			_tmp6_ = _arg_index;
			_tmp7_ = _arg_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _arg_list;
			_tmp9_ = _arg_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			arg = (ValaExpression*) _tmp10_;
			_tmp11_ = arg;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp11_, collection);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp12_;
		ValaList* _tmp13_;
		gint _init_size = 0;
		ValaList* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gint _init_index = 0;
		_tmp12_ = self->priv->object_initializer;
		_tmp13_ = _vala_iterable_ref0 (_tmp12_);
		_init_list = _tmp13_;
		_tmp14_ = _init_list;
		_tmp15_ = vala_collection_get_size ((ValaCollection*) _tmp14_);
		_tmp16_ = _tmp15_;
		_init_size = _tmp16_;
		_init_index = -1;
		while (TRUE) {
			gint _tmp17_;
			gint _tmp18_;
			gint _tmp19_;
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp20_;
			gint _tmp21_;
			gpointer _tmp22_;
			ValaMemberInitializer* _tmp23_;
			_tmp17_ = _init_index;
			_init_index = _tmp17_ + 1;
			_tmp18_ = _init_index;
			_tmp19_ = _init_size;
			if (!(_tmp18_ < _tmp19_)) {
				break;
			}
			_tmp20_ = _init_list;
			_tmp21_ = _init_index;
			_tmp22_ = vala_list_get (_tmp20_, _tmp21_);
			init = (ValaMemberInitializer*) _tmp22_;
			_tmp23_ = init;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp23_, collection);
			_vala_code_node_unref0 (init);
		}
		_vala_iterable_unref0 (_init_list);
	}
}


ValaDataType*
vala_object_creation_expression_get_type_reference (ValaObjectCreationExpression* self)
{
	ValaDataType* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_data_type;
	result = _tmp0_;
	return result;
}


void
vala_object_creation_expression_set_type_reference (ValaObjectCreationExpression* self, 
                                                    ValaDataType* value)
{
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_data_type);
	self->priv->_data_type = _tmp0_;
	_tmp1_ = self->priv->_data_type;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}


ValaMemberAccess*
vala_object_creation_expression_get_member_name (ValaObjectCreationExpression* self)
{
	ValaMemberAccess* result;
	ValaMemberAccess* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_member_name;
	result = _tmp0_;
	return result;
}


void
vala_object_creation_expression_set_member_name (ValaObjectCreationExpression* self, 
                                                 ValaMemberAccess* value)
{
	ValaMemberAccess* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_member_name);
	self->priv->_member_name = _tmp0_;
}


gboolean
vala_object_creation_expression_get_is_yield_expression (ValaObjectCreationExpression* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_yield_expression;
	result = _tmp0_;
	return result;
}


void
vala_object_creation_expression_set_is_yield_expression (ValaObjectCreationExpression* self, 
                                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_yield_expression = value;
}


gboolean
vala_object_creation_expression_get_struct_creation (ValaObjectCreationExpression* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_struct_creation;
	result = _tmp0_;
	return result;
}


void
vala_object_creation_expression_set_struct_creation (ValaObjectCreationExpression* self, 
                                                     gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_struct_creation = value;
}


static void
vala_object_creation_expression_class_init (ValaObjectCreationExpressionClass * klass)
{
	vala_object_creation_expression_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_object_creation_expression_finalize;
	g_type_class_add_private (klass, sizeof (ValaObjectCreationExpressionPrivate));
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_object_creation_expression_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_object_creation_expression_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode *, ValaExpression*, ValaExpression*)) vala_object_creation_expression_real_replace_expression;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression *)) vala_object_creation_expression_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression *, ValaSymbol*)) vala_object_creation_expression_real_is_accessible;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode *, ValaDataType*, ValaDataType*)) vala_object_creation_expression_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode *, ValaCodeContext*)) vala_object_creation_expression_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode *, ValaCodeGenerator*)) vala_object_creation_expression_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode *, ValaCollection*)) vala_object_creation_expression_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode *, ValaCollection*)) vala_object_creation_expression_real_get_used_variables;
}


static void
vala_object_creation_expression_instance_init (ValaObjectCreationExpression * self)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GEqualFunc _tmp2_;
	ValaArrayList* _tmp3_;
	self->priv = VALA_OBJECT_CREATION_EXPRESSION_GET_PRIVATE (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->argument_list = (ValaList*) _tmp1_;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_array_list_new (VALA_TYPE_MEMBER_INITIALIZER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp2_);
	self->priv->object_initializer = (ValaList*) _tmp3_;
}


static void
vala_object_creation_expression_finalize (ValaCodeNode * obj)
{
	ValaObjectCreationExpression * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_OBJECT_CREATION_EXPRESSION, ValaObjectCreationExpression);
	_vala_code_node_unref0 (self->priv->_member_name);
	_vala_iterable_unref0 (self->priv->argument_list);
	_vala_iterable_unref0 (self->priv->object_initializer);
	_vala_code_node_unref0 (self->priv->_data_type);
	VALA_CODE_NODE_CLASS (vala_object_creation_expression_parent_class)->finalize (obj);
}


/**
 * Represents an object creation expression in the source code.
 */
GType
vala_object_creation_expression_get_type (void)
{
	static volatile gsize vala_object_creation_expression_type_id__volatile = 0;
	if (g_once_init_enter (&vala_object_creation_expression_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaObjectCreationExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_object_creation_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaObjectCreationExpression), 0, (GInstanceInitFunc) vala_object_creation_expression_instance_init, NULL };
		GType vala_object_creation_expression_type_id;
		vala_object_creation_expression_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaObjectCreationExpression", &g_define_type_info, 0);
		g_once_init_leave (&vala_object_creation_expression_type_id__volatile, vala_object_creation_expression_type_id);
	}
	return vala_object_creation_expression_type_id__volatile;
}



