/* valagsignalmodule.c generated by valac, the Vala compiler
 * generated from valagsignalmodule.vala, do not modify */

/* valagsignalmodule.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include "valacodegen.h"
#include <vala.h>
#include <valaccode.h>
#include <valagee.h>
#include <stdlib.h>
#include <string.h>

enum  {
	VALA_GSIGNAL_MODULE_0_PROPERTY,
	VALA_GSIGNAL_MODULE_NUM_PROPERTIES
};
static GParamSpec* vala_gsignal_module_properties[VALA_GSIGNAL_MODULE_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_ccode_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_node_unref (var), NULL)))
#define _vala_target_value_unref0(var) ((var == NULL) ? NULL : (var = (vala_target_value_unref (var), NULL)))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))


static gpointer vala_gsignal_module_parent_class = NULL;

static gchar* vala_gsignal_module_get_marshaller_function (ValaGSignalModule* self, 
                                                    ValaList* params, 
                                                    ValaDataType* return_type, 
                                                    const gchar* prefix);
static gchar* vala_gsignal_module_get_marshaller_signature (ValaGSignalModule* self, 
                                                     ValaList* params, 
                                                     ValaDataType* return_type);
static gchar* vala_gsignal_module_get_value_type_name_from_type_reference (ValaGSignalModule* self, 
                                                                    ValaDataType* t);
static gchar* vala_gsignal_module_get_value_type_name_from_parameter (ValaGSignalModule* self, 
                                                               ValaParameter* p);
static ValaCCodeExpression* vala_gsignal_module_get_signal_name_cexpression (ValaGSignalModule* self, 
                                                                      ValaSignal* sig, 
                                                                      ValaExpression* detail_expr, 
                                                                      ValaCodeNode* node);
static ValaCCodeExpression* vala_gsignal_module_get_signal_id_cexpression (ValaGSignalModule* self, 
                                                                    ValaSignal* sig);
static ValaCCodeExpression* vala_gsignal_module_get_detail_cexpression (ValaGSignalModule* self, 
                                                                 ValaExpression* detail_expr, 
                                                                 ValaCodeNode* node);
static void vala_gsignal_module_real_visit_signal (ValaCodeVisitor* base, 
                                            ValaSignal* sig);
static void vala_gsignal_module_generate_marshaller (ValaGSignalModule* self, 
                                              ValaList* params, 
                                              ValaDataType* return_type);
static ValaCCodeExpression* vala_gsignal_module_real_get_signal_creation (ValaCCodeBaseModule* base, 
                                                                   ValaSignal* sig, 
                                                                   ValaTypeSymbol* type);
static void _vala_array_add1 (gchar** * array, 
                       int* length, 
                       int* size, 
                       gchar* value);
static void _vala_array_add2 (gchar** * array, 
                       int* length, 
                       int* size, 
                       gchar* value);
static void _vala_array_add3 (gchar** * array, 
                       int* length, 
                       int* size, 
                       gchar* value);
static void _vala_array_add4 (gchar** * array, 
                       int* length, 
                       int* size, 
                       gchar* value);
static void _vala_array_add5 (gchar** * array, 
                       int* length, 
                       int* size, 
                       gchar* value);
static void _vala_array_add6 (gchar** * array, 
                       int* length, 
                       int* size, 
                       gchar* value);
static void _vala_array_add7 (gchar** * array, 
                       int* length, 
                       int* size, 
                       gchar* value);
static void _vala_array_add8 (gchar** * array, 
                       int* length, 
                       int* size, 
                       gchar* value);
static void vala_gsignal_module_real_visit_element_access (ValaCodeVisitor* base, 
                                                    ValaElementAccess* expr);
static gboolean vala_gsignal_module_in_gobject_instance (ValaGSignalModule* self, 
                                                  ValaMethod* m);
static void vala_gsignal_module_emit_signal_assignment (ValaGSignalModule* self, 
                                                 ValaAssignment* assignment);
static ValaCCodeExpression* vala_gsignal_module_connect_signal (ValaGSignalModule* self, 
                                                         ValaSignal* sig, 
                                                         ValaExpression* signal_access, 
                                                         ValaExpression* handler, 
                                                         gboolean disconnect, 
                                                         gboolean after, 
                                                         ValaCodeNode* expr);
static void vala_gsignal_module_real_visit_assignment (ValaCodeVisitor* base, 
                                                ValaAssignment* assignment);
static void vala_gsignal_module_real_visit_member_access (ValaCodeVisitor* base, 
                                                   ValaMemberAccess* expr);
static void vala_gsignal_module_real_visit_method_call (ValaCodeVisitor* base, 
                                                 ValaMethodCall* expr);
static void _vala_array_destroy (gpointer array, 
                          gint array_length, 
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, 
                       gint array_length, 
                       GDestroyNotify destroy_func);


static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}


static gchar*
string_replace (const gchar* self, 
                const gchar* old, 
                const gchar* replacement)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch11_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch11_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally11;
	__catch11_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally11:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static gchar*
vala_gsignal_module_get_marshaller_function (ValaGSignalModule* self, 
                                             ValaList* params, 
                                             ValaDataType* return_type, 
                                             const gchar* prefix)
{
	gchar* result = NULL;
	gchar* signature = NULL;
	gchar* _tmp0_;
	gchar* ret = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean _tmp6_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (params != NULL, NULL);
	g_return_val_if_fail (return_type != NULL, NULL);
	_tmp0_ = vala_gsignal_module_get_marshaller_signature (self, params, return_type);
	signature = _tmp0_;
	if (prefix == NULL) {
		ValaSet* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = ((ValaCCodeBaseModule*) self)->predefined_marshal_set;
		_tmp2_ = signature;
		if (vala_collection_contains ((ValaCollection*) _tmp1_, _tmp2_)) {
			prefix = "g_cclosure_marshal";
		} else {
			prefix = "g_cclosure_user_marshal";
		}
	}
	_tmp3_ = vala_get_ccode_marshaller_type_name ((ValaCodeNode*) return_type);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup_printf ("%s_%s_", prefix, _tmp4_);
	_g_free0 (ret);
	ret = _tmp5_;
	_g_free0 (_tmp4_);
	if (params == NULL) {
		_tmp6_ = TRUE;
	} else {
		gint _tmp7_;
		gint _tmp8_;
		_tmp7_ = vala_collection_get_size ((ValaCollection*) params);
		_tmp8_ = _tmp7_;
		_tmp6_ = _tmp8_ == 0;
	}
	if (_tmp6_) {
		const gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp9_ = ret;
		_tmp10_ = g_strconcat (_tmp9_, "_VOID", NULL);
		_g_free0 (ret);
		ret = _tmp10_;
	} else {
		{
			ValaList* _p_list = NULL;
			ValaList* _tmp11_;
			gint _p_size = 0;
			ValaList* _tmp12_;
			gint _tmp13_;
			gint _tmp14_;
			gint _p_index = 0;
			_tmp11_ = _vala_iterable_ref0 (params);
			_p_list = _tmp11_;
			_tmp12_ = _p_list;
			_tmp13_ = vala_collection_get_size ((ValaCollection*) _tmp12_);
			_tmp14_ = _tmp13_;
			_p_size = _tmp14_;
			_p_index = -1;
			while (TRUE) {
				gint _tmp15_;
				gint _tmp16_;
				gint _tmp17_;
				ValaParameter* p = NULL;
				ValaList* _tmp18_;
				gint _tmp19_;
				gpointer _tmp20_;
				const gchar* _tmp21_;
				ValaParameter* _tmp22_;
				gchar* _tmp23_;
				gchar* _tmp24_;
				gchar* _tmp25_;
				gchar* _tmp26_;
				gchar* _tmp27_;
				_tmp15_ = _p_index;
				_p_index = _tmp15_ + 1;
				_tmp16_ = _p_index;
				_tmp17_ = _p_size;
				if (!(_tmp16_ < _tmp17_)) {
					break;
				}
				_tmp18_ = _p_list;
				_tmp19_ = _p_index;
				_tmp20_ = vala_list_get (_tmp18_, _tmp19_);
				p = (ValaParameter*) _tmp20_;
				_tmp21_ = ret;
				_tmp22_ = p;
				_tmp23_ = vala_get_ccode_marshaller_type_name ((ValaCodeNode*) _tmp22_);
				_tmp24_ = _tmp23_;
				_tmp25_ = string_replace (_tmp24_, ",", "_");
				_tmp26_ = _tmp25_;
				_tmp27_ = g_strdup_printf ("%s_%s", _tmp21_, _tmp26_);
				_g_free0 (ret);
				ret = _tmp27_;
				_g_free0 (_tmp26_);
				_g_free0 (_tmp24_);
				_vala_code_node_unref0 (p);
			}
			_vala_iterable_unref0 (_p_list);
		}
	}
	result = ret;
	_g_free0 (signature);
	return result;
}


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static gchar*
vala_gsignal_module_get_value_type_name_from_type_reference (ValaGSignalModule* self, 
                                                             ValaDataType* t)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (t != NULL, NULL);
	if (G_TYPE_CHECK_INSTANCE_TYPE (t, VALA_TYPE_POINTER_TYPE)) {
		_tmp0_ = TRUE;
	} else {
		ValaTypeParameter* _tmp1_;
		ValaTypeParameter* _tmp2_;
		_tmp1_ = vala_data_type_get_type_parameter (t);
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_ != NULL;
	}
	if (_tmp0_) {
		gchar* _tmp3_;
		_tmp3_ = g_strdup ("gpointer");
		result = _tmp3_;
		return result;
	} else {
		if (G_TYPE_CHECK_INSTANCE_TYPE (t, VALA_TYPE_VOID_TYPE)) {
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("void");
			result = _tmp4_;
			return result;
		} else {
			gchar* _tmp5_;
			gchar* _tmp6_;
			ValaDataType* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			gboolean _tmp10_;
			_tmp5_ = vala_get_ccode_type_id ((ValaCodeNode*) t);
			_tmp6_ = _tmp5_;
			_tmp7_ = ((ValaCCodeBaseModule*) self)->string_type;
			_tmp8_ = vala_get_ccode_type_id ((ValaCodeNode*) _tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = g_strcmp0 (_tmp6_, _tmp9_) == 0;
			_g_free0 (_tmp9_);
			_g_free0 (_tmp6_);
			if (_tmp10_) {
				gchar* _tmp11_;
				_tmp11_ = g_strdup ("const char*");
				result = _tmp11_;
				return result;
			} else {
				gboolean _tmp12_ = FALSE;
				ValaTypeSymbol* _tmp13_;
				ValaTypeSymbol* _tmp14_;
				_tmp13_ = vala_data_type_get_data_type (t);
				_tmp14_ = _tmp13_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp14_, VALA_TYPE_CLASS)) {
					_tmp12_ = TRUE;
				} else {
					ValaTypeSymbol* _tmp15_;
					ValaTypeSymbol* _tmp16_;
					_tmp15_ = vala_data_type_get_data_type (t);
					_tmp16_ = _tmp15_;
					_tmp12_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, VALA_TYPE_INTERFACE);
				}
				if (_tmp12_) {
					gchar* _tmp17_;
					_tmp17_ = g_strdup ("gpointer");
					result = _tmp17_;
					return result;
				} else {
					gboolean _tmp18_ = FALSE;
					if (G_TYPE_CHECK_INSTANCE_TYPE (t, VALA_TYPE_VALUE_TYPE)) {
						gboolean _tmp19_;
						gboolean _tmp20_;
						_tmp19_ = vala_data_type_get_nullable (t);
						_tmp20_ = _tmp19_;
						_tmp18_ = _tmp20_;
					} else {
						_tmp18_ = FALSE;
					}
					if (_tmp18_) {
						gchar* _tmp21_;
						_tmp21_ = g_strdup ("gpointer");
						result = _tmp21_;
						return result;
					} else {
						ValaTypeSymbol* _tmp22_;
						ValaTypeSymbol* _tmp23_;
						_tmp22_ = vala_data_type_get_data_type (t);
						_tmp23_ = _tmp22_;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp23_, VALA_TYPE_STRUCT)) {
							ValaStruct* st = NULL;
							ValaTypeSymbol* _tmp24_;
							ValaTypeSymbol* _tmp25_;
							ValaStruct* _tmp26_;
							ValaStruct* _tmp27_;
							_tmp24_ = vala_data_type_get_data_type (t);
							_tmp25_ = _tmp24_;
							_tmp26_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, VALA_TYPE_STRUCT, ValaStruct));
							st = _tmp26_;
							_tmp27_ = st;
							if (vala_struct_is_simple_type (_tmp27_)) {
								ValaTypeSymbol* _tmp28_;
								ValaTypeSymbol* _tmp29_;
								gchar* _tmp30_;
								_tmp28_ = vala_data_type_get_data_type (t);
								_tmp29_ = _tmp28_;
								_tmp30_ = vala_get_ccode_name ((ValaCodeNode*) _tmp29_);
								result = _tmp30_;
								_vala_code_node_unref0 (st);
								return result;
							} else {
								gchar* _tmp31_;
								_tmp31_ = g_strdup ("gpointer");
								result = _tmp31_;
								_vala_code_node_unref0 (st);
								return result;
							}
							_vala_code_node_unref0 (st);
						} else {
							ValaTypeSymbol* _tmp32_;
							ValaTypeSymbol* _tmp33_;
							_tmp32_ = vala_data_type_get_data_type (t);
							_tmp33_ = _tmp32_;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp33_, VALA_TYPE_ENUM)) {
								gchar* _tmp34_;
								_tmp34_ = g_strdup ("gint");
								result = _tmp34_;
								return result;
							} else {
								if (G_TYPE_CHECK_INSTANCE_TYPE (t, VALA_TYPE_ARRAY_TYPE)) {
									gchar* _tmp35_;
									_tmp35_ = g_strdup ("gpointer");
									result = _tmp35_;
									return result;
								} else {
									if (G_TYPE_CHECK_INSTANCE_TYPE (t, VALA_TYPE_ERROR_TYPE)) {
										gchar* _tmp36_;
										_tmp36_ = g_strdup ("gpointer");
										result = _tmp36_;
										return result;
									}
								}
							}
						}
					}
				}
			}
		}
	}
	result = NULL;
	return result;
}


static gchar*
vala_gsignal_module_get_value_type_name_from_parameter (ValaGSignalModule* self, 
                                                        ValaParameter* p)
{
	gchar* result = NULL;
	ValaParameterDirection _tmp0_;
	ValaParameterDirection _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (p != NULL, NULL);
	_tmp0_ = vala_parameter_get_direction (p);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != VALA_PARAMETER_DIRECTION_IN) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("gpointer");
		result = _tmp2_;
		return result;
	} else {
		ValaDataType* _tmp3_;
		ValaDataType* _tmp4_;
		gchar* _tmp5_;
		_tmp3_ = vala_variable_get_variable_type ((ValaVariable*) p);
		_tmp4_ = _tmp3_;
		_tmp5_ = vala_gsignal_module_get_value_type_name_from_type_reference (self, _tmp4_);
		result = _tmp5_;
		return result;
	}
}


static gchar*
vala_gsignal_module_get_marshaller_signature (ValaGSignalModule* self, 
                                              ValaList* params, 
                                              ValaDataType* return_type)
{
	gchar* result = NULL;
	gchar* signature = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (params != NULL, NULL);
	g_return_val_if_fail (return_type != NULL, NULL);
	_tmp0_ = vala_get_ccode_marshaller_type_name ((ValaCodeNode*) return_type);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("%s:", _tmp1_);
	_g_free0 (signature);
	signature = _tmp2_;
	_g_free0 (_tmp1_);
	if (params == NULL) {
		_tmp3_ = TRUE;
	} else {
		gint _tmp4_;
		gint _tmp5_;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) params);
		_tmp5_ = _tmp4_;
		_tmp3_ = _tmp5_ == 0;
	}
	if (_tmp3_) {
		const gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp6_ = signature;
		_tmp7_ = g_strconcat (_tmp6_, "VOID", NULL);
		_g_free0 (signature);
		signature = _tmp7_;
	} else {
		gboolean first = FALSE;
		first = TRUE;
		{
			ValaList* _p_list = NULL;
			ValaList* _tmp8_;
			gint _p_size = 0;
			ValaList* _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			gint _p_index = 0;
			_tmp8_ = _vala_iterable_ref0 (params);
			_p_list = _tmp8_;
			_tmp9_ = _p_list;
			_tmp10_ = vala_collection_get_size ((ValaCollection*) _tmp9_);
			_tmp11_ = _tmp10_;
			_p_size = _tmp11_;
			_p_index = -1;
			while (TRUE) {
				gint _tmp12_;
				gint _tmp13_;
				gint _tmp14_;
				ValaParameter* p = NULL;
				ValaList* _tmp15_;
				gint _tmp16_;
				gpointer _tmp17_;
				gboolean _tmp18_;
				_tmp12_ = _p_index;
				_p_index = _tmp12_ + 1;
				_tmp13_ = _p_index;
				_tmp14_ = _p_size;
				if (!(_tmp13_ < _tmp14_)) {
					break;
				}
				_tmp15_ = _p_list;
				_tmp16_ = _p_index;
				_tmp17_ = vala_list_get (_tmp15_, _tmp16_);
				p = (ValaParameter*) _tmp17_;
				_tmp18_ = first;
				if (_tmp18_) {
					const gchar* _tmp19_;
					ValaParameter* _tmp20_;
					gchar* _tmp21_;
					gchar* _tmp22_;
					gchar* _tmp23_;
					_tmp19_ = signature;
					_tmp20_ = p;
					_tmp21_ = vala_get_ccode_marshaller_type_name ((ValaCodeNode*) _tmp20_);
					_tmp22_ = _tmp21_;
					_tmp23_ = g_strconcat (_tmp19_, _tmp22_, NULL);
					_g_free0 (signature);
					signature = _tmp23_;
					_g_free0 (_tmp22_);
					first = FALSE;
				} else {
					const gchar* _tmp24_;
					ValaParameter* _tmp25_;
					gchar* _tmp26_;
					gchar* _tmp27_;
					gchar* _tmp28_;
					_tmp24_ = signature;
					_tmp25_ = p;
					_tmp26_ = vala_get_ccode_marshaller_type_name ((ValaCodeNode*) _tmp25_);
					_tmp27_ = _tmp26_;
					_tmp28_ = g_strdup_printf ("%s,%s", _tmp24_, _tmp27_);
					_g_free0 (signature);
					signature = _tmp28_;
					_g_free0 (_tmp27_);
				}
				_vala_code_node_unref0 (p);
			}
			_vala_iterable_unref0 (_p_list);
		}
	}
	result = signature;
	return result;
}


static ValaCCodeExpression*
vala_gsignal_module_get_signal_name_cexpression (ValaGSignalModule* self, 
                                                 ValaSignal* sig, 
                                                 ValaExpression* detail_expr, 
                                                 ValaCodeNode* node)
{
	ValaCCodeExpression* result = NULL;
	gboolean _tmp1_ = FALSE;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	ValaTargetValue* detail_value = NULL;
	ValaDataType* _tmp13_;
	ValaDataType* _tmp14_;
	gboolean _tmp15_;
	ValaTargetValue* _tmp16_;
	ValaArrayList* _tmp17_;
	ValaArrayList* _tmp18_;
	ValaTargetValue* _tmp19_;
	ValaCCodeFunctionCall* ccall = NULL;
	ValaCCodeIdentifier* _tmp20_;
	ValaCCodeIdentifier* _tmp21_;
	ValaCCodeFunctionCall* _tmp22_;
	ValaCCodeFunctionCall* _tmp23_;
	ValaCCodeFunctionCall* _tmp24_;
	ValaCCodeConstant* _tmp25_;
	ValaCCodeConstant* _tmp26_;
	ValaCCodeFunctionCall* _tmp27_;
	ValaCCodeExpression* _tmp28_;
	ValaCCodeExpression* _tmp29_;
	ValaCCodeFunctionCall* _tmp30_;
	ValaCCodeConstant* _tmp31_;
	ValaCCodeConstant* _tmp32_;
	ValaCCodeFunction* _tmp33_;
	ValaCCodeFunction* _tmp34_;
	ValaTargetValue* _tmp35_;
	ValaCCodeExpression* _tmp36_;
	ValaCCodeExpression* _tmp37_;
	ValaCCodeFunctionCall* _tmp38_;
	ValaTargetValue* _tmp39_;
	ValaCCodeExpression* _tmp40_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sig != NULL, NULL);
	g_return_val_if_fail (node != NULL, NULL);
	if (detail_expr == NULL) {
		ValaCCodeConstant* _tmp0_;
		_tmp0_ = vala_ccode_base_module_get_signal_canonical_constant ((ValaCCodeBaseModule*) self, sig, NULL);
		result = (ValaCCodeExpression*) _tmp0_;
		return result;
	}
	_tmp2_ = vala_expression_get_value_type (detail_expr);
	_tmp3_ = _tmp2_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, VALA_TYPE_NULL_TYPE)) {
		_tmp1_ = TRUE;
	} else {
		ValaDataType* _tmp4_;
		ValaDataType* _tmp5_;
		ValaDataType* _tmp6_;
		_tmp4_ = vala_expression_get_value_type (detail_expr);
		_tmp5_ = _tmp4_;
		_tmp6_ = ((ValaCCodeBaseModule*) self)->string_type;
		_tmp1_ = !vala_data_type_compatible (_tmp5_, _tmp6_);
	}
	if (_tmp1_) {
		ValaSourceReference* _tmp7_;
		ValaSourceReference* _tmp8_;
		vala_code_node_set_error (node, TRUE);
		_tmp7_ = vala_code_node_get_source_reference ((ValaCodeNode*) detail_expr);
		_tmp8_ = _tmp7_;
		vala_report_error (_tmp8_, "only string details are supported");
		result = NULL;
		return result;
	}
	if (G_TYPE_CHECK_INSTANCE_TYPE (detail_expr, VALA_TYPE_STRING_LITERAL)) {
		gchar* _tmp9_;
		gchar* _tmp10_;
		ValaCCodeConstant* _tmp11_;
		ValaCCodeExpression* _tmp12_;
		_tmp9_ = vala_string_literal_eval (G_TYPE_CHECK_INSTANCE_CAST (detail_expr, VALA_TYPE_STRING_LITERAL, ValaStringLiteral));
		_tmp10_ = _tmp9_;
		_tmp11_ = vala_ccode_base_module_get_signal_canonical_constant ((ValaCCodeBaseModule*) self, sig, _tmp10_);
		_tmp12_ = (ValaCCodeExpression*) _tmp11_;
		_g_free0 (_tmp10_);
		result = _tmp12_;
		return result;
	}
	_tmp13_ = vala_expression_get_value_type (detail_expr);
	_tmp14_ = _tmp13_;
	_tmp15_ = TRUE;
	_tmp16_ = vala_ccode_base_module_create_temp_value ((ValaCCodeBaseModule*) self, _tmp14_, FALSE, node, &_tmp15_);
	detail_value = _tmp16_;
	_tmp17_ = vala_ccode_base_module_get_temp_ref_values ((ValaCCodeBaseModule*) self);
	_tmp18_ = _tmp17_;
	_tmp19_ = detail_value;
	vala_list_insert ((ValaList*) _tmp18_, 0, _tmp19_);
	_tmp20_ = vala_ccode_identifier_new ("g_strconcat");
	_tmp21_ = _tmp20_;
	_tmp22_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp21_);
	_tmp23_ = _tmp22_;
	_vala_ccode_node_unref0 (_tmp21_);
	ccall = _tmp23_;
	_tmp24_ = ccall;
	_tmp25_ = vala_ccode_base_module_get_signal_canonical_constant ((ValaCCodeBaseModule*) self, sig, "");
	_tmp26_ = _tmp25_;
	vala_ccode_function_call_add_argument (_tmp24_, (ValaCCodeExpression*) _tmp26_);
	_vala_ccode_node_unref0 (_tmp26_);
	_tmp27_ = ccall;
	_tmp28_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, detail_expr);
	_tmp29_ = _tmp28_;
	vala_ccode_function_call_add_argument (_tmp27_, _tmp29_);
	_vala_ccode_node_unref0 (_tmp29_);
	_tmp30_ = ccall;
	_tmp31_ = vala_ccode_constant_new ("NULL");
	_tmp32_ = _tmp31_;
	vala_ccode_function_call_add_argument (_tmp30_, (ValaCCodeExpression*) _tmp32_);
	_vala_ccode_node_unref0 (_tmp32_);
	_tmp33_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp34_ = _tmp33_;
	_tmp35_ = detail_value;
	_tmp36_ = vala_ccode_base_module_get_cvalue_ ((ValaCCodeBaseModule*) self, _tmp35_);
	_tmp37_ = _tmp36_;
	_tmp38_ = ccall;
	vala_ccode_function_add_assignment (_tmp34_, _tmp37_, (ValaCCodeExpression*) _tmp38_);
	_vala_ccode_node_unref0 (_tmp37_);
	_tmp39_ = detail_value;
	_tmp40_ = vala_ccode_base_module_get_cvalue_ ((ValaCCodeBaseModule*) self, _tmp39_);
	result = _tmp40_;
	_vala_ccode_node_unref0 (ccall);
	_vala_target_value_unref0 (detail_value);
	return result;
}


static ValaCCodeExpression*
vala_gsignal_module_get_signal_id_cexpression (ValaGSignalModule* self, 
                                               ValaSignal* sig)
{
	ValaCCodeExpression* result = NULL;
	ValaTypeSymbol* cl = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaTypeSymbol* _tmp2_;
	ValaCCodeIdentifier* signal_array = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	ValaCCodeIdentifier* _tmp7_;
	ValaCCodeIdentifier* _tmp8_;
	ValaCCodeIdentifier* signal_enum_value = NULL;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	ValaCCodeIdentifier* _tmp15_;
	ValaCCodeIdentifier* _tmp16_;
	ValaCCodeElementAccess* _tmp17_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sig != NULL, NULL);
	_tmp0_ = vala_symbol_get_parent_symbol ((ValaSymbol*) sig);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
	cl = _tmp2_;
	_tmp3_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) cl, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup_printf ("%s_signals", _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_ccode_identifier_new (_tmp6_);
	_tmp8_ = _tmp7_;
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	signal_array = _tmp8_;
	_tmp9_ = vala_get_ccode_upper_case_name ((ValaSymbol*) cl, NULL);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_get_ccode_upper_case_name ((ValaSymbol*) sig, NULL);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_strdup_printf ("%s_%s_SIGNAL", _tmp10_, _tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = vala_ccode_identifier_new (_tmp14_);
	_tmp16_ = _tmp15_;
	_g_free0 (_tmp14_);
	_g_free0 (_tmp12_);
	_g_free0 (_tmp10_);
	signal_enum_value = _tmp16_;
	_tmp17_ = vala_ccode_element_access_new ((ValaCCodeExpression*) signal_array, (ValaCCodeExpression*) signal_enum_value);
	result = (ValaCCodeExpression*) _tmp17_;
	_vala_ccode_node_unref0 (signal_enum_value);
	_vala_ccode_node_unref0 (signal_array);
	_vala_code_node_unref0 (cl);
	return result;
}


static ValaCCodeExpression*
vala_gsignal_module_get_detail_cexpression (ValaGSignalModule* self, 
                                            ValaExpression* detail_expr, 
                                            ValaCodeNode* node)
{
	ValaCCodeExpression* result = NULL;
	gboolean _tmp0_ = FALSE;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	ValaCCodeExpression* detail_cexpr = NULL;
	ValaCCodeExpression* _tmp8_;
	ValaCCodeFunctionCall* detail_ccall = NULL;
	ValaCCodeExpression* _tmp9_;
	ValaCCodeFunctionCall* _tmp16_;
	ValaCCodeExpression* _tmp17_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (detail_expr != NULL, NULL);
	g_return_val_if_fail (node != NULL, NULL);
	_tmp1_ = vala_expression_get_value_type (detail_expr);
	_tmp2_ = _tmp1_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, VALA_TYPE_NULL_TYPE)) {
		_tmp0_ = TRUE;
	} else {
		ValaDataType* _tmp3_;
		ValaDataType* _tmp4_;
		ValaDataType* _tmp5_;
		_tmp3_ = vala_expression_get_value_type (detail_expr);
		_tmp4_ = _tmp3_;
		_tmp5_ = ((ValaCCodeBaseModule*) self)->string_type;
		_tmp0_ = !vala_data_type_compatible (_tmp4_, _tmp5_);
	}
	if (_tmp0_) {
		ValaSourceReference* _tmp6_;
		ValaSourceReference* _tmp7_;
		vala_code_node_set_error (node, TRUE);
		_tmp6_ = vala_code_node_get_source_reference ((ValaCodeNode*) detail_expr);
		_tmp7_ = _tmp6_;
		vala_report_error (_tmp7_, "only string details are supported");
		result = NULL;
		return result;
	}
	_tmp8_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, detail_expr);
	detail_cexpr = _tmp8_;
	_tmp9_ = detail_cexpr;
	if (vala_ccode_base_module_is_constant_ccode_expression ((ValaCCodeBaseModule*) self, _tmp9_)) {
		ValaCCodeIdentifier* _tmp10_;
		ValaCCodeIdentifier* _tmp11_;
		ValaCCodeFunctionCall* _tmp12_;
		_tmp10_ = vala_ccode_identifier_new ("g_quark_from_static_string");
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp11_);
		_vala_ccode_node_unref0 (detail_ccall);
		detail_ccall = _tmp12_;
		_vala_ccode_node_unref0 (_tmp11_);
	} else {
		ValaCCodeIdentifier* _tmp13_;
		ValaCCodeIdentifier* _tmp14_;
		ValaCCodeFunctionCall* _tmp15_;
		_tmp13_ = vala_ccode_identifier_new ("g_quark_from_string");
		_tmp14_ = _tmp13_;
		_tmp15_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp14_);
		_vala_ccode_node_unref0 (detail_ccall);
		detail_ccall = _tmp15_;
		_vala_ccode_node_unref0 (_tmp14_);
	}
	_tmp16_ = detail_ccall;
	_tmp17_ = detail_cexpr;
	vala_ccode_function_call_add_argument (_tmp16_, _tmp17_);
	result = (ValaCCodeExpression*) detail_ccall;
	_vala_ccode_node_unref0 (detail_cexpr);
	return result;
}


static void
vala_gsignal_module_real_visit_signal (ValaCodeVisitor* base, 
                                       ValaSignal* sig)
{
	ValaGSignalModule * self;
	ValaClass* cl = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaClass* _tmp2_;
	gboolean _tmp3_ = FALSE;
	ValaClass* _tmp4_;
	ValaClass* _tmp10_;
	ValaCCodeEnum* _tmp32_;
	ValaSymbol* _tmp33_;
	ValaSymbol* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	gchar* _tmp40_;
	ValaCCodeEnumValue* _tmp41_;
	ValaCCodeEnumValue* _tmp42_;
	ValaList* _tmp62_;
	ValaList* _tmp63_;
	ValaDataType* _tmp64_;
	ValaDataType* _tmp65_;
	self = (ValaGSignalModule*) base;
	g_return_if_fail (sig != NULL);
	_tmp0_ = vala_symbol_get_parent_symbol ((ValaSymbol*) sig);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_CLASS) ? ((ValaClass*) _tmp1_) : NULL);
	cl = _tmp2_;
	_tmp4_ = cl;
	if (_tmp4_ != NULL) {
		ValaClass* _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_;
		_tmp5_ = cl;
		_tmp6_ = vala_class_get_is_compact (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp3_ = _tmp7_;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		ValaSourceReference* _tmp8_;
		ValaSourceReference* _tmp9_;
		vala_code_node_set_error ((ValaCodeNode*) sig, TRUE);
		_tmp8_ = vala_code_node_get_source_reference ((ValaCodeNode*) sig);
		_tmp9_ = _tmp8_;
		vala_report_error (_tmp9_, "Signals are not supported in compact classes");
		_vala_code_node_unref0 (cl);
		return;
	}
	_tmp10_ = cl;
	if (_tmp10_ != NULL) {
		{
			ValaList* _base_type_list = NULL;
			ValaClass* _tmp11_;
			ValaList* _tmp12_;
			gint _base_type_size = 0;
			ValaList* _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
			gint _base_type_index = 0;
			_tmp11_ = cl;
			_tmp12_ = vala_class_get_base_types (_tmp11_);
			_base_type_list = _tmp12_;
			_tmp13_ = _base_type_list;
			_tmp14_ = vala_collection_get_size ((ValaCollection*) _tmp13_);
			_tmp15_ = _tmp14_;
			_base_type_size = _tmp15_;
			_base_type_index = -1;
			while (TRUE) {
				gint _tmp16_;
				gint _tmp17_;
				gint _tmp18_;
				ValaDataType* base_type = NULL;
				ValaList* _tmp19_;
				gint _tmp20_;
				gpointer _tmp21_;
				ValaDataType* _tmp22_;
				ValaTypeSymbol* _tmp23_;
				ValaTypeSymbol* _tmp24_;
				const gchar* _tmp25_;
				const gchar* _tmp26_;
				ValaSymbol* _tmp27_;
				ValaSymbol* _tmp28_;
				gboolean _tmp29_;
				_tmp16_ = _base_type_index;
				_base_type_index = _tmp16_ + 1;
				_tmp17_ = _base_type_index;
				_tmp18_ = _base_type_size;
				if (!(_tmp17_ < _tmp18_)) {
					break;
				}
				_tmp19_ = _base_type_list;
				_tmp20_ = _base_type_index;
				_tmp21_ = vala_list_get (_tmp19_, _tmp20_);
				base_type = (ValaDataType*) _tmp21_;
				_tmp22_ = base_type;
				_tmp23_ = vala_data_type_get_data_type (_tmp22_);
				_tmp24_ = _tmp23_;
				_tmp25_ = vala_symbol_get_name ((ValaSymbol*) sig);
				_tmp26_ = _tmp25_;
				_tmp27_ = vala_semantic_analyzer_symbol_lookup_inherited ((ValaSymbol*) _tmp24_, _tmp26_);
				_tmp28_ = _tmp27_;
				_tmp29_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp28_, VALA_TYPE_SIGNAL);
				_vala_code_node_unref0 (_tmp28_);
				if (_tmp29_) {
					ValaSourceReference* _tmp30_;
					ValaSourceReference* _tmp31_;
					vala_code_node_set_error ((ValaCodeNode*) sig, TRUE);
					_tmp30_ = vala_code_node_get_source_reference ((ValaCodeNode*) sig);
					_tmp31_ = _tmp30_;
					vala_report_error (_tmp31_, "Signals with the same name as a signal in a base type are not supporte" \
"d");
					_vala_code_node_unref0 (base_type);
					_vala_iterable_unref0 (_base_type_list);
					_vala_code_node_unref0 (cl);
					return;
				}
				_vala_code_node_unref0 (base_type);
			}
			_vala_iterable_unref0 (_base_type_list);
		}
	}
	_tmp32_ = ((ValaCCodeBaseModule*) self)->signal_enum;
	_tmp33_ = vala_symbol_get_parent_symbol ((ValaSymbol*) sig);
	_tmp34_ = _tmp33_;
	_tmp35_ = vala_get_ccode_upper_case_name ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol), NULL);
	_tmp36_ = _tmp35_;
	_tmp37_ = vala_get_ccode_upper_case_name ((ValaSymbol*) sig, NULL);
	_tmp38_ = _tmp37_;
	_tmp39_ = g_strdup_printf ("%s_%s_SIGNAL", _tmp36_, _tmp38_);
	_tmp40_ = _tmp39_;
	_tmp41_ = vala_ccode_enum_value_new (_tmp40_, NULL);
	_tmp42_ = _tmp41_;
	vala_ccode_enum_add_value (_tmp32_, _tmp42_);
	_vala_ccode_node_unref0 (_tmp42_);
	_g_free0 (_tmp40_);
	_g_free0 (_tmp38_);
	_g_free0 (_tmp36_);
	vala_code_node_accept_children ((ValaCodeNode*) sig, (ValaCodeVisitor*) self);
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp43_;
		gint _p_size = 0;
		ValaList* _tmp44_;
		gint _tmp45_;
		gint _tmp46_;
		gint _p_index = 0;
		_tmp43_ = vala_callable_get_parameters ((ValaCallable*) sig);
		_p_list = _tmp43_;
		_tmp44_ = _p_list;
		_tmp45_ = vala_collection_get_size ((ValaCollection*) _tmp44_);
		_tmp46_ = _tmp45_;
		_p_size = _tmp46_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp47_;
			gint _tmp48_;
			gint _tmp49_;
			ValaParameter* p = NULL;
			ValaList* _tmp50_;
			gint _tmp51_;
			gpointer _tmp52_;
			ValaParameter* _tmp53_;
			ValaCCodeFile* _tmp54_;
			GHashFunc _tmp55_;
			GEqualFunc _tmp56_;
			GEqualFunc _tmp57_;
			ValaHashMap* _tmp58_;
			ValaHashMap* _tmp59_;
			ValaCCodeParameter* _tmp60_;
			ValaCCodeParameter* _tmp61_;
			_tmp47_ = _p_index;
			_p_index = _tmp47_ + 1;
			_tmp48_ = _p_index;
			_tmp49_ = _p_size;
			if (!(_tmp48_ < _tmp49_)) {
				break;
			}
			_tmp50_ = _p_list;
			_tmp51_ = _p_index;
			_tmp52_ = vala_list_get (_tmp50_, _tmp51_);
			p = (ValaParameter*) _tmp52_;
			_tmp53_ = p;
			_tmp54_ = ((ValaCCodeBaseModule*) self)->cfile;
			_tmp55_ = g_direct_hash;
			_tmp56_ = g_direct_equal;
			_tmp57_ = g_direct_equal;
			_tmp58_ = vala_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_PARAMETER, (GBoxedCopyFunc) vala_ccode_node_ref, (GDestroyNotify) vala_ccode_node_unref, _tmp55_, _tmp56_, _tmp57_);
			_tmp59_ = _tmp58_;
			_tmp60_ = vala_ccode_method_module_generate_parameter ((ValaCCodeMethodModule*) self, _tmp53_, _tmp54_, (ValaMap*) _tmp59_, NULL);
			_tmp61_ = _tmp60_;
			_vala_ccode_node_unref0 (_tmp61_);
			_vala_map_unref0 (_tmp59_);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	_tmp62_ = vala_callable_get_parameters ((ValaCallable*) sig);
	_tmp63_ = _tmp62_;
	_tmp64_ = vala_callable_get_return_type ((ValaCallable*) sig);
	_tmp65_ = _tmp64_;
	vala_gsignal_module_generate_marshaller (self, _tmp63_, _tmp65_);
	_vala_iterable_unref0 (_tmp63_);
	_vala_code_node_unref0 (cl);
}


static void
vala_gsignal_module_generate_marshaller (ValaGSignalModule* self, 
                                         ValaList* params, 
                                         ValaDataType* return_type)
{
	gchar* signature = NULL;
	gint n_params = 0;
	gint i = 0;
	gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	ValaSet* _tmp2_;
	const gchar* _tmp3_;
	ValaCCodeFunction* signal_marshaller = NULL;
	gchar* _tmp6_;
	gchar* _tmp7_;
	ValaCCodeFunction* _tmp8_;
	ValaCCodeFunction* _tmp9_;
	ValaCCodeFunction* _tmp10_;
	ValaCCodeFunction* _tmp11_;
	ValaCCodeParameter* _tmp12_;
	ValaCCodeParameter* _tmp13_;
	ValaCCodeFunction* _tmp14_;
	ValaCCodeParameter* _tmp15_;
	ValaCCodeParameter* _tmp16_;
	ValaCCodeFunction* _tmp17_;
	ValaCCodeParameter* _tmp18_;
	ValaCCodeParameter* _tmp19_;
	ValaCCodeFunction* _tmp20_;
	ValaCCodeParameter* _tmp21_;
	ValaCCodeParameter* _tmp22_;
	ValaCCodeFunction* _tmp23_;
	ValaCCodeParameter* _tmp24_;
	ValaCCodeParameter* _tmp25_;
	ValaCCodeFunction* _tmp26_;
	ValaCCodeParameter* _tmp27_;
	ValaCCodeParameter* _tmp28_;
	ValaCCodeFunction* _tmp29_;
	ValaCCodeFunctionDeclarator* callback_decl = NULL;
	gchar* _tmp30_;
	gchar* _tmp31_;
	ValaCCodeFunctionDeclarator* _tmp32_;
	ValaCCodeFunctionDeclarator* _tmp33_;
	ValaCCodeFunctionDeclarator* _tmp34_;
	ValaCCodeParameter* _tmp35_;
	ValaCCodeParameter* _tmp36_;
	ValaCCodeFunctionDeclarator* _tmp75_;
	ValaCCodeParameter* _tmp76_;
	ValaCCodeParameter* _tmp77_;
	ValaCCodeFunction* _tmp78_;
	ValaCCodeFunction* _tmp79_;
	gchar* _tmp80_;
	gchar* _tmp81_;
	ValaCCodeFunctionDeclarator* _tmp82_;
	ValaCCodeTypeDefinition* _tmp83_;
	ValaCCodeTypeDefinition* _tmp84_;
	ValaCCodeFunction* _tmp85_;
	ValaCCodeFunction* _tmp86_;
	gchar* _tmp87_;
	gchar* _tmp88_;
	ValaCCodeVariableDeclarator* _tmp89_;
	ValaCCodeVariableDeclarator* _tmp90_;
	ValaCCodeFunction* _tmp91_;
	ValaCCodeFunction* _tmp92_;
	ValaCCodeIdentifier* _tmp93_;
	ValaCCodeIdentifier* _tmp94_;
	ValaCCodeCastExpression* _tmp95_;
	ValaCCodeCastExpression* _tmp96_;
	ValaCCodeVariableDeclarator* _tmp97_;
	ValaCCodeVariableDeclarator* _tmp98_;
	ValaCCodeFunction* _tmp99_;
	ValaCCodeFunction* _tmp100_;
	ValaCCodeVariableDeclarator* _tmp101_;
	ValaCCodeVariableDeclarator* _tmp102_;
	ValaCCodeFunction* _tmp103_;
	ValaCCodeFunction* _tmp104_;
	ValaCCodeVariableDeclarator* _tmp105_;
	ValaCCodeVariableDeclarator* _tmp106_;
	ValaCCodeFunctionCall* fc = NULL;
	gboolean _tmp107_ = FALSE;
	ValaTypeSymbol* _tmp108_;
	ValaTypeSymbol* _tmp109_;
	ValaCCodeIdentifier* _tmp129_;
	ValaCCodeIdentifier* _tmp130_;
	ValaCCodeFunctionCall* _tmp131_;
	ValaCCodeFunctionCall* _tmp132_;
	ValaCCodeIdentifier* _tmp133_;
	ValaCCodeIdentifier* _tmp134_;
	gint _tmp135_;
	gchar* _tmp136_;
	gchar* _tmp137_;
	ValaCCodeConstant* _tmp138_;
	ValaCCodeConstant* _tmp139_;
	ValaCCodeBinaryExpression* _tmp140_;
	ValaCCodeBinaryExpression* _tmp141_;
	ValaCCodeFunction* _tmp142_;
	ValaCCodeFunction* _tmp143_;
	ValaCCodeFunctionCall* _tmp144_;
	ValaCCodeMemberAccess* data = NULL;
	ValaCCodeIdentifier* _tmp145_;
	ValaCCodeIdentifier* _tmp146_;
	ValaCCodeMemberAccess* _tmp147_;
	ValaCCodeMemberAccess* _tmp148_;
	ValaCCodeMemberAccess* param = NULL;
	ValaCCodeIdentifier* _tmp149_;
	ValaCCodeIdentifier* _tmp150_;
	ValaCCodeMemberAccess* _tmp151_;
	ValaCCodeMemberAccess* _tmp152_;
	ValaCCodeMemberAccess* _tmp153_;
	ValaCCodeMemberAccess* _tmp154_;
	ValaCCodeFunctionCall* cond = NULL;
	ValaCCodeConstant* _tmp155_;
	ValaCCodeConstant* _tmp156_;
	ValaCCodeFunctionCall* _tmp157_;
	ValaCCodeFunctionCall* _tmp158_;
	ValaCCodeFunctionCall* _tmp159_;
	ValaCCodeIdentifier* _tmp160_;
	ValaCCodeIdentifier* _tmp161_;
	ValaCCodeFunction* _tmp162_;
	ValaCCodeFunction* _tmp163_;
	ValaCCodeFunctionCall* _tmp164_;
	ValaCCodeFunction* _tmp165_;
	ValaCCodeFunction* _tmp166_;
	ValaCCodeIdentifier* _tmp167_;
	ValaCCodeIdentifier* _tmp168_;
	ValaCCodeMemberAccess* _tmp169_;
	ValaCCodeFunction* _tmp170_;
	ValaCCodeFunction* _tmp171_;
	ValaCCodeIdentifier* _tmp172_;
	ValaCCodeIdentifier* _tmp173_;
	ValaCCodeMemberAccess* _tmp174_;
	ValaCCodeFunction* _tmp175_;
	ValaCCodeFunction* _tmp176_;
	ValaCCodeFunction* _tmp177_;
	ValaCCodeFunction* _tmp178_;
	ValaCCodeIdentifier* _tmp179_;
	ValaCCodeIdentifier* _tmp180_;
	ValaCCodeMemberAccess* _tmp181_;
	ValaCCodeFunction* _tmp182_;
	ValaCCodeFunction* _tmp183_;
	ValaCCodeIdentifier* _tmp184_;
	ValaCCodeIdentifier* _tmp185_;
	ValaCCodeMemberAccess* _tmp186_;
	ValaCCodeFunction* _tmp187_;
	ValaCCodeFunction* _tmp188_;
	ValaCCodeCastExpression* c_assign_rhs = NULL;
	ValaCCodeIdentifier* _tmp189_;
	ValaCCodeIdentifier* _tmp190_;
	ValaCCodeIdentifier* _tmp191_;
	ValaCCodeIdentifier* _tmp192_;
	ValaCCodeIdentifier* _tmp193_;
	ValaCCodeIdentifier* _tmp194_;
	ValaCCodeMemberAccess* _tmp195_;
	ValaCCodeMemberAccess* _tmp196_;
	ValaCCodeConditionalExpression* _tmp197_;
	ValaCCodeConditionalExpression* _tmp198_;
	gchar* _tmp199_;
	gchar* _tmp200_;
	ValaCCodeCastExpression* _tmp201_;
	ValaCCodeCastExpression* _tmp202_;
	ValaCCodeFunction* _tmp203_;
	ValaCCodeFunction* _tmp204_;
	ValaCCodeIdentifier* _tmp205_;
	ValaCCodeIdentifier* _tmp206_;
	ValaCCodeCastExpression* _tmp207_;
	ValaCCodeIdentifier* _tmp208_;
	ValaCCodeIdentifier* _tmp209_;
	ValaCCodeFunctionCall* _tmp210_;
	ValaCCodeFunctionCall* _tmp211_;
	ValaCCodeIdentifier* _tmp212_;
	ValaCCodeIdentifier* _tmp213_;
	ValaCCodeFunctionCall* _tmp317_;
	ValaCCodeIdentifier* _tmp318_;
	ValaCCodeIdentifier* _tmp319_;
	gboolean _tmp320_ = FALSE;
	ValaTypeSymbol* _tmp321_;
	ValaTypeSymbol* _tmp322_;
	ValaCCodeFile* _tmp390_;
	ValaCCodeFunction* _tmp391_;
	ValaCCodeFile* _tmp392_;
	ValaCCodeFunction* _tmp393_;
	ValaSet* _tmp394_;
	const gchar* _tmp395_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (params != NULL);
	g_return_if_fail (return_type != NULL);
	_tmp0_ = vala_gsignal_module_get_marshaller_signature (self, params, return_type);
	_g_free0 (signature);
	signature = _tmp0_;
	_tmp2_ = ((ValaCCodeBaseModule*) self)->predefined_marshal_set;
	_tmp3_ = signature;
	if (vala_collection_contains ((ValaCollection*) _tmp2_, _tmp3_)) {
		_tmp1_ = TRUE;
	} else {
		ValaSet* _tmp4_;
		const gchar* _tmp5_;
		_tmp4_ = ((ValaCCodeBaseModule*) self)->user_marshal_set;
		_tmp5_ = signature;
		_tmp1_ = vala_collection_contains ((ValaCollection*) _tmp4_, _tmp5_);
	}
	if (_tmp1_) {
		_g_free0 (signature);
		return;
	}
	_tmp6_ = vala_gsignal_module_get_marshaller_function (self, params, return_type, NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = vala_ccode_function_new (_tmp7_, "void");
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp7_);
	signal_marshaller = _tmp9_;
	_tmp10_ = signal_marshaller;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp10_, VALA_CCODE_MODIFIERS_STATIC);
	_tmp11_ = signal_marshaller;
	_tmp12_ = vala_ccode_parameter_new ("closure", "GClosure *");
	_tmp13_ = _tmp12_;
	vala_ccode_function_add_parameter (_tmp11_, _tmp13_);
	_vala_ccode_node_unref0 (_tmp13_);
	_tmp14_ = signal_marshaller;
	_tmp15_ = vala_ccode_parameter_new ("return_value", "GValue *");
	_tmp16_ = _tmp15_;
	vala_ccode_function_add_parameter (_tmp14_, _tmp16_);
	_vala_ccode_node_unref0 (_tmp16_);
	_tmp17_ = signal_marshaller;
	_tmp18_ = vala_ccode_parameter_new ("n_param_values", "guint");
	_tmp19_ = _tmp18_;
	vala_ccode_function_add_parameter (_tmp17_, _tmp19_);
	_vala_ccode_node_unref0 (_tmp19_);
	_tmp20_ = signal_marshaller;
	_tmp21_ = vala_ccode_parameter_new ("param_values", "const GValue *");
	_tmp22_ = _tmp21_;
	vala_ccode_function_add_parameter (_tmp20_, _tmp22_);
	_vala_ccode_node_unref0 (_tmp22_);
	_tmp23_ = signal_marshaller;
	_tmp24_ = vala_ccode_parameter_new ("invocation_hint", "gpointer");
	_tmp25_ = _tmp24_;
	vala_ccode_function_add_parameter (_tmp23_, _tmp25_);
	_vala_ccode_node_unref0 (_tmp25_);
	_tmp26_ = signal_marshaller;
	_tmp27_ = vala_ccode_parameter_new ("marshal_data", "gpointer");
	_tmp28_ = _tmp27_;
	vala_ccode_function_add_parameter (_tmp26_, _tmp28_);
	_vala_ccode_node_unref0 (_tmp28_);
	_tmp29_ = signal_marshaller;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp29_);
	_tmp30_ = vala_gsignal_module_get_marshaller_function (self, params, return_type, "GMarshalFunc");
	_tmp31_ = _tmp30_;
	_tmp32_ = vala_ccode_function_declarator_new (_tmp31_);
	_tmp33_ = _tmp32_;
	_g_free0 (_tmp31_);
	callback_decl = _tmp33_;
	_tmp34_ = callback_decl;
	_tmp35_ = vala_ccode_parameter_new ("data1", "gpointer");
	_tmp36_ = _tmp35_;
	vala_ccode_function_declarator_add_parameter (_tmp34_, _tmp36_);
	_vala_ccode_node_unref0 (_tmp36_);
	n_params = 1;
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp37_;
		gint _p_size = 0;
		ValaList* _tmp38_;
		gint _tmp39_;
		gint _tmp40_;
		gint _p_index = 0;
		_tmp37_ = _vala_iterable_ref0 (params);
		_p_list = _tmp37_;
		_tmp38_ = _p_list;
		_tmp39_ = vala_collection_get_size ((ValaCollection*) _tmp38_);
		_tmp40_ = _tmp39_;
		_p_size = _tmp40_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp41_;
			gint _tmp42_;
			gint _tmp43_;
			ValaParameter* p = NULL;
			ValaList* _tmp44_;
			gint _tmp45_;
			gpointer _tmp46_;
			ValaCCodeFunctionDeclarator* _tmp47_;
			gint _tmp48_;
			gchar* _tmp49_;
			gchar* _tmp50_;
			ValaParameter* _tmp51_;
			gchar* _tmp52_;
			gchar* _tmp53_;
			ValaCCodeParameter* _tmp54_;
			ValaCCodeParameter* _tmp55_;
			gint _tmp56_;
			ValaParameter* _tmp57_;
			ValaDataType* _tmp58_;
			ValaDataType* _tmp59_;
			_tmp41_ = _p_index;
			_p_index = _tmp41_ + 1;
			_tmp42_ = _p_index;
			_tmp43_ = _p_size;
			if (!(_tmp42_ < _tmp43_)) {
				break;
			}
			_tmp44_ = _p_list;
			_tmp45_ = _p_index;
			_tmp46_ = vala_list_get (_tmp44_, _tmp45_);
			p = (ValaParameter*) _tmp46_;
			_tmp47_ = callback_decl;
			_tmp48_ = n_params;
			_tmp49_ = g_strdup_printf ("arg_%d", _tmp48_);
			_tmp50_ = _tmp49_;
			_tmp51_ = p;
			_tmp52_ = vala_gsignal_module_get_value_type_name_from_parameter (self, _tmp51_);
			_tmp53_ = _tmp52_;
			_tmp54_ = vala_ccode_parameter_new (_tmp50_, _tmp53_);
			_tmp55_ = _tmp54_;
			vala_ccode_function_declarator_add_parameter (_tmp47_, _tmp55_);
			_vala_ccode_node_unref0 (_tmp55_);
			_g_free0 (_tmp53_);
			_g_free0 (_tmp50_);
			_tmp56_ = n_params;
			n_params = _tmp56_ + 1;
			_tmp57_ = p;
			_tmp58_ = vala_variable_get_variable_type ((ValaVariable*) _tmp57_);
			_tmp59_ = _tmp58_;
			if (vala_data_type_is_array (_tmp59_)) {
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp60_ = FALSE;
						_tmp60_ = TRUE;
						while (TRUE) {
							gint _tmp62_;
							ValaParameter* _tmp63_;
							ValaDataType* _tmp64_;
							ValaDataType* _tmp65_;
							gint _tmp66_;
							gint _tmp67_;
							ValaCCodeFunctionDeclarator* _tmp68_;
							gint _tmp69_;
							gchar* _tmp70_;
							gchar* _tmp71_;
							ValaCCodeParameter* _tmp72_;
							ValaCCodeParameter* _tmp73_;
							gint _tmp74_;
							if (!_tmp60_) {
								gint _tmp61_;
								_tmp61_ = j;
								j = _tmp61_ + 1;
							}
							_tmp60_ = FALSE;
							_tmp62_ = j;
							_tmp63_ = p;
							_tmp64_ = vala_variable_get_variable_type ((ValaVariable*) _tmp63_);
							_tmp65_ = _tmp64_;
							_tmp66_ = vala_array_type_get_rank (G_TYPE_CHECK_INSTANCE_CAST (_tmp65_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
							_tmp67_ = _tmp66_;
							if (!(_tmp62_ < _tmp67_)) {
								break;
							}
							_tmp68_ = callback_decl;
							_tmp69_ = n_params;
							_tmp70_ = g_strdup_printf ("arg_%d", _tmp69_);
							_tmp71_ = _tmp70_;
							_tmp72_ = vala_ccode_parameter_new (_tmp71_, "gint");
							_tmp73_ = _tmp72_;
							vala_ccode_function_declarator_add_parameter (_tmp68_, _tmp73_);
							_vala_ccode_node_unref0 (_tmp73_);
							_g_free0 (_tmp71_);
							_tmp74_ = n_params;
							n_params = _tmp74_ + 1;
						}
					}
				}
			}
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	_tmp75_ = callback_decl;
	_tmp76_ = vala_ccode_parameter_new ("data2", "gpointer");
	_tmp77_ = _tmp76_;
	vala_ccode_function_declarator_add_parameter (_tmp75_, _tmp77_);
	_vala_ccode_node_unref0 (_tmp77_);
	_tmp78_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp79_ = _tmp78_;
	_tmp80_ = vala_gsignal_module_get_value_type_name_from_type_reference (self, return_type);
	_tmp81_ = _tmp80_;
	_tmp82_ = callback_decl;
	_tmp83_ = vala_ccode_type_definition_new (_tmp81_, (ValaCCodeDeclarator*) _tmp82_);
	_tmp84_ = _tmp83_;
	vala_ccode_function_add_statement (_tmp79_, (ValaCCodeNode*) _tmp84_);
	_vala_ccode_node_unref0 (_tmp84_);
	_g_free0 (_tmp81_);
	_tmp85_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp86_ = _tmp85_;
	_tmp87_ = vala_gsignal_module_get_marshaller_function (self, params, return_type, "GMarshalFunc");
	_tmp88_ = _tmp87_;
	_tmp89_ = vala_ccode_variable_declarator_new ("callback", NULL, NULL);
	_tmp90_ = _tmp89_;
	vala_ccode_function_add_declaration (_tmp86_, _tmp88_, (ValaCCodeDeclarator*) _tmp90_, VALA_CCODE_MODIFIERS_REGISTER);
	_vala_ccode_node_unref0 (_tmp90_);
	_g_free0 (_tmp88_);
	_tmp91_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp92_ = _tmp91_;
	_tmp93_ = vala_ccode_identifier_new ("closure");
	_tmp94_ = _tmp93_;
	_tmp95_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp94_, "GCClosure *");
	_tmp96_ = _tmp95_;
	_tmp97_ = vala_ccode_variable_declarator_new ("cc", (ValaCCodeExpression*) _tmp96_, NULL);
	_tmp98_ = _tmp97_;
	vala_ccode_function_add_declaration (_tmp92_, "GCClosure *", (ValaCCodeDeclarator*) _tmp98_, VALA_CCODE_MODIFIERS_REGISTER);
	_vala_ccode_node_unref0 (_tmp98_);
	_vala_ccode_node_unref0 (_tmp96_);
	_vala_ccode_node_unref0 (_tmp94_);
	_tmp99_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp100_ = _tmp99_;
	_tmp101_ = vala_ccode_variable_declarator_new ("data1", NULL, NULL);
	_tmp102_ = _tmp101_;
	vala_ccode_function_add_declaration (_tmp100_, "gpointer", (ValaCCodeDeclarator*) _tmp102_, VALA_CCODE_MODIFIERS_REGISTER);
	_vala_ccode_node_unref0 (_tmp102_);
	_tmp103_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp104_ = _tmp103_;
	_tmp105_ = vala_ccode_variable_declarator_new ("data2", NULL, NULL);
	_tmp106_ = _tmp105_;
	vala_ccode_function_add_declaration (_tmp104_, "gpointer", (ValaCCodeDeclarator*) _tmp106_, VALA_CCODE_MODIFIERS_REGISTER);
	_vala_ccode_node_unref0 (_tmp106_);
	_tmp108_ = vala_data_type_get_data_type (return_type);
	_tmp109_ = _tmp108_;
	if (_tmp109_ != NULL) {
		_tmp107_ = TRUE;
	} else {
		_tmp107_ = vala_data_type_is_array (return_type);
	}
	if (_tmp107_) {
		ValaCCodeFunction* _tmp110_;
		ValaCCodeFunction* _tmp111_;
		gchar* _tmp112_;
		gchar* _tmp113_;
		ValaCCodeVariableDeclarator* _tmp114_;
		ValaCCodeVariableDeclarator* _tmp115_;
		ValaCCodeIdentifier* _tmp116_;
		ValaCCodeIdentifier* _tmp117_;
		ValaCCodeFunctionCall* _tmp118_;
		ValaCCodeFunctionCall* _tmp119_;
		ValaCCodeIdentifier* _tmp120_;
		ValaCCodeIdentifier* _tmp121_;
		ValaCCodeConstant* _tmp122_;
		ValaCCodeConstant* _tmp123_;
		ValaCCodeBinaryExpression* _tmp124_;
		ValaCCodeBinaryExpression* _tmp125_;
		ValaCCodeFunction* _tmp126_;
		ValaCCodeFunction* _tmp127_;
		ValaCCodeFunctionCall* _tmp128_;
		_tmp110_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp111_ = _tmp110_;
		_tmp112_ = vala_gsignal_module_get_value_type_name_from_type_reference (self, return_type);
		_tmp113_ = _tmp112_;
		_tmp114_ = vala_ccode_variable_declarator_new ("v_return", NULL, NULL);
		_tmp115_ = _tmp114_;
		vala_ccode_function_add_declaration (_tmp111_, _tmp113_, (ValaCCodeDeclarator*) _tmp115_, 0);
		_vala_ccode_node_unref0 (_tmp115_);
		_g_free0 (_tmp113_);
		_tmp116_ = vala_ccode_identifier_new ("g_return_if_fail");
		_tmp117_ = _tmp116_;
		_tmp118_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp117_);
		_vala_ccode_node_unref0 (fc);
		fc = _tmp118_;
		_vala_ccode_node_unref0 (_tmp117_);
		_tmp119_ = fc;
		_tmp120_ = vala_ccode_identifier_new ("return_value");
		_tmp121_ = _tmp120_;
		_tmp122_ = vala_ccode_constant_new ("NULL");
		_tmp123_ = _tmp122_;
		_tmp124_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, (ValaCCodeExpression*) _tmp121_, (ValaCCodeExpression*) _tmp123_);
		_tmp125_ = _tmp124_;
		vala_ccode_function_call_add_argument (_tmp119_, (ValaCCodeExpression*) _tmp125_);
		_vala_ccode_node_unref0 (_tmp125_);
		_vala_ccode_node_unref0 (_tmp123_);
		_vala_ccode_node_unref0 (_tmp121_);
		_tmp126_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp127_ = _tmp126_;
		_tmp128_ = fc;
		vala_ccode_function_add_expression (_tmp127_, (ValaCCodeExpression*) _tmp128_);
	}
	_tmp129_ = vala_ccode_identifier_new ("g_return_if_fail");
	_tmp130_ = _tmp129_;
	_tmp131_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp130_);
	_vala_ccode_node_unref0 (fc);
	fc = _tmp131_;
	_vala_ccode_node_unref0 (_tmp130_);
	_tmp132_ = fc;
	_tmp133_ = vala_ccode_identifier_new ("n_param_values");
	_tmp134_ = _tmp133_;
	_tmp135_ = n_params;
	_tmp136_ = g_strdup_printf ("%i", _tmp135_);
	_tmp137_ = _tmp136_;
	_tmp138_ = vala_ccode_constant_new (_tmp137_);
	_tmp139_ = _tmp138_;
	_tmp140_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, (ValaCCodeExpression*) _tmp134_, (ValaCCodeExpression*) _tmp139_);
	_tmp141_ = _tmp140_;
	vala_ccode_function_call_add_argument (_tmp132_, (ValaCCodeExpression*) _tmp141_);
	_vala_ccode_node_unref0 (_tmp141_);
	_vala_ccode_node_unref0 (_tmp139_);
	_g_free0 (_tmp137_);
	_vala_ccode_node_unref0 (_tmp134_);
	_tmp142_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp143_ = _tmp142_;
	_tmp144_ = fc;
	vala_ccode_function_add_expression (_tmp143_, (ValaCCodeExpression*) _tmp144_);
	_tmp145_ = vala_ccode_identifier_new ("closure");
	_tmp146_ = _tmp145_;
	_tmp147_ = vala_ccode_member_access_new ((ValaCCodeExpression*) _tmp146_, "data", TRUE);
	_tmp148_ = _tmp147_;
	_vala_ccode_node_unref0 (_tmp146_);
	data = _tmp148_;
	_tmp149_ = vala_ccode_identifier_new ("param_values");
	_tmp150_ = _tmp149_;
	_tmp151_ = vala_ccode_member_access_new ((ValaCCodeExpression*) _tmp150_, "data[0]", TRUE);
	_tmp152_ = _tmp151_;
	_tmp153_ = vala_ccode_member_access_new ((ValaCCodeExpression*) _tmp152_, "v_pointer", FALSE);
	_tmp154_ = _tmp153_;
	_vala_ccode_node_unref0 (_tmp152_);
	_vala_ccode_node_unref0 (_tmp150_);
	param = _tmp154_;
	_tmp155_ = vala_ccode_constant_new ("G_CCLOSURE_SWAP_DATA");
	_tmp156_ = _tmp155_;
	_tmp157_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp156_);
	_tmp158_ = _tmp157_;
	_vala_ccode_node_unref0 (_tmp156_);
	cond = _tmp158_;
	_tmp159_ = cond;
	_tmp160_ = vala_ccode_identifier_new ("closure");
	_tmp161_ = _tmp160_;
	vala_ccode_function_call_add_argument (_tmp159_, (ValaCCodeExpression*) _tmp161_);
	_vala_ccode_node_unref0 (_tmp161_);
	_tmp162_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp163_ = _tmp162_;
	_tmp164_ = cond;
	vala_ccode_function_open_if (_tmp163_, (ValaCCodeExpression*) _tmp164_);
	_tmp165_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp166_ = _tmp165_;
	_tmp167_ = vala_ccode_identifier_new ("data1");
	_tmp168_ = _tmp167_;
	_tmp169_ = data;
	vala_ccode_function_add_assignment (_tmp166_, (ValaCCodeExpression*) _tmp168_, (ValaCCodeExpression*) _tmp169_);
	_vala_ccode_node_unref0 (_tmp168_);
	_tmp170_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp171_ = _tmp170_;
	_tmp172_ = vala_ccode_identifier_new ("data2");
	_tmp173_ = _tmp172_;
	_tmp174_ = param;
	vala_ccode_function_add_assignment (_tmp171_, (ValaCCodeExpression*) _tmp173_, (ValaCCodeExpression*) _tmp174_);
	_vala_ccode_node_unref0 (_tmp173_);
	_tmp175_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp176_ = _tmp175_;
	vala_ccode_function_add_else (_tmp176_);
	_tmp177_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp178_ = _tmp177_;
	_tmp179_ = vala_ccode_identifier_new ("data1");
	_tmp180_ = _tmp179_;
	_tmp181_ = param;
	vala_ccode_function_add_assignment (_tmp178_, (ValaCCodeExpression*) _tmp180_, (ValaCCodeExpression*) _tmp181_);
	_vala_ccode_node_unref0 (_tmp180_);
	_tmp182_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp183_ = _tmp182_;
	_tmp184_ = vala_ccode_identifier_new ("data2");
	_tmp185_ = _tmp184_;
	_tmp186_ = data;
	vala_ccode_function_add_assignment (_tmp183_, (ValaCCodeExpression*) _tmp185_, (ValaCCodeExpression*) _tmp186_);
	_vala_ccode_node_unref0 (_tmp185_);
	_tmp187_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp188_ = _tmp187_;
	vala_ccode_function_close (_tmp188_);
	_tmp189_ = vala_ccode_identifier_new ("marshal_data");
	_tmp190_ = _tmp189_;
	_tmp191_ = vala_ccode_identifier_new ("marshal_data");
	_tmp192_ = _tmp191_;
	_tmp193_ = vala_ccode_identifier_new ("cc");
	_tmp194_ = _tmp193_;
	_tmp195_ = vala_ccode_member_access_new ((ValaCCodeExpression*) _tmp194_, "callback", TRUE);
	_tmp196_ = _tmp195_;
	_tmp197_ = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) _tmp190_, (ValaCCodeExpression*) _tmp192_, (ValaCCodeExpression*) _tmp196_);
	_tmp198_ = _tmp197_;
	_tmp199_ = vala_gsignal_module_get_marshaller_function (self, params, return_type, "GMarshalFunc");
	_tmp200_ = _tmp199_;
	_tmp201_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp198_, _tmp200_);
	_tmp202_ = _tmp201_;
	_g_free0 (_tmp200_);
	_vala_ccode_node_unref0 (_tmp198_);
	_vala_ccode_node_unref0 (_tmp196_);
	_vala_ccode_node_unref0 (_tmp194_);
	_vala_ccode_node_unref0 (_tmp192_);
	_vala_ccode_node_unref0 (_tmp190_);
	c_assign_rhs = _tmp202_;
	_tmp203_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp204_ = _tmp203_;
	_tmp205_ = vala_ccode_identifier_new ("callback");
	_tmp206_ = _tmp205_;
	_tmp207_ = c_assign_rhs;
	vala_ccode_function_add_assignment (_tmp204_, (ValaCCodeExpression*) _tmp206_, (ValaCCodeExpression*) _tmp207_);
	_vala_ccode_node_unref0 (_tmp206_);
	_tmp208_ = vala_ccode_identifier_new ("callback");
	_tmp209_ = _tmp208_;
	_tmp210_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp209_);
	_vala_ccode_node_unref0 (fc);
	fc = _tmp210_;
	_vala_ccode_node_unref0 (_tmp209_);
	_tmp211_ = fc;
	_tmp212_ = vala_ccode_identifier_new ("data1");
	_tmp213_ = _tmp212_;
	vala_ccode_function_call_add_argument (_tmp211_, (ValaCCodeExpression*) _tmp213_);
	_vala_ccode_node_unref0 (_tmp213_);
	i = 1;
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp214_;
		gint _p_size = 0;
		ValaList* _tmp215_;
		gint _tmp216_;
		gint _tmp217_;
		gint _p_index = 0;
		_tmp214_ = _vala_iterable_ref0 (params);
		_p_list = _tmp214_;
		_tmp215_ = _p_list;
		_tmp216_ = vala_collection_get_size ((ValaCollection*) _tmp215_);
		_tmp217_ = _tmp216_;
		_p_size = _tmp217_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp218_;
			gint _tmp219_;
			gint _tmp220_;
			ValaParameter* p = NULL;
			ValaList* _tmp221_;
			gint _tmp222_;
			gpointer _tmp223_;
			gchar* get_value_function = NULL;
			gboolean is_array = FALSE;
			ValaParameter* _tmp224_;
			ValaDataType* _tmp225_;
			ValaDataType* _tmp226_;
			ValaParameter* _tmp227_;
			ValaParameterDirection _tmp228_;
			ValaParameterDirection _tmp229_;
			ValaCCodeFunctionCall* inner_fc = NULL;
			const gchar* _tmp274_;
			ValaCCodeIdentifier* _tmp275_;
			ValaCCodeIdentifier* _tmp276_;
			ValaCCodeFunctionCall* _tmp277_;
			ValaCCodeFunctionCall* _tmp278_;
			ValaCCodeFunctionCall* _tmp279_;
			ValaCCodeIdentifier* _tmp280_;
			ValaCCodeIdentifier* _tmp281_;
			gint _tmp282_;
			gchar* _tmp283_;
			gchar* _tmp284_;
			ValaCCodeIdentifier* _tmp285_;
			ValaCCodeIdentifier* _tmp286_;
			ValaCCodeBinaryExpression* _tmp287_;
			ValaCCodeBinaryExpression* _tmp288_;
			ValaCCodeFunctionCall* _tmp289_;
			ValaCCodeFunctionCall* _tmp290_;
			gint _tmp291_;
			gboolean _tmp292_;
			_tmp218_ = _p_index;
			_p_index = _tmp218_ + 1;
			_tmp219_ = _p_index;
			_tmp220_ = _p_size;
			if (!(_tmp219_ < _tmp220_)) {
				break;
			}
			_tmp221_ = _p_list;
			_tmp222_ = _p_index;
			_tmp223_ = vala_list_get (_tmp221_, _tmp222_);
			p = (ValaParameter*) _tmp223_;
			_tmp224_ = p;
			_tmp225_ = vala_variable_get_variable_type ((ValaVariable*) _tmp224_);
			_tmp226_ = _tmp225_;
			is_array = vala_data_type_is_array (_tmp226_);
			_tmp227_ = p;
			_tmp228_ = vala_parameter_get_direction (_tmp227_);
			_tmp229_ = _tmp228_;
			if (_tmp229_ != VALA_PARAMETER_DIRECTION_IN) {
				gchar* _tmp230_;
				_tmp230_ = g_strdup ("g_value_get_pointer");
				_g_free0 (get_value_function);
				get_value_function = _tmp230_;
			} else {
				gboolean _tmp231_;
				_tmp231_ = is_array;
				if (_tmp231_) {
					ValaParameter* _tmp232_;
					ValaDataType* _tmp233_;
					ValaDataType* _tmp234_;
					ValaDataType* _tmp235_;
					ValaDataType* _tmp236_;
					ValaTypeSymbol* _tmp237_;
					ValaTypeSymbol* _tmp238_;
					ValaDataType* _tmp239_;
					ValaTypeSymbol* _tmp240_;
					ValaTypeSymbol* _tmp241_;
					_tmp232_ = p;
					_tmp233_ = vala_variable_get_variable_type ((ValaVariable*) _tmp232_);
					_tmp234_ = _tmp233_;
					_tmp235_ = vala_array_type_get_element_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp234_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
					_tmp236_ = _tmp235_;
					_tmp237_ = vala_data_type_get_data_type (_tmp236_);
					_tmp238_ = _tmp237_;
					_tmp239_ = ((ValaCCodeBaseModule*) self)->string_type;
					_tmp240_ = vala_data_type_get_data_type (_tmp239_);
					_tmp241_ = _tmp240_;
					if (_tmp238_ == _tmp241_) {
						gchar* _tmp242_;
						_tmp242_ = g_strdup ("g_value_get_boxed");
						_g_free0 (get_value_function);
						get_value_function = _tmp242_;
					} else {
						gchar* _tmp243_;
						_tmp243_ = g_strdup ("g_value_get_pointer");
						_g_free0 (get_value_function);
						get_value_function = _tmp243_;
					}
				} else {
					gboolean _tmp244_ = FALSE;
					ValaParameter* _tmp245_;
					ValaDataType* _tmp246_;
					ValaDataType* _tmp247_;
					_tmp245_ = p;
					_tmp246_ = vala_variable_get_variable_type ((ValaVariable*) _tmp245_);
					_tmp247_ = _tmp246_;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp247_, VALA_TYPE_POINTER_TYPE)) {
						_tmp244_ = TRUE;
					} else {
						ValaParameter* _tmp248_;
						ValaDataType* _tmp249_;
						ValaDataType* _tmp250_;
						ValaTypeParameter* _tmp251_;
						ValaTypeParameter* _tmp252_;
						_tmp248_ = p;
						_tmp249_ = vala_variable_get_variable_type ((ValaVariable*) _tmp248_);
						_tmp250_ = _tmp249_;
						_tmp251_ = vala_data_type_get_type_parameter (_tmp250_);
						_tmp252_ = _tmp251_;
						_tmp244_ = _tmp252_ != NULL;
					}
					if (_tmp244_) {
						gchar* _tmp253_;
						_tmp253_ = g_strdup ("g_value_get_pointer");
						_g_free0 (get_value_function);
						get_value_function = _tmp253_;
					} else {
						ValaParameter* _tmp254_;
						ValaDataType* _tmp255_;
						ValaDataType* _tmp256_;
						_tmp254_ = p;
						_tmp255_ = vala_variable_get_variable_type ((ValaVariable*) _tmp254_);
						_tmp256_ = _tmp255_;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp256_, VALA_TYPE_ERROR_TYPE)) {
							gchar* _tmp257_;
							_tmp257_ = g_strdup ("g_value_get_pointer");
							_g_free0 (get_value_function);
							get_value_function = _tmp257_;
						} else {
							gboolean _tmp258_ = FALSE;
							ValaParameter* _tmp259_;
							ValaDataType* _tmp260_;
							ValaDataType* _tmp261_;
							_tmp259_ = p;
							_tmp260_ = vala_variable_get_variable_type ((ValaVariable*) _tmp259_);
							_tmp261_ = _tmp260_;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp261_, VALA_TYPE_VALUE_TYPE)) {
								ValaParameter* _tmp262_;
								ValaDataType* _tmp263_;
								ValaDataType* _tmp264_;
								gboolean _tmp265_;
								gboolean _tmp266_;
								_tmp262_ = p;
								_tmp263_ = vala_variable_get_variable_type ((ValaVariable*) _tmp262_);
								_tmp264_ = _tmp263_;
								_tmp265_ = vala_data_type_get_nullable (_tmp264_);
								_tmp266_ = _tmp265_;
								_tmp258_ = _tmp266_;
							} else {
								_tmp258_ = FALSE;
							}
							if (_tmp258_) {
								gchar* _tmp267_;
								_tmp267_ = g_strdup ("g_value_get_pointer");
								_g_free0 (get_value_function);
								get_value_function = _tmp267_;
							} else {
								ValaParameter* _tmp268_;
								ValaDataType* _tmp269_;
								ValaDataType* _tmp270_;
								ValaTypeSymbol* _tmp271_;
								ValaTypeSymbol* _tmp272_;
								gchar* _tmp273_;
								_tmp268_ = p;
								_tmp269_ = vala_variable_get_variable_type ((ValaVariable*) _tmp268_);
								_tmp270_ = _tmp269_;
								_tmp271_ = vala_data_type_get_data_type (_tmp270_);
								_tmp272_ = _tmp271_;
								_tmp273_ = vala_get_ccode_get_value_function ((ValaCodeNode*) _tmp272_);
								_g_free0 (get_value_function);
								get_value_function = _tmp273_;
							}
						}
					}
				}
			}
			_tmp274_ = get_value_function;
			_tmp275_ = vala_ccode_identifier_new (_tmp274_);
			_tmp276_ = _tmp275_;
			_tmp277_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp276_);
			_tmp278_ = _tmp277_;
			_vala_ccode_node_unref0 (_tmp276_);
			inner_fc = _tmp278_;
			_tmp279_ = inner_fc;
			_tmp280_ = vala_ccode_identifier_new ("param_values");
			_tmp281_ = _tmp280_;
			_tmp282_ = i;
			_tmp283_ = g_strdup_printf ("%i", _tmp282_);
			_tmp284_ = _tmp283_;
			_tmp285_ = vala_ccode_identifier_new (_tmp284_);
			_tmp286_ = _tmp285_;
			_tmp287_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) _tmp281_, (ValaCCodeExpression*) _tmp286_);
			_tmp288_ = _tmp287_;
			vala_ccode_function_call_add_argument (_tmp279_, (ValaCCodeExpression*) _tmp288_);
			_vala_ccode_node_unref0 (_tmp288_);
			_vala_ccode_node_unref0 (_tmp286_);
			_g_free0 (_tmp284_);
			_vala_ccode_node_unref0 (_tmp281_);
			_tmp289_ = fc;
			_tmp290_ = inner_fc;
			vala_ccode_function_call_add_argument (_tmp289_, (ValaCCodeExpression*) _tmp290_);
			_tmp291_ = i;
			i = _tmp291_ + 1;
			_tmp292_ = is_array;
			if (_tmp292_) {
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp293_ = FALSE;
						_tmp293_ = TRUE;
						while (TRUE) {
							gint _tmp295_;
							ValaParameter* _tmp296_;
							ValaDataType* _tmp297_;
							ValaDataType* _tmp298_;
							gint _tmp299_;
							gint _tmp300_;
							ValaCCodeIdentifier* _tmp301_;
							ValaCCodeIdentifier* _tmp302_;
							ValaCCodeFunctionCall* _tmp303_;
							ValaCCodeFunctionCall* _tmp304_;
							ValaCCodeIdentifier* _tmp305_;
							ValaCCodeIdentifier* _tmp306_;
							gint _tmp307_;
							gchar* _tmp308_;
							gchar* _tmp309_;
							ValaCCodeIdentifier* _tmp310_;
							ValaCCodeIdentifier* _tmp311_;
							ValaCCodeBinaryExpression* _tmp312_;
							ValaCCodeBinaryExpression* _tmp313_;
							ValaCCodeFunctionCall* _tmp314_;
							ValaCCodeFunctionCall* _tmp315_;
							gint _tmp316_;
							if (!_tmp293_) {
								gint _tmp294_;
								_tmp294_ = j;
								j = _tmp294_ + 1;
							}
							_tmp293_ = FALSE;
							_tmp295_ = j;
							_tmp296_ = p;
							_tmp297_ = vala_variable_get_variable_type ((ValaVariable*) _tmp296_);
							_tmp298_ = _tmp297_;
							_tmp299_ = vala_array_type_get_rank (G_TYPE_CHECK_INSTANCE_CAST (_tmp298_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
							_tmp300_ = _tmp299_;
							if (!(_tmp295_ < _tmp300_)) {
								break;
							}
							_tmp301_ = vala_ccode_identifier_new ("g_value_get_int");
							_tmp302_ = _tmp301_;
							_tmp303_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp302_);
							_vala_ccode_node_unref0 (inner_fc);
							inner_fc = _tmp303_;
							_vala_ccode_node_unref0 (_tmp302_);
							_tmp304_ = inner_fc;
							_tmp305_ = vala_ccode_identifier_new ("param_values");
							_tmp306_ = _tmp305_;
							_tmp307_ = i;
							_tmp308_ = g_strdup_printf ("%i", _tmp307_);
							_tmp309_ = _tmp308_;
							_tmp310_ = vala_ccode_identifier_new (_tmp309_);
							_tmp311_ = _tmp310_;
							_tmp312_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) _tmp306_, (ValaCCodeExpression*) _tmp311_);
							_tmp313_ = _tmp312_;
							vala_ccode_function_call_add_argument (_tmp304_, (ValaCCodeExpression*) _tmp313_);
							_vala_ccode_node_unref0 (_tmp313_);
							_vala_ccode_node_unref0 (_tmp311_);
							_g_free0 (_tmp309_);
							_vala_ccode_node_unref0 (_tmp306_);
							_tmp314_ = fc;
							_tmp315_ = inner_fc;
							vala_ccode_function_call_add_argument (_tmp314_, (ValaCCodeExpression*) _tmp315_);
							_tmp316_ = i;
							i = _tmp316_ + 1;
						}
					}
				}
			}
			_vala_ccode_node_unref0 (inner_fc);
			_g_free0 (get_value_function);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	_tmp317_ = fc;
	_tmp318_ = vala_ccode_identifier_new ("data2");
	_tmp319_ = _tmp318_;
	vala_ccode_function_call_add_argument (_tmp317_, (ValaCCodeExpression*) _tmp319_);
	_vala_ccode_node_unref0 (_tmp319_);
	_tmp321_ = vala_data_type_get_data_type (return_type);
	_tmp322_ = _tmp321_;
	if (_tmp322_ != NULL) {
		_tmp320_ = TRUE;
	} else {
		_tmp320_ = vala_data_type_is_array (return_type);
	}
	if (_tmp320_) {
		ValaCCodeFunction* _tmp323_;
		ValaCCodeFunction* _tmp324_;
		ValaCCodeIdentifier* _tmp325_;
		ValaCCodeIdentifier* _tmp326_;
		ValaCCodeFunctionCall* _tmp327_;
		ValaCCodeFunctionCall* set_fc = NULL;
		ValaCCodeFunctionCall* _tmp378_;
		ValaCCodeIdentifier* _tmp379_;
		ValaCCodeIdentifier* _tmp380_;
		ValaCCodeFunctionCall* _tmp381_;
		ValaCCodeIdentifier* _tmp382_;
		ValaCCodeIdentifier* _tmp383_;
		ValaCCodeFunction* _tmp384_;
		ValaCCodeFunction* _tmp385_;
		ValaCCodeFunctionCall* _tmp386_;
		_tmp323_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp324_ = _tmp323_;
		_tmp325_ = vala_ccode_identifier_new ("v_return");
		_tmp326_ = _tmp325_;
		_tmp327_ = fc;
		vala_ccode_function_add_assignment (_tmp324_, (ValaCCodeExpression*) _tmp326_, (ValaCCodeExpression*) _tmp327_);
		_vala_ccode_node_unref0 (_tmp326_);
		if (vala_data_type_is_array (return_type)) {
			ValaDataType* _tmp328_;
			ValaDataType* _tmp329_;
			ValaTypeSymbol* _tmp330_;
			ValaTypeSymbol* _tmp331_;
			ValaDataType* _tmp332_;
			ValaTypeSymbol* _tmp333_;
			ValaTypeSymbol* _tmp334_;
			_tmp328_ = vala_array_type_get_element_type (G_TYPE_CHECK_INSTANCE_CAST (return_type, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
			_tmp329_ = _tmp328_;
			_tmp330_ = vala_data_type_get_data_type (_tmp329_);
			_tmp331_ = _tmp330_;
			_tmp332_ = ((ValaCCodeBaseModule*) self)->string_type;
			_tmp333_ = vala_data_type_get_data_type (_tmp332_);
			_tmp334_ = _tmp333_;
			if (_tmp331_ == _tmp334_) {
				ValaCCodeIdentifier* _tmp335_;
				ValaCCodeIdentifier* _tmp336_;
				ValaCCodeFunctionCall* _tmp337_;
				_tmp335_ = vala_ccode_identifier_new ("g_value_take_boxed");
				_tmp336_ = _tmp335_;
				_tmp337_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp336_);
				_vala_ccode_node_unref0 (set_fc);
				set_fc = _tmp337_;
				_vala_ccode_node_unref0 (_tmp336_);
			} else {
				ValaCCodeIdentifier* _tmp338_;
				ValaCCodeIdentifier* _tmp339_;
				ValaCCodeFunctionCall* _tmp340_;
				_tmp338_ = vala_ccode_identifier_new ("g_value_set_pointer");
				_tmp339_ = _tmp338_;
				_tmp340_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp339_);
				_vala_ccode_node_unref0 (set_fc);
				set_fc = _tmp340_;
				_vala_ccode_node_unref0 (_tmp339_);
			}
		} else {
			ValaTypeParameter* _tmp341_;
			ValaTypeParameter* _tmp342_;
			_tmp341_ = vala_data_type_get_type_parameter (return_type);
			_tmp342_ = _tmp341_;
			if (_tmp342_ != NULL) {
				ValaCCodeIdentifier* _tmp343_;
				ValaCCodeIdentifier* _tmp344_;
				ValaCCodeFunctionCall* _tmp345_;
				_tmp343_ = vala_ccode_identifier_new ("g_value_set_pointer");
				_tmp344_ = _tmp343_;
				_tmp345_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp344_);
				_vala_ccode_node_unref0 (set_fc);
				set_fc = _tmp345_;
				_vala_ccode_node_unref0 (_tmp344_);
			} else {
				if (G_TYPE_CHECK_INSTANCE_TYPE (return_type, VALA_TYPE_ERROR_TYPE)) {
					ValaCCodeIdentifier* _tmp346_;
					ValaCCodeIdentifier* _tmp347_;
					ValaCCodeFunctionCall* _tmp348_;
					_tmp346_ = vala_ccode_identifier_new ("g_value_set_pointer");
					_tmp347_ = _tmp346_;
					_tmp348_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp347_);
					_vala_ccode_node_unref0 (set_fc);
					set_fc = _tmp348_;
					_vala_ccode_node_unref0 (_tmp347_);
				} else {
					ValaTypeSymbol* _tmp349_;
					ValaTypeSymbol* _tmp350_;
					ValaDataType* _tmp351_;
					ValaTypeSymbol* _tmp352_;
					ValaTypeSymbol* _tmp353_;
					_tmp349_ = vala_data_type_get_data_type (return_type);
					_tmp350_ = _tmp349_;
					_tmp351_ = ((ValaCCodeBaseModule*) self)->string_type;
					_tmp352_ = vala_data_type_get_data_type (_tmp351_);
					_tmp353_ = _tmp352_;
					if (_tmp350_ == _tmp353_) {
						ValaCCodeIdentifier* _tmp354_;
						ValaCCodeIdentifier* _tmp355_;
						ValaCCodeFunctionCall* _tmp356_;
						_tmp354_ = vala_ccode_identifier_new ("g_value_take_string");
						_tmp355_ = _tmp354_;
						_tmp356_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp355_);
						_vala_ccode_node_unref0 (set_fc);
						set_fc = _tmp356_;
						_vala_ccode_node_unref0 (_tmp355_);
					} else {
						gboolean _tmp357_ = FALSE;
						ValaTypeSymbol* _tmp358_;
						ValaTypeSymbol* _tmp359_;
						_tmp358_ = vala_data_type_get_data_type (return_type);
						_tmp359_ = _tmp358_;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp359_, VALA_TYPE_CLASS)) {
							_tmp357_ = TRUE;
						} else {
							ValaTypeSymbol* _tmp360_;
							ValaTypeSymbol* _tmp361_;
							_tmp360_ = vala_data_type_get_data_type (return_type);
							_tmp361_ = _tmp360_;
							_tmp357_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp361_, VALA_TYPE_INTERFACE);
						}
						if (_tmp357_) {
							ValaCCodeIdentifier* _tmp362_;
							ValaCCodeIdentifier* _tmp363_;
							ValaCCodeFunctionCall* _tmp364_;
							_tmp362_ = vala_ccode_identifier_new ("g_value_take_object");
							_tmp363_ = _tmp362_;
							_tmp364_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp363_);
							_vala_ccode_node_unref0 (set_fc);
							set_fc = _tmp364_;
							_vala_ccode_node_unref0 (_tmp363_);
						} else {
							gboolean _tmp365_ = FALSE;
							if (G_TYPE_CHECK_INSTANCE_TYPE (return_type, VALA_TYPE_VALUE_TYPE)) {
								gboolean _tmp366_;
								gboolean _tmp367_;
								_tmp366_ = vala_data_type_get_nullable (return_type);
								_tmp367_ = _tmp366_;
								_tmp365_ = _tmp367_;
							} else {
								_tmp365_ = FALSE;
							}
							if (_tmp365_) {
								ValaCCodeIdentifier* _tmp368_;
								ValaCCodeIdentifier* _tmp369_;
								ValaCCodeFunctionCall* _tmp370_;
								_tmp368_ = vala_ccode_identifier_new ("g_value_set_pointer");
								_tmp369_ = _tmp368_;
								_tmp370_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp369_);
								_vala_ccode_node_unref0 (set_fc);
								set_fc = _tmp370_;
								_vala_ccode_node_unref0 (_tmp369_);
							} else {
								ValaTypeSymbol* _tmp371_;
								ValaTypeSymbol* _tmp372_;
								gchar* _tmp373_;
								gchar* _tmp374_;
								ValaCCodeIdentifier* _tmp375_;
								ValaCCodeIdentifier* _tmp376_;
								ValaCCodeFunctionCall* _tmp377_;
								_tmp371_ = vala_data_type_get_data_type (return_type);
								_tmp372_ = _tmp371_;
								_tmp373_ = vala_get_ccode_set_value_function ((ValaCodeNode*) _tmp372_);
								_tmp374_ = _tmp373_;
								_tmp375_ = vala_ccode_identifier_new (_tmp374_);
								_tmp376_ = _tmp375_;
								_tmp377_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp376_);
								_vala_ccode_node_unref0 (set_fc);
								set_fc = _tmp377_;
								_vala_ccode_node_unref0 (_tmp376_);
								_g_free0 (_tmp374_);
							}
						}
					}
				}
			}
		}
		_tmp378_ = set_fc;
		_tmp379_ = vala_ccode_identifier_new ("return_value");
		_tmp380_ = _tmp379_;
		vala_ccode_function_call_add_argument (_tmp378_, (ValaCCodeExpression*) _tmp380_);
		_vala_ccode_node_unref0 (_tmp380_);
		_tmp381_ = set_fc;
		_tmp382_ = vala_ccode_identifier_new ("v_return");
		_tmp383_ = _tmp382_;
		vala_ccode_function_call_add_argument (_tmp381_, (ValaCCodeExpression*) _tmp383_);
		_vala_ccode_node_unref0 (_tmp383_);
		_tmp384_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp385_ = _tmp384_;
		_tmp386_ = set_fc;
		vala_ccode_function_add_expression (_tmp385_, (ValaCCodeExpression*) _tmp386_);
		_vala_ccode_node_unref0 (set_fc);
	} else {
		ValaCCodeFunction* _tmp387_;
		ValaCCodeFunction* _tmp388_;
		ValaCCodeFunctionCall* _tmp389_;
		_tmp387_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp388_ = _tmp387_;
		_tmp389_ = fc;
		vala_ccode_function_add_expression (_tmp388_, (ValaCCodeExpression*) _tmp389_);
	}
	vala_ccode_base_module_pop_function ((ValaCCodeBaseModule*) self);
	_tmp390_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp391_ = signal_marshaller;
	vala_ccode_file_add_function_declaration (_tmp390_, _tmp391_);
	_tmp392_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp393_ = signal_marshaller;
	vala_ccode_file_add_function (_tmp392_, _tmp393_);
	_tmp394_ = ((ValaCCodeBaseModule*) self)->user_marshal_set;
	_tmp395_ = signature;
	vala_collection_add ((ValaCollection*) _tmp394_, _tmp395_);
	_vala_ccode_node_unref0 (c_assign_rhs);
	_vala_ccode_node_unref0 (cond);
	_vala_ccode_node_unref0 (param);
	_vala_ccode_node_unref0 (data);
	_vala_ccode_node_unref0 (fc);
	_vala_ccode_node_unref0 (callback_decl);
	_vala_ccode_node_unref0 (signal_marshaller);
	_g_free0 (signature);
}


static void
_vala_array_add1 (gchar** * array, 
                  int* length, 
                  int* size, 
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void
_vala_array_add2 (gchar** * array, 
                  int* length, 
                  int* size, 
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void
_vala_array_add3 (gchar** * array, 
                  int* length, 
                  int* size, 
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void
_vala_array_add4 (gchar** * array, 
                  int* length, 
                  int* size, 
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void
_vala_array_add5 (gchar** * array, 
                  int* length, 
                  int* size, 
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void
_vala_array_add6 (gchar** * array, 
                  int* length, 
                  int* size, 
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void
_vala_array_add7 (gchar** * array, 
                  int* length, 
                  int* size, 
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void
_vala_array_add8 (gchar** * array, 
                  int* length, 
                  int* size, 
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gchar*
_vala_g_strjoinv (const gchar* separator, 
                  gchar** str_array, 
                  int str_array_length1)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = str_array_length1 > 0;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp2_ = FALSE;
		if (str_array_length1 == -1) {
			const gchar* _tmp3_;
			_tmp3_ = str_array[0];
			_tmp2_ = _tmp3_ != NULL;
		} else {
			_tmp2_ = FALSE;
		}
		_tmp0_ = _tmp2_;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp20_;
		gint _tmp22_;
		gint _tmp23_;
		gsize _tmp24_;
		gint _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		const gchar* res = NULL;
		gsize _tmp28_;
		void* _tmp29_;
		void* ptr = NULL;
		const gchar* _tmp30_;
		const gchar* _tmp31_;
		void* _tmp32_;
		const gchar* _tmp45_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp12_ = 0;
				gint _tmp13_;
				const gchar* _tmp14_;
				gsize _tmp19_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					gint _tmp8_;
					_tmp8_ = i;
					_tmp7_ = _tmp8_ < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp9_ = FALSE;
					if (str_array_length1 == -1) {
						gint _tmp10_;
						const gchar* _tmp11_;
						_tmp10_ = i;
						_tmp11_ = str_array[_tmp10_];
						_tmp9_ = _tmp11_ != NULL;
					} else {
						_tmp9_ = FALSE;
					}
					_tmp6_ = _tmp9_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp13_ = i;
				_tmp14_ = str_array[_tmp13_];
				if (_tmp14_ != NULL) {
					gint _tmp15_;
					const gchar* _tmp16_;
					gint _tmp17_;
					gint _tmp18_;
					_tmp15_ = i;
					_tmp16_ = str_array[_tmp15_];
					_tmp17_ = strlen ((const gchar*) _tmp16_);
					_tmp18_ = _tmp17_;
					_tmp12_ = _tmp18_;
				} else {
					_tmp12_ = 0;
				}
				_tmp19_ = len;
				len = _tmp19_ + _tmp12_;
			}
		}
		_tmp20_ = i;
		if (_tmp20_ == 0) {
			gchar* _tmp21_;
			_tmp21_ = g_strdup ("");
			result = _tmp21_;
			return result;
		}
		_tmp22_ = i;
		str_array_length1 = _tmp22_;
		_tmp23_ = str_array_length1;
		_tmp24_ = len;
		_tmp25_ = strlen ((const gchar*) separator);
		_tmp26_ = _tmp25_;
		_tmp27_ = i;
		len = _tmp24_ + (_tmp26_ * (_tmp27_ - 1));
		_tmp28_ = len;
		_tmp29_ = g_malloc (_tmp28_);
		res = _tmp29_;
		_tmp30_ = res;
		_tmp31_ = str_array[0];
		_tmp32_ = g_stpcpy ((void*) _tmp30_, (const gchar*) _tmp31_);
		ptr = _tmp32_;
		{
			gboolean _tmp33_ = FALSE;
			i = 1;
			_tmp33_ = TRUE;
			while (TRUE) {
				gint _tmp35_;
				void* _tmp36_;
				void* _tmp37_;
				const gchar* _tmp38_ = NULL;
				gint _tmp39_;
				const gchar* _tmp40_;
				void* _tmp43_;
				void* _tmp44_;
				if (!_tmp33_) {
					gint _tmp34_;
					_tmp34_ = i;
					i = _tmp34_ + 1;
				}
				_tmp33_ = FALSE;
				_tmp35_ = i;
				if (!(_tmp35_ < str_array_length1)) {
					break;
				}
				_tmp36_ = ptr;
				_tmp37_ = g_stpcpy (_tmp36_, (const gchar*) separator);
				ptr = _tmp37_;
				_tmp39_ = i;
				_tmp40_ = str_array[_tmp39_];
				if (_tmp40_ != NULL) {
					gint _tmp41_;
					const gchar* _tmp42_;
					_tmp41_ = i;
					_tmp42_ = str_array[_tmp41_];
					_tmp38_ = (const gchar*) _tmp42_;
				} else {
					_tmp38_ = "";
				}
				_tmp43_ = ptr;
				_tmp44_ = g_stpcpy (_tmp43_, _tmp38_);
				ptr = _tmp44_;
			}
		}
		_tmp45_ = res;
		res = NULL;
		result = (gchar*) _tmp45_;
		return result;
	} else {
		gchar* _tmp46_;
		_tmp46_ = g_strdup ("");
		result = _tmp46_;
		return result;
	}
}


static ValaCCodeExpression*
vala_gsignal_module_real_get_signal_creation (ValaCCodeBaseModule* base, 
                                              ValaSignal* sig, 
                                              ValaTypeSymbol* type)
{
	ValaGSignalModule * self;
	ValaCCodeExpression* result = NULL;
	ValaCCodeFunctionCall* csignew = NULL;
	ValaCCodeIdentifier* _tmp0_;
	ValaCCodeIdentifier* _tmp1_;
	ValaCCodeFunctionCall* _tmp2_;
	ValaCCodeFunctionCall* _tmp3_;
	ValaCCodeFunctionCall* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	ValaCCodeConstant* _tmp9_;
	ValaCCodeConstant* _tmp10_;
	ValaCCodeFunctionCall* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	ValaCCodeIdentifier* _tmp14_;
	ValaCCodeIdentifier* _tmp15_;
	gchar** flags = NULL;
	gchar** _tmp16_;
	gint flags_length1;
	gint _flags_size_;
	gchar* run_type = NULL;
	gchar* _tmp17_;
	const gchar* _tmp18_;
	ValaVersionAttribute* _tmp34_;
	ValaVersionAttribute* _tmp35_;
	gboolean _tmp36_;
	gboolean _tmp37_;
	ValaCCodeFunctionCall* _tmp40_;
	gchar** _tmp41_;
	gint _tmp41__length1;
	gchar* _tmp42_;
	gchar* _tmp43_;
	ValaCCodeConstant* _tmp44_;
	ValaCCodeConstant* _tmp45_;
	ValaMethod* _tmp46_;
	ValaMethod* _tmp47_;
	ValaCCodeFunctionCall* _tmp76_;
	ValaCCodeConstant* _tmp77_;
	ValaCCodeConstant* _tmp78_;
	ValaCCodeFunctionCall* _tmp79_;
	ValaCCodeConstant* _tmp80_;
	ValaCCodeConstant* _tmp81_;
	gchar* marshaller = NULL;
	ValaList* _tmp82_;
	ValaList* _tmp83_;
	ValaDataType* _tmp84_;
	ValaDataType* _tmp85_;
	gchar* _tmp86_;
	gchar* _tmp87_;
	ValaCCodeIdentifier* marshal_arg = NULL;
	const gchar* _tmp88_;
	ValaCCodeIdentifier* _tmp89_;
	ValaCCodeFunctionCall* _tmp90_;
	ValaCCodeIdentifier* _tmp91_;
	ValaList* params = NULL;
	ValaList* _tmp92_;
	gboolean _tmp93_ = FALSE;
	ValaDataType* _tmp94_;
	ValaDataType* _tmp95_;
	gint params_len = 0;
	ValaCCodeFunctionCall* _tmp155_;
	gint _tmp156_;
	gchar* _tmp157_;
	gchar* _tmp158_;
	ValaCCodeConstant* _tmp159_;
	ValaCCodeConstant* _tmp160_;
	ValaCCodeIdentifier* _tmp246_;
	const gchar* _tmp247_;
	ValaCCodeExpression* _tmp248_;
	ValaCCodeExpression* _tmp249_;
	ValaCCodeFunctionCall* _tmp250_;
	ValaCCodeAssignment* _tmp251_;
	ValaCCodeExpression* _tmp252_;
	self = (ValaGSignalModule*) base;
	g_return_val_if_fail (sig != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	_tmp0_ = vala_ccode_identifier_new ("g_signal_new");
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1_);
	_tmp3_ = _tmp2_;
	_vala_ccode_node_unref0 (_tmp1_);
	csignew = _tmp3_;
	_tmp4_ = csignew;
	_tmp5_ = vala_get_ccode_name ((ValaCodeNode*) sig);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strdup_printf ("\"%s\"", _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = vala_ccode_constant_new (_tmp8_);
	_tmp10_ = _tmp9_;
	vala_ccode_function_call_add_argument (_tmp4_, (ValaCCodeExpression*) _tmp10_);
	_vala_ccode_node_unref0 (_tmp10_);
	_g_free0 (_tmp8_);
	_g_free0 (_tmp6_);
	_tmp11_ = csignew;
	_tmp12_ = vala_get_ccode_type_id ((ValaCodeNode*) type);
	_tmp13_ = _tmp12_;
	_tmp14_ = vala_ccode_identifier_new (_tmp13_);
	_tmp15_ = _tmp14_;
	vala_ccode_function_call_add_argument (_tmp11_, (ValaCCodeExpression*) _tmp15_);
	_vala_ccode_node_unref0 (_tmp15_);
	_g_free0 (_tmp13_);
	_tmp16_ = g_new0 (gchar*, 0 + 1);
	flags = _tmp16_;
	flags_length1 = 0;
	_flags_size_ = flags_length1;
	_tmp17_ = vala_code_node_get_attribute_string ((ValaCodeNode*) sig, "Signal", "run", NULL);
	run_type = _tmp17_;
	_tmp18_ = run_type;
	if (g_strcmp0 (_tmp18_, "first") == 0) {
		gchar** _tmp19_;
		gint _tmp19__length1;
		gchar* _tmp20_;
		_tmp19_ = flags;
		_tmp19__length1 = flags_length1;
		_tmp20_ = g_strdup ("G_SIGNAL_RUN_FIRST");
		_vala_array_add1 (&flags, &flags_length1, &_flags_size_, _tmp20_);
	} else {
		const gchar* _tmp21_;
		_tmp21_ = run_type;
		if (g_strcmp0 (_tmp21_, "cleanup") == 0) {
			gchar** _tmp22_;
			gint _tmp22__length1;
			gchar* _tmp23_;
			_tmp22_ = flags;
			_tmp22__length1 = flags_length1;
			_tmp23_ = g_strdup ("G_SIGNAL_RUN_CLEANUP");
			_vala_array_add2 (&flags, &flags_length1, &_flags_size_, _tmp23_);
		} else {
			gchar** _tmp24_;
			gint _tmp24__length1;
			gchar* _tmp25_;
			_tmp24_ = flags;
			_tmp24__length1 = flags_length1;
			_tmp25_ = g_strdup ("G_SIGNAL_RUN_LAST");
			_vala_array_add3 (&flags, &flags_length1, &_flags_size_, _tmp25_);
		}
	}
	if (vala_code_node_get_attribute_bool ((ValaCodeNode*) sig, "Signal", "detailed", FALSE)) {
		gchar** _tmp26_;
		gint _tmp26__length1;
		gchar* _tmp27_;
		_tmp26_ = flags;
		_tmp26__length1 = flags_length1;
		_tmp27_ = g_strdup ("G_SIGNAL_DETAILED");
		_vala_array_add4 (&flags, &flags_length1, &_flags_size_, _tmp27_);
	}
	if (vala_code_node_get_attribute_bool ((ValaCodeNode*) sig, "Signal", "no_recurse", FALSE)) {
		gchar** _tmp28_;
		gint _tmp28__length1;
		gchar* _tmp29_;
		_tmp28_ = flags;
		_tmp28__length1 = flags_length1;
		_tmp29_ = g_strdup ("G_SIGNAL_NO_RECURSE");
		_vala_array_add5 (&flags, &flags_length1, &_flags_size_, _tmp29_);
	}
	if (vala_code_node_get_attribute_bool ((ValaCodeNode*) sig, "Signal", "action", FALSE)) {
		gchar** _tmp30_;
		gint _tmp30__length1;
		gchar* _tmp31_;
		_tmp30_ = flags;
		_tmp30__length1 = flags_length1;
		_tmp31_ = g_strdup ("G_SIGNAL_ACTION");
		_vala_array_add6 (&flags, &flags_length1, &_flags_size_, _tmp31_);
	}
	if (vala_code_node_get_attribute_bool ((ValaCodeNode*) sig, "Signal", "no_hooks", FALSE)) {
		gchar** _tmp32_;
		gint _tmp32__length1;
		gchar* _tmp33_;
		_tmp32_ = flags;
		_tmp32__length1 = flags_length1;
		_tmp33_ = g_strdup ("G_SIGNAL_NO_HOOKS");
		_vala_array_add7 (&flags, &flags_length1, &_flags_size_, _tmp33_);
	}
	_tmp34_ = vala_symbol_get_version ((ValaSymbol*) sig);
	_tmp35_ = _tmp34_;
	_tmp36_ = vala_version_attribute_get_deprecated (_tmp35_);
	_tmp37_ = _tmp36_;
	if (_tmp37_) {
		gchar** _tmp38_;
		gint _tmp38__length1;
		gchar* _tmp39_;
		_tmp38_ = flags;
		_tmp38__length1 = flags_length1;
		_tmp39_ = g_strdup ("G_SIGNAL_DEPRECATED");
		_vala_array_add8 (&flags, &flags_length1, &_flags_size_, _tmp39_);
	}
	_tmp40_ = csignew;
	_tmp41_ = flags;
	_tmp41__length1 = flags_length1;
	_tmp42_ = _vala_g_strjoinv (" | ", _tmp41_, _tmp41__length1);
	_tmp43_ = _tmp42_;
	_tmp44_ = vala_ccode_constant_new (_tmp43_);
	_tmp45_ = _tmp44_;
	vala_ccode_function_call_add_argument (_tmp40_, (ValaCCodeExpression*) _tmp45_);
	_vala_ccode_node_unref0 (_tmp45_);
	_g_free0 (_tmp43_);
	_tmp46_ = vala_signal_get_default_handler (sig);
	_tmp47_ = _tmp46_;
	if (_tmp47_ == NULL) {
		ValaCCodeFunctionCall* _tmp48_;
		ValaCCodeConstant* _tmp49_;
		ValaCCodeConstant* _tmp50_;
		_tmp48_ = csignew;
		_tmp49_ = vala_ccode_constant_new ("0");
		_tmp50_ = _tmp49_;
		vala_ccode_function_call_add_argument (_tmp48_, (ValaCCodeExpression*) _tmp50_);
		_vala_ccode_node_unref0 (_tmp50_);
	} else {
		ValaCCodeFunctionCall* struct_offset = NULL;
		ValaCCodeIdentifier* _tmp51_;
		ValaCCodeIdentifier* _tmp52_;
		ValaCCodeFunctionCall* _tmp53_;
		ValaCCodeFunctionCall* _tmp54_;
		ValaCCodeFunctionCall* _tmp67_;
		ValaMethod* _tmp68_;
		ValaMethod* _tmp69_;
		gchar* _tmp70_;
		gchar* _tmp71_;
		ValaCCodeIdentifier* _tmp72_;
		ValaCCodeIdentifier* _tmp73_;
		ValaCCodeFunctionCall* _tmp74_;
		ValaCCodeFunctionCall* _tmp75_;
		_tmp51_ = vala_ccode_identifier_new ("G_STRUCT_OFFSET");
		_tmp52_ = _tmp51_;
		_tmp53_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp52_);
		_tmp54_ = _tmp53_;
		_vala_ccode_node_unref0 (_tmp52_);
		struct_offset = _tmp54_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (type, VALA_TYPE_CLASS)) {
			ValaCCodeFunctionCall* _tmp55_;
			gchar* _tmp56_;
			gchar* _tmp57_;
			gchar* _tmp58_;
			gchar* _tmp59_;
			ValaCCodeIdentifier* _tmp60_;
			ValaCCodeIdentifier* _tmp61_;
			_tmp55_ = struct_offset;
			_tmp56_ = vala_get_ccode_name ((ValaCodeNode*) type);
			_tmp57_ = _tmp56_;
			_tmp58_ = g_strdup_printf ("%sClass", _tmp57_);
			_tmp59_ = _tmp58_;
			_tmp60_ = vala_ccode_identifier_new (_tmp59_);
			_tmp61_ = _tmp60_;
			vala_ccode_function_call_add_argument (_tmp55_, (ValaCCodeExpression*) _tmp61_);
			_vala_ccode_node_unref0 (_tmp61_);
			_g_free0 (_tmp59_);
			_g_free0 (_tmp57_);
		} else {
			ValaCCodeFunctionCall* _tmp62_;
			gchar* _tmp63_;
			gchar* _tmp64_;
			ValaCCodeIdentifier* _tmp65_;
			ValaCCodeIdentifier* _tmp66_;
			_tmp62_ = struct_offset;
			_tmp63_ = vala_get_ccode_type_name (G_TYPE_CHECK_INSTANCE_CAST (type, VALA_TYPE_INTERFACE, ValaInterface));
			_tmp64_ = _tmp63_;
			_tmp65_ = vala_ccode_identifier_new (_tmp64_);
			_tmp66_ = _tmp65_;
			vala_ccode_function_call_add_argument (_tmp62_, (ValaCCodeExpression*) _tmp66_);
			_vala_ccode_node_unref0 (_tmp66_);
			_g_free0 (_tmp64_);
		}
		_tmp67_ = struct_offset;
		_tmp68_ = vala_signal_get_default_handler (sig);
		_tmp69_ = _tmp68_;
		_tmp70_ = vala_get_ccode_vfunc_name (_tmp69_);
		_tmp71_ = _tmp70_;
		_tmp72_ = vala_ccode_identifier_new (_tmp71_);
		_tmp73_ = _tmp72_;
		vala_ccode_function_call_add_argument (_tmp67_, (ValaCCodeExpression*) _tmp73_);
		_vala_ccode_node_unref0 (_tmp73_);
		_g_free0 (_tmp71_);
		_tmp74_ = csignew;
		_tmp75_ = struct_offset;
		vala_ccode_function_call_add_argument (_tmp74_, (ValaCCodeExpression*) _tmp75_);
		_vala_ccode_node_unref0 (struct_offset);
	}
	_tmp76_ = csignew;
	_tmp77_ = vala_ccode_constant_new ("NULL");
	_tmp78_ = _tmp77_;
	vala_ccode_function_call_add_argument (_tmp76_, (ValaCCodeExpression*) _tmp78_);
	_vala_ccode_node_unref0 (_tmp78_);
	_tmp79_ = csignew;
	_tmp80_ = vala_ccode_constant_new ("NULL");
	_tmp81_ = _tmp80_;
	vala_ccode_function_call_add_argument (_tmp79_, (ValaCCodeExpression*) _tmp81_);
	_vala_ccode_node_unref0 (_tmp81_);
	_tmp82_ = vala_callable_get_parameters ((ValaCallable*) sig);
	_tmp83_ = _tmp82_;
	_tmp84_ = vala_callable_get_return_type ((ValaCallable*) sig);
	_tmp85_ = _tmp84_;
	_tmp86_ = vala_gsignal_module_get_marshaller_function (self, _tmp83_, _tmp85_, NULL);
	_tmp87_ = _tmp86_;
	_vala_iterable_unref0 (_tmp83_);
	marshaller = _tmp87_;
	_tmp88_ = marshaller;
	_tmp89_ = vala_ccode_identifier_new (_tmp88_);
	marshal_arg = _tmp89_;
	_tmp90_ = csignew;
	_tmp91_ = marshal_arg;
	vala_ccode_function_call_add_argument (_tmp90_, (ValaCCodeExpression*) _tmp91_);
	_tmp92_ = vala_callable_get_parameters ((ValaCallable*) sig);
	params = _tmp92_;
	_tmp94_ = vala_callable_get_return_type ((ValaCallable*) sig);
	_tmp95_ = _tmp94_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp95_, VALA_TYPE_POINTER_TYPE)) {
		_tmp93_ = TRUE;
	} else {
		ValaDataType* _tmp96_;
		ValaDataType* _tmp97_;
		ValaTypeParameter* _tmp98_;
		ValaTypeParameter* _tmp99_;
		_tmp96_ = vala_callable_get_return_type ((ValaCallable*) sig);
		_tmp97_ = _tmp96_;
		_tmp98_ = vala_data_type_get_type_parameter (_tmp97_);
		_tmp99_ = _tmp98_;
		_tmp93_ = _tmp99_ != NULL;
	}
	if (_tmp93_) {
		ValaCCodeFunctionCall* _tmp100_;
		ValaCCodeConstant* _tmp101_;
		ValaCCodeConstant* _tmp102_;
		_tmp100_ = csignew;
		_tmp101_ = vala_ccode_constant_new ("G_TYPE_POINTER");
		_tmp102_ = _tmp101_;
		vala_ccode_function_call_add_argument (_tmp100_, (ValaCCodeExpression*) _tmp102_);
		_vala_ccode_node_unref0 (_tmp102_);
	} else {
		ValaDataType* _tmp103_;
		ValaDataType* _tmp104_;
		_tmp103_ = vala_callable_get_return_type ((ValaCallable*) sig);
		_tmp104_ = _tmp103_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp104_, VALA_TYPE_ERROR_TYPE)) {
			ValaCCodeFunctionCall* _tmp105_;
			ValaCCodeConstant* _tmp106_;
			ValaCCodeConstant* _tmp107_;
			_tmp105_ = csignew;
			_tmp106_ = vala_ccode_constant_new ("G_TYPE_POINTER");
			_tmp107_ = _tmp106_;
			vala_ccode_function_call_add_argument (_tmp105_, (ValaCCodeExpression*) _tmp107_);
			_vala_ccode_node_unref0 (_tmp107_);
		} else {
			gboolean _tmp108_ = FALSE;
			ValaDataType* _tmp109_;
			ValaDataType* _tmp110_;
			_tmp109_ = vala_callable_get_return_type ((ValaCallable*) sig);
			_tmp110_ = _tmp109_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp110_, VALA_TYPE_VALUE_TYPE)) {
				ValaDataType* _tmp111_;
				ValaDataType* _tmp112_;
				gboolean _tmp113_;
				gboolean _tmp114_;
				_tmp111_ = vala_callable_get_return_type ((ValaCallable*) sig);
				_tmp112_ = _tmp111_;
				_tmp113_ = vala_data_type_get_nullable (_tmp112_);
				_tmp114_ = _tmp113_;
				_tmp108_ = _tmp114_;
			} else {
				_tmp108_ = FALSE;
			}
			if (_tmp108_) {
				ValaCCodeFunctionCall* _tmp115_;
				ValaCCodeConstant* _tmp116_;
				ValaCCodeConstant* _tmp117_;
				_tmp115_ = csignew;
				_tmp116_ = vala_ccode_constant_new ("G_TYPE_POINTER");
				_tmp117_ = _tmp116_;
				vala_ccode_function_call_add_argument (_tmp115_, (ValaCCodeExpression*) _tmp117_);
				_vala_ccode_node_unref0 (_tmp117_);
			} else {
				ValaDataType* _tmp118_;
				ValaDataType* _tmp119_;
				ValaTypeSymbol* _tmp120_;
				ValaTypeSymbol* _tmp121_;
				_tmp118_ = vala_callable_get_return_type ((ValaCallable*) sig);
				_tmp119_ = _tmp118_;
				_tmp120_ = vala_data_type_get_data_type (_tmp119_);
				_tmp121_ = _tmp120_;
				if (_tmp121_ == NULL) {
					ValaCCodeFunctionCall* _tmp122_;
					ValaCCodeConstant* _tmp123_;
					ValaCCodeConstant* _tmp124_;
					_tmp122_ = csignew;
					_tmp123_ = vala_ccode_constant_new ("G_TYPE_NONE");
					_tmp124_ = _tmp123_;
					vala_ccode_function_call_add_argument (_tmp122_, (ValaCCodeExpression*) _tmp124_);
					_vala_ccode_node_unref0 (_tmp124_);
				} else {
					ValaCCodeFunctionCall* _tmp125_;
					ValaDataType* _tmp126_;
					ValaDataType* _tmp127_;
					ValaTypeSymbol* _tmp128_;
					ValaTypeSymbol* _tmp129_;
					gchar* _tmp130_;
					gchar* _tmp131_;
					ValaCCodeConstant* _tmp132_;
					ValaCCodeConstant* _tmp133_;
					_tmp125_ = csignew;
					_tmp126_ = vala_callable_get_return_type ((ValaCallable*) sig);
					_tmp127_ = _tmp126_;
					_tmp128_ = vala_data_type_get_data_type (_tmp127_);
					_tmp129_ = _tmp128_;
					_tmp130_ = vala_get_ccode_type_id ((ValaCodeNode*) _tmp129_);
					_tmp131_ = _tmp130_;
					_tmp132_ = vala_ccode_constant_new (_tmp131_);
					_tmp133_ = _tmp132_;
					vala_ccode_function_call_add_argument (_tmp125_, (ValaCCodeExpression*) _tmp133_);
					_vala_ccode_node_unref0 (_tmp133_);
					_g_free0 (_tmp131_);
				}
			}
		}
	}
	params_len = 0;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp134_;
		ValaList* _tmp135_;
		gint _param_size = 0;
		ValaList* _tmp136_;
		gint _tmp137_;
		gint _tmp138_;
		gint _param_index = 0;
		_tmp134_ = params;
		_tmp135_ = _vala_iterable_ref0 (_tmp134_);
		_param_list = _tmp135_;
		_tmp136_ = _param_list;
		_tmp137_ = vala_collection_get_size ((ValaCollection*) _tmp136_);
		_tmp138_ = _tmp137_;
		_param_size = _tmp138_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp139_;
			gint _tmp140_;
			gint _tmp141_;
			ValaParameter* param = NULL;
			ValaList* _tmp142_;
			gint _tmp143_;
			gpointer _tmp144_;
			gint _tmp145_;
			ValaParameter* _tmp146_;
			ValaDataType* _tmp147_;
			ValaDataType* _tmp148_;
			_tmp139_ = _param_index;
			_param_index = _tmp139_ + 1;
			_tmp140_ = _param_index;
			_tmp141_ = _param_size;
			if (!(_tmp140_ < _tmp141_)) {
				break;
			}
			_tmp142_ = _param_list;
			_tmp143_ = _param_index;
			_tmp144_ = vala_list_get (_tmp142_, _tmp143_);
			param = (ValaParameter*) _tmp144_;
			_tmp145_ = params_len;
			params_len = _tmp145_ + 1;
			_tmp146_ = param;
			_tmp147_ = vala_variable_get_variable_type ((ValaVariable*) _tmp146_);
			_tmp148_ = _tmp147_;
			if (vala_data_type_is_array (_tmp148_)) {
				gint _tmp149_;
				ValaParameter* _tmp150_;
				ValaDataType* _tmp151_;
				ValaDataType* _tmp152_;
				gint _tmp153_;
				gint _tmp154_;
				_tmp149_ = params_len;
				_tmp150_ = param;
				_tmp151_ = vala_variable_get_variable_type ((ValaVariable*) _tmp150_);
				_tmp152_ = _tmp151_;
				_tmp153_ = vala_array_type_get_rank (G_TYPE_CHECK_INSTANCE_CAST (_tmp152_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
				_tmp154_ = _tmp153_;
				params_len = _tmp149_ + _tmp154_;
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp155_ = csignew;
	_tmp156_ = params_len;
	_tmp157_ = g_strdup_printf ("%d", _tmp156_);
	_tmp158_ = _tmp157_;
	_tmp159_ = vala_ccode_constant_new (_tmp158_);
	_tmp160_ = _tmp159_;
	vala_ccode_function_call_add_argument (_tmp155_, (ValaCCodeExpression*) _tmp160_);
	_vala_ccode_node_unref0 (_tmp160_);
	_g_free0 (_tmp158_);
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp161_;
		ValaList* _tmp162_;
		gint _param_size = 0;
		ValaList* _tmp163_;
		gint _tmp164_;
		gint _tmp165_;
		gint _param_index = 0;
		_tmp161_ = params;
		_tmp162_ = _vala_iterable_ref0 (_tmp161_);
		_param_list = _tmp162_;
		_tmp163_ = _param_list;
		_tmp164_ = vala_collection_get_size ((ValaCollection*) _tmp163_);
		_tmp165_ = _tmp164_;
		_param_size = _tmp165_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp166_;
			gint _tmp167_;
			gint _tmp168_;
			ValaParameter* param = NULL;
			ValaList* _tmp169_;
			gint _tmp170_;
			gpointer _tmp171_;
			ValaParameter* _tmp172_;
			ValaDataType* _tmp173_;
			ValaDataType* _tmp174_;
			_tmp166_ = _param_index;
			_param_index = _tmp166_ + 1;
			_tmp167_ = _param_index;
			_tmp168_ = _param_size;
			if (!(_tmp167_ < _tmp168_)) {
				break;
			}
			_tmp169_ = _param_list;
			_tmp170_ = _param_index;
			_tmp171_ = vala_list_get (_tmp169_, _tmp170_);
			param = (ValaParameter*) _tmp171_;
			_tmp172_ = param;
			_tmp173_ = vala_variable_get_variable_type ((ValaVariable*) _tmp172_);
			_tmp174_ = _tmp173_;
			if (vala_data_type_is_array (_tmp174_)) {
				ValaParameter* _tmp175_;
				ValaDataType* _tmp176_;
				ValaDataType* _tmp177_;
				ValaDataType* _tmp178_;
				ValaDataType* _tmp179_;
				ValaTypeSymbol* _tmp180_;
				ValaTypeSymbol* _tmp181_;
				ValaDataType* _tmp182_;
				ValaTypeSymbol* _tmp183_;
				ValaTypeSymbol* _tmp184_;
				_tmp175_ = param;
				_tmp176_ = vala_variable_get_variable_type ((ValaVariable*) _tmp175_);
				_tmp177_ = _tmp176_;
				_tmp178_ = vala_array_type_get_element_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp177_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
				_tmp179_ = _tmp178_;
				_tmp180_ = vala_data_type_get_data_type (_tmp179_);
				_tmp181_ = _tmp180_;
				_tmp182_ = ((ValaCCodeBaseModule*) self)->string_type;
				_tmp183_ = vala_data_type_get_data_type (_tmp182_);
				_tmp184_ = _tmp183_;
				if (_tmp181_ == _tmp184_) {
					ValaCCodeFunctionCall* _tmp185_;
					ValaCCodeConstant* _tmp186_;
					ValaCCodeConstant* _tmp187_;
					_tmp185_ = csignew;
					_tmp186_ = vala_ccode_constant_new ("G_TYPE_STRV");
					_tmp187_ = _tmp186_;
					vala_ccode_function_call_add_argument (_tmp185_, (ValaCCodeExpression*) _tmp187_);
					_vala_ccode_node_unref0 (_tmp187_);
				} else {
					ValaCCodeFunctionCall* _tmp188_;
					ValaCCodeConstant* _tmp189_;
					ValaCCodeConstant* _tmp190_;
					_tmp188_ = csignew;
					_tmp189_ = vala_ccode_constant_new ("G_TYPE_POINTER");
					_tmp190_ = _tmp189_;
					vala_ccode_function_call_add_argument (_tmp188_, (ValaCCodeExpression*) _tmp190_);
					_vala_ccode_node_unref0 (_tmp190_);
				}
				{
					gint i = 0;
					i = 0;
					{
						gboolean _tmp191_ = FALSE;
						_tmp191_ = TRUE;
						while (TRUE) {
							gint _tmp193_;
							ValaParameter* _tmp194_;
							ValaDataType* _tmp195_;
							ValaDataType* _tmp196_;
							gint _tmp197_;
							gint _tmp198_;
							ValaCCodeFunctionCall* _tmp199_;
							ValaCCodeConstant* _tmp200_;
							ValaCCodeConstant* _tmp201_;
							if (!_tmp191_) {
								gint _tmp192_;
								_tmp192_ = i;
								i = _tmp192_ + 1;
							}
							_tmp191_ = FALSE;
							_tmp193_ = i;
							_tmp194_ = param;
							_tmp195_ = vala_variable_get_variable_type ((ValaVariable*) _tmp194_);
							_tmp196_ = _tmp195_;
							_tmp197_ = vala_array_type_get_rank (G_TYPE_CHECK_INSTANCE_CAST (_tmp196_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
							_tmp198_ = _tmp197_;
							if (!(_tmp193_ < _tmp198_)) {
								break;
							}
							_tmp199_ = csignew;
							_tmp200_ = vala_ccode_constant_new ("G_TYPE_INT");
							_tmp201_ = _tmp200_;
							vala_ccode_function_call_add_argument (_tmp199_, (ValaCCodeExpression*) _tmp201_);
							_vala_ccode_node_unref0 (_tmp201_);
						}
					}
				}
			} else {
				gboolean _tmp202_ = FALSE;
				gboolean _tmp203_ = FALSE;
				ValaParameter* _tmp204_;
				ValaDataType* _tmp205_;
				ValaDataType* _tmp206_;
				_tmp204_ = param;
				_tmp205_ = vala_variable_get_variable_type ((ValaVariable*) _tmp204_);
				_tmp206_ = _tmp205_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp206_, VALA_TYPE_POINTER_TYPE)) {
					_tmp203_ = TRUE;
				} else {
					ValaParameter* _tmp207_;
					ValaDataType* _tmp208_;
					ValaDataType* _tmp209_;
					ValaTypeParameter* _tmp210_;
					ValaTypeParameter* _tmp211_;
					_tmp207_ = param;
					_tmp208_ = vala_variable_get_variable_type ((ValaVariable*) _tmp207_);
					_tmp209_ = _tmp208_;
					_tmp210_ = vala_data_type_get_type_parameter (_tmp209_);
					_tmp211_ = _tmp210_;
					_tmp203_ = _tmp211_ != NULL;
				}
				if (_tmp203_) {
					_tmp202_ = TRUE;
				} else {
					ValaParameter* _tmp212_;
					ValaParameterDirection _tmp213_;
					ValaParameterDirection _tmp214_;
					_tmp212_ = param;
					_tmp213_ = vala_parameter_get_direction (_tmp212_);
					_tmp214_ = _tmp213_;
					_tmp202_ = _tmp214_ != VALA_PARAMETER_DIRECTION_IN;
				}
				if (_tmp202_) {
					ValaCCodeFunctionCall* _tmp215_;
					ValaCCodeConstant* _tmp216_;
					ValaCCodeConstant* _tmp217_;
					_tmp215_ = csignew;
					_tmp216_ = vala_ccode_constant_new ("G_TYPE_POINTER");
					_tmp217_ = _tmp216_;
					vala_ccode_function_call_add_argument (_tmp215_, (ValaCCodeExpression*) _tmp217_);
					_vala_ccode_node_unref0 (_tmp217_);
				} else {
					ValaParameter* _tmp218_;
					ValaDataType* _tmp219_;
					ValaDataType* _tmp220_;
					_tmp218_ = param;
					_tmp219_ = vala_variable_get_variable_type ((ValaVariable*) _tmp218_);
					_tmp220_ = _tmp219_;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp220_, VALA_TYPE_ERROR_TYPE)) {
						ValaCCodeFunctionCall* _tmp221_;
						ValaCCodeConstant* _tmp222_;
						ValaCCodeConstant* _tmp223_;
						_tmp221_ = csignew;
						_tmp222_ = vala_ccode_constant_new ("G_TYPE_POINTER");
						_tmp223_ = _tmp222_;
						vala_ccode_function_call_add_argument (_tmp221_, (ValaCCodeExpression*) _tmp223_);
						_vala_ccode_node_unref0 (_tmp223_);
					} else {
						gboolean _tmp224_ = FALSE;
						ValaParameter* _tmp225_;
						ValaDataType* _tmp226_;
						ValaDataType* _tmp227_;
						_tmp225_ = param;
						_tmp226_ = vala_variable_get_variable_type ((ValaVariable*) _tmp225_);
						_tmp227_ = _tmp226_;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp227_, VALA_TYPE_VALUE_TYPE)) {
							ValaParameter* _tmp228_;
							ValaDataType* _tmp229_;
							ValaDataType* _tmp230_;
							gboolean _tmp231_;
							gboolean _tmp232_;
							_tmp228_ = param;
							_tmp229_ = vala_variable_get_variable_type ((ValaVariable*) _tmp228_);
							_tmp230_ = _tmp229_;
							_tmp231_ = vala_data_type_get_nullable (_tmp230_);
							_tmp232_ = _tmp231_;
							_tmp224_ = _tmp232_;
						} else {
							_tmp224_ = FALSE;
						}
						if (_tmp224_) {
							ValaCCodeFunctionCall* _tmp233_;
							ValaCCodeConstant* _tmp234_;
							ValaCCodeConstant* _tmp235_;
							_tmp233_ = csignew;
							_tmp234_ = vala_ccode_constant_new ("G_TYPE_POINTER");
							_tmp235_ = _tmp234_;
							vala_ccode_function_call_add_argument (_tmp233_, (ValaCCodeExpression*) _tmp235_);
							_vala_ccode_node_unref0 (_tmp235_);
						} else {
							ValaCCodeFunctionCall* _tmp236_;
							ValaParameter* _tmp237_;
							ValaDataType* _tmp238_;
							ValaDataType* _tmp239_;
							ValaTypeSymbol* _tmp240_;
							ValaTypeSymbol* _tmp241_;
							gchar* _tmp242_;
							gchar* _tmp243_;
							ValaCCodeConstant* _tmp244_;
							ValaCCodeConstant* _tmp245_;
							_tmp236_ = csignew;
							_tmp237_ = param;
							_tmp238_ = vala_variable_get_variable_type ((ValaVariable*) _tmp237_);
							_tmp239_ = _tmp238_;
							_tmp240_ = vala_data_type_get_data_type (_tmp239_);
							_tmp241_ = _tmp240_;
							_tmp242_ = vala_get_ccode_type_id ((ValaCodeNode*) _tmp241_);
							_tmp243_ = _tmp242_;
							_tmp244_ = vala_ccode_constant_new (_tmp243_);
							_tmp245_ = _tmp244_;
							vala_ccode_function_call_add_argument (_tmp236_, (ValaCCodeExpression*) _tmp245_);
							_vala_ccode_node_unref0 (_tmp245_);
							_g_free0 (_tmp243_);
						}
					}
				}
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp246_ = marshal_arg;
	_tmp247_ = marshaller;
	vala_ccode_identifier_set_name (_tmp246_, _tmp247_);
	_tmp248_ = vala_gsignal_module_get_signal_id_cexpression (self, sig);
	_tmp249_ = _tmp248_;
	_tmp250_ = csignew;
	_tmp251_ = vala_ccode_assignment_new (_tmp249_, (ValaCCodeExpression*) _tmp250_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
	_tmp252_ = (ValaCCodeExpression*) _tmp251_;
	_vala_ccode_node_unref0 (_tmp249_);
	result = _tmp252_;
	_vala_iterable_unref0 (params);
	_vala_ccode_node_unref0 (marshal_arg);
	_g_free0 (marshaller);
	_g_free0 (run_type);
	flags = (_vala_array_free (flags, flags_length1, (GDestroyNotify) g_free), NULL);
	_vala_ccode_node_unref0 (csignew);
	return result;
}


static void
vala_gsignal_module_real_visit_element_access (ValaCodeVisitor* base, 
                                               ValaElementAccess* expr)
{
	ValaGSignalModule * self;
	gboolean _tmp0_ = FALSE;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	self = (ValaGSignalModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp1_ = vala_element_access_get_container (expr);
	_tmp2_ = _tmp1_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, VALA_TYPE_MEMBER_ACCESS)) {
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		ValaSymbol* _tmp5_;
		ValaSymbol* _tmp6_;
		_tmp3_ = vala_element_access_get_container (expr);
		_tmp4_ = _tmp3_;
		_tmp5_ = vala_expression_get_symbol_reference (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, VALA_TYPE_SIGNAL);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		ValaCodeNode* _tmp7_;
		ValaCodeNode* _tmp8_;
		_tmp7_ = vala_code_node_get_parent_node ((ValaCodeNode*) expr);
		_tmp8_ = _tmp7_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, VALA_TYPE_METHOD_CALL)) {
			ValaSignal* sig = NULL;
			ValaSymbol* _tmp9_;
			ValaSymbol* _tmp10_;
			ValaSignal* _tmp11_;
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp12_;
			ValaExpression* _tmp13_;
			ValaMemberAccess* _tmp14_;
			ValaExpression* detail_expr = NULL;
			ValaList* _tmp15_;
			ValaList* _tmp16_;
			gpointer _tmp17_;
			ValaExpression* _tmp18_;
			ValaCCodeFunctionCall* ccall = NULL;
			gboolean _tmp19_ = FALSE;
			ValaSignal* _tmp20_;
			gboolean _tmp21_;
			gboolean _tmp22_;
			ValaCCodeFunctionCall* _tmp65_;
			_tmp9_ = vala_expression_get_symbol_reference ((ValaExpression*) expr);
			_tmp10_ = _tmp9_;
			_tmp11_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, VALA_TYPE_SIGNAL, ValaSignal));
			sig = _tmp11_;
			_tmp12_ = vala_element_access_get_container (expr);
			_tmp13_ = _tmp12_;
			_tmp14_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			ma = _tmp14_;
			_tmp15_ = vala_element_access_get_indices (expr);
			_tmp16_ = _tmp15_;
			_tmp17_ = vala_list_get (_tmp16_, 0);
			_tmp18_ = (ValaExpression*) _tmp17_;
			_vala_iterable_unref0 (_tmp16_);
			detail_expr = _tmp18_;
			_tmp20_ = sig;
			_tmp21_ = vala_symbol_get_external_package ((ValaSymbol*) _tmp20_);
			_tmp22_ = _tmp21_;
			if (!_tmp22_) {
				ValaSourceReference* _tmp23_;
				ValaSourceReference* _tmp24_;
				ValaSourceFile* _tmp25_;
				ValaSourceFile* _tmp26_;
				ValaSignal* _tmp27_;
				ValaSourceReference* _tmp28_;
				ValaSourceReference* _tmp29_;
				ValaSourceFile* _tmp30_;
				ValaSourceFile* _tmp31_;
				_tmp23_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
				_tmp24_ = _tmp23_;
				_tmp25_ = vala_source_reference_get_file (_tmp24_);
				_tmp26_ = _tmp25_;
				_tmp27_ = sig;
				_tmp28_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp27_);
				_tmp29_ = _tmp28_;
				_tmp30_ = vala_source_reference_get_file (_tmp29_);
				_tmp31_ = _tmp30_;
				_tmp19_ = _tmp26_ == _tmp31_;
			} else {
				_tmp19_ = FALSE;
			}
			if (_tmp19_) {
				ValaCCodeExpression* detail_cexpr = NULL;
				ValaExpression* _tmp32_;
				ValaCCodeExpression* _tmp33_;
				ValaCCodeIdentifier* _tmp34_;
				ValaCCodeIdentifier* _tmp35_;
				ValaCCodeFunctionCall* _tmp36_;
				ValaCCodeFunctionCall* _tmp37_;
				ValaMemberAccess* _tmp38_;
				ValaExpression* _tmp39_;
				ValaExpression* _tmp40_;
				ValaCCodeExpression* _tmp41_;
				ValaCCodeExpression* _tmp42_;
				ValaCCodeFunctionCall* _tmp43_;
				ValaSignal* _tmp44_;
				ValaCCodeExpression* _tmp45_;
				ValaCCodeExpression* _tmp46_;
				ValaCCodeExpression* _tmp47_;
				_tmp32_ = detail_expr;
				_tmp33_ = vala_gsignal_module_get_detail_cexpression (self, _tmp32_, (ValaCodeNode*) expr);
				detail_cexpr = _tmp33_;
				_tmp34_ = vala_ccode_identifier_new ("g_signal_emit");
				_tmp35_ = _tmp34_;
				_tmp36_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp35_);
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp36_;
				_vala_ccode_node_unref0 (_tmp35_);
				_tmp37_ = ccall;
				_tmp38_ = ma;
				_tmp39_ = vala_member_access_get_inner (_tmp38_);
				_tmp40_ = _tmp39_;
				_tmp41_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp40_);
				_tmp42_ = _tmp41_;
				vala_ccode_function_call_add_argument (_tmp37_, _tmp42_);
				_vala_ccode_node_unref0 (_tmp42_);
				_tmp43_ = ccall;
				_tmp44_ = sig;
				_tmp45_ = vala_gsignal_module_get_signal_id_cexpression (self, _tmp44_);
				_tmp46_ = _tmp45_;
				vala_ccode_function_call_add_argument (_tmp43_, _tmp46_);
				_vala_ccode_node_unref0 (_tmp46_);
				_tmp47_ = detail_cexpr;
				if (_tmp47_ != NULL) {
					ValaCCodeFunctionCall* _tmp48_;
					ValaCCodeExpression* _tmp49_;
					_tmp48_ = ccall;
					_tmp49_ = detail_cexpr;
					vala_ccode_function_call_add_argument (_tmp48_, _tmp49_);
				}
				_vala_ccode_node_unref0 (detail_cexpr);
			} else {
				ValaCCodeExpression* signal_name_cexpr = NULL;
				ValaSignal* _tmp50_;
				ValaExpression* _tmp51_;
				ValaCCodeExpression* _tmp52_;
				ValaCCodeIdentifier* _tmp53_;
				ValaCCodeIdentifier* _tmp54_;
				ValaCCodeFunctionCall* _tmp55_;
				ValaCCodeFunctionCall* _tmp56_;
				ValaMemberAccess* _tmp57_;
				ValaExpression* _tmp58_;
				ValaExpression* _tmp59_;
				ValaCCodeExpression* _tmp60_;
				ValaCCodeExpression* _tmp61_;
				ValaCCodeExpression* _tmp62_;
				_tmp50_ = sig;
				_tmp51_ = detail_expr;
				_tmp52_ = vala_gsignal_module_get_signal_name_cexpression (self, _tmp50_, _tmp51_, (ValaCodeNode*) expr);
				signal_name_cexpr = _tmp52_;
				_tmp53_ = vala_ccode_identifier_new ("g_signal_emit_by_name");
				_tmp54_ = _tmp53_;
				_tmp55_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp54_);
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp55_;
				_vala_ccode_node_unref0 (_tmp54_);
				_tmp56_ = ccall;
				_tmp57_ = ma;
				_tmp58_ = vala_member_access_get_inner (_tmp57_);
				_tmp59_ = _tmp58_;
				_tmp60_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp59_);
				_tmp61_ = _tmp60_;
				vala_ccode_function_call_add_argument (_tmp56_, _tmp61_);
				_vala_ccode_node_unref0 (_tmp61_);
				_tmp62_ = signal_name_cexpr;
				if (_tmp62_ != NULL) {
					ValaCCodeFunctionCall* _tmp63_;
					ValaCCodeExpression* _tmp64_;
					_tmp63_ = ccall;
					_tmp64_ = signal_name_cexpr;
					vala_ccode_function_call_add_argument (_tmp63_, _tmp64_);
				}
				_vala_ccode_node_unref0 (signal_name_cexpr);
			}
			_tmp65_ = ccall;
			vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp65_);
			_vala_ccode_node_unref0 (ccall);
			_vala_code_node_unref0 (detail_expr);
			_vala_code_node_unref0 (ma);
			_vala_code_node_unref0 (sig);
		} else {
		}
	} else {
		VALA_CODE_VISITOR_CLASS (vala_gsignal_module_parent_class)->visit_element_access ((ValaCodeVisitor*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_GOBJECT_MODULE, ValaGObjectModule), expr);
	}
}


static gboolean
vala_gsignal_module_in_gobject_instance (ValaGSignalModule* self, 
                                         ValaMethod* m)
{
	gboolean result = FALSE;
	gboolean _result_ = FALSE;
	ValaMemberBinding _tmp0_;
	ValaMemberBinding _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (m != NULL, FALSE);
	_result_ = FALSE;
	_tmp0_ = vala_method_get_binding (m);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == VALA_MEMBER_BINDING_INSTANCE) {
		ValaParameter* _tmp2_;
		ValaParameter* _tmp3_;
		ValaDataType* _tmp4_;
		ValaDataType* _tmp5_;
		ValaTypeSymbol* _tmp6_;
		ValaTypeSymbol* _tmp7_;
		ValaTypeSymbol* _tmp8_;
		_tmp2_ = vala_method_get_this_parameter (m);
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_variable_get_variable_type ((ValaVariable*) _tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_data_type_get_data_type (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = ((ValaCCodeBaseModule*) self)->gobject_type;
		_result_ = vala_typesymbol_is_subtype_of (_tmp7_, _tmp8_);
	}
	result = _result_;
	return result;
}


static void
vala_gsignal_module_emit_signal_assignment (ValaGSignalModule* self, 
                                            ValaAssignment* assignment)
{
	ValaSignal* sig = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaSymbol* _tmp2_;
	ValaSymbol* _tmp3_;
	ValaSignal* _tmp4_;
	gboolean disconnect = FALSE;
	ValaAssignmentOperator _tmp5_;
	ValaAssignmentOperator _tmp6_;
	ValaSignal* _tmp11_;
	ValaExpression* _tmp12_;
	ValaExpression* _tmp13_;
	ValaExpression* _tmp14_;
	ValaExpression* _tmp15_;
	gboolean _tmp16_;
	ValaCCodeExpression* _tmp17_;
	ValaCCodeExpression* _tmp18_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (assignment != NULL);
	_tmp0_ = vala_assignment_get_left (assignment);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_expression_get_symbol_reference (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, VALA_TYPE_SIGNAL, ValaSignal));
	sig = _tmp4_;
	disconnect = FALSE;
	_tmp5_ = vala_assignment_get_operator (assignment);
	_tmp6_ = _tmp5_;
	if (_tmp6_ == VALA_ASSIGNMENT_OPERATOR_ADD) {
	} else {
		ValaAssignmentOperator _tmp7_;
		ValaAssignmentOperator _tmp8_;
		_tmp7_ = vala_assignment_get_operator (assignment);
		_tmp8_ = _tmp7_;
		if (_tmp8_ == VALA_ASSIGNMENT_OPERATOR_SUB) {
			disconnect = TRUE;
		} else {
			ValaSourceReference* _tmp9_;
			ValaSourceReference* _tmp10_;
			vala_code_node_set_error ((ValaCodeNode*) assignment, TRUE);
			_tmp9_ = vala_code_node_get_source_reference ((ValaCodeNode*) assignment);
			_tmp10_ = _tmp9_;
			vala_report_error (_tmp10_, "Specified compound assignment type for signals not supported.");
			_vala_code_node_unref0 (sig);
			return;
		}
	}
	_tmp11_ = sig;
	_tmp12_ = vala_assignment_get_left (assignment);
	_tmp13_ = _tmp12_;
	_tmp14_ = vala_assignment_get_right (assignment);
	_tmp15_ = _tmp14_;
	_tmp16_ = disconnect;
	_tmp17_ = vala_gsignal_module_connect_signal (self, _tmp11_, _tmp13_, _tmp15_, _tmp16_, FALSE, (ValaCodeNode*) assignment);
	_tmp18_ = _tmp17_;
	_vala_ccode_node_unref0 (_tmp18_);
	_vala_code_node_unref0 (sig);
}


static void
vala_gsignal_module_real_visit_assignment (ValaCodeVisitor* base, 
                                           ValaAssignment* assignment)
{
	ValaGSignalModule * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaSymbol* _tmp2_;
	ValaSymbol* _tmp3_;
	self = (ValaGSignalModule*) base;
	g_return_if_fail (assignment != NULL);
	_tmp0_ = vala_assignment_get_left (assignment);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_expression_get_symbol_reference (_tmp1_);
	_tmp3_ = _tmp2_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, VALA_TYPE_SIGNAL)) {
		gboolean _tmp4_ = FALSE;
		ValaExpression* _tmp5_;
		ValaExpression* _tmp6_;
		gboolean _tmp7_;
		gboolean _tmp8_;
		_tmp5_ = vala_assignment_get_left (assignment);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_code_node_get_error ((ValaCodeNode*) _tmp6_);
		_tmp8_ = _tmp7_;
		if (_tmp8_) {
			_tmp4_ = TRUE;
		} else {
			ValaExpression* _tmp9_;
			ValaExpression* _tmp10_;
			gboolean _tmp11_;
			gboolean _tmp12_;
			_tmp9_ = vala_assignment_get_right (assignment);
			_tmp10_ = _tmp9_;
			_tmp11_ = vala_code_node_get_error ((ValaCodeNode*) _tmp10_);
			_tmp12_ = _tmp11_;
			_tmp4_ = _tmp12_;
		}
		if (_tmp4_) {
			vala_code_node_set_error ((ValaCodeNode*) assignment, TRUE);
			return;
		}
		vala_gsignal_module_emit_signal_assignment (self, assignment);
	} else {
		VALA_CODE_VISITOR_CLASS (vala_gsignal_module_parent_class)->visit_assignment ((ValaCodeVisitor*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_GOBJECT_MODULE, ValaGObjectModule), assignment);
	}
}


static void
vala_gsignal_module_real_visit_member_access (ValaCodeVisitor* base, 
                                              ValaMemberAccess* expr)
{
	ValaGSignalModule * self;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	self = (ValaGSignalModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) expr);
	_tmp1_ = _tmp0_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_SIGNAL)) {
		ValaCCodeExpression* pub_inst = NULL;
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		ValaSignal* sig = NULL;
		ValaSymbol* _tmp7_;
		ValaSymbol* _tmp8_;
		ValaSignal* _tmp9_;
		ValaTypeSymbol* cl = NULL;
		ValaSignal* _tmp10_;
		ValaSymbol* _tmp11_;
		ValaSymbol* _tmp12_;
		ValaTypeSymbol* _tmp13_;
		gboolean _tmp14_ = FALSE;
		ValaExpression* _tmp15_;
		ValaExpression* _tmp16_;
		gboolean _tmp52_ = FALSE;
		ValaSignal* _tmp53_;
		gboolean _tmp54_;
		gboolean _tmp55_;
		pub_inst = NULL;
		_tmp2_ = vala_member_access_get_inner (expr);
		_tmp3_ = _tmp2_;
		if (_tmp3_ != NULL) {
			ValaExpression* _tmp4_;
			ValaExpression* _tmp5_;
			ValaCCodeExpression* _tmp6_;
			_tmp4_ = vala_member_access_get_inner (expr);
			_tmp5_ = _tmp4_;
			_tmp6_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp5_);
			_vala_ccode_node_unref0 (pub_inst);
			pub_inst = _tmp6_;
		}
		_tmp7_ = vala_expression_get_symbol_reference ((ValaExpression*) expr);
		_tmp8_ = _tmp7_;
		_tmp9_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, VALA_TYPE_SIGNAL, ValaSignal));
		sig = _tmp9_;
		_tmp10_ = sig;
		_tmp11_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
		cl = _tmp13_;
		_tmp15_ = vala_member_access_get_inner (expr);
		_tmp16_ = _tmp15_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, VALA_TYPE_BASE_ACCESS)) {
			ValaSignal* _tmp17_;
			gboolean _tmp18_;
			gboolean _tmp19_;
			_tmp17_ = sig;
			_tmp18_ = vala_signal_get_is_virtual (_tmp17_);
			_tmp19_ = _tmp18_;
			_tmp14_ = _tmp19_;
		} else {
			_tmp14_ = FALSE;
		}
		if (_tmp14_) {
			ValaMethod* m = NULL;
			ValaSignal* _tmp20_;
			ValaMethod* _tmp21_;
			ValaMethod* _tmp22_;
			ValaMethod* _tmp23_;
			ValaClass* base_class = NULL;
			ValaMethod* _tmp24_;
			ValaSymbol* _tmp25_;
			ValaSymbol* _tmp26_;
			ValaClass* _tmp27_;
			ValaCCodeFunctionCall* vcast = NULL;
			ValaClass* _tmp28_;
			gchar* _tmp29_;
			gchar* _tmp30_;
			gchar* _tmp31_;
			gchar* _tmp32_;
			ValaCCodeIdentifier* _tmp33_;
			ValaCCodeIdentifier* _tmp34_;
			ValaCCodeFunctionCall* _tmp35_;
			ValaCCodeFunctionCall* _tmp36_;
			ValaCCodeFunctionCall* _tmp37_;
			ValaClass* _tmp38_;
			ValaClass* _tmp39_;
			gchar* _tmp40_;
			gchar* _tmp41_;
			gchar* _tmp42_;
			gchar* _tmp43_;
			ValaCCodeIdentifier* _tmp44_;
			ValaCCodeIdentifier* _tmp45_;
			ValaCCodeFunctionCall* _tmp46_;
			ValaMethod* _tmp47_;
			const gchar* _tmp48_;
			const gchar* _tmp49_;
			ValaCCodeMemberAccess* _tmp50_;
			ValaCCodeMemberAccess* _tmp51_;
			_tmp20_ = sig;
			_tmp21_ = vala_signal_get_default_handler (_tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = _vala_code_node_ref0 (_tmp22_);
			m = _tmp23_;
			_tmp24_ = m;
			_tmp25_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp24_);
			_tmp26_ = _tmp25_;
			_tmp27_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, VALA_TYPE_CLASS, ValaClass));
			base_class = _tmp27_;
			_tmp28_ = base_class;
			_tmp29_ = vala_get_ccode_upper_case_name ((ValaSymbol*) _tmp28_, NULL);
			_tmp30_ = _tmp29_;
			_tmp31_ = g_strdup_printf ("%s_CLASS", _tmp30_);
			_tmp32_ = _tmp31_;
			_tmp33_ = vala_ccode_identifier_new (_tmp32_);
			_tmp34_ = _tmp33_;
			_tmp35_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp34_);
			_tmp36_ = _tmp35_;
			_vala_ccode_node_unref0 (_tmp34_);
			_g_free0 (_tmp32_);
			_g_free0 (_tmp30_);
			vcast = _tmp36_;
			_tmp37_ = vcast;
			_tmp38_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp39_ = _tmp38_;
			_tmp40_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp39_, NULL);
			_tmp41_ = _tmp40_;
			_tmp42_ = g_strdup_printf ("%s_parent_class", _tmp41_);
			_tmp43_ = _tmp42_;
			_tmp44_ = vala_ccode_identifier_new (_tmp43_);
			_tmp45_ = _tmp44_;
			vala_ccode_function_call_add_argument (_tmp37_, (ValaCCodeExpression*) _tmp45_);
			_vala_ccode_node_unref0 (_tmp45_);
			_g_free0 (_tmp43_);
			_g_free0 (_tmp41_);
			_tmp46_ = vcast;
			_tmp47_ = m;
			_tmp48_ = vala_symbol_get_name ((ValaSymbol*) _tmp47_);
			_tmp49_ = _tmp48_;
			_tmp50_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp46_, _tmp49_);
			_tmp51_ = _tmp50_;
			vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp51_);
			_vala_ccode_node_unref0 (_tmp51_);
			_vala_ccode_node_unref0 (vcast);
			_vala_code_node_unref0 (base_class);
			_vala_code_node_unref0 (m);
			_vala_code_node_unref0 (cl);
			_vala_code_node_unref0 (sig);
			_vala_ccode_node_unref0 (pub_inst);
			return;
		}
		_tmp53_ = sig;
		_tmp54_ = vala_symbol_get_external_package ((ValaSymbol*) _tmp53_);
		_tmp55_ = _tmp54_;
		if (!_tmp55_) {
			ValaSourceReference* _tmp56_;
			ValaSourceReference* _tmp57_;
			ValaSourceFile* _tmp58_;
			ValaSourceFile* _tmp59_;
			ValaSignal* _tmp60_;
			ValaSourceReference* _tmp61_;
			ValaSourceReference* _tmp62_;
			ValaSourceFile* _tmp63_;
			ValaSourceFile* _tmp64_;
			_tmp56_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
			_tmp57_ = _tmp56_;
			_tmp58_ = vala_source_reference_get_file (_tmp57_);
			_tmp59_ = _tmp58_;
			_tmp60_ = sig;
			_tmp61_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp60_);
			_tmp62_ = _tmp61_;
			_tmp63_ = vala_source_reference_get_file (_tmp62_);
			_tmp64_ = _tmp63_;
			_tmp52_ = _tmp59_ == _tmp64_;
		} else {
			_tmp52_ = FALSE;
		}
		if (_tmp52_) {
			ValaCCodeFunctionCall* ccall = NULL;
			ValaCCodeIdentifier* _tmp65_;
			ValaCCodeIdentifier* _tmp66_;
			ValaCCodeFunctionCall* _tmp67_;
			ValaCCodeFunctionCall* _tmp68_;
			ValaCCodeFunctionCall* _tmp69_;
			ValaCCodeExpression* _tmp70_;
			ValaCCodeFunctionCall* _tmp71_;
			ValaSignal* _tmp72_;
			ValaCCodeExpression* _tmp73_;
			ValaCCodeExpression* _tmp74_;
			ValaCCodeFunctionCall* _tmp75_;
			ValaCCodeConstant* _tmp76_;
			ValaCCodeConstant* _tmp77_;
			ValaCCodeFunctionCall* _tmp78_;
			_tmp65_ = vala_ccode_identifier_new ("g_signal_emit");
			_tmp66_ = _tmp65_;
			_tmp67_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp66_);
			_tmp68_ = _tmp67_;
			_vala_ccode_node_unref0 (_tmp66_);
			ccall = _tmp68_;
			_tmp69_ = ccall;
			_tmp70_ = pub_inst;
			vala_ccode_function_call_add_argument (_tmp69_, _tmp70_);
			_tmp71_ = ccall;
			_tmp72_ = sig;
			_tmp73_ = vala_gsignal_module_get_signal_id_cexpression (self, _tmp72_);
			_tmp74_ = _tmp73_;
			vala_ccode_function_call_add_argument (_tmp71_, _tmp74_);
			_vala_ccode_node_unref0 (_tmp74_);
			_tmp75_ = ccall;
			_tmp76_ = vala_ccode_constant_new ("0");
			_tmp77_ = _tmp76_;
			vala_ccode_function_call_add_argument (_tmp75_, (ValaCCodeExpression*) _tmp77_);
			_vala_ccode_node_unref0 (_tmp77_);
			_tmp78_ = ccall;
			vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp78_);
			_vala_ccode_node_unref0 (ccall);
		} else {
			ValaSignal* _tmp79_;
			_tmp79_ = sig;
			if (vala_ccode_base_module_get_signal_has_emitter ((ValaCCodeBaseModule*) self, _tmp79_)) {
				gchar* emitter_func = NULL;
				ValaSignal* _tmp80_;
				ValaMethod* _tmp81_;
				ValaMethod* _tmp82_;
				ValaCCodeFunctionCall* ccall = NULL;
				const gchar* _tmp111_;
				ValaCCodeIdentifier* _tmp112_;
				ValaCCodeIdentifier* _tmp113_;
				ValaCCodeFunctionCall* _tmp114_;
				ValaCCodeFunctionCall* _tmp115_;
				ValaCCodeFunctionCall* _tmp116_;
				ValaCCodeExpression* _tmp117_;
				ValaCCodeFunctionCall* _tmp118_;
				_tmp80_ = sig;
				_tmp81_ = vala_signal_get_emitter (_tmp80_);
				_tmp82_ = _tmp81_;
				if (_tmp82_ != NULL) {
					gboolean _tmp83_ = FALSE;
					ValaSignal* _tmp84_;
					gboolean _tmp85_;
					gboolean _tmp86_;
					ValaSignal* _tmp100_;
					ValaMethod* _tmp101_;
					ValaMethod* _tmp102_;
					gchar* _tmp103_;
					_tmp84_ = sig;
					_tmp85_ = vala_symbol_get_external_package ((ValaSymbol*) _tmp84_);
					_tmp86_ = _tmp85_;
					if (!_tmp86_) {
						ValaSourceReference* _tmp87_;
						ValaSourceReference* _tmp88_;
						ValaSourceFile* _tmp89_;
						ValaSourceFile* _tmp90_;
						ValaSignal* _tmp91_;
						ValaSourceReference* _tmp92_;
						ValaSourceReference* _tmp93_;
						ValaSourceFile* _tmp94_;
						ValaSourceFile* _tmp95_;
						_tmp87_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
						_tmp88_ = _tmp87_;
						_tmp89_ = vala_source_reference_get_file (_tmp88_);
						_tmp90_ = _tmp89_;
						_tmp91_ = sig;
						_tmp92_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp91_);
						_tmp93_ = _tmp92_;
						_tmp94_ = vala_source_reference_get_file (_tmp93_);
						_tmp95_ = _tmp94_;
						_tmp83_ = _tmp90_ != _tmp95_;
					} else {
						_tmp83_ = FALSE;
					}
					if (_tmp83_) {
						ValaSignal* _tmp96_;
						ValaMethod* _tmp97_;
						ValaMethod* _tmp98_;
						ValaCCodeFile* _tmp99_;
						_tmp96_ = sig;
						_tmp97_ = vala_signal_get_emitter (_tmp96_);
						_tmp98_ = _tmp97_;
						_tmp99_ = ((ValaCCodeBaseModule*) self)->cfile;
						vala_ccode_base_module_generate_method_declaration ((ValaCCodeBaseModule*) self, _tmp98_, _tmp99_);
					}
					_tmp100_ = sig;
					_tmp101_ = vala_signal_get_emitter (_tmp100_);
					_tmp102_ = _tmp101_;
					_tmp103_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp102_, NULL);
					_g_free0 (emitter_func);
					emitter_func = _tmp103_;
				} else {
					ValaTypeSymbol* _tmp104_;
					gchar* _tmp105_;
					gchar* _tmp106_;
					ValaSignal* _tmp107_;
					gchar* _tmp108_;
					gchar* _tmp109_;
					gchar* _tmp110_;
					_tmp104_ = cl;
					_tmp105_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp104_, NULL);
					_tmp106_ = _tmp105_;
					_tmp107_ = sig;
					_tmp108_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp107_, NULL);
					_tmp109_ = _tmp108_;
					_tmp110_ = g_strdup_printf ("%s_%s", _tmp106_, _tmp109_);
					_g_free0 (emitter_func);
					emitter_func = _tmp110_;
					_g_free0 (_tmp109_);
					_g_free0 (_tmp106_);
				}
				_tmp111_ = emitter_func;
				_tmp112_ = vala_ccode_identifier_new (_tmp111_);
				_tmp113_ = _tmp112_;
				_tmp114_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp113_);
				_tmp115_ = _tmp114_;
				_vala_ccode_node_unref0 (_tmp113_);
				ccall = _tmp115_;
				_tmp116_ = ccall;
				_tmp117_ = pub_inst;
				vala_ccode_function_call_add_argument (_tmp116_, _tmp117_);
				_tmp118_ = ccall;
				vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp118_);
				_vala_ccode_node_unref0 (ccall);
				_g_free0 (emitter_func);
			} else {
				ValaCCodeFunctionCall* ccall = NULL;
				ValaCCodeIdentifier* _tmp119_;
				ValaCCodeIdentifier* _tmp120_;
				ValaCCodeFunctionCall* _tmp121_;
				ValaCCodeFunctionCall* _tmp122_;
				ValaCCodeFunctionCall* _tmp123_;
				ValaCCodeExpression* _tmp124_;
				ValaCCodeFunctionCall* _tmp125_;
				ValaSignal* _tmp126_;
				ValaCCodeConstant* _tmp127_;
				ValaCCodeConstant* _tmp128_;
				ValaCCodeFunctionCall* _tmp129_;
				_tmp119_ = vala_ccode_identifier_new ("g_signal_emit_by_name");
				_tmp120_ = _tmp119_;
				_tmp121_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp120_);
				_tmp122_ = _tmp121_;
				_vala_ccode_node_unref0 (_tmp120_);
				ccall = _tmp122_;
				_tmp123_ = ccall;
				_tmp124_ = pub_inst;
				vala_ccode_function_call_add_argument (_tmp123_, _tmp124_);
				_tmp125_ = ccall;
				_tmp126_ = sig;
				_tmp127_ = vala_ccode_base_module_get_signal_canonical_constant ((ValaCCodeBaseModule*) self, _tmp126_, NULL);
				_tmp128_ = _tmp127_;
				vala_ccode_function_call_add_argument (_tmp125_, (ValaCCodeExpression*) _tmp128_);
				_vala_ccode_node_unref0 (_tmp128_);
				_tmp129_ = ccall;
				vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp129_);
				_vala_ccode_node_unref0 (ccall);
			}
		}
		_vala_code_node_unref0 (cl);
		_vala_code_node_unref0 (sig);
		_vala_ccode_node_unref0 (pub_inst);
	} else {
		VALA_CODE_VISITOR_CLASS (vala_gsignal_module_parent_class)->visit_member_access ((ValaCodeVisitor*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_GOBJECT_MODULE, ValaGObjectModule), expr);
	}
}


static void
vala_gsignal_module_real_visit_method_call (ValaCodeVisitor* base, 
                                            ValaMethodCall* expr)
{
	ValaGSignalModule * self;
	ValaMethodType* method_type = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	ValaMethodType* _tmp4_;
	gboolean _tmp5_ = FALSE;
	ValaMethodType* _tmp6_;
	ValaSignal* sig = NULL;
	ValaMethodType* _tmp12_;
	ValaMethod* _tmp13_;
	ValaMethod* _tmp14_;
	ValaSymbol* _tmp15_;
	ValaSymbol* _tmp16_;
	ValaSignal* _tmp17_;
	ValaExpression* signal_access = NULL;
	ValaExpression* _tmp18_;
	ValaExpression* _tmp19_;
	ValaExpression* _tmp20_;
	ValaExpression* _tmp21_;
	ValaExpression* _tmp22_;
	ValaExpression* handler = NULL;
	ValaList* _tmp23_;
	ValaList* _tmp24_;
	gpointer _tmp25_;
	ValaExpression* _tmp26_;
	gboolean disconnect = FALSE;
	ValaMethodType* _tmp27_;
	ValaMethod* _tmp28_;
	ValaMethod* _tmp29_;
	const gchar* _tmp30_;
	const gchar* _tmp31_;
	gboolean after = FALSE;
	ValaMethodType* _tmp32_;
	ValaMethod* _tmp33_;
	ValaMethod* _tmp34_;
	const gchar* _tmp35_;
	const gchar* _tmp36_;
	ValaCCodeExpression* cexpr = NULL;
	ValaSignal* _tmp37_;
	ValaExpression* _tmp38_;
	ValaExpression* _tmp39_;
	gboolean _tmp40_;
	gboolean _tmp41_;
	ValaCCodeExpression* _tmp42_;
	ValaCCodeExpression* _tmp43_;
	self = (ValaGSignalModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_method_call_get_call (expr);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_expression_get_value_type (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, VALA_TYPE_METHOD_TYPE) ? ((ValaMethodType*) _tmp3_) : NULL);
	method_type = _tmp4_;
	_tmp6_ = method_type;
	if (_tmp6_ == NULL) {
		_tmp5_ = TRUE;
	} else {
		ValaMethodType* _tmp7_;
		ValaMethod* _tmp8_;
		ValaMethod* _tmp9_;
		ValaSymbol* _tmp10_;
		ValaSymbol* _tmp11_;
		_tmp7_ = method_type;
		_tmp8_ = vala_method_type_get_method_symbol (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp9_);
		_tmp11_ = _tmp10_;
		_tmp5_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, VALA_TYPE_SIGNAL);
	}
	if (_tmp5_) {
		VALA_CODE_VISITOR_CLASS (vala_gsignal_module_parent_class)->visit_method_call ((ValaCodeVisitor*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_GOBJECT_MODULE, ValaGObjectModule), expr);
		_vala_code_node_unref0 (method_type);
		return;
	}
	_tmp12_ = method_type;
	_tmp13_ = vala_method_type_get_method_symbol (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, VALA_TYPE_SIGNAL, ValaSignal));
	sig = _tmp17_;
	_tmp18_ = vala_method_call_get_call (expr);
	_tmp19_ = _tmp18_;
	_tmp20_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
	_tmp21_ = _tmp20_;
	_tmp22_ = _vala_code_node_ref0 (_tmp21_);
	signal_access = _tmp22_;
	_tmp23_ = vala_method_call_get_argument_list (expr);
	_tmp24_ = _tmp23_;
	_tmp25_ = vala_list_get (_tmp24_, 0);
	_tmp26_ = (ValaExpression*) _tmp25_;
	_vala_iterable_unref0 (_tmp24_);
	handler = _tmp26_;
	_tmp27_ = method_type;
	_tmp28_ = vala_method_type_get_method_symbol (_tmp27_);
	_tmp29_ = _tmp28_;
	_tmp30_ = vala_symbol_get_name ((ValaSymbol*) _tmp29_);
	_tmp31_ = _tmp30_;
	disconnect = g_strcmp0 (_tmp31_, "disconnect") == 0;
	_tmp32_ = method_type;
	_tmp33_ = vala_method_type_get_method_symbol (_tmp32_);
	_tmp34_ = _tmp33_;
	_tmp35_ = vala_symbol_get_name ((ValaSymbol*) _tmp34_);
	_tmp36_ = _tmp35_;
	after = g_strcmp0 (_tmp36_, "connect_after") == 0;
	_tmp37_ = sig;
	_tmp38_ = signal_access;
	_tmp39_ = handler;
	_tmp40_ = disconnect;
	_tmp41_ = after;
	_tmp42_ = vala_gsignal_module_connect_signal (self, _tmp37_, _tmp38_, _tmp39_, _tmp40_, _tmp41_, (ValaCodeNode*) expr);
	cexpr = _tmp42_;
	_tmp43_ = cexpr;
	vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp43_);
	_vala_ccode_node_unref0 (cexpr);
	_vala_code_node_unref0 (handler);
	_vala_code_node_unref0 (signal_access);
	_vala_code_node_unref0 (sig);
	_vala_code_node_unref0 (method_type);
}


static ValaCCodeExpression*
vala_gsignal_module_connect_signal (ValaGSignalModule* self, 
                                    ValaSignal* sig, 
                                    ValaExpression* signal_access, 
                                    ValaExpression* handler, 
                                    gboolean disconnect, 
                                    gboolean after, 
                                    ValaCodeNode* expr)
{
	ValaCCodeExpression* result = NULL;
	gchar* connect_func = NULL;
	ValaDelegateType* dt = NULL;
	ValaParameter* p = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaParameter* _tmp2_;
	ValaParameter* _tmp3_;
	ValaMethod* m = NULL;
	ValaSymbol* _tmp17_;
	ValaSymbol* _tmp18_;
	ValaMethod* _tmp19_;
	ValaCCodeFunctionCall* ccall = NULL;
	const gchar* _tmp44_;
	ValaCCodeIdentifier* _tmp45_;
	ValaCCodeIdentifier* _tmp46_;
	ValaCCodeFunctionCall* _tmp47_;
	ValaCCodeFunctionCall* _tmp48_;
	ValaCCodeExpression* signal_name_cexpr = NULL;
	ValaMemberAccess* ma = NULL;
	ValaMemberAccess* _tmp64_;
	ValaExpression* _tmp65_;
	ValaExpression* _tmp66_;
	ValaCCodeFunctionCall* _tmp159_;
	ValaCCodeExpression* _tmp160_;
	ValaCCodeExpression* _tmp161_;
	ValaCCodeCastExpression* _tmp162_;
	ValaCCodeCastExpression* _tmp163_;
	gboolean _tmp164_ = FALSE;
	ValaMethod* _tmp165_;
	gboolean _tmp241_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sig != NULL, NULL);
	g_return_val_if_fail (signal_access != NULL, NULL);
	g_return_val_if_fail (handler != NULL, NULL);
	g_return_val_if_fail (expr != NULL, NULL);
	dt = NULL;
	_tmp0_ = vala_expression_get_symbol_reference (handler);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_PARAMETER) ? ((ValaParameter*) _tmp1_) : NULL);
	p = _tmp2_;
	_tmp3_ = p;
	if (_tmp3_ != NULL) {
		ValaParameter* _tmp4_;
		ValaDataType* _tmp5_;
		ValaDataType* _tmp6_;
		ValaDelegateType* _tmp7_;
		gboolean _tmp8_ = FALSE;
		ValaDelegateType* _tmp9_;
		_tmp4_ = p;
		_tmp5_ = vala_variable_get_variable_type ((ValaVariable*) _tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, VALA_TYPE_DELEGATE_TYPE) ? ((ValaDelegateType*) _tmp6_) : NULL);
		_vala_code_node_unref0 (dt);
		dt = _tmp7_;
		_tmp9_ = dt;
		if (_tmp9_ != NULL) {
			ValaCodeContext* _tmp10_;
			ValaCodeContext* _tmp11_;
			gboolean _tmp12_;
			gboolean _tmp13_;
			_tmp10_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
			_tmp11_ = _tmp10_;
			_tmp12_ = vala_code_context_get_experimental (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp8_ = !_tmp13_;
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			ValaDelegateType* _tmp14_;
			ValaSourceReference* _tmp15_;
			ValaSourceReference* _tmp16_;
			_tmp14_ = dt;
			_tmp15_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp14_);
			_tmp16_ = _tmp15_;
			vala_report_warning (_tmp16_, "Connecting delegates to signals is experimental");
		}
	}
	_tmp17_ = vala_expression_get_symbol_reference (handler);
	_tmp18_ = _tmp17_;
	_tmp19_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp18_, VALA_TYPE_METHOD) ? ((ValaMethod*) _tmp18_) : NULL);
	m = _tmp19_;
	if (!disconnect) {
		if (G_TYPE_CHECK_INSTANCE_TYPE (sig, VALA_TYPE_DYNAMIC_SIGNAL)) {
			if (!after) {
				gchar* _tmp20_;
				_tmp20_ = vala_ccode_base_module_get_dynamic_signal_connect_wrapper_name ((ValaCCodeBaseModule*) self, G_TYPE_CHECK_INSTANCE_CAST (sig, VALA_TYPE_DYNAMIC_SIGNAL, ValaDynamicSignal));
				_g_free0 (connect_func);
				connect_func = _tmp20_;
			} else {
				gchar* _tmp21_;
				_tmp21_ = vala_ccode_base_module_get_dynamic_signal_connect_after_wrapper_name ((ValaCCodeBaseModule*) self, G_TYPE_CHECK_INSTANCE_CAST (sig, VALA_TYPE_DYNAMIC_SIGNAL, ValaDynamicSignal));
				_g_free0 (connect_func);
				connect_func = _tmp21_;
			}
		} else {
			gboolean _tmp22_ = FALSE;
			gboolean _tmp23_ = FALSE;
			ValaMethod* _tmp24_;
			_tmp24_ = m;
			if (_tmp24_ != NULL) {
				ValaMethod* _tmp25_;
				gboolean _tmp26_;
				gboolean _tmp27_;
				_tmp25_ = m;
				_tmp26_ = vala_method_get_closure (_tmp25_);
				_tmp27_ = _tmp26_;
				_tmp23_ = _tmp27_;
			} else {
				_tmp23_ = FALSE;
			}
			if (_tmp23_) {
				_tmp22_ = TRUE;
			} else {
				gboolean _tmp28_ = FALSE;
				ValaDelegateType* _tmp29_;
				_tmp29_ = dt;
				if (_tmp29_ != NULL) {
					ValaDelegateType* _tmp30_;
					gboolean _tmp31_;
					gboolean _tmp32_;
					_tmp30_ = dt;
					_tmp31_ = vala_data_type_get_value_owned ((ValaDataType*) _tmp30_);
					_tmp32_ = _tmp31_;
					_tmp28_ = _tmp32_;
				} else {
					_tmp28_ = FALSE;
				}
				_tmp22_ = _tmp28_;
			}
			if (_tmp22_) {
				gchar* _tmp33_;
				_tmp33_ = g_strdup ("g_signal_connect_data");
				_g_free0 (connect_func);
				connect_func = _tmp33_;
			} else {
				gboolean _tmp34_ = FALSE;
				ValaMethod* _tmp35_;
				_tmp35_ = m;
				if (_tmp35_ != NULL) {
					ValaMethod* _tmp36_;
					_tmp36_ = m;
					_tmp34_ = vala_gsignal_module_in_gobject_instance (self, _tmp36_);
				} else {
					_tmp34_ = FALSE;
				}
				if (_tmp34_) {
					gchar* _tmp37_;
					_tmp37_ = g_strdup ("g_signal_connect_object");
					_g_free0 (connect_func);
					connect_func = _tmp37_;
				} else {
					if (!after) {
						gchar* _tmp38_;
						_tmp38_ = g_strdup ("g_signal_connect");
						_g_free0 (connect_func);
						connect_func = _tmp38_;
					} else {
						gchar* _tmp39_;
						_tmp39_ = g_strdup ("g_signal_connect_after");
						_g_free0 (connect_func);
						connect_func = _tmp39_;
					}
				}
			}
		}
	} else {
		if (G_TYPE_CHECK_INSTANCE_TYPE (handler, VALA_TYPE_LAMBDA_EXPRESSION)) {
			ValaSourceReference* _tmp40_;
			ValaSourceReference* _tmp41_;
			_tmp40_ = vala_code_node_get_source_reference ((ValaCodeNode*) handler);
			_tmp41_ = _tmp40_;
			vala_report_error (_tmp41_, "Cannot disconnect lambda expression from signal. Use Object.disconnect" \
".");
		}
		if (G_TYPE_CHECK_INSTANCE_TYPE (sig, VALA_TYPE_DYNAMIC_SIGNAL)) {
			gchar* _tmp42_;
			_tmp42_ = vala_ccode_base_module_get_dynamic_signal_disconnect_wrapper_name ((ValaCCodeBaseModule*) self, G_TYPE_CHECK_INSTANCE_CAST (sig, VALA_TYPE_DYNAMIC_SIGNAL, ValaDynamicSignal));
			_g_free0 (connect_func);
			connect_func = _tmp42_;
		} else {
			gchar* _tmp43_;
			_tmp43_ = g_strdup ("g_signal_handlers_disconnect_matched");
			_g_free0 (connect_func);
			connect_func = _tmp43_;
		}
	}
	_tmp44_ = connect_func;
	_tmp45_ = vala_ccode_identifier_new (_tmp44_);
	_tmp46_ = _tmp45_;
	_tmp47_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp46_);
	_tmp48_ = _tmp47_;
	_vala_ccode_node_unref0 (_tmp46_);
	ccall = _tmp48_;
	signal_name_cexpr = NULL;
	if (G_TYPE_CHECK_INSTANCE_TYPE (signal_access, VALA_TYPE_ELEMENT_ACCESS)) {
		ValaElementAccess* ea = NULL;
		ValaElementAccess* _tmp49_;
		ValaElementAccess* _tmp50_;
		ValaExpression* _tmp51_;
		ValaExpression* _tmp52_;
		ValaMemberAccess* _tmp53_;
		ValaExpression* detail_expr = NULL;
		ValaElementAccess* _tmp54_;
		ValaList* _tmp55_;
		ValaList* _tmp56_;
		gpointer _tmp57_;
		ValaExpression* _tmp58_;
		ValaExpression* _tmp59_;
		ValaCCodeExpression* _tmp60_;
		ValaCCodeExpression* _tmp61_;
		_tmp49_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (signal_access, VALA_TYPE_ELEMENT_ACCESS, ValaElementAccess));
		ea = _tmp49_;
		_tmp50_ = ea;
		_tmp51_ = vala_element_access_get_container (_tmp50_);
		_tmp52_ = _tmp51_;
		_tmp53_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp52_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
		_vala_code_node_unref0 (ma);
		ma = _tmp53_;
		_tmp54_ = ea;
		_tmp55_ = vala_element_access_get_indices (_tmp54_);
		_tmp56_ = _tmp55_;
		_tmp57_ = vala_list_get (_tmp56_, 0);
		_tmp58_ = (ValaExpression*) _tmp57_;
		_vala_iterable_unref0 (_tmp56_);
		detail_expr = _tmp58_;
		_tmp59_ = detail_expr;
		_tmp60_ = vala_gsignal_module_get_signal_name_cexpression (self, sig, _tmp59_, expr);
		_vala_ccode_node_unref0 (signal_name_cexpr);
		signal_name_cexpr = _tmp60_;
		_tmp61_ = signal_name_cexpr;
		if (_tmp61_ == NULL) {
			result = NULL;
			_vala_code_node_unref0 (detail_expr);
			_vala_code_node_unref0 (ea);
			_vala_code_node_unref0 (ma);
			_vala_ccode_node_unref0 (signal_name_cexpr);
			_vala_ccode_node_unref0 (ccall);
			_vala_code_node_unref0 (m);
			_vala_code_node_unref0 (p);
			_vala_code_node_unref0 (dt);
			_g_free0 (connect_func);
			return result;
		}
		_vala_code_node_unref0 (detail_expr);
		_vala_code_node_unref0 (ea);
	} else {
		ValaMemberAccess* _tmp62_;
		ValaCCodeExpression* _tmp63_;
		_tmp62_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (signal_access, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
		_vala_code_node_unref0 (ma);
		ma = _tmp62_;
		_tmp63_ = vala_gsignal_module_get_signal_name_cexpression (self, sig, NULL, expr);
		_vala_ccode_node_unref0 (signal_name_cexpr);
		signal_name_cexpr = _tmp63_;
	}
	_tmp64_ = ma;
	_tmp65_ = vala_member_access_get_inner (_tmp64_);
	_tmp66_ = _tmp65_;
	if (_tmp66_ != NULL) {
		ValaCCodeFunctionCall* _tmp67_;
		ValaMemberAccess* _tmp68_;
		ValaExpression* _tmp69_;
		ValaExpression* _tmp70_;
		ValaCCodeExpression* _tmp71_;
		ValaCCodeExpression* _tmp72_;
		_tmp67_ = ccall;
		_tmp68_ = ma;
		_tmp69_ = vala_member_access_get_inner (_tmp68_);
		_tmp70_ = _tmp69_;
		_tmp71_ = vala_ccode_base_module_get_ccodenode ((ValaCCodeBaseModule*) self, _tmp70_);
		_tmp72_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp71_, VALA_TYPE_CCODE_EXPRESSION, ValaCCodeExpression);
		vala_ccode_function_call_add_argument (_tmp67_, _tmp72_);
		_vala_ccode_node_unref0 (_tmp72_);
	} else {
		ValaCCodeFunctionCall* _tmp73_;
		ValaCCodeExpression* _tmp74_;
		ValaCCodeExpression* _tmp75_;
		_tmp73_ = ccall;
		_tmp74_ = vala_ccode_base_module_get_result_cexpression ((ValaCCodeBaseModule*) self, "self");
		_tmp75_ = _tmp74_;
		vala_ccode_function_call_add_argument (_tmp73_, _tmp75_);
		_vala_ccode_node_unref0 (_tmp75_);
	}
	if (G_TYPE_CHECK_INSTANCE_TYPE (sig, VALA_TYPE_DYNAMIC_SIGNAL)) {
		ValaCCodeFunctionCall* _tmp76_;
		gchar* _tmp77_;
		gchar* _tmp78_;
		gchar* _tmp79_;
		gchar* _tmp80_;
		ValaCCodeConstant* _tmp81_;
		ValaCCodeConstant* _tmp82_;
		_tmp76_ = ccall;
		_tmp77_ = vala_get_ccode_name ((ValaCodeNode*) sig);
		_tmp78_ = _tmp77_;
		_tmp79_ = g_strdup_printf ("\"%s\"", _tmp78_);
		_tmp80_ = _tmp79_;
		_tmp81_ = vala_ccode_constant_new (_tmp80_);
		_tmp82_ = _tmp81_;
		vala_ccode_function_call_add_argument (_tmp76_, (ValaCCodeExpression*) _tmp82_);
		_vala_ccode_node_unref0 (_tmp82_);
		_g_free0 (_tmp80_);
		_g_free0 (_tmp78_);
	} else {
		if (!disconnect) {
			ValaCCodeFunctionCall* _tmp83_;
			ValaCCodeExpression* _tmp84_;
			_tmp83_ = ccall;
			_tmp84_ = signal_name_cexpr;
			vala_ccode_function_call_add_argument (_tmp83_, _tmp84_);
		} else {
			ValaLocalVariable* temp_decl = NULL;
			ValaDataType* _tmp91_;
			ValaLocalVariable* _tmp92_;
			ValaLocalVariable* _tmp93_;
			ValaCCodeFunctionCall* parse_call = NULL;
			ValaCCodeIdentifier* _tmp94_;
			ValaCCodeIdentifier* _tmp95_;
			ValaCCodeFunctionCall* _tmp96_;
			ValaCCodeFunctionCall* _tmp97_;
			ValaCCodeFunctionCall* _tmp98_;
			ValaCCodeExpression* _tmp99_;
			ValaTypeSymbol* decl_type = NULL;
			ValaSymbol* _tmp100_;
			ValaSymbol* _tmp101_;
			ValaTypeSymbol* _tmp102_;
			ValaCCodeFunctionCall* _tmp103_;
			ValaTypeSymbol* _tmp104_;
			gchar* _tmp105_;
			gchar* _tmp106_;
			ValaCCodeIdentifier* _tmp107_;
			ValaCCodeIdentifier* _tmp108_;
			ValaCCodeFunctionCall* _tmp109_;
			ValaLocalVariable* _tmp110_;
			const gchar* _tmp111_;
			const gchar* _tmp112_;
			ValaCCodeExpression* _tmp113_;
			ValaCCodeExpression* _tmp114_;
			ValaCCodeUnaryExpression* _tmp115_;
			ValaCCodeUnaryExpression* _tmp116_;
			ValaLocalVariable* detail_temp_decl = NULL;
			ValaCCodeFunction* _tmp137_;
			ValaCCodeFunction* _tmp138_;
			ValaCCodeFunctionCall* _tmp139_;
			ValaCCodeFunctionCall* _tmp140_;
			ValaLocalVariable* _tmp141_;
			const gchar* _tmp142_;
			const gchar* _tmp143_;
			ValaCCodeExpression* _tmp144_;
			ValaCCodeExpression* _tmp145_;
			ValaLocalVariable* _tmp146_;
			ValaCCodeFunctionCall* _tmp156_;
			ValaCCodeConstant* _tmp157_;
			ValaCCodeConstant* _tmp158_;
			if (!G_TYPE_CHECK_INSTANCE_TYPE (signal_access, VALA_TYPE_ELEMENT_ACCESS)) {
				ValaCCodeFunctionCall* _tmp85_;
				ValaCCodeConstant* _tmp86_;
				ValaCCodeConstant* _tmp87_;
				_tmp85_ = ccall;
				_tmp86_ = vala_ccode_constant_new ("G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA");
				_tmp87_ = _tmp86_;
				vala_ccode_function_call_add_argument (_tmp85_, (ValaCCodeExpression*) _tmp87_);
				_vala_ccode_node_unref0 (_tmp87_);
			} else {
				ValaCCodeFunctionCall* _tmp88_;
				ValaCCodeConstant* _tmp89_;
				ValaCCodeConstant* _tmp90_;
				_tmp88_ = ccall;
				_tmp89_ = vala_ccode_constant_new ("G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SI" \
"GNAL_MATCH_DATA");
				_tmp90_ = _tmp89_;
				vala_ccode_function_call_add_argument (_tmp88_, (ValaCCodeExpression*) _tmp90_);
				_vala_ccode_node_unref0 (_tmp90_);
			}
			_tmp91_ = ((ValaCCodeBaseModule*) self)->uint_type;
			_tmp92_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp91_, TRUE, NULL, FALSE);
			temp_decl = _tmp92_;
			_tmp93_ = temp_decl;
			vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp93_);
			_tmp94_ = vala_ccode_identifier_new ("g_signal_parse_name");
			_tmp95_ = _tmp94_;
			_tmp96_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp95_);
			_tmp97_ = _tmp96_;
			_vala_ccode_node_unref0 (_tmp95_);
			parse_call = _tmp97_;
			_tmp98_ = parse_call;
			_tmp99_ = signal_name_cexpr;
			vala_ccode_function_call_add_argument (_tmp98_, _tmp99_);
			_tmp100_ = vala_symbol_get_parent_symbol ((ValaSymbol*) sig);
			_tmp101_ = _tmp100_;
			_tmp102_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp101_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
			decl_type = _tmp102_;
			_tmp103_ = parse_call;
			_tmp104_ = decl_type;
			_tmp105_ = vala_get_ccode_type_id ((ValaCodeNode*) _tmp104_);
			_tmp106_ = _tmp105_;
			_tmp107_ = vala_ccode_identifier_new (_tmp106_);
			_tmp108_ = _tmp107_;
			vala_ccode_function_call_add_argument (_tmp103_, (ValaCCodeExpression*) _tmp108_);
			_vala_ccode_node_unref0 (_tmp108_);
			_g_free0 (_tmp106_);
			_tmp109_ = parse_call;
			_tmp110_ = temp_decl;
			_tmp111_ = vala_symbol_get_name ((ValaSymbol*) _tmp110_);
			_tmp112_ = _tmp111_;
			_tmp113_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp112_);
			_tmp114_ = _tmp113_;
			_tmp115_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp114_);
			_tmp116_ = _tmp115_;
			vala_ccode_function_call_add_argument (_tmp109_, (ValaCCodeExpression*) _tmp116_);
			_vala_ccode_node_unref0 (_tmp116_);
			_vala_ccode_node_unref0 (_tmp114_);
			detail_temp_decl = NULL;
			if (!G_TYPE_CHECK_INSTANCE_TYPE (signal_access, VALA_TYPE_ELEMENT_ACCESS)) {
				ValaCCodeFunctionCall* _tmp117_;
				ValaCCodeConstant* _tmp118_;
				ValaCCodeConstant* _tmp119_;
				ValaCCodeFunctionCall* _tmp120_;
				ValaCCodeConstant* _tmp121_;
				ValaCCodeConstant* _tmp122_;
				_tmp117_ = parse_call;
				_tmp118_ = vala_ccode_constant_new ("NULL");
				_tmp119_ = _tmp118_;
				vala_ccode_function_call_add_argument (_tmp117_, (ValaCCodeExpression*) _tmp119_);
				_vala_ccode_node_unref0 (_tmp119_);
				_tmp120_ = parse_call;
				_tmp121_ = vala_ccode_constant_new ("FALSE");
				_tmp122_ = _tmp121_;
				vala_ccode_function_call_add_argument (_tmp120_, (ValaCCodeExpression*) _tmp122_);
				_vala_ccode_node_unref0 (_tmp122_);
			} else {
				ValaDataType* _tmp123_;
				ValaLocalVariable* _tmp124_;
				ValaLocalVariable* _tmp125_;
				ValaCCodeFunctionCall* _tmp126_;
				ValaLocalVariable* _tmp127_;
				const gchar* _tmp128_;
				const gchar* _tmp129_;
				ValaCCodeExpression* _tmp130_;
				ValaCCodeExpression* _tmp131_;
				ValaCCodeUnaryExpression* _tmp132_;
				ValaCCodeUnaryExpression* _tmp133_;
				ValaCCodeFunctionCall* _tmp134_;
				ValaCCodeConstant* _tmp135_;
				ValaCCodeConstant* _tmp136_;
				_tmp123_ = ((ValaCCodeBaseModule*) self)->gquark_type;
				_tmp124_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp123_, TRUE, NULL, FALSE);
				_vala_code_node_unref0 (detail_temp_decl);
				detail_temp_decl = _tmp124_;
				_tmp125_ = detail_temp_decl;
				vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp125_);
				_tmp126_ = parse_call;
				_tmp127_ = detail_temp_decl;
				_tmp128_ = vala_symbol_get_name ((ValaSymbol*) _tmp127_);
				_tmp129_ = _tmp128_;
				_tmp130_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp129_);
				_tmp131_ = _tmp130_;
				_tmp132_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp131_);
				_tmp133_ = _tmp132_;
				vala_ccode_function_call_add_argument (_tmp126_, (ValaCCodeExpression*) _tmp133_);
				_vala_ccode_node_unref0 (_tmp133_);
				_vala_ccode_node_unref0 (_tmp131_);
				_tmp134_ = parse_call;
				_tmp135_ = vala_ccode_constant_new ("TRUE");
				_tmp136_ = _tmp135_;
				vala_ccode_function_call_add_argument (_tmp134_, (ValaCCodeExpression*) _tmp136_);
				_vala_ccode_node_unref0 (_tmp136_);
			}
			_tmp137_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp138_ = _tmp137_;
			_tmp139_ = parse_call;
			vala_ccode_function_add_expression (_tmp138_, (ValaCCodeExpression*) _tmp139_);
			_tmp140_ = ccall;
			_tmp141_ = temp_decl;
			_tmp142_ = vala_symbol_get_name ((ValaSymbol*) _tmp141_);
			_tmp143_ = _tmp142_;
			_tmp144_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp143_);
			_tmp145_ = _tmp144_;
			vala_ccode_function_call_add_argument (_tmp140_, _tmp145_);
			_vala_ccode_node_unref0 (_tmp145_);
			_tmp146_ = detail_temp_decl;
			if (_tmp146_ == NULL) {
				ValaCCodeFunctionCall* _tmp147_;
				ValaCCodeConstant* _tmp148_;
				ValaCCodeConstant* _tmp149_;
				_tmp147_ = ccall;
				_tmp148_ = vala_ccode_constant_new ("0");
				_tmp149_ = _tmp148_;
				vala_ccode_function_call_add_argument (_tmp147_, (ValaCCodeExpression*) _tmp149_);
				_vala_ccode_node_unref0 (_tmp149_);
			} else {
				ValaCCodeFunctionCall* _tmp150_;
				ValaLocalVariable* _tmp151_;
				const gchar* _tmp152_;
				const gchar* _tmp153_;
				ValaCCodeExpression* _tmp154_;
				ValaCCodeExpression* _tmp155_;
				_tmp150_ = ccall;
				_tmp151_ = detail_temp_decl;
				_tmp152_ = vala_symbol_get_name ((ValaSymbol*) _tmp151_);
				_tmp153_ = _tmp152_;
				_tmp154_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp153_);
				_tmp155_ = _tmp154_;
				vala_ccode_function_call_add_argument (_tmp150_, _tmp155_);
				_vala_ccode_node_unref0 (_tmp155_);
			}
			_tmp156_ = ccall;
			_tmp157_ = vala_ccode_constant_new ("NULL");
			_tmp158_ = _tmp157_;
			vala_ccode_function_call_add_argument (_tmp156_, (ValaCCodeExpression*) _tmp158_);
			_vala_ccode_node_unref0 (_tmp158_);
			_vala_code_node_unref0 (detail_temp_decl);
			_vala_code_node_unref0 (decl_type);
			_vala_ccode_node_unref0 (parse_call);
			_vala_code_node_unref0 (temp_decl);
		}
	}
	_tmp159_ = ccall;
	_tmp160_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, handler);
	_tmp161_ = _tmp160_;
	_tmp162_ = vala_ccode_cast_expression_new (_tmp161_, "GCallback");
	_tmp163_ = _tmp162_;
	vala_ccode_function_call_add_argument (_tmp159_, (ValaCCodeExpression*) _tmp163_);
	_vala_ccode_node_unref0 (_tmp163_);
	_vala_ccode_node_unref0 (_tmp161_);
	_tmp165_ = m;
	if (_tmp165_ != NULL) {
		ValaMethod* _tmp166_;
		gboolean _tmp167_;
		gboolean _tmp168_;
		_tmp166_ = m;
		_tmp167_ = vala_method_get_closure (_tmp166_);
		_tmp168_ = _tmp167_;
		_tmp164_ = _tmp168_;
	} else {
		_tmp164_ = FALSE;
	}
	if (_tmp164_) {
		ValaCCodeExpression* handler_destroy_notify = NULL;
		ValaCCodeFunctionCall* _tmp169_;
		ValaCCodeExpression* _tmp170_ = NULL;
		ValaCCodeExpression* _tmp171_;
		ValaCCodeExpression* _tmp172_;
		ValaCCodeFunctionCall* _tmp173_;
		ValaCCodeExpression* _tmp174_;
		ValaCCodeCastExpression* _tmp175_;
		ValaCCodeCastExpression* _tmp176_;
		_tmp169_ = ccall;
		_tmp171_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, handler, &_tmp170_);
		_vala_ccode_node_unref0 (handler_destroy_notify);
		handler_destroy_notify = _tmp170_;
		_tmp172_ = _tmp171_;
		vala_ccode_function_call_add_argument (_tmp169_, _tmp172_);
		_vala_ccode_node_unref0 (_tmp172_);
		_tmp173_ = ccall;
		_tmp174_ = handler_destroy_notify;
		_tmp175_ = vala_ccode_cast_expression_new (_tmp174_, "GClosureNotify");
		_tmp176_ = _tmp175_;
		vala_ccode_function_call_add_argument (_tmp173_, (ValaCCodeExpression*) _tmp176_);
		_vala_ccode_node_unref0 (_tmp176_);
		if (!after) {
			ValaCCodeFunctionCall* _tmp177_;
			ValaCCodeConstant* _tmp178_;
			ValaCCodeConstant* _tmp179_;
			_tmp177_ = ccall;
			_tmp178_ = vala_ccode_constant_new ("0");
			_tmp179_ = _tmp178_;
			vala_ccode_function_call_add_argument (_tmp177_, (ValaCCodeExpression*) _tmp179_);
			_vala_ccode_node_unref0 (_tmp179_);
		} else {
			ValaCCodeFunctionCall* _tmp180_;
			ValaCCodeConstant* _tmp181_;
			ValaCCodeConstant* _tmp182_;
			_tmp180_ = ccall;
			_tmp181_ = vala_ccode_constant_new ("G_CONNECT_AFTER");
			_tmp182_ = _tmp181_;
			vala_ccode_function_call_add_argument (_tmp180_, (ValaCCodeExpression*) _tmp182_);
			_vala_ccode_node_unref0 (_tmp182_);
		}
		_vala_ccode_node_unref0 (handler_destroy_notify);
	} else {
		gboolean _tmp183_ = FALSE;
		ValaMethod* _tmp184_;
		_tmp184_ = m;
		if (_tmp184_ != NULL) {
			ValaMethod* _tmp185_;
			ValaMemberBinding _tmp186_;
			ValaMemberBinding _tmp187_;
			_tmp185_ = m;
			_tmp186_ = vala_method_get_binding (_tmp185_);
			_tmp187_ = _tmp186_;
			_tmp183_ = _tmp187_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp183_ = FALSE;
		}
		if (_tmp183_) {
			gboolean _tmp204_ = FALSE;
			gboolean _tmp205_ = FALSE;
			if (G_TYPE_CHECK_INSTANCE_TYPE (handler, VALA_TYPE_MEMBER_ACCESS)) {
				ValaMemberAccess* right_ma = NULL;
				ValaMemberAccess* _tmp188_;
				ValaMemberAccess* _tmp189_;
				ValaExpression* _tmp190_;
				ValaExpression* _tmp191_;
				_tmp188_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (handler, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
				right_ma = _tmp188_;
				_tmp189_ = right_ma;
				_tmp190_ = vala_member_access_get_inner (_tmp189_);
				_tmp191_ = _tmp190_;
				if (_tmp191_ != NULL) {
					ValaCCodeFunctionCall* _tmp192_;
					ValaMemberAccess* _tmp193_;
					ValaExpression* _tmp194_;
					ValaExpression* _tmp195_;
					ValaCCodeExpression* _tmp196_;
					ValaCCodeExpression* _tmp197_;
					_tmp192_ = ccall;
					_tmp193_ = right_ma;
					_tmp194_ = vala_member_access_get_inner (_tmp193_);
					_tmp195_ = _tmp194_;
					_tmp196_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp195_);
					_tmp197_ = _tmp196_;
					vala_ccode_function_call_add_argument (_tmp192_, _tmp197_);
					_vala_ccode_node_unref0 (_tmp197_);
				} else {
					ValaCCodeFunctionCall* _tmp198_;
					ValaCCodeExpression* _tmp199_;
					ValaCCodeExpression* _tmp200_;
					_tmp198_ = ccall;
					_tmp199_ = vala_ccode_base_module_get_result_cexpression ((ValaCCodeBaseModule*) self, "self");
					_tmp200_ = _tmp199_;
					vala_ccode_function_call_add_argument (_tmp198_, _tmp200_);
					_vala_ccode_node_unref0 (_tmp200_);
				}
				_vala_code_node_unref0 (right_ma);
			} else {
				if (G_TYPE_CHECK_INSTANCE_TYPE (handler, VALA_TYPE_LAMBDA_EXPRESSION)) {
					ValaCCodeFunctionCall* _tmp201_;
					ValaCCodeExpression* _tmp202_;
					ValaCCodeExpression* _tmp203_;
					_tmp201_ = ccall;
					_tmp202_ = vala_ccode_base_module_get_result_cexpression ((ValaCCodeBaseModule*) self, "self");
					_tmp203_ = _tmp202_;
					vala_ccode_function_call_add_argument (_tmp201_, _tmp203_);
					_vala_ccode_node_unref0 (_tmp203_);
				}
			}
			if (!disconnect) {
				_tmp205_ = !G_TYPE_CHECK_INSTANCE_TYPE (sig, VALA_TYPE_DYNAMIC_SIGNAL);
			} else {
				_tmp205_ = FALSE;
			}
			if (_tmp205_) {
				ValaMethod* _tmp206_;
				_tmp206_ = m;
				_tmp204_ = vala_gsignal_module_in_gobject_instance (self, _tmp206_);
			} else {
				_tmp204_ = FALSE;
			}
			if (_tmp204_) {
				if (!after) {
					ValaCCodeFunctionCall* _tmp207_;
					ValaCCodeConstant* _tmp208_;
					ValaCCodeConstant* _tmp209_;
					_tmp207_ = ccall;
					_tmp208_ = vala_ccode_constant_new ("0");
					_tmp209_ = _tmp208_;
					vala_ccode_function_call_add_argument (_tmp207_, (ValaCCodeExpression*) _tmp209_);
					_vala_ccode_node_unref0 (_tmp209_);
				} else {
					ValaCCodeFunctionCall* _tmp210_;
					ValaCCodeConstant* _tmp211_;
					ValaCCodeConstant* _tmp212_;
					_tmp210_ = ccall;
					_tmp211_ = vala_ccode_constant_new ("G_CONNECT_AFTER");
					_tmp212_ = _tmp211_;
					vala_ccode_function_call_add_argument (_tmp210_, (ValaCCodeExpression*) _tmp212_);
					_vala_ccode_node_unref0 (_tmp212_);
				}
			}
		} else {
			gboolean _tmp213_ = FALSE;
			ValaDelegateType* _tmp214_;
			_tmp214_ = dt;
			if (_tmp214_ != NULL) {
				ValaDelegateType* _tmp215_;
				ValaDelegate* _tmp216_;
				ValaDelegate* _tmp217_;
				gboolean _tmp218_;
				gboolean _tmp219_;
				_tmp215_ = dt;
				_tmp216_ = vala_delegate_type_get_delegate_symbol (_tmp215_);
				_tmp217_ = _tmp216_;
				_tmp218_ = vala_delegate_get_has_target (_tmp217_);
				_tmp219_ = _tmp218_;
				_tmp213_ = _tmp219_;
			} else {
				_tmp213_ = FALSE;
			}
			if (_tmp213_) {
				ValaCCodeExpression* handler_destroy_notify = NULL;
				ValaCCodeFunctionCall* _tmp220_;
				ValaCCodeExpression* _tmp221_ = NULL;
				ValaCCodeExpression* _tmp222_;
				ValaCCodeExpression* _tmp223_;
				gboolean _tmp224_ = FALSE;
				_tmp220_ = ccall;
				_tmp222_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, handler, &_tmp221_);
				_vala_ccode_node_unref0 (handler_destroy_notify);
				handler_destroy_notify = _tmp221_;
				_tmp223_ = _tmp222_;
				vala_ccode_function_call_add_argument (_tmp220_, _tmp223_);
				_vala_ccode_node_unref0 (_tmp223_);
				if (!disconnect) {
					ValaDelegateType* _tmp225_;
					gboolean _tmp226_;
					gboolean _tmp227_;
					_tmp225_ = dt;
					_tmp226_ = vala_data_type_get_value_owned ((ValaDataType*) _tmp225_);
					_tmp227_ = _tmp226_;
					_tmp224_ = _tmp227_;
				} else {
					_tmp224_ = FALSE;
				}
				if (_tmp224_) {
					ValaCCodeFunctionCall* _tmp228_;
					ValaCCodeExpression* _tmp229_;
					ValaCCodeCastExpression* _tmp230_;
					ValaCCodeCastExpression* _tmp231_;
					_tmp228_ = ccall;
					_tmp229_ = handler_destroy_notify;
					_tmp230_ = vala_ccode_cast_expression_new (_tmp229_, "GClosureNotify");
					_tmp231_ = _tmp230_;
					vala_ccode_function_call_add_argument (_tmp228_, (ValaCCodeExpression*) _tmp231_);
					_vala_ccode_node_unref0 (_tmp231_);
					if (!after) {
						ValaCCodeFunctionCall* _tmp232_;
						ValaCCodeConstant* _tmp233_;
						ValaCCodeConstant* _tmp234_;
						_tmp232_ = ccall;
						_tmp233_ = vala_ccode_constant_new ("0");
						_tmp234_ = _tmp233_;
						vala_ccode_function_call_add_argument (_tmp232_, (ValaCCodeExpression*) _tmp234_);
						_vala_ccode_node_unref0 (_tmp234_);
					} else {
						ValaCCodeFunctionCall* _tmp235_;
						ValaCCodeConstant* _tmp236_;
						ValaCCodeConstant* _tmp237_;
						_tmp235_ = ccall;
						_tmp236_ = vala_ccode_constant_new ("G_CONNECT_AFTER");
						_tmp237_ = _tmp236_;
						vala_ccode_function_call_add_argument (_tmp235_, (ValaCCodeExpression*) _tmp237_);
						_vala_ccode_node_unref0 (_tmp237_);
					}
				}
				_vala_ccode_node_unref0 (handler_destroy_notify);
			} else {
				ValaCCodeFunctionCall* _tmp238_;
				ValaCCodeConstant* _tmp239_;
				ValaCCodeConstant* _tmp240_;
				_tmp238_ = ccall;
				_tmp239_ = vala_ccode_constant_new ("NULL");
				_tmp240_ = _tmp239_;
				vala_ccode_function_call_add_argument (_tmp238_, (ValaCCodeExpression*) _tmp240_);
				_vala_ccode_node_unref0 (_tmp240_);
			}
		}
	}
	if (disconnect) {
		_tmp241_ = TRUE;
	} else {
		ValaCodeNode* _tmp242_;
		ValaCodeNode* _tmp243_;
		_tmp242_ = vala_code_node_get_parent_node (expr);
		_tmp243_ = _tmp242_;
		_tmp241_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp243_, VALA_TYPE_EXPRESSION_STATEMENT);
	}
	if (_tmp241_) {
		ValaCCodeFunction* _tmp244_;
		ValaCCodeFunction* _tmp245_;
		ValaCCodeFunctionCall* _tmp246_;
		_tmp244_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp245_ = _tmp244_;
		_tmp246_ = ccall;
		vala_ccode_function_add_expression (_tmp245_, (ValaCCodeExpression*) _tmp246_);
		result = NULL;
		_vala_code_node_unref0 (ma);
		_vala_ccode_node_unref0 (signal_name_cexpr);
		_vala_ccode_node_unref0 (ccall);
		_vala_code_node_unref0 (m);
		_vala_code_node_unref0 (p);
		_vala_code_node_unref0 (dt);
		_g_free0 (connect_func);
		return result;
	} else {
		ValaLocalVariable* temp_var = NULL;
		ValaDataType* _tmp247_;
		ValaLocalVariable* _tmp248_;
		ValaCCodeExpression* temp_ref = NULL;
		ValaLocalVariable* _tmp249_;
		const gchar* _tmp250_;
		const gchar* _tmp251_;
		ValaCCodeExpression* _tmp252_;
		ValaLocalVariable* _tmp253_;
		ValaCCodeFunction* _tmp254_;
		ValaCCodeFunction* _tmp255_;
		ValaCCodeExpression* _tmp256_;
		ValaCCodeFunctionCall* _tmp257_;
		_tmp247_ = ((ValaCCodeBaseModule*) self)->ulong_type;
		_tmp248_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp247_, TRUE, NULL, FALSE);
		temp_var = _tmp248_;
		_tmp249_ = temp_var;
		_tmp250_ = vala_symbol_get_name ((ValaSymbol*) _tmp249_);
		_tmp251_ = _tmp250_;
		_tmp252_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp251_);
		temp_ref = _tmp252_;
		_tmp253_ = temp_var;
		vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp253_);
		_tmp254_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp255_ = _tmp254_;
		_tmp256_ = temp_ref;
		_tmp257_ = ccall;
		vala_ccode_function_add_assignment (_tmp255_, _tmp256_, (ValaCCodeExpression*) _tmp257_);
		result = temp_ref;
		_vala_code_node_unref0 (temp_var);
		_vala_code_node_unref0 (ma);
		_vala_ccode_node_unref0 (signal_name_cexpr);
		_vala_ccode_node_unref0 (ccall);
		_vala_code_node_unref0 (m);
		_vala_code_node_unref0 (p);
		_vala_code_node_unref0 (dt);
		_g_free0 (connect_func);
		return result;
	}
	_vala_code_node_unref0 (ma);
	_vala_ccode_node_unref0 (signal_name_cexpr);
	_vala_ccode_node_unref0 (ccall);
	_vala_code_node_unref0 (m);
	_vala_code_node_unref0 (p);
	_vala_code_node_unref0 (dt);
	_g_free0 (connect_func);
}


ValaGSignalModule*
vala_gsignal_module_construct (GType object_type)
{
	ValaGSignalModule* self = NULL;
	self = (ValaGSignalModule*) vala_gobject_module_construct (object_type);
	return self;
}


ValaGSignalModule*
vala_gsignal_module_new (void)
{
	return vala_gsignal_module_construct (VALA_TYPE_GSIGNAL_MODULE);
}


static void
vala_gsignal_module_class_init (ValaGSignalModuleClass * klass)
{
	vala_gsignal_module_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeVisitorClass *) klass)->visit_signal = (void (*) (ValaCodeVisitor *, ValaSignal*)) vala_gsignal_module_real_visit_signal;
	((ValaCCodeBaseModuleClass *) klass)->get_signal_creation = (ValaCCodeExpression* (*) (ValaCCodeBaseModule *, ValaSignal*, ValaTypeSymbol*)) vala_gsignal_module_real_get_signal_creation;
	((ValaCodeVisitorClass *) klass)->visit_element_access = (void (*) (ValaCodeVisitor *, ValaElementAccess*)) vala_gsignal_module_real_visit_element_access;
	((ValaCodeVisitorClass *) klass)->visit_assignment = (void (*) (ValaCodeVisitor *, ValaAssignment*)) vala_gsignal_module_real_visit_assignment;
	((ValaCodeVisitorClass *) klass)->visit_member_access = (void (*) (ValaCodeVisitor *, ValaMemberAccess*)) vala_gsignal_module_real_visit_member_access;
	((ValaCodeVisitorClass *) klass)->visit_method_call = (void (*) (ValaCodeVisitor *, ValaMethodCall*)) vala_gsignal_module_real_visit_method_call;
}


static void
vala_gsignal_module_instance_init (ValaGSignalModule * self)
{
}


GType
vala_gsignal_module_get_type (void)
{
	static volatile gsize vala_gsignal_module_type_id__volatile = 0;
	if (g_once_init_enter (&vala_gsignal_module_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaGSignalModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gsignal_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGSignalModule), 0, (GInstanceInitFunc) vala_gsignal_module_instance_init, NULL };
		GType vala_gsignal_module_type_id;
		vala_gsignal_module_type_id = g_type_register_static (VALA_TYPE_GOBJECT_MODULE, "ValaGSignalModule", &g_define_type_info, 0);
		g_once_init_leave (&vala_gsignal_module_type_id__volatile, vala_gsignal_module_type_id);
	}
	return vala_gsignal_module_type_id__volatile;
}


static void
_vala_array_destroy (gpointer array, 
                     gint array_length, 
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array, 
                  gint array_length, 
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



