/* valagdbusmodule.c generated by valac, the Vala compiler
 * generated from valagdbusmodule.vala, do not modify */

/* valagdbusmodule.vala
 *
 * Copyright (C) 2010-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include "valacodegen.h"
#include <vala.h>
#include <stdlib.h>
#include <string.h>
#include <valaccode.h>
#include <valagee.h>

enum  {
	VALA_GD_BUS_MODULE_0_PROPERTY,
	VALA_GD_BUS_MODULE_NUM_PROPERTIES
};
static GParamSpec* vala_gd_bus_module_properties[VALA_GD_BUS_MODULE_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_ccode_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))


static gpointer vala_gd_bus_module_parent_class = NULL;

static void vala_gd_bus_module_real_visit_error_domain (ValaCodeVisitor* base, 
                                                 ValaErrorDomain* edomain);
static gboolean vala_gd_bus_module_is_file_descriptor (ValaGDBusModule* self, 
                                                ValaDataType* type);
static ValaCCodeExpression* vala_gd_bus_module_get_file_descriptor (ValaGDBusModule* self, 
                                                             ValaDataType* type, 
                                                             ValaCCodeExpression* expr);
static ValaCCodeExpression* vala_gd_bus_module_create_from_file_descriptor (ValaGDBusModule* self, 
                                                                     ValaDataType* type, 
                                                                     ValaCCodeExpression* expr);
static ValaCCodeExpression* vala_gd_bus_module_get_method_info (ValaGDBusModule* self, 
                                                         ValaObjectTypeSymbol* sym);
static ValaCCodeExpression* vala_gd_bus_module_get_signal_info (ValaGDBusModule* self, 
                                                         ValaObjectTypeSymbol* sym);
static ValaCCodeExpression* vala_gd_bus_module_get_property_info (ValaGDBusModule* self, 
                                                           ValaObjectTypeSymbol* sym);
static void vala_gd_bus_module_declare_interface_info (ValaGDBusModule* self, 
                                                ValaObjectTypeSymbol* sym);
static void vala_gd_bus_module_real_visit_class (ValaCodeVisitor* base, 
                                          ValaClass* cl);
static void vala_gd_bus_module_visit_object_type_symbol (ValaGDBusModule* self, 
                                                  ValaObjectTypeSymbol* sym);
static void vala_gd_bus_module_real_visit_interface (ValaCodeVisitor* base, 
                                              ValaInterface* iface);


gchar*
vala_gd_bus_module_get_dbus_name (ValaTypeSymbol* symbol)
{
	gchar* result = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (symbol != NULL, NULL);
	_tmp0_ = vala_code_node_get_attribute_string ((ValaCodeNode*) symbol, "DBus", "name", NULL);
	result = _tmp0_;
	return result;
}


gchar*
vala_gd_bus_module_get_dbus_name_for_member (ValaSymbol* symbol)
{
	gchar* result = NULL;
	gchar* dbus_name = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_val_if_fail (symbol != NULL, NULL);
	_tmp0_ = vala_code_node_get_attribute_string ((ValaCodeNode*) symbol, "DBus", "name", NULL);
	dbus_name = _tmp0_;
	_tmp1_ = dbus_name;
	if (_tmp1_ != NULL) {
		result = dbus_name;
		return result;
	}
	_tmp2_ = vala_symbol_get_name (symbol);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_symbol_lower_case_to_camel_case (_tmp3_);
	result = _tmp4_;
	_g_free0 (dbus_name);
	return result;
}


gint
vala_gd_bus_module_get_dbus_timeout_for_member (ValaSymbol* symbol)
{
	gint result = 0;
	g_return_val_if_fail (symbol != NULL, 0);
	result = vala_code_node_get_attribute_integer ((ValaCodeNode*) symbol, "DBus", "timeout", -1);
	return result;
}


gboolean
vala_gd_bus_module_is_dbus_visible (ValaCodeNode* node)
{
	gboolean result = FALSE;
	ValaAttribute* dbus_attribute = NULL;
	ValaAttribute* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	ValaAttribute* _tmp3_;
	g_return_val_if_fail (node != NULL, FALSE);
	_tmp0_ = vala_code_node_get_attribute (node, "DBus");
	dbus_attribute = _tmp0_;
	_tmp3_ = dbus_attribute;
	if (_tmp3_ != NULL) {
		ValaAttribute* _tmp4_;
		_tmp4_ = dbus_attribute;
		_tmp2_ = vala_attribute_has_argument (_tmp4_, "visible");
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		ValaAttribute* _tmp5_;
		_tmp5_ = dbus_attribute;
		_tmp1_ = !vala_attribute_get_bool (_tmp5_, "visible", FALSE);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		result = FALSE;
		_vala_code_node_unref0 (dbus_attribute);
		return result;
	}
	result = TRUE;
	_vala_code_node_unref0 (dbus_attribute);
	return result;
}


gboolean
vala_gd_bus_module_is_dbus_no_reply (ValaMethod* m)
{
	gboolean result = FALSE;
	g_return_val_if_fail (m != NULL, FALSE);
	result = vala_code_node_get_attribute_bool ((ValaCodeNode*) m, "DBus", "no_reply", FALSE);
	return result;
}


gchar*
vala_gd_bus_module_dbus_result_name (ValaMethod* m)
{
	gchar* result = NULL;
	gchar* dbus_name = NULL;
	gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	gchar* _tmp4_;
	g_return_val_if_fail (m != NULL, NULL);
	_tmp0_ = vala_code_node_get_attribute_string ((ValaCodeNode*) m, "DBus", "result", NULL);
	dbus_name = _tmp0_;
	_tmp2_ = dbus_name;
	if (_tmp2_ != NULL) {
		const gchar* _tmp3_;
		_tmp3_ = dbus_name;
		_tmp1_ = g_strcmp0 (_tmp3_, "") != 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		result = dbus_name;
		return result;
	}
	_tmp4_ = g_strdup ("result");
	result = _tmp4_;
	_g_free0 (dbus_name);
	return result;
}


static void
vala_gd_bus_module_real_visit_error_domain (ValaCodeVisitor* base, 
                                            ValaErrorDomain* edomain)
{
	ValaGDBusModule * self;
	gchar* edomain_dbus_name = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	ValaCCodeFile* _tmp2_;
	ValaCCodeFile* _tmp3_;
	ValaCCodeInitializerList* error_entries = NULL;
	ValaCCodeInitializerList* _tmp6_;
	ValaCCodeDeclaration* _cdecl_ = NULL;
	ValaCCodeDeclaration* _tmp42_;
	ValaCCodeDeclaration* _tmp43_;
	gchar* _tmp44_;
	gchar* _tmp45_;
	gchar* _tmp46_;
	gchar* _tmp47_;
	ValaCCodeInitializerList* _tmp48_;
	ValaCCodeVariableDeclarator* _tmp49_;
	ValaCCodeVariableDeclarator* _tmp50_;
	ValaCCodeDeclaration* _tmp51_;
	ValaCCodeFile* _tmp52_;
	ValaCCodeDeclaration* _tmp53_;
	gchar* quark_fun_name = NULL;
	gchar* _tmp54_;
	gchar* _tmp55_;
	gchar* _tmp56_;
	gchar* _tmp57_;
	ValaCCodeFunction* cquark_fun = NULL;
	const gchar* _tmp58_;
	ValaDataType* _tmp59_;
	ValaTypeSymbol* _tmp60_;
	ValaTypeSymbol* _tmp61_;
	gchar* _tmp62_;
	gchar* _tmp63_;
	ValaCCodeFunction* _tmp64_;
	ValaCCodeFunction* _tmp65_;
	ValaCCodeFunction* _tmp66_;
	gchar* quark_name = NULL;
	gchar* _tmp67_;
	gchar* _tmp68_;
	gchar* _tmp69_;
	gchar* _tmp70_;
	ValaCCodeFunction* _tmp71_;
	ValaCCodeFunction* _tmp72_;
	const gchar* _tmp73_;
	ValaCCodeConstant* _tmp74_;
	ValaCCodeConstant* _tmp75_;
	ValaCCodeVariableDeclarator* _tmp76_;
	ValaCCodeVariableDeclarator* _tmp77_;
	ValaCCodeFunctionCall* register_call = NULL;
	ValaCCodeIdentifier* _tmp78_;
	ValaCCodeIdentifier* _tmp79_;
	ValaCCodeFunctionCall* _tmp80_;
	ValaCCodeFunctionCall* _tmp81_;
	ValaCCodeFunctionCall* _tmp82_;
	gchar* _tmp83_;
	gchar* _tmp84_;
	gchar* _tmp85_;
	gchar* _tmp86_;
	gchar* _tmp87_;
	gchar* _tmp88_;
	ValaCCodeConstant* _tmp89_;
	ValaCCodeConstant* _tmp90_;
	ValaCCodeFunctionCall* _tmp91_;
	const gchar* _tmp92_;
	ValaCCodeIdentifier* _tmp93_;
	ValaCCodeIdentifier* _tmp94_;
	ValaCCodeUnaryExpression* _tmp95_;
	ValaCCodeUnaryExpression* _tmp96_;
	ValaCCodeFunctionCall* _tmp97_;
	gchar* _tmp98_;
	gchar* _tmp99_;
	gchar* _tmp100_;
	gchar* _tmp101_;
	ValaCCodeIdentifier* _tmp102_;
	ValaCCodeIdentifier* _tmp103_;
	ValaCCodeFunctionCall* nentries = NULL;
	ValaCCodeIdentifier* _tmp104_;
	ValaCCodeIdentifier* _tmp105_;
	ValaCCodeFunctionCall* _tmp106_;
	ValaCCodeFunctionCall* _tmp107_;
	ValaCCodeFunctionCall* _tmp108_;
	gchar* _tmp109_;
	gchar* _tmp110_;
	gchar* _tmp111_;
	gchar* _tmp112_;
	ValaCCodeIdentifier* _tmp113_;
	ValaCCodeIdentifier* _tmp114_;
	ValaCCodeFunctionCall* _tmp115_;
	ValaCCodeFunctionCall* _tmp116_;
	ValaCCodeFunction* _tmp117_;
	ValaCCodeFunction* _tmp118_;
	ValaCCodeFunctionCall* _tmp119_;
	ValaCCodeFunction* _tmp120_;
	ValaCCodeFunction* _tmp121_;
	const gchar* _tmp122_;
	ValaCCodeIdentifier* _tmp123_;
	ValaCCodeIdentifier* _tmp124_;
	ValaCCodeCastExpression* _tmp125_;
	ValaCCodeCastExpression* _tmp126_;
	ValaCCodeFile* _tmp127_;
	ValaCCodeFunction* _tmp128_;
	self = (ValaGDBusModule*) base;
	g_return_if_fail (edomain != NULL);
	_tmp0_ = vala_gd_bus_module_get_dbus_name ((ValaTypeSymbol*) edomain);
	edomain_dbus_name = _tmp0_;
	_tmp1_ = edomain_dbus_name;
	if (_tmp1_ == NULL) {
		VALA_CODE_VISITOR_CLASS (vala_gd_bus_module_parent_class)->visit_error_domain ((ValaCodeVisitor*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_GVARIANT_MODULE, ValaGVariantModule), edomain);
		_g_free0 (edomain_dbus_name);
		return;
	}
	_tmp2_ = ((ValaCCodeBaseModule*) self)->cfile;
	vala_ccode_file_add_include (_tmp2_, "gio/gio.h", FALSE);
	_tmp3_ = ((ValaCCodeBaseModule*) self)->cfile;
	vala_ccode_base_module_generate_error_domain_declaration ((ValaCCodeBaseModule*) self, edomain, _tmp3_);
	if (!vala_symbol_is_internal_symbol ((ValaSymbol*) edomain)) {
		ValaCCodeFile* _tmp4_;
		_tmp4_ = ((ValaCCodeBaseModule*) self)->header_file;
		vala_ccode_base_module_generate_error_domain_declaration ((ValaCCodeBaseModule*) self, edomain, _tmp4_);
	}
	if (!vala_symbol_is_private_symbol ((ValaSymbol*) edomain)) {
		ValaCCodeFile* _tmp5_;
		_tmp5_ = ((ValaCCodeBaseModule*) self)->internal_header_file;
		vala_ccode_base_module_generate_error_domain_declaration ((ValaCCodeBaseModule*) self, edomain, _tmp5_);
	}
	_tmp6_ = vala_ccode_initializer_list_new ();
	error_entries = _tmp6_;
	{
		ValaList* _ecode_list = NULL;
		ValaList* _tmp7_;
		gint _ecode_size = 0;
		ValaList* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gint _ecode_index = 0;
		_tmp7_ = vala_error_domain_get_codes (edomain);
		_ecode_list = _tmp7_;
		_tmp8_ = _ecode_list;
		_tmp9_ = vala_collection_get_size ((ValaCollection*) _tmp8_);
		_tmp10_ = _tmp9_;
		_ecode_size = _tmp10_;
		_ecode_index = -1;
		while (TRUE) {
			gint _tmp11_;
			gint _tmp12_;
			gint _tmp13_;
			ValaErrorCode* ecode = NULL;
			ValaList* _tmp14_;
			gint _tmp15_;
			gpointer _tmp16_;
			gchar* ecode_dbus_name = NULL;
			ValaErrorCode* _tmp17_;
			gchar* _tmp18_;
			const gchar* _tmp19_;
			ValaCCodeInitializerList* error_entry = NULL;
			ValaCCodeInitializerList* _tmp26_;
			ValaCCodeInitializerList* _tmp27_;
			ValaErrorCode* _tmp28_;
			gchar* _tmp29_;
			gchar* _tmp30_;
			ValaCCodeIdentifier* _tmp31_;
			ValaCCodeIdentifier* _tmp32_;
			ValaCCodeInitializerList* _tmp33_;
			const gchar* _tmp34_;
			const gchar* _tmp35_;
			gchar* _tmp36_;
			gchar* _tmp37_;
			ValaCCodeConstant* _tmp38_;
			ValaCCodeConstant* _tmp39_;
			ValaCCodeInitializerList* _tmp40_;
			ValaCCodeInitializerList* _tmp41_;
			_tmp11_ = _ecode_index;
			_ecode_index = _tmp11_ + 1;
			_tmp12_ = _ecode_index;
			_tmp13_ = _ecode_size;
			if (!(_tmp12_ < _tmp13_)) {
				break;
			}
			_tmp14_ = _ecode_list;
			_tmp15_ = _ecode_index;
			_tmp16_ = vala_list_get (_tmp14_, _tmp15_);
			ecode = (ValaErrorCode*) _tmp16_;
			_tmp17_ = ecode;
			_tmp18_ = vala_gd_bus_module_get_dbus_name ((ValaTypeSymbol*) _tmp17_);
			ecode_dbus_name = _tmp18_;
			_tmp19_ = ecode_dbus_name;
			if (_tmp19_ == NULL) {
				ValaErrorCode* _tmp20_;
				const gchar* _tmp21_;
				const gchar* _tmp22_;
				gchar* _tmp23_;
				gchar* _tmp24_;
				gchar* _tmp25_;
				_tmp20_ = ecode;
				_tmp21_ = vala_symbol_get_name ((ValaSymbol*) _tmp20_);
				_tmp22_ = _tmp21_;
				_tmp23_ = g_utf8_strdown (_tmp22_, (gssize) -1);
				_tmp24_ = _tmp23_;
				_tmp25_ = vala_symbol_lower_case_to_camel_case (_tmp24_);
				_g_free0 (ecode_dbus_name);
				ecode_dbus_name = _tmp25_;
				_g_free0 (_tmp24_);
			}
			_tmp26_ = vala_ccode_initializer_list_new ();
			error_entry = _tmp26_;
			_tmp27_ = error_entry;
			_tmp28_ = ecode;
			_tmp29_ = vala_get_ccode_name ((ValaCodeNode*) _tmp28_);
			_tmp30_ = _tmp29_;
			_tmp31_ = vala_ccode_identifier_new (_tmp30_);
			_tmp32_ = _tmp31_;
			vala_ccode_initializer_list_append (_tmp27_, (ValaCCodeExpression*) _tmp32_);
			_vala_ccode_node_unref0 (_tmp32_);
			_g_free0 (_tmp30_);
			_tmp33_ = error_entry;
			_tmp34_ = edomain_dbus_name;
			_tmp35_ = ecode_dbus_name;
			_tmp36_ = g_strdup_printf ("\"%s.%s\"", _tmp34_, _tmp35_);
			_tmp37_ = _tmp36_;
			_tmp38_ = vala_ccode_constant_new (_tmp37_);
			_tmp39_ = _tmp38_;
			vala_ccode_initializer_list_append (_tmp33_, (ValaCCodeExpression*) _tmp39_);
			_vala_ccode_node_unref0 (_tmp39_);
			_g_free0 (_tmp37_);
			_tmp40_ = error_entries;
			_tmp41_ = error_entry;
			vala_ccode_initializer_list_append (_tmp40_, (ValaCCodeExpression*) _tmp41_);
			_vala_ccode_node_unref0 (error_entry);
			_g_free0 (ecode_dbus_name);
			_vala_code_node_unref0 (ecode);
		}
		_vala_iterable_unref0 (_ecode_list);
	}
	_tmp42_ = vala_ccode_declaration_new ("const GDBusErrorEntry");
	_cdecl_ = _tmp42_;
	_tmp43_ = _cdecl_;
	_tmp44_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) edomain, NULL);
	_tmp45_ = _tmp44_;
	_tmp46_ = g_strconcat (_tmp45_, "_entries[]", NULL);
	_tmp47_ = _tmp46_;
	_tmp48_ = error_entries;
	_tmp49_ = vala_ccode_variable_declarator_new (_tmp47_, (ValaCCodeExpression*) _tmp48_, NULL);
	_tmp50_ = _tmp49_;
	vala_ccode_declaration_add_declarator (_tmp43_, (ValaCCodeDeclarator*) _tmp50_);
	_vala_ccode_node_unref0 (_tmp50_);
	_g_free0 (_tmp47_);
	_g_free0 (_tmp45_);
	_tmp51_ = _cdecl_;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp51_, VALA_CCODE_MODIFIERS_STATIC);
	_tmp52_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp53_ = _cdecl_;
	vala_ccode_file_add_constant_declaration (_tmp52_, (ValaCCodeNode*) _tmp53_);
	_tmp54_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) edomain);
	_tmp55_ = _tmp54_;
	_tmp56_ = g_strconcat (_tmp55_, "quark", NULL);
	_tmp57_ = _tmp56_;
	_g_free0 (_tmp55_);
	quark_fun_name = _tmp57_;
	_tmp58_ = quark_fun_name;
	_tmp59_ = ((ValaCCodeBaseModule*) self)->gquark_type;
	_tmp60_ = vala_data_type_get_data_type (_tmp59_);
	_tmp61_ = _tmp60_;
	_tmp62_ = vala_get_ccode_name ((ValaCodeNode*) _tmp61_);
	_tmp63_ = _tmp62_;
	_tmp64_ = vala_ccode_function_new (_tmp58_, _tmp63_);
	_tmp65_ = _tmp64_;
	_g_free0 (_tmp63_);
	cquark_fun = _tmp65_;
	_tmp66_ = cquark_fun;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp66_);
	_tmp67_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) edomain);
	_tmp68_ = _tmp67_;
	_tmp69_ = g_strdup_printf ("%squark_volatile", _tmp68_);
	_tmp70_ = _tmp69_;
	_g_free0 (_tmp68_);
	quark_name = _tmp70_;
	_tmp71_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp72_ = _tmp71_;
	_tmp73_ = quark_name;
	_tmp74_ = vala_ccode_constant_new ("0");
	_tmp75_ = _tmp74_;
	_tmp76_ = vala_ccode_variable_declarator_new (_tmp73_, (ValaCCodeExpression*) _tmp75_, NULL);
	_tmp77_ = _tmp76_;
	vala_ccode_function_add_declaration (_tmp72_, "gsize", (ValaCCodeDeclarator*) _tmp77_, VALA_CCODE_MODIFIERS_STATIC | VALA_CCODE_MODIFIERS_VOLATILE);
	_vala_ccode_node_unref0 (_tmp77_);
	_vala_ccode_node_unref0 (_tmp75_);
	_tmp78_ = vala_ccode_identifier_new ("g_dbus_error_register_error_domain");
	_tmp79_ = _tmp78_;
	_tmp80_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp79_);
	_tmp81_ = _tmp80_;
	_vala_ccode_node_unref0 (_tmp79_);
	register_call = _tmp81_;
	_tmp82_ = register_call;
	_tmp83_ = vala_get_ccode_quark_name (edomain);
	_tmp84_ = _tmp83_;
	_tmp85_ = g_strconcat ("\"", _tmp84_, NULL);
	_tmp86_ = _tmp85_;
	_tmp87_ = g_strconcat (_tmp86_, "\"", NULL);
	_tmp88_ = _tmp87_;
	_tmp89_ = vala_ccode_constant_new (_tmp88_);
	_tmp90_ = _tmp89_;
	vala_ccode_function_call_add_argument (_tmp82_, (ValaCCodeExpression*) _tmp90_);
	_vala_ccode_node_unref0 (_tmp90_);
	_g_free0 (_tmp88_);
	_g_free0 (_tmp86_);
	_g_free0 (_tmp84_);
	_tmp91_ = register_call;
	_tmp92_ = quark_name;
	_tmp93_ = vala_ccode_identifier_new (_tmp92_);
	_tmp94_ = _tmp93_;
	_tmp95_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp94_);
	_tmp96_ = _tmp95_;
	vala_ccode_function_call_add_argument (_tmp91_, (ValaCCodeExpression*) _tmp96_);
	_vala_ccode_node_unref0 (_tmp96_);
	_vala_ccode_node_unref0 (_tmp94_);
	_tmp97_ = register_call;
	_tmp98_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) edomain, NULL);
	_tmp99_ = _tmp98_;
	_tmp100_ = g_strconcat (_tmp99_, "_entries", NULL);
	_tmp101_ = _tmp100_;
	_tmp102_ = vala_ccode_identifier_new (_tmp101_);
	_tmp103_ = _tmp102_;
	vala_ccode_function_call_add_argument (_tmp97_, (ValaCCodeExpression*) _tmp103_);
	_vala_ccode_node_unref0 (_tmp103_);
	_g_free0 (_tmp101_);
	_g_free0 (_tmp99_);
	_tmp104_ = vala_ccode_identifier_new ("G_N_ELEMENTS");
	_tmp105_ = _tmp104_;
	_tmp106_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp105_);
	_tmp107_ = _tmp106_;
	_vala_ccode_node_unref0 (_tmp105_);
	nentries = _tmp107_;
	_tmp108_ = nentries;
	_tmp109_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) edomain, NULL);
	_tmp110_ = _tmp109_;
	_tmp111_ = g_strconcat (_tmp110_, "_entries", NULL);
	_tmp112_ = _tmp111_;
	_tmp113_ = vala_ccode_identifier_new (_tmp112_);
	_tmp114_ = _tmp113_;
	vala_ccode_function_call_add_argument (_tmp108_, (ValaCCodeExpression*) _tmp114_);
	_vala_ccode_node_unref0 (_tmp114_);
	_g_free0 (_tmp112_);
	_g_free0 (_tmp110_);
	_tmp115_ = register_call;
	_tmp116_ = nentries;
	vala_ccode_function_call_add_argument (_tmp115_, (ValaCCodeExpression*) _tmp116_);
	_tmp117_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp118_ = _tmp117_;
	_tmp119_ = register_call;
	vala_ccode_function_add_expression (_tmp118_, (ValaCCodeExpression*) _tmp119_);
	_tmp120_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp121_ = _tmp120_;
	_tmp122_ = quark_name;
	_tmp123_ = vala_ccode_identifier_new (_tmp122_);
	_tmp124_ = _tmp123_;
	_tmp125_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp124_, "GQuark");
	_tmp126_ = _tmp125_;
	vala_ccode_function_add_return (_tmp121_, (ValaCCodeExpression*) _tmp126_);
	_vala_ccode_node_unref0 (_tmp126_);
	_vala_ccode_node_unref0 (_tmp124_);
	vala_ccode_base_module_pop_function ((ValaCCodeBaseModule*) self);
	_tmp127_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp128_ = cquark_fun;
	vala_ccode_file_add_function (_tmp127_, _tmp128_);
	_vala_ccode_node_unref0 (nentries);
	_vala_ccode_node_unref0 (register_call);
	_g_free0 (quark_name);
	_vala_ccode_node_unref0 (cquark_fun);
	_g_free0 (quark_fun_name);
	_vala_ccode_node_unref0 (_cdecl_);
	_vala_ccode_node_unref0 (error_entries);
	_g_free0 (edomain_dbus_name);
}


static gboolean
vala_gd_bus_module_is_file_descriptor (ValaGDBusModule* self, 
                                       ValaDataType* type)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (type != NULL, FALSE);
	if (G_TYPE_CHECK_INSTANCE_TYPE (type, VALA_TYPE_OBJECT_TYPE)) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_ = FALSE;
		ValaTypeSymbol* _tmp3_;
		ValaTypeSymbol* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gboolean _tmp7_;
		_tmp3_ = vala_data_type_get_data_type (type);
		_tmp4_ = _tmp3_;
		_tmp5_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_strcmp0 (_tmp6_, "GLib.UnixInputStream") == 0;
		_g_free0 (_tmp6_);
		if (_tmp7_) {
			_tmp2_ = TRUE;
		} else {
			ValaTypeSymbol* _tmp8_;
			ValaTypeSymbol* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			_tmp8_ = vala_data_type_get_data_type (type);
			_tmp9_ = _tmp8_;
			_tmp10_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp9_);
			_tmp11_ = _tmp10_;
			_tmp2_ = g_strcmp0 (_tmp11_, "GLib.UnixOutputStream") == 0;
			_g_free0 (_tmp11_);
		}
		if (_tmp2_) {
			_tmp1_ = TRUE;
		} else {
			ValaTypeSymbol* _tmp12_;
			ValaTypeSymbol* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			_tmp12_ = vala_data_type_get_data_type (type);
			_tmp13_ = _tmp12_;
			_tmp14_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp13_);
			_tmp15_ = _tmp14_;
			_tmp1_ = g_strcmp0 (_tmp15_, "GLib.Socket") == 0;
			_g_free0 (_tmp15_);
		}
		if (_tmp1_) {
			_tmp0_ = TRUE;
		} else {
			ValaTypeSymbol* _tmp16_;
			ValaTypeSymbol* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			_tmp16_ = vala_data_type_get_data_type (type);
			_tmp17_ = _tmp16_;
			_tmp18_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp17_);
			_tmp19_ = _tmp18_;
			_tmp0_ = g_strcmp0 (_tmp19_, "GLib.FileDescriptorBased") == 0;
			_g_free0 (_tmp19_);
		}
		if (_tmp0_) {
			result = TRUE;
			return result;
		}
	}
	result = FALSE;
	return result;
}


gboolean
vala_gd_bus_module_dbus_method_uses_file_descriptor (ValaGDBusModule* self, 
                                                     ValaMethod* method)
{
	gboolean result = FALSE;
	ValaDataType* _tmp13_;
	ValaDataType* _tmp14_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (method != NULL, FALSE);
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp0_;
		gint _param_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _param_index = 0;
		_tmp0_ = vala_callable_get_parameters ((ValaCallable*) method);
		_param_list = _tmp0_;
		_tmp1_ = _param_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_param_size = _tmp3_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			gint _tmp6_;
			ValaParameter* param = NULL;
			ValaList* _tmp7_;
			gint _tmp8_;
			gpointer _tmp9_;
			ValaParameter* _tmp10_;
			ValaDataType* _tmp11_;
			ValaDataType* _tmp12_;
			_tmp4_ = _param_index;
			_param_index = _tmp4_ + 1;
			_tmp5_ = _param_index;
			_tmp6_ = _param_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _param_list;
			_tmp8_ = _param_index;
			_tmp9_ = vala_list_get (_tmp7_, _tmp8_);
			param = (ValaParameter*) _tmp9_;
			_tmp10_ = param;
			_tmp11_ = vala_variable_get_variable_type ((ValaVariable*) _tmp10_);
			_tmp12_ = _tmp11_;
			if (vala_gd_bus_module_is_file_descriptor (self, _tmp12_)) {
				result = TRUE;
				_vala_code_node_unref0 (param);
				_vala_iterable_unref0 (_param_list);
				return result;
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp13_ = vala_callable_get_return_type ((ValaCallable*) method);
	_tmp14_ = _tmp13_;
	if (vala_gd_bus_module_is_file_descriptor (self, _tmp14_)) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static ValaCCodeExpression*
vala_gd_bus_module_get_file_descriptor (ValaGDBusModule* self, 
                                        ValaDataType* type, 
                                        ValaCCodeExpression* expr)
{
	ValaCCodeExpression* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	g_return_val_if_fail (expr != NULL, NULL);
	if (G_TYPE_CHECK_INSTANCE_TYPE (type, VALA_TYPE_OBJECT_TYPE)) {
		ValaTypeSymbol* _tmp0_;
		ValaTypeSymbol* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gboolean _tmp4_;
		_tmp0_ = vala_data_type_get_data_type (type);
		_tmp1_ = _tmp0_;
		_tmp2_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_strcmp0 (_tmp3_, "GLib.UnixInputStream") == 0;
		_g_free0 (_tmp3_);
		if (_tmp4_) {
			ValaCCodeFunctionCall* _result_ = NULL;
			ValaCCodeIdentifier* _tmp5_;
			ValaCCodeIdentifier* _tmp6_;
			ValaCCodeFunctionCall* _tmp7_;
			ValaCCodeFunctionCall* _tmp8_;
			ValaCCodeFunctionCall* _tmp9_;
			_tmp5_ = vala_ccode_identifier_new ("g_unix_input_stream_get_fd");
			_tmp6_ = _tmp5_;
			_tmp7_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp6_);
			_tmp8_ = _tmp7_;
			_vala_ccode_node_unref0 (_tmp6_);
			_result_ = _tmp8_;
			_tmp9_ = _result_;
			vala_ccode_function_call_add_argument (_tmp9_, expr);
			result = (ValaCCodeExpression*) _result_;
			return result;
		} else {
			ValaTypeSymbol* _tmp10_;
			ValaTypeSymbol* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			gboolean _tmp14_;
			_tmp10_ = vala_data_type_get_data_type (type);
			_tmp11_ = _tmp10_;
			_tmp12_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = g_strcmp0 (_tmp13_, "GLib.UnixOutputStream") == 0;
			_g_free0 (_tmp13_);
			if (_tmp14_) {
				ValaCCodeFunctionCall* _result_ = NULL;
				ValaCCodeIdentifier* _tmp15_;
				ValaCCodeIdentifier* _tmp16_;
				ValaCCodeFunctionCall* _tmp17_;
				ValaCCodeFunctionCall* _tmp18_;
				ValaCCodeFunctionCall* _tmp19_;
				_tmp15_ = vala_ccode_identifier_new ("g_unix_output_stream_get_fd");
				_tmp16_ = _tmp15_;
				_tmp17_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp16_);
				_tmp18_ = _tmp17_;
				_vala_ccode_node_unref0 (_tmp16_);
				_result_ = _tmp18_;
				_tmp19_ = _result_;
				vala_ccode_function_call_add_argument (_tmp19_, expr);
				result = (ValaCCodeExpression*) _result_;
				return result;
			} else {
				ValaTypeSymbol* _tmp20_;
				ValaTypeSymbol* _tmp21_;
				gchar* _tmp22_;
				gchar* _tmp23_;
				gboolean _tmp24_;
				_tmp20_ = vala_data_type_get_data_type (type);
				_tmp21_ = _tmp20_;
				_tmp22_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp21_);
				_tmp23_ = _tmp22_;
				_tmp24_ = g_strcmp0 (_tmp23_, "GLib.Socket") == 0;
				_g_free0 (_tmp23_);
				if (_tmp24_) {
					ValaCCodeFunctionCall* _result_ = NULL;
					ValaCCodeIdentifier* _tmp25_;
					ValaCCodeIdentifier* _tmp26_;
					ValaCCodeFunctionCall* _tmp27_;
					ValaCCodeFunctionCall* _tmp28_;
					ValaCCodeFunctionCall* _tmp29_;
					_tmp25_ = vala_ccode_identifier_new ("g_socket_get_fd");
					_tmp26_ = _tmp25_;
					_tmp27_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp26_);
					_tmp28_ = _tmp27_;
					_vala_ccode_node_unref0 (_tmp26_);
					_result_ = _tmp28_;
					_tmp29_ = _result_;
					vala_ccode_function_call_add_argument (_tmp29_, expr);
					result = (ValaCCodeExpression*) _result_;
					return result;
				} else {
					ValaTypeSymbol* _tmp30_;
					ValaTypeSymbol* _tmp31_;
					gchar* _tmp32_;
					gchar* _tmp33_;
					gboolean _tmp34_;
					_tmp30_ = vala_data_type_get_data_type (type);
					_tmp31_ = _tmp30_;
					_tmp32_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp31_);
					_tmp33_ = _tmp32_;
					_tmp34_ = g_strcmp0 (_tmp33_, "GLib.FileDescriptorBased") == 0;
					_g_free0 (_tmp33_);
					if (_tmp34_) {
						ValaCCodeFunctionCall* _result_ = NULL;
						ValaCCodeIdentifier* _tmp35_;
						ValaCCodeIdentifier* _tmp36_;
						ValaCCodeFunctionCall* _tmp37_;
						ValaCCodeFunctionCall* _tmp38_;
						ValaCCodeFunctionCall* _tmp39_;
						_tmp35_ = vala_ccode_identifier_new ("g_file_descriptor_based_get_fd");
						_tmp36_ = _tmp35_;
						_tmp37_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp36_);
						_tmp38_ = _tmp37_;
						_vala_ccode_node_unref0 (_tmp36_);
						_result_ = _tmp38_;
						_tmp39_ = _result_;
						vala_ccode_function_call_add_argument (_tmp39_, expr);
						result = (ValaCCodeExpression*) _result_;
						return result;
					}
				}
			}
		}
	}
	result = NULL;
	return result;
}


void
vala_gd_bus_module_send_dbus_value (ValaGDBusModule* self, 
                                    ValaDataType* type, 
                                    ValaCCodeExpression* builder_expr, 
                                    ValaCCodeExpression* expr, 
                                    ValaSymbol* sym)
{
	ValaCCodeExpression* fd = NULL;
	ValaCCodeExpression* _tmp0_;
	ValaCCodeExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	g_return_if_fail (builder_expr != NULL);
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_gd_bus_module_get_file_descriptor (self, type, expr);
	fd = _tmp0_;
	_tmp1_ = fd;
	if (_tmp1_ != NULL) {
		ValaCCodeFunctionCall* fd_append = NULL;
		ValaCCodeIdentifier* _tmp2_;
		ValaCCodeIdentifier* _tmp3_;
		ValaCCodeFunctionCall* _tmp4_;
		ValaCCodeFunctionCall* _tmp5_;
		ValaCCodeFunctionCall* _tmp6_;
		ValaCCodeIdentifier* _tmp7_;
		ValaCCodeIdentifier* _tmp8_;
		ValaCCodeFunctionCall* _tmp9_;
		ValaCCodeExpression* _tmp10_;
		ValaCCodeFunctionCall* _tmp11_;
		ValaCCodeConstant* _tmp12_;
		ValaCCodeConstant* _tmp13_;
		ValaCCodeFunctionCall* builder_add = NULL;
		ValaCCodeIdentifier* _tmp14_;
		ValaCCodeIdentifier* _tmp15_;
		ValaCCodeFunctionCall* _tmp16_;
		ValaCCodeFunctionCall* _tmp17_;
		ValaCCodeFunctionCall* _tmp18_;
		ValaCCodeUnaryExpression* _tmp19_;
		ValaCCodeUnaryExpression* _tmp20_;
		ValaCCodeFunctionCall* _tmp21_;
		ValaCCodeConstant* _tmp22_;
		ValaCCodeConstant* _tmp23_;
		ValaCCodeFunctionCall* _tmp24_;
		ValaCCodeFunctionCall* _tmp25_;
		ValaCCodeFunction* _tmp26_;
		ValaCCodeFunction* _tmp27_;
		ValaCCodeFunctionCall* _tmp28_;
		_tmp2_ = vala_ccode_identifier_new ("g_unix_fd_list_append");
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp3_);
		_tmp5_ = _tmp4_;
		_vala_ccode_node_unref0 (_tmp3_);
		fd_append = _tmp5_;
		_tmp6_ = fd_append;
		_tmp7_ = vala_ccode_identifier_new ("_fd_list");
		_tmp8_ = _tmp7_;
		vala_ccode_function_call_add_argument (_tmp6_, (ValaCCodeExpression*) _tmp8_);
		_vala_ccode_node_unref0 (_tmp8_);
		_tmp9_ = fd_append;
		_tmp10_ = fd;
		vala_ccode_function_call_add_argument (_tmp9_, _tmp10_);
		_tmp11_ = fd_append;
		_tmp12_ = vala_ccode_constant_new ("NULL");
		_tmp13_ = _tmp12_;
		vala_ccode_function_call_add_argument (_tmp11_, (ValaCCodeExpression*) _tmp13_);
		_vala_ccode_node_unref0 (_tmp13_);
		_tmp14_ = vala_ccode_identifier_new ("g_variant_builder_add");
		_tmp15_ = _tmp14_;
		_tmp16_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp15_);
		_tmp17_ = _tmp16_;
		_vala_ccode_node_unref0 (_tmp15_);
		builder_add = _tmp17_;
		_tmp18_ = builder_add;
		_tmp19_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, builder_expr);
		_tmp20_ = _tmp19_;
		vala_ccode_function_call_add_argument (_tmp18_, (ValaCCodeExpression*) _tmp20_);
		_vala_ccode_node_unref0 (_tmp20_);
		_tmp21_ = builder_add;
		_tmp22_ = vala_ccode_constant_new ("\"h\"");
		_tmp23_ = _tmp22_;
		vala_ccode_function_call_add_argument (_tmp21_, (ValaCCodeExpression*) _tmp23_);
		_vala_ccode_node_unref0 (_tmp23_);
		_tmp24_ = builder_add;
		_tmp25_ = fd_append;
		vala_ccode_function_call_add_argument (_tmp24_, (ValaCCodeExpression*) _tmp25_);
		_tmp26_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp27_ = _tmp26_;
		_tmp28_ = builder_add;
		vala_ccode_function_add_expression (_tmp27_, (ValaCCodeExpression*) _tmp28_);
		_vala_ccode_node_unref0 (builder_add);
		_vala_ccode_node_unref0 (fd_append);
	} else {
		vala_gvariant_module_write_expression ((ValaGVariantModule*) self, type, builder_expr, expr, sym);
	}
	_vala_ccode_node_unref0 (fd);
}


static ValaCCodeExpression*
vala_gd_bus_module_create_from_file_descriptor (ValaGDBusModule* self, 
                                                ValaDataType* type, 
                                                ValaCCodeExpression* expr)
{
	ValaCCodeExpression* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	g_return_val_if_fail (expr != NULL, NULL);
	if (G_TYPE_CHECK_INSTANCE_TYPE (type, VALA_TYPE_OBJECT_TYPE)) {
		ValaTypeSymbol* _tmp0_;
		ValaTypeSymbol* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gboolean _tmp4_;
		_tmp0_ = vala_data_type_get_data_type (type);
		_tmp1_ = _tmp0_;
		_tmp2_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_strcmp0 (_tmp3_, "GLib.UnixInputStream") == 0;
		_g_free0 (_tmp3_);
		if (_tmp4_) {
			ValaCCodeFunctionCall* _result_ = NULL;
			ValaCCodeIdentifier* _tmp5_;
			ValaCCodeIdentifier* _tmp6_;
			ValaCCodeFunctionCall* _tmp7_;
			ValaCCodeFunctionCall* _tmp8_;
			ValaCCodeFunctionCall* _tmp9_;
			ValaCCodeFunctionCall* _tmp10_;
			ValaCCodeConstant* _tmp11_;
			ValaCCodeConstant* _tmp12_;
			ValaCCodeFunctionCall* _tmp13_;
			ValaCCodeCastExpression* _tmp14_;
			_tmp5_ = vala_ccode_identifier_new ("g_unix_input_stream_new");
			_tmp6_ = _tmp5_;
			_tmp7_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp6_);
			_tmp8_ = _tmp7_;
			_vala_ccode_node_unref0 (_tmp6_);
			_result_ = _tmp8_;
			_tmp9_ = _result_;
			vala_ccode_function_call_add_argument (_tmp9_, expr);
			_tmp10_ = _result_;
			_tmp11_ = vala_ccode_constant_new ("TRUE");
			_tmp12_ = _tmp11_;
			vala_ccode_function_call_add_argument (_tmp10_, (ValaCCodeExpression*) _tmp12_);
			_vala_ccode_node_unref0 (_tmp12_);
			_tmp13_ = _result_;
			_tmp14_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp13_, "GUnixInputStream *");
			result = (ValaCCodeExpression*) _tmp14_;
			_vala_ccode_node_unref0 (_result_);
			return result;
		} else {
			ValaTypeSymbol* _tmp15_;
			ValaTypeSymbol* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			gboolean _tmp19_;
			_tmp15_ = vala_data_type_get_data_type (type);
			_tmp16_ = _tmp15_;
			_tmp17_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = g_strcmp0 (_tmp18_, "GLib.UnixOutputStream") == 0;
			_g_free0 (_tmp18_);
			if (_tmp19_) {
				ValaCCodeFunctionCall* _result_ = NULL;
				ValaCCodeIdentifier* _tmp20_;
				ValaCCodeIdentifier* _tmp21_;
				ValaCCodeFunctionCall* _tmp22_;
				ValaCCodeFunctionCall* _tmp23_;
				ValaCCodeFunctionCall* _tmp24_;
				ValaCCodeFunctionCall* _tmp25_;
				ValaCCodeConstant* _tmp26_;
				ValaCCodeConstant* _tmp27_;
				ValaCCodeFunctionCall* _tmp28_;
				ValaCCodeCastExpression* _tmp29_;
				_tmp20_ = vala_ccode_identifier_new ("g_unix_output_stream_new");
				_tmp21_ = _tmp20_;
				_tmp22_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp21_);
				_tmp23_ = _tmp22_;
				_vala_ccode_node_unref0 (_tmp21_);
				_result_ = _tmp23_;
				_tmp24_ = _result_;
				vala_ccode_function_call_add_argument (_tmp24_, expr);
				_tmp25_ = _result_;
				_tmp26_ = vala_ccode_constant_new ("TRUE");
				_tmp27_ = _tmp26_;
				vala_ccode_function_call_add_argument (_tmp25_, (ValaCCodeExpression*) _tmp27_);
				_vala_ccode_node_unref0 (_tmp27_);
				_tmp28_ = _result_;
				_tmp29_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp28_, "GUnixOutputStream *");
				result = (ValaCCodeExpression*) _tmp29_;
				_vala_ccode_node_unref0 (_result_);
				return result;
			} else {
				ValaTypeSymbol* _tmp30_;
				ValaTypeSymbol* _tmp31_;
				gchar* _tmp32_;
				gchar* _tmp33_;
				gboolean _tmp34_;
				_tmp30_ = vala_data_type_get_data_type (type);
				_tmp31_ = _tmp30_;
				_tmp32_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp31_);
				_tmp33_ = _tmp32_;
				_tmp34_ = g_strcmp0 (_tmp33_, "GLib.Socket") == 0;
				_g_free0 (_tmp33_);
				if (_tmp34_) {
					ValaCCodeFunctionCall* _result_ = NULL;
					ValaCCodeIdentifier* _tmp35_;
					ValaCCodeIdentifier* _tmp36_;
					ValaCCodeFunctionCall* _tmp37_;
					ValaCCodeFunctionCall* _tmp38_;
					ValaCCodeFunctionCall* _tmp39_;
					ValaCCodeFunctionCall* _tmp40_;
					ValaCCodeConstant* _tmp41_;
					ValaCCodeConstant* _tmp42_;
					_tmp35_ = vala_ccode_identifier_new ("g_socket_new_from_fd");
					_tmp36_ = _tmp35_;
					_tmp37_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp36_);
					_tmp38_ = _tmp37_;
					_vala_ccode_node_unref0 (_tmp36_);
					_result_ = _tmp38_;
					_tmp39_ = _result_;
					vala_ccode_function_call_add_argument (_tmp39_, expr);
					_tmp40_ = _result_;
					_tmp41_ = vala_ccode_constant_new ("NULL");
					_tmp42_ = _tmp41_;
					vala_ccode_function_call_add_argument (_tmp40_, (ValaCCodeExpression*) _tmp42_);
					_vala_ccode_node_unref0 (_tmp42_);
					result = (ValaCCodeExpression*) _result_;
					return result;
				}
			}
		}
	}
	result = NULL;
	return result;
}


void
vala_gd_bus_module_receive_dbus_value (ValaGDBusModule* self, 
                                       ValaDataType* type, 
                                       ValaCCodeExpression* message_expr, 
                                       ValaCCodeExpression* iter_expr, 
                                       ValaCCodeExpression* target_expr, 
                                       ValaSymbol* sym, 
                                       ValaCCodeExpression* error_expr, 
                                       gboolean* may_fail)
{
	gboolean _vala_may_fail = FALSE;
	ValaCCodeFunctionCall* fd_list = NULL;
	ValaCCodeIdentifier* _tmp0_;
	ValaCCodeIdentifier* _tmp1_;
	ValaCCodeFunctionCall* _tmp2_;
	ValaCCodeFunctionCall* _tmp3_;
	ValaCCodeFunctionCall* _tmp4_;
	ValaCCodeIdentifier* fd_var = NULL;
	ValaCCodeIdentifier* _tmp5_;
	ValaCCodeExpression* stream = NULL;
	ValaCCodeIdentifier* _tmp6_;
	ValaCCodeExpression* _tmp7_;
	ValaCCodeExpression* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	g_return_if_fail (message_expr != NULL);
	g_return_if_fail (iter_expr != NULL);
	g_return_if_fail (target_expr != NULL);
	_tmp0_ = vala_ccode_identifier_new ("g_dbus_message_get_unix_fd_list");
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1_);
	_tmp3_ = _tmp2_;
	_vala_ccode_node_unref0 (_tmp1_);
	fd_list = _tmp3_;
	_tmp4_ = fd_list;
	vala_ccode_function_call_add_argument (_tmp4_, message_expr);
	_tmp5_ = vala_ccode_identifier_new ("_fd");
	fd_var = _tmp5_;
	_tmp6_ = fd_var;
	_tmp7_ = vala_gd_bus_module_create_from_file_descriptor (self, type, (ValaCCodeExpression*) _tmp6_);
	stream = _tmp7_;
	_tmp8_ = stream;
	if (_tmp8_ != NULL) {
		ValaCCodeIdentifier* fd_list_var = NULL;
		ValaCCodeIdentifier* _tmp9_;
		ValaCCodeFunctionCall* fd = NULL;
		ValaCCodeIdentifier* _tmp10_;
		ValaCCodeIdentifier* _tmp11_;
		ValaCCodeFunctionCall* _tmp12_;
		ValaCCodeFunctionCall* _tmp13_;
		ValaCCodeFunctionCall* _tmp14_;
		ValaCCodeIdentifier* _tmp15_;
		ValaCCodeFunctionCall* _tmp16_;
		ValaCCodeIdentifier* _tmp17_;
		ValaCCodeIdentifier* _tmp18_;
		ValaCCodeFunctionCall* _tmp19_;
		ValaCCodeFunction* _tmp20_;
		ValaCCodeFunction* _tmp21_;
		ValaCCodeIdentifier* _tmp22_;
		ValaCCodeFunctionCall* _tmp23_;
		ValaCCodeFunction* _tmp24_;
		ValaCCodeFunction* _tmp25_;
		ValaCCodeIdentifier* _tmp26_;
		ValaCCodeFunctionCall* get_fd = NULL;
		ValaCCodeIdentifier* _tmp27_;
		ValaCCodeIdentifier* _tmp28_;
		ValaCCodeFunctionCall* _tmp29_;
		ValaCCodeFunctionCall* _tmp30_;
		ValaCCodeFunctionCall* _tmp31_;
		ValaCCodeUnaryExpression* _tmp32_;
		ValaCCodeUnaryExpression* _tmp33_;
		ValaCCodeFunctionCall* _tmp34_;
		ValaCCodeConstant* _tmp35_;
		ValaCCodeConstant* _tmp36_;
		ValaCCodeFunctionCall* _tmp37_;
		ValaCCodeIdentifier* _tmp38_;
		ValaCCodeIdentifier* _tmp39_;
		ValaCCodeUnaryExpression* _tmp40_;
		ValaCCodeUnaryExpression* _tmp41_;
		ValaCCodeFunction* _tmp42_;
		ValaCCodeFunction* _tmp43_;
		ValaCCodeFunctionCall* _tmp44_;
		ValaCCodeFunction* _tmp45_;
		ValaCCodeFunction* _tmp46_;
		ValaCCodeIdentifier* _tmp47_;
		ValaCCodeFunctionCall* _tmp48_;
		ValaCCodeFunction* _tmp49_;
		ValaCCodeFunction* _tmp50_;
		ValaCCodeIdentifier* _tmp51_;
		ValaCCodeConstant* _tmp52_;
		ValaCCodeConstant* _tmp53_;
		ValaCCodeBinaryExpression* _tmp54_;
		ValaCCodeBinaryExpression* _tmp55_;
		ValaCCodeFunction* _tmp56_;
		ValaCCodeFunction* _tmp57_;
		ValaCCodeExpression* _tmp58_;
		ValaCCodeFunction* _tmp59_;
		ValaCCodeFunction* _tmp60_;
		ValaCCodeFunction* _tmp61_;
		ValaCCodeFunction* _tmp62_;
		ValaCCodeFunctionCall* set_error = NULL;
		ValaCCodeIdentifier* _tmp63_;
		ValaCCodeIdentifier* _tmp64_;
		ValaCCodeFunctionCall* _tmp65_;
		ValaCCodeFunctionCall* _tmp66_;
		ValaCCodeFunctionCall* _tmp67_;
		ValaCCodeFunctionCall* _tmp68_;
		ValaCCodeIdentifier* _tmp69_;
		ValaCCodeIdentifier* _tmp70_;
		ValaCCodeFunctionCall* _tmp71_;
		ValaCCodeIdentifier* _tmp72_;
		ValaCCodeIdentifier* _tmp73_;
		ValaCCodeFunctionCall* _tmp74_;
		ValaCCodeConstant* _tmp75_;
		ValaCCodeConstant* _tmp76_;
		ValaCCodeFunction* _tmp77_;
		ValaCCodeFunction* _tmp78_;
		ValaCCodeFunctionCall* _tmp79_;
		ValaCCodeFunction* _tmp80_;
		ValaCCodeFunction* _tmp81_;
		_tmp9_ = vala_ccode_identifier_new ("_fd_list");
		fd_list_var = _tmp9_;
		_tmp10_ = vala_ccode_identifier_new ("g_unix_fd_list_get");
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp11_);
		_tmp13_ = _tmp12_;
		_vala_ccode_node_unref0 (_tmp11_);
		fd = _tmp13_;
		_tmp14_ = fd;
		_tmp15_ = fd_list_var;
		vala_ccode_function_call_add_argument (_tmp14_, (ValaCCodeExpression*) _tmp15_);
		_tmp16_ = fd;
		_tmp17_ = vala_ccode_identifier_new ("_fd_index");
		_tmp18_ = _tmp17_;
		vala_ccode_function_call_add_argument (_tmp16_, (ValaCCodeExpression*) _tmp18_);
		_vala_ccode_node_unref0 (_tmp18_);
		_tmp19_ = fd;
		vala_ccode_function_call_add_argument (_tmp19_, error_expr);
		_tmp20_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp21_ = _tmp20_;
		_tmp22_ = fd_list_var;
		_tmp23_ = fd_list;
		vala_ccode_function_add_assignment (_tmp21_, (ValaCCodeExpression*) _tmp22_, (ValaCCodeExpression*) _tmp23_);
		_tmp24_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp25_ = _tmp24_;
		_tmp26_ = fd_list_var;
		vala_ccode_function_open_if (_tmp25_, (ValaCCodeExpression*) _tmp26_);
		_tmp27_ = vala_ccode_identifier_new ("g_variant_iter_next");
		_tmp28_ = _tmp27_;
		_tmp29_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp28_);
		_tmp30_ = _tmp29_;
		_vala_ccode_node_unref0 (_tmp28_);
		get_fd = _tmp30_;
		_tmp31_ = get_fd;
		_tmp32_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, iter_expr);
		_tmp33_ = _tmp32_;
		vala_ccode_function_call_add_argument (_tmp31_, (ValaCCodeExpression*) _tmp33_);
		_vala_ccode_node_unref0 (_tmp33_);
		_tmp34_ = get_fd;
		_tmp35_ = vala_ccode_constant_new ("\"h\"");
		_tmp36_ = _tmp35_;
		vala_ccode_function_call_add_argument (_tmp34_, (ValaCCodeExpression*) _tmp36_);
		_vala_ccode_node_unref0 (_tmp36_);
		_tmp37_ = get_fd;
		_tmp38_ = vala_ccode_identifier_new ("_fd_index");
		_tmp39_ = _tmp38_;
		_tmp40_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp39_);
		_tmp41_ = _tmp40_;
		vala_ccode_function_call_add_argument (_tmp37_, (ValaCCodeExpression*) _tmp41_);
		_vala_ccode_node_unref0 (_tmp41_);
		_vala_ccode_node_unref0 (_tmp39_);
		_tmp42_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp43_ = _tmp42_;
		_tmp44_ = get_fd;
		vala_ccode_function_add_expression (_tmp43_, (ValaCCodeExpression*) _tmp44_);
		_tmp45_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp46_ = _tmp45_;
		_tmp47_ = fd_var;
		_tmp48_ = fd;
		vala_ccode_function_add_assignment (_tmp46_, (ValaCCodeExpression*) _tmp47_, (ValaCCodeExpression*) _tmp48_);
		_tmp49_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp50_ = _tmp49_;
		_tmp51_ = fd_var;
		_tmp52_ = vala_ccode_constant_new ("0");
		_tmp53_ = _tmp52_;
		_tmp54_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_GREATER_THAN_OR_EQUAL, (ValaCCodeExpression*) _tmp51_, (ValaCCodeExpression*) _tmp53_);
		_tmp55_ = _tmp54_;
		vala_ccode_function_open_if (_tmp50_, (ValaCCodeExpression*) _tmp55_);
		_vala_ccode_node_unref0 (_tmp55_);
		_vala_ccode_node_unref0 (_tmp53_);
		_tmp56_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp57_ = _tmp56_;
		_tmp58_ = stream;
		vala_ccode_function_add_assignment (_tmp57_, target_expr, _tmp58_);
		_vala_may_fail = TRUE;
		_tmp59_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp60_ = _tmp59_;
		vala_ccode_function_close (_tmp60_);
		_tmp61_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp62_ = _tmp61_;
		vala_ccode_function_add_else (_tmp62_);
		_tmp63_ = vala_ccode_identifier_new ("g_set_error_literal");
		_tmp64_ = _tmp63_;
		_tmp65_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp64_);
		_tmp66_ = _tmp65_;
		_vala_ccode_node_unref0 (_tmp64_);
		set_error = _tmp66_;
		_tmp67_ = set_error;
		vala_ccode_function_call_add_argument (_tmp67_, error_expr);
		_tmp68_ = set_error;
		_tmp69_ = vala_ccode_identifier_new ("G_IO_ERROR");
		_tmp70_ = _tmp69_;
		vala_ccode_function_call_add_argument (_tmp68_, (ValaCCodeExpression*) _tmp70_);
		_vala_ccode_node_unref0 (_tmp70_);
		_tmp71_ = set_error;
		_tmp72_ = vala_ccode_identifier_new ("G_IO_ERROR_FAILED");
		_tmp73_ = _tmp72_;
		vala_ccode_function_call_add_argument (_tmp71_, (ValaCCodeExpression*) _tmp73_);
		_vala_ccode_node_unref0 (_tmp73_);
		_tmp74_ = set_error;
		_tmp75_ = vala_ccode_constant_new ("\"FD List is NULL\"");
		_tmp76_ = _tmp75_;
		vala_ccode_function_call_add_argument (_tmp74_, (ValaCCodeExpression*) _tmp76_);
		_vala_ccode_node_unref0 (_tmp76_);
		_tmp77_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp78_ = _tmp77_;
		_tmp79_ = set_error;
		vala_ccode_function_add_expression (_tmp78_, (ValaCCodeExpression*) _tmp79_);
		_tmp80_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp81_ = _tmp80_;
		vala_ccode_function_close (_tmp81_);
		_vala_ccode_node_unref0 (set_error);
		_vala_ccode_node_unref0 (get_fd);
		_vala_ccode_node_unref0 (fd);
		_vala_ccode_node_unref0 (fd_list_var);
	} else {
		gboolean _tmp82_ = FALSE;
		vala_gvariant_module_read_expression ((ValaGVariantModule*) self, type, iter_expr, target_expr, sym, error_expr, &_tmp82_);
		_vala_may_fail = _tmp82_;
	}
	_vala_ccode_node_unref0 (stream);
	_vala_ccode_node_unref0 (fd_var);
	_vala_ccode_node_unref0 (fd_list);
	if (may_fail) {
		*may_fail = _vala_may_fail;
	}
}


static ValaCCodeExpression*
vala_gd_bus_module_get_method_info (ValaGDBusModule* self, 
                                    ValaObjectTypeSymbol* sym)
{
	ValaCCodeExpression* result = NULL;
	ValaCCodeInitializerList* infos = NULL;
	ValaCCodeInitializerList* _tmp0_;
	ValaCCodeInitializerList* _tmp358_;
	ValaCCodeConstant* _tmp359_;
	ValaCCodeConstant* _tmp360_;
	ValaCCodeDeclaration* _cdecl_ = NULL;
	ValaCCodeDeclaration* _tmp361_;
	gchar* _tmp362_;
	gchar* _tmp363_;
	gchar* _tmp364_;
	gchar* _tmp365_;
	gchar* _tmp366_;
	gchar* _tmp367_;
	ValaCCodeInitializerList* _tmp368_;
	ValaCCodeVariableDeclarator* _tmp369_;
	ValaCCodeVariableDeclarator* _tmp370_;
	ValaCCodeFile* _tmp371_;
	gchar* _tmp372_;
	gchar* _tmp373_;
	gchar* _tmp374_;
	gchar* _tmp375_;
	gchar* _tmp376_;
	gchar* _tmp377_;
	ValaCCodeIdentifier* _tmp378_;
	ValaCCodeExpression* _tmp379_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0_ = vala_ccode_initializer_list_new ();
	infos = _tmp0_;
	{
		ValaList* _m_list = NULL;
		ValaList* _tmp1_;
		gint _m_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _m_index = 0;
		_tmp1_ = vala_object_type_symbol_get_methods (sym);
		_m_list = _tmp1_;
		_tmp2_ = _m_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_m_size = _tmp4_;
		_m_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaMethod* m = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			gboolean _tmp11_ = FALSE;
			gboolean _tmp12_ = FALSE;
			gboolean _tmp13_ = FALSE;
			ValaMethod* _tmp14_;
			ValaMethod* _tmp24_;
			ValaCCodeInitializerList* in_args_info = NULL;
			ValaCCodeInitializerList* _tmp25_;
			ValaCCodeInitializerList* out_args_info = NULL;
			ValaCCodeInitializerList* _tmp26_;
			ValaMethod* _tmp158_;
			ValaDataType* _tmp159_;
			ValaDataType* _tmp160_;
			ValaCCodeInitializerList* _tmp223_;
			ValaCCodeConstant* _tmp224_;
			ValaCCodeConstant* _tmp225_;
			ValaCCodeInitializerList* _tmp226_;
			ValaCCodeConstant* _tmp227_;
			ValaCCodeConstant* _tmp228_;
			ValaCCodeDeclaration* _cdecl_ = NULL;
			ValaCCodeDeclaration* _tmp229_;
			ValaCCodeDeclaration* _tmp230_;
			gchar* _tmp231_;
			gchar* _tmp232_;
			gchar* _tmp233_;
			gchar* _tmp234_;
			gchar* _tmp235_;
			gchar* _tmp236_;
			ValaMethod* _tmp237_;
			const gchar* _tmp238_;
			const gchar* _tmp239_;
			gchar* _tmp240_;
			gchar* _tmp241_;
			gchar* _tmp242_;
			gchar* _tmp243_;
			ValaCCodeInitializerList* _tmp244_;
			ValaCCodeVariableDeclarator* _tmp245_;
			ValaCCodeVariableDeclarator* _tmp246_;
			ValaCCodeDeclaration* _tmp247_;
			ValaCCodeFile* _tmp248_;
			ValaCCodeDeclaration* _tmp249_;
			ValaCCodeDeclaration* _tmp250_;
			ValaCCodeDeclaration* _tmp251_;
			gchar* _tmp252_;
			gchar* _tmp253_;
			gchar* _tmp254_;
			gchar* _tmp255_;
			gchar* _tmp256_;
			gchar* _tmp257_;
			ValaMethod* _tmp258_;
			const gchar* _tmp259_;
			const gchar* _tmp260_;
			gchar* _tmp261_;
			gchar* _tmp262_;
			gchar* _tmp263_;
			gchar* _tmp264_;
			ValaCCodeInitializerList* _tmp265_;
			ValaCCodeVariableDeclarator* _tmp266_;
			ValaCCodeVariableDeclarator* _tmp267_;
			ValaCCodeDeclaration* _tmp268_;
			ValaCCodeFile* _tmp269_;
			ValaCCodeDeclaration* _tmp270_;
			ValaCCodeInitializerList* info = NULL;
			ValaCCodeInitializerList* _tmp271_;
			ValaCCodeInitializerList* _tmp272_;
			ValaCCodeConstant* _tmp273_;
			ValaCCodeConstant* _tmp274_;
			ValaCCodeInitializerList* _tmp275_;
			ValaMethod* _tmp276_;
			gchar* _tmp277_;
			gchar* _tmp278_;
			gchar* _tmp279_;
			gchar* _tmp280_;
			ValaCCodeConstant* _tmp281_;
			ValaCCodeConstant* _tmp282_;
			ValaCCodeInitializerList* _tmp283_;
			gchar* _tmp284_;
			gchar* _tmp285_;
			gchar* _tmp286_;
			gchar* _tmp287_;
			gchar* _tmp288_;
			gchar* _tmp289_;
			ValaMethod* _tmp290_;
			const gchar* _tmp291_;
			const gchar* _tmp292_;
			gchar* _tmp293_;
			gchar* _tmp294_;
			gchar* _tmp295_;
			gchar* _tmp296_;
			ValaCCodeIdentifier* _tmp297_;
			ValaCCodeIdentifier* _tmp298_;
			ValaCCodeUnaryExpression* _tmp299_;
			ValaCCodeUnaryExpression* _tmp300_;
			ValaCCodeCastExpression* _tmp301_;
			ValaCCodeCastExpression* _tmp302_;
			ValaCCodeInitializerList* _tmp303_;
			gchar* _tmp304_;
			gchar* _tmp305_;
			gchar* _tmp306_;
			gchar* _tmp307_;
			gchar* _tmp308_;
			gchar* _tmp309_;
			ValaMethod* _tmp310_;
			const gchar* _tmp311_;
			const gchar* _tmp312_;
			gchar* _tmp313_;
			gchar* _tmp314_;
			gchar* _tmp315_;
			gchar* _tmp316_;
			ValaCCodeIdentifier* _tmp317_;
			ValaCCodeIdentifier* _tmp318_;
			ValaCCodeUnaryExpression* _tmp319_;
			ValaCCodeUnaryExpression* _tmp320_;
			ValaCCodeCastExpression* _tmp321_;
			ValaCCodeCastExpression* _tmp322_;
			ValaCCodeDeclaration* _tmp323_;
			ValaCCodeDeclaration* _tmp324_;
			gchar* _tmp325_;
			gchar* _tmp326_;
			gchar* _tmp327_;
			gchar* _tmp328_;
			gchar* _tmp329_;
			gchar* _tmp330_;
			ValaMethod* _tmp331_;
			const gchar* _tmp332_;
			const gchar* _tmp333_;
			gchar* _tmp334_;
			gchar* _tmp335_;
			ValaCCodeInitializerList* _tmp336_;
			ValaCCodeVariableDeclarator* _tmp337_;
			ValaCCodeVariableDeclarator* _tmp338_;
			ValaCCodeDeclaration* _tmp339_;
			ValaCCodeFile* _tmp340_;
			ValaCCodeDeclaration* _tmp341_;
			ValaCCodeInitializerList* _tmp342_;
			gchar* _tmp343_;
			gchar* _tmp344_;
			gchar* _tmp345_;
			gchar* _tmp346_;
			gchar* _tmp347_;
			gchar* _tmp348_;
			ValaMethod* _tmp349_;
			const gchar* _tmp350_;
			const gchar* _tmp351_;
			gchar* _tmp352_;
			gchar* _tmp353_;
			ValaCCodeIdentifier* _tmp354_;
			ValaCCodeIdentifier* _tmp355_;
			ValaCCodeUnaryExpression* _tmp356_;
			ValaCCodeUnaryExpression* _tmp357_;
			_tmp5_ = _m_index;
			_m_index = _tmp5_ + 1;
			_tmp6_ = _m_index;
			_tmp7_ = _m_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _m_list;
			_tmp9_ = _m_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			m = (ValaMethod*) _tmp10_;
			_tmp14_ = m;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp14_, VALA_TYPE_CREATION_METHOD)) {
				_tmp13_ = TRUE;
			} else {
				ValaMethod* _tmp15_;
				ValaMemberBinding _tmp16_;
				ValaMemberBinding _tmp17_;
				_tmp15_ = m;
				_tmp16_ = vala_method_get_binding (_tmp15_);
				_tmp17_ = _tmp16_;
				_tmp13_ = _tmp17_ != VALA_MEMBER_BINDING_INSTANCE;
			}
			if (_tmp13_) {
				_tmp12_ = TRUE;
			} else {
				ValaMethod* _tmp18_;
				gboolean _tmp19_;
				gboolean _tmp20_;
				_tmp18_ = m;
				_tmp19_ = vala_method_get_overrides (_tmp18_);
				_tmp20_ = _tmp19_;
				_tmp12_ = _tmp20_;
			}
			if (_tmp12_) {
				_tmp11_ = TRUE;
			} else {
				ValaMethod* _tmp21_;
				ValaSymbolAccessibility _tmp22_;
				ValaSymbolAccessibility _tmp23_;
				_tmp21_ = m;
				_tmp22_ = vala_symbol_get_access ((ValaSymbol*) _tmp21_);
				_tmp23_ = _tmp22_;
				_tmp11_ = _tmp23_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
			}
			if (_tmp11_) {
				_vala_code_node_unref0 (m);
				continue;
			}
			_tmp24_ = m;
			if (!vala_gd_bus_module_is_dbus_visible ((ValaCodeNode*) _tmp24_)) {
				_vala_code_node_unref0 (m);
				continue;
			}
			_tmp25_ = vala_ccode_initializer_list_new ();
			in_args_info = _tmp25_;
			_tmp26_ = vala_ccode_initializer_list_new ();
			out_args_info = _tmp26_;
			{
				ValaList* _param_list = NULL;
				ValaMethod* _tmp27_;
				ValaList* _tmp28_;
				gint _param_size = 0;
				ValaList* _tmp29_;
				gint _tmp30_;
				gint _tmp31_;
				gint _param_index = 0;
				_tmp27_ = m;
				_tmp28_ = vala_callable_get_parameters ((ValaCallable*) _tmp27_);
				_param_list = _tmp28_;
				_tmp29_ = _param_list;
				_tmp30_ = vala_collection_get_size ((ValaCollection*) _tmp29_);
				_tmp31_ = _tmp30_;
				_param_size = _tmp31_;
				_param_index = -1;
				while (TRUE) {
					gint _tmp32_;
					gint _tmp33_;
					gint _tmp34_;
					ValaParameter* param = NULL;
					ValaList* _tmp35_;
					gint _tmp36_;
					gpointer _tmp37_;
					gboolean _tmp38_ = FALSE;
					ValaParameter* _tmp39_;
					ValaDataType* _tmp40_;
					ValaDataType* _tmp41_;
					gboolean _tmp49_ = FALSE;
					ValaParameter* _tmp50_;
					ValaDataType* _tmp51_;
					ValaDataType* _tmp52_;
					ValaCCodeInitializerList* info = NULL;
					ValaCCodeInitializerList* _tmp60_;
					ValaCCodeInitializerList* _tmp61_;
					ValaCCodeConstant* _tmp62_;
					ValaCCodeConstant* _tmp63_;
					ValaCCodeInitializerList* _tmp64_;
					ValaParameter* _tmp65_;
					const gchar* _tmp66_;
					const gchar* _tmp67_;
					gchar* _tmp68_;
					gchar* _tmp69_;
					ValaCCodeConstant* _tmp70_;
					ValaCCodeConstant* _tmp71_;
					ValaCCodeInitializerList* _tmp72_;
					ValaParameter* _tmp73_;
					ValaDataType* _tmp74_;
					ValaDataType* _tmp75_;
					ValaParameter* _tmp76_;
					gchar* _tmp77_;
					gchar* _tmp78_;
					gchar* _tmp79_;
					gchar* _tmp80_;
					ValaCCodeConstant* _tmp81_;
					ValaCCodeConstant* _tmp82_;
					ValaCCodeDeclaration* _cdecl_ = NULL;
					ValaCCodeDeclaration* _tmp83_;
					ValaCCodeDeclaration* _tmp84_;
					gchar* _tmp85_;
					gchar* _tmp86_;
					gchar* _tmp87_;
					gchar* _tmp88_;
					gchar* _tmp89_;
					gchar* _tmp90_;
					ValaMethod* _tmp91_;
					const gchar* _tmp92_;
					const gchar* _tmp93_;
					gchar* _tmp94_;
					gchar* _tmp95_;
					gchar* _tmp96_;
					gchar* _tmp97_;
					ValaParameter* _tmp98_;
					const gchar* _tmp99_;
					const gchar* _tmp100_;
					gchar* _tmp101_;
					gchar* _tmp102_;
					ValaCCodeInitializerList* _tmp103_;
					ValaCCodeVariableDeclarator* _tmp104_;
					ValaCCodeVariableDeclarator* _tmp105_;
					ValaCCodeDeclaration* _tmp106_;
					ValaCCodeFile* _tmp107_;
					ValaCCodeDeclaration* _tmp108_;
					ValaParameter* _tmp109_;
					ValaParameterDirection _tmp110_;
					ValaParameterDirection _tmp111_;
					_tmp32_ = _param_index;
					_param_index = _tmp32_ + 1;
					_tmp33_ = _param_index;
					_tmp34_ = _param_size;
					if (!(_tmp33_ < _tmp34_)) {
						break;
					}
					_tmp35_ = _param_list;
					_tmp36_ = _param_index;
					_tmp37_ = vala_list_get (_tmp35_, _tmp36_);
					param = (ValaParameter*) _tmp37_;
					_tmp39_ = param;
					_tmp40_ = vala_variable_get_variable_type ((ValaVariable*) _tmp39_);
					_tmp41_ = _tmp40_;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp41_, VALA_TYPE_OBJECT_TYPE)) {
						ValaParameter* _tmp42_;
						ValaDataType* _tmp43_;
						ValaDataType* _tmp44_;
						ValaTypeSymbol* _tmp45_;
						ValaTypeSymbol* _tmp46_;
						gchar* _tmp47_;
						gchar* _tmp48_;
						_tmp42_ = param;
						_tmp43_ = vala_variable_get_variable_type ((ValaVariable*) _tmp42_);
						_tmp44_ = _tmp43_;
						_tmp45_ = vala_data_type_get_data_type (_tmp44_);
						_tmp46_ = _tmp45_;
						_tmp47_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp46_);
						_tmp48_ = _tmp47_;
						_tmp38_ = g_strcmp0 (_tmp48_, "GLib.Cancellable") == 0;
						_g_free0 (_tmp48_);
					} else {
						_tmp38_ = FALSE;
					}
					if (_tmp38_) {
						_vala_code_node_unref0 (param);
						continue;
					}
					_tmp50_ = param;
					_tmp51_ = vala_variable_get_variable_type ((ValaVariable*) _tmp50_);
					_tmp52_ = _tmp51_;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp52_, VALA_TYPE_OBJECT_TYPE)) {
						ValaParameter* _tmp53_;
						ValaDataType* _tmp54_;
						ValaDataType* _tmp55_;
						ValaTypeSymbol* _tmp56_;
						ValaTypeSymbol* _tmp57_;
						gchar* _tmp58_;
						gchar* _tmp59_;
						_tmp53_ = param;
						_tmp54_ = vala_variable_get_variable_type ((ValaVariable*) _tmp53_);
						_tmp55_ = _tmp54_;
						_tmp56_ = vala_data_type_get_data_type (_tmp55_);
						_tmp57_ = _tmp56_;
						_tmp58_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp57_);
						_tmp59_ = _tmp58_;
						_tmp49_ = g_strcmp0 (_tmp59_, "GLib.BusName") == 0;
						_g_free0 (_tmp59_);
					} else {
						_tmp49_ = FALSE;
					}
					if (_tmp49_) {
						_vala_code_node_unref0 (param);
						continue;
					}
					_tmp60_ = vala_ccode_initializer_list_new ();
					info = _tmp60_;
					_tmp61_ = info;
					_tmp62_ = vala_ccode_constant_new ("-1");
					_tmp63_ = _tmp62_;
					vala_ccode_initializer_list_append (_tmp61_, (ValaCCodeExpression*) _tmp63_);
					_vala_ccode_node_unref0 (_tmp63_);
					_tmp64_ = info;
					_tmp65_ = param;
					_tmp66_ = vala_symbol_get_name ((ValaSymbol*) _tmp65_);
					_tmp67_ = _tmp66_;
					_tmp68_ = g_strdup_printf ("\"%s\"", _tmp67_);
					_tmp69_ = _tmp68_;
					_tmp70_ = vala_ccode_constant_new (_tmp69_);
					_tmp71_ = _tmp70_;
					vala_ccode_initializer_list_append (_tmp64_, (ValaCCodeExpression*) _tmp71_);
					_vala_ccode_node_unref0 (_tmp71_);
					_g_free0 (_tmp69_);
					_tmp72_ = info;
					_tmp73_ = param;
					_tmp74_ = vala_variable_get_variable_type ((ValaVariable*) _tmp73_);
					_tmp75_ = _tmp74_;
					_tmp76_ = param;
					_tmp77_ = vala_gvariant_module_get_type_signature (_tmp75_, (ValaSymbol*) _tmp76_);
					_tmp78_ = _tmp77_;
					_tmp79_ = g_strdup_printf ("\"%s\"", _tmp78_);
					_tmp80_ = _tmp79_;
					_tmp81_ = vala_ccode_constant_new (_tmp80_);
					_tmp82_ = _tmp81_;
					vala_ccode_initializer_list_append (_tmp72_, (ValaCCodeExpression*) _tmp82_);
					_vala_ccode_node_unref0 (_tmp82_);
					_g_free0 (_tmp80_);
					_g_free0 (_tmp78_);
					_tmp83_ = vala_ccode_declaration_new ("const GDBusArgInfo");
					_cdecl_ = _tmp83_;
					_tmp84_ = _cdecl_;
					_tmp85_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
					_tmp86_ = _tmp85_;
					_tmp87_ = g_strconcat ("_", _tmp86_, NULL);
					_tmp88_ = _tmp87_;
					_tmp89_ = g_strconcat (_tmp88_, "dbus_arg_info_", NULL);
					_tmp90_ = _tmp89_;
					_tmp91_ = m;
					_tmp92_ = vala_symbol_get_name ((ValaSymbol*) _tmp91_);
					_tmp93_ = _tmp92_;
					_tmp94_ = g_strconcat (_tmp90_, _tmp93_, NULL);
					_tmp95_ = _tmp94_;
					_tmp96_ = g_strconcat (_tmp95_, "_", NULL);
					_tmp97_ = _tmp96_;
					_tmp98_ = param;
					_tmp99_ = vala_symbol_get_name ((ValaSymbol*) _tmp98_);
					_tmp100_ = _tmp99_;
					_tmp101_ = g_strconcat (_tmp97_, _tmp100_, NULL);
					_tmp102_ = _tmp101_;
					_tmp103_ = info;
					_tmp104_ = vala_ccode_variable_declarator_new (_tmp102_, (ValaCCodeExpression*) _tmp103_, NULL);
					_tmp105_ = _tmp104_;
					vala_ccode_declaration_add_declarator (_tmp84_, (ValaCCodeDeclarator*) _tmp105_);
					_vala_ccode_node_unref0 (_tmp105_);
					_g_free0 (_tmp102_);
					_g_free0 (_tmp97_);
					_g_free0 (_tmp95_);
					_g_free0 (_tmp90_);
					_g_free0 (_tmp88_);
					_g_free0 (_tmp86_);
					_tmp106_ = _cdecl_;
					vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp106_, VALA_CCODE_MODIFIERS_STATIC);
					_tmp107_ = ((ValaCCodeBaseModule*) self)->cfile;
					_tmp108_ = _cdecl_;
					vala_ccode_file_add_constant_declaration (_tmp107_, (ValaCCodeNode*) _tmp108_);
					_tmp109_ = param;
					_tmp110_ = vala_parameter_get_direction (_tmp109_);
					_tmp111_ = _tmp110_;
					if (_tmp111_ == VALA_PARAMETER_DIRECTION_IN) {
						ValaCCodeInitializerList* _tmp112_;
						gchar* _tmp113_;
						gchar* _tmp114_;
						gchar* _tmp115_;
						gchar* _tmp116_;
						gchar* _tmp117_;
						gchar* _tmp118_;
						ValaMethod* _tmp119_;
						const gchar* _tmp120_;
						const gchar* _tmp121_;
						gchar* _tmp122_;
						gchar* _tmp123_;
						gchar* _tmp124_;
						gchar* _tmp125_;
						ValaParameter* _tmp126_;
						const gchar* _tmp127_;
						const gchar* _tmp128_;
						gchar* _tmp129_;
						gchar* _tmp130_;
						ValaCCodeIdentifier* _tmp131_;
						ValaCCodeIdentifier* _tmp132_;
						ValaCCodeUnaryExpression* _tmp133_;
						ValaCCodeUnaryExpression* _tmp134_;
						_tmp112_ = in_args_info;
						_tmp113_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
						_tmp114_ = _tmp113_;
						_tmp115_ = g_strconcat ("_", _tmp114_, NULL);
						_tmp116_ = _tmp115_;
						_tmp117_ = g_strconcat (_tmp116_, "dbus_arg_info_", NULL);
						_tmp118_ = _tmp117_;
						_tmp119_ = m;
						_tmp120_ = vala_symbol_get_name ((ValaSymbol*) _tmp119_);
						_tmp121_ = _tmp120_;
						_tmp122_ = g_strconcat (_tmp118_, _tmp121_, NULL);
						_tmp123_ = _tmp122_;
						_tmp124_ = g_strconcat (_tmp123_, "_", NULL);
						_tmp125_ = _tmp124_;
						_tmp126_ = param;
						_tmp127_ = vala_symbol_get_name ((ValaSymbol*) _tmp126_);
						_tmp128_ = _tmp127_;
						_tmp129_ = g_strconcat (_tmp125_, _tmp128_, NULL);
						_tmp130_ = _tmp129_;
						_tmp131_ = vala_ccode_identifier_new (_tmp130_);
						_tmp132_ = _tmp131_;
						_tmp133_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp132_);
						_tmp134_ = _tmp133_;
						vala_ccode_initializer_list_append (_tmp112_, (ValaCCodeExpression*) _tmp134_);
						_vala_ccode_node_unref0 (_tmp134_);
						_vala_ccode_node_unref0 (_tmp132_);
						_g_free0 (_tmp130_);
						_g_free0 (_tmp125_);
						_g_free0 (_tmp123_);
						_g_free0 (_tmp118_);
						_g_free0 (_tmp116_);
						_g_free0 (_tmp114_);
					} else {
						ValaCCodeInitializerList* _tmp135_;
						gchar* _tmp136_;
						gchar* _tmp137_;
						gchar* _tmp138_;
						gchar* _tmp139_;
						gchar* _tmp140_;
						gchar* _tmp141_;
						ValaMethod* _tmp142_;
						const gchar* _tmp143_;
						const gchar* _tmp144_;
						gchar* _tmp145_;
						gchar* _tmp146_;
						gchar* _tmp147_;
						gchar* _tmp148_;
						ValaParameter* _tmp149_;
						const gchar* _tmp150_;
						const gchar* _tmp151_;
						gchar* _tmp152_;
						gchar* _tmp153_;
						ValaCCodeIdentifier* _tmp154_;
						ValaCCodeIdentifier* _tmp155_;
						ValaCCodeUnaryExpression* _tmp156_;
						ValaCCodeUnaryExpression* _tmp157_;
						_tmp135_ = out_args_info;
						_tmp136_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
						_tmp137_ = _tmp136_;
						_tmp138_ = g_strconcat ("_", _tmp137_, NULL);
						_tmp139_ = _tmp138_;
						_tmp140_ = g_strconcat (_tmp139_, "dbus_arg_info_", NULL);
						_tmp141_ = _tmp140_;
						_tmp142_ = m;
						_tmp143_ = vala_symbol_get_name ((ValaSymbol*) _tmp142_);
						_tmp144_ = _tmp143_;
						_tmp145_ = g_strconcat (_tmp141_, _tmp144_, NULL);
						_tmp146_ = _tmp145_;
						_tmp147_ = g_strconcat (_tmp146_, "_", NULL);
						_tmp148_ = _tmp147_;
						_tmp149_ = param;
						_tmp150_ = vala_symbol_get_name ((ValaSymbol*) _tmp149_);
						_tmp151_ = _tmp150_;
						_tmp152_ = g_strconcat (_tmp148_, _tmp151_, NULL);
						_tmp153_ = _tmp152_;
						_tmp154_ = vala_ccode_identifier_new (_tmp153_);
						_tmp155_ = _tmp154_;
						_tmp156_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp155_);
						_tmp157_ = _tmp156_;
						vala_ccode_initializer_list_append (_tmp135_, (ValaCCodeExpression*) _tmp157_);
						_vala_ccode_node_unref0 (_tmp157_);
						_vala_ccode_node_unref0 (_tmp155_);
						_g_free0 (_tmp153_);
						_g_free0 (_tmp148_);
						_g_free0 (_tmp146_);
						_g_free0 (_tmp141_);
						_g_free0 (_tmp139_);
						_g_free0 (_tmp137_);
					}
					_vala_ccode_node_unref0 (_cdecl_);
					_vala_ccode_node_unref0 (info);
					_vala_code_node_unref0 (param);
				}
				_vala_iterable_unref0 (_param_list);
			}
			_tmp158_ = m;
			_tmp159_ = vala_callable_get_return_type ((ValaCallable*) _tmp158_);
			_tmp160_ = _tmp159_;
			if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp160_, VALA_TYPE_VOID_TYPE)) {
				ValaCCodeInitializerList* info = NULL;
				ValaCCodeInitializerList* _tmp161_;
				ValaCCodeInitializerList* _tmp162_;
				ValaCCodeConstant* _tmp163_;
				ValaCCodeConstant* _tmp164_;
				ValaCCodeInitializerList* _tmp165_;
				ValaMethod* _tmp166_;
				gchar* _tmp167_;
				gchar* _tmp168_;
				gchar* _tmp169_;
				gchar* _tmp170_;
				ValaCCodeConstant* _tmp171_;
				ValaCCodeConstant* _tmp172_;
				ValaCCodeInitializerList* _tmp173_;
				ValaMethod* _tmp174_;
				ValaDataType* _tmp175_;
				ValaDataType* _tmp176_;
				ValaMethod* _tmp177_;
				gchar* _tmp178_;
				gchar* _tmp179_;
				gchar* _tmp180_;
				gchar* _tmp181_;
				ValaCCodeConstant* _tmp182_;
				ValaCCodeConstant* _tmp183_;
				ValaCCodeDeclaration* _cdecl_ = NULL;
				ValaCCodeDeclaration* _tmp184_;
				ValaCCodeDeclaration* _tmp185_;
				gchar* _tmp186_;
				gchar* _tmp187_;
				gchar* _tmp188_;
				gchar* _tmp189_;
				gchar* _tmp190_;
				gchar* _tmp191_;
				ValaMethod* _tmp192_;
				const gchar* _tmp193_;
				const gchar* _tmp194_;
				gchar* _tmp195_;
				gchar* _tmp196_;
				gchar* _tmp197_;
				gchar* _tmp198_;
				ValaCCodeInitializerList* _tmp199_;
				ValaCCodeVariableDeclarator* _tmp200_;
				ValaCCodeVariableDeclarator* _tmp201_;
				ValaCCodeDeclaration* _tmp202_;
				ValaCCodeFile* _tmp203_;
				ValaCCodeDeclaration* _tmp204_;
				ValaCCodeInitializerList* _tmp205_;
				gchar* _tmp206_;
				gchar* _tmp207_;
				gchar* _tmp208_;
				gchar* _tmp209_;
				gchar* _tmp210_;
				gchar* _tmp211_;
				ValaMethod* _tmp212_;
				const gchar* _tmp213_;
				const gchar* _tmp214_;
				gchar* _tmp215_;
				gchar* _tmp216_;
				gchar* _tmp217_;
				gchar* _tmp218_;
				ValaCCodeIdentifier* _tmp219_;
				ValaCCodeIdentifier* _tmp220_;
				ValaCCodeUnaryExpression* _tmp221_;
				ValaCCodeUnaryExpression* _tmp222_;
				_tmp161_ = vala_ccode_initializer_list_new ();
				info = _tmp161_;
				_tmp162_ = info;
				_tmp163_ = vala_ccode_constant_new ("-1");
				_tmp164_ = _tmp163_;
				vala_ccode_initializer_list_append (_tmp162_, (ValaCCodeExpression*) _tmp164_);
				_vala_ccode_node_unref0 (_tmp164_);
				_tmp165_ = info;
				_tmp166_ = m;
				_tmp167_ = vala_gd_bus_module_dbus_result_name (_tmp166_);
				_tmp168_ = _tmp167_;
				_tmp169_ = g_strdup_printf ("\"%s\"", _tmp168_);
				_tmp170_ = _tmp169_;
				_tmp171_ = vala_ccode_constant_new (_tmp170_);
				_tmp172_ = _tmp171_;
				vala_ccode_initializer_list_append (_tmp165_, (ValaCCodeExpression*) _tmp172_);
				_vala_ccode_node_unref0 (_tmp172_);
				_g_free0 (_tmp170_);
				_g_free0 (_tmp168_);
				_tmp173_ = info;
				_tmp174_ = m;
				_tmp175_ = vala_callable_get_return_type ((ValaCallable*) _tmp174_);
				_tmp176_ = _tmp175_;
				_tmp177_ = m;
				_tmp178_ = vala_gvariant_module_get_type_signature (_tmp176_, (ValaSymbol*) _tmp177_);
				_tmp179_ = _tmp178_;
				_tmp180_ = g_strdup_printf ("\"%s\"", _tmp179_);
				_tmp181_ = _tmp180_;
				_tmp182_ = vala_ccode_constant_new (_tmp181_);
				_tmp183_ = _tmp182_;
				vala_ccode_initializer_list_append (_tmp173_, (ValaCCodeExpression*) _tmp183_);
				_vala_ccode_node_unref0 (_tmp183_);
				_g_free0 (_tmp181_);
				_g_free0 (_tmp179_);
				_tmp184_ = vala_ccode_declaration_new ("const GDBusArgInfo");
				_cdecl_ = _tmp184_;
				_tmp185_ = _cdecl_;
				_tmp186_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
				_tmp187_ = _tmp186_;
				_tmp188_ = g_strconcat ("_", _tmp187_, NULL);
				_tmp189_ = _tmp188_;
				_tmp190_ = g_strconcat (_tmp189_, "dbus_arg_info_", NULL);
				_tmp191_ = _tmp190_;
				_tmp192_ = m;
				_tmp193_ = vala_symbol_get_name ((ValaSymbol*) _tmp192_);
				_tmp194_ = _tmp193_;
				_tmp195_ = g_strconcat (_tmp191_, _tmp194_, NULL);
				_tmp196_ = _tmp195_;
				_tmp197_ = g_strconcat (_tmp196_, "_result", NULL);
				_tmp198_ = _tmp197_;
				_tmp199_ = info;
				_tmp200_ = vala_ccode_variable_declarator_new (_tmp198_, (ValaCCodeExpression*) _tmp199_, NULL);
				_tmp201_ = _tmp200_;
				vala_ccode_declaration_add_declarator (_tmp185_, (ValaCCodeDeclarator*) _tmp201_);
				_vala_ccode_node_unref0 (_tmp201_);
				_g_free0 (_tmp198_);
				_g_free0 (_tmp196_);
				_g_free0 (_tmp191_);
				_g_free0 (_tmp189_);
				_g_free0 (_tmp187_);
				_tmp202_ = _cdecl_;
				vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp202_, VALA_CCODE_MODIFIERS_STATIC);
				_tmp203_ = ((ValaCCodeBaseModule*) self)->cfile;
				_tmp204_ = _cdecl_;
				vala_ccode_file_add_constant_declaration (_tmp203_, (ValaCCodeNode*) _tmp204_);
				_tmp205_ = out_args_info;
				_tmp206_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
				_tmp207_ = _tmp206_;
				_tmp208_ = g_strconcat ("_", _tmp207_, NULL);
				_tmp209_ = _tmp208_;
				_tmp210_ = g_strconcat (_tmp209_, "dbus_arg_info_", NULL);
				_tmp211_ = _tmp210_;
				_tmp212_ = m;
				_tmp213_ = vala_symbol_get_name ((ValaSymbol*) _tmp212_);
				_tmp214_ = _tmp213_;
				_tmp215_ = g_strconcat (_tmp211_, _tmp214_, NULL);
				_tmp216_ = _tmp215_;
				_tmp217_ = g_strconcat (_tmp216_, "_result", NULL);
				_tmp218_ = _tmp217_;
				_tmp219_ = vala_ccode_identifier_new (_tmp218_);
				_tmp220_ = _tmp219_;
				_tmp221_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp220_);
				_tmp222_ = _tmp221_;
				vala_ccode_initializer_list_append (_tmp205_, (ValaCCodeExpression*) _tmp222_);
				_vala_ccode_node_unref0 (_tmp222_);
				_vala_ccode_node_unref0 (_tmp220_);
				_g_free0 (_tmp218_);
				_g_free0 (_tmp216_);
				_g_free0 (_tmp211_);
				_g_free0 (_tmp209_);
				_g_free0 (_tmp207_);
				_vala_ccode_node_unref0 (_cdecl_);
				_vala_ccode_node_unref0 (info);
			}
			_tmp223_ = in_args_info;
			_tmp224_ = vala_ccode_constant_new ("NULL");
			_tmp225_ = _tmp224_;
			vala_ccode_initializer_list_append (_tmp223_, (ValaCCodeExpression*) _tmp225_);
			_vala_ccode_node_unref0 (_tmp225_);
			_tmp226_ = out_args_info;
			_tmp227_ = vala_ccode_constant_new ("NULL");
			_tmp228_ = _tmp227_;
			vala_ccode_initializer_list_append (_tmp226_, (ValaCCodeExpression*) _tmp228_);
			_vala_ccode_node_unref0 (_tmp228_);
			_tmp229_ = vala_ccode_declaration_new ("const GDBusArgInfo * const");
			_cdecl_ = _tmp229_;
			_tmp230_ = _cdecl_;
			_tmp231_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
			_tmp232_ = _tmp231_;
			_tmp233_ = g_strconcat ("_", _tmp232_, NULL);
			_tmp234_ = _tmp233_;
			_tmp235_ = g_strconcat (_tmp234_, "dbus_arg_info_", NULL);
			_tmp236_ = _tmp235_;
			_tmp237_ = m;
			_tmp238_ = vala_symbol_get_name ((ValaSymbol*) _tmp237_);
			_tmp239_ = _tmp238_;
			_tmp240_ = g_strconcat (_tmp236_, _tmp239_, NULL);
			_tmp241_ = _tmp240_;
			_tmp242_ = g_strconcat (_tmp241_, "_in[]", NULL);
			_tmp243_ = _tmp242_;
			_tmp244_ = in_args_info;
			_tmp245_ = vala_ccode_variable_declarator_new (_tmp243_, (ValaCCodeExpression*) _tmp244_, NULL);
			_tmp246_ = _tmp245_;
			vala_ccode_declaration_add_declarator (_tmp230_, (ValaCCodeDeclarator*) _tmp246_);
			_vala_ccode_node_unref0 (_tmp246_);
			_g_free0 (_tmp243_);
			_g_free0 (_tmp241_);
			_g_free0 (_tmp236_);
			_g_free0 (_tmp234_);
			_g_free0 (_tmp232_);
			_tmp247_ = _cdecl_;
			vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp247_, VALA_CCODE_MODIFIERS_STATIC);
			_tmp248_ = ((ValaCCodeBaseModule*) self)->cfile;
			_tmp249_ = _cdecl_;
			vala_ccode_file_add_constant_declaration (_tmp248_, (ValaCCodeNode*) _tmp249_);
			_tmp250_ = vala_ccode_declaration_new ("const GDBusArgInfo * const");
			_vala_ccode_node_unref0 (_cdecl_);
			_cdecl_ = _tmp250_;
			_tmp251_ = _cdecl_;
			_tmp252_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
			_tmp253_ = _tmp252_;
			_tmp254_ = g_strconcat ("_", _tmp253_, NULL);
			_tmp255_ = _tmp254_;
			_tmp256_ = g_strconcat (_tmp255_, "dbus_arg_info_", NULL);
			_tmp257_ = _tmp256_;
			_tmp258_ = m;
			_tmp259_ = vala_symbol_get_name ((ValaSymbol*) _tmp258_);
			_tmp260_ = _tmp259_;
			_tmp261_ = g_strconcat (_tmp257_, _tmp260_, NULL);
			_tmp262_ = _tmp261_;
			_tmp263_ = g_strconcat (_tmp262_, "_out[]", NULL);
			_tmp264_ = _tmp263_;
			_tmp265_ = out_args_info;
			_tmp266_ = vala_ccode_variable_declarator_new (_tmp264_, (ValaCCodeExpression*) _tmp265_, NULL);
			_tmp267_ = _tmp266_;
			vala_ccode_declaration_add_declarator (_tmp251_, (ValaCCodeDeclarator*) _tmp267_);
			_vala_ccode_node_unref0 (_tmp267_);
			_g_free0 (_tmp264_);
			_g_free0 (_tmp262_);
			_g_free0 (_tmp257_);
			_g_free0 (_tmp255_);
			_g_free0 (_tmp253_);
			_tmp268_ = _cdecl_;
			vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp268_, VALA_CCODE_MODIFIERS_STATIC);
			_tmp269_ = ((ValaCCodeBaseModule*) self)->cfile;
			_tmp270_ = _cdecl_;
			vala_ccode_file_add_constant_declaration (_tmp269_, (ValaCCodeNode*) _tmp270_);
			_tmp271_ = vala_ccode_initializer_list_new ();
			info = _tmp271_;
			_tmp272_ = info;
			_tmp273_ = vala_ccode_constant_new ("-1");
			_tmp274_ = _tmp273_;
			vala_ccode_initializer_list_append (_tmp272_, (ValaCCodeExpression*) _tmp274_);
			_vala_ccode_node_unref0 (_tmp274_);
			_tmp275_ = info;
			_tmp276_ = m;
			_tmp277_ = vala_gd_bus_module_get_dbus_name_for_member ((ValaSymbol*) _tmp276_);
			_tmp278_ = _tmp277_;
			_tmp279_ = g_strdup_printf ("\"%s\"", _tmp278_);
			_tmp280_ = _tmp279_;
			_tmp281_ = vala_ccode_constant_new (_tmp280_);
			_tmp282_ = _tmp281_;
			vala_ccode_initializer_list_append (_tmp275_, (ValaCCodeExpression*) _tmp282_);
			_vala_ccode_node_unref0 (_tmp282_);
			_g_free0 (_tmp280_);
			_g_free0 (_tmp278_);
			_tmp283_ = info;
			_tmp284_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
			_tmp285_ = _tmp284_;
			_tmp286_ = g_strconcat ("_", _tmp285_, NULL);
			_tmp287_ = _tmp286_;
			_tmp288_ = g_strconcat (_tmp287_, "dbus_arg_info_", NULL);
			_tmp289_ = _tmp288_;
			_tmp290_ = m;
			_tmp291_ = vala_symbol_get_name ((ValaSymbol*) _tmp290_);
			_tmp292_ = _tmp291_;
			_tmp293_ = g_strconcat (_tmp289_, _tmp292_, NULL);
			_tmp294_ = _tmp293_;
			_tmp295_ = g_strconcat (_tmp294_, "_in", NULL);
			_tmp296_ = _tmp295_;
			_tmp297_ = vala_ccode_identifier_new (_tmp296_);
			_tmp298_ = _tmp297_;
			_tmp299_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp298_);
			_tmp300_ = _tmp299_;
			_tmp301_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp300_, "GDBusArgInfo **");
			_tmp302_ = _tmp301_;
			vala_ccode_initializer_list_append (_tmp283_, (ValaCCodeExpression*) _tmp302_);
			_vala_ccode_node_unref0 (_tmp302_);
			_vala_ccode_node_unref0 (_tmp300_);
			_vala_ccode_node_unref0 (_tmp298_);
			_g_free0 (_tmp296_);
			_g_free0 (_tmp294_);
			_g_free0 (_tmp289_);
			_g_free0 (_tmp287_);
			_g_free0 (_tmp285_);
			_tmp303_ = info;
			_tmp304_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
			_tmp305_ = _tmp304_;
			_tmp306_ = g_strconcat ("_", _tmp305_, NULL);
			_tmp307_ = _tmp306_;
			_tmp308_ = g_strconcat (_tmp307_, "dbus_arg_info_", NULL);
			_tmp309_ = _tmp308_;
			_tmp310_ = m;
			_tmp311_ = vala_symbol_get_name ((ValaSymbol*) _tmp310_);
			_tmp312_ = _tmp311_;
			_tmp313_ = g_strconcat (_tmp309_, _tmp312_, NULL);
			_tmp314_ = _tmp313_;
			_tmp315_ = g_strconcat (_tmp314_, "_out", NULL);
			_tmp316_ = _tmp315_;
			_tmp317_ = vala_ccode_identifier_new (_tmp316_);
			_tmp318_ = _tmp317_;
			_tmp319_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp318_);
			_tmp320_ = _tmp319_;
			_tmp321_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp320_, "GDBusArgInfo **");
			_tmp322_ = _tmp321_;
			vala_ccode_initializer_list_append (_tmp303_, (ValaCCodeExpression*) _tmp322_);
			_vala_ccode_node_unref0 (_tmp322_);
			_vala_ccode_node_unref0 (_tmp320_);
			_vala_ccode_node_unref0 (_tmp318_);
			_g_free0 (_tmp316_);
			_g_free0 (_tmp314_);
			_g_free0 (_tmp309_);
			_g_free0 (_tmp307_);
			_g_free0 (_tmp305_);
			_tmp323_ = vala_ccode_declaration_new ("const GDBusMethodInfo");
			_vala_ccode_node_unref0 (_cdecl_);
			_cdecl_ = _tmp323_;
			_tmp324_ = _cdecl_;
			_tmp325_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
			_tmp326_ = _tmp325_;
			_tmp327_ = g_strconcat ("_", _tmp326_, NULL);
			_tmp328_ = _tmp327_;
			_tmp329_ = g_strconcat (_tmp328_, "dbus_method_info_", NULL);
			_tmp330_ = _tmp329_;
			_tmp331_ = m;
			_tmp332_ = vala_symbol_get_name ((ValaSymbol*) _tmp331_);
			_tmp333_ = _tmp332_;
			_tmp334_ = g_strconcat (_tmp330_, _tmp333_, NULL);
			_tmp335_ = _tmp334_;
			_tmp336_ = info;
			_tmp337_ = vala_ccode_variable_declarator_new (_tmp335_, (ValaCCodeExpression*) _tmp336_, NULL);
			_tmp338_ = _tmp337_;
			vala_ccode_declaration_add_declarator (_tmp324_, (ValaCCodeDeclarator*) _tmp338_);
			_vala_ccode_node_unref0 (_tmp338_);
			_g_free0 (_tmp335_);
			_g_free0 (_tmp330_);
			_g_free0 (_tmp328_);
			_g_free0 (_tmp326_);
			_tmp339_ = _cdecl_;
			vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp339_, VALA_CCODE_MODIFIERS_STATIC);
			_tmp340_ = ((ValaCCodeBaseModule*) self)->cfile;
			_tmp341_ = _cdecl_;
			vala_ccode_file_add_constant_declaration (_tmp340_, (ValaCCodeNode*) _tmp341_);
			_tmp342_ = infos;
			_tmp343_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
			_tmp344_ = _tmp343_;
			_tmp345_ = g_strconcat ("_", _tmp344_, NULL);
			_tmp346_ = _tmp345_;
			_tmp347_ = g_strconcat (_tmp346_, "dbus_method_info_", NULL);
			_tmp348_ = _tmp347_;
			_tmp349_ = m;
			_tmp350_ = vala_symbol_get_name ((ValaSymbol*) _tmp349_);
			_tmp351_ = _tmp350_;
			_tmp352_ = g_strconcat (_tmp348_, _tmp351_, NULL);
			_tmp353_ = _tmp352_;
			_tmp354_ = vala_ccode_identifier_new (_tmp353_);
			_tmp355_ = _tmp354_;
			_tmp356_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp355_);
			_tmp357_ = _tmp356_;
			vala_ccode_initializer_list_append (_tmp342_, (ValaCCodeExpression*) _tmp357_);
			_vala_ccode_node_unref0 (_tmp357_);
			_vala_ccode_node_unref0 (_tmp355_);
			_g_free0 (_tmp353_);
			_g_free0 (_tmp348_);
			_g_free0 (_tmp346_);
			_g_free0 (_tmp344_);
			_vala_ccode_node_unref0 (info);
			_vala_ccode_node_unref0 (_cdecl_);
			_vala_ccode_node_unref0 (out_args_info);
			_vala_ccode_node_unref0 (in_args_info);
			_vala_code_node_unref0 (m);
		}
		_vala_iterable_unref0 (_m_list);
	}
	_tmp358_ = infos;
	_tmp359_ = vala_ccode_constant_new ("NULL");
	_tmp360_ = _tmp359_;
	vala_ccode_initializer_list_append (_tmp358_, (ValaCCodeExpression*) _tmp360_);
	_vala_ccode_node_unref0 (_tmp360_);
	_tmp361_ = vala_ccode_declaration_new ("const GDBusMethodInfo * const");
	_cdecl_ = _tmp361_;
	_tmp362_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
	_tmp363_ = _tmp362_;
	_tmp364_ = g_strconcat ("_", _tmp363_, NULL);
	_tmp365_ = _tmp364_;
	_tmp366_ = g_strconcat (_tmp365_, "dbus_method_info[]", NULL);
	_tmp367_ = _tmp366_;
	_tmp368_ = infos;
	_tmp369_ = vala_ccode_variable_declarator_new (_tmp367_, (ValaCCodeExpression*) _tmp368_, NULL);
	_tmp370_ = _tmp369_;
	vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) _tmp370_);
	_vala_ccode_node_unref0 (_tmp370_);
	_g_free0 (_tmp367_);
	_g_free0 (_tmp365_);
	_g_free0 (_tmp363_);
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _cdecl_, VALA_CCODE_MODIFIERS_STATIC);
	_tmp371_ = ((ValaCCodeBaseModule*) self)->cfile;
	vala_ccode_file_add_constant_declaration (_tmp371_, (ValaCCodeNode*) _cdecl_);
	_tmp372_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
	_tmp373_ = _tmp372_;
	_tmp374_ = g_strconcat ("_", _tmp373_, NULL);
	_tmp375_ = _tmp374_;
	_tmp376_ = g_strconcat (_tmp375_, "dbus_method_info", NULL);
	_tmp377_ = _tmp376_;
	_tmp378_ = vala_ccode_identifier_new (_tmp377_);
	_tmp379_ = (ValaCCodeExpression*) _tmp378_;
	_g_free0 (_tmp377_);
	_g_free0 (_tmp375_);
	_g_free0 (_tmp373_);
	result = _tmp379_;
	_vala_ccode_node_unref0 (_cdecl_);
	_vala_ccode_node_unref0 (infos);
	return result;
}


static ValaCCodeExpression*
vala_gd_bus_module_get_signal_info (ValaGDBusModule* self, 
                                    ValaObjectTypeSymbol* sym)
{
	ValaCCodeExpression* result = NULL;
	ValaCCodeInitializerList* infos = NULL;
	ValaCCodeInitializerList* _tmp0_;
	ValaCCodeInitializerList* _tmp188_;
	ValaCCodeConstant* _tmp189_;
	ValaCCodeConstant* _tmp190_;
	ValaCCodeDeclaration* _cdecl_ = NULL;
	ValaCCodeDeclaration* _tmp191_;
	gchar* _tmp192_;
	gchar* _tmp193_;
	gchar* _tmp194_;
	gchar* _tmp195_;
	gchar* _tmp196_;
	gchar* _tmp197_;
	ValaCCodeInitializerList* _tmp198_;
	ValaCCodeVariableDeclarator* _tmp199_;
	ValaCCodeVariableDeclarator* _tmp200_;
	ValaCCodeFile* _tmp201_;
	gchar* _tmp202_;
	gchar* _tmp203_;
	gchar* _tmp204_;
	gchar* _tmp205_;
	gchar* _tmp206_;
	gchar* _tmp207_;
	ValaCCodeIdentifier* _tmp208_;
	ValaCCodeExpression* _tmp209_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0_ = vala_ccode_initializer_list_new ();
	infos = _tmp0_;
	{
		ValaList* _sig_list = NULL;
		ValaList* _tmp1_;
		gint _sig_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _sig_index = 0;
		_tmp1_ = vala_object_type_symbol_get_signals (sym);
		_sig_list = _tmp1_;
		_tmp2_ = _sig_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_sig_size = _tmp4_;
		_sig_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaSignal* sig = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValaSignal* _tmp11_;
			ValaSymbolAccessibility _tmp12_;
			ValaSymbolAccessibility _tmp13_;
			ValaSignal* _tmp14_;
			ValaCCodeInitializerList* args_info = NULL;
			ValaCCodeInitializerList* _tmp15_;
			ValaCCodeInitializerList* _tmp99_;
			ValaCCodeConstant* _tmp100_;
			ValaCCodeConstant* _tmp101_;
			ValaCCodeDeclaration* _cdecl_ = NULL;
			ValaCCodeDeclaration* _tmp102_;
			ValaCCodeDeclaration* _tmp103_;
			gchar* _tmp104_;
			gchar* _tmp105_;
			gchar* _tmp106_;
			gchar* _tmp107_;
			gchar* _tmp108_;
			gchar* _tmp109_;
			ValaSignal* _tmp110_;
			gchar* _tmp111_;
			gchar* _tmp112_;
			gchar* _tmp113_;
			gchar* _tmp114_;
			gchar* _tmp115_;
			gchar* _tmp116_;
			ValaCCodeInitializerList* _tmp117_;
			ValaCCodeVariableDeclarator* _tmp118_;
			ValaCCodeVariableDeclarator* _tmp119_;
			ValaCCodeDeclaration* _tmp120_;
			ValaCCodeFile* _tmp121_;
			ValaCCodeDeclaration* _tmp122_;
			ValaCCodeInitializerList* info = NULL;
			ValaCCodeInitializerList* _tmp123_;
			ValaCCodeInitializerList* _tmp124_;
			ValaCCodeConstant* _tmp125_;
			ValaCCodeConstant* _tmp126_;
			ValaCCodeInitializerList* _tmp127_;
			ValaSignal* _tmp128_;
			gchar* _tmp129_;
			gchar* _tmp130_;
			gchar* _tmp131_;
			gchar* _tmp132_;
			ValaCCodeConstant* _tmp133_;
			ValaCCodeConstant* _tmp134_;
			ValaCCodeInitializerList* _tmp135_;
			gchar* _tmp136_;
			gchar* _tmp137_;
			gchar* _tmp138_;
			gchar* _tmp139_;
			gchar* _tmp140_;
			gchar* _tmp141_;
			ValaSignal* _tmp142_;
			gchar* _tmp143_;
			gchar* _tmp144_;
			gchar* _tmp145_;
			gchar* _tmp146_;
			ValaCCodeIdentifier* _tmp147_;
			ValaCCodeIdentifier* _tmp148_;
			ValaCCodeUnaryExpression* _tmp149_;
			ValaCCodeUnaryExpression* _tmp150_;
			ValaCCodeCastExpression* _tmp151_;
			ValaCCodeCastExpression* _tmp152_;
			ValaCCodeDeclaration* _tmp153_;
			ValaCCodeDeclaration* _tmp154_;
			gchar* _tmp155_;
			gchar* _tmp156_;
			gchar* _tmp157_;
			gchar* _tmp158_;
			gchar* _tmp159_;
			gchar* _tmp160_;
			ValaSignal* _tmp161_;
			gchar* _tmp162_;
			gchar* _tmp163_;
			gchar* _tmp164_;
			gchar* _tmp165_;
			ValaCCodeInitializerList* _tmp166_;
			ValaCCodeVariableDeclarator* _tmp167_;
			ValaCCodeVariableDeclarator* _tmp168_;
			ValaCCodeDeclaration* _tmp169_;
			ValaCCodeFile* _tmp170_;
			ValaCCodeDeclaration* _tmp171_;
			ValaCCodeInitializerList* _tmp172_;
			gchar* _tmp173_;
			gchar* _tmp174_;
			gchar* _tmp175_;
			gchar* _tmp176_;
			gchar* _tmp177_;
			gchar* _tmp178_;
			ValaSignal* _tmp179_;
			gchar* _tmp180_;
			gchar* _tmp181_;
			gchar* _tmp182_;
			gchar* _tmp183_;
			ValaCCodeIdentifier* _tmp184_;
			ValaCCodeIdentifier* _tmp185_;
			ValaCCodeUnaryExpression* _tmp186_;
			ValaCCodeUnaryExpression* _tmp187_;
			_tmp5_ = _sig_index;
			_sig_index = _tmp5_ + 1;
			_tmp6_ = _sig_index;
			_tmp7_ = _sig_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _sig_list;
			_tmp9_ = _sig_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			sig = (ValaSignal*) _tmp10_;
			_tmp11_ = sig;
			_tmp12_ = vala_symbol_get_access ((ValaSymbol*) _tmp11_);
			_tmp13_ = _tmp12_;
			if (_tmp13_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
				_vala_code_node_unref0 (sig);
				continue;
			}
			_tmp14_ = sig;
			if (!vala_gd_bus_module_is_dbus_visible ((ValaCodeNode*) _tmp14_)) {
				_vala_code_node_unref0 (sig);
				continue;
			}
			_tmp15_ = vala_ccode_initializer_list_new ();
			args_info = _tmp15_;
			{
				ValaList* _param_list = NULL;
				ValaSignal* _tmp16_;
				ValaList* _tmp17_;
				gint _param_size = 0;
				ValaList* _tmp18_;
				gint _tmp19_;
				gint _tmp20_;
				gint _param_index = 0;
				_tmp16_ = sig;
				_tmp17_ = vala_callable_get_parameters ((ValaCallable*) _tmp16_);
				_param_list = _tmp17_;
				_tmp18_ = _param_list;
				_tmp19_ = vala_collection_get_size ((ValaCollection*) _tmp18_);
				_tmp20_ = _tmp19_;
				_param_size = _tmp20_;
				_param_index = -1;
				while (TRUE) {
					gint _tmp21_;
					gint _tmp22_;
					gint _tmp23_;
					ValaParameter* param = NULL;
					ValaList* _tmp24_;
					gint _tmp25_;
					gpointer _tmp26_;
					ValaCCodeInitializerList* info = NULL;
					ValaCCodeInitializerList* _tmp27_;
					ValaCCodeInitializerList* _tmp28_;
					ValaCCodeConstant* _tmp29_;
					ValaCCodeConstant* _tmp30_;
					ValaCCodeInitializerList* _tmp31_;
					ValaParameter* _tmp32_;
					const gchar* _tmp33_;
					const gchar* _tmp34_;
					gchar* _tmp35_;
					gchar* _tmp36_;
					ValaCCodeConstant* _tmp37_;
					ValaCCodeConstant* _tmp38_;
					ValaCCodeInitializerList* _tmp39_;
					ValaParameter* _tmp40_;
					ValaDataType* _tmp41_;
					ValaDataType* _tmp42_;
					ValaParameter* _tmp43_;
					gchar* _tmp44_;
					gchar* _tmp45_;
					gchar* _tmp46_;
					gchar* _tmp47_;
					ValaCCodeConstant* _tmp48_;
					ValaCCodeConstant* _tmp49_;
					ValaCCodeDeclaration* _cdecl_ = NULL;
					ValaCCodeDeclaration* _tmp50_;
					ValaCCodeDeclaration* _tmp51_;
					gchar* _tmp52_;
					gchar* _tmp53_;
					gchar* _tmp54_;
					gchar* _tmp55_;
					gchar* _tmp56_;
					gchar* _tmp57_;
					ValaSignal* _tmp58_;
					gchar* _tmp59_;
					gchar* _tmp60_;
					gchar* _tmp61_;
					gchar* _tmp62_;
					gchar* _tmp63_;
					gchar* _tmp64_;
					ValaParameter* _tmp65_;
					const gchar* _tmp66_;
					const gchar* _tmp67_;
					gchar* _tmp68_;
					gchar* _tmp69_;
					ValaCCodeInitializerList* _tmp70_;
					ValaCCodeVariableDeclarator* _tmp71_;
					ValaCCodeVariableDeclarator* _tmp72_;
					ValaCCodeDeclaration* _tmp73_;
					ValaCCodeFile* _tmp74_;
					ValaCCodeDeclaration* _tmp75_;
					ValaCCodeInitializerList* _tmp76_;
					gchar* _tmp77_;
					gchar* _tmp78_;
					gchar* _tmp79_;
					gchar* _tmp80_;
					gchar* _tmp81_;
					gchar* _tmp82_;
					ValaSignal* _tmp83_;
					gchar* _tmp84_;
					gchar* _tmp85_;
					gchar* _tmp86_;
					gchar* _tmp87_;
					gchar* _tmp88_;
					gchar* _tmp89_;
					ValaParameter* _tmp90_;
					const gchar* _tmp91_;
					const gchar* _tmp92_;
					gchar* _tmp93_;
					gchar* _tmp94_;
					ValaCCodeIdentifier* _tmp95_;
					ValaCCodeIdentifier* _tmp96_;
					ValaCCodeUnaryExpression* _tmp97_;
					ValaCCodeUnaryExpression* _tmp98_;
					_tmp21_ = _param_index;
					_param_index = _tmp21_ + 1;
					_tmp22_ = _param_index;
					_tmp23_ = _param_size;
					if (!(_tmp22_ < _tmp23_)) {
						break;
					}
					_tmp24_ = _param_list;
					_tmp25_ = _param_index;
					_tmp26_ = vala_list_get (_tmp24_, _tmp25_);
					param = (ValaParameter*) _tmp26_;
					_tmp27_ = vala_ccode_initializer_list_new ();
					info = _tmp27_;
					_tmp28_ = info;
					_tmp29_ = vala_ccode_constant_new ("-1");
					_tmp30_ = _tmp29_;
					vala_ccode_initializer_list_append (_tmp28_, (ValaCCodeExpression*) _tmp30_);
					_vala_ccode_node_unref0 (_tmp30_);
					_tmp31_ = info;
					_tmp32_ = param;
					_tmp33_ = vala_symbol_get_name ((ValaSymbol*) _tmp32_);
					_tmp34_ = _tmp33_;
					_tmp35_ = g_strdup_printf ("\"%s\"", _tmp34_);
					_tmp36_ = _tmp35_;
					_tmp37_ = vala_ccode_constant_new (_tmp36_);
					_tmp38_ = _tmp37_;
					vala_ccode_initializer_list_append (_tmp31_, (ValaCCodeExpression*) _tmp38_);
					_vala_ccode_node_unref0 (_tmp38_);
					_g_free0 (_tmp36_);
					_tmp39_ = info;
					_tmp40_ = param;
					_tmp41_ = vala_variable_get_variable_type ((ValaVariable*) _tmp40_);
					_tmp42_ = _tmp41_;
					_tmp43_ = param;
					_tmp44_ = vala_gvariant_module_get_type_signature (_tmp42_, (ValaSymbol*) _tmp43_);
					_tmp45_ = _tmp44_;
					_tmp46_ = g_strdup_printf ("\"%s\"", _tmp45_);
					_tmp47_ = _tmp46_;
					_tmp48_ = vala_ccode_constant_new (_tmp47_);
					_tmp49_ = _tmp48_;
					vala_ccode_initializer_list_append (_tmp39_, (ValaCCodeExpression*) _tmp49_);
					_vala_ccode_node_unref0 (_tmp49_);
					_g_free0 (_tmp47_);
					_g_free0 (_tmp45_);
					_tmp50_ = vala_ccode_declaration_new ("const GDBusArgInfo");
					_cdecl_ = _tmp50_;
					_tmp51_ = _cdecl_;
					_tmp52_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
					_tmp53_ = _tmp52_;
					_tmp54_ = g_strconcat ("_", _tmp53_, NULL);
					_tmp55_ = _tmp54_;
					_tmp56_ = g_strconcat (_tmp55_, "dbus_arg_info_", NULL);
					_tmp57_ = _tmp56_;
					_tmp58_ = sig;
					_tmp59_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp58_, NULL);
					_tmp60_ = _tmp59_;
					_tmp61_ = g_strconcat (_tmp57_, _tmp60_, NULL);
					_tmp62_ = _tmp61_;
					_tmp63_ = g_strconcat (_tmp62_, "_", NULL);
					_tmp64_ = _tmp63_;
					_tmp65_ = param;
					_tmp66_ = vala_symbol_get_name ((ValaSymbol*) _tmp65_);
					_tmp67_ = _tmp66_;
					_tmp68_ = g_strconcat (_tmp64_, _tmp67_, NULL);
					_tmp69_ = _tmp68_;
					_tmp70_ = info;
					_tmp71_ = vala_ccode_variable_declarator_new (_tmp69_, (ValaCCodeExpression*) _tmp70_, NULL);
					_tmp72_ = _tmp71_;
					vala_ccode_declaration_add_declarator (_tmp51_, (ValaCCodeDeclarator*) _tmp72_);
					_vala_ccode_node_unref0 (_tmp72_);
					_g_free0 (_tmp69_);
					_g_free0 (_tmp64_);
					_g_free0 (_tmp62_);
					_g_free0 (_tmp60_);
					_g_free0 (_tmp57_);
					_g_free0 (_tmp55_);
					_g_free0 (_tmp53_);
					_tmp73_ = _cdecl_;
					vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp73_, VALA_CCODE_MODIFIERS_STATIC);
					_tmp74_ = ((ValaCCodeBaseModule*) self)->cfile;
					_tmp75_ = _cdecl_;
					vala_ccode_file_add_constant_declaration (_tmp74_, (ValaCCodeNode*) _tmp75_);
					_tmp76_ = args_info;
					_tmp77_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
					_tmp78_ = _tmp77_;
					_tmp79_ = g_strconcat ("_", _tmp78_, NULL);
					_tmp80_ = _tmp79_;
					_tmp81_ = g_strconcat (_tmp80_, "dbus_arg_info_", NULL);
					_tmp82_ = _tmp81_;
					_tmp83_ = sig;
					_tmp84_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp83_, NULL);
					_tmp85_ = _tmp84_;
					_tmp86_ = g_strconcat (_tmp82_, _tmp85_, NULL);
					_tmp87_ = _tmp86_;
					_tmp88_ = g_strconcat (_tmp87_, "_", NULL);
					_tmp89_ = _tmp88_;
					_tmp90_ = param;
					_tmp91_ = vala_symbol_get_name ((ValaSymbol*) _tmp90_);
					_tmp92_ = _tmp91_;
					_tmp93_ = g_strconcat (_tmp89_, _tmp92_, NULL);
					_tmp94_ = _tmp93_;
					_tmp95_ = vala_ccode_identifier_new (_tmp94_);
					_tmp96_ = _tmp95_;
					_tmp97_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp96_);
					_tmp98_ = _tmp97_;
					vala_ccode_initializer_list_append (_tmp76_, (ValaCCodeExpression*) _tmp98_);
					_vala_ccode_node_unref0 (_tmp98_);
					_vala_ccode_node_unref0 (_tmp96_);
					_g_free0 (_tmp94_);
					_g_free0 (_tmp89_);
					_g_free0 (_tmp87_);
					_g_free0 (_tmp85_);
					_g_free0 (_tmp82_);
					_g_free0 (_tmp80_);
					_g_free0 (_tmp78_);
					_vala_ccode_node_unref0 (_cdecl_);
					_vala_ccode_node_unref0 (info);
					_vala_code_node_unref0 (param);
				}
				_vala_iterable_unref0 (_param_list);
			}
			_tmp99_ = args_info;
			_tmp100_ = vala_ccode_constant_new ("NULL");
			_tmp101_ = _tmp100_;
			vala_ccode_initializer_list_append (_tmp99_, (ValaCCodeExpression*) _tmp101_);
			_vala_ccode_node_unref0 (_tmp101_);
			_tmp102_ = vala_ccode_declaration_new ("const GDBusArgInfo * const");
			_cdecl_ = _tmp102_;
			_tmp103_ = _cdecl_;
			_tmp104_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
			_tmp105_ = _tmp104_;
			_tmp106_ = g_strconcat ("_", _tmp105_, NULL);
			_tmp107_ = _tmp106_;
			_tmp108_ = g_strconcat (_tmp107_, "dbus_arg_info_", NULL);
			_tmp109_ = _tmp108_;
			_tmp110_ = sig;
			_tmp111_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp110_, NULL);
			_tmp112_ = _tmp111_;
			_tmp113_ = g_strconcat (_tmp109_, _tmp112_, NULL);
			_tmp114_ = _tmp113_;
			_tmp115_ = g_strconcat (_tmp114_, "[]", NULL);
			_tmp116_ = _tmp115_;
			_tmp117_ = args_info;
			_tmp118_ = vala_ccode_variable_declarator_new (_tmp116_, (ValaCCodeExpression*) _tmp117_, NULL);
			_tmp119_ = _tmp118_;
			vala_ccode_declaration_add_declarator (_tmp103_, (ValaCCodeDeclarator*) _tmp119_);
			_vala_ccode_node_unref0 (_tmp119_);
			_g_free0 (_tmp116_);
			_g_free0 (_tmp114_);
			_g_free0 (_tmp112_);
			_g_free0 (_tmp109_);
			_g_free0 (_tmp107_);
			_g_free0 (_tmp105_);
			_tmp120_ = _cdecl_;
			vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp120_, VALA_CCODE_MODIFIERS_STATIC);
			_tmp121_ = ((ValaCCodeBaseModule*) self)->cfile;
			_tmp122_ = _cdecl_;
			vala_ccode_file_add_constant_declaration (_tmp121_, (ValaCCodeNode*) _tmp122_);
			_tmp123_ = vala_ccode_initializer_list_new ();
			info = _tmp123_;
			_tmp124_ = info;
			_tmp125_ = vala_ccode_constant_new ("-1");
			_tmp126_ = _tmp125_;
			vala_ccode_initializer_list_append (_tmp124_, (ValaCCodeExpression*) _tmp126_);
			_vala_ccode_node_unref0 (_tmp126_);
			_tmp127_ = info;
			_tmp128_ = sig;
			_tmp129_ = vala_gd_bus_module_get_dbus_name_for_member ((ValaSymbol*) _tmp128_);
			_tmp130_ = _tmp129_;
			_tmp131_ = g_strdup_printf ("\"%s\"", _tmp130_);
			_tmp132_ = _tmp131_;
			_tmp133_ = vala_ccode_constant_new (_tmp132_);
			_tmp134_ = _tmp133_;
			vala_ccode_initializer_list_append (_tmp127_, (ValaCCodeExpression*) _tmp134_);
			_vala_ccode_node_unref0 (_tmp134_);
			_g_free0 (_tmp132_);
			_g_free0 (_tmp130_);
			_tmp135_ = info;
			_tmp136_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
			_tmp137_ = _tmp136_;
			_tmp138_ = g_strconcat ("_", _tmp137_, NULL);
			_tmp139_ = _tmp138_;
			_tmp140_ = g_strconcat (_tmp139_, "dbus_arg_info_", NULL);
			_tmp141_ = _tmp140_;
			_tmp142_ = sig;
			_tmp143_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp142_, NULL);
			_tmp144_ = _tmp143_;
			_tmp145_ = g_strconcat (_tmp141_, _tmp144_, NULL);
			_tmp146_ = _tmp145_;
			_tmp147_ = vala_ccode_identifier_new (_tmp146_);
			_tmp148_ = _tmp147_;
			_tmp149_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp148_);
			_tmp150_ = _tmp149_;
			_tmp151_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp150_, "GDBusArgInfo **");
			_tmp152_ = _tmp151_;
			vala_ccode_initializer_list_append (_tmp135_, (ValaCCodeExpression*) _tmp152_);
			_vala_ccode_node_unref0 (_tmp152_);
			_vala_ccode_node_unref0 (_tmp150_);
			_vala_ccode_node_unref0 (_tmp148_);
			_g_free0 (_tmp146_);
			_g_free0 (_tmp144_);
			_g_free0 (_tmp141_);
			_g_free0 (_tmp139_);
			_g_free0 (_tmp137_);
			_tmp153_ = vala_ccode_declaration_new ("const GDBusSignalInfo");
			_vala_ccode_node_unref0 (_cdecl_);
			_cdecl_ = _tmp153_;
			_tmp154_ = _cdecl_;
			_tmp155_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
			_tmp156_ = _tmp155_;
			_tmp157_ = g_strconcat ("_", _tmp156_, NULL);
			_tmp158_ = _tmp157_;
			_tmp159_ = g_strconcat (_tmp158_, "dbus_signal_info_", NULL);
			_tmp160_ = _tmp159_;
			_tmp161_ = sig;
			_tmp162_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp161_, NULL);
			_tmp163_ = _tmp162_;
			_tmp164_ = g_strconcat (_tmp160_, _tmp163_, NULL);
			_tmp165_ = _tmp164_;
			_tmp166_ = info;
			_tmp167_ = vala_ccode_variable_declarator_new (_tmp165_, (ValaCCodeExpression*) _tmp166_, NULL);
			_tmp168_ = _tmp167_;
			vala_ccode_declaration_add_declarator (_tmp154_, (ValaCCodeDeclarator*) _tmp168_);
			_vala_ccode_node_unref0 (_tmp168_);
			_g_free0 (_tmp165_);
			_g_free0 (_tmp163_);
			_g_free0 (_tmp160_);
			_g_free0 (_tmp158_);
			_g_free0 (_tmp156_);
			_tmp169_ = _cdecl_;
			vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp169_, VALA_CCODE_MODIFIERS_STATIC);
			_tmp170_ = ((ValaCCodeBaseModule*) self)->cfile;
			_tmp171_ = _cdecl_;
			vala_ccode_file_add_constant_declaration (_tmp170_, (ValaCCodeNode*) _tmp171_);
			_tmp172_ = infos;
			_tmp173_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
			_tmp174_ = _tmp173_;
			_tmp175_ = g_strconcat ("_", _tmp174_, NULL);
			_tmp176_ = _tmp175_;
			_tmp177_ = g_strconcat (_tmp176_, "dbus_signal_info_", NULL);
			_tmp178_ = _tmp177_;
			_tmp179_ = sig;
			_tmp180_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp179_, NULL);
			_tmp181_ = _tmp180_;
			_tmp182_ = g_strconcat (_tmp178_, _tmp181_, NULL);
			_tmp183_ = _tmp182_;
			_tmp184_ = vala_ccode_identifier_new (_tmp183_);
			_tmp185_ = _tmp184_;
			_tmp186_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp185_);
			_tmp187_ = _tmp186_;
			vala_ccode_initializer_list_append (_tmp172_, (ValaCCodeExpression*) _tmp187_);
			_vala_ccode_node_unref0 (_tmp187_);
			_vala_ccode_node_unref0 (_tmp185_);
			_g_free0 (_tmp183_);
			_g_free0 (_tmp181_);
			_g_free0 (_tmp178_);
			_g_free0 (_tmp176_);
			_g_free0 (_tmp174_);
			_vala_ccode_node_unref0 (info);
			_vala_ccode_node_unref0 (_cdecl_);
			_vala_ccode_node_unref0 (args_info);
			_vala_code_node_unref0 (sig);
		}
		_vala_iterable_unref0 (_sig_list);
	}
	_tmp188_ = infos;
	_tmp189_ = vala_ccode_constant_new ("NULL");
	_tmp190_ = _tmp189_;
	vala_ccode_initializer_list_append (_tmp188_, (ValaCCodeExpression*) _tmp190_);
	_vala_ccode_node_unref0 (_tmp190_);
	_tmp191_ = vala_ccode_declaration_new ("const GDBusSignalInfo * const");
	_cdecl_ = _tmp191_;
	_tmp192_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
	_tmp193_ = _tmp192_;
	_tmp194_ = g_strconcat ("_", _tmp193_, NULL);
	_tmp195_ = _tmp194_;
	_tmp196_ = g_strconcat (_tmp195_, "dbus_signal_info[]", NULL);
	_tmp197_ = _tmp196_;
	_tmp198_ = infos;
	_tmp199_ = vala_ccode_variable_declarator_new (_tmp197_, (ValaCCodeExpression*) _tmp198_, NULL);
	_tmp200_ = _tmp199_;
	vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) _tmp200_);
	_vala_ccode_node_unref0 (_tmp200_);
	_g_free0 (_tmp197_);
	_g_free0 (_tmp195_);
	_g_free0 (_tmp193_);
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _cdecl_, VALA_CCODE_MODIFIERS_STATIC);
	_tmp201_ = ((ValaCCodeBaseModule*) self)->cfile;
	vala_ccode_file_add_constant_declaration (_tmp201_, (ValaCCodeNode*) _cdecl_);
	_tmp202_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
	_tmp203_ = _tmp202_;
	_tmp204_ = g_strconcat ("_", _tmp203_, NULL);
	_tmp205_ = _tmp204_;
	_tmp206_ = g_strconcat (_tmp205_, "dbus_signal_info", NULL);
	_tmp207_ = _tmp206_;
	_tmp208_ = vala_ccode_identifier_new (_tmp207_);
	_tmp209_ = (ValaCCodeExpression*) _tmp208_;
	_g_free0 (_tmp207_);
	_g_free0 (_tmp205_);
	_g_free0 (_tmp203_);
	result = _tmp209_;
	_vala_ccode_node_unref0 (_cdecl_);
	_vala_ccode_node_unref0 (infos);
	return result;
}


static ValaCCodeExpression*
vala_gd_bus_module_get_property_info (ValaGDBusModule* self, 
                                      ValaObjectTypeSymbol* sym)
{
	ValaCCodeExpression* result = NULL;
	ValaCCodeInitializerList* infos = NULL;
	ValaCCodeInitializerList* _tmp0_;
	ValaCCodeInitializerList* _tmp106_;
	ValaCCodeConstant* _tmp107_;
	ValaCCodeConstant* _tmp108_;
	ValaCCodeDeclaration* _cdecl_ = NULL;
	ValaCCodeDeclaration* _tmp109_;
	gchar* _tmp110_;
	gchar* _tmp111_;
	gchar* _tmp112_;
	gchar* _tmp113_;
	gchar* _tmp114_;
	gchar* _tmp115_;
	ValaCCodeInitializerList* _tmp116_;
	ValaCCodeVariableDeclarator* _tmp117_;
	ValaCCodeVariableDeclarator* _tmp118_;
	ValaCCodeFile* _tmp119_;
	gchar* _tmp120_;
	gchar* _tmp121_;
	gchar* _tmp122_;
	gchar* _tmp123_;
	gchar* _tmp124_;
	gchar* _tmp125_;
	ValaCCodeIdentifier* _tmp126_;
	ValaCCodeExpression* _tmp127_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0_ = vala_ccode_initializer_list_new ();
	infos = _tmp0_;
	{
		ValaList* _prop_list = NULL;
		ValaList* _tmp1_;
		gint _prop_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _prop_index = 0;
		_tmp1_ = vala_object_type_symbol_get_properties (sym);
		_prop_list = _tmp1_;
		_tmp2_ = _prop_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_prop_size = _tmp4_;
		_prop_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaProperty* prop = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			gboolean _tmp11_ = FALSE;
			gboolean _tmp12_ = FALSE;
			ValaProperty* _tmp13_;
			ValaMemberBinding _tmp14_;
			ValaMemberBinding _tmp15_;
			ValaProperty* _tmp22_;
			ValaCCodeInitializerList* info = NULL;
			ValaCCodeInitializerList* _tmp23_;
			ValaCCodeInitializerList* _tmp24_;
			ValaCCodeConstant* _tmp25_;
			ValaCCodeConstant* _tmp26_;
			ValaCCodeInitializerList* _tmp27_;
			ValaProperty* _tmp28_;
			gchar* _tmp29_;
			gchar* _tmp30_;
			gchar* _tmp31_;
			gchar* _tmp32_;
			ValaCCodeConstant* _tmp33_;
			ValaCCodeConstant* _tmp34_;
			ValaCCodeInitializerList* _tmp35_;
			ValaProperty* _tmp36_;
			ValaDataType* _tmp37_;
			ValaDataType* _tmp38_;
			ValaProperty* _tmp39_;
			gchar* _tmp40_;
			gchar* _tmp41_;
			gchar* _tmp42_;
			gchar* _tmp43_;
			ValaCCodeConstant* _tmp44_;
			ValaCCodeConstant* _tmp45_;
			gboolean _tmp46_ = FALSE;
			ValaProperty* _tmp47_;
			ValaPropertyAccessor* _tmp48_;
			ValaPropertyAccessor* _tmp49_;
			ValaCCodeDeclaration* _cdecl_ = NULL;
			ValaCCodeDeclaration* _tmp71_;
			ValaCCodeDeclaration* _tmp72_;
			gchar* _tmp73_;
			gchar* _tmp74_;
			gchar* _tmp75_;
			gchar* _tmp76_;
			gchar* _tmp77_;
			gchar* _tmp78_;
			ValaProperty* _tmp79_;
			const gchar* _tmp80_;
			const gchar* _tmp81_;
			gchar* _tmp82_;
			gchar* _tmp83_;
			ValaCCodeInitializerList* _tmp84_;
			ValaCCodeVariableDeclarator* _tmp85_;
			ValaCCodeVariableDeclarator* _tmp86_;
			ValaCCodeDeclaration* _tmp87_;
			ValaCCodeFile* _tmp88_;
			ValaCCodeDeclaration* _tmp89_;
			ValaCCodeInitializerList* _tmp90_;
			gchar* _tmp91_;
			gchar* _tmp92_;
			gchar* _tmp93_;
			gchar* _tmp94_;
			gchar* _tmp95_;
			gchar* _tmp96_;
			ValaProperty* _tmp97_;
			const gchar* _tmp98_;
			const gchar* _tmp99_;
			gchar* _tmp100_;
			gchar* _tmp101_;
			ValaCCodeIdentifier* _tmp102_;
			ValaCCodeIdentifier* _tmp103_;
			ValaCCodeUnaryExpression* _tmp104_;
			ValaCCodeUnaryExpression* _tmp105_;
			_tmp5_ = _prop_index;
			_prop_index = _tmp5_ + 1;
			_tmp6_ = _prop_index;
			_tmp7_ = _prop_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _prop_list;
			_tmp9_ = _prop_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			prop = (ValaProperty*) _tmp10_;
			_tmp13_ = prop;
			_tmp14_ = vala_property_get_binding (_tmp13_);
			_tmp15_ = _tmp14_;
			if (_tmp15_ != VALA_MEMBER_BINDING_INSTANCE) {
				_tmp12_ = TRUE;
			} else {
				ValaProperty* _tmp16_;
				gboolean _tmp17_;
				gboolean _tmp18_;
				_tmp16_ = prop;
				_tmp17_ = vala_property_get_overrides (_tmp16_);
				_tmp18_ = _tmp17_;
				_tmp12_ = _tmp18_;
			}
			if (_tmp12_) {
				_tmp11_ = TRUE;
			} else {
				ValaProperty* _tmp19_;
				ValaSymbolAccessibility _tmp20_;
				ValaSymbolAccessibility _tmp21_;
				_tmp19_ = prop;
				_tmp20_ = vala_symbol_get_access ((ValaSymbol*) _tmp19_);
				_tmp21_ = _tmp20_;
				_tmp11_ = _tmp21_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
			}
			if (_tmp11_) {
				_vala_code_node_unref0 (prop);
				continue;
			}
			_tmp22_ = prop;
			if (!vala_gd_bus_module_is_dbus_visible ((ValaCodeNode*) _tmp22_)) {
				_vala_code_node_unref0 (prop);
				continue;
			}
			_tmp23_ = vala_ccode_initializer_list_new ();
			info = _tmp23_;
			_tmp24_ = info;
			_tmp25_ = vala_ccode_constant_new ("-1");
			_tmp26_ = _tmp25_;
			vala_ccode_initializer_list_append (_tmp24_, (ValaCCodeExpression*) _tmp26_);
			_vala_ccode_node_unref0 (_tmp26_);
			_tmp27_ = info;
			_tmp28_ = prop;
			_tmp29_ = vala_gd_bus_module_get_dbus_name_for_member ((ValaSymbol*) _tmp28_);
			_tmp30_ = _tmp29_;
			_tmp31_ = g_strdup_printf ("\"%s\"", _tmp30_);
			_tmp32_ = _tmp31_;
			_tmp33_ = vala_ccode_constant_new (_tmp32_);
			_tmp34_ = _tmp33_;
			vala_ccode_initializer_list_append (_tmp27_, (ValaCCodeExpression*) _tmp34_);
			_vala_ccode_node_unref0 (_tmp34_);
			_g_free0 (_tmp32_);
			_g_free0 (_tmp30_);
			_tmp35_ = info;
			_tmp36_ = prop;
			_tmp37_ = vala_property_get_property_type (_tmp36_);
			_tmp38_ = _tmp37_;
			_tmp39_ = prop;
			_tmp40_ = vala_gvariant_module_get_type_signature (_tmp38_, (ValaSymbol*) _tmp39_);
			_tmp41_ = _tmp40_;
			_tmp42_ = g_strdup_printf ("\"%s\"", _tmp41_);
			_tmp43_ = _tmp42_;
			_tmp44_ = vala_ccode_constant_new (_tmp43_);
			_tmp45_ = _tmp44_;
			vala_ccode_initializer_list_append (_tmp35_, (ValaCCodeExpression*) _tmp45_);
			_vala_ccode_node_unref0 (_tmp45_);
			_g_free0 (_tmp43_);
			_g_free0 (_tmp41_);
			_tmp47_ = prop;
			_tmp48_ = vala_property_get_get_accessor (_tmp47_);
			_tmp49_ = _tmp48_;
			if (_tmp49_ != NULL) {
				ValaProperty* _tmp50_;
				ValaPropertyAccessor* _tmp51_;
				ValaPropertyAccessor* _tmp52_;
				_tmp50_ = prop;
				_tmp51_ = vala_property_get_set_accessor (_tmp50_);
				_tmp52_ = _tmp51_;
				_tmp46_ = _tmp52_ != NULL;
			} else {
				_tmp46_ = FALSE;
			}
			if (_tmp46_) {
				ValaCCodeInitializerList* _tmp53_;
				ValaCCodeConstant* _tmp54_;
				ValaCCodeConstant* _tmp55_;
				_tmp53_ = info;
				_tmp54_ = vala_ccode_constant_new ("G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITA" \
"BLE");
				_tmp55_ = _tmp54_;
				vala_ccode_initializer_list_append (_tmp53_, (ValaCCodeExpression*) _tmp55_);
				_vala_ccode_node_unref0 (_tmp55_);
			} else {
				ValaProperty* _tmp56_;
				ValaPropertyAccessor* _tmp57_;
				ValaPropertyAccessor* _tmp58_;
				_tmp56_ = prop;
				_tmp57_ = vala_property_get_get_accessor (_tmp56_);
				_tmp58_ = _tmp57_;
				if (_tmp58_ != NULL) {
					ValaCCodeInitializerList* _tmp59_;
					ValaCCodeConstant* _tmp60_;
					ValaCCodeConstant* _tmp61_;
					_tmp59_ = info;
					_tmp60_ = vala_ccode_constant_new ("G_DBUS_PROPERTY_INFO_FLAGS_READABLE");
					_tmp61_ = _tmp60_;
					vala_ccode_initializer_list_append (_tmp59_, (ValaCCodeExpression*) _tmp61_);
					_vala_ccode_node_unref0 (_tmp61_);
				} else {
					ValaProperty* _tmp62_;
					ValaPropertyAccessor* _tmp63_;
					ValaPropertyAccessor* _tmp64_;
					_tmp62_ = prop;
					_tmp63_ = vala_property_get_set_accessor (_tmp62_);
					_tmp64_ = _tmp63_;
					if (_tmp64_ != NULL) {
						ValaCCodeInitializerList* _tmp65_;
						ValaCCodeConstant* _tmp66_;
						ValaCCodeConstant* _tmp67_;
						_tmp65_ = info;
						_tmp66_ = vala_ccode_constant_new ("G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE");
						_tmp67_ = _tmp66_;
						vala_ccode_initializer_list_append (_tmp65_, (ValaCCodeExpression*) _tmp67_);
						_vala_ccode_node_unref0 (_tmp67_);
					} else {
						ValaCCodeInitializerList* _tmp68_;
						ValaCCodeConstant* _tmp69_;
						ValaCCodeConstant* _tmp70_;
						_tmp68_ = info;
						_tmp69_ = vala_ccode_constant_new ("G_DBUS_PROPERTY_INFO_FLAGS_NONE");
						_tmp70_ = _tmp69_;
						vala_ccode_initializer_list_append (_tmp68_, (ValaCCodeExpression*) _tmp70_);
						_vala_ccode_node_unref0 (_tmp70_);
					}
				}
			}
			_tmp71_ = vala_ccode_declaration_new ("const GDBusPropertyInfo");
			_cdecl_ = _tmp71_;
			_tmp72_ = _cdecl_;
			_tmp73_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
			_tmp74_ = _tmp73_;
			_tmp75_ = g_strconcat ("_", _tmp74_, NULL);
			_tmp76_ = _tmp75_;
			_tmp77_ = g_strconcat (_tmp76_, "dbus_property_info_", NULL);
			_tmp78_ = _tmp77_;
			_tmp79_ = prop;
			_tmp80_ = vala_symbol_get_name ((ValaSymbol*) _tmp79_);
			_tmp81_ = _tmp80_;
			_tmp82_ = g_strconcat (_tmp78_, _tmp81_, NULL);
			_tmp83_ = _tmp82_;
			_tmp84_ = info;
			_tmp85_ = vala_ccode_variable_declarator_new (_tmp83_, (ValaCCodeExpression*) _tmp84_, NULL);
			_tmp86_ = _tmp85_;
			vala_ccode_declaration_add_declarator (_tmp72_, (ValaCCodeDeclarator*) _tmp86_);
			_vala_ccode_node_unref0 (_tmp86_);
			_g_free0 (_tmp83_);
			_g_free0 (_tmp78_);
			_g_free0 (_tmp76_);
			_g_free0 (_tmp74_);
			_tmp87_ = _cdecl_;
			vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp87_, VALA_CCODE_MODIFIERS_STATIC);
			_tmp88_ = ((ValaCCodeBaseModule*) self)->cfile;
			_tmp89_ = _cdecl_;
			vala_ccode_file_add_constant_declaration (_tmp88_, (ValaCCodeNode*) _tmp89_);
			_tmp90_ = infos;
			_tmp91_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
			_tmp92_ = _tmp91_;
			_tmp93_ = g_strconcat ("_", _tmp92_, NULL);
			_tmp94_ = _tmp93_;
			_tmp95_ = g_strconcat (_tmp94_, "dbus_property_info_", NULL);
			_tmp96_ = _tmp95_;
			_tmp97_ = prop;
			_tmp98_ = vala_symbol_get_name ((ValaSymbol*) _tmp97_);
			_tmp99_ = _tmp98_;
			_tmp100_ = g_strconcat (_tmp96_, _tmp99_, NULL);
			_tmp101_ = _tmp100_;
			_tmp102_ = vala_ccode_identifier_new (_tmp101_);
			_tmp103_ = _tmp102_;
			_tmp104_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp103_);
			_tmp105_ = _tmp104_;
			vala_ccode_initializer_list_append (_tmp90_, (ValaCCodeExpression*) _tmp105_);
			_vala_ccode_node_unref0 (_tmp105_);
			_vala_ccode_node_unref0 (_tmp103_);
			_g_free0 (_tmp101_);
			_g_free0 (_tmp96_);
			_g_free0 (_tmp94_);
			_g_free0 (_tmp92_);
			_vala_ccode_node_unref0 (_cdecl_);
			_vala_ccode_node_unref0 (info);
			_vala_code_node_unref0 (prop);
		}
		_vala_iterable_unref0 (_prop_list);
	}
	_tmp106_ = infos;
	_tmp107_ = vala_ccode_constant_new ("NULL");
	_tmp108_ = _tmp107_;
	vala_ccode_initializer_list_append (_tmp106_, (ValaCCodeExpression*) _tmp108_);
	_vala_ccode_node_unref0 (_tmp108_);
	_tmp109_ = vala_ccode_declaration_new ("const GDBusPropertyInfo * const");
	_cdecl_ = _tmp109_;
	_tmp110_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
	_tmp111_ = _tmp110_;
	_tmp112_ = g_strconcat ("_", _tmp111_, NULL);
	_tmp113_ = _tmp112_;
	_tmp114_ = g_strconcat (_tmp113_, "dbus_property_info[]", NULL);
	_tmp115_ = _tmp114_;
	_tmp116_ = infos;
	_tmp117_ = vala_ccode_variable_declarator_new (_tmp115_, (ValaCCodeExpression*) _tmp116_, NULL);
	_tmp118_ = _tmp117_;
	vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) _tmp118_);
	_vala_ccode_node_unref0 (_tmp118_);
	_g_free0 (_tmp115_);
	_g_free0 (_tmp113_);
	_g_free0 (_tmp111_);
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _cdecl_, VALA_CCODE_MODIFIERS_STATIC);
	_tmp119_ = ((ValaCCodeBaseModule*) self)->cfile;
	vala_ccode_file_add_constant_declaration (_tmp119_, (ValaCCodeNode*) _cdecl_);
	_tmp120_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
	_tmp121_ = _tmp120_;
	_tmp122_ = g_strconcat ("_", _tmp121_, NULL);
	_tmp123_ = _tmp122_;
	_tmp124_ = g_strconcat (_tmp123_, "dbus_property_info", NULL);
	_tmp125_ = _tmp124_;
	_tmp126_ = vala_ccode_identifier_new (_tmp125_);
	_tmp127_ = (ValaCCodeExpression*) _tmp126_;
	_g_free0 (_tmp125_);
	_g_free0 (_tmp123_);
	_g_free0 (_tmp121_);
	result = _tmp127_;
	_vala_ccode_node_unref0 (_cdecl_);
	_vala_ccode_node_unref0 (infos);
	return result;
}


static void
vala_gd_bus_module_declare_interface_info (ValaGDBusModule* self, 
                                           ValaObjectTypeSymbol* sym)
{
	ValaCCodeInitializerList* info = NULL;
	ValaCCodeInitializerList* _tmp0_;
	ValaCCodeConstant* _tmp1_;
	ValaCCodeConstant* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	ValaCCodeConstant* _tmp7_;
	ValaCCodeConstant* _tmp8_;
	ValaCCodeExpression* _tmp9_;
	ValaCCodeExpression* _tmp10_;
	ValaCCodeUnaryExpression* _tmp11_;
	ValaCCodeUnaryExpression* _tmp12_;
	ValaCCodeCastExpression* _tmp13_;
	ValaCCodeCastExpression* _tmp14_;
	ValaCCodeExpression* _tmp15_;
	ValaCCodeExpression* _tmp16_;
	ValaCCodeUnaryExpression* _tmp17_;
	ValaCCodeUnaryExpression* _tmp18_;
	ValaCCodeCastExpression* _tmp19_;
	ValaCCodeCastExpression* _tmp20_;
	ValaCCodeExpression* _tmp21_;
	ValaCCodeExpression* _tmp22_;
	ValaCCodeUnaryExpression* _tmp23_;
	ValaCCodeUnaryExpression* _tmp24_;
	ValaCCodeCastExpression* _tmp25_;
	ValaCCodeCastExpression* _tmp26_;
	ValaCCodeDeclaration* _cdecl_ = NULL;
	ValaCCodeDeclaration* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	ValaCCodeVariableDeclarator* _tmp34_;
	ValaCCodeVariableDeclarator* _tmp35_;
	ValaCCodeFile* _tmp36_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sym != NULL);
	_tmp0_ = vala_ccode_initializer_list_new ();
	info = _tmp0_;
	_tmp1_ = vala_ccode_constant_new ("-1");
	_tmp2_ = _tmp1_;
	vala_ccode_initializer_list_append (info, (ValaCCodeExpression*) _tmp2_);
	_vala_ccode_node_unref0 (_tmp2_);
	_tmp3_ = vala_gd_bus_module_get_dbus_name ((ValaTypeSymbol*) sym);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup_printf ("\"%s\"", _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_ccode_constant_new (_tmp6_);
	_tmp8_ = _tmp7_;
	vala_ccode_initializer_list_append (info, (ValaCCodeExpression*) _tmp8_);
	_vala_ccode_node_unref0 (_tmp8_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_tmp9_ = vala_gd_bus_module_get_method_info (self, sym);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp12_, "GDBusMethodInfo **");
	_tmp14_ = _tmp13_;
	vala_ccode_initializer_list_append (info, (ValaCCodeExpression*) _tmp14_);
	_vala_ccode_node_unref0 (_tmp14_);
	_vala_ccode_node_unref0 (_tmp12_);
	_vala_ccode_node_unref0 (_tmp10_);
	_tmp15_ = vala_gd_bus_module_get_signal_info (self, sym);
	_tmp16_ = _tmp15_;
	_tmp17_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp18_, "GDBusSignalInfo **");
	_tmp20_ = _tmp19_;
	vala_ccode_initializer_list_append (info, (ValaCCodeExpression*) _tmp20_);
	_vala_ccode_node_unref0 (_tmp20_);
	_vala_ccode_node_unref0 (_tmp18_);
	_vala_ccode_node_unref0 (_tmp16_);
	_tmp21_ = vala_gd_bus_module_get_property_info (self, sym);
	_tmp22_ = _tmp21_;
	_tmp23_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp22_);
	_tmp24_ = _tmp23_;
	_tmp25_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp24_, "GDBusPropertyInfo **");
	_tmp26_ = _tmp25_;
	vala_ccode_initializer_list_append (info, (ValaCCodeExpression*) _tmp26_);
	_vala_ccode_node_unref0 (_tmp26_);
	_vala_ccode_node_unref0 (_tmp24_);
	_vala_ccode_node_unref0 (_tmp22_);
	_tmp27_ = vala_ccode_declaration_new ("const GDBusInterfaceInfo");
	_cdecl_ = _tmp27_;
	_tmp28_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
	_tmp29_ = _tmp28_;
	_tmp30_ = g_strconcat ("_", _tmp29_, NULL);
	_tmp31_ = _tmp30_;
	_tmp32_ = g_strconcat (_tmp31_, "dbus_interface_info", NULL);
	_tmp33_ = _tmp32_;
	_tmp34_ = vala_ccode_variable_declarator_new (_tmp33_, (ValaCCodeExpression*) info, NULL);
	_tmp35_ = _tmp34_;
	vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) _tmp35_);
	_vala_ccode_node_unref0 (_tmp35_);
	_g_free0 (_tmp33_);
	_g_free0 (_tmp31_);
	_g_free0 (_tmp29_);
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _cdecl_, VALA_CCODE_MODIFIERS_STATIC);
	_tmp36_ = ((ValaCCodeBaseModule*) self)->cfile;
	vala_ccode_file_add_constant_declaration (_tmp36_, (ValaCCodeNode*) _cdecl_);
	_vala_ccode_node_unref0 (_cdecl_);
	_vala_ccode_node_unref0 (info);
}


ValaCCodeExpression*
vala_gd_bus_module_get_interface_info (ValaGDBusModule* self, 
                                       ValaObjectTypeSymbol* sym)
{
	ValaCCodeExpression* result = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	ValaCCodeIdentifier* _tmp6_;
	ValaCCodeExpression* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat ("_", _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat (_tmp3_, "dbus_interface_info", NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_ccode_identifier_new (_tmp5_);
	_tmp7_ = (ValaCCodeExpression*) _tmp6_;
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	result = _tmp7_;
	return result;
}


static void
vala_gd_bus_module_real_visit_class (ValaCodeVisitor* base, 
                                     ValaClass* cl)
{
	ValaGDBusModule * self;
	self = (ValaGDBusModule*) base;
	g_return_if_fail (cl != NULL);
	VALA_CODE_VISITOR_CLASS (vala_gd_bus_module_parent_class)->visit_class ((ValaCodeVisitor*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_GVARIANT_MODULE, ValaGVariantModule), cl);
	vala_gd_bus_module_visit_object_type_symbol (self, (ValaObjectTypeSymbol*) cl);
}


static void
vala_gd_bus_module_real_visit_interface (ValaCodeVisitor* base, 
                                         ValaInterface* iface)
{
	ValaGDBusModule * self;
	self = (ValaGDBusModule*) base;
	g_return_if_fail (iface != NULL);
	VALA_CODE_VISITOR_CLASS (vala_gd_bus_module_parent_class)->visit_interface ((ValaCodeVisitor*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_GVARIANT_MODULE, ValaGVariantModule), iface);
	vala_gd_bus_module_visit_object_type_symbol (self, (ValaObjectTypeSymbol*) iface);
}


static void
vala_gd_bus_module_visit_object_type_symbol (ValaGDBusModule* self, 
                                             ValaObjectTypeSymbol* sym)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sym != NULL);
	_tmp0_ = vala_gd_bus_module_get_dbus_name ((ValaTypeSymbol*) sym);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_ == NULL;
	_g_free0 (_tmp1_);
	if (_tmp2_) {
		return;
	}
	vala_gd_bus_module_declare_interface_info (self, sym);
}


ValaGDBusModule*
vala_gd_bus_module_construct (GType object_type)
{
	ValaGDBusModule* self = NULL;
	self = (ValaGDBusModule*) vala_gvariant_module_construct (object_type);
	return self;
}


ValaGDBusModule*
vala_gd_bus_module_new (void)
{
	return vala_gd_bus_module_construct (VALA_TYPE_GD_BUS_MODULE);
}


static void
vala_gd_bus_module_class_init (ValaGDBusModuleClass * klass)
{
	vala_gd_bus_module_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeVisitorClass *) klass)->visit_error_domain = (void (*) (ValaCodeVisitor *, ValaErrorDomain*)) vala_gd_bus_module_real_visit_error_domain;
	((ValaCodeVisitorClass *) klass)->visit_class = (void (*) (ValaCodeVisitor *, ValaClass*)) vala_gd_bus_module_real_visit_class;
	((ValaCodeVisitorClass *) klass)->visit_interface = (void (*) (ValaCodeVisitor *, ValaInterface*)) vala_gd_bus_module_real_visit_interface;
}


static void
vala_gd_bus_module_instance_init (ValaGDBusModule * self)
{
}


GType
vala_gd_bus_module_get_type (void)
{
	static volatile gsize vala_gd_bus_module_type_id__volatile = 0;
	if (g_once_init_enter (&vala_gd_bus_module_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaGDBusModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gd_bus_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGDBusModule), 0, (GInstanceInitFunc) vala_gd_bus_module_instance_init, NULL };
		GType vala_gd_bus_module_type_id;
		vala_gd_bus_module_type_id = g_type_register_static (VALA_TYPE_GVARIANT_MODULE, "ValaGDBusModule", &g_define_type_info, 0);
		g_once_init_leave (&vala_gd_bus_module_type_id__volatile, vala_gd_bus_module_type_id);
	}
	return vala_gd_bus_module_type_id__volatile;
}



