/* utils.c generated by valac, the Vala compiler
 * generated from utils.vala, do not modify */

/* utils.vala
 *
 * Copyright (C) 2010 Luca Bruno
 * Copyright (C) 2007-2009  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Luca Bruno <lethalman88@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <valadoc.h>
#include <float.h>
#include <math.h>
#include <valagee.h>
#include <stdio.h>
#include <glib/gstdio.h>
#include <gobject/gvaluecollector.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))

#define GTKDOC_TYPE_TEXT_WRITER (gtkdoc_text_writer_get_type ())
#define GTKDOC_TEXT_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKDOC_TYPE_TEXT_WRITER, GtkdocTextWriter))
#define GTKDOC_TEXT_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKDOC_TYPE_TEXT_WRITER, GtkdocTextWriterClass))
#define GTKDOC_IS_TEXT_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKDOC_TYPE_TEXT_WRITER))
#define GTKDOC_IS_TEXT_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKDOC_TYPE_TEXT_WRITER))
#define GTKDOC_TEXT_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKDOC_TYPE_TEXT_WRITER, GtkdocTextWriterClass))

typedef struct _GtkdocTextWriter GtkdocTextWriter;
typedef struct _GtkdocTextWriterClass GtkdocTextWriterClass;
typedef struct _GtkdocTextWriterPrivate GtkdocTextWriterPrivate;
enum  {
	GTKDOC_TEXT_WRITER_0_PROPERTY,
	GTKDOC_TEXT_WRITER_NUM_PROPERTIES
};
static GParamSpec* gtkdoc_text_writer_properties[GTKDOC_TEXT_WRITER_NUM_PROPERTIES];
typedef struct _GtkdocParamSpecTextWriter GtkdocParamSpecTextWriter;

struct _GtkdocTextWriter {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GtkdocTextWriterPrivate * priv;
	gchar* filename;
	gchar* mode;
};

struct _GtkdocTextWriterClass {
	GTypeClass parent_class;
	void (*finalize) (GtkdocTextWriter *self);
};

struct _GtkdocTextWriterPrivate {
	FILE* stream;
};

struct _GtkdocParamSpecTextWriter {
	GParamSpec parent_instance;
};


static gpointer gtkdoc_text_writer_parent_class = NULL;

gchar* gtkdoc_get_section (const gchar* filename);
gchar* gtkdoc_commentize (const gchar* comment);
gchar* gtkdoc_get_cname (ValadocApiItem* item);
gchar* gtkdoc_get_dbus_interface (ValadocApiItem* item);
gchar* gtkdoc_get_docbook_type_link (ValadocApiClass* cls);
gchar* gtkdoc_to_docbook_id (const gchar* name);
gchar* gtkdoc_get_gtkdoc_link (ValadocApiNode* symbol);
gchar* gtkdoc_get_docbook_link (ValadocApiItem* item, gboolean is_dbus, gboolean is_async_finish);
gdouble gtkdoc_get_parameter_pos (ValadocApiNode* node, const gchar* name);
gchar* gtkdoc_to_lower_case (const gchar* camel);
gboolean gtkdoc_package_exists (const gchar* package_name, ValadocErrorReporter* reporter);
gboolean gtkdoc_is_generated_by_vala (const gchar* filename);
gpointer gtkdoc_text_writer_ref (gpointer instance);
void gtkdoc_text_writer_unref (gpointer instance);
GParamSpec* gtkdoc_param_spec_text_writer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gtkdoc_value_set_text_writer (GValue* value, gpointer v_object);
void gtkdoc_value_take_text_writer (GValue* value, gpointer v_object);
gpointer gtkdoc_value_get_text_writer (const GValue* value);
GType gtkdoc_text_writer_get_type (void) G_GNUC_CONST;
#define GTKDOC_TEXT_WRITER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GTKDOC_TYPE_TEXT_WRITER, GtkdocTextWriterPrivate))
GtkdocTextWriter* gtkdoc_text_writer_new (const gchar* filename, const gchar* mode);
GtkdocTextWriter* gtkdoc_text_writer_construct (GType object_type, const gchar* filename, const gchar* mode);
gboolean gtkdoc_text_writer_open (GtkdocTextWriter* self);
void gtkdoc_text_writer_close (GtkdocTextWriter* self);
void gtkdoc_text_writer_write_line (GtkdocTextWriter* self, const gchar* line);
static void gtkdoc_text_writer_finalize (GtkdocTextWriter * obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	glong _tmp8_;
	glong _tmp14_;
	glong _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	gchar* _tmp22_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_;
		glong _tmp4_;
		glong _tmp5_;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_;
		gint _tmp7_;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_;
		glong _tmp10_;
		glong _tmp11_;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_;
		glong _tmp13_;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_;
		glong _tmp16_;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


static gint string_last_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_;
	gunichar _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = c;
	_tmp2_ = g_utf8_strrchr (((gchar*) self) + _tmp0_, (gssize) -1, _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


gchar* gtkdoc_get_section (const gchar* filename) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gint _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_val_if_fail (filename != NULL, NULL);
	_tmp0_ = filename;
	_tmp1_ = filename;
	_tmp2_ = string_last_index_of_char (_tmp1_, (gunichar) '.', 0);
	_tmp3_ = string_substring (_tmp0_, (glong) 0, (glong) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_path_get_basename (_tmp4_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	result = _tmp6_;
	return result;
}


static gchar* _vala_g_strjoinv (const gchar* separator, gchar** str_array, int str_array_length1) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gchar** _tmp2_;
	gint _tmp2__length1;
	_tmp0_ = separator;
	if (_tmp0_ == NULL) {
		separator = "";
	}
	_tmp2_ = str_array;
	_tmp2__length1 = str_array_length1;
	if (_tmp2_ != NULL) {
		gboolean _tmp3_ = FALSE;
		gchar** _tmp4_;
		gint _tmp4__length1;
		_tmp4_ = str_array;
		_tmp4__length1 = str_array_length1;
		if (_tmp4__length1 > 0) {
			_tmp3_ = TRUE;
		} else {
			gboolean _tmp5_ = FALSE;
			gchar** _tmp6_;
			gint _tmp6__length1;
			_tmp6_ = str_array;
			_tmp6__length1 = str_array_length1;
			if (_tmp6__length1 == -1) {
				gchar** _tmp7_;
				gint _tmp7__length1;
				const gchar* _tmp8_;
				_tmp7_ = str_array;
				_tmp7__length1 = str_array_length1;
				_tmp8_ = _tmp7_[0];
				_tmp5_ = _tmp8_ != NULL;
			} else {
				_tmp5_ = FALSE;
			}
			_tmp3_ = _tmp5_;
		}
		_tmp1_ = _tmp3_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp31_;
		gint _tmp33_;
		gint _tmp34_;
		gsize _tmp35_;
		const gchar* _tmp36_;
		gint _tmp37_;
		gint _tmp38_;
		gint _tmp39_;
		const gchar* res = NULL;
		gsize _tmp40_;
		void* _tmp41_;
		void* ptr = NULL;
		const gchar* _tmp42_;
		gchar** _tmp43_;
		gint _tmp43__length1;
		const gchar* _tmp44_;
		void* _tmp45_;
		const gchar* _tmp62_;
		len = (gsize) 1;
		{
			gboolean _tmp9_ = FALSE;
			i = 0;
			_tmp9_ = TRUE;
			while (TRUE) {
				gboolean _tmp11_ = FALSE;
				gboolean _tmp12_ = FALSE;
				gchar** _tmp13_;
				gint _tmp13__length1;
				gint _tmp21_ = 0;
				gchar** _tmp22_;
				gint _tmp22__length1;
				gint _tmp23_;
				const gchar* _tmp24_;
				gsize _tmp30_;
				if (!_tmp9_) {
					gint _tmp10_;
					_tmp10_ = i;
					i = _tmp10_ + 1;
				}
				_tmp9_ = FALSE;
				_tmp13_ = str_array;
				_tmp13__length1 = str_array_length1;
				if (_tmp13__length1 != -1) {
					gint _tmp14_;
					gchar** _tmp15_;
					gint _tmp15__length1;
					_tmp14_ = i;
					_tmp15_ = str_array;
					_tmp15__length1 = str_array_length1;
					_tmp12_ = _tmp14_ < _tmp15__length1;
				} else {
					_tmp12_ = FALSE;
				}
				if (_tmp12_) {
					_tmp11_ = TRUE;
				} else {
					gboolean _tmp16_ = FALSE;
					gchar** _tmp17_;
					gint _tmp17__length1;
					_tmp17_ = str_array;
					_tmp17__length1 = str_array_length1;
					if (_tmp17__length1 == -1) {
						gchar** _tmp18_;
						gint _tmp18__length1;
						gint _tmp19_;
						const gchar* _tmp20_;
						_tmp18_ = str_array;
						_tmp18__length1 = str_array_length1;
						_tmp19_ = i;
						_tmp20_ = _tmp18_[_tmp19_];
						_tmp16_ = _tmp20_ != NULL;
					} else {
						_tmp16_ = FALSE;
					}
					_tmp11_ = _tmp16_;
				}
				if (!_tmp11_) {
					break;
				}
				_tmp22_ = str_array;
				_tmp22__length1 = str_array_length1;
				_tmp23_ = i;
				_tmp24_ = _tmp22_[_tmp23_];
				if (_tmp24_ != NULL) {
					gchar** _tmp25_;
					gint _tmp25__length1;
					gint _tmp26_;
					const gchar* _tmp27_;
					gint _tmp28_;
					gint _tmp29_;
					_tmp25_ = str_array;
					_tmp25__length1 = str_array_length1;
					_tmp26_ = i;
					_tmp27_ = _tmp25_[_tmp26_];
					_tmp28_ = strlen ((const gchar*) _tmp27_);
					_tmp29_ = _tmp28_;
					_tmp21_ = _tmp29_;
				} else {
					_tmp21_ = 0;
				}
				_tmp30_ = len;
				len = _tmp30_ + _tmp21_;
			}
		}
		_tmp31_ = i;
		if (_tmp31_ == 0) {
			gchar* _tmp32_;
			_tmp32_ = g_strdup ("");
			result = _tmp32_;
			return result;
		}
		_tmp33_ = i;
		str_array_length1 = _tmp33_;
		_tmp34_ = str_array_length1;
		_tmp35_ = len;
		_tmp36_ = separator;
		_tmp37_ = strlen ((const gchar*) _tmp36_);
		_tmp38_ = _tmp37_;
		_tmp39_ = i;
		len = _tmp35_ + (_tmp38_ * (_tmp39_ - 1));
		_tmp40_ = len;
		_tmp41_ = g_malloc (_tmp40_);
		res = _tmp41_;
		_tmp42_ = res;
		_tmp43_ = str_array;
		_tmp43__length1 = str_array_length1;
		_tmp44_ = _tmp43_[0];
		_tmp45_ = g_stpcpy ((void*) _tmp42_, (const gchar*) _tmp44_);
		ptr = _tmp45_;
		{
			gboolean _tmp46_ = FALSE;
			i = 1;
			_tmp46_ = TRUE;
			while (TRUE) {
				gint _tmp48_;
				gchar** _tmp49_;
				gint _tmp49__length1;
				void* _tmp50_;
				const gchar* _tmp51_;
				void* _tmp52_;
				const gchar* _tmp53_ = NULL;
				gchar** _tmp54_;
				gint _tmp54__length1;
				gint _tmp55_;
				const gchar* _tmp56_;
				void* _tmp60_;
				void* _tmp61_;
				if (!_tmp46_) {
					gint _tmp47_;
					_tmp47_ = i;
					i = _tmp47_ + 1;
				}
				_tmp46_ = FALSE;
				_tmp48_ = i;
				_tmp49_ = str_array;
				_tmp49__length1 = str_array_length1;
				if (!(_tmp48_ < _tmp49__length1)) {
					break;
				}
				_tmp50_ = ptr;
				_tmp51_ = separator;
				_tmp52_ = g_stpcpy (_tmp50_, (const gchar*) _tmp51_);
				ptr = _tmp52_;
				_tmp54_ = str_array;
				_tmp54__length1 = str_array_length1;
				_tmp55_ = i;
				_tmp56_ = _tmp54_[_tmp55_];
				if (_tmp56_ != NULL) {
					gchar** _tmp57_;
					gint _tmp57__length1;
					gint _tmp58_;
					const gchar* _tmp59_;
					_tmp57_ = str_array;
					_tmp57__length1 = str_array_length1;
					_tmp58_ = i;
					_tmp59_ = _tmp57_[_tmp58_];
					_tmp53_ = (const gchar*) _tmp59_;
				} else {
					_tmp53_ = "";
				}
				_tmp60_ = ptr;
				_tmp61_ = g_stpcpy (_tmp60_, _tmp53_);
				ptr = _tmp61_;
			}
		}
		_tmp62_ = res;
		res = NULL;
		result = (gchar*) _tmp62_;
		return result;
	} else {
		gchar* _tmp63_;
		_tmp63_ = g_strdup ("");
		result = _tmp63_;
		return result;
	}
}


gchar* gtkdoc_commentize (const gchar* comment) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_val_if_fail (comment != NULL, NULL);
	_tmp0_ = comment;
	_tmp2_ = _tmp1_ = g_strsplit (_tmp0_, "\n", 0);
	_tmp3_ = _tmp2_;
	_tmp3__length1 = _vala_array_length (_tmp1_);
	_tmp4_ = _vala_g_strjoinv ("\n * ", _tmp3_, _vala_array_length (_tmp1_));
	_tmp5_ = _tmp4_;
	_tmp3_ = (_vala_array_free (_tmp3_, _tmp3__length1, (GDestroyNotify) g_free), NULL);
	result = _tmp5_;
	return result;
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp2_;
		_tmp2_ = old;
		_tmp1_ = (*((gchar*) _tmp2_)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = old;
		_tmp4_ = replacement;
		_tmp0_ = g_strcmp0 (_tmp3_, _tmp4_) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup (self);
		result = _tmp5_;
		return result;
	}
	{
		GRegex* regex = NULL;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		GRegex* _tmp9_;
		GRegex* _tmp10_;
		gchar* _tmp11_ = NULL;
		GRegex* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp6_ = old;
		_tmp7_ = g_regex_escape_string (_tmp6_, -1);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_regex_new (_tmp8_, 0, 0, &_inner_error_);
		_tmp10_ = _tmp9_;
		_g_free0 (_tmp8_);
		regex = _tmp10_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch10_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp12_ = regex;
		_tmp13_ = replacement;
		_tmp14_ = g_regex_replace_literal (_tmp12_, self, (gssize) -1, 0, _tmp13_, 0, &_inner_error_);
		_tmp11_ = _tmp14_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch10_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp15_ = _tmp11_;
		_tmp11_ = NULL;
		result = _tmp15_;
		_g_free0 (_tmp11_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally10;
	__catch10_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally10:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


gchar* gtkdoc_get_cname (ValadocApiItem* item) {
	gchar* result = NULL;
	ValadocApiItem* _tmp0_;
	g_return_val_if_fail (item != NULL, NULL);
	_tmp0_ = item;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, VALADOC_API_TYPE_METHOD)) {
		ValadocApiItem* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = item;
		_tmp2_ = valadoc_api_method_get_cname (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, VALADOC_API_TYPE_METHOD, ValadocApiMethod));
		result = _tmp2_;
		return result;
	} else {
		ValadocApiItem* _tmp3_;
		_tmp3_ = item;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, VALADOC_API_TYPE_FORMAL_PARAMETER)) {
			ValadocApiItem* _tmp4_;
			const gchar* _tmp5_;
			const gchar* _tmp6_;
			gchar* _tmp7_;
			_tmp4_ = item;
			_tmp5_ = valadoc_api_node_get_name ((ValadocApiNode*) G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, VALADOC_API_TYPE_FORMAL_PARAMETER, ValadocApiFormalParameter));
			_tmp6_ = _tmp5_;
			_tmp7_ = g_strdup (_tmp6_);
			result = _tmp7_;
			return result;
		} else {
			ValadocApiItem* _tmp8_;
			_tmp8_ = item;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, VALADOC_API_TYPE_CONSTANT)) {
				ValadocApiItem* _tmp9_;
				gchar* _tmp10_;
				_tmp9_ = item;
				_tmp10_ = valadoc_api_constant_get_cname (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, VALADOC_API_TYPE_CONSTANT, ValadocApiConstant));
				result = _tmp10_;
				return result;
			} else {
				ValadocApiItem* _tmp11_;
				_tmp11_ = item;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, VALADOC_API_TYPE_PROPERTY)) {
					ValadocApiItem* _tmp12_;
					gchar* _tmp13_;
					_tmp12_ = item;
					_tmp13_ = valadoc_api_property_get_cname (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, VALADOC_API_TYPE_PROPERTY, ValadocApiProperty));
					result = _tmp13_;
					return result;
				} else {
					ValadocApiItem* _tmp14_;
					_tmp14_ = item;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp14_, VALADOC_API_TYPE_SIGNAL)) {
						gchar* name = NULL;
						ValadocApiItem* _tmp15_;
						gchar* _tmp16_;
						const gchar* _tmp17_;
						gchar* _tmp18_;
						_tmp15_ = item;
						_tmp16_ = valadoc_api_signal_get_cname (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, VALADOC_API_TYPE_SIGNAL, ValadocApiSignal));
						name = _tmp16_;
						_tmp17_ = name;
						_tmp18_ = string_replace (_tmp17_, "_", "-");
						result = _tmp18_;
						_g_free0 (name);
						return result;
					} else {
						ValadocApiItem* _tmp19_;
						_tmp19_ = item;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp19_, VALADOC_API_TYPE_CLASS)) {
							ValadocApiItem* _tmp20_;
							gchar* _tmp21_;
							_tmp20_ = item;
							_tmp21_ = valadoc_api_class_get_cname (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, VALADOC_API_TYPE_CLASS, ValadocApiClass));
							result = _tmp21_;
							return result;
						} else {
							ValadocApiItem* _tmp22_;
							_tmp22_ = item;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp22_, VALADOC_API_TYPE_STRUCT)) {
								ValadocApiItem* _tmp23_;
								gchar* _tmp24_;
								_tmp23_ = item;
								_tmp24_ = valadoc_api_struct_get_cname (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, VALADOC_API_TYPE_STRUCT, ValadocApiStruct));
								result = _tmp24_;
								return result;
							} else {
								ValadocApiItem* _tmp25_;
								_tmp25_ = item;
								if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp25_, VALADOC_API_TYPE_INTERFACE)) {
									ValadocApiItem* _tmp26_;
									gchar* _tmp27_;
									_tmp26_ = item;
									_tmp27_ = valadoc_api_interface_get_cname (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, VALADOC_API_TYPE_INTERFACE, ValadocApiInterface));
									result = _tmp27_;
									return result;
								} else {
									ValadocApiItem* _tmp28_;
									_tmp28_ = item;
									if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp28_, VALADOC_API_TYPE_ERROR_DOMAIN)) {
										ValadocApiItem* _tmp29_;
										gchar* _tmp30_;
										_tmp29_ = item;
										_tmp30_ = valadoc_api_error_domain_get_cname (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, VALADOC_API_TYPE_ERROR_DOMAIN, ValadocApiErrorDomain));
										result = _tmp30_;
										return result;
									} else {
										ValadocApiItem* _tmp31_;
										_tmp31_ = item;
										if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp31_, VALADOC_API_TYPE_ERROR_CODE)) {
											ValadocApiItem* _tmp32_;
											gchar* _tmp33_;
											_tmp32_ = item;
											_tmp33_ = valadoc_api_error_code_get_cname (G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, VALADOC_API_TYPE_ERROR_CODE, ValadocApiErrorCode));
											result = _tmp33_;
											return result;
										} else {
											ValadocApiItem* _tmp34_;
											_tmp34_ = item;
											if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp34_, VALADOC_API_TYPE_DELEGATE)) {
												ValadocApiItem* _tmp35_;
												gchar* _tmp36_;
												_tmp35_ = item;
												_tmp36_ = valadoc_api_delegate_get_cname (G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, VALADOC_API_TYPE_DELEGATE, ValadocApiDelegate));
												result = _tmp36_;
												return result;
											} else {
												ValadocApiItem* _tmp37_;
												_tmp37_ = item;
												if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp37_, VALADOC_API_TYPE_ENUM)) {
													ValadocApiItem* _tmp38_;
													gchar* _tmp39_;
													_tmp38_ = item;
													_tmp39_ = valadoc_api_enum_get_cname (G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, VALADOC_API_TYPE_ENUM, ValadocApiEnum));
													result = _tmp39_;
													return result;
												} else {
													ValadocApiItem* _tmp40_;
													_tmp40_ = item;
													if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp40_, VALADOC_API_TYPE_ENUM_VALUE)) {
														ValadocApiItem* _tmp41_;
														gchar* _tmp42_;
														_tmp41_ = item;
														_tmp42_ = valadoc_api_enum_value_get_cname (G_TYPE_CHECK_INSTANCE_CAST (_tmp41_, VALADOC_API_TYPE_ENUM_VALUE, ValadocApiEnumValue));
														result = _tmp42_;
														return result;
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	result = NULL;
	return result;
}


gchar* gtkdoc_get_dbus_interface (ValadocApiItem* item) {
	gchar* result = NULL;
	ValadocApiItem* _tmp0_;
	g_return_val_if_fail (item != NULL, NULL);
	_tmp0_ = item;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, VALADOC_API_TYPE_CLASS)) {
		ValadocApiItem* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = item;
		_tmp2_ = valadoc_api_class_get_dbus_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, VALADOC_API_TYPE_CLASS, ValadocApiClass));
		result = _tmp2_;
		return result;
	} else {
		ValadocApiItem* _tmp3_;
		_tmp3_ = item;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, VALADOC_API_TYPE_INTERFACE)) {
			ValadocApiItem* _tmp4_;
			gchar* _tmp5_;
			_tmp4_ = item;
			_tmp5_ = valadoc_api_interface_get_dbus_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, VALADOC_API_TYPE_INTERFACE, ValadocApiInterface));
			result = _tmp5_;
			return result;
		}
	}
	result = NULL;
	return result;
}


gchar* gtkdoc_get_docbook_type_link (ValadocApiClass* cls) {
	gchar* result = NULL;
	ValadocApiClass* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	ValadocApiClass* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	g_return_val_if_fail (cls != NULL, NULL);
	_tmp0_ = cls;
	_tmp1_ = valadoc_api_class_get_type_id (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = gtkdoc_to_docbook_id (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = cls;
	_tmp6_ = valadoc_api_class_get_type_id (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strdup_printf ("<link linkend=\"%s:CAPS\"><literal>%s</literal></link>", _tmp4_, _tmp7_);
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp7_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	result = _tmp9_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


gchar* gtkdoc_get_gtkdoc_link (ValadocApiNode* symbol) {
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	ValadocApiNode* _tmp4_;
	ValadocApiNode* _tmp14_;
	gboolean _tmp20_ = FALSE;
	gboolean _tmp21_ = FALSE;
	ValadocApiNode* _tmp22_;
	ValadocApiNode* _tmp30_;
	ValadocApiNode* _tmp41_;
	gboolean _tmp52_ = FALSE;
	ValadocApiNode* _tmp53_;
	gchar* _tmp78_ = NULL;
	ValadocApiNode* _tmp79_;
	gchar* _tmp80_;
	gchar* _tmp83_;
	g_return_val_if_fail (symbol != NULL, NULL);
	_tmp4_ = symbol;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, VALADOC_API_TYPE_CLASS)) {
		_tmp3_ = TRUE;
	} else {
		ValadocApiNode* _tmp5_;
		_tmp5_ = symbol;
		_tmp3_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, VALADOC_API_TYPE_INTERFACE);
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		ValadocApiNode* _tmp6_;
		_tmp6_ = symbol;
		_tmp2_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, VALADOC_API_TYPE_STRUCT);
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		ValadocApiNode* _tmp7_;
		_tmp7_ = symbol;
		_tmp1_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALADOC_API_TYPE_ENUM);
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		ValadocApiNode* _tmp8_;
		_tmp8_ = symbol;
		_tmp0_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, VALADOC_API_TYPE_ERROR_DOMAIN);
	}
	if (_tmp0_) {
		ValadocApiNode* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp9_ = symbol;
		_tmp10_ = gtkdoc_get_cname ((ValadocApiItem*) _tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_strdup_printf ("#%s", _tmp11_);
		_tmp13_ = _tmp12_;
		_g_free0 (_tmp11_);
		result = _tmp13_;
		return result;
	}
	_tmp14_ = symbol;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp14_, VALADOC_API_TYPE_METHOD)) {
		ValadocApiNode* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		_tmp15_ = symbol;
		_tmp16_ = valadoc_api_method_get_cname (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, VALADOC_API_TYPE_METHOD, ValadocApiMethod));
		_tmp17_ = _tmp16_;
		_tmp18_ = g_strdup_printf ("%s ()", _tmp17_);
		_tmp19_ = _tmp18_;
		_g_free0 (_tmp17_);
		result = _tmp19_;
		return result;
	}
	_tmp22_ = symbol;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp22_, VALADOC_API_TYPE_CONSTANT)) {
		_tmp21_ = TRUE;
	} else {
		ValadocApiNode* _tmp23_;
		_tmp23_ = symbol;
		_tmp21_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp23_, VALADOC_API_TYPE_ENUM_VALUE);
	}
	if (_tmp21_) {
		_tmp20_ = TRUE;
	} else {
		ValadocApiNode* _tmp24_;
		_tmp24_ = symbol;
		_tmp20_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp24_, VALADOC_API_TYPE_ERROR_CODE);
	}
	if (_tmp20_) {
		ValadocApiNode* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		_tmp25_ = symbol;
		_tmp26_ = gtkdoc_get_cname ((ValadocApiItem*) _tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = g_strdup_printf ("%%%s", _tmp27_);
		_tmp29_ = _tmp28_;
		_g_free0 (_tmp27_);
		result = _tmp29_;
		return result;
	}
	_tmp30_ = symbol;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp30_, VALADOC_API_TYPE_SIGNAL)) {
		ValadocApiNode* _tmp31_;
		ValadocApiItem* _tmp32_;
		ValadocApiItem* _tmp33_;
		gchar* _tmp34_;
		gchar* _tmp35_;
		ValadocApiNode* _tmp36_;
		gchar* _tmp37_;
		gchar* _tmp38_;
		gchar* _tmp39_;
		gchar* _tmp40_;
		_tmp31_ = symbol;
		_tmp32_ = valadoc_api_item_get_parent ((ValadocApiItem*) _tmp31_);
		_tmp33_ = _tmp32_;
		_tmp34_ = gtkdoc_get_cname (_tmp33_);
		_tmp35_ = _tmp34_;
		_tmp36_ = symbol;
		_tmp37_ = valadoc_api_signal_get_cname (G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, VALADOC_API_TYPE_SIGNAL, ValadocApiSignal));
		_tmp38_ = _tmp37_;
		_tmp39_ = g_strdup_printf ("#%s::%s", _tmp35_, _tmp38_);
		_tmp40_ = _tmp39_;
		_g_free0 (_tmp38_);
		_g_free0 (_tmp35_);
		result = _tmp40_;
		return result;
	}
	_tmp41_ = symbol;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp41_, VALADOC_API_TYPE_PROPERTY)) {
		ValadocApiNode* _tmp42_;
		ValadocApiItem* _tmp43_;
		ValadocApiItem* _tmp44_;
		gchar* _tmp45_;
		gchar* _tmp46_;
		ValadocApiNode* _tmp47_;
		gchar* _tmp48_;
		gchar* _tmp49_;
		gchar* _tmp50_;
		gchar* _tmp51_;
		_tmp42_ = symbol;
		_tmp43_ = valadoc_api_item_get_parent ((ValadocApiItem*) _tmp42_);
		_tmp44_ = _tmp43_;
		_tmp45_ = gtkdoc_get_cname (_tmp44_);
		_tmp46_ = _tmp45_;
		_tmp47_ = symbol;
		_tmp48_ = valadoc_api_property_get_cname (G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, VALADOC_API_TYPE_PROPERTY, ValadocApiProperty));
		_tmp49_ = _tmp48_;
		_tmp50_ = g_strdup_printf ("#%s:%s", _tmp46_, _tmp49_);
		_tmp51_ = _tmp50_;
		_g_free0 (_tmp49_);
		_g_free0 (_tmp46_);
		result = _tmp51_;
		return result;
	}
	_tmp53_ = symbol;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp53_, VALADOC_API_TYPE_FIELD)) {
		gboolean _tmp54_ = FALSE;
		ValadocApiNode* _tmp55_;
		ValadocApiItem* _tmp56_;
		ValadocApiItem* _tmp57_;
		_tmp55_ = symbol;
		_tmp56_ = valadoc_api_item_get_parent ((ValadocApiItem*) _tmp55_);
		_tmp57_ = _tmp56_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp57_, VALADOC_API_TYPE_CLASS)) {
			_tmp54_ = TRUE;
		} else {
			ValadocApiNode* _tmp58_;
			ValadocApiItem* _tmp59_;
			ValadocApiItem* _tmp60_;
			_tmp58_ = symbol;
			_tmp59_ = valadoc_api_item_get_parent ((ValadocApiItem*) _tmp58_);
			_tmp60_ = _tmp59_;
			_tmp54_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp60_, VALADOC_API_TYPE_STRUCT);
		}
		_tmp52_ = _tmp54_;
	} else {
		_tmp52_ = FALSE;
	}
	if (_tmp52_) {
		ValadocApiField* field = NULL;
		ValadocApiNode* _tmp61_;
		ValadocApiField* _tmp62_;
		ValadocApiField* _tmp63_;
		gboolean _tmp64_;
		gboolean _tmp65_;
		_tmp61_ = symbol;
		_tmp62_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp61_, VALADOC_API_TYPE_FIELD) ? ((ValadocApiField*) _tmp61_) : NULL);
		field = _tmp62_;
		_tmp63_ = field;
		_tmp64_ = valadoc_api_field_get_is_static (_tmp63_);
		_tmp65_ = _tmp64_;
		if (_tmp65_) {
			ValadocApiField* _tmp66_;
			gchar* _tmp67_;
			_tmp66_ = field;
			_tmp67_ = valadoc_api_field_get_cname (_tmp66_);
			result = _tmp67_;
			_g_object_unref0 (field);
			return result;
		} else {
			ValadocApiNode* _tmp68_;
			ValadocApiItem* _tmp69_;
			ValadocApiItem* _tmp70_;
			gchar* _tmp71_;
			gchar* _tmp72_;
			ValadocApiField* _tmp73_;
			gchar* _tmp74_;
			gchar* _tmp75_;
			gchar* _tmp76_;
			gchar* _tmp77_;
			_tmp68_ = symbol;
			_tmp69_ = valadoc_api_item_get_parent ((ValadocApiItem*) _tmp68_);
			_tmp70_ = _tmp69_;
			_tmp71_ = gtkdoc_get_cname (_tmp70_);
			_tmp72_ = _tmp71_;
			_tmp73_ = field;
			_tmp74_ = valadoc_api_field_get_cname (_tmp73_);
			_tmp75_ = _tmp74_;
			_tmp76_ = g_strdup_printf ("#%s.%s", _tmp72_, _tmp75_);
			_tmp77_ = _tmp76_;
			_g_free0 (_tmp75_);
			_g_free0 (_tmp72_);
			result = _tmp77_;
			_g_object_unref0 (field);
			return result;
		}
		_g_object_unref0 (field);
	}
	_tmp79_ = symbol;
	_tmp80_ = gtkdoc_get_cname ((ValadocApiItem*) _tmp79_);
	_tmp78_ = _tmp80_;
	if (_tmp78_ == NULL) {
		ValadocApiNode* _tmp81_;
		gchar* _tmp82_;
		_tmp81_ = symbol;
		_tmp82_ = valadoc_api_node_get_full_name (_tmp81_);
		_g_free0 (_tmp78_);
		_tmp78_ = _tmp82_;
	}
	_tmp83_ = _tmp78_;
	_tmp78_ = NULL;
	result = _tmp83_;
	_g_free0 (_tmp78_);
	return result;
}


gchar* gtkdoc_get_docbook_link (ValadocApiItem* item, gboolean is_dbus, gboolean is_async_finish) {
	gchar* result = NULL;
	ValadocApiItem* _tmp0_;
	g_return_val_if_fail (item != NULL, NULL);
	_tmp0_ = item;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, VALADOC_API_TYPE_METHOD)) {
		gchar* name = NULL;
		gchar* parent = NULL;
		gboolean _tmp1_;
		const gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		const gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		const gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		_tmp1_ = is_dbus;
		if (_tmp1_) {
			ValadocApiItem* _tmp2_;
			gchar* _tmp3_;
			ValadocApiItem* _tmp4_;
			ValadocApiItem* _tmp5_;
			ValadocApiItem* _tmp6_;
			gchar* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			_tmp2_ = item;
			_tmp3_ = valadoc_api_method_get_dbus_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, VALADOC_API_TYPE_METHOD, ValadocApiMethod));
			_g_free0 (name);
			name = _tmp3_;
			_tmp4_ = item;
			_tmp5_ = valadoc_api_item_get_parent (_tmp4_);
			_tmp6_ = _tmp5_;
			_tmp7_ = gtkdoc_get_dbus_interface (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = g_strdup_printf ("%s-", _tmp8_);
			_g_free0 (parent);
			parent = _tmp9_;
			_g_free0 (_tmp8_);
		} else {
			gboolean _tmp10_;
			gchar* _tmp15_;
			_tmp10_ = is_async_finish;
			if (!_tmp10_) {
				ValadocApiItem* _tmp11_;
				gchar* _tmp12_;
				_tmp11_ = item;
				_tmp12_ = valadoc_api_method_get_cname (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, VALADOC_API_TYPE_METHOD, ValadocApiMethod));
				_g_free0 (name);
				name = _tmp12_;
			} else {
				ValadocApiItem* _tmp13_;
				gchar* _tmp14_;
				_tmp13_ = item;
				_tmp14_ = valadoc_api_method_get_finish_function_cname (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, VALADOC_API_TYPE_METHOD, ValadocApiMethod));
				_g_free0 (name);
				name = _tmp14_;
			}
			_tmp15_ = g_strdup ("");
			_g_free0 (parent);
			parent = _tmp15_;
		}
		_tmp16_ = parent;
		_tmp17_ = gtkdoc_to_docbook_id (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = name;
		_tmp20_ = gtkdoc_to_docbook_id (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = name;
		_tmp23_ = g_strdup_printf ("<link linkend=\"%s%s\"><function>%s()</function></link>", _tmp18_, _tmp21_, _tmp22_);
		_tmp24_ = _tmp23_;
		_g_free0 (_tmp21_);
		_g_free0 (_tmp18_);
		result = _tmp24_;
		_g_free0 (parent);
		_g_free0 (name);
		return result;
	} else {
		ValadocApiItem* _tmp25_;
		_tmp25_ = item;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp25_, VALADOC_API_TYPE_FORMAL_PARAMETER)) {
			ValadocApiItem* _tmp26_;
			const gchar* _tmp27_;
			const gchar* _tmp28_;
			gchar* _tmp29_;
			_tmp26_ = item;
			_tmp27_ = valadoc_api_node_get_name ((ValadocApiNode*) G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, VALADOC_API_TYPE_FORMAL_PARAMETER, ValadocApiFormalParameter));
			_tmp28_ = _tmp27_;
			_tmp29_ = g_strdup_printf ("<parameter>%s</parameter>", _tmp28_);
			result = _tmp29_;
			return result;
		} else {
			ValadocApiItem* _tmp30_;
			_tmp30_ = item;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp30_, VALADOC_API_TYPE_CONSTANT)) {
				gchar* cname = NULL;
				ValadocApiItem* _tmp31_;
				gchar* _tmp32_;
				const gchar* _tmp33_;
				gchar* _tmp34_;
				gchar* _tmp35_;
				const gchar* _tmp36_;
				gchar* _tmp37_;
				gchar* _tmp38_;
				_tmp31_ = item;
				_tmp32_ = valadoc_api_constant_get_cname (G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, VALADOC_API_TYPE_CONSTANT, ValadocApiConstant));
				cname = _tmp32_;
				_tmp33_ = cname;
				_tmp34_ = gtkdoc_to_docbook_id (_tmp33_);
				_tmp35_ = _tmp34_;
				_tmp36_ = cname;
				_tmp37_ = g_strdup_printf ("<link linkend=\"%s:CAPS\"><literal>%s</literal></link>", _tmp35_, _tmp36_);
				_tmp38_ = _tmp37_;
				_g_free0 (_tmp35_);
				result = _tmp38_;
				_g_free0 (cname);
				return result;
			} else {
				ValadocApiItem* _tmp39_;
				_tmp39_ = item;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp39_, VALADOC_API_TYPE_ERROR_CODE)) {
					gchar* cname = NULL;
					ValadocApiItem* _tmp40_;
					gchar* _tmp41_;
					const gchar* _tmp42_;
					gchar* _tmp43_;
					gchar* _tmp44_;
					const gchar* _tmp45_;
					gchar* _tmp46_;
					gchar* _tmp47_;
					_tmp40_ = item;
					_tmp41_ = valadoc_api_error_code_get_cname (G_TYPE_CHECK_INSTANCE_CAST (_tmp40_, VALADOC_API_TYPE_ERROR_CODE, ValadocApiErrorCode));
					cname = _tmp41_;
					_tmp42_ = cname;
					_tmp43_ = gtkdoc_to_docbook_id (_tmp42_);
					_tmp44_ = _tmp43_;
					_tmp45_ = cname;
					_tmp46_ = g_strdup_printf ("<link linkend=\"%s:CAPS\"><literal>%s</literal></link>", _tmp44_, _tmp45_);
					_tmp47_ = _tmp46_;
					_g_free0 (_tmp44_);
					result = _tmp47_;
					_g_free0 (cname);
					return result;
				} else {
					ValadocApiItem* _tmp48_;
					_tmp48_ = item;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp48_, VALADOC_API_TYPE_PROPERTY)) {
						gchar* name = NULL;
						gchar* parent = NULL;
						gboolean _tmp49_;
						const gchar* _tmp62_;
						gchar* _tmp63_;
						gchar* _tmp64_;
						const gchar* _tmp65_;
						gchar* _tmp66_;
						gchar* _tmp67_;
						const gchar* _tmp68_;
						gchar* _tmp69_;
						gchar* _tmp70_;
						_tmp49_ = is_dbus;
						if (_tmp49_) {
							ValadocApiItem* _tmp50_;
							gchar* _tmp51_;
							ValadocApiItem* _tmp52_;
							ValadocApiItem* _tmp53_;
							ValadocApiItem* _tmp54_;
							gchar* _tmp55_;
							_tmp50_ = item;
							_tmp51_ = valadoc_api_property_get_dbus_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp50_, VALADOC_API_TYPE_PROPERTY, ValadocApiProperty));
							_g_free0 (name);
							name = _tmp51_;
							_tmp52_ = item;
							_tmp53_ = valadoc_api_item_get_parent (_tmp52_);
							_tmp54_ = _tmp53_;
							_tmp55_ = gtkdoc_get_dbus_interface (_tmp54_);
							_g_free0 (parent);
							parent = _tmp55_;
						} else {
							ValadocApiItem* _tmp56_;
							gchar* _tmp57_;
							ValadocApiItem* _tmp58_;
							ValadocApiItem* _tmp59_;
							ValadocApiItem* _tmp60_;
							gchar* _tmp61_;
							_tmp56_ = item;
							_tmp57_ = valadoc_api_property_get_cname (G_TYPE_CHECK_INSTANCE_CAST (_tmp56_, VALADOC_API_TYPE_PROPERTY, ValadocApiProperty));
							_g_free0 (name);
							name = _tmp57_;
							_tmp58_ = item;
							_tmp59_ = valadoc_api_item_get_parent (_tmp58_);
							_tmp60_ = _tmp59_;
							_tmp61_ = gtkdoc_get_cname (_tmp60_);
							_g_free0 (parent);
							parent = _tmp61_;
						}
						_tmp62_ = parent;
						_tmp63_ = gtkdoc_to_docbook_id (_tmp62_);
						_tmp64_ = _tmp63_;
						_tmp65_ = name;
						_tmp66_ = gtkdoc_to_docbook_id (_tmp65_);
						_tmp67_ = _tmp66_;
						_tmp68_ = name;
						_tmp69_ = g_strdup_printf ("<link linkend=\"%s--%s\"><type>\"%s\"</type></link>", _tmp64_, _tmp67_, _tmp68_);
						_tmp70_ = _tmp69_;
						_g_free0 (_tmp67_);
						_g_free0 (_tmp64_);
						result = _tmp70_;
						_g_free0 (parent);
						_g_free0 (name);
						return result;
					} else {
						ValadocApiItem* _tmp71_;
						_tmp71_ = item;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp71_, VALADOC_API_TYPE_SIGNAL)) {
							gchar* name = NULL;
							gchar* parent = NULL;
							gboolean _tmp72_;
							const gchar* _tmp87_;
							gchar* _tmp88_;
							gchar* _tmp89_;
							const gchar* _tmp90_;
							gchar* _tmp91_;
							gchar* _tmp92_;
							const gchar* _tmp93_;
							gchar* _tmp94_;
							gchar* _tmp95_;
							_tmp72_ = is_dbus;
							if (_tmp72_) {
								ValadocApiItem* _tmp73_;
								gchar* _tmp74_;
								ValadocApiItem* _tmp75_;
								ValadocApiItem* _tmp76_;
								ValadocApiItem* _tmp77_;
								gchar* _tmp78_;
								_tmp73_ = item;
								_tmp74_ = valadoc_api_signal_get_dbus_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp73_, VALADOC_API_TYPE_SIGNAL, ValadocApiSignal));
								_g_free0 (name);
								name = _tmp74_;
								_tmp75_ = item;
								_tmp76_ = valadoc_api_item_get_parent (_tmp75_);
								_tmp77_ = _tmp76_;
								_tmp78_ = gtkdoc_get_dbus_interface (_tmp77_);
								_g_free0 (parent);
								parent = _tmp78_;
							} else {
								ValadocApiItem* _tmp79_;
								gchar* _tmp80_;
								const gchar* _tmp81_;
								gchar* _tmp82_;
								ValadocApiItem* _tmp83_;
								ValadocApiItem* _tmp84_;
								ValadocApiItem* _tmp85_;
								gchar* _tmp86_;
								_tmp79_ = item;
								_tmp80_ = valadoc_api_signal_get_cname (G_TYPE_CHECK_INSTANCE_CAST (_tmp79_, VALADOC_API_TYPE_SIGNAL, ValadocApiSignal));
								_g_free0 (name);
								name = _tmp80_;
								_tmp81_ = name;
								_tmp82_ = string_replace (_tmp81_, "_", "-");
								_g_free0 (name);
								name = _tmp82_;
								_tmp83_ = item;
								_tmp84_ = valadoc_api_item_get_parent (_tmp83_);
								_tmp85_ = _tmp84_;
								_tmp86_ = gtkdoc_get_cname (_tmp85_);
								_g_free0 (parent);
								parent = _tmp86_;
							}
							_tmp87_ = parent;
							_tmp88_ = gtkdoc_to_docbook_id (_tmp87_);
							_tmp89_ = _tmp88_;
							_tmp90_ = name;
							_tmp91_ = gtkdoc_to_docbook_id (_tmp90_);
							_tmp92_ = _tmp91_;
							_tmp93_ = name;
							_tmp94_ = g_strdup_printf ("<link linkend=\"%s-%s\"><type>\"%s\"</type></link>", _tmp89_, _tmp92_, _tmp93_);
							_tmp95_ = _tmp94_;
							_g_free0 (_tmp92_);
							_g_free0 (_tmp89_);
							result = _tmp95_;
							_g_free0 (parent);
							_g_free0 (name);
							return result;
						} else {
							gchar* cname = NULL;
							ValadocApiItem* _tmp96_;
							gchar* _tmp97_;
							const gchar* _tmp98_;
							_tmp96_ = item;
							_tmp97_ = gtkdoc_get_cname (_tmp96_);
							cname = _tmp97_;
							_tmp98_ = cname;
							if (_tmp98_ != NULL) {
								const gchar* _tmp99_;
								gchar* _tmp100_;
								gchar* _tmp101_;
								const gchar* _tmp102_;
								gchar* _tmp103_;
								gchar* _tmp104_;
								_tmp99_ = cname;
								_tmp100_ = gtkdoc_to_docbook_id (_tmp99_);
								_tmp101_ = _tmp100_;
								_tmp102_ = cname;
								_tmp103_ = g_strdup_printf ("<link linkend=\"%s\"><type>%s</type></link>", _tmp101_, _tmp102_);
								_tmp104_ = _tmp103_;
								_g_free0 (_tmp101_);
								result = _tmp104_;
								_g_free0 (cname);
								return result;
							}
							_g_free0 (cname);
						}
					}
				}
			}
		}
	}
	result = NULL;
	return result;
}


gdouble gtkdoc_get_parameter_pos (ValadocApiNode* node, const gchar* name) {
	gdouble result = 0.0;
	gdouble pos = 0.0;
	g_return_val_if_fail (node != NULL, 0.0);
	g_return_val_if_fail (name != NULL, 0.0);
	pos = (gdouble) 1;
	{
		ValaList* _param_list = NULL;
		ValadocApiNode* _tmp0_;
		ValaList* _tmp1_;
		gint _param_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _param_index = 0;
		_tmp0_ = node;
		_tmp1_ = valadoc_api_node_get_children_by_type (_tmp0_, VALADOC_API_NODE_TYPE_FORMAL_PARAMETER, TRUE);
		_param_list = _tmp1_;
		_tmp2_ = _param_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_param_size = _tmp4_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValadocApiNode* param = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValadocApiNode* _tmp11_;
			const gchar* _tmp12_;
			const gchar* _tmp13_;
			const gchar* _tmp14_;
			gdouble _tmp15_;
			_tmp5_ = _param_index;
			_param_index = _tmp5_ + 1;
			_tmp6_ = _param_index;
			_tmp7_ = _param_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _param_list;
			_tmp9_ = _param_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			param = (ValadocApiNode*) _tmp10_;
			_tmp11_ = param;
			_tmp12_ = valadoc_api_node_get_name (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = name;
			if (g_strcmp0 (_tmp13_, _tmp14_) == 0) {
				result = pos;
				_g_object_unref0 (param);
				_vala_iterable_unref0 (_param_list);
				return result;
			}
			_tmp15_ = pos;
			pos = _tmp15_ + 1;
			_g_object_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	result = (gdouble) -1;
	return result;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


gchar* gtkdoc_to_lower_case (const gchar* camel) {
	gchar* result = NULL;
	GString* builder = NULL;
	GString* _tmp0_;
	gboolean last_upper = FALSE;
	GString* _tmp22_;
	const gchar* _tmp23_;
	gchar* _tmp24_;
	g_return_val_if_fail (camel != NULL, NULL);
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	last_upper = TRUE;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint _tmp3_;
				const gchar* _tmp4_;
				gint _tmp5_;
				gint _tmp6_;
				const gchar* _tmp7_;
				gint _tmp8_;
				gchar _tmp9_;
				gboolean _tmp10_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = i;
				_tmp4_ = camel;
				_tmp5_ = strlen (_tmp4_);
				_tmp6_ = _tmp5_;
				if (!(_tmp3_ < _tmp6_)) {
					break;
				}
				_tmp7_ = camel;
				_tmp8_ = i;
				_tmp9_ = string_get (_tmp7_, (glong) _tmp8_);
				_tmp10_ = g_ascii_isupper (_tmp9_);
				if (_tmp10_) {
					gboolean _tmp11_;
					GString* _tmp13_;
					const gchar* _tmp14_;
					gint _tmp15_;
					gchar _tmp16_;
					gchar _tmp17_;
					_tmp11_ = last_upper;
					if (!_tmp11_) {
						GString* _tmp12_;
						_tmp12_ = builder;
						g_string_append_c (_tmp12_, '_');
					}
					_tmp13_ = builder;
					_tmp14_ = camel;
					_tmp15_ = i;
					_tmp16_ = string_get (_tmp14_, (glong) _tmp15_);
					_tmp17_ = g_ascii_tolower (_tmp16_);
					g_string_append_unichar (_tmp13_, (gunichar) _tmp17_);
					last_upper = TRUE;
				} else {
					GString* _tmp18_;
					const gchar* _tmp19_;
					gint _tmp20_;
					gchar _tmp21_;
					_tmp18_ = builder;
					_tmp19_ = camel;
					_tmp20_ = i;
					_tmp21_ = string_get (_tmp19_, (glong) _tmp20_);
					g_string_append_unichar (_tmp18_, (gunichar) _tmp21_);
					last_upper = FALSE;
				}
			}
		}
	}
	_tmp22_ = builder;
	_tmp23_ = _tmp22_->str;
	_tmp24_ = g_strdup (_tmp23_);
	result = _tmp24_;
	_g_string_free0 (builder);
	return result;
}


gchar* gtkdoc_to_docbook_id (const gchar* name) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = name;
	_tmp1_ = string_replace (_tmp0_, ".", "-");
	_tmp2_ = _tmp1_;
	_tmp3_ = string_replace (_tmp2_, "_", "-");
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	result = _tmp4_;
	return result;
}


gboolean gtkdoc_package_exists (const gchar* package_name, ValadocErrorReporter* reporter) {
	gboolean result = FALSE;
	gchar* pc = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gint exit_status = 0;
	gboolean _tmp8_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (package_name != NULL, FALSE);
	g_return_val_if_fail (reporter != NULL, FALSE);
	_tmp0_ = package_name;
	_tmp1_ = g_strconcat ("pkg-config --exists ", _tmp0_, NULL);
	pc = _tmp1_;
	{
		gint _tmp2_ = 0;
		g_spawn_command_line_sync (pc, NULL, NULL, &_tmp2_, &_inner_error_);
		exit_status = _tmp2_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gboolean _tmp3_ = FALSE;
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch11_g_spawn_error;
			}
			_g_free0 (pc);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp3_;
		}
		result = 0 == exit_status;
		_g_free0 (pc);
		return result;
	}
	goto __finally11;
	__catch11_g_spawn_error:
	{
		GError* e = NULL;
		ValadocErrorReporter* _tmp4_;
		const gchar* _tmp5_;
		GError* _tmp6_;
		const gchar* _tmp7_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = reporter;
		_tmp5_ = package_name;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		valadoc_error_reporter_simple_warning (_tmp4_, "GtkDoc", "Error pkg-config --exists %s: %s", _tmp5_, _tmp7_);
		result = FALSE;
		_g_error_free0 (e);
		_g_free0 (pc);
		return result;
	}
	__finally11:
	_g_free0 (pc);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return _tmp8_;
}


static gchar* g_file_stream_read_line (FILE* self) {
	gchar* result = NULL;
	gint c = 0;
	GString* ret = NULL;
	GString* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	ret = NULL;
	while (TRUE) {
		gint _tmp0_;
		gint _tmp1_;
		GString* _tmp2_;
		gint _tmp4_;
		GString* _tmp5_;
		gint _tmp6_;
		_tmp0_ = fgetc (self);
		c = _tmp0_;
		_tmp1_ = c;
		if (!(_tmp1_ != EOF)) {
			break;
		}
		_tmp2_ = ret;
		if (_tmp2_ == NULL) {
			GString* _tmp3_;
			_tmp3_ = g_string_new ("");
			_g_string_free0 (ret);
			ret = _tmp3_;
		}
		_tmp4_ = c;
		if (_tmp4_ == ((gint) '\n')) {
			break;
		}
		_tmp5_ = ret;
		_tmp6_ = c;
		g_string_append_c ((GString*) _tmp5_, (gchar) _tmp6_);
	}
	_tmp7_ = ret;
	if (_tmp7_ == NULL) {
		result = NULL;
		_g_string_free0 (ret);
		return result;
	} else {
		GString* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp8_ = ret;
		_tmp9_ = ((GString*) _tmp8_)->str;
		_tmp10_ = g_strdup (_tmp9_);
		result = _tmp10_;
		_g_string_free0 (ret);
		return result;
	}
	_g_string_free0 (ret);
}


static gint string_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = needle;
	_tmp2_ = strstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


gboolean gtkdoc_is_generated_by_vala (const gchar* filename) {
	gboolean result = FALSE;
	FILE* stream = NULL;
	const gchar* _tmp0_;
	FILE* _tmp1_;
	FILE* _tmp2_;
	g_return_val_if_fail (filename != NULL, FALSE);
	_tmp0_ = filename;
	_tmp1_ = g_fopen (_tmp0_, "r");
	stream = _tmp1_;
	_tmp2_ = stream;
	if (_tmp2_ != NULL) {
		gchar* line = NULL;
		FILE* _tmp3_;
		gchar* _tmp4_;
		const gchar* _tmp5_;
		_tmp3_ = stream;
		_tmp4_ = g_file_stream_read_line (_tmp3_);
		line = _tmp4_;
		_tmp5_ = line;
		if (_tmp5_ != NULL) {
			const gchar* _tmp6_;
			gint _tmp7_;
			_tmp6_ = line;
			_tmp7_ = string_index_of (_tmp6_, "generated by valac", 0);
			result = _tmp7_ >= 0;
			_g_free0 (line);
			_fclose0 (stream);
			return result;
		}
		_g_free0 (line);
	}
	result = FALSE;
	_fclose0 (stream);
	return result;
}


GtkdocTextWriter* gtkdoc_text_writer_construct (GType object_type, const gchar* filename, const gchar* mode) {
	GtkdocTextWriter* self = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (filename != NULL, NULL);
	g_return_val_if_fail (mode != NULL, NULL);
	self = (GtkdocTextWriter*) g_type_create_instance (object_type);
	_tmp0_ = filename;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->filename);
	self->filename = _tmp1_;
	_tmp2_ = mode;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (self->mode);
	self->mode = _tmp3_;
	return self;
}


GtkdocTextWriter* gtkdoc_text_writer_new (const gchar* filename, const gchar* mode) {
	return gtkdoc_text_writer_construct (GTKDOC_TYPE_TEXT_WRITER, filename, mode);
}


gboolean gtkdoc_text_writer_open (GtkdocTextWriter* self) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	FILE* _tmp2_;
	FILE* _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->filename;
	_tmp1_ = self->mode;
	_tmp2_ = g_fopen (_tmp0_, _tmp1_);
	_fclose0 (self->priv->stream);
	self->priv->stream = _tmp2_;
	_tmp3_ = self->priv->stream;
	result = _tmp3_ != NULL;
	return result;
}


void gtkdoc_text_writer_close (GtkdocTextWriter* self) {
	g_return_if_fail (self != NULL);
	_fclose0 (self->priv->stream);
	self->priv->stream = NULL;
}


void gtkdoc_text_writer_write_line (GtkdocTextWriter* self, const gchar* line) {
	FILE* _tmp0_;
	const gchar* _tmp1_;
	FILE* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (line != NULL);
	_tmp0_ = self->priv->stream;
	_tmp1_ = line;
	fputs (_tmp1_, _tmp0_);
	_tmp2_ = self->priv->stream;
	fputc ('\n', _tmp2_);
}


static void gtkdoc_value_text_writer_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void gtkdoc_value_text_writer_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		gtkdoc_text_writer_unref (value->data[0].v_pointer);
	}
}


static void gtkdoc_value_text_writer_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = gtkdoc_text_writer_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer gtkdoc_value_text_writer_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* gtkdoc_value_text_writer_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		GtkdocTextWriter * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = gtkdoc_text_writer_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* gtkdoc_value_text_writer_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	GtkdocTextWriter ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = gtkdoc_text_writer_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* gtkdoc_param_spec_text_writer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	GtkdocParamSpecTextWriter* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GTKDOC_TYPE_TEXT_WRITER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer gtkdoc_value_get_text_writer (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GTKDOC_TYPE_TEXT_WRITER), NULL);
	return value->data[0].v_pointer;
}


void gtkdoc_value_set_text_writer (GValue* value, gpointer v_object) {
	GtkdocTextWriter * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GTKDOC_TYPE_TEXT_WRITER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GTKDOC_TYPE_TEXT_WRITER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		gtkdoc_text_writer_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gtkdoc_text_writer_unref (old);
	}
}


void gtkdoc_value_take_text_writer (GValue* value, gpointer v_object) {
	GtkdocTextWriter * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GTKDOC_TYPE_TEXT_WRITER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GTKDOC_TYPE_TEXT_WRITER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gtkdoc_text_writer_unref (old);
	}
}


static void gtkdoc_text_writer_class_init (GtkdocTextWriterClass * klass) {
	gtkdoc_text_writer_parent_class = g_type_class_peek_parent (klass);
	((GtkdocTextWriterClass *) klass)->finalize = gtkdoc_text_writer_finalize;
	g_type_class_add_private (klass, sizeof (GtkdocTextWriterPrivate));
}


static void gtkdoc_text_writer_instance_init (GtkdocTextWriter * self) {
	self->priv = GTKDOC_TEXT_WRITER_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void gtkdoc_text_writer_finalize (GtkdocTextWriter * obj) {
	GtkdocTextWriter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GTKDOC_TYPE_TEXT_WRITER, GtkdocTextWriter);
	g_signal_handlers_destroy (self);
	_g_free0 (self->filename);
	_g_free0 (self->mode);
	_fclose0 (self->priv->stream);
}


GType gtkdoc_text_writer_get_type (void) {
	static volatile gsize gtkdoc_text_writer_type_id__volatile = 0;
	if (g_once_init_enter (&gtkdoc_text_writer_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { gtkdoc_value_text_writer_init, gtkdoc_value_text_writer_free_value, gtkdoc_value_text_writer_copy_value, gtkdoc_value_text_writer_peek_pointer, "p", gtkdoc_value_text_writer_collect_value, "p", gtkdoc_value_text_writer_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (GtkdocTextWriterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gtkdoc_text_writer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GtkdocTextWriter), 0, (GInstanceInitFunc) gtkdoc_text_writer_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType gtkdoc_text_writer_type_id;
		gtkdoc_text_writer_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GtkdocTextWriter", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&gtkdoc_text_writer_type_id__volatile, gtkdoc_text_writer_type_id);
	}
	return gtkdoc_text_writer_type_id__volatile;
}


gpointer gtkdoc_text_writer_ref (gpointer instance) {
	GtkdocTextWriter * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void gtkdoc_text_writer_unref (gpointer instance) {
	GtkdocTextWriter * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GTKDOC_TEXT_WRITER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



