/* valarealliteral.c generated by valac, the Vala compiler
 * generated from valarealliteral.vala, do not modify */

/* valarealliteral.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <stdlib.h>
#include <string.h>

enum  {
	VALA_REAL_LITERAL_0_PROPERTY,
	VALA_REAL_LITERAL_NUM_PROPERTIES
};
static GParamSpec* vala_real_literal_properties[VALA_REAL_LITERAL_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))

struct _ValaRealLiteralPrivate {
	gchar* _value;
};


static gpointer vala_real_literal_parent_class = NULL;

#define VALA_REAL_LITERAL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_REAL_LITERAL, ValaRealLiteralPrivate))
static void vala_real_literal_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static gboolean vala_real_literal_real_is_pure (ValaExpression* base);
static gchar* vala_real_literal_real_to_string (ValaCodeNode* base);
static gboolean vala_real_literal_real_check (ValaCodeNode* base, ValaCodeContext* context);
static void vala_real_literal_real_emit (ValaCodeNode* base, ValaCodeGenerator* codegen);
static void vala_real_literal_finalize (ValaCodeNode * obj);


/**
 * Creates a new real literal.
 *
 * @param r      literal value
 * @param source reference to source code
 * @return       newly created real literal
 */
ValaRealLiteral* vala_real_literal_construct (GType object_type, const gchar* r, ValaSourceReference* source) {
	ValaRealLiteral* self = NULL;
	const gchar* _tmp0_;
	ValaSourceReference* _tmp1_;
	g_return_val_if_fail (r != NULL, NULL);
	self = (ValaRealLiteral*) vala_literal_construct (object_type);
	_tmp0_ = r;
	vala_real_literal_set_value (self, _tmp0_);
	_tmp1_ = source;
	vala_code_node_set_source_reference ((ValaCodeNode*) self, _tmp1_);
	return self;
}


ValaRealLiteral* vala_real_literal_new (const gchar* r, ValaSourceReference* source) {
	return vala_real_literal_construct (VALA_TYPE_REAL_LITERAL, r, source);
}


static void vala_real_literal_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaRealLiteral * self;
	ValaCodeVisitor* _tmp0_;
	ValaCodeVisitor* _tmp1_;
	self = (ValaRealLiteral*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = visitor;
	vala_code_visitor_visit_real_literal (_tmp0_, self);
	_tmp1_ = visitor;
	vala_code_visitor_visit_expression (_tmp1_, (ValaExpression*) self);
}


/**
 * Returns the type name of the value this literal represents.
 *
 * @return the name of literal type
 */
gchar* vala_real_literal_get_type_name (ValaRealLiteral* self) {
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	gboolean _tmp2_;
	gchar* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->priv->_value;
	_tmp2_ = g_str_has_suffix (_tmp1_, "f");
	if (_tmp2_) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp3_;
		gboolean _tmp4_;
		_tmp3_ = self->priv->_value;
		_tmp4_ = g_str_has_suffix (_tmp3_, "F");
		_tmp0_ = _tmp4_;
	}
	if (_tmp0_) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup ("float");
		result = _tmp5_;
		return result;
	}
	_tmp6_ = g_strdup ("double");
	result = _tmp6_;
	return result;
}


static gboolean vala_real_literal_real_is_pure (ValaExpression* base) {
	ValaRealLiteral * self;
	gboolean result = FALSE;
	self = (ValaRealLiteral*) base;
	result = TRUE;
	return result;
}


static gchar* vala_real_literal_real_to_string (ValaCodeNode* base) {
	ValaRealLiteral * self;
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	self = (ValaRealLiteral*) base;
	_tmp0_ = self->priv->_value;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


static gboolean vala_real_literal_real_check (ValaCodeNode* base, ValaCodeContext* context) {
	ValaRealLiteral * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaStruct* st = NULL;
	ValaCodeContext* _tmp4_;
	ValaSemanticAnalyzer* _tmp5_;
	ValaSemanticAnalyzer* _tmp6_;
	ValaSymbol* _tmp7_;
	ValaScope* _tmp8_;
	ValaScope* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	ValaSymbol* _tmp12_;
	ValaStruct* _tmp13_;
	ValaStruct* _tmp14_;
	ValaCodeContext* _tmp15_;
	ValaStruct* _tmp16_;
	ValaFloatingType* _tmp17_;
	ValaFloatingType* _tmp18_;
	gboolean _tmp19_;
	gboolean _tmp20_;
	self = (ValaRealLiteral*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = context;
	_tmp5_ = vala_code_context_get_analyzer (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp6_->root_symbol;
	_tmp8_ = vala_symbol_get_scope (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = vala_real_literal_get_type_name (self);
	_tmp11_ = _tmp10_;
	_tmp12_ = vala_scope_lookup (_tmp9_, _tmp11_);
	_tmp13_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, VALA_TYPE_STRUCT, ValaStruct);
	_g_free0 (_tmp11_);
	st = _tmp13_;
	_tmp14_ = st;
	_tmp15_ = context;
	vala_code_node_check ((ValaCodeNode*) _tmp14_, _tmp15_);
	_tmp16_ = st;
	_tmp17_ = vala_floating_type_new (_tmp16_);
	_tmp18_ = _tmp17_;
	vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp18_);
	_vala_code_node_unref0 (_tmp18_);
	_tmp19_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp20_ = _tmp19_;
	result = !_tmp20_;
	_vala_code_node_unref0 (st);
	return result;
}


static void vala_real_literal_real_emit (ValaCodeNode* base, ValaCodeGenerator* codegen) {
	ValaRealLiteral * self;
	ValaCodeGenerator* _tmp0_;
	ValaCodeGenerator* _tmp1_;
	self = (ValaRealLiteral*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = codegen;
	vala_code_visitor_visit_real_literal ((ValaCodeVisitor*) _tmp0_, self);
	_tmp1_ = codegen;
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) _tmp1_, (ValaExpression*) self);
}


const gchar* vala_real_literal_get_value (ValaRealLiteral* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_value;
	result = _tmp0_;
	return result;
}


void vala_real_literal_set_value (ValaRealLiteral* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_value);
	self->priv->_value = _tmp1_;
}


static void vala_real_literal_class_init (ValaRealLiteralClass * klass) {
	vala_real_literal_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_real_literal_finalize;
	g_type_class_add_private (klass, sizeof (ValaRealLiteralPrivate));
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_real_literal_real_accept;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression *)) vala_real_literal_real_is_pure;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode *)) vala_real_literal_real_to_string;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode *, ValaCodeContext*)) vala_real_literal_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode *, ValaCodeGenerator*)) vala_real_literal_real_emit;
}


static void vala_real_literal_instance_init (ValaRealLiteral * self) {
	self->priv = VALA_REAL_LITERAL_GET_PRIVATE (self);
}


static void vala_real_literal_finalize (ValaCodeNode * obj) {
	ValaRealLiteral * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_REAL_LITERAL, ValaRealLiteral);
	_g_free0 (self->priv->_value);
	VALA_CODE_NODE_CLASS (vala_real_literal_parent_class)->finalize (obj);
}


/**
 * Represents a real literal in the source code.
 */
GType vala_real_literal_get_type (void) {
	static volatile gsize vala_real_literal_type_id__volatile = 0;
	if (g_once_init_enter (&vala_real_literal_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaRealLiteralClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_real_literal_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaRealLiteral), 0, (GInstanceInitFunc) vala_real_literal_instance_init, NULL };
		GType vala_real_literal_type_id;
		vala_real_literal_type_id = g_type_register_static (VALA_TYPE_LITERAL, "ValaRealLiteral", &g_define_type_info, 0);
		g_once_init_leave (&vala_real_literal_type_id__volatile, vala_real_literal_type_id);
	}
	return vala_real_literal_type_id__volatile;
}



