/* valacreationmethod.c generated by valac, the Vala compiler
 * generated from valacreationmethod.vala, do not modify */

/* valacreationmethod.vala
 *
 * Copyright (C) 2007-2010  Jürg Billeter
 * Copyright (C) 2007-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <valagee.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))

struct _ValaCreationMethodPrivate {
	gchar* _class_name;
	gboolean _chain_up;
};


static gpointer vala_creation_method_parent_class = NULL;

#define VALA_CREATION_METHOD_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CREATION_METHOD, ValaCreationMethodPrivate))
static void vala_creation_method_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_creation_method_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
static gboolean vala_creation_method_real_check (ValaCodeNode* base, ValaCodeContext* context);
static void vala_creation_method_finalize (ValaCodeNode * obj);


/**
 * Creates a new method.
 *
 * @param name             method name
 * @param source_reference reference to source code
 * @return                 newly created method
 */
ValaCreationMethod* vala_creation_method_construct (GType object_type, const gchar* class_name, const gchar* name, ValaSourceReference* source_reference, ValaComment* comment) {
	ValaCreationMethod* self = NULL;
	const gchar* _tmp0_;
	ValaVoidType* _tmp1_;
	ValaVoidType* _tmp2_;
	ValaSourceReference* _tmp3_;
	ValaComment* _tmp4_;
	const gchar* _tmp5_;
	_tmp0_ = name;
	_tmp1_ = vala_void_type_new (NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = source_reference;
	_tmp4_ = comment;
	self = (ValaCreationMethod*) vala_method_construct (object_type, _tmp0_, (ValaDataType*) _tmp2_, _tmp3_, _tmp4_);
	_vala_code_node_unref0 (_tmp2_);
	_tmp5_ = class_name;
	vala_creation_method_set_class_name (self, _tmp5_);
	return self;
}


ValaCreationMethod* vala_creation_method_new (const gchar* class_name, const gchar* name, ValaSourceReference* source_reference, ValaComment* comment) {
	return vala_creation_method_construct (VALA_TYPE_CREATION_METHOD, class_name, name, source_reference, comment);
}


static void vala_creation_method_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaCreationMethod * self;
	ValaCodeVisitor* _tmp0_;
	self = (ValaCreationMethod*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = visitor;
	vala_code_visitor_visit_creation_method (_tmp0_, self);
}


static void vala_creation_method_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaCreationMethod * self;
	ValaBlock* _tmp48_;
	ValaBlock* _tmp49_;
	self = (ValaCreationMethod*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp0_;
		gint _param_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _param_index = 0;
		_tmp0_ = vala_callable_get_parameters ((ValaCallable*) self);
		_param_list = _tmp0_;
		_tmp1_ = _param_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_param_size = _tmp3_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			gint _tmp6_;
			ValaParameter* param = NULL;
			ValaList* _tmp7_;
			gint _tmp8_;
			gpointer _tmp9_;
			ValaParameter* _tmp10_;
			ValaCodeVisitor* _tmp11_;
			_tmp4_ = _param_index;
			_param_index = _tmp4_ + 1;
			_tmp5_ = _param_index;
			_tmp6_ = _param_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _param_list;
			_tmp8_ = _param_index;
			_tmp9_ = vala_list_get (_tmp7_, _tmp8_);
			param = (ValaParameter*) _tmp9_;
			_tmp10_ = param;
			_tmp11_ = visitor;
			vala_code_node_accept ((ValaCodeNode*) _tmp10_, _tmp11_);
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	{
		ValaList* _error_type_list = NULL;
		ValaList* _tmp12_;
		gint _error_type_size = 0;
		ValaList* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gint _error_type_index = 0;
		_tmp12_ = vala_code_node_get_error_types ((ValaCodeNode*) self);
		_error_type_list = _tmp12_;
		_tmp13_ = _error_type_list;
		_tmp14_ = vala_collection_get_size ((ValaCollection*) _tmp13_);
		_tmp15_ = _tmp14_;
		_error_type_size = _tmp15_;
		_error_type_index = -1;
		while (TRUE) {
			gint _tmp16_;
			gint _tmp17_;
			gint _tmp18_;
			ValaDataType* error_type = NULL;
			ValaList* _tmp19_;
			gint _tmp20_;
			gpointer _tmp21_;
			ValaDataType* _tmp22_;
			ValaCodeVisitor* _tmp23_;
			_tmp16_ = _error_type_index;
			_error_type_index = _tmp16_ + 1;
			_tmp17_ = _error_type_index;
			_tmp18_ = _error_type_size;
			if (!(_tmp17_ < _tmp18_)) {
				break;
			}
			_tmp19_ = _error_type_list;
			_tmp20_ = _error_type_index;
			_tmp21_ = vala_list_get (_tmp19_, _tmp20_);
			error_type = (ValaDataType*) _tmp21_;
			_tmp22_ = error_type;
			_tmp23_ = visitor;
			vala_code_node_accept ((ValaCodeNode*) _tmp22_, _tmp23_);
			_vala_code_node_unref0 (error_type);
		}
		_vala_iterable_unref0 (_error_type_list);
	}
	{
		ValaList* _precondition_list = NULL;
		ValaList* _tmp24_;
		gint _precondition_size = 0;
		ValaList* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		gint _precondition_index = 0;
		_tmp24_ = vala_method_get_preconditions ((ValaMethod*) self);
		_precondition_list = _tmp24_;
		_tmp25_ = _precondition_list;
		_tmp26_ = vala_collection_get_size ((ValaCollection*) _tmp25_);
		_tmp27_ = _tmp26_;
		_precondition_size = _tmp27_;
		_precondition_index = -1;
		while (TRUE) {
			gint _tmp28_;
			gint _tmp29_;
			gint _tmp30_;
			ValaExpression* precondition = NULL;
			ValaList* _tmp31_;
			gint _tmp32_;
			gpointer _tmp33_;
			ValaExpression* _tmp34_;
			ValaCodeVisitor* _tmp35_;
			_tmp28_ = _precondition_index;
			_precondition_index = _tmp28_ + 1;
			_tmp29_ = _precondition_index;
			_tmp30_ = _precondition_size;
			if (!(_tmp29_ < _tmp30_)) {
				break;
			}
			_tmp31_ = _precondition_list;
			_tmp32_ = _precondition_index;
			_tmp33_ = vala_list_get (_tmp31_, _tmp32_);
			precondition = (ValaExpression*) _tmp33_;
			_tmp34_ = precondition;
			_tmp35_ = visitor;
			vala_code_node_accept ((ValaCodeNode*) _tmp34_, _tmp35_);
			_vala_code_node_unref0 (precondition);
		}
		_vala_iterable_unref0 (_precondition_list);
	}
	{
		ValaList* _postcondition_list = NULL;
		ValaList* _tmp36_;
		gint _postcondition_size = 0;
		ValaList* _tmp37_;
		gint _tmp38_;
		gint _tmp39_;
		gint _postcondition_index = 0;
		_tmp36_ = vala_method_get_postconditions ((ValaMethod*) self);
		_postcondition_list = _tmp36_;
		_tmp37_ = _postcondition_list;
		_tmp38_ = vala_collection_get_size ((ValaCollection*) _tmp37_);
		_tmp39_ = _tmp38_;
		_postcondition_size = _tmp39_;
		_postcondition_index = -1;
		while (TRUE) {
			gint _tmp40_;
			gint _tmp41_;
			gint _tmp42_;
			ValaExpression* postcondition = NULL;
			ValaList* _tmp43_;
			gint _tmp44_;
			gpointer _tmp45_;
			ValaExpression* _tmp46_;
			ValaCodeVisitor* _tmp47_;
			_tmp40_ = _postcondition_index;
			_postcondition_index = _tmp40_ + 1;
			_tmp41_ = _postcondition_index;
			_tmp42_ = _postcondition_size;
			if (!(_tmp41_ < _tmp42_)) {
				break;
			}
			_tmp43_ = _postcondition_list;
			_tmp44_ = _postcondition_index;
			_tmp45_ = vala_list_get (_tmp43_, _tmp44_);
			postcondition = (ValaExpression*) _tmp45_;
			_tmp46_ = postcondition;
			_tmp47_ = visitor;
			vala_code_node_accept ((ValaCodeNode*) _tmp46_, _tmp47_);
			_vala_code_node_unref0 (postcondition);
		}
		_vala_iterable_unref0 (_postcondition_list);
	}
	_tmp48_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp49_ = _tmp48_;
	if (_tmp49_ != NULL) {
		ValaBlock* _tmp50_;
		ValaBlock* _tmp51_;
		ValaCodeVisitor* _tmp52_;
		_tmp50_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp51_ = _tmp50_;
		_tmp52_ = visitor;
		vala_code_node_accept ((ValaCodeNode*) _tmp51_, _tmp52_);
	}
}


static gpointer _vala_source_file_ref0 (gpointer self) {
	return self ? vala_source_file_ref (self) : NULL;
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


static gboolean vala_creation_method_real_check (ValaCodeNode* base, ValaCodeContext* context) {
	ValaCreationMethod * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_;
	ValaSourceFile* old_source_file = NULL;
	ValaCodeContext* _tmp23_;
	ValaSemanticAnalyzer* _tmp24_;
	ValaSemanticAnalyzer* _tmp25_;
	ValaSourceFile* _tmp26_;
	ValaSourceFile* _tmp27_;
	ValaSourceFile* _tmp28_;
	ValaSymbol* old_symbol = NULL;
	ValaCodeContext* _tmp29_;
	ValaSemanticAnalyzer* _tmp30_;
	ValaSemanticAnalyzer* _tmp31_;
	ValaSymbol* _tmp32_;
	ValaSymbol* _tmp33_;
	ValaSymbol* _tmp34_;
	ValaSourceReference* _tmp35_;
	ValaSourceReference* _tmp36_;
	ValaCodeContext* _tmp44_;
	ValaSemanticAnalyzer* _tmp45_;
	ValaSemanticAnalyzer* _tmp46_;
	gint i = 0;
	ValaBlock* _tmp107_;
	ValaBlock* _tmp108_;
	ValaCodeContext* _tmp244_;
	ValaSemanticAnalyzer* _tmp245_;
	ValaSemanticAnalyzer* _tmp246_;
	ValaSourceFile* _tmp247_;
	ValaCodeContext* _tmp248_;
	ValaSemanticAnalyzer* _tmp249_;
	ValaSemanticAnalyzer* _tmp250_;
	ValaSymbol* _tmp251_;
	gboolean _tmp252_ = FALSE;
	gboolean _tmp253_ = FALSE;
	gboolean _tmp254_;
	gboolean _tmp255_;
	ValaBlock* _tmp266_;
	ValaBlock* _tmp267_;
	gboolean _tmp306_;
	gboolean _tmp307_;
	self = (ValaCreationMethod*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp5_ = self->priv->_class_name;
	if (_tmp5_ != NULL) {
		const gchar* _tmp6_;
		ValaSymbol* _tmp7_;
		ValaSymbol* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		_tmp6_ = self->priv->_class_name;
		_tmp7_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_symbol_get_name (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp4_ = g_strcmp0 (_tmp6_, _tmp10_) != 0;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		ValaSourceReference* _tmp11_;
		ValaSourceReference* _tmp12_;
		ValaCodeContext* _tmp13_;
		ValaSemanticAnalyzer* _tmp14_;
		ValaSemanticAnalyzer* _tmp15_;
		ValaSymbol* _tmp16_;
		ValaSymbol* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		const gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		_tmp11_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp12_ = _tmp11_;
		_tmp13_ = context;
		_tmp14_ = vala_code_context_get_analyzer (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = vala_semantic_analyzer_get_current_symbol (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_symbol_get_full_name (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = self->priv->_class_name;
		_tmp21_ = g_strdup_printf ("missing return type in method `%s.%s´", _tmp19_, _tmp20_);
		_tmp22_ = _tmp21_;
		vala_report_error (_tmp12_, _tmp22_);
		_g_free0 (_tmp22_);
		_g_free0 (_tmp19_);
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp23_ = context;
	_tmp24_ = vala_code_context_get_analyzer (_tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_semantic_analyzer_get_current_source_file (_tmp25_);
	_tmp27_ = _tmp26_;
	_tmp28_ = _vala_source_file_ref0 (_tmp27_);
	old_source_file = _tmp28_;
	_tmp29_ = context;
	_tmp30_ = vala_code_context_get_analyzer (_tmp29_);
	_tmp31_ = _tmp30_;
	_tmp32_ = vala_semantic_analyzer_get_current_symbol (_tmp31_);
	_tmp33_ = _tmp32_;
	_tmp34_ = _vala_code_node_ref0 (_tmp33_);
	old_symbol = _tmp34_;
	_tmp35_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp36_ = _tmp35_;
	if (_tmp36_ != NULL) {
		ValaCodeContext* _tmp37_;
		ValaSemanticAnalyzer* _tmp38_;
		ValaSemanticAnalyzer* _tmp39_;
		ValaSourceReference* _tmp40_;
		ValaSourceReference* _tmp41_;
		ValaSourceFile* _tmp42_;
		ValaSourceFile* _tmp43_;
		_tmp37_ = context;
		_tmp38_ = vala_code_context_get_analyzer (_tmp37_);
		_tmp39_ = _tmp38_;
		_tmp40_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp41_ = _tmp40_;
		_tmp42_ = vala_source_reference_get_file (_tmp41_);
		_tmp43_ = _tmp42_;
		vala_semantic_analyzer_set_current_source_file (_tmp39_, _tmp43_);
	}
	_tmp44_ = context;
	_tmp45_ = vala_code_context_get_analyzer (_tmp44_);
	_tmp46_ = _tmp45_;
	vala_semantic_analyzer_set_current_symbol (_tmp46_, (ValaSymbol*) self);
	i = 0;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp47_;
		gint _param_size = 0;
		ValaList* _tmp48_;
		gint _tmp49_;
		gint _tmp50_;
		gint _param_index = 0;
		_tmp47_ = vala_callable_get_parameters ((ValaCallable*) self);
		_param_list = _tmp47_;
		_tmp48_ = _param_list;
		_tmp49_ = vala_collection_get_size ((ValaCollection*) _tmp48_);
		_tmp50_ = _tmp49_;
		_param_size = _tmp50_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp51_;
			gint _tmp52_;
			gint _tmp53_;
			ValaParameter* param = NULL;
			ValaList* _tmp54_;
			gint _tmp55_;
			gpointer _tmp56_;
			ValaParameter* _tmp57_;
			ValaCodeContext* _tmp58_;
			gboolean _tmp59_ = FALSE;
			gboolean _tmp60_ = FALSE;
			gint _tmp61_;
			gint _tmp70_;
			_tmp51_ = _param_index;
			_param_index = _tmp51_ + 1;
			_tmp52_ = _param_index;
			_tmp53_ = _param_size;
			if (!(_tmp52_ < _tmp53_)) {
				break;
			}
			_tmp54_ = _param_list;
			_tmp55_ = _param_index;
			_tmp56_ = vala_list_get (_tmp54_, _tmp55_);
			param = (ValaParameter*) _tmp56_;
			_tmp57_ = param;
			_tmp58_ = context;
			vala_code_node_check ((ValaCodeNode*) _tmp57_, _tmp58_);
			_tmp61_ = i;
			if (_tmp61_ == 0) {
				ValaParameter* _tmp62_;
				gboolean _tmp63_;
				gboolean _tmp64_;
				_tmp62_ = param;
				_tmp63_ = vala_parameter_get_ellipsis (_tmp62_);
				_tmp64_ = _tmp63_;
				_tmp60_ = _tmp64_;
			} else {
				_tmp60_ = FALSE;
			}
			if (_tmp60_) {
				ValaBlock* _tmp65_;
				ValaBlock* _tmp66_;
				_tmp65_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp66_ = _tmp65_;
				_tmp59_ = _tmp66_ != NULL;
			} else {
				_tmp59_ = FALSE;
			}
			if (_tmp59_) {
				ValaParameter* _tmp67_;
				ValaSourceReference* _tmp68_;
				ValaSourceReference* _tmp69_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp67_ = param;
				_tmp68_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp67_);
				_tmp69_ = _tmp68_;
				vala_report_error (_tmp69_, "Named parameter required before `...'");
			}
			_tmp70_ = i;
			i = _tmp70_ + 1;
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	{
		ValaList* _error_type_list = NULL;
		ValaList* _tmp71_;
		gint _error_type_size = 0;
		ValaList* _tmp72_;
		gint _tmp73_;
		gint _tmp74_;
		gint _error_type_index = 0;
		_tmp71_ = vala_code_node_get_error_types ((ValaCodeNode*) self);
		_error_type_list = _tmp71_;
		_tmp72_ = _error_type_list;
		_tmp73_ = vala_collection_get_size ((ValaCollection*) _tmp72_);
		_tmp74_ = _tmp73_;
		_error_type_size = _tmp74_;
		_error_type_index = -1;
		while (TRUE) {
			gint _tmp75_;
			gint _tmp76_;
			gint _tmp77_;
			ValaDataType* error_type = NULL;
			ValaList* _tmp78_;
			gint _tmp79_;
			gpointer _tmp80_;
			ValaDataType* _tmp81_;
			ValaCodeContext* _tmp82_;
			_tmp75_ = _error_type_index;
			_error_type_index = _tmp75_ + 1;
			_tmp76_ = _error_type_index;
			_tmp77_ = _error_type_size;
			if (!(_tmp76_ < _tmp77_)) {
				break;
			}
			_tmp78_ = _error_type_list;
			_tmp79_ = _error_type_index;
			_tmp80_ = vala_list_get (_tmp78_, _tmp79_);
			error_type = (ValaDataType*) _tmp80_;
			_tmp81_ = error_type;
			_tmp82_ = context;
			vala_code_node_check ((ValaCodeNode*) _tmp81_, _tmp82_);
			_vala_code_node_unref0 (error_type);
		}
		_vala_iterable_unref0 (_error_type_list);
	}
	{
		ValaList* _precondition_list = NULL;
		ValaList* _tmp83_;
		gint _precondition_size = 0;
		ValaList* _tmp84_;
		gint _tmp85_;
		gint _tmp86_;
		gint _precondition_index = 0;
		_tmp83_ = vala_method_get_preconditions ((ValaMethod*) self);
		_precondition_list = _tmp83_;
		_tmp84_ = _precondition_list;
		_tmp85_ = vala_collection_get_size ((ValaCollection*) _tmp84_);
		_tmp86_ = _tmp85_;
		_precondition_size = _tmp86_;
		_precondition_index = -1;
		while (TRUE) {
			gint _tmp87_;
			gint _tmp88_;
			gint _tmp89_;
			ValaExpression* precondition = NULL;
			ValaList* _tmp90_;
			gint _tmp91_;
			gpointer _tmp92_;
			ValaExpression* _tmp93_;
			ValaCodeContext* _tmp94_;
			_tmp87_ = _precondition_index;
			_precondition_index = _tmp87_ + 1;
			_tmp88_ = _precondition_index;
			_tmp89_ = _precondition_size;
			if (!(_tmp88_ < _tmp89_)) {
				break;
			}
			_tmp90_ = _precondition_list;
			_tmp91_ = _precondition_index;
			_tmp92_ = vala_list_get (_tmp90_, _tmp91_);
			precondition = (ValaExpression*) _tmp92_;
			_tmp93_ = precondition;
			_tmp94_ = context;
			vala_code_node_check ((ValaCodeNode*) _tmp93_, _tmp94_);
			_vala_code_node_unref0 (precondition);
		}
		_vala_iterable_unref0 (_precondition_list);
	}
	{
		ValaList* _postcondition_list = NULL;
		ValaList* _tmp95_;
		gint _postcondition_size = 0;
		ValaList* _tmp96_;
		gint _tmp97_;
		gint _tmp98_;
		gint _postcondition_index = 0;
		_tmp95_ = vala_method_get_postconditions ((ValaMethod*) self);
		_postcondition_list = _tmp95_;
		_tmp96_ = _postcondition_list;
		_tmp97_ = vala_collection_get_size ((ValaCollection*) _tmp96_);
		_tmp98_ = _tmp97_;
		_postcondition_size = _tmp98_;
		_postcondition_index = -1;
		while (TRUE) {
			gint _tmp99_;
			gint _tmp100_;
			gint _tmp101_;
			ValaExpression* postcondition = NULL;
			ValaList* _tmp102_;
			gint _tmp103_;
			gpointer _tmp104_;
			ValaExpression* _tmp105_;
			ValaCodeContext* _tmp106_;
			_tmp99_ = _postcondition_index;
			_postcondition_index = _tmp99_ + 1;
			_tmp100_ = _postcondition_index;
			_tmp101_ = _postcondition_size;
			if (!(_tmp100_ < _tmp101_)) {
				break;
			}
			_tmp102_ = _postcondition_list;
			_tmp103_ = _postcondition_index;
			_tmp104_ = vala_list_get (_tmp102_, _tmp103_);
			postcondition = (ValaExpression*) _tmp104_;
			_tmp105_ = postcondition;
			_tmp106_ = context;
			vala_code_node_check ((ValaCodeNode*) _tmp105_, _tmp106_);
			_vala_code_node_unref0 (postcondition);
		}
		_vala_iterable_unref0 (_postcondition_list);
	}
	_tmp107_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp108_ = _tmp107_;
	if (_tmp108_ != NULL) {
		ValaBlock* _tmp109_;
		ValaBlock* _tmp110_;
		ValaCodeContext* _tmp111_;
		ValaClass* cl = NULL;
		ValaSymbol* _tmp112_;
		ValaSymbol* _tmp113_;
		ValaClass* _tmp114_;
		gboolean _tmp115_ = FALSE;
		gboolean _tmp116_ = FALSE;
		gboolean _tmp117_;
		_tmp109_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp110_ = _tmp109_;
		_tmp111_ = context;
		vala_code_node_check ((ValaCodeNode*) _tmp110_, _tmp111_);
		_tmp112_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp113_ = _tmp112_;
		_tmp114_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp113_, VALA_TYPE_CLASS) ? ((ValaClass*) _tmp113_) : NULL);
		cl = _tmp114_;
		_tmp117_ = self->priv->_chain_up;
		if (!_tmp117_) {
			ValaClass* _tmp118_;
			_tmp118_ = cl;
			_tmp116_ = _tmp118_ != NULL;
		} else {
			_tmp116_ = FALSE;
		}
		if (_tmp116_) {
			ValaClass* _tmp119_;
			ValaClass* _tmp120_;
			ValaClass* _tmp121_;
			_tmp119_ = cl;
			_tmp120_ = vala_class_get_base_class (_tmp119_);
			_tmp121_ = _tmp120_;
			_tmp115_ = _tmp121_ != NULL;
		} else {
			_tmp115_ = FALSE;
		}
		if (_tmp115_) {
			gboolean _tmp122_ = FALSE;
			ValaClass* _tmp123_;
			ValaClass* _tmp124_;
			ValaClass* _tmp125_;
			ValaCreationMethod* _tmp126_;
			ValaCreationMethod* _tmp127_;
			_tmp123_ = cl;
			_tmp124_ = vala_class_get_base_class (_tmp123_);
			_tmp125_ = _tmp124_;
			_tmp126_ = vala_class_get_default_construction_method (_tmp125_);
			_tmp127_ = _tmp126_;
			if (_tmp127_ != NULL) {
				ValaClass* _tmp128_;
				ValaClass* _tmp129_;
				ValaClass* _tmp130_;
				ValaCreationMethod* _tmp131_;
				ValaCreationMethod* _tmp132_;
				gboolean _tmp133_;
				gboolean _tmp134_;
				_tmp128_ = cl;
				_tmp129_ = vala_class_get_base_class (_tmp128_);
				_tmp130_ = _tmp129_;
				_tmp131_ = vala_class_get_default_construction_method (_tmp130_);
				_tmp132_ = _tmp131_;
				_tmp133_ = vala_method_get_has_construct_function ((ValaMethod*) _tmp132_);
				_tmp134_ = _tmp133_;
				_tmp122_ = !_tmp134_;
			} else {
				_tmp122_ = FALSE;
			}
			if (_tmp122_) {
				ValaBlock* old_insert_block = NULL;
				ValaCodeContext* _tmp135_;
				ValaSemanticAnalyzer* _tmp136_;
				ValaSemanticAnalyzer* _tmp137_;
				ValaBlock* _tmp138_;
				ValaBlock* _tmp139_;
				ValaCodeContext* _tmp140_;
				ValaSemanticAnalyzer* _tmp141_;
				ValaSemanticAnalyzer* _tmp142_;
				ValaBlock* _tmp143_;
				ValaBlock* _tmp144_;
				ValaCodeContext* _tmp145_;
				ValaSemanticAnalyzer* _tmp146_;
				ValaSemanticAnalyzer* _tmp147_;
				ValaBlock* _tmp148_;
				ValaBlock* _tmp149_;
				ValaBlock* _tmp150_;
				ValaExpressionStatement* stmt = NULL;
				ValaSourceReference* _tmp151_;
				ValaSourceReference* _tmp152_;
				ValaMemberAccess* _tmp153_;
				ValaMemberAccess* _tmp154_;
				ValaSourceReference* _tmp155_;
				ValaSourceReference* _tmp156_;
				ValaMemberAccess* _tmp157_;
				ValaMemberAccess* _tmp158_;
				ValaSourceReference* _tmp159_;
				ValaSourceReference* _tmp160_;
				ValaMethodCall* _tmp161_;
				ValaMethodCall* _tmp162_;
				ValaSourceReference* _tmp163_;
				ValaSourceReference* _tmp164_;
				ValaExpressionStatement* _tmp165_;
				ValaExpressionStatement* _tmp166_;
				ValaBlock* _tmp167_;
				ValaBlock* _tmp168_;
				ValaExpressionStatement* _tmp169_;
				ValaExpressionStatement* _tmp170_;
				ValaCodeContext* _tmp171_;
				ValaCodeContext* _tmp172_;
				ValaSemanticAnalyzer* _tmp173_;
				ValaSemanticAnalyzer* _tmp174_;
				ValaCodeContext* _tmp175_;
				ValaSemanticAnalyzer* _tmp176_;
				ValaSemanticAnalyzer* _tmp177_;
				ValaBlock* _tmp178_;
				ValaBlock* _tmp179_;
				_tmp135_ = context;
				_tmp136_ = vala_code_context_get_analyzer (_tmp135_);
				_tmp137_ = _tmp136_;
				_tmp138_ = _tmp137_->insert_block;
				_tmp139_ = _vala_code_node_ref0 (_tmp138_);
				old_insert_block = _tmp139_;
				_tmp140_ = context;
				_tmp141_ = vala_code_context_get_analyzer (_tmp140_);
				_tmp142_ = _tmp141_;
				_tmp143_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp144_ = _tmp143_;
				vala_semantic_analyzer_set_current_symbol (_tmp142_, (ValaSymbol*) _tmp144_);
				_tmp145_ = context;
				_tmp146_ = vala_code_context_get_analyzer (_tmp145_);
				_tmp147_ = _tmp146_;
				_tmp148_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp149_ = _tmp148_;
				_tmp150_ = _vala_code_node_ref0 (_tmp149_);
				_vala_code_node_unref0 (_tmp147_->insert_block);
				_tmp147_->insert_block = _tmp150_;
				_tmp151_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp152_ = _tmp151_;
				_tmp153_ = vala_member_access_new_simple ("GLib", _tmp152_);
				_tmp154_ = _tmp153_;
				_tmp155_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp156_ = _tmp155_;
				_tmp157_ = vala_member_access_new ((ValaExpression*) _tmp154_, "Object", _tmp156_);
				_tmp158_ = _tmp157_;
				_tmp159_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp160_ = _tmp159_;
				_tmp161_ = vala_method_call_new ((ValaExpression*) _tmp158_, _tmp160_);
				_tmp162_ = _tmp161_;
				_tmp163_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp164_ = _tmp163_;
				_tmp165_ = vala_expression_statement_new ((ValaExpression*) _tmp162_, _tmp164_);
				_tmp166_ = _tmp165_;
				_vala_code_node_unref0 (_tmp162_);
				_vala_code_node_unref0 (_tmp158_);
				_vala_code_node_unref0 (_tmp154_);
				stmt = _tmp166_;
				_tmp167_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp168_ = _tmp167_;
				_tmp169_ = stmt;
				vala_block_insert_statement (_tmp168_, 0, (ValaStatement*) _tmp169_);
				_tmp170_ = stmt;
				_tmp171_ = context;
				vala_code_node_check ((ValaCodeNode*) _tmp170_, _tmp171_);
				_tmp172_ = context;
				_tmp173_ = vala_code_context_get_analyzer (_tmp172_);
				_tmp174_ = _tmp173_;
				vala_semantic_analyzer_set_current_symbol (_tmp174_, (ValaSymbol*) self);
				_tmp175_ = context;
				_tmp176_ = vala_code_context_get_analyzer (_tmp175_);
				_tmp177_ = _tmp176_;
				_tmp178_ = old_insert_block;
				_tmp179_ = _vala_code_node_ref0 (_tmp178_);
				_vala_code_node_unref0 (_tmp177_->insert_block);
				_tmp177_->insert_block = _tmp179_;
				_vala_code_node_unref0 (stmt);
				_vala_code_node_unref0 (old_insert_block);
			} else {
				gboolean _tmp180_ = FALSE;
				ValaClass* _tmp181_;
				ValaClass* _tmp182_;
				ValaClass* _tmp183_;
				ValaCreationMethod* _tmp184_;
				ValaCreationMethod* _tmp185_;
				_tmp181_ = cl;
				_tmp182_ = vala_class_get_base_class (_tmp181_);
				_tmp183_ = _tmp182_;
				_tmp184_ = vala_class_get_default_construction_method (_tmp183_);
				_tmp185_ = _tmp184_;
				if (_tmp185_ == NULL) {
					_tmp180_ = TRUE;
				} else {
					ValaClass* _tmp186_;
					ValaClass* _tmp187_;
					ValaClass* _tmp188_;
					ValaCreationMethod* _tmp189_;
					ValaCreationMethod* _tmp190_;
					ValaSymbolAccessibility _tmp191_;
					ValaSymbolAccessibility _tmp192_;
					_tmp186_ = cl;
					_tmp187_ = vala_class_get_base_class (_tmp186_);
					_tmp188_ = _tmp187_;
					_tmp189_ = vala_class_get_default_construction_method (_tmp188_);
					_tmp190_ = _tmp189_;
					_tmp191_ = vala_symbol_get_access ((ValaSymbol*) _tmp190_);
					_tmp192_ = _tmp191_;
					_tmp180_ = _tmp192_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE;
				}
				if (_tmp180_) {
					ValaSourceReference* _tmp193_;
					ValaSourceReference* _tmp194_;
					_tmp193_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp194_ = _tmp193_;
					vala_report_error (_tmp194_, "unable to chain up to private base constructor");
				} else {
					ValaClass* _tmp195_;
					ValaClass* _tmp196_;
					ValaClass* _tmp197_;
					ValaCreationMethod* _tmp198_;
					ValaCreationMethod* _tmp199_;
					gint _tmp200_;
					_tmp195_ = cl;
					_tmp196_ = vala_class_get_base_class (_tmp195_);
					_tmp197_ = _tmp196_;
					_tmp198_ = vala_class_get_default_construction_method (_tmp197_);
					_tmp199_ = _tmp198_;
					_tmp200_ = vala_method_get_required_arguments ((ValaMethod*) _tmp199_);
					if (_tmp200_ > 0) {
						ValaSourceReference* _tmp201_;
						ValaSourceReference* _tmp202_;
						_tmp201_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp202_ = _tmp201_;
						vala_report_error (_tmp202_, "unable to chain up to base constructor requiring arguments");
					} else {
						ValaBlock* old_insert_block = NULL;
						ValaCodeContext* _tmp203_;
						ValaSemanticAnalyzer* _tmp204_;
						ValaSemanticAnalyzer* _tmp205_;
						ValaBlock* _tmp206_;
						ValaBlock* _tmp207_;
						ValaCodeContext* _tmp208_;
						ValaSemanticAnalyzer* _tmp209_;
						ValaSemanticAnalyzer* _tmp210_;
						ValaBlock* _tmp211_;
						ValaBlock* _tmp212_;
						ValaCodeContext* _tmp213_;
						ValaSemanticAnalyzer* _tmp214_;
						ValaSemanticAnalyzer* _tmp215_;
						ValaBlock* _tmp216_;
						ValaBlock* _tmp217_;
						ValaBlock* _tmp218_;
						ValaExpressionStatement* stmt = NULL;
						ValaSourceReference* _tmp219_;
						ValaSourceReference* _tmp220_;
						ValaBaseAccess* _tmp221_;
						ValaBaseAccess* _tmp222_;
						ValaSourceReference* _tmp223_;
						ValaSourceReference* _tmp224_;
						ValaMethodCall* _tmp225_;
						ValaMethodCall* _tmp226_;
						ValaSourceReference* _tmp227_;
						ValaSourceReference* _tmp228_;
						ValaExpressionStatement* _tmp229_;
						ValaExpressionStatement* _tmp230_;
						ValaBlock* _tmp231_;
						ValaBlock* _tmp232_;
						ValaExpressionStatement* _tmp233_;
						ValaExpressionStatement* _tmp234_;
						ValaCodeContext* _tmp235_;
						ValaCodeContext* _tmp236_;
						ValaSemanticAnalyzer* _tmp237_;
						ValaSemanticAnalyzer* _tmp238_;
						ValaCodeContext* _tmp239_;
						ValaSemanticAnalyzer* _tmp240_;
						ValaSemanticAnalyzer* _tmp241_;
						ValaBlock* _tmp242_;
						ValaBlock* _tmp243_;
						_tmp203_ = context;
						_tmp204_ = vala_code_context_get_analyzer (_tmp203_);
						_tmp205_ = _tmp204_;
						_tmp206_ = _tmp205_->insert_block;
						_tmp207_ = _vala_code_node_ref0 (_tmp206_);
						old_insert_block = _tmp207_;
						_tmp208_ = context;
						_tmp209_ = vala_code_context_get_analyzer (_tmp208_);
						_tmp210_ = _tmp209_;
						_tmp211_ = vala_subroutine_get_body ((ValaSubroutine*) self);
						_tmp212_ = _tmp211_;
						vala_semantic_analyzer_set_current_symbol (_tmp210_, (ValaSymbol*) _tmp212_);
						_tmp213_ = context;
						_tmp214_ = vala_code_context_get_analyzer (_tmp213_);
						_tmp215_ = _tmp214_;
						_tmp216_ = vala_subroutine_get_body ((ValaSubroutine*) self);
						_tmp217_ = _tmp216_;
						_tmp218_ = _vala_code_node_ref0 (_tmp217_);
						_vala_code_node_unref0 (_tmp215_->insert_block);
						_tmp215_->insert_block = _tmp218_;
						_tmp219_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp220_ = _tmp219_;
						_tmp221_ = vala_base_access_new (_tmp220_);
						_tmp222_ = _tmp221_;
						_tmp223_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp224_ = _tmp223_;
						_tmp225_ = vala_method_call_new ((ValaExpression*) _tmp222_, _tmp224_);
						_tmp226_ = _tmp225_;
						_tmp227_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp228_ = _tmp227_;
						_tmp229_ = vala_expression_statement_new ((ValaExpression*) _tmp226_, _tmp228_);
						_tmp230_ = _tmp229_;
						_vala_code_node_unref0 (_tmp226_);
						_vala_code_node_unref0 (_tmp222_);
						stmt = _tmp230_;
						_tmp231_ = vala_subroutine_get_body ((ValaSubroutine*) self);
						_tmp232_ = _tmp231_;
						_tmp233_ = stmt;
						vala_block_insert_statement (_tmp232_, 0, (ValaStatement*) _tmp233_);
						_tmp234_ = stmt;
						_tmp235_ = context;
						vala_code_node_check ((ValaCodeNode*) _tmp234_, _tmp235_);
						_tmp236_ = context;
						_tmp237_ = vala_code_context_get_analyzer (_tmp236_);
						_tmp238_ = _tmp237_;
						vala_semantic_analyzer_set_current_symbol (_tmp238_, (ValaSymbol*) self);
						_tmp239_ = context;
						_tmp240_ = vala_code_context_get_analyzer (_tmp239_);
						_tmp241_ = _tmp240_;
						_tmp242_ = old_insert_block;
						_tmp243_ = _vala_code_node_ref0 (_tmp242_);
						_vala_code_node_unref0 (_tmp241_->insert_block);
						_tmp241_->insert_block = _tmp243_;
						_vala_code_node_unref0 (stmt);
						_vala_code_node_unref0 (old_insert_block);
					}
				}
			}
		}
		_vala_code_node_unref0 (cl);
	}
	_tmp244_ = context;
	_tmp245_ = vala_code_context_get_analyzer (_tmp244_);
	_tmp246_ = _tmp245_;
	_tmp247_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp246_, _tmp247_);
	_tmp248_ = context;
	_tmp249_ = vala_code_context_get_analyzer (_tmp248_);
	_tmp250_ = _tmp249_;
	_tmp251_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp250_, _tmp251_);
	_tmp254_ = vala_method_get_is_abstract ((ValaMethod*) self);
	_tmp255_ = _tmp254_;
	if (_tmp255_) {
		_tmp253_ = TRUE;
	} else {
		gboolean _tmp256_;
		gboolean _tmp257_;
		_tmp256_ = vala_method_get_is_virtual ((ValaMethod*) self);
		_tmp257_ = _tmp256_;
		_tmp253_ = _tmp257_;
	}
	if (_tmp253_) {
		_tmp252_ = TRUE;
	} else {
		gboolean _tmp258_;
		gboolean _tmp259_;
		_tmp258_ = vala_method_get_overrides ((ValaMethod*) self);
		_tmp259_ = _tmp258_;
		_tmp252_ = _tmp259_;
	}
	if (_tmp252_) {
		ValaSourceReference* _tmp260_;
		ValaSourceReference* _tmp261_;
		gchar* _tmp262_;
		gchar* _tmp263_;
		gchar* _tmp264_;
		gchar* _tmp265_;
		_tmp260_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp261_ = _tmp260_;
		_tmp262_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp263_ = _tmp262_;
		_tmp264_ = g_strdup_printf ("The creation method `%s' cannot be marked as override, virtual, or abs" \
"tract", _tmp263_);
		_tmp265_ = _tmp264_;
		vala_report_error (_tmp261_, _tmp265_);
		_g_free0 (_tmp265_);
		_g_free0 (_tmp263_);
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	_tmp266_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp267_ = _tmp266_;
	if (_tmp267_ != NULL) {
		{
			ValaList* _body_error_type_list = NULL;
			ValaBlock* _tmp268_;
			ValaBlock* _tmp269_;
			ValaList* _tmp270_;
			gint _body_error_type_size = 0;
			ValaList* _tmp271_;
			gint _tmp272_;
			gint _tmp273_;
			gint _body_error_type_index = 0;
			_tmp268_ = vala_subroutine_get_body ((ValaSubroutine*) self);
			_tmp269_ = _tmp268_;
			_tmp270_ = vala_code_node_get_error_types ((ValaCodeNode*) _tmp269_);
			_body_error_type_list = _tmp270_;
			_tmp271_ = _body_error_type_list;
			_tmp272_ = vala_collection_get_size ((ValaCollection*) _tmp271_);
			_tmp273_ = _tmp272_;
			_body_error_type_size = _tmp273_;
			_body_error_type_index = -1;
			while (TRUE) {
				gint _tmp274_;
				gint _tmp275_;
				gint _tmp276_;
				ValaDataType* body_error_type = NULL;
				ValaList* _tmp277_;
				gint _tmp278_;
				gpointer _tmp279_;
				gboolean can_propagate_error = FALSE;
				gboolean _tmp293_ = FALSE;
				gboolean _tmp294_;
				_tmp274_ = _body_error_type_index;
				_body_error_type_index = _tmp274_ + 1;
				_tmp275_ = _body_error_type_index;
				_tmp276_ = _body_error_type_size;
				if (!(_tmp275_ < _tmp276_)) {
					break;
				}
				_tmp277_ = _body_error_type_list;
				_tmp278_ = _body_error_type_index;
				_tmp279_ = vala_list_get (_tmp277_, _tmp278_);
				body_error_type = (ValaDataType*) _tmp279_;
				can_propagate_error = FALSE;
				{
					ValaList* _method_error_type_list = NULL;
					ValaList* _tmp280_;
					gint _method_error_type_size = 0;
					ValaList* _tmp281_;
					gint _tmp282_;
					gint _tmp283_;
					gint _method_error_type_index = 0;
					_tmp280_ = vala_code_node_get_error_types ((ValaCodeNode*) self);
					_method_error_type_list = _tmp280_;
					_tmp281_ = _method_error_type_list;
					_tmp282_ = vala_collection_get_size ((ValaCollection*) _tmp281_);
					_tmp283_ = _tmp282_;
					_method_error_type_size = _tmp283_;
					_method_error_type_index = -1;
					while (TRUE) {
						gint _tmp284_;
						gint _tmp285_;
						gint _tmp286_;
						ValaDataType* method_error_type = NULL;
						ValaList* _tmp287_;
						gint _tmp288_;
						gpointer _tmp289_;
						ValaDataType* _tmp290_;
						ValaDataType* _tmp291_;
						gboolean _tmp292_;
						_tmp284_ = _method_error_type_index;
						_method_error_type_index = _tmp284_ + 1;
						_tmp285_ = _method_error_type_index;
						_tmp286_ = _method_error_type_size;
						if (!(_tmp285_ < _tmp286_)) {
							break;
						}
						_tmp287_ = _method_error_type_list;
						_tmp288_ = _method_error_type_index;
						_tmp289_ = vala_list_get (_tmp287_, _tmp288_);
						method_error_type = (ValaDataType*) _tmp289_;
						_tmp290_ = body_error_type;
						_tmp291_ = method_error_type;
						_tmp292_ = vala_data_type_compatible (_tmp290_, _tmp291_);
						if (_tmp292_) {
							can_propagate_error = TRUE;
						}
						_vala_code_node_unref0 (method_error_type);
					}
					_vala_iterable_unref0 (_method_error_type_list);
				}
				_tmp294_ = can_propagate_error;
				if (!_tmp294_) {
					ValaDataType* _tmp295_;
					gboolean _tmp296_;
					gboolean _tmp297_;
					_tmp295_ = body_error_type;
					_tmp296_ = vala_error_type_get_dynamic_error (G_TYPE_CHECK_INSTANCE_CAST (_tmp295_, VALA_TYPE_ERROR_TYPE, ValaErrorType));
					_tmp297_ = _tmp296_;
					_tmp293_ = !_tmp297_;
				} else {
					_tmp293_ = FALSE;
				}
				if (_tmp293_) {
					ValaDataType* _tmp298_;
					ValaSourceReference* _tmp299_;
					ValaSourceReference* _tmp300_;
					ValaDataType* _tmp301_;
					gchar* _tmp302_;
					gchar* _tmp303_;
					gchar* _tmp304_;
					gchar* _tmp305_;
					_tmp298_ = body_error_type;
					_tmp299_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp298_);
					_tmp300_ = _tmp299_;
					_tmp301_ = body_error_type;
					_tmp302_ = vala_code_node_to_string ((ValaCodeNode*) _tmp301_);
					_tmp303_ = _tmp302_;
					_tmp304_ = g_strdup_printf ("unhandled error `%s'", _tmp303_);
					_tmp305_ = _tmp304_;
					vala_report_warning (_tmp300_, _tmp305_);
					_g_free0 (_tmp305_);
					_g_free0 (_tmp303_);
				}
				_vala_code_node_unref0 (body_error_type);
			}
			_vala_iterable_unref0 (_body_error_type_list);
		}
	}
	_tmp306_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp307_ = _tmp306_;
	result = !_tmp307_;
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}


const gchar* vala_creation_method_get_class_name (ValaCreationMethod* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_class_name;
	result = _tmp0_;
	return result;
}


void vala_creation_method_set_class_name (ValaCreationMethod* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_class_name);
	self->priv->_class_name = _tmp1_;
}


gboolean vala_creation_method_get_chain_up (ValaCreationMethod* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_chain_up;
	result = _tmp0_;
	return result;
}


void vala_creation_method_set_chain_up (ValaCreationMethod* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_chain_up = _tmp0_;
}


static void vala_creation_method_class_init (ValaCreationMethodClass * klass) {
	vala_creation_method_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_creation_method_finalize;
	g_type_class_add_private (klass, sizeof (ValaCreationMethodPrivate));
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_creation_method_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_creation_method_real_accept_children;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode *, ValaCodeContext*)) vala_creation_method_real_check;
}


static void vala_creation_method_instance_init (ValaCreationMethod * self) {
	self->priv = VALA_CREATION_METHOD_GET_PRIVATE (self);
}


static void vala_creation_method_finalize (ValaCodeNode * obj) {
	ValaCreationMethod * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_CREATION_METHOD, ValaCreationMethod);
	_g_free0 (self->priv->_class_name);
	VALA_CODE_NODE_CLASS (vala_creation_method_parent_class)->finalize (obj);
}


/**
 * Represents a type creation method.
 */
GType vala_creation_method_get_type (void) {
	static volatile gsize vala_creation_method_type_id__volatile = 0;
	if (g_once_init_enter (&vala_creation_method_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCreationMethodClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_creation_method_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCreationMethod), 0, (GInstanceInitFunc) vala_creation_method_instance_init, NULL };
		GType vala_creation_method_type_id;
		vala_creation_method_type_id = g_type_register_static (VALA_TYPE_METHOD, "ValaCreationMethod", &g_define_type_info, 0);
		g_once_init_leave (&vala_creation_method_type_id__volatile, vala_creation_method_type_id);
	}
	return vala_creation_method_type_id__volatile;
}



