/* valadatatype.c generated by valac, the Vala compiler
 * generated from valadatatype.vala, do not modify */

/* valadatatype.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <valagee.h>
#include <stdlib.h>
#include <string.h>

enum  {
	VALA_DATA_TYPE_DUMMY_PROPERTY,
	VALA_DATA_TYPE_LAST_PROPERTY
};
static GParamSpec* vala_data_type_properties[VALA_DATA_TYPE_LAST_PROPERTY];
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_scope_unref0(var) ((var == NULL) ? NULL : (var = (vala_scope_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))

struct _ValaDataTypePrivate {
	gboolean _value_owned;
	gboolean _nullable;
	ValaTypeSymbol* _data_type;
	ValaTypeParameter* _type_parameter;
	gboolean _floating_reference;
	gboolean _is_dynamic;
	ValaList* type_argument_list;
};


static gpointer vala_data_type_parent_class = NULL;
static ValaList* vala_data_type__empty_type_list;
static ValaList* vala_data_type__empty_type_list = NULL;

#define VALA_DATA_TYPE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_DATA_TYPE, ValaDataTypePrivate))
static void vala_data_type_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_data_type_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
static gchar* vala_data_type_real_to_string (ValaCodeNode* base);
static gchar* vala_data_type_real_to_qualified_string (ValaDataType* self, ValaScope* scope);
static ValaDataType* vala_data_type_real_copy (ValaDataType* self);
static gboolean vala_data_type_real_equals (ValaDataType* self, ValaDataType* type2);
static gboolean vala_data_type_real_stricter (ValaDataType* self, ValaDataType* type2);
static void vala_data_type_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type);
static gboolean vala_data_type_real_compatible (ValaDataType* self, ValaDataType* target_type);
G_GNUC_INTERNAL ValaDataType* vala_semantic_analyzer_get_instance_base_type_for_member (ValaDataType* derived_instance_type, ValaTypeSymbol* type_symbol, ValaCodeNode* node_reference);
static gboolean vala_data_type_real_is_invokable (ValaDataType* self);
static ValaDataType* vala_data_type_real_get_return_type (ValaDataType* self);
static ValaList* vala_data_type_real_get_parameters (ValaDataType* self);
static gboolean vala_data_type_real_is_reference_type_or_type_parameter (ValaDataType* self);
static gboolean vala_data_type_real_is_array (ValaDataType* self);
static gboolean vala_data_type_real_is_accessible (ValaDataType* self, ValaSymbol* sym);
static ValaSymbol* vala_data_type_real_get_member (ValaDataType* self, const gchar* member_name);
static ValaSymbol* vala_data_type_real_get_pointer_member (ValaDataType* self, const gchar* member_name);
static gboolean vala_data_type_real_is_real_struct_type (ValaDataType* self);
static gboolean vala_data_type_real_is_disposable (ValaDataType* self);
static ValaDataType* vala_data_type_real_get_actual_type (ValaDataType* self, ValaDataType* derived_instance_type, ValaList* method_type_arguments, ValaCodeNode* node_reference);
static ValaDataType* vala_data_type_real_infer_type_argument (ValaDataType* self, ValaTypeParameter* type_param, ValaDataType* value_type);
static gchar* vala_data_type_real_to_prototype_string (ValaDataType* self, const gchar* override_name);
static void vala_data_type_finalize (ValaCodeNode * obj);


/**
 * Appends the specified type as generic type argument.
 *
 * @param arg a type reference
 */
void vala_data_type_add_type_argument (ValaDataType* self, ValaDataType* arg) {
	ValaList* _tmp0_;
	ValaList* _tmp3_;
	ValaDataType* _tmp4_;
	ValaDataType* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (arg != NULL);
	_tmp0_ = self->priv->type_argument_list;
	if (_tmp0_ == NULL) {
		GEqualFunc _tmp1_;
		ValaArrayList* _tmp2_;
		_tmp1_ = g_direct_equal;
		_tmp2_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp1_);
		_vala_iterable_unref0 (self->priv->type_argument_list);
		self->priv->type_argument_list = (ValaList*) _tmp2_;
	}
	_tmp3_ = self->priv->type_argument_list;
	_tmp4_ = arg;
	vala_collection_add ((ValaCollection*) _tmp3_, _tmp4_);
	_tmp5_ = arg;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp5_, (ValaCodeNode*) self);
}


/**
 * Returns a copy of the list of generic type arguments.
 *
 * @return type argument list
 */
static gpointer _vala_iterable_ref0 (gpointer self) {
	return self ? vala_iterable_ref (self) : NULL;
}


ValaList* vala_data_type_get_type_arguments (ValaDataType* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp3_;
	ValaList* _tmp6_;
	ValaList* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->type_argument_list;
	if (_tmp0_ != NULL) {
		ValaList* _tmp1_;
		ValaList* _tmp2_;
		_tmp1_ = self->priv->type_argument_list;
		_tmp2_ = _vala_iterable_ref0 (_tmp1_);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = vala_data_type__empty_type_list;
	if (_tmp3_ == NULL) {
		GEqualFunc _tmp4_;
		ValaArrayList* _tmp5_;
		_tmp4_ = g_direct_equal;
		_tmp5_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp4_);
		_vala_iterable_unref0 (vala_data_type__empty_type_list);
		vala_data_type__empty_type_list = (ValaList*) _tmp5_;
	}
	_tmp6_ = vala_data_type__empty_type_list;
	_tmp7_ = _vala_iterable_ref0 (_tmp6_);
	result = _tmp7_;
	return result;
}


gboolean vala_data_type_has_type_arguments (ValaDataType* self) {
	gboolean result = FALSE;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->type_argument_list;
	if (_tmp0_ == NULL) {
		result = FALSE;
		return result;
	}
	_tmp1_ = self->priv->type_argument_list;
	_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	result = _tmp3_ > 0;
	return result;
}


/**
 * Removes all generic type arguments.
 */
void vala_data_type_remove_all_type_arguments (ValaDataType* self) {
	g_return_if_fail (self != NULL);
	_vala_iterable_unref0 (self->priv->type_argument_list);
	self->priv->type_argument_list = NULL;
}


static void vala_data_type_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaDataType * self;
	ValaCodeVisitor* _tmp0_;
	self = (ValaDataType*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = visitor;
	vala_code_visitor_visit_data_type (_tmp0_, self);
}


static void vala_data_type_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaDataType * self;
	gboolean _tmp0_ = FALSE;
	ValaList* _tmp1_;
	self = (ValaDataType*) base;
	g_return_if_fail (visitor != NULL);
	_tmp1_ = self->priv->type_argument_list;
	if (_tmp1_ != NULL) {
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		_tmp2_ = self->priv->type_argument_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ > 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		{
			ValaList* _type_arg_list = NULL;
			ValaList* _tmp5_;
			ValaList* _tmp6_;
			gint _type_arg_size = 0;
			ValaList* _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			gint _type_arg_index = 0;
			_tmp5_ = self->priv->type_argument_list;
			_tmp6_ = _vala_iterable_ref0 (_tmp5_);
			_type_arg_list = _tmp6_;
			_tmp7_ = _type_arg_list;
			_tmp8_ = vala_collection_get_size ((ValaCollection*) _tmp7_);
			_tmp9_ = _tmp8_;
			_type_arg_size = _tmp9_;
			_type_arg_index = -1;
			while (TRUE) {
				gint _tmp10_;
				gint _tmp11_;
				gint _tmp12_;
				ValaDataType* type_arg = NULL;
				ValaList* _tmp13_;
				gint _tmp14_;
				gpointer _tmp15_;
				ValaDataType* _tmp16_;
				ValaCodeVisitor* _tmp17_;
				_tmp10_ = _type_arg_index;
				_type_arg_index = _tmp10_ + 1;
				_tmp11_ = _type_arg_index;
				_tmp12_ = _type_arg_size;
				if (!(_tmp11_ < _tmp12_)) {
					break;
				}
				_tmp13_ = _type_arg_list;
				_tmp14_ = _type_arg_index;
				_tmp15_ = vala_list_get (_tmp13_, _tmp14_);
				type_arg = (ValaDataType*) _tmp15_;
				_tmp16_ = type_arg;
				_tmp17_ = visitor;
				vala_code_node_accept ((ValaCodeNode*) _tmp16_, _tmp17_);
				_vala_code_node_unref0 (type_arg);
			}
			_vala_iterable_unref0 (_type_arg_list);
		}
	}
}


static gchar* vala_data_type_real_to_string (ValaCodeNode* base) {
	ValaDataType * self;
	gchar* result = NULL;
	gchar* _tmp0_;
	self = (ValaDataType*) base;
	_tmp0_ = vala_data_type_to_qualified_string (self, NULL);
	result = _tmp0_;
	return result;
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


static gpointer _vala_scope_ref0 (gpointer self) {
	return self ? vala_scope_ref (self) : NULL;
}


static gchar* vala_data_type_real_to_qualified_string (ValaDataType* self, ValaScope* scope) {
	gchar* result = NULL;
	gchar* s = NULL;
	ValaTypeSymbol* _tmp0_;
	ValaList* type_args = NULL;
	ValaList* _tmp37_;
	ValaList* _tmp38_;
	gint _tmp39_;
	gint _tmp40_;
	gboolean _tmp69_;
	_tmp0_ = self->priv->_data_type;
	if (_tmp0_ != NULL) {
		ValaSymbol* global_symbol = NULL;
		ValaTypeSymbol* _tmp1_;
		ValaSymbol* _tmp2_;
		ValaSymbol* sym = NULL;
		ValaScope* parent_scope = NULL;
		ValaScope* _tmp12_;
		ValaScope* _tmp13_;
		gboolean _tmp26_ = FALSE;
		ValaSymbol* _tmp27_;
		_tmp1_ = self->priv->_data_type;
		_tmp2_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp1_);
		global_symbol = _tmp2_;
		while (TRUE) {
			ValaSymbol* _tmp3_;
			ValaSymbol* _tmp4_;
			ValaSymbol* _tmp5_;
			const gchar* _tmp6_;
			const gchar* _tmp7_;
			ValaSymbol* _tmp8_;
			ValaSymbol* _tmp9_;
			ValaSymbol* _tmp10_;
			ValaSymbol* _tmp11_;
			_tmp3_ = global_symbol;
			_tmp4_ = vala_symbol_get_parent_symbol (_tmp3_);
			_tmp5_ = _tmp4_;
			_tmp6_ = vala_symbol_get_name (_tmp5_);
			_tmp7_ = _tmp6_;
			if (!(_tmp7_ != NULL)) {
				break;
			}
			_tmp8_ = global_symbol;
			_tmp9_ = vala_symbol_get_parent_symbol (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = _vala_code_node_ref0 (_tmp10_);
			_vala_code_node_unref0 (global_symbol);
			global_symbol = _tmp11_;
		}
		sym = NULL;
		_tmp12_ = scope;
		_tmp13_ = _vala_scope_ref0 (_tmp12_);
		parent_scope = _tmp13_;
		while (TRUE) {
			gboolean _tmp14_ = FALSE;
			ValaSymbol* _tmp15_;
			ValaScope* _tmp17_;
			ValaSymbol* _tmp18_;
			const gchar* _tmp19_;
			const gchar* _tmp20_;
			ValaSymbol* _tmp21_;
			ValaScope* _tmp22_;
			ValaScope* _tmp23_;
			ValaScope* _tmp24_;
			ValaScope* _tmp25_;
			_tmp15_ = sym;
			if (_tmp15_ == NULL) {
				ValaScope* _tmp16_;
				_tmp16_ = parent_scope;
				_tmp14_ = _tmp16_ != NULL;
			} else {
				_tmp14_ = FALSE;
			}
			if (!_tmp14_) {
				break;
			}
			_tmp17_ = parent_scope;
			_tmp18_ = global_symbol;
			_tmp19_ = vala_symbol_get_name (_tmp18_);
			_tmp20_ = _tmp19_;
			_tmp21_ = vala_scope_lookup (_tmp17_, _tmp20_);
			_vala_code_node_unref0 (sym);
			sym = _tmp21_;
			_tmp22_ = parent_scope;
			_tmp23_ = vala_scope_get_parent_scope (_tmp22_);
			_tmp24_ = _tmp23_;
			_tmp25_ = _vala_scope_ref0 (_tmp24_);
			_vala_scope_unref0 (parent_scope);
			parent_scope = _tmp25_;
		}
		_tmp27_ = sym;
		if (_tmp27_ != NULL) {
			ValaSymbol* _tmp28_;
			ValaSymbol* _tmp29_;
			_tmp28_ = global_symbol;
			_tmp29_ = sym;
			_tmp26_ = _tmp28_ != _tmp29_;
		} else {
			_tmp26_ = FALSE;
		}
		if (_tmp26_) {
			ValaTypeSymbol* _tmp30_;
			gchar* _tmp31_;
			gchar* _tmp32_;
			gchar* _tmp33_;
			_tmp30_ = self->priv->_data_type;
			_tmp31_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp30_);
			_tmp32_ = _tmp31_;
			_tmp33_ = g_strconcat ("global::", _tmp32_, NULL);
			_g_free0 (s);
			s = _tmp33_;
			_g_free0 (_tmp32_);
		} else {
			ValaTypeSymbol* _tmp34_;
			gchar* _tmp35_;
			_tmp34_ = self->priv->_data_type;
			_tmp35_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp34_);
			_g_free0 (s);
			s = _tmp35_;
		}
		_vala_scope_unref0 (parent_scope);
		_vala_code_node_unref0 (sym);
		_vala_code_node_unref0 (global_symbol);
	} else {
		gchar* _tmp36_;
		_tmp36_ = g_strdup ("null");
		_g_free0 (s);
		s = _tmp36_;
	}
	_tmp37_ = vala_data_type_get_type_arguments (self);
	type_args = _tmp37_;
	_tmp38_ = type_args;
	_tmp39_ = vala_collection_get_size ((ValaCollection*) _tmp38_);
	_tmp40_ = _tmp39_;
	if (_tmp40_ > 0) {
		const gchar* _tmp41_;
		gchar* _tmp42_;
		gboolean first = FALSE;
		const gchar* _tmp67_;
		gchar* _tmp68_;
		_tmp41_ = s;
		_tmp42_ = g_strconcat (_tmp41_, "<", NULL);
		_g_free0 (s);
		s = _tmp42_;
		first = TRUE;
		{
			ValaList* _type_arg_list = NULL;
			ValaList* _tmp43_;
			ValaList* _tmp44_;
			gint _type_arg_size = 0;
			ValaList* _tmp45_;
			gint _tmp46_;
			gint _tmp47_;
			gint _type_arg_index = 0;
			_tmp43_ = type_args;
			_tmp44_ = _vala_iterable_ref0 (_tmp43_);
			_type_arg_list = _tmp44_;
			_tmp45_ = _type_arg_list;
			_tmp46_ = vala_collection_get_size ((ValaCollection*) _tmp45_);
			_tmp47_ = _tmp46_;
			_type_arg_size = _tmp47_;
			_type_arg_index = -1;
			while (TRUE) {
				gint _tmp48_;
				gint _tmp49_;
				gint _tmp50_;
				ValaDataType* type_arg = NULL;
				ValaList* _tmp51_;
				gint _tmp52_;
				gpointer _tmp53_;
				gboolean _tmp54_;
				ValaDataType* _tmp57_;
				gboolean _tmp58_;
				const gchar* _tmp61_;
				ValaDataType* _tmp62_;
				ValaScope* _tmp63_;
				gchar* _tmp64_;
				gchar* _tmp65_;
				gchar* _tmp66_;
				_tmp48_ = _type_arg_index;
				_type_arg_index = _tmp48_ + 1;
				_tmp49_ = _type_arg_index;
				_tmp50_ = _type_arg_size;
				if (!(_tmp49_ < _tmp50_)) {
					break;
				}
				_tmp51_ = _type_arg_list;
				_tmp52_ = _type_arg_index;
				_tmp53_ = vala_list_get (_tmp51_, _tmp52_);
				type_arg = (ValaDataType*) _tmp53_;
				_tmp54_ = first;
				if (!_tmp54_) {
					const gchar* _tmp55_;
					gchar* _tmp56_;
					_tmp55_ = s;
					_tmp56_ = g_strconcat (_tmp55_, ",", NULL);
					_g_free0 (s);
					s = _tmp56_;
				} else {
					first = FALSE;
				}
				_tmp57_ = type_arg;
				_tmp58_ = _tmp57_->priv->_value_owned;
				if (!_tmp58_) {
					const gchar* _tmp59_;
					gchar* _tmp60_;
					_tmp59_ = s;
					_tmp60_ = g_strconcat (_tmp59_, "weak ", NULL);
					_g_free0 (s);
					s = _tmp60_;
				}
				_tmp61_ = s;
				_tmp62_ = type_arg;
				_tmp63_ = scope;
				_tmp64_ = vala_data_type_to_qualified_string (_tmp62_, _tmp63_);
				_tmp65_ = _tmp64_;
				_tmp66_ = g_strconcat (_tmp61_, _tmp65_, NULL);
				_g_free0 (s);
				s = _tmp66_;
				_g_free0 (_tmp65_);
				_vala_code_node_unref0 (type_arg);
			}
			_vala_iterable_unref0 (_type_arg_list);
		}
		_tmp67_ = s;
		_tmp68_ = g_strconcat (_tmp67_, ">", NULL);
		_g_free0 (s);
		s = _tmp68_;
	}
	_tmp69_ = self->priv->_nullable;
	if (_tmp69_) {
		const gchar* _tmp70_;
		gchar* _tmp71_;
		_tmp70_ = s;
		_tmp71_ = g_strconcat (_tmp70_, "?", NULL);
		_g_free0 (s);
		s = _tmp71_;
	}
	result = s;
	_vala_iterable_unref0 (type_args);
	return result;
}


gchar* vala_data_type_to_qualified_string (ValaDataType* self, ValaScope* scope) {
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_DATA_TYPE_GET_CLASS (self)->to_qualified_string (self, scope);
}


/**
 * Creates a shallow copy of this type reference.
 *
 * @return copy of this type reference
 */
static ValaDataType* vala_data_type_real_copy (ValaDataType* self) {
	g_critical ("Type `%s' does not implement abstract method `vala_data_type_copy'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


ValaDataType* vala_data_type_copy (ValaDataType* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_DATA_TYPE_GET_CLASS (self)->copy (self);
}


/**
 * Checks two type references for equality. May only be used with
 * resolved type references.
 *
 * @param type2 a type reference
 * @return      true if this type reference is equal to type2, false
 *              otherwise
 */
static gboolean vala_data_type_real_equals (ValaDataType* self, ValaDataType* type2) {
	gboolean result = FALSE;
	ValaDataType* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	ValaDataType* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	ValaDataType* _tmp6_;
	ValaTypeSymbol* _tmp7_;
	ValaTypeSymbol* _tmp8_;
	gboolean _tmp9_ = FALSE;
	ValaDataType* _tmp10_;
	ValaTypeParameter* _tmp11_;
	ValaDataType* _tmp21_;
	gboolean _tmp22_;
	gboolean _tmp23_;
	ValaList* type_args = NULL;
	ValaList* _tmp24_;
	ValaList* type2_args = NULL;
	ValaDataType* _tmp25_;
	ValaList* _tmp26_;
	ValaList* _tmp27_;
	gint _tmp28_;
	gint _tmp29_;
	ValaList* _tmp30_;
	gint _tmp31_;
	gint _tmp32_;
	g_return_val_if_fail (type2 != NULL, FALSE);
	_tmp0_ = type2;
	_tmp1_ = vala_data_type_is_disposable (_tmp0_);
	_tmp2_ = vala_data_type_is_disposable (self);
	if (_tmp1_ != _tmp2_) {
		result = FALSE;
		return result;
	}
	_tmp3_ = type2;
	_tmp4_ = _tmp3_->priv->_nullable;
	_tmp5_ = self->priv->_nullable;
	if (_tmp4_ != _tmp5_) {
		result = FALSE;
		return result;
	}
	_tmp6_ = type2;
	_tmp7_ = _tmp6_->priv->_data_type;
	_tmp8_ = self->priv->_data_type;
	if (_tmp7_ != _tmp8_) {
		result = FALSE;
		return result;
	}
	_tmp10_ = type2;
	_tmp11_ = _tmp10_->priv->_type_parameter;
	if (_tmp11_ != NULL) {
		_tmp9_ = TRUE;
	} else {
		ValaTypeParameter* _tmp12_;
		_tmp12_ = self->priv->_type_parameter;
		_tmp9_ = _tmp12_ != NULL;
	}
	if (_tmp9_) {
		gboolean _tmp13_ = FALSE;
		ValaDataType* _tmp14_;
		ValaTypeParameter* _tmp15_;
		ValaDataType* _tmp17_;
		ValaTypeParameter* _tmp18_;
		ValaTypeParameter* _tmp19_;
		gboolean _tmp20_;
		_tmp14_ = type2;
		_tmp15_ = _tmp14_->priv->_type_parameter;
		if (_tmp15_ == NULL) {
			_tmp13_ = TRUE;
		} else {
			ValaTypeParameter* _tmp16_;
			_tmp16_ = self->priv->_type_parameter;
			_tmp13_ = _tmp16_ == NULL;
		}
		if (_tmp13_) {
			result = FALSE;
			return result;
		}
		_tmp17_ = type2;
		_tmp18_ = _tmp17_->priv->_type_parameter;
		_tmp19_ = self->priv->_type_parameter;
		_tmp20_ = vala_typeparameter_equals (_tmp18_, _tmp19_);
		if (!_tmp20_) {
			result = FALSE;
			return result;
		}
	}
	_tmp21_ = type2;
	_tmp22_ = _tmp21_->priv->_floating_reference;
	_tmp23_ = self->priv->_floating_reference;
	if (_tmp22_ != _tmp23_) {
		result = FALSE;
		return result;
	}
	_tmp24_ = vala_data_type_get_type_arguments (self);
	type_args = _tmp24_;
	_tmp25_ = type2;
	_tmp26_ = vala_data_type_get_type_arguments (_tmp25_);
	type2_args = _tmp26_;
	_tmp27_ = type2_args;
	_tmp28_ = vala_collection_get_size ((ValaCollection*) _tmp27_);
	_tmp29_ = _tmp28_;
	_tmp30_ = type_args;
	_tmp31_ = vala_collection_get_size ((ValaCollection*) _tmp30_);
	_tmp32_ = _tmp31_;
	if (_tmp29_ != _tmp32_) {
		result = FALSE;
		_vala_iterable_unref0 (type2_args);
		_vala_iterable_unref0 (type_args);
		return result;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp33_ = FALSE;
			_tmp33_ = TRUE;
			while (TRUE) {
				gint _tmp35_;
				ValaList* _tmp36_;
				gint _tmp37_;
				gint _tmp38_;
				ValaList* _tmp39_;
				gint _tmp40_;
				gpointer _tmp41_;
				ValaDataType* _tmp42_;
				ValaList* _tmp43_;
				gint _tmp44_;
				gpointer _tmp45_;
				ValaDataType* _tmp46_;
				gboolean _tmp47_;
				gboolean _tmp48_;
				if (!_tmp33_) {
					gint _tmp34_;
					_tmp34_ = i;
					i = _tmp34_ + 1;
				}
				_tmp33_ = FALSE;
				_tmp35_ = i;
				_tmp36_ = type_args;
				_tmp37_ = vala_collection_get_size ((ValaCollection*) _tmp36_);
				_tmp38_ = _tmp37_;
				if (!(_tmp35_ < _tmp38_)) {
					break;
				}
				_tmp39_ = type2_args;
				_tmp40_ = i;
				_tmp41_ = vala_list_get (_tmp39_, _tmp40_);
				_tmp42_ = (ValaDataType*) _tmp41_;
				_tmp43_ = type_args;
				_tmp44_ = i;
				_tmp45_ = vala_list_get (_tmp43_, _tmp44_);
				_tmp46_ = (ValaDataType*) _tmp45_;
				_tmp47_ = vala_data_type_equals (_tmp42_, _tmp46_);
				_tmp48_ = !_tmp47_;
				_vala_code_node_unref0 (_tmp46_);
				_vala_code_node_unref0 (_tmp42_);
				if (_tmp48_) {
					result = FALSE;
					_vala_iterable_unref0 (type2_args);
					_vala_iterable_unref0 (type_args);
					return result;
				}
			}
		}
	}
	result = TRUE;
	_vala_iterable_unref0 (type2_args);
	_vala_iterable_unref0 (type_args);
	return result;
}


gboolean vala_data_type_equals (ValaDataType* self, ValaDataType* type2) {
	g_return_val_if_fail (self != NULL, FALSE);
	return VALA_DATA_TYPE_GET_CLASS (self)->equals (self, type2);
}


/**
 * Checks whether this type reference is at least as strict as the
 * specified type reference type2.
 *
 * @param type2 a type reference
 * @return      true if this type reference is stricter or equal
 */
static gboolean vala_data_type_real_stricter (ValaDataType* self, ValaDataType* type2) {
	gboolean result = FALSE;
	ValaDataType* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_ = FALSE;
	ValaDataType* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp7_ = FALSE;
	ValaTypeParameter* _tmp8_;
	ValaDataType* _tmp11_;
	ValaTypeSymbol* _tmp12_;
	ValaTypeSymbol* _tmp13_;
	ValaDataType* _tmp14_;
	gboolean _tmp15_;
	gboolean _tmp16_;
	g_return_val_if_fail (type2 != NULL, FALSE);
	_tmp0_ = type2;
	_tmp1_ = vala_data_type_is_disposable (_tmp0_);
	_tmp2_ = vala_data_type_is_disposable (self);
	if (_tmp1_ != _tmp2_) {
		result = FALSE;
		return result;
	}
	_tmp4_ = type2;
	_tmp5_ = _tmp4_->priv->_nullable;
	if (!_tmp5_) {
		gboolean _tmp6_;
		_tmp6_ = self->priv->_nullable;
		_tmp3_ = _tmp6_;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		result = FALSE;
		return result;
	}
	_tmp8_ = self->priv->_type_parameter;
	if (_tmp8_ != NULL) {
		_tmp7_ = TRUE;
	} else {
		ValaDataType* _tmp9_;
		ValaTypeParameter* _tmp10_;
		_tmp9_ = type2;
		_tmp10_ = _tmp9_->priv->_type_parameter;
		_tmp7_ = _tmp10_ != NULL;
	}
	if (_tmp7_) {
		result = TRUE;
		return result;
	}
	_tmp11_ = type2;
	_tmp12_ = _tmp11_->priv->_data_type;
	_tmp13_ = self->priv->_data_type;
	if (_tmp12_ != _tmp13_) {
		result = FALSE;
		return result;
	}
	_tmp14_ = type2;
	_tmp15_ = _tmp14_->priv->_floating_reference;
	_tmp16_ = self->priv->_floating_reference;
	if (_tmp15_ != _tmp16_) {
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}


gboolean vala_data_type_stricter (ValaDataType* self, ValaDataType* type2) {
	g_return_val_if_fail (self != NULL, FALSE);
	return VALA_DATA_TYPE_GET_CLASS (self)->stricter (self, type2);
}


static void vala_data_type_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type) {
	ValaDataType * self;
	ValaList* _tmp0_;
	self = (ValaDataType*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = self->priv->type_argument_list;
	if (_tmp0_ != NULL) {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp1_ = FALSE;
				_tmp1_ = TRUE;
				while (TRUE) {
					gint _tmp3_;
					ValaList* _tmp4_;
					gint _tmp5_;
					gint _tmp6_;
					ValaList* _tmp7_;
					gint _tmp8_;
					gpointer _tmp9_;
					ValaDataType* _tmp10_;
					ValaDataType* _tmp11_;
					gboolean _tmp12_;
					if (!_tmp1_) {
						gint _tmp2_;
						_tmp2_ = i;
						i = _tmp2_ + 1;
					}
					_tmp1_ = FALSE;
					_tmp3_ = i;
					_tmp4_ = self->priv->type_argument_list;
					_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
					_tmp6_ = _tmp5_;
					if (!(_tmp3_ < _tmp6_)) {
						break;
					}
					_tmp7_ = self->priv->type_argument_list;
					_tmp8_ = i;
					_tmp9_ = vala_list_get (_tmp7_, _tmp8_);
					_tmp10_ = (ValaDataType*) _tmp9_;
					_tmp11_ = old_type;
					_tmp12_ = _tmp10_ == _tmp11_;
					_vala_code_node_unref0 (_tmp10_);
					if (_tmp12_) {
						ValaList* _tmp13_;
						gint _tmp14_;
						ValaDataType* _tmp15_;
						_tmp13_ = self->priv->type_argument_list;
						_tmp14_ = i;
						_tmp15_ = new_type;
						vala_list_set (_tmp13_, _tmp14_, _tmp15_);
						return;
					}
				}
			}
		}
	}
}


static gboolean vala_data_type_real_compatible (ValaDataType* self, ValaDataType* target_type) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaCodeContext* _tmp2_;
	ValaCodeContext* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	ValaDataType* _tmp10_;
	ValaTypeSymbol* _tmp11_;
	gboolean _tmp32_ = FALSE;
	ValaDataType* _tmp33_;
	ValaDataType* _tmp39_;
	ValaDataType* _tmp47_;
	ValaTypeParameter* _tmp48_;
	ValaDataType* _tmp49_;
	gboolean _tmp50_ = FALSE;
	gboolean _tmp51_ = FALSE;
	ValaTypeSymbol* _tmp52_;
	gboolean _tmp58_ = FALSE;
	gboolean _tmp59_ = FALSE;
	ValaTypeSymbol* _tmp60_;
	gboolean _tmp96_ = FALSE;
	ValaTypeSymbol* _tmp97_;
	g_return_val_if_fail (target_type != NULL, FALSE);
	_tmp2_ = vala_code_context_get ();
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_code_context_get_experimental_non_null (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_;
	_vala_code_context_unref0 (_tmp3_);
	if (_tmp6_) {
		gboolean _tmp7_;
		_tmp7_ = self->priv->_nullable;
		_tmp1_ = _tmp7_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		ValaDataType* _tmp8_;
		gboolean _tmp9_;
		_tmp8_ = target_type;
		_tmp9_ = _tmp8_->priv->_nullable;
		_tmp0_ = !_tmp9_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp10_ = target_type;
	_tmp11_ = _tmp10_->priv->_data_type;
	if (_tmp11_ != NULL) {
		ValaDataType* _tmp12_;
		ValaTypeSymbol* _tmp13_;
		ValaCodeContext* _tmp14_;
		ValaCodeContext* _tmp15_;
		ValaSemanticAnalyzer* _tmp16_;
		ValaSemanticAnalyzer* _tmp17_;
		ValaStructValueType* _tmp18_;
		ValaTypeSymbol* _tmp19_;
		gboolean _tmp20_;
		gboolean _tmp21_;
		ValaDataType* _tmp22_;
		ValaTypeSymbol* _tmp23_;
		ValaCodeContext* _tmp24_;
		ValaCodeContext* _tmp25_;
		ValaSemanticAnalyzer* _tmp26_;
		ValaSemanticAnalyzer* _tmp27_;
		ValaObjectType* _tmp28_;
		ValaTypeSymbol* _tmp29_;
		gboolean _tmp30_;
		gboolean _tmp31_;
		_tmp12_ = target_type;
		_tmp13_ = _tmp12_->priv->_data_type;
		_tmp14_ = vala_code_context_get ();
		_tmp15_ = _tmp14_;
		_tmp16_ = vala_code_context_get_analyzer (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = _tmp17_->gvalue_type;
		_tmp19_ = ((ValaDataType*) _tmp18_)->priv->_data_type;
		_tmp20_ = vala_typesymbol_is_subtype_of (_tmp13_, _tmp19_);
		_tmp21_ = _tmp20_;
		_vala_code_context_unref0 (_tmp15_);
		if (_tmp21_) {
			result = TRUE;
			return result;
		}
		_tmp22_ = target_type;
		_tmp23_ = _tmp22_->priv->_data_type;
		_tmp24_ = vala_code_context_get ();
		_tmp25_ = _tmp24_;
		_tmp26_ = vala_code_context_get_analyzer (_tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = _tmp27_->gvariant_type;
		_tmp29_ = ((ValaDataType*) _tmp28_)->priv->_data_type;
		_tmp30_ = vala_typesymbol_is_subtype_of (_tmp23_, _tmp29_);
		_tmp31_ = _tmp30_;
		_vala_code_context_unref0 (_tmp25_);
		if (_tmp31_) {
			result = TRUE;
			return result;
		}
	}
	_tmp33_ = target_type;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp33_, VALA_TYPE_DELEGATE_TYPE)) {
		_tmp32_ = G_TYPE_CHECK_INSTANCE_TYPE (self, VALA_TYPE_DELEGATE_TYPE);
	} else {
		_tmp32_ = FALSE;
	}
	if (_tmp32_) {
		ValaDataType* _tmp34_;
		ValaDelegate* _tmp35_;
		ValaDelegate* _tmp36_;
		ValaDelegate* _tmp37_;
		ValaDelegate* _tmp38_;
		_tmp34_ = target_type;
		_tmp35_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
		_tmp36_ = _tmp35_;
		_tmp37_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
		_tmp38_ = _tmp37_;
		result = _tmp36_ == _tmp38_;
		return result;
	}
	_tmp39_ = target_type;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp39_, VALA_TYPE_POINTER_TYPE)) {
		gboolean _tmp40_ = FALSE;
		ValaTypeParameter* _tmp41_;
		_tmp41_ = self->priv->_type_parameter;
		if (_tmp41_ != NULL) {
			_tmp40_ = TRUE;
		} else {
			gboolean _tmp42_ = FALSE;
			ValaTypeSymbol* _tmp43_;
			_tmp43_ = self->priv->_data_type;
			if (_tmp43_ != NULL) {
				gboolean _tmp44_ = FALSE;
				ValaTypeSymbol* _tmp45_;
				gboolean _tmp46_;
				_tmp45_ = self->priv->_data_type;
				_tmp46_ = vala_typesymbol_is_reference_type (_tmp45_);
				if (_tmp46_) {
					_tmp44_ = TRUE;
				} else {
					_tmp44_ = G_TYPE_CHECK_INSTANCE_TYPE (self, VALA_TYPE_DELEGATE_TYPE);
				}
				_tmp42_ = _tmp44_;
			} else {
				_tmp42_ = FALSE;
			}
			_tmp40_ = _tmp42_;
		}
		if (_tmp40_) {
			result = TRUE;
			return result;
		}
		result = FALSE;
		return result;
	}
	_tmp47_ = target_type;
	_tmp48_ = _tmp47_->priv->_type_parameter;
	if (_tmp48_ != NULL) {
		result = TRUE;
		return result;
	}
	_tmp49_ = target_type;
	if (G_TYPE_CHECK_INSTANCE_TYPE (self, VALA_TYPE_ARRAY_TYPE) != G_TYPE_CHECK_INSTANCE_TYPE (_tmp49_, VALA_TYPE_ARRAY_TYPE)) {
		result = FALSE;
		return result;
	}
	_tmp52_ = self->priv->_data_type;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp52_, VALA_TYPE_ENUM)) {
		ValaDataType* _tmp53_;
		ValaTypeSymbol* _tmp54_;
		_tmp53_ = target_type;
		_tmp54_ = _tmp53_->priv->_data_type;
		_tmp51_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp54_, VALA_TYPE_STRUCT);
	} else {
		_tmp51_ = FALSE;
	}
	if (_tmp51_) {
		ValaDataType* _tmp55_;
		ValaTypeSymbol* _tmp56_;
		gboolean _tmp57_;
		_tmp55_ = target_type;
		_tmp56_ = _tmp55_->priv->_data_type;
		_tmp57_ = vala_struct_is_integer_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp56_, VALA_TYPE_STRUCT, ValaStruct));
		_tmp50_ = _tmp57_;
	} else {
		_tmp50_ = FALSE;
	}
	if (_tmp50_) {
		result = TRUE;
		return result;
	}
	_tmp60_ = self->priv->_data_type;
	if (_tmp60_ != NULL) {
		ValaDataType* _tmp61_;
		ValaTypeSymbol* _tmp62_;
		_tmp61_ = target_type;
		_tmp62_ = _tmp61_->priv->_data_type;
		_tmp59_ = _tmp62_ != NULL;
	} else {
		_tmp59_ = FALSE;
	}
	if (_tmp59_) {
		ValaTypeSymbol* _tmp63_;
		ValaDataType* _tmp64_;
		ValaTypeSymbol* _tmp65_;
		gboolean _tmp66_;
		_tmp63_ = self->priv->_data_type;
		_tmp64_ = target_type;
		_tmp65_ = _tmp64_->priv->_data_type;
		_tmp66_ = vala_typesymbol_is_subtype_of (_tmp63_, _tmp65_);
		_tmp58_ = _tmp66_;
	} else {
		_tmp58_ = FALSE;
	}
	if (_tmp58_) {
		ValaDataType* base_type = NULL;
		ValaDataType* _tmp67_;
		ValaTypeSymbol* _tmp68_;
		ValaDataType* _tmp69_;
		ValaList* base_type_args = NULL;
		ValaDataType* _tmp70_;
		ValaList* _tmp71_;
		ValaList* target_type_args = NULL;
		ValaDataType* _tmp72_;
		ValaList* _tmp73_;
		ValaList* _tmp74_;
		gint _tmp75_;
		gint _tmp76_;
		ValaList* _tmp77_;
		gint _tmp78_;
		gint _tmp79_;
		_tmp67_ = target_type;
		_tmp68_ = _tmp67_->priv->_data_type;
		_tmp69_ = vala_semantic_analyzer_get_instance_base_type_for_member (self, _tmp68_, (ValaCodeNode*) self);
		base_type = _tmp69_;
		_tmp70_ = base_type;
		_tmp71_ = vala_data_type_get_type_arguments (_tmp70_);
		base_type_args = _tmp71_;
		_tmp72_ = target_type;
		_tmp73_ = vala_data_type_get_type_arguments (_tmp72_);
		target_type_args = _tmp73_;
		_tmp74_ = base_type_args;
		_tmp75_ = vala_collection_get_size ((ValaCollection*) _tmp74_);
		_tmp76_ = _tmp75_;
		_tmp77_ = target_type_args;
		_tmp78_ = vala_collection_get_size ((ValaCollection*) _tmp77_);
		_tmp79_ = _tmp78_;
		if (_tmp76_ == _tmp79_) {
			{
				gint i = 0;
				i = 0;
				{
					gboolean _tmp80_ = FALSE;
					_tmp80_ = TRUE;
					while (TRUE) {
						gint _tmp82_;
						ValaList* _tmp83_;
						gint _tmp84_;
						gint _tmp85_;
						ValaList* _tmp86_;
						gint _tmp87_;
						gpointer _tmp88_;
						ValaDataType* _tmp89_;
						ValaList* _tmp90_;
						gint _tmp91_;
						gpointer _tmp92_;
						ValaDataType* _tmp93_;
						gboolean _tmp94_;
						gboolean _tmp95_;
						if (!_tmp80_) {
							gint _tmp81_;
							_tmp81_ = i;
							i = _tmp81_ + 1;
						}
						_tmp80_ = FALSE;
						_tmp82_ = i;
						_tmp83_ = base_type_args;
						_tmp84_ = vala_collection_get_size ((ValaCollection*) _tmp83_);
						_tmp85_ = _tmp84_;
						if (!(_tmp82_ < _tmp85_)) {
							break;
						}
						_tmp86_ = base_type_args;
						_tmp87_ = i;
						_tmp88_ = vala_list_get (_tmp86_, _tmp87_);
						_tmp89_ = (ValaDataType*) _tmp88_;
						_tmp90_ = target_type_args;
						_tmp91_ = i;
						_tmp92_ = vala_list_get (_tmp90_, _tmp91_);
						_tmp93_ = (ValaDataType*) _tmp92_;
						_tmp94_ = vala_data_type_compatible (_tmp89_, _tmp93_);
						_tmp95_ = !_tmp94_;
						_vala_code_node_unref0 (_tmp93_);
						_vala_code_node_unref0 (_tmp89_);
						if (_tmp95_) {
							result = FALSE;
							_vala_iterable_unref0 (target_type_args);
							_vala_iterable_unref0 (base_type_args);
							_vala_code_node_unref0 (base_type);
							return result;
						}
					}
				}
			}
		}
		result = TRUE;
		_vala_iterable_unref0 (target_type_args);
		_vala_iterable_unref0 (base_type_args);
		_vala_code_node_unref0 (base_type);
		return result;
	}
	_tmp97_ = self->priv->_data_type;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp97_, VALA_TYPE_STRUCT)) {
		ValaDataType* _tmp98_;
		ValaTypeSymbol* _tmp99_;
		_tmp98_ = target_type;
		_tmp99_ = _tmp98_->priv->_data_type;
		_tmp96_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp99_, VALA_TYPE_STRUCT);
	} else {
		_tmp96_ = FALSE;
	}
	if (_tmp96_) {
		ValaStruct* expr_struct = NULL;
		ValaTypeSymbol* _tmp100_;
		ValaStruct* _tmp101_;
		ValaStruct* expect_struct = NULL;
		ValaDataType* _tmp102_;
		ValaTypeSymbol* _tmp103_;
		ValaStruct* _tmp104_;
		gboolean _tmp105_ = FALSE;
		ValaStruct* _tmp106_;
		gboolean _tmp107_;
		gboolean _tmp110_ = FALSE;
		gboolean _tmp111_ = FALSE;
		ValaStruct* _tmp112_;
		gboolean _tmp113_;
		_tmp100_ = self->priv->_data_type;
		_tmp101_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp100_, VALA_TYPE_STRUCT, ValaStruct));
		expr_struct = _tmp101_;
		_tmp102_ = target_type;
		_tmp103_ = _tmp102_->priv->_data_type;
		_tmp104_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp103_, VALA_TYPE_STRUCT, ValaStruct));
		expect_struct = _tmp104_;
		_tmp106_ = expr_struct;
		_tmp107_ = vala_struct_is_integer_type (_tmp106_);
		if (_tmp107_) {
			ValaStruct* _tmp108_;
			gboolean _tmp109_;
			_tmp108_ = expect_struct;
			_tmp109_ = vala_struct_is_floating_type (_tmp108_);
			_tmp105_ = _tmp109_;
		} else {
			_tmp105_ = FALSE;
		}
		if (_tmp105_) {
			result = TRUE;
			_vala_code_node_unref0 (expect_struct);
			_vala_code_node_unref0 (expr_struct);
			return result;
		}
		_tmp112_ = expr_struct;
		_tmp113_ = vala_struct_is_integer_type (_tmp112_);
		if (_tmp113_) {
			ValaStruct* _tmp114_;
			gboolean _tmp115_;
			_tmp114_ = expect_struct;
			_tmp115_ = vala_struct_is_integer_type (_tmp114_);
			_tmp111_ = _tmp115_;
		} else {
			_tmp111_ = FALSE;
		}
		if (_tmp111_) {
			_tmp110_ = TRUE;
		} else {
			gboolean _tmp116_ = FALSE;
			ValaStruct* _tmp117_;
			gboolean _tmp118_;
			_tmp117_ = expr_struct;
			_tmp118_ = vala_struct_is_floating_type (_tmp117_);
			if (_tmp118_) {
				ValaStruct* _tmp119_;
				gboolean _tmp120_;
				_tmp119_ = expect_struct;
				_tmp120_ = vala_struct_is_floating_type (_tmp119_);
				_tmp116_ = _tmp120_;
			} else {
				_tmp116_ = FALSE;
			}
			_tmp110_ = _tmp116_;
		}
		if (_tmp110_) {
			ValaStruct* _tmp121_;
			gint _tmp122_;
			ValaStruct* _tmp123_;
			gint _tmp124_;
			_tmp121_ = expr_struct;
			_tmp122_ = vala_struct_get_rank (_tmp121_);
			_tmp123_ = expect_struct;
			_tmp124_ = vala_struct_get_rank (_tmp123_);
			if (_tmp122_ <= _tmp124_) {
				result = TRUE;
				_vala_code_node_unref0 (expect_struct);
				_vala_code_node_unref0 (expr_struct);
				return result;
			}
		}
		_vala_code_node_unref0 (expect_struct);
		_vala_code_node_unref0 (expr_struct);
	}
	result = FALSE;
	return result;
}


gboolean vala_data_type_compatible (ValaDataType* self, ValaDataType* target_type) {
	g_return_val_if_fail (self != NULL, FALSE);
	return VALA_DATA_TYPE_GET_CLASS (self)->compatible (self, target_type);
}


/**
 * Returns whether instances of this type are invokable.
 *
 * @return true if invokable, false otherwise
 */
static gboolean vala_data_type_real_is_invokable (ValaDataType* self) {
	gboolean result = FALSE;
	result = FALSE;
	return result;
}


gboolean vala_data_type_is_invokable (ValaDataType* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return VALA_DATA_TYPE_GET_CLASS (self)->is_invokable (self);
}


/**
 * Returns the return type of this invokable.
 *
 * @return return type
 */
static ValaDataType* vala_data_type_real_get_return_type (ValaDataType* self) {
	ValaDataType* result = NULL;
	result = NULL;
	return result;
}


ValaDataType* vala_data_type_get_return_type (ValaDataType* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_DATA_TYPE_GET_CLASS (self)->get_return_type (self);
}


/**
 * Returns copy of the list of invocation parameters.
 *
 * @return parameter list
 */
static ValaList* vala_data_type_real_get_parameters (ValaDataType* self) {
	ValaList* result = NULL;
	result = NULL;
	return result;
}


ValaList* vala_data_type_get_parameters (ValaDataType* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_DATA_TYPE_GET_CLASS (self)->get_parameters (self);
}


static gboolean vala_data_type_real_is_reference_type_or_type_parameter (ValaDataType* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaTypeSymbol* _tmp2_;
	_tmp2_ = self->priv->_data_type;
	if (_tmp2_ != NULL) {
		ValaTypeSymbol* _tmp3_;
		gboolean _tmp4_;
		_tmp3_ = self->priv->_data_type;
		_tmp4_ = vala_typesymbol_is_reference_type (_tmp3_);
		_tmp1_ = _tmp4_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		ValaTypeParameter* _tmp5_;
		_tmp5_ = self->priv->_type_parameter;
		_tmp0_ = _tmp5_ != NULL;
	}
	result = _tmp0_;
	return result;
}


gboolean vala_data_type_is_reference_type_or_type_parameter (ValaDataType* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return VALA_DATA_TYPE_GET_CLASS (self)->is_reference_type_or_type_parameter (self);
}


static gboolean vala_data_type_real_is_array (ValaDataType* self) {
	gboolean result = FALSE;
	result = FALSE;
	return result;
}


gboolean vala_data_type_is_array (ValaDataType* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return VALA_DATA_TYPE_GET_CLASS (self)->is_array (self);
}


static gboolean vala_data_type_real_is_accessible (ValaDataType* self, ValaSymbol* sym) {
	gboolean result = FALSE;
	ValaTypeSymbol* _tmp13_;
	g_return_val_if_fail (sym != NULL, FALSE);
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp0_;
		gint _type_arg_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _type_arg_index = 0;
		_tmp0_ = vala_data_type_get_type_arguments (self);
		_type_arg_list = _tmp0_;
		_tmp1_ = _type_arg_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_type_arg_size = _tmp3_;
		_type_arg_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			gint _tmp6_;
			ValaDataType* type_arg = NULL;
			ValaList* _tmp7_;
			gint _tmp8_;
			gpointer _tmp9_;
			ValaDataType* _tmp10_;
			ValaSymbol* _tmp11_;
			gboolean _tmp12_;
			_tmp4_ = _type_arg_index;
			_type_arg_index = _tmp4_ + 1;
			_tmp5_ = _type_arg_index;
			_tmp6_ = _type_arg_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _type_arg_list;
			_tmp8_ = _type_arg_index;
			_tmp9_ = vala_list_get (_tmp7_, _tmp8_);
			type_arg = (ValaDataType*) _tmp9_;
			_tmp10_ = type_arg;
			_tmp11_ = sym;
			_tmp12_ = vala_data_type_is_accessible (_tmp10_, _tmp11_);
			if (!_tmp12_) {
				result = FALSE;
				_vala_code_node_unref0 (type_arg);
				_vala_iterable_unref0 (_type_arg_list);
				return result;
			}
			_vala_code_node_unref0 (type_arg);
		}
		_vala_iterable_unref0 (_type_arg_list);
	}
	_tmp13_ = self->priv->_data_type;
	if (_tmp13_ != NULL) {
		ValaTypeSymbol* _tmp14_;
		ValaSymbol* _tmp15_;
		gboolean _tmp16_;
		_tmp14_ = self->priv->_data_type;
		_tmp15_ = sym;
		_tmp16_ = vala_symbol_is_accessible ((ValaSymbol*) _tmp14_, _tmp15_);
		result = _tmp16_;
		return result;
	}
	result = TRUE;
	return result;
}


gboolean vala_data_type_is_accessible (ValaDataType* self, ValaSymbol* sym) {
	g_return_val_if_fail (self != NULL, FALSE);
	return VALA_DATA_TYPE_GET_CLASS (self)->is_accessible (self, sym);
}


static ValaSymbol* vala_data_type_real_get_member (ValaDataType* self, const gchar* member_name) {
	ValaSymbol* result = NULL;
	ValaTypeSymbol* _tmp0_;
	g_return_val_if_fail (member_name != NULL, NULL);
	_tmp0_ = self->priv->_data_type;
	if (_tmp0_ != NULL) {
		ValaTypeSymbol* _tmp1_;
		const gchar* _tmp2_;
		ValaSymbol* _tmp3_;
		_tmp1_ = self->priv->_data_type;
		_tmp2_ = member_name;
		_tmp3_ = vala_semantic_analyzer_symbol_lookup_inherited ((ValaSymbol*) _tmp1_, _tmp2_);
		result = _tmp3_;
		return result;
	}
	result = NULL;
	return result;
}


ValaSymbol* vala_data_type_get_member (ValaDataType* self, const gchar* member_name) {
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_DATA_TYPE_GET_CLASS (self)->get_member (self, member_name);
}


static ValaSymbol* vala_data_type_real_get_pointer_member (ValaDataType* self, const gchar* member_name) {
	ValaSymbol* result = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	result = NULL;
	return result;
}


ValaSymbol* vala_data_type_get_pointer_member (ValaDataType* self, const gchar* member_name) {
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_DATA_TYPE_GET_CLASS (self)->get_pointer_member (self, member_name);
}


/**
 * Checks whether this data type references a real struct. A real struct
 * is a struct which is not a simple (fundamental) type.
 */
static gboolean vala_data_type_real_is_real_struct_type (ValaDataType* self) {
	gboolean result = FALSE;
	ValaStruct* s = NULL;
	ValaTypeSymbol* _tmp0_;
	ValaStruct* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaStruct* _tmp3_;
	_tmp0_ = self->priv->_data_type;
	_tmp1_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp0_) : NULL);
	s = _tmp1_;
	_tmp3_ = s;
	if (_tmp3_ != NULL) {
		ValaStruct* _tmp4_;
		gboolean _tmp5_;
		_tmp4_ = s;
		_tmp5_ = vala_struct_is_simple_type (_tmp4_);
		_tmp2_ = !_tmp5_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		result = TRUE;
		_vala_code_node_unref0 (s);
		return result;
	}
	result = FALSE;
	_vala_code_node_unref0 (s);
	return result;
}


gboolean vala_data_type_is_real_struct_type (ValaDataType* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return VALA_DATA_TYPE_GET_CLASS (self)->is_real_struct_type (self);
}


gboolean vala_data_type_is_real_non_null_struct_type (ValaDataType* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = vala_data_type_is_real_struct_type (self);
	if (_tmp1_) {
		gboolean _tmp2_;
		_tmp2_ = self->priv->_nullable;
		_tmp0_ = !_tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


/**
 * Returns whether the value needs to be disposed, i.e. whether
 * allocated memory or other resources need to be released when
 * the value is no longer needed.
 */
static gboolean vala_data_type_real_is_disposable (ValaDataType* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	_tmp0_ = self->priv->_value_owned;
	if (!_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp1_ = vala_data_type_is_reference_type_or_type_parameter (self);
	if (_tmp1_) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


gboolean vala_data_type_is_disposable (ValaDataType* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return VALA_DATA_TYPE_GET_CLASS (self)->is_disposable (self);
}


static ValaDataType* vala_data_type_real_get_actual_type (ValaDataType* self, ValaDataType* derived_instance_type, ValaList* method_type_arguments, ValaCodeNode* node_reference) {
	ValaDataType* result = NULL;
	ValaDataType* _result_ = NULL;
	ValaDataType* _tmp0_;
	gboolean _tmp1_ = FALSE;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp4_;
	g_return_val_if_fail (node_reference != NULL, NULL);
	_tmp0_ = vala_data_type_copy (self);
	_result_ = _tmp0_;
	_tmp2_ = derived_instance_type;
	if (_tmp2_ == NULL) {
		ValaList* _tmp3_;
		_tmp3_ = method_type_arguments;
		_tmp1_ = _tmp3_ == NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		result = _result_;
		return result;
	}
	_tmp4_ = _result_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, VALA_TYPE_GENERIC_TYPE)) {
		ValaDataType* _tmp5_;
		ValaList* _tmp6_;
		ValaDataType* _tmp7_;
		ValaCodeNode* _tmp8_;
		ValaDataType* _tmp9_;
		_tmp5_ = derived_instance_type;
		_tmp6_ = method_type_arguments;
		_tmp7_ = _result_;
		_tmp8_ = node_reference;
		_tmp9_ = vala_semantic_analyzer_get_actual_type (_tmp5_, _tmp6_, G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, VALA_TYPE_GENERIC_TYPE, ValaGenericType), _tmp8_);
		_vala_code_node_unref0 (_result_);
		_result_ = _tmp9_;
	} else {
		ValaDataType* _tmp10_;
		ValaList* _tmp11_;
		_tmp10_ = _result_;
		_tmp11_ = _tmp10_->priv->type_argument_list;
		if (_tmp11_ != NULL) {
			{
				gint i = 0;
				i = 0;
				{
					gboolean _tmp12_ = FALSE;
					_tmp12_ = TRUE;
					while (TRUE) {
						gint _tmp14_;
						ValaDataType* _tmp15_;
						ValaList* _tmp16_;
						gint _tmp17_;
						gint _tmp18_;
						ValaDataType* _tmp19_;
						ValaList* _tmp20_;
						gint _tmp21_;
						ValaDataType* _tmp22_;
						ValaList* _tmp23_;
						gint _tmp24_;
						gpointer _tmp25_;
						ValaDataType* _tmp26_;
						ValaDataType* _tmp27_;
						ValaList* _tmp28_;
						ValaCodeNode* _tmp29_;
						ValaDataType* _tmp30_;
						ValaDataType* _tmp31_;
						if (!_tmp12_) {
							gint _tmp13_;
							_tmp13_ = i;
							i = _tmp13_ + 1;
						}
						_tmp12_ = FALSE;
						_tmp14_ = i;
						_tmp15_ = _result_;
						_tmp16_ = _tmp15_->priv->type_argument_list;
						_tmp17_ = vala_collection_get_size ((ValaCollection*) _tmp16_);
						_tmp18_ = _tmp17_;
						if (!(_tmp14_ < _tmp18_)) {
							break;
						}
						_tmp19_ = _result_;
						_tmp20_ = _tmp19_->priv->type_argument_list;
						_tmp21_ = i;
						_tmp22_ = _result_;
						_tmp23_ = _tmp22_->priv->type_argument_list;
						_tmp24_ = i;
						_tmp25_ = vala_list_get (_tmp23_, _tmp24_);
						_tmp26_ = (ValaDataType*) _tmp25_;
						_tmp27_ = derived_instance_type;
						_tmp28_ = method_type_arguments;
						_tmp29_ = node_reference;
						_tmp30_ = vala_data_type_get_actual_type (_tmp26_, _tmp27_, _tmp28_, _tmp29_);
						_tmp31_ = _tmp30_;
						vala_list_set (_tmp20_, _tmp21_, _tmp31_);
						_vala_code_node_unref0 (_tmp31_);
						_vala_code_node_unref0 (_tmp26_);
					}
				}
			}
		}
	}
	result = _result_;
	return result;
}


ValaDataType* vala_data_type_get_actual_type (ValaDataType* self, ValaDataType* derived_instance_type, ValaList* method_type_arguments, ValaCodeNode* node_reference) {
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_DATA_TYPE_GET_CLASS (self)->get_actual_type (self, derived_instance_type, method_type_arguments, node_reference);
}


/**
 * Search for the type parameter in this formal type and match it in
 * value_type.
 */
static ValaDataType* vala_data_type_real_infer_type_argument (ValaDataType* self, ValaTypeParameter* type_param, ValaDataType* value_type) {
	ValaDataType* result = NULL;
	ValaIterator* value_type_arg_it = NULL;
	ValaDataType* _tmp0_;
	ValaList* _tmp1_;
	ValaList* _tmp2_;
	ValaIterator* _tmp3_;
	ValaIterator* _tmp4_;
	g_return_val_if_fail (type_param != NULL, NULL);
	g_return_val_if_fail (value_type != NULL, NULL);
	_tmp0_ = value_type;
	_tmp1_ = vala_data_type_get_type_arguments (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_iterable_iterator ((ValaIterable*) _tmp2_);
	_tmp4_ = _tmp3_;
	_vala_iterable_unref0 (_tmp2_);
	value_type_arg_it = _tmp4_;
	{
		ValaList* _formal_type_arg_list = NULL;
		ValaList* _tmp5_;
		gint _formal_type_arg_size = 0;
		ValaList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _formal_type_arg_index = 0;
		_tmp5_ = vala_data_type_get_type_arguments (self);
		_formal_type_arg_list = _tmp5_;
		_tmp6_ = _formal_type_arg_list;
		_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_formal_type_arg_size = _tmp8_;
		_formal_type_arg_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			ValaDataType* formal_type_arg = NULL;
			ValaList* _tmp12_;
			gint _tmp13_;
			gpointer _tmp14_;
			ValaIterator* _tmp15_;
			gboolean _tmp16_;
			_tmp9_ = _formal_type_arg_index;
			_formal_type_arg_index = _tmp9_ + 1;
			_tmp10_ = _formal_type_arg_index;
			_tmp11_ = _formal_type_arg_size;
			if (!(_tmp10_ < _tmp11_)) {
				break;
			}
			_tmp12_ = _formal_type_arg_list;
			_tmp13_ = _formal_type_arg_index;
			_tmp14_ = vala_list_get (_tmp12_, _tmp13_);
			formal_type_arg = (ValaDataType*) _tmp14_;
			_tmp15_ = value_type_arg_it;
			_tmp16_ = vala_iterator_next (_tmp15_);
			if (_tmp16_) {
				ValaDataType* inferred_type = NULL;
				ValaDataType* _tmp17_;
				ValaTypeParameter* _tmp18_;
				ValaIterator* _tmp19_;
				gpointer _tmp20_;
				ValaDataType* _tmp21_;
				ValaDataType* _tmp22_;
				ValaDataType* _tmp23_;
				ValaDataType* _tmp24_;
				_tmp17_ = formal_type_arg;
				_tmp18_ = type_param;
				_tmp19_ = value_type_arg_it;
				_tmp20_ = vala_iterator_get (_tmp19_);
				_tmp21_ = (ValaDataType*) _tmp20_;
				_tmp22_ = vala_data_type_infer_type_argument (_tmp17_, _tmp18_, _tmp21_);
				_tmp23_ = _tmp22_;
				_vala_code_node_unref0 (_tmp21_);
				inferred_type = _tmp23_;
				_tmp24_ = inferred_type;
				if (_tmp24_ != NULL) {
					result = inferred_type;
					_vala_code_node_unref0 (formal_type_arg);
					_vala_iterable_unref0 (_formal_type_arg_list);
					_vala_iterator_unref0 (value_type_arg_it);
					return result;
				}
				_vala_code_node_unref0 (inferred_type);
			}
			_vala_code_node_unref0 (formal_type_arg);
		}
		_vala_iterable_unref0 (_formal_type_arg_list);
	}
	result = NULL;
	_vala_iterator_unref0 (value_type_arg_it);
	return result;
}


ValaDataType* vala_data_type_infer_type_argument (ValaDataType* self, ValaTypeParameter* type_param, ValaDataType* value_type) {
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_DATA_TYPE_GET_CLASS (self)->infer_type_argument (self, type_param, value_type);
}


/**
 * Returns a stringified representation used for detailed error output
 *
 * @param override_name used as name if given
 * @return stringified representation
 */
static gchar* vala_data_type_real_to_prototype_string (ValaDataType* self, const gchar* override_name) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	_tmp1_ = vala_data_type_is_weak (self);
	if (_tmp1_) {
		_tmp0_ = "unowned ";
	} else {
		_tmp0_ = "";
	}
	_tmp2_ = vala_data_type_to_qualified_string (self, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf ("%s%s", _tmp0_, _tmp3_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	result = _tmp5_;
	return result;
}


gchar* vala_data_type_to_prototype_string (ValaDataType* self, const gchar* override_name) {
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_DATA_TYPE_GET_CLASS (self)->to_prototype_string (self, override_name);
}


gboolean vala_data_type_is_weak (ValaDataType* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_value_owned;
	if (_tmp0_) {
		result = FALSE;
		return result;
	} else {
		gboolean _tmp1_ = FALSE;
		if (G_TYPE_CHECK_INSTANCE_TYPE (self, VALA_TYPE_VOID_TYPE)) {
			_tmp1_ = TRUE;
		} else {
			_tmp1_ = G_TYPE_CHECK_INSTANCE_TYPE (self, VALA_TYPE_POINTER_TYPE);
		}
		if (_tmp1_) {
			result = FALSE;
			return result;
		} else {
			if (G_TYPE_CHECK_INSTANCE_TYPE (self, VALA_TYPE_VALUE_TYPE)) {
				gboolean _tmp2_;
				_tmp2_ = self->priv->_nullable;
				if (_tmp2_) {
					result = TRUE;
					return result;
				}
				result = FALSE;
				return result;
			}
		}
	}
	result = TRUE;
	return result;
}


ValaDataType* vala_data_type_construct (GType object_type) {
	ValaDataType* self = NULL;
	self = (ValaDataType*) vala_code_node_construct (object_type);
	return self;
}


gboolean vala_data_type_get_value_owned (ValaDataType* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_value_owned;
	result = _tmp0_;
	return result;
}


void vala_data_type_set_value_owned (ValaDataType* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_value_owned = _tmp0_;
}


gboolean vala_data_type_get_nullable (ValaDataType* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_nullable;
	result = _tmp0_;
	return result;
}


void vala_data_type_set_nullable (ValaDataType* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_nullable = _tmp0_;
}


ValaTypeSymbol* vala_data_type_get_data_type (ValaDataType* self) {
	ValaTypeSymbol* result;
	ValaTypeSymbol* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_data_type;
	result = _tmp0_;
	return result;
}


void vala_data_type_set_data_type (ValaDataType* self, ValaTypeSymbol* value) {
	ValaTypeSymbol* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_data_type = _tmp0_;
}


ValaTypeParameter* vala_data_type_get_type_parameter (ValaDataType* self) {
	ValaTypeParameter* result;
	ValaTypeParameter* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_type_parameter;
	result = _tmp0_;
	return result;
}


void vala_data_type_set_type_parameter (ValaDataType* self, ValaTypeParameter* value) {
	ValaTypeParameter* _tmp0_;
	ValaTypeParameter* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_type_parameter);
	self->priv->_type_parameter = _tmp1_;
}


gboolean vala_data_type_get_floating_reference (ValaDataType* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_floating_reference;
	result = _tmp0_;
	return result;
}


void vala_data_type_set_floating_reference (ValaDataType* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_floating_reference = _tmp0_;
}


gboolean vala_data_type_get_is_dynamic (ValaDataType* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_dynamic;
	result = _tmp0_;
	return result;
}


void vala_data_type_set_is_dynamic (ValaDataType* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_is_dynamic = _tmp0_;
}


static void vala_data_type_class_init (ValaDataTypeClass * klass) {
	vala_data_type_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_data_type_finalize;
	g_type_class_add_private (klass, sizeof (ValaDataTypePrivate));
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_data_type_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_data_type_real_accept_children;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode *)) vala_data_type_real_to_string;
	((ValaDataTypeClass *) klass)->to_qualified_string = (gchar* (*) (ValaDataType *, ValaScope*)) vala_data_type_real_to_qualified_string;
	((ValaDataTypeClass *) klass)->copy = (ValaDataType* (*) (ValaDataType *)) vala_data_type_real_copy;
	((ValaDataTypeClass *) klass)->equals = (gboolean (*) (ValaDataType *, ValaDataType*)) vala_data_type_real_equals;
	((ValaDataTypeClass *) klass)->stricter = (gboolean (*) (ValaDataType *, ValaDataType*)) vala_data_type_real_stricter;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode *, ValaDataType*, ValaDataType*)) vala_data_type_real_replace_type;
	((ValaDataTypeClass *) klass)->compatible = (gboolean (*) (ValaDataType *, ValaDataType*)) vala_data_type_real_compatible;
	((ValaDataTypeClass *) klass)->is_invokable = (gboolean (*) (ValaDataType *)) vala_data_type_real_is_invokable;
	((ValaDataTypeClass *) klass)->get_return_type = (ValaDataType* (*) (ValaDataType *)) vala_data_type_real_get_return_type;
	((ValaDataTypeClass *) klass)->get_parameters = (ValaList* (*) (ValaDataType *)) vala_data_type_real_get_parameters;
	((ValaDataTypeClass *) klass)->is_reference_type_or_type_parameter = (gboolean (*) (ValaDataType *)) vala_data_type_real_is_reference_type_or_type_parameter;
	((ValaDataTypeClass *) klass)->is_array = (gboolean (*) (ValaDataType *)) vala_data_type_real_is_array;
	((ValaDataTypeClass *) klass)->is_accessible = (gboolean (*) (ValaDataType *, ValaSymbol*)) vala_data_type_real_is_accessible;
	((ValaDataTypeClass *) klass)->get_member = (ValaSymbol* (*) (ValaDataType *, const gchar*)) vala_data_type_real_get_member;
	((ValaDataTypeClass *) klass)->get_pointer_member = (ValaSymbol* (*) (ValaDataType *, const gchar*)) vala_data_type_real_get_pointer_member;
	((ValaDataTypeClass *) klass)->is_real_struct_type = (gboolean (*) (ValaDataType *)) vala_data_type_real_is_real_struct_type;
	((ValaDataTypeClass *) klass)->is_disposable = (gboolean (*) (ValaDataType *)) vala_data_type_real_is_disposable;
	((ValaDataTypeClass *) klass)->get_actual_type = (ValaDataType* (*) (ValaDataType *, ValaDataType*, ValaList*, ValaCodeNode*)) vala_data_type_real_get_actual_type;
	((ValaDataTypeClass *) klass)->infer_type_argument = (ValaDataType* (*) (ValaDataType *, ValaTypeParameter*, ValaDataType*)) vala_data_type_real_infer_type_argument;
	((ValaDataTypeClass *) klass)->to_prototype_string = (gchar* (*) (ValaDataType *, const gchar*)) vala_data_type_real_to_prototype_string;
}


static void vala_data_type_instance_init (ValaDataType * self) {
	self->priv = VALA_DATA_TYPE_GET_PRIVATE (self);
}


static void vala_data_type_finalize (ValaCodeNode * obj) {
	ValaDataType * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_DATA_TYPE, ValaDataType);
	_vala_code_node_unref0 (self->priv->_type_parameter);
	_vala_iterable_unref0 (self->priv->type_argument_list);
	VALA_CODE_NODE_CLASS (vala_data_type_parent_class)->finalize (obj);
}


/**
 * A reference to a data type. This is used to specify static types of
 * expressions.
 */
GType vala_data_type_get_type (void) {
	static volatile gsize vala_data_type_type_id__volatile = 0;
	if (g_once_init_enter (&vala_data_type_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaDataTypeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_data_type_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaDataType), 0, (GInstanceInitFunc) vala_data_type_instance_init, NULL };
		GType vala_data_type_type_id;
		vala_data_type_type_id = g_type_register_static (VALA_TYPE_CODE_NODE, "ValaDataType", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&vala_data_type_type_id__volatile, vala_data_type_type_id);
	}
	return vala_data_type_type_id__volatile;
}



