/* valacharacterliteral.c generated by valac, the Vala compiler
 * generated from valacharacterliteral.vala, do not modify */

/* valacharacterliteral.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 2006-2009  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <stdlib.h>
#include <string.h>

enum  {
	VALA_CHARACTER_LITERAL_DUMMY_PROPERTY,
	VALA_CHARACTER_LITERAL_LAST_PROPERTY
};
static GParamSpec* vala_character_literal_properties[VALA_CHARACTER_LITERAL_LAST_PROPERTY];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))

struct _ValaCharacterLiteralPrivate {
	gchar* _value;
};


static gpointer vala_character_literal_parent_class = NULL;

#define VALA_CHARACTER_LITERAL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CHARACTER_LITERAL, ValaCharacterLiteralPrivate))
static void vala_character_literal_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static gboolean vala_character_literal_real_is_pure (ValaExpression* base);
static gchar* vala_character_literal_real_to_string (ValaCodeNode* base);
static gboolean vala_character_literal_real_check (ValaCodeNode* base, ValaCodeContext* context);
static void vala_character_literal_real_emit (ValaCodeNode* base, ValaCodeGenerator* codegen);
static void vala_character_literal_finalize (ValaCodeNode * obj);


/**
 * Creates a new character literal.
 *
 * @param c      character
 * @param source reference to source code
 * @return       newly created character literal
 */
ValaCharacterLiteral* vala_character_literal_construct (GType object_type, const gchar* c, ValaSourceReference* source) {
	ValaCharacterLiteral* self = NULL;
	const gchar* _tmp0_;
	ValaSourceReference* _tmp1_;
	g_return_val_if_fail (c != NULL, NULL);
	self = (ValaCharacterLiteral*) vala_literal_construct (object_type);
	_tmp0_ = c;
	vala_character_literal_set_value (self, _tmp0_);
	_tmp1_ = source;
	vala_code_node_set_source_reference ((ValaCodeNode*) self, _tmp1_);
	return self;
}


ValaCharacterLiteral* vala_character_literal_new (const gchar* c, ValaSourceReference* source) {
	return vala_character_literal_construct (VALA_TYPE_CHARACTER_LITERAL, c, source);
}


static void vala_character_literal_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaCharacterLiteral * self;
	ValaCodeVisitor* _tmp0_;
	ValaCodeVisitor* _tmp1_;
	self = (ValaCharacterLiteral*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = visitor;
	vala_code_visitor_visit_character_literal (_tmp0_, self);
	_tmp1_ = visitor;
	vala_code_visitor_visit_expression (_tmp1_, (ValaExpression*) self);
}


/**
 * Returns the unicode character value this character literal
 * represents.
 *
 * @return unicode character value
 */
static gunichar string_get_char (const gchar* self, glong index) {
	gunichar result = 0U;
	glong _tmp0_;
	gunichar _tmp1_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = index;
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
	result = _tmp1_;
	return result;
}


gunichar vala_character_literal_get_char (ValaCharacterLiteral* self) {
	gunichar result = 0U;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gunichar _tmp3_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = vala_character_literal_get_value (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_utf8_next_char (_tmp1_);
	_tmp3_ = string_get_char (_tmp2_, (glong) 0);
	result = _tmp3_;
	return result;
}


static gboolean vala_character_literal_real_is_pure (ValaExpression* base) {
	ValaCharacterLiteral * self;
	gboolean result = FALSE;
	self = (ValaCharacterLiteral*) base;
	result = TRUE;
	return result;
}


static gchar* vala_character_literal_real_to_string (ValaCodeNode* base) {
	ValaCharacterLiteral * self;
	gchar* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	self = (ValaCharacterLiteral*) base;
	_tmp0_ = vala_character_literal_get_value (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup (_tmp1_);
	result = _tmp2_;
	return result;
}


static gboolean vala_character_literal_real_check (ValaCodeNode* base, ValaCodeContext* context) {
	ValaCharacterLiteral * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gunichar _tmp4_;
	gboolean _tmp25_;
	gboolean _tmp26_;
	self = (ValaCharacterLiteral*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_character_literal_get_char (self);
	if (_tmp4_ < ((gunichar) 128)) {
		ValaCodeContext* _tmp5_;
		ValaSemanticAnalyzer* _tmp6_;
		ValaSemanticAnalyzer* _tmp7_;
		ValaSymbol* _tmp8_;
		ValaScope* _tmp9_;
		ValaScope* _tmp10_;
		ValaSymbol* _tmp11_;
		ValaStruct* _tmp12_;
		ValaIntegerType* _tmp13_;
		ValaIntegerType* _tmp14_;
		_tmp5_ = context;
		_tmp6_ = vala_code_context_get_analyzer (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = _tmp7_->root_symbol;
		_tmp9_ = vala_symbol_get_scope (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = vala_scope_lookup (_tmp10_, "char");
		_tmp12_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, VALA_TYPE_STRUCT, ValaStruct);
		_tmp13_ = vala_integer_type_new (_tmp12_, NULL, NULL);
		_tmp14_ = _tmp13_;
		vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp14_);
		_vala_code_node_unref0 (_tmp14_);
		_vala_code_node_unref0 (_tmp12_);
	} else {
		ValaCodeContext* _tmp15_;
		ValaSemanticAnalyzer* _tmp16_;
		ValaSemanticAnalyzer* _tmp17_;
		ValaSymbol* _tmp18_;
		ValaScope* _tmp19_;
		ValaScope* _tmp20_;
		ValaSymbol* _tmp21_;
		ValaStruct* _tmp22_;
		ValaIntegerType* _tmp23_;
		ValaIntegerType* _tmp24_;
		_tmp15_ = context;
		_tmp16_ = vala_code_context_get_analyzer (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = _tmp17_->root_symbol;
		_tmp19_ = vala_symbol_get_scope (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_scope_lookup (_tmp20_, "unichar");
		_tmp22_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, VALA_TYPE_STRUCT, ValaStruct);
		_tmp23_ = vala_integer_type_new (_tmp22_, NULL, NULL);
		_tmp24_ = _tmp23_;
		vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp24_);
		_vala_code_node_unref0 (_tmp24_);
		_vala_code_node_unref0 (_tmp22_);
	}
	_tmp25_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp26_ = _tmp25_;
	result = !_tmp26_;
	return result;
}


static void vala_character_literal_real_emit (ValaCodeNode* base, ValaCodeGenerator* codegen) {
	ValaCharacterLiteral * self;
	ValaCodeGenerator* _tmp0_;
	ValaCodeGenerator* _tmp1_;
	self = (ValaCharacterLiteral*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = codegen;
	vala_code_visitor_visit_character_literal ((ValaCodeVisitor*) _tmp0_, self);
	_tmp1_ = codegen;
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) _tmp1_, (ValaExpression*) self);
}


const gchar* vala_character_literal_get_value (ValaCharacterLiteral* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_value;
	result = _tmp0_;
	return result;
}


void vala_character_literal_set_value (ValaCharacterLiteral* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_value);
	self->priv->_value = _tmp1_;
	_tmp2_ = value;
	_tmp3_ = g_utf8_validate (_tmp2_, (gssize) -1, NULL);
	if (!_tmp3_) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
	}
}


static void vala_character_literal_class_init (ValaCharacterLiteralClass * klass) {
	vala_character_literal_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_character_literal_finalize;
	g_type_class_add_private (klass, sizeof (ValaCharacterLiteralPrivate));
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_character_literal_real_accept;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression *)) vala_character_literal_real_is_pure;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode *)) vala_character_literal_real_to_string;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode *, ValaCodeContext*)) vala_character_literal_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode *, ValaCodeGenerator*)) vala_character_literal_real_emit;
}


static void vala_character_literal_instance_init (ValaCharacterLiteral * self) {
	self->priv = VALA_CHARACTER_LITERAL_GET_PRIVATE (self);
}


static void vala_character_literal_finalize (ValaCodeNode * obj) {
	ValaCharacterLiteral * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_CHARACTER_LITERAL, ValaCharacterLiteral);
	_g_free0 (self->priv->_value);
	VALA_CODE_NODE_CLASS (vala_character_literal_parent_class)->finalize (obj);
}


/**
 * Represents a single literal character.
 */
GType vala_character_literal_get_type (void) {
	static volatile gsize vala_character_literal_type_id__volatile = 0;
	if (g_once_init_enter (&vala_character_literal_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCharacterLiteralClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_character_literal_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCharacterLiteral), 0, (GInstanceInitFunc) vala_character_literal_instance_init, NULL };
		GType vala_character_literal_type_id;
		vala_character_literal_type_id = g_type_register_static (VALA_TYPE_LITERAL, "ValaCharacterLiteral", &g_define_type_info, 0);
		g_once_init_leave (&vala_character_literal_type_id__volatile, vala_character_literal_type_id);
	}
	return vala_character_literal_type_id__volatile;
}



