/* valavapigen.c generated by valac, the Vala compiler
 * generated from valavapigen.vala, do not modify */

/* valavapigen.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <glib/gstdio.h>
#include <valagee.h>
#include <locale.h>
#include <version.h>
#include <gobject/gvaluecollector.h>


#define VALA_TYPE_VAPI_GEN (vala_vapi_gen_get_type ())
#define VALA_VAPI_GEN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_VAPI_GEN, ValaVAPIGen))
#define VALA_VAPI_GEN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_VAPI_GEN, ValaVAPIGenClass))
#define VALA_IS_VAPI_GEN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_VAPI_GEN))
#define VALA_IS_VAPI_GEN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_VAPI_GEN))
#define VALA_VAPI_GEN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_VAPI_GEN, ValaVAPIGenClass))

typedef struct _ValaVAPIGen ValaVAPIGen;
typedef struct _ValaVAPIGenClass ValaVAPIGenClass;
typedef struct _ValaVAPIGenPrivate ValaVAPIGenPrivate;
enum  {
	VALA_VAPI_GEN_DUMMY_PROPERTY,
	VALA_VAPI_GEN_LAST_PROPERTY
};
static GParamSpec* vala_vapi_gen_properties[VALA_VAPI_GEN_LAST_PROPERTY];
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_code_visitor_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_visitor_unref (var), NULL)))

#define VALA_TYPE_GIDL_PARSER (vala_gidl_parser_get_type ())
#define VALA_GIDL_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GIDL_PARSER, ValaGIdlParser))
#define VALA_GIDL_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GIDL_PARSER, ValaGIdlParserClass))
#define VALA_IS_GIDL_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GIDL_PARSER))
#define VALA_IS_GIDL_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GIDL_PARSER))
#define VALA_GIDL_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GIDL_PARSER, ValaGIdlParserClass))

typedef struct _ValaGIdlParser ValaGIdlParser;
typedef struct _ValaGIdlParserClass ValaGIdlParserClass;
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_vapi_gen_unref0(var) ((var == NULL) ? NULL : (var = (vala_vapi_gen_unref (var), NULL)))
typedef struct _ValaParamSpecVAPIGen ValaParamSpecVAPIGen;

struct _ValaVAPIGen {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaVAPIGenPrivate * priv;
};

struct _ValaVAPIGenClass {
	GTypeClass parent_class;
	void (*finalize) (ValaVAPIGen *self);
};

struct _ValaVAPIGenPrivate {
	ValaCodeContext* context;
};

struct _ValaParamSpecVAPIGen {
	GParamSpec parent_instance;
};


static gpointer vala_vapi_gen_parent_class = NULL;
static gchar* vala_vapi_gen_directory;
static gchar* vala_vapi_gen_directory = NULL;
static gboolean vala_vapi_gen_version;
static gboolean vala_vapi_gen_version = FALSE;
static gboolean vala_vapi_gen_quiet_mode;
static gboolean vala_vapi_gen_quiet_mode = FALSE;
static gboolean vala_vapi_gen_disable_warnings;
static gboolean vala_vapi_gen_disable_warnings = FALSE;
static gchar** vala_vapi_gen_sources;
static gchar** vala_vapi_gen_sources = NULL;
static gchar** vala_vapi_gen_vapi_directories;
static gchar** vala_vapi_gen_vapi_directories = NULL;
static gchar** vala_vapi_gen_gir_directories;
static gchar** vala_vapi_gen_gir_directories = NULL;
static gchar** vala_vapi_gen_metadata_directories;
static gchar** vala_vapi_gen_metadata_directories = NULL;
static gchar* vala_vapi_gen_library;
static gchar* vala_vapi_gen_library = NULL;
static gchar** vala_vapi_gen_packages;
static gchar** vala_vapi_gen_packages = NULL;
static gboolean vala_vapi_gen_nostdpkg;
static gboolean vala_vapi_gen_nostdpkg = FALSE;

G_GNUC_INTERNAL gpointer vala_vapi_gen_ref (gpointer instance);
G_GNUC_INTERNAL void vala_vapi_gen_unref (gpointer instance);
G_GNUC_INTERNAL GParamSpec* vala_param_spec_vapi_gen (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
G_GNUC_INTERNAL void vala_value_set_vapi_gen (GValue* value, gpointer v_object) G_GNUC_UNUSED;
G_GNUC_INTERNAL void vala_value_take_vapi_gen (GValue* value, gpointer v_object);
G_GNUC_INTERNAL gpointer vala_value_get_vapi_gen (const GValue* value) G_GNUC_UNUSED;
G_GNUC_INTERNAL GType vala_vapi_gen_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define VALA_VAPI_GEN_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_VAPI_GEN, ValaVAPIGenPrivate))
static gint vala_vapi_gen_quit (ValaVAPIGen* self);
static gint vala_vapi_gen_run (ValaVAPIGen* self);
static gchar** _vala_array_dup1 (gchar** self, int length);
static gchar** _vala_array_dup2 (gchar** self, int length);
static gchar** _vala_array_dup3 (gchar** self, int length);
GType vala_gidl_parser_get_type (void) G_GNUC_CONST;
ValaGIdlParser* vala_gidl_parser_new (void);
ValaGIdlParser* vala_gidl_parser_construct (GType object_type);
void vala_gidl_parser_parse (ValaGIdlParser* self, ValaCodeContext* context);
static gboolean _vala_string_array_contains (gchar* * stack, int stack_length, gchar* needle);
static gint vala_vapi_gen_main (gchar** args, int args_length1);
G_GNUC_INTERNAL ValaVAPIGen* vala_vapi_gen_new (void);
G_GNUC_INTERNAL ValaVAPIGen* vala_vapi_gen_construct (GType object_type);
static void vala_vapi_gen_finalize (ValaVAPIGen * obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GOptionEntry VALA_VAPI_GEN_options[12] = {{"vapidir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_vapi_gen_vapi_directories, "Look for package bindings in DIRECTORY", "DIRECTORY..."}, {"girdir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_vapi_gen_gir_directories, "Look for GIR bindings in DIRECTORY", "DIRECTORY..."}, {"metadatadir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_vapi_gen_metadata_directories, "Look for GIR .metadata files in DIRECTORY", "DIRECTORY..."}, {"nostdpkg", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_vapi_gen_nostdpkg, "Do not include standard packages", NULL}, {"pkg", (gchar) 0, 0, G_OPTION_ARG_STRING_ARRAY, &vala_vapi_gen_packages, "Include binding for PACKAGE", "PACKAGE..."}, {"library", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_vapi_gen_library, "Library name", "NAME"}, {"directory", 'd', 0, G_OPTION_ARG_FILENAME, &vala_vapi_gen_directory, "Output directory", "DIRECTORY"}, {"disable-warnings", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_vapi_gen_disable_warnings, "Disable warnings", NULL}, {"version", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_vapi_gen_version, "Display version number", NULL}, {"quiet", 'q', 0, G_OPTION_ARG_NONE, &vala_vapi_gen_quiet_mode, "Do not print messages to the console", NULL}, {"", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_vapi_gen_sources, NULL, "FILE..."}, {NULL}};

static gint vala_vapi_gen_quit (ValaVAPIGen* self) {
	gint result = 0;
	ValaCodeContext* _tmp0_;
	ValaReport* _tmp1_;
	ValaReport* _tmp2_;
	gint _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->context;
	_tmp1_ = vala_code_context_get_report (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_report_get_errors (_tmp2_);
	if (_tmp3_ == 0) {
		gboolean _tmp4_;
		_tmp4_ = vala_vapi_gen_quiet_mode;
		if (!_tmp4_) {
			FILE* _tmp5_;
			ValaCodeContext* _tmp6_;
			ValaReport* _tmp7_;
			ValaReport* _tmp8_;
			gint _tmp9_;
			_tmp5_ = stdout;
			_tmp6_ = self->priv->context;
			_tmp7_ = vala_code_context_get_report (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = vala_report_get_warnings (_tmp8_);
			fprintf (_tmp5_, "Generation succeeded - %d warning(s)\n", _tmp9_);
		}
		result = 0;
		return result;
	} else {
		gboolean _tmp10_;
		_tmp10_ = vala_vapi_gen_quiet_mode;
		if (!_tmp10_) {
			FILE* _tmp11_;
			ValaCodeContext* _tmp12_;
			ValaReport* _tmp13_;
			ValaReport* _tmp14_;
			gint _tmp15_;
			ValaCodeContext* _tmp16_;
			ValaReport* _tmp17_;
			ValaReport* _tmp18_;
			gint _tmp19_;
			_tmp11_ = stdout;
			_tmp12_ = self->priv->context;
			_tmp13_ = vala_code_context_get_report (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = vala_report_get_errors (_tmp14_);
			_tmp16_ = self->priv->context;
			_tmp17_ = vala_code_context_get_report (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = vala_report_get_warnings (_tmp18_);
			fprintf (_tmp11_, "Generation failed: %d error(s), %d warning(s)\n", _tmp15_, _tmp19_);
		}
		result = 1;
		return result;
	}
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup2 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup3 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	glong _tmp8_;
	glong _tmp14_;
	glong _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	gchar* _tmp22_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_;
		glong _tmp4_;
		glong _tmp5_;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_;
		gint _tmp7_;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_;
		glong _tmp10_;
		glong _tmp11_;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_;
		glong _tmp13_;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_;
		glong _tmp16_;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


static gboolean _vala_string_array_contains (gchar* * stack, int stack_length, gchar* needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}


static gint vala_vapi_gen_run (ValaVAPIGen* self) {
	gint result = 0;
	ValaCodeContext* _tmp0_;
	ValaCodeContext* _tmp1_;
	ValaCodeContext* _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar** _tmp4_;
	gint _tmp4__length1;
	ValaCodeContext* _tmp5_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gchar** _tmp7_;
	gint _tmp7__length1;
	ValaCodeContext* _tmp8_;
	gchar** _tmp9_;
	gint _tmp9__length1;
	gchar** _tmp10_;
	gint _tmp10__length1;
	ValaCodeContext* _tmp11_;
	ValaReport* _tmp12_;
	ValaReport* _tmp13_;
	gboolean _tmp14_;
	ValaCodeContext* _tmp15_;
	ValaReport* _tmp16_;
	ValaReport* _tmp17_;
	gboolean _tmp18_;
	ValaCodeContext* _tmp19_;
	ValaCodeContext* _tmp20_;
	gboolean _tmp21_;
	gboolean _tmp22_;
	ValaCodeContext* _tmp25_;
	ValaReport* _tmp26_;
	ValaReport* _tmp27_;
	gint _tmp28_;
	gchar** _tmp30_;
	gint _tmp30__length1;
	ValaCodeContext* _tmp46_;
	ValaReport* _tmp47_;
	ValaReport* _tmp48_;
	gint _tmp49_;
	const gchar* _tmp51_;
	ValaCodeContext* _tmp56_;
	ValaReport* _tmp57_;
	ValaReport* _tmp58_;
	gint _tmp59_;
	gchar** _tmp61_;
	gint _tmp61__length1;
	ValaCodeContext* _tmp66_;
	ValaReport* _tmp67_;
	ValaReport* _tmp68_;
	gint _tmp69_;
	gchar** _tmp71_;
	gint _tmp71__length1;
	ValaCodeContext* _tmp84_;
	ValaReport* _tmp85_;
	ValaReport* _tmp86_;
	gint _tmp87_;
	ValaParser* parser = NULL;
	ValaParser* _tmp89_;
	ValaParser* _tmp90_;
	ValaCodeContext* _tmp91_;
	ValaCodeContext* _tmp92_;
	ValaReport* _tmp93_;
	ValaReport* _tmp94_;
	gint _tmp95_;
	ValaGirParser* girparser = NULL;
	ValaGirParser* _tmp97_;
	ValaGirParser* _tmp98_;
	ValaCodeContext* _tmp99_;
	ValaCodeContext* _tmp100_;
	ValaReport* _tmp101_;
	ValaReport* _tmp102_;
	gint _tmp103_;
	ValaGIdlParser* gidlparser = NULL;
	ValaGIdlParser* _tmp105_;
	ValaGIdlParser* _tmp106_;
	ValaCodeContext* _tmp107_;
	ValaCodeContext* _tmp108_;
	ValaReport* _tmp109_;
	ValaReport* _tmp110_;
	gint _tmp111_;
	ValaCodeContext* _tmp113_;
	ValaCodeContext* _tmp114_;
	ValaReport* _tmp115_;
	ValaReport* _tmp116_;
	gint _tmp117_;
	ValaCodeWriter* interface_writer = NULL;
	ValaCodeWriter* _tmp165_;
	gchar* vapi_filename = NULL;
	const gchar* _tmp166_;
	gchar* _tmp167_;
	const gchar* _tmp168_;
	ValaCodeWriter* _tmp172_;
	ValaCodeContext* _tmp173_;
	const gchar* _tmp174_;
	gint _tmp175_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = vala_code_context_new ();
	_vala_code_context_unref0 (self->priv->context);
	self->priv->context = _tmp0_;
	_tmp1_ = self->priv->context;
	vala_code_context_set_profile (_tmp1_, VALA_PROFILE_GOBJECT);
	_tmp2_ = self->priv->context;
	_tmp3_ = vala_vapi_gen_vapi_directories;
	_tmp3__length1 = _vala_array_length (vala_vapi_gen_vapi_directories);
	_tmp4_ = (_tmp3_ != NULL) ? _vala_array_dup1 (_tmp3_, _tmp3__length1) : ((gpointer) _tmp3_);
	_tmp4__length1 = _tmp3__length1;
	_tmp2_->vapi_directories = (_vala_array_free (_tmp2_->vapi_directories, _tmp2_->vapi_directories_length1, (GDestroyNotify) g_free), NULL);
	_tmp2_->vapi_directories = _tmp4_;
	_tmp2_->vapi_directories_length1 = _tmp4__length1;
	_tmp5_ = self->priv->context;
	_tmp6_ = vala_vapi_gen_gir_directories;
	_tmp6__length1 = _vala_array_length (vala_vapi_gen_gir_directories);
	_tmp7_ = (_tmp6_ != NULL) ? _vala_array_dup2 (_tmp6_, _tmp6__length1) : ((gpointer) _tmp6_);
	_tmp7__length1 = _tmp6__length1;
	_tmp5_->gir_directories = (_vala_array_free (_tmp5_->gir_directories, _tmp5_->gir_directories_length1, (GDestroyNotify) g_free), NULL);
	_tmp5_->gir_directories = _tmp7_;
	_tmp5_->gir_directories_length1 = _tmp7__length1;
	_tmp8_ = self->priv->context;
	_tmp9_ = vala_vapi_gen_metadata_directories;
	_tmp9__length1 = _vala_array_length (vala_vapi_gen_metadata_directories);
	_tmp10_ = (_tmp9_ != NULL) ? _vala_array_dup3 (_tmp9_, _tmp9__length1) : ((gpointer) _tmp9_);
	_tmp10__length1 = _tmp9__length1;
	_tmp8_->metadata_directories = (_vala_array_free (_tmp8_->metadata_directories, _tmp8_->metadata_directories_length1, (GDestroyNotify) g_free), NULL);
	_tmp8_->metadata_directories = _tmp10_;
	_tmp8_->metadata_directories_length1 = _tmp10__length1;
	_tmp11_ = self->priv->context;
	_tmp12_ = vala_code_context_get_report (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = vala_vapi_gen_disable_warnings;
	vala_report_set_enable_warnings (_tmp13_, !_tmp14_);
	_tmp15_ = self->priv->context;
	_tmp16_ = vala_code_context_get_report (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = vala_vapi_gen_quiet_mode;
	vala_report_set_verbose_errors (_tmp17_, !_tmp18_);
	_tmp19_ = self->priv->context;
	vala_code_context_push (_tmp19_);
	_tmp20_ = self->priv->context;
	_tmp21_ = vala_vapi_gen_nostdpkg;
	vala_code_context_set_nostdpkg (_tmp20_, _tmp21_);
	_tmp22_ = vala_vapi_gen_nostdpkg;
	if (!_tmp22_) {
		ValaCodeContext* _tmp23_;
		ValaCodeContext* _tmp24_;
		_tmp23_ = self->priv->context;
		vala_code_context_add_external_package (_tmp23_, "glib-2.0");
		_tmp24_ = self->priv->context;
		vala_code_context_add_external_package (_tmp24_, "gobject-2.0");
	}
	_tmp25_ = self->priv->context;
	_tmp26_ = vala_code_context_get_report (_tmp25_);
	_tmp27_ = _tmp26_;
	_tmp28_ = vala_report_get_errors (_tmp27_);
	if (_tmp28_ > 0) {
		gint _tmp29_;
		_tmp29_ = vala_vapi_gen_quit (self);
		result = _tmp29_;
		return result;
	}
	_tmp30_ = vala_vapi_gen_sources;
	_tmp30__length1 = _vala_array_length (vala_vapi_gen_sources);
	{
		gchar** source_collection = NULL;
		gint source_collection_length1 = 0;
		gint _source_collection_size_ = 0;
		gint source_it = 0;
		source_collection = _tmp30_;
		source_collection_length1 = _tmp30__length1;
		for (source_it = 0; source_it < _tmp30__length1; source_it = source_it + 1) {
			gchar* _tmp31_;
			gchar* source = NULL;
			_tmp31_ = g_strdup (source_collection[source_it]);
			source = _tmp31_;
			{
				const gchar* _tmp32_;
				gboolean _tmp33_;
				gchar* depsfile = NULL;
				const gchar* _tmp34_;
				const gchar* _tmp35_;
				gint _tmp36_;
				gint _tmp37_;
				gint _tmp38_;
				gint _tmp39_;
				gchar* _tmp40_;
				gchar* _tmp41_;
				gchar* _tmp42_;
				gchar* _tmp43_;
				ValaCodeContext* _tmp44_;
				const gchar* _tmp45_;
				_tmp32_ = source;
				_tmp33_ = g_str_has_suffix (_tmp32_, ".gi");
				if (!_tmp33_) {
					_g_free0 (source);
					continue;
				}
				_tmp34_ = source;
				_tmp35_ = source;
				_tmp36_ = strlen (_tmp35_);
				_tmp37_ = _tmp36_;
				_tmp38_ = strlen ("gi");
				_tmp39_ = _tmp38_;
				_tmp40_ = string_substring (_tmp34_, (glong) 0, (glong) (_tmp37_ - _tmp39_));
				_tmp41_ = _tmp40_;
				_tmp42_ = g_strconcat (_tmp41_, "deps", NULL);
				_tmp43_ = _tmp42_;
				_g_free0 (_tmp41_);
				depsfile = _tmp43_;
				_tmp44_ = self->priv->context;
				_tmp45_ = depsfile;
				vala_code_context_add_packages_from_file (_tmp44_, _tmp45_);
				_g_free0 (depsfile);
				_g_free0 (source);
			}
		}
	}
	_tmp46_ = self->priv->context;
	_tmp47_ = vala_code_context_get_report (_tmp46_);
	_tmp48_ = _tmp47_;
	_tmp49_ = vala_report_get_errors (_tmp48_);
	if (_tmp49_ > 0) {
		gint _tmp50_;
		_tmp50_ = vala_vapi_gen_quit (self);
		result = _tmp50_;
		return result;
	}
	_tmp51_ = vala_vapi_gen_library;
	if (_tmp51_ != NULL) {
		gchar* depsfile = NULL;
		const gchar* _tmp52_;
		gchar* _tmp53_;
		ValaCodeContext* _tmp54_;
		const gchar* _tmp55_;
		_tmp52_ = vala_vapi_gen_library;
		_tmp53_ = g_strconcat (_tmp52_, ".deps", NULL);
		depsfile = _tmp53_;
		_tmp54_ = self->priv->context;
		_tmp55_ = depsfile;
		vala_code_context_add_packages_from_file (_tmp54_, _tmp55_);
		_g_free0 (depsfile);
	} else {
		vala_report_error (NULL, "--library option must be specified");
	}
	_tmp56_ = self->priv->context;
	_tmp57_ = vala_code_context_get_report (_tmp56_);
	_tmp58_ = _tmp57_;
	_tmp59_ = vala_report_get_errors (_tmp58_);
	if (_tmp59_ > 0) {
		gint _tmp60_;
		_tmp60_ = vala_vapi_gen_quit (self);
		result = _tmp60_;
		return result;
	}
	_tmp61_ = vala_vapi_gen_packages;
	_tmp61__length1 = _vala_array_length (vala_vapi_gen_packages);
	if (_tmp61_ != NULL) {
		gchar** _tmp62_;
		gint _tmp62__length1;
		_tmp62_ = vala_vapi_gen_packages;
		_tmp62__length1 = _vala_array_length (vala_vapi_gen_packages);
		{
			gchar** package_collection = NULL;
			gint package_collection_length1 = 0;
			gint _package_collection_size_ = 0;
			gint package_it = 0;
			package_collection = _tmp62_;
			package_collection_length1 = _tmp62__length1;
			for (package_it = 0; package_it < _tmp62__length1; package_it = package_it + 1) {
				gchar* _tmp63_;
				gchar* package = NULL;
				_tmp63_ = g_strdup (package_collection[package_it]);
				package = _tmp63_;
				{
					ValaCodeContext* _tmp64_;
					const gchar* _tmp65_;
					_tmp64_ = self->priv->context;
					_tmp65_ = package;
					vala_code_context_add_external_package (_tmp64_, _tmp65_);
					_g_free0 (package);
				}
			}
		}
		vala_vapi_gen_packages = (_vala_array_free (vala_vapi_gen_packages, _vala_array_length (vala_vapi_gen_packages), (GDestroyNotify) g_free), NULL);
		vala_vapi_gen_packages = NULL;
	}
	_tmp66_ = self->priv->context;
	_tmp67_ = vala_code_context_get_report (_tmp66_);
	_tmp68_ = _tmp67_;
	_tmp69_ = vala_report_get_errors (_tmp68_);
	if (_tmp69_ > 0) {
		gint _tmp70_;
		_tmp70_ = vala_vapi_gen_quit (self);
		result = _tmp70_;
		return result;
	}
	_tmp71_ = vala_vapi_gen_sources;
	_tmp71__length1 = _vala_array_length (vala_vapi_gen_sources);
	{
		gchar** source_collection = NULL;
		gint source_collection_length1 = 0;
		gint _source_collection_size_ = 0;
		gint source_it = 0;
		source_collection = _tmp71_;
		source_collection_length1 = _tmp71__length1;
		for (source_it = 0; source_it < _tmp71__length1; source_it = source_it + 1) {
			gchar* _tmp72_;
			gchar* source = NULL;
			_tmp72_ = g_strdup (source_collection[source_it]);
			source = _tmp72_;
			{
				const gchar* _tmp73_;
				gboolean _tmp74_;
				_tmp73_ = source;
				_tmp74_ = g_file_test (_tmp73_, G_FILE_TEST_EXISTS);
				if (_tmp74_) {
					ValaSourceFile* source_file = NULL;
					ValaCodeContext* _tmp75_;
					const gchar* _tmp76_;
					ValaSourceFile* _tmp77_;
					ValaSourceFile* _tmp78_;
					ValaCodeContext* _tmp79_;
					ValaSourceFile* _tmp80_;
					_tmp75_ = self->priv->context;
					_tmp76_ = source;
					_tmp77_ = vala_source_file_new (_tmp75_, VALA_SOURCE_FILE_TYPE_PACKAGE, _tmp76_, NULL, FALSE);
					source_file = _tmp77_;
					_tmp78_ = source_file;
					vala_source_file_set_explicit (_tmp78_, TRUE);
					_tmp79_ = self->priv->context;
					_tmp80_ = source_file;
					vala_code_context_add_source_file (_tmp79_, _tmp80_);
					_vala_source_file_unref0 (source_file);
				} else {
					const gchar* _tmp81_;
					gchar* _tmp82_;
					gchar* _tmp83_;
					_tmp81_ = source;
					_tmp82_ = g_strdup_printf ("%s not found", _tmp81_);
					_tmp83_ = _tmp82_;
					vala_report_error (NULL, _tmp83_);
					_g_free0 (_tmp83_);
				}
				_g_free0 (source);
			}
		}
	}
	_tmp84_ = self->priv->context;
	_tmp85_ = vala_code_context_get_report (_tmp84_);
	_tmp86_ = _tmp85_;
	_tmp87_ = vala_report_get_errors (_tmp86_);
	if (_tmp87_ > 0) {
		gint _tmp88_;
		_tmp88_ = vala_vapi_gen_quit (self);
		result = _tmp88_;
		return result;
	}
	_tmp89_ = vala_parser_new ();
	parser = _tmp89_;
	_tmp90_ = parser;
	_tmp91_ = self->priv->context;
	vala_parser_parse (_tmp90_, _tmp91_);
	_tmp92_ = self->priv->context;
	_tmp93_ = vala_code_context_get_report (_tmp92_);
	_tmp94_ = _tmp93_;
	_tmp95_ = vala_report_get_errors (_tmp94_);
	if (_tmp95_ > 0) {
		gint _tmp96_;
		_tmp96_ = vala_vapi_gen_quit (self);
		result = _tmp96_;
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp97_ = vala_gir_parser_new ();
	girparser = _tmp97_;
	_tmp98_ = girparser;
	_tmp99_ = self->priv->context;
	vala_gir_parser_parse (_tmp98_, _tmp99_);
	_tmp100_ = self->priv->context;
	_tmp101_ = vala_code_context_get_report (_tmp100_);
	_tmp102_ = _tmp101_;
	_tmp103_ = vala_report_get_errors (_tmp102_);
	if (_tmp103_ > 0) {
		gint _tmp104_;
		_tmp104_ = vala_vapi_gen_quit (self);
		result = _tmp104_;
		_vala_code_visitor_unref0 (girparser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp105_ = vala_gidl_parser_new ();
	gidlparser = _tmp105_;
	_tmp106_ = gidlparser;
	_tmp107_ = self->priv->context;
	vala_gidl_parser_parse (_tmp106_, _tmp107_);
	_tmp108_ = self->priv->context;
	_tmp109_ = vala_code_context_get_report (_tmp108_);
	_tmp110_ = _tmp109_;
	_tmp111_ = vala_report_get_errors (_tmp110_);
	if (_tmp111_ > 0) {
		gint _tmp112_;
		_tmp112_ = vala_vapi_gen_quit (self);
		result = _tmp112_;
		_vala_code_visitor_unref0 (gidlparser);
		_vala_code_visitor_unref0 (girparser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp113_ = self->priv->context;
	vala_code_context_check (_tmp113_);
	_tmp114_ = self->priv->context;
	_tmp115_ = vala_code_context_get_report (_tmp114_);
	_tmp116_ = _tmp115_;
	_tmp117_ = vala_report_get_errors (_tmp116_);
	if (_tmp117_ > 0) {
		gint _tmp118_;
		_tmp118_ = vala_vapi_gen_quit (self);
		result = _tmp118_;
		_vala_code_visitor_unref0 (gidlparser);
		_vala_code_visitor_unref0 (girparser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	{
		ValaList* _file_list = NULL;
		ValaCodeContext* _tmp119_;
		ValaList* _tmp120_;
		gint _file_size = 0;
		ValaList* _tmp121_;
		gint _tmp122_;
		gint _tmp123_;
		gint _file_index = 0;
		_tmp119_ = self->priv->context;
		_tmp120_ = vala_code_context_get_source_files (_tmp119_);
		_file_list = _tmp120_;
		_tmp121_ = _file_list;
		_tmp122_ = vala_collection_get_size ((ValaCollection*) _tmp121_);
		_tmp123_ = _tmp122_;
		_file_size = _tmp123_;
		_file_index = -1;
		while (TRUE) {
			gint _tmp124_;
			gint _tmp125_;
			gint _tmp126_;
			ValaSourceFile* file = NULL;
			ValaList* _tmp127_;
			gint _tmp128_;
			gpointer _tmp129_;
			ValaSourceFile* _tmp130_;
			const gchar* _tmp131_;
			const gchar* _tmp132_;
			gboolean _tmp133_;
			ValaSourceFile* _tmp134_;
			const gchar* _tmp135_;
			const gchar* _tmp136_;
			gchar** _tmp137_;
			gint _tmp137__length1;
			_tmp124_ = _file_index;
			_file_index = _tmp124_ + 1;
			_tmp125_ = _file_index;
			_tmp126_ = _file_size;
			if (!(_tmp125_ < _tmp126_)) {
				break;
			}
			_tmp127_ = _file_list;
			_tmp128_ = _file_index;
			_tmp129_ = vala_list_get (_tmp127_, _tmp128_);
			file = (ValaSourceFile*) _tmp129_;
			_tmp130_ = file;
			_tmp131_ = vala_source_file_get_filename (_tmp130_);
			_tmp132_ = _tmp131_;
			_tmp133_ = g_str_has_suffix (_tmp132_, ".vapi");
			if (_tmp133_) {
				_vala_source_file_unref0 (file);
				continue;
			}
			_tmp134_ = file;
			_tmp135_ = vala_source_file_get_filename (_tmp134_);
			_tmp136_ = _tmp135_;
			_tmp137_ = vala_vapi_gen_sources;
			_tmp137__length1 = _vala_array_length (vala_vapi_gen_sources);
			if (_vala_string_array_contains (_tmp137_, _tmp137__length1, _tmp136_)) {
				ValaSourceFile* _tmp138_;
				ValaSourceFile* _tmp139_;
				const gchar* _tmp140_;
				const gchar* _tmp141_;
				gboolean _tmp142_;
				_tmp138_ = file;
				vala_source_file_set_file_type (_tmp138_, VALA_SOURCE_FILE_TYPE_SOURCE);
				_tmp139_ = file;
				_tmp140_ = vala_source_file_get_filename (_tmp139_);
				_tmp141_ = _tmp140_;
				_tmp142_ = g_str_has_suffix (_tmp141_, ".gir");
				if (_tmp142_) {
					gchar* metadata_filename = NULL;
					ValaCodeContext* _tmp143_;
					ValaSourceFile* _tmp144_;
					const gchar* _tmp145_;
					const gchar* _tmp146_;
					gchar* _tmp147_;
					const gchar* _tmp148_;
					_tmp143_ = self->priv->context;
					_tmp144_ = file;
					_tmp145_ = vala_source_file_get_filename (_tmp144_);
					_tmp146_ = _tmp145_;
					_tmp147_ = vala_code_context_get_metadata_path (_tmp143_, _tmp146_);
					metadata_filename = _tmp147_;
					_tmp148_ = metadata_filename;
					if (_tmp148_ != NULL) {
						{
							ValaList* _metadata_file_list = NULL;
							ValaCodeContext* _tmp149_;
							ValaList* _tmp150_;
							gint _metadata_file_size = 0;
							ValaList* _tmp151_;
							gint _tmp152_;
							gint _tmp153_;
							gint _metadata_file_index = 0;
							_tmp149_ = self->priv->context;
							_tmp150_ = vala_code_context_get_source_files (_tmp149_);
							_metadata_file_list = _tmp150_;
							_tmp151_ = _metadata_file_list;
							_tmp152_ = vala_collection_get_size ((ValaCollection*) _tmp151_);
							_tmp153_ = _tmp152_;
							_metadata_file_size = _tmp153_;
							_metadata_file_index = -1;
							while (TRUE) {
								gint _tmp154_;
								gint _tmp155_;
								gint _tmp156_;
								ValaSourceFile* metadata_file = NULL;
								ValaList* _tmp157_;
								gint _tmp158_;
								gpointer _tmp159_;
								ValaSourceFile* _tmp160_;
								const gchar* _tmp161_;
								const gchar* _tmp162_;
								const gchar* _tmp163_;
								_tmp154_ = _metadata_file_index;
								_metadata_file_index = _tmp154_ + 1;
								_tmp155_ = _metadata_file_index;
								_tmp156_ = _metadata_file_size;
								if (!(_tmp155_ < _tmp156_)) {
									break;
								}
								_tmp157_ = _metadata_file_list;
								_tmp158_ = _metadata_file_index;
								_tmp159_ = vala_list_get (_tmp157_, _tmp158_);
								metadata_file = (ValaSourceFile*) _tmp159_;
								_tmp160_ = metadata_file;
								_tmp161_ = vala_source_file_get_filename (_tmp160_);
								_tmp162_ = _tmp161_;
								_tmp163_ = metadata_filename;
								if (g_strcmp0 (_tmp162_, _tmp163_) == 0) {
									ValaSourceFile* _tmp164_;
									_tmp164_ = metadata_file;
									vala_source_file_set_file_type (_tmp164_, VALA_SOURCE_FILE_TYPE_SOURCE);
								}
								_vala_source_file_unref0 (metadata_file);
							}
							_vala_iterable_unref0 (_metadata_file_list);
						}
					}
					_g_free0 (metadata_filename);
				}
			}
			_vala_source_file_unref0 (file);
		}
		_vala_iterable_unref0 (_file_list);
	}
	_tmp165_ = vala_code_writer_new (VALA_CODE_WRITER_TYPE_EXTERNAL);
	interface_writer = _tmp165_;
	_tmp166_ = vala_vapi_gen_library;
	_tmp167_ = g_strdup_printf ("%s.vapi", _tmp166_);
	vapi_filename = _tmp167_;
	_tmp168_ = vala_vapi_gen_directory;
	if (_tmp168_ != NULL) {
		const gchar* _tmp169_;
		const gchar* _tmp170_;
		gchar* _tmp171_;
		_tmp169_ = vala_vapi_gen_directory;
		_tmp170_ = vapi_filename;
		_tmp171_ = g_build_path ("/", _tmp169_, _tmp170_, NULL);
		_g_free0 (vapi_filename);
		vapi_filename = _tmp171_;
	}
	_tmp172_ = interface_writer;
	_tmp173_ = self->priv->context;
	_tmp174_ = vapi_filename;
	vala_code_writer_write_file (_tmp172_, _tmp173_, _tmp174_);
	_g_free0 (vala_vapi_gen_library);
	vala_vapi_gen_library = NULL;
	_tmp175_ = vala_vapi_gen_quit (self);
	result = _tmp175_;
	_g_free0 (vapi_filename);
	_vala_code_visitor_unref0 (interface_writer);
	_vala_code_visitor_unref0 (gidlparser);
	_vala_code_visitor_unref0 (girparser);
	_vala_code_visitor_unref0 (parser);
	return result;
}


static gint vala_vapi_gen_main (gchar** args, int args_length1) {
	gint result = 0;
	gboolean _tmp12_;
	gchar** _tmp14_;
	gint _tmp14__length1;
	ValaVAPIGen* vapigen = NULL;
	ValaVAPIGen* _tmp16_;
	ValaVAPIGen* _tmp17_;
	gint _tmp18_;
	GError * _inner_error_ = NULL;
	setlocale (LC_ALL, "");
	{
		GOptionContext* opt_context = NULL;
		GOptionContext* _tmp0_;
		GOptionContext* _tmp1_;
		GOptionContext* _tmp2_;
		GOptionContext* _tmp3_;
		_tmp0_ = g_option_context_new ("- Vala API Generator");
		opt_context = _tmp0_;
		_tmp1_ = opt_context;
		g_option_context_set_help_enabled (_tmp1_, TRUE);
		_tmp2_ = opt_context;
		g_option_context_add_main_entries (_tmp2_, VALA_VAPI_GEN_options, NULL);
		_tmp3_ = opt_context;
		g_option_context_parse (_tmp3_, &args_length1, &args, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gint _tmp4_ = 0;
			_g_option_context_free0 (opt_context);
			if (_inner_error_->domain == G_OPTION_ERROR) {
				goto __catch3_g_option_error;
			}
			_g_option_context_free0 (opt_context);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp4_;
		}
		_g_option_context_free0 (opt_context);
	}
	goto __finally3;
	__catch3_g_option_error:
	{
		GError* e = NULL;
		FILE* _tmp5_;
		GError* _tmp6_;
		const gchar* _tmp7_;
		FILE* _tmp8_;
		gchar** _tmp9_;
		gint _tmp9__length1;
		const gchar* _tmp10_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = stdout;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		fprintf (_tmp5_, "%s\n", _tmp7_);
		_tmp8_ = stdout;
		_tmp9_ = args;
		_tmp9__length1 = args_length1;
		_tmp10_ = _tmp9_[0];
		fprintf (_tmp8_, "Run '%s --help' to see a full list of available command line options.\n", _tmp10_);
		result = 1;
		_g_error_free0 (e);
		return result;
	}
	__finally3:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gint _tmp11_ = 0;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp11_;
	}
	_tmp12_ = vala_vapi_gen_version;
	if (_tmp12_) {
		FILE* _tmp13_;
		_tmp13_ = stdout;
		fprintf (_tmp13_, "Vala API Generator %s\n", BUILD_VERSION);
		result = 0;
		return result;
	}
	_tmp14_ = vala_vapi_gen_sources;
	_tmp14__length1 = _vala_array_length (vala_vapi_gen_sources);
	if (_tmp14_ == NULL) {
		FILE* _tmp15_;
		_tmp15_ = stderr;
		fprintf (_tmp15_, "No source file specified.\n");
		result = 1;
		return result;
	}
	_tmp16_ = vala_vapi_gen_new ();
	vapigen = _tmp16_;
	_tmp17_ = vapigen;
	_tmp18_ = vala_vapi_gen_run (_tmp17_);
	result = _tmp18_;
	_vala_vapi_gen_unref0 (vapigen);
	return result;
}


int main (int argc, char ** argv) {
	return vala_vapi_gen_main (argv, argc);
}


G_GNUC_INTERNAL ValaVAPIGen* vala_vapi_gen_construct (GType object_type) {
	ValaVAPIGen* self = NULL;
	self = (ValaVAPIGen*) g_type_create_instance (object_type);
	return self;
}


G_GNUC_INTERNAL ValaVAPIGen* vala_vapi_gen_new (void) {
	return vala_vapi_gen_construct (VALA_TYPE_VAPI_GEN);
}


static void vala_value_vapi_gen_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void vala_value_vapi_gen_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		vala_vapi_gen_unref (value->data[0].v_pointer);
	}
}


static void vala_value_vapi_gen_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_vapi_gen_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer vala_value_vapi_gen_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* vala_value_vapi_gen_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ValaVAPIGen * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_vapi_gen_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* vala_value_vapi_gen_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ValaVAPIGen ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_vapi_gen_ref (value->data[0].v_pointer);
	}
	return NULL;
}


G_GNUC_INTERNAL GParamSpec* vala_param_spec_vapi_gen (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ValaParamSpecVAPIGen* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_TYPE_VAPI_GEN), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


G_GNUC_INTERNAL gpointer vala_value_get_vapi_gen (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_VAPI_GEN), NULL);
	return value->data[0].v_pointer;
}


G_GNUC_INTERNAL void vala_value_set_vapi_gen (GValue* value, gpointer v_object) {
	ValaVAPIGen * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_VAPI_GEN));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_VAPI_GEN));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_vapi_gen_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_vapi_gen_unref (old);
	}
}


G_GNUC_INTERNAL void vala_value_take_vapi_gen (GValue* value, gpointer v_object) {
	ValaVAPIGen * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_VAPI_GEN));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_VAPI_GEN));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_vapi_gen_unref (old);
	}
}


static void vala_vapi_gen_class_init (ValaVAPIGenClass * klass) {
	vala_vapi_gen_parent_class = g_type_class_peek_parent (klass);
	((ValaVAPIGenClass *) klass)->finalize = vala_vapi_gen_finalize;
	g_type_class_add_private (klass, sizeof (ValaVAPIGenPrivate));
}


static void vala_vapi_gen_instance_init (ValaVAPIGen * self) {
	self->priv = VALA_VAPI_GEN_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void vala_vapi_gen_finalize (ValaVAPIGen * obj) {
	ValaVAPIGen * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_VAPI_GEN, ValaVAPIGen);
	g_signal_handlers_destroy (self);
	_vala_code_context_unref0 (self->priv->context);
}


G_GNUC_INTERNAL GType vala_vapi_gen_get_type (void) {
	static volatile gsize vala_vapi_gen_type_id__volatile = 0;
	if (g_once_init_enter (&vala_vapi_gen_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { vala_value_vapi_gen_init, vala_value_vapi_gen_free_value, vala_value_vapi_gen_copy_value, vala_value_vapi_gen_peek_pointer, "p", vala_value_vapi_gen_collect_value, "p", vala_value_vapi_gen_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValaVAPIGenClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_vapi_gen_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaVAPIGen), 0, (GInstanceInitFunc) vala_vapi_gen_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType vala_vapi_gen_type_id;
		vala_vapi_gen_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaVAPIGen", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&vala_vapi_gen_type_id__volatile, vala_vapi_gen_type_id);
	}
	return vala_vapi_gen_type_id__volatile;
}


G_GNUC_INTERNAL gpointer vala_vapi_gen_ref (gpointer instance) {
	ValaVAPIGen * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


G_GNUC_INTERNAL void vala_vapi_gen_unref (gpointer instance) {
	ValaVAPIGen * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_VAPI_GEN_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



