/* valabaseaccess.c generated by valac, the Vala compiler
 * generated from valabaseaccess.vala, do not modify */

/* valabaseaccess.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <valagee.h>

enum  {
	VALA_BASE_ACCESS_DUMMY_PROPERTY,
	VALA_BASE_ACCESS_LAST_PROPERTY
};
static GParamSpec* vala_base_access_properties[VALA_BASE_ACCESS_LAST_PROPERTY];
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))


static gpointer vala_base_access_parent_class = NULL;

static void vala_base_access_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static gchar* vala_base_access_real_to_string (ValaCodeNode* base);
static gboolean vala_base_access_real_is_pure (ValaExpression* base);
static gboolean vala_base_access_real_check (ValaCodeNode* base, ValaCodeContext* context);
static void vala_base_access_real_emit (ValaCodeNode* base, ValaCodeGenerator* codegen);


/**
 * Creates a new base access expression.
 *
 * @param source reference to source code
 * @return       newly created base access expression
 */
ValaBaseAccess* vala_base_access_construct (GType object_type, ValaSourceReference* source) {
	ValaBaseAccess* self = NULL;
	ValaSourceReference* _tmp0_;
	self = (ValaBaseAccess*) vala_expression_construct (object_type);
	_tmp0_ = source;
	vala_code_node_set_source_reference ((ValaCodeNode*) self, _tmp0_);
	return self;
}


ValaBaseAccess* vala_base_access_new (ValaSourceReference* source) {
	return vala_base_access_construct (VALA_TYPE_BASE_ACCESS, source);
}


static void vala_base_access_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaBaseAccess * self;
	ValaCodeVisitor* _tmp0_;
	ValaCodeVisitor* _tmp1_;
	self = (ValaBaseAccess*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = visitor;
	vala_code_visitor_visit_base_access (_tmp0_, self);
	_tmp1_ = visitor;
	vala_code_visitor_visit_expression (_tmp1_, (ValaExpression*) self);
}


static gchar* vala_base_access_real_to_string (ValaCodeNode* base) {
	ValaBaseAccess * self;
	gchar* result = NULL;
	gchar* _tmp0_;
	self = (ValaBaseAccess*) base;
	_tmp0_ = g_strdup ("base");
	result = _tmp0_;
	return result;
}


static gboolean vala_base_access_real_is_pure (ValaExpression* base) {
	ValaBaseAccess * self;
	gboolean result = FALSE;
	self = (ValaBaseAccess*) base;
	result = TRUE;
	return result;
}


static gboolean vala_base_access_real_check (ValaCodeNode* base, ValaCodeContext* context) {
	ValaBaseAccess * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaCodeContext* _tmp4_;
	ValaSemanticAnalyzer* _tmp5_;
	ValaSemanticAnalyzer* _tmp6_;
	gboolean _tmp7_;
	ValaCodeContext* _tmp10_;
	ValaSemanticAnalyzer* _tmp11_;
	ValaSemanticAnalyzer* _tmp12_;
	ValaClass* _tmp13_;
	ValaClass* _tmp14_;
	ValaDataType* _tmp70_;
	ValaDataType* _tmp71_;
	ValaTypeSymbol* _tmp72_;
	ValaTypeSymbol* _tmp73_;
	gboolean _tmp74_;
	gboolean _tmp75_;
	self = (ValaBaseAccess*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = context;
	_tmp5_ = vala_code_context_get_analyzer (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_semantic_analyzer_is_in_instance_method (_tmp6_);
	if (!_tmp7_) {
		ValaSourceReference* _tmp8_;
		ValaSourceReference* _tmp9_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp8_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp9_ = _tmp8_;
		vala_report_error (_tmp9_, "Base access invalid outside of instance methods");
		result = FALSE;
		return result;
	}
	_tmp10_ = context;
	_tmp11_ = vala_code_context_get_analyzer (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = vala_semantic_analyzer_get_current_class (_tmp12_);
	_tmp14_ = _tmp13_;
	if (_tmp14_ == NULL) {
		ValaCodeContext* _tmp15_;
		ValaSemanticAnalyzer* _tmp16_;
		ValaSemanticAnalyzer* _tmp17_;
		ValaStruct* _tmp18_;
		ValaStruct* _tmp19_;
		ValaCodeContext* _tmp31_;
		ValaSemanticAnalyzer* _tmp32_;
		ValaSemanticAnalyzer* _tmp33_;
		ValaStruct* _tmp34_;
		ValaStruct* _tmp35_;
		ValaDataType* _tmp36_;
		ValaDataType* _tmp37_;
		_tmp15_ = context;
		_tmp16_ = vala_code_context_get_analyzer (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_semantic_analyzer_get_current_struct (_tmp17_);
		_tmp19_ = _tmp18_;
		if (_tmp19_ == NULL) {
			ValaSourceReference* _tmp20_;
			ValaSourceReference* _tmp21_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp20_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp21_ = _tmp20_;
			vala_report_error (_tmp21_, "Base access invalid outside of class and struct");
			result = FALSE;
			return result;
		} else {
			ValaCodeContext* _tmp22_;
			ValaSemanticAnalyzer* _tmp23_;
			ValaSemanticAnalyzer* _tmp24_;
			ValaStruct* _tmp25_;
			ValaStruct* _tmp26_;
			ValaDataType* _tmp27_;
			ValaDataType* _tmp28_;
			_tmp22_ = context;
			_tmp23_ = vala_code_context_get_analyzer (_tmp22_);
			_tmp24_ = _tmp23_;
			_tmp25_ = vala_semantic_analyzer_get_current_struct (_tmp24_);
			_tmp26_ = _tmp25_;
			_tmp27_ = vala_struct_get_base_type (_tmp26_);
			_tmp28_ = _tmp27_;
			if (_tmp28_ == NULL) {
				ValaSourceReference* _tmp29_;
				ValaSourceReference* _tmp30_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp29_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp30_ = _tmp29_;
				vala_report_error (_tmp30_, "Base access invalid without base type");
				result = FALSE;
				return result;
			}
		}
		_tmp31_ = context;
		_tmp32_ = vala_code_context_get_analyzer (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp34_ = vala_semantic_analyzer_get_current_struct (_tmp33_);
		_tmp35_ = _tmp34_;
		_tmp36_ = vala_struct_get_base_type (_tmp35_);
		_tmp37_ = _tmp36_;
		vala_expression_set_value_type ((ValaExpression*) self, _tmp37_);
	} else {
		ValaCodeContext* _tmp38_;
		ValaSemanticAnalyzer* _tmp39_;
		ValaSemanticAnalyzer* _tmp40_;
		ValaClass* _tmp41_;
		ValaClass* _tmp42_;
		ValaClass* _tmp43_;
		ValaClass* _tmp44_;
		_tmp38_ = context;
		_tmp39_ = vala_code_context_get_analyzer (_tmp38_);
		_tmp40_ = _tmp39_;
		_tmp41_ = vala_semantic_analyzer_get_current_class (_tmp40_);
		_tmp42_ = _tmp41_;
		_tmp43_ = vala_class_get_base_class (_tmp42_);
		_tmp44_ = _tmp43_;
		if (_tmp44_ == NULL) {
			ValaSourceReference* _tmp45_;
			ValaSourceReference* _tmp46_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp45_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp46_ = _tmp45_;
			vala_report_error (_tmp46_, "Base access invalid without base class");
			result = FALSE;
			return result;
		} else {
			{
				ValaList* _base_type_list = NULL;
				ValaCodeContext* _tmp47_;
				ValaSemanticAnalyzer* _tmp48_;
				ValaSemanticAnalyzer* _tmp49_;
				ValaClass* _tmp50_;
				ValaClass* _tmp51_;
				ValaList* _tmp52_;
				gint _base_type_size = 0;
				ValaList* _tmp53_;
				gint _tmp54_;
				gint _tmp55_;
				gint _base_type_index = 0;
				_tmp47_ = context;
				_tmp48_ = vala_code_context_get_analyzer (_tmp47_);
				_tmp49_ = _tmp48_;
				_tmp50_ = vala_semantic_analyzer_get_current_class (_tmp49_);
				_tmp51_ = _tmp50_;
				_tmp52_ = vala_class_get_base_types (_tmp51_);
				_base_type_list = _tmp52_;
				_tmp53_ = _base_type_list;
				_tmp54_ = vala_collection_get_size ((ValaCollection*) _tmp53_);
				_tmp55_ = _tmp54_;
				_base_type_size = _tmp55_;
				_base_type_index = -1;
				while (TRUE) {
					gint _tmp56_;
					gint _tmp57_;
					gint _tmp58_;
					ValaDataType* base_type = NULL;
					ValaList* _tmp59_;
					gint _tmp60_;
					gpointer _tmp61_;
					ValaDataType* _tmp62_;
					ValaTypeSymbol* _tmp63_;
					ValaTypeSymbol* _tmp64_;
					_tmp56_ = _base_type_index;
					_base_type_index = _tmp56_ + 1;
					_tmp57_ = _base_type_index;
					_tmp58_ = _base_type_size;
					if (!(_tmp57_ < _tmp58_)) {
						break;
					}
					_tmp59_ = _base_type_list;
					_tmp60_ = _base_type_index;
					_tmp61_ = vala_list_get (_tmp59_, _tmp60_);
					base_type = (ValaDataType*) _tmp61_;
					_tmp62_ = base_type;
					_tmp63_ = vala_data_type_get_data_type (_tmp62_);
					_tmp64_ = _tmp63_;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp64_, VALA_TYPE_CLASS)) {
						ValaDataType* _tmp65_;
						ValaDataType* _tmp66_;
						ValaDataType* _tmp67_;
						ValaDataType* _tmp68_;
						ValaDataType* _tmp69_;
						_tmp65_ = base_type;
						_tmp66_ = vala_data_type_copy (_tmp65_);
						_tmp67_ = _tmp66_;
						vala_expression_set_value_type ((ValaExpression*) self, _tmp67_);
						_vala_code_node_unref0 (_tmp67_);
						_tmp68_ = vala_expression_get_value_type ((ValaExpression*) self);
						_tmp69_ = _tmp68_;
						vala_data_type_set_value_owned (_tmp69_, FALSE);
					}
					_vala_code_node_unref0 (base_type);
				}
				_vala_iterable_unref0 (_base_type_list);
			}
		}
	}
	_tmp70_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp71_ = _tmp70_;
	_tmp72_ = vala_data_type_get_data_type (_tmp71_);
	_tmp73_ = _tmp72_;
	vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp73_);
	_tmp74_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp75_ = _tmp74_;
	result = !_tmp75_;
	return result;
}


static void vala_base_access_real_emit (ValaCodeNode* base, ValaCodeGenerator* codegen) {
	ValaBaseAccess * self;
	ValaCodeGenerator* _tmp0_;
	ValaCodeGenerator* _tmp1_;
	self = (ValaBaseAccess*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = codegen;
	vala_code_visitor_visit_base_access ((ValaCodeVisitor*) _tmp0_, self);
	_tmp1_ = codegen;
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) _tmp1_, (ValaExpression*) self);
}


static void vala_base_access_class_init (ValaBaseAccessClass * klass) {
	vala_base_access_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_base_access_real_accept;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode *)) vala_base_access_real_to_string;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression *)) vala_base_access_real_is_pure;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode *, ValaCodeContext*)) vala_base_access_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode *, ValaCodeGenerator*)) vala_base_access_real_emit;
}


static void vala_base_access_instance_init (ValaBaseAccess * self) {
}


/**
 * Represents an access to base class members in the source code.
 */
GType vala_base_access_get_type (void) {
	static volatile gsize vala_base_access_type_id__volatile = 0;
	if (g_once_init_enter (&vala_base_access_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaBaseAccessClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_base_access_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaBaseAccess), 0, (GInstanceInitFunc) vala_base_access_instance_init, NULL };
		GType vala_base_access_type_id;
		vala_base_access_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaBaseAccess", &g_define_type_info, 0);
		g_once_init_leave (&vala_base_access_type_id__volatile, vala_base_access_type_id);
	}
	return vala_base_access_type_id__volatile;
}



