/* girmetadata.c generated by valac, the Vala compiler
 * generated from girmetadata.vala, do not modify */

/* girmetadata.vala
 *
 * Copyright (C) 2012-2014 Florian Brosch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Brosch Florian <flo.brosch@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>
#include "valadoc.h"
#include <stdlib.h>
#include <string.h>
#include <glib/gstdio.h>

enum  {
	VALADOC_GIR_META_DATA_DUMMY_PROPERTY,
	VALADOC_GIR_META_DATA_IS_DOCBOOK,
	VALADOC_GIR_META_DATA_INDEX_SGML,
	VALADOC_GIR_META_DATA_INDEX_SGML_ONLINE,
	VALADOC_GIR_META_DATA_LAST_PROPERTY
};
static GParamSpec* valadoc_gir_meta_data_properties[VALADOC_GIR_META_DATA_LAST_PROPERTY];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _ValadocGirMetaDataPrivate {
	gchar* metadata_path;
	gchar* resource_dir;
	gboolean _is_docbook;
	gchar* _index_sgml;
	gchar* _index_sgml_online;
};


static gpointer valadoc_gir_meta_data_parent_class = NULL;

#define VALADOC_GIR_META_DATA_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALADOC_TYPE_GIR_META_DATA, ValadocGirMetaDataPrivate))
static gchar* valadoc_gir_meta_data_get_metadata_file_name (ValadocGirMetaData* self, const gchar* gir_file_path);
static gchar* valadoc_gir_meta_data_get_metadata_path (ValadocGirMetaData* self, const gchar* gir_file_path, gchar** metadata_dirs, int metadata_dirs_length1);
static void valadoc_gir_meta_data_load_general_metadata (ValadocGirMetaData* self, GKeyFile* key_file, ValadocErrorReporter* reporter, GError** error);
static void valadoc_gir_meta_data_set_is_docbook (ValadocGirMetaData* self, gboolean value);
static void valadoc_gir_meta_data_set_index_sgml (ValadocGirMetaData* self, const gchar* value);
static void valadoc_gir_meta_data_set_index_sgml_online (ValadocGirMetaData* self, const gchar* value);
static void valadoc_gir_meta_data_finalize (GObject * obj);
static void _vala_valadoc_gir_meta_data_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_valadoc_gir_meta_data_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


/**
 * Used to manipulate paths to resources inside gir-files
 */
gchar* valadoc_gir_meta_data_get_resource_path (ValadocGirMetaData* self, const gchar* resource) {
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	const gchar* _tmp5_;
	gboolean _tmp6_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (resource != NULL, NULL);
	_tmp1_ = self->priv->resource_dir;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp2_;
		_tmp2_ = self->priv->metadata_path;
		_tmp0_ = _tmp2_ == NULL;
	}
	if (_tmp0_) {
		const gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = resource;
		_tmp4_ = g_strdup (_tmp3_);
		result = _tmp4_;
		return result;
	}
	_tmp5_ = self->priv->resource_dir;
	_tmp6_ = g_path_is_absolute (_tmp5_);
	if (_tmp6_) {
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp7_ = self->priv->resource_dir;
		_tmp8_ = resource;
		_tmp9_ = g_build_filename (_tmp7_, _tmp8_, NULL);
		result = _tmp9_;
		return result;
	}
	_tmp10_ = self->priv->metadata_path;
	_tmp11_ = g_path_get_dirname (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = self->priv->resource_dir;
	_tmp14_ = resource;
	_tmp15_ = g_build_filename (_tmp12_, _tmp13_, _tmp14_, NULL);
	_tmp16_ = _tmp15_;
	_g_free0 (_tmp12_);
	result = _tmp16_;
	return result;
}


static gint string_last_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = needle;
	_tmp2_ = g_strrstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	glong _tmp8_;
	glong _tmp14_;
	glong _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	gchar* _tmp22_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_;
		glong _tmp4_;
		glong _tmp5_;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_;
		gint _tmp7_;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_;
		glong _tmp10_;
		glong _tmp11_;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_;
		glong _tmp13_;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_;
		glong _tmp16_;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


static gchar* valadoc_gir_meta_data_get_metadata_file_name (ValadocGirMetaData* self, const gchar* gir_file_path) {
	gchar* result = NULL;
	gchar* metadata_file_name = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gint last_dot_pos = 0;
	const gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	const gchar* _tmp5_;
	gint _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (gir_file_path != NULL, NULL);
	_tmp0_ = gir_file_path;
	_tmp1_ = g_path_get_basename (_tmp0_);
	metadata_file_name = _tmp1_;
	_tmp2_ = metadata_file_name;
	_tmp3_ = string_last_index_of (_tmp2_, ".", 0);
	last_dot_pos = _tmp3_;
	_tmp4_ = last_dot_pos;
	if (_tmp4_ < 0) {
		result = NULL;
		_g_free0 (metadata_file_name);
		return result;
	}
	_tmp5_ = metadata_file_name;
	_tmp6_ = last_dot_pos;
	_tmp7_ = string_substring (_tmp5_, (glong) 0, (glong) _tmp6_);
	_g_free0 (metadata_file_name);
	metadata_file_name = _tmp7_;
	_tmp8_ = metadata_file_name;
	_tmp9_ = g_strconcat (_tmp8_, ".valadoc.metadata", NULL);
	result = _tmp9_;
	_g_free0 (metadata_file_name);
	return result;
}


static gchar* valadoc_gir_meta_data_get_metadata_path (ValadocGirMetaData* self, const gchar* gir_file_path, gchar** metadata_dirs, int metadata_dirs_length1) {
	gchar* result = NULL;
	gchar* metadata_file_name = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* metadata_path = NULL;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	gboolean _tmp10_;
	gchar** _tmp11_;
	gint _tmp11__length1;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (gir_file_path != NULL, NULL);
	_tmp0_ = gir_file_path;
	_tmp1_ = valadoc_gir_meta_data_get_metadata_file_name (self, _tmp0_);
	metadata_file_name = _tmp1_;
	_tmp2_ = metadata_file_name;
	if (_tmp2_ == NULL) {
		result = NULL;
		_g_free0 (metadata_file_name);
		return result;
	}
	_tmp3_ = gir_file_path;
	_tmp4_ = g_path_get_dirname (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = metadata_file_name;
	_tmp7_ = g_build_filename (_tmp5_, _tmp6_, NULL);
	_tmp8_ = _tmp7_;
	_g_free0 (_tmp5_);
	metadata_path = _tmp8_;
	_tmp9_ = metadata_path;
	_tmp10_ = g_file_test (_tmp9_, G_FILE_TEST_IS_REGULAR);
	if (_tmp10_) {
		result = metadata_path;
		_g_free0 (metadata_file_name);
		return result;
	}
	_tmp11_ = metadata_dirs;
	_tmp11__length1 = metadata_dirs_length1;
	{
		gchar** metadata_dir_collection = NULL;
		gint metadata_dir_collection_length1 = 0;
		gint _metadata_dir_collection_size_ = 0;
		gint metadata_dir_it = 0;
		metadata_dir_collection = _tmp11_;
		metadata_dir_collection_length1 = _tmp11__length1;
		for (metadata_dir_it = 0; metadata_dir_it < _tmp11__length1; metadata_dir_it = metadata_dir_it + 1) {
			gchar* _tmp12_;
			gchar* metadata_dir = NULL;
			_tmp12_ = g_strdup (metadata_dir_collection[metadata_dir_it]);
			metadata_dir = _tmp12_;
			{
				const gchar* _tmp13_;
				const gchar* _tmp14_;
				gchar* _tmp15_;
				const gchar* _tmp16_;
				gboolean _tmp17_;
				_tmp13_ = metadata_dir;
				_tmp14_ = metadata_file_name;
				_tmp15_ = g_build_filename (_tmp13_, _tmp14_, NULL);
				_g_free0 (metadata_path);
				metadata_path = _tmp15_;
				_tmp16_ = metadata_path;
				_tmp17_ = g_file_test (_tmp16_, G_FILE_TEST_IS_REGULAR);
				if (_tmp17_) {
					result = metadata_path;
					_g_free0 (metadata_dir);
					_g_free0 (metadata_file_name);
					return result;
				}
				_g_free0 (metadata_dir);
			}
		}
	}
	result = NULL;
	_g_free0 (metadata_path);
	_g_free0 (metadata_file_name);
	return result;
}


static void valadoc_gir_meta_data_load_general_metadata (ValadocGirMetaData* self, GKeyFile* key_file, ValadocErrorReporter* reporter, GError** error) {
	gchar** _tmp0_ = NULL;
	GKeyFile* _tmp1_;
	gsize _tmp2_;
	gchar** _tmp3_;
	gint _tmp0__length1;
	gint __tmp0__size_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key_file != NULL);
	g_return_if_fail (reporter != NULL);
	_tmp1_ = key_file;
	_tmp3_ = g_key_file_get_keys (_tmp1_, "General", &_tmp2_, &_inner_error_);
	_tmp0_ = _tmp3_;
	_tmp0__length1 = _tmp2_;
	__tmp0__size_ = _tmp0__length1;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == G_KEY_FILE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp4_ = _tmp0_;
	_tmp4__length1 = _tmp0__length1;
	_tmp0_ = NULL;
	_tmp0__length1 = 0;
	{
		gchar** key_collection = NULL;
		gint key_collection_length1 = 0;
		gint _key_collection_size_ = 0;
		gint key_it = 0;
		key_collection = _tmp4_;
		key_collection_length1 = _tmp4__length1;
		for (key_it = 0; key_it < _tmp4__length1; key_it = key_it + 1) {
			gchar* _tmp5_;
			gchar* key = NULL;
			_tmp5_ = g_strdup (key_collection[key_it]);
			key = _tmp5_;
			{
				const gchar* _tmp6_;
				const gchar* _tmp7_;
				GQuark _tmp9_ = 0U;
				static GQuark _tmp8_label0 = 0;
				static GQuark _tmp8_label1 = 0;
				static GQuark _tmp8_label2 = 0;
				static GQuark _tmp8_label3 = 0;
				_tmp6_ = key;
				_tmp7_ = _tmp6_;
				_tmp9_ = (NULL == _tmp7_) ? 0 : g_quark_from_string (_tmp7_);
				if (_tmp9_ == ((0 != _tmp8_label0) ? _tmp8_label0 : (_tmp8_label0 = g_quark_from_static_string ("resources")))) {
					switch (0) {
						default:
						{
							gchar* _tmp10_ = NULL;
							GKeyFile* _tmp11_;
							gchar* _tmp12_;
							gchar* _tmp13_;
							_tmp11_ = key_file;
							_tmp12_ = g_key_file_get_string (_tmp11_, "General", "resources", &_inner_error_);
							_tmp10_ = _tmp12_;
							if (G_UNLIKELY (_inner_error_ != NULL)) {
								if (_inner_error_->domain == G_KEY_FILE_ERROR) {
									g_propagate_error (error, _inner_error_);
									_g_free0 (key);
									key_collection = (_vala_array_free (key_collection, key_collection_length1, (GDestroyNotify) g_free), NULL);
									_tmp0_ = (_vala_array_free (_tmp0_, _tmp0__length1, (GDestroyNotify) g_free), NULL);
									return;
								} else {
									_g_free0 (key);
									key_collection = (_vala_array_free (key_collection, key_collection_length1, (GDestroyNotify) g_free), NULL);
									_tmp0_ = (_vala_array_free (_tmp0_, _tmp0__length1, (GDestroyNotify) g_free), NULL);
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return;
								}
							}
							_tmp13_ = _tmp10_;
							_tmp10_ = NULL;
							_g_free0 (self->priv->resource_dir);
							self->priv->resource_dir = _tmp13_;
							_g_free0 (_tmp10_);
							break;
						}
					}
				} else if (_tmp9_ == ((0 != _tmp8_label1) ? _tmp8_label1 : (_tmp8_label1 = g_quark_from_static_string ("is_docbook")))) {
					switch (0) {
						default:
						{
							gboolean _tmp14_ = FALSE;
							GKeyFile* _tmp15_;
							gboolean _tmp16_;
							_tmp15_ = key_file;
							_tmp16_ = g_key_file_get_boolean (_tmp15_, "General", "is_docbook", &_inner_error_);
							_tmp14_ = _tmp16_;
							if (G_UNLIKELY (_inner_error_ != NULL)) {
								if (_inner_error_->domain == G_KEY_FILE_ERROR) {
									g_propagate_error (error, _inner_error_);
									_g_free0 (key);
									key_collection = (_vala_array_free (key_collection, key_collection_length1, (GDestroyNotify) g_free), NULL);
									_tmp0_ = (_vala_array_free (_tmp0_, _tmp0__length1, (GDestroyNotify) g_free), NULL);
									return;
								} else {
									_g_free0 (key);
									key_collection = (_vala_array_free (key_collection, key_collection_length1, (GDestroyNotify) g_free), NULL);
									_tmp0_ = (_vala_array_free (_tmp0_, _tmp0__length1, (GDestroyNotify) g_free), NULL);
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return;
								}
							}
							valadoc_gir_meta_data_set_is_docbook (self, _tmp14_);
							break;
						}
					}
				} else if (_tmp9_ == ((0 != _tmp8_label2) ? _tmp8_label2 : (_tmp8_label2 = g_quark_from_static_string ("index_sgml")))) {
					switch (0) {
						default:
						{
							gchar* tmp = NULL;
							GKeyFile* _tmp17_;
							gchar* _tmp18_;
							const gchar* _tmp19_;
							gchar* _tmp20_;
							gchar* _tmp21_;
							const gchar* _tmp22_;
							gchar* _tmp23_;
							gchar* _tmp24_;
							_tmp17_ = key_file;
							_tmp18_ = g_key_file_get_string (_tmp17_, "General", "index_sgml", &_inner_error_);
							tmp = _tmp18_;
							if (G_UNLIKELY (_inner_error_ != NULL)) {
								if (_inner_error_->domain == G_KEY_FILE_ERROR) {
									g_propagate_error (error, _inner_error_);
									_g_free0 (key);
									key_collection = (_vala_array_free (key_collection, key_collection_length1, (GDestroyNotify) g_free), NULL);
									_tmp0_ = (_vala_array_free (_tmp0_, _tmp0__length1, (GDestroyNotify) g_free), NULL);
									return;
								} else {
									_g_free0 (key);
									key_collection = (_vala_array_free (key_collection, key_collection_length1, (GDestroyNotify) g_free), NULL);
									_tmp0_ = (_vala_array_free (_tmp0_, _tmp0__length1, (GDestroyNotify) g_free), NULL);
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return;
								}
							}
							_tmp19_ = self->priv->metadata_path;
							_tmp20_ = g_path_get_dirname (_tmp19_);
							_tmp21_ = _tmp20_;
							_tmp22_ = tmp;
							_tmp23_ = g_build_filename (_tmp21_, _tmp22_, NULL);
							_tmp24_ = _tmp23_;
							valadoc_gir_meta_data_set_index_sgml (self, _tmp24_);
							_g_free0 (_tmp24_);
							_g_free0 (_tmp21_);
							_g_free0 (tmp);
							break;
						}
					}
				} else if (_tmp9_ == ((0 != _tmp8_label3) ? _tmp8_label3 : (_tmp8_label3 = g_quark_from_static_string ("index_sgml_online")))) {
					switch (0) {
						default:
						{
							gchar* _tmp25_ = NULL;
							GKeyFile* _tmp26_;
							gchar* _tmp27_;
							_tmp26_ = key_file;
							_tmp27_ = g_key_file_get_string (_tmp26_, "General", "index_sgml_online", &_inner_error_);
							_tmp25_ = _tmp27_;
							if (G_UNLIKELY (_inner_error_ != NULL)) {
								if (_inner_error_->domain == G_KEY_FILE_ERROR) {
									g_propagate_error (error, _inner_error_);
									_g_free0 (key);
									key_collection = (_vala_array_free (key_collection, key_collection_length1, (GDestroyNotify) g_free), NULL);
									_tmp0_ = (_vala_array_free (_tmp0_, _tmp0__length1, (GDestroyNotify) g_free), NULL);
									return;
								} else {
									_g_free0 (key);
									key_collection = (_vala_array_free (key_collection, key_collection_length1, (GDestroyNotify) g_free), NULL);
									_tmp0_ = (_vala_array_free (_tmp0_, _tmp0__length1, (GDestroyNotify) g_free), NULL);
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return;
								}
							}
							valadoc_gir_meta_data_set_index_sgml_online (self, _tmp25_);
							_g_free0 (_tmp25_);
							break;
						}
					}
				} else {
					switch (0) {
						default:
						{
							ValadocErrorReporter* _tmp28_;
							const gchar* _tmp29_;
							const gchar* _tmp30_;
							_tmp28_ = reporter;
							_tmp29_ = self->priv->metadata_path;
							_tmp30_ = key;
							valadoc_error_reporter_simple_warning (_tmp28_, _tmp29_, "Unknown key 'General.%s'", _tmp30_);
							break;
						}
					}
				}
				_g_free0 (key);
			}
		}
		key_collection = (_vala_array_free (key_collection, key_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp0_ = (_vala_array_free (_tmp0_, _tmp0__length1, (GDestroyNotify) g_free), NULL);
}


ValadocGirMetaData* valadoc_gir_meta_data_construct (GType object_type, const gchar* gir_file_path, gchar** metadata_dirs, int metadata_dirs_length1, ValadocErrorReporter* reporter) {
	ValadocGirMetaData * self = NULL;
	const gchar* _tmp0_;
	gboolean _tmp1_;
	const gchar* _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	GKeyFile* key_file = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (gir_file_path != NULL, NULL);
	g_return_val_if_fail (reporter != NULL, NULL);
	self = (ValadocGirMetaData*) g_object_new (object_type, NULL);
	_tmp0_ = gir_file_path;
	_tmp1_ = g_file_test (_tmp0_, G_FILE_TEST_IS_REGULAR);
	if (!_tmp1_) {
		return self;
	}
	_tmp2_ = gir_file_path;
	_tmp3_ = metadata_dirs;
	_tmp3__length1 = metadata_dirs_length1;
	_tmp4_ = valadoc_gir_meta_data_get_metadata_path (self, _tmp2_, _tmp3_, _tmp3__length1);
	_g_free0 (self->priv->metadata_path);
	self->priv->metadata_path = _tmp4_;
	_tmp5_ = self->priv->metadata_path;
	if (_tmp5_ == NULL) {
		return self;
	}
	{
		GKeyFile* _tmp6_;
		GKeyFile* _tmp7_;
		const gchar* _tmp8_;
		_tmp6_ = g_key_file_new ();
		_g_key_file_unref0 (key_file);
		key_file = _tmp6_;
		_tmp7_ = key_file;
		_tmp8_ = self->priv->metadata_path;
		g_key_file_load_from_file (_tmp7_, _tmp8_, G_KEY_FILE_NONE, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch16_g_key_file_error;
			}
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch16_g_file_error;
			}
			_g_key_file_unref0 (key_file);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	goto __finally16;
	__catch16_g_key_file_error:
	{
		GError* e = NULL;
		ValadocErrorReporter* _tmp9_;
		const gchar* _tmp10_;
		GError* _tmp11_;
		const gchar* _tmp12_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp9_ = reporter;
		_tmp10_ = self->priv->metadata_path;
		_tmp11_ = e;
		_tmp12_ = _tmp11_->message;
		valadoc_error_reporter_simple_error (_tmp9_, _tmp10_, "%s", _tmp12_);
		_g_error_free0 (e);
		_g_key_file_unref0 (key_file);
		return self;
	}
	goto __finally16;
	__catch16_g_file_error:
	{
		GError* e = NULL;
		ValadocErrorReporter* _tmp13_;
		const gchar* _tmp14_;
		GError* _tmp15_;
		const gchar* _tmp16_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp13_ = reporter;
		_tmp14_ = self->priv->metadata_path;
		_tmp15_ = e;
		_tmp16_ = _tmp15_->message;
		valadoc_error_reporter_simple_error (_tmp13_, _tmp14_, "%s", _tmp16_);
		_g_error_free0 (e);
		_g_key_file_unref0 (key_file);
		return self;
	}
	__finally16:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_key_file_unref0 (key_file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	{
		GKeyFile* _tmp17_;
		gsize _tmp18_;
		gchar** _tmp19_;
		_tmp17_ = key_file;
		_tmp19_ = g_key_file_get_groups (_tmp17_, &_tmp18_);
		{
			gchar** group_collection = NULL;
			gint group_collection_length1 = 0;
			gint _group_collection_size_ = 0;
			gint group_it = 0;
			group_collection = _tmp19_;
			group_collection_length1 = _tmp18_;
			for (group_it = 0; group_it < _tmp18_; group_it = group_it + 1) {
				gchar* _tmp20_;
				gchar* group = NULL;
				_tmp20_ = g_strdup (group_collection[group_it]);
				group = _tmp20_;
				{
					const gchar* _tmp21_;
					const gchar* _tmp22_;
					GQuark _tmp24_ = 0U;
					static GQuark _tmp23_label0 = 0;
					_tmp21_ = group;
					_tmp22_ = _tmp21_;
					_tmp24_ = (NULL == _tmp22_) ? 0 : g_quark_from_string (_tmp22_);
					if (_tmp24_ == ((0 != _tmp23_label0) ? _tmp23_label0 : (_tmp23_label0 = g_quark_from_static_string ("General")))) {
						switch (0) {
							default:
							{
								GKeyFile* _tmp25_;
								ValadocErrorReporter* _tmp26_;
								_tmp25_ = key_file;
								_tmp26_ = reporter;
								valadoc_gir_meta_data_load_general_metadata (self, _tmp25_, _tmp26_, &_inner_error_);
								if (G_UNLIKELY (_inner_error_ != NULL)) {
									_g_free0 (group);
									group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
									if (_inner_error_->domain == G_KEY_FILE_ERROR) {
										goto __catch17_g_key_file_error;
									}
									_g_free0 (group);
									group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
									_g_key_file_unref0 (key_file);
									g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return NULL;
								}
								break;
							}
						}
					} else {
						switch (0) {
							default:
							{
								ValadocErrorReporter* _tmp27_;
								const gchar* _tmp28_;
								const gchar* _tmp29_;
								_tmp27_ = reporter;
								_tmp28_ = self->priv->metadata_path;
								_tmp29_ = group;
								valadoc_error_reporter_simple_warning (_tmp27_, _tmp28_, "Unknown group '%s'", _tmp29_);
								break;
							}
						}
					}
					_g_free0 (group);
				}
			}
			group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
		}
	}
	goto __finally17;
	__catch17_g_key_file_error:
	{
		GError* e = NULL;
		ValadocErrorReporter* _tmp30_;
		const gchar* _tmp31_;
		GError* _tmp32_;
		const gchar* _tmp33_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp30_ = reporter;
		_tmp31_ = self->priv->metadata_path;
		_tmp32_ = e;
		_tmp33_ = _tmp32_->message;
		valadoc_error_reporter_simple_error (_tmp30_, NULL, "Unable to read file '%s': %s", _tmp31_, _tmp33_);
		_g_error_free0 (e);
	}
	__finally17:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_key_file_unref0 (key_file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_key_file_unref0 (key_file);
	return self;
}


ValadocGirMetaData* valadoc_gir_meta_data_new (const gchar* gir_file_path, gchar** metadata_dirs, int metadata_dirs_length1, ValadocErrorReporter* reporter) {
	return valadoc_gir_meta_data_construct (VALADOC_TYPE_GIR_META_DATA, gir_file_path, metadata_dirs, metadata_dirs_length1, reporter);
}


gboolean valadoc_gir_meta_data_get_is_docbook (ValadocGirMetaData* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_docbook;
	result = _tmp0_;
	return result;
}


static void valadoc_gir_meta_data_set_is_docbook (ValadocGirMetaData* self, gboolean value) {
	g_return_if_fail (self != NULL);
	if (valadoc_gir_meta_data_get_is_docbook (self) != value) {
		gboolean _tmp0_;
		_tmp0_ = value;
		self->priv->_is_docbook = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, valadoc_gir_meta_data_properties[VALADOC_GIR_META_DATA_IS_DOCBOOK]);
	}
}


const gchar* valadoc_gir_meta_data_get_index_sgml (ValadocGirMetaData* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_index_sgml;
	result = _tmp0_;
	return result;
}


static void valadoc_gir_meta_data_set_index_sgml (ValadocGirMetaData* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, valadoc_gir_meta_data_get_index_sgml (self)) != 0) {
		const gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = g_strdup (_tmp0_);
		_g_free0 (self->priv->_index_sgml);
		self->priv->_index_sgml = _tmp1_;
		g_object_notify_by_pspec ((GObject *) self, valadoc_gir_meta_data_properties[VALADOC_GIR_META_DATA_INDEX_SGML]);
	}
}


const gchar* valadoc_gir_meta_data_get_index_sgml_online (ValadocGirMetaData* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_index_sgml_online;
	result = _tmp0_;
	return result;
}


static void valadoc_gir_meta_data_set_index_sgml_online (ValadocGirMetaData* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, valadoc_gir_meta_data_get_index_sgml_online (self)) != 0) {
		const gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = g_strdup (_tmp0_);
		_g_free0 (self->priv->_index_sgml_online);
		self->priv->_index_sgml_online = _tmp1_;
		g_object_notify_by_pspec ((GObject *) self, valadoc_gir_meta_data_properties[VALADOC_GIR_META_DATA_INDEX_SGML_ONLINE]);
	}
}


static void valadoc_gir_meta_data_class_init (ValadocGirMetaDataClass * klass) {
	valadoc_gir_meta_data_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValadocGirMetaDataPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_valadoc_gir_meta_data_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_valadoc_gir_meta_data_set_property;
	G_OBJECT_CLASS (klass)->finalize = valadoc_gir_meta_data_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALADOC_GIR_META_DATA_IS_DOCBOOK, valadoc_gir_meta_data_properties[VALADOC_GIR_META_DATA_IS_DOCBOOK] = g_param_spec_boolean ("is-docbook", "is-docbook", "is-docbook", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALADOC_GIR_META_DATA_INDEX_SGML, valadoc_gir_meta_data_properties[VALADOC_GIR_META_DATA_INDEX_SGML] = g_param_spec_string ("index-sgml", "index-sgml", "index-sgml", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALADOC_GIR_META_DATA_INDEX_SGML_ONLINE, valadoc_gir_meta_data_properties[VALADOC_GIR_META_DATA_INDEX_SGML_ONLINE] = g_param_spec_string ("index-sgml-online", "index-sgml-online", "index-sgml-online", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void valadoc_gir_meta_data_instance_init (ValadocGirMetaData * self) {
	self->priv = VALADOC_GIR_META_DATA_GET_PRIVATE (self);
	self->priv->metadata_path = NULL;
	self->priv->resource_dir = NULL;
	self->priv->_is_docbook = FALSE;
	self->priv->_index_sgml = NULL;
	self->priv->_index_sgml_online = NULL;
}


static void valadoc_gir_meta_data_finalize (GObject * obj) {
	ValadocGirMetaData * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALADOC_TYPE_GIR_META_DATA, ValadocGirMetaData);
	_g_free0 (self->priv->metadata_path);
	_g_free0 (self->priv->resource_dir);
	_g_free0 (self->priv->_index_sgml);
	_g_free0 (self->priv->_index_sgml_online);
	G_OBJECT_CLASS (valadoc_gir_meta_data_parent_class)->finalize (obj);
}


/**
 * Metadata reader for GIR files
 */
GType valadoc_gir_meta_data_get_type (void) {
	static volatile gsize valadoc_gir_meta_data_type_id__volatile = 0;
	if (g_once_init_enter (&valadoc_gir_meta_data_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValadocGirMetaDataClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) valadoc_gir_meta_data_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValadocGirMetaData), 0, (GInstanceInitFunc) valadoc_gir_meta_data_instance_init, NULL };
		GType valadoc_gir_meta_data_type_id;
		valadoc_gir_meta_data_type_id = g_type_register_static (G_TYPE_OBJECT, "ValadocGirMetaData", &g_define_type_info, 0);
		g_once_init_leave (&valadoc_gir_meta_data_type_id__volatile, valadoc_gir_meta_data_type_id);
	}
	return valadoc_gir_meta_data_type_id__volatile;
}


static void _vala_valadoc_gir_meta_data_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ValadocGirMetaData * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, VALADOC_TYPE_GIR_META_DATA, ValadocGirMetaData);
	switch (property_id) {
		case VALADOC_GIR_META_DATA_IS_DOCBOOK:
		g_value_set_boolean (value, valadoc_gir_meta_data_get_is_docbook (self));
		break;
		case VALADOC_GIR_META_DATA_INDEX_SGML:
		g_value_set_string (value, valadoc_gir_meta_data_get_index_sgml (self));
		break;
		case VALADOC_GIR_META_DATA_INDEX_SGML_ONLINE:
		g_value_set_string (value, valadoc_gir_meta_data_get_index_sgml_online (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_valadoc_gir_meta_data_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ValadocGirMetaData * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, VALADOC_TYPE_GIR_META_DATA, ValadocGirMetaData);
	switch (property_id) {
		case VALADOC_GIR_META_DATA_IS_DOCBOOK:
		valadoc_gir_meta_data_set_is_docbook (self, g_value_get_boolean (value));
		break;
		case VALADOC_GIR_META_DATA_INDEX_SGML:
		valadoc_gir_meta_data_set_index_sgml (self, g_value_get_string (value));
		break;
		case VALADOC_GIR_META_DATA_INDEX_SGML_ONLINE:
		valadoc_gir_meta_data_set_index_sgml_online (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



