/* sourcecode.c generated by valac, the Vala compiler
 * generated from sourcecode.vala, do not modify */

/* sourcecode.vala
 *
 * Copyright (C) 2008-2009 Didier Villevalois
 * Copyright (C) 2008-2012 Florian Brosch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Didier 'Ptitjes Villevalois <ptitjes@free.fr>
 */

#include <glib.h>
#include <glib-object.h>
#include "valadoc.h"
#include <stdlib.h>
#include <string.h>
#include <glib/gstdio.h>
#include <valagee.h>

enum  {
	VALADOC_CONTENT_SOURCE_CODE_DUMMY_PROPERTY,
	VALADOC_CONTENT_SOURCE_CODE_CODE,
	VALADOC_CONTENT_SOURCE_CODE_HIGHLIGHTED_CODE,
	VALADOC_CONTENT_SOURCE_CODE_LANGUAGE,
	VALADOC_CONTENT_SOURCE_CODE_LAST_PROPERTY
};
static GParamSpec* valadoc_content_source_code_properties[VALADOC_CONTENT_SOURCE_CODE_LAST_PROPERTY];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValadocContentSourceCodePrivate {
	gchar* _code;
	ValadocContentRun* _highlighted_code;
	ValadocContentSourceCodeLanguage* _language;
};


static gpointer valadoc_content_source_code_parent_class = NULL;
static ValadocContentInlineIface * valadoc_content_source_code_valadoc_content_inline_parent_iface = NULL;

#define VALADOC_CONTENT_SOURCE_CODE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALADOC_CONTENT_TYPE_SOURCE_CODE, ValadocContentSourceCodePrivate))
static ValadocContentSourceCodeLanguage* _valadoc_content_source_code_language_dup (ValadocContentSourceCodeLanguage* self);
G_GNUC_INTERNAL ValadocContentSourceCode* valadoc_content_source_code_new (void);
G_GNUC_INTERNAL ValadocContentSourceCode* valadoc_content_source_code_construct (GType object_type);
static gchar* valadoc_content_source_code_get_path (ValadocContentSourceCode* self, const gchar* path, ValadocApiNode* container, const gchar* source_file_path, ValadocErrorReporter* reporter);
static void valadoc_content_source_code_load_source_code (ValadocContentSourceCode* self, const gchar* _path, ValadocApiNode* container, const gchar* source_file_path, ValadocErrorReporter* reporter);
static inline gboolean valadoc_content_source_code_is_empty_string (ValadocContentSourceCode* self, const gchar* line);
static gchar* valadoc_content_source_code_strip_code (ValadocContentSourceCode* self, const gchar* code);
static void valadoc_content_source_code_real_check (ValadocContentContentElement* base, ValadocApiTree* api_root, ValadocApiNode* container, const gchar* file_path, ValadocErrorReporter* reporter, ValadocSettings* settings);
static gboolean _valadoc_content_source_code_language_equal (const ValadocContentSourceCodeLanguage * s1, const ValadocContentSourceCodeLanguage * s2);
static void valadoc_content_source_code_set_highlighted_code (ValadocContentSourceCode* self, ValadocContentRun* value);
G_GNUC_INTERNAL ValadocContentRun* valadoc_content_run_new (ValadocContentRunStyle style);
G_GNUC_INTERNAL ValadocContentRun* valadoc_content_run_construct (GType object_type, ValadocContentRunStyle style);
G_GNUC_INTERNAL ValadocContentText* valadoc_content_text_new (const gchar* text);
G_GNUC_INTERNAL ValadocContentText* valadoc_content_text_construct (GType object_type, const gchar* text);
static void valadoc_content_source_code_real_accept (ValadocContentContentElement* base, ValadocContentContentVisitor* visitor);
static void valadoc_content_source_code_real_accept_children (ValadocContentContentElement* base, ValadocContentContentVisitor* visitor);
static gboolean valadoc_content_source_code_real_is_empty (ValadocContentContentElement* base);
static ValadocContentContentElement* valadoc_content_source_code_real_copy (ValadocContentContentElement* base, ValadocContentContentElement* new_parent);
G_GNUC_INTERNAL void valadoc_content_content_element_set_parent (ValadocContentContentElement* self, ValadocContentContentElement* value);
static void valadoc_content_source_code_finalize (GObject * obj);
static void _vala_valadoc_content_source_code_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_valadoc_content_source_code_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gint string_last_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = needle;
	_tmp2_ = g_strrstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	glong _tmp8_;
	glong _tmp14_;
	glong _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	gchar* _tmp22_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_;
		glong _tmp4_;
		glong _tmp5_;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_;
		gint _tmp7_;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_;
		glong _tmp10_;
		glong _tmp11_;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_;
		glong _tmp13_;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_;
		glong _tmp16_;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


ValadocContentSourceCodeLanguage* valadoc_content_source_code_language_from_path (const gchar* path) {
	ValadocContentSourceCodeLanguage* result = NULL;
	gint pos = 0;
	const gchar* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gchar* ext = NULL;
	const gchar* _tmp3_;
	gint _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	ValadocContentSourceCodeLanguage* _tmp7_;
	g_return_val_if_fail (path != NULL, NULL);
	_tmp0_ = path;
	_tmp1_ = string_last_index_of (_tmp0_, ".", 0);
	pos = _tmp1_;
	_tmp2_ = pos;
	if (_tmp2_ < 0) {
		result = NULL;
		return result;
	}
	_tmp3_ = path;
	_tmp4_ = pos;
	_tmp5_ = string_substring (_tmp3_, (glong) (_tmp4_ + 1), (glong) -1);
	ext = _tmp5_;
	_tmp6_ = ext;
	_tmp7_ = valadoc_content_source_code_language_from_string (_tmp6_, TRUE);
	result = _tmp7_;
	_g_free0 (ext);
	return result;
}


static ValadocContentSourceCodeLanguage* _valadoc_content_source_code_language_dup (ValadocContentSourceCodeLanguage* self) {
	ValadocContentSourceCodeLanguage* dup;
	dup = g_new0 (ValadocContentSourceCodeLanguage, 1);
	memcpy (dup, self, sizeof (ValadocContentSourceCodeLanguage));
	return dup;
}


static gpointer __valadoc_content_source_code_language_dup0 (gpointer self) {
	return self ? _valadoc_content_source_code_language_dup (self) : NULL;
}


ValadocContentSourceCodeLanguage* valadoc_content_source_code_language_from_string (const gchar* str, gboolean is_extension) {
	ValadocContentSourceCodeLanguage* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	static GQuark _tmp2_label3 = 0;
	static GQuark _tmp2_label4 = 0;
	static GQuark _tmp2_label5 = 0;
	g_return_val_if_fail (str != NULL, NULL);
	_tmp0_ = str;
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("genie")))) {
		switch (0) {
			default:
			{
				gboolean _tmp4_;
				ValadocContentSourceCodeLanguage _tmp5_;
				ValadocContentSourceCodeLanguage* _tmp6_;
				_tmp4_ = is_extension;
				if (_tmp4_) {
					result = NULL;
					return result;
				}
				_tmp5_ = VALADOC_CONTENT_SOURCE_CODE_LANGUAGE_GENIE;
				_tmp6_ = __valadoc_content_source_code_language_dup0 (&_tmp5_);
				result = _tmp6_;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("gs")))) {
		switch (0) {
			default:
			{
				ValadocContentSourceCodeLanguage _tmp7_;
				ValadocContentSourceCodeLanguage* _tmp8_;
				_tmp7_ = VALADOC_CONTENT_SOURCE_CODE_LANGUAGE_GENIE;
				_tmp8_ = __valadoc_content_source_code_language_dup0 (&_tmp7_);
				result = _tmp8_;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("xml")))) {
		switch (0) {
			default:
			{
				ValadocContentSourceCodeLanguage _tmp9_;
				ValadocContentSourceCodeLanguage* _tmp10_;
				_tmp9_ = VALADOC_CONTENT_SOURCE_CODE_LANGUAGE_XML;
				_tmp10_ = __valadoc_content_source_code_language_dup0 (&_tmp9_);
				result = _tmp10_;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("vala")))) {
		switch (0) {
			default:
			{
				ValadocContentSourceCodeLanguage _tmp11_;
				ValadocContentSourceCodeLanguage* _tmp12_;
				_tmp11_ = VALADOC_CONTENT_SOURCE_CODE_LANGUAGE_VALA;
				_tmp12_ = __valadoc_content_source_code_language_dup0 (&_tmp11_);
				result = _tmp12_;
				return result;
			}
		}
	} else if ((_tmp3_ == ((0 != _tmp2_label4) ? _tmp2_label4 : (_tmp2_label4 = g_quark_from_static_string ("c")))) || (_tmp3_ == ((0 != _tmp2_label5) ? _tmp2_label5 : (_tmp2_label5 = g_quark_from_static_string ("h"))))) {
		switch (0) {
			default:
			{
				ValadocContentSourceCodeLanguage _tmp13_;
				ValadocContentSourceCodeLanguage* _tmp14_;
				_tmp13_ = VALADOC_CONTENT_SOURCE_CODE_LANGUAGE_C;
				_tmp14_ = __valadoc_content_source_code_language_dup0 (&_tmp13_);
				result = _tmp14_;
				return result;
			}
		}
	}
	result = NULL;
	return result;
}


const gchar* valadoc_content_source_code_language_to_string (ValadocContentSourceCodeLanguage self) {
	const gchar* result = NULL;
	switch (self) {
		case VALADOC_CONTENT_SOURCE_CODE_LANGUAGE_GENIE:
		{
			result = "genie";
			return result;
		}
		case VALADOC_CONTENT_SOURCE_CODE_LANGUAGE_VALA:
		{
			result = "vala";
			return result;
		}
		case VALADOC_CONTENT_SOURCE_CODE_LANGUAGE_XML:
		{
			result = "xml";
			return result;
		}
		case VALADOC_CONTENT_SOURCE_CODE_LANGUAGE_C:
		{
			result = "c";
			return result;
		}
		default:
		break;
	}
	_vala_assert (TRUE, "true");
	result = "";
	return result;
}


GType valadoc_content_source_code_language_get_type (void) {
	static volatile gsize valadoc_content_source_code_language_type_id__volatile = 0;
	if (g_once_init_enter (&valadoc_content_source_code_language_type_id__volatile)) {
		static const GEnumValue values[] = {{VALADOC_CONTENT_SOURCE_CODE_LANGUAGE_GENIE, "VALADOC_CONTENT_SOURCE_CODE_LANGUAGE_GENIE", "genie"}, {VALADOC_CONTENT_SOURCE_CODE_LANGUAGE_VALA, "VALADOC_CONTENT_SOURCE_CODE_LANGUAGE_VALA", "vala"}, {VALADOC_CONTENT_SOURCE_CODE_LANGUAGE_XML, "VALADOC_CONTENT_SOURCE_CODE_LANGUAGE_XML", "xml"}, {VALADOC_CONTENT_SOURCE_CODE_LANGUAGE_C, "VALADOC_CONTENT_SOURCE_CODE_LANGUAGE_C", "c"}, {0, NULL, NULL}};
		GType valadoc_content_source_code_language_type_id;
		valadoc_content_source_code_language_type_id = g_enum_register_static ("ValadocContentSourceCodeLanguage", values);
		g_once_init_leave (&valadoc_content_source_code_language_type_id__volatile, valadoc_content_source_code_language_type_id);
	}
	return valadoc_content_source_code_language_type_id__volatile;
}


G_GNUC_INTERNAL ValadocContentSourceCode* valadoc_content_source_code_construct (GType object_type) {
	ValadocContentSourceCode * self = NULL;
	ValadocContentSourceCodeLanguage _tmp0_;
	ValadocContentSourceCodeLanguage* _tmp1_;
	self = (ValadocContentSourceCode*) valadoc_content_content_element_construct (object_type);
	_tmp0_ = VALADOC_CONTENT_SOURCE_CODE_LANGUAGE_VALA;
	_tmp1_ = __valadoc_content_source_code_language_dup0 (&_tmp0_);
	_g_free0 (self->priv->_language);
	self->priv->_language = _tmp1_;
	return self;
}


G_GNUC_INTERNAL ValadocContentSourceCode* valadoc_content_source_code_new (void) {
	return valadoc_content_source_code_construct (VALADOC_CONTENT_TYPE_SOURCE_CODE);
}


static gchar* valadoc_content_source_code_get_path (ValadocContentSourceCode* self, const gchar* path, ValadocApiNode* container, const gchar* source_file_path, ValadocErrorReporter* reporter) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gboolean _tmp1_;
	const gchar* _tmp11_;
	gboolean _tmp12_;
	const gchar* _tmp30_;
	gchar* _tmp31_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	g_return_val_if_fail (container != NULL, NULL);
	g_return_val_if_fail (source_file_path != NULL, NULL);
	g_return_val_if_fail (reporter != NULL, NULL);
	_tmp0_ = path;
	_tmp1_ = g_path_is_absolute (_tmp0_);
	if (!_tmp1_) {
		gchar* relative_to_file = NULL;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		const gchar* _tmp8_;
		gboolean _tmp9_;
		_tmp2_ = source_file_path;
		_tmp3_ = g_path_get_dirname (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = path;
		_tmp6_ = g_build_path (G_DIR_SEPARATOR_S, _tmp4_, _tmp5_, NULL);
		_tmp7_ = _tmp6_;
		_g_free0 (_tmp4_);
		relative_to_file = _tmp7_;
		_tmp8_ = relative_to_file;
		_tmp9_ = g_file_test (_tmp8_, G_FILE_TEST_EXISTS | G_FILE_TEST_IS_REGULAR);
		if (_tmp9_) {
			gchar* _tmp10_;
			_tmp10_ = relative_to_file;
			relative_to_file = NULL;
			result = _tmp10_;
			_g_free0 (relative_to_file);
			return result;
		}
		_g_free0 (relative_to_file);
	}
	_tmp11_ = path;
	_tmp12_ = g_file_test (_tmp11_, G_FILE_TEST_EXISTS | G_FILE_TEST_IS_REGULAR);
	if (!_tmp12_) {
		gchar* _tmp13_ = NULL;
		ValadocApiNode* _tmp14_;
		gchar* node_segment = NULL;
		gchar* _tmp20_;
		const gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		ValadocErrorReporter* _tmp24_;
		const gchar* _tmp25_;
		const gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		const gchar* _tmp29_;
		_tmp14_ = container;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp14_, VALADOC_API_TYPE_PACKAGE)) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			_g_free0 (_tmp13_);
			_tmp13_ = _tmp15_;
		} else {
			ValadocApiNode* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			_tmp16_ = container;
			_tmp17_ = valadoc_api_node_get_full_name (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = g_strconcat (_tmp18_, ": ", NULL);
			_g_free0 (_tmp13_);
			_tmp13_ = _tmp19_;
			_g_free0 (_tmp18_);
		}
		_tmp20_ = g_strdup (_tmp13_);
		node_segment = _tmp20_;
		_tmp21_ = path;
		_tmp22_ = g_strdup_printf ("File '%s' does not exist", _tmp21_);
		_tmp23_ = _tmp22_;
		valadoc_content_source_code_set_code (self, _tmp23_);
		_g_free0 (_tmp23_);
		_tmp24_ = reporter;
		_tmp25_ = source_file_path;
		_tmp26_ = node_segment;
		_tmp27_ = g_strdup_printf ("%s: %s{{{", _tmp25_, _tmp26_);
		_tmp28_ = _tmp27_;
		_tmp29_ = self->priv->_code;
		valadoc_error_reporter_simple_warning (_tmp24_, _tmp28_, "%s", _tmp29_);
		_g_free0 (_tmp28_);
		result = NULL;
		_g_free0 (node_segment);
		_g_free0 (_tmp13_);
		return result;
	}
	_tmp30_ = path;
	_tmp31_ = g_strdup (_tmp30_);
	result = _tmp31_;
	return result;
}


static void valadoc_content_source_code_load_source_code (ValadocContentSourceCode* self, const gchar* _path, ValadocApiNode* container, const gchar* source_file_path, ValadocErrorReporter* reporter) {
	gchar* path = NULL;
	const gchar* _tmp0_;
	ValadocApiNode* _tmp1_;
	const gchar* _tmp2_;
	ValadocErrorReporter* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (_path != NULL);
	g_return_if_fail (container != NULL);
	g_return_if_fail (source_file_path != NULL);
	g_return_if_fail (reporter != NULL);
	_tmp0_ = _path;
	_tmp1_ = container;
	_tmp2_ = source_file_path;
	_tmp3_ = reporter;
	_tmp4_ = valadoc_content_source_code_get_path (self, _tmp0_, _tmp1_, _tmp2_, _tmp3_);
	path = _tmp4_;
	_tmp5_ = path;
	if (_tmp5_ == NULL) {
		_g_free0 (path);
		return;
	}
	{
		gchar* content = NULL;
		const gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		const gchar* _tmp8_;
		ValadocContentSourceCodeLanguage* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		content = NULL;
		_tmp6_ = path;
		g_file_get_contents (_tmp6_, &_tmp7_, NULL, &_inner_error_);
		_g_free0 (content);
		content = _tmp7_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (content);
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch20_g_file_error;
			}
			_g_free0 (content);
			_g_free0 (path);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp8_ = path;
		_tmp9_ = valadoc_content_source_code_language_from_path (_tmp8_);
		_g_free0 (self->priv->_language);
		self->priv->_language = _tmp9_;
		_tmp10_ = content;
		content = NULL;
		_tmp11_ = _tmp10_;
		valadoc_content_source_code_set_code (self, _tmp11_);
		_g_free0 (_tmp11_);
		_g_free0 (content);
	}
	goto __finally20;
	__catch20_g_file_error:
	{
		GError* err = NULL;
		gchar* _tmp12_ = NULL;
		ValadocApiNode* _tmp13_;
		gchar* node_segment = NULL;
		gchar* _tmp19_;
		ValadocErrorReporter* _tmp20_;
		const gchar* _tmp21_;
		const gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		const gchar* _tmp25_;
		GError* _tmp26_;
		const gchar* _tmp27_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp13_ = container;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp13_, VALADOC_API_TYPE_PACKAGE)) {
			gchar* _tmp14_;
			_tmp14_ = g_strdup ("");
			_g_free0 (_tmp12_);
			_tmp12_ = _tmp14_;
		} else {
			ValadocApiNode* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			_tmp15_ = container;
			_tmp16_ = valadoc_api_node_get_full_name (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = g_strconcat (_tmp17_, ": ", NULL);
			_g_free0 (_tmp12_);
			_tmp12_ = _tmp18_;
			_g_free0 (_tmp17_);
		}
		_tmp19_ = g_strdup (_tmp12_);
		node_segment = _tmp19_;
		_tmp20_ = reporter;
		_tmp21_ = source_file_path;
		_tmp22_ = node_segment;
		_tmp23_ = g_strdup_printf ("%s: %s{{{", _tmp21_, _tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = path;
		_tmp26_ = err;
		_tmp27_ = _tmp26_->message;
		valadoc_error_reporter_simple_error (_tmp20_, _tmp24_, "Can't read file '%s': %s", _tmp25_, _tmp27_);
		_g_free0 (_tmp24_);
		_g_free0 (node_segment);
		_g_free0 (_tmp12_);
		_g_error_free0 (err);
	}
	__finally20:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (path);
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static inline gboolean valadoc_content_source_code_is_empty_string (ValadocContentSourceCode* self, const gchar* line) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (line != NULL, FALSE);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				const gchar* _tmp2_;
				gint _tmp3_;
				gchar _tmp4_;
				const gchar* _tmp5_;
				gint _tmp6_;
				gchar _tmp7_;
				gboolean _tmp8_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = line;
				_tmp3_ = i;
				_tmp4_ = string_get (_tmp2_, (glong) _tmp3_);
				if (!(_tmp4_ != '\0')) {
					break;
				}
				_tmp5_ = line;
				_tmp6_ = i;
				_tmp7_ = string_get (_tmp5_, (glong) _tmp6_);
				_tmp8_ = g_ascii_isspace (_tmp7_);
				if (_tmp8_ == FALSE) {
					result = FALSE;
					return result;
				}
			}
		}
	}
	result = TRUE;
	return result;
}


static gchar* _vala_g_strjoinv (const gchar* separator, gchar** str_array, int str_array_length1) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gchar** _tmp3_;
	gint _tmp3__length1;
	_tmp0_ = separator;
	if (_tmp0_ == NULL) {
		separator = "";
	}
	_tmp3_ = str_array;
	_tmp3__length1 = str_array_length1;
	if (_tmp3_ != NULL) {
		_tmp2_ = TRUE;
	} else {
		gchar** _tmp4_;
		gint _tmp4__length1;
		_tmp4_ = str_array;
		_tmp4__length1 = str_array_length1;
		_tmp2_ = _tmp4__length1 > 0;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp5_ = FALSE;
		gchar** _tmp6_;
		gint _tmp6__length1;
		_tmp6_ = str_array;
		_tmp6__length1 = str_array_length1;
		if (_tmp6__length1 == -1) {
			gchar** _tmp7_;
			gint _tmp7__length1;
			const gchar* _tmp8_;
			_tmp7_ = str_array;
			_tmp7__length1 = str_array_length1;
			_tmp8_ = _tmp7_[0];
			_tmp5_ = _tmp8_ != NULL;
		} else {
			_tmp5_ = FALSE;
		}
		_tmp1_ = _tmp5_;
	}
	if (_tmp1_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp31_;
		gint _tmp33_;
		gint _tmp34_;
		gsize _tmp35_;
		const gchar* _tmp36_;
		gint _tmp37_;
		gint _tmp38_;
		gint _tmp39_;
		const gchar* res = NULL;
		gsize _tmp40_;
		void* _tmp41_;
		void* ptr = NULL;
		const gchar* _tmp42_;
		gchar** _tmp43_;
		gint _tmp43__length1;
		const gchar* _tmp44_;
		void* _tmp45_;
		const gchar* _tmp62_;
		len = (gsize) 1;
		{
			gboolean _tmp9_ = FALSE;
			i = 0;
			_tmp9_ = TRUE;
			while (TRUE) {
				gboolean _tmp11_ = FALSE;
				gboolean _tmp12_ = FALSE;
				gchar** _tmp13_;
				gint _tmp13__length1;
				gint _tmp21_ = 0;
				gchar** _tmp22_;
				gint _tmp22__length1;
				gint _tmp23_;
				const gchar* _tmp24_;
				gsize _tmp30_;
				if (!_tmp9_) {
					gint _tmp10_;
					_tmp10_ = i;
					i = _tmp10_ + 1;
				}
				_tmp9_ = FALSE;
				_tmp13_ = str_array;
				_tmp13__length1 = str_array_length1;
				if (_tmp13__length1 != -1) {
					gint _tmp14_;
					gchar** _tmp15_;
					gint _tmp15__length1;
					_tmp14_ = i;
					_tmp15_ = str_array;
					_tmp15__length1 = str_array_length1;
					_tmp12_ = _tmp14_ < _tmp15__length1;
				} else {
					_tmp12_ = FALSE;
				}
				if (_tmp12_) {
					_tmp11_ = TRUE;
				} else {
					gboolean _tmp16_ = FALSE;
					gchar** _tmp17_;
					gint _tmp17__length1;
					_tmp17_ = str_array;
					_tmp17__length1 = str_array_length1;
					if (_tmp17__length1 == -1) {
						gchar** _tmp18_;
						gint _tmp18__length1;
						gint _tmp19_;
						const gchar* _tmp20_;
						_tmp18_ = str_array;
						_tmp18__length1 = str_array_length1;
						_tmp19_ = i;
						_tmp20_ = _tmp18_[_tmp19_];
						_tmp16_ = _tmp20_ != NULL;
					} else {
						_tmp16_ = FALSE;
					}
					_tmp11_ = _tmp16_;
				}
				if (!_tmp11_) {
					break;
				}
				_tmp22_ = str_array;
				_tmp22__length1 = str_array_length1;
				_tmp23_ = i;
				_tmp24_ = _tmp22_[_tmp23_];
				if (_tmp24_ != NULL) {
					gchar** _tmp25_;
					gint _tmp25__length1;
					gint _tmp26_;
					const gchar* _tmp27_;
					gint _tmp28_;
					gint _tmp29_;
					_tmp25_ = str_array;
					_tmp25__length1 = str_array_length1;
					_tmp26_ = i;
					_tmp27_ = _tmp25_[_tmp26_];
					_tmp28_ = strlen ((const gchar*) _tmp27_);
					_tmp29_ = _tmp28_;
					_tmp21_ = _tmp29_;
				} else {
					_tmp21_ = 0;
				}
				_tmp30_ = len;
				len = _tmp30_ + _tmp21_;
			}
		}
		_tmp31_ = i;
		if (_tmp31_ == 0) {
			gchar* _tmp32_;
			_tmp32_ = g_strdup ("");
			result = _tmp32_;
			return result;
		}
		_tmp33_ = i;
		str_array_length1 = _tmp33_;
		_tmp34_ = str_array_length1;
		_tmp35_ = len;
		_tmp36_ = separator;
		_tmp37_ = strlen ((const gchar*) _tmp36_);
		_tmp38_ = _tmp37_;
		_tmp39_ = i;
		len = _tmp35_ + (_tmp38_ * (_tmp39_ - 1));
		_tmp40_ = len;
		_tmp41_ = g_malloc (_tmp40_);
		res = _tmp41_;
		_tmp42_ = res;
		_tmp43_ = str_array;
		_tmp43__length1 = str_array_length1;
		_tmp44_ = _tmp43_[0];
		_tmp45_ = g_stpcpy ((void*) _tmp42_, (const gchar*) _tmp44_);
		ptr = _tmp45_;
		{
			gboolean _tmp46_ = FALSE;
			i = 1;
			_tmp46_ = TRUE;
			while (TRUE) {
				gint _tmp48_;
				gchar** _tmp49_;
				gint _tmp49__length1;
				void* _tmp50_;
				const gchar* _tmp51_;
				void* _tmp52_;
				const gchar* _tmp53_ = NULL;
				gchar** _tmp54_;
				gint _tmp54__length1;
				gint _tmp55_;
				const gchar* _tmp56_;
				void* _tmp60_;
				void* _tmp61_;
				if (!_tmp46_) {
					gint _tmp47_;
					_tmp47_ = i;
					i = _tmp47_ + 1;
				}
				_tmp46_ = FALSE;
				_tmp48_ = i;
				_tmp49_ = str_array;
				_tmp49__length1 = str_array_length1;
				if (!(_tmp48_ < _tmp49__length1)) {
					break;
				}
				_tmp50_ = ptr;
				_tmp51_ = separator;
				_tmp52_ = g_stpcpy (_tmp50_, (const gchar*) _tmp51_);
				ptr = _tmp52_;
				_tmp54_ = str_array;
				_tmp54__length1 = str_array_length1;
				_tmp55_ = i;
				_tmp56_ = _tmp54_[_tmp55_];
				if (_tmp56_ != NULL) {
					gchar** _tmp57_;
					gint _tmp57__length1;
					gint _tmp58_;
					const gchar* _tmp59_;
					_tmp57_ = str_array;
					_tmp57__length1 = str_array_length1;
					_tmp58_ = i;
					_tmp59_ = _tmp57_[_tmp58_];
					_tmp53_ = (const gchar*) _tmp59_;
				} else {
					_tmp53_ = "";
				}
				_tmp60_ = ptr;
				_tmp61_ = g_stpcpy (_tmp60_, _tmp53_);
				ptr = _tmp61_;
			}
		}
		_tmp62_ = res;
		res = NULL;
		result = (gchar*) _tmp62_;
		return result;
	} else {
		gchar* _tmp63_;
		_tmp63_ = g_strdup ("");
		result = _tmp63_;
		return result;
	}
}


static gchar* valadoc_content_source_code_strip_code (ValadocContentSourceCode* self, const gchar* code) {
	gchar* result = NULL;
	gchar** lines = NULL;
	const gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint lines_length1;
	gint _lines_size_;
	const gchar** _lines = NULL;
	gchar** _tmp15_;
	gint _tmp15__length1;
	const gchar** _tmp28_;
	gchar* _tmp29_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (code != NULL, NULL);
	_tmp0_ = code;
	_tmp2_ = _tmp1_ = g_strsplit (_tmp0_, "\n", 0);
	lines = _tmp2_;
	lines_length1 = _vala_array_length (_tmp1_);
	_lines_size_ = lines_length1;
	{
		gint i = 0;
		gchar** _tmp3_;
		gint _tmp3__length1;
		_tmp3_ = lines;
		_tmp3__length1 = lines_length1;
		i = _tmp3__length1 - 1;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gint _tmp7_;
				gchar** _tmp12_;
				gint _tmp12__length1;
				gint _tmp13_;
				gchar* _tmp14_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ - 1;
				}
				_tmp4_ = FALSE;
				_tmp7_ = i;
				if (_tmp7_ >= 0) {
					gchar** _tmp8_;
					gint _tmp8__length1;
					gint _tmp9_;
					const gchar* _tmp10_;
					gboolean _tmp11_;
					_tmp8_ = lines;
					_tmp8__length1 = lines_length1;
					_tmp9_ = i;
					_tmp10_ = _tmp8_[_tmp9_];
					_tmp11_ = valadoc_content_source_code_is_empty_string (self, _tmp10_);
					_tmp6_ = _tmp11_;
				} else {
					_tmp6_ = FALSE;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp12_ = lines;
				_tmp12__length1 = lines_length1;
				_tmp13_ = i;
				_g_free0 (_tmp12_[_tmp13_]);
				_tmp12_[_tmp13_] = NULL;
				_tmp14_ = _tmp12_[_tmp13_];
			}
		}
	}
	_tmp15_ = lines;
	_tmp15__length1 = lines_length1;
	_lines = _tmp15_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp16_ = FALSE;
			_tmp16_ = TRUE;
			while (TRUE) {
				gboolean _tmp18_ = FALSE;
				gchar** _tmp19_;
				gint _tmp19__length1;
				gint _tmp20_;
				const gchar* _tmp21_;
				gchar** _tmp26_;
				gint _tmp26__length1;
				gint _tmp27_;
				if (!_tmp16_) {
					gint _tmp17_;
					_tmp17_ = i;
					i = _tmp17_ + 1;
				}
				_tmp16_ = FALSE;
				_tmp19_ = lines;
				_tmp19__length1 = lines_length1;
				_tmp20_ = i;
				_tmp21_ = _tmp19_[_tmp20_];
				if (_tmp21_ != NULL) {
					gchar** _tmp22_;
					gint _tmp22__length1;
					gint _tmp23_;
					const gchar* _tmp24_;
					gboolean _tmp25_;
					_tmp22_ = lines;
					_tmp22__length1 = lines_length1;
					_tmp23_ = i;
					_tmp24_ = _tmp22_[_tmp23_];
					_tmp25_ = valadoc_content_source_code_is_empty_string (self, _tmp24_);
					_tmp18_ = _tmp25_;
				} else {
					_tmp18_ = FALSE;
				}
				if (!_tmp18_) {
					break;
				}
				_tmp26_ = lines;
				_tmp26__length1 = lines_length1;
				_tmp27_ = i;
				_lines = &_tmp26_[_tmp27_ + 1];
			}
		}
	}
	_tmp28_ = _lines;
	_tmp29_ = _vala_g_strjoinv ("\n", (gchar**) _tmp28_, -1);
	result = _tmp29_;
	lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static gboolean _valadoc_content_source_code_language_equal (const ValadocContentSourceCodeLanguage * s1, const ValadocContentSourceCodeLanguage * s2) {
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	return (*s1) == (*s2);
}


static void valadoc_content_source_code_real_check (ValadocContentContentElement* base, ValadocApiTree* api_root, ValadocApiNode* container, const gchar* file_path, ValadocErrorReporter* reporter, ValadocSettings* settings) {
	ValadocContentSourceCode * self;
	gchar** splitted = NULL;
	const gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint splitted_length1;
	gint _splitted_size_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gboolean _tmp7_;
	const gchar* _tmp50_;
	gchar* _tmp51_;
	gchar* _tmp52_;
	ValadocContentSourceCodeLanguage* _tmp53_;
	ValadocContentSourceCodeLanguage _tmp54_;
	self = (ValadocContentSourceCode*) base;
	g_return_if_fail (api_root != NULL);
	g_return_if_fail (container != NULL);
	g_return_if_fail (file_path != NULL);
	g_return_if_fail (reporter != NULL);
	g_return_if_fail (settings != NULL);
	_tmp0_ = self->priv->_code;
	_tmp2_ = _tmp1_ = g_strsplit (_tmp0_, "\n", 2);
	splitted = _tmp2_;
	splitted_length1 = _vala_array_length (_tmp1_);
	_splitted_size_ = splitted_length1;
	_tmp3_ = splitted;
	_tmp3__length1 = splitted_length1;
	_tmp4_ = _tmp3_[0];
	_tmp5_ = string_strip (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strcmp0 (_tmp6_, "") == 0;
	_g_free0 (_tmp6_);
	if (_tmp7_) {
		const gchar* _tmp8_ = NULL;
		gchar** _tmp9_;
		gint _tmp9__length1;
		const gchar* _tmp10_;
		_tmp9_ = splitted;
		_tmp9__length1 = splitted_length1;
		_tmp10_ = _tmp9_[1];
		_tmp8_ = _tmp10_;
		if (_tmp8_ == NULL) {
			_tmp8_ = "";
		}
		valadoc_content_source_code_set_code (self, _tmp8_);
	} else {
		gchar** _tmp11_;
		gint _tmp11__length1;
		const gchar* _tmp12_;
		gboolean _tmp13_;
		_tmp11_ = splitted;
		_tmp11__length1 = splitted_length1;
		_tmp12_ = _tmp11_[0];
		_tmp13_ = g_str_has_prefix (_tmp12_, "#!");
		if (_tmp13_) {
			const gchar* start = NULL;
			gchar** _tmp14_;
			gint _tmp14__length1;
			const gchar* _tmp15_;
			const gchar* _tmp16_;
			gboolean _tmp17_;
			_tmp14_ = splitted;
			_tmp14__length1 = splitted_length1;
			_tmp15_ = _tmp14_[0];
			start = (const gchar*) (((gchar*) _tmp15_) + 2);
			_tmp16_ = start;
			_tmp17_ = g_str_has_prefix (_tmp16_, "include:");
			if (_tmp17_) {
				const gchar* _tmp18_;
				gchar* path = NULL;
				const gchar* _tmp19_;
				gchar* _tmp20_;
				const gchar* _tmp21_;
				ValadocApiNode* _tmp22_;
				const gchar* _tmp23_;
				ValadocErrorReporter* _tmp24_;
				_tmp18_ = start;
				start = (const gchar*) (((gchar*) _tmp18_) + 8);
				_tmp19_ = start;
				_tmp20_ = string_strip (_tmp19_);
				path = _tmp20_;
				_tmp21_ = path;
				_tmp22_ = container;
				_tmp23_ = file_path;
				_tmp24_ = reporter;
				valadoc_content_source_code_load_source_code (self, _tmp21_, _tmp22_, _tmp23_, _tmp24_);
				_g_free0 (path);
			} else {
				gchar* name = NULL;
				const gchar* _tmp25_;
				const gchar* _tmp26_;
				gchar* _tmp27_;
				const gchar* _tmp28_;
				ValadocContentSourceCodeLanguage* _tmp29_;
				const gchar* _tmp30_ = NULL;
				gchar** _tmp31_;
				gint _tmp31__length1;
				const gchar* _tmp32_;
				gboolean _tmp33_ = FALSE;
				ValadocContentSourceCodeLanguage* _tmp34_;
				_tmp25_ = start;
				_tmp26_ = g_strstrip (_tmp25_);
				_tmp27_ = g_utf8_strdown (_tmp26_, (gssize) -1);
				name = _tmp27_;
				_tmp28_ = name;
				_tmp29_ = valadoc_content_source_code_language_from_string (_tmp28_, FALSE);
				_g_free0 (self->priv->_language);
				self->priv->_language = _tmp29_;
				_tmp31_ = splitted;
				_tmp31__length1 = splitted_length1;
				_tmp32_ = _tmp31_[1];
				_tmp30_ = _tmp32_;
				if (_tmp30_ == NULL) {
					_tmp30_ = "";
				}
				valadoc_content_source_code_set_code (self, _tmp30_);
				_tmp34_ = self->priv->_language;
				if (_tmp34_ == NULL) {
					const gchar* _tmp35_;
					_tmp35_ = name;
					_tmp33_ = g_strcmp0 (_tmp35_, "none") != 0;
				} else {
					_tmp33_ = FALSE;
				}
				if (_tmp33_) {
					gchar* _tmp36_ = NULL;
					ValadocApiNode* _tmp37_;
					gchar* node_segment = NULL;
					gchar* _tmp43_;
					ValadocErrorReporter* _tmp44_;
					const gchar* _tmp45_;
					const gchar* _tmp46_;
					gchar* _tmp47_;
					gchar* _tmp48_;
					const gchar* _tmp49_;
					_tmp37_ = container;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp37_, VALADOC_API_TYPE_PACKAGE)) {
						gchar* _tmp38_;
						_tmp38_ = g_strdup ("");
						_g_free0 (_tmp36_);
						_tmp36_ = _tmp38_;
					} else {
						ValadocApiNode* _tmp39_;
						gchar* _tmp40_;
						gchar* _tmp41_;
						gchar* _tmp42_;
						_tmp39_ = container;
						_tmp40_ = valadoc_api_node_get_full_name (_tmp39_);
						_tmp41_ = _tmp40_;
						_tmp42_ = g_strconcat (_tmp41_, ": ", NULL);
						_g_free0 (_tmp36_);
						_tmp36_ = _tmp42_;
						_g_free0 (_tmp41_);
					}
					_tmp43_ = g_strdup (_tmp36_);
					node_segment = _tmp43_;
					_tmp44_ = reporter;
					_tmp45_ = file_path;
					_tmp46_ = node_segment;
					_tmp47_ = g_strdup_printf ("%s: %s{{{", _tmp45_, _tmp46_);
					_tmp48_ = _tmp47_;
					_tmp49_ = name;
					valadoc_error_reporter_simple_warning (_tmp44_, _tmp48_, "Unsupported programming language '%s'", _tmp49_);
					_g_free0 (_tmp48_);
					_g_free0 (node_segment);
					_g_free0 (_tmp36_);
				}
				_g_free0 (name);
			}
		}
	}
	_tmp50_ = self->priv->_code;
	_tmp51_ = valadoc_content_source_code_strip_code (self, _tmp50_);
	_tmp52_ = _tmp51_;
	valadoc_content_source_code_set_code (self, _tmp52_);
	_g_free0 (_tmp52_);
	_tmp53_ = self->priv->_language;
	_tmp54_ = VALADOC_CONTENT_SOURCE_CODE_LANGUAGE_VALA;
	if (_valadoc_content_source_code_language_equal (_tmp53_, &_tmp54_) == TRUE) {
		ValadocApiTree* _tmp55_;
		ValadocHighlighterHighlighter* _tmp56_;
		ValadocHighlighterHighlighter* _tmp57_;
		const gchar* _tmp58_;
		ValadocContentRun* _tmp59_;
		ValadocContentRun* _tmp60_;
		_tmp55_ = api_root;
		_tmp56_ = valadoc_api_tree_get_highlighter (_tmp55_);
		_tmp57_ = _tmp56_;
		_tmp58_ = self->priv->_code;
		_tmp59_ = valadoc_highlighter_highlighter_highlight_vala (_tmp57_, _tmp58_);
		_tmp60_ = _tmp59_;
		valadoc_content_source_code_set_highlighted_code (self, _tmp60_);
		_g_object_unref0 (_tmp60_);
	} else {
		ValadocContentSourceCodeLanguage* _tmp61_;
		ValadocContentSourceCodeLanguage _tmp62_;
		_tmp61_ = self->priv->_language;
		_tmp62_ = VALADOC_CONTENT_SOURCE_CODE_LANGUAGE_XML;
		if (_valadoc_content_source_code_language_equal (_tmp61_, &_tmp62_) == TRUE) {
			ValadocApiTree* _tmp63_;
			ValadocHighlighterHighlighter* _tmp64_;
			ValadocHighlighterHighlighter* _tmp65_;
			const gchar* _tmp66_;
			ValadocContentRun* _tmp67_;
			ValadocContentRun* _tmp68_;
			_tmp63_ = api_root;
			_tmp64_ = valadoc_api_tree_get_highlighter (_tmp63_);
			_tmp65_ = _tmp64_;
			_tmp66_ = self->priv->_code;
			_tmp67_ = valadoc_highlighter_highlighter_highlight_xml (_tmp65_, _tmp66_);
			_tmp68_ = _tmp67_;
			valadoc_content_source_code_set_highlighted_code (self, _tmp68_);
			_g_object_unref0 (_tmp68_);
		} else {
			ValadocContentSourceCodeLanguage* _tmp69_;
			ValadocContentSourceCodeLanguage _tmp70_;
			_tmp69_ = self->priv->_language;
			_tmp70_ = VALADOC_CONTENT_SOURCE_CODE_LANGUAGE_C;
			if (_valadoc_content_source_code_language_equal (_tmp69_, &_tmp70_) == TRUE) {
				ValadocApiTree* _tmp71_;
				ValadocHighlighterHighlighter* _tmp72_;
				ValadocHighlighterHighlighter* _tmp73_;
				const gchar* _tmp74_;
				ValadocContentRun* _tmp75_;
				ValadocContentRun* _tmp76_;
				_tmp71_ = api_root;
				_tmp72_ = valadoc_api_tree_get_highlighter (_tmp71_);
				_tmp73_ = _tmp72_;
				_tmp74_ = self->priv->_code;
				_tmp75_ = valadoc_highlighter_highlighter_highlight_c (_tmp73_, _tmp74_);
				_tmp76_ = _tmp75_;
				valadoc_content_source_code_set_highlighted_code (self, _tmp76_);
				_g_object_unref0 (_tmp76_);
			} else {
				ValadocContentRun* _tmp77_;
				ValadocContentRun* _tmp78_;
				ValadocContentRun* _tmp79_;
				ValaList* _tmp80_;
				ValaList* _tmp81_;
				const gchar* _tmp82_;
				ValadocContentText* _tmp83_;
				ValadocContentText* _tmp84_;
				_tmp77_ = valadoc_content_run_new (VALADOC_CONTENT_RUN_STYLE_MONOSPACED);
				_tmp78_ = _tmp77_;
				valadoc_content_source_code_set_highlighted_code (self, _tmp78_);
				_g_object_unref0 (_tmp78_);
				_tmp79_ = self->priv->_highlighted_code;
				_tmp80_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp79_);
				_tmp81_ = _tmp80_;
				_tmp82_ = self->priv->_code;
				_tmp83_ = valadoc_content_text_new (_tmp82_);
				_tmp84_ = _tmp83_;
				vala_collection_add ((ValaCollection*) _tmp81_, (ValadocContentInline*) _tmp84_);
				_g_object_unref0 (_tmp84_);
			}
		}
	}
	splitted = (_vala_array_free (splitted, splitted_length1, (GDestroyNotify) g_free), NULL);
}


static void valadoc_content_source_code_real_accept (ValadocContentContentElement* base, ValadocContentContentVisitor* visitor) {
	ValadocContentSourceCode * self;
	ValadocContentContentVisitor* _tmp0_;
	self = (ValadocContentSourceCode*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = visitor;
	valadoc_content_content_visitor_visit_source_code (_tmp0_, self);
}


static void valadoc_content_source_code_real_accept_children (ValadocContentContentElement* base, ValadocContentContentVisitor* visitor) {
	ValadocContentSourceCode * self;
	ValadocContentRun* _tmp0_;
	self = (ValadocContentSourceCode*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = self->priv->_highlighted_code;
	if (_tmp0_ != NULL) {
		ValadocContentRun* _tmp1_;
		ValadocContentContentVisitor* _tmp2_;
		_tmp1_ = self->priv->_highlighted_code;
		_tmp2_ = visitor;
		valadoc_content_content_element_accept ((ValadocContentContentElement*) _tmp1_, _tmp2_);
	}
}


static gboolean valadoc_content_source_code_real_is_empty (ValadocContentContentElement* base) {
	ValadocContentSourceCode * self;
	gboolean result = FALSE;
	self = (ValadocContentSourceCode*) base;
	result = FALSE;
	return result;
}


static ValadocContentContentElement* valadoc_content_source_code_real_copy (ValadocContentContentElement* base, ValadocContentContentElement* new_parent) {
	ValadocContentSourceCode * self;
	ValadocContentContentElement* result = NULL;
	ValadocContentSourceCode* source_code = NULL;
	ValadocContentSourceCode* _tmp0_;
	ValadocContentContentElement* _tmp1_;
	ValadocContentSourceCodeLanguage* _tmp2_;
	const gchar* _tmp3_;
	self = (ValadocContentSourceCode*) base;
	_tmp0_ = valadoc_content_source_code_new ();
	source_code = _tmp0_;
	_tmp1_ = new_parent;
	valadoc_content_content_element_set_parent ((ValadocContentContentElement*) source_code, _tmp1_);
	_tmp2_ = self->priv->_language;
	valadoc_content_source_code_set_language (source_code, _tmp2_);
	_tmp3_ = self->priv->_code;
	valadoc_content_source_code_set_code (source_code, _tmp3_);
	result = (ValadocContentContentElement*) source_code;
	return result;
}


const gchar* valadoc_content_source_code_get_code (ValadocContentSourceCode* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_code;
	result = _tmp0_;
	return result;
}


void valadoc_content_source_code_set_code (ValadocContentSourceCode* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, valadoc_content_source_code_get_code (self)) != 0) {
		const gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = g_strdup (_tmp0_);
		_g_free0 (self->priv->_code);
		self->priv->_code = _tmp1_;
		g_object_notify_by_pspec ((GObject *) self, valadoc_content_source_code_properties[VALADOC_CONTENT_SOURCE_CODE_CODE]);
	}
}


ValadocContentRun* valadoc_content_source_code_get_highlighted_code (ValadocContentSourceCode* self) {
	ValadocContentRun* result;
	ValadocContentRun* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_highlighted_code;
	result = _tmp0_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void valadoc_content_source_code_set_highlighted_code (ValadocContentSourceCode* self, ValadocContentRun* value) {
	g_return_if_fail (self != NULL);
	if (valadoc_content_source_code_get_highlighted_code (self) != value) {
		ValadocContentRun* _tmp0_;
		ValadocContentRun* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_g_object_unref0 (self->priv->_highlighted_code);
		self->priv->_highlighted_code = _tmp1_;
		g_object_notify_by_pspec ((GObject *) self, valadoc_content_source_code_properties[VALADOC_CONTENT_SOURCE_CODE_HIGHLIGHTED_CODE]);
	}
}


ValadocContentSourceCodeLanguage* valadoc_content_source_code_get_language (ValadocContentSourceCode* self) {
	ValadocContentSourceCodeLanguage* result;
	ValadocContentSourceCodeLanguage* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_language;
	result = _tmp0_;
	return result;
}


void valadoc_content_source_code_set_language (ValadocContentSourceCode* self, ValadocContentSourceCodeLanguage* value) {
	g_return_if_fail (self != NULL);
	if (valadoc_content_source_code_get_language (self) != value) {
		ValadocContentSourceCodeLanguage* _tmp0_;
		ValadocContentSourceCodeLanguage* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = __valadoc_content_source_code_language_dup0 (_tmp0_);
		_g_free0 (self->priv->_language);
		self->priv->_language = _tmp1_;
		g_object_notify_by_pspec ((GObject *) self, valadoc_content_source_code_properties[VALADOC_CONTENT_SOURCE_CODE_LANGUAGE]);
	}
}


static void valadoc_content_source_code_class_init (ValadocContentSourceCodeClass * klass) {
	valadoc_content_source_code_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValadocContentSourceCodePrivate));
	((ValadocContentContentElementClass *) klass)->check = (void (*) (ValadocContentContentElement *, ValadocApiTree*, ValadocApiNode*, const gchar*, ValadocErrorReporter*, ValadocSettings*)) valadoc_content_source_code_real_check;
	((ValadocContentContentElementClass *) klass)->accept = (void (*) (ValadocContentContentElement *, ValadocContentContentVisitor*)) valadoc_content_source_code_real_accept;
	((ValadocContentContentElementClass *) klass)->accept_children = (void (*) (ValadocContentContentElement *, ValadocContentContentVisitor*)) valadoc_content_source_code_real_accept_children;
	((ValadocContentContentElementClass *) klass)->is_empty = (gboolean (*) (ValadocContentContentElement *)) valadoc_content_source_code_real_is_empty;
	((ValadocContentContentElementClass *) klass)->copy = (ValadocContentContentElement* (*) (ValadocContentContentElement *, ValadocContentContentElement*)) valadoc_content_source_code_real_copy;
	G_OBJECT_CLASS (klass)->get_property = _vala_valadoc_content_source_code_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_valadoc_content_source_code_set_property;
	G_OBJECT_CLASS (klass)->finalize = valadoc_content_source_code_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALADOC_CONTENT_SOURCE_CODE_CODE, valadoc_content_source_code_properties[VALADOC_CONTENT_SOURCE_CODE_CODE] = g_param_spec_string ("code", "code", "code", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALADOC_CONTENT_SOURCE_CODE_HIGHLIGHTED_CODE, valadoc_content_source_code_properties[VALADOC_CONTENT_SOURCE_CODE_HIGHLIGHTED_CODE] = g_param_spec_object ("highlighted-code", "highlighted-code", "highlighted-code", VALADOC_CONTENT_TYPE_RUN, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALADOC_CONTENT_SOURCE_CODE_LANGUAGE, valadoc_content_source_code_properties[VALADOC_CONTENT_SOURCE_CODE_LANGUAGE] = g_param_spec_enum ("language", "language", "language", VALADOC_CONTENT_SOURCE_CODE_TYPE_LANGUAGE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void valadoc_content_source_code_valadoc_content_inline_interface_init (ValadocContentInlineIface * iface) {
	valadoc_content_source_code_valadoc_content_inline_parent_iface = g_type_interface_peek_parent (iface);
}


static void valadoc_content_source_code_instance_init (ValadocContentSourceCode * self) {
	self->priv = VALADOC_CONTENT_SOURCE_CODE_GET_PRIVATE (self);
}


static void valadoc_content_source_code_finalize (GObject * obj) {
	ValadocContentSourceCode * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALADOC_CONTENT_TYPE_SOURCE_CODE, ValadocContentSourceCode);
	_g_free0 (self->priv->_code);
	_g_object_unref0 (self->priv->_highlighted_code);
	_g_free0 (self->priv->_language);
	G_OBJECT_CLASS (valadoc_content_source_code_parent_class)->finalize (obj);
}


GType valadoc_content_source_code_get_type (void) {
	static volatile gsize valadoc_content_source_code_type_id__volatile = 0;
	if (g_once_init_enter (&valadoc_content_source_code_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValadocContentSourceCodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) valadoc_content_source_code_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValadocContentSourceCode), 0, (GInstanceInitFunc) valadoc_content_source_code_instance_init, NULL };
		static const GInterfaceInfo valadoc_content_inline_info = { (GInterfaceInitFunc) valadoc_content_source_code_valadoc_content_inline_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType valadoc_content_source_code_type_id;
		valadoc_content_source_code_type_id = g_type_register_static (VALADOC_CONTENT_TYPE_CONTENT_ELEMENT, "ValadocContentSourceCode", &g_define_type_info, 0);
		g_type_add_interface_static (valadoc_content_source_code_type_id, VALADOC_CONTENT_TYPE_INLINE, &valadoc_content_inline_info);
		g_once_init_leave (&valadoc_content_source_code_type_id__volatile, valadoc_content_source_code_type_id);
	}
	return valadoc_content_source_code_type_id__volatile;
}


static void _vala_valadoc_content_source_code_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ValadocContentSourceCode * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, VALADOC_CONTENT_TYPE_SOURCE_CODE, ValadocContentSourceCode);
	switch (property_id) {
		case VALADOC_CONTENT_SOURCE_CODE_CODE:
		g_value_set_string (value, valadoc_content_source_code_get_code (self));
		break;
		case VALADOC_CONTENT_SOURCE_CODE_HIGHLIGHTED_CODE:
		g_value_set_object (value, valadoc_content_source_code_get_highlighted_code (self));
		break;
		case VALADOC_CONTENT_SOURCE_CODE_LANGUAGE:
		g_value_set_enum (value, valadoc_content_source_code_get_language (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_valadoc_content_source_code_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ValadocContentSourceCode * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, VALADOC_CONTENT_TYPE_SOURCE_CODE, ValadocContentSourceCode);
	switch (property_id) {
		case VALADOC_CONTENT_SOURCE_CODE_CODE:
		valadoc_content_source_code_set_code (self, g_value_get_string (value));
		break;
		case VALADOC_CONTENT_SOURCE_CODE_HIGHLIGHTED_CODE:
		valadoc_content_source_code_set_highlighted_code (self, g_value_get_object (value));
		break;
		case VALADOC_CONTENT_SOURCE_CODE_LANGUAGE:
		valadoc_content_source_code_set_language (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



