/* valacompiler.c generated by valac, the Vala compiler
 * generated from valacompiler.vala, do not modify */

/* valacompiler.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 * Copyright (C) 1996-2002, 2004, 2005, 2006 Free Software Foundation, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <valacodegen.h>
#include <version.h>
#include <config.h>
#include <glib/gstdio.h>
#include <unistd.h>
#include <locale.h>
#include <gobject/gvaluecollector.h>


#define VALA_TYPE_COMPILER (vala_compiler_get_type ())
#define VALA_COMPILER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_COMPILER, ValaCompiler))
#define VALA_COMPILER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_COMPILER, ValaCompilerClass))
#define VALA_IS_COMPILER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_COMPILER))
#define VALA_IS_COMPILER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_COMPILER))
#define VALA_COMPILER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_COMPILER, ValaCompilerClass))

typedef struct _ValaCompiler ValaCompiler;
typedef struct _ValaCompilerClass ValaCompilerClass;
typedef struct _ValaCompilerPrivate ValaCompilerPrivate;
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_code_visitor_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_visitor_unref (var), NULL)))
#define _vala_ccode_compiler_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_compiler_unref (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_compiler_unref0(var) ((var == NULL) ? NULL : (var = (vala_compiler_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
typedef struct _ValaParamSpecCompiler ValaParamSpecCompiler;

struct _ValaCompiler {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCompilerPrivate * priv;
};

struct _ValaCompilerClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCompiler *self);
};

struct _ValaCompilerPrivate {
	ValaCodeContext* context;
};

struct _Block1Data {
	int _ref_count_;
	GMainLoop* loop;
	gint child_status;
};

struct _ValaParamSpecCompiler {
	GParamSpec parent_instance;
};


static gpointer vala_compiler_parent_class = NULL;
static gchar* vala_compiler_basedir;
static gchar* vala_compiler_basedir = NULL;
static gchar* vala_compiler_directory;
static gchar* vala_compiler_directory = NULL;
static gboolean vala_compiler_version;
static gboolean vala_compiler_version = FALSE;
static gboolean vala_compiler_api_version;
static gboolean vala_compiler_api_version = FALSE;
static gchar** vala_compiler_sources;
static gchar** vala_compiler_sources = NULL;
static gchar** vala_compiler_vapi_directories;
static gchar** vala_compiler_vapi_directories = NULL;
static gchar** vala_compiler_gir_directories;
static gchar** vala_compiler_gir_directories = NULL;
static gchar** vala_compiler_metadata_directories;
static gchar** vala_compiler_metadata_directories = NULL;
static gchar* vala_compiler_vapi_filename;
static gchar* vala_compiler_vapi_filename = NULL;
static gchar* vala_compiler_library;
static gchar* vala_compiler_library = NULL;
static gchar* vala_compiler_shared_library;
static gchar* vala_compiler_shared_library = NULL;
static gchar* vala_compiler_gir;
static gchar* vala_compiler_gir = NULL;
static gchar** vala_compiler_packages;
static gchar** vala_compiler_packages = NULL;
static gchar** vala_compiler_fast_vapis;
static gchar** vala_compiler_fast_vapis = NULL;
static gchar* vala_compiler_target_glib;
static gchar* vala_compiler_target_glib = NULL;
static gchar** vala_compiler_gresources;
static gchar** vala_compiler_gresources = NULL;
static gchar** vala_compiler_gresources_directories;
static gchar** vala_compiler_gresources_directories = NULL;
static gboolean vala_compiler_ccode_only;
static gboolean vala_compiler_ccode_only = FALSE;
static gchar* vala_compiler_header_filename;
static gchar* vala_compiler_header_filename = NULL;
static gboolean vala_compiler_use_header;
static gboolean vala_compiler_use_header = FALSE;
static gchar* vala_compiler_internal_header_filename;
static gchar* vala_compiler_internal_header_filename = NULL;
static gchar* vala_compiler_internal_vapi_filename;
static gchar* vala_compiler_internal_vapi_filename = NULL;
static gchar* vala_compiler_fast_vapi_filename;
static gchar* vala_compiler_fast_vapi_filename = NULL;
static gboolean vala_compiler_vapi_comments;
static gboolean vala_compiler_vapi_comments = FALSE;
static gchar* vala_compiler_symbols_filename;
static gchar* vala_compiler_symbols_filename = NULL;
static gchar* vala_compiler_includedir;
static gchar* vala_compiler_includedir = NULL;
static gboolean vala_compiler_compile_only;
static gboolean vala_compiler_compile_only = FALSE;
static gchar* vala_compiler_output;
static gchar* vala_compiler_output = NULL;
static gboolean vala_compiler_debug;
static gboolean vala_compiler_debug = FALSE;
static gboolean vala_compiler_mem_profiler;
static gboolean vala_compiler_mem_profiler = FALSE;
static gboolean vala_compiler_disable_assert;
static gboolean vala_compiler_disable_assert = FALSE;
static gboolean vala_compiler_enable_checking;
static gboolean vala_compiler_enable_checking = FALSE;
static gboolean vala_compiler_deprecated;
static gboolean vala_compiler_deprecated = FALSE;
static gboolean vala_compiler_hide_internal;
static gboolean vala_compiler_hide_internal = FALSE;
static gboolean vala_compiler_experimental;
static gboolean vala_compiler_experimental = FALSE;
static gboolean vala_compiler_experimental_non_null;
static gboolean vala_compiler_experimental_non_null = FALSE;
static gboolean vala_compiler_gobject_tracing;
static gboolean vala_compiler_gobject_tracing = FALSE;
static gboolean vala_compiler_disable_since_check;
static gboolean vala_compiler_disable_since_check = FALSE;
static gboolean vala_compiler_disable_warnings;
static gboolean vala_compiler_disable_warnings = FALSE;
static gchar* vala_compiler_cc_command;
static gchar* vala_compiler_cc_command = NULL;
static gchar** vala_compiler_cc_options;
static gchar** vala_compiler_cc_options = NULL;
static gchar* vala_compiler_pkg_config_command;
static gchar* vala_compiler_pkg_config_command = NULL;
static gchar* vala_compiler_dump_tree;
static gchar* vala_compiler_dump_tree = NULL;
static gboolean vala_compiler_save_temps;
static gboolean vala_compiler_save_temps = FALSE;
static gchar** vala_compiler_defines;
static gchar** vala_compiler_defines = NULL;
static gboolean vala_compiler_quiet_mode;
static gboolean vala_compiler_quiet_mode = FALSE;
static gboolean vala_compiler_verbose_mode;
static gboolean vala_compiler_verbose_mode = FALSE;
static gchar* vala_compiler_profile;
static gchar* vala_compiler_profile = NULL;
static gboolean vala_compiler_nostdpkg;
static gboolean vala_compiler_nostdpkg = FALSE;
static gboolean vala_compiler_enable_version_header;
static gboolean vala_compiler_enable_version_header = FALSE;
static gboolean vala_compiler_disable_version_header;
static gboolean vala_compiler_disable_version_header = FALSE;
static gboolean vala_compiler_fatal_warnings;
static gboolean vala_compiler_fatal_warnings = FALSE;
static gboolean vala_compiler_disable_diagnostic_colors;
static gboolean vala_compiler_disable_diagnostic_colors = FALSE;
static gchar* vala_compiler_dependencies;
static gchar* vala_compiler_dependencies = NULL;
static gchar* vala_compiler_entry_point;
static gchar* vala_compiler_entry_point = NULL;
static gboolean vala_compiler_run_output;
static gboolean vala_compiler_run_output = FALSE;

G_GNUC_INTERNAL gpointer vala_compiler_ref (gpointer instance);
G_GNUC_INTERNAL void vala_compiler_unref (gpointer instance);
G_GNUC_INTERNAL GParamSpec* vala_param_spec_compiler (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
G_GNUC_INTERNAL void vala_value_set_compiler (GValue* value, gpointer v_object) G_GNUC_UNUSED;
G_GNUC_INTERNAL void vala_value_take_compiler (GValue* value, gpointer v_object);
G_GNUC_INTERNAL gpointer vala_value_get_compiler (const GValue* value) G_GNUC_UNUSED;
G_GNUC_INTERNAL GType vala_compiler_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define VALA_COMPILER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_COMPILER, ValaCompilerPrivate))
enum  {
	VALA_COMPILER_0_PROPERTY
};
#define VALA_COMPILER_DEFAULT_COLORS "error=01;31:warning=01;35:note=01;36:caret=01;32:locus=01:quote=01"
static gboolean vala_compiler_option_deprecated (const gchar* option_name, const gchar* val, void* data, GError** error);
static gint vala_compiler_quit (ValaCompiler* self);
static gint vala_compiler_run (ValaCompiler* self);
static gchar** _vala_array_dup1 (gchar** self, int length);
static gchar** _vala_array_dup2 (gchar** self, int length);
static gchar** _vala_array_dup3 (gchar** self, int length);
static gchar** _vala_array_dup4 (gchar** self, int length);
static gchar** _vala_array_dup5 (gchar** self, int length);
static gint vala_compiler_run_source (gchar** args, int args_length1);
G_GNUC_INTERNAL ValaCompiler* vala_compiler_new (void);
G_GNUC_INTERNAL ValaCompiler* vala_compiler_construct (GType object_type);
static void _vala_array_add1 (gchar** * array, int* length, int* size, gchar* value);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void ___lambda4_ (Block1Data* _data1_, GPid pid, gint status);
static void ____lambda4__gchild_watch_func (GPid pid, gint status, gpointer self);
static gint vala_compiler_main (gchar** args, int args_length1);
static void vala_compiler_finalize (ValaCompiler * obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GOptionEntry VALA_COMPILER_options[57] = {{"vapidir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_vapi_directories, "Look for package bindings in DIRECTORY", "DIRECTORY..."}, {"girdir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_gir_directories, "Look for .gir files in DIRECTORY", "DIRECTORY..."}, {"metadatadir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_metadata_directories, "Look for GIR .metadata files in DIRECTORY", "DIRECTORY..."}, {"pkg", (gchar) 0, 0, G_OPTION_ARG_STRING_ARRAY, &vala_compiler_packages, "Include binding for PACKAGE", "PACKAGE..."}, {"vapi", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_vapi_filename, "Output VAPI file name", "FILE"}, {"library", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_library, "Library name", "NAME"}, {"shared-library", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_shared_library, "Shared library name used in generated gir", "NAME"}, {"gir", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_gir, "GObject-Introspection repository file name", "NAME-VERSION.gir"}, {"basedir", 'b', 0, G_OPTION_ARG_FILENAME, &vala_compiler_basedir, "Base source directory", "DIRECTORY"}, {"directory", 'd', 0, G_OPTION_ARG_FILENAME, &vala_compiler_directory, "Change output directory from current working directory", "DIRECTORY"}, {"version", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_version, "Display version number", NULL}, {"api-version", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_api_version, "Display API version number", NULL}, {"ccode", 'C', 0, G_OPTION_ARG_NONE, &vala_compiler_ccode_only, "Output C code", NULL}, {"header", 'H', 0, G_OPTION_ARG_FILENAME, &vala_compiler_header_filename, "Output C header file", "FILE"}, {"use-header", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_use_header, "Use C header file", NULL}, {"includedir", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_includedir, "Directory used to include the C header file", "DIRECTORY"}, {"internal-header", 'h', 0, G_OPTION_ARG_FILENAME, &vala_compiler_internal_header_filename, "Output internal C header file", "FILE"}, {"internal-vapi", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_internal_vapi_filename, "Output vapi with internal api", "FILE"}, {"fast-vapi", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_fast_vapi_filename, "Output vapi without performing symbol resolution", NULL}, {"use-fast-vapi", (gchar) 0, 0, G_OPTION_ARG_STRING_ARRAY, &vala_compiler_fast_vapis, "Use --fast-vapi output during this compile", NULL}, {"vapi-comments", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_vapi_comments, "Include comments in generated vapi", NULL}, {"deps", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_dependencies, "Write make-style dependency information to this file", NULL}, {"symbols", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_symbols_filename, "Output symbols file", "FILE"}, {"compile", 'c', 0, G_OPTION_ARG_NONE, &vala_compiler_compile_only, "Compile but do not link", NULL}, {"output", 'o', 0, G_OPTION_ARG_FILENAME, &vala_compiler_output, "Place output in file FILE", "FILE"}, {"debug", 'g', 0, G_OPTION_ARG_NONE, &vala_compiler_debug, "Produce debug information", NULL}, {"thread", (gchar) 0, (gint) (G_OPTION_FLAG_OPTIONAL_ARG | G_OPTION_FLAG_NO_ARG), G_OPTION_ARG_CALLBACK, (void*) vala_compiler_option_deprecated, "Enable multithreading support (DEPRECATED AND IGNORED)", NULL}, {"enable-mem-profiler", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_mem_profiler, "Enable GLib memory profiler", NULL}, {"define", 'D', 0, G_OPTION_ARG_STRING_ARRAY, &vala_compiler_defines, "Define SYMBOL", "SYMBOL..."}, {"main", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_entry_point, "Use SYMBOL as entry point", "SYMBOL..."}, {"nostdpkg", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_nostdpkg, "Do not include standard packages", NULL}, {"disable-assert", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_disable_assert, "Disable assertions", NULL}, {"enable-checking", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_enable_checking, "Enable additional run-time checks", NULL}, {"enable-deprecated", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_deprecated, "Enable deprecated features", NULL}, {"hide-internal", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_hide_internal, "Hide symbols marked as internal", NULL}, {"enable-experimental", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_experimental, "Enable experimental features", NULL}, {"disable-warnings", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_disable_warnings, "Disable warnings", NULL}, {"fatal-warnings", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_fatal_warnings, "Treat warnings as fatal", NULL}, {"disable-since-check", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_disable_since_check, "Do not check whether used symbols exist in local packages", NULL}, {"enable-experimental-non-null", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_experimental_non_null, "Enable experimental enhancements for non-null types", NULL}, {"enable-gobject-tracing", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_gobject_tracing, "Enable GObject creation tracing", NULL}, {"cc", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_cc_command, "Use COMMAND as C compiler command", "COMMAND"}, {"Xcc", 'X', 0, G_OPTION_ARG_STRING_ARRAY, &vala_compiler_cc_options, "Pass OPTION to the C compiler", "OPTION..."}, {"pkg-config", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_pkg_config_command, "Use COMMAND as pkg-config command", "COMMAND"}, {"dump-tree", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_dump_tree, "Write code tree to FILE", "FILE"}, {"save-temps", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_save_temps, "Keep temporary files", NULL}, {"profile", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_profile, "Use the given profile instead of the default", "PROFILE"}, {"quiet", 'q', 0, G_OPTION_ARG_NONE, &vala_compiler_quiet_mode, "Do not print messages to the console", NULL}, {"verbose", 'v', 0, G_OPTION_ARG_NONE, &vala_compiler_verbose_mode, "Print additional messages to the console", NULL}, {"no-color", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_disable_diagnostic_colors, "Disable colored output", NULL}, {"target-glib", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_target_glib, "Target version of glib for code generation", "MAJOR.MINOR"}, {"gresources", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_gresources, "XML of gresources", "FILE..."}, {"gresourcesdir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_gresources_directories, "Look for resources in DIRECTORY", "DIRECTORY..."}, {"enable-version-header", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_enable_version_header, "Write vala build version in generated files", NULL}, {"disable-version-header", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_disable_version_header, "Do not write vala build version in generated files", NULL}, {"", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_sources, NULL, "FILE..."}, {NULL}};

static gboolean vala_compiler_option_deprecated (const gchar* option_name, const gchar* val, void* data, GError** error) {
	gboolean result = FALSE;
	FILE* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (option_name != NULL, FALSE);
	_tmp0_ = stdout;
	_tmp1_ = option_name;
	fprintf (_tmp0_, "Command-line option `%s` is deprecated and will be ignored\n", _tmp1_);
	result = TRUE;
	return result;
}


static gint vala_compiler_quit (ValaCompiler* self) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	ValaCodeContext* _tmp1_;
	ValaReport* _tmp2_;
	ValaReport* _tmp3_;
	gint _tmp4_;
	gboolean _tmp9_ = FALSE;
	ValaCodeContext* _tmp10_;
	ValaReport* _tmp11_;
	ValaReport* _tmp12_;
	gint _tmp13_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp1_ = self->priv->context;
	_tmp2_ = vala_code_context_get_report (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_report_get_errors (_tmp3_);
	if (_tmp4_ == 0) {
		ValaCodeContext* _tmp5_;
		ValaReport* _tmp6_;
		ValaReport* _tmp7_;
		gint _tmp8_;
		_tmp5_ = self->priv->context;
		_tmp6_ = vala_code_context_get_report (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_report_get_warnings (_tmp7_);
		_tmp0_ = _tmp8_ == 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = 0;
		return result;
	}
	_tmp10_ = self->priv->context;
	_tmp11_ = vala_code_context_get_report (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = vala_report_get_errors (_tmp12_);
	if (_tmp13_ == 0) {
		gboolean _tmp14_ = FALSE;
		gboolean _tmp15_;
		_tmp15_ = vala_compiler_fatal_warnings;
		if (!_tmp15_) {
			_tmp14_ = TRUE;
		} else {
			ValaCodeContext* _tmp16_;
			ValaReport* _tmp17_;
			ValaReport* _tmp18_;
			gint _tmp19_;
			_tmp16_ = self->priv->context;
			_tmp17_ = vala_code_context_get_report (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = vala_report_get_warnings (_tmp18_);
			_tmp14_ = _tmp19_ == 0;
		}
		_tmp9_ = _tmp14_;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		gboolean _tmp20_;
		_tmp20_ = vala_compiler_quiet_mode;
		if (!_tmp20_) {
			FILE* _tmp21_;
			ValaCodeContext* _tmp22_;
			ValaReport* _tmp23_;
			ValaReport* _tmp24_;
			gint _tmp25_;
			_tmp21_ = stdout;
			_tmp22_ = self->priv->context;
			_tmp23_ = vala_code_context_get_report (_tmp22_);
			_tmp24_ = _tmp23_;
			_tmp25_ = vala_report_get_warnings (_tmp24_);
			fprintf (_tmp21_, "Compilation succeeded - %d warning(s)\n", _tmp25_);
		}
		result = 0;
		return result;
	} else {
		gboolean _tmp26_;
		_tmp26_ = vala_compiler_quiet_mode;
		if (!_tmp26_) {
			FILE* _tmp27_;
			ValaCodeContext* _tmp28_;
			ValaReport* _tmp29_;
			ValaReport* _tmp30_;
			gint _tmp31_;
			ValaCodeContext* _tmp32_;
			ValaReport* _tmp33_;
			ValaReport* _tmp34_;
			gint _tmp35_;
			_tmp27_ = stdout;
			_tmp28_ = self->priv->context;
			_tmp29_ = vala_code_context_get_report (_tmp28_);
			_tmp30_ = _tmp29_;
			_tmp31_ = vala_report_get_errors (_tmp30_);
			_tmp32_ = self->priv->context;
			_tmp33_ = vala_code_context_get_report (_tmp32_);
			_tmp34_ = _tmp33_;
			_tmp35_ = vala_report_get_warnings (_tmp34_);
			fprintf (_tmp27_, "Compilation failed: %d error(s), %d warning(s)\n", _tmp31_, _tmp35_);
		}
		result = 1;
		return result;
	}
}


static gint string_last_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_;
	gunichar _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = c;
	_tmp2_ = g_utf8_strrchr (((gchar*) self) + _tmp0_, (gssize) -1, _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	glong _tmp8_;
	glong _tmp14_;
	glong _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	gchar* _tmp22_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_;
		glong _tmp4_;
		glong _tmp5_;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_;
		gint _tmp7_;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_;
		glong _tmp10_;
		glong _tmp11_;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_;
		glong _tmp13_;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_;
		glong _tmp16_;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup2 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup3 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup4 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup5 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


static gint vala_compiler_run (ValaCompiler* self) {
	gint result = 0;
	ValaCodeContext* _tmp0_;
	ValaCodeContext* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_;
	ValaCodeContext* _tmp29_;
	gboolean _tmp30_;
	ValaCodeContext* _tmp31_;
	gboolean _tmp32_;
	ValaCodeContext* _tmp33_;
	gboolean _tmp34_;
	ValaCodeContext* _tmp35_;
	gboolean _tmp36_;
	ValaCodeContext* _tmp37_;
	gboolean _tmp38_;
	ValaCodeContext* _tmp39_;
	gboolean _tmp40_;
	ValaCodeContext* _tmp41_;
	gboolean _tmp42_;
	ValaCodeContext* _tmp43_;
	gboolean _tmp44_;
	ValaCodeContext* _tmp45_;
	ValaReport* _tmp46_;
	ValaReport* _tmp47_;
	gboolean _tmp48_;
	ValaCodeContext* _tmp49_;
	ValaReport* _tmp50_;
	ValaReport* _tmp51_;
	gboolean _tmp52_;
	ValaCodeContext* _tmp53_;
	gboolean _tmp54_;
	ValaCodeContext* _tmp55_;
	gboolean _tmp56_;
	ValaCodeContext* _tmp57_;
	gboolean _tmp58_;
	gboolean _tmp59_ = FALSE;
	gboolean _tmp60_;
	ValaCodeContext* _tmp62_;
	gboolean _tmp63_;
	ValaCodeContext* _tmp64_;
	const gchar* _tmp65_;
	gboolean _tmp66_ = FALSE;
	const gchar* _tmp67_;
	ValaCodeContext* _tmp69_;
	gboolean _tmp70_;
	ValaCodeContext* _tmp71_;
	const gchar* _tmp72_;
	ValaCodeContext* _tmp73_;
	const gchar* _tmp74_;
	ValaCodeContext* _tmp75_;
	const gchar* _tmp76_;
	ValaCodeContext* _tmp77_;
	const gchar* _tmp78_;
	gboolean _tmp79_ = FALSE;
	const gchar* _tmp80_;
	const gchar* _tmp82_;
	const gchar* _tmp90_;
	ValaCodeContext* _tmp99_;
	gchar** _tmp100_;
	gint _tmp100__length1;
	gchar** _tmp101_;
	gint _tmp101__length1;
	ValaCodeContext* _tmp102_;
	gboolean _tmp103_;
	ValaCodeContext* _tmp104_;
	gchar** _tmp105_;
	gint _tmp105__length1;
	gchar** _tmp106_;
	gint _tmp106__length1;
	ValaCodeContext* _tmp107_;
	gchar** _tmp108_;
	gint _tmp108__length1;
	gchar** _tmp109_;
	gint _tmp109__length1;
	ValaCodeContext* _tmp110_;
	gboolean _tmp111_;
	ValaCodeContext* _tmp112_;
	gboolean _tmp113_;
	ValaCodeContext* _tmp114_;
	gboolean _tmp115_;
	gboolean _tmp116_ = FALSE;
	gboolean _tmp117_;
	gboolean _tmp119_ = FALSE;
	gboolean _tmp120_ = FALSE;
	const gchar* _tmp121_;
	gboolean _tmp129_;
	const gchar* _tmp130_;
	ValaCodeContext* _tmp131_;
	gboolean _tmp132_;
	ValaCodeContext* _tmp133_;
	const gchar* _tmp134_;
	ValaCodeContext* _tmp135_;
	gboolean _tmp136_;
	const gchar* _tmp137_;
	ValaCodeContext* _tmp141_;
	const gchar* _tmp142_;
	gchar** _tmp143_;
	gint _tmp143__length1;
	gint glib_major = 0;
	gint glib_minor = 0;
	gboolean _tmp155_ = FALSE;
	const gchar* _tmp156_;
	ValaCodeContext* _tmp161_;
	gint _tmp162_;
	ValaCodeContext* _tmp163_;
	gint _tmp164_;
	ValaCodeContext* _tmp165_;
	gint _tmp166_;
	gint _tmp167_;
	gboolean _tmp176_;
	gchar** _tmp179_;
	gint _tmp179__length1;
	gchar** _tmp184_;
	gint _tmp184__length1;
	ValaCodeContext* _tmp195_;
	gchar** _tmp196_;
	gint _tmp196__length1;
	gchar** _tmp197_;
	gint _tmp197__length1;
	ValaCodeContext* _tmp198_;
	gchar** _tmp199_;
	gint _tmp199__length1;
	gchar** _tmp200_;
	gint _tmp200__length1;
	gboolean _tmp201_ = FALSE;
	ValaCodeContext* _tmp202_;
	ValaReport* _tmp203_;
	ValaReport* _tmp204_;
	gint _tmp205_;
	ValaCodeContext* _tmp213_;
	ValaGDBusServerModule* _tmp214_;
	ValaGDBusServerModule* _tmp215_;
	gboolean has_c_files = FALSE;
	gboolean has_h_files = FALSE;
	gchar** _tmp216_;
	gint _tmp216__length1;
	gboolean _tmp226_ = FALSE;
	gboolean _tmp227_;
	gboolean _tmp231_ = FALSE;
	ValaCodeContext* _tmp232_;
	ValaReport* _tmp233_;
	ValaReport* _tmp234_;
	gint _tmp235_;
	ValaParser* parser = NULL;
	ValaParser* _tmp243_;
	ValaParser* _tmp244_;
	ValaCodeContext* _tmp245_;
	ValaGenieParser* genie_parser = NULL;
	ValaGenieParser* _tmp246_;
	ValaGenieParser* _tmp247_;
	ValaCodeContext* _tmp248_;
	ValaGirParser* gir_parser = NULL;
	ValaGirParser* _tmp249_;
	ValaGirParser* _tmp250_;
	ValaCodeContext* _tmp251_;
	gboolean _tmp252_ = FALSE;
	ValaCodeContext* _tmp253_;
	ValaReport* _tmp254_;
	ValaReport* _tmp255_;
	gint _tmp256_;
	const gchar* _tmp264_;
	ValaCodeContext* _tmp270_;
	gboolean _tmp271_ = FALSE;
	ValaCodeContext* _tmp272_;
	ValaReport* _tmp273_;
	ValaReport* _tmp274_;
	gint _tmp275_;
	gboolean _tmp283_ = FALSE;
	gboolean _tmp284_ = FALSE;
	gboolean _tmp285_;
	const gchar* _tmp293_;
	gboolean _tmp298_ = FALSE;
	ValaCodeContext* _tmp299_;
	ValaReport* _tmp300_;
	ValaReport* _tmp301_;
	gint _tmp302_;
	ValaCodeContext* _tmp310_;
	ValaCodeGenerator* _tmp311_;
	ValaCodeGenerator* _tmp312_;
	ValaCodeContext* _tmp313_;
	gboolean _tmp314_ = FALSE;
	ValaCodeContext* _tmp315_;
	ValaReport* _tmp316_;
	ValaReport* _tmp317_;
	gint _tmp318_;
	gboolean _tmp326_ = FALSE;
	const gchar* _tmp327_;
	const gchar* _tmp331_;
	const gchar* _tmp385_;
	const gchar* _tmp399_;
	const gchar* _tmp444_;
	gboolean _tmp447_ = FALSE;
	ValaCodeContext* _tmp448_;
	ValaReport* _tmp449_;
	ValaReport* _tmp450_;
	gint _tmp451_;
	gboolean _tmp459_;
	gint _tmp476_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = vala_code_context_new ();
	_vala_code_context_unref0 (self->priv->context);
	self->priv->context = _tmp0_;
	_tmp1_ = self->priv->context;
	vala_code_context_push (_tmp1_);
	_tmp2_ = vala_compiler_disable_diagnostic_colors;
	if (_tmp2_ == FALSE) {
		const gchar* env_colors = NULL;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = g_getenv ("VALA_COLORS");
		env_colors = _tmp3_;
		_tmp4_ = env_colors;
		if (_tmp4_ != NULL) {
			ValaCodeContext* _tmp5_;
			ValaReport* _tmp6_;
			ValaReport* _tmp7_;
			const gchar* _tmp8_;
			_tmp5_ = self->priv->context;
			_tmp6_ = vala_code_context_get_report (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = env_colors;
			vala_report_set_colors (_tmp7_, _tmp8_);
		} else {
			ValaCodeContext* _tmp9_;
			ValaReport* _tmp10_;
			ValaReport* _tmp11_;
			_tmp9_ = self->priv->context;
			_tmp10_ = vala_code_context_get_report (_tmp9_);
			_tmp11_ = _tmp10_;
			vala_report_set_colors (_tmp11_, VALA_COMPILER_DEFAULT_COLORS);
		}
	}
	_tmp14_ = vala_compiler_ccode_only;
	if (!_tmp14_) {
		gboolean _tmp15_;
		_tmp15_ = vala_compiler_compile_only;
		_tmp13_ = !_tmp15_;
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		const gchar* _tmp16_;
		_tmp16_ = vala_compiler_output;
		_tmp12_ = _tmp16_ == NULL;
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		gchar** _tmp17_;
		gint _tmp17__length1;
		const gchar* _tmp18_;
		gint _tmp19_;
		_tmp17_ = vala_compiler_sources;
		_tmp17__length1 = _vala_array_length (vala_compiler_sources);
		_tmp18_ = _tmp17_[0];
		_tmp19_ = string_last_index_of_char (_tmp18_, (gunichar) '.', 0);
		if (_tmp19_ != -1) {
			gint dot = 0;
			gchar** _tmp20_;
			gint _tmp20__length1;
			const gchar* _tmp21_;
			gint _tmp22_;
			gchar** _tmp23_;
			gint _tmp23__length1;
			const gchar* _tmp24_;
			gint _tmp25_;
			gchar* _tmp26_;
			gchar* _tmp27_;
			gchar* _tmp28_;
			_tmp20_ = vala_compiler_sources;
			_tmp20__length1 = _vala_array_length (vala_compiler_sources);
			_tmp21_ = _tmp20_[0];
			_tmp22_ = string_last_index_of_char (_tmp21_, (gunichar) '.', 0);
			dot = _tmp22_;
			_tmp23_ = vala_compiler_sources;
			_tmp23__length1 = _vala_array_length (vala_compiler_sources);
			_tmp24_ = _tmp23_[0];
			_tmp25_ = dot;
			_tmp26_ = string_substring (_tmp24_, (glong) 0, (glong) _tmp25_);
			_tmp27_ = _tmp26_;
			_tmp28_ = g_path_get_basename (_tmp27_);
			_g_free0 (vala_compiler_output);
			vala_compiler_output = _tmp28_;
			_g_free0 (_tmp27_);
		}
	}
	_tmp29_ = self->priv->context;
	_tmp30_ = vala_compiler_disable_assert;
	vala_code_context_set_assert (_tmp29_, !_tmp30_);
	_tmp31_ = self->priv->context;
	_tmp32_ = vala_compiler_enable_checking;
	vala_code_context_set_checking (_tmp31_, _tmp32_);
	_tmp33_ = self->priv->context;
	_tmp34_ = vala_compiler_deprecated;
	vala_code_context_set_deprecated (_tmp33_, _tmp34_);
	_tmp35_ = self->priv->context;
	_tmp36_ = vala_compiler_disable_since_check;
	vala_code_context_set_since_check (_tmp35_, !_tmp36_);
	_tmp37_ = self->priv->context;
	_tmp38_ = vala_compiler_hide_internal;
	vala_code_context_set_hide_internal (_tmp37_, _tmp38_);
	_tmp39_ = self->priv->context;
	_tmp40_ = vala_compiler_experimental;
	vala_code_context_set_experimental (_tmp39_, _tmp40_);
	_tmp41_ = self->priv->context;
	_tmp42_ = vala_compiler_experimental_non_null;
	vala_code_context_set_experimental_non_null (_tmp41_, _tmp42_);
	_tmp43_ = self->priv->context;
	_tmp44_ = vala_compiler_gobject_tracing;
	vala_code_context_set_gobject_tracing (_tmp43_, _tmp44_);
	_tmp45_ = self->priv->context;
	_tmp46_ = vala_code_context_get_report (_tmp45_);
	_tmp47_ = _tmp46_;
	_tmp48_ = vala_compiler_disable_warnings;
	vala_report_set_enable_warnings (_tmp47_, !_tmp48_);
	_tmp49_ = self->priv->context;
	_tmp50_ = vala_code_context_get_report (_tmp49_);
	_tmp51_ = _tmp50_;
	_tmp52_ = vala_compiler_quiet_mode;
	vala_report_set_verbose_errors (_tmp51_, !_tmp52_);
	_tmp53_ = self->priv->context;
	_tmp54_ = vala_compiler_verbose_mode;
	vala_code_context_set_verbose_mode (_tmp53_, _tmp54_);
	_tmp55_ = self->priv->context;
	_tmp56_ = vala_compiler_disable_version_header;
	vala_code_context_set_version_header (_tmp55_, !_tmp56_);
	_tmp57_ = self->priv->context;
	_tmp58_ = vala_compiler_ccode_only;
	vala_code_context_set_ccode_only (_tmp57_, _tmp58_);
	_tmp60_ = vala_compiler_ccode_only;
	if (_tmp60_) {
		gchar** _tmp61_;
		gint _tmp61__length1;
		_tmp61_ = vala_compiler_cc_options;
		_tmp61__length1 = _vala_array_length (vala_compiler_cc_options);
		_tmp59_ = _tmp61_ != NULL;
	} else {
		_tmp59_ = FALSE;
	}
	if (_tmp59_) {
		vala_report_warning (NULL, "-X has no effect when -C or --ccode is set");
	}
	_tmp62_ = self->priv->context;
	_tmp63_ = vala_compiler_compile_only;
	vala_code_context_set_compile_only (_tmp62_, _tmp63_);
	_tmp64_ = self->priv->context;
	_tmp65_ = vala_compiler_header_filename;
	vala_code_context_set_header_filename (_tmp64_, _tmp65_);
	_tmp67_ = vala_compiler_header_filename;
	if (_tmp67_ == NULL) {
		gboolean _tmp68_;
		_tmp68_ = vala_compiler_use_header;
		_tmp66_ = _tmp68_;
	} else {
		_tmp66_ = FALSE;
	}
	if (_tmp66_) {
		vala_report_error (NULL, "--use-header may only be used in combination with --header");
	}
	_tmp69_ = self->priv->context;
	_tmp70_ = vala_compiler_use_header;
	vala_code_context_set_use_header (_tmp69_, _tmp70_);
	_tmp71_ = self->priv->context;
	_tmp72_ = vala_compiler_internal_header_filename;
	vala_code_context_set_internal_header_filename (_tmp71_, _tmp72_);
	_tmp73_ = self->priv->context;
	_tmp74_ = vala_compiler_symbols_filename;
	vala_code_context_set_symbols_filename (_tmp73_, _tmp74_);
	_tmp75_ = self->priv->context;
	_tmp76_ = vala_compiler_includedir;
	vala_code_context_set_includedir (_tmp75_, _tmp76_);
	_tmp77_ = self->priv->context;
	_tmp78_ = vala_compiler_output;
	vala_code_context_set_output (_tmp77_, _tmp78_);
	_tmp80_ = vala_compiler_output;
	if (_tmp80_ != NULL) {
		gboolean _tmp81_;
		_tmp81_ = vala_compiler_ccode_only;
		_tmp79_ = _tmp81_;
	} else {
		_tmp79_ = FALSE;
	}
	if (_tmp79_) {
		vala_report_warning (NULL, "--output and -o have no effect when -C or --ccode is set");
	}
	_tmp82_ = vala_compiler_basedir;
	if (_tmp82_ == NULL) {
		ValaCodeContext* _tmp83_;
		gchar* _tmp84_;
		gchar* _tmp85_;
		_tmp83_ = self->priv->context;
		_tmp84_ = vala_code_context_realpath (".");
		_tmp85_ = _tmp84_;
		vala_code_context_set_basedir (_tmp83_, _tmp85_);
		_g_free0 (_tmp85_);
	} else {
		ValaCodeContext* _tmp86_;
		const gchar* _tmp87_;
		gchar* _tmp88_;
		gchar* _tmp89_;
		_tmp86_ = self->priv->context;
		_tmp87_ = vala_compiler_basedir;
		_tmp88_ = vala_code_context_realpath (_tmp87_);
		_tmp89_ = _tmp88_;
		vala_code_context_set_basedir (_tmp86_, _tmp89_);
		_g_free0 (_tmp89_);
	}
	_tmp90_ = vala_compiler_directory;
	if (_tmp90_ != NULL) {
		ValaCodeContext* _tmp91_;
		const gchar* _tmp92_;
		gchar* _tmp93_;
		gchar* _tmp94_;
		_tmp91_ = self->priv->context;
		_tmp92_ = vala_compiler_directory;
		_tmp93_ = vala_code_context_realpath (_tmp92_);
		_tmp94_ = _tmp93_;
		vala_code_context_set_directory (_tmp91_, _tmp94_);
		_g_free0 (_tmp94_);
	} else {
		ValaCodeContext* _tmp95_;
		ValaCodeContext* _tmp96_;
		const gchar* _tmp97_;
		const gchar* _tmp98_;
		_tmp95_ = self->priv->context;
		_tmp96_ = self->priv->context;
		_tmp97_ = vala_code_context_get_basedir (_tmp96_);
		_tmp98_ = _tmp97_;
		vala_code_context_set_directory (_tmp95_, _tmp98_);
	}
	_tmp99_ = self->priv->context;
	_tmp100_ = vala_compiler_vapi_directories;
	_tmp100__length1 = _vala_array_length (vala_compiler_vapi_directories);
	_tmp101_ = (_tmp100_ != NULL) ? _vala_array_dup1 (_tmp100_, _tmp100__length1) : ((gpointer) _tmp100_);
	_tmp101__length1 = _tmp100__length1;
	_tmp99_->vapi_directories = (_vala_array_free (_tmp99_->vapi_directories, _tmp99_->vapi_directories_length1, (GDestroyNotify) g_free), NULL);
	_tmp99_->vapi_directories = _tmp101_;
	_tmp99_->vapi_directories_length1 = _tmp101__length1;
	_tmp102_ = self->priv->context;
	_tmp103_ = vala_compiler_vapi_comments;
	vala_code_context_set_vapi_comments (_tmp102_, _tmp103_);
	_tmp104_ = self->priv->context;
	_tmp105_ = vala_compiler_gir_directories;
	_tmp105__length1 = _vala_array_length (vala_compiler_gir_directories);
	_tmp106_ = (_tmp105_ != NULL) ? _vala_array_dup2 (_tmp105_, _tmp105__length1) : ((gpointer) _tmp105_);
	_tmp106__length1 = _tmp105__length1;
	_tmp104_->gir_directories = (_vala_array_free (_tmp104_->gir_directories, _tmp104_->gir_directories_length1, (GDestroyNotify) g_free), NULL);
	_tmp104_->gir_directories = _tmp106_;
	_tmp104_->gir_directories_length1 = _tmp106__length1;
	_tmp107_ = self->priv->context;
	_tmp108_ = vala_compiler_metadata_directories;
	_tmp108__length1 = _vala_array_length (vala_compiler_metadata_directories);
	_tmp109_ = (_tmp108_ != NULL) ? _vala_array_dup3 (_tmp108_, _tmp108__length1) : ((gpointer) _tmp108_);
	_tmp109__length1 = _tmp108__length1;
	_tmp107_->metadata_directories = (_vala_array_free (_tmp107_->metadata_directories, _tmp107_->metadata_directories_length1, (GDestroyNotify) g_free), NULL);
	_tmp107_->metadata_directories = _tmp109_;
	_tmp107_->metadata_directories_length1 = _tmp109__length1;
	_tmp110_ = self->priv->context;
	_tmp111_ = vala_compiler_debug;
	vala_code_context_set_debug (_tmp110_, _tmp111_);
	_tmp112_ = self->priv->context;
	_tmp113_ = vala_compiler_mem_profiler;
	vala_code_context_set_mem_profiler (_tmp112_, _tmp113_);
	_tmp114_ = self->priv->context;
	_tmp115_ = vala_compiler_save_temps;
	vala_code_context_set_save_temps (_tmp114_, _tmp115_);
	_tmp117_ = vala_compiler_ccode_only;
	if (_tmp117_) {
		gboolean _tmp118_;
		_tmp118_ = vala_compiler_save_temps;
		_tmp116_ = _tmp118_;
	} else {
		_tmp116_ = FALSE;
	}
	if (_tmp116_) {
		vala_report_warning (NULL, "--save-temps has no effect when -C or --ccode is set");
	}
	_tmp121_ = vala_compiler_profile;
	if (g_strcmp0 (_tmp121_, "gobject-2.0") == 0) {
		_tmp120_ = TRUE;
	} else {
		const gchar* _tmp122_;
		_tmp122_ = vala_compiler_profile;
		_tmp120_ = g_strcmp0 (_tmp122_, "gobject") == 0;
	}
	if (_tmp120_) {
		_tmp119_ = TRUE;
	} else {
		const gchar* _tmp123_;
		_tmp123_ = vala_compiler_profile;
		_tmp119_ = _tmp123_ == NULL;
	}
	if (_tmp119_) {
		ValaCodeContext* _tmp124_;
		ValaCodeContext* _tmp125_;
		_tmp124_ = self->priv->context;
		vala_code_context_set_profile (_tmp124_, VALA_PROFILE_GOBJECT);
		_tmp125_ = self->priv->context;
		vala_code_context_add_define (_tmp125_, "GOBJECT");
	} else {
		const gchar* _tmp126_;
		gchar* _tmp127_;
		gchar* _tmp128_;
		_tmp126_ = vala_compiler_profile;
		_tmp127_ = g_strdup_printf ("Unknown profile %s", _tmp126_);
		_tmp128_ = _tmp127_;
		vala_report_error (NULL, _tmp128_);
		_g_free0 (_tmp128_);
	}
	_tmp129_ = vala_compiler_nostdpkg;
	_tmp130_ = vala_compiler_fast_vapi_filename;
	vala_compiler_nostdpkg = _tmp129_ | (_tmp130_ != NULL);
	_tmp131_ = self->priv->context;
	_tmp132_ = vala_compiler_nostdpkg;
	vala_code_context_set_nostdpkg (_tmp131_, _tmp132_);
	_tmp133_ = self->priv->context;
	_tmp134_ = vala_compiler_entry_point;
	vala_code_context_set_entry_point_name (_tmp133_, _tmp134_);
	_tmp135_ = self->priv->context;
	_tmp136_ = vala_compiler_run_output;
	vala_code_context_set_run_output (_tmp135_, _tmp136_);
	_tmp137_ = vala_compiler_pkg_config_command;
	if (_tmp137_ == NULL) {
		const gchar* _tmp138_ = NULL;
		const gchar* _tmp139_;
		gchar* _tmp140_;
		_tmp139_ = g_getenv ("PKG_CONFIG");
		_tmp138_ = _tmp139_;
		if (_tmp138_ == NULL) {
			_tmp138_ = "pkg-config";
		}
		_tmp140_ = g_strdup (_tmp138_);
		_g_free0 (vala_compiler_pkg_config_command);
		vala_compiler_pkg_config_command = _tmp140_;
	}
	_tmp141_ = self->priv->context;
	_tmp142_ = vala_compiler_pkg_config_command;
	vala_code_context_set_pkg_config_command (_tmp141_, _tmp142_);
	_tmp143_ = vala_compiler_defines;
	_tmp143__length1 = _vala_array_length (vala_compiler_defines);
	if (_tmp143_ != NULL) {
		gchar** _tmp144_;
		gint _tmp144__length1;
		_tmp144_ = vala_compiler_defines;
		_tmp144__length1 = _vala_array_length (vala_compiler_defines);
		{
			gchar** define_collection = NULL;
			gint define_collection_length1 = 0;
			gint _define_collection_size_ = 0;
			gint define_it = 0;
			define_collection = _tmp144_;
			define_collection_length1 = _tmp144__length1;
			for (define_it = 0; define_it < define_collection_length1; define_it = define_it + 1) {
				gchar* _tmp145_;
				gchar* define = NULL;
				_tmp145_ = g_strdup (define_collection[define_it]);
				define = _tmp145_;
				{
					ValaCodeContext* _tmp146_;
					const gchar* _tmp147_;
					_tmp146_ = self->priv->context;
					_tmp147_ = define;
					vala_code_context_add_define (_tmp146_, _tmp147_);
					_g_free0 (define);
				}
			}
		}
	}
	{
		gint i = 0;
		i = 2;
		{
			gboolean _tmp148_ = FALSE;
			_tmp148_ = TRUE;
			while (TRUE) {
				gint _tmp150_;
				ValaCodeContext* _tmp151_;
				gint _tmp152_;
				gchar* _tmp153_;
				gchar* _tmp154_;
				if (!_tmp148_) {
					gint _tmp149_;
					_tmp149_ = i;
					i = _tmp149_ + 2;
				}
				_tmp148_ = FALSE;
				_tmp150_ = i;
				if (!(_tmp150_ <= 36)) {
					break;
				}
				_tmp151_ = self->priv->context;
				_tmp152_ = i;
				_tmp153_ = g_strdup_printf ("VALA_0_%d", _tmp152_);
				_tmp154_ = _tmp153_;
				vala_code_context_add_define (_tmp151_, _tmp154_);
				_g_free0 (_tmp154_);
			}
		}
	}
	glib_major = 2;
	glib_minor = 32;
	_tmp156_ = vala_compiler_target_glib;
	if (_tmp156_ != NULL) {
		const gchar* _tmp157_;
		gint _tmp158_ = 0;
		gint _tmp159_ = 0;
		gint _tmp160_;
		_tmp157_ = vala_compiler_target_glib;
		_tmp160_ = sscanf (_tmp157_, "%d.%d", &_tmp158_, &_tmp159_);
		glib_major = _tmp158_;
		glib_minor = _tmp159_;
		_tmp155_ = _tmp160_ != 2;
	} else {
		_tmp155_ = FALSE;
	}
	if (_tmp155_) {
		vala_report_error (NULL, "Invalid format for --target-glib");
	}
	_tmp161_ = self->priv->context;
	_tmp162_ = glib_major;
	vala_code_context_set_target_glib_major (_tmp161_, _tmp162_);
	_tmp163_ = self->priv->context;
	_tmp164_ = glib_minor;
	vala_code_context_set_target_glib_minor (_tmp163_, _tmp164_);
	_tmp165_ = self->priv->context;
	_tmp166_ = vala_code_context_get_target_glib_major (_tmp165_);
	_tmp167_ = _tmp166_;
	if (_tmp167_ != 2) {
		vala_report_error (NULL, "This version of valac only supports GLib 2");
	}
	{
		gint i = 0;
		i = 16;
		{
			gboolean _tmp168_ = FALSE;
			_tmp168_ = TRUE;
			while (TRUE) {
				gint _tmp170_;
				gint _tmp171_;
				ValaCodeContext* _tmp172_;
				gint _tmp173_;
				gchar* _tmp174_;
				gchar* _tmp175_;
				if (!_tmp168_) {
					gint _tmp169_;
					_tmp169_ = i;
					i = _tmp169_ + 2;
				}
				_tmp168_ = FALSE;
				_tmp170_ = i;
				_tmp171_ = glib_minor;
				if (!(_tmp170_ <= _tmp171_)) {
					break;
				}
				_tmp172_ = self->priv->context;
				_tmp173_ = i;
				_tmp174_ = g_strdup_printf ("GLIB_2_%d", _tmp173_);
				_tmp175_ = _tmp174_;
				vala_code_context_add_define (_tmp172_, _tmp175_);
				_g_free0 (_tmp175_);
			}
		}
	}
	_tmp176_ = vala_compiler_nostdpkg;
	if (!_tmp176_) {
		ValaCodeContext* _tmp177_;
		ValaCodeContext* _tmp178_;
		_tmp177_ = self->priv->context;
		vala_code_context_add_external_package (_tmp177_, "glib-2.0");
		_tmp178_ = self->priv->context;
		vala_code_context_add_external_package (_tmp178_, "gobject-2.0");
	}
	_tmp179_ = vala_compiler_packages;
	_tmp179__length1 = _vala_array_length (vala_compiler_packages);
	if (_tmp179_ != NULL) {
		gchar** _tmp180_;
		gint _tmp180__length1;
		_tmp180_ = vala_compiler_packages;
		_tmp180__length1 = _vala_array_length (vala_compiler_packages);
		{
			gchar** package_collection = NULL;
			gint package_collection_length1 = 0;
			gint _package_collection_size_ = 0;
			gint package_it = 0;
			package_collection = _tmp180_;
			package_collection_length1 = _tmp180__length1;
			for (package_it = 0; package_it < package_collection_length1; package_it = package_it + 1) {
				gchar* _tmp181_;
				gchar* package = NULL;
				_tmp181_ = g_strdup (package_collection[package_it]);
				package = _tmp181_;
				{
					ValaCodeContext* _tmp182_;
					const gchar* _tmp183_;
					_tmp182_ = self->priv->context;
					_tmp183_ = package;
					vala_code_context_add_external_package (_tmp182_, _tmp183_);
					_g_free0 (package);
				}
			}
		}
		vala_compiler_packages = (_vala_array_free (vala_compiler_packages, _vala_array_length (vala_compiler_packages), (GDestroyNotify) g_free), NULL);
		vala_compiler_packages = NULL;
	}
	_tmp184_ = vala_compiler_fast_vapis;
	_tmp184__length1 = _vala_array_length (vala_compiler_fast_vapis);
	if (_tmp184_ != NULL) {
		gchar** _tmp185_;
		gint _tmp185__length1;
		ValaCodeContext* _tmp194_;
		_tmp185_ = vala_compiler_fast_vapis;
		_tmp185__length1 = _vala_array_length (vala_compiler_fast_vapis);
		{
			gchar** vapi_collection = NULL;
			gint vapi_collection_length1 = 0;
			gint _vapi_collection_size_ = 0;
			gint vapi_it = 0;
			vapi_collection = _tmp185_;
			vapi_collection_length1 = _tmp185__length1;
			for (vapi_it = 0; vapi_it < vapi_collection_length1; vapi_it = vapi_it + 1) {
				gchar* _tmp186_;
				gchar* vapi = NULL;
				_tmp186_ = g_strdup (vapi_collection[vapi_it]);
				vapi = _tmp186_;
				{
					gchar* rpath = NULL;
					const gchar* _tmp187_;
					gchar* _tmp188_;
					ValaSourceFile* source_file = NULL;
					ValaCodeContext* _tmp189_;
					const gchar* _tmp190_;
					ValaSourceFile* _tmp191_;
					ValaCodeContext* _tmp192_;
					ValaSourceFile* _tmp193_;
					_tmp187_ = vapi;
					_tmp188_ = vala_code_context_realpath (_tmp187_);
					rpath = _tmp188_;
					_tmp189_ = self->priv->context;
					_tmp190_ = rpath;
					_tmp191_ = vala_source_file_new (_tmp189_, VALA_SOURCE_FILE_TYPE_FAST, _tmp190_, NULL, FALSE);
					source_file = _tmp191_;
					_tmp192_ = self->priv->context;
					_tmp193_ = source_file;
					vala_code_context_add_source_file (_tmp192_, _tmp193_);
					_vala_source_file_unref0 (source_file);
					_g_free0 (rpath);
					_g_free0 (vapi);
				}
			}
		}
		_tmp194_ = self->priv->context;
		vala_code_context_set_use_fast_vapi (_tmp194_, TRUE);
	}
	_tmp195_ = self->priv->context;
	_tmp196_ = vala_compiler_gresources;
	_tmp196__length1 = _vala_array_length (vala_compiler_gresources);
	_tmp197_ = (_tmp196_ != NULL) ? _vala_array_dup4 (_tmp196_, _tmp196__length1) : ((gpointer) _tmp196_);
	_tmp197__length1 = _tmp196__length1;
	_tmp195_->gresources = (_vala_array_free (_tmp195_->gresources, _tmp195_->gresources_length1, (GDestroyNotify) g_free), NULL);
	_tmp195_->gresources = _tmp197_;
	_tmp195_->gresources_length1 = _tmp197__length1;
	_tmp198_ = self->priv->context;
	_tmp199_ = vala_compiler_gresources_directories;
	_tmp199__length1 = _vala_array_length (vala_compiler_gresources_directories);
	_tmp200_ = (_tmp199_ != NULL) ? _vala_array_dup5 (_tmp199_, _tmp199__length1) : ((gpointer) _tmp199_);
	_tmp200__length1 = _tmp199__length1;
	_tmp198_->gresources_directories = (_vala_array_free (_tmp198_->gresources_directories, _tmp198_->gresources_directories_length1, (GDestroyNotify) g_free), NULL);
	_tmp198_->gresources_directories = _tmp200_;
	_tmp198_->gresources_directories_length1 = _tmp200__length1;
	_tmp202_ = self->priv->context;
	_tmp203_ = vala_code_context_get_report (_tmp202_);
	_tmp204_ = _tmp203_;
	_tmp205_ = vala_report_get_errors (_tmp204_);
	if (_tmp205_ > 0) {
		_tmp201_ = TRUE;
	} else {
		gboolean _tmp206_ = FALSE;
		gboolean _tmp207_;
		_tmp207_ = vala_compiler_fatal_warnings;
		if (_tmp207_) {
			ValaCodeContext* _tmp208_;
			ValaReport* _tmp209_;
			ValaReport* _tmp210_;
			gint _tmp211_;
			_tmp208_ = self->priv->context;
			_tmp209_ = vala_code_context_get_report (_tmp208_);
			_tmp210_ = _tmp209_;
			_tmp211_ = vala_report_get_warnings (_tmp210_);
			_tmp206_ = _tmp211_ > 0;
		} else {
			_tmp206_ = FALSE;
		}
		_tmp201_ = _tmp206_;
	}
	if (_tmp201_) {
		gint _tmp212_;
		_tmp212_ = vala_compiler_quit (self);
		result = _tmp212_;
		return result;
	}
	_tmp213_ = self->priv->context;
	_tmp214_ = vala_gd_bus_server_module_new ();
	_tmp215_ = _tmp214_;
	vala_code_context_set_codegen (_tmp213_, (ValaCodeGenerator*) _tmp215_);
	_vala_code_visitor_unref0 (_tmp215_);
	has_c_files = FALSE;
	has_h_files = FALSE;
	_tmp216_ = vala_compiler_sources;
	_tmp216__length1 = _vala_array_length (vala_compiler_sources);
	{
		gchar** source_collection = NULL;
		gint source_collection_length1 = 0;
		gint _source_collection_size_ = 0;
		gint source_it = 0;
		source_collection = _tmp216_;
		source_collection_length1 = _tmp216__length1;
		for (source_it = 0; source_it < source_collection_length1; source_it = source_it + 1) {
			gchar* _tmp217_;
			gchar* source = NULL;
			_tmp217_ = g_strdup (source_collection[source_it]);
			source = _tmp217_;
			{
				ValaCodeContext* _tmp218_;
				const gchar* _tmp219_;
				gboolean _tmp220_;
				gboolean _tmp221_;
				_tmp218_ = self->priv->context;
				_tmp219_ = source;
				_tmp220_ = vala_compiler_run_output;
				_tmp221_ = vala_code_context_add_source_filename (_tmp218_, _tmp219_, _tmp220_, TRUE);
				if (_tmp221_) {
					const gchar* _tmp222_;
					gboolean _tmp223_;
					_tmp222_ = source;
					_tmp223_ = g_str_has_suffix (_tmp222_, ".c");
					if (_tmp223_) {
						has_c_files = TRUE;
					} else {
						const gchar* _tmp224_;
						gboolean _tmp225_;
						_tmp224_ = source;
						_tmp225_ = g_str_has_suffix (_tmp224_, ".h");
						if (_tmp225_) {
							has_h_files = TRUE;
						}
					}
				}
				_g_free0 (source);
			}
		}
	}
	vala_compiler_sources = (_vala_array_free (vala_compiler_sources, _vala_array_length (vala_compiler_sources), (GDestroyNotify) g_free), NULL);
	vala_compiler_sources = NULL;
	_tmp227_ = vala_compiler_ccode_only;
	if (_tmp227_) {
		gboolean _tmp228_ = FALSE;
		gboolean _tmp229_;
		_tmp229_ = has_c_files;
		if (_tmp229_) {
			_tmp228_ = TRUE;
		} else {
			gboolean _tmp230_;
			_tmp230_ = has_h_files;
			_tmp228_ = _tmp230_;
		}
		_tmp226_ = _tmp228_;
	} else {
		_tmp226_ = FALSE;
	}
	if (_tmp226_) {
		vala_report_warning (NULL, "C header and source files are ignored when -C or --ccode is set");
	}
	_tmp232_ = self->priv->context;
	_tmp233_ = vala_code_context_get_report (_tmp232_);
	_tmp234_ = _tmp233_;
	_tmp235_ = vala_report_get_errors (_tmp234_);
	if (_tmp235_ > 0) {
		_tmp231_ = TRUE;
	} else {
		gboolean _tmp236_ = FALSE;
		gboolean _tmp237_;
		_tmp237_ = vala_compiler_fatal_warnings;
		if (_tmp237_) {
			ValaCodeContext* _tmp238_;
			ValaReport* _tmp239_;
			ValaReport* _tmp240_;
			gint _tmp241_;
			_tmp238_ = self->priv->context;
			_tmp239_ = vala_code_context_get_report (_tmp238_);
			_tmp240_ = _tmp239_;
			_tmp241_ = vala_report_get_warnings (_tmp240_);
			_tmp236_ = _tmp241_ > 0;
		} else {
			_tmp236_ = FALSE;
		}
		_tmp231_ = _tmp236_;
	}
	if (_tmp231_) {
		gint _tmp242_;
		_tmp242_ = vala_compiler_quit (self);
		result = _tmp242_;
		return result;
	}
	_tmp243_ = vala_parser_new ();
	parser = _tmp243_;
	_tmp244_ = parser;
	_tmp245_ = self->priv->context;
	vala_parser_parse (_tmp244_, _tmp245_);
	_tmp246_ = vala_genie_parser_new ();
	genie_parser = _tmp246_;
	_tmp247_ = genie_parser;
	_tmp248_ = self->priv->context;
	vala_genie_parser_parse (_tmp247_, _tmp248_);
	_tmp249_ = vala_gir_parser_new ();
	gir_parser = _tmp249_;
	_tmp250_ = gir_parser;
	_tmp251_ = self->priv->context;
	vala_gir_parser_parse (_tmp250_, _tmp251_);
	_tmp253_ = self->priv->context;
	_tmp254_ = vala_code_context_get_report (_tmp253_);
	_tmp255_ = _tmp254_;
	_tmp256_ = vala_report_get_errors (_tmp255_);
	if (_tmp256_ > 0) {
		_tmp252_ = TRUE;
	} else {
		gboolean _tmp257_ = FALSE;
		gboolean _tmp258_;
		_tmp258_ = vala_compiler_fatal_warnings;
		if (_tmp258_) {
			ValaCodeContext* _tmp259_;
			ValaReport* _tmp260_;
			ValaReport* _tmp261_;
			gint _tmp262_;
			_tmp259_ = self->priv->context;
			_tmp260_ = vala_code_context_get_report (_tmp259_);
			_tmp261_ = _tmp260_;
			_tmp262_ = vala_report_get_warnings (_tmp261_);
			_tmp257_ = _tmp262_ > 0;
		} else {
			_tmp257_ = FALSE;
		}
		_tmp252_ = _tmp257_;
	}
	if (_tmp252_) {
		gint _tmp263_;
		_tmp263_ = vala_compiler_quit (self);
		result = _tmp263_;
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp264_ = vala_compiler_fast_vapi_filename;
	if (_tmp264_ != NULL) {
		ValaCodeWriter* interface_writer = NULL;
		ValaCodeWriter* _tmp265_;
		ValaCodeWriter* _tmp266_;
		ValaCodeContext* _tmp267_;
		const gchar* _tmp268_;
		gint _tmp269_;
		_tmp265_ = vala_code_writer_new (VALA_CODE_WRITER_TYPE_FAST);
		interface_writer = _tmp265_;
		_tmp266_ = interface_writer;
		_tmp267_ = self->priv->context;
		_tmp268_ = vala_compiler_fast_vapi_filename;
		vala_code_writer_write_file (_tmp266_, _tmp267_, _tmp268_);
		_tmp269_ = vala_compiler_quit (self);
		result = _tmp269_;
		_vala_code_visitor_unref0 (interface_writer);
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp270_ = self->priv->context;
	vala_code_context_check (_tmp270_);
	_tmp272_ = self->priv->context;
	_tmp273_ = vala_code_context_get_report (_tmp272_);
	_tmp274_ = _tmp273_;
	_tmp275_ = vala_report_get_errors (_tmp274_);
	if (_tmp275_ > 0) {
		_tmp271_ = TRUE;
	} else {
		gboolean _tmp276_ = FALSE;
		gboolean _tmp277_;
		_tmp277_ = vala_compiler_fatal_warnings;
		if (_tmp277_) {
			ValaCodeContext* _tmp278_;
			ValaReport* _tmp279_;
			ValaReport* _tmp280_;
			gint _tmp281_;
			_tmp278_ = self->priv->context;
			_tmp279_ = vala_code_context_get_report (_tmp278_);
			_tmp280_ = _tmp279_;
			_tmp281_ = vala_report_get_warnings (_tmp280_);
			_tmp276_ = _tmp281_ > 0;
		} else {
			_tmp276_ = FALSE;
		}
		_tmp271_ = _tmp276_;
	}
	if (_tmp271_) {
		gint _tmp282_;
		_tmp282_ = vala_compiler_quit (self);
		result = _tmp282_;
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp285_ = vala_compiler_ccode_only;
	if (!_tmp285_) {
		gboolean _tmp286_;
		_tmp286_ = vala_compiler_compile_only;
		_tmp284_ = !_tmp286_;
	} else {
		_tmp284_ = FALSE;
	}
	if (_tmp284_) {
		const gchar* _tmp287_;
		_tmp287_ = vala_compiler_library;
		_tmp283_ = _tmp287_ == NULL;
	} else {
		_tmp283_ = FALSE;
	}
	if (_tmp283_) {
		gboolean _tmp288_ = FALSE;
		gboolean _tmp289_;
		_tmp289_ = has_c_files;
		if (!_tmp289_) {
			ValaCodeContext* _tmp290_;
			ValaMethod* _tmp291_;
			ValaMethod* _tmp292_;
			_tmp290_ = self->priv->context;
			_tmp291_ = vala_code_context_get_entry_point (_tmp290_);
			_tmp292_ = _tmp291_;
			_tmp288_ = _tmp292_ == NULL;
		} else {
			_tmp288_ = FALSE;
		}
		if (_tmp288_) {
			vala_report_error (NULL, "program does not contain a static `main' method");
		}
	}
	_tmp293_ = vala_compiler_dump_tree;
	if (_tmp293_ != NULL) {
		ValaCodeWriter* code_writer = NULL;
		ValaCodeWriter* _tmp294_;
		ValaCodeWriter* _tmp295_;
		ValaCodeContext* _tmp296_;
		const gchar* _tmp297_;
		_tmp294_ = vala_code_writer_new (VALA_CODE_WRITER_TYPE_DUMP);
		code_writer = _tmp294_;
		_tmp295_ = code_writer;
		_tmp296_ = self->priv->context;
		_tmp297_ = vala_compiler_dump_tree;
		vala_code_writer_write_file (_tmp295_, _tmp296_, _tmp297_);
		_vala_code_visitor_unref0 (code_writer);
	}
	_tmp299_ = self->priv->context;
	_tmp300_ = vala_code_context_get_report (_tmp299_);
	_tmp301_ = _tmp300_;
	_tmp302_ = vala_report_get_errors (_tmp301_);
	if (_tmp302_ > 0) {
		_tmp298_ = TRUE;
	} else {
		gboolean _tmp303_ = FALSE;
		gboolean _tmp304_;
		_tmp304_ = vala_compiler_fatal_warnings;
		if (_tmp304_) {
			ValaCodeContext* _tmp305_;
			ValaReport* _tmp306_;
			ValaReport* _tmp307_;
			gint _tmp308_;
			_tmp305_ = self->priv->context;
			_tmp306_ = vala_code_context_get_report (_tmp305_);
			_tmp307_ = _tmp306_;
			_tmp308_ = vala_report_get_warnings (_tmp307_);
			_tmp303_ = _tmp308_ > 0;
		} else {
			_tmp303_ = FALSE;
		}
		_tmp298_ = _tmp303_;
	}
	if (_tmp298_) {
		gint _tmp309_;
		_tmp309_ = vala_compiler_quit (self);
		result = _tmp309_;
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp310_ = self->priv->context;
	_tmp311_ = vala_code_context_get_codegen (_tmp310_);
	_tmp312_ = _tmp311_;
	_tmp313_ = self->priv->context;
	vala_code_generator_emit (_tmp312_, _tmp313_);
	_tmp315_ = self->priv->context;
	_tmp316_ = vala_code_context_get_report (_tmp315_);
	_tmp317_ = _tmp316_;
	_tmp318_ = vala_report_get_errors (_tmp317_);
	if (_tmp318_ > 0) {
		_tmp314_ = TRUE;
	} else {
		gboolean _tmp319_ = FALSE;
		gboolean _tmp320_;
		_tmp320_ = vala_compiler_fatal_warnings;
		if (_tmp320_) {
			ValaCodeContext* _tmp321_;
			ValaReport* _tmp322_;
			ValaReport* _tmp323_;
			gint _tmp324_;
			_tmp321_ = self->priv->context;
			_tmp322_ = vala_code_context_get_report (_tmp321_);
			_tmp323_ = _tmp322_;
			_tmp324_ = vala_report_get_warnings (_tmp323_);
			_tmp319_ = _tmp324_ > 0;
		} else {
			_tmp319_ = FALSE;
		}
		_tmp314_ = _tmp319_;
	}
	if (_tmp314_) {
		gint _tmp325_;
		_tmp325_ = vala_compiler_quit (self);
		result = _tmp325_;
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp327_ = vala_compiler_vapi_filename;
	if (_tmp327_ == NULL) {
		const gchar* _tmp328_;
		_tmp328_ = vala_compiler_library;
		_tmp326_ = _tmp328_ != NULL;
	} else {
		_tmp326_ = FALSE;
	}
	if (_tmp326_) {
		const gchar* _tmp329_;
		gchar* _tmp330_;
		_tmp329_ = vala_compiler_library;
		_tmp330_ = g_strdup_printf ("%s.vapi", _tmp329_);
		_g_free0 (vala_compiler_vapi_filename);
		vala_compiler_vapi_filename = _tmp330_;
	}
	_tmp331_ = vala_compiler_library;
	if (_tmp331_ != NULL) {
		const gchar* _tmp332_;
		_tmp332_ = vala_compiler_gir;
		if (_tmp332_ != NULL) {
			gchar* gir_base = NULL;
			const gchar* _tmp333_;
			gchar* _tmp334_;
			glong gir_len = 0L;
			const gchar* _tmp335_;
			gint _tmp336_;
			gint _tmp337_;
			gint last_hyphen = 0;
			const gchar* _tmp338_;
			gint _tmp339_;
			gboolean _tmp340_ = FALSE;
			gint _tmp341_;
			_tmp333_ = vala_compiler_gir;
			_tmp334_ = g_path_get_basename (_tmp333_);
			gir_base = _tmp334_;
			_tmp335_ = gir_base;
			_tmp336_ = strlen (_tmp335_);
			_tmp337_ = _tmp336_;
			gir_len = (glong) _tmp337_;
			_tmp338_ = gir_base;
			_tmp339_ = string_last_index_of_char (_tmp338_, (gunichar) '-', 0);
			last_hyphen = _tmp339_;
			_tmp341_ = last_hyphen;
			if (_tmp341_ == -1) {
				_tmp340_ = TRUE;
			} else {
				const gchar* _tmp342_;
				gboolean _tmp343_;
				_tmp342_ = gir_base;
				_tmp343_ = g_str_has_suffix (_tmp342_, ".gir");
				_tmp340_ = !_tmp343_;
			}
			if (_tmp340_) {
				const gchar* _tmp344_;
				gchar* _tmp345_;
				gchar* _tmp346_;
				_tmp344_ = vala_compiler_gir;
				_tmp345_ = g_strdup_printf ("GIR file name `%s' is not well-formed, expected NAME-VERSION.gir", _tmp344_);
				_tmp346_ = _tmp345_;
				vala_report_error (NULL, _tmp346_);
				_g_free0 (_tmp346_);
			} else {
				gchar* gir_namespace = NULL;
				const gchar* _tmp347_;
				gint _tmp348_;
				gchar* _tmp349_;
				gchar* gir_version = NULL;
				const gchar* _tmp350_;
				gint _tmp351_;
				glong _tmp352_;
				gint _tmp353_;
				gchar* _tmp354_;
				const gchar* _tmp355_;
				gboolean _tmp356_ = FALSE;
				gboolean _tmp357_ = FALSE;
				gboolean _tmp358_ = FALSE;
				const gchar* _tmp359_;
				_tmp347_ = gir_base;
				_tmp348_ = last_hyphen;
				_tmp349_ = string_substring (_tmp347_, (glong) 0, (glong) _tmp348_);
				gir_namespace = _tmp349_;
				_tmp350_ = gir_base;
				_tmp351_ = last_hyphen;
				_tmp352_ = gir_len;
				_tmp353_ = last_hyphen;
				_tmp354_ = string_substring (_tmp350_, (glong) (_tmp351_ + 1), (_tmp352_ - _tmp353_) - 5);
				gir_version = _tmp354_;
				_tmp355_ = gir_version;
				g_strcanon (_tmp355_, "0123456789.", '?');
				_tmp359_ = gir_namespace;
				if (g_strcmp0 (_tmp359_, "") == 0) {
					_tmp358_ = TRUE;
				} else {
					const gchar* _tmp360_;
					_tmp360_ = gir_version;
					_tmp358_ = g_strcmp0 (_tmp360_, "") == 0;
				}
				if (_tmp358_) {
					_tmp357_ = TRUE;
				} else {
					const gchar* _tmp361_;
					gchar _tmp362_;
					gboolean _tmp363_;
					_tmp361_ = gir_version;
					_tmp362_ = string_get (_tmp361_, (glong) 0);
					_tmp363_ = g_ascii_isdigit (_tmp362_);
					_tmp357_ = !_tmp363_;
				}
				if (_tmp357_) {
					_tmp356_ = TRUE;
				} else {
					const gchar* _tmp364_;
					gboolean _tmp365_;
					_tmp364_ = gir_version;
					_tmp365_ = string_contains (_tmp364_, "?");
					_tmp356_ = _tmp365_;
				}
				if (_tmp356_) {
					const gchar* _tmp366_;
					gchar* _tmp367_;
					gchar* _tmp368_;
					_tmp366_ = vala_compiler_gir;
					_tmp367_ = g_strdup_printf ("GIR file name `%s' is not well-formed, expected NAME-VERSION.gir", _tmp366_);
					_tmp368_ = _tmp367_;
					vala_report_error (NULL, _tmp368_);
					_g_free0 (_tmp368_);
				} else {
					ValaGIRWriter* gir_writer = NULL;
					ValaGIRWriter* _tmp369_;
					gchar* gir_directory = NULL;
					gchar* _tmp370_;
					const gchar* _tmp371_;
					ValaGIRWriter* _tmp376_;
					ValaCodeContext* _tmp377_;
					const gchar* _tmp378_;
					const gchar* _tmp379_;
					const gchar* _tmp380_;
					const gchar* _tmp381_;
					const gchar* _tmp382_;
					const gchar* _tmp383_;
					_tmp369_ = vala_gir_writer_new ();
					gir_writer = _tmp369_;
					_tmp370_ = g_strdup (".");
					gir_directory = _tmp370_;
					_tmp371_ = vala_compiler_directory;
					if (_tmp371_ != NULL) {
						ValaCodeContext* _tmp372_;
						const gchar* _tmp373_;
						const gchar* _tmp374_;
						gchar* _tmp375_;
						_tmp372_ = self->priv->context;
						_tmp373_ = vala_code_context_get_directory (_tmp372_);
						_tmp374_ = _tmp373_;
						_tmp375_ = g_strdup (_tmp374_);
						_g_free0 (gir_directory);
						gir_directory = _tmp375_;
					}
					_tmp376_ = gir_writer;
					_tmp377_ = self->priv->context;
					_tmp378_ = gir_directory;
					_tmp379_ = vala_compiler_gir;
					_tmp380_ = gir_namespace;
					_tmp381_ = gir_version;
					_tmp382_ = vala_compiler_library;
					_tmp383_ = vala_compiler_shared_library;
					vala_gir_writer_write_file (_tmp376_, _tmp377_, _tmp378_, _tmp379_, _tmp380_, _tmp381_, _tmp382_, _tmp383_);
					_g_free0 (gir_directory);
					_vala_code_visitor_unref0 (gir_writer);
				}
				_g_free0 (gir_version);
				_g_free0 (gir_namespace);
			}
			_g_free0 (vala_compiler_gir);
			vala_compiler_gir = NULL;
			_g_free0 (gir_base);
		}
		_g_free0 (vala_compiler_library);
		vala_compiler_library = NULL;
	} else {
		const gchar* _tmp384_;
		_tmp384_ = vala_compiler_gir;
		if (_tmp384_ != NULL) {
			vala_report_warning (NULL, "--gir has no effect without --library");
			_g_free0 (vala_compiler_gir);
			vala_compiler_gir = NULL;
		}
	}
	_tmp385_ = vala_compiler_vapi_filename;
	if (_tmp385_ != NULL) {
		ValaCodeWriter* interface_writer = NULL;
		ValaCodeWriter* _tmp386_;
		gboolean _tmp387_ = FALSE;
		const gchar* _tmp388_;
		ValaCodeWriter* _tmp396_;
		ValaCodeContext* _tmp397_;
		const gchar* _tmp398_;
		_tmp386_ = vala_code_writer_new (VALA_CODE_WRITER_TYPE_EXTERNAL);
		interface_writer = _tmp386_;
		_tmp388_ = vala_compiler_directory;
		if (_tmp388_ != NULL) {
			const gchar* _tmp389_;
			gboolean _tmp390_;
			_tmp389_ = vala_compiler_vapi_filename;
			_tmp390_ = g_path_is_absolute (_tmp389_);
			_tmp387_ = !_tmp390_;
		} else {
			_tmp387_ = FALSE;
		}
		if (_tmp387_) {
			ValaCodeContext* _tmp391_;
			const gchar* _tmp392_;
			const gchar* _tmp393_;
			const gchar* _tmp394_;
			gchar* _tmp395_;
			_tmp391_ = self->priv->context;
			_tmp392_ = vala_code_context_get_directory (_tmp391_);
			_tmp393_ = _tmp392_;
			_tmp394_ = vala_compiler_vapi_filename;
			_tmp395_ = g_strdup_printf ("%s%c%s", _tmp393_, (gint) G_DIR_SEPARATOR, _tmp394_);
			_g_free0 (vala_compiler_vapi_filename);
			vala_compiler_vapi_filename = _tmp395_;
		}
		_tmp396_ = interface_writer;
		_tmp397_ = self->priv->context;
		_tmp398_ = vala_compiler_vapi_filename;
		vala_code_writer_write_file (_tmp396_, _tmp397_, _tmp398_);
		_vala_code_visitor_unref0 (interface_writer);
	}
	_tmp399_ = vala_compiler_internal_vapi_filename;
	if (_tmp399_ != NULL) {
		gboolean _tmp400_ = FALSE;
		const gchar* _tmp401_;
		ValaCodeWriter* interface_writer = NULL;
		ValaCodeWriter* _tmp404_;
		ValaCodeContext* _tmp405_;
		const gchar* _tmp406_;
		const gchar* _tmp407_;
		gchar* vapi_filename = NULL;
		const gchar* _tmp430_;
		gchar* _tmp431_;
		gboolean _tmp432_ = FALSE;
		const gchar* _tmp433_;
		ValaCodeWriter* _tmp441_;
		ValaCodeContext* _tmp442_;
		const gchar* _tmp443_;
		_tmp401_ = vala_compiler_internal_header_filename;
		if (_tmp401_ == NULL) {
			_tmp400_ = TRUE;
		} else {
			const gchar* _tmp402_;
			_tmp402_ = vala_compiler_header_filename;
			_tmp400_ = _tmp402_ == NULL;
		}
		if (_tmp400_) {
			gint _tmp403_;
			vala_report_error (NULL, "--internal-vapi may only be used in combination with --header and --in" \
"ternal-header");
			_tmp403_ = vala_compiler_quit (self);
			result = _tmp403_;
			_vala_code_visitor_unref0 (gir_parser);
			_vala_code_visitor_unref0 (genie_parser);
			_vala_code_visitor_unref0 (parser);
			return result;
		}
		_tmp404_ = vala_code_writer_new (VALA_CODE_WRITER_TYPE_INTERNAL);
		interface_writer = _tmp404_;
		_tmp405_ = self->priv->context;
		_tmp406_ = vala_code_context_get_includedir (_tmp405_);
		_tmp407_ = _tmp406_;
		if (_tmp407_ != NULL) {
			gchar* prefixed_header_filename = NULL;
			ValaCodeContext* _tmp408_;
			const gchar* _tmp409_;
			const gchar* _tmp410_;
			const gchar* _tmp411_;
			gchar* _tmp412_;
			gchar* _tmp413_;
			gchar* _tmp414_;
			gchar* _tmp415_;
			gchar* prefixed_internal_header_filename = NULL;
			ValaCodeContext* _tmp416_;
			const gchar* _tmp417_;
			const gchar* _tmp418_;
			const gchar* _tmp419_;
			gchar* _tmp420_;
			gchar* _tmp421_;
			gchar* _tmp422_;
			gchar* _tmp423_;
			ValaCodeWriter* _tmp424_;
			const gchar* _tmp425_;
			const gchar* _tmp426_;
			_tmp408_ = self->priv->context;
			_tmp409_ = vala_code_context_get_includedir (_tmp408_);
			_tmp410_ = _tmp409_;
			_tmp411_ = vala_compiler_header_filename;
			_tmp412_ = g_path_get_basename (_tmp411_);
			_tmp413_ = _tmp412_;
			_tmp414_ = g_build_path ("/", _tmp410_, _tmp413_, NULL);
			_tmp415_ = _tmp414_;
			_g_free0 (_tmp413_);
			prefixed_header_filename = _tmp415_;
			_tmp416_ = self->priv->context;
			_tmp417_ = vala_code_context_get_includedir (_tmp416_);
			_tmp418_ = _tmp417_;
			_tmp419_ = vala_compiler_internal_header_filename;
			_tmp420_ = g_path_get_basename (_tmp419_);
			_tmp421_ = _tmp420_;
			_tmp422_ = g_build_path ("/", _tmp418_, _tmp421_, NULL);
			_tmp423_ = _tmp422_;
			_g_free0 (_tmp421_);
			prefixed_internal_header_filename = _tmp423_;
			_tmp424_ = interface_writer;
			_tmp425_ = prefixed_header_filename;
			_tmp426_ = prefixed_internal_header_filename;
			vala_code_writer_set_cheader_override (_tmp424_, _tmp425_, _tmp426_);
			_g_free0 (prefixed_internal_header_filename);
			_g_free0 (prefixed_header_filename);
		} else {
			ValaCodeWriter* _tmp427_;
			const gchar* _tmp428_;
			const gchar* _tmp429_;
			_tmp427_ = interface_writer;
			_tmp428_ = vala_compiler_header_filename;
			_tmp429_ = vala_compiler_internal_header_filename;
			vala_code_writer_set_cheader_override (_tmp427_, _tmp428_, _tmp429_);
		}
		_tmp430_ = vala_compiler_internal_vapi_filename;
		_tmp431_ = g_strdup (_tmp430_);
		vapi_filename = _tmp431_;
		_tmp433_ = vala_compiler_directory;
		if (_tmp433_ != NULL) {
			const gchar* _tmp434_;
			gboolean _tmp435_;
			_tmp434_ = vapi_filename;
			_tmp435_ = g_path_is_absolute (_tmp434_);
			_tmp432_ = !_tmp435_;
		} else {
			_tmp432_ = FALSE;
		}
		if (_tmp432_) {
			ValaCodeContext* _tmp436_;
			const gchar* _tmp437_;
			const gchar* _tmp438_;
			const gchar* _tmp439_;
			gchar* _tmp440_;
			_tmp436_ = self->priv->context;
			_tmp437_ = vala_code_context_get_directory (_tmp436_);
			_tmp438_ = _tmp437_;
			_tmp439_ = vapi_filename;
			_tmp440_ = g_strdup_printf ("%s%c%s", _tmp438_, (gint) G_DIR_SEPARATOR, _tmp439_);
			_g_free0 (vapi_filename);
			vapi_filename = _tmp440_;
		}
		_tmp441_ = interface_writer;
		_tmp442_ = self->priv->context;
		_tmp443_ = vapi_filename;
		vala_code_writer_write_file (_tmp441_, _tmp442_, _tmp443_);
		_g_free0 (vala_compiler_internal_vapi_filename);
		vala_compiler_internal_vapi_filename = NULL;
		_g_free0 (vapi_filename);
		_vala_code_visitor_unref0 (interface_writer);
	}
	_tmp444_ = vala_compiler_dependencies;
	if (_tmp444_ != NULL) {
		ValaCodeContext* _tmp445_;
		const gchar* _tmp446_;
		_tmp445_ = self->priv->context;
		_tmp446_ = vala_compiler_dependencies;
		vala_code_context_write_dependencies (_tmp445_, _tmp446_);
	}
	_tmp448_ = self->priv->context;
	_tmp449_ = vala_code_context_get_report (_tmp448_);
	_tmp450_ = _tmp449_;
	_tmp451_ = vala_report_get_errors (_tmp450_);
	if (_tmp451_ > 0) {
		_tmp447_ = TRUE;
	} else {
		gboolean _tmp452_ = FALSE;
		gboolean _tmp453_;
		_tmp453_ = vala_compiler_fatal_warnings;
		if (_tmp453_) {
			ValaCodeContext* _tmp454_;
			ValaReport* _tmp455_;
			ValaReport* _tmp456_;
			gint _tmp457_;
			_tmp454_ = self->priv->context;
			_tmp455_ = vala_code_context_get_report (_tmp454_);
			_tmp456_ = _tmp455_;
			_tmp457_ = vala_report_get_warnings (_tmp456_);
			_tmp452_ = _tmp457_ > 0;
		} else {
			_tmp452_ = FALSE;
		}
		_tmp447_ = _tmp452_;
	}
	if (_tmp447_) {
		gint _tmp458_;
		_tmp458_ = vala_compiler_quit (self);
		result = _tmp458_;
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp459_ = vala_compiler_ccode_only;
	if (!_tmp459_) {
		ValaCCodeCompiler* ccompiler = NULL;
		ValaCCodeCompiler* _tmp460_;
		gboolean _tmp461_ = FALSE;
		const gchar* _tmp462_;
		gchar** _tmp466_;
		gint _tmp466__length1;
		_tmp460_ = vala_ccode_compiler_new ();
		ccompiler = _tmp460_;
		_tmp462_ = vala_compiler_cc_command;
		if (_tmp462_ == NULL) {
			const gchar* _tmp463_;
			_tmp463_ = g_getenv ("CC");
			_tmp461_ = _tmp463_ != NULL;
		} else {
			_tmp461_ = FALSE;
		}
		if (_tmp461_) {
			const gchar* _tmp464_;
			gchar* _tmp465_;
			_tmp464_ = g_getenv ("CC");
			_tmp465_ = g_strdup (_tmp464_);
			_g_free0 (vala_compiler_cc_command);
			vala_compiler_cc_command = _tmp465_;
		}
		_tmp466_ = vala_compiler_cc_options;
		_tmp466__length1 = _vala_array_length (vala_compiler_cc_options);
		if (_tmp466_ == NULL) {
			ValaCCodeCompiler* _tmp467_;
			ValaCodeContext* _tmp468_;
			const gchar* _tmp469_;
			gchar** _tmp470_;
			gchar** _tmp471_;
			gint _tmp471__length1;
			_tmp467_ = ccompiler;
			_tmp468_ = self->priv->context;
			_tmp469_ = vala_compiler_cc_command;
			_tmp470_ = g_new0 (gchar*, 0 + 1);
			_tmp471_ = _tmp470_;
			_tmp471__length1 = 0;
			vala_ccode_compiler_compile (_tmp467_, _tmp468_, _tmp469_, _tmp471_, 0);
			_tmp471_ = (_vala_array_free (_tmp471_, _tmp471__length1, (GDestroyNotify) g_free), NULL);
		} else {
			ValaCCodeCompiler* _tmp472_;
			ValaCodeContext* _tmp473_;
			const gchar* _tmp474_;
			gchar** _tmp475_;
			gint _tmp475__length1;
			_tmp472_ = ccompiler;
			_tmp473_ = self->priv->context;
			_tmp474_ = vala_compiler_cc_command;
			_tmp475_ = vala_compiler_cc_options;
			_tmp475__length1 = _vala_array_length (vala_compiler_cc_options);
			vala_ccode_compiler_compile (_tmp472_, _tmp473_, _tmp474_, _tmp475_, _tmp475__length1);
		}
		_vala_ccode_compiler_unref0 (ccompiler);
	}
	_tmp476_ = vala_compiler_quit (self);
	result = _tmp476_;
	_vala_code_visitor_unref0 (gir_parser);
	_vala_code_visitor_unref0 (genie_parser);
	_vala_code_visitor_unref0 (parser);
	return result;
}


static void _vala_array_add1 (gchar** * array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_main_loop_unref0 (_data1_->loop);
		g_slice_free (Block1Data, _data1_);
	}
}


static void ___lambda4_ (Block1Data* _data1_, GPid pid, gint status) {
	gint _tmp0_;
	GMainLoop* _tmp1_;
	_tmp0_ = status;
	_data1_->child_status = (_tmp0_ & 0xff00) >> 8;
	_tmp1_ = _data1_->loop;
	g_main_loop_quit (_tmp1_);
}


static void ____lambda4__gchild_watch_func (GPid pid, gint status, gpointer self) {
	___lambda4_ (self, pid, status);
}


static gint vala_compiler_run_source (gchar** args, int args_length1) {
	gint result = 0;
	gint i = 0;
	gboolean _tmp0_ = FALSE;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gint _tmp2_;
	const gchar* _tmp3_;
	gboolean _tmp32_;
	gchar** _tmp36_;
	gint _tmp36__length1;
	gint _tmp37_;
	const gchar* _tmp38_;
	gchar** _tmp40_;
	gint _tmp40__length1;
	gint _tmp41_;
	const gchar* _tmp42_;
	gchar* _tmp43_;
	gchar** _tmp44_;
	const gchar* _tmp45_;
	gchar** _tmp46_;
	gint _tmp46__length1;
	gint _tmp47_;
	const gchar* _tmp48_;
	gchar* _tmp49_;
	gchar* _tmp50_;
	gchar* _tmp51_;
	gint outputfd = 0;
	const gchar* _tmp52_;
	gint _tmp53_;
	gint _tmp54_;
	ValaCompiler* compiler = NULL;
	ValaCompiler* _tmp55_;
	gint ret = 0;
	ValaCompiler* _tmp56_;
	gint _tmp57_;
	gint _tmp58_;
	gint _tmp59_;
	const gchar* _tmp60_;
	gint _tmp61_;
	gchar** target_args = NULL;
	const gchar* _tmp63_;
	gchar* _tmp64_;
	gchar** _tmp65_;
	gint target_args_length1;
	gint _target_args_size_;
	gint _tmp85_ = 0;
	GError* _inner_error0_ = NULL;
	i = 1;
	_tmp1_ = args;
	_tmp1__length1 = args_length1;
	_tmp2_ = i;
	_tmp3_ = _tmp1_[_tmp2_];
	if (_tmp3_ != NULL) {
		gchar** _tmp4_;
		gint _tmp4__length1;
		gint _tmp5_;
		const gchar* _tmp6_;
		gboolean _tmp7_;
		_tmp4_ = args;
		_tmp4__length1 = args_length1;
		_tmp5_ = i;
		_tmp6_ = _tmp4_[_tmp5_];
		_tmp7_ = g_str_has_prefix (_tmp6_, "-");
		_tmp0_ = _tmp7_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint _tmp31_;
		{
			gchar** compile_args = NULL;
			gint compile_args_length1 = 0;
			gint _compile_args_size_ = 0;
			gchar** _tmp8_;
			gint _tmp8__length1;
			const gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			gchar** _tmp12_ = NULL;
			gint _tmp13_;
			GOptionContext* opt_context = NULL;
			GOptionContext* _tmp15_;
			GOptionContext* _tmp16_;
			GOptionContext* _tmp17_;
			gchar** temp_args = NULL;
			gchar** _tmp18_;
			gint _tmp18__length1;
			gint temp_args_length1;
			gint _temp_args_size_;
			GOptionContext* _tmp19_;
			_tmp8_ = args;
			_tmp8__length1 = args_length1;
			_tmp9_ = _tmp8_[1];
			_tmp10_ = g_strconcat ("valac ", _tmp9_, NULL);
			_tmp11_ = _tmp10_;
			g_shell_parse_argv (_tmp11_, &_tmp13_, &_tmp12_, &_inner_error0_);
			compile_args = (_vala_array_free (compile_args, compile_args_length1, (GDestroyNotify) g_free), NULL);
			compile_args = _tmp12_;
			compile_args_length1 = _tmp13_;
			_compile_args_size_ = compile_args_length1;
			_g_free0 (_tmp11_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gint _tmp14_ = 0;
				compile_args = (_vala_array_free (compile_args, compile_args_length1, (GDestroyNotify) g_free), NULL);
				if (_inner_error0_->domain == G_SHELL_ERROR) {
					goto __catch0_g_shell_error;
				}
				if (_inner_error0_->domain == G_OPTION_ERROR) {
					goto __catch0_g_option_error;
				}
				compile_args = (_vala_array_free (compile_args, compile_args_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp14_;
			}
			_tmp15_ = g_option_context_new ("- Vala");
			opt_context = _tmp15_;
			_tmp16_ = opt_context;
			g_option_context_set_help_enabled (_tmp16_, TRUE);
			_tmp17_ = opt_context;
			g_option_context_add_main_entries (_tmp17_, VALA_COMPILER_options, NULL);
			_tmp18_ = compile_args;
			_tmp18__length1 = compile_args_length1;
			temp_args = _tmp18_;
			temp_args_length1 = _tmp18__length1;
			_temp_args_size_ = temp_args_length1;
			_tmp19_ = opt_context;
			g_option_context_parse (_tmp19_, &temp_args_length1, &temp_args, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gint _tmp20_ = 0;
				_g_option_context_free0 (opt_context);
				compile_args = (_vala_array_free (compile_args, compile_args_length1, (GDestroyNotify) g_free), NULL);
				if (_inner_error0_->domain == G_SHELL_ERROR) {
					goto __catch0_g_shell_error;
				}
				if (_inner_error0_->domain == G_OPTION_ERROR) {
					goto __catch0_g_option_error;
				}
				_g_option_context_free0 (opt_context);
				compile_args = (_vala_array_free (compile_args, compile_args_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp20_;
			}
			_g_option_context_free0 (opt_context);
			compile_args = (_vala_array_free (compile_args, compile_args_length1, (GDestroyNotify) g_free), NULL);
		}
		goto __finally0;
		__catch0_g_shell_error:
		{
			GError* e = NULL;
			FILE* _tmp21_;
			GError* _tmp22_;
			const gchar* _tmp23_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp21_ = stdout;
			_tmp22_ = e;
			_tmp23_ = _tmp22_->message;
			fprintf (_tmp21_, "%s\n", _tmp23_);
			result = 1;
			_g_error_free0 (e);
			return result;
		}
		goto __finally0;
		__catch0_g_option_error:
		{
			GError* e = NULL;
			FILE* _tmp24_;
			GError* _tmp25_;
			const gchar* _tmp26_;
			FILE* _tmp27_;
			gchar** _tmp28_;
			gint _tmp28__length1;
			const gchar* _tmp29_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp24_ = stdout;
			_tmp25_ = e;
			_tmp26_ = _tmp25_->message;
			fprintf (_tmp24_, "%s\n", _tmp26_);
			_tmp27_ = stdout;
			_tmp28_ = args;
			_tmp28__length1 = args_length1;
			_tmp29_ = _tmp28_[0];
			fprintf (_tmp27_, "Run '%s --help' to see a full list of available command line options.\n", _tmp29_);
			result = 1;
			_g_error_free0 (e);
			return result;
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gint _tmp30_ = 0;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp30_;
		}
		_tmp31_ = i;
		i = _tmp31_ + 1;
	}
	_tmp32_ = vala_compiler_version;
	if (_tmp32_) {
		FILE* _tmp33_;
		_tmp33_ = stdout;
		fprintf (_tmp33_, "Vala %s\n", BUILD_VERSION);
		result = 0;
		return result;
	} else {
		gboolean _tmp34_;
		_tmp34_ = vala_compiler_api_version;
		if (_tmp34_) {
			FILE* _tmp35_;
			_tmp35_ = stdout;
			fprintf (_tmp35_, "%s\n", API_VERSION);
			result = 0;
			return result;
		}
	}
	_tmp36_ = args;
	_tmp36__length1 = args_length1;
	_tmp37_ = i;
	_tmp38_ = _tmp36_[_tmp37_];
	if (_tmp38_ == NULL) {
		FILE* _tmp39_;
		_tmp39_ = stderr;
		fprintf (_tmp39_, "No source file specified.\n");
		result = 1;
		return result;
	}
	_tmp40_ = args;
	_tmp40__length1 = args_length1;
	_tmp41_ = i;
	_tmp42_ = _tmp40_[_tmp41_];
	_tmp43_ = g_strdup (_tmp42_);
	_tmp44_ = g_new0 (gchar*, 1 + 1);
	_tmp44_[0] = _tmp43_;
	vala_compiler_sources = (_vala_array_free (vala_compiler_sources, _vala_array_length (vala_compiler_sources), (GDestroyNotify) g_free), NULL);
	vala_compiler_sources = _tmp44_;
	_tmp45_ = g_get_tmp_dir ();
	_tmp46_ = args;
	_tmp46__length1 = args_length1;
	_tmp47_ = i;
	_tmp48_ = _tmp46_[_tmp47_];
	_tmp49_ = g_path_get_basename (_tmp48_);
	_tmp50_ = _tmp49_;
	_tmp51_ = g_strdup_printf ("%s/%s.XXXXXX", _tmp45_, _tmp50_);
	_g_free0 (vala_compiler_output);
	vala_compiler_output = _tmp51_;
	_g_free0 (_tmp50_);
	_tmp52_ = vala_compiler_output;
	_tmp53_ = g_mkstemp (_tmp52_);
	outputfd = _tmp53_;
	_tmp54_ = outputfd;
	if (_tmp54_ < 0) {
		result = 1;
		return result;
	}
	vala_compiler_run_output = TRUE;
	vala_compiler_disable_warnings = TRUE;
	vala_compiler_quiet_mode = TRUE;
	_tmp55_ = vala_compiler_new ();
	compiler = _tmp55_;
	_tmp56_ = compiler;
	_tmp57_ = vala_compiler_run (_tmp56_);
	ret = _tmp57_;
	_tmp58_ = ret;
	if (_tmp58_ != 0) {
		result = ret;
		_vala_compiler_unref0 (compiler);
		return result;
	}
	_tmp59_ = outputfd;
	close (_tmp59_);
	_tmp60_ = vala_compiler_output;
	_tmp61_ = g_chmod (_tmp60_, 0700);
	if (_tmp61_ != 0) {
		const gchar* _tmp62_;
		_tmp62_ = vala_compiler_output;
		g_unlink (_tmp62_);
		result = 1;
		_vala_compiler_unref0 (compiler);
		return result;
	}
	_tmp63_ = vala_compiler_output;
	_tmp64_ = g_strdup (_tmp63_);
	_tmp65_ = g_new0 (gchar*, 1 + 1);
	_tmp65_[0] = _tmp64_;
	target_args = _tmp65_;
	target_args_length1 = 1;
	_target_args_size_ = target_args_length1;
	while (TRUE) {
		gint _tmp66_;
		gchar** _tmp67_;
		gint _tmp67__length1;
		gchar** _tmp68_;
		gint _tmp68__length1;
		gchar** _tmp69_;
		gint _tmp69__length1;
		gint _tmp70_;
		const gchar* _tmp71_;
		gchar* _tmp72_;
		gint _tmp73_;
		_tmp66_ = i;
		_tmp67_ = args;
		_tmp67__length1 = args_length1;
		if (!(_tmp66_ < _tmp67__length1)) {
			break;
		}
		_tmp68_ = target_args;
		_tmp68__length1 = target_args_length1;
		_tmp69_ = args;
		_tmp69__length1 = args_length1;
		_tmp70_ = i;
		_tmp71_ = _tmp69_[_tmp70_];
		_tmp72_ = g_strdup (_tmp71_);
		_vala_array_add1 (&target_args, &target_args_length1, &_target_args_size_, _tmp72_);
		_tmp73_ = i;
		i = _tmp73_ + 1;
	}
	{
		Block1Data* _data1_;
		GPid pid = 0;
		GMainLoop* _tmp74_;
		gchar** _tmp75_;
		gint _tmp75__length1;
		GPid _tmp76_ = 0;
		const gchar* _tmp78_;
		GPid _tmp79_;
		GMainLoop* _tmp80_;
		gint _tmp81_;
		_data1_ = g_slice_new0 (Block1Data);
		_data1_->_ref_count_ = 1;
		_tmp74_ = g_main_loop_new (NULL, FALSE);
		_data1_->loop = _tmp74_;
		_data1_->child_status = 0;
		_tmp75_ = target_args;
		_tmp75__length1 = target_args_length1;
		g_spawn_async (NULL, _tmp75_, NULL, (G_SPAWN_CHILD_INHERITS_STDIN | G_SPAWN_DO_NOT_REAP_CHILD) | G_SPAWN_FILE_AND_ARGV_ZERO, NULL, NULL, &_tmp76_, &_inner_error0_);
		pid = _tmp76_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gint _tmp77_ = 0;
			block1_data_unref (_data1_);
			_data1_ = NULL;
			if (_inner_error0_->domain == G_SPAWN_ERROR) {
				goto __catch1_g_spawn_error;
			}
			block1_data_unref (_data1_);
			_data1_ = NULL;
			target_args = (_vala_array_free (target_args, target_args_length1, (GDestroyNotify) g_free), NULL);
			_vala_compiler_unref0 (compiler);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp77_;
		}
		_tmp78_ = vala_compiler_output;
		g_unlink (_tmp78_);
		_tmp79_ = pid;
		g_child_watch_add_full (G_PRIORITY_DEFAULT_IDLE, _tmp79_, ____lambda4__gchild_watch_func, block1_data_ref (_data1_), block1_data_unref);
		_tmp80_ = _data1_->loop;
		g_main_loop_run (_tmp80_);
		_tmp81_ = _data1_->child_status;
		result = _tmp81_;
		block1_data_unref (_data1_);
		_data1_ = NULL;
		target_args = (_vala_array_free (target_args, target_args_length1, (GDestroyNotify) g_free), NULL);
		_vala_compiler_unref0 (compiler);
		return result;
	}
	goto __finally1;
	__catch1_g_spawn_error:
	{
		GError* e = NULL;
		FILE* _tmp82_;
		GError* _tmp83_;
		const gchar* _tmp84_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp82_ = stdout;
		_tmp83_ = e;
		_tmp84_ = _tmp83_->message;
		fprintf (_tmp82_, "%s\n", _tmp84_);
		result = 1;
		_g_error_free0 (e);
		target_args = (_vala_array_free (target_args, target_args_length1, (GDestroyNotify) g_free), NULL);
		_vala_compiler_unref0 (compiler);
		return result;
	}
	__finally1:
	target_args = (_vala_array_free (target_args, target_args_length1, (GDestroyNotify) g_free), NULL);
	_vala_compiler_unref0 (compiler);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp85_;
}


static gint vala_compiler_main (gchar** args, int args_length1) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	gchar** _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp24_;
	gboolean _tmp28_ = FALSE;
	gchar** _tmp29_;
	gint _tmp29__length1;
	ValaCompiler* compiler = NULL;
	ValaCompiler* _tmp32_;
	ValaCompiler* _tmp33_;
	gint _tmp34_;
	GError* _inner_error0_ = NULL;
	setlocale (LC_ALL, "");
	_tmp1_ = args;
	_tmp1__length1 = args_length1;
	_tmp2_ = _tmp1_[0];
	_tmp3_ = g_path_get_basename (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strcmp0 (_tmp4_, "vala") == 0;
	_g_free0 (_tmp4_);
	if (_tmp5_) {
		_tmp0_ = TRUE;
	} else {
		gchar** _tmp6_;
		gint _tmp6__length1;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp6_ = args;
		_tmp6__length1 = args_length1;
		_tmp7_ = _tmp6_[0];
		_tmp8_ = g_path_get_basename (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp0_ = g_strcmp0 (_tmp9_, "vala" PACKAGE_SUFFIX) == 0;
		_g_free0 (_tmp9_);
	}
	if (_tmp0_) {
		gchar** _tmp10_;
		gint _tmp10__length1;
		gint _tmp11_;
		_tmp10_ = args;
		_tmp10__length1 = args_length1;
		_tmp11_ = vala_compiler_run_source (_tmp10_, _tmp10__length1);
		result = _tmp11_;
		return result;
	}
	{
		GOptionContext* opt_context = NULL;
		GOptionContext* _tmp12_;
		GOptionContext* _tmp13_;
		GOptionContext* _tmp14_;
		GOptionContext* _tmp15_;
		_tmp12_ = g_option_context_new ("- Vala Compiler");
		opt_context = _tmp12_;
		_tmp13_ = opt_context;
		g_option_context_set_help_enabled (_tmp13_, TRUE);
		_tmp14_ = opt_context;
		g_option_context_add_main_entries (_tmp14_, VALA_COMPILER_options, NULL);
		_tmp15_ = opt_context;
		g_option_context_parse (_tmp15_, &args_length1, &args, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gint _tmp16_ = 0;
			_g_option_context_free0 (opt_context);
			if (_inner_error0_->domain == G_OPTION_ERROR) {
				goto __catch2_g_option_error;
			}
			_g_option_context_free0 (opt_context);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp16_;
		}
		_g_option_context_free0 (opt_context);
	}
	goto __finally2;
	__catch2_g_option_error:
	{
		GError* e = NULL;
		FILE* _tmp17_;
		GError* _tmp18_;
		const gchar* _tmp19_;
		FILE* _tmp20_;
		gchar** _tmp21_;
		gint _tmp21__length1;
		const gchar* _tmp22_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp17_ = stdout;
		_tmp18_ = e;
		_tmp19_ = _tmp18_->message;
		fprintf (_tmp17_, "%s\n", _tmp19_);
		_tmp20_ = stdout;
		_tmp21_ = args;
		_tmp21__length1 = args_length1;
		_tmp22_ = _tmp21_[0];
		fprintf (_tmp20_, "Run '%s --help' to see a full list of available command line options.\n", _tmp22_);
		result = 1;
		_g_error_free0 (e);
		return result;
	}
	__finally2:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp23_ = 0;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp23_;
	}
	_tmp24_ = vala_compiler_version;
	if (_tmp24_) {
		FILE* _tmp25_;
		_tmp25_ = stdout;
		fprintf (_tmp25_, "Vala %s\n", BUILD_VERSION);
		result = 0;
		return result;
	} else {
		gboolean _tmp26_;
		_tmp26_ = vala_compiler_api_version;
		if (_tmp26_) {
			FILE* _tmp27_;
			_tmp27_ = stdout;
			fprintf (_tmp27_, "%s\n", API_VERSION);
			result = 0;
			return result;
		}
	}
	_tmp29_ = vala_compiler_sources;
	_tmp29__length1 = _vala_array_length (vala_compiler_sources);
	if (_tmp29_ == NULL) {
		gchar** _tmp30_;
		gint _tmp30__length1;
		_tmp30_ = vala_compiler_fast_vapis;
		_tmp30__length1 = _vala_array_length (vala_compiler_fast_vapis);
		_tmp28_ = _tmp30_ == NULL;
	} else {
		_tmp28_ = FALSE;
	}
	if (_tmp28_) {
		FILE* _tmp31_;
		_tmp31_ = stderr;
		fprintf (_tmp31_, "No source file specified.\n");
		result = 1;
		return result;
	}
	_tmp32_ = vala_compiler_new ();
	compiler = _tmp32_;
	_tmp33_ = compiler;
	_tmp34_ = vala_compiler_run (_tmp33_);
	result = _tmp34_;
	_vala_compiler_unref0 (compiler);
	return result;
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
	return vala_compiler_main (argv, argc);
}


G_GNUC_INTERNAL ValaCompiler* vala_compiler_construct (GType object_type) {
	ValaCompiler* self = NULL;
	self = (ValaCompiler*) g_type_create_instance (object_type);
	return self;
}


G_GNUC_INTERNAL ValaCompiler* vala_compiler_new (void) {
	return vala_compiler_construct (VALA_TYPE_COMPILER);
}


static void vala_value_compiler_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void vala_value_compiler_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		vala_compiler_unref (value->data[0].v_pointer);
	}
}


static void vala_value_compiler_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_compiler_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer vala_value_compiler_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* vala_value_compiler_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ValaCompiler * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_compiler_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* vala_value_compiler_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ValaCompiler ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_compiler_ref (value->data[0].v_pointer);
	}
	return NULL;
}


G_GNUC_INTERNAL GParamSpec* vala_param_spec_compiler (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ValaParamSpecCompiler* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_TYPE_COMPILER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


G_GNUC_INTERNAL gpointer vala_value_get_compiler (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_COMPILER), NULL);
	return value->data[0].v_pointer;
}


G_GNUC_INTERNAL void vala_value_set_compiler (GValue* value, gpointer v_object) {
	ValaCompiler * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_COMPILER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_COMPILER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_compiler_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_compiler_unref (old);
	}
}


G_GNUC_INTERNAL void vala_value_take_compiler (GValue* value, gpointer v_object) {
	ValaCompiler * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_COMPILER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_COMPILER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_compiler_unref (old);
	}
}


static void vala_compiler_class_init (ValaCompilerClass * klass) {
	vala_compiler_parent_class = g_type_class_peek_parent (klass);
	((ValaCompilerClass *) klass)->finalize = vala_compiler_finalize;
	g_type_class_add_private (klass, sizeof (ValaCompilerPrivate));
}


static void vala_compiler_instance_init (ValaCompiler * self) {
	self->priv = VALA_COMPILER_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void vala_compiler_finalize (ValaCompiler * obj) {
	ValaCompiler * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_COMPILER, ValaCompiler);
	g_signal_handlers_destroy (self);
	_vala_code_context_unref0 (self->priv->context);
}


G_GNUC_INTERNAL GType vala_compiler_get_type (void) {
	static volatile gsize vala_compiler_type_id__volatile = 0;
	if (g_once_init_enter (&vala_compiler_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { vala_value_compiler_init, vala_value_compiler_free_value, vala_value_compiler_copy_value, vala_value_compiler_peek_pointer, "p", vala_value_compiler_collect_value, "p", vala_value_compiler_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValaCompilerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_compiler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCompiler), 0, (GInstanceInitFunc) vala_compiler_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType vala_compiler_type_id;
		vala_compiler_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaCompiler", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&vala_compiler_type_id__volatile, vala_compiler_type_id);
	}
	return vala_compiler_type_id__volatile;
}


G_GNUC_INTERNAL gpointer vala_compiler_ref (gpointer instance) {
	ValaCompiler * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


G_GNUC_INTERNAL void vala_compiler_unref (gpointer instance) {
	ValaCompiler * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_COMPILER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



