/* valaenum.c generated by valac, the Vala compiler
 * generated from valaenum.vala, do not modify */

/* valaenum.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>


#define VALA_TYPE_CODE_NODE (vala_code_node_get_type ())
#define VALA_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_NODE, ValaCodeNode))
#define VALA_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))
#define VALA_IS_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_NODE))
#define VALA_IS_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_NODE))
#define VALA_CODE_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))

typedef struct _ValaCodeNode ValaCodeNode;
typedef struct _ValaCodeNodeClass ValaCodeNodeClass;
typedef struct _ValaCodeNodePrivate ValaCodeNodePrivate;

#define VALA_TYPE_CODE_VISITOR (vala_code_visitor_get_type ())
#define VALA_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitor))
#define VALA_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))
#define VALA_IS_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_VISITOR))
#define VALA_IS_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_VISITOR))
#define VALA_CODE_VISITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))

typedef struct _ValaCodeVisitor ValaCodeVisitor;
typedef struct _ValaCodeVisitorClass ValaCodeVisitorClass;

#define VALA_TYPE_CODE_CONTEXT (vala_code_context_get_type ())
#define VALA_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContext))
#define VALA_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))
#define VALA_IS_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_CONTEXT))
#define VALA_IS_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_CONTEXT))
#define VALA_CODE_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))

typedef struct _ValaCodeContext ValaCodeContext;
typedef struct _ValaCodeContextClass ValaCodeContextClass;

#define VALA_TYPE_CODE_GENERATOR (vala_code_generator_get_type ())
#define VALA_CODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_GENERATOR, ValaCodeGenerator))
#define VALA_CODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_GENERATOR, ValaCodeGeneratorClass))
#define VALA_IS_CODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_GENERATOR))
#define VALA_IS_CODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_GENERATOR))
#define VALA_CODE_GENERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_GENERATOR, ValaCodeGeneratorClass))

typedef struct _ValaCodeGenerator ValaCodeGenerator;
typedef struct _ValaCodeGeneratorClass ValaCodeGeneratorClass;

#define VALA_TYPE_DATA_TYPE (vala_data_type_get_type ())
#define VALA_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DATA_TYPE, ValaDataType))
#define VALA_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))
#define VALA_IS_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DATA_TYPE))
#define VALA_IS_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DATA_TYPE))
#define VALA_DATA_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))

typedef struct _ValaDataType ValaDataType;
typedef struct _ValaDataTypeClass ValaDataTypeClass;

#define VALA_TYPE_EXPRESSION (vala_expression_get_type ())
#define VALA_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_EXPRESSION, ValaExpression))
#define VALA_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_EXPRESSION, ValaExpressionClass))
#define VALA_IS_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_EXPRESSION))
#define VALA_IS_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_EXPRESSION))
#define VALA_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_EXPRESSION, ValaExpressionClass))

typedef struct _ValaExpression ValaExpression;
typedef struct _ValaExpressionClass ValaExpressionClass;

#define VALA_TYPE_SYMBOL (vala_symbol_get_type ())
#define VALA_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SYMBOL, ValaSymbol))
#define VALA_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SYMBOL, ValaSymbolClass))
#define VALA_IS_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SYMBOL))
#define VALA_IS_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SYMBOL))
#define VALA_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SYMBOL, ValaSymbolClass))

typedef struct _ValaSymbol ValaSymbol;
typedef struct _ValaSymbolClass ValaSymbolClass;

#define VALA_TYPE_VARIABLE (vala_variable_get_type ())
#define VALA_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_VARIABLE, ValaVariable))
#define VALA_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_VARIABLE, ValaVariableClass))
#define VALA_IS_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_VARIABLE))
#define VALA_IS_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_VARIABLE))
#define VALA_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_VARIABLE, ValaVariableClass))

typedef struct _ValaVariable ValaVariable;
typedef struct _ValaVariableClass ValaVariableClass;

#define VALA_TYPE_ATTRIBUTE (vala_attribute_get_type ())
#define VALA_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ATTRIBUTE, ValaAttribute))
#define VALA_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))
#define VALA_IS_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ATTRIBUTE))
#define VALA_IS_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ATTRIBUTE))
#define VALA_ATTRIBUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))

typedef struct _ValaAttribute ValaAttribute;
typedef struct _ValaAttributeClass ValaAttributeClass;
typedef struct _ValaSymbolPrivate ValaSymbolPrivate;

#define VALA_TYPE_NAMESPACE (vala_namespace_get_type ())
#define VALA_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_NAMESPACE, ValaNamespace))
#define VALA_NAMESPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_NAMESPACE, ValaNamespaceClass))
#define VALA_IS_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_NAMESPACE))
#define VALA_IS_NAMESPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_NAMESPACE))
#define VALA_NAMESPACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_NAMESPACE, ValaNamespaceClass))

typedef struct _ValaNamespace ValaNamespace;
typedef struct _ValaNamespaceClass ValaNamespaceClass;

#define VALA_TYPE_TYPESYMBOL (vala_typesymbol_get_type ())
#define VALA_TYPESYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPESYMBOL, ValaTypeSymbol))
#define VALA_TYPESYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPESYMBOL, ValaTypeSymbolClass))
#define VALA_IS_TYPESYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPESYMBOL))
#define VALA_IS_TYPESYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPESYMBOL))
#define VALA_TYPESYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPESYMBOL, ValaTypeSymbolClass))

typedef struct _ValaTypeSymbol ValaTypeSymbol;
typedef struct _ValaTypeSymbolClass ValaTypeSymbolClass;

#define VALA_TYPE_OBJECT_TYPE_SYMBOL (vala_object_type_symbol_get_type ())
#define VALA_OBJECT_TYPE_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol))
#define VALA_OBJECT_TYPE_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbolClass))
#define VALA_IS_OBJECT_TYPE_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL))
#define VALA_IS_OBJECT_TYPE_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_OBJECT_TYPE_SYMBOL))
#define VALA_OBJECT_TYPE_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbolClass))

typedef struct _ValaObjectTypeSymbol ValaObjectTypeSymbol;
typedef struct _ValaObjectTypeSymbolClass ValaObjectTypeSymbolClass;

#define VALA_TYPE_CLASS (vala_class_get_type ())
#define VALA_CLASS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CLASS, ValaClass))
#define VALA_CLASS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CLASS, ValaClassClass))
#define VALA_IS_CLASS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CLASS))
#define VALA_IS_CLASS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CLASS))
#define VALA_CLASS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CLASS, ValaClassClass))

typedef struct _ValaClass ValaClass;
typedef struct _ValaClassClass ValaClassClass;

#define VALA_TYPE_INTERFACE (vala_interface_get_type ())
#define VALA_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_INTERFACE, ValaInterface))
#define VALA_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_INTERFACE, ValaInterfaceClass))
#define VALA_IS_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_INTERFACE))
#define VALA_IS_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_INTERFACE))
#define VALA_INTERFACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_INTERFACE, ValaInterfaceClass))

typedef struct _ValaInterface ValaInterface;
typedef struct _ValaInterfaceClass ValaInterfaceClass;

#define VALA_TYPE_STRUCT (vala_struct_get_type ())
#define VALA_STRUCT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_STRUCT, ValaStruct))
#define VALA_STRUCT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_STRUCT, ValaStructClass))
#define VALA_IS_STRUCT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_STRUCT))
#define VALA_IS_STRUCT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_STRUCT))
#define VALA_STRUCT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_STRUCT, ValaStructClass))

typedef struct _ValaStruct ValaStruct;
typedef struct _ValaStructClass ValaStructClass;

#define VALA_TYPE_ENUM (vala_enum_get_type ())
#define VALA_ENUM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ENUM, ValaEnum))
#define VALA_ENUM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ENUM, ValaEnumClass))
#define VALA_IS_ENUM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ENUM))
#define VALA_IS_ENUM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ENUM))
#define VALA_ENUM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ENUM, ValaEnumClass))

typedef struct _ValaEnum ValaEnum;
typedef struct _ValaEnumClass ValaEnumClass;

#define VALA_TYPE_ERROR_DOMAIN (vala_error_domain_get_type ())
#define VALA_ERROR_DOMAIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ERROR_DOMAIN, ValaErrorDomain))
#define VALA_ERROR_DOMAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ERROR_DOMAIN, ValaErrorDomainClass))
#define VALA_IS_ERROR_DOMAIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ERROR_DOMAIN))
#define VALA_IS_ERROR_DOMAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ERROR_DOMAIN))
#define VALA_ERROR_DOMAIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ERROR_DOMAIN, ValaErrorDomainClass))

typedef struct _ValaErrorDomain ValaErrorDomain;
typedef struct _ValaErrorDomainClass ValaErrorDomainClass;

#define VALA_TYPE_DELEGATE (vala_delegate_get_type ())
#define VALA_DELEGATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DELEGATE, ValaDelegate))
#define VALA_DELEGATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DELEGATE, ValaDelegateClass))
#define VALA_IS_DELEGATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DELEGATE))
#define VALA_IS_DELEGATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DELEGATE))
#define VALA_DELEGATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DELEGATE, ValaDelegateClass))

typedef struct _ValaDelegate ValaDelegate;
typedef struct _ValaDelegateClass ValaDelegateClass;

#define VALA_TYPE_CONSTANT (vala_constant_get_type ())
#define VALA_CONSTANT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CONSTANT, ValaConstant))
#define VALA_CONSTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CONSTANT, ValaConstantClass))
#define VALA_IS_CONSTANT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CONSTANT))
#define VALA_IS_CONSTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CONSTANT))
#define VALA_CONSTANT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CONSTANT, ValaConstantClass))

typedef struct _ValaConstant ValaConstant;
typedef struct _ValaConstantClass ValaConstantClass;

#define VALA_TYPE_FIELD (vala_field_get_type ())
#define VALA_FIELD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_FIELD, ValaField))
#define VALA_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_FIELD, ValaFieldClass))
#define VALA_IS_FIELD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_FIELD))
#define VALA_IS_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_FIELD))
#define VALA_FIELD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_FIELD, ValaFieldClass))

typedef struct _ValaField ValaField;
typedef struct _ValaFieldClass ValaFieldClass;

#define VALA_TYPE_SUBROUTINE (vala_subroutine_get_type ())
#define VALA_SUBROUTINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SUBROUTINE, ValaSubroutine))
#define VALA_SUBROUTINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SUBROUTINE, ValaSubroutineClass))
#define VALA_IS_SUBROUTINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SUBROUTINE))
#define VALA_IS_SUBROUTINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SUBROUTINE))
#define VALA_SUBROUTINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SUBROUTINE, ValaSubroutineClass))

typedef struct _ValaSubroutine ValaSubroutine;
typedef struct _ValaSubroutineClass ValaSubroutineClass;

#define VALA_TYPE_METHOD (vala_method_get_type ())
#define VALA_METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_METHOD, ValaMethod))
#define VALA_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_METHOD, ValaMethodClass))
#define VALA_IS_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_METHOD))
#define VALA_IS_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_METHOD))
#define VALA_METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_METHOD, ValaMethodClass))

typedef struct _ValaMethod ValaMethod;
typedef struct _ValaMethodClass ValaMethodClass;

#define VALA_TYPE_PROPERTY (vala_property_get_type ())
#define VALA_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_PROPERTY, ValaProperty))
#define VALA_PROPERTY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_PROPERTY, ValaPropertyClass))
#define VALA_IS_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_PROPERTY))
#define VALA_IS_PROPERTY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_PROPERTY))
#define VALA_PROPERTY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_PROPERTY, ValaPropertyClass))

typedef struct _ValaProperty ValaProperty;
typedef struct _ValaPropertyClass ValaPropertyClass;

#define VALA_TYPE_SIGNAL (vala_signal_get_type ())
#define VALA_SIGNAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SIGNAL, ValaSignal))
#define VALA_SIGNAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SIGNAL, ValaSignalClass))
#define VALA_IS_SIGNAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SIGNAL))
#define VALA_IS_SIGNAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SIGNAL))
#define VALA_SIGNAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SIGNAL, ValaSignalClass))

typedef struct _ValaSignal ValaSignal;
typedef struct _ValaSignalClass ValaSignalClass;

#define VALA_TYPE_CONSTRUCTOR (vala_constructor_get_type ())
#define VALA_CONSTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CONSTRUCTOR, ValaConstructor))
#define VALA_CONSTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CONSTRUCTOR, ValaConstructorClass))
#define VALA_IS_CONSTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CONSTRUCTOR))
#define VALA_IS_CONSTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CONSTRUCTOR))
#define VALA_CONSTRUCTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CONSTRUCTOR, ValaConstructorClass))

typedef struct _ValaConstructor ValaConstructor;
typedef struct _ValaConstructorClass ValaConstructorClass;

#define VALA_TYPE_DESTRUCTOR (vala_destructor_get_type ())
#define VALA_DESTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DESTRUCTOR, ValaDestructor))
#define VALA_DESTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DESTRUCTOR, ValaDestructorClass))
#define VALA_IS_DESTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DESTRUCTOR))
#define VALA_IS_DESTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DESTRUCTOR))
#define VALA_DESTRUCTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DESTRUCTOR, ValaDestructorClass))

typedef struct _ValaDestructor ValaDestructor;
typedef struct _ValaDestructorClass ValaDestructorClass;
typedef struct _ValaTypeSymbolPrivate ValaTypeSymbolPrivate;
typedef struct _ValaEnumPrivate ValaEnumPrivate;

#define VALA_TYPE_ENUM_VALUE (vala_enum_value_get_type ())
#define VALA_ENUM_VALUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ENUM_VALUE, ValaEnumValue))
#define VALA_ENUM_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ENUM_VALUE, ValaEnumValueClass))
#define VALA_IS_ENUM_VALUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ENUM_VALUE))
#define VALA_IS_ENUM_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ENUM_VALUE))
#define VALA_ENUM_VALUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ENUM_VALUE, ValaEnumValueClass))

typedef struct _ValaEnumValue ValaEnumValue;
typedef struct _ValaEnumValueClass ValaEnumValueClass;
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))

#define VALA_TYPE_SOURCE_REFERENCE (vala_source_reference_get_type ())
#define VALA_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReference))
#define VALA_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))
#define VALA_IS_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_IS_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_SOURCE_REFERENCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))

typedef struct _ValaSourceReference ValaSourceReference;
typedef struct _ValaSourceReferenceClass ValaSourceReferenceClass;

#define VALA_TYPE_COMMENT (vala_comment_get_type ())
#define VALA_COMMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_COMMENT, ValaComment))
#define VALA_COMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_COMMENT, ValaCommentClass))
#define VALA_IS_COMMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_COMMENT))
#define VALA_IS_COMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_COMMENT))
#define VALA_COMMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_COMMENT, ValaCommentClass))

typedef struct _ValaComment ValaComment;
typedef struct _ValaCommentClass ValaCommentClass;
typedef enum  {
	VALA_SYMBOL_ACCESSIBILITY_PRIVATE,
	VALA_SYMBOL_ACCESSIBILITY_INTERNAL,
	VALA_SYMBOL_ACCESSIBILITY_PROTECTED,
	VALA_SYMBOL_ACCESSIBILITY_PUBLIC
} ValaSymbolAccessibility;


#define VALA_TYPE_SYMBOL_ACCESSIBILITY (vala_symbol_accessibility_get_type ())

#define VALA_TYPE_SCOPE (vala_scope_get_type ())
#define VALA_SCOPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SCOPE, ValaScope))
#define VALA_SCOPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SCOPE, ValaScopeClass))
#define VALA_IS_SCOPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SCOPE))
#define VALA_IS_SCOPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SCOPE))
#define VALA_SCOPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SCOPE, ValaScopeClass))

typedef struct _ValaScope ValaScope;
typedef struct _ValaScopeClass ValaScopeClass;

#define VALA_TYPE_CREATION_METHOD (vala_creation_method_get_type ())
#define VALA_CREATION_METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CREATION_METHOD, ValaCreationMethod))
#define VALA_CREATION_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CREATION_METHOD, ValaCreationMethodClass))
#define VALA_IS_CREATION_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CREATION_METHOD))
#define VALA_IS_CREATION_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CREATION_METHOD))
#define VALA_CREATION_METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CREATION_METHOD, ValaCreationMethodClass))

typedef struct _ValaCreationMethod ValaCreationMethod;
typedef struct _ValaCreationMethodClass ValaCreationMethodClass;
typedef enum  {
	VALA_MEMBER_BINDING_INSTANCE,
	VALA_MEMBER_BINDING_CLASS,
	VALA_MEMBER_BINDING_STATIC
} ValaMemberBinding;


#define VALA_TYPE_MEMBER_BINDING (vala_member_binding_get_type ())

#define VALA_TYPE_VALUE_TYPE (vala_value_type_get_type ())
#define VALA_VALUE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_VALUE_TYPE, ValaValueType))
#define VALA_VALUE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_VALUE_TYPE, ValaValueTypeClass))
#define VALA_IS_VALUE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_VALUE_TYPE))
#define VALA_IS_VALUE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_VALUE_TYPE))
#define VALA_VALUE_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_VALUE_TYPE, ValaValueTypeClass))

typedef struct _ValaValueType ValaValueType;
typedef struct _ValaValueTypeClass ValaValueTypeClass;

#define VALA_TYPE_ENUM_VALUE_TYPE (vala_enum_value_type_get_type ())
#define VALA_ENUM_VALUE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ENUM_VALUE_TYPE, ValaEnumValueType))
#define VALA_ENUM_VALUE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ENUM_VALUE_TYPE, ValaEnumValueTypeClass))
#define VALA_IS_ENUM_VALUE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ENUM_VALUE_TYPE))
#define VALA_IS_ENUM_VALUE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ENUM_VALUE_TYPE))
#define VALA_ENUM_VALUE_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ENUM_VALUE_TYPE, ValaEnumValueTypeClass))

typedef struct _ValaEnumValueType ValaEnumValueType;
typedef struct _ValaEnumValueTypeClass ValaEnumValueTypeClass;

#define VALA_TYPE_PARAMETER (vala_parameter_get_type ())
#define VALA_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_PARAMETER, ValaParameter))
#define VALA_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_PARAMETER, ValaParameterClass))
#define VALA_IS_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_PARAMETER))
#define VALA_IS_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_PARAMETER))
#define VALA_PARAMETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_PARAMETER, ValaParameterClass))

typedef struct _ValaParameter ValaParameter;
typedef struct _ValaParameterClass ValaParameterClass;
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))

#define VALA_TYPE_CALLABLE (vala_callable_get_type ())
#define VALA_CALLABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CALLABLE, ValaCallable))
#define VALA_IS_CALLABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CALLABLE))
#define VALA_CALLABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), VALA_TYPE_CALLABLE, ValaCallableIface))

typedef struct _ValaCallable ValaCallable;
typedef struct _ValaCallableIface ValaCallableIface;

#define VALA_TYPE_VOID_TYPE (vala_void_type_get_type ())
#define VALA_VOID_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_VOID_TYPE, ValaVoidType))
#define VALA_VOID_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_VOID_TYPE, ValaVoidTypeClass))
#define VALA_IS_VOID_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_VOID_TYPE))
#define VALA_IS_VOID_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_VOID_TYPE))
#define VALA_VOID_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_VOID_TYPE, ValaVoidTypeClass))

typedef struct _ValaVoidType ValaVoidType;
typedef struct _ValaVoidTypeClass ValaVoidTypeClass;

#define VALA_TYPE_LOCAL_VARIABLE (vala_local_variable_get_type ())
#define VALA_LOCAL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable))
#define VALA_LOCAL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariableClass))
#define VALA_IS_LOCAL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_LOCAL_VARIABLE))
#define VALA_IS_LOCAL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_LOCAL_VARIABLE))
#define VALA_LOCAL_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariableClass))

typedef struct _ValaLocalVariable ValaLocalVariable;
typedef struct _ValaLocalVariableClass ValaLocalVariableClass;

#define VALA_TYPE_SOURCE_FILE (vala_source_file_get_type ())
#define VALA_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFile))
#define VALA_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))
#define VALA_IS_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_FILE))
#define VALA_IS_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_FILE))
#define VALA_SOURCE_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))

typedef struct _ValaSourceFile ValaSourceFile;
typedef struct _ValaSourceFileClass ValaSourceFileClass;

#define VALA_TYPE_SEMANTIC_ANALYZER (vala_semantic_analyzer_get_type ())
#define VALA_SEMANTIC_ANALYZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzer))
#define VALA_SEMANTIC_ANALYZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzerClass))
#define VALA_IS_SEMANTIC_ANALYZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SEMANTIC_ANALYZER))
#define VALA_IS_SEMANTIC_ANALYZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SEMANTIC_ANALYZER))
#define VALA_SEMANTIC_ANALYZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzerClass))

typedef struct _ValaSemanticAnalyzer ValaSemanticAnalyzer;
typedef struct _ValaSemanticAnalyzerClass ValaSemanticAnalyzerClass;
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))

struct _ValaCodeNode {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCodeNodePrivate * priv;
	GList* attributes;
};

struct _ValaCodeNodeClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCodeNode *self);
	void (*accept) (ValaCodeNode* self, ValaCodeVisitor* visitor);
	void (*accept_children) (ValaCodeNode* self, ValaCodeVisitor* visitor);
	gboolean (*check) (ValaCodeNode* self, ValaCodeContext* context);
	void (*emit) (ValaCodeNode* self, ValaCodeGenerator* codegen);
	void (*replace_type) (ValaCodeNode* self, ValaDataType* old_type, ValaDataType* new_type);
	void (*replace_expression) (ValaCodeNode* self, ValaExpression* old_node, ValaExpression* new_node);
	gchar* (*to_string) (ValaCodeNode* self);
	void (*get_defined_variables) (ValaCodeNode* self, ValaCollection* collection);
	void (*get_used_variables) (ValaCodeNode* self, ValaCollection* collection);
};

struct _ValaSymbol {
	ValaCodeNode parent_instance;
	ValaSymbolPrivate * priv;
};

struct _ValaSymbolClass {
	ValaCodeNodeClass parent_class;
	gboolean (*is_instance_member) (ValaSymbol* self);
	gboolean (*is_class_member) (ValaSymbol* self);
	void (*add_namespace) (ValaSymbol* self, ValaNamespace* ns);
	void (*add_class) (ValaSymbol* self, ValaClass* cl);
	void (*add_interface) (ValaSymbol* self, ValaInterface* iface);
	void (*add_struct) (ValaSymbol* self, ValaStruct* st);
	void (*add_enum) (ValaSymbol* self, ValaEnum* en);
	void (*add_error_domain) (ValaSymbol* self, ValaErrorDomain* edomain);
	void (*add_delegate) (ValaSymbol* self, ValaDelegate* d);
	void (*add_constant) (ValaSymbol* self, ValaConstant* constant);
	void (*add_field) (ValaSymbol* self, ValaField* f);
	void (*add_method) (ValaSymbol* self, ValaMethod* m);
	void (*add_property) (ValaSymbol* self, ValaProperty* prop);
	void (*add_signal) (ValaSymbol* self, ValaSignal* sig);
	void (*add_constructor) (ValaSymbol* self, ValaConstructor* c);
	void (*add_destructor) (ValaSymbol* self, ValaDestructor* d);
};

struct _ValaTypeSymbol {
	ValaSymbol parent_instance;
	ValaTypeSymbolPrivate * priv;
};

struct _ValaTypeSymbolClass {
	ValaSymbolClass parent_class;
	gboolean (*is_reference_type) (ValaTypeSymbol* self);
	gboolean (*is_subtype_of) (ValaTypeSymbol* self, ValaTypeSymbol* t);
	gint (*get_type_parameter_index) (ValaTypeSymbol* self, const gchar* name);
};

struct _ValaEnum {
	ValaTypeSymbol parent_instance;
	ValaEnumPrivate * priv;
};

struct _ValaEnumClass {
	ValaTypeSymbolClass parent_class;
};

struct _ValaEnumPrivate {
	ValaList* values;
	ValaList* methods;
	ValaList* constants;
	gboolean* _is_flags;
};

struct _ValaCallableIface {
	GTypeInterface parent_iface;
	void (*add_parameter) (ValaCallable* self, ValaParameter* param);
	ValaList* (*get_parameters) (ValaCallable* self);
	ValaDataType* (*get_return_type) (ValaCallable* self);
	void (*set_return_type) (ValaCallable* self, ValaDataType* value);
};


static gpointer vala_enum_parent_class = NULL;

gpointer vala_code_node_ref (gpointer instance);
void vala_code_node_unref (gpointer instance);
GParamSpec* vala_param_spec_code_node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_node (GValue* value, gpointer v_object);
void vala_value_take_code_node (GValue* value, gpointer v_object);
gpointer vala_value_get_code_node (const GValue* value);
GType vala_code_node_get_type (void) G_GNUC_CONST;
gpointer vala_code_visitor_ref (gpointer instance);
void vala_code_visitor_unref (gpointer instance);
GParamSpec* vala_param_spec_code_visitor (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_visitor (GValue* value, gpointer v_object);
void vala_value_take_code_visitor (GValue* value, gpointer v_object);
gpointer vala_value_get_code_visitor (const GValue* value);
GType vala_code_visitor_get_type (void) G_GNUC_CONST;
gpointer vala_code_context_ref (gpointer instance);
void vala_code_context_unref (gpointer instance);
GParamSpec* vala_param_spec_code_context (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_context (GValue* value, gpointer v_object);
void vala_value_take_code_context (GValue* value, gpointer v_object);
gpointer vala_value_get_code_context (const GValue* value);
GType vala_code_context_get_type (void) G_GNUC_CONST;
GType vala_code_generator_get_type (void) G_GNUC_CONST;
GType vala_data_type_get_type (void) G_GNUC_CONST;
GType vala_expression_get_type (void) G_GNUC_CONST;
GType vala_symbol_get_type (void) G_GNUC_CONST;
GType vala_variable_get_type (void) G_GNUC_CONST;
GType vala_attribute_get_type (void) G_GNUC_CONST;
GType vala_namespace_get_type (void) G_GNUC_CONST;
GType vala_typesymbol_get_type (void) G_GNUC_CONST;
GType vala_object_type_symbol_get_type (void) G_GNUC_CONST;
GType vala_class_get_type (void) G_GNUC_CONST;
GType vala_interface_get_type (void) G_GNUC_CONST;
GType vala_struct_get_type (void) G_GNUC_CONST;
GType vala_enum_get_type (void) G_GNUC_CONST;
GType vala_error_domain_get_type (void) G_GNUC_CONST;
GType vala_delegate_get_type (void) G_GNUC_CONST;
GType vala_constant_get_type (void) G_GNUC_CONST;
GType vala_field_get_type (void) G_GNUC_CONST;
GType vala_subroutine_get_type (void) G_GNUC_CONST;
GType vala_method_get_type (void) G_GNUC_CONST;
GType vala_property_get_type (void) G_GNUC_CONST;
GType vala_signal_get_type (void) G_GNUC_CONST;
GType vala_constructor_get_type (void) G_GNUC_CONST;
GType vala_destructor_get_type (void) G_GNUC_CONST;
GType vala_enum_value_get_type (void) G_GNUC_CONST;
#define VALA_ENUM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_ENUM, ValaEnumPrivate))
enum  {
	VALA_ENUM_0_PROPERTY
};
gpointer vala_source_reference_ref (gpointer instance);
void vala_source_reference_unref (gpointer instance);
GParamSpec* vala_param_spec_source_reference (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_reference (GValue* value, gpointer v_object);
void vala_value_take_source_reference (GValue* value, gpointer v_object);
gpointer vala_value_get_source_reference (const GValue* value);
GType vala_source_reference_get_type (void) G_GNUC_CONST;
gpointer vala_comment_ref (gpointer instance);
void vala_comment_unref (gpointer instance);
GParamSpec* vala_param_spec_comment (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_comment (GValue* value, gpointer v_object);
void vala_value_take_comment (GValue* value, gpointer v_object);
gpointer vala_value_get_comment (const GValue* value);
GType vala_comment_get_type (void) G_GNUC_CONST;
ValaEnum* vala_enum_new (const gchar* name, ValaSourceReference* source_reference, ValaComment* comment);
ValaEnum* vala_enum_construct (GType object_type, const gchar* name, ValaSourceReference* source_reference, ValaComment* comment);
ValaTypeSymbol* vala_typesymbol_construct (GType object_type, const gchar* name, ValaSourceReference* source_reference, ValaComment* comment);
void vala_enum_add_value (ValaEnum* self, ValaEnumValue* value);
GType vala_symbol_accessibility_get_type (void) G_GNUC_CONST;
void vala_symbol_set_access (ValaSymbol* self, ValaSymbolAccessibility value);
gpointer vala_scope_ref (gpointer instance);
void vala_scope_unref (gpointer instance);
GParamSpec* vala_param_spec_scope (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_scope (GValue* value, gpointer v_object);
void vala_value_take_scope (GValue* value, gpointer v_object);
gpointer vala_value_get_scope (const GValue* value);
GType vala_scope_get_type (void) G_GNUC_CONST;
ValaScope* vala_symbol_get_scope (ValaSymbol* self);
void vala_scope_add (ValaScope* self, const gchar* name, ValaSymbol* sym);
const gchar* vala_symbol_get_name (ValaSymbol* self);
static void vala_enum_real_add_method (ValaSymbol* base, ValaMethod* m);
GType vala_creation_method_get_type (void) G_GNUC_CONST;
void vala_report_error (ValaSourceReference* source, const gchar* message);
ValaSourceReference* vala_code_node_get_source_reference (ValaCodeNode* self);
void vala_code_node_set_error (ValaCodeNode* self, gboolean value);
GType vala_member_binding_get_type (void) G_GNUC_CONST;
ValaMemberBinding vala_method_get_binding (ValaMethod* self);
ValaEnumValueType* vala_enum_value_type_new (ValaEnum* type_symbol);
ValaEnumValueType* vala_enum_value_type_construct (GType object_type, ValaEnum* type_symbol);
GType vala_value_type_get_type (void) G_GNUC_CONST;
GType vala_enum_value_type_get_type (void) G_GNUC_CONST;
ValaParameter* vala_parameter_new (const gchar* name, ValaDataType* variable_type, ValaSourceReference* source_reference);
ValaParameter* vala_parameter_construct (GType object_type, const gchar* name, ValaDataType* variable_type, ValaSourceReference* source_reference);
GType vala_parameter_get_type (void) G_GNUC_CONST;
void vala_method_set_this_parameter (ValaMethod* self, ValaParameter* value);
ValaParameter* vala_method_get_this_parameter (ValaMethod* self);
GType vala_callable_get_type (void) G_GNUC_CONST;
ValaDataType* vala_callable_get_return_type (ValaCallable* self);
GType vala_void_type_get_type (void) G_GNUC_CONST;
ValaList* vala_method_get_postconditions (ValaMethod* self);
ValaDataType* vala_data_type_copy (ValaDataType* self);
ValaLocalVariable* vala_local_variable_new (ValaDataType* variable_type, const gchar* name, ValaExpression* initializer, ValaSourceReference* source_reference);
ValaLocalVariable* vala_local_variable_construct (GType object_type, ValaDataType* variable_type, const gchar* name, ValaExpression* initializer, ValaSourceReference* source_reference);
GType vala_local_variable_get_type (void) G_GNUC_CONST;
void vala_subroutine_set_result_var (ValaSubroutine* self, ValaLocalVariable* value);
ValaLocalVariable* vala_subroutine_get_result_var (ValaSubroutine* self);
void vala_local_variable_set_is_result (ValaLocalVariable* self, gboolean value);
static void vala_enum_real_add_constant (ValaSymbol* base, ValaConstant* c);
ValaList* vala_enum_get_values (ValaEnum* self);
void vala_enum_remove_all_values (ValaEnum* self);
ValaList* vala_enum_get_methods (ValaEnum* self);
ValaList* vala_enum_get_constants (ValaEnum* self);
static void vala_enum_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
void vala_code_visitor_visit_enum (ValaCodeVisitor* self, ValaEnum* en);
static void vala_enum_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
void vala_code_node_accept (ValaCodeNode* self, ValaCodeVisitor* visitor);
static gboolean vala_enum_real_is_reference_type (ValaTypeSymbol* base);
static gboolean vala_enum_real_check (ValaCodeNode* base, ValaCodeContext* context);
gboolean vala_code_node_get_checked (ValaCodeNode* self);
gboolean vala_code_node_get_error (ValaCodeNode* self);
void vala_code_node_set_checked (ValaCodeNode* self, gboolean value);
gpointer vala_source_file_ref (gpointer instance);
void vala_source_file_unref (gpointer instance);
GParamSpec* vala_param_spec_source_file (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_file (GValue* value, gpointer v_object);
void vala_value_take_source_file (GValue* value, gpointer v_object);
gpointer vala_value_get_source_file (const GValue* value);
GType vala_source_file_get_type (void) G_GNUC_CONST;
GType vala_semantic_analyzer_get_type (void) G_GNUC_CONST;
ValaSemanticAnalyzer* vala_code_context_get_analyzer (ValaCodeContext* self);
ValaSourceFile* vala_semantic_analyzer_get_current_source_file (ValaSemanticAnalyzer* self);
ValaSymbol* vala_semantic_analyzer_get_current_symbol (ValaSemanticAnalyzer* self);
ValaSourceFile* vala_source_reference_get_file (ValaSourceReference* self);
void vala_semantic_analyzer_set_current_source_file (ValaSemanticAnalyzer* self, ValaSourceFile* value);
void vala_semantic_analyzer_set_current_symbol (ValaSemanticAnalyzer* self, ValaSymbol* value);
gchar* vala_symbol_get_full_name (ValaSymbol* self);
gboolean vala_code_node_check (ValaCodeNode* self, ValaCodeContext* context);
gboolean vala_enum_get_is_flags (ValaEnum* self);
ValaAttribute* vala_code_node_get_attribute (ValaCodeNode* self, const gchar* name);
static gboolean* _bool_dup (gboolean* self);
static void vala_enum_finalize (ValaCodeNode * obj);


/**
 * Creates a new enum.
 *
 * @param name             type name
 * @param source_reference reference to source code
 * @return                 newly created enum
 */
ValaEnum* vala_enum_construct (GType object_type, const gchar* name, ValaSourceReference* source_reference, ValaComment* comment) {
	ValaEnum* self = NULL;
	const gchar* _tmp0_;
	ValaSourceReference* _tmp1_;
	ValaComment* _tmp2_;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = name;
	_tmp1_ = source_reference;
	_tmp2_ = comment;
	self = (ValaEnum*) vala_typesymbol_construct (object_type, _tmp0_, _tmp1_, _tmp2_);
	return self;
}


ValaEnum* vala_enum_new (const gchar* name, ValaSourceReference* source_reference, ValaComment* comment) {
	return vala_enum_construct (VALA_TYPE_ENUM, name, source_reference, comment);
}


/**
 * Appends the specified enum value to the list of values.
 *
 * @param value an enum value
 */
void vala_enum_add_value (ValaEnum* self, ValaEnumValue* value) {
	ValaEnumValue* _tmp0_;
	ValaList* _tmp1_;
	ValaEnumValue* _tmp2_;
	ValaScope* _tmp3_;
	ValaScope* _tmp4_;
	ValaEnumValue* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	ValaEnumValue* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (value != NULL);
	_tmp0_ = value;
	vala_symbol_set_access ((ValaSymbol*) _tmp0_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	_tmp1_ = self->priv->values;
	_tmp2_ = value;
	vala_collection_add ((ValaCollection*) _tmp1_, _tmp2_);
	_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp4_ = _tmp3_;
	_tmp5_ = value;
	_tmp6_ = vala_symbol_get_name ((ValaSymbol*) _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = value;
	vala_scope_add (_tmp4_, _tmp7_, (ValaSymbol*) _tmp8_);
}


/**
 * Adds the specified method as a member to this enum.
 *
 * @param m a method
 */
static void vala_enum_real_add_method (ValaSymbol* base, ValaMethod* m) {
	ValaEnum * self;
	ValaMethod* _tmp0_;
	ValaMethod* _tmp5_;
	ValaMemberBinding _tmp6_;
	ValaMemberBinding _tmp7_;
	gboolean _tmp24_ = FALSE;
	ValaMethod* _tmp25_;
	ValaDataType* _tmp26_;
	ValaDataType* _tmp27_;
	ValaList* _tmp46_;
	ValaMethod* _tmp47_;
	ValaScope* _tmp48_;
	ValaScope* _tmp49_;
	ValaMethod* _tmp50_;
	const gchar* _tmp51_;
	const gchar* _tmp52_;
	ValaMethod* _tmp53_;
	self = (ValaEnum*) base;
	g_return_if_fail (m != NULL);
	_tmp0_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, VALA_TYPE_CREATION_METHOD)) {
		ValaMethod* _tmp1_;
		ValaSourceReference* _tmp2_;
		ValaSourceReference* _tmp3_;
		ValaMethod* _tmp4_;
		_tmp1_ = m;
		_tmp2_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1_);
		_tmp3_ = _tmp2_;
		vala_report_error (_tmp3_, "construction methods may only be declared within classes and structs");
		_tmp4_ = m;
		vala_code_node_set_error ((ValaCodeNode*) _tmp4_, TRUE);
		return;
	}
	_tmp5_ = m;
	_tmp6_ = vala_method_get_binding (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp7_ == VALA_MEMBER_BINDING_INSTANCE) {
		ValaMethod* _tmp8_;
		ValaEnumValueType* _tmp9_;
		ValaEnumValueType* _tmp10_;
		ValaParameter* _tmp11_;
		ValaParameter* _tmp12_;
		ValaMethod* _tmp13_;
		ValaScope* _tmp14_;
		ValaScope* _tmp15_;
		ValaMethod* _tmp16_;
		ValaParameter* _tmp17_;
		ValaParameter* _tmp18_;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		ValaMethod* _tmp21_;
		ValaParameter* _tmp22_;
		ValaParameter* _tmp23_;
		_tmp8_ = m;
		_tmp9_ = vala_enum_value_type_new (self);
		_tmp10_ = _tmp9_;
		_tmp11_ = vala_parameter_new ("this", (ValaDataType*) _tmp10_, NULL);
		_tmp12_ = _tmp11_;
		vala_method_set_this_parameter (_tmp8_, _tmp12_);
		_vala_code_node_unref0 (_tmp12_);
		_vala_code_node_unref0 (_tmp10_);
		_tmp13_ = m;
		_tmp14_ = vala_symbol_get_scope ((ValaSymbol*) _tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = m;
		_tmp17_ = vala_method_get_this_parameter (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = vala_symbol_get_name ((ValaSymbol*) _tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = m;
		_tmp22_ = vala_method_get_this_parameter (_tmp21_);
		_tmp23_ = _tmp22_;
		vala_scope_add (_tmp15_, _tmp20_, (ValaSymbol*) _tmp23_);
	}
	_tmp25_ = m;
	_tmp26_ = vala_callable_get_return_type ((ValaCallable*) _tmp25_);
	_tmp27_ = _tmp26_;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp27_, VALA_TYPE_VOID_TYPE)) {
		ValaMethod* _tmp28_;
		ValaList* _tmp29_;
		ValaList* _tmp30_;
		gint _tmp31_;
		gint _tmp32_;
		_tmp28_ = m;
		_tmp29_ = vala_method_get_postconditions (_tmp28_);
		_tmp30_ = _tmp29_;
		_tmp31_ = vala_collection_get_size ((ValaCollection*) _tmp30_);
		_tmp32_ = _tmp31_;
		_tmp24_ = _tmp32_ > 0;
		_vala_iterable_unref0 (_tmp30_);
	} else {
		_tmp24_ = FALSE;
	}
	if (_tmp24_) {
		ValaMethod* _tmp33_;
		ValaMethod* _tmp34_;
		ValaDataType* _tmp35_;
		ValaDataType* _tmp36_;
		ValaDataType* _tmp37_;
		ValaDataType* _tmp38_;
		ValaSourceReference* _tmp39_;
		ValaSourceReference* _tmp40_;
		ValaLocalVariable* _tmp41_;
		ValaLocalVariable* _tmp42_;
		ValaMethod* _tmp43_;
		ValaLocalVariable* _tmp44_;
		ValaLocalVariable* _tmp45_;
		_tmp33_ = m;
		_tmp34_ = m;
		_tmp35_ = vala_callable_get_return_type ((ValaCallable*) _tmp34_);
		_tmp36_ = _tmp35_;
		_tmp37_ = vala_data_type_copy (_tmp36_);
		_tmp38_ = _tmp37_;
		_tmp39_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp40_ = _tmp39_;
		_tmp41_ = vala_local_variable_new (_tmp38_, "result", NULL, _tmp40_);
		_tmp42_ = _tmp41_;
		vala_subroutine_set_result_var ((ValaSubroutine*) _tmp33_, _tmp42_);
		_vala_code_node_unref0 (_tmp42_);
		_vala_code_node_unref0 (_tmp38_);
		_tmp43_ = m;
		_tmp44_ = vala_subroutine_get_result_var ((ValaSubroutine*) _tmp43_);
		_tmp45_ = _tmp44_;
		vala_local_variable_set_is_result (_tmp45_, TRUE);
	}
	_tmp46_ = self->priv->methods;
	_tmp47_ = m;
	vala_collection_add ((ValaCollection*) _tmp46_, _tmp47_);
	_tmp48_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp49_ = _tmp48_;
	_tmp50_ = m;
	_tmp51_ = vala_symbol_get_name ((ValaSymbol*) _tmp50_);
	_tmp52_ = _tmp51_;
	_tmp53_ = m;
	vala_scope_add (_tmp49_, _tmp52_, (ValaSymbol*) _tmp53_);
}


/**
 * Adds the specified constant as a member to this enum.
 *
 * @param c a constant
 */
static void vala_enum_real_add_constant (ValaSymbol* base, ValaConstant* c) {
	ValaEnum * self;
	ValaList* _tmp0_;
	ValaConstant* _tmp1_;
	ValaScope* _tmp2_;
	ValaScope* _tmp3_;
	ValaConstant* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	ValaConstant* _tmp7_;
	self = (ValaEnum*) base;
	g_return_if_fail (c != NULL);
	_tmp0_ = self->priv->constants;
	_tmp1_ = c;
	vala_collection_add ((ValaCollection*) _tmp0_, _tmp1_);
	_tmp2_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = c;
	_tmp5_ = vala_symbol_get_name ((ValaSymbol*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = c;
	vala_scope_add (_tmp3_, _tmp6_, (ValaSymbol*) _tmp7_);
}


/**
 * Returns a copy of the list of enum values.
 *
 * @return list of enum values
 */
static gpointer _vala_iterable_ref0 (gpointer self) {
	return self ? vala_iterable_ref (self) : NULL;
}


ValaList* vala_enum_get_values (ValaEnum* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->values;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


void vala_enum_remove_all_values (ValaEnum* self) {
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->values;
	vala_collection_clear ((ValaCollection*) _tmp0_);
}


/**
 * Returns a copy of the list of methods.
 *
 * @return list of methods
 */
ValaList* vala_enum_get_methods (ValaEnum* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->methods;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Returns a copy of the list of constants.
 *
 * @return list of constants
 */
ValaList* vala_enum_get_constants (ValaEnum* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->constants;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


static void vala_enum_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaEnum * self;
	ValaCodeVisitor* _tmp0_;
	self = (ValaEnum*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = visitor;
	vala_code_visitor_visit_enum (_tmp0_, self);
}


static void vala_enum_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaEnum * self;
	self = (ValaEnum*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _value_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _value_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _value_index = 0;
		_tmp0_ = self->priv->values;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_value_list = _tmp1_;
		_tmp2_ = _value_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_value_size = _tmp4_;
		_value_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaEnumValue* value = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValaEnumValue* _tmp11_;
			ValaCodeVisitor* _tmp12_;
			_tmp5_ = _value_index;
			_value_index = _tmp5_ + 1;
			_tmp6_ = _value_index;
			_tmp7_ = _value_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _value_list;
			_tmp9_ = _value_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			value = (ValaEnumValue*) _tmp10_;
			_tmp11_ = value;
			_tmp12_ = visitor;
			vala_code_node_accept ((ValaCodeNode*) _tmp11_, _tmp12_);
			_vala_code_node_unref0 (value);
		}
		_vala_iterable_unref0 (_value_list);
	}
	{
		ValaList* _m_list = NULL;
		ValaList* _tmp13_;
		ValaList* _tmp14_;
		gint _m_size = 0;
		ValaList* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		gint _m_index = 0;
		_tmp13_ = self->priv->methods;
		_tmp14_ = _vala_iterable_ref0 (_tmp13_);
		_m_list = _tmp14_;
		_tmp15_ = _m_list;
		_tmp16_ = vala_collection_get_size ((ValaCollection*) _tmp15_);
		_tmp17_ = _tmp16_;
		_m_size = _tmp17_;
		_m_index = -1;
		while (TRUE) {
			gint _tmp18_;
			gint _tmp19_;
			gint _tmp20_;
			ValaMethod* m = NULL;
			ValaList* _tmp21_;
			gint _tmp22_;
			gpointer _tmp23_;
			ValaMethod* _tmp24_;
			ValaCodeVisitor* _tmp25_;
			_tmp18_ = _m_index;
			_m_index = _tmp18_ + 1;
			_tmp19_ = _m_index;
			_tmp20_ = _m_size;
			if (!(_tmp19_ < _tmp20_)) {
				break;
			}
			_tmp21_ = _m_list;
			_tmp22_ = _m_index;
			_tmp23_ = vala_list_get (_tmp21_, _tmp22_);
			m = (ValaMethod*) _tmp23_;
			_tmp24_ = m;
			_tmp25_ = visitor;
			vala_code_node_accept ((ValaCodeNode*) _tmp24_, _tmp25_);
			_vala_code_node_unref0 (m);
		}
		_vala_iterable_unref0 (_m_list);
	}
	{
		ValaList* _c_list = NULL;
		ValaList* _tmp26_;
		ValaList* _tmp27_;
		gint _c_size = 0;
		ValaList* _tmp28_;
		gint _tmp29_;
		gint _tmp30_;
		gint _c_index = 0;
		_tmp26_ = self->priv->constants;
		_tmp27_ = _vala_iterable_ref0 (_tmp26_);
		_c_list = _tmp27_;
		_tmp28_ = _c_list;
		_tmp29_ = vala_collection_get_size ((ValaCollection*) _tmp28_);
		_tmp30_ = _tmp29_;
		_c_size = _tmp30_;
		_c_index = -1;
		while (TRUE) {
			gint _tmp31_;
			gint _tmp32_;
			gint _tmp33_;
			ValaConstant* c = NULL;
			ValaList* _tmp34_;
			gint _tmp35_;
			gpointer _tmp36_;
			ValaConstant* _tmp37_;
			ValaCodeVisitor* _tmp38_;
			_tmp31_ = _c_index;
			_c_index = _tmp31_ + 1;
			_tmp32_ = _c_index;
			_tmp33_ = _c_size;
			if (!(_tmp32_ < _tmp33_)) {
				break;
			}
			_tmp34_ = _c_list;
			_tmp35_ = _c_index;
			_tmp36_ = vala_list_get (_tmp34_, _tmp35_);
			c = (ValaConstant*) _tmp36_;
			_tmp37_ = c;
			_tmp38_ = visitor;
			vala_code_node_accept ((ValaCodeNode*) _tmp37_, _tmp38_);
			_vala_code_node_unref0 (c);
		}
		_vala_iterable_unref0 (_c_list);
	}
}


static gboolean vala_enum_real_is_reference_type (ValaTypeSymbol* base) {
	ValaEnum * self;
	gboolean result = FALSE;
	self = (ValaEnum*) base;
	result = FALSE;
	return result;
}


static gpointer _vala_source_file_ref0 (gpointer self) {
	return self ? vala_source_file_ref (self) : NULL;
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


static gboolean vala_enum_real_check (ValaCodeNode* base, ValaCodeContext* context) {
	ValaEnum * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaSourceFile* old_source_file = NULL;
	ValaCodeContext* _tmp4_;
	ValaSemanticAnalyzer* _tmp5_;
	ValaSemanticAnalyzer* _tmp6_;
	ValaSourceFile* _tmp7_;
	ValaSourceFile* _tmp8_;
	ValaSourceFile* _tmp9_;
	ValaSymbol* old_symbol = NULL;
	ValaCodeContext* _tmp10_;
	ValaSemanticAnalyzer* _tmp11_;
	ValaSemanticAnalyzer* _tmp12_;
	ValaSymbol* _tmp13_;
	ValaSymbol* _tmp14_;
	ValaSymbol* _tmp15_;
	ValaSourceReference* _tmp16_;
	ValaSourceReference* _tmp17_;
	ValaCodeContext* _tmp25_;
	ValaSemanticAnalyzer* _tmp26_;
	ValaSemanticAnalyzer* _tmp27_;
	ValaList* _tmp28_;
	gint _tmp29_;
	gint _tmp30_;
	ValaCodeContext* _tmp76_;
	ValaSemanticAnalyzer* _tmp77_;
	ValaSemanticAnalyzer* _tmp78_;
	ValaSourceFile* _tmp79_;
	ValaCodeContext* _tmp80_;
	ValaSemanticAnalyzer* _tmp81_;
	ValaSemanticAnalyzer* _tmp82_;
	ValaSymbol* _tmp83_;
	gboolean _tmp84_;
	gboolean _tmp85_;
	self = (ValaEnum*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = context;
	_tmp5_ = vala_code_context_get_analyzer (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_semantic_analyzer_get_current_source_file (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = _vala_source_file_ref0 (_tmp8_);
	old_source_file = _tmp9_;
	_tmp10_ = context;
	_tmp11_ = vala_code_context_get_analyzer (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = vala_semantic_analyzer_get_current_symbol (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = _vala_code_node_ref0 (_tmp14_);
	old_symbol = _tmp15_;
	_tmp16_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp17_ = _tmp16_;
	if (_tmp17_ != NULL) {
		ValaCodeContext* _tmp18_;
		ValaSemanticAnalyzer* _tmp19_;
		ValaSemanticAnalyzer* _tmp20_;
		ValaSourceReference* _tmp21_;
		ValaSourceReference* _tmp22_;
		ValaSourceFile* _tmp23_;
		ValaSourceFile* _tmp24_;
		_tmp18_ = context;
		_tmp19_ = vala_code_context_get_analyzer (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp22_ = _tmp21_;
		_tmp23_ = vala_source_reference_get_file (_tmp22_);
		_tmp24_ = _tmp23_;
		vala_semantic_analyzer_set_current_source_file (_tmp20_, _tmp24_);
	}
	_tmp25_ = context;
	_tmp26_ = vala_code_context_get_analyzer (_tmp25_);
	_tmp27_ = _tmp26_;
	vala_semantic_analyzer_set_current_symbol (_tmp27_, (ValaSymbol*) self);
	_tmp28_ = self->priv->values;
	_tmp29_ = vala_collection_get_size ((ValaCollection*) _tmp28_);
	_tmp30_ = _tmp29_;
	if (_tmp30_ <= 0) {
		ValaSourceReference* _tmp31_;
		ValaSourceReference* _tmp32_;
		gchar* _tmp33_;
		gchar* _tmp34_;
		gchar* _tmp35_;
		gchar* _tmp36_;
		_tmp31_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp32_ = _tmp31_;
		_tmp33_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp34_ = _tmp33_;
		_tmp35_ = g_strdup_printf ("Enum `%s' requires at least one value", _tmp34_);
		_tmp36_ = _tmp35_;
		vala_report_error (_tmp32_, _tmp36_);
		_g_free0 (_tmp36_);
		_g_free0 (_tmp34_);
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	{
		ValaList* _value_list = NULL;
		ValaList* _tmp37_;
		ValaList* _tmp38_;
		gint _value_size = 0;
		ValaList* _tmp39_;
		gint _tmp40_;
		gint _tmp41_;
		gint _value_index = 0;
		_tmp37_ = self->priv->values;
		_tmp38_ = _vala_iterable_ref0 (_tmp37_);
		_value_list = _tmp38_;
		_tmp39_ = _value_list;
		_tmp40_ = vala_collection_get_size ((ValaCollection*) _tmp39_);
		_tmp41_ = _tmp40_;
		_value_size = _tmp41_;
		_value_index = -1;
		while (TRUE) {
			gint _tmp42_;
			gint _tmp43_;
			gint _tmp44_;
			ValaEnumValue* value = NULL;
			ValaList* _tmp45_;
			gint _tmp46_;
			gpointer _tmp47_;
			ValaEnumValue* _tmp48_;
			ValaCodeContext* _tmp49_;
			_tmp42_ = _value_index;
			_value_index = _tmp42_ + 1;
			_tmp43_ = _value_index;
			_tmp44_ = _value_size;
			if (!(_tmp43_ < _tmp44_)) {
				break;
			}
			_tmp45_ = _value_list;
			_tmp46_ = _value_index;
			_tmp47_ = vala_list_get (_tmp45_, _tmp46_);
			value = (ValaEnumValue*) _tmp47_;
			_tmp48_ = value;
			_tmp49_ = context;
			vala_code_node_check ((ValaCodeNode*) _tmp48_, _tmp49_);
			_vala_code_node_unref0 (value);
		}
		_vala_iterable_unref0 (_value_list);
	}
	{
		ValaList* _m_list = NULL;
		ValaList* _tmp50_;
		ValaList* _tmp51_;
		gint _m_size = 0;
		ValaList* _tmp52_;
		gint _tmp53_;
		gint _tmp54_;
		gint _m_index = 0;
		_tmp50_ = self->priv->methods;
		_tmp51_ = _vala_iterable_ref0 (_tmp50_);
		_m_list = _tmp51_;
		_tmp52_ = _m_list;
		_tmp53_ = vala_collection_get_size ((ValaCollection*) _tmp52_);
		_tmp54_ = _tmp53_;
		_m_size = _tmp54_;
		_m_index = -1;
		while (TRUE) {
			gint _tmp55_;
			gint _tmp56_;
			gint _tmp57_;
			ValaMethod* m = NULL;
			ValaList* _tmp58_;
			gint _tmp59_;
			gpointer _tmp60_;
			ValaMethod* _tmp61_;
			ValaCodeContext* _tmp62_;
			_tmp55_ = _m_index;
			_m_index = _tmp55_ + 1;
			_tmp56_ = _m_index;
			_tmp57_ = _m_size;
			if (!(_tmp56_ < _tmp57_)) {
				break;
			}
			_tmp58_ = _m_list;
			_tmp59_ = _m_index;
			_tmp60_ = vala_list_get (_tmp58_, _tmp59_);
			m = (ValaMethod*) _tmp60_;
			_tmp61_ = m;
			_tmp62_ = context;
			vala_code_node_check ((ValaCodeNode*) _tmp61_, _tmp62_);
			_vala_code_node_unref0 (m);
		}
		_vala_iterable_unref0 (_m_list);
	}
	{
		ValaList* _c_list = NULL;
		ValaList* _tmp63_;
		ValaList* _tmp64_;
		gint _c_size = 0;
		ValaList* _tmp65_;
		gint _tmp66_;
		gint _tmp67_;
		gint _c_index = 0;
		_tmp63_ = self->priv->constants;
		_tmp64_ = _vala_iterable_ref0 (_tmp63_);
		_c_list = _tmp64_;
		_tmp65_ = _c_list;
		_tmp66_ = vala_collection_get_size ((ValaCollection*) _tmp65_);
		_tmp67_ = _tmp66_;
		_c_size = _tmp67_;
		_c_index = -1;
		while (TRUE) {
			gint _tmp68_;
			gint _tmp69_;
			gint _tmp70_;
			ValaConstant* c = NULL;
			ValaList* _tmp71_;
			gint _tmp72_;
			gpointer _tmp73_;
			ValaConstant* _tmp74_;
			ValaCodeContext* _tmp75_;
			_tmp68_ = _c_index;
			_c_index = _tmp68_ + 1;
			_tmp69_ = _c_index;
			_tmp70_ = _c_size;
			if (!(_tmp69_ < _tmp70_)) {
				break;
			}
			_tmp71_ = _c_list;
			_tmp72_ = _c_index;
			_tmp73_ = vala_list_get (_tmp71_, _tmp72_);
			c = (ValaConstant*) _tmp73_;
			_tmp74_ = c;
			_tmp75_ = context;
			vala_code_node_check ((ValaCodeNode*) _tmp74_, _tmp75_);
			_vala_code_node_unref0 (c);
		}
		_vala_iterable_unref0 (_c_list);
	}
	_tmp76_ = context;
	_tmp77_ = vala_code_context_get_analyzer (_tmp76_);
	_tmp78_ = _tmp77_;
	_tmp79_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp78_, _tmp79_);
	_tmp80_ = context;
	_tmp81_ = vala_code_context_get_analyzer (_tmp80_);
	_tmp82_ = _tmp81_;
	_tmp83_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp82_, _tmp83_);
	_tmp84_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp85_ = _tmp84_;
	result = !_tmp85_;
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}


static gboolean* _bool_dup (gboolean* self) {
	gboolean* dup;
	dup = g_new0 (gboolean, 1);
	memcpy (dup, self, sizeof (gboolean));
	return dup;
}


static gpointer __bool_dup0 (gpointer self) {
	return self ? _bool_dup (self) : NULL;
}


gboolean vala_enum_get_is_flags (ValaEnum* self) {
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp5_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_flags;
	if (_tmp0_ == NULL) {
		ValaAttribute* _tmp1_;
		ValaAttribute* _tmp2_;
		gboolean _tmp3_;
		gboolean* _tmp4_;
		_tmp1_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "Flags");
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_ != NULL;
		_tmp4_ = __bool_dup0 (&_tmp3_);
		_g_free0 (self->priv->_is_flags);
		self->priv->_is_flags = _tmp4_;
		_vala_code_node_unref0 (_tmp2_);
	}
	_tmp5_ = self->priv->_is_flags;
	result = *_tmp5_;
	return result;
}


static void vala_enum_class_init (ValaEnumClass * klass) {
	vala_enum_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_enum_finalize;
	g_type_class_add_private (klass, sizeof (ValaEnumPrivate));
	((ValaSymbolClass *) klass)->add_method = (void (*) (ValaSymbol*, ValaMethod*)) vala_enum_real_add_method;
	((ValaSymbolClass *) klass)->add_constant = (void (*) (ValaSymbol*, ValaConstant*)) vala_enum_real_add_constant;
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_enum_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_enum_real_accept_children;
	((ValaTypeSymbolClass *) klass)->is_reference_type = (gboolean (*) (ValaTypeSymbol*)) vala_enum_real_is_reference_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_enum_real_check;
}


static void vala_enum_instance_init (ValaEnum * self) {
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GEqualFunc _tmp2_;
	ValaArrayList* _tmp3_;
	GEqualFunc _tmp4_;
	ValaArrayList* _tmp5_;
	self->priv = VALA_ENUM_GET_PRIVATE (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_ENUM_VALUE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->values = (ValaList*) _tmp1_;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_array_list_new (VALA_TYPE_METHOD, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp2_);
	self->priv->methods = (ValaList*) _tmp3_;
	_tmp4_ = g_direct_equal;
	_tmp5_ = vala_array_list_new (VALA_TYPE_CONSTANT, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp4_);
	self->priv->constants = (ValaList*) _tmp5_;
}


static void vala_enum_finalize (ValaCodeNode * obj) {
	ValaEnum * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_ENUM, ValaEnum);
	_vala_iterable_unref0 (self->priv->values);
	_vala_iterable_unref0 (self->priv->methods);
	_vala_iterable_unref0 (self->priv->constants);
	_g_free0 (self->priv->_is_flags);
	VALA_CODE_NODE_CLASS (vala_enum_parent_class)->finalize (obj);
}


/**
 * Represents an enum declaration in the source code.
 */
GType vala_enum_get_type (void) {
	static volatile gsize vala_enum_type_id__volatile = 0;
	if (g_once_init_enter (&vala_enum_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaEnumClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_enum_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaEnum), 0, (GInstanceInitFunc) vala_enum_instance_init, NULL };
		GType vala_enum_type_id;
		vala_enum_type_id = g_type_register_static (VALA_TYPE_TYPESYMBOL, "ValaEnum", &g_define_type_info, 0);
		g_once_init_leave (&vala_enum_type_id__volatile, vala_enum_type_id);
	}
	return vala_enum_type_id__volatile;
}



