/* valaproperty.c generated by valac, the Vala compiler
 * generated from valaproperty.vala, do not modify */

/* valaproperty.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>


#define VALA_TYPE_CODE_NODE (vala_code_node_get_type ())
#define VALA_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_NODE, ValaCodeNode))
#define VALA_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))
#define VALA_IS_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_NODE))
#define VALA_IS_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_NODE))
#define VALA_CODE_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))

typedef struct _ValaCodeNode ValaCodeNode;
typedef struct _ValaCodeNodeClass ValaCodeNodeClass;
typedef struct _ValaCodeNodePrivate ValaCodeNodePrivate;

#define VALA_TYPE_CODE_VISITOR (vala_code_visitor_get_type ())
#define VALA_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitor))
#define VALA_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))
#define VALA_IS_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_VISITOR))
#define VALA_IS_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_VISITOR))
#define VALA_CODE_VISITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))

typedef struct _ValaCodeVisitor ValaCodeVisitor;
typedef struct _ValaCodeVisitorClass ValaCodeVisitorClass;

#define VALA_TYPE_CODE_CONTEXT (vala_code_context_get_type ())
#define VALA_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContext))
#define VALA_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))
#define VALA_IS_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_CONTEXT))
#define VALA_IS_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_CONTEXT))
#define VALA_CODE_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))

typedef struct _ValaCodeContext ValaCodeContext;
typedef struct _ValaCodeContextClass ValaCodeContextClass;

#define VALA_TYPE_CODE_GENERATOR (vala_code_generator_get_type ())
#define VALA_CODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_GENERATOR, ValaCodeGenerator))
#define VALA_CODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_GENERATOR, ValaCodeGeneratorClass))
#define VALA_IS_CODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_GENERATOR))
#define VALA_IS_CODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_GENERATOR))
#define VALA_CODE_GENERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_GENERATOR, ValaCodeGeneratorClass))

typedef struct _ValaCodeGenerator ValaCodeGenerator;
typedef struct _ValaCodeGeneratorClass ValaCodeGeneratorClass;

#define VALA_TYPE_DATA_TYPE (vala_data_type_get_type ())
#define VALA_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DATA_TYPE, ValaDataType))
#define VALA_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))
#define VALA_IS_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DATA_TYPE))
#define VALA_IS_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DATA_TYPE))
#define VALA_DATA_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))

typedef struct _ValaDataType ValaDataType;
typedef struct _ValaDataTypeClass ValaDataTypeClass;

#define VALA_TYPE_EXPRESSION (vala_expression_get_type ())
#define VALA_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_EXPRESSION, ValaExpression))
#define VALA_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_EXPRESSION, ValaExpressionClass))
#define VALA_IS_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_EXPRESSION))
#define VALA_IS_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_EXPRESSION))
#define VALA_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_EXPRESSION, ValaExpressionClass))

typedef struct _ValaExpression ValaExpression;
typedef struct _ValaExpressionClass ValaExpressionClass;

#define VALA_TYPE_SYMBOL (vala_symbol_get_type ())
#define VALA_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SYMBOL, ValaSymbol))
#define VALA_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SYMBOL, ValaSymbolClass))
#define VALA_IS_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SYMBOL))
#define VALA_IS_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SYMBOL))
#define VALA_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SYMBOL, ValaSymbolClass))

typedef struct _ValaSymbol ValaSymbol;
typedef struct _ValaSymbolClass ValaSymbolClass;

#define VALA_TYPE_VARIABLE (vala_variable_get_type ())
#define VALA_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_VARIABLE, ValaVariable))
#define VALA_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_VARIABLE, ValaVariableClass))
#define VALA_IS_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_VARIABLE))
#define VALA_IS_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_VARIABLE))
#define VALA_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_VARIABLE, ValaVariableClass))

typedef struct _ValaVariable ValaVariable;
typedef struct _ValaVariableClass ValaVariableClass;

#define VALA_TYPE_ATTRIBUTE (vala_attribute_get_type ())
#define VALA_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ATTRIBUTE, ValaAttribute))
#define VALA_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))
#define VALA_IS_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ATTRIBUTE))
#define VALA_IS_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ATTRIBUTE))
#define VALA_ATTRIBUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))

typedef struct _ValaAttribute ValaAttribute;
typedef struct _ValaAttributeClass ValaAttributeClass;
typedef struct _ValaSymbolPrivate ValaSymbolPrivate;

#define VALA_TYPE_NAMESPACE (vala_namespace_get_type ())
#define VALA_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_NAMESPACE, ValaNamespace))
#define VALA_NAMESPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_NAMESPACE, ValaNamespaceClass))
#define VALA_IS_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_NAMESPACE))
#define VALA_IS_NAMESPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_NAMESPACE))
#define VALA_NAMESPACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_NAMESPACE, ValaNamespaceClass))

typedef struct _ValaNamespace ValaNamespace;
typedef struct _ValaNamespaceClass ValaNamespaceClass;

#define VALA_TYPE_TYPESYMBOL (vala_typesymbol_get_type ())
#define VALA_TYPESYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPESYMBOL, ValaTypeSymbol))
#define VALA_TYPESYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPESYMBOL, ValaTypeSymbolClass))
#define VALA_IS_TYPESYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPESYMBOL))
#define VALA_IS_TYPESYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPESYMBOL))
#define VALA_TYPESYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPESYMBOL, ValaTypeSymbolClass))

typedef struct _ValaTypeSymbol ValaTypeSymbol;
typedef struct _ValaTypeSymbolClass ValaTypeSymbolClass;

#define VALA_TYPE_OBJECT_TYPE_SYMBOL (vala_object_type_symbol_get_type ())
#define VALA_OBJECT_TYPE_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol))
#define VALA_OBJECT_TYPE_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbolClass))
#define VALA_IS_OBJECT_TYPE_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL))
#define VALA_IS_OBJECT_TYPE_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_OBJECT_TYPE_SYMBOL))
#define VALA_OBJECT_TYPE_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbolClass))

typedef struct _ValaObjectTypeSymbol ValaObjectTypeSymbol;
typedef struct _ValaObjectTypeSymbolClass ValaObjectTypeSymbolClass;

#define VALA_TYPE_CLASS (vala_class_get_type ())
#define VALA_CLASS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CLASS, ValaClass))
#define VALA_CLASS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CLASS, ValaClassClass))
#define VALA_IS_CLASS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CLASS))
#define VALA_IS_CLASS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CLASS))
#define VALA_CLASS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CLASS, ValaClassClass))

typedef struct _ValaClass ValaClass;
typedef struct _ValaClassClass ValaClassClass;

#define VALA_TYPE_INTERFACE (vala_interface_get_type ())
#define VALA_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_INTERFACE, ValaInterface))
#define VALA_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_INTERFACE, ValaInterfaceClass))
#define VALA_IS_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_INTERFACE))
#define VALA_IS_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_INTERFACE))
#define VALA_INTERFACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_INTERFACE, ValaInterfaceClass))

typedef struct _ValaInterface ValaInterface;
typedef struct _ValaInterfaceClass ValaInterfaceClass;

#define VALA_TYPE_STRUCT (vala_struct_get_type ())
#define VALA_STRUCT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_STRUCT, ValaStruct))
#define VALA_STRUCT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_STRUCT, ValaStructClass))
#define VALA_IS_STRUCT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_STRUCT))
#define VALA_IS_STRUCT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_STRUCT))
#define VALA_STRUCT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_STRUCT, ValaStructClass))

typedef struct _ValaStruct ValaStruct;
typedef struct _ValaStructClass ValaStructClass;

#define VALA_TYPE_ENUM (vala_enum_get_type ())
#define VALA_ENUM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ENUM, ValaEnum))
#define VALA_ENUM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ENUM, ValaEnumClass))
#define VALA_IS_ENUM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ENUM))
#define VALA_IS_ENUM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ENUM))
#define VALA_ENUM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ENUM, ValaEnumClass))

typedef struct _ValaEnum ValaEnum;
typedef struct _ValaEnumClass ValaEnumClass;

#define VALA_TYPE_ERROR_DOMAIN (vala_error_domain_get_type ())
#define VALA_ERROR_DOMAIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ERROR_DOMAIN, ValaErrorDomain))
#define VALA_ERROR_DOMAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ERROR_DOMAIN, ValaErrorDomainClass))
#define VALA_IS_ERROR_DOMAIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ERROR_DOMAIN))
#define VALA_IS_ERROR_DOMAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ERROR_DOMAIN))
#define VALA_ERROR_DOMAIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ERROR_DOMAIN, ValaErrorDomainClass))

typedef struct _ValaErrorDomain ValaErrorDomain;
typedef struct _ValaErrorDomainClass ValaErrorDomainClass;

#define VALA_TYPE_DELEGATE (vala_delegate_get_type ())
#define VALA_DELEGATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DELEGATE, ValaDelegate))
#define VALA_DELEGATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DELEGATE, ValaDelegateClass))
#define VALA_IS_DELEGATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DELEGATE))
#define VALA_IS_DELEGATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DELEGATE))
#define VALA_DELEGATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DELEGATE, ValaDelegateClass))

typedef struct _ValaDelegate ValaDelegate;
typedef struct _ValaDelegateClass ValaDelegateClass;

#define VALA_TYPE_CONSTANT (vala_constant_get_type ())
#define VALA_CONSTANT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CONSTANT, ValaConstant))
#define VALA_CONSTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CONSTANT, ValaConstantClass))
#define VALA_IS_CONSTANT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CONSTANT))
#define VALA_IS_CONSTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CONSTANT))
#define VALA_CONSTANT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CONSTANT, ValaConstantClass))

typedef struct _ValaConstant ValaConstant;
typedef struct _ValaConstantClass ValaConstantClass;

#define VALA_TYPE_FIELD (vala_field_get_type ())
#define VALA_FIELD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_FIELD, ValaField))
#define VALA_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_FIELD, ValaFieldClass))
#define VALA_IS_FIELD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_FIELD))
#define VALA_IS_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_FIELD))
#define VALA_FIELD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_FIELD, ValaFieldClass))

typedef struct _ValaField ValaField;
typedef struct _ValaFieldClass ValaFieldClass;

#define VALA_TYPE_SUBROUTINE (vala_subroutine_get_type ())
#define VALA_SUBROUTINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SUBROUTINE, ValaSubroutine))
#define VALA_SUBROUTINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SUBROUTINE, ValaSubroutineClass))
#define VALA_IS_SUBROUTINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SUBROUTINE))
#define VALA_IS_SUBROUTINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SUBROUTINE))
#define VALA_SUBROUTINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SUBROUTINE, ValaSubroutineClass))

typedef struct _ValaSubroutine ValaSubroutine;
typedef struct _ValaSubroutineClass ValaSubroutineClass;

#define VALA_TYPE_METHOD (vala_method_get_type ())
#define VALA_METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_METHOD, ValaMethod))
#define VALA_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_METHOD, ValaMethodClass))
#define VALA_IS_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_METHOD))
#define VALA_IS_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_METHOD))
#define VALA_METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_METHOD, ValaMethodClass))

typedef struct _ValaMethod ValaMethod;
typedef struct _ValaMethodClass ValaMethodClass;

#define VALA_TYPE_PROPERTY (vala_property_get_type ())
#define VALA_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_PROPERTY, ValaProperty))
#define VALA_PROPERTY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_PROPERTY, ValaPropertyClass))
#define VALA_IS_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_PROPERTY))
#define VALA_IS_PROPERTY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_PROPERTY))
#define VALA_PROPERTY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_PROPERTY, ValaPropertyClass))

typedef struct _ValaProperty ValaProperty;
typedef struct _ValaPropertyClass ValaPropertyClass;

#define VALA_TYPE_SIGNAL (vala_signal_get_type ())
#define VALA_SIGNAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SIGNAL, ValaSignal))
#define VALA_SIGNAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SIGNAL, ValaSignalClass))
#define VALA_IS_SIGNAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SIGNAL))
#define VALA_IS_SIGNAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SIGNAL))
#define VALA_SIGNAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SIGNAL, ValaSignalClass))

typedef struct _ValaSignal ValaSignal;
typedef struct _ValaSignalClass ValaSignalClass;

#define VALA_TYPE_CONSTRUCTOR (vala_constructor_get_type ())
#define VALA_CONSTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CONSTRUCTOR, ValaConstructor))
#define VALA_CONSTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CONSTRUCTOR, ValaConstructorClass))
#define VALA_IS_CONSTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CONSTRUCTOR))
#define VALA_IS_CONSTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CONSTRUCTOR))
#define VALA_CONSTRUCTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CONSTRUCTOR, ValaConstructorClass))

typedef struct _ValaConstructor ValaConstructor;
typedef struct _ValaConstructorClass ValaConstructorClass;

#define VALA_TYPE_DESTRUCTOR (vala_destructor_get_type ())
#define VALA_DESTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DESTRUCTOR, ValaDestructor))
#define VALA_DESTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DESTRUCTOR, ValaDestructorClass))
#define VALA_IS_DESTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DESTRUCTOR))
#define VALA_IS_DESTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DESTRUCTOR))
#define VALA_DESTRUCTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DESTRUCTOR, ValaDestructorClass))

typedef struct _ValaDestructor ValaDestructor;
typedef struct _ValaDestructorClass ValaDestructorClass;

#define VALA_TYPE_LOCKABLE (vala_lockable_get_type ())
#define VALA_LOCKABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_LOCKABLE, ValaLockable))
#define VALA_IS_LOCKABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_LOCKABLE))
#define VALA_LOCKABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), VALA_TYPE_LOCKABLE, ValaLockableIface))

typedef struct _ValaLockable ValaLockable;
typedef struct _ValaLockableIface ValaLockableIface;
typedef struct _ValaPropertyPrivate ValaPropertyPrivate;

#define VALA_TYPE_PARAMETER (vala_parameter_get_type ())
#define VALA_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_PARAMETER, ValaParameter))
#define VALA_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_PARAMETER, ValaParameterClass))
#define VALA_IS_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_PARAMETER))
#define VALA_IS_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_PARAMETER))
#define VALA_PARAMETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_PARAMETER, ValaParameterClass))

typedef struct _ValaParameter ValaParameter;
typedef struct _ValaParameterClass ValaParameterClass;

#define VALA_TYPE_MEMBER_BINDING (vala_member_binding_get_type ())

#define VALA_TYPE_PROPERTY_ACCESSOR (vala_property_accessor_get_type ())
#define VALA_PROPERTY_ACCESSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_PROPERTY_ACCESSOR, ValaPropertyAccessor))
#define VALA_PROPERTY_ACCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_PROPERTY_ACCESSOR, ValaPropertyAccessorClass))
#define VALA_IS_PROPERTY_ACCESSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_PROPERTY_ACCESSOR))
#define VALA_IS_PROPERTY_ACCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_PROPERTY_ACCESSOR))
#define VALA_PROPERTY_ACCESSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_PROPERTY_ACCESSOR, ValaPropertyAccessorClass))

typedef struct _ValaPropertyAccessor ValaPropertyAccessor;
typedef struct _ValaPropertyAccessorClass ValaPropertyAccessorClass;
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define VALA_TYPE_SOURCE_REFERENCE (vala_source_reference_get_type ())
#define VALA_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReference))
#define VALA_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))
#define VALA_IS_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_IS_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_SOURCE_REFERENCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))

typedef struct _ValaSourceReference ValaSourceReference;
typedef struct _ValaSourceReferenceClass ValaSourceReferenceClass;

#define VALA_TYPE_COMMENT (vala_comment_get_type ())
#define VALA_COMMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_COMMENT, ValaComment))
#define VALA_COMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_COMMENT, ValaCommentClass))
#define VALA_IS_COMMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_COMMENT))
#define VALA_IS_COMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_COMMENT))
#define VALA_COMMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_COMMENT, ValaCommentClass))

typedef struct _ValaComment ValaComment;
typedef struct _ValaCommentClass ValaCommentClass;

#define VALA_TYPE_SCOPE (vala_scope_get_type ())
#define VALA_SCOPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SCOPE, ValaScope))
#define VALA_SCOPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SCOPE, ValaScopeClass))
#define VALA_IS_SCOPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SCOPE))
#define VALA_IS_SCOPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SCOPE))
#define VALA_SCOPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SCOPE, ValaScopeClass))

typedef struct _ValaScope ValaScope;
typedef struct _ValaScopeClass ValaScopeClass;
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))

#define VALA_TYPE_SYMBOL_ACCESSIBILITY (vala_symbol_accessibility_get_type ())

#define VALA_TYPE_SOURCE_FILE (vala_source_file_get_type ())
#define VALA_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFile))
#define VALA_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))
#define VALA_IS_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_FILE))
#define VALA_IS_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_FILE))
#define VALA_SOURCE_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))

typedef struct _ValaSourceFile ValaSourceFile;
typedef struct _ValaSourceFileClass ValaSourceFileClass;

#define VALA_TYPE_SEMANTIC_ANALYZER (vala_semantic_analyzer_get_type ())
#define VALA_SEMANTIC_ANALYZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzer))
#define VALA_SEMANTIC_ANALYZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzerClass))
#define VALA_IS_SEMANTIC_ANALYZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SEMANTIC_ANALYZER))
#define VALA_IS_SEMANTIC_ANALYZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SEMANTIC_ANALYZER))
#define VALA_SEMANTIC_ANALYZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzerClass))

typedef struct _ValaSemanticAnalyzer ValaSemanticAnalyzer;
typedef struct _ValaSemanticAnalyzerClass ValaSemanticAnalyzerClass;

#define VALA_TYPE_VOID_TYPE (vala_void_type_get_type ())
#define VALA_VOID_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_VOID_TYPE, ValaVoidType))
#define VALA_VOID_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_VOID_TYPE, ValaVoidTypeClass))
#define VALA_IS_VOID_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_VOID_TYPE))
#define VALA_IS_VOID_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_VOID_TYPE))
#define VALA_VOID_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_VOID_TYPE, ValaVoidTypeClass))

typedef struct _ValaVoidType ValaVoidType;
typedef struct _ValaVoidTypeClass ValaVoidTypeClass;
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _ValaCodeNode {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCodeNodePrivate * priv;
	GList* attributes;
};

struct _ValaCodeNodeClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCodeNode *self);
	void (*accept) (ValaCodeNode* self, ValaCodeVisitor* visitor);
	void (*accept_children) (ValaCodeNode* self, ValaCodeVisitor* visitor);
	gboolean (*check) (ValaCodeNode* self, ValaCodeContext* context);
	void (*emit) (ValaCodeNode* self, ValaCodeGenerator* codegen);
	void (*replace_type) (ValaCodeNode* self, ValaDataType* old_type, ValaDataType* new_type);
	void (*replace_expression) (ValaCodeNode* self, ValaExpression* old_node, ValaExpression* new_node);
	gchar* (*to_string) (ValaCodeNode* self);
	void (*get_defined_variables) (ValaCodeNode* self, ValaCollection* collection);
	void (*get_used_variables) (ValaCodeNode* self, ValaCollection* collection);
};

struct _ValaSymbol {
	ValaCodeNode parent_instance;
	ValaSymbolPrivate * priv;
};

struct _ValaSymbolClass {
	ValaCodeNodeClass parent_class;
	gboolean (*is_instance_member) (ValaSymbol* self);
	gboolean (*is_class_member) (ValaSymbol* self);
	void (*add_namespace) (ValaSymbol* self, ValaNamespace* ns);
	void (*add_class) (ValaSymbol* self, ValaClass* cl);
	void (*add_interface) (ValaSymbol* self, ValaInterface* iface);
	void (*add_struct) (ValaSymbol* self, ValaStruct* st);
	void (*add_enum) (ValaSymbol* self, ValaEnum* en);
	void (*add_error_domain) (ValaSymbol* self, ValaErrorDomain* edomain);
	void (*add_delegate) (ValaSymbol* self, ValaDelegate* d);
	void (*add_constant) (ValaSymbol* self, ValaConstant* constant);
	void (*add_field) (ValaSymbol* self, ValaField* f);
	void (*add_method) (ValaSymbol* self, ValaMethod* m);
	void (*add_property) (ValaSymbol* self, ValaProperty* prop);
	void (*add_signal) (ValaSymbol* self, ValaSignal* sig);
	void (*add_constructor) (ValaSymbol* self, ValaConstructor* c);
	void (*add_destructor) (ValaSymbol* self, ValaDestructor* d);
};

struct _ValaLockableIface {
	GTypeInterface parent_iface;
	gboolean (*get_lock_used) (ValaLockable* self);
	void (*set_lock_used) (ValaLockable* self, gboolean used);
};

struct _ValaProperty {
	ValaSymbol parent_instance;
	ValaPropertyPrivate * priv;
};

struct _ValaPropertyClass {
	ValaSymbolClass parent_class;
};

typedef enum  {
	VALA_MEMBER_BINDING_INSTANCE,
	VALA_MEMBER_BINDING_CLASS,
	VALA_MEMBER_BINDING_STATIC
} ValaMemberBinding;

struct _ValaPropertyPrivate {
	ValaParameter* _this_parameter;
	gboolean _interface_only;
	gboolean _is_abstract;
	gboolean _is_virtual;
	gboolean _overrides;
	ValaField* _field;
	ValaMemberBinding _binding;
	ValaExpression* _initializer;
	gboolean lock_used;
	ValaDataType* _data_type;
	ValaProperty* _base_property;
	ValaProperty* _base_interface_property;
	gboolean base_properties_valid;
	ValaPropertyAccessor* _get_accessor;
	ValaPropertyAccessor* _set_accessor;
	gchar* _nick;
	gchar* _blurb;
	gboolean* _notify;
};

typedef enum  {
	VALA_SYMBOL_ACCESSIBILITY_PRIVATE,
	VALA_SYMBOL_ACCESSIBILITY_INTERNAL,
	VALA_SYMBOL_ACCESSIBILITY_PROTECTED,
	VALA_SYMBOL_ACCESSIBILITY_PUBLIC
} ValaSymbolAccessibility;


static gpointer vala_property_parent_class = NULL;
static ValaLockableIface * vala_property_vala_lockable_parent_iface = NULL;

gpointer vala_code_node_ref (gpointer instance);
void vala_code_node_unref (gpointer instance);
GParamSpec* vala_param_spec_code_node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_node (GValue* value, gpointer v_object);
void vala_value_take_code_node (GValue* value, gpointer v_object);
gpointer vala_value_get_code_node (const GValue* value);
GType vala_code_node_get_type (void) G_GNUC_CONST;
gpointer vala_code_visitor_ref (gpointer instance);
void vala_code_visitor_unref (gpointer instance);
GParamSpec* vala_param_spec_code_visitor (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_visitor (GValue* value, gpointer v_object);
void vala_value_take_code_visitor (GValue* value, gpointer v_object);
gpointer vala_value_get_code_visitor (const GValue* value);
GType vala_code_visitor_get_type (void) G_GNUC_CONST;
gpointer vala_code_context_ref (gpointer instance);
void vala_code_context_unref (gpointer instance);
GParamSpec* vala_param_spec_code_context (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_context (GValue* value, gpointer v_object);
void vala_value_take_code_context (GValue* value, gpointer v_object);
gpointer vala_value_get_code_context (const GValue* value);
GType vala_code_context_get_type (void) G_GNUC_CONST;
GType vala_code_generator_get_type (void) G_GNUC_CONST;
GType vala_data_type_get_type (void) G_GNUC_CONST;
GType vala_expression_get_type (void) G_GNUC_CONST;
GType vala_symbol_get_type (void) G_GNUC_CONST;
GType vala_variable_get_type (void) G_GNUC_CONST;
GType vala_attribute_get_type (void) G_GNUC_CONST;
GType vala_namespace_get_type (void) G_GNUC_CONST;
GType vala_typesymbol_get_type (void) G_GNUC_CONST;
GType vala_object_type_symbol_get_type (void) G_GNUC_CONST;
GType vala_class_get_type (void) G_GNUC_CONST;
GType vala_interface_get_type (void) G_GNUC_CONST;
GType vala_struct_get_type (void) G_GNUC_CONST;
GType vala_enum_get_type (void) G_GNUC_CONST;
GType vala_error_domain_get_type (void) G_GNUC_CONST;
GType vala_delegate_get_type (void) G_GNUC_CONST;
GType vala_constant_get_type (void) G_GNUC_CONST;
GType vala_field_get_type (void) G_GNUC_CONST;
GType vala_subroutine_get_type (void) G_GNUC_CONST;
GType vala_method_get_type (void) G_GNUC_CONST;
GType vala_property_get_type (void) G_GNUC_CONST;
GType vala_signal_get_type (void) G_GNUC_CONST;
GType vala_constructor_get_type (void) G_GNUC_CONST;
GType vala_destructor_get_type (void) G_GNUC_CONST;
GType vala_lockable_get_type (void) G_GNUC_CONST;
GType vala_parameter_get_type (void) G_GNUC_CONST;
GType vala_member_binding_get_type (void) G_GNUC_CONST;
GType vala_property_accessor_get_type (void) G_GNUC_CONST;
#define VALA_PROPERTY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_PROPERTY, ValaPropertyPrivate))
enum  {
	VALA_PROPERTY_0_PROPERTY
};
gpointer vala_source_reference_ref (gpointer instance);
void vala_source_reference_unref (gpointer instance);
GParamSpec* vala_param_spec_source_reference (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_reference (GValue* value, gpointer v_object);
void vala_value_take_source_reference (GValue* value, gpointer v_object);
gpointer vala_value_get_source_reference (const GValue* value);
GType vala_source_reference_get_type (void) G_GNUC_CONST;
gpointer vala_comment_ref (gpointer instance);
void vala_comment_unref (gpointer instance);
GParamSpec* vala_param_spec_comment (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_comment (GValue* value, gpointer v_object);
void vala_value_take_comment (GValue* value, gpointer v_object);
gpointer vala_value_get_comment (const GValue* value);
GType vala_comment_get_type (void) G_GNUC_CONST;
ValaProperty* vala_property_new (const gchar* name, ValaDataType* property_type, ValaPropertyAccessor* get_accessor, ValaPropertyAccessor* set_accessor, ValaSourceReference* source_reference, ValaComment* comment);
ValaProperty* vala_property_construct (GType object_type, const gchar* name, ValaDataType* property_type, ValaPropertyAccessor* get_accessor, ValaPropertyAccessor* set_accessor, ValaSourceReference* source_reference, ValaComment* comment);
ValaSymbol* vala_symbol_construct (GType object_type, const gchar* name, ValaSourceReference* source_reference, ValaComment* comment);
void vala_property_set_property_type (ValaProperty* self, ValaDataType* value);
void vala_property_set_get_accessor (ValaProperty* self, ValaPropertyAccessor* value);
void vala_property_set_set_accessor (ValaProperty* self, ValaPropertyAccessor* value);
static void vala_property_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
void vala_code_visitor_visit_property (ValaCodeVisitor* self, ValaProperty* prop);
static void vala_property_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
ValaDataType* vala_property_get_property_type (ValaProperty* self);
void vala_code_node_accept (ValaCodeNode* self, ValaCodeVisitor* visitor);
ValaPropertyAccessor* vala_property_get_get_accessor (ValaProperty* self);
ValaPropertyAccessor* vala_property_get_set_accessor (ValaProperty* self);
ValaExpression* vala_property_get_initializer (ValaProperty* self);
static gboolean vala_property_real_get_lock_used (ValaLockable* base);
static void vala_property_real_set_lock_used (ValaLockable* base, gboolean used);
gboolean vala_property_compatible (ValaProperty* self, ValaProperty* base_property, gchar* * invalid_match);
ValaDataType* vala_semantic_analyzer_get_data_type_for_symbol (ValaTypeSymbol* sym);
ValaSymbol* vala_symbol_get_parent_symbol (ValaSymbol* self);
ValaDataType* vala_property_accessor_get_value_type (ValaPropertyAccessor* self);
ValaDataType* vala_data_type_get_actual_type (ValaDataType* self, ValaDataType* derived_instance_type, ValaList* method_type_arguments, ValaCodeNode* node_reference);
gboolean vala_data_type_equals (ValaDataType* self, ValaDataType* type2);
gboolean vala_property_accessor_get_writable (ValaPropertyAccessor* self);
gboolean vala_property_accessor_get_construction (ValaPropertyAccessor* self);
static void vala_property_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type);
static void vala_property_real_replace_expression (ValaCodeNode* base, ValaExpression* old_node, ValaExpression* new_node);
void vala_property_set_initializer (ValaProperty* self, ValaExpression* value);
static void vala_property_find_base_properties (ValaProperty* self);
static void vala_property_find_base_interface_property (ValaProperty* self, ValaClass* cl);
gboolean vala_property_get_is_virtual (ValaProperty* self);
gboolean vala_property_get_overrides (ValaProperty* self);
static void vala_property_find_base_class_property (ValaProperty* self, ValaClass* cl);
gboolean vala_property_get_is_abstract (ValaProperty* self);
gpointer vala_scope_ref (gpointer instance);
void vala_scope_unref (gpointer instance);
GParamSpec* vala_param_spec_scope (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_scope (GValue* value, gpointer v_object);
void vala_value_take_scope (GValue* value, gpointer v_object);
gpointer vala_value_get_scope (const GValue* value);
GType vala_scope_get_type (void) G_GNUC_CONST;
ValaScope* vala_symbol_get_scope (ValaSymbol* self);
ValaSymbol* vala_scope_lookup (ValaScope* self, const gchar* name);
const gchar* vala_symbol_get_name (ValaSymbol* self);
void vala_code_node_set_error (ValaCodeNode* self, gboolean value);
void vala_report_error (ValaSourceReference* source, const gchar* message);
ValaSourceReference* vala_code_node_get_source_reference (ValaCodeNode* self);
gchar* vala_symbol_get_full_name (ValaSymbol* self);
ValaClass* vala_class_get_base_class (ValaClass* self);
ValaList* vala_class_get_base_types (ValaClass* self);
ValaTypeSymbol* vala_data_type_get_data_type (ValaDataType* self);
static gboolean vala_property_real_check (ValaCodeNode* base, ValaCodeContext* context);
gboolean vala_code_node_get_checked (ValaCodeNode* self);
gboolean vala_code_node_get_error (ValaCodeNode* self);
void vala_code_node_set_checked (ValaCodeNode* self, gboolean value);
gboolean vala_class_get_is_abstract (ValaClass* self);
gboolean vala_class_get_is_compact (ValaClass* self);
GType vala_symbol_accessibility_get_type (void) G_GNUC_CONST;
ValaSymbolAccessibility vala_symbol_get_access (ValaSymbol* self);
gpointer vala_source_file_ref (gpointer instance);
void vala_source_file_unref (gpointer instance);
GParamSpec* vala_param_spec_source_file (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_file (GValue* value, gpointer v_object);
void vala_value_take_source_file (GValue* value, gpointer v_object);
gpointer vala_value_get_source_file (const GValue* value);
GType vala_source_file_get_type (void) G_GNUC_CONST;
GType vala_semantic_analyzer_get_type (void) G_GNUC_CONST;
ValaSemanticAnalyzer* vala_code_context_get_analyzer (ValaCodeContext* self);
ValaSourceFile* vala_semantic_analyzer_get_current_source_file (ValaSemanticAnalyzer* self);
ValaSymbol* vala_semantic_analyzer_get_current_symbol (ValaSemanticAnalyzer* self);
ValaSourceFile* vala_source_reference_get_file (ValaSourceReference* self);
void vala_semantic_analyzer_set_current_source_file (ValaSemanticAnalyzer* self, ValaSourceFile* value);
void vala_semantic_analyzer_set_current_symbol (ValaSemanticAnalyzer* self, ValaSymbol* value);
GType vala_void_type_get_type (void) G_GNUC_CONST;
gboolean vala_code_node_check (ValaCodeNode* self, ValaCodeContext* context);
gboolean vala_semantic_analyzer_is_type_accessible (ValaSemanticAnalyzer* self, ValaSymbol* sym, ValaDataType* type);
gchar* vala_code_node_to_string (ValaCodeNode* self);
ValaProperty* vala_property_get_base_property (ValaProperty* self);
gboolean vala_symbol_get_external_package (ValaSymbol* self);
gboolean vala_symbol_get_hides (ValaSymbol* self);
ValaSymbol* vala_symbol_get_hidden_member (ValaSymbol* self);
void vala_report_warning (ValaSourceReference* source, const gchar* message);
ValaDataType* vala_expression_get_value_type (ValaExpression* self);
gboolean vala_data_type_compatible (ValaDataType* self, ValaDataType* target_type);
void vala_code_node_set_parent_node (ValaCodeNode* self, ValaCodeNode* value);
void vala_symbol_set_owner (ValaSymbol* self, ValaScope* value);
ValaParameter* vala_property_get_this_parameter (ValaProperty* self);
void vala_property_set_this_parameter (ValaProperty* self, ValaParameter* value);
gboolean vala_property_get_interface_only (ValaProperty* self);
void vala_property_set_interface_only (ValaProperty* self, gboolean value);
void vala_property_set_is_abstract (ValaProperty* self, gboolean value);
void vala_property_set_is_virtual (ValaProperty* self, gboolean value);
void vala_property_set_overrides (ValaProperty* self, gboolean value);
ValaField* vala_property_get_field (ValaProperty* self);
void vala_property_set_field (ValaProperty* self, ValaField* value);
ValaMemberBinding vala_property_get_binding (ValaProperty* self);
void vala_property_set_binding (ValaProperty* self, ValaMemberBinding value);
const gchar* vala_property_get_nick (ValaProperty* self);
gchar* vala_code_node_get_attribute_string (ValaCodeNode* self, const gchar* attribute, const gchar* argument, const gchar* default_value);
const gchar* vala_property_get_blurb (ValaProperty* self);
gboolean vala_property_get_notify (ValaProperty* self);
gboolean vala_code_node_get_attribute_bool (ValaCodeNode* self, const gchar* attribute, const gchar* argument, gboolean default_value);
static gboolean* _bool_dup (gboolean* self);
ValaProperty* vala_property_get_base_interface_property (ValaProperty* self);
static void vala_property_finalize (ValaCodeNode * obj);


/**
 * Creates a new property.
 *
 * @param name              property name
 * @param property_type     property type
 * @param get_accessor      get accessor
 * @param set_accessor      set/construct accessor
 * @param source_reference  reference to source code
 * @return                  newly created property
 */
ValaProperty* vala_property_construct (GType object_type, const gchar* name, ValaDataType* property_type, ValaPropertyAccessor* get_accessor, ValaPropertyAccessor* set_accessor, ValaSourceReference* source_reference, ValaComment* comment) {
	ValaProperty* self = NULL;
	const gchar* _tmp0_;
	ValaSourceReference* _tmp1_;
	ValaComment* _tmp2_;
	ValaDataType* _tmp3_;
	ValaPropertyAccessor* _tmp4_;
	ValaPropertyAccessor* _tmp5_;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = name;
	_tmp1_ = source_reference;
	_tmp2_ = comment;
	self = (ValaProperty*) vala_symbol_construct (object_type, _tmp0_, _tmp1_, _tmp2_);
	_tmp3_ = property_type;
	vala_property_set_property_type (self, _tmp3_);
	_tmp4_ = get_accessor;
	vala_property_set_get_accessor (self, _tmp4_);
	_tmp5_ = set_accessor;
	vala_property_set_set_accessor (self, _tmp5_);
	return self;
}


ValaProperty* vala_property_new (const gchar* name, ValaDataType* property_type, ValaPropertyAccessor* get_accessor, ValaPropertyAccessor* set_accessor, ValaSourceReference* source_reference, ValaComment* comment) {
	return vala_property_construct (VALA_TYPE_PROPERTY, name, property_type, get_accessor, set_accessor, source_reference, comment);
}


static void vala_property_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaProperty * self;
	ValaCodeVisitor* _tmp0_;
	self = (ValaProperty*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = visitor;
	vala_code_visitor_visit_property (_tmp0_, self);
}


static void vala_property_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaProperty * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaCodeVisitor* _tmp2_;
	ValaPropertyAccessor* _tmp3_;
	ValaPropertyAccessor* _tmp4_;
	ValaPropertyAccessor* _tmp8_;
	ValaPropertyAccessor* _tmp9_;
	ValaExpression* _tmp13_;
	ValaExpression* _tmp14_;
	self = (ValaProperty*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_property_get_property_type (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = visitor;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, _tmp2_);
	_tmp3_ = vala_property_get_get_accessor (self);
	_tmp4_ = _tmp3_;
	if (_tmp4_ != NULL) {
		ValaPropertyAccessor* _tmp5_;
		ValaPropertyAccessor* _tmp6_;
		ValaCodeVisitor* _tmp7_;
		_tmp5_ = vala_property_get_get_accessor (self);
		_tmp6_ = _tmp5_;
		_tmp7_ = visitor;
		vala_code_node_accept ((ValaCodeNode*) _tmp6_, _tmp7_);
	}
	_tmp8_ = vala_property_get_set_accessor (self);
	_tmp9_ = _tmp8_;
	if (_tmp9_ != NULL) {
		ValaPropertyAccessor* _tmp10_;
		ValaPropertyAccessor* _tmp11_;
		ValaCodeVisitor* _tmp12_;
		_tmp10_ = vala_property_get_set_accessor (self);
		_tmp11_ = _tmp10_;
		_tmp12_ = visitor;
		vala_code_node_accept ((ValaCodeNode*) _tmp11_, _tmp12_);
	}
	_tmp13_ = vala_property_get_initializer (self);
	_tmp14_ = _tmp13_;
	if (_tmp14_ != NULL) {
		ValaExpression* _tmp15_;
		ValaExpression* _tmp16_;
		ValaCodeVisitor* _tmp17_;
		_tmp15_ = vala_property_get_initializer (self);
		_tmp16_ = _tmp15_;
		_tmp17_ = visitor;
		vala_code_node_accept ((ValaCodeNode*) _tmp16_, _tmp17_);
	}
}


static gboolean vala_property_real_get_lock_used (ValaLockable* base) {
	ValaProperty * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	self = (ValaProperty*) base;
	_tmp0_ = self->priv->lock_used;
	result = _tmp0_;
	return result;
}


static void vala_property_real_set_lock_used (ValaLockable* base, gboolean used) {
	ValaProperty * self;
	gboolean _tmp0_;
	self = (ValaProperty*) base;
	_tmp0_ = used;
	self->priv->lock_used = _tmp0_;
}


/**
 * Checks whether the accessors of this property are compatible
 * with the specified base property.
 *
 * @param base_property a property
 * @param invalid_match error string about which check failed
 * @return true if the specified property is compatible to this property
 */
gboolean vala_property_compatible (ValaProperty* self, ValaProperty* base_property, gchar* * invalid_match) {
	gchar* _vala_invalid_match = NULL;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaPropertyAccessor* _tmp2_;
	ValaPropertyAccessor* _tmp3_;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	ValaPropertyAccessor* _tmp16_;
	ValaPropertyAccessor* _tmp17_;
	ValaDataType* object_type = NULL;
	ValaSymbol* _tmp28_;
	ValaSymbol* _tmp29_;
	ValaDataType* _tmp30_;
	ValaPropertyAccessor* _tmp31_;
	ValaPropertyAccessor* _tmp32_;
	ValaPropertyAccessor* _tmp47_;
	ValaPropertyAccessor* _tmp48_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (base_property != NULL, FALSE);
	_tmp2_ = vala_property_get_get_accessor (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		ValaProperty* _tmp4_;
		ValaPropertyAccessor* _tmp5_;
		ValaPropertyAccessor* _tmp6_;
		_tmp4_ = base_property;
		_tmp5_ = vala_property_get_get_accessor (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp1_ = _tmp6_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp7_ = FALSE;
		ValaPropertyAccessor* _tmp8_;
		ValaPropertyAccessor* _tmp9_;
		_tmp8_ = vala_property_get_get_accessor (self);
		_tmp9_ = _tmp8_;
		if (_tmp9_ != NULL) {
			ValaProperty* _tmp10_;
			ValaPropertyAccessor* _tmp11_;
			ValaPropertyAccessor* _tmp12_;
			_tmp10_ = base_property;
			_tmp11_ = vala_property_get_get_accessor (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp7_ = _tmp12_ == NULL;
		} else {
			_tmp7_ = FALSE;
		}
		_tmp0_ = _tmp7_;
	}
	if (_tmp0_) {
		gchar* _tmp13_;
		_tmp13_ = g_strdup ("incompatible get accessor");
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = _tmp13_;
		result = FALSE;
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	}
	_tmp16_ = vala_property_get_set_accessor (self);
	_tmp17_ = _tmp16_;
	if (_tmp17_ == NULL) {
		ValaProperty* _tmp18_;
		ValaPropertyAccessor* _tmp19_;
		ValaPropertyAccessor* _tmp20_;
		_tmp18_ = base_property;
		_tmp19_ = vala_property_get_set_accessor (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp15_ = _tmp20_ != NULL;
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		_tmp14_ = TRUE;
	} else {
		gboolean _tmp21_ = FALSE;
		ValaPropertyAccessor* _tmp22_;
		ValaPropertyAccessor* _tmp23_;
		_tmp22_ = vala_property_get_set_accessor (self);
		_tmp23_ = _tmp22_;
		if (_tmp23_ != NULL) {
			ValaProperty* _tmp24_;
			ValaPropertyAccessor* _tmp25_;
			ValaPropertyAccessor* _tmp26_;
			_tmp24_ = base_property;
			_tmp25_ = vala_property_get_set_accessor (_tmp24_);
			_tmp26_ = _tmp25_;
			_tmp21_ = _tmp26_ == NULL;
		} else {
			_tmp21_ = FALSE;
		}
		_tmp14_ = _tmp21_;
	}
	if (_tmp14_) {
		gchar* _tmp27_;
		_tmp27_ = g_strdup ("incompatible set accessor");
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = _tmp27_;
		result = FALSE;
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	}
	_tmp28_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp29_ = _tmp28_;
	_tmp30_ = vala_semantic_analyzer_get_data_type_for_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
	object_type = _tmp30_;
	_tmp31_ = vala_property_get_get_accessor (self);
	_tmp32_ = _tmp31_;
	if (_tmp32_ != NULL) {
		ValaDataType* actual_base_type = NULL;
		ValaProperty* _tmp33_;
		ValaPropertyAccessor* _tmp34_;
		ValaPropertyAccessor* _tmp35_;
		ValaDataType* _tmp36_;
		ValaDataType* _tmp37_;
		ValaDataType* _tmp38_;
		ValaDataType* _tmp39_;
		ValaDataType* _tmp40_;
		ValaPropertyAccessor* _tmp41_;
		ValaPropertyAccessor* _tmp42_;
		ValaDataType* _tmp43_;
		ValaDataType* _tmp44_;
		gboolean _tmp45_;
		_tmp33_ = base_property;
		_tmp34_ = vala_property_get_get_accessor (_tmp33_);
		_tmp35_ = _tmp34_;
		_tmp36_ = vala_property_accessor_get_value_type (_tmp35_);
		_tmp37_ = _tmp36_;
		_tmp38_ = object_type;
		_tmp39_ = vala_data_type_get_actual_type (_tmp37_, _tmp38_, NULL, (ValaCodeNode*) self);
		actual_base_type = _tmp39_;
		_tmp40_ = actual_base_type;
		_tmp41_ = vala_property_get_get_accessor (self);
		_tmp42_ = _tmp41_;
		_tmp43_ = vala_property_accessor_get_value_type (_tmp42_);
		_tmp44_ = _tmp43_;
		_tmp45_ = vala_data_type_equals (_tmp40_, _tmp44_);
		if (!_tmp45_) {
			gchar* _tmp46_;
			_tmp46_ = g_strdup ("incompatible get accessor type");
			_g_free0 (_vala_invalid_match);
			_vala_invalid_match = _tmp46_;
			result = FALSE;
			_vala_code_node_unref0 (actual_base_type);
			_vala_code_node_unref0 (object_type);
			if (invalid_match) {
				*invalid_match = _vala_invalid_match;
			} else {
				_g_free0 (_vala_invalid_match);
			}
			return result;
		}
		_vala_code_node_unref0 (actual_base_type);
	}
	_tmp47_ = vala_property_get_set_accessor (self);
	_tmp48_ = _tmp47_;
	if (_tmp48_ != NULL) {
		ValaDataType* actual_base_type = NULL;
		ValaProperty* _tmp49_;
		ValaPropertyAccessor* _tmp50_;
		ValaPropertyAccessor* _tmp51_;
		ValaDataType* _tmp52_;
		ValaDataType* _tmp53_;
		ValaDataType* _tmp54_;
		ValaDataType* _tmp55_;
		ValaDataType* _tmp56_;
		ValaPropertyAccessor* _tmp57_;
		ValaPropertyAccessor* _tmp58_;
		ValaDataType* _tmp59_;
		ValaDataType* _tmp60_;
		gboolean _tmp61_;
		ValaPropertyAccessor* _tmp63_;
		ValaPropertyAccessor* _tmp64_;
		gboolean _tmp65_;
		gboolean _tmp66_;
		ValaProperty* _tmp67_;
		ValaPropertyAccessor* _tmp68_;
		ValaPropertyAccessor* _tmp69_;
		gboolean _tmp70_;
		gboolean _tmp71_;
		ValaPropertyAccessor* _tmp73_;
		ValaPropertyAccessor* _tmp74_;
		gboolean _tmp75_;
		gboolean _tmp76_;
		ValaProperty* _tmp77_;
		ValaPropertyAccessor* _tmp78_;
		ValaPropertyAccessor* _tmp79_;
		gboolean _tmp80_;
		gboolean _tmp81_;
		_tmp49_ = base_property;
		_tmp50_ = vala_property_get_set_accessor (_tmp49_);
		_tmp51_ = _tmp50_;
		_tmp52_ = vala_property_accessor_get_value_type (_tmp51_);
		_tmp53_ = _tmp52_;
		_tmp54_ = object_type;
		_tmp55_ = vala_data_type_get_actual_type (_tmp53_, _tmp54_, NULL, (ValaCodeNode*) self);
		actual_base_type = _tmp55_;
		_tmp56_ = actual_base_type;
		_tmp57_ = vala_property_get_set_accessor (self);
		_tmp58_ = _tmp57_;
		_tmp59_ = vala_property_accessor_get_value_type (_tmp58_);
		_tmp60_ = _tmp59_;
		_tmp61_ = vala_data_type_equals (_tmp56_, _tmp60_);
		if (!_tmp61_) {
			gchar* _tmp62_;
			_tmp62_ = g_strdup ("incompatible set accessor type");
			_g_free0 (_vala_invalid_match);
			_vala_invalid_match = _tmp62_;
			result = FALSE;
			_vala_code_node_unref0 (actual_base_type);
			_vala_code_node_unref0 (object_type);
			if (invalid_match) {
				*invalid_match = _vala_invalid_match;
			} else {
				_g_free0 (_vala_invalid_match);
			}
			return result;
		}
		_tmp63_ = vala_property_get_set_accessor (self);
		_tmp64_ = _tmp63_;
		_tmp65_ = vala_property_accessor_get_writable (_tmp64_);
		_tmp66_ = _tmp65_;
		_tmp67_ = base_property;
		_tmp68_ = vala_property_get_set_accessor (_tmp67_);
		_tmp69_ = _tmp68_;
		_tmp70_ = vala_property_accessor_get_writable (_tmp69_);
		_tmp71_ = _tmp70_;
		if (_tmp66_ != _tmp71_) {
			gchar* _tmp72_;
			_tmp72_ = g_strdup ("incompatible set accessor");
			_g_free0 (_vala_invalid_match);
			_vala_invalid_match = _tmp72_;
			result = FALSE;
			_vala_code_node_unref0 (actual_base_type);
			_vala_code_node_unref0 (object_type);
			if (invalid_match) {
				*invalid_match = _vala_invalid_match;
			} else {
				_g_free0 (_vala_invalid_match);
			}
			return result;
		}
		_tmp73_ = vala_property_get_set_accessor (self);
		_tmp74_ = _tmp73_;
		_tmp75_ = vala_property_accessor_get_construction (_tmp74_);
		_tmp76_ = _tmp75_;
		_tmp77_ = base_property;
		_tmp78_ = vala_property_get_set_accessor (_tmp77_);
		_tmp79_ = _tmp78_;
		_tmp80_ = vala_property_accessor_get_construction (_tmp79_);
		_tmp81_ = _tmp80_;
		if (_tmp76_ != _tmp81_) {
			gchar* _tmp82_;
			_tmp82_ = g_strdup ("incompatible set accessor");
			_g_free0 (_vala_invalid_match);
			_vala_invalid_match = _tmp82_;
			result = FALSE;
			_vala_code_node_unref0 (actual_base_type);
			_vala_code_node_unref0 (object_type);
			if (invalid_match) {
				*invalid_match = _vala_invalid_match;
			} else {
				_g_free0 (_vala_invalid_match);
			}
			return result;
		}
		_vala_code_node_unref0 (actual_base_type);
	}
	_g_free0 (_vala_invalid_match);
	_vala_invalid_match = NULL;
	result = TRUE;
	_vala_code_node_unref0 (object_type);
	if (invalid_match) {
		*invalid_match = _vala_invalid_match;
	} else {
		_g_free0 (_vala_invalid_match);
	}
	return result;
}


static void vala_property_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type) {
	ValaProperty * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	self = (ValaProperty*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_property_get_property_type (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = old_type;
	if (_tmp1_ == _tmp2_) {
		ValaDataType* _tmp3_;
		_tmp3_ = new_type;
		vala_property_set_property_type (self, _tmp3_);
	}
}


static void vala_property_real_replace_expression (ValaCodeNode* base, ValaExpression* old_node, ValaExpression* new_node) {
	ValaProperty * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	self = (ValaProperty*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_property_get_initializer (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = old_node;
	if (_tmp1_ == _tmp2_) {
		ValaExpression* _tmp3_;
		_tmp3_ = new_node;
		vala_property_set_initializer (self, _tmp3_);
	}
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


static void vala_property_find_base_properties (ValaProperty* self) {
	gboolean _tmp0_;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->base_properties_valid;
	if (_tmp0_) {
		return;
	}
	_tmp1_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp2_ = _tmp1_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, VALA_TYPE_CLASS)) {
		ValaSymbol* _tmp3_;
		ValaSymbol* _tmp4_;
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_;
		_tmp3_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_property_find_base_interface_property (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, VALA_TYPE_CLASS, ValaClass));
		_tmp6_ = self->priv->_is_virtual;
		if (_tmp6_) {
			_tmp5_ = TRUE;
		} else {
			gboolean _tmp7_;
			_tmp7_ = self->priv->_overrides;
			_tmp5_ = _tmp7_;
		}
		if (_tmp5_) {
			ValaSymbol* _tmp8_;
			ValaSymbol* _tmp9_;
			_tmp8_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp9_ = _tmp8_;
			vala_property_find_base_class_property (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, VALA_TYPE_CLASS, ValaClass));
		}
	} else {
		ValaSymbol* _tmp10_;
		ValaSymbol* _tmp11_;
		_tmp10_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp11_ = _tmp10_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, VALA_TYPE_INTERFACE)) {
			gboolean _tmp12_ = FALSE;
			gboolean _tmp13_;
			_tmp13_ = self->priv->_is_virtual;
			if (_tmp13_) {
				_tmp12_ = TRUE;
			} else {
				gboolean _tmp14_;
				_tmp14_ = self->priv->_is_abstract;
				_tmp12_ = _tmp14_;
			}
			if (_tmp12_) {
				ValaProperty* _tmp15_;
				_tmp15_ = _vala_code_node_ref0 (self);
				_vala_code_node_unref0 (self->priv->_base_interface_property);
				self->priv->_base_interface_property = _tmp15_;
			}
		}
	}
	self->priv->base_properties_valid = TRUE;
}


static void vala_property_find_base_class_property (ValaProperty* self, ValaClass* cl) {
	ValaSymbol* sym = NULL;
	ValaClass* _tmp0_;
	ValaScope* _tmp1_;
	ValaScope* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	ValaSymbol* _tmp5_;
	ValaSymbol* _tmp6_;
	ValaClass* _tmp28_;
	ValaClass* _tmp29_;
	ValaClass* _tmp30_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	_tmp0_ = cl;
	_tmp1_ = vala_symbol_get_scope ((ValaSymbol*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_symbol_get_name ((ValaSymbol*) self);
	_tmp4_ = _tmp3_;
	_tmp5_ = vala_scope_lookup (_tmp2_, _tmp4_);
	sym = _tmp5_;
	_tmp6_ = sym;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, VALA_TYPE_PROPERTY)) {
		ValaProperty* base_property = NULL;
		ValaSymbol* _tmp7_;
		ValaProperty* _tmp8_;
		gboolean _tmp9_ = FALSE;
		ValaProperty* _tmp10_;
		gboolean _tmp11_;
		_tmp7_ = sym;
		_tmp8_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, VALA_TYPE_PROPERTY, ValaProperty));
		base_property = _tmp8_;
		_tmp10_ = base_property;
		_tmp11_ = _tmp10_->priv->_is_abstract;
		if (_tmp11_) {
			_tmp9_ = TRUE;
		} else {
			ValaProperty* _tmp12_;
			gboolean _tmp13_;
			_tmp12_ = base_property;
			_tmp13_ = _tmp12_->priv->_is_virtual;
			_tmp9_ = _tmp13_;
		}
		if (_tmp9_) {
			gchar* invalid_match = NULL;
			ValaProperty* _tmp14_;
			gchar* _tmp15_ = NULL;
			gboolean _tmp16_;
			ValaProperty* _tmp27_;
			_tmp14_ = base_property;
			_tmp16_ = vala_property_compatible (self, _tmp14_, &_tmp15_);
			_g_free0 (invalid_match);
			invalid_match = _tmp15_;
			if (!_tmp16_) {
				ValaSourceReference* _tmp17_;
				ValaSourceReference* _tmp18_;
				gchar* _tmp19_;
				gchar* _tmp20_;
				ValaProperty* _tmp21_;
				gchar* _tmp22_;
				gchar* _tmp23_;
				const gchar* _tmp24_;
				gchar* _tmp25_;
				gchar* _tmp26_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp17_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp18_ = _tmp17_;
				_tmp19_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp20_ = _tmp19_;
				_tmp21_ = base_property;
				_tmp22_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp21_);
				_tmp23_ = _tmp22_;
				_tmp24_ = invalid_match;
				_tmp25_ = g_strdup_printf ("Type and/or accessors of overriding property `%s' do not match overrid" \
"den property `%s': %s.", _tmp20_, _tmp23_, _tmp24_);
				_tmp26_ = _tmp25_;
				vala_report_error (_tmp18_, _tmp26_);
				_g_free0 (_tmp26_);
				_g_free0 (_tmp23_);
				_g_free0 (_tmp20_);
				_g_free0 (invalid_match);
				_vala_code_node_unref0 (base_property);
				_vala_code_node_unref0 (sym);
				return;
			}
			_tmp27_ = base_property;
			self->priv->_base_property = _tmp27_;
			_g_free0 (invalid_match);
			_vala_code_node_unref0 (base_property);
			_vala_code_node_unref0 (sym);
			return;
		}
		_vala_code_node_unref0 (base_property);
	}
	_tmp28_ = cl;
	_tmp29_ = vala_class_get_base_class (_tmp28_);
	_tmp30_ = _tmp29_;
	if (_tmp30_ != NULL) {
		ValaClass* _tmp31_;
		ValaClass* _tmp32_;
		ValaClass* _tmp33_;
		_tmp31_ = cl;
		_tmp32_ = vala_class_get_base_class (_tmp31_);
		_tmp33_ = _tmp32_;
		vala_property_find_base_class_property (self, _tmp33_);
	}
	_vala_code_node_unref0 (sym);
}


static void vala_property_find_base_interface_property (ValaProperty* self, ValaClass* cl) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	{
		ValaList* _type_list = NULL;
		ValaClass* _tmp0_;
		ValaList* _tmp1_;
		gint _type_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _type_index = 0;
		_tmp0_ = cl;
		_tmp1_ = vala_class_get_base_types (_tmp0_);
		_type_list = _tmp1_;
		_tmp2_ = _type_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_type_size = _tmp4_;
		_type_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaDataType* type = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValaDataType* _tmp11_;
			ValaTypeSymbol* _tmp12_;
			ValaTypeSymbol* _tmp13_;
			_tmp5_ = _type_index;
			_type_index = _tmp5_ + 1;
			_tmp6_ = _type_index;
			_tmp7_ = _type_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _type_list;
			_tmp9_ = _type_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			type = (ValaDataType*) _tmp10_;
			_tmp11_ = type;
			_tmp12_ = vala_data_type_get_data_type (_tmp11_);
			_tmp13_ = _tmp12_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp13_, VALA_TYPE_INTERFACE)) {
				ValaSymbol* sym = NULL;
				ValaDataType* _tmp14_;
				ValaTypeSymbol* _tmp15_;
				ValaTypeSymbol* _tmp16_;
				ValaScope* _tmp17_;
				ValaScope* _tmp18_;
				const gchar* _tmp19_;
				const gchar* _tmp20_;
				ValaSymbol* _tmp21_;
				ValaSymbol* _tmp22_;
				_tmp14_ = type;
				_tmp15_ = vala_data_type_get_data_type (_tmp14_);
				_tmp16_ = _tmp15_;
				_tmp17_ = vala_symbol_get_scope ((ValaSymbol*) _tmp16_);
				_tmp18_ = _tmp17_;
				_tmp19_ = vala_symbol_get_name ((ValaSymbol*) self);
				_tmp20_ = _tmp19_;
				_tmp21_ = vala_scope_lookup (_tmp18_, _tmp20_);
				sym = _tmp21_;
				_tmp22_ = sym;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp22_, VALA_TYPE_PROPERTY)) {
					ValaProperty* base_property = NULL;
					ValaSymbol* _tmp23_;
					ValaProperty* _tmp24_;
					gboolean _tmp25_ = FALSE;
					ValaProperty* _tmp26_;
					gboolean _tmp27_;
					_tmp23_ = sym;
					_tmp24_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, VALA_TYPE_PROPERTY, ValaProperty));
					base_property = _tmp24_;
					_tmp26_ = base_property;
					_tmp27_ = _tmp26_->priv->_is_abstract;
					if (_tmp27_) {
						_tmp25_ = TRUE;
					} else {
						ValaProperty* _tmp28_;
						gboolean _tmp29_;
						_tmp28_ = base_property;
						_tmp29_ = _tmp28_->priv->_is_virtual;
						_tmp25_ = _tmp29_;
					}
					if (_tmp25_) {
						gchar* invalid_match = NULL;
						ValaProperty* _tmp30_;
						gchar* _tmp31_ = NULL;
						gboolean _tmp32_;
						ValaProperty* _tmp43_;
						ValaProperty* _tmp44_;
						_tmp30_ = base_property;
						_tmp32_ = vala_property_compatible (self, _tmp30_, &_tmp31_);
						_g_free0 (invalid_match);
						invalid_match = _tmp31_;
						if (!_tmp32_) {
							ValaSourceReference* _tmp33_;
							ValaSourceReference* _tmp34_;
							gchar* _tmp35_;
							gchar* _tmp36_;
							ValaProperty* _tmp37_;
							gchar* _tmp38_;
							gchar* _tmp39_;
							const gchar* _tmp40_;
							gchar* _tmp41_;
							gchar* _tmp42_;
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
							_tmp33_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp34_ = _tmp33_;
							_tmp35_ = vala_symbol_get_full_name ((ValaSymbol*) self);
							_tmp36_ = _tmp35_;
							_tmp37_ = base_property;
							_tmp38_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp37_);
							_tmp39_ = _tmp38_;
							_tmp40_ = invalid_match;
							_tmp41_ = g_strdup_printf ("Type and/or accessors of overriding property `%s' do not match overrid" \
"den property `%s': %s.", _tmp36_, _tmp39_, _tmp40_);
							_tmp42_ = _tmp41_;
							vala_report_error (_tmp34_, _tmp42_);
							_g_free0 (_tmp42_);
							_g_free0 (_tmp39_);
							_g_free0 (_tmp36_);
							_g_free0 (invalid_match);
							_vala_code_node_unref0 (base_property);
							_vala_code_node_unref0 (sym);
							_vala_code_node_unref0 (type);
							_vala_iterable_unref0 (_type_list);
							return;
						}
						_tmp43_ = base_property;
						_tmp44_ = _vala_code_node_ref0 (_tmp43_);
						_vala_code_node_unref0 (self->priv->_base_interface_property);
						self->priv->_base_interface_property = _tmp44_;
						_g_free0 (invalid_match);
						_vala_code_node_unref0 (base_property);
						_vala_code_node_unref0 (sym);
						_vala_code_node_unref0 (type);
						_vala_iterable_unref0 (_type_list);
						return;
					}
					_vala_code_node_unref0 (base_property);
				}
				_vala_code_node_unref0 (sym);
			}
			_vala_code_node_unref0 (type);
		}
		_vala_iterable_unref0 (_type_list);
	}
}


static gpointer _vala_source_file_ref0 (gpointer self) {
	return self ? vala_source_file_ref (self) : NULL;
}


static gboolean vala_property_real_check (ValaCodeNode* base, ValaCodeContext* context) {
	ValaProperty * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp4_;
	ValaSourceFile* old_source_file = NULL;
	ValaCodeContext* _tmp51_;
	ValaSemanticAnalyzer* _tmp52_;
	ValaSemanticAnalyzer* _tmp53_;
	ValaSourceFile* _tmp54_;
	ValaSourceFile* _tmp55_;
	ValaSourceFile* _tmp56_;
	ValaSymbol* old_symbol = NULL;
	ValaCodeContext* _tmp57_;
	ValaSemanticAnalyzer* _tmp58_;
	ValaSemanticAnalyzer* _tmp59_;
	ValaSymbol* _tmp60_;
	ValaSymbol* _tmp61_;
	ValaSymbol* _tmp62_;
	ValaSourceReference* _tmp63_;
	ValaSourceReference* _tmp64_;
	ValaCodeContext* _tmp72_;
	ValaSemanticAnalyzer* _tmp73_;
	ValaSemanticAnalyzer* _tmp74_;
	ValaDataType* _tmp75_;
	ValaDataType* _tmp76_;
	ValaDataType* _tmp79_;
	ValaDataType* _tmp80_;
	ValaCodeContext* _tmp81_;
	gboolean _tmp82_ = FALSE;
	ValaPropertyAccessor* _tmp83_;
	ValaPropertyAccessor* _tmp84_;
	ValaPropertyAccessor* _tmp93_;
	ValaPropertyAccessor* _tmp94_;
	ValaPropertyAccessor* _tmp98_;
	ValaPropertyAccessor* _tmp99_;
	ValaExpression* _tmp103_;
	ValaExpression* _tmp104_;
	ValaCodeContext* _tmp108_;
	ValaSemanticAnalyzer* _tmp109_;
	ValaSemanticAnalyzer* _tmp110_;
	ValaDataType* _tmp111_;
	ValaDataType* _tmp112_;
	gboolean _tmp113_;
	gboolean _tmp124_ = FALSE;
	gboolean _tmp125_;
	gboolean _tmp134_ = FALSE;
	gboolean _tmp135_ = FALSE;
	gboolean _tmp136_ = FALSE;
	gboolean _tmp137_;
	gboolean _tmp138_;
	gboolean _tmp154_ = FALSE;
	ValaPropertyAccessor* _tmp155_;
	ValaPropertyAccessor* _tmp156_;
	gboolean _tmp169_ = FALSE;
	gboolean _tmp170_ = FALSE;
	gboolean _tmp171_ = FALSE;
	ValaExpression* _tmp172_;
	ValaExpression* _tmp173_;
	ValaCodeContext* _tmp205_;
	ValaSemanticAnalyzer* _tmp206_;
	ValaSemanticAnalyzer* _tmp207_;
	ValaSourceFile* _tmp208_;
	ValaCodeContext* _tmp209_;
	ValaSemanticAnalyzer* _tmp210_;
	ValaSemanticAnalyzer* _tmp211_;
	ValaSymbol* _tmp212_;
	gboolean _tmp213_;
	gboolean _tmp214_;
	self = (ValaProperty*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = self->priv->_is_abstract;
	if (_tmp4_) {
		ValaSymbol* _tmp5_;
		ValaSymbol* _tmp6_;
		_tmp5_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp6_ = _tmp5_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, VALA_TYPE_CLASS)) {
			ValaClass* cl = NULL;
			ValaSymbol* _tmp7_;
			ValaSymbol* _tmp8_;
			ValaClass* _tmp9_;
			ValaClass* _tmp10_;
			gboolean _tmp11_;
			gboolean _tmp12_;
			_tmp7_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp8_ = _tmp7_;
			_tmp9_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, VALA_TYPE_CLASS, ValaClass));
			cl = _tmp9_;
			_tmp10_ = cl;
			_tmp11_ = vala_class_get_is_abstract (_tmp10_);
			_tmp12_ = _tmp11_;
			if (!_tmp12_) {
				ValaSourceReference* _tmp13_;
				ValaSourceReference* _tmp14_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp13_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp14_ = _tmp13_;
				vala_report_error (_tmp14_, "Abstract properties may not be declared in non-abstract classes");
				result = FALSE;
				_vala_code_node_unref0 (cl);
				return result;
			}
			_vala_code_node_unref0 (cl);
		} else {
			ValaSymbol* _tmp15_;
			ValaSymbol* _tmp16_;
			_tmp15_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp16_ = _tmp15_;
			if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, VALA_TYPE_INTERFACE)) {
				ValaSourceReference* _tmp17_;
				ValaSourceReference* _tmp18_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp17_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp18_ = _tmp17_;
				vala_report_error (_tmp18_, "Abstract properties may not be declared outside of classes and interfa" \
"ces");
				result = FALSE;
				return result;
			}
		}
	} else {
		gboolean _tmp19_;
		_tmp19_ = self->priv->_is_virtual;
		if (_tmp19_) {
			gboolean _tmp20_ = FALSE;
			ValaSymbol* _tmp21_;
			ValaSymbol* _tmp22_;
			ValaSymbol* _tmp27_;
			ValaSymbol* _tmp28_;
			_tmp21_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp22_ = _tmp21_;
			if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp22_, VALA_TYPE_CLASS)) {
				ValaSymbol* _tmp23_;
				ValaSymbol* _tmp24_;
				_tmp23_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
				_tmp24_ = _tmp23_;
				_tmp20_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp24_, VALA_TYPE_INTERFACE);
			} else {
				_tmp20_ = FALSE;
			}
			if (_tmp20_) {
				ValaSourceReference* _tmp25_;
				ValaSourceReference* _tmp26_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp25_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp26_ = _tmp25_;
				vala_report_error (_tmp26_, "Virtual properties may not be declared outside of classes and interfac" \
"es");
				result = FALSE;
				return result;
			}
			_tmp27_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp28_ = _tmp27_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp28_, VALA_TYPE_CLASS)) {
				ValaClass* cl = NULL;
				ValaSymbol* _tmp29_;
				ValaSymbol* _tmp30_;
				ValaClass* _tmp31_;
				ValaClass* _tmp32_;
				gboolean _tmp33_;
				gboolean _tmp34_;
				_tmp29_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
				_tmp30_ = _tmp29_;
				_tmp31_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp31_;
				_tmp32_ = cl;
				_tmp33_ = vala_class_get_is_compact (_tmp32_);
				_tmp34_ = _tmp33_;
				if (_tmp34_) {
					ValaSourceReference* _tmp35_;
					ValaSourceReference* _tmp36_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp35_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp36_ = _tmp35_;
					vala_report_error (_tmp36_, "Virtual properties may not be declared in compact classes");
					result = FALSE;
					_vala_code_node_unref0 (cl);
					return result;
				}
				_vala_code_node_unref0 (cl);
			}
		} else {
			gboolean _tmp37_;
			_tmp37_ = self->priv->_overrides;
			if (_tmp37_) {
				ValaSymbol* _tmp38_;
				ValaSymbol* _tmp39_;
				_tmp38_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
				_tmp39_ = _tmp38_;
				if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp39_, VALA_TYPE_CLASS)) {
					ValaSourceReference* _tmp40_;
					ValaSourceReference* _tmp41_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp40_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp41_ = _tmp40_;
					vala_report_error (_tmp41_, "Properties may not be overridden outside of classes");
					result = FALSE;
					return result;
				}
			} else {
				ValaSymbolAccessibility _tmp42_;
				ValaSymbolAccessibility _tmp43_;
				_tmp42_ = vala_symbol_get_access ((ValaSymbol*) self);
				_tmp43_ = _tmp42_;
				if (_tmp43_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
					gboolean _tmp44_ = FALSE;
					ValaSymbol* _tmp45_;
					ValaSymbol* _tmp46_;
					_tmp45_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
					_tmp46_ = _tmp45_;
					if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp46_, VALA_TYPE_CLASS)) {
						ValaSymbol* _tmp47_;
						ValaSymbol* _tmp48_;
						_tmp47_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
						_tmp48_ = _tmp47_;
						_tmp44_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp48_, VALA_TYPE_INTERFACE);
					} else {
						_tmp44_ = FALSE;
					}
					if (_tmp44_) {
						ValaSourceReference* _tmp49_;
						ValaSourceReference* _tmp50_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp49_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp50_ = _tmp49_;
						vala_report_error (_tmp50_, "Protected properties may not be declared outside of classes and interf" \
"aces");
						result = FALSE;
						return result;
					}
				}
			}
		}
	}
	_tmp51_ = context;
	_tmp52_ = vala_code_context_get_analyzer (_tmp51_);
	_tmp53_ = _tmp52_;
	_tmp54_ = vala_semantic_analyzer_get_current_source_file (_tmp53_);
	_tmp55_ = _tmp54_;
	_tmp56_ = _vala_source_file_ref0 (_tmp55_);
	old_source_file = _tmp56_;
	_tmp57_ = context;
	_tmp58_ = vala_code_context_get_analyzer (_tmp57_);
	_tmp59_ = _tmp58_;
	_tmp60_ = vala_semantic_analyzer_get_current_symbol (_tmp59_);
	_tmp61_ = _tmp60_;
	_tmp62_ = _vala_code_node_ref0 (_tmp61_);
	old_symbol = _tmp62_;
	_tmp63_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp64_ = _tmp63_;
	if (_tmp64_ != NULL) {
		ValaCodeContext* _tmp65_;
		ValaSemanticAnalyzer* _tmp66_;
		ValaSemanticAnalyzer* _tmp67_;
		ValaSourceReference* _tmp68_;
		ValaSourceReference* _tmp69_;
		ValaSourceFile* _tmp70_;
		ValaSourceFile* _tmp71_;
		_tmp65_ = context;
		_tmp66_ = vala_code_context_get_analyzer (_tmp65_);
		_tmp67_ = _tmp66_;
		_tmp68_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp69_ = _tmp68_;
		_tmp70_ = vala_source_reference_get_file (_tmp69_);
		_tmp71_ = _tmp70_;
		vala_semantic_analyzer_set_current_source_file (_tmp67_, _tmp71_);
	}
	_tmp72_ = context;
	_tmp73_ = vala_code_context_get_analyzer (_tmp72_);
	_tmp74_ = _tmp73_;
	vala_semantic_analyzer_set_current_symbol (_tmp74_, (ValaSymbol*) self);
	_tmp75_ = vala_property_get_property_type (self);
	_tmp76_ = _tmp75_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp76_, VALA_TYPE_VOID_TYPE)) {
		ValaSourceReference* _tmp77_;
		ValaSourceReference* _tmp78_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp77_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp78_ = _tmp77_;
		vala_report_error (_tmp78_, "'void' not supported as property type");
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	_tmp79_ = vala_property_get_property_type (self);
	_tmp80_ = _tmp79_;
	_tmp81_ = context;
	vala_code_node_check ((ValaCodeNode*) _tmp80_, _tmp81_);
	_tmp83_ = vala_property_get_get_accessor (self);
	_tmp84_ = _tmp83_;
	if (_tmp84_ == NULL) {
		ValaPropertyAccessor* _tmp85_;
		ValaPropertyAccessor* _tmp86_;
		_tmp85_ = vala_property_get_set_accessor (self);
		_tmp86_ = _tmp85_;
		_tmp82_ = _tmp86_ == NULL;
	} else {
		_tmp82_ = FALSE;
	}
	if (_tmp82_) {
		ValaSourceReference* _tmp87_;
		ValaSourceReference* _tmp88_;
		gchar* _tmp89_;
		gchar* _tmp90_;
		gchar* _tmp91_;
		gchar* _tmp92_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp87_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp88_ = _tmp87_;
		_tmp89_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp90_ = _tmp89_;
		_tmp91_ = g_strdup_printf ("Property `%s' must have a `get' accessor and/or a `set' mutator", _tmp90_);
		_tmp92_ = _tmp91_;
		vala_report_error (_tmp88_, _tmp92_);
		_g_free0 (_tmp92_);
		_g_free0 (_tmp90_);
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	_tmp93_ = vala_property_get_get_accessor (self);
	_tmp94_ = _tmp93_;
	if (_tmp94_ != NULL) {
		ValaPropertyAccessor* _tmp95_;
		ValaPropertyAccessor* _tmp96_;
		ValaCodeContext* _tmp97_;
		_tmp95_ = vala_property_get_get_accessor (self);
		_tmp96_ = _tmp95_;
		_tmp97_ = context;
		vala_code_node_check ((ValaCodeNode*) _tmp96_, _tmp97_);
	}
	_tmp98_ = vala_property_get_set_accessor (self);
	_tmp99_ = _tmp98_;
	if (_tmp99_ != NULL) {
		ValaPropertyAccessor* _tmp100_;
		ValaPropertyAccessor* _tmp101_;
		ValaCodeContext* _tmp102_;
		_tmp100_ = vala_property_get_set_accessor (self);
		_tmp101_ = _tmp100_;
		_tmp102_ = context;
		vala_code_node_check ((ValaCodeNode*) _tmp101_, _tmp102_);
	}
	_tmp103_ = vala_property_get_initializer (self);
	_tmp104_ = _tmp103_;
	if (_tmp104_ != NULL) {
		ValaExpression* _tmp105_;
		ValaExpression* _tmp106_;
		ValaCodeContext* _tmp107_;
		_tmp105_ = vala_property_get_initializer (self);
		_tmp106_ = _tmp105_;
		_tmp107_ = context;
		vala_code_node_check ((ValaCodeNode*) _tmp106_, _tmp107_);
	}
	_tmp108_ = context;
	_tmp109_ = vala_code_context_get_analyzer (_tmp108_);
	_tmp110_ = _tmp109_;
	_tmp111_ = vala_property_get_property_type (self);
	_tmp112_ = _tmp111_;
	_tmp113_ = vala_semantic_analyzer_is_type_accessible (_tmp110_, (ValaSymbol*) self, _tmp112_);
	if (!_tmp113_) {
		ValaSourceReference* _tmp114_;
		ValaSourceReference* _tmp115_;
		ValaDataType* _tmp116_;
		ValaDataType* _tmp117_;
		gchar* _tmp118_;
		gchar* _tmp119_;
		gchar* _tmp120_;
		gchar* _tmp121_;
		gchar* _tmp122_;
		gchar* _tmp123_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp114_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp115_ = _tmp114_;
		_tmp116_ = vala_property_get_property_type (self);
		_tmp117_ = _tmp116_;
		_tmp118_ = vala_code_node_to_string ((ValaCodeNode*) _tmp117_);
		_tmp119_ = _tmp118_;
		_tmp120_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp121_ = _tmp120_;
		_tmp122_ = g_strdup_printf ("property type `%s` is less accessible than property `%s`", _tmp119_, _tmp121_);
		_tmp123_ = _tmp122_;
		vala_report_error (_tmp115_, _tmp123_);
		_g_free0 (_tmp123_);
		_g_free0 (_tmp121_);
		_g_free0 (_tmp119_);
	}
	_tmp125_ = self->priv->_overrides;
	if (_tmp125_) {
		ValaProperty* _tmp126_;
		ValaProperty* _tmp127_;
		_tmp126_ = vala_property_get_base_property (self);
		_tmp127_ = _tmp126_;
		_tmp124_ = _tmp127_ == NULL;
	} else {
		_tmp124_ = FALSE;
	}
	if (_tmp124_) {
		ValaSourceReference* _tmp128_;
		ValaSourceReference* _tmp129_;
		gchar* _tmp130_;
		gchar* _tmp131_;
		gchar* _tmp132_;
		gchar* _tmp133_;
		_tmp128_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp129_ = _tmp128_;
		_tmp130_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp131_ = _tmp130_;
		_tmp132_ = g_strdup_printf ("%s: no suitable property found to override", _tmp131_);
		_tmp133_ = _tmp132_;
		vala_report_error (_tmp129_, _tmp133_);
		_g_free0 (_tmp133_);
		_g_free0 (_tmp131_);
	}
	_tmp137_ = vala_symbol_get_external_package ((ValaSymbol*) self);
	_tmp138_ = _tmp137_;
	if (!_tmp138_) {
		gboolean _tmp139_;
		_tmp139_ = self->priv->_overrides;
		_tmp136_ = !_tmp139_;
	} else {
		_tmp136_ = FALSE;
	}
	if (_tmp136_) {
		gboolean _tmp140_;
		gboolean _tmp141_;
		_tmp140_ = vala_symbol_get_hides ((ValaSymbol*) self);
		_tmp141_ = _tmp140_;
		_tmp135_ = !_tmp141_;
	} else {
		_tmp135_ = FALSE;
	}
	if (_tmp135_) {
		ValaSymbol* _tmp142_;
		ValaSymbol* _tmp143_;
		_tmp142_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp143_ = _tmp142_;
		_tmp134_ = _tmp143_ != NULL;
		_vala_code_node_unref0 (_tmp143_);
	} else {
		_tmp134_ = FALSE;
	}
	if (_tmp134_) {
		ValaSourceReference* _tmp144_;
		ValaSourceReference* _tmp145_;
		gchar* _tmp146_;
		gchar* _tmp147_;
		ValaSymbol* _tmp148_;
		ValaSymbol* _tmp149_;
		gchar* _tmp150_;
		gchar* _tmp151_;
		gchar* _tmp152_;
		gchar* _tmp153_;
		_tmp144_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp145_ = _tmp144_;
		_tmp146_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp147_ = _tmp146_;
		_tmp148_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp149_ = _tmp148_;
		_tmp150_ = vala_symbol_get_full_name (_tmp149_);
		_tmp151_ = _tmp150_;
		_tmp152_ = g_strdup_printf ("%s hides inherited property `%s'. Use the `new' keyword if hiding was " \
"intentional", _tmp147_, _tmp151_);
		_tmp153_ = _tmp152_;
		vala_report_warning (_tmp145_, _tmp153_);
		_g_free0 (_tmp153_);
		_g_free0 (_tmp151_);
		_vala_code_node_unref0 (_tmp149_);
		_g_free0 (_tmp147_);
	}
	_tmp155_ = vala_property_get_set_accessor (self);
	_tmp156_ = _tmp155_;
	if (_tmp156_ != NULL) {
		ValaPropertyAccessor* _tmp157_;
		ValaPropertyAccessor* _tmp158_;
		gboolean _tmp159_;
		gboolean _tmp160_;
		_tmp157_ = vala_property_get_set_accessor (self);
		_tmp158_ = _tmp157_;
		_tmp159_ = vala_property_accessor_get_construction (_tmp158_);
		_tmp160_ = _tmp159_;
		_tmp154_ = _tmp160_;
	} else {
		_tmp154_ = FALSE;
	}
	if (_tmp154_) {
		ValaSymbolAccessibility _tmp161_;
		ValaSymbolAccessibility _tmp162_;
		_tmp161_ = vala_symbol_get_access ((ValaSymbol*) self);
		_tmp162_ = _tmp161_;
		if (_tmp162_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
			ValaSourceReference* _tmp163_;
			ValaSourceReference* _tmp164_;
			gchar* _tmp165_;
			gchar* _tmp166_;
			gchar* _tmp167_;
			gchar* _tmp168_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp163_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp164_ = _tmp163_;
			_tmp165_ = vala_symbol_get_full_name ((ValaSymbol*) self);
			_tmp166_ = _tmp165_;
			_tmp167_ = g_strdup_printf ("%s: construct properties must be public", _tmp166_);
			_tmp168_ = _tmp167_;
			vala_report_error (_tmp164_, _tmp168_);
			_g_free0 (_tmp168_);
			_g_free0 (_tmp166_);
		}
	}
	_tmp172_ = vala_property_get_initializer (self);
	_tmp173_ = _tmp172_;
	if (_tmp173_ != NULL) {
		ValaExpression* _tmp174_;
		ValaExpression* _tmp175_;
		gboolean _tmp176_;
		gboolean _tmp177_;
		_tmp174_ = vala_property_get_initializer (self);
		_tmp175_ = _tmp174_;
		_tmp176_ = vala_code_node_get_error ((ValaCodeNode*) _tmp175_);
		_tmp177_ = _tmp176_;
		_tmp171_ = !_tmp177_;
	} else {
		_tmp171_ = FALSE;
	}
	if (_tmp171_) {
		ValaExpression* _tmp178_;
		ValaExpression* _tmp179_;
		ValaDataType* _tmp180_;
		ValaDataType* _tmp181_;
		_tmp178_ = vala_property_get_initializer (self);
		_tmp179_ = _tmp178_;
		_tmp180_ = vala_expression_get_value_type (_tmp179_);
		_tmp181_ = _tmp180_;
		_tmp170_ = _tmp181_ != NULL;
	} else {
		_tmp170_ = FALSE;
	}
	if (_tmp170_) {
		ValaExpression* _tmp182_;
		ValaExpression* _tmp183_;
		ValaDataType* _tmp184_;
		ValaDataType* _tmp185_;
		ValaDataType* _tmp186_;
		ValaDataType* _tmp187_;
		gboolean _tmp188_;
		_tmp182_ = vala_property_get_initializer (self);
		_tmp183_ = _tmp182_;
		_tmp184_ = vala_expression_get_value_type (_tmp183_);
		_tmp185_ = _tmp184_;
		_tmp186_ = vala_property_get_property_type (self);
		_tmp187_ = _tmp186_;
		_tmp188_ = vala_data_type_compatible (_tmp185_, _tmp187_);
		_tmp169_ = !_tmp188_;
	} else {
		_tmp169_ = FALSE;
	}
	if (_tmp169_) {
		ValaExpression* _tmp189_;
		ValaExpression* _tmp190_;
		ValaSourceReference* _tmp191_;
		ValaSourceReference* _tmp192_;
		ValaDataType* _tmp193_;
		ValaDataType* _tmp194_;
		gchar* _tmp195_;
		gchar* _tmp196_;
		ValaExpression* _tmp197_;
		ValaExpression* _tmp198_;
		ValaDataType* _tmp199_;
		ValaDataType* _tmp200_;
		gchar* _tmp201_;
		gchar* _tmp202_;
		gchar* _tmp203_;
		gchar* _tmp204_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp189_ = vala_property_get_initializer (self);
		_tmp190_ = _tmp189_;
		_tmp191_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp190_);
		_tmp192_ = _tmp191_;
		_tmp193_ = vala_property_get_property_type (self);
		_tmp194_ = _tmp193_;
		_tmp195_ = vala_code_node_to_string ((ValaCodeNode*) _tmp194_);
		_tmp196_ = _tmp195_;
		_tmp197_ = vala_property_get_initializer (self);
		_tmp198_ = _tmp197_;
		_tmp199_ = vala_expression_get_value_type (_tmp198_);
		_tmp200_ = _tmp199_;
		_tmp201_ = vala_code_node_to_string ((ValaCodeNode*) _tmp200_);
		_tmp202_ = _tmp201_;
		_tmp203_ = g_strdup_printf ("Expected initializer of type `%s' but got `%s'", _tmp196_, _tmp202_);
		_tmp204_ = _tmp203_;
		vala_report_error (_tmp192_, _tmp204_);
		_g_free0 (_tmp204_);
		_g_free0 (_tmp202_);
		_g_free0 (_tmp196_);
	}
	_tmp205_ = context;
	_tmp206_ = vala_code_context_get_analyzer (_tmp205_);
	_tmp207_ = _tmp206_;
	_tmp208_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp207_, _tmp208_);
	_tmp209_ = context;
	_tmp210_ = vala_code_context_get_analyzer (_tmp209_);
	_tmp211_ = _tmp210_;
	_tmp212_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp211_, _tmp212_);
	_tmp213_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp214_ = _tmp213_;
	result = !_tmp214_;
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}


ValaDataType* vala_property_get_property_type (ValaProperty* self) {
	ValaDataType* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_data_type;
	result = _tmp0_;
	return result;
}


void vala_property_set_property_type (ValaProperty* self, ValaDataType* value) {
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_data_type);
	self->priv->_data_type = _tmp1_;
	_tmp2_ = value;
	if (_tmp2_ != NULL) {
		ValaDataType* _tmp3_;
		_tmp3_ = self->priv->_data_type;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp3_, (ValaCodeNode*) self);
	}
}


ValaPropertyAccessor* vala_property_get_get_accessor (ValaProperty* self) {
	ValaPropertyAccessor* result;
	ValaPropertyAccessor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_get_accessor;
	result = _tmp0_;
	return result;
}


void vala_property_set_get_accessor (ValaProperty* self, ValaPropertyAccessor* value) {
	ValaPropertyAccessor* _tmp0_;
	ValaPropertyAccessor* _tmp1_;
	ValaPropertyAccessor* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_get_accessor);
	self->priv->_get_accessor = _tmp1_;
	_tmp2_ = value;
	if (_tmp2_ != NULL) {
		ValaPropertyAccessor* _tmp3_;
		ValaScope* _tmp4_;
		ValaScope* _tmp5_;
		_tmp3_ = value;
		_tmp4_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp5_ = _tmp4_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp3_, _tmp5_);
	}
}


ValaPropertyAccessor* vala_property_get_set_accessor (ValaProperty* self) {
	ValaPropertyAccessor* result;
	ValaPropertyAccessor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_set_accessor;
	result = _tmp0_;
	return result;
}


void vala_property_set_set_accessor (ValaProperty* self, ValaPropertyAccessor* value) {
	ValaPropertyAccessor* _tmp0_;
	ValaPropertyAccessor* _tmp1_;
	ValaPropertyAccessor* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_set_accessor);
	self->priv->_set_accessor = _tmp1_;
	_tmp2_ = value;
	if (_tmp2_ != NULL) {
		ValaPropertyAccessor* _tmp3_;
		ValaScope* _tmp4_;
		ValaScope* _tmp5_;
		_tmp3_ = value;
		_tmp4_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp5_ = _tmp4_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp3_, _tmp5_);
	}
}


ValaParameter* vala_property_get_this_parameter (ValaProperty* self) {
	ValaParameter* result;
	ValaParameter* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_this_parameter;
	result = _tmp0_;
	return result;
}


void vala_property_set_this_parameter (ValaProperty* self, ValaParameter* value) {
	ValaParameter* _tmp0_;
	ValaParameter* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_this_parameter);
	self->priv->_this_parameter = _tmp1_;
}


gboolean vala_property_get_interface_only (ValaProperty* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_interface_only;
	result = _tmp0_;
	return result;
}


void vala_property_set_interface_only (ValaProperty* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_interface_only = _tmp0_;
}


gboolean vala_property_get_is_abstract (ValaProperty* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_abstract;
	result = _tmp0_;
	return result;
}


void vala_property_set_is_abstract (ValaProperty* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_is_abstract = _tmp0_;
}


gboolean vala_property_get_is_virtual (ValaProperty* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_virtual;
	result = _tmp0_;
	return result;
}


void vala_property_set_is_virtual (ValaProperty* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_is_virtual = _tmp0_;
}


gboolean vala_property_get_overrides (ValaProperty* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_overrides;
	result = _tmp0_;
	return result;
}


void vala_property_set_overrides (ValaProperty* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_overrides = _tmp0_;
}


ValaField* vala_property_get_field (ValaProperty* self) {
	ValaField* result;
	ValaField* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_field;
	result = _tmp0_;
	return result;
}


void vala_property_set_field (ValaProperty* self, ValaField* value) {
	ValaField* _tmp0_;
	ValaField* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_field);
	self->priv->_field = _tmp1_;
}


ValaMemberBinding vala_property_get_binding (ValaProperty* self) {
	ValaMemberBinding result;
	ValaMemberBinding _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_binding;
	result = _tmp0_;
	return result;
}


void vala_property_set_binding (ValaProperty* self, ValaMemberBinding value) {
	ValaMemberBinding _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_binding = _tmp0_;
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp2_;
		_tmp2_ = old;
		_tmp1_ = (*((gchar*) _tmp2_)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = old;
		_tmp4_ = replacement;
		_tmp0_ = g_strcmp0 (_tmp3_, _tmp4_) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup (self);
		result = _tmp5_;
		return result;
	}
	{
		GRegex* regex = NULL;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		GRegex* _tmp9_;
		GRegex* _tmp10_;
		gchar* _tmp11_ = NULL;
		GRegex* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp6_ = old;
		_tmp7_ = g_regex_escape_string (_tmp6_, -1);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_regex_new (_tmp8_, 0, 0, &_inner_error_);
		_tmp10_ = _tmp9_;
		_g_free0 (_tmp8_);
		regex = _tmp10_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch19_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp12_ = regex;
		_tmp13_ = replacement;
		_tmp14_ = g_regex_replace_literal (_tmp12_, self, (gssize) -1, 0, _tmp13_, 0, &_inner_error_);
		_tmp11_ = _tmp14_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch19_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp15_ = _tmp11_;
		_tmp11_ = NULL;
		result = _tmp15_;
		_g_free0 (_tmp11_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally19;
	__catch19_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally19:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


const gchar* vala_property_get_nick (ValaProperty* self) {
	const gchar* result;
	const gchar* _tmp0_;
	const gchar* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_nick;
	if (_tmp0_ == NULL) {
		gchar* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = vala_code_node_get_attribute_string ((ValaCodeNode*) self, "Description", "nick", NULL);
		_g_free0 (self->priv->_nick);
		self->priv->_nick = _tmp1_;
		_tmp2_ = self->priv->_nick;
		if (_tmp2_ == NULL) {
			const gchar* _tmp3_;
			const gchar* _tmp4_;
			gchar* _tmp5_;
			_tmp3_ = vala_symbol_get_name ((ValaSymbol*) self);
			_tmp4_ = _tmp3_;
			_tmp5_ = string_replace (_tmp4_, "_", "-");
			_g_free0 (self->priv->_nick);
			self->priv->_nick = _tmp5_;
		}
	}
	_tmp6_ = self->priv->_nick;
	result = _tmp6_;
	return result;
}


const gchar* vala_property_get_blurb (ValaProperty* self) {
	const gchar* result;
	const gchar* _tmp0_;
	const gchar* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_blurb;
	if (_tmp0_ == NULL) {
		gchar* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = vala_code_node_get_attribute_string ((ValaCodeNode*) self, "Description", "blurb", NULL);
		_g_free0 (self->priv->_blurb);
		self->priv->_blurb = _tmp1_;
		_tmp2_ = self->priv->_blurb;
		if (_tmp2_ == NULL) {
			const gchar* _tmp3_;
			const gchar* _tmp4_;
			gchar* _tmp5_;
			_tmp3_ = vala_symbol_get_name ((ValaSymbol*) self);
			_tmp4_ = _tmp3_;
			_tmp5_ = string_replace (_tmp4_, "_", "-");
			_g_free0 (self->priv->_blurb);
			self->priv->_blurb = _tmp5_;
		}
	}
	_tmp6_ = self->priv->_blurb;
	result = _tmp6_;
	return result;
}


static gboolean* _bool_dup (gboolean* self) {
	gboolean* dup;
	dup = g_new0 (gboolean, 1);
	memcpy (dup, self, sizeof (gboolean));
	return dup;
}


static gpointer __bool_dup0 (gpointer self) {
	return self ? _bool_dup (self) : NULL;
}


gboolean vala_property_get_notify (ValaProperty* self) {
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_notify;
	if (_tmp0_ == NULL) {
		gboolean _tmp1_;
		gboolean* _tmp2_;
		_tmp1_ = vala_code_node_get_attribute_bool ((ValaCodeNode*) self, "CCode", "notify", TRUE);
		_tmp2_ = __bool_dup0 (&_tmp1_);
		_g_free0 (self->priv->_notify);
		self->priv->_notify = _tmp2_;
	}
	_tmp3_ = self->priv->_notify;
	result = *_tmp3_;
	return result;
}


ValaProperty* vala_property_get_base_property (ValaProperty* self) {
	ValaProperty* result;
	ValaProperty* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	vala_property_find_base_properties (self);
	_tmp0_ = self->priv->_base_property;
	result = _tmp0_;
	return result;
}


ValaProperty* vala_property_get_base_interface_property (ValaProperty* self) {
	ValaProperty* result;
	ValaProperty* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	vala_property_find_base_properties (self);
	_tmp0_ = self->priv->_base_interface_property;
	result = _tmp0_;
	return result;
}


ValaExpression* vala_property_get_initializer (ValaProperty* self) {
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_initializer;
	result = _tmp0_;
	return result;
}


void vala_property_set_initializer (ValaProperty* self, ValaExpression* value) {
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_initializer);
	self->priv->_initializer = _tmp1_;
	_tmp2_ = self->priv->_initializer;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
}


static void vala_property_class_init (ValaPropertyClass * klass) {
	vala_property_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_property_finalize;
	g_type_class_add_private (klass, sizeof (ValaPropertyPrivate));
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_property_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_property_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode *, ValaDataType*, ValaDataType*)) vala_property_real_replace_type;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode *, ValaExpression*, ValaExpression*)) vala_property_real_replace_expression;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode *, ValaCodeContext*)) vala_property_real_check;
}


static void vala_property_vala_lockable_interface_init (ValaLockableIface * iface) {
	vala_property_vala_lockable_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_lock_used = (gboolean (*) (ValaLockable *)) vala_property_real_get_lock_used;
	iface->set_lock_used = (void (*) (ValaLockable *, gboolean)) vala_property_real_set_lock_used;
}


static void vala_property_instance_init (ValaProperty * self) {
	self->priv = VALA_PROPERTY_GET_PRIVATE (self);
	self->priv->_binding = VALA_MEMBER_BINDING_INSTANCE;
	self->priv->lock_used = FALSE;
}


static void vala_property_finalize (ValaCodeNode * obj) {
	ValaProperty * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_PROPERTY, ValaProperty);
	_vala_code_node_unref0 (self->priv->_this_parameter);
	_vala_code_node_unref0 (self->priv->_field);
	_vala_code_node_unref0 (self->priv->_initializer);
	_vala_code_node_unref0 (self->priv->_data_type);
	_vala_code_node_unref0 (self->priv->_base_interface_property);
	_vala_code_node_unref0 (self->priv->_get_accessor);
	_vala_code_node_unref0 (self->priv->_set_accessor);
	_g_free0 (self->priv->_nick);
	_g_free0 (self->priv->_blurb);
	_g_free0 (self->priv->_notify);
	VALA_CODE_NODE_CLASS (vala_property_parent_class)->finalize (obj);
}


/**
 * Represents a property declaration in the source code.
 */
GType vala_property_get_type (void) {
	static volatile gsize vala_property_type_id__volatile = 0;
	if (g_once_init_enter (&vala_property_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaPropertyClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_property_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaProperty), 0, (GInstanceInitFunc) vala_property_instance_init, NULL };
		static const GInterfaceInfo vala_lockable_info = { (GInterfaceInitFunc) vala_property_vala_lockable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType vala_property_type_id;
		vala_property_type_id = g_type_register_static (VALA_TYPE_SYMBOL, "ValaProperty", &g_define_type_info, 0);
		g_type_add_interface_static (vala_property_type_id, VALA_TYPE_LOCKABLE, &vala_lockable_info);
		g_once_init_leave (&vala_property_type_id__volatile, vala_property_type_id);
	}
	return vala_property_type_id__volatile;
}



