/* valareport.c generated by valac, the Vala compiler
 * generated from valareport.vala, do not modify */

/* valareport.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <gmodule.h>


#define VALA_TYPE_REPORT (vala_report_get_type ())
#define VALA_REPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_REPORT, ValaReport))
#define VALA_REPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_REPORT, ValaReportClass))
#define VALA_IS_REPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_REPORT))
#define VALA_IS_REPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_REPORT))
#define VALA_REPORT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_REPORT, ValaReportClass))

typedef struct _ValaReport ValaReport;
typedef struct _ValaReportClass ValaReportClass;
typedef struct _ValaReportPrivate ValaReportPrivate;

#define VALA_TYPE_SOURCE_REFERENCE (vala_source_reference_get_type ())
#define VALA_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReference))
#define VALA_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))
#define VALA_IS_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_IS_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_SOURCE_REFERENCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))

typedef struct _ValaSourceReference ValaSourceReference;
typedef struct _ValaSourceReferenceClass ValaSourceReferenceClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define VALA_TYPE_SOURCE_LOCATION (vala_source_location_get_type ())
typedef struct _ValaSourceLocation ValaSourceLocation;

#define VALA_TYPE_SOURCE_FILE (vala_source_file_get_type ())
#define VALA_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFile))
#define VALA_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))
#define VALA_IS_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_FILE))
#define VALA_IS_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_FILE))
#define VALA_SOURCE_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))

typedef struct _ValaSourceFile ValaSourceFile;
typedef struct _ValaSourceFileClass ValaSourceFileClass;

#define VALA_TYPE_CODE_CONTEXT (vala_code_context_get_type ())
#define VALA_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContext))
#define VALA_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))
#define VALA_IS_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_CONTEXT))
#define VALA_IS_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_CONTEXT))
#define VALA_CODE_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))

typedef struct _ValaCodeContext ValaCodeContext;
typedef struct _ValaCodeContextClass ValaCodeContextClass;
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _g_module_close0(var) ((var == NULL) ? NULL : (var = (g_module_close (var), NULL)))

struct _ValaReport {
	GObject parent_instance;
	ValaReportPrivate * priv;
	gint warnings;
	gint errors;
};

struct _ValaReportClass {
	GObjectClass parent_class;
	void (*note) (ValaReport* self, ValaSourceReference* source, const gchar* message);
	void (*depr) (ValaReport* self, ValaSourceReference* source, const gchar* message);
	void (*warn) (ValaReport* self, ValaSourceReference* source, const gchar* message);
	void (*err) (ValaReport* self, ValaSourceReference* source, const gchar* message);
};

struct _ValaReportPrivate {
	gchar* locus_color_start;
	const gchar* locus_color_end;
	gchar* warning_color_start;
	const gchar* warning_color_end;
	gchar* error_color_start;
	const gchar* error_color_end;
	gchar* note_color_start;
	const gchar* note_color_end;
	gchar* caret_color_start;
	const gchar* caret_color_end;
	gchar* quote_color_start;
	const gchar* quote_color_end;
	gboolean verbose_errors;
	gboolean _enable_warnings;
};

struct _ValaSourceLocation {
	gchar* pos;
	gint line;
	gint column;
};

typedef gint (*ValaReportAttyFunc) (gint fd);

static gpointer vala_report_parent_class = NULL;
static GRegex* vala_report_val_regex;
static GRegex* vala_report_val_regex = NULL;

GType vala_report_get_type (void) G_GNUC_CONST;
gpointer vala_source_reference_ref (gpointer instance);
void vala_source_reference_unref (gpointer instance);
GParamSpec* vala_param_spec_source_reference (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_reference (GValue* value, gpointer v_object);
void vala_value_take_source_reference (GValue* value, gpointer v_object);
gpointer vala_value_get_source_reference (const GValue* value);
GType vala_source_reference_get_type (void) G_GNUC_CONST;
#define VALA_REPORT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_REPORT, ValaReportPrivate))
enum  {
	VALA_REPORT_0_PROPERTY,
	VALA_REPORT_ENABLE_WARNINGS_PROPERTY
};
#define VALA_REPORT_ANSI_COLOR_END "\x1b[0m"
gboolean vala_report_set_colors (ValaReport* self, const gchar* str);
static gboolean vala_report_is_atty (ValaReport* self, gint fd);
void vala_report_set_verbose_errors (ValaReport* self, gboolean verbose);
gint vala_report_get_warnings (ValaReport* self);
gint vala_report_get_errors (ValaReport* self);
static void vala_report_report_source (ValaReport* self, ValaSourceReference* source);
GType vala_source_location_get_type (void) G_GNUC_CONST;
ValaSourceLocation* vala_source_location_dup (const ValaSourceLocation* self);
void vala_source_location_free (ValaSourceLocation* self);
void vala_source_reference_get_begin (ValaSourceReference* self, ValaSourceLocation * result);
void vala_source_reference_get_end (ValaSourceReference* self, ValaSourceLocation * result);
gpointer vala_source_file_ref (gpointer instance);
void vala_source_file_unref (gpointer instance);
GParamSpec* vala_param_spec_source_file (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_file (GValue* value, gpointer v_object);
void vala_value_take_source_file (GValue* value, gpointer v_object);
gpointer vala_value_get_source_file (const GValue* value);
GType vala_source_file_get_type (void) G_GNUC_CONST;
ValaSourceFile* vala_source_reference_get_file (ValaSourceReference* self);
gchar* vala_source_file_get_source_line (ValaSourceFile* self, gint lineno);
static void vala_report_print_highlighted_message (ValaReport* self, const gchar* message);
static void vala_report_print_message (ValaReport* self, ValaSourceReference* source, const gchar* type, const gchar* type_color_start, const gchar* type_color_end, const gchar* message, gboolean do_report_source);
gchar* vala_source_reference_to_string (ValaSourceReference* self);
void vala_report_note (ValaReport* self, ValaSourceReference* source, const gchar* message);
static void vala_report_real_note (ValaReport* self, ValaSourceReference* source, const gchar* message);
gboolean vala_report_get_enable_warnings (ValaReport* self);
void vala_report_depr (ValaReport* self, ValaSourceReference* source, const gchar* message);
static void vala_report_real_depr (ValaReport* self, ValaSourceReference* source, const gchar* message);
void vala_report_warn (ValaReport* self, ValaSourceReference* source, const gchar* message);
static void vala_report_real_warn (ValaReport* self, ValaSourceReference* source, const gchar* message);
void vala_report_err (ValaReport* self, ValaSourceReference* source, const gchar* message);
static void vala_report_real_err (ValaReport* self, ValaSourceReference* source, const gchar* message);
void vala_report_notice (ValaSourceReference* source, const gchar* message);
gpointer vala_code_context_ref (gpointer instance);
void vala_code_context_unref (gpointer instance);
GParamSpec* vala_param_spec_code_context (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_context (GValue* value, gpointer v_object);
void vala_value_take_code_context (GValue* value, gpointer v_object);
gpointer vala_value_get_code_context (const GValue* value);
GType vala_code_context_get_type (void) G_GNUC_CONST;
ValaCodeContext* vala_code_context_get (void);
ValaReport* vala_code_context_get_report (ValaCodeContext* self);
void vala_report_deprecated (ValaSourceReference* source, const gchar* message);
void vala_report_experimental (ValaSourceReference* source, const gchar* message);
void vala_report_warning (ValaSourceReference* source, const gchar* message);
void vala_report_error (ValaSourceReference* source, const gchar* message);
ValaReport* vala_report_new (void);
ValaReport* vala_report_construct (GType object_type);
void vala_report_set_enable_warnings (ValaReport* self, gboolean value);
static void vala_report_finalize (GObject * obj);
static void _vala_vala_report_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_vala_report_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


/**
 * Set all colors by string
 *
 * {{{
 *   "error=01;31:warning=01;35:note=01;36:caret=01;32:locus=01:quote=01"
 * }}}
 */
gboolean vala_report_set_colors (ValaReport* self, const gchar* str) {
	gboolean result = FALSE;
	gchar* error_color = NULL;
	gchar* warning_color = NULL;
	gchar* note_color = NULL;
	gchar* caret_color = NULL;
	gchar* locus_color = NULL;
	gchar* quote_color = NULL;
	gchar** fragments = NULL;
	const gchar* _tmp6_;
	gchar** _tmp7_;
	gchar** _tmp8_;
	gint fragments_length1;
	gint _fragments_size_;
	gchar** _tmp9_;
	gint _tmp9__length1;
	FILE* _tmp39_;
	gint _tmp40_;
	gboolean _tmp41_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (str != NULL, FALSE);
	{
		GRegex* _tmp0_;
		_tmp0_ = vala_report_val_regex;
		if (_tmp0_ == NULL) {
			GRegex* _tmp1_ = NULL;
			GRegex* _tmp2_;
			GRegex* _tmp4_;
			_tmp2_ = g_regex_new ("^\\s*[0-9]+(;[0-9]*)*\\s*$", 0, 0, &_inner_error_);
			_tmp1_ = _tmp2_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				gboolean _tmp3_ = FALSE;
				if (_inner_error_->domain == G_REGEX_ERROR) {
					goto __catch16_g_regex_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return _tmp3_;
			}
			_tmp4_ = _tmp1_;
			_tmp1_ = NULL;
			_g_regex_unref0 (vala_report_val_regex);
			vala_report_val_regex = _tmp4_;
			_g_regex_unref0 (_tmp1_);
		}
	}
	goto __finally16;
	__catch16_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally16:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gboolean _tmp5_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp5_;
	}
	error_color = NULL;
	warning_color = NULL;
	note_color = NULL;
	caret_color = NULL;
	locus_color = NULL;
	quote_color = NULL;
	_tmp6_ = str;
	_tmp8_ = _tmp7_ = g_strsplit (_tmp6_, ":", 0);
	fragments = _tmp8_;
	fragments_length1 = _vala_array_length (_tmp7_);
	_fragments_size_ = fragments_length1;
	_tmp9_ = fragments;
	_tmp9__length1 = fragments_length1;
	{
		gchar** fragment_collection = NULL;
		gint fragment_collection_length1 = 0;
		gint _fragment_collection_size_ = 0;
		gint fragment_it = 0;
		fragment_collection = _tmp9_;
		fragment_collection_length1 = _tmp9__length1;
		for (fragment_it = 0; fragment_it < _tmp9__length1; fragment_it = fragment_it + 1) {
			const gchar* fragment = NULL;
			fragment = fragment_collection[fragment_it];
			{
				gchar** eq = NULL;
				const gchar* _tmp10_;
				gchar** _tmp11_;
				gchar** _tmp12_;
				gint eq_length1;
				gint _eq_size_;
				gchar** _tmp13_;
				gint _tmp13__length1;
				GRegex* _tmp14_;
				gchar** _tmp15_;
				gint _tmp15__length1;
				const gchar* _tmp16_;
				gboolean _tmp17_;
				const gchar* checked_value = NULL;
				gchar** _tmp18_;
				gint _tmp18__length1;
				const gchar* _tmp19_;
				const gchar* _tmp20_;
				gchar** _tmp21_;
				gint _tmp21__length1;
				const gchar* _tmp22_;
				const gchar* _tmp23_;
				const gchar* _tmp24_;
				GQuark _tmp26_ = 0U;
				static GQuark _tmp25_label0 = 0;
				static GQuark _tmp25_label1 = 0;
				static GQuark _tmp25_label2 = 0;
				static GQuark _tmp25_label3 = 0;
				static GQuark _tmp25_label4 = 0;
				static GQuark _tmp25_label5 = 0;
				_tmp10_ = fragment;
				_tmp12_ = _tmp11_ = g_strsplit (_tmp10_, "=", 2);
				eq = _tmp12_;
				eq_length1 = _vala_array_length (_tmp11_);
				_eq_size_ = eq_length1;
				_tmp13_ = eq;
				_tmp13__length1 = eq_length1;
				if (_tmp13__length1 != 2) {
					result = FALSE;
					eq = (_vala_array_free (eq, eq_length1, (GDestroyNotify) g_free), NULL);
					fragments = (_vala_array_free (fragments, fragments_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (quote_color);
					_g_free0 (locus_color);
					_g_free0 (caret_color);
					_g_free0 (note_color);
					_g_free0 (warning_color);
					_g_free0 (error_color);
					return result;
				}
				_tmp14_ = vala_report_val_regex;
				_tmp15_ = eq;
				_tmp15__length1 = eq_length1;
				_tmp16_ = _tmp15_[1];
				_tmp17_ = g_regex_match (_tmp14_, _tmp16_, 0, NULL);
				if (!_tmp17_) {
					result = FALSE;
					eq = (_vala_array_free (eq, eq_length1, (GDestroyNotify) g_free), NULL);
					fragments = (_vala_array_free (fragments, fragments_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (quote_color);
					_g_free0 (locus_color);
					_g_free0 (caret_color);
					_g_free0 (note_color);
					_g_free0 (warning_color);
					_g_free0 (error_color);
					return result;
				}
				_tmp18_ = eq;
				_tmp18__length1 = eq_length1;
				_tmp19_ = _tmp18_[1];
				_tmp20_ = g_strstrip (_tmp19_);
				checked_value = _tmp20_;
				_tmp21_ = eq;
				_tmp21__length1 = eq_length1;
				_tmp22_ = _tmp21_[0];
				_tmp23_ = g_strstrip (_tmp22_);
				_tmp24_ = _tmp23_;
				_tmp26_ = (NULL == _tmp24_) ? 0 : g_quark_from_string (_tmp24_);
				if (_tmp26_ == ((0 != _tmp25_label0) ? _tmp25_label0 : (_tmp25_label0 = g_quark_from_static_string ("error")))) {
					switch (0) {
						default:
						{
							const gchar* _tmp27_;
							gchar* _tmp28_;
							_tmp27_ = checked_value;
							_tmp28_ = g_strdup (_tmp27_);
							_g_free0 (error_color);
							error_color = _tmp28_;
							break;
						}
					}
				} else if (_tmp26_ == ((0 != _tmp25_label1) ? _tmp25_label1 : (_tmp25_label1 = g_quark_from_static_string ("warning")))) {
					switch (0) {
						default:
						{
							const gchar* _tmp29_;
							gchar* _tmp30_;
							_tmp29_ = checked_value;
							_tmp30_ = g_strdup (_tmp29_);
							_g_free0 (warning_color);
							warning_color = _tmp30_;
							break;
						}
					}
				} else if (_tmp26_ == ((0 != _tmp25_label2) ? _tmp25_label2 : (_tmp25_label2 = g_quark_from_static_string ("note")))) {
					switch (0) {
						default:
						{
							const gchar* _tmp31_;
							gchar* _tmp32_;
							_tmp31_ = checked_value;
							_tmp32_ = g_strdup (_tmp31_);
							_g_free0 (note_color);
							note_color = _tmp32_;
							break;
						}
					}
				} else if (_tmp26_ == ((0 != _tmp25_label3) ? _tmp25_label3 : (_tmp25_label3 = g_quark_from_static_string ("caret")))) {
					switch (0) {
						default:
						{
							const gchar* _tmp33_;
							gchar* _tmp34_;
							_tmp33_ = checked_value;
							_tmp34_ = g_strdup (_tmp33_);
							_g_free0 (caret_color);
							caret_color = _tmp34_;
							break;
						}
					}
				} else if (_tmp26_ == ((0 != _tmp25_label4) ? _tmp25_label4 : (_tmp25_label4 = g_quark_from_static_string ("locus")))) {
					switch (0) {
						default:
						{
							const gchar* _tmp35_;
							gchar* _tmp36_;
							_tmp35_ = checked_value;
							_tmp36_ = g_strdup (_tmp35_);
							_g_free0 (locus_color);
							locus_color = _tmp36_;
							break;
						}
					}
				} else if (_tmp26_ == ((0 != _tmp25_label5) ? _tmp25_label5 : (_tmp25_label5 = g_quark_from_static_string ("quote")))) {
					switch (0) {
						default:
						{
							const gchar* _tmp37_;
							gchar* _tmp38_;
							_tmp37_ = checked_value;
							_tmp38_ = g_strdup (_tmp37_);
							_g_free0 (quote_color);
							quote_color = _tmp38_;
							break;
						}
					}
				} else {
					switch (0) {
						default:
						{
							result = FALSE;
							eq = (_vala_array_free (eq, eq_length1, (GDestroyNotify) g_free), NULL);
							fragments = (_vala_array_free (fragments, fragments_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (quote_color);
							_g_free0 (locus_color);
							_g_free0 (caret_color);
							_g_free0 (note_color);
							_g_free0 (warning_color);
							_g_free0 (error_color);
							return result;
						}
					}
				}
				eq = (_vala_array_free (eq, eq_length1, (GDestroyNotify) g_free), NULL);
			}
		}
	}
	_tmp39_ = stderr;
	_tmp40_ = fileno (_tmp39_);
	_tmp41_ = vala_report_is_atty (self, _tmp40_);
	if (_tmp41_) {
		const gchar* _tmp42_;
		const gchar* _tmp47_;
		const gchar* _tmp52_;
		const gchar* _tmp57_;
		const gchar* _tmp62_;
		const gchar* _tmp67_;
		_tmp42_ = error_color;
		if (_tmp42_ != NULL) {
			const gchar* _tmp43_;
			gchar* _tmp44_;
			gchar* _tmp45_;
			gchar* _tmp46_;
			_tmp43_ = error_color;
			_tmp44_ = g_strconcat ("\x1b[0", _tmp43_, NULL);
			_tmp45_ = _tmp44_;
			_tmp46_ = g_strconcat (_tmp45_, "m", NULL);
			_g_free0 (self->priv->error_color_start);
			self->priv->error_color_start = _tmp46_;
			_g_free0 (_tmp45_);
			self->priv->error_color_end = VALA_REPORT_ANSI_COLOR_END;
		}
		_tmp47_ = warning_color;
		if (_tmp47_ != NULL) {
			const gchar* _tmp48_;
			gchar* _tmp49_;
			gchar* _tmp50_;
			gchar* _tmp51_;
			_tmp48_ = warning_color;
			_tmp49_ = g_strconcat ("\x1b[0", _tmp48_, NULL);
			_tmp50_ = _tmp49_;
			_tmp51_ = g_strconcat (_tmp50_, "m", NULL);
			_g_free0 (self->priv->warning_color_start);
			self->priv->warning_color_start = _tmp51_;
			_g_free0 (_tmp50_);
			self->priv->warning_color_end = VALA_REPORT_ANSI_COLOR_END;
		}
		_tmp52_ = note_color;
		if (_tmp52_ != NULL) {
			const gchar* _tmp53_;
			gchar* _tmp54_;
			gchar* _tmp55_;
			gchar* _tmp56_;
			_tmp53_ = note_color;
			_tmp54_ = g_strconcat ("\x1b[0", _tmp53_, NULL);
			_tmp55_ = _tmp54_;
			_tmp56_ = g_strconcat (_tmp55_, "m", NULL);
			_g_free0 (self->priv->note_color_start);
			self->priv->note_color_start = _tmp56_;
			_g_free0 (_tmp55_);
			self->priv->note_color_end = VALA_REPORT_ANSI_COLOR_END;
		}
		_tmp57_ = caret_color;
		if (_tmp57_ != NULL) {
			const gchar* _tmp58_;
			gchar* _tmp59_;
			gchar* _tmp60_;
			gchar* _tmp61_;
			_tmp58_ = caret_color;
			_tmp59_ = g_strconcat ("\x1b[0", _tmp58_, NULL);
			_tmp60_ = _tmp59_;
			_tmp61_ = g_strconcat (_tmp60_, "m", NULL);
			_g_free0 (self->priv->caret_color_start);
			self->priv->caret_color_start = _tmp61_;
			_g_free0 (_tmp60_);
			self->priv->caret_color_end = VALA_REPORT_ANSI_COLOR_END;
		}
		_tmp62_ = locus_color;
		if (_tmp62_ != NULL) {
			const gchar* _tmp63_;
			gchar* _tmp64_;
			gchar* _tmp65_;
			gchar* _tmp66_;
			_tmp63_ = locus_color;
			_tmp64_ = g_strconcat ("\x1b[0", _tmp63_, NULL);
			_tmp65_ = _tmp64_;
			_tmp66_ = g_strconcat (_tmp65_, "m", NULL);
			_g_free0 (self->priv->locus_color_start);
			self->priv->locus_color_start = _tmp66_;
			_g_free0 (_tmp65_);
			self->priv->locus_color_end = VALA_REPORT_ANSI_COLOR_END;
		}
		_tmp67_ = quote_color;
		if (_tmp67_ != NULL) {
			const gchar* _tmp68_;
			gchar* _tmp69_;
			gchar* _tmp70_;
			gchar* _tmp71_;
			_tmp68_ = quote_color;
			_tmp69_ = g_strconcat ("\x1b[0", _tmp68_, NULL);
			_tmp70_ = _tmp69_;
			_tmp71_ = g_strconcat (_tmp70_, "m", NULL);
			_g_free0 (self->priv->quote_color_start);
			self->priv->quote_color_start = _tmp71_;
			_g_free0 (_tmp70_);
			self->priv->quote_color_end = VALA_REPORT_ANSI_COLOR_END;
		}
	}
	result = TRUE;
	fragments = (_vala_array_free (fragments, fragments_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (quote_color);
	_g_free0 (locus_color);
	_g_free0 (caret_color);
	_g_free0 (note_color);
	_g_free0 (warning_color);
	_g_free0 (error_color);
	return result;
}


/**
 * Set the error verbosity.
 */
void vala_report_set_verbose_errors (ValaReport* self, gboolean verbose) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = verbose;
	self->priv->verbose_errors = _tmp0_;
}


/**
 * Returns the total number of warnings reported.
 */
gint vala_report_get_warnings (ValaReport* self) {
	gint result = 0;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->warnings;
	result = _tmp0_;
	return result;
}


/**
 * Returns the total number of errors reported.
 */
gint vala_report_get_errors (ValaReport* self) {
	gint result = 0;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->errors;
	result = _tmp0_;
	return result;
}


/**
 * Pretty-print the actual line of offending code if possible.
 */
static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static void vala_report_report_source (ValaReport* self, ValaSourceReference* source) {
	ValaSourceReference* _tmp0_;
	ValaSourceLocation _tmp1_ = {0};
	ValaSourceLocation _tmp2_;
	gint _tmp3_;
	ValaSourceReference* _tmp4_;
	ValaSourceLocation _tmp5_ = {0};
	ValaSourceLocation _tmp6_;
	gint _tmp7_;
	gchar* offending_line = NULL;
	ValaSourceReference* _tmp8_;
	ValaSourceFile* _tmp9_;
	ValaSourceFile* _tmp10_;
	ValaSourceReference* _tmp11_;
	ValaSourceLocation _tmp12_ = {0};
	ValaSourceLocation _tmp13_;
	gint _tmp14_;
	gchar* _tmp15_;
	const gchar* _tmp16_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	_tmp0_ = source;
	vala_source_reference_get_begin (_tmp0_, &_tmp1_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_.line;
	_tmp4_ = source;
	vala_source_reference_get_end (_tmp4_, &_tmp5_);
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp6_.line;
	if (_tmp3_ != _tmp7_) {
		return;
	}
	_tmp8_ = source;
	_tmp9_ = vala_source_reference_get_file (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = source;
	vala_source_reference_get_begin (_tmp11_, &_tmp12_);
	_tmp13_ = _tmp12_;
	_tmp14_ = _tmp13_.line;
	_tmp15_ = vala_source_file_get_source_line (_tmp10_, _tmp14_);
	offending_line = _tmp15_;
	_tmp16_ = offending_line;
	if (_tmp16_ != NULL) {
		FILE* _tmp17_;
		const gchar* _tmp18_;
		gint idx = 0;
		FILE* _tmp31_;
		const gchar* _tmp32_;
		FILE* _tmp49_;
		const gchar* _tmp50_;
		FILE* _tmp51_;
		_tmp17_ = stderr;
		_tmp18_ = offending_line;
		fprintf (_tmp17_, "%s\n", _tmp18_);
		{
			gboolean _tmp19_ = FALSE;
			idx = 1;
			_tmp19_ = TRUE;
			while (TRUE) {
				gint _tmp21_;
				ValaSourceReference* _tmp22_;
				ValaSourceLocation _tmp23_ = {0};
				ValaSourceLocation _tmp24_;
				gint _tmp25_;
				const gchar* _tmp26_;
				gint _tmp27_;
				gchar _tmp28_;
				if (!_tmp19_) {
					gint _tmp20_;
					_tmp20_ = idx;
					idx = _tmp20_ + 1;
				}
				_tmp19_ = FALSE;
				_tmp21_ = idx;
				_tmp22_ = source;
				vala_source_reference_get_begin (_tmp22_, &_tmp23_);
				_tmp24_ = _tmp23_;
				_tmp25_ = _tmp24_.column;
				if (!(_tmp21_ < _tmp25_)) {
					break;
				}
				_tmp26_ = offending_line;
				_tmp27_ = idx;
				_tmp28_ = string_get (_tmp26_, (glong) (_tmp27_ - 1));
				if (_tmp28_ == '\t') {
					FILE* _tmp29_;
					_tmp29_ = stderr;
					fprintf (_tmp29_, "\t");
				} else {
					FILE* _tmp30_;
					_tmp30_ = stderr;
					fprintf (_tmp30_, " ");
				}
			}
		}
		_tmp31_ = stderr;
		_tmp32_ = self->priv->caret_color_start;
		fputs (_tmp32_, _tmp31_);
		{
			ValaSourceReference* _tmp33_;
			ValaSourceLocation _tmp34_ = {0};
			ValaSourceLocation _tmp35_;
			gint _tmp36_;
			gboolean _tmp37_ = FALSE;
			_tmp33_ = source;
			vala_source_reference_get_begin (_tmp33_, &_tmp34_);
			_tmp35_ = _tmp34_;
			_tmp36_ = _tmp35_.column;
			idx = _tmp36_;
			_tmp37_ = TRUE;
			while (TRUE) {
				gint _tmp39_;
				ValaSourceReference* _tmp40_;
				ValaSourceLocation _tmp41_ = {0};
				ValaSourceLocation _tmp42_;
				gint _tmp43_;
				const gchar* _tmp44_;
				gint _tmp45_;
				gchar _tmp46_;
				if (!_tmp37_) {
					gint _tmp38_;
					_tmp38_ = idx;
					idx = _tmp38_ + 1;
				}
				_tmp37_ = FALSE;
				_tmp39_ = idx;
				_tmp40_ = source;
				vala_source_reference_get_end (_tmp40_, &_tmp41_);
				_tmp42_ = _tmp41_;
				_tmp43_ = _tmp42_.column;
				if (!(_tmp39_ <= _tmp43_)) {
					break;
				}
				_tmp44_ = offending_line;
				_tmp45_ = idx;
				_tmp46_ = string_get (_tmp44_, (glong) (_tmp45_ - 1));
				if (_tmp46_ == '\t') {
					FILE* _tmp47_;
					_tmp47_ = stderr;
					fprintf (_tmp47_, "\t");
				} else {
					FILE* _tmp48_;
					_tmp48_ = stderr;
					fprintf (_tmp48_, "^");
				}
			}
		}
		_tmp49_ = stderr;
		_tmp50_ = self->priv->caret_color_end;
		fputs (_tmp50_, _tmp49_);
		_tmp51_ = stderr;
		fprintf (_tmp51_, "\n");
	}
	_g_free0 (offending_line);
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	glong _tmp8_;
	glong _tmp14_;
	glong _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	gchar* _tmp22_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_;
		glong _tmp4_;
		glong _tmp5_;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_;
		gint _tmp7_;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_;
		glong _tmp10_;
		glong _tmp11_;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_;
		glong _tmp13_;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_;
		glong _tmp16_;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


static gint string_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_;
	gunichar _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = c;
	_tmp2_ = g_utf8_strchr (((gchar*) self) + _tmp0_, (gssize) -1, _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static const gchar* string_offset (const gchar* self, glong offset) {
	const gchar* result = NULL;
	glong _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = offset;
	result = (const gchar*) (((gchar*) self) + _tmp0_);
	return result;
}


static void vala_report_print_highlighted_message (ValaReport* self, const gchar* message) {
	gint start = 0;
	gint cur = 0;
	FILE* _tmp56_;
	const gchar* _tmp57_;
	gint _tmp58_;
	const gchar* _tmp59_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	start = 0;
	cur = 0;
	while (TRUE) {
		const gchar* _tmp0_;
		gint _tmp1_;
		gchar _tmp2_;
		gboolean _tmp3_ = FALSE;
		const gchar* _tmp4_;
		gint _tmp5_;
		gchar _tmp6_;
		_tmp0_ = message;
		_tmp1_ = cur;
		_tmp2_ = string_get (_tmp0_, (glong) _tmp1_);
		if (!(_tmp2_ != '\0')) {
			break;
		}
		_tmp4_ = message;
		_tmp5_ = cur;
		_tmp6_ = string_get (_tmp4_, (glong) _tmp5_);
		if (_tmp6_ == '\'') {
			_tmp3_ = TRUE;
		} else {
			const gchar* _tmp7_;
			gint _tmp8_;
			gchar _tmp9_;
			_tmp7_ = message;
			_tmp8_ = cur;
			_tmp9_ = string_get (_tmp7_, (glong) _tmp8_);
			_tmp3_ = _tmp9_ == '`';
		}
		if (_tmp3_) {
			const gchar* _tmp10_ = NULL;
			const gchar* _tmp11_;
			gint _tmp12_;
			gchar _tmp13_;
			const gchar* end_chars = NULL;
			FILE* _tmp14_;
			const gchar* _tmp15_;
			gint _tmp16_;
			gint _tmp17_;
			gint _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			gint _tmp21_;
			gint _tmp22_;
			const gchar* _tmp33_;
			gint _tmp34_;
			gchar _tmp35_;
			_tmp11_ = message;
			_tmp12_ = cur;
			_tmp13_ = string_get (_tmp11_, (glong) _tmp12_);
			if (_tmp13_ == '`') {
				_tmp10_ = "`'";
			} else {
				_tmp10_ = "'";
			}
			end_chars = _tmp10_;
			_tmp14_ = stderr;
			_tmp15_ = message;
			_tmp16_ = start;
			_tmp17_ = cur;
			_tmp18_ = start;
			_tmp19_ = string_substring (_tmp15_, (glong) _tmp16_, (glong) (_tmp17_ - _tmp18_));
			_tmp20_ = _tmp19_;
			fputs (_tmp20_, _tmp14_);
			_g_free0 (_tmp20_);
			_tmp21_ = cur;
			start = _tmp21_;
			_tmp22_ = cur;
			cur = _tmp22_ + 1;
			while (TRUE) {
				gboolean _tmp23_ = FALSE;
				const gchar* _tmp24_;
				gint _tmp25_;
				gchar _tmp26_;
				gint _tmp32_;
				_tmp24_ = message;
				_tmp25_ = cur;
				_tmp26_ = string_get (_tmp24_, (glong) _tmp25_);
				if (_tmp26_ != '\0') {
					const gchar* _tmp27_;
					const gchar* _tmp28_;
					gint _tmp29_;
					gchar _tmp30_;
					gint _tmp31_;
					_tmp27_ = end_chars;
					_tmp28_ = message;
					_tmp29_ = cur;
					_tmp30_ = string_get (_tmp28_, (glong) _tmp29_);
					_tmp31_ = string_index_of_char (_tmp27_, (gunichar) _tmp30_, 0);
					_tmp23_ = _tmp31_ < 0;
				} else {
					_tmp23_ = FALSE;
				}
				if (!_tmp23_) {
					break;
				}
				_tmp32_ = cur;
				cur = _tmp32_ + 1;
			}
			_tmp33_ = message;
			_tmp34_ = cur;
			_tmp35_ = string_get (_tmp33_, (glong) _tmp34_);
			if (_tmp35_ == '\0') {
				FILE* _tmp36_;
				const gchar* _tmp37_;
				gint _tmp38_;
				gint _tmp39_;
				gint _tmp40_;
				gchar* _tmp41_;
				gchar* _tmp42_;
				gint _tmp43_;
				_tmp36_ = stderr;
				_tmp37_ = message;
				_tmp38_ = start;
				_tmp39_ = cur;
				_tmp40_ = start;
				_tmp41_ = string_substring (_tmp37_, (glong) _tmp38_, (glong) (_tmp39_ - _tmp40_));
				_tmp42_ = _tmp41_;
				fputs (_tmp42_, _tmp36_);
				_g_free0 (_tmp42_);
				_tmp43_ = cur;
				start = _tmp43_;
			} else {
				gint _tmp44_;
				FILE* _tmp45_;
				const gchar* _tmp46_;
				const gchar* _tmp47_;
				gint _tmp48_;
				gint _tmp49_;
				gint _tmp50_;
				gchar* _tmp51_;
				gchar* _tmp52_;
				const gchar* _tmp53_;
				gint _tmp54_;
				_tmp44_ = cur;
				cur = _tmp44_ + 1;
				_tmp45_ = stderr;
				_tmp46_ = self->priv->quote_color_start;
				_tmp47_ = message;
				_tmp48_ = start;
				_tmp49_ = cur;
				_tmp50_ = start;
				_tmp51_ = string_substring (_tmp47_, (glong) _tmp48_, (glong) (_tmp49_ - _tmp50_));
				_tmp52_ = _tmp51_;
				_tmp53_ = self->priv->quote_color_end;
				fprintf (_tmp45_, "%s%s%s", _tmp46_, _tmp52_, _tmp53_);
				_g_free0 (_tmp52_);
				_tmp54_ = cur;
				start = _tmp54_;
			}
		} else {
			gint _tmp55_;
			_tmp55_ = cur;
			cur = _tmp55_ + 1;
		}
	}
	_tmp56_ = stderr;
	_tmp57_ = message;
	_tmp58_ = start;
	_tmp59_ = string_offset (_tmp57_, (glong) _tmp58_);
	fputs (_tmp59_, _tmp56_);
}


static void vala_report_print_message (ValaReport* self, ValaSourceReference* source, const gchar* type, const gchar* type_color_start, const gchar* type_color_end, const gchar* message, gboolean do_report_source) {
	ValaSourceReference* _tmp0_;
	FILE* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	FILE* _tmp12_;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	g_return_if_fail (type_color_start != NULL);
	g_return_if_fail (type_color_end != NULL);
	g_return_if_fail (message != NULL);
	_tmp0_ = source;
	if (_tmp0_ != NULL) {
		FILE* _tmp1_;
		const gchar* _tmp2_;
		ValaSourceReference* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		const gchar* _tmp6_;
		_tmp1_ = stderr;
		_tmp2_ = self->priv->locus_color_start;
		_tmp3_ = source;
		_tmp4_ = vala_source_reference_to_string (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = self->priv->locus_color_end;
		fprintf (_tmp1_, "%s%s:%s ", _tmp2_, _tmp5_, _tmp6_);
		_g_free0 (_tmp5_);
	}
	_tmp7_ = stderr;
	_tmp8_ = type_color_start;
	_tmp9_ = type;
	_tmp10_ = type_color_end;
	fprintf (_tmp7_, "%s%s:%s ", _tmp8_, _tmp9_, _tmp10_);
	_tmp11_ = message;
	vala_report_print_highlighted_message (self, _tmp11_);
	_tmp12_ = stderr;
	fputc ('\n', _tmp12_);
	_tmp14_ = do_report_source;
	if (_tmp14_) {
		ValaSourceReference* _tmp15_;
		_tmp15_ = source;
		_tmp13_ = _tmp15_ != NULL;
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		ValaSourceReference* _tmp16_;
		_tmp16_ = source;
		vala_report_report_source (self, _tmp16_);
	}
}


/**
 * Reports the specified message as note.
 *
 * @param source  reference to source code
 * @param message note message
 */
static void vala_report_real_note (ValaReport* self, ValaSourceReference* source, const gchar* message) {
	gboolean _tmp0_;
	ValaSourceReference* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gboolean _tmp5_;
	g_return_if_fail (message != NULL);
	_tmp0_ = self->priv->_enable_warnings;
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = source;
	_tmp2_ = self->priv->note_color_start;
	_tmp3_ = self->priv->note_color_end;
	_tmp4_ = message;
	_tmp5_ = self->priv->verbose_errors;
	vala_report_print_message (self, _tmp1_, "note", _tmp2_, _tmp3_, _tmp4_, _tmp5_);
}


void vala_report_note (ValaReport* self, ValaSourceReference* source, const gchar* message) {
	g_return_if_fail (self != NULL);
	VALA_REPORT_GET_CLASS (self)->note (self, source, message);
}


/**
 * Reports the specified message as deprecation warning.
 *
 * @param source  reference to source code
 * @param message warning message
 */
static void vala_report_real_depr (ValaReport* self, ValaSourceReference* source, const gchar* message) {
	gboolean _tmp0_;
	gint _tmp1_;
	ValaSourceReference* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	g_return_if_fail (message != NULL);
	_tmp0_ = self->priv->_enable_warnings;
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = self->warnings;
	self->warnings = _tmp1_ + 1;
	_tmp2_ = source;
	_tmp3_ = self->priv->warning_color_start;
	_tmp4_ = self->priv->warning_color_end;
	_tmp5_ = message;
	vala_report_print_message (self, _tmp2_, "warning", _tmp3_, _tmp4_, _tmp5_, FALSE);
}


void vala_report_depr (ValaReport* self, ValaSourceReference* source, const gchar* message) {
	g_return_if_fail (self != NULL);
	VALA_REPORT_GET_CLASS (self)->depr (self, source, message);
}


/**
 * Reports the specified message as warning.
 *
 * @param source  reference to source code
 * @param message warning message
 */
static void vala_report_real_warn (ValaReport* self, ValaSourceReference* source, const gchar* message) {
	gboolean _tmp0_;
	gint _tmp1_;
	ValaSourceReference* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gboolean _tmp6_;
	g_return_if_fail (message != NULL);
	_tmp0_ = self->priv->_enable_warnings;
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = self->warnings;
	self->warnings = _tmp1_ + 1;
	_tmp2_ = source;
	_tmp3_ = self->priv->warning_color_start;
	_tmp4_ = self->priv->warning_color_end;
	_tmp5_ = message;
	_tmp6_ = self->priv->verbose_errors;
	vala_report_print_message (self, _tmp2_, "warning", _tmp3_, _tmp4_, _tmp5_, _tmp6_);
}


void vala_report_warn (ValaReport* self, ValaSourceReference* source, const gchar* message) {
	g_return_if_fail (self != NULL);
	VALA_REPORT_GET_CLASS (self)->warn (self, source, message);
}


/**
 * Reports the specified message as error.
 *
 * @param source  reference to source code
 * @param message error message
 */
static void vala_report_real_err (ValaReport* self, ValaSourceReference* source, const gchar* message) {
	gint _tmp0_;
	ValaSourceReference* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gboolean _tmp5_;
	g_return_if_fail (message != NULL);
	_tmp0_ = self->errors;
	self->errors = _tmp0_ + 1;
	_tmp1_ = source;
	_tmp2_ = self->priv->error_color_start;
	_tmp3_ = self->priv->error_color_end;
	_tmp4_ = message;
	_tmp5_ = self->priv->verbose_errors;
	vala_report_print_message (self, _tmp1_, "error", _tmp2_, _tmp3_, _tmp4_, _tmp5_);
}


void vala_report_err (ValaReport* self, ValaSourceReference* source, const gchar* message) {
	g_return_if_fail (self != NULL);
	VALA_REPORT_GET_CLASS (self)->err (self, source, message);
}


void vala_report_notice (ValaSourceReference* source, const gchar* message) {
	ValaCodeContext* _tmp0_;
	ValaCodeContext* _tmp1_;
	ValaReport* _tmp2_;
	ValaReport* _tmp3_;
	ValaSourceReference* _tmp4_;
	const gchar* _tmp5_;
	g_return_if_fail (message != NULL);
	_tmp0_ = vala_code_context_get ();
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_code_context_get_report (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = source;
	_tmp5_ = message;
	vala_report_note (_tmp3_, _tmp4_, _tmp5_);
	_vala_code_context_unref0 (_tmp1_);
}


void vala_report_deprecated (ValaSourceReference* source, const gchar* message) {
	ValaCodeContext* _tmp0_;
	ValaCodeContext* _tmp1_;
	ValaReport* _tmp2_;
	ValaReport* _tmp3_;
	ValaSourceReference* _tmp4_;
	const gchar* _tmp5_;
	g_return_if_fail (message != NULL);
	_tmp0_ = vala_code_context_get ();
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_code_context_get_report (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = source;
	_tmp5_ = message;
	vala_report_depr (_tmp3_, _tmp4_, _tmp5_);
	_vala_code_context_unref0 (_tmp1_);
}


void vala_report_experimental (ValaSourceReference* source, const gchar* message) {
	ValaCodeContext* _tmp0_;
	ValaCodeContext* _tmp1_;
	ValaReport* _tmp2_;
	ValaReport* _tmp3_;
	ValaSourceReference* _tmp4_;
	const gchar* _tmp5_;
	g_return_if_fail (message != NULL);
	_tmp0_ = vala_code_context_get ();
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_code_context_get_report (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = source;
	_tmp5_ = message;
	vala_report_depr (_tmp3_, _tmp4_, _tmp5_);
	_vala_code_context_unref0 (_tmp1_);
}


void vala_report_warning (ValaSourceReference* source, const gchar* message) {
	ValaCodeContext* _tmp0_;
	ValaCodeContext* _tmp1_;
	ValaReport* _tmp2_;
	ValaReport* _tmp3_;
	ValaSourceReference* _tmp4_;
	const gchar* _tmp5_;
	g_return_if_fail (message != NULL);
	_tmp0_ = vala_code_context_get ();
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_code_context_get_report (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = source;
	_tmp5_ = message;
	vala_report_warn (_tmp3_, _tmp4_, _tmp5_);
	_vala_code_context_unref0 (_tmp1_);
}


void vala_report_error (ValaSourceReference* source, const gchar* message) {
	ValaCodeContext* _tmp0_;
	ValaCodeContext* _tmp1_;
	ValaReport* _tmp2_;
	ValaReport* _tmp3_;
	ValaSourceReference* _tmp4_;
	const gchar* _tmp5_;
	g_return_if_fail (message != NULL);
	_tmp0_ = vala_code_context_get ();
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_code_context_get_report (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = source;
	_tmp5_ = message;
	vala_report_err (_tmp3_, _tmp4_, _tmp5_);
	_vala_code_context_unref0 (_tmp1_);
}


static gboolean vala_report_is_atty (ValaReport* self, gint fd) {
	gboolean result = FALSE;
	GModule* module = NULL;
	GModule* _tmp0_;
	GModule* _tmp1_;
	void* _func = NULL;
	GModule* _tmp2_;
	void* _tmp3_ = NULL;
	void* _tmp4_;
	ValaReportAttyFunc func = NULL;
	void* _tmp5_;
	ValaReportAttyFunc _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = g_module_open (NULL, G_MODULE_BIND_LAZY);
	module = _tmp0_;
	_tmp1_ = module;
	if (_tmp1_ == NULL) {
		result = FALSE;
		_g_module_close0 (module);
		return result;
	}
	_tmp2_ = module;
	g_module_symbol (_tmp2_, "isatty", &_tmp3_);
	_func = _tmp3_;
	_tmp4_ = _func;
	if (_tmp4_ == NULL) {
		result = FALSE;
		_g_module_close0 (module);
		return result;
	}
	_tmp5_ = _func;
	func = (ValaReportAttyFunc) _tmp5_;
	_tmp6_ = func;
	_tmp7_ = fd;
	_tmp8_ = _tmp6_ (_tmp7_);
	result = _tmp8_ == 1;
	_g_module_close0 (module);
	return result;
}


ValaReport* vala_report_construct (GType object_type) {
	ValaReport * self = NULL;
	self = (ValaReport*) g_object_new (object_type, NULL);
	return self;
}


ValaReport* vala_report_new (void) {
	return vala_report_construct (VALA_TYPE_REPORT);
}


gboolean vala_report_get_enable_warnings (ValaReport* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_enable_warnings;
	result = _tmp0_;
	return result;
}


void vala_report_set_enable_warnings (ValaReport* self, gboolean value) {
	g_return_if_fail (self != NULL);
	if (vala_report_get_enable_warnings (self) != value) {
		gboolean _tmp0_;
		_tmp0_ = value;
		self->priv->_enable_warnings = _tmp0_;
		g_object_notify ((GObject *) self, "enable-warnings");
	}
}


static void vala_report_class_init (ValaReportClass * klass) {
	vala_report_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaReportPrivate));
	((ValaReportClass *) klass)->note = (void (*) (ValaReport *, ValaSourceReference*, const gchar*)) vala_report_real_note;
	((ValaReportClass *) klass)->depr = (void (*) (ValaReport *, ValaSourceReference*, const gchar*)) vala_report_real_depr;
	((ValaReportClass *) klass)->warn = (void (*) (ValaReport *, ValaSourceReference*, const gchar*)) vala_report_real_warn;
	((ValaReportClass *) klass)->err = (void (*) (ValaReport *, ValaSourceReference*, const gchar*)) vala_report_real_err;
	G_OBJECT_CLASS (klass)->get_property = _vala_vala_report_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_vala_report_set_property;
	G_OBJECT_CLASS (klass)->finalize = vala_report_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_REPORT_ENABLE_WARNINGS_PROPERTY, g_param_spec_boolean ("enable-warnings", "enable-warnings", "enable-warnings", TRUE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_report_instance_init (ValaReport * self) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	self->priv = VALA_REPORT_GET_PRIVATE (self);
	_tmp0_ = g_strdup ("");
	self->priv->locus_color_start = _tmp0_;
	self->priv->locus_color_end = "";
	_tmp1_ = g_strdup ("");
	self->priv->warning_color_start = _tmp1_;
	self->priv->warning_color_end = "";
	_tmp2_ = g_strdup ("");
	self->priv->error_color_start = _tmp2_;
	self->priv->error_color_end = "";
	_tmp3_ = g_strdup ("");
	self->priv->note_color_start = _tmp3_;
	self->priv->note_color_end = "";
	_tmp4_ = g_strdup ("");
	self->priv->caret_color_start = _tmp4_;
	self->priv->caret_color_end = "";
	_tmp5_ = g_strdup ("");
	self->priv->quote_color_start = _tmp5_;
	self->priv->quote_color_end = "";
	self->priv->_enable_warnings = TRUE;
}


static void vala_report_finalize (GObject * obj) {
	ValaReport * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_REPORT, ValaReport);
	_g_free0 (self->priv->locus_color_start);
	_g_free0 (self->priv->warning_color_start);
	_g_free0 (self->priv->error_color_start);
	_g_free0 (self->priv->note_color_start);
	_g_free0 (self->priv->caret_color_start);
	_g_free0 (self->priv->quote_color_start);
	G_OBJECT_CLASS (vala_report_parent_class)->finalize (obj);
}


/**
 * Namespace to centralize reporting warnings and errors.
 */
GType vala_report_get_type (void) {
	static volatile gsize vala_report_type_id__volatile = 0;
	if (g_once_init_enter (&vala_report_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaReportClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_report_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaReport), 0, (GInstanceInitFunc) vala_report_instance_init, NULL };
		GType vala_report_type_id;
		vala_report_type_id = g_type_register_static (G_TYPE_OBJECT, "ValaReport", &g_define_type_info, 0);
		g_once_init_leave (&vala_report_type_id__volatile, vala_report_type_id);
	}
	return vala_report_type_id__volatile;
}


static void _vala_vala_report_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ValaReport * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, VALA_TYPE_REPORT, ValaReport);
	switch (property_id) {
		case VALA_REPORT_ENABLE_WARNINGS_PROPERTY:
		g_value_set_boolean (value, vala_report_get_enable_warnings (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_vala_report_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ValaReport * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, VALA_TYPE_REPORT, ValaReport);
	switch (property_id) {
		case VALA_REPORT_ENABLE_WARNINGS_PROPERTY:
		vala_report_set_enable_warnings (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



