/* valaccodetypesymbolbinding.vala
 *
 * Copyright (C) 2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <gobject/valaccodetypesymbolbinding.h>
#include <ccode/valaccodeexpression.h>
#include <ccode/valaccodeconstant.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valadatatype.h>
#include <vala/valaclass.h>
#include <vala/valainterface.h>
#include <ccode/valaccodeidentifier.h>
#include <vala/valaenum.h>
#include <vala/valacodenode.h>
#include <vala/valastruct.h>
#include <vala/valapropertyaccessor.h>
#include <vala/valasymbol.h>
#include <gee/list.h>
#include <gee/collection.h>
#include <vala/valapointertype.h>
#include <vala/valaerrortype.h>
#include <vala/valaformalparameter.h>
#include <gobject/valaccodegenerator.h>




enum  {
	VALA_CCODE_TYPE_SYMBOL_BINDING_DUMMY_PROPERTY
};
static gpointer vala_ccode_type_symbol_binding_parent_class = NULL;
static int _vala_strcmp0 (const char * str1, const char * str2);



ValaCCodeFunctionCall* vala_ccode_type_symbol_binding_get_param_spec (ValaCCodeTypeSymbolBinding* self, ValaProperty* prop) {
	ValaCCodeFunctionCall* cspec;
	ValaCCodeConstant* _tmp0;
	ValaCCodeConstant* _tmp2;
	char* _tmp1;
	ValaCCodeConstant* _tmp4;
	char* _tmp3;
	char* pflags;
	ValaCCodeConstant* _tmp81;
	ValaCCodeFunctionCall* _tmp82;
	g_return_val_if_fail (VALA_IS_CCODE_TYPE_SYMBOL_BINDING (self), NULL);
	g_return_val_if_fail (VALA_IS_PROPERTY (prop), NULL);
	cspec = vala_ccode_function_call_new (NULL);
	_tmp0 = NULL;
	vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp0 = vala_property_get_canonical_cconstant (prop))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
	_tmp2 = NULL;
	_tmp1 = NULL;
	vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp2 = vala_ccode_constant_new ((_tmp1 = g_strdup_printf ("\"%s\"", vala_property_get_nick (prop)))))));
	(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
	_tmp1 = (g_free (_tmp1), NULL);
	_tmp4 = NULL;
	_tmp3 = NULL;
	vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp4 = vala_ccode_constant_new ((_tmp3 = g_strdup_printf ("\"%s\"", vala_property_get_blurb (prop)))))));
	(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
	_tmp3 = (g_free (_tmp3), NULL);
	if ((VALA_IS_CLASS (vala_data_type_get_data_type (vala_property_get_property_type (prop))) && vala_typesymbol_is_subtype_of (VALA_TYPESYMBOL ((VALA_CLASS (vala_data_type_get_data_type (vala_property_get_property_type (prop))))), vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->gobject_type)) || VALA_IS_INTERFACE (vala_data_type_get_data_type (vala_property_get_property_type (prop)))) {
		ValaCCodeIdentifier* _tmp5;
		ValaCCodeIdentifier* _tmp7;
		char* _tmp6;
		_tmp5 = NULL;
		vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((_tmp5 = vala_ccode_identifier_new ("g_param_spec_object"))));
		(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
		_tmp7 = NULL;
		_tmp6 = NULL;
		vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp7 = vala_ccode_identifier_new ((_tmp6 = vala_typesymbol_get_upper_case_cname (vala_data_type_get_data_type (vala_property_get_property_type (prop)), "TYPE_"))))));
		(_tmp7 == NULL ? NULL : (_tmp7 = (g_object_unref (_tmp7), NULL)));
		_tmp6 = (g_free (_tmp6), NULL);
	} else {
		if (vala_data_type_get_data_type (vala_property_get_property_type (prop)) == vala_data_type_get_data_type (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->string_type)) {
			ValaCCodeIdentifier* _tmp8;
			ValaCCodeConstant* _tmp9;
			_tmp8 = NULL;
			vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((_tmp8 = vala_ccode_identifier_new ("g_param_spec_string"))));
			(_tmp8 == NULL ? NULL : (_tmp8 = (g_object_unref (_tmp8), NULL)));
			_tmp9 = NULL;
			vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp9 = vala_ccode_constant_new ("NULL"))));
			(_tmp9 == NULL ? NULL : (_tmp9 = (g_object_unref (_tmp9), NULL)));
		} else {
			if (VALA_IS_ENUM (vala_data_type_get_data_type (vala_property_get_property_type (prop)))) {
				ValaEnum* _tmp11;
				ValaTypeSymbol* _tmp10;
				ValaEnum* e;
				_tmp11 = NULL;
				_tmp10 = NULL;
				e = (_tmp11 = (_tmp10 = vala_data_type_get_data_type (vala_property_get_property_type (prop)), (VALA_IS_ENUM (_tmp10) ? ((ValaEnum*) (_tmp10)) : NULL)), (_tmp11 == NULL ? NULL : g_object_ref (_tmp11)));
				if (vala_enum_get_has_type_id (e)) {
					ValaCCodeIdentifier* _tmp15;
					char* _tmp14;
					if (vala_enum_get_is_flags (e)) {
						ValaCCodeIdentifier* _tmp12;
						_tmp12 = NULL;
						vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((_tmp12 = vala_ccode_identifier_new ("g_param_spec_flags"))));
						(_tmp12 == NULL ? NULL : (_tmp12 = (g_object_unref (_tmp12), NULL)));
					} else {
						ValaCCodeIdentifier* _tmp13;
						_tmp13 = NULL;
						vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((_tmp13 = vala_ccode_identifier_new ("g_param_spec_enum"))));
						(_tmp13 == NULL ? NULL : (_tmp13 = (g_object_unref (_tmp13), NULL)));
					}
					_tmp15 = NULL;
					_tmp14 = NULL;
					vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp15 = vala_ccode_identifier_new ((_tmp14 = vala_typesymbol_get_type_id (VALA_TYPESYMBOL (e)))))));
					(_tmp15 == NULL ? NULL : (_tmp15 = (g_object_unref (_tmp15), NULL)));
					_tmp14 = (g_free (_tmp14), NULL);
				} else {
					if (vala_enum_get_is_flags (e)) {
						ValaCCodeIdentifier* _tmp16;
						ValaCCodeConstant* _tmp17;
						ValaCCodeConstant* _tmp18;
						_tmp16 = NULL;
						vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((_tmp16 = vala_ccode_identifier_new ("g_param_spec_uint"))));
						(_tmp16 == NULL ? NULL : (_tmp16 = (g_object_unref (_tmp16), NULL)));
						_tmp17 = NULL;
						vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp17 = vala_ccode_constant_new ("0"))));
						(_tmp17 == NULL ? NULL : (_tmp17 = (g_object_unref (_tmp17), NULL)));
						_tmp18 = NULL;
						vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp18 = vala_ccode_constant_new ("G_MAXUINT"))));
						(_tmp18 == NULL ? NULL : (_tmp18 = (g_object_unref (_tmp18), NULL)));
					} else {
						ValaCCodeIdentifier* _tmp19;
						ValaCCodeConstant* _tmp20;
						ValaCCodeConstant* _tmp21;
						_tmp19 = NULL;
						vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((_tmp19 = vala_ccode_identifier_new ("g_param_spec_int"))));
						(_tmp19 == NULL ? NULL : (_tmp19 = (g_object_unref (_tmp19), NULL)));
						_tmp20 = NULL;
						vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp20 = vala_ccode_constant_new ("G_MININT"))));
						(_tmp20 == NULL ? NULL : (_tmp20 = (g_object_unref (_tmp20), NULL)));
						_tmp21 = NULL;
						vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp21 = vala_ccode_constant_new ("G_MAXINT"))));
						(_tmp21 == NULL ? NULL : (_tmp21 = (g_object_unref (_tmp21), NULL)));
					}
				}
				if (vala_property_get_default_expression (prop) != NULL) {
					vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_property_get_default_expression (prop)))));
				} else {
					ValaCCodeConstant* _tmp23;
					char* _tmp22;
					_tmp23 = NULL;
					_tmp22 = NULL;
					vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp23 = vala_ccode_constant_new ((_tmp22 = vala_typesymbol_get_default_value (vala_data_type_get_data_type (vala_property_get_property_type (prop))))))));
					(_tmp23 == NULL ? NULL : (_tmp23 = (g_object_unref (_tmp23), NULL)));
					_tmp22 = (g_free (_tmp22), NULL);
				}
				(e == NULL ? NULL : (e = (g_object_unref (e), NULL)));
			} else {
				if (VALA_IS_STRUCT (vala_data_type_get_data_type (vala_property_get_property_type (prop)))) {
					ValaStruct* _tmp24;
					ValaStruct* st;
					char* _tmp25;
					gboolean _tmp26;
					_tmp24 = NULL;
					st = (_tmp24 = VALA_STRUCT (vala_data_type_get_data_type (vala_property_get_property_type (prop))), (_tmp24 == NULL ? NULL : g_object_ref (_tmp24)));
					_tmp25 = NULL;
					if ((_tmp26 = _vala_strcmp0 ((_tmp25 = vala_typesymbol_get_type_id (VALA_TYPESYMBOL (st))), "G_TYPE_INT") == 0, (_tmp25 = (g_free (_tmp25), NULL)), _tmp26)) {
						ValaCCodeIdentifier* _tmp27;
						ValaCCodeConstant* _tmp28;
						ValaCCodeConstant* _tmp29;
						_tmp27 = NULL;
						vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((_tmp27 = vala_ccode_identifier_new ("g_param_spec_int"))));
						(_tmp27 == NULL ? NULL : (_tmp27 = (g_object_unref (_tmp27), NULL)));
						_tmp28 = NULL;
						vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp28 = vala_ccode_constant_new ("G_MININT"))));
						(_tmp28 == NULL ? NULL : (_tmp28 = (g_object_unref (_tmp28), NULL)));
						_tmp29 = NULL;
						vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp29 = vala_ccode_constant_new ("G_MAXINT"))));
						(_tmp29 == NULL ? NULL : (_tmp29 = (g_object_unref (_tmp29), NULL)));
						if (vala_property_get_default_expression (prop) != NULL) {
							vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_property_get_default_expression (prop)))));
						} else {
							ValaCCodeConstant* _tmp30;
							_tmp30 = NULL;
							vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp30 = vala_ccode_constant_new ("0"))));
							(_tmp30 == NULL ? NULL : (_tmp30 = (g_object_unref (_tmp30), NULL)));
						}
					} else {
						char* _tmp31;
						gboolean _tmp32;
						_tmp31 = NULL;
						if ((_tmp32 = _vala_strcmp0 ((_tmp31 = vala_typesymbol_get_type_id (VALA_TYPESYMBOL (st))), "G_TYPE_UINT") == 0, (_tmp31 = (g_free (_tmp31), NULL)), _tmp32)) {
							ValaCCodeIdentifier* _tmp33;
							ValaCCodeConstant* _tmp34;
							ValaCCodeConstant* _tmp35;
							_tmp33 = NULL;
							vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((_tmp33 = vala_ccode_identifier_new ("g_param_spec_uint"))));
							(_tmp33 == NULL ? NULL : (_tmp33 = (g_object_unref (_tmp33), NULL)));
							_tmp34 = NULL;
							vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp34 = vala_ccode_constant_new ("0"))));
							(_tmp34 == NULL ? NULL : (_tmp34 = (g_object_unref (_tmp34), NULL)));
							_tmp35 = NULL;
							vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp35 = vala_ccode_constant_new ("G_MAXUINT"))));
							(_tmp35 == NULL ? NULL : (_tmp35 = (g_object_unref (_tmp35), NULL)));
							if (vala_property_get_default_expression (prop) != NULL) {
								vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_property_get_default_expression (prop)))));
							} else {
								ValaCCodeConstant* _tmp36;
								_tmp36 = NULL;
								vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp36 = vala_ccode_constant_new ("0U"))));
								(_tmp36 == NULL ? NULL : (_tmp36 = (g_object_unref (_tmp36), NULL)));
							}
						} else {
							char* _tmp37;
							gboolean _tmp38;
							_tmp37 = NULL;
							if ((_tmp38 = _vala_strcmp0 ((_tmp37 = vala_typesymbol_get_type_id (VALA_TYPESYMBOL (st))), "G_TYPE_LONG") == 0, (_tmp37 = (g_free (_tmp37), NULL)), _tmp38)) {
								ValaCCodeIdentifier* _tmp39;
								ValaCCodeConstant* _tmp40;
								ValaCCodeConstant* _tmp41;
								_tmp39 = NULL;
								vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((_tmp39 = vala_ccode_identifier_new ("g_param_spec_long"))));
								(_tmp39 == NULL ? NULL : (_tmp39 = (g_object_unref (_tmp39), NULL)));
								_tmp40 = NULL;
								vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp40 = vala_ccode_constant_new ("G_MINLONG"))));
								(_tmp40 == NULL ? NULL : (_tmp40 = (g_object_unref (_tmp40), NULL)));
								_tmp41 = NULL;
								vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp41 = vala_ccode_constant_new ("G_MAXLONG"))));
								(_tmp41 == NULL ? NULL : (_tmp41 = (g_object_unref (_tmp41), NULL)));
								if (vala_property_get_default_expression (prop) != NULL) {
									vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_property_get_default_expression (prop)))));
								} else {
									ValaCCodeConstant* _tmp42;
									_tmp42 = NULL;
									vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp42 = vala_ccode_constant_new ("0L"))));
									(_tmp42 == NULL ? NULL : (_tmp42 = (g_object_unref (_tmp42), NULL)));
								}
							} else {
								char* _tmp43;
								gboolean _tmp44;
								_tmp43 = NULL;
								if ((_tmp44 = _vala_strcmp0 ((_tmp43 = vala_typesymbol_get_type_id (VALA_TYPESYMBOL (st))), "G_TYPE_ULONG") == 0, (_tmp43 = (g_free (_tmp43), NULL)), _tmp44)) {
									ValaCCodeIdentifier* _tmp45;
									ValaCCodeConstant* _tmp46;
									ValaCCodeConstant* _tmp47;
									_tmp45 = NULL;
									vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((_tmp45 = vala_ccode_identifier_new ("g_param_spec_ulong"))));
									(_tmp45 == NULL ? NULL : (_tmp45 = (g_object_unref (_tmp45), NULL)));
									_tmp46 = NULL;
									vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp46 = vala_ccode_constant_new ("0"))));
									(_tmp46 == NULL ? NULL : (_tmp46 = (g_object_unref (_tmp46), NULL)));
									_tmp47 = NULL;
									vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp47 = vala_ccode_constant_new ("G_MAXULONG"))));
									(_tmp47 == NULL ? NULL : (_tmp47 = (g_object_unref (_tmp47), NULL)));
									if (vala_property_get_default_expression (prop) != NULL) {
										vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_property_get_default_expression (prop)))));
									} else {
										ValaCCodeConstant* _tmp48;
										_tmp48 = NULL;
										vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp48 = vala_ccode_constant_new ("0UL"))));
										(_tmp48 == NULL ? NULL : (_tmp48 = (g_object_unref (_tmp48), NULL)));
									}
								} else {
									char* _tmp49;
									gboolean _tmp50;
									_tmp49 = NULL;
									if ((_tmp50 = _vala_strcmp0 ((_tmp49 = vala_typesymbol_get_type_id (VALA_TYPESYMBOL (st))), "G_TYPE_BOOLEAN") == 0, (_tmp49 = (g_free (_tmp49), NULL)), _tmp50)) {
										ValaCCodeIdentifier* _tmp51;
										_tmp51 = NULL;
										vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((_tmp51 = vala_ccode_identifier_new ("g_param_spec_boolean"))));
										(_tmp51 == NULL ? NULL : (_tmp51 = (g_object_unref (_tmp51), NULL)));
										if (vala_property_get_default_expression (prop) != NULL) {
											vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_property_get_default_expression (prop)))));
										} else {
											ValaCCodeConstant* _tmp52;
											_tmp52 = NULL;
											vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp52 = vala_ccode_constant_new ("FALSE"))));
											(_tmp52 == NULL ? NULL : (_tmp52 = (g_object_unref (_tmp52), NULL)));
										}
									} else {
										char* _tmp53;
										gboolean _tmp54;
										_tmp53 = NULL;
										if ((_tmp54 = _vala_strcmp0 ((_tmp53 = vala_typesymbol_get_type_id (VALA_TYPESYMBOL (st))), "G_TYPE_CHAR") == 0, (_tmp53 = (g_free (_tmp53), NULL)), _tmp54)) {
											ValaCCodeIdentifier* _tmp55;
											ValaCCodeConstant* _tmp56;
											ValaCCodeConstant* _tmp57;
											_tmp55 = NULL;
											vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((_tmp55 = vala_ccode_identifier_new ("g_param_spec_char"))));
											(_tmp55 == NULL ? NULL : (_tmp55 = (g_object_unref (_tmp55), NULL)));
											_tmp56 = NULL;
											vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp56 = vala_ccode_constant_new ("G_MININT8"))));
											(_tmp56 == NULL ? NULL : (_tmp56 = (g_object_unref (_tmp56), NULL)));
											_tmp57 = NULL;
											vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp57 = vala_ccode_constant_new ("G_MAXINT8"))));
											(_tmp57 == NULL ? NULL : (_tmp57 = (g_object_unref (_tmp57), NULL)));
											if (vala_property_get_default_expression (prop) != NULL) {
												vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_property_get_default_expression (prop)))));
											} else {
												ValaCCodeConstant* _tmp58;
												_tmp58 = NULL;
												vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp58 = vala_ccode_constant_new ("0"))));
												(_tmp58 == NULL ? NULL : (_tmp58 = (g_object_unref (_tmp58), NULL)));
											}
										} else {
											char* _tmp59;
											gboolean _tmp60;
											_tmp59 = NULL;
											if ((_tmp60 = _vala_strcmp0 ((_tmp59 = vala_typesymbol_get_type_id (VALA_TYPESYMBOL (st))), "G_TYPE_FLOAT") == 0, (_tmp59 = (g_free (_tmp59), NULL)), _tmp60)) {
												ValaCCodeIdentifier* _tmp61;
												ValaCCodeConstant* _tmp62;
												ValaCCodeConstant* _tmp63;
												_tmp61 = NULL;
												vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((_tmp61 = vala_ccode_identifier_new ("g_param_spec_float"))));
												(_tmp61 == NULL ? NULL : (_tmp61 = (g_object_unref (_tmp61), NULL)));
												_tmp62 = NULL;
												vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp62 = vala_ccode_constant_new ("-G_MAXFLOAT"))));
												(_tmp62 == NULL ? NULL : (_tmp62 = (g_object_unref (_tmp62), NULL)));
												_tmp63 = NULL;
												vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp63 = vala_ccode_constant_new ("G_MAXFLOAT"))));
												(_tmp63 == NULL ? NULL : (_tmp63 = (g_object_unref (_tmp63), NULL)));
												if (vala_property_get_default_expression (prop) != NULL) {
													vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_property_get_default_expression (prop)))));
												} else {
													ValaCCodeConstant* _tmp64;
													_tmp64 = NULL;
													vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp64 = vala_ccode_constant_new ("0.0F"))));
													(_tmp64 == NULL ? NULL : (_tmp64 = (g_object_unref (_tmp64), NULL)));
												}
											} else {
												char* _tmp65;
												gboolean _tmp66;
												_tmp65 = NULL;
												if ((_tmp66 = _vala_strcmp0 ((_tmp65 = vala_typesymbol_get_type_id (VALA_TYPESYMBOL (st))), "G_TYPE_DOUBLE") == 0, (_tmp65 = (g_free (_tmp65), NULL)), _tmp66)) {
													ValaCCodeIdentifier* _tmp67;
													ValaCCodeConstant* _tmp68;
													ValaCCodeConstant* _tmp69;
													_tmp67 = NULL;
													vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((_tmp67 = vala_ccode_identifier_new ("g_param_spec_double"))));
													(_tmp67 == NULL ? NULL : (_tmp67 = (g_object_unref (_tmp67), NULL)));
													_tmp68 = NULL;
													vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp68 = vala_ccode_constant_new ("-G_MAXDOUBLE"))));
													(_tmp68 == NULL ? NULL : (_tmp68 = (g_object_unref (_tmp68), NULL)));
													_tmp69 = NULL;
													vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp69 = vala_ccode_constant_new ("G_MAXDOUBLE"))));
													(_tmp69 == NULL ? NULL : (_tmp69 = (g_object_unref (_tmp69), NULL)));
													if (vala_property_get_default_expression (prop) != NULL) {
														vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_property_get_default_expression (prop)))));
													} else {
														ValaCCodeConstant* _tmp70;
														_tmp70 = NULL;
														vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp70 = vala_ccode_constant_new ("0.0"))));
														(_tmp70 == NULL ? NULL : (_tmp70 = (g_object_unref (_tmp70), NULL)));
													}
												} else {
													char* _tmp71;
													gboolean _tmp72;
													_tmp71 = NULL;
													if ((_tmp72 = _vala_strcmp0 ((_tmp71 = vala_typesymbol_get_type_id (VALA_TYPESYMBOL (st))), "G_TYPE_GTYPE") == 0, (_tmp71 = (g_free (_tmp71), NULL)), _tmp72)) {
														ValaCCodeIdentifier* _tmp73;
														_tmp73 = NULL;
														vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((_tmp73 = vala_ccode_identifier_new ("g_param_spec_gtype"))));
														(_tmp73 == NULL ? NULL : (_tmp73 = (g_object_unref (_tmp73), NULL)));
														if (vala_property_get_default_expression (prop) != NULL) {
															vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_property_get_default_expression (prop)))));
														} else {
															ValaCCodeConstant* _tmp74;
															_tmp74 = NULL;
															vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp74 = vala_ccode_constant_new ("G_TYPE_NONE"))));
															(_tmp74 == NULL ? NULL : (_tmp74 = (g_object_unref (_tmp74), NULL)));
														}
													} else {
														ValaCCodeIdentifier* _tmp75;
														_tmp75 = NULL;
														vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((_tmp75 = vala_ccode_identifier_new ("g_param_spec_pointer"))));
														(_tmp75 == NULL ? NULL : (_tmp75 = (g_object_unref (_tmp75), NULL)));
													}
												}
											}
										}
									}
								}
							}
						}
					}
					(st == NULL ? NULL : (st = (g_object_unref (st), NULL)));
				} else {
					ValaCCodeIdentifier* _tmp76;
					_tmp76 = NULL;
					vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((_tmp76 = vala_ccode_identifier_new ("g_param_spec_pointer"))));
					(_tmp76 == NULL ? NULL : (_tmp76 = (g_object_unref (_tmp76), NULL)));
				}
			}
		}
	}
	pflags = g_strdup ("G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB");
	if (vala_property_get_get_accessor (prop) != NULL) {
		char* _tmp77;
		_tmp77 = NULL;
		pflags = (_tmp77 = g_strdup_printf ("%s%s", pflags, " | G_PARAM_READABLE"), (pflags = (g_free (pflags), NULL)), _tmp77);
	}
	if (vala_property_get_set_accessor (prop) != NULL) {
		char* _tmp78;
		_tmp78 = NULL;
		pflags = (_tmp78 = g_strdup_printf ("%s%s", pflags, " | G_PARAM_WRITABLE"), (pflags = (g_free (pflags), NULL)), _tmp78);
		if (vala_property_accessor_get_construction (vala_property_get_set_accessor (prop))) {
			if (vala_property_accessor_get_writable (vala_property_get_set_accessor (prop))) {
				char* _tmp79;
				_tmp79 = NULL;
				pflags = (_tmp79 = g_strdup_printf ("%s%s", pflags, " | G_PARAM_CONSTRUCT"), (pflags = (g_free (pflags), NULL)), _tmp79);
			} else {
				char* _tmp80;
				_tmp80 = NULL;
				pflags = (_tmp80 = g_strdup_printf ("%s%s", pflags, " | G_PARAM_CONSTRUCT_ONLY"), (pflags = (g_free (pflags), NULL)), _tmp80);
			}
		}
	}
	_tmp81 = NULL;
	vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp81 = vala_ccode_constant_new (pflags))));
	(_tmp81 == NULL ? NULL : (_tmp81 = (g_object_unref (_tmp81), NULL)));
	_tmp82 = NULL;
	return (_tmp82 = cspec, (pflags = (g_free (pflags), NULL)), _tmp82);
}


ValaCCodeFunctionCall* vala_ccode_type_symbol_binding_get_signal_creation (ValaCCodeTypeSymbolBinding* self, ValaSignal* sig, ValaTypeSymbol* type) {
	ValaCCodeIdentifier* _tmp0;
	ValaCCodeFunctionCall* _tmp1;
	ValaCCodeFunctionCall* csignew;
	ValaCCodeConstant* _tmp3;
	char* _tmp2;
	ValaCCodeIdentifier* _tmp5;
	char* _tmp4;
	ValaCCodeConstant* _tmp6;
	ValaCCodeConstant* _tmp7;
	ValaCCodeConstant* _tmp8;
	ValaCCodeConstant* _tmp9;
	GeeList* _tmp10;
	char* _tmp11;
	char* marshaller;
	ValaCCodeIdentifier* marshal_arg;
	GeeList* params;
	gint params_len;
	ValaCCodeConstant* _tmp18;
	char* _tmp17;
	ValaCCodeFunctionCall* _tmp23;
	g_return_val_if_fail (VALA_IS_CCODE_TYPE_SYMBOL_BINDING (self), NULL);
	g_return_val_if_fail (VALA_IS_SIGNAL (sig), NULL);
	g_return_val_if_fail (VALA_IS_TYPESYMBOL (type), NULL);
	_tmp0 = NULL;
	_tmp1 = NULL;
	csignew = (_tmp1 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp0 = vala_ccode_identifier_new ("g_signal_new")))), (_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL))), _tmp1);
	_tmp3 = NULL;
	_tmp2 = NULL;
	vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((_tmp3 = vala_ccode_constant_new ((_tmp2 = g_strdup_printf ("\"%s\"", vala_symbol_get_name (VALA_SYMBOL (sig))))))));
	(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
	_tmp2 = (g_free (_tmp2), NULL);
	_tmp5 = NULL;
	_tmp4 = NULL;
	vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((_tmp5 = vala_ccode_identifier_new ((_tmp4 = vala_typesymbol_get_upper_case_cname (type, "TYPE_"))))));
	(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
	_tmp4 = (g_free (_tmp4), NULL);
	_tmp6 = NULL;
	vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((_tmp6 = vala_ccode_constant_new ("G_SIGNAL_RUN_LAST"))));
	(_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL)));
	_tmp7 = NULL;
	vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((_tmp7 = vala_ccode_constant_new ("0"))));
	(_tmp7 == NULL ? NULL : (_tmp7 = (g_object_unref (_tmp7), NULL)));
	_tmp8 = NULL;
	vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((_tmp8 = vala_ccode_constant_new ("NULL"))));
	(_tmp8 == NULL ? NULL : (_tmp8 = (g_object_unref (_tmp8), NULL)));
	_tmp9 = NULL;
	vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((_tmp9 = vala_ccode_constant_new ("NULL"))));
	(_tmp9 == NULL ? NULL : (_tmp9 = (g_object_unref (_tmp9), NULL)));
	_tmp10 = NULL;
	_tmp11 = NULL;
	marshaller = (_tmp11 = vala_ccode_generator_get_marshaller_function (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), (_tmp10 = vala_signal_get_parameters (sig)), vala_signal_get_return_type (sig), NULL, FALSE), (_tmp10 == NULL ? NULL : (_tmp10 = (g_object_unref (_tmp10), NULL))), _tmp11);
	marshal_arg = vala_ccode_identifier_new (marshaller);
	vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION (marshal_arg));
	params = vala_signal_get_parameters (sig);
	params_len = gee_collection_get_size (GEE_COLLECTION (params));
	if (VALA_IS_POINTER_TYPE (vala_signal_get_return_type (sig)) || vala_data_type_get_type_parameter (vala_signal_get_return_type (sig)) != NULL) {
		ValaCCodeConstant* _tmp12;
		_tmp12 = NULL;
		vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((_tmp12 = vala_ccode_constant_new ("G_TYPE_POINTER"))));
		(_tmp12 == NULL ? NULL : (_tmp12 = (g_object_unref (_tmp12), NULL)));
	} else {
		if (VALA_IS_ERROR_TYPE (vala_signal_get_return_type (sig))) {
			ValaCCodeConstant* _tmp13;
			_tmp13 = NULL;
			vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((_tmp13 = vala_ccode_constant_new ("G_TYPE_POINTER"))));
			(_tmp13 == NULL ? NULL : (_tmp13 = (g_object_unref (_tmp13), NULL)));
		} else {
			if (vala_data_type_get_data_type (vala_signal_get_return_type (sig)) == NULL) {
				ValaCCodeConstant* _tmp14;
				_tmp14 = NULL;
				vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((_tmp14 = vala_ccode_constant_new ("G_TYPE_NONE"))));
				(_tmp14 == NULL ? NULL : (_tmp14 = (g_object_unref (_tmp14), NULL)));
			} else {
				ValaCCodeConstant* _tmp16;
				char* _tmp15;
				_tmp16 = NULL;
				_tmp15 = NULL;
				vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((_tmp16 = vala_ccode_constant_new ((_tmp15 = vala_typesymbol_get_type_id (vala_data_type_get_data_type (vala_signal_get_return_type (sig))))))));
				(_tmp16 == NULL ? NULL : (_tmp16 = (g_object_unref (_tmp16), NULL)));
				_tmp15 = (g_free (_tmp15), NULL);
			}
		}
	}
	_tmp18 = NULL;
	_tmp17 = NULL;
	vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((_tmp18 = vala_ccode_constant_new ((_tmp17 = g_strdup_printf ("%d", params_len))))));
	(_tmp18 == NULL ? NULL : (_tmp18 = (g_object_unref (_tmp18), NULL)));
	_tmp17 = (g_free (_tmp17), NULL);
	{
		GeeList* param_collection;
		int param_it;
		param_collection = params;
		for (param_it = 0; param_it < gee_collection_get_size (GEE_COLLECTION (param_collection)); param_it = param_it + 1) {
			ValaFormalParameter* param;
			param = ((ValaFormalParameter*) (gee_list_get (GEE_LIST (param_collection), param_it)));
			{
				if (VALA_IS_POINTER_TYPE (vala_formal_parameter_get_parameter_type (param)) || vala_data_type_get_type_parameter (vala_formal_parameter_get_parameter_type (param)) != NULL || vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_IN) {
					ValaCCodeConstant* _tmp19;
					_tmp19 = NULL;
					vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((_tmp19 = vala_ccode_constant_new ("G_TYPE_POINTER"))));
					(_tmp19 == NULL ? NULL : (_tmp19 = (g_object_unref (_tmp19), NULL)));
				} else {
					if (VALA_IS_ERROR_TYPE (vala_formal_parameter_get_parameter_type (param))) {
						ValaCCodeConstant* _tmp20;
						_tmp20 = NULL;
						vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((_tmp20 = vala_ccode_constant_new ("G_TYPE_POINTER"))));
						(_tmp20 == NULL ? NULL : (_tmp20 = (g_object_unref (_tmp20), NULL)));
					} else {
						ValaCCodeConstant* _tmp22;
						char* _tmp21;
						_tmp22 = NULL;
						_tmp21 = NULL;
						vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((_tmp22 = vala_ccode_constant_new ((_tmp21 = vala_typesymbol_get_type_id (vala_data_type_get_data_type (vala_formal_parameter_get_parameter_type (param))))))));
						(_tmp22 == NULL ? NULL : (_tmp22 = (g_object_unref (_tmp22), NULL)));
						_tmp21 = (g_free (_tmp21), NULL);
					}
				}
				(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
			}
		}
	}
	vala_ccode_identifier_set_name (marshal_arg, marshaller);
	_tmp23 = NULL;
	return (_tmp23 = csignew, (marshaller = (g_free (marshaller), NULL)), (marshal_arg == NULL ? NULL : (marshal_arg = (g_object_unref (marshal_arg), NULL))), (params == NULL ? NULL : (params = (g_object_unref (params), NULL))), _tmp23);
}


static void vala_ccode_type_symbol_binding_class_init (ValaCCodeTypeSymbolBindingClass * klass) {
	vala_ccode_type_symbol_binding_parent_class = g_type_class_peek_parent (klass);
}


static void vala_ccode_type_symbol_binding_instance_init (ValaCCodeTypeSymbolBinding * self) {
}


GType vala_ccode_type_symbol_binding_get_type (void) {
	static GType vala_ccode_type_symbol_binding_type_id = 0;
	if (G_UNLIKELY (vala_ccode_type_symbol_binding_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeTypeSymbolBindingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_type_symbol_binding_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeTypeSymbolBinding), 0, (GInstanceInitFunc) vala_ccode_type_symbol_binding_instance_init };
		vala_ccode_type_symbol_binding_type_id = g_type_register_static (VALA_TYPE_CCODE_BINDING, "ValaCCodeTypeSymbolBinding", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	}
	return vala_ccode_type_symbol_binding_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return (str1 != str2);
	}
	return strcmp (str1, str2);
}




