/* valaccodeobjecttypesymbolbinding.vala
 *
 * Copyright (C) 2008  Philip Van Hoof
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Philip Van Hoof <pvanhoof@gnome.org>
 */

#include <gobject/valaccodeobjecttypesymbolbinding.h>
#include <vala/valacodenode.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valaattribute.h>
#include <vala/valamethod.h>
#include <vala/valacreationmethod.h>
#include <vala/valamember.h>
#include <vala/valasymbol.h>
#include <gee/arraylist.h>
#include <vala/valaformalparameter.h>
#include <gee/collection.h>
#include <vala/valavoidtype.h>
#include <vala/valapointertype.h>
#include <vala/valadatatype.h>
#include <vala/valasourcereference.h>
#include <gee/list.h>
#include <vala/valareport.h>
#include <vala/valasignal.h>
#include <vala/valaproperty.h>
#include <ccode/valaccodedeclaration.h>
#include <ccode/valaccodemodifiers.h>
#include <ccode/valaccodevariabledeclarator.h>
#include <ccode/valaccodeconstant.h>
#include <ccode/valaccodeexpression.h>
#include <ccode/valaccodedeclarator.h>
#include <ccode/valaccodenode.h>
#include <ccode/valaccodefunctioncall.h>
#include <ccode/valaccodeidentifier.h>
#include <vala/valatypesymbol.h>
#include <ccode/valaccodeunaryexpression.h>
#include <ccode/valaccodeexpressionstatement.h>
#include <ccode/valaccodefunction.h>
#include <ccode/valaccodeformalparameter.h>
#include <ccode/valaccodeblock.h>
#include <vala/valastruct.h>
#include <vala/valafield.h>
#include <ccode/valaccodeelementaccess.h>
#include <ccode/valaccodememberaccess.h>
#include <ccode/valaccodeassignment.h>
#include <ccode/valaccodeinitializerlist.h>
#include <ccode/valaccodebinaryexpression.h>
#include <ccode/valaccodereturnstatement.h>
#include <gobject/valaccodebinding.h>
#include <gobject/valaccodegenerator.h>




enum  {
	VALA_CCODE_OBJECT_TYPE_SYMBOL_BINDING_DUMMY_PROPERTY
};
static gboolean vala_ccode_object_type_symbol_binding_is_dbus_visible (ValaCCodeObjectTypeSymbolBinding* self, ValaCodeNode* node);
static char* vala_ccode_object_type_symbol_binding_generate_dbus_wrapper (ValaCCodeObjectTypeSymbolBinding* self, ValaMethod* m, ValaObjectTypeSymbol* bindable);
static gpointer vala_ccode_object_type_symbol_binding_parent_class = NULL;



static gboolean vala_ccode_object_type_symbol_binding_is_dbus_visible (ValaCCodeObjectTypeSymbolBinding* self, ValaCodeNode* node) {
	ValaAttribute* dbus_attribute;
	gboolean _tmp1;
	g_return_val_if_fail (VALA_IS_CCODE_OBJECT_TYPE_SYMBOL_BINDING (self), FALSE);
	g_return_val_if_fail (VALA_IS_CODE_NODE (node), FALSE);
	dbus_attribute = vala_code_node_get_attribute (node, "DBus");
	if (dbus_attribute != NULL && vala_attribute_has_argument (dbus_attribute, "visible") && !vala_attribute_get_bool (dbus_attribute, "visible")) {
		gboolean _tmp0;
		return (_tmp0 = FALSE, (dbus_attribute == NULL ? NULL : (dbus_attribute = (g_object_unref (dbus_attribute), NULL))), _tmp0);
	}
	return (_tmp1 = TRUE, (dbus_attribute == NULL ? NULL : (dbus_attribute = (g_object_unref (dbus_attribute), NULL))), _tmp1);
}


ValaCCodeFragment* vala_ccode_object_type_symbol_binding_register_dbus_info (ValaCCodeObjectTypeSymbolBinding* self, ValaObjectTypeSymbol* bindable) {
	ValaCCodeFragment* fragment;
	ValaAttribute* dbus;
	char* dbus_iface_name;
	GString* dbus_methods;
	GString* blob;
	gint method_count;
	glong blob_len;
	GString* dbus_signals;
	GString* dbus_props;
	ValaCCodeDeclaration* dbus_methods_decl;
	ValaCCodeVariableDeclarator* _tmp14;
	ValaCCodeConstant* _tmp13;
	char* _tmp12;
	char* _tmp11;
	ValaCCodeDeclaration* dbus_object_info;
	ValaCCodeVariableDeclarator* _tmp20;
	ValaCCodeConstant* _tmp19;
	char* _tmp18;
	char* _tmp17;
	char* _tmp16;
	char* _tmp15;
	ValaCCodeIdentifier* _tmp21;
	ValaCCodeFunctionCall* _tmp22;
	ValaCCodeFunctionCall* install_call;
	ValaCCodeIdentifier* _tmp24;
	char* _tmp23;
	ValaCCodeUnaryExpression* _tmp28;
	ValaCCodeIdentifier* _tmp27;
	char* _tmp26;
	char* _tmp25;
	ValaCCodeExpressionStatement* _tmp29;
	ValaCCodeFragment* _tmp30;
	g_return_val_if_fail (VALA_IS_CCODE_OBJECT_TYPE_SYMBOL_BINDING (self), NULL);
	g_return_val_if_fail (VALA_IS_OBJECT_TYPE_SYMBOL (bindable), NULL);
	fragment = vala_ccode_fragment_new ();
	dbus = vala_code_node_get_attribute (VALA_CODE_NODE (bindable), "DBus");
	if (dbus == NULL) {
		ValaCCodeFragment* _tmp0;
		_tmp0 = NULL;
		return (_tmp0 = fragment, (dbus == NULL ? NULL : (dbus = (g_object_unref (dbus), NULL))), _tmp0);
	}
	dbus_iface_name = vala_attribute_get_string (dbus, "name");
	if (dbus_iface_name == NULL) {
		ValaCCodeFragment* _tmp1;
		_tmp1 = NULL;
		return (_tmp1 = fragment, (dbus == NULL ? NULL : (dbus = (g_object_unref (dbus), NULL))), (dbus_iface_name = (g_free (dbus_iface_name), NULL)), _tmp1);
	}
	vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->dbus_glib_h_needed = TRUE;
	dbus_methods = g_string_new ("");
	g_string_append (dbus_methods, "{\n");
	blob = g_string_new ("");
	g_string_append_c (blob, '"');
	method_count = 0;
	blob_len = ((glong) (0));
	{
		GeeList* m_collection;
		int m_it;
		m_collection = vala_object_type_symbol_get_methods (bindable);
		for (m_it = 0; m_it < gee_collection_get_size (GEE_COLLECTION (m_collection)); m_it = m_it + 1) {
			ValaMethod* m;
			m = ((ValaMethod*) (gee_list_get (GEE_LIST (m_collection), m_it)));
			{
				GeeArrayList* parameters;
				ValaFormalParameter* _tmp5;
				char* _tmp6;
				char* _tmp7;
				char* _tmp8;
				glong start;
				if (VALA_IS_CREATION_METHOD (m) || vala_method_get_binding (m) != MEMBER_BINDING_INSTANCE || vala_method_get_overrides (m) || vala_symbol_get_access (VALA_SYMBOL (m)) != VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
					(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
					continue;
				}
				if (!vala_ccode_object_type_symbol_binding_is_dbus_visible (self, VALA_CODE_NODE (m))) {
					(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
					continue;
				}
				parameters = gee_array_list_new (VALA_TYPE_FORMAL_PARAMETER, ((GBoxedCopyFunc) (g_object_ref)), g_object_unref, g_direct_equal);
				{
					GeeList* param_collection;
					int param_it;
					param_collection = vala_method_get_parameters (m);
					for (param_it = 0; param_it < gee_collection_get_size (GEE_COLLECTION (param_collection)); param_it = param_it + 1) {
						ValaFormalParameter* param;
						param = ((ValaFormalParameter*) (gee_list_get (GEE_LIST (param_collection), param_it)));
						{
							gee_collection_add (GEE_COLLECTION (parameters), param);
							(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
						}
					}
					(param_collection == NULL ? NULL : (param_collection = (g_object_unref (param_collection), NULL)));
				}
				if (!(VALA_IS_VOID_TYPE (vala_method_get_return_type (m)))) {
					ValaFormalParameter* _tmp4;
					ValaPointerType* _tmp3;
					ValaVoidType* _tmp2;
					_tmp4 = NULL;
					_tmp3 = NULL;
					_tmp2 = NULL;
					gee_collection_add (GEE_COLLECTION (parameters), (_tmp4 = vala_formal_parameter_new ("result", VALA_DATA_TYPE ((_tmp3 = vala_pointer_type_new (VALA_DATA_TYPE ((_tmp2 = vala_void_type_new ())), NULL))), NULL)));
					(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
					(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
					(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
				}
				_tmp5 = NULL;
				gee_collection_add (GEE_COLLECTION (parameters), (_tmp5 = vala_formal_parameter_new ("error", VALA_DATA_TYPE (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->gerror_type), NULL)));
				(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
				g_string_append (dbus_methods, "{ (GCallback) ");
				_tmp6 = NULL;
				g_string_append (dbus_methods, (_tmp6 = vala_ccode_object_type_symbol_binding_generate_dbus_wrapper (self, m, bindable)));
				_tmp6 = (g_free (_tmp6), NULL);
				g_string_append (dbus_methods, ", ");
				_tmp7 = NULL;
				g_string_append (dbus_methods, (_tmp7 = vala_ccode_generator_get_marshaller_function (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), GEE_LIST (parameters), vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->bool_type, NULL, TRUE)));
				_tmp7 = (g_free (_tmp7), NULL);
				g_string_append (dbus_methods, ", ");
				_tmp8 = NULL;
				g_string_append (dbus_methods, (_tmp8 = g_strdup_printf ("%li", blob_len)));
				_tmp8 = (g_free (_tmp8), NULL);
				g_string_append (dbus_methods, " },\n");
				vala_ccode_generator_generate_marshaller (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), GEE_LIST (parameters), vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->bool_type, TRUE);
				start = blob->len;
				g_string_append (blob, dbus_iface_name);
				g_string_append (blob, "\\0");
				start++;
				g_string_append (blob, vala_symbol_get_name (VALA_SYMBOL (m)));
				g_string_append (blob, "\\0");
				start++;
				/* synchronous*/
				g_string_append (blob, "S\\0");
				start++;
				{
					GeeList* param_collection;
					int param_it;
					param_collection = vala_method_get_parameters (m);
					for (param_it = 0; param_it < gee_collection_get_size (GEE_COLLECTION (param_collection)); param_it = param_it + 1) {
						ValaFormalParameter* param;
						param = ((ValaFormalParameter*) (gee_list_get (GEE_LIST (param_collection), param_it)));
						{
							char* _tmp9;
							g_string_append (blob, vala_symbol_get_name (VALA_SYMBOL (param)));
							g_string_append (blob, "\\0");
							start++;
							if (vala_formal_parameter_get_direction (param) == VALA_PARAMETER_DIRECTION_IN) {
								g_string_append (blob, "I\\0");
								start++;
							} else {
								if (vala_formal_parameter_get_direction (param) == VALA_PARAMETER_DIRECTION_OUT) {
									g_string_append (blob, "O\\0");
									start++;
									g_string_append (blob, "F\\0");
									start++;
									g_string_append (blob, "N\\0");
									start++;
								} else {
									vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (param)), "unsupported parameter direction for D-Bus method");
								}
							}
							_tmp9 = NULL;
							g_string_append (blob, (_tmp9 = vala_data_type_get_type_signature (vala_formal_parameter_get_parameter_type (param))));
							_tmp9 = (g_free (_tmp9), NULL);
							g_string_append (blob, "\\0");
							start++;
							(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
						}
					}
					(param_collection == NULL ? NULL : (param_collection = (g_object_unref (param_collection), NULL)));
				}
				if (!(VALA_IS_VOID_TYPE (vala_method_get_return_type (m)))) {
					char* _tmp10;
					g_string_append (blob, "result\\0");
					start++;
					g_string_append (blob, "O\\0");
					start++;
					g_string_append (blob, "F\\0");
					start++;
					g_string_append (blob, "N\\0");
					start++;
					_tmp10 = NULL;
					g_string_append (blob, (_tmp10 = vala_data_type_get_type_signature (vala_method_get_return_type (m))));
					_tmp10 = (g_free (_tmp10), NULL);
					g_string_append (blob, "\\0");
					start++;
				}
				g_string_append (blob, "\\0");
				start++;
				blob_len = blob_len + (blob->len - start);
				method_count++;
				(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
				(parameters == NULL ? NULL : (parameters = (g_object_unref (parameters), NULL)));
			}
		}
		(m_collection == NULL ? NULL : (m_collection = (g_object_unref (m_collection), NULL)));
	}
	g_string_append_c (blob, '"');
	g_string_append (dbus_methods, "}\n");
	dbus_signals = g_string_new ("");
	g_string_append_c (dbus_signals, '"');
	{
		GeeList* sig_collection;
		int sig_it;
		sig_collection = vala_object_type_symbol_get_signals (bindable);
		for (sig_it = 0; sig_it < gee_collection_get_size (GEE_COLLECTION (sig_collection)); sig_it = sig_it + 1) {
			ValaSignal* sig;
			sig = ((ValaSignal*) (gee_list_get (GEE_LIST (sig_collection), sig_it)));
			{
				if (vala_symbol_get_access (VALA_SYMBOL (sig)) != VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
					(sig == NULL ? NULL : (sig = (g_object_unref (sig), NULL)));
					continue;
				}
				if (!vala_ccode_object_type_symbol_binding_is_dbus_visible (self, VALA_CODE_NODE (sig))) {
					(sig == NULL ? NULL : (sig = (g_object_unref (sig), NULL)));
					continue;
				}
				g_string_append (dbus_signals, dbus_iface_name);
				g_string_append (dbus_signals, "\\0");
				g_string_append (dbus_signals, vala_symbol_get_name (VALA_SYMBOL (sig)));
				g_string_append (dbus_signals, "\\0");
				(sig == NULL ? NULL : (sig = (g_object_unref (sig), NULL)));
			}
		}
		(sig_collection == NULL ? NULL : (sig_collection = (g_object_unref (sig_collection), NULL)));
	}
	g_string_append_c (dbus_signals, '"');
	dbus_props = g_string_new ("");
	g_string_append_c (dbus_props, '"');
	{
		GeeList* prop_collection;
		int prop_it;
		prop_collection = vala_object_type_symbol_get_properties (bindable);
		for (prop_it = 0; prop_it < gee_collection_get_size (GEE_COLLECTION (prop_collection)); prop_it = prop_it + 1) {
			ValaProperty* prop;
			prop = ((ValaProperty*) (gee_list_get (GEE_LIST (prop_collection), prop_it)));
			{
				if (vala_symbol_get_access (VALA_SYMBOL (prop)) != VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
					(prop == NULL ? NULL : (prop = (g_object_unref (prop), NULL)));
					continue;
				}
				if (!vala_ccode_object_type_symbol_binding_is_dbus_visible (self, VALA_CODE_NODE (prop))) {
					(prop == NULL ? NULL : (prop = (g_object_unref (prop), NULL)));
					continue;
				}
				g_string_append (dbus_props, dbus_iface_name);
				g_string_append (dbus_props, "\\0");
				g_string_append (dbus_props, vala_symbol_get_name (VALA_SYMBOL (prop)));
				g_string_append (dbus_props, "\\0");
				(prop == NULL ? NULL : (prop = (g_object_unref (prop), NULL)));
			}
		}
		(prop_collection == NULL ? NULL : (prop_collection = (g_object_unref (prop_collection), NULL)));
	}
	g_string_append_c (dbus_props, '"');
	dbus_methods_decl = vala_ccode_declaration_new ("const DBusGMethodInfo");
	vala_ccode_declaration_set_modifiers (dbus_methods_decl, VALA_CCODE_MODIFIERS_STATIC);
	_tmp14 = NULL;
	_tmp13 = NULL;
	_tmp12 = NULL;
	_tmp11 = NULL;
	vala_ccode_declaration_add_declarator (dbus_methods_decl, VALA_CCODE_DECLARATOR ((_tmp14 = vala_ccode_variable_declarator_new_with_initializer ((_tmp12 = g_strdup_printf ("%s_dbus_methods[]", (_tmp11 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (bindable), NULL)))), VALA_CCODE_EXPRESSION ((_tmp13 = vala_ccode_constant_new (dbus_methods->str)))))));
	(_tmp14 == NULL ? NULL : (_tmp14 = (g_object_unref (_tmp14), NULL)));
	(_tmp13 == NULL ? NULL : (_tmp13 = (g_object_unref (_tmp13), NULL)));
	_tmp12 = (g_free (_tmp12), NULL);
	_tmp11 = (g_free (_tmp11), NULL);
	vala_ccode_fragment_append (fragment, VALA_CCODE_NODE (dbus_methods_decl));
	dbus_object_info = vala_ccode_declaration_new ("const DBusGObjectInfo");
	vala_ccode_declaration_set_modifiers (dbus_object_info, VALA_CCODE_MODIFIERS_STATIC);
	_tmp20 = NULL;
	_tmp19 = NULL;
	_tmp18 = NULL;
	_tmp17 = NULL;
	_tmp16 = NULL;
	_tmp15 = NULL;
	vala_ccode_declaration_add_declarator (dbus_object_info, VALA_CCODE_DECLARATOR ((_tmp20 = vala_ccode_variable_declarator_new_with_initializer ((_tmp16 = g_strdup_printf ("%s_dbus_object_info", (_tmp15 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (bindable), NULL)))), VALA_CCODE_EXPRESSION ((_tmp19 = vala_ccode_constant_new ((_tmp18 = g_strdup_printf ("{ 0, %s_dbus_methods, %d, %s, %s, %s }", (_tmp17 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (bindable), NULL)), method_count, blob->str, dbus_signals->str, dbus_props->str)))))))));
	(_tmp20 == NULL ? NULL : (_tmp20 = (g_object_unref (_tmp20), NULL)));
	(_tmp19 == NULL ? NULL : (_tmp19 = (g_object_unref (_tmp19), NULL)));
	_tmp18 = (g_free (_tmp18), NULL);
	_tmp17 = (g_free (_tmp17), NULL);
	_tmp16 = (g_free (_tmp16), NULL);
	_tmp15 = (g_free (_tmp15), NULL);
	vala_ccode_fragment_append (fragment, VALA_CCODE_NODE (dbus_object_info));
	_tmp21 = NULL;
	_tmp22 = NULL;
	install_call = (_tmp22 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp21 = vala_ccode_identifier_new ("dbus_g_object_type_install_info")))), (_tmp21 == NULL ? NULL : (_tmp21 = (g_object_unref (_tmp21), NULL))), _tmp22);
	_tmp24 = NULL;
	_tmp23 = NULL;
	vala_ccode_function_call_add_argument (install_call, VALA_CCODE_EXPRESSION ((_tmp24 = vala_ccode_identifier_new ((_tmp23 = vala_typesymbol_get_type_id (VALA_TYPESYMBOL (bindable)))))));
	(_tmp24 == NULL ? NULL : (_tmp24 = (g_object_unref (_tmp24), NULL)));
	_tmp23 = (g_free (_tmp23), NULL);
	_tmp28 = NULL;
	_tmp27 = NULL;
	_tmp26 = NULL;
	_tmp25 = NULL;
	vala_ccode_function_call_add_argument (install_call, VALA_CCODE_EXPRESSION ((_tmp28 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp27 = vala_ccode_identifier_new ((_tmp26 = g_strdup_printf ("%s_dbus_object_info", (_tmp25 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (bindable), NULL)))))))))));
	(_tmp28 == NULL ? NULL : (_tmp28 = (g_object_unref (_tmp28), NULL)));
	(_tmp27 == NULL ? NULL : (_tmp27 = (g_object_unref (_tmp27), NULL)));
	_tmp26 = (g_free (_tmp26), NULL);
	_tmp25 = (g_free (_tmp25), NULL);
	_tmp29 = NULL;
	vala_ccode_fragment_append (fragment, VALA_CCODE_NODE ((_tmp29 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (install_call)))));
	(_tmp29 == NULL ? NULL : (_tmp29 = (g_object_unref (_tmp29), NULL)));
	_tmp30 = NULL;
	return (_tmp30 = fragment, (dbus == NULL ? NULL : (dbus = (g_object_unref (dbus), NULL))), (dbus_iface_name = (g_free (dbus_iface_name), NULL)), (dbus_methods == NULL ? NULL : (dbus_methods = (g_string_free (dbus_methods, TRUE), NULL))), (blob == NULL ? NULL : (blob = (g_string_free (blob, TRUE), NULL))), (dbus_signals == NULL ? NULL : (dbus_signals = (g_string_free (dbus_signals, TRUE), NULL))), (dbus_props == NULL ? NULL : (dbus_props = (g_string_free (dbus_props, TRUE), NULL))), (dbus_methods_decl == NULL ? NULL : (dbus_methods_decl = (g_object_unref (dbus_methods_decl), NULL))), (dbus_object_info == NULL ? NULL : (dbus_object_info = (g_object_unref (dbus_object_info), NULL))), (install_call == NULL ? NULL : (install_call = (g_object_unref (install_call), NULL))), _tmp30);
}


static char* vala_ccode_object_type_symbol_binding_generate_dbus_wrapper (ValaCCodeObjectTypeSymbolBinding* self, ValaMethod* m, ValaObjectTypeSymbol* bindable) {
	char* _tmp0;
	char* _tmp1;
	char* wrapper_name;
	ValaCCodeFunction* function;
	ValaCCodeFormalParameter* _tmp4;
	char* _tmp3;
	char* _tmp2;
	ValaCCodeFormalParameter* _tmp17;
	ValaCCodeBlock* block;
	ValaCCodeIdentifier* _tmp39;
	char* _tmp38;
	ValaCCodeFunctionCall* _tmp40;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeIdentifier* _tmp41;
	GeeList* _tmp47;
	gboolean _tmp48;
	ValaCCodeExpression* expr;
	ValaCCodeExpressionStatement* _tmp54;
	ValaCCodeIdentifier* _tmp90;
	ValaCCodeIdentifier* _tmp89;
	ValaCCodeBinaryExpression* _tmp91;
	ValaCCodeBinaryExpression* no_error;
	ValaCCodeReturnStatement* _tmp92;
	ValaCCodeFunction* _tmp93;
	char* _tmp94;
	g_return_val_if_fail (VALA_IS_CCODE_OBJECT_TYPE_SYMBOL_BINDING (self), NULL);
	g_return_val_if_fail (VALA_IS_METHOD (m), NULL);
	g_return_val_if_fail (VALA_IS_OBJECT_TYPE_SYMBOL (bindable), NULL);
	_tmp0 = NULL;
	_tmp1 = NULL;
	wrapper_name = (_tmp1 = g_strdup_printf ("_dbus_%s", (_tmp0 = vala_method_get_cname (m))), (_tmp0 = (g_free (_tmp0), NULL)), _tmp1);
	/* declaration*/
	function = vala_ccode_function_new (wrapper_name, "gboolean");
	vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
	vala_code_node_set_ccodenode (VALA_CODE_NODE (m), VALA_CCODE_NODE (function));
	_tmp4 = NULL;
	_tmp3 = NULL;
	_tmp2 = NULL;
	vala_ccode_function_add_parameter (function, (_tmp4 = vala_ccode_formal_parameter_new ("self", (_tmp3 = g_strconcat ((_tmp2 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (bindable), FALSE)), "*", NULL)))));
	(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
	_tmp3 = (g_free (_tmp3), NULL);
	_tmp2 = (g_free (_tmp2), NULL);
	{
		GeeList* param_collection;
		int param_it;
		param_collection = vala_method_get_parameters (m);
		for (param_it = 0; param_it < gee_collection_get_size (GEE_COLLECTION (param_collection)); param_it = param_it + 1) {
			ValaFormalParameter* param;
			param = ((ValaFormalParameter*) (gee_list_get (GEE_LIST (param_collection), param_it)));
			{
				char* _tmp5;
				gboolean _tmp6;
				_tmp5 = NULL;
				if ((_tmp6 = g_str_has_prefix ((_tmp5 = vala_data_type_get_type_signature (vala_formal_parameter_get_parameter_type (param))), "("), (_tmp5 = (g_free (_tmp5), NULL)), _tmp6)) {
					if (vala_formal_parameter_get_direction (param) == VALA_PARAMETER_DIRECTION_IN) {
						ValaCCodeFormalParameter* _tmp8;
						char* _tmp7;
						_tmp8 = NULL;
						_tmp7 = NULL;
						vala_ccode_function_add_parameter (function, (_tmp8 = vala_ccode_formal_parameter_new ((_tmp7 = g_strdup_printf ("dbus_%s", vala_symbol_get_name (VALA_SYMBOL (param)))), "GValueArray*")));
						(_tmp8 == NULL ? NULL : (_tmp8 = (g_object_unref (_tmp8), NULL)));
						_tmp7 = (g_free (_tmp7), NULL);
					} else {
						ValaCCodeFormalParameter* _tmp10;
						char* _tmp9;
						_tmp10 = NULL;
						_tmp9 = NULL;
						vala_ccode_function_add_parameter (function, (_tmp10 = vala_ccode_formal_parameter_new ((_tmp9 = g_strdup_printf ("dbus_%s", vala_symbol_get_name (VALA_SYMBOL (param)))), "GValueArray**")));
						(_tmp10 == NULL ? NULL : (_tmp10 = (g_object_unref (_tmp10), NULL)));
						_tmp9 = (g_free (_tmp9), NULL);
					}
				} else {
					vala_ccode_function_add_parameter (function, VALA_CCODE_FORMAL_PARAMETER (vala_code_node_get_ccodenode (VALA_CODE_NODE (param))));
				}
				(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
			}
		}
		(param_collection == NULL ? NULL : (param_collection = (g_object_unref (param_collection), NULL)));
	}
	if (!(VALA_IS_VOID_TYPE (vala_method_get_return_type (m)))) {
		char* _tmp11;
		gboolean _tmp12;
		_tmp11 = NULL;
		if ((_tmp12 = g_str_has_prefix ((_tmp11 = vala_data_type_get_type_signature (vala_method_get_return_type (m))), "("), (_tmp11 = (g_free (_tmp11), NULL)), _tmp12)) {
			ValaCCodeFormalParameter* _tmp13;
			_tmp13 = NULL;
			vala_ccode_function_add_parameter (function, (_tmp13 = vala_ccode_formal_parameter_new ("result", "GValueArray**")));
			(_tmp13 == NULL ? NULL : (_tmp13 = (g_object_unref (_tmp13), NULL)));
		} else {
			ValaCCodeFormalParameter* _tmp16;
			char* _tmp15;
			char* _tmp14;
			_tmp16 = NULL;
			_tmp15 = NULL;
			_tmp14 = NULL;
			vala_ccode_function_add_parameter (function, (_tmp16 = vala_ccode_formal_parameter_new ("result", (_tmp15 = g_strconcat ((_tmp14 = vala_data_type_get_cname (vala_method_get_return_type (m))), "*", NULL)))));
			(_tmp16 == NULL ? NULL : (_tmp16 = (g_object_unref (_tmp16), NULL)));
			_tmp15 = (g_free (_tmp15), NULL);
			_tmp14 = (g_free (_tmp14), NULL);
		}
	}
	_tmp17 = NULL;
	vala_ccode_function_add_parameter (function, (_tmp17 = vala_ccode_formal_parameter_new ("error", "GError**")));
	(_tmp17 == NULL ? NULL : (_tmp17 = (g_object_unref (_tmp17), NULL)));
	/* definition*/
	block = vala_ccode_block_new ();
	{
		GeeList* param_collection;
		int param_it;
		param_collection = vala_method_get_parameters (m);
		for (param_it = 0; param_it < gee_collection_get_size (GEE_COLLECTION (param_collection)); param_it = param_it + 1) {
			ValaFormalParameter* param;
			param = ((ValaFormalParameter*) (gee_list_get (GEE_LIST (param_collection), param_it)));
			{
				char* _tmp18;
				gboolean _tmp19;
				_tmp18 = NULL;
				if ((_tmp19 = g_str_has_prefix ((_tmp18 = vala_data_type_get_type_signature (vala_formal_parameter_get_parameter_type (param))), "("), (_tmp18 = (g_free (_tmp18), NULL)), _tmp19)) {
					ValaStruct* _tmp20;
					ValaStruct* st;
					char* _tmp21;
					ValaCCodeDeclaration* _tmp22;
					ValaCCodeDeclaration* cdecl_;
					ValaCCodeVariableDeclarator* _tmp23;
					_tmp20 = NULL;
					st = (_tmp20 = VALA_STRUCT (vala_data_type_get_data_type (vala_formal_parameter_get_parameter_type (param))), (_tmp20 == NULL ? NULL : g_object_ref (_tmp20)));
					_tmp21 = NULL;
					_tmp22 = NULL;
					cdecl_ = (_tmp22 = vala_ccode_declaration_new ((_tmp21 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (st), FALSE))), (_tmp21 = (g_free (_tmp21), NULL)), _tmp22);
					_tmp23 = NULL;
					vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp23 = vala_ccode_variable_declarator_new (vala_symbol_get_name (VALA_SYMBOL (param))))));
					(_tmp23 == NULL ? NULL : (_tmp23 = (g_object_unref (_tmp23), NULL)));
					vala_ccode_block_add_statement (block, VALA_CCODE_NODE (cdecl_));
					if (vala_formal_parameter_get_direction (param) == VALA_PARAMETER_DIRECTION_IN) {
						gint i;
						/* struct input parameter*/
						i = 0;
						{
							GeeList* f_collection;
							int f_it;
							f_collection = vala_struct_get_fields (st);
							for (f_it = 0; f_it < gee_collection_get_size (GEE_COLLECTION (f_collection)); f_it = f_it + 1) {
								ValaField* f;
								f = ((ValaField*) (gee_list_get (GEE_LIST (f_collection), f_it)));
								{
									if (vala_field_get_binding (f) == MEMBER_BINDING_INSTANCE) {
										ValaCCodeIdentifier* _tmp25;
										char* _tmp24;
										ValaCCodeFunctionCall* _tmp26;
										ValaCCodeFunctionCall* cget_call;
										ValaCCodeUnaryExpression* _tmp33;
										ValaCCodeElementAccess* _tmp32;
										ValaCCodeConstant* _tmp31;
										char* _tmp30;
										ValaCCodeMemberAccess* _tmp29;
										ValaCCodeIdentifier* _tmp28;
										char* _tmp27;
										ValaCCodeMemberAccess* _tmp35;
										ValaCCodeIdentifier* _tmp34;
										ValaCCodeAssignment* _tmp36;
										ValaCCodeAssignment* assign;
										ValaCCodeExpressionStatement* _tmp37;
										_tmp25 = NULL;
										_tmp24 = NULL;
										_tmp26 = NULL;
										cget_call = (_tmp26 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp25 = vala_ccode_identifier_new ((_tmp24 = vala_typesymbol_get_get_value_function (vala_data_type_get_data_type (vala_field_get_field_type (f)))))))), (_tmp25 == NULL ? NULL : (_tmp25 = (g_object_unref (_tmp25), NULL))), (_tmp24 = (g_free (_tmp24), NULL)), _tmp26);
										_tmp33 = NULL;
										_tmp32 = NULL;
										_tmp31 = NULL;
										_tmp30 = NULL;
										_tmp29 = NULL;
										_tmp28 = NULL;
										_tmp27 = NULL;
										vala_ccode_function_call_add_argument (cget_call, VALA_CCODE_EXPRESSION ((_tmp33 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp32 = vala_ccode_element_access_new (VALA_CCODE_EXPRESSION ((_tmp29 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp28 = vala_ccode_identifier_new ((_tmp27 = g_strdup_printf ("dbus_%s", vala_symbol_get_name (VALA_SYMBOL (param))))))), "values"))), VALA_CCODE_EXPRESSION ((_tmp31 = vala_ccode_constant_new ((_tmp30 = g_strdup_printf ("%i", i))))))))))));
										(_tmp33 == NULL ? NULL : (_tmp33 = (g_object_unref (_tmp33), NULL)));
										(_tmp32 == NULL ? NULL : (_tmp32 = (g_object_unref (_tmp32), NULL)));
										(_tmp31 == NULL ? NULL : (_tmp31 = (g_object_unref (_tmp31), NULL)));
										_tmp30 = (g_free (_tmp30), NULL);
										(_tmp29 == NULL ? NULL : (_tmp29 = (g_object_unref (_tmp29), NULL)));
										(_tmp28 == NULL ? NULL : (_tmp28 = (g_object_unref (_tmp28), NULL)));
										_tmp27 = (g_free (_tmp27), NULL);
										_tmp35 = NULL;
										_tmp34 = NULL;
										_tmp36 = NULL;
										assign = (_tmp36 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp35 = vala_ccode_member_access_new (VALA_CCODE_EXPRESSION ((_tmp34 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (param))))), vala_symbol_get_name (VALA_SYMBOL (f)), FALSE))), VALA_CCODE_EXPRESSION (cget_call), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (_tmp35 == NULL ? NULL : (_tmp35 = (g_object_unref (_tmp35), NULL))), (_tmp34 == NULL ? NULL : (_tmp34 = (g_object_unref (_tmp34), NULL))), _tmp36);
										_tmp37 = NULL;
										vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((_tmp37 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (assign)))));
										(_tmp37 == NULL ? NULL : (_tmp37 = (g_object_unref (_tmp37), NULL)));
										i++;
										(cget_call == NULL ? NULL : (cget_call = (g_object_unref (cget_call), NULL)));
										(assign == NULL ? NULL : (assign = (g_object_unref (assign), NULL)));
									}
									(f == NULL ? NULL : (f = (g_object_unref (f), NULL)));
								}
							}
							(f_collection == NULL ? NULL : (f_collection = (g_object_unref (f_collection), NULL)));
						}
					}
					(st == NULL ? NULL : (st = (g_object_unref (st), NULL)));
					(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
				}
				(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
			}
		}
		(param_collection == NULL ? NULL : (param_collection = (g_object_unref (param_collection), NULL)));
	}
	_tmp39 = NULL;
	_tmp38 = NULL;
	_tmp40 = NULL;
	ccall = (_tmp40 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp39 = vala_ccode_identifier_new ((_tmp38 = vala_method_get_cname (m)))))), (_tmp39 == NULL ? NULL : (_tmp39 = (g_object_unref (_tmp39), NULL))), (_tmp38 = (g_free (_tmp38), NULL)), _tmp40);
	_tmp41 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp41 = vala_ccode_identifier_new ("self"))));
	(_tmp41 == NULL ? NULL : (_tmp41 = (g_object_unref (_tmp41), NULL)));
	{
		GeeList* param_collection;
		int param_it;
		param_collection = vala_method_get_parameters (m);
		for (param_it = 0; param_it < gee_collection_get_size (GEE_COLLECTION (param_collection)); param_it = param_it + 1) {
			ValaFormalParameter* param;
			param = ((ValaFormalParameter*) (gee_list_get (GEE_LIST (param_collection), param_it)));
			{
				char* _tmp42;
				gboolean _tmp43;
				_tmp42 = NULL;
				if ((_tmp43 = g_str_has_prefix ((_tmp42 = vala_data_type_get_type_signature (vala_formal_parameter_get_parameter_type (param))), "("), (_tmp42 = (g_free (_tmp42), NULL)), _tmp43)) {
					ValaCCodeUnaryExpression* _tmp45;
					ValaCCodeIdentifier* _tmp44;
					/* struct input or output parameters*/
					_tmp45 = NULL;
					_tmp44 = NULL;
					vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp45 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp44 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (param)))))))));
					(_tmp45 == NULL ? NULL : (_tmp45 = (g_object_unref (_tmp45), NULL)));
					(_tmp44 == NULL ? NULL : (_tmp44 = (g_object_unref (_tmp44), NULL)));
				} else {
					ValaCCodeIdentifier* _tmp46;
					_tmp46 = NULL;
					vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp46 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (param))))));
					(_tmp46 == NULL ? NULL : (_tmp46 = (g_object_unref (_tmp46), NULL)));
				}
				(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
			}
		}
		(param_collection == NULL ? NULL : (param_collection = (g_object_unref (param_collection), NULL)));
	}
	_tmp47 = NULL;
	if ((_tmp48 = gee_collection_get_size (GEE_COLLECTION ((_tmp47 = vala_code_node_get_error_types (VALA_CODE_NODE (m))))) > 0, (_tmp47 == NULL ? NULL : (_tmp47 = (g_object_unref (_tmp47), NULL))), _tmp48)) {
		ValaCCodeIdentifier* _tmp49;
		_tmp49 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp49 = vala_ccode_identifier_new ("error"))));
		(_tmp49 == NULL ? NULL : (_tmp49 = (g_object_unref (_tmp49), NULL)));
	}
	expr = NULL;
	if (VALA_IS_VOID_TYPE (vala_method_get_return_type (m))) {
		ValaCCodeExpression* _tmp51;
		ValaCCodeExpression* _tmp50;
		_tmp51 = NULL;
		_tmp50 = NULL;
		expr = (_tmp51 = (_tmp50 = VALA_CCODE_EXPRESSION (ccall), (_tmp50 == NULL ? NULL : g_object_ref (_tmp50))), (expr == NULL ? NULL : (expr = (g_object_unref (expr), NULL))), _tmp51);
	} else {
		ValaCCodeExpression* _tmp53;
		ValaCCodeIdentifier* _tmp52;
		_tmp53 = NULL;
		_tmp52 = NULL;
		expr = (_tmp53 = VALA_CCODE_EXPRESSION (vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp52 = vala_ccode_identifier_new ("*result"))), VALA_CCODE_EXPRESSION (ccall), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)), (expr == NULL ? NULL : (expr = (g_object_unref (expr), NULL))), _tmp53);
		(_tmp52 == NULL ? NULL : (_tmp52 = (g_object_unref (_tmp52), NULL)));
	}
	_tmp54 = NULL;
	vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((_tmp54 = vala_ccode_expression_statement_new (expr))));
	(_tmp54 == NULL ? NULL : (_tmp54 = (g_object_unref (_tmp54), NULL)));
	{
		GeeList* param_collection;
		int param_it;
		param_collection = vala_method_get_parameters (m);
		for (param_it = 0; param_it < gee_collection_get_size (GEE_COLLECTION (param_collection)); param_it = param_it + 1) {
			ValaFormalParameter* param;
			param = ((ValaFormalParameter*) (gee_list_get (GEE_LIST (param_collection), param_it)));
			{
				char* _tmp55;
				gboolean _tmp56;
				_tmp55 = NULL;
				if ((_tmp56 = vala_formal_parameter_get_direction (param) == VALA_PARAMETER_DIRECTION_OUT && g_str_has_prefix ((_tmp55 = vala_data_type_get_type_signature (vala_formal_parameter_get_parameter_type (param))), "("), (_tmp55 = (g_free (_tmp55), NULL)), _tmp56)) {
					ValaStruct* _tmp57;
					ValaStruct* st;
					ValaCCodeIdentifier* _tmp58;
					ValaCCodeFunctionCall* _tmp59;
					ValaCCodeFunctionCall* array_construct;
					ValaCCodeConstant* _tmp60;
					ValaCCodeIdentifier* _tmp62;
					char* _tmp61;
					ValaCCodeUnaryExpression* _tmp63;
					ValaCCodeUnaryExpression* dbus_param;
					ValaCCodeExpressionStatement* _tmp65;
					ValaCCodeAssignment* _tmp64;
					ValaCCodeIdentifier* _tmp66;
					ValaCCodeFunctionCall* _tmp67;
					ValaCCodeFunctionCall* type_call;
					ValaCCodeConstant* _tmp68;
					/* struct output parameter*/
					_tmp57 = NULL;
					st = (_tmp57 = VALA_STRUCT (vala_data_type_get_data_type (vala_formal_parameter_get_parameter_type (param))), (_tmp57 == NULL ? NULL : g_object_ref (_tmp57)));
					_tmp58 = NULL;
					_tmp59 = NULL;
					array_construct = (_tmp59 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp58 = vala_ccode_identifier_new ("g_value_array_new")))), (_tmp58 == NULL ? NULL : (_tmp58 = (g_object_unref (_tmp58), NULL))), _tmp59);
					_tmp60 = NULL;
					vala_ccode_function_call_add_argument (array_construct, VALA_CCODE_EXPRESSION ((_tmp60 = vala_ccode_constant_new ("0"))));
					(_tmp60 == NULL ? NULL : (_tmp60 = (g_object_unref (_tmp60), NULL)));
					_tmp62 = NULL;
					_tmp61 = NULL;
					_tmp63 = NULL;
					dbus_param = (_tmp63 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, VALA_CCODE_EXPRESSION ((_tmp62 = vala_ccode_identifier_new ((_tmp61 = g_strdup_printf ("dbus_%s", vala_symbol_get_name (VALA_SYMBOL (param)))))))), (_tmp62 == NULL ? NULL : (_tmp62 = (g_object_unref (_tmp62), NULL))), (_tmp61 = (g_free (_tmp61), NULL)), _tmp63);
					_tmp65 = NULL;
					_tmp64 = NULL;
					vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((_tmp65 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp64 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (dbus_param), VALA_CCODE_EXPRESSION (array_construct), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
					(_tmp65 == NULL ? NULL : (_tmp65 = (g_object_unref (_tmp65), NULL)));
					(_tmp64 == NULL ? NULL : (_tmp64 = (g_object_unref (_tmp64), NULL)));
					_tmp66 = NULL;
					_tmp67 = NULL;
					type_call = (_tmp67 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp66 = vala_ccode_identifier_new ("dbus_g_type_get_struct")))), (_tmp66 == NULL ? NULL : (_tmp66 = (g_object_unref (_tmp66), NULL))), _tmp67);
					_tmp68 = NULL;
					vala_ccode_function_call_add_argument (type_call, VALA_CCODE_EXPRESSION ((_tmp68 = vala_ccode_constant_new ("\"GValueArray\""))));
					(_tmp68 == NULL ? NULL : (_tmp68 = (g_object_unref (_tmp68), NULL)));
					{
						GeeList* f_collection;
						int f_it;
						f_collection = vala_struct_get_fields (st);
						for (f_it = 0; f_it < gee_collection_get_size (GEE_COLLECTION (f_collection)); f_it = f_it + 1) {
							ValaField* f;
							f = ((ValaField*) (gee_list_get (GEE_LIST (f_collection), f_it)));
							{
								char* val_name;
								ValaCCodeInitializerList* cvalinit;
								ValaCCodeConstant* _tmp69;
								ValaCCodeDeclaration* cval_decl;
								ValaCCodeVariableDeclarator* _tmp70;
								ValaCCodeIdentifier* _tmp71;
								ValaCCodeUnaryExpression* _tmp72;
								ValaCCodeUnaryExpression* val_ptr;
								ValaCCodeIdentifier* _tmp73;
								ValaCCodeFunctionCall* _tmp74;
								ValaCCodeFunctionCall* cinit_call;
								ValaCCodeIdentifier* _tmp76;
								char* _tmp75;
								ValaCCodeExpressionStatement* _tmp77;
								ValaCCodeIdentifier* _tmp79;
								char* _tmp78;
								ValaCCodeFunctionCall* _tmp80;
								ValaCCodeFunctionCall* cset_call;
								ValaCCodeMemberAccess* _tmp82;
								ValaCCodeIdentifier* _tmp81;
								ValaCCodeExpressionStatement* _tmp83;
								ValaCCodeIdentifier* _tmp84;
								ValaCCodeFunctionCall* _tmp85;
								ValaCCodeFunctionCall* cappend_call;
								ValaCCodeExpressionStatement* _tmp86;
								ValaCCodeIdentifier* _tmp88;
								char* _tmp87;
								if (vala_field_get_binding (f) != MEMBER_BINDING_INSTANCE) {
									(f == NULL ? NULL : (f = (g_object_unref (f), NULL)));
									continue;
								}
								val_name = g_strdup_printf ("val_%s_%s", vala_symbol_get_name (VALA_SYMBOL (param)), vala_symbol_get_name (VALA_SYMBOL (f)));
								/* 0-initialize struct with struct initializer { 0 }*/
								cvalinit = vala_ccode_initializer_list_new ();
								_tmp69 = NULL;
								vala_ccode_initializer_list_append (cvalinit, VALA_CCODE_EXPRESSION ((_tmp69 = vala_ccode_constant_new ("0"))));
								(_tmp69 == NULL ? NULL : (_tmp69 = (g_object_unref (_tmp69), NULL)));
								cval_decl = vala_ccode_declaration_new ("GValue");
								_tmp70 = NULL;
								vala_ccode_declaration_add_declarator (cval_decl, VALA_CCODE_DECLARATOR ((_tmp70 = vala_ccode_variable_declarator_new_with_initializer (val_name, VALA_CCODE_EXPRESSION (cvalinit)))));
								(_tmp70 == NULL ? NULL : (_tmp70 = (g_object_unref (_tmp70), NULL)));
								vala_ccode_block_add_statement (block, VALA_CCODE_NODE (cval_decl));
								_tmp71 = NULL;
								_tmp72 = NULL;
								val_ptr = (_tmp72 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp71 = vala_ccode_identifier_new (val_name)))), (_tmp71 == NULL ? NULL : (_tmp71 = (g_object_unref (_tmp71), NULL))), _tmp72);
								_tmp73 = NULL;
								_tmp74 = NULL;
								cinit_call = (_tmp74 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp73 = vala_ccode_identifier_new ("g_value_init")))), (_tmp73 == NULL ? NULL : (_tmp73 = (g_object_unref (_tmp73), NULL))), _tmp74);
								vala_ccode_function_call_add_argument (cinit_call, VALA_CCODE_EXPRESSION (val_ptr));
								_tmp76 = NULL;
								_tmp75 = NULL;
								vala_ccode_function_call_add_argument (cinit_call, VALA_CCODE_EXPRESSION ((_tmp76 = vala_ccode_identifier_new ((_tmp75 = vala_typesymbol_get_type_id (vala_data_type_get_data_type (vala_field_get_field_type (f))))))));
								(_tmp76 == NULL ? NULL : (_tmp76 = (g_object_unref (_tmp76), NULL)));
								_tmp75 = (g_free (_tmp75), NULL);
								_tmp77 = NULL;
								vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((_tmp77 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cinit_call)))));
								(_tmp77 == NULL ? NULL : (_tmp77 = (g_object_unref (_tmp77), NULL)));
								_tmp79 = NULL;
								_tmp78 = NULL;
								_tmp80 = NULL;
								cset_call = (_tmp80 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp79 = vala_ccode_identifier_new ((_tmp78 = vala_typesymbol_get_set_value_function (vala_data_type_get_data_type (vala_field_get_field_type (f)))))))), (_tmp79 == NULL ? NULL : (_tmp79 = (g_object_unref (_tmp79), NULL))), (_tmp78 = (g_free (_tmp78), NULL)), _tmp80);
								vala_ccode_function_call_add_argument (cset_call, VALA_CCODE_EXPRESSION (val_ptr));
								_tmp82 = NULL;
								_tmp81 = NULL;
								vala_ccode_function_call_add_argument (cset_call, VALA_CCODE_EXPRESSION ((_tmp82 = vala_ccode_member_access_new (VALA_CCODE_EXPRESSION ((_tmp81 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (param))))), vala_symbol_get_name (VALA_SYMBOL (f)), FALSE))));
								(_tmp82 == NULL ? NULL : (_tmp82 = (g_object_unref (_tmp82), NULL)));
								(_tmp81 == NULL ? NULL : (_tmp81 = (g_object_unref (_tmp81), NULL)));
								_tmp83 = NULL;
								vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((_tmp83 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cset_call)))));
								(_tmp83 == NULL ? NULL : (_tmp83 = (g_object_unref (_tmp83), NULL)));
								_tmp84 = NULL;
								_tmp85 = NULL;
								cappend_call = (_tmp85 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp84 = vala_ccode_identifier_new ("g_value_array_append")))), (_tmp84 == NULL ? NULL : (_tmp84 = (g_object_unref (_tmp84), NULL))), _tmp85);
								vala_ccode_function_call_add_argument (cappend_call, VALA_CCODE_EXPRESSION (dbus_param));
								vala_ccode_function_call_add_argument (cappend_call, VALA_CCODE_EXPRESSION (val_ptr));
								_tmp86 = NULL;
								vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((_tmp86 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cappend_call)))));
								(_tmp86 == NULL ? NULL : (_tmp86 = (g_object_unref (_tmp86), NULL)));
								_tmp88 = NULL;
								_tmp87 = NULL;
								vala_ccode_function_call_add_argument (type_call, VALA_CCODE_EXPRESSION ((_tmp88 = vala_ccode_identifier_new ((_tmp87 = vala_typesymbol_get_type_id (vala_data_type_get_data_type (vala_field_get_field_type (f))))))));
								(_tmp88 == NULL ? NULL : (_tmp88 = (g_object_unref (_tmp88), NULL)));
								_tmp87 = (g_free (_tmp87), NULL);
								(f == NULL ? NULL : (f = (g_object_unref (f), NULL)));
								val_name = (g_free (val_name), NULL);
								(cvalinit == NULL ? NULL : (cvalinit = (g_object_unref (cvalinit), NULL)));
								(cval_decl == NULL ? NULL : (cval_decl = (g_object_unref (cval_decl), NULL)));
								(val_ptr == NULL ? NULL : (val_ptr = (g_object_unref (val_ptr), NULL)));
								(cinit_call == NULL ? NULL : (cinit_call = (g_object_unref (cinit_call), NULL)));
								(cset_call == NULL ? NULL : (cset_call = (g_object_unref (cset_call), NULL)));
								(cappend_call == NULL ? NULL : (cappend_call = (g_object_unref (cappend_call), NULL)));
							}
						}
						(f_collection == NULL ? NULL : (f_collection = (g_object_unref (f_collection), NULL)));
					}
					(st == NULL ? NULL : (st = (g_object_unref (st), NULL)));
					(array_construct == NULL ? NULL : (array_construct = (g_object_unref (array_construct), NULL)));
					(dbus_param == NULL ? NULL : (dbus_param = (g_object_unref (dbus_param), NULL)));
					(type_call == NULL ? NULL : (type_call = (g_object_unref (type_call), NULL)));
				}
				(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
			}
		}
		(param_collection == NULL ? NULL : (param_collection = (g_object_unref (param_collection), NULL)));
	}
	_tmp90 = NULL;
	_tmp89 = NULL;
	_tmp91 = NULL;
	no_error = (_tmp91 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_OR, VALA_CCODE_EXPRESSION ((_tmp89 = vala_ccode_identifier_new ("!error"))), VALA_CCODE_EXPRESSION ((_tmp90 = vala_ccode_identifier_new ("!*error")))), (_tmp90 == NULL ? NULL : (_tmp90 = (g_object_unref (_tmp90), NULL))), (_tmp89 == NULL ? NULL : (_tmp89 = (g_object_unref (_tmp89), NULL))), _tmp91);
	_tmp92 = NULL;
	vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((_tmp92 = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION (no_error)))));
	(_tmp92 == NULL ? NULL : (_tmp92 = (g_object_unref (_tmp92), NULL)));
	/* append to file*/
	_tmp93 = NULL;
	vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_declaration, VALA_CCODE_NODE ((_tmp93 = vala_ccode_function_copy (function))));
	(_tmp93 == NULL ? NULL : (_tmp93 = (g_object_unref (_tmp93), NULL)));
	vala_ccode_function_set_block (function, block);
	vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_definition, VALA_CCODE_NODE (function));
	_tmp94 = NULL;
	return (_tmp94 = wrapper_name, (function == NULL ? NULL : (function = (g_object_unref (function), NULL))), (block == NULL ? NULL : (block = (g_object_unref (block), NULL))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), (expr == NULL ? NULL : (expr = (g_object_unref (expr), NULL))), (no_error == NULL ? NULL : (no_error = (g_object_unref (no_error), NULL))), _tmp94);
}


static void vala_ccode_object_type_symbol_binding_class_init (ValaCCodeObjectTypeSymbolBindingClass * klass) {
	vala_ccode_object_type_symbol_binding_parent_class = g_type_class_peek_parent (klass);
}


static void vala_ccode_object_type_symbol_binding_instance_init (ValaCCodeObjectTypeSymbolBinding * self) {
}


GType vala_ccode_object_type_symbol_binding_get_type (void) {
	static GType vala_ccode_object_type_symbol_binding_type_id = 0;
	if (G_UNLIKELY (vala_ccode_object_type_symbol_binding_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeObjectTypeSymbolBindingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_object_type_symbol_binding_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeObjectTypeSymbolBinding), 0, (GInstanceInitFunc) vala_ccode_object_type_symbol_binding_instance_init };
		vala_ccode_object_type_symbol_binding_type_id = g_type_register_static (VALA_TYPE_CCODE_TYPE_SYMBOL_BINDING, "ValaCCodeObjectTypeSymbolBinding", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	}
	return vala_ccode_object_type_symbol_binding_type_id;
}




