/* valaccodememberaccessbinding.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter, Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <gobject/valaccodememberaccessbinding.h>
#include <ccode/valaccodeexpression.h>
#include <vala/valadatatype.h>
#include <vala/valaexpression.h>
#include <vala/valamethod.h>
#include <vala/valabaseaccess.h>
#include <vala/valasymbol.h>
#include <vala/valaclass.h>
#include <ccode/valaccodefunctioncall.h>
#include <ccode/valaccodeidentifier.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valatypesymbol.h>
#include <vala/valacodenode.h>
#include <ccode/valaccodememberaccess.h>
#include <vala/valainterface.h>
#include <vala/valalocalvariable.h>
#include <gee/list.h>
#include <ccode/valaccodeassignment.h>
#include <vala/valaarraylengthfield.h>
#include <vala/valafield.h>
#include <vala/valamember.h>
#include <vala/valapointertype.h>
#include <vala/valaconstant.h>
#include <vala/valaproperty.h>
#include <vala/valapropertyaccessor.h>
#include <vala/valadynamicproperty.h>
#include <ccode/valaccodecommaexpression.h>
#include <gee/collection.h>
#include <ccode/valaccodeunaryexpression.h>
#include <ccode/valaccodeconstant.h>
#include <vala/valaenumvalue.h>
#include <vala/valaformalparameter.h>
#include <vala/valastruct.h>
#include <vala/valasignal.h>
#include <gobject/valaccodebinding.h>
#include <gobject/valaccodemethodbinding.h>
#include <gobject/valaccodedynamicpropertybinding.h>




struct _ValaCCodeMemberAccessBindingPrivate {
	ValaMemberAccess* _member_access;
};

#define VALA_CCODE_MEMBER_ACCESS_BINDING_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_MEMBER_ACCESS_BINDING, ValaCCodeMemberAccessBindingPrivate))
enum  {
	VALA_CCODE_MEMBER_ACCESS_BINDING_DUMMY_PROPERTY,
	VALA_CCODE_MEMBER_ACCESS_BINDING_MEMBER_ACCESS
};
static void vala_ccode_member_access_binding_process_cmember (ValaCCodeMemberAccessBinding* self, ValaMemberAccess* expr, ValaCCodeExpression* pub_inst, ValaDataType* base_type);
static void vala_ccode_member_access_binding_real_emit (ValaCCodeBinding* base);
static gpointer vala_ccode_member_access_binding_parent_class = NULL;
static void vala_ccode_member_access_binding_dispose (GObject * obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



ValaCCodeMemberAccessBinding* vala_ccode_member_access_binding_new (ValaCCodeGenerator* codegen, ValaMemberAccess* member_access) {
	ValaCCodeMemberAccessBinding * self;
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (codegen), NULL);
	g_return_val_if_fail (VALA_IS_MEMBER_ACCESS (member_access), NULL);
	self = g_object_newv (VALA_TYPE_CCODE_MEMBER_ACCESS_BINDING, 0, NULL);
	vala_ccode_member_access_binding_set_member_access (self, member_access);
	vala_ccode_binding_set_codegen (VALA_CCODE_BINDING (self), codegen);
	return self;
}


static void vala_ccode_member_access_binding_process_cmember (ValaCCodeMemberAccessBinding* self, ValaMemberAccess* expr, ValaCCodeExpression* pub_inst, ValaDataType* base_type) {
	g_return_if_fail (VALA_IS_CCODE_MEMBER_ACCESS_BINDING (self));
	g_return_if_fail (VALA_IS_MEMBER_ACCESS (expr));
	g_return_if_fail (pub_inst == NULL || VALA_IS_CCODE_EXPRESSION (pub_inst));
	g_return_if_fail (base_type == NULL || VALA_IS_DATA_TYPE (base_type));
	if (VALA_IS_METHOD (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr)))) {
		ValaMethod* _tmp0;
		ValaMethod* m;
		_tmp0 = NULL;
		m = (_tmp0 = VALA_METHOD (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr))), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
		if (VALA_IS_BASE_ACCESS (vala_member_access_get_inner (expr))) {
			if (vala_method_get_base_method (m) != NULL) {
				ValaClass* _tmp1;
				ValaClass* base_class;
				ValaCCodeIdentifier* _tmp4;
				char* _tmp3;
				char* _tmp2;
				ValaCCodeFunctionCall* _tmp5;
				ValaCCodeFunctionCall* vcast;
				ValaCCodeIdentifier* _tmp8;
				char* _tmp7;
				char* _tmp6;
				ValaCCodeMemberAccess* _tmp9;
				_tmp1 = NULL;
				base_class = (_tmp1 = VALA_CLASS (vala_symbol_get_parent_symbol (VALA_SYMBOL (vala_method_get_base_method (m)))), (_tmp1 == NULL ? NULL : g_object_ref (_tmp1)));
				_tmp4 = NULL;
				_tmp3 = NULL;
				_tmp2 = NULL;
				_tmp5 = NULL;
				vcast = (_tmp5 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp4 = vala_ccode_identifier_new ((_tmp3 = g_strdup_printf ("%s_CLASS", (_tmp2 = vala_typesymbol_get_upper_case_cname (VALA_TYPESYMBOL (base_class), NULL)))))))), (_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL))), (_tmp3 = (g_free (_tmp3), NULL)), (_tmp2 = (g_free (_tmp2), NULL)), _tmp5);
				_tmp8 = NULL;
				_tmp7 = NULL;
				_tmp6 = NULL;
				vala_ccode_function_call_add_argument (vcast, VALA_CCODE_EXPRESSION ((_tmp8 = vala_ccode_identifier_new ((_tmp7 = g_strdup_printf ("%s_parent_class", (_tmp6 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_class), NULL))))))));
				(_tmp8 == NULL ? NULL : (_tmp8 = (g_object_unref (_tmp8), NULL)));
				_tmp7 = (g_free (_tmp7), NULL);
				_tmp6 = (g_free (_tmp6), NULL);
				_tmp9 = NULL;
				vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp9 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (vcast), vala_symbol_get_name (VALA_SYMBOL (m))))));
				(_tmp9 == NULL ? NULL : (_tmp9 = (g_object_unref (_tmp9), NULL)));
				(base_class == NULL ? NULL : (base_class = (g_object_unref (base_class), NULL)));
				(vcast == NULL ? NULL : (vcast = (g_object_unref (vcast), NULL)));
				(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
				return;
			} else {
				if (vala_method_get_base_interface_method (m) != NULL) {
					ValaInterface* _tmp10;
					ValaInterface* base_iface;
					char* _tmp12;
					char* _tmp11;
					char* _tmp13;
					char* parent_iface_var;
					ValaCCodeMemberAccess* _tmp15;
					ValaCCodeIdentifier* _tmp14;
					_tmp10 = NULL;
					base_iface = (_tmp10 = VALA_INTERFACE (vala_symbol_get_parent_symbol (VALA_SYMBOL (vala_method_get_base_interface_method (m)))), (_tmp10 == NULL ? NULL : g_object_ref (_tmp10)));
					_tmp12 = NULL;
					_tmp11 = NULL;
					_tmp13 = NULL;
					parent_iface_var = (_tmp13 = g_strdup_printf ("%s_%s_parent_iface", (_tmp11 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_class), NULL)), (_tmp12 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (base_iface), NULL))), (_tmp12 = (g_free (_tmp12), NULL)), (_tmp11 = (g_free (_tmp11), NULL)), _tmp13);
					_tmp15 = NULL;
					_tmp14 = NULL;
					vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp15 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp14 = vala_ccode_identifier_new (parent_iface_var))), vala_symbol_get_name (VALA_SYMBOL (m))))));
					(_tmp15 == NULL ? NULL : (_tmp15 = (g_object_unref (_tmp15), NULL)));
					(_tmp14 == NULL ? NULL : (_tmp14 = (g_object_unref (_tmp14), NULL)));
					(base_iface == NULL ? NULL : (base_iface = (g_object_unref (base_iface), NULL)));
					parent_iface_var = (g_free (parent_iface_var), NULL);
					(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
					return;
				}
			}
		}
		if (vala_method_get_base_method (m) != NULL) {
			ValaCCodeMethodBinding* binding;
			binding = vala_ccode_binding_method_binding (VALA_CCODE_BINDING (self), vala_method_get_base_method (m));
			if (!vala_ccode_method_binding_get_has_wrapper (binding)) {
				ValaCCodeExpression* _tmp16;
				ValaCCodeExpression* inst;
				ValaClass* _tmp18;
				ValaClass* base_class;
				ValaCCodeIdentifier* _tmp21;
				char* _tmp20;
				char* _tmp19;
				ValaCCodeFunctionCall* _tmp22;
				ValaCCodeFunctionCall* vclass;
				ValaCCodeMemberAccess* _tmp23;
				_tmp16 = NULL;
				inst = (_tmp16 = pub_inst, (_tmp16 == NULL ? NULL : g_object_ref (_tmp16)));
				if (vala_member_access_get_inner (expr) != NULL && !vala_expression_is_pure (vala_member_access_get_inner (expr))) {
					ValaLocalVariable* temp_var;
					ValaCCodeIdentifier* ctemp;
					ValaCCodeExpression* _tmp17;
					/* instance expression has side-effects
					 store in temp. variable*/
					temp_var = vala_ccode_generator_get_temp_variable (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_expression_get_value_type (vala_member_access_get_inner (expr)), TRUE, NULL);
					gee_list_insert (GEE_LIST (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->temp_vars), 0, temp_var);
					ctemp = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_var)));
					_tmp17 = NULL;
					inst = (_tmp17 = VALA_CCODE_EXPRESSION (vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (ctemp), pub_inst, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)), (inst == NULL ? NULL : (inst = (g_object_unref (inst), NULL))), _tmp17);
					vala_code_node_set_ccodenode (VALA_CODE_NODE (vala_member_access_get_inner (expr)), VALA_CCODE_NODE (ctemp));
					(temp_var == NULL ? NULL : (temp_var = (g_object_unref (temp_var), NULL)));
					(ctemp == NULL ? NULL : (ctemp = (g_object_unref (ctemp), NULL)));
				}
				_tmp18 = NULL;
				base_class = (_tmp18 = VALA_CLASS (vala_symbol_get_parent_symbol (VALA_SYMBOL (vala_method_get_base_method (m)))), (_tmp18 == NULL ? NULL : g_object_ref (_tmp18)));
				_tmp21 = NULL;
				_tmp20 = NULL;
				_tmp19 = NULL;
				_tmp22 = NULL;
				vclass = (_tmp22 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp21 = vala_ccode_identifier_new ((_tmp20 = g_strdup_printf ("%s_GET_CLASS", (_tmp19 = vala_typesymbol_get_upper_case_cname (VALA_TYPESYMBOL (base_class), NULL)))))))), (_tmp21 == NULL ? NULL : (_tmp21 = (g_object_unref (_tmp21), NULL))), (_tmp20 = (g_free (_tmp20), NULL)), (_tmp19 = (g_free (_tmp19), NULL)), _tmp22);
				vala_ccode_function_call_add_argument (vclass, inst);
				_tmp23 = NULL;
				vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp23 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (vclass), vala_symbol_get_name (VALA_SYMBOL (m))))));
				(_tmp23 == NULL ? NULL : (_tmp23 = (g_object_unref (_tmp23), NULL)));
				(inst == NULL ? NULL : (inst = (g_object_unref (inst), NULL)));
				(base_class == NULL ? NULL : (base_class = (g_object_unref (base_class), NULL)));
				(vclass == NULL ? NULL : (vclass = (g_object_unref (vclass), NULL)));
			} else {
				ValaCCodeIdentifier* _tmp25;
				char* _tmp24;
				_tmp25 = NULL;
				_tmp24 = NULL;
				vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp25 = vala_ccode_identifier_new ((_tmp24 = vala_method_get_cname (vala_method_get_base_method (m)))))));
				(_tmp25 == NULL ? NULL : (_tmp25 = (g_object_unref (_tmp25), NULL)));
				_tmp24 = (g_free (_tmp24), NULL);
			}
			(binding == NULL ? NULL : (binding = (g_object_unref (binding), NULL)));
		} else {
			if (vala_method_get_base_interface_method (m) != NULL) {
				ValaCCodeIdentifier* _tmp27;
				char* _tmp26;
				_tmp27 = NULL;
				_tmp26 = NULL;
				vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp27 = vala_ccode_identifier_new ((_tmp26 = vala_method_get_cname (vala_method_get_base_interface_method (m)))))));
				(_tmp27 == NULL ? NULL : (_tmp27 = (g_object_unref (_tmp27), NULL)));
				_tmp26 = (g_free (_tmp26), NULL);
			} else {
				ValaCCodeIdentifier* _tmp29;
				char* _tmp28;
				_tmp29 = NULL;
				_tmp28 = NULL;
				vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp29 = vala_ccode_identifier_new ((_tmp28 = vala_method_get_cname (m))))));
				(_tmp29 == NULL ? NULL : (_tmp29 = (g_object_unref (_tmp29), NULL)));
				_tmp28 = (g_free (_tmp28), NULL);
			}
		}
		(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
	} else {
		if (VALA_IS_ARRAY_LENGTH_FIELD (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr)))) {
			ValaCCodeExpression* _tmp30;
			_tmp30 = NULL;
			vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp30 = vala_ccode_generator_get_array_length_cexpression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_member_access_get_inner (expr), 1))));
			(_tmp30 == NULL ? NULL : (_tmp30 = (g_object_unref (_tmp30), NULL)));
		} else {
			if (VALA_IS_FIELD (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr)))) {
				ValaField* _tmp31;
				ValaField* f;
				_tmp31 = NULL;
				f = (_tmp31 = VALA_FIELD (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr))), (_tmp31 == NULL ? NULL : g_object_ref (_tmp31)));
				if (vala_field_get_binding (f) == MEMBER_BINDING_INSTANCE) {
					ValaDataType* _tmp32;
					ValaDataType* instance_expression_type;
					ValaDataType* instance_target_type;
					ValaClass* _tmp34;
					ValaTypeSymbol* _tmp33;
					ValaClass* cl;
					gboolean is_gtypeinstance;
					ValaCCodeExpression* inst;
					_tmp32 = NULL;
					instance_expression_type = (_tmp32 = base_type, (_tmp32 == NULL ? NULL : g_object_ref (_tmp32)));
					instance_target_type = vala_ccode_generator_get_data_type_for_symbol (VALA_TYPESYMBOL (vala_symbol_get_parent_symbol (VALA_SYMBOL (f))));
					_tmp34 = NULL;
					_tmp33 = NULL;
					cl = (_tmp34 = (_tmp33 = vala_data_type_get_data_type (instance_target_type), (VALA_IS_CLASS (_tmp33) ? ((ValaClass*) (_tmp33)) : NULL)), (_tmp34 == NULL ? NULL : g_object_ref (_tmp34)));
					is_gtypeinstance = (cl == NULL || !vala_class_get_is_compact (cl));
					inst = NULL;
					if (is_gtypeinstance && vala_symbol_get_access (VALA_SYMBOL (f)) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
						ValaCCodeExpression* _tmp35;
						_tmp35 = NULL;
						inst = (_tmp35 = VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (pub_inst, "priv")), (inst == NULL ? NULL : (inst = (g_object_unref (inst), NULL))), _tmp35);
					} else {
						ValaCCodeExpression* _tmp37;
						ValaCCodeExpression* _tmp36;
						_tmp37 = NULL;
						_tmp36 = NULL;
						inst = (_tmp37 = (_tmp36 = pub_inst, (_tmp36 == NULL ? NULL : g_object_ref (_tmp36))), (inst == NULL ? NULL : (inst = (g_object_unref (inst), NULL))), _tmp37);
					}
					if (vala_typesymbol_is_reference_type (vala_data_type_get_data_type (instance_target_type)) || (vala_member_access_get_inner (expr) != NULL && VALA_IS_POINTER_TYPE (vala_expression_get_value_type (vala_member_access_get_inner (expr))))) {
						ValaCCodeMemberAccess* _tmp39;
						char* _tmp38;
						_tmp39 = NULL;
						_tmp38 = NULL;
						vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp39 = vala_ccode_member_access_new_pointer (inst, (_tmp38 = vala_field_get_cname (f))))));
						(_tmp39 == NULL ? NULL : (_tmp39 = (g_object_unref (_tmp39), NULL)));
						_tmp38 = (g_free (_tmp38), NULL);
					} else {
						ValaCCodeMemberAccess* _tmp41;
						char* _tmp40;
						_tmp41 = NULL;
						_tmp40 = NULL;
						vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp41 = vala_ccode_member_access_new (inst, (_tmp40 = vala_field_get_cname (f)), FALSE))));
						(_tmp41 == NULL ? NULL : (_tmp41 = (g_object_unref (_tmp41), NULL)));
						_tmp40 = (g_free (_tmp40), NULL);
					}
					(instance_expression_type == NULL ? NULL : (instance_expression_type = (g_object_unref (instance_expression_type), NULL)));
					(instance_target_type == NULL ? NULL : (instance_target_type = (g_object_unref (instance_target_type), NULL)));
					(cl == NULL ? NULL : (cl = (g_object_unref (cl), NULL)));
					(inst == NULL ? NULL : (inst = (g_object_unref (inst), NULL)));
				} else {
					if (vala_field_get_binding (f) == MEMBER_BINDING_CLASS) {
						ValaClass* _tmp42;
						ValaClass* cl;
						ValaCCodeIdentifier* _tmp45;
						char* _tmp44;
						char* _tmp43;
						ValaCCodeFunctionCall* _tmp46;
						ValaCCodeFunctionCall* cast;
						ValaCCodeIdentifier* _tmp47;
						ValaCCodeMemberAccess* _tmp49;
						char* _tmp48;
						_tmp42 = NULL;
						cl = (_tmp42 = VALA_CLASS (vala_symbol_get_parent_symbol (VALA_SYMBOL (f))), (_tmp42 == NULL ? NULL : g_object_ref (_tmp42)));
						_tmp45 = NULL;
						_tmp44 = NULL;
						_tmp43 = NULL;
						_tmp46 = NULL;
						cast = (_tmp46 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp45 = vala_ccode_identifier_new ((_tmp44 = g_strconcat ((_tmp43 = vala_typesymbol_get_upper_case_cname (VALA_TYPESYMBOL (cl), NULL)), "_CLASS", NULL)))))), (_tmp45 == NULL ? NULL : (_tmp45 = (g_object_unref (_tmp45), NULL))), (_tmp44 = (g_free (_tmp44), NULL)), (_tmp43 = (g_free (_tmp43), NULL)), _tmp46);
						_tmp47 = NULL;
						vala_ccode_function_call_add_argument (cast, VALA_CCODE_EXPRESSION ((_tmp47 = vala_ccode_identifier_new ("klass"))));
						(_tmp47 == NULL ? NULL : (_tmp47 = (g_object_unref (_tmp47), NULL)));
						_tmp49 = NULL;
						_tmp48 = NULL;
						vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp49 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (cast), (_tmp48 = vala_field_get_cname (f))))));
						(_tmp49 == NULL ? NULL : (_tmp49 = (g_object_unref (_tmp49), NULL)));
						_tmp48 = (g_free (_tmp48), NULL);
						(cl == NULL ? NULL : (cl = (g_object_unref (cl), NULL)));
						(cast == NULL ? NULL : (cast = (g_object_unref (cast), NULL)));
					} else {
						ValaCCodeIdentifier* _tmp51;
						char* _tmp50;
						_tmp51 = NULL;
						_tmp50 = NULL;
						vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp51 = vala_ccode_identifier_new ((_tmp50 = vala_field_get_cname (f))))));
						(_tmp51 == NULL ? NULL : (_tmp51 = (g_object_unref (_tmp51), NULL)));
						_tmp50 = (g_free (_tmp50), NULL);
					}
				}
				if (vala_data_type_get_type_parameter (vala_field_get_field_type (f)) != NULL && vala_data_type_get_type_parameter (vala_expression_get_value_type (VALA_EXPRESSION (expr))) == NULL) {
					ValaCCodeExpression* _tmp52;
					_tmp52 = NULL;
					vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp52 = vala_ccode_generator_convert_from_generic_pointer (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (expr))), vala_expression_get_value_type (VALA_EXPRESSION (expr))))));
					(_tmp52 == NULL ? NULL : (_tmp52 = (g_object_unref (_tmp52), NULL)));
				}
				(f == NULL ? NULL : (f = (g_object_unref (f), NULL)));
			} else {
				if (VALA_IS_CONSTANT (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr)))) {
					ValaConstant* _tmp53;
					ValaConstant* c;
					ValaCCodeIdentifier* _tmp55;
					char* _tmp54;
					_tmp53 = NULL;
					c = (_tmp53 = VALA_CONSTANT (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr))), (_tmp53 == NULL ? NULL : g_object_ref (_tmp53)));
					_tmp55 = NULL;
					_tmp54 = NULL;
					vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp55 = vala_ccode_identifier_new ((_tmp54 = vala_constant_get_cname (c))))));
					(_tmp55 == NULL ? NULL : (_tmp55 = (g_object_unref (_tmp55), NULL)));
					_tmp54 = (g_free (_tmp54), NULL);
					(c == NULL ? NULL : (c = (g_object_unref (c), NULL)));
				} else {
					if (VALA_IS_PROPERTY (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr)))) {
						ValaProperty* _tmp56;
						ValaProperty* prop;
						_tmp56 = NULL;
						prop = (_tmp56 = VALA_PROPERTY (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr))), (_tmp56 == NULL ? NULL : g_object_ref (_tmp56)));
						if (vala_property_get_get_accessor (prop) != NULL && vala_property_accessor_get_automatic_body (vala_property_get_get_accessor (prop)) && VALA_SYMBOL (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_type_symbol) == vala_symbol_get_parent_symbol (VALA_SYMBOL (prop))) {
							ValaCCodeExpression* inst;
							ValaCCodeExpression* _tmp57;
							ValaCCodeMemberAccess* _tmp59;
							char* _tmp58;
							inst = NULL;
							_tmp57 = NULL;
							inst = (_tmp57 = VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (pub_inst, "priv")), (inst == NULL ? NULL : (inst = (g_object_unref (inst), NULL))), _tmp57);
							_tmp59 = NULL;
							_tmp58 = NULL;
							vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp59 = vala_ccode_member_access_new_pointer (inst, (_tmp58 = vala_field_get_cname (vala_property_get_field (prop)))))));
							(_tmp59 == NULL ? NULL : (_tmp59 = (g_object_unref (_tmp59), NULL)));
							_tmp58 = (g_free (_tmp58), NULL);
							(inst == NULL ? NULL : (inst = (g_object_unref (inst), NULL)));
						} else {
							if (!vala_property_get_no_accessor_method (prop)) {
								ValaProperty* _tmp60;
								ValaProperty* base_property;
								ValaTypeSymbol* _tmp65;
								ValaTypeSymbol* base_property_type;
								char* getter_cname;
								ValaCCodeIdentifier* _tmp70;
								ValaCCodeFunctionCall* _tmp71;
								ValaCCodeFunctionCall* ccall;
								_tmp60 = NULL;
								base_property = (_tmp60 = prop, (_tmp60 == NULL ? NULL : g_object_ref (_tmp60)));
								if (vala_property_get_base_property (prop) != NULL) {
									ValaProperty* _tmp62;
									ValaProperty* _tmp61;
									_tmp62 = NULL;
									_tmp61 = NULL;
									base_property = (_tmp62 = (_tmp61 = vala_property_get_base_property (prop), (_tmp61 == NULL ? NULL : g_object_ref (_tmp61))), (base_property == NULL ? NULL : (base_property = (g_object_unref (base_property), NULL))), _tmp62);
								} else {
									if (vala_property_get_base_interface_property (prop) != NULL) {
										ValaProperty* _tmp64;
										ValaProperty* _tmp63;
										_tmp64 = NULL;
										_tmp63 = NULL;
										base_property = (_tmp64 = (_tmp63 = vala_property_get_base_interface_property (prop), (_tmp63 == NULL ? NULL : g_object_ref (_tmp63))), (base_property == NULL ? NULL : (base_property = (g_object_unref (base_property), NULL))), _tmp64);
									}
								}
								_tmp65 = NULL;
								base_property_type = (_tmp65 = VALA_TYPESYMBOL (vala_symbol_get_parent_symbol (VALA_SYMBOL (base_property))), (_tmp65 == NULL ? NULL : g_object_ref (_tmp65)));
								getter_cname = NULL;
								if (VALA_IS_DYNAMIC_PROPERTY (prop)) {
									char* _tmp67;
									ValaCCodeDynamicPropertyBinding* _tmp66;
									_tmp67 = NULL;
									_tmp66 = NULL;
									getter_cname = (_tmp67 = vala_ccode_dynamic_property_binding_get_getter_cname ((_tmp66 = vala_ccode_generator_dynamic_property_binding (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), VALA_DYNAMIC_PROPERTY (prop)))), (getter_cname = (g_free (getter_cname), NULL)), _tmp67);
									(_tmp66 == NULL ? NULL : (_tmp66 = (g_object_unref (_tmp66), NULL)));
								} else {
									char* _tmp69;
									char* _tmp68;
									_tmp69 = NULL;
									_tmp68 = NULL;
									getter_cname = (_tmp69 = g_strdup_printf ("%s_get_%s", (_tmp68 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (base_property_type), NULL)), vala_symbol_get_name (VALA_SYMBOL (base_property))), (getter_cname = (g_free (getter_cname), NULL)), _tmp69);
									_tmp68 = (g_free (_tmp68), NULL);
								}
								_tmp70 = NULL;
								_tmp71 = NULL;
								ccall = (_tmp71 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp70 = vala_ccode_identifier_new (getter_cname)))), (_tmp70 == NULL ? NULL : (_tmp70 = (g_object_unref (_tmp70), NULL))), _tmp71);
								vala_ccode_function_call_add_argument (ccall, pub_inst);
								/* Property acesses to real struct types are handeled different to other properties.
								 They are returned as out parameter.*/
								if (vala_data_type_is_real_struct_type (vala_property_get_property_type (base_property))) {
									ValaCCodeCommaExpression* ccomma;
									ValaLocalVariable* temp_var;
									ValaCCodeIdentifier* ctemp;
									ValaCCodeUnaryExpression* _tmp72;
									ccomma = vala_ccode_comma_expression_new ();
									temp_var = vala_ccode_generator_get_temp_variable (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_property_get_property_type (base_property), TRUE, NULL);
									ctemp = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_var)));
									gee_collection_add (GEE_COLLECTION (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->temp_vars), temp_var);
									_tmp72 = NULL;
									vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp72 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION (ctemp)))));
									(_tmp72 == NULL ? NULL : (_tmp72 = (g_object_unref (_tmp72), NULL)));
									vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (ccall));
									vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (ctemp));
									vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccomma));
									(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
									(temp_var == NULL ? NULL : (temp_var = (g_object_unref (temp_var), NULL)));
									(ctemp == NULL ? NULL : (ctemp = (g_object_unref (ctemp), NULL)));
								} else {
									vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccall));
								}
								(base_property == NULL ? NULL : (base_property = (g_object_unref (base_property), NULL)));
								(base_property_type == NULL ? NULL : (base_property_type = (g_object_unref (base_property_type), NULL)));
								getter_cname = (g_free (getter_cname), NULL);
								(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
							} else {
								ValaCCodeIdentifier* _tmp73;
								ValaCCodeFunctionCall* _tmp74;
								ValaCCodeFunctionCall* ccall;
								ValaCCodeIdentifier* _tmp75;
								ValaCCodeFunctionCall* _tmp76;
								ValaCCodeFunctionCall* ccast;
								ValaCCodeConstant* _tmp77;
								ValaLocalVariable* temp_var;
								ValaCCodeIdentifier* ctemp;
								ValaCCodeUnaryExpression* _tmp78;
								ValaCCodeConstant* _tmp79;
								ValaCCodeCommaExpression* ccomma;
								_tmp73 = NULL;
								_tmp74 = NULL;
								ccall = (_tmp74 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp73 = vala_ccode_identifier_new ("g_object_get")))), (_tmp73 == NULL ? NULL : (_tmp73 = (g_object_unref (_tmp73), NULL))), _tmp74);
								_tmp75 = NULL;
								_tmp76 = NULL;
								ccast = (_tmp76 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp75 = vala_ccode_identifier_new ("G_OBJECT")))), (_tmp75 == NULL ? NULL : (_tmp75 = (g_object_unref (_tmp75), NULL))), _tmp76);
								vala_ccode_function_call_add_argument (ccast, pub_inst);
								vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (ccast));
								/* property name is second argument of g_object_get*/
								_tmp77 = NULL;
								vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp77 = vala_property_get_canonical_cconstant (prop))));
								(_tmp77 == NULL ? NULL : (_tmp77 = (g_object_unref (_tmp77), NULL)));
								/* we need a temporary variable to save the property value*/
								temp_var = vala_ccode_generator_get_temp_variable (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_expression_get_value_type (VALA_EXPRESSION (expr)), TRUE, NULL);
								gee_list_insert (GEE_LIST (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->temp_vars), 0, temp_var);
								ctemp = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_var)));
								_tmp78 = NULL;
								vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp78 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION (ctemp)))));
								(_tmp78 == NULL ? NULL : (_tmp78 = (g_object_unref (_tmp78), NULL)));
								_tmp79 = NULL;
								vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp79 = vala_ccode_constant_new ("NULL"))));
								(_tmp79 == NULL ? NULL : (_tmp79 = (g_object_unref (_tmp79), NULL)));
								ccomma = vala_ccode_comma_expression_new ();
								vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (ccall));
								vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (ctemp));
								vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccomma));
								(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
								(ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL)));
								(temp_var == NULL ? NULL : (temp_var = (g_object_unref (temp_var), NULL)));
								(ctemp == NULL ? NULL : (ctemp = (g_object_unref (ctemp), NULL)));
								(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
							}
						}
						(prop == NULL ? NULL : (prop = (g_object_unref (prop), NULL)));
					} else {
						if (VALA_IS_ENUM_VALUE (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr)))) {
							ValaEnumValue* _tmp80;
							ValaEnumValue* ev;
							ValaCCodeConstant* _tmp82;
							char* _tmp81;
							_tmp80 = NULL;
							ev = (_tmp80 = VALA_ENUM_VALUE (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr))), (_tmp80 == NULL ? NULL : g_object_ref (_tmp80)));
							_tmp82 = NULL;
							_tmp81 = NULL;
							vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp82 = vala_ccode_constant_new ((_tmp81 = vala_enum_value_get_cname (ev))))));
							(_tmp82 == NULL ? NULL : (_tmp82 = (g_object_unref (_tmp82), NULL)));
							_tmp81 = (g_free (_tmp81), NULL);
							(ev == NULL ? NULL : (ev = (g_object_unref (ev), NULL)));
						} else {
							if (VALA_IS_LOCAL_VARIABLE (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr)))) {
								ValaLocalVariable* _tmp83;
								ValaLocalVariable* local;
								ValaCCodeIdentifier* _tmp85;
								char* _tmp84;
								_tmp83 = NULL;
								local = (_tmp83 = VALA_LOCAL_VARIABLE (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr))), (_tmp83 == NULL ? NULL : g_object_ref (_tmp83)));
								_tmp85 = NULL;
								_tmp84 = NULL;
								vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp85 = vala_ccode_identifier_new ((_tmp84 = vala_ccode_generator_get_variable_cname (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_symbol_get_name (VALA_SYMBOL (local))))))));
								(_tmp85 == NULL ? NULL : (_tmp85 = (g_object_unref (_tmp85), NULL)));
								_tmp84 = (g_free (_tmp84), NULL);
								(local == NULL ? NULL : (local = (g_object_unref (local), NULL)));
							} else {
								if (VALA_IS_FORMAL_PARAMETER (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr)))) {
									ValaFormalParameter* _tmp86;
									ValaFormalParameter* p;
									_tmp86 = NULL;
									p = (_tmp86 = VALA_FORMAL_PARAMETER (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr))), (_tmp86 == NULL ? NULL : g_object_ref (_tmp86)));
									if (_vala_strcmp0 (vala_symbol_get_name (VALA_SYMBOL (p)), "this") == 0) {
										ValaStruct* _tmp88;
										ValaTypeSymbol* _tmp87;
										ValaStruct* st;
										_tmp88 = NULL;
										_tmp87 = NULL;
										st = (_tmp88 = (_tmp87 = vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_type_symbol, (VALA_IS_STRUCT (_tmp87) ? ((ValaStruct*) (_tmp87)) : NULL)), (_tmp88 == NULL ? NULL : g_object_ref (_tmp88)));
										if (st != NULL && !vala_struct_is_simple_type (st)) {
											ValaCCodeIdentifier* _tmp89;
											_tmp89 = NULL;
											vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp89 = vala_ccode_identifier_new ("(*self)"))));
											(_tmp89 == NULL ? NULL : (_tmp89 = (g_object_unref (_tmp89), NULL)));
										} else {
											ValaCCodeIdentifier* _tmp90;
											_tmp90 = NULL;
											vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp90 = vala_ccode_identifier_new ("self"))));
											(_tmp90 == NULL ? NULL : (_tmp90 = (g_object_unref (_tmp90), NULL)));
										}
										(st == NULL ? NULL : (st = (g_object_unref (st), NULL)));
									} else {
										ValaStruct* _tmp92;
										ValaTypeSymbol* _tmp91;
										ValaStruct* type_as_struct;
										_tmp92 = NULL;
										_tmp91 = NULL;
										type_as_struct = (_tmp92 = (_tmp91 = vala_data_type_get_data_type (vala_formal_parameter_get_parameter_type (p)), (VALA_IS_STRUCT (_tmp91) ? ((ValaStruct*) (_tmp91)) : NULL)), (_tmp92 == NULL ? NULL : g_object_ref (_tmp92)));
										if (vala_formal_parameter_get_direction (p) != VALA_PARAMETER_DIRECTION_IN || (type_as_struct != NULL && !vala_struct_is_simple_type (type_as_struct) && !vala_data_type_get_nullable (vala_formal_parameter_get_parameter_type (p)))) {
											ValaCCodeIdentifier* _tmp94;
											char* _tmp93;
											_tmp94 = NULL;
											_tmp93 = NULL;
											vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp94 = vala_ccode_identifier_new ((_tmp93 = g_strdup_printf ("(*%s)", vala_symbol_get_name (VALA_SYMBOL (p))))))));
											(_tmp94 == NULL ? NULL : (_tmp94 = (g_object_unref (_tmp94), NULL)));
											_tmp93 = (g_free (_tmp93), NULL);
										} else {
											/* Property setters of non simple structs shall replace all occurences
											 of the "value" formal parameter with a dereferencing version of that
											 parameter.*/
											if (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_property_accessor != NULL && vala_property_accessor_get_writable (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_property_accessor) && vala_property_accessor_get_value_parameter (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_property_accessor) == p && vala_data_type_is_real_struct_type (vala_property_get_property_type (vala_property_accessor_get_prop (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_property_accessor)))) {
												ValaCCodeIdentifier* _tmp95;
												_tmp95 = NULL;
												vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp95 = vala_ccode_identifier_new ("(*value)"))));
												(_tmp95 == NULL ? NULL : (_tmp95 = (g_object_unref (_tmp95), NULL)));
											} else {
												ValaCCodeIdentifier* _tmp96;
												_tmp96 = NULL;
												vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp96 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (p))))));
												(_tmp96 == NULL ? NULL : (_tmp96 = (g_object_unref (_tmp96), NULL)));
											}
										}
										(type_as_struct == NULL ? NULL : (type_as_struct = (g_object_unref (type_as_struct), NULL)));
									}
									(p == NULL ? NULL : (p = (g_object_unref (p), NULL)));
								} else {
									if (VALA_IS_SIGNAL (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr)))) {
										ValaSignal* _tmp97;
										ValaSignal* sig;
										ValaTypeSymbol* _tmp98;
										ValaTypeSymbol* cl;
										_tmp97 = NULL;
										sig = (_tmp97 = VALA_SIGNAL (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr))), (_tmp97 == NULL ? NULL : g_object_ref (_tmp97)));
										_tmp98 = NULL;
										cl = (_tmp98 = VALA_TYPESYMBOL (vala_symbol_get_parent_symbol (VALA_SYMBOL (sig))), (_tmp98 == NULL ? NULL : g_object_ref (_tmp98)));
										if (vala_signal_get_has_emitter (sig)) {
											ValaCCodeIdentifier* _tmp101;
											char* _tmp100;
											char* _tmp99;
											ValaCCodeFunctionCall* _tmp102;
											ValaCCodeFunctionCall* ccall;
											_tmp101 = NULL;
											_tmp100 = NULL;
											_tmp99 = NULL;
											_tmp102 = NULL;
											ccall = (_tmp102 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp101 = vala_ccode_identifier_new ((_tmp100 = g_strdup_printf ("%s_%s", (_tmp99 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL)), vala_symbol_get_name (VALA_SYMBOL (sig)))))))), (_tmp101 == NULL ? NULL : (_tmp101 = (g_object_unref (_tmp101), NULL))), (_tmp100 = (g_free (_tmp100), NULL)), (_tmp99 = (g_free (_tmp99), NULL)), _tmp102);
											vala_ccode_function_call_add_argument (ccall, pub_inst);
											vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccall));
											(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
										} else {
											ValaCCodeIdentifier* _tmp103;
											ValaCCodeFunctionCall* _tmp104;
											ValaCCodeFunctionCall* ccall;
											ValaCCodeIdentifier* _tmp105;
											ValaCCodeFunctionCall* _tmp106;
											ValaCCodeFunctionCall* ccast;
											ValaCCodeConstant* _tmp107;
											_tmp103 = NULL;
											_tmp104 = NULL;
											ccall = (_tmp104 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp103 = vala_ccode_identifier_new ("g_signal_emit_by_name")))), (_tmp103 == NULL ? NULL : (_tmp103 = (g_object_unref (_tmp103), NULL))), _tmp104);
											/* FIXME: use C cast if debugging disabled*/
											_tmp105 = NULL;
											_tmp106 = NULL;
											ccast = (_tmp106 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp105 = vala_ccode_identifier_new ("G_OBJECT")))), (_tmp105 == NULL ? NULL : (_tmp105 = (g_object_unref (_tmp105), NULL))), _tmp106);
											vala_ccode_function_call_add_argument (ccast, pub_inst);
											vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (ccast));
											_tmp107 = NULL;
											vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp107 = vala_signal_get_canonical_cconstant (sig))));
											(_tmp107 == NULL ? NULL : (_tmp107 = (g_object_unref (_tmp107), NULL)));
											vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccall));
											(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
											(ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL)));
										}
										(sig == NULL ? NULL : (sig = (g_object_unref (sig), NULL)));
										(cl == NULL ? NULL : (cl = (g_object_unref (cl), NULL)));
									}
								}
							}
						}
					}
				}
			}
		}
	}
}


static void vala_ccode_member_access_binding_real_emit (ValaCCodeBinding* base) {
	ValaCCodeMemberAccessBinding * self;
	ValaMemberAccess* _tmp0;
	ValaMemberAccess* expr;
	ValaCCodeExpression* pub_inst;
	ValaDataType* base_type;
	self = VALA_CCODE_MEMBER_ACCESS_BINDING (base);
	_tmp0 = NULL;
	expr = (_tmp0 = self->priv->_member_access, (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
	pub_inst = NULL;
	base_type = NULL;
	if (vala_member_access_get_inner (expr) != NULL) {
		ValaCCodeExpression* _tmp2;
		ValaCCodeExpression* _tmp1;
		_tmp2 = NULL;
		_tmp1 = NULL;
		pub_inst = (_tmp2 = (_tmp1 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_member_access_get_inner (expr)))), (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (pub_inst == NULL ? NULL : (pub_inst = (g_object_unref (pub_inst), NULL))), _tmp2);
		if (vala_expression_get_value_type (vala_member_access_get_inner (expr)) != NULL) {
			ValaDataType* _tmp4;
			ValaDataType* _tmp3;
			_tmp4 = NULL;
			_tmp3 = NULL;
			base_type = (_tmp4 = (_tmp3 = vala_expression_get_value_type (vala_member_access_get_inner (expr)), (_tmp3 == NULL ? NULL : g_object_ref (_tmp3))), (base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL))), _tmp4);
		}
	}
	vala_ccode_member_access_binding_process_cmember (self, expr, pub_inst, base_type);
	(expr == NULL ? NULL : (expr = (g_object_unref (expr), NULL)));
	(pub_inst == NULL ? NULL : (pub_inst = (g_object_unref (pub_inst), NULL)));
	(base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL)));
}


ValaMemberAccess* vala_ccode_member_access_binding_get_member_access (ValaCCodeMemberAccessBinding* self) {
	g_return_val_if_fail (VALA_IS_CCODE_MEMBER_ACCESS_BINDING (self), NULL);
	return self->priv->_member_access;
}


void vala_ccode_member_access_binding_set_member_access (ValaCCodeMemberAccessBinding* self, ValaMemberAccess* value) {
	ValaMemberAccess* _tmp2;
	ValaMemberAccess* _tmp1;
	g_return_if_fail (VALA_IS_CCODE_MEMBER_ACCESS_BINDING (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_member_access = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_member_access == NULL ? NULL : (self->priv->_member_access = (g_object_unref (self->priv->_member_access), NULL))), _tmp2);
}


static void vala_ccode_member_access_binding_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ValaCCodeMemberAccessBinding * self;
	self = VALA_CCODE_MEMBER_ACCESS_BINDING (object);
	switch (property_id) {
		case VALA_CCODE_MEMBER_ACCESS_BINDING_MEMBER_ACCESS:
		g_value_set_object (value, vala_ccode_member_access_binding_get_member_access (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_ccode_member_access_binding_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ValaCCodeMemberAccessBinding * self;
	self = VALA_CCODE_MEMBER_ACCESS_BINDING (object);
	switch (property_id) {
		case VALA_CCODE_MEMBER_ACCESS_BINDING_MEMBER_ACCESS:
		vala_ccode_member_access_binding_set_member_access (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_ccode_member_access_binding_class_init (ValaCCodeMemberAccessBindingClass * klass) {
	vala_ccode_member_access_binding_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaCCodeMemberAccessBindingPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_ccode_member_access_binding_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_ccode_member_access_binding_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_ccode_member_access_binding_dispose;
	VALA_CCODE_BINDING_CLASS (klass)->emit = vala_ccode_member_access_binding_real_emit;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CCODE_MEMBER_ACCESS_BINDING_MEMBER_ACCESS, g_param_spec_object ("member-access", "member-access", "member-access", VALA_TYPE_MEMBER_ACCESS, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_ccode_member_access_binding_instance_init (ValaCCodeMemberAccessBinding * self) {
	self->priv = VALA_CCODE_MEMBER_ACCESS_BINDING_GET_PRIVATE (self);
}


static void vala_ccode_member_access_binding_dispose (GObject * obj) {
	ValaCCodeMemberAccessBinding * self;
	self = VALA_CCODE_MEMBER_ACCESS_BINDING (obj);
	(self->priv->_member_access == NULL ? NULL : (self->priv->_member_access = (g_object_unref (self->priv->_member_access), NULL)));
	G_OBJECT_CLASS (vala_ccode_member_access_binding_parent_class)->dispose (obj);
}


GType vala_ccode_member_access_binding_get_type (void) {
	static GType vala_ccode_member_access_binding_type_id = 0;
	if (G_UNLIKELY (vala_ccode_member_access_binding_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeMemberAccessBindingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_member_access_binding_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeMemberAccessBinding), 0, (GInstanceInitFunc) vala_ccode_member_access_binding_instance_init };
		vala_ccode_member_access_binding_type_id = g_type_register_static (VALA_TYPE_CCODE_EXPRESSION_BINDING, "ValaCCodeMemberAccessBinding", &g_define_type_info, 0);
	}
	return vala_ccode_member_access_binding_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return (str1 != str2);
	}
	return strcmp (str1, str2);
}




