/* valaccodeinvocationexpressionbinding.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter, Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <gobject/valaccodeinvocationexpressionbinding.h>
#include <vala/valacodenode.h>
#include <vala/valacodevisitor.h>
#include <ccode/valaccodefunctioncall.h>
#include <ccode/valaccodeexpression.h>
#include <vala/valamethod.h>
#include <gee/list.h>
#include <vala/valamemberaccess.h>
#include <vala/valareport.h>
#include <vala/valasourcereference.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valaexpression.h>
#include <vala/valadatatype.h>
#include <vala/valamethodtype.h>
#include <vala/valasignaltype.h>
#include <gee/hashmap.h>
#include <vala/valaarrayresizemethod.h>
#include <vala/valaarraytype.h>
#include <gee/map.h>
#include <float.h>
#include <math.h>
#include <ccode/valaccodeidentifier.h>
#include <vala/valaarraymovemethod.h>
#include <vala/valamember.h>
#include <vala/valastruct.h>
#include <ccode/valaccodeunaryexpression.h>
#include <ccode/valaccodememberaccess.h>
#include <ccode/valaccodecommaexpression.h>
#include <vala/valalocalvariable.h>
#include <ccode/valaccodeassignment.h>
#include <vala/valasymbol.h>
#include <vala/valaclass.h>
#include <vala/valatypesymbol.h>
#include <vala/valadynamicmethod.h>
#include <vala/valaunaryexpression.h>
#include <vala/valaformalparameter.h>
#include <gee/iterable.h>
#include <gee/iterator.h>
#include <gee/arraylist.h>
#include <vala/valadelegatetype.h>
#include <vala/valadelegate.h>
#include <ccode/valaccodeconstant.h>
#include <vala/valanulltype.h>
#include <vala/valavoidtype.h>
#include <vala/valapointertype.h>
#include <ccode/valaccodeparenthesizedexpression.h>
#include <ccode/valaccodebinaryexpression.h>
#include <ccode/valaccodeconditionalexpression.h>
#include <gobject/valaccodebinding.h>
#include <gobject/valaccodedynamicmethodbinding.h>




struct _ValaCCodeInvocationExpressionBindingPrivate {
	ValaInvocationExpression* _invocation_expression;
};

#define VALA_CCODE_INVOCATION_EXPRESSION_BINDING_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_INVOCATION_EXPRESSION_BINDING, ValaCCodeInvocationExpressionBindingPrivate))
enum  {
	VALA_CCODE_INVOCATION_EXPRESSION_BINDING_DUMMY_PROPERTY,
	VALA_CCODE_INVOCATION_EXPRESSION_BINDING_INVOCATION_EXPRESSION
};
static void vala_ccode_invocation_expression_binding_real_emit (ValaCCodeBinding* base);
static gpointer vala_ccode_invocation_expression_binding_parent_class = NULL;
static void vala_ccode_invocation_expression_binding_dispose (GObject * obj);



ValaCCodeInvocationExpressionBinding* vala_ccode_invocation_expression_binding_new (ValaCCodeGenerator* codegen, ValaInvocationExpression* invocation_expression) {
	ValaCCodeInvocationExpressionBinding * self;
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (codegen), NULL);
	g_return_val_if_fail (VALA_IS_INVOCATION_EXPRESSION (invocation_expression), NULL);
	self = g_object_newv (VALA_TYPE_CCODE_INVOCATION_EXPRESSION_BINDING, 0, NULL);
	vala_ccode_invocation_expression_binding_set_invocation_expression (self, invocation_expression);
	vala_ccode_binding_set_codegen (VALA_CCODE_BINDING (self), codegen);
	return self;
}


static void vala_ccode_invocation_expression_binding_real_emit (ValaCCodeBinding* base) {
	ValaCCodeInvocationExpressionBinding * self;
	ValaInvocationExpression* _tmp0;
	ValaInvocationExpression* expr;
	ValaCCodeFunctionCall* ccall;
	ValaMethod* m;
	GeeList* params;
	ValaMemberAccess* _tmp1;
	ValaMemberAccess* ma;
	ValaDataType* _tmp2;
	ValaDataType* itype;
	GeeList* _tmp3;
	ValaCCodeExpression* _tmp8;
	ValaCCodeExpression* ccall_expr;
	GeeHashMap* carg_map;
	ValaCCodeExpression* instance;
	gboolean ellipsis;
	gint i;
	gint arg_pos;
	GeeIterator* params_it;
	gint last_pos;
	gint min_pos;
	self = VALA_CCODE_INVOCATION_EXPRESSION_BINDING (base);
	_tmp0 = NULL;
	expr = (_tmp0 = self->priv->_invocation_expression, (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
	vala_code_node_accept_children (VALA_CODE_NODE (expr), VALA_CODE_VISITOR (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))));
	/* the bare function call*/
	ccall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_invocation_expression_get_call (expr)))));
	m = NULL;
	params = NULL;
	if (!(VALA_IS_MEMBER_ACCESS (vala_invocation_expression_get_call (expr)))) {
		vala_code_node_set_error (VALA_CODE_NODE (expr), TRUE);
		vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (expr)), "unsupported method invocation");
		(expr == NULL ? NULL : (expr = (g_object_unref (expr), NULL)));
		(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
		(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
		(params == NULL ? NULL : (params = (g_object_unref (params), NULL)));
		return;
	}
	_tmp1 = NULL;
	ma = (_tmp1 = VALA_MEMBER_ACCESS (vala_invocation_expression_get_call (expr)), (_tmp1 == NULL ? NULL : g_object_ref (_tmp1)));
	_tmp2 = NULL;
	itype = (_tmp2 = vala_expression_get_value_type (vala_invocation_expression_get_call (expr)), (_tmp2 == NULL ? NULL : g_object_ref (_tmp2)));
	_tmp3 = NULL;
	params = (_tmp3 = vala_data_type_get_parameters (itype), (params == NULL ? NULL : (params = (g_object_unref (params), NULL))), _tmp3);
	if (VALA_IS_METHOD_TYPE (itype)) {
		ValaMethod* _tmp5;
		ValaMethod* _tmp4;
		_tmp5 = NULL;
		_tmp4 = NULL;
		m = (_tmp5 = (_tmp4 = vala_method_type_get_method_symbol ((VALA_METHOD_TYPE (itype))), (_tmp4 == NULL ? NULL : g_object_ref (_tmp4))), (m == NULL ? NULL : (m = (g_object_unref (m), NULL))), _tmp5);
	} else {
		if (VALA_IS_SIGNAL_TYPE (itype)) {
			ValaCCodeFunctionCall* _tmp7;
			ValaCCodeFunctionCall* _tmp6;
			_tmp7 = NULL;
			_tmp6 = NULL;
			ccall = (_tmp7 = (_tmp6 = VALA_CCODE_FUNCTION_CALL (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_invocation_expression_get_call (expr)))), (_tmp6 == NULL ? NULL : g_object_ref (_tmp6))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), _tmp7);
		}
	}
	/* the complete call expression, might include casts, comma expressions, and/or assignments*/
	_tmp8 = NULL;
	ccall_expr = (_tmp8 = VALA_CCODE_EXPRESSION (ccall), (_tmp8 == NULL ? NULL : g_object_ref (_tmp8)));
	carg_map = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, ((GBoxedCopyFunc) (g_object_ref)), g_object_unref, g_direct_hash, g_direct_equal, g_direct_equal);
	if (VALA_IS_ARRAY_RESIZE_METHOD (m)) {
		ValaArrayType* _tmp9;
		ValaArrayType* array_type;
		ValaCCodeIdentifier* _tmp11;
		char* _tmp10;
		_tmp9 = NULL;
		array_type = (_tmp9 = VALA_ARRAY_TYPE (vala_expression_get_value_type (vala_member_access_get_inner (ma))), (_tmp9 == NULL ? NULL : g_object_ref (_tmp9)));
		_tmp11 = NULL;
		_tmp10 = NULL;
		gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), ((double) (0)), FALSE)), VALA_CCODE_EXPRESSION ((_tmp11 = vala_ccode_identifier_new ((_tmp10 = vala_data_type_get_cname (vala_array_type_get_element_type (array_type)))))));
		(_tmp11 == NULL ? NULL : (_tmp11 = (g_object_unref (_tmp11), NULL)));
		_tmp10 = (g_free (_tmp10), NULL);
		(array_type == NULL ? NULL : (array_type = (g_object_unref (array_type), NULL)));
	} else {
		if (VALA_IS_ARRAY_MOVE_METHOD (m)) {
			vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->requires_array_move = TRUE;
		}
	}
	instance = NULL;
	if (m != NULL && vala_method_get_binding (m) == MEMBER_BINDING_INSTANCE) {
		ValaCCodeExpression* _tmp13;
		ValaCCodeExpression* _tmp12;
		ValaDataType* _tmp14;
		ValaDataType* instance_expression_type;
		_tmp13 = NULL;
		_tmp12 = NULL;
		instance = (_tmp13 = (_tmp12 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_member_access_get_inner (ma)))), (_tmp12 == NULL ? NULL : g_object_ref (_tmp12))), (instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL))), _tmp13);
		_tmp14 = NULL;
		instance_expression_type = (_tmp14 = vala_expression_get_value_type (vala_member_access_get_inner (ma)), (_tmp14 == NULL ? NULL : g_object_ref (_tmp14)));
		if (VALA_IS_STRUCT (vala_data_type_get_data_type (instance_expression_type)) && !vala_struct_is_simple_type ((VALA_STRUCT (vala_data_type_get_data_type (instance_expression_type)))) && vala_data_type_get_data_type (instance_expression_type) != vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_type_symbol) {
			ValaCCodeUnaryExpression* _tmp16;
			ValaCCodeExpression* _tmp15;
			ValaCCodeUnaryExpression* unary;
			_tmp16 = NULL;
			_tmp15 = NULL;
			unary = (_tmp16 = (_tmp15 = instance, (VALA_IS_CCODE_UNARY_EXPRESSION (_tmp15) ? ((ValaCCodeUnaryExpression*) (_tmp15)) : NULL)), (_tmp16 == NULL ? NULL : g_object_ref (_tmp16)));
			if (unary != NULL && vala_ccode_unary_expression_get_operator (unary) == VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION) {
				ValaCCodeExpression* _tmp18;
				ValaCCodeExpression* _tmp17;
				/* *expr => expr*/
				_tmp18 = NULL;
				_tmp17 = NULL;
				instance = (_tmp18 = (_tmp17 = vala_ccode_unary_expression_get_inner (unary), (_tmp17 == NULL ? NULL : g_object_ref (_tmp17))), (instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL))), _tmp18);
			} else {
				if (VALA_IS_CCODE_IDENTIFIER (instance) || VALA_IS_CCODE_MEMBER_ACCESS (instance)) {
					ValaCCodeExpression* _tmp19;
					_tmp19 = NULL;
					instance = (_tmp19 = VALA_CCODE_EXPRESSION (vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, instance)), (instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL))), _tmp19);
				} else {
					ValaCCodeCommaExpression* ccomma;
					ValaLocalVariable* temp_var;
					ValaCCodeAssignment* _tmp21;
					ValaCCodeIdentifier* _tmp20;
					ValaCCodeUnaryExpression* _tmp23;
					ValaCCodeIdentifier* _tmp22;
					ValaCCodeExpression* _tmp25;
					ValaCCodeExpression* _tmp24;
					/* if instance is e.g. a function call, we can't take the address of the expression
					 (tmp = expr, &tmp)*/
					ccomma = vala_ccode_comma_expression_new ();
					temp_var = vala_ccode_generator_get_temp_variable (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), instance_expression_type, TRUE, NULL);
					gee_list_insert (GEE_LIST (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->temp_vars), 0, temp_var);
					_tmp21 = NULL;
					_tmp20 = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp21 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp20 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_var))))), instance, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
					(_tmp21 == NULL ? NULL : (_tmp21 = (g_object_unref (_tmp21), NULL)));
					(_tmp20 == NULL ? NULL : (_tmp20 = (g_object_unref (_tmp20), NULL)));
					_tmp23 = NULL;
					_tmp22 = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp23 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp22 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_var)))))))));
					(_tmp23 == NULL ? NULL : (_tmp23 = (g_object_unref (_tmp23), NULL)));
					(_tmp22 == NULL ? NULL : (_tmp22 = (g_object_unref (_tmp22), NULL)));
					_tmp25 = NULL;
					_tmp24 = NULL;
					instance = (_tmp25 = (_tmp24 = VALA_CCODE_EXPRESSION (ccomma), (_tmp24 == NULL ? NULL : g_object_ref (_tmp24))), (instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL))), _tmp25);
					(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
					(temp_var == NULL ? NULL : (temp_var = (g_object_unref (temp_var), NULL)));
				}
			}
			(unary == NULL ? NULL : (unary = (g_object_unref (unary), NULL)));
		}
		gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_method_get_cinstance_parameter_position (m), FALSE)), instance);
		(instance_expression_type == NULL ? NULL : (instance_expression_type = (g_object_unref (instance_expression_type), NULL)));
	} else {
		if (m != NULL && vala_method_get_binding (m) == MEMBER_BINDING_CLASS) {
			ValaClass* _tmp26;
			ValaClass* cl;
			ValaCCodeIdentifier* _tmp29;
			char* _tmp28;
			char* _tmp27;
			ValaCCodeFunctionCall* _tmp30;
			ValaCCodeFunctionCall* cast;
			ValaCCodeIdentifier* _tmp31;
			_tmp26 = NULL;
			cl = (_tmp26 = VALA_CLASS (vala_symbol_get_parent_symbol (VALA_SYMBOL (m))), (_tmp26 == NULL ? NULL : g_object_ref (_tmp26)));
			_tmp29 = NULL;
			_tmp28 = NULL;
			_tmp27 = NULL;
			_tmp30 = NULL;
			cast = (_tmp30 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp29 = vala_ccode_identifier_new ((_tmp28 = g_strconcat ((_tmp27 = vala_typesymbol_get_upper_case_cname (VALA_TYPESYMBOL (cl), NULL)), "_CLASS", NULL)))))), (_tmp29 == NULL ? NULL : (_tmp29 = (g_object_unref (_tmp29), NULL))), (_tmp28 = (g_free (_tmp28), NULL)), (_tmp27 = (g_free (_tmp27), NULL)), _tmp30);
			_tmp31 = NULL;
			vala_ccode_function_call_add_argument (cast, VALA_CCODE_EXPRESSION ((_tmp31 = vala_ccode_identifier_new ("klass"))));
			(_tmp31 == NULL ? NULL : (_tmp31 = (g_object_unref (_tmp31), NULL)));
			gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_method_get_cinstance_parameter_position (m), FALSE)), VALA_CCODE_EXPRESSION (cast));
			(cl == NULL ? NULL : (cl = (g_object_unref (cl), NULL)));
			(cast == NULL ? NULL : (cast = (g_object_unref (cast), NULL)));
		}
	}
	if (VALA_IS_ARRAY_MOVE_METHOD (m)) {
		ValaArrayType* _tmp32;
		ValaArrayType* array_type;
		ValaCCodeIdentifier* _tmp33;
		ValaCCodeFunctionCall* _tmp34;
		ValaCCodeFunctionCall* csizeof;
		ValaCCodeIdentifier* _tmp36;
		char* _tmp35;
		_tmp32 = NULL;
		array_type = (_tmp32 = VALA_ARRAY_TYPE (vala_expression_get_value_type (vala_member_access_get_inner (ma))), (_tmp32 == NULL ? NULL : g_object_ref (_tmp32)));
		_tmp33 = NULL;
		_tmp34 = NULL;
		csizeof = (_tmp34 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp33 = vala_ccode_identifier_new ("sizeof")))), (_tmp33 == NULL ? NULL : (_tmp33 = (g_object_unref (_tmp33), NULL))), _tmp34);
		_tmp36 = NULL;
		_tmp35 = NULL;
		vala_ccode_function_call_add_argument (csizeof, VALA_CCODE_EXPRESSION ((_tmp36 = vala_ccode_identifier_new ((_tmp35 = vala_data_type_get_cname (vala_array_type_get_element_type (array_type)))))));
		(_tmp36 == NULL ? NULL : (_tmp36 = (g_object_unref (_tmp36), NULL)));
		_tmp35 = (g_free (_tmp35), NULL);
		gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), 0.1, FALSE)), VALA_CCODE_EXPRESSION (csizeof));
		(array_type == NULL ? NULL : (array_type = (g_object_unref (array_type), NULL)));
		(csizeof == NULL ? NULL : (csizeof = (g_object_unref (csizeof), NULL)));
	} else {
		if (VALA_IS_DYNAMIC_METHOD (m)) {
			gint param_nr;
			ValaCCodeDynamicMethodBinding* _tmp45;
			vala_method_clear_parameters (m);
			param_nr = 1;
			{
				GeeList* arg_collection;
				int arg_it;
				arg_collection = vala_invocation_expression_get_argument_list (expr);
				for (arg_it = 0; arg_it < gee_collection_get_size (GEE_COLLECTION (arg_collection)); arg_it = arg_it + 1) {
					ValaExpression* arg;
					arg = ((ValaExpression*) (gee_list_get (GEE_LIST (arg_collection), arg_it)));
					{
						ValaUnaryExpression* _tmp38;
						ValaExpression* _tmp37;
						ValaUnaryExpression* unary;
						_tmp38 = NULL;
						_tmp37 = NULL;
						unary = (_tmp38 = (_tmp37 = arg, (VALA_IS_UNARY_EXPRESSION (_tmp37) ? ((ValaUnaryExpression*) (_tmp37)) : NULL)), (_tmp38 == NULL ? NULL : g_object_ref (_tmp38)));
						if (unary != NULL && vala_unary_expression_get_operator (unary) == VALA_UNARY_OPERATOR_OUT) {
							char* _tmp39;
							ValaFormalParameter* _tmp40;
							ValaFormalParameter* param;
							/* out argument*/
							_tmp39 = NULL;
							_tmp40 = NULL;
							param = (_tmp40 = vala_formal_parameter_new ((_tmp39 = g_strdup_printf ("param%d", param_nr)), vala_expression_get_value_type (vala_unary_expression_get_inner (unary)), NULL), (_tmp39 = (g_free (_tmp39), NULL)), _tmp40);
							vala_formal_parameter_set_direction (param, VALA_PARAMETER_DIRECTION_OUT);
							vala_method_add_parameter (m, param);
							(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
						} else {
							if (unary != NULL && vala_unary_expression_get_operator (unary) == VALA_UNARY_OPERATOR_REF) {
								char* _tmp41;
								ValaFormalParameter* _tmp42;
								ValaFormalParameter* param;
								/* ref argument*/
								_tmp41 = NULL;
								_tmp42 = NULL;
								param = (_tmp42 = vala_formal_parameter_new ((_tmp41 = g_strdup_printf ("param%d", param_nr)), vala_expression_get_value_type (vala_unary_expression_get_inner (unary)), NULL), (_tmp41 = (g_free (_tmp41), NULL)), _tmp42);
								vala_formal_parameter_set_direction (param, VALA_PARAMETER_DIRECTION_REF);
								vala_method_add_parameter (m, param);
								(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
							} else {
								ValaFormalParameter* _tmp44;
								char* _tmp43;
								/* in argument*/
								_tmp44 = NULL;
								_tmp43 = NULL;
								vala_method_add_parameter (m, (_tmp44 = vala_formal_parameter_new ((_tmp43 = g_strdup_printf ("param%d", param_nr)), vala_expression_get_value_type (arg), NULL)));
								(_tmp44 == NULL ? NULL : (_tmp44 = (g_object_unref (_tmp44), NULL)));
								_tmp43 = (g_free (_tmp43), NULL);
							}
						}
						param_nr++;
						(arg == NULL ? NULL : (arg = (g_object_unref (arg), NULL)));
						(unary == NULL ? NULL : (unary = (g_object_unref (unary), NULL)));
					}
				}
				(arg_collection == NULL ? NULL : (arg_collection = (g_object_unref (arg_collection), NULL)));
			}
			{
				GeeList* param_collection;
				int param_it;
				param_collection = vala_method_get_parameters (m);
				for (param_it = 0; param_it < gee_collection_get_size (GEE_COLLECTION (param_collection)); param_it = param_it + 1) {
					ValaFormalParameter* param;
					param = ((ValaFormalParameter*) (gee_list_get (GEE_LIST (param_collection), param_it)));
					{
						vala_code_node_accept (VALA_CODE_NODE (param), VALA_CODE_VISITOR (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))));
						(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
					}
				}
				(param_collection == NULL ? NULL : (param_collection = (g_object_unref (param_collection), NULL)));
			}
			_tmp45 = NULL;
			vala_ccode_dynamic_method_binding_generate_wrapper ((_tmp45 = vala_ccode_generator_dynamic_method_binding (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), VALA_DYNAMIC_METHOD (m))));
			(_tmp45 == NULL ? NULL : (_tmp45 = (g_object_unref (_tmp45), NULL)));
		}
	}
	ellipsis = FALSE;
	i = 1;
	arg_pos = 0;
	params_it = gee_iterable_iterator (GEE_ITERABLE (params));
	{
		GeeList* arg_collection;
		int arg_it;
		arg_collection = vala_invocation_expression_get_argument_list (expr);
		for (arg_it = 0; arg_it < gee_collection_get_size (GEE_COLLECTION (arg_collection)); arg_it = arg_it + 1) {
			ValaExpression* arg;
			arg = ((ValaExpression*) (gee_list_get (GEE_LIST (arg_collection), arg_it)));
			{
				ValaCCodeExpression* _tmp46;
				ValaCCodeExpression* cexpr;
				GeeList* extra_args;
				_tmp46 = NULL;
				cexpr = (_tmp46 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (arg))), (_tmp46 == NULL ? NULL : g_object_ref (_tmp46)));
				extra_args = GEE_LIST (gee_array_list_new (VALA_TYPE_CCODE_EXPRESSION, ((GBoxedCopyFunc) (g_object_ref)), g_object_unref, g_direct_equal));
				if (gee_iterator_next (params_it)) {
					ValaFormalParameter* param;
					param = ((ValaFormalParameter*) (gee_iterator_get (params_it)));
					ellipsis = vala_formal_parameter_get_ellipsis (param);
					if (!ellipsis) {
						gboolean multiple_cargs;
						/* if the vala argument expands to multiple C arguments,
						 we have to make sure that the C arguments don't depend
						 on each other as there is no guaranteed argument
						 evaluation order
						 http://bugzilla.gnome.org/show_bug.cgi?id=519597*/
						multiple_cargs = FALSE;
						if (!vala_formal_parameter_get_no_array_length (param) && VALA_IS_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param))) {
							ValaArrayType* _tmp47;
							ValaArrayType* array_type;
							_tmp47 = NULL;
							array_type = (_tmp47 = VALA_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param)), (_tmp47 == NULL ? NULL : g_object_ref (_tmp47)));
							{
								gint dim;
								dim = 1;
								for (; dim <= vala_array_type_get_rank (array_type); dim++) {
									ValaCCodeExpression* _tmp48;
									_tmp48 = NULL;
									gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_formal_parameter_get_carray_length_parameter_position (param) + 0.01 * dim, FALSE)), (_tmp48 = vala_ccode_generator_get_array_length_cexpression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), arg, dim)));
									(_tmp48 == NULL ? NULL : (_tmp48 = (g_object_unref (_tmp48), NULL)));
								}
							}
							multiple_cargs = TRUE;
							(array_type == NULL ? NULL : (array_type = (g_object_unref (array_type), NULL)));
						} else {
							if (VALA_IS_DELEGATE_TYPE (vala_formal_parameter_get_parameter_type (param))) {
								ValaDelegateType* _tmp49;
								ValaDelegateType* deleg_type;
								ValaDelegate* _tmp50;
								ValaDelegate* d;
								_tmp49 = NULL;
								deleg_type = (_tmp49 = VALA_DELEGATE_TYPE (vala_formal_parameter_get_parameter_type (param)), (_tmp49 == NULL ? NULL : g_object_ref (_tmp49)));
								_tmp50 = NULL;
								d = (_tmp50 = vala_delegate_type_get_delegate_symbol (deleg_type), (_tmp50 == NULL ? NULL : g_object_ref (_tmp50)));
								if (vala_delegate_get_has_target (d)) {
									ValaCCodeExpression* delegate_target;
									delegate_target = vala_ccode_generator_get_delegate_target_cexpression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), arg);
									if (vala_data_type_get_value_owned (VALA_DATA_TYPE (deleg_type))) {
										ValaCCodeExpression* delegate_target_destroy_notify;
										ValaMethod* _tmp52;
										ValaSymbol* _tmp51;
										ValaMethod* delegate_method;
										ValaMemberAccess* _tmp54;
										ValaExpression* _tmp53;
										ValaMemberAccess* ma;
										delegate_target_destroy_notify = NULL;
										_tmp52 = NULL;
										_tmp51 = NULL;
										delegate_method = (_tmp52 = (_tmp51 = vala_expression_get_symbol_reference (arg), (VALA_IS_METHOD (_tmp51) ? ((ValaMethod*) (_tmp51)) : NULL)), (_tmp52 == NULL ? NULL : g_object_ref (_tmp52)));
										_tmp54 = NULL;
										_tmp53 = NULL;
										ma = (_tmp54 = (_tmp53 = arg, (VALA_IS_MEMBER_ACCESS (_tmp53) ? ((ValaMemberAccess*) (_tmp53)) : NULL)), (_tmp54 == NULL ? NULL : g_object_ref (_tmp54)));
										if (delegate_method != NULL && vala_method_get_binding (delegate_method) == MEMBER_BINDING_INSTANCE && vala_member_access_get_inner (ma) != NULL && vala_data_type_get_data_type (vala_expression_get_value_type (vala_member_access_get_inner (ma))) != NULL && vala_typesymbol_is_reference_counting (vala_data_type_get_data_type (vala_expression_get_value_type (vala_member_access_get_inner (ma))))) {
											ValaCCodeExpression* _tmp55;
											ValaCCodeFunctionCall* _tmp56;
											ValaCCodeFunctionCall* ref_call;
											ValaCCodeExpression* _tmp58;
											ValaCCodeExpression* _tmp57;
											ValaCCodeExpression* _tmp59;
											_tmp55 = NULL;
											_tmp56 = NULL;
											ref_call = (_tmp56 = vala_ccode_function_call_new ((_tmp55 = vala_ccode_generator_get_dup_func_expression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_expression_get_value_type (vala_member_access_get_inner (ma)), vala_code_node_get_source_reference (VALA_CODE_NODE (arg))))), (_tmp55 == NULL ? NULL : (_tmp55 = (g_object_unref (_tmp55), NULL))), _tmp56);
											vala_ccode_function_call_add_argument (ref_call, delegate_target);
											_tmp58 = NULL;
											_tmp57 = NULL;
											delegate_target = (_tmp58 = (_tmp57 = VALA_CCODE_EXPRESSION (ref_call), (_tmp57 == NULL ? NULL : g_object_ref (_tmp57))), (delegate_target == NULL ? NULL : (delegate_target = (g_object_unref (delegate_target), NULL))), _tmp58);
											_tmp59 = NULL;
											delegate_target_destroy_notify = (_tmp59 = vala_ccode_generator_get_destroy_func_expression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_expression_get_value_type (vala_member_access_get_inner (ma))), (delegate_target_destroy_notify == NULL ? NULL : (delegate_target_destroy_notify = (g_object_unref (delegate_target_destroy_notify), NULL))), _tmp59);
											(ref_call == NULL ? NULL : (ref_call = (g_object_unref (ref_call), NULL)));
										} else {
											ValaCCodeExpression* _tmp60;
											_tmp60 = NULL;
											delegate_target_destroy_notify = (_tmp60 = VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("NULL")), (delegate_target_destroy_notify == NULL ? NULL : (delegate_target_destroy_notify = (g_object_unref (delegate_target_destroy_notify), NULL))), _tmp60);
										}
										gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_formal_parameter_get_cdelegate_target_parameter_position (param) + 0.01, FALSE)), delegate_target_destroy_notify);
										(delegate_target_destroy_notify == NULL ? NULL : (delegate_target_destroy_notify = (g_object_unref (delegate_target_destroy_notify), NULL)));
										(delegate_method == NULL ? NULL : (delegate_method = (g_object_unref (delegate_method), NULL)));
										(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
									}
									gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_formal_parameter_get_cdelegate_target_parameter_position (param), FALSE)), delegate_target);
									multiple_cargs = TRUE;
									(delegate_target == NULL ? NULL : (delegate_target = (g_object_unref (delegate_target), NULL)));
								}
								(deleg_type == NULL ? NULL : (deleg_type = (g_object_unref (deleg_type), NULL)));
								(d == NULL ? NULL : (d = (g_object_unref (d), NULL)));
							} else {
								if (VALA_IS_METHOD_TYPE (vala_formal_parameter_get_parameter_type (param))) {
									ValaCCodeExpression* _tmp61;
									_tmp61 = NULL;
									gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_formal_parameter_get_cdelegate_target_parameter_position (param), FALSE)), (_tmp61 = vala_ccode_generator_get_delegate_target_cexpression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), arg)));
									(_tmp61 == NULL ? NULL : (_tmp61 = (g_object_unref (_tmp61), NULL)));
									multiple_cargs = TRUE;
								}
							}
						}
						/* pass non-simple struct instances always by reference*/
						if (!(VALA_IS_NULL_TYPE (vala_expression_get_value_type (arg))) && VALA_IS_STRUCT (vala_data_type_get_data_type (vala_formal_parameter_get_parameter_type (param))) && !vala_struct_is_simple_type ((VALA_STRUCT (vala_data_type_get_data_type (vala_formal_parameter_get_parameter_type (param)))))) {
							/* we already use a reference for arguments of ref, out, and nullable parameters*/
							if (vala_formal_parameter_get_direction (param) == VALA_PARAMETER_DIRECTION_IN && !vala_data_type_get_nullable (vala_formal_parameter_get_parameter_type (param))) {
								ValaCCodeUnaryExpression* _tmp63;
								ValaCCodeExpression* _tmp62;
								ValaCCodeUnaryExpression* unary;
								_tmp63 = NULL;
								_tmp62 = NULL;
								unary = (_tmp63 = (_tmp62 = cexpr, (VALA_IS_CCODE_UNARY_EXPRESSION (_tmp62) ? ((ValaCCodeUnaryExpression*) (_tmp62)) : NULL)), (_tmp63 == NULL ? NULL : g_object_ref (_tmp63)));
								if (unary != NULL && vala_ccode_unary_expression_get_operator (unary) == VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION) {
									ValaCCodeExpression* _tmp65;
									ValaCCodeExpression* _tmp64;
									/* *expr => expr*/
									_tmp65 = NULL;
									_tmp64 = NULL;
									cexpr = (_tmp65 = (_tmp64 = vala_ccode_unary_expression_get_inner (unary), (_tmp64 == NULL ? NULL : g_object_ref (_tmp64))), (cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL))), _tmp65);
								} else {
									if (VALA_IS_CCODE_IDENTIFIER (cexpr) || VALA_IS_CCODE_MEMBER_ACCESS (cexpr)) {
										ValaCCodeExpression* _tmp66;
										_tmp66 = NULL;
										cexpr = (_tmp66 = VALA_CCODE_EXPRESSION (vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, cexpr)), (cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL))), _tmp66);
									} else {
										ValaCCodeCommaExpression* ccomma;
										ValaLocalVariable* temp_var;
										ValaCCodeAssignment* _tmp68;
										ValaCCodeIdentifier* _tmp67;
										ValaCCodeUnaryExpression* _tmp70;
										ValaCCodeIdentifier* _tmp69;
										ValaCCodeExpression* _tmp72;
										ValaCCodeExpression* _tmp71;
										/* if cexpr is e.g. a function call, we can't take the address of the expression
										 (tmp = expr, &tmp)*/
										ccomma = vala_ccode_comma_expression_new ();
										temp_var = vala_ccode_generator_get_temp_variable (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_expression_get_value_type (arg), TRUE, NULL);
										gee_list_insert (GEE_LIST (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->temp_vars), 0, temp_var);
										_tmp68 = NULL;
										_tmp67 = NULL;
										vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp68 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp67 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_var))))), cexpr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
										(_tmp68 == NULL ? NULL : (_tmp68 = (g_object_unref (_tmp68), NULL)));
										(_tmp67 == NULL ? NULL : (_tmp67 = (g_object_unref (_tmp67), NULL)));
										_tmp70 = NULL;
										_tmp69 = NULL;
										vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp70 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp69 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_var)))))))));
										(_tmp70 == NULL ? NULL : (_tmp70 = (g_object_unref (_tmp70), NULL)));
										(_tmp69 == NULL ? NULL : (_tmp69 = (g_object_unref (_tmp69), NULL)));
										_tmp72 = NULL;
										_tmp71 = NULL;
										cexpr = (_tmp72 = (_tmp71 = VALA_CCODE_EXPRESSION (ccomma), (_tmp71 == NULL ? NULL : g_object_ref (_tmp71))), (cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL))), _tmp72);
										(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
										(temp_var == NULL ? NULL : (temp_var = (g_object_unref (temp_var), NULL)));
									}
								}
								(unary == NULL ? NULL : (unary = (g_object_unref (unary), NULL)));
							}
						}
						if (multiple_cargs && VALA_IS_INVOCATION_EXPRESSION (arg)) {
							ValaCCodeCommaExpression* ccomma;
							ValaLocalVariable* temp_decl;
							ValaCCodeAssignment* _tmp74;
							ValaCCodeIdentifier* _tmp73;
							ValaCCodeExpression* _tmp75;
							ValaCCodeExpression* _tmp77;
							ValaCCodeExpression* _tmp76;
							/* if vala argument is invocation expression
							 the auxiliary C argument(s) will depend on the main C argument
							 (tmp = arg1, call (tmp, arg2, arg3,...))*/
							ccomma = vala_ccode_comma_expression_new ();
							temp_decl = vala_ccode_generator_get_temp_variable (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_expression_get_value_type (arg), TRUE, NULL);
							gee_list_insert (GEE_LIST (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->temp_vars), 0, temp_decl);
							_tmp74 = NULL;
							_tmp73 = NULL;
							vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp74 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp73 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_decl))))), cexpr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
							(_tmp74 == NULL ? NULL : (_tmp74 = (g_object_unref (_tmp74), NULL)));
							(_tmp73 == NULL ? NULL : (_tmp73 = (g_object_unref (_tmp73), NULL)));
							_tmp75 = NULL;
							cexpr = (_tmp75 = VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_decl)))), (cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL))), _tmp75);
							vala_ccode_comma_expression_append_expression (ccomma, ccall_expr);
							_tmp77 = NULL;
							_tmp76 = NULL;
							ccall_expr = (_tmp77 = (_tmp76 = VALA_CCODE_EXPRESSION (ccomma), (_tmp76 == NULL ? NULL : g_object_ref (_tmp76))), (ccall_expr == NULL ? NULL : (ccall_expr = (g_object_unref (ccall_expr), NULL))), _tmp77);
							(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
							(temp_decl == NULL ? NULL : (temp_decl = (g_object_unref (temp_decl), NULL)));
						}
						/* unref old value for non-null non-weak ref/out arguments
						 disabled for arrays for now as that requires special handling
						 (ret_tmp = call (&tmp), var1 = (assign_tmp = dup (tmp), free (var1), assign_tmp), ret_tmp)*/
						if (vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_IN && vala_ccode_generator_requires_destroy (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_expression_get_value_type (arg)) && (vala_formal_parameter_get_direction (param) == VALA_PARAMETER_DIRECTION_OUT || !vala_data_type_get_value_owned (vala_formal_parameter_get_parameter_type (param))) && !(VALA_IS_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param)))) {
							ValaUnaryExpression* _tmp78;
							ValaUnaryExpression* unary;
							ValaCCodeCommaExpression* ccomma;
							ValaLocalVariable* temp_var;
							ValaCCodeExpression* _tmp80;
							ValaCCodeIdentifier* _tmp79;
							ValaLocalVariable* ret_temp_var;
							ValaCCodeCommaExpression* cassign_comma;
							ValaLocalVariable* assign_temp_var;
							ValaCCodeAssignment* _tmp91;
							ValaCCodeExpression* _tmp90;
							ValaCCodeIdentifier* _tmp89;
							ValaCCodeIdentifier* _tmp88;
							ValaCCodeExpression* _tmp92;
							ValaCCodeIdentifier* _tmp93;
							ValaCCodeAssignment* _tmp94;
							ValaCCodeExpression* _tmp97;
							ValaCCodeExpression* _tmp96;
							_tmp78 = NULL;
							unary = (_tmp78 = VALA_UNARY_EXPRESSION (arg), (_tmp78 == NULL ? NULL : g_object_ref (_tmp78)));
							ccomma = vala_ccode_comma_expression_new ();
							temp_var = vala_ccode_generator_get_temp_variable (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_formal_parameter_get_parameter_type (param), vala_data_type_get_value_owned (vala_formal_parameter_get_parameter_type (param)), NULL);
							gee_list_insert (GEE_LIST (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->temp_vars), 0, temp_var);
							_tmp80 = NULL;
							_tmp79 = NULL;
							cexpr = (_tmp80 = VALA_CCODE_EXPRESSION (vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp79 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_var))))))), (cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL))), _tmp80);
							(_tmp79 == NULL ? NULL : (_tmp79 = (g_object_unref (_tmp79), NULL)));
							if (vala_formal_parameter_get_direction (param) == VALA_PARAMETER_DIRECTION_REF) {
								ValaCCodeCommaExpression* crefcomma;
								ValaCCodeAssignment* _tmp82;
								ValaCCodeIdentifier* _tmp81;
								ValaCCodeExpression* _tmp84;
								ValaCCodeExpression* _tmp83;
								crefcomma = vala_ccode_comma_expression_new ();
								_tmp82 = NULL;
								_tmp81 = NULL;
								vala_ccode_comma_expression_append_expression (crefcomma, VALA_CCODE_EXPRESSION ((_tmp82 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp81 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_var))))), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_unary_expression_get_inner (unary)))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
								(_tmp82 == NULL ? NULL : (_tmp82 = (g_object_unref (_tmp82), NULL)));
								(_tmp81 == NULL ? NULL : (_tmp81 = (g_object_unref (_tmp81), NULL)));
								vala_ccode_comma_expression_append_expression (crefcomma, cexpr);
								_tmp84 = NULL;
								_tmp83 = NULL;
								cexpr = (_tmp84 = (_tmp83 = VALA_CCODE_EXPRESSION (crefcomma), (_tmp83 == NULL ? NULL : g_object_ref (_tmp83))), (cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL))), _tmp84);
								(crefcomma == NULL ? NULL : (crefcomma = (g_object_unref (crefcomma), NULL)));
							}
							/* call function*/
							ret_temp_var = NULL;
							if (VALA_IS_VOID_TYPE (vala_method_get_return_type (m))) {
								vala_ccode_comma_expression_append_expression (ccomma, ccall_expr);
							} else {
								ValaLocalVariable* _tmp85;
								ValaCCodeAssignment* _tmp87;
								ValaCCodeIdentifier* _tmp86;
								_tmp85 = NULL;
								ret_temp_var = (_tmp85 = vala_ccode_generator_get_temp_variable (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_method_get_return_type (m), TRUE, NULL), (ret_temp_var == NULL ? NULL : (ret_temp_var = (g_object_unref (ret_temp_var), NULL))), _tmp85);
								gee_list_insert (GEE_LIST (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->temp_vars), 0, ret_temp_var);
								_tmp87 = NULL;
								_tmp86 = NULL;
								vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp87 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp86 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (ret_temp_var))))), ccall_expr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
								(_tmp87 == NULL ? NULL : (_tmp87 = (g_object_unref (_tmp87), NULL)));
								(_tmp86 == NULL ? NULL : (_tmp86 = (g_object_unref (_tmp86), NULL)));
							}
							cassign_comma = vala_ccode_comma_expression_new ();
							assign_temp_var = vala_ccode_generator_get_temp_variable (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_expression_get_value_type (vala_unary_expression_get_inner (unary)), vala_data_type_get_value_owned (vala_expression_get_value_type (vala_unary_expression_get_inner (unary))), NULL);
							gee_list_insert (GEE_LIST (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->temp_vars), 0, assign_temp_var);
							_tmp91 = NULL;
							_tmp90 = NULL;
							_tmp89 = NULL;
							_tmp88 = NULL;
							vala_ccode_comma_expression_append_expression (cassign_comma, VALA_CCODE_EXPRESSION ((_tmp91 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp88 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (assign_temp_var))))), (_tmp90 = vala_ccode_generator_transform_expression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), VALA_CCODE_EXPRESSION ((_tmp89 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_var))))), vala_formal_parameter_get_parameter_type (param), vala_expression_get_value_type (vala_unary_expression_get_inner (unary)), arg)), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
							(_tmp91 == NULL ? NULL : (_tmp91 = (g_object_unref (_tmp91), NULL)));
							(_tmp90 == NULL ? NULL : (_tmp90 = (g_object_unref (_tmp90), NULL)));
							(_tmp89 == NULL ? NULL : (_tmp89 = (g_object_unref (_tmp89), NULL)));
							(_tmp88 == NULL ? NULL : (_tmp88 = (g_object_unref (_tmp88), NULL)));
							/* unref old value*/
							_tmp92 = NULL;
							vala_ccode_comma_expression_append_expression (cassign_comma, (_tmp92 = vala_ccode_generator_get_unref_expression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_unary_expression_get_inner (unary)))), vala_expression_get_value_type (arg), arg)));
							(_tmp92 == NULL ? NULL : (_tmp92 = (g_object_unref (_tmp92), NULL)));
							_tmp93 = NULL;
							vala_ccode_comma_expression_append_expression (cassign_comma, VALA_CCODE_EXPRESSION ((_tmp93 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (assign_temp_var))))));
							(_tmp93 == NULL ? NULL : (_tmp93 = (g_object_unref (_tmp93), NULL)));
							/* assign new value*/
							_tmp94 = NULL;
							vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp94 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_unary_expression_get_inner (unary)))), VALA_CCODE_EXPRESSION (cassign_comma), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
							(_tmp94 == NULL ? NULL : (_tmp94 = (g_object_unref (_tmp94), NULL)));
							/* return value*/
							if (!(VALA_IS_VOID_TYPE (vala_method_get_return_type (m)))) {
								ValaCCodeIdentifier* _tmp95;
								_tmp95 = NULL;
								vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp95 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (ret_temp_var))))));
								(_tmp95 == NULL ? NULL : (_tmp95 = (g_object_unref (_tmp95), NULL)));
							}
							_tmp97 = NULL;
							_tmp96 = NULL;
							ccall_expr = (_tmp97 = (_tmp96 = VALA_CCODE_EXPRESSION (ccomma), (_tmp96 == NULL ? NULL : g_object_ref (_tmp96))), (ccall_expr == NULL ? NULL : (ccall_expr = (g_object_unref (ccall_expr), NULL))), _tmp97);
							(unary == NULL ? NULL : (unary = (g_object_unref (unary), NULL)));
							(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
							(temp_var == NULL ? NULL : (temp_var = (g_object_unref (temp_var), NULL)));
							(ret_temp_var == NULL ? NULL : (ret_temp_var = (g_object_unref (ret_temp_var), NULL)));
							(cassign_comma == NULL ? NULL : (cassign_comma = (g_object_unref (cassign_comma), NULL)));
							(assign_temp_var == NULL ? NULL : (assign_temp_var = (g_object_unref (assign_temp_var), NULL)));
						}
					}
					arg_pos = vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_formal_parameter_get_cparameter_position (param), ellipsis);
					(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
				} else {
					/* default argument position*/
					arg_pos = vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), ((double) (i)), ellipsis);
				}
				gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (arg_pos), cexpr);
				i++;
				(arg == NULL ? NULL : (arg = (g_object_unref (arg), NULL)));
				(cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL)));
				(extra_args == NULL ? NULL : (extra_args = (g_object_unref (extra_args), NULL)));
			}
		}
		(arg_collection == NULL ? NULL : (arg_collection = (g_object_unref (arg_collection), NULL)));
	}
	while (gee_iterator_next (params_it)) {
		ValaFormalParameter* param;
		param = ((ValaFormalParameter*) (gee_iterator_get (params_it)));
		if (vala_formal_parameter_get_ellipsis (param)) {
			ellipsis = TRUE;
			(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
			break;
		}
		if (vala_formal_parameter_get_default_expression (param) == NULL) {
			char* _tmp98;
			_tmp98 = NULL;
			vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (expr)), (_tmp98 = g_strdup_printf ("no default expression for argument %d", i)));
			_tmp98 = (g_free (_tmp98), NULL);
			(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
			(expr == NULL ? NULL : (expr = (g_object_unref (expr), NULL)));
			(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
			(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
			(params == NULL ? NULL : (params = (g_object_unref (params), NULL)));
			(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
			(itype == NULL ? NULL : (itype = (g_object_unref (itype), NULL)));
			(ccall_expr == NULL ? NULL : (ccall_expr = (g_object_unref (ccall_expr), NULL)));
			(carg_map == NULL ? NULL : (carg_map = (g_object_unref (carg_map), NULL)));
			(instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL)));
			(params_it == NULL ? NULL : (params_it = (g_object_unref (params_it), NULL)));
			return;
		}
		/* evaluate default expression here as the code
		 * generator might not have visited the formal
		 * parameter yet */
		vala_code_node_accept (VALA_CODE_NODE (vala_formal_parameter_get_default_expression (param)), VALA_CODE_VISITOR (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))));
		if (!vala_formal_parameter_get_no_array_length (param) && vala_formal_parameter_get_parameter_type (param) != NULL && VALA_IS_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param))) {
			ValaArrayType* _tmp99;
			ValaArrayType* array_type;
			_tmp99 = NULL;
			array_type = (_tmp99 = VALA_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param)), (_tmp99 == NULL ? NULL : g_object_ref (_tmp99)));
			{
				gint dim;
				dim = 1;
				for (; dim <= vala_array_type_get_rank (array_type); dim++) {
					ValaCCodeExpression* _tmp100;
					_tmp100 = NULL;
					gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_formal_parameter_get_carray_length_parameter_position (param) + 0.01 * dim, FALSE)), (_tmp100 = vala_ccode_generator_get_array_length_cexpression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_formal_parameter_get_default_expression (param), dim)));
					(_tmp100 == NULL ? NULL : (_tmp100 = (g_object_unref (_tmp100), NULL)));
				}
			}
			(array_type == NULL ? NULL : (array_type = (g_object_unref (array_type), NULL)));
		}
		gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_formal_parameter_get_cparameter_position (param), FALSE)), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_formal_parameter_get_default_expression (param)))));
		i++;
		(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
	}
	/* add length argument for methods returning arrays */
	if (m != NULL && VALA_IS_ARRAY_TYPE (vala_method_get_return_type (m))) {
		ValaArrayType* _tmp101;
		ValaArrayType* array_type;
		_tmp101 = NULL;
		array_type = (_tmp101 = VALA_ARRAY_TYPE (vala_method_get_return_type (m)), (_tmp101 == NULL ? NULL : g_object_ref (_tmp101)));
		{
			gint dim;
			dim = 1;
			for (; dim <= vala_array_type_get_rank (array_type); dim++) {
				if (!vala_method_get_no_array_length (m)) {
					ValaLocalVariable* temp_var;
					ValaCCodeIdentifier* temp_ref;
					ValaCCodeUnaryExpression* _tmp102;
					temp_var = vala_ccode_generator_get_temp_variable (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->int_type, TRUE, NULL);
					temp_ref = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_var)));
					gee_list_insert (GEE_LIST (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->temp_vars), 0, temp_var);
					_tmp102 = NULL;
					gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_method_get_carray_length_parameter_position (m) + 0.01 * dim, FALSE)), VALA_CCODE_EXPRESSION ((_tmp102 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION (temp_ref)))));
					(_tmp102 == NULL ? NULL : (_tmp102 = (g_object_unref (_tmp102), NULL)));
					vala_invocation_expression_append_array_size (expr, VALA_CCODE_EXPRESSION (temp_ref));
					(temp_var == NULL ? NULL : (temp_var = (g_object_unref (temp_var), NULL)));
					(temp_ref == NULL ? NULL : (temp_ref = (g_object_unref (temp_ref), NULL)));
				} else {
					ValaCCodeConstant* _tmp103;
					_tmp103 = NULL;
					vala_invocation_expression_append_array_size (expr, VALA_CCODE_EXPRESSION ((_tmp103 = vala_ccode_constant_new ("-1"))));
					(_tmp103 == NULL ? NULL : (_tmp103 = (g_object_unref (_tmp103), NULL)));
				}
			}
		}
		(array_type == NULL ? NULL : (array_type = (g_object_unref (array_type), NULL)));
	} else {
		if (m != NULL && VALA_IS_DELEGATE_TYPE (vala_method_get_return_type (m))) {
			ValaDelegateType* _tmp104;
			ValaDelegateType* deleg_type;
			ValaDelegate* _tmp105;
			ValaDelegate* d;
			_tmp104 = NULL;
			deleg_type = (_tmp104 = VALA_DELEGATE_TYPE (vala_method_get_return_type (m)), (_tmp104 == NULL ? NULL : g_object_ref (_tmp104)));
			_tmp105 = NULL;
			d = (_tmp105 = vala_delegate_type_get_delegate_symbol (deleg_type), (_tmp105 == NULL ? NULL : g_object_ref (_tmp105)));
			if (vala_delegate_get_has_target (d)) {
				ValaPointerType* _tmp107;
				ValaVoidType* _tmp106;
				ValaLocalVariable* _tmp108;
				ValaLocalVariable* temp_var;
				ValaCCodeIdentifier* temp_ref;
				ValaCCodeUnaryExpression* _tmp109;
				_tmp107 = NULL;
				_tmp106 = NULL;
				_tmp108 = NULL;
				temp_var = (_tmp108 = vala_ccode_generator_get_temp_variable (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), VALA_DATA_TYPE ((_tmp107 = vala_pointer_type_new (VALA_DATA_TYPE ((_tmp106 = vala_void_type_new ())), NULL))), TRUE, NULL), (_tmp107 == NULL ? NULL : (_tmp107 = (g_object_unref (_tmp107), NULL))), (_tmp106 == NULL ? NULL : (_tmp106 = (g_object_unref (_tmp106), NULL))), _tmp108);
				temp_ref = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_var)));
				gee_list_insert (GEE_LIST (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->temp_vars), 0, temp_var);
				_tmp109 = NULL;
				gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_method_get_cdelegate_target_parameter_position (m), FALSE)), VALA_CCODE_EXPRESSION ((_tmp109 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION (temp_ref)))));
				(_tmp109 == NULL ? NULL : (_tmp109 = (g_object_unref (_tmp109), NULL)));
				vala_invocation_expression_set_delegate_target (expr, VALA_CCODE_EXPRESSION (temp_ref));
				(temp_var == NULL ? NULL : (temp_var = (g_object_unref (temp_var), NULL)));
				(temp_ref == NULL ? NULL : (temp_ref = (g_object_unref (temp_ref), NULL)));
			}
			(deleg_type == NULL ? NULL : (deleg_type = (g_object_unref (deleg_type), NULL)));
			(d == NULL ? NULL : (d = (g_object_unref (d), NULL)));
		}
	}
	if (vala_code_node_get_tree_can_fail (VALA_CODE_NODE (expr))) {
		ValaCCodeUnaryExpression* _tmp111;
		ValaCCodeIdentifier* _tmp110;
		/* method can fail*/
		vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_method_inner_error = TRUE;
		/* add &inner_error before the ellipsis arguments*/
		_tmp111 = NULL;
		_tmp110 = NULL;
		gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), ((double) (-2)), FALSE)), VALA_CCODE_EXPRESSION ((_tmp111 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp110 = vala_ccode_identifier_new ("inner_error")))))));
		(_tmp111 == NULL ? NULL : (_tmp111 = (g_object_unref (_tmp111), NULL)));
		(_tmp110 == NULL ? NULL : (_tmp110 = (g_object_unref (_tmp110), NULL)));
	}
	if (ellipsis) {
		/* ensure variable argument list ends with NULL
		 * except when using printf-style arguments */
		if ((m == NULL || !vala_method_get_printf_format (m))) {
			ValaCCodeConstant* _tmp112;
			_tmp112 = NULL;
			gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), ((double) (-1)), TRUE)), VALA_CCODE_EXPRESSION ((_tmp112 = vala_ccode_constant_new (vala_method_get_sentinel (m)))));
			(_tmp112 == NULL ? NULL : (_tmp112 = (g_object_unref (_tmp112), NULL)));
		}
	} else {
		if (VALA_IS_DELEGATE_TYPE (itype)) {
			ValaDelegateType* _tmp113;
			ValaDelegateType* deleg_type;
			ValaDelegate* _tmp114;
			ValaDelegate* d;
			_tmp113 = NULL;
			deleg_type = (_tmp113 = VALA_DELEGATE_TYPE (itype), (_tmp113 == NULL ? NULL : g_object_ref (_tmp113)));
			_tmp114 = NULL;
			d = (_tmp114 = vala_delegate_type_get_delegate_symbol (deleg_type), (_tmp114 == NULL ? NULL : g_object_ref (_tmp114)));
			if (vala_delegate_get_has_target (d)) {
				ValaCCodeExpression* _tmp115;
				_tmp115 = NULL;
				gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_delegate_get_cinstance_parameter_position (d), FALSE)), (_tmp115 = vala_ccode_generator_get_delegate_target_cexpression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_invocation_expression_get_call (expr))));
				(_tmp115 == NULL ? NULL : (_tmp115 = (g_object_unref (_tmp115), NULL)));
			}
			(deleg_type == NULL ? NULL : (deleg_type = (g_object_unref (deleg_type), NULL)));
			(d == NULL ? NULL : (d = (g_object_unref (d), NULL)));
		}
	}
	/* append C arguments in the right order*/
	last_pos = -1;
	min_pos = 0;
	while (TRUE) {
		ValaCCodeExpression* _tmp116;
		min_pos = -1;
		{
			GeeSet* pos_collection;
			GeeIterator* pos_it;
			pos_collection = gee_map_get_keys (GEE_MAP (carg_map));
			pos_it = gee_iterable_iterator (GEE_ITERABLE (pos_collection));
			while (gee_iterator_next (pos_it)) {
				gint pos;
				pos = GPOINTER_TO_INT (gee_iterator_get (pos_it));
				{
					if (pos > last_pos && (min_pos == -1 || pos < min_pos)) {
						min_pos = pos;
					}
				}
			}
			(pos_it == NULL ? NULL : (pos_it = (g_object_unref (pos_it), NULL)));
			(pos_collection == NULL ? NULL : (pos_collection = (g_object_unref (pos_collection), NULL)));
		}
		if (min_pos == -1) {
			break;
		}
		_tmp116 = NULL;
		vala_ccode_function_call_add_argument (ccall, (_tmp116 = ((ValaCCodeExpression*) (gee_map_get (GEE_MAP (carg_map), GINT_TO_POINTER (min_pos))))));
		(_tmp116 == NULL ? NULL : (_tmp116 = (g_object_unref (_tmp116), NULL)));
		last_pos = min_pos;
	}
	if (m != NULL && vala_method_get_binding (m) == MEMBER_BINDING_INSTANCE && vala_method_get_returns_modified_pointer (m)) {
		ValaCCodeAssignment* _tmp117;
		_tmp117 = NULL;
		vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp117 = vala_ccode_assignment_new (instance, ccall_expr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
		(_tmp117 == NULL ? NULL : (_tmp117 = (g_object_unref (_tmp117), NULL)));
	} else {
		/* cast pointer to actual type if this is a generic method return value */
		if (m != NULL && vala_data_type_get_type_parameter (vala_method_get_return_type (m)) != NULL && vala_data_type_get_data_type (vala_expression_get_value_type (VALA_EXPRESSION (expr))) != NULL) {
			ValaCCodeExpression* _tmp118;
			_tmp118 = NULL;
			vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp118 = vala_ccode_generator_convert_from_generic_pointer (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), ccall_expr, vala_expression_get_value_type (VALA_EXPRESSION (expr))))));
			(_tmp118 == NULL ? NULL : (_tmp118 = (g_object_unref (_tmp118), NULL)));
		} else {
			vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccall_expr));
		}
	}
	if (VALA_IS_ARRAY_RESIZE_METHOD (m)) {
		GeeList* _tmp119;
		GeeIterator* _tmp120;
		GeeIterator* arg_it;
		ValaCCodeExpression* _tmp122;
		ValaExpression* _tmp121;
		ValaCCodeExpression* _tmp123;
		ValaCCodeExpression* new_size;
		ValaLocalVariable* temp_decl;
		ValaCCodeIdentifier* temp_ref;
		ValaCCodeExpression* clen;
		ValaCCodeExpression* _tmp124;
		ValaCCodeExpression* celems;
		ValaArrayType* _tmp125;
		ValaArrayType* array_type;
		char* _tmp127;
		char* _tmp126;
		ValaCCodeIdentifier* _tmp128;
		ValaCCodeIdentifier* csizeof;
		ValaCCodeBinaryExpression* _tmp129;
		ValaCCodeParenthesizedExpression* _tmp130;
		ValaCCodeParenthesizedExpression* cdelta;
		ValaCCodeBinaryExpression* ccheck;
		ValaCCodeIdentifier* _tmp131;
		ValaCCodeFunctionCall* _tmp132;
		ValaCCodeFunctionCall* czero;
		ValaCCodeBinaryExpression* _tmp133;
		ValaCCodeConstant* _tmp134;
		ValaCCodeBinaryExpression* _tmp135;
		ValaCCodeCommaExpression* ccomma;
		ValaCCodeAssignment* _tmp136;
		ValaCCodeConditionalExpression* _tmp138;
		ValaCCodeConstant* _tmp137;
		ValaCCodeAssignment* _tmp140;
		ValaCCodeExpression* _tmp139;
		/* FIXME: size expression must not be evaluated twice at runtime (potential side effects)*/
		_tmp119 = NULL;
		_tmp120 = NULL;
		arg_it = (_tmp120 = gee_iterable_iterator (GEE_ITERABLE ((_tmp119 = vala_invocation_expression_get_argument_list (expr)))), (_tmp119 == NULL ? NULL : (_tmp119 = (g_object_unref (_tmp119), NULL))), _tmp120);
		gee_iterator_next (arg_it);
		_tmp122 = NULL;
		_tmp121 = NULL;
		_tmp123 = NULL;
		new_size = (_tmp123 = (_tmp122 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE ((_tmp121 = ((ValaExpression*) (gee_iterator_get (arg_it))))))), (_tmp122 == NULL ? NULL : g_object_ref (_tmp122))), (_tmp121 == NULL ? NULL : (_tmp121 = (g_object_unref (_tmp121), NULL))), _tmp123);
		temp_decl = vala_ccode_generator_get_temp_variable (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->int_type, TRUE, NULL);
		temp_ref = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_decl)));
		gee_list_insert (GEE_LIST (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->temp_vars), 0, temp_decl);
		/* memset needs string.h */
		vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->string_h_needed = TRUE;
		clen = vala_ccode_generator_get_array_length_cexpression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_member_access_get_inner (ma), 1);
		_tmp124 = NULL;
		celems = (_tmp124 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_member_access_get_inner (ma)))), (_tmp124 == NULL ? NULL : g_object_ref (_tmp124)));
		_tmp125 = NULL;
		array_type = (_tmp125 = VALA_ARRAY_TYPE (vala_expression_get_value_type (vala_member_access_get_inner (ma))), (_tmp125 == NULL ? NULL : g_object_ref (_tmp125)));
		_tmp127 = NULL;
		_tmp126 = NULL;
		_tmp128 = NULL;
		csizeof = (_tmp128 = vala_ccode_identifier_new ((_tmp127 = g_strdup_printf ("sizeof (%s)", (_tmp126 = vala_data_type_get_cname (vala_array_type_get_element_type (array_type)))))), (_tmp127 = (g_free (_tmp127), NULL)), (_tmp126 = (g_free (_tmp126), NULL)), _tmp128);
		_tmp129 = NULL;
		_tmp130 = NULL;
		cdelta = (_tmp130 = vala_ccode_parenthesized_expression_new (VALA_CCODE_EXPRESSION ((_tmp129 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MINUS, VALA_CCODE_EXPRESSION (temp_ref), clen)))), (_tmp129 == NULL ? NULL : (_tmp129 = (g_object_unref (_tmp129), NULL))), _tmp130);
		ccheck = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_GREATER_THAN, VALA_CCODE_EXPRESSION (temp_ref), clen);
		_tmp131 = NULL;
		_tmp132 = NULL;
		czero = (_tmp132 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp131 = vala_ccode_identifier_new ("memset")))), (_tmp131 == NULL ? NULL : (_tmp131 = (g_object_unref (_tmp131), NULL))), _tmp132);
		_tmp133 = NULL;
		vala_ccode_function_call_add_argument (czero, VALA_CCODE_EXPRESSION ((_tmp133 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, celems, clen))));
		(_tmp133 == NULL ? NULL : (_tmp133 = (g_object_unref (_tmp133), NULL)));
		_tmp134 = NULL;
		vala_ccode_function_call_add_argument (czero, VALA_CCODE_EXPRESSION ((_tmp134 = vala_ccode_constant_new ("0"))));
		(_tmp134 == NULL ? NULL : (_tmp134 = (g_object_unref (_tmp134), NULL)));
		_tmp135 = NULL;
		vala_ccode_function_call_add_argument (czero, VALA_CCODE_EXPRESSION ((_tmp135 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, VALA_CCODE_EXPRESSION (csizeof), VALA_CCODE_EXPRESSION (cdelta)))));
		(_tmp135 == NULL ? NULL : (_tmp135 = (g_object_unref (_tmp135), NULL)));
		ccomma = vala_ccode_comma_expression_new ();
		_tmp136 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp136 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (temp_ref), new_size, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
		(_tmp136 == NULL ? NULL : (_tmp136 = (g_object_unref (_tmp136), NULL)));
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (expr))));
		_tmp138 = NULL;
		_tmp137 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp138 = vala_ccode_conditional_expression_new (VALA_CCODE_EXPRESSION (ccheck), VALA_CCODE_EXPRESSION (czero), VALA_CCODE_EXPRESSION ((_tmp137 = vala_ccode_constant_new ("NULL")))))));
		(_tmp138 == NULL ? NULL : (_tmp138 = (g_object_unref (_tmp138), NULL)));
		(_tmp137 == NULL ? NULL : (_tmp137 = (g_object_unref (_tmp137), NULL)));
		_tmp140 = NULL;
		_tmp139 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp140 = vala_ccode_assignment_new ((_tmp139 = vala_ccode_generator_get_array_length_cexpression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_member_access_get_inner (ma), 1)), VALA_CCODE_EXPRESSION (temp_ref), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
		(_tmp140 == NULL ? NULL : (_tmp140 = (g_object_unref (_tmp140), NULL)));
		(_tmp139 == NULL ? NULL : (_tmp139 = (g_object_unref (_tmp139), NULL)));
		vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccomma));
		(arg_it == NULL ? NULL : (arg_it = (g_object_unref (arg_it), NULL)));
		(new_size == NULL ? NULL : (new_size = (g_object_unref (new_size), NULL)));
		(temp_decl == NULL ? NULL : (temp_decl = (g_object_unref (temp_decl), NULL)));
		(temp_ref == NULL ? NULL : (temp_ref = (g_object_unref (temp_ref), NULL)));
		(clen == NULL ? NULL : (clen = (g_object_unref (clen), NULL)));
		(celems == NULL ? NULL : (celems = (g_object_unref (celems), NULL)));
		(array_type == NULL ? NULL : (array_type = (g_object_unref (array_type), NULL)));
		(csizeof == NULL ? NULL : (csizeof = (g_object_unref (csizeof), NULL)));
		(cdelta == NULL ? NULL : (cdelta = (g_object_unref (cdelta), NULL)));
		(ccheck == NULL ? NULL : (ccheck = (g_object_unref (ccheck), NULL)));
		(czero == NULL ? NULL : (czero = (g_object_unref (czero), NULL)));
		(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
	} else {
		if (m == vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->substring_method) {
			ValaLocalVariable* temp_decl;
			ValaCCodeIdentifier* temp_ref;
			GeeList* args;
			ValaCCodeIdentifier* _tmp141;
			ValaCCodeFunctionCall* _tmp142;
			ValaCCodeFunctionCall* coffsetcall;
			ValaCCodeExpression* _tmp143;
			ValaCCodeExpression* _tmp144;
			ValaCCodeIdentifier* _tmp145;
			ValaCCodeFunctionCall* _tmp146;
			ValaCCodeFunctionCall* coffsetcall2;
			ValaCCodeExpression* _tmp147;
			ValaCCodeIdentifier* _tmp148;
			ValaCCodeFunctionCall* _tmp149;
			ValaCCodeFunctionCall* cndupcall;
			ValaCCodeBinaryExpression* _tmp150;
			ValaCCodeCommaExpression* ccomma;
			ValaCCodeAssignment* _tmp151;
			temp_decl = vala_ccode_generator_get_temp_variable (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->string_type, TRUE, NULL);
			temp_ref = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_decl)));
			gee_list_insert (GEE_LIST (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->temp_vars), 0, temp_decl);
			args = vala_ccode_function_call_get_arguments (ccall);
			_tmp141 = NULL;
			_tmp142 = NULL;
			coffsetcall = (_tmp142 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp141 = vala_ccode_identifier_new ("g_utf8_offset_to_pointer")))), (_tmp141 == NULL ? NULL : (_tmp141 = (g_object_unref (_tmp141), NULL))), _tmp142);
			/* full string*/
			_tmp143 = NULL;
			vala_ccode_function_call_add_argument (coffsetcall, (_tmp143 = ((ValaCCodeExpression*) (gee_list_get (((GeeList*) (args)), 0)))));
			(_tmp143 == NULL ? NULL : (_tmp143 = (g_object_unref (_tmp143), NULL)));
			/* offset*/
			_tmp144 = NULL;
			vala_ccode_function_call_add_argument (coffsetcall, (_tmp144 = ((ValaCCodeExpression*) (gee_list_get (((GeeList*) (args)), 1)))));
			(_tmp144 == NULL ? NULL : (_tmp144 = (g_object_unref (_tmp144), NULL)));
			_tmp145 = NULL;
			_tmp146 = NULL;
			coffsetcall2 = (_tmp146 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp145 = vala_ccode_identifier_new ("g_utf8_offset_to_pointer")))), (_tmp145 == NULL ? NULL : (_tmp145 = (g_object_unref (_tmp145), NULL))), _tmp146);
			vala_ccode_function_call_add_argument (coffsetcall2, VALA_CCODE_EXPRESSION (temp_ref));
			/* len*/
			_tmp147 = NULL;
			vala_ccode_function_call_add_argument (coffsetcall2, (_tmp147 = ((ValaCCodeExpression*) (gee_list_get (((GeeList*) (args)), 2)))));
			(_tmp147 == NULL ? NULL : (_tmp147 = (g_object_unref (_tmp147), NULL)));
			_tmp148 = NULL;
			_tmp149 = NULL;
			cndupcall = (_tmp149 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp148 = vala_ccode_identifier_new ("g_strndup")))), (_tmp148 == NULL ? NULL : (_tmp148 = (g_object_unref (_tmp148), NULL))), _tmp149);
			vala_ccode_function_call_add_argument (cndupcall, VALA_CCODE_EXPRESSION (temp_ref));
			_tmp150 = NULL;
			vala_ccode_function_call_add_argument (cndupcall, VALA_CCODE_EXPRESSION ((_tmp150 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MINUS, VALA_CCODE_EXPRESSION (coffsetcall2), VALA_CCODE_EXPRESSION (temp_ref)))));
			(_tmp150 == NULL ? NULL : (_tmp150 = (g_object_unref (_tmp150), NULL)));
			ccomma = vala_ccode_comma_expression_new ();
			_tmp151 = NULL;
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp151 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (temp_ref), VALA_CCODE_EXPRESSION (coffsetcall), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
			(_tmp151 == NULL ? NULL : (_tmp151 = (g_object_unref (_tmp151), NULL)));
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (cndupcall));
			vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccomma));
			(temp_decl == NULL ? NULL : (temp_decl = (g_object_unref (temp_decl), NULL)));
			(temp_ref == NULL ? NULL : (temp_ref = (g_object_unref (temp_ref), NULL)));
			(args == NULL ? NULL : (args = (g_object_unref (args), NULL)));
			(coffsetcall == NULL ? NULL : (coffsetcall = (g_object_unref (coffsetcall), NULL)));
			(coffsetcall2 == NULL ? NULL : (coffsetcall2 = (g_object_unref (coffsetcall2), NULL)));
			(cndupcall == NULL ? NULL : (cndupcall = (g_object_unref (cndupcall), NULL)));
			(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
		}
	}
	(expr == NULL ? NULL : (expr = (g_object_unref (expr), NULL)));
	(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
	(params == NULL ? NULL : (params = (g_object_unref (params), NULL)));
	(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
	(itype == NULL ? NULL : (itype = (g_object_unref (itype), NULL)));
	(ccall_expr == NULL ? NULL : (ccall_expr = (g_object_unref (ccall_expr), NULL)));
	(carg_map == NULL ? NULL : (carg_map = (g_object_unref (carg_map), NULL)));
	(instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL)));
	(params_it == NULL ? NULL : (params_it = (g_object_unref (params_it), NULL)));
}


ValaInvocationExpression* vala_ccode_invocation_expression_binding_get_invocation_expression (ValaCCodeInvocationExpressionBinding* self) {
	g_return_val_if_fail (VALA_IS_CCODE_INVOCATION_EXPRESSION_BINDING (self), NULL);
	return self->priv->_invocation_expression;
}


void vala_ccode_invocation_expression_binding_set_invocation_expression (ValaCCodeInvocationExpressionBinding* self, ValaInvocationExpression* value) {
	ValaInvocationExpression* _tmp2;
	ValaInvocationExpression* _tmp1;
	g_return_if_fail (VALA_IS_CCODE_INVOCATION_EXPRESSION_BINDING (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_invocation_expression = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_invocation_expression == NULL ? NULL : (self->priv->_invocation_expression = (g_object_unref (self->priv->_invocation_expression), NULL))), _tmp2);
}


static void vala_ccode_invocation_expression_binding_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ValaCCodeInvocationExpressionBinding * self;
	self = VALA_CCODE_INVOCATION_EXPRESSION_BINDING (object);
	switch (property_id) {
		case VALA_CCODE_INVOCATION_EXPRESSION_BINDING_INVOCATION_EXPRESSION:
		g_value_set_object (value, vala_ccode_invocation_expression_binding_get_invocation_expression (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_ccode_invocation_expression_binding_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ValaCCodeInvocationExpressionBinding * self;
	self = VALA_CCODE_INVOCATION_EXPRESSION_BINDING (object);
	switch (property_id) {
		case VALA_CCODE_INVOCATION_EXPRESSION_BINDING_INVOCATION_EXPRESSION:
		vala_ccode_invocation_expression_binding_set_invocation_expression (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_ccode_invocation_expression_binding_class_init (ValaCCodeInvocationExpressionBindingClass * klass) {
	vala_ccode_invocation_expression_binding_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaCCodeInvocationExpressionBindingPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_ccode_invocation_expression_binding_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_ccode_invocation_expression_binding_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_ccode_invocation_expression_binding_dispose;
	VALA_CCODE_BINDING_CLASS (klass)->emit = vala_ccode_invocation_expression_binding_real_emit;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CCODE_INVOCATION_EXPRESSION_BINDING_INVOCATION_EXPRESSION, g_param_spec_object ("invocation-expression", "invocation-expression", "invocation-expression", VALA_TYPE_INVOCATION_EXPRESSION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_ccode_invocation_expression_binding_instance_init (ValaCCodeInvocationExpressionBinding * self) {
	self->priv = VALA_CCODE_INVOCATION_EXPRESSION_BINDING_GET_PRIVATE (self);
}


static void vala_ccode_invocation_expression_binding_dispose (GObject * obj) {
	ValaCCodeInvocationExpressionBinding * self;
	self = VALA_CCODE_INVOCATION_EXPRESSION_BINDING (obj);
	(self->priv->_invocation_expression == NULL ? NULL : (self->priv->_invocation_expression = (g_object_unref (self->priv->_invocation_expression), NULL)));
	G_OBJECT_CLASS (vala_ccode_invocation_expression_binding_parent_class)->dispose (obj);
}


GType vala_ccode_invocation_expression_binding_get_type (void) {
	static GType vala_ccode_invocation_expression_binding_type_id = 0;
	if (G_UNLIKELY (vala_ccode_invocation_expression_binding_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeInvocationExpressionBindingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_invocation_expression_binding_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeInvocationExpressionBinding), 0, (GInstanceInitFunc) vala_ccode_invocation_expression_binding_instance_init };
		vala_ccode_invocation_expression_binding_type_id = g_type_register_static (VALA_TYPE_CCODE_EXPRESSION_BINDING, "ValaCCodeInvocationExpressionBinding", &g_define_type_info, 0);
	}
	return vala_ccode_invocation_expression_binding_type_id;
}




