/* valaccodeclassbinding.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter, Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <gobject/valaccodeclassbinding.h>
#include <vala/valasymbol.h>
#include <vala/valatypesymbol.h>
#include <ccode/valaccodestruct.h>
#include <ccode/valaccodeenum.h>
#include <ccode/valaccodefragment.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valacodenode.h>
#include <vala/valareport.h>
#include <vala/valasourcereference.h>
#include <ccode/valaccodeenumvalue.h>
#include <ccode/valaccodeexpression.h>
#include <ccode/valaccodenewline.h>
#include <ccode/valaccodenode.h>
#include <ccode/valaccodemacroreplacement.h>
#include <vala/valasourcefile.h>
#include <ccode/valaccodetypedefinition.h>
#include <ccode/valaccodevariabledeclarator.h>
#include <ccode/valaccodedeclarator.h>
#include <gee/collection.h>
#include <ccode/valaccodecomment.h>
#include <vala/valacodevisitor.h>
#include <ccode/valaccodeassignment.h>
#include <ccode/valaccodememberaccess.h>
#include <ccode/valaccodeidentifier.h>
#include <ccode/valaccodeconstant.h>
#include <ccode/valaccodeexpressionstatement.h>
#include <vala/valadatatype.h>
#include <vala/valainterface.h>
#include <ccode/valaccodefunctioncall.h>
#include <ccode/valaccodefunction.h>
#include <ccode/valaccodemodifiers.h>
#include <ccode/valaccodeformalparameter.h>
#include <ccode/valaccodeblock.h>
#include <ccode/valaccodedeclaration.h>
#include <ccode/valaccodeunaryexpression.h>
#include <ccode/valaccodereturnstatement.h>
#include <ccode/valaccodecastexpression.h>
#include <ccode/valaccodeifstatement.h>
#include <ccode/valaccodestatement.h>
#include <vala/valadestructor.h>
#include <vala/valaobjecttypesymbol.h>
#include <vala/valamethod.h>
#include <vala/valatypeparameter.h>
#include <gee/list.h>
#include <vala/valaproperty.h>
#include <vala/valasignal.h>
#include <vala/valainstancecast.h>
#include <ccode/valaccodeswitchstatement.h>
#include <ccode/valaccodecasestatement.h>
#include <ccode/valaccodebreakstatement.h>
#include <gobject/valaccodebinding.h>
#include <gobject/valaclassregisterfunction.h>
#include <gobject/valatyperegisterfunction.h>
#include <gobject/valaccodetypesymbolbinding.h>




struct _ValaCCodeClassBindingPrivate {
	ValaClass* _cl;
};

#define VALA_CCODE_CLASS_BINDING_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_CLASS_BINDING, ValaCCodeClassBindingPrivate))
enum  {
	VALA_CCODE_CLASS_BINDING_DUMMY_PROPERTY,
	VALA_CCODE_CLASS_BINDING_CL
};
static void vala_ccode_class_binding_real_emit (ValaCCodeBinding* base);
static void vala_ccode_class_binding_add_class_init_function (ValaCCodeClassBinding* self, ValaClass* cl);
static void vala_ccode_class_binding_add_interface_init_function (ValaCCodeClassBinding* self, ValaClass* cl, ValaInterface* iface);
static void vala_ccode_class_binding_add_instance_init_function (ValaCCodeClassBinding* self, ValaClass* cl);
static void vala_ccode_class_binding_add_dispose_function (ValaCCodeClassBinding* self, ValaClass* cl);
static gboolean vala_ccode_class_binding_class_has_readable_properties (ValaCCodeClassBinding* self, ValaClass* cl);
static gboolean vala_ccode_class_binding_class_has_writable_properties (ValaCCodeClassBinding* self, ValaClass* cl);
static void vala_ccode_class_binding_add_get_property_function (ValaCCodeClassBinding* self, ValaClass* cl);
static void vala_ccode_class_binding_add_set_property_function (ValaCCodeClassBinding* self, ValaClass* cl);
static ValaCCodeStatement* vala_ccode_class_binding_get_invalid_property_id_warn_statement (ValaCCodeClassBinding* self);
static gpointer vala_ccode_class_binding_parent_class = NULL;
static void vala_ccode_class_binding_dispose (GObject * obj);



ValaCCodeClassBinding* vala_ccode_class_binding_new (ValaCCodeGenerator* codegen, ValaClass* cl) {
	ValaCCodeClassBinding * self;
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (codegen), NULL);
	g_return_val_if_fail (VALA_IS_CLASS (cl), NULL);
	self = g_object_newv (VALA_TYPE_CCODE_CLASS_BINDING, 0, NULL);
	vala_ccode_class_binding_set_cl (self, cl);
	vala_ccode_binding_set_codegen (VALA_CCODE_BINDING (self), codegen);
	return self;
}


static void vala_ccode_class_binding_real_emit (ValaCCodeBinding* base) {
	ValaCCodeClassBinding * self;
	ValaSymbol* _tmp0;
	ValaSymbol* old_symbol;
	ValaTypeSymbol* _tmp1;
	ValaTypeSymbol* old_type_symbol;
	ValaClass* _tmp2;
	ValaClass* old_class;
	ValaCCodeStruct* _tmp3;
	ValaCCodeStruct* old_instance_struct;
	ValaCCodeStruct* _tmp4;
	ValaCCodeStruct* old_type_struct;
	ValaCCodeStruct* _tmp5;
	ValaCCodeStruct* old_instance_priv_struct;
	ValaCCodeEnum* _tmp6;
	ValaCCodeEnum* old_prop_enum;
	ValaCCodeFragment* _tmp7;
	ValaCCodeFragment* old_class_init_fragment;
	ValaCCodeFragment* _tmp8;
	ValaCCodeFragment* old_instance_init_fragment;
	ValaCCodeFragment* _tmp9;
	ValaCCodeFragment* old_instance_dispose_fragment;
	ValaSymbol* _tmp11;
	ValaSymbol* _tmp10;
	ValaTypeSymbol* _tmp13;
	ValaTypeSymbol* _tmp12;
	ValaClass* _tmp15;
	ValaClass* _tmp14;
	gboolean is_gtypeinstance;
	gboolean is_gobject;
	gboolean is_fundamental;
	char* _tmp16;
	gboolean _tmp17;
	ValaCCodeFragment* decl_frag;
	ValaCCodeFragment* def_frag;
	GeeList* _tmp83;
	gboolean _tmp84;
	ValaTypeSymbol* _tmp185;
	ValaTypeSymbol* _tmp184;
	ValaClass* _tmp187;
	ValaClass* _tmp186;
	ValaCCodeStruct* _tmp189;
	ValaCCodeStruct* _tmp188;
	ValaCCodeStruct* _tmp191;
	ValaCCodeStruct* _tmp190;
	ValaCCodeStruct* _tmp193;
	ValaCCodeStruct* _tmp192;
	ValaCCodeEnum* _tmp195;
	ValaCCodeEnum* _tmp194;
	ValaCCodeFragment* _tmp197;
	ValaCCodeFragment* _tmp196;
	ValaCCodeFragment* _tmp199;
	ValaCCodeFragment* _tmp198;
	ValaCCodeFragment* _tmp201;
	ValaCCodeFragment* _tmp200;
	self = VALA_CCODE_CLASS_BINDING (base);
	_tmp0 = NULL;
	old_symbol = (_tmp0 = vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_symbol, (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
	_tmp1 = NULL;
	old_type_symbol = (_tmp1 = vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_type_symbol, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1)));
	_tmp2 = NULL;
	old_class = (_tmp2 = vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_class, (_tmp2 == NULL ? NULL : g_object_ref (_tmp2)));
	_tmp3 = NULL;
	old_instance_struct = (_tmp3 = vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_struct, (_tmp3 == NULL ? NULL : g_object_ref (_tmp3)));
	_tmp4 = NULL;
	old_type_struct = (_tmp4 = vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->type_struct, (_tmp4 == NULL ? NULL : g_object_ref (_tmp4)));
	_tmp5 = NULL;
	old_instance_priv_struct = (_tmp5 = vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_priv_struct, (_tmp5 == NULL ? NULL : g_object_ref (_tmp5)));
	_tmp6 = NULL;
	old_prop_enum = (_tmp6 = vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->prop_enum, (_tmp6 == NULL ? NULL : g_object_ref (_tmp6)));
	_tmp7 = NULL;
	old_class_init_fragment = (_tmp7 = vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->class_init_fragment, (_tmp7 == NULL ? NULL : g_object_ref (_tmp7)));
	_tmp8 = NULL;
	old_instance_init_fragment = (_tmp8 = vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_init_fragment, (_tmp8 == NULL ? NULL : g_object_ref (_tmp8)));
	_tmp9 = NULL;
	old_instance_dispose_fragment = (_tmp9 = vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_dispose_fragment, (_tmp9 == NULL ? NULL : g_object_ref (_tmp9)));
	_tmp11 = NULL;
	_tmp10 = NULL;
	vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_symbol = (_tmp11 = (_tmp10 = VALA_SYMBOL (self->priv->_cl), (_tmp10 == NULL ? NULL : g_object_ref (_tmp10))), (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_symbol == NULL ? NULL : (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_symbol = (g_object_unref (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_symbol), NULL))), _tmp11);
	_tmp13 = NULL;
	_tmp12 = NULL;
	vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_type_symbol = (_tmp13 = (_tmp12 = VALA_TYPESYMBOL (self->priv->_cl), (_tmp12 == NULL ? NULL : g_object_ref (_tmp12))), (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_type_symbol == NULL ? NULL : (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_type_symbol = (g_object_unref (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_type_symbol), NULL))), _tmp13);
	_tmp15 = NULL;
	_tmp14 = NULL;
	vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_class = (_tmp15 = (_tmp14 = self->priv->_cl, (_tmp14 == NULL ? NULL : g_object_ref (_tmp14))), (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_class == NULL ? NULL : (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_class = (g_object_unref (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_class), NULL))), _tmp15);
	is_gtypeinstance = !vala_class_get_is_compact (self->priv->_cl) && !vala_class_get_is_static (self->priv->_cl);
	is_gobject = vala_typesymbol_is_subtype_of (VALA_TYPESYMBOL (self->priv->_cl), vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->gobject_type);
	is_fundamental = is_gtypeinstance && vala_class_get_base_class (self->priv->_cl) == NULL;
	_tmp16 = NULL;
	if ((_tmp17 = g_utf8_strlen ((_tmp16 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (self->priv->_cl), FALSE)), -1) < 3, (_tmp16 = (g_free (_tmp16), NULL)), _tmp17)) {
		char* _tmp19;
		char* _tmp18;
		vala_code_node_set_error (VALA_CODE_NODE (self->priv->_cl), TRUE);
		_tmp19 = NULL;
		_tmp18 = NULL;
		vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (self->priv->_cl)), (_tmp19 = g_strdup_printf ("Class name `%s' is too short", (_tmp18 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (self->priv->_cl), FALSE)))));
		_tmp19 = (g_free (_tmp19), NULL);
		_tmp18 = (g_free (_tmp18), NULL);
		(old_symbol == NULL ? NULL : (old_symbol = (g_object_unref (old_symbol), NULL)));
		(old_type_symbol == NULL ? NULL : (old_type_symbol = (g_object_unref (old_type_symbol), NULL)));
		(old_class == NULL ? NULL : (old_class = (g_object_unref (old_class), NULL)));
		(old_instance_struct == NULL ? NULL : (old_instance_struct = (g_object_unref (old_instance_struct), NULL)));
		(old_type_struct == NULL ? NULL : (old_type_struct = (g_object_unref (old_type_struct), NULL)));
		(old_instance_priv_struct == NULL ? NULL : (old_instance_priv_struct = (g_object_unref (old_instance_priv_struct), NULL)));
		(old_prop_enum == NULL ? NULL : (old_prop_enum = (g_object_unref (old_prop_enum), NULL)));
		(old_class_init_fragment == NULL ? NULL : (old_class_init_fragment = (g_object_unref (old_class_init_fragment), NULL)));
		(old_instance_init_fragment == NULL ? NULL : (old_instance_init_fragment = (g_object_unref (old_instance_init_fragment), NULL)));
		(old_instance_dispose_fragment == NULL ? NULL : (old_instance_dispose_fragment = (g_object_unref (old_instance_dispose_fragment), NULL)));
		return;
	}
	if (!vala_class_get_is_static (self->priv->_cl)) {
		ValaCCodeStruct* _tmp22;
		char* _tmp21;
		char* _tmp20;
		ValaCCodeStruct* _tmp25;
		char* _tmp24;
		char* _tmp23;
		ValaCCodeStruct* _tmp28;
		char* _tmp27;
		char* _tmp26;
		ValaCCodeEnum* _tmp29;
		ValaCCodeEnumValue* _tmp32;
		char* _tmp31;
		char* _tmp30;
		ValaCCodeFragment* _tmp33;
		ValaCCodeFragment* _tmp34;
		ValaCCodeFragment* _tmp35;
		_tmp22 = NULL;
		_tmp21 = NULL;
		_tmp20 = NULL;
		vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_struct = (_tmp22 = vala_ccode_struct_new ((_tmp21 = g_strdup_printf ("_%s", (_tmp20 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (self->priv->_cl), FALSE))))), (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_struct == NULL ? NULL : (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_struct = (g_object_unref (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_struct), NULL))), _tmp22);
		_tmp21 = (g_free (_tmp21), NULL);
		_tmp20 = (g_free (_tmp20), NULL);
		_tmp25 = NULL;
		_tmp24 = NULL;
		_tmp23 = NULL;
		vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->type_struct = (_tmp25 = vala_ccode_struct_new ((_tmp24 = g_strdup_printf ("_%sClass", (_tmp23 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (self->priv->_cl), FALSE))))), (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->type_struct == NULL ? NULL : (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->type_struct = (g_object_unref (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->type_struct), NULL))), _tmp25);
		_tmp24 = (g_free (_tmp24), NULL);
		_tmp23 = (g_free (_tmp23), NULL);
		_tmp28 = NULL;
		_tmp27 = NULL;
		_tmp26 = NULL;
		vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_priv_struct = (_tmp28 = vala_ccode_struct_new ((_tmp27 = g_strdup_printf ("_%sPrivate", (_tmp26 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (self->priv->_cl), FALSE))))), (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_priv_struct == NULL ? NULL : (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_priv_struct = (g_object_unref (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_priv_struct), NULL))), _tmp28);
		_tmp27 = (g_free (_tmp27), NULL);
		_tmp26 = (g_free (_tmp26), NULL);
		_tmp29 = NULL;
		vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->prop_enum = (_tmp29 = vala_ccode_enum_new (NULL), (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->prop_enum == NULL ? NULL : (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->prop_enum = (g_object_unref (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->prop_enum), NULL))), _tmp29);
		_tmp32 = NULL;
		_tmp31 = NULL;
		_tmp30 = NULL;
		vala_ccode_enum_add_value (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->prop_enum, (_tmp32 = vala_ccode_enum_value_new ((_tmp31 = g_strdup_printf ("%s_DUMMY_PROPERTY", (_tmp30 = vala_typesymbol_get_upper_case_cname (VALA_TYPESYMBOL (self->priv->_cl), NULL)))), NULL)));
		(_tmp32 == NULL ? NULL : (_tmp32 = (g_object_unref (_tmp32), NULL)));
		_tmp31 = (g_free (_tmp31), NULL);
		_tmp30 = (g_free (_tmp30), NULL);
		_tmp33 = NULL;
		vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->class_init_fragment = (_tmp33 = vala_ccode_fragment_new (), (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->class_init_fragment == NULL ? NULL : (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->class_init_fragment = (g_object_unref (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->class_init_fragment), NULL))), _tmp33);
		_tmp34 = NULL;
		vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_init_fragment = (_tmp34 = vala_ccode_fragment_new (), (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_init_fragment == NULL ? NULL : (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_init_fragment = (g_object_unref (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_init_fragment), NULL))), _tmp34);
		_tmp35 = NULL;
		vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_dispose_fragment = (_tmp35 = vala_ccode_fragment_new (), (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_dispose_fragment == NULL ? NULL : (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_dispose_fragment = (g_object_unref (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_dispose_fragment), NULL))), _tmp35);
	}
	decl_frag = NULL;
	def_frag = NULL;
	if (vala_symbol_get_access (VALA_SYMBOL (self->priv->_cl)) != VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		ValaCCodeFragment* _tmp37;
		ValaCCodeFragment* _tmp36;
		ValaCCodeFragment* _tmp39;
		ValaCCodeFragment* _tmp38;
		_tmp37 = NULL;
		_tmp36 = NULL;
		decl_frag = (_tmp37 = (_tmp36 = vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->header_type_declaration, (_tmp36 == NULL ? NULL : g_object_ref (_tmp36))), (decl_frag == NULL ? NULL : (decl_frag = (g_object_unref (decl_frag), NULL))), _tmp37);
		_tmp39 = NULL;
		_tmp38 = NULL;
		def_frag = (_tmp39 = (_tmp38 = vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->header_type_definition, (_tmp38 == NULL ? NULL : g_object_ref (_tmp38))), (def_frag == NULL ? NULL : (def_frag = (g_object_unref (def_frag), NULL))), _tmp39);
	} else {
		ValaCCodeFragment* _tmp41;
		ValaCCodeFragment* _tmp40;
		ValaCCodeFragment* _tmp43;
		ValaCCodeFragment* _tmp42;
		_tmp41 = NULL;
		_tmp40 = NULL;
		decl_frag = (_tmp41 = (_tmp40 = vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_declaration, (_tmp40 == NULL ? NULL : g_object_ref (_tmp40))), (decl_frag == NULL ? NULL : (decl_frag = (g_object_unref (decl_frag), NULL))), _tmp41);
		_tmp43 = NULL;
		_tmp42 = NULL;
		def_frag = (_tmp43 = (_tmp42 = vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_definition, (_tmp42 == NULL ? NULL : g_object_ref (_tmp42))), (def_frag == NULL ? NULL : (def_frag = (g_object_unref (def_frag), NULL))), _tmp43);
	}
	if (is_gtypeinstance) {
		ValaCCodeNewline* _tmp44;
		char* _tmp45;
		char* _tmp46;
		char* macro;
		ValaCCodeMacroReplacement* _tmp48;
		char* _tmp47;
		char* _tmp51;
		char* _tmp50;
		char* _tmp49;
		ValaCCodeMacroReplacement* _tmp54;
		char* _tmp53;
		char* _tmp52;
		char* _tmp57;
		char* _tmp56;
		char* _tmp55;
		ValaCCodeMacroReplacement* _tmp60;
		char* _tmp59;
		char* _tmp58;
		char* _tmp62;
		char* _tmp61;
		ValaCCodeMacroReplacement* _tmp65;
		char* _tmp64;
		char* _tmp63;
		char* _tmp67;
		char* _tmp66;
		ValaCCodeMacroReplacement* _tmp70;
		char* _tmp69;
		char* _tmp68;
		char* _tmp73;
		char* _tmp72;
		char* _tmp71;
		ValaCCodeMacroReplacement* _tmp76;
		char* _tmp75;
		char* _tmp74;
		ValaCCodeNewline* _tmp77;
		_tmp44 = NULL;
		vala_ccode_fragment_append (decl_frag, VALA_CCODE_NODE ((_tmp44 = vala_ccode_newline_new ())));
		(_tmp44 == NULL ? NULL : (_tmp44 = (g_object_unref (_tmp44), NULL)));
		_tmp45 = NULL;
		_tmp46 = NULL;
		macro = (_tmp46 = g_strdup_printf ("(%s_get_type ())", (_tmp45 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (self->priv->_cl), NULL))), (_tmp45 = (g_free (_tmp45), NULL)), _tmp46);
		_tmp48 = NULL;
		_tmp47 = NULL;
		vala_ccode_fragment_append (decl_frag, VALA_CCODE_NODE ((_tmp48 = vala_ccode_macro_replacement_new ((_tmp47 = vala_typesymbol_get_upper_case_cname (VALA_TYPESYMBOL (self->priv->_cl), "TYPE_")), macro))));
		(_tmp48 == NULL ? NULL : (_tmp48 = (g_object_unref (_tmp48), NULL)));
		_tmp47 = (g_free (_tmp47), NULL);
		_tmp51 = NULL;
		_tmp50 = NULL;
		_tmp49 = NULL;
		macro = (_tmp51 = g_strdup_printf ("(G_TYPE_CHECK_INSTANCE_CAST ((obj), %s, %s))", (_tmp49 = vala_typesymbol_get_upper_case_cname (VALA_TYPESYMBOL (self->priv->_cl), "TYPE_")), (_tmp50 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (self->priv->_cl), FALSE))), (macro = (g_free (macro), NULL)), _tmp51);
		_tmp50 = (g_free (_tmp50), NULL);
		_tmp49 = (g_free (_tmp49), NULL);
		_tmp54 = NULL;
		_tmp53 = NULL;
		_tmp52 = NULL;
		vala_ccode_fragment_append (decl_frag, VALA_CCODE_NODE ((_tmp54 = vala_ccode_macro_replacement_new ((_tmp53 = g_strdup_printf ("%s(obj)", (_tmp52 = vala_typesymbol_get_upper_case_cname (VALA_TYPESYMBOL (self->priv->_cl), NULL)))), macro))));
		(_tmp54 == NULL ? NULL : (_tmp54 = (g_object_unref (_tmp54), NULL)));
		_tmp53 = (g_free (_tmp53), NULL);
		_tmp52 = (g_free (_tmp52), NULL);
		_tmp57 = NULL;
		_tmp56 = NULL;
		_tmp55 = NULL;
		macro = (_tmp57 = g_strdup_printf ("(G_TYPE_CHECK_CLASS_CAST ((klass), %s, %sClass))", (_tmp55 = vala_typesymbol_get_upper_case_cname (VALA_TYPESYMBOL (self->priv->_cl), "TYPE_")), (_tmp56 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (self->priv->_cl), FALSE))), (macro = (g_free (macro), NULL)), _tmp57);
		_tmp56 = (g_free (_tmp56), NULL);
		_tmp55 = (g_free (_tmp55), NULL);
		_tmp60 = NULL;
		_tmp59 = NULL;
		_tmp58 = NULL;
		vala_ccode_fragment_append (decl_frag, VALA_CCODE_NODE ((_tmp60 = vala_ccode_macro_replacement_new ((_tmp59 = g_strdup_printf ("%s_CLASS(klass)", (_tmp58 = vala_typesymbol_get_upper_case_cname (VALA_TYPESYMBOL (self->priv->_cl), NULL)))), macro))));
		(_tmp60 == NULL ? NULL : (_tmp60 = (g_object_unref (_tmp60), NULL)));
		_tmp59 = (g_free (_tmp59), NULL);
		_tmp58 = (g_free (_tmp58), NULL);
		_tmp62 = NULL;
		_tmp61 = NULL;
		macro = (_tmp62 = g_strdup_printf ("(G_TYPE_CHECK_INSTANCE_TYPE ((obj), %s))", (_tmp61 = vala_typesymbol_get_upper_case_cname (VALA_TYPESYMBOL (self->priv->_cl), "TYPE_"))), (macro = (g_free (macro), NULL)), _tmp62);
		_tmp61 = (g_free (_tmp61), NULL);
		_tmp65 = NULL;
		_tmp64 = NULL;
		_tmp63 = NULL;
		vala_ccode_fragment_append (decl_frag, VALA_CCODE_NODE ((_tmp65 = vala_ccode_macro_replacement_new ((_tmp64 = g_strdup_printf ("%s(obj)", (_tmp63 = vala_typesymbol_get_upper_case_cname (VALA_TYPESYMBOL (self->priv->_cl), "IS_")))), macro))));
		(_tmp65 == NULL ? NULL : (_tmp65 = (g_object_unref (_tmp65), NULL)));
		_tmp64 = (g_free (_tmp64), NULL);
		_tmp63 = (g_free (_tmp63), NULL);
		_tmp67 = NULL;
		_tmp66 = NULL;
		macro = (_tmp67 = g_strdup_printf ("(G_TYPE_CHECK_CLASS_TYPE ((klass), %s))", (_tmp66 = vala_typesymbol_get_upper_case_cname (VALA_TYPESYMBOL (self->priv->_cl), "TYPE_"))), (macro = (g_free (macro), NULL)), _tmp67);
		_tmp66 = (g_free (_tmp66), NULL);
		_tmp70 = NULL;
		_tmp69 = NULL;
		_tmp68 = NULL;
		vala_ccode_fragment_append (decl_frag, VALA_CCODE_NODE ((_tmp70 = vala_ccode_macro_replacement_new ((_tmp69 = g_strdup_printf ("%s_CLASS(klass)", (_tmp68 = vala_typesymbol_get_upper_case_cname (VALA_TYPESYMBOL (self->priv->_cl), "IS_")))), macro))));
		(_tmp70 == NULL ? NULL : (_tmp70 = (g_object_unref (_tmp70), NULL)));
		_tmp69 = (g_free (_tmp69), NULL);
		_tmp68 = (g_free (_tmp68), NULL);
		_tmp73 = NULL;
		_tmp72 = NULL;
		_tmp71 = NULL;
		macro = (_tmp73 = g_strdup_printf ("(G_TYPE_INSTANCE_GET_CLASS ((obj), %s, %sClass))", (_tmp71 = vala_typesymbol_get_upper_case_cname (VALA_TYPESYMBOL (self->priv->_cl), "TYPE_")), (_tmp72 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (self->priv->_cl), FALSE))), (macro = (g_free (macro), NULL)), _tmp73);
		_tmp72 = (g_free (_tmp72), NULL);
		_tmp71 = (g_free (_tmp71), NULL);
		_tmp76 = NULL;
		_tmp75 = NULL;
		_tmp74 = NULL;
		vala_ccode_fragment_append (decl_frag, VALA_CCODE_NODE ((_tmp76 = vala_ccode_macro_replacement_new ((_tmp75 = g_strdup_printf ("%s_GET_CLASS(obj)", (_tmp74 = vala_typesymbol_get_upper_case_cname (VALA_TYPESYMBOL (self->priv->_cl), NULL)))), macro))));
		(_tmp76 == NULL ? NULL : (_tmp76 = (g_object_unref (_tmp76), NULL)));
		_tmp75 = (g_free (_tmp75), NULL);
		_tmp74 = (g_free (_tmp74), NULL);
		_tmp77 = NULL;
		vala_ccode_fragment_append (decl_frag, VALA_CCODE_NODE ((_tmp77 = vala_ccode_newline_new ())));
		(_tmp77 == NULL ? NULL : (_tmp77 = (g_object_unref (_tmp77), NULL)));
		macro = (g_free (macro), NULL);
	}
	if (!vala_class_get_is_static (self->priv->_cl) && vala_source_file_get_cycle (vala_source_reference_get_file (vala_code_node_get_source_reference (VALA_CODE_NODE (self->priv->_cl)))) == NULL) {
		ValaCCodeTypeDefinition* _tmp81;
		ValaCCodeVariableDeclarator* _tmp80;
		char* _tmp79;
		char* _tmp78;
		_tmp81 = NULL;
		_tmp80 = NULL;
		_tmp79 = NULL;
		_tmp78 = NULL;
		vala_ccode_fragment_append (decl_frag, VALA_CCODE_NODE ((_tmp81 = vala_ccode_type_definition_new ((_tmp78 = g_strdup_printf ("struct %s", vala_ccode_struct_get_name (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_struct))), VALA_CCODE_DECLARATOR ((_tmp80 = vala_ccode_variable_declarator_new ((_tmp79 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (self->priv->_cl), FALSE)))))))));
		(_tmp81 == NULL ? NULL : (_tmp81 = (g_object_unref (_tmp81), NULL)));
		(_tmp80 == NULL ? NULL : (_tmp80 = (g_object_unref (_tmp80), NULL)));
		_tmp79 = (g_free (_tmp79), NULL);
		_tmp78 = (g_free (_tmp78), NULL);
	}
	if (vala_class_get_base_class (self->priv->_cl) != NULL) {
		char* _tmp82;
		_tmp82 = NULL;
		vala_ccode_struct_add_field (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_struct, (_tmp82 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (vala_class_get_base_class (self->priv->_cl)), FALSE)), "parent_instance");
		_tmp82 = (g_free (_tmp82), NULL);
	} else {
		if (is_fundamental) {
			vala_ccode_struct_add_field (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_struct, "GTypeInstance", "parent_instance");
			vala_ccode_struct_add_field (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_struct, "volatile int", "ref_count");
		}
	}
	_tmp83 = NULL;
	if ((_tmp84 = vala_class_get_is_compact (self->priv->_cl) && vala_class_get_base_class (self->priv->_cl) == NULL && gee_collection_get_size (GEE_COLLECTION ((_tmp83 = vala_class_get_fields (self->priv->_cl)))) == 0, (_tmp83 == NULL ? NULL : (_tmp83 = (g_object_unref (_tmp83), NULL))), _tmp84)) {
		/* add dummy member, C doesn't allow empty structs*/
		vala_ccode_struct_add_field (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_struct, "int", "dummy");
	}
	if (is_gtypeinstance) {
		ValaCCodeTypeDefinition* _tmp94;
		ValaCCodeVariableDeclarator* _tmp93;
		char* _tmp92;
		char* _tmp91;
		char* _tmp90;
		char* _tmp96;
		char* _tmp95;
		if (vala_source_file_get_cycle (vala_source_reference_get_file (vala_code_node_get_source_reference (VALA_CODE_NODE (self->priv->_cl)))) == NULL) {
			ValaCCodeTypeDefinition* _tmp89;
			ValaCCodeVariableDeclarator* _tmp88;
			char* _tmp87;
			char* _tmp86;
			char* _tmp85;
			_tmp89 = NULL;
			_tmp88 = NULL;
			_tmp87 = NULL;
			_tmp86 = NULL;
			_tmp85 = NULL;
			vala_ccode_fragment_append (decl_frag, VALA_CCODE_NODE ((_tmp89 = vala_ccode_type_definition_new ((_tmp85 = g_strdup_printf ("struct %s", vala_ccode_struct_get_name (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->type_struct))), VALA_CCODE_DECLARATOR ((_tmp88 = vala_ccode_variable_declarator_new ((_tmp87 = g_strdup_printf ("%sClass", (_tmp86 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (self->priv->_cl), FALSE)))))))))));
			(_tmp89 == NULL ? NULL : (_tmp89 = (g_object_unref (_tmp89), NULL)));
			(_tmp88 == NULL ? NULL : (_tmp88 = (g_object_unref (_tmp88), NULL)));
			_tmp87 = (g_free (_tmp87), NULL);
			_tmp86 = (g_free (_tmp86), NULL);
			_tmp85 = (g_free (_tmp85), NULL);
		}
		_tmp94 = NULL;
		_tmp93 = NULL;
		_tmp92 = NULL;
		_tmp91 = NULL;
		_tmp90 = NULL;
		vala_ccode_fragment_append (decl_frag, VALA_CCODE_NODE ((_tmp94 = vala_ccode_type_definition_new ((_tmp90 = g_strdup_printf ("struct %s", vala_ccode_struct_get_name (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_priv_struct))), VALA_CCODE_DECLARATOR ((_tmp93 = vala_ccode_variable_declarator_new ((_tmp92 = g_strdup_printf ("%sPrivate", (_tmp91 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (self->priv->_cl), FALSE)))))))))));
		(_tmp94 == NULL ? NULL : (_tmp94 = (g_object_unref (_tmp94), NULL)));
		(_tmp93 == NULL ? NULL : (_tmp93 = (g_object_unref (_tmp93), NULL)));
		_tmp92 = (g_free (_tmp92), NULL);
		_tmp91 = (g_free (_tmp91), NULL);
		_tmp90 = (g_free (_tmp90), NULL);
		_tmp96 = NULL;
		_tmp95 = NULL;
		vala_ccode_struct_add_field (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_struct, (_tmp96 = g_strdup_printf ("%sPrivate *", (_tmp95 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (self->priv->_cl), FALSE)))), "priv");
		_tmp96 = (g_free (_tmp96), NULL);
		_tmp95 = (g_free (_tmp95), NULL);
		if (is_fundamental) {
			char* _tmp98;
			char* _tmp97;
			vala_ccode_struct_add_field (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->type_struct, "GTypeClass", "parent_class");
			_tmp98 = NULL;
			_tmp97 = NULL;
			vala_ccode_struct_add_field (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->type_struct, "void", (_tmp98 = g_strdup_printf ("(*finalize) (%s *self)", (_tmp97 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (self->priv->_cl), FALSE)))));
			_tmp98 = (g_free (_tmp98), NULL);
			_tmp97 = (g_free (_tmp97), NULL);
		} else {
			char* _tmp100;
			char* _tmp99;
			_tmp100 = NULL;
			_tmp99 = NULL;
			vala_ccode_struct_add_field (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->type_struct, (_tmp100 = g_strdup_printf ("%sClass", (_tmp99 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (vala_class_get_base_class (self->priv->_cl)), FALSE)))), "parent_class");
			_tmp100 = (g_free (_tmp100), NULL);
			_tmp99 = (g_free (_tmp99), NULL);
		}
	}
	if (!vala_class_get_is_static (self->priv->_cl)) {
		if (vala_source_reference_get_comment (vala_code_node_get_source_reference (VALA_CODE_NODE (self->priv->_cl))) != NULL) {
			ValaCCodeComment* _tmp101;
			_tmp101 = NULL;
			vala_ccode_fragment_append (def_frag, VALA_CCODE_NODE ((_tmp101 = vala_ccode_comment_new (vala_source_reference_get_comment (vala_code_node_get_source_reference (VALA_CODE_NODE (self->priv->_cl)))))));
			(_tmp101 == NULL ? NULL : (_tmp101 = (g_object_unref (_tmp101), NULL)));
		}
		vala_ccode_fragment_append (def_frag, VALA_CCODE_NODE (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_struct));
	}
	if (is_gtypeinstance) {
		GeeList* _tmp102;
		gboolean _tmp103;
		vala_ccode_fragment_append (def_frag, VALA_CCODE_NODE (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->type_struct));
		/* only add the *Private struct if it is not empty, i.e. we actually have private data */
		_tmp102 = NULL;
		if ((_tmp103 = vala_class_get_has_private_fields (self->priv->_cl) || gee_collection_get_size (GEE_COLLECTION ((_tmp102 = vala_class_get_type_parameters (self->priv->_cl)))) > 0, (_tmp102 == NULL ? NULL : (_tmp102 = (g_object_unref (_tmp102), NULL))), _tmp103)) {
			char* _tmp105;
			char* _tmp104;
			char* _tmp106;
			char* macro;
			ValaCCodeMacroReplacement* _tmp109;
			char* _tmp108;
			char* _tmp107;
			vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_declaration, VALA_CCODE_NODE (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_priv_struct));
			_tmp105 = NULL;
			_tmp104 = NULL;
			_tmp106 = NULL;
			macro = (_tmp106 = g_strdup_printf ("(G_TYPE_INSTANCE_GET_PRIVATE ((o), %s, %sPrivate))", (_tmp104 = vala_typesymbol_get_upper_case_cname (VALA_TYPESYMBOL (self->priv->_cl), "TYPE_")), (_tmp105 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (self->priv->_cl), FALSE))), (_tmp105 = (g_free (_tmp105), NULL)), (_tmp104 = (g_free (_tmp104), NULL)), _tmp106);
			_tmp109 = NULL;
			_tmp108 = NULL;
			_tmp107 = NULL;
			vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_declaration, VALA_CCODE_NODE ((_tmp109 = vala_ccode_macro_replacement_new ((_tmp108 = g_strdup_printf ("%s_GET_PRIVATE(o)", (_tmp107 = vala_typesymbol_get_upper_case_cname (VALA_TYPESYMBOL (self->priv->_cl), NULL)))), macro))));
			(_tmp109 == NULL ? NULL : (_tmp109 = (g_object_unref (_tmp109), NULL)));
			_tmp108 = (g_free (_tmp108), NULL);
			_tmp107 = (g_free (_tmp107), NULL);
			macro = (g_free (macro), NULL);
		}
		vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_declaration, VALA_CCODE_NODE (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->prop_enum));
	}
	vala_code_node_accept_children (VALA_CODE_NODE (self->priv->_cl), VALA_CODE_VISITOR (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))));
	if (is_gtypeinstance) {
		ValaClassRegisterFunction* type_fun;
		ValaCCodeFragment* _tmp123;
		if (is_fundamental) {
			ValaCCodeConstant* _tmp112;
			ValaCCodeMemberAccess* _tmp111;
			ValaCCodeIdentifier* _tmp110;
			ValaCCodeAssignment* _tmp113;
			ValaCCodeAssignment* ref_count;
			ValaCCodeExpressionStatement* _tmp114;
			_tmp112 = NULL;
			_tmp111 = NULL;
			_tmp110 = NULL;
			_tmp113 = NULL;
			ref_count = (_tmp113 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp111 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp110 = vala_ccode_identifier_new ("self"))), "ref_count"))), VALA_CCODE_EXPRESSION ((_tmp112 = vala_ccode_constant_new ("1"))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (_tmp112 == NULL ? NULL : (_tmp112 = (g_object_unref (_tmp112), NULL))), (_tmp111 == NULL ? NULL : (_tmp111 = (g_object_unref (_tmp111), NULL))), (_tmp110 == NULL ? NULL : (_tmp110 = (g_object_unref (_tmp110), NULL))), _tmp113);
			_tmp114 = NULL;
			vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_init_fragment, VALA_CCODE_NODE ((_tmp114 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ref_count)))));
			(_tmp114 == NULL ? NULL : (_tmp114 = (g_object_unref (_tmp114), NULL)));
			(ref_count == NULL ? NULL : (ref_count = (g_object_unref (ref_count), NULL)));
		} else {
			if (is_gobject) {
				GeeList* _tmp115;
				gboolean _tmp116;
				GeeList* _tmp117;
				gboolean _tmp118;
				_tmp115 = NULL;
				if ((_tmp116 = vala_ccode_class_binding_class_has_readable_properties (self, self->priv->_cl) || gee_collection_get_size (GEE_COLLECTION ((_tmp115 = vala_class_get_type_parameters (self->priv->_cl)))) > 0, (_tmp115 == NULL ? NULL : (_tmp115 = (g_object_unref (_tmp115), NULL))), _tmp116)) {
					vala_ccode_class_binding_add_get_property_function (self, self->priv->_cl);
				}
				_tmp117 = NULL;
				if ((_tmp118 = vala_ccode_class_binding_class_has_writable_properties (self, self->priv->_cl) || gee_collection_get_size (GEE_COLLECTION ((_tmp117 = vala_class_get_type_parameters (self->priv->_cl)))) > 0, (_tmp117 == NULL ? NULL : (_tmp117 = (g_object_unref (_tmp117), NULL))), _tmp118)) {
					vala_ccode_class_binding_add_set_property_function (self, self->priv->_cl);
				}
			}
		}
		vala_ccode_class_binding_add_class_init_function (self, self->priv->_cl);
		{
			GeeList* base_type_collection;
			int base_type_it;
			base_type_collection = vala_class_get_base_types (self->priv->_cl);
			for (base_type_it = 0; base_type_it < gee_collection_get_size (GEE_COLLECTION (base_type_collection)); base_type_it = base_type_it + 1) {
				ValaDataType* base_type;
				base_type = ((ValaDataType*) (gee_list_get (GEE_LIST (base_type_collection), base_type_it)));
				{
					if (VALA_IS_INTERFACE (vala_data_type_get_data_type (base_type))) {
						vala_ccode_class_binding_add_interface_init_function (self, self->priv->_cl, VALA_INTERFACE (vala_data_type_get_data_type (base_type)));
					}
					(base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL)));
				}
			}
			(base_type_collection == NULL ? NULL : (base_type_collection = (g_object_unref (base_type_collection), NULL)));
		}
		vala_ccode_class_binding_add_instance_init_function (self, self->priv->_cl);
		if (is_gobject) {
			GeeList* _tmp119;
			gboolean _tmp120;
			_tmp119 = NULL;
			if ((_tmp120 = gee_collection_get_size (GEE_COLLECTION ((_tmp119 = vala_class_get_fields (self->priv->_cl)))) > 0 || vala_class_get_destructor (self->priv->_cl) != NULL, (_tmp119 == NULL ? NULL : (_tmp119 = (g_object_unref (_tmp119), NULL))), _tmp120)) {
				vala_ccode_class_binding_add_dispose_function (self, self->priv->_cl);
			}
		}
		type_fun = vala_class_register_function_new (self->priv->_cl);
		vala_typeregister_function_init_from_type (VALA_TYPEREGISTER_FUNCTION (type_fun), vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->in_plugin);
		if (vala_symbol_get_access (VALA_SYMBOL (self->priv->_cl)) != VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			ValaCCodeFragment* _tmp121;
			_tmp121 = NULL;
			vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->header_type_member_declaration, VALA_CCODE_NODE ((_tmp121 = vala_typeregister_function_get_declaration (VALA_TYPEREGISTER_FUNCTION (type_fun)))));
			(_tmp121 == NULL ? NULL : (_tmp121 = (g_object_unref (_tmp121), NULL)));
		} else {
			ValaCCodeFragment* _tmp122;
			_tmp122 = NULL;
			vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_declaration, VALA_CCODE_NODE ((_tmp122 = vala_typeregister_function_get_declaration (VALA_TYPEREGISTER_FUNCTION (type_fun)))));
			(_tmp122 == NULL ? NULL : (_tmp122 = (g_object_unref (_tmp122), NULL)));
		}
		_tmp123 = NULL;
		vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_definition, VALA_CCODE_NODE ((_tmp123 = vala_typeregister_function_get_definition (VALA_TYPEREGISTER_FUNCTION (type_fun)))));
		(_tmp123 == NULL ? NULL : (_tmp123 = (g_object_unref (_tmp123), NULL)));
		if (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->in_plugin) {
			ValaCCodeIdentifier* _tmp126;
			char* _tmp125;
			char* _tmp124;
			ValaCCodeFunctionCall* _tmp127;
			ValaCCodeFunctionCall* register_call;
			ValaCCodeIdentifier* _tmp128;
			ValaCCodeExpressionStatement* _tmp129;
			/* FIXME resolve potential dependency issues, i.e. base types have to be registered before derived types*/
			_tmp126 = NULL;
			_tmp125 = NULL;
			_tmp124 = NULL;
			_tmp127 = NULL;
			register_call = (_tmp127 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp126 = vala_ccode_identifier_new ((_tmp125 = g_strdup_printf ("%s_register_type", (_tmp124 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (self->priv->_cl), NULL)))))))), (_tmp126 == NULL ? NULL : (_tmp126 = (g_object_unref (_tmp126), NULL))), (_tmp125 = (g_free (_tmp125), NULL)), (_tmp124 = (g_free (_tmp124), NULL)), _tmp127);
			_tmp128 = NULL;
			vala_ccode_function_call_add_argument (register_call, VALA_CCODE_EXPRESSION ((_tmp128 = vala_ccode_identifier_new (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->module_init_param_name))));
			(_tmp128 == NULL ? NULL : (_tmp128 = (g_object_unref (_tmp128), NULL)));
			_tmp129 = NULL;
			vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->module_init_fragment, VALA_CCODE_NODE ((_tmp129 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (register_call)))));
			(_tmp129 == NULL ? NULL : (_tmp129 = (g_object_unref (_tmp129), NULL)));
			(register_call == NULL ? NULL : (register_call = (g_object_unref (register_call), NULL)));
		}
		if (is_fundamental) {
			char* _tmp131;
			char* _tmp130;
			ValaCCodeFunction* _tmp132;
			ValaCCodeFunction* ref_fun;
			char* _tmp134;
			char* _tmp133;
			ValaCCodeFunction* _tmp135;
			ValaCCodeFunction* unref_fun;
			ValaCCodeFormalParameter* _tmp136;
			ValaCCodeFormalParameter* _tmp137;
			ValaCCodeBlock* ref_block;
			ValaCCodeBlock* unref_block;
			char* _tmp143;
			char* _tmp142;
			ValaCCodeDeclaration* _tmp144;
			ValaCCodeDeclaration* cdecl_;
			ValaCCodeVariableDeclarator* _tmp146;
			ValaCCodeIdentifier* _tmp145;
			ValaCCodeIdentifier* _tmp147;
			ValaCCodeMemberAccess* _tmp148;
			ValaCCodeMemberAccess* ref_count;
			ValaCCodeIdentifier* _tmp149;
			ValaCCodeFunctionCall* _tmp150;
			ValaCCodeFunctionCall* ccall;
			ValaCCodeUnaryExpression* _tmp151;
			ValaCCodeExpressionStatement* _tmp152;
			ValaCCodeReturnStatement* _tmp154;
			ValaCCodeIdentifier* _tmp153;
			ValaCCodeBlock* destroy_block;
			ValaCCodeIdentifier* _tmp157;
			char* _tmp156;
			char* _tmp155;
			ValaCCodeFunctionCall* _tmp158;
			ValaCCodeFunctionCall* get_class;
			ValaCCodeIdentifier* _tmp159;
			ValaCCodeMemberAccess* finalize;
			ValaCCodeFunctionCall* finalize_call;
			ValaCCodeIdentifier* _tmp160;
			ValaCCodeIdentifier* _tmp161;
			ValaCCodeFunctionCall* _tmp162;
			ValaCCodeFunctionCall* free;
			ValaCCodeCastExpression* _tmp164;
			ValaCCodeIdentifier* _tmp163;
			ValaCCodeExpressionStatement* _tmp165;
			ValaCCodeFunctionCall* _tmp167;
			ValaCCodeIdentifier* _tmp166;
			ValaCCodeUnaryExpression* _tmp168;
			ValaCCodeIfStatement* _tmp169;
			_tmp131 = NULL;
			_tmp130 = NULL;
			_tmp132 = NULL;
			ref_fun = (_tmp132 = vala_ccode_function_new ((_tmp131 = g_strconcat ((_tmp130 = vala_symbol_get_lower_case_cprefix (VALA_SYMBOL (self->priv->_cl))), "ref", NULL)), "gpointer"), (_tmp131 = (g_free (_tmp131), NULL)), (_tmp130 = (g_free (_tmp130), NULL)), _tmp132);
			_tmp134 = NULL;
			_tmp133 = NULL;
			_tmp135 = NULL;
			unref_fun = (_tmp135 = vala_ccode_function_new ((_tmp134 = g_strconcat ((_tmp133 = vala_symbol_get_lower_case_cprefix (VALA_SYMBOL (self->priv->_cl))), "unref", NULL)), "void"), (_tmp134 = (g_free (_tmp134), NULL)), (_tmp133 = (g_free (_tmp133), NULL)), _tmp135);
			if (vala_symbol_get_access (VALA_SYMBOL (self->priv->_cl)) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
				vala_ccode_function_set_modifiers (ref_fun, VALA_CCODE_MODIFIERS_STATIC);
				vala_ccode_function_set_modifiers (unref_fun, VALA_CCODE_MODIFIERS_STATIC);
			}
			_tmp136 = NULL;
			vala_ccode_function_add_parameter (ref_fun, (_tmp136 = vala_ccode_formal_parameter_new ("instance", "gpointer")));
			(_tmp136 == NULL ? NULL : (_tmp136 = (g_object_unref (_tmp136), NULL)));
			_tmp137 = NULL;
			vala_ccode_function_add_parameter (unref_fun, (_tmp137 = vala_ccode_formal_parameter_new ("instance", "gpointer")));
			(_tmp137 == NULL ? NULL : (_tmp137 = (g_object_unref (_tmp137), NULL)));
			if (vala_symbol_get_access (VALA_SYMBOL (self->priv->_cl)) != VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
				ValaCCodeFunction* _tmp138;
				ValaCCodeFunction* _tmp139;
				_tmp138 = NULL;
				vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->header_type_member_declaration, VALA_CCODE_NODE ((_tmp138 = vala_ccode_function_copy (ref_fun))));
				(_tmp138 == NULL ? NULL : (_tmp138 = (g_object_unref (_tmp138), NULL)));
				_tmp139 = NULL;
				vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->header_type_member_declaration, VALA_CCODE_NODE ((_tmp139 = vala_ccode_function_copy (unref_fun))));
				(_tmp139 == NULL ? NULL : (_tmp139 = (g_object_unref (_tmp139), NULL)));
			} else {
				ValaCCodeFunction* _tmp140;
				ValaCCodeFunction* _tmp141;
				_tmp140 = NULL;
				vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_declaration, VALA_CCODE_NODE ((_tmp140 = vala_ccode_function_copy (ref_fun))));
				(_tmp140 == NULL ? NULL : (_tmp140 = (g_object_unref (_tmp140), NULL)));
				_tmp141 = NULL;
				vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_declaration, VALA_CCODE_NODE ((_tmp141 = vala_ccode_function_copy (unref_fun))));
				(_tmp141 == NULL ? NULL : (_tmp141 = (g_object_unref (_tmp141), NULL)));
			}
			ref_block = vala_ccode_block_new ();
			unref_block = vala_ccode_block_new ();
			_tmp143 = NULL;
			_tmp142 = NULL;
			_tmp144 = NULL;
			cdecl_ = (_tmp144 = vala_ccode_declaration_new ((_tmp143 = g_strconcat ((_tmp142 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (self->priv->_cl), FALSE)), "*", NULL))), (_tmp143 = (g_free (_tmp143), NULL)), (_tmp142 = (g_free (_tmp142), NULL)), _tmp144);
			_tmp146 = NULL;
			_tmp145 = NULL;
			vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp146 = vala_ccode_variable_declarator_new_with_initializer ("self", VALA_CCODE_EXPRESSION ((_tmp145 = vala_ccode_identifier_new ("instance")))))));
			(_tmp146 == NULL ? NULL : (_tmp146 = (g_object_unref (_tmp146), NULL)));
			(_tmp145 == NULL ? NULL : (_tmp145 = (g_object_unref (_tmp145), NULL)));
			vala_ccode_block_add_statement (ref_block, VALA_CCODE_NODE (cdecl_));
			vala_ccode_block_add_statement (unref_block, VALA_CCODE_NODE (cdecl_));
			_tmp147 = NULL;
			_tmp148 = NULL;
			ref_count = (_tmp148 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp147 = vala_ccode_identifier_new ("self"))), "ref_count"), (_tmp147 == NULL ? NULL : (_tmp147 = (g_object_unref (_tmp147), NULL))), _tmp148);
			_tmp149 = NULL;
			_tmp150 = NULL;
			ccall = (_tmp150 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp149 = vala_ccode_identifier_new ("g_atomic_int_inc")))), (_tmp149 == NULL ? NULL : (_tmp149 = (g_object_unref (_tmp149), NULL))), _tmp150);
			_tmp151 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp151 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION (ref_count)))));
			(_tmp151 == NULL ? NULL : (_tmp151 = (g_object_unref (_tmp151), NULL)));
			_tmp152 = NULL;
			vala_ccode_block_add_statement (ref_block, VALA_CCODE_NODE ((_tmp152 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ccall)))));
			(_tmp152 == NULL ? NULL : (_tmp152 = (g_object_unref (_tmp152), NULL)));
			_tmp154 = NULL;
			_tmp153 = NULL;
			vala_ccode_block_add_statement (ref_block, VALA_CCODE_NODE ((_tmp154 = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION ((_tmp153 = vala_ccode_identifier_new ("instance")))))));
			(_tmp154 == NULL ? NULL : (_tmp154 = (g_object_unref (_tmp154), NULL)));
			(_tmp153 == NULL ? NULL : (_tmp153 = (g_object_unref (_tmp153), NULL)));
			destroy_block = vala_ccode_block_new ();
			_tmp157 = NULL;
			_tmp156 = NULL;
			_tmp155 = NULL;
			_tmp158 = NULL;
			get_class = (_tmp158 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp157 = vala_ccode_identifier_new ((_tmp156 = g_strdup_printf ("%s_GET_CLASS", (_tmp155 = vala_typesymbol_get_upper_case_cname (VALA_TYPESYMBOL (self->priv->_cl), NULL)))))))), (_tmp157 == NULL ? NULL : (_tmp157 = (g_object_unref (_tmp157), NULL))), (_tmp156 = (g_free (_tmp156), NULL)), (_tmp155 = (g_free (_tmp155), NULL)), _tmp158);
			_tmp159 = NULL;
			vala_ccode_function_call_add_argument (get_class, VALA_CCODE_EXPRESSION ((_tmp159 = vala_ccode_identifier_new ("self"))));
			(_tmp159 == NULL ? NULL : (_tmp159 = (g_object_unref (_tmp159), NULL)));
			finalize = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (get_class), "finalize");
			finalize_call = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (finalize));
			_tmp160 = NULL;
			vala_ccode_function_call_add_argument (finalize_call, VALA_CCODE_EXPRESSION ((_tmp160 = vala_ccode_identifier_new ("self"))));
			(_tmp160 == NULL ? NULL : (_tmp160 = (g_object_unref (_tmp160), NULL)));
			/*destroy_block.add_statement (new CCodeExpressionStatement (finalize_call));*/
			_tmp161 = NULL;
			_tmp162 = NULL;
			free = (_tmp162 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp161 = vala_ccode_identifier_new ("g_type_free_instance")))), (_tmp161 == NULL ? NULL : (_tmp161 = (g_object_unref (_tmp161), NULL))), _tmp162);
			_tmp164 = NULL;
			_tmp163 = NULL;
			vala_ccode_function_call_add_argument (free, VALA_CCODE_EXPRESSION ((_tmp164 = vala_ccode_cast_expression_new (VALA_CCODE_EXPRESSION ((_tmp163 = vala_ccode_identifier_new ("self"))), "GTypeInstance *"))));
			(_tmp164 == NULL ? NULL : (_tmp164 = (g_object_unref (_tmp164), NULL)));
			(_tmp163 == NULL ? NULL : (_tmp163 = (g_object_unref (_tmp163), NULL)));
			_tmp165 = NULL;
			vala_ccode_block_add_statement (destroy_block, VALA_CCODE_NODE ((_tmp165 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (free)))));
			(_tmp165 == NULL ? NULL : (_tmp165 = (g_object_unref (_tmp165), NULL)));
			_tmp167 = NULL;
			_tmp166 = NULL;
			ccall = (_tmp167 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp166 = vala_ccode_identifier_new ("g_atomic_int_dec_and_test")))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), _tmp167);
			(_tmp166 == NULL ? NULL : (_tmp166 = (g_object_unref (_tmp166), NULL)));
			_tmp168 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp168 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION (ref_count)))));
			(_tmp168 == NULL ? NULL : (_tmp168 = (g_object_unref (_tmp168), NULL)));
			_tmp169 = NULL;
			vala_ccode_block_add_statement (unref_block, VALA_CCODE_NODE ((_tmp169 = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION (ccall), VALA_CCODE_STATEMENT (destroy_block), NULL))));
			(_tmp169 == NULL ? NULL : (_tmp169 = (g_object_unref (_tmp169), NULL)));
			vala_ccode_function_set_block (ref_fun, ref_block);
			vala_ccode_function_set_block (unref_fun, unref_block);
			vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_definition, VALA_CCODE_NODE (ref_fun));
			vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_definition, VALA_CCODE_NODE (unref_fun));
			(ref_fun == NULL ? NULL : (ref_fun = (g_object_unref (ref_fun), NULL)));
			(unref_fun == NULL ? NULL : (unref_fun = (g_object_unref (unref_fun), NULL)));
			(ref_block == NULL ? NULL : (ref_block = (g_object_unref (ref_block), NULL)));
			(unref_block == NULL ? NULL : (unref_block = (g_object_unref (unref_block), NULL)));
			(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
			(ref_count == NULL ? NULL : (ref_count = (g_object_unref (ref_count), NULL)));
			(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
			(destroy_block == NULL ? NULL : (destroy_block = (g_object_unref (destroy_block), NULL)));
			(get_class == NULL ? NULL : (get_class = (g_object_unref (get_class), NULL)));
			(finalize == NULL ? NULL : (finalize = (g_object_unref (finalize), NULL)));
			(finalize_call == NULL ? NULL : (finalize_call = (g_object_unref (finalize_call), NULL)));
			(free == NULL ? NULL : (free = (g_object_unref (free), NULL)));
		}
		(type_fun == NULL ? NULL : (type_fun = (g_object_unref (type_fun), NULL)));
	} else {
		if (!vala_class_get_is_static (self->priv->_cl)) {
			char* _tmp171;
			char* _tmp170;
			ValaCCodeFunction* _tmp172;
			ValaCCodeFunction* function;
			ValaCCodeFormalParameter* _tmp175;
			char* _tmp174;
			char* _tmp173;
			ValaCCodeBlock* cblock;
			ValaCCodeIdentifier* _tmp178;
			ValaCCodeFunctionCall* _tmp179;
			ValaCCodeFunctionCall* ccall;
			ValaCCodeIdentifier* _tmp181;
			char* _tmp180;
			ValaCCodeIdentifier* _tmp182;
			ValaCCodeExpressionStatement* _tmp183;
			_tmp171 = NULL;
			_tmp170 = NULL;
			_tmp172 = NULL;
			function = (_tmp172 = vala_ccode_function_new ((_tmp171 = g_strconcat ((_tmp170 = vala_symbol_get_lower_case_cprefix (VALA_SYMBOL (self->priv->_cl))), "free", NULL)), "void"), (_tmp171 = (g_free (_tmp171), NULL)), (_tmp170 = (g_free (_tmp170), NULL)), _tmp172);
			if (vala_symbol_get_access (VALA_SYMBOL (self->priv->_cl)) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
				vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
			}
			_tmp175 = NULL;
			_tmp174 = NULL;
			_tmp173 = NULL;
			vala_ccode_function_add_parameter (function, (_tmp175 = vala_ccode_formal_parameter_new ("self", (_tmp174 = g_strconcat ((_tmp173 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (self->priv->_cl), FALSE)), "*", NULL)))));
			(_tmp175 == NULL ? NULL : (_tmp175 = (g_object_unref (_tmp175), NULL)));
			_tmp174 = (g_free (_tmp174), NULL);
			_tmp173 = (g_free (_tmp173), NULL);
			if (vala_symbol_get_access (VALA_SYMBOL (self->priv->_cl)) != VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
				ValaCCodeFunction* _tmp176;
				_tmp176 = NULL;
				vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->header_type_member_declaration, VALA_CCODE_NODE ((_tmp176 = vala_ccode_function_copy (function))));
				(_tmp176 == NULL ? NULL : (_tmp176 = (g_object_unref (_tmp176), NULL)));
			} else {
				ValaCCodeFunction* _tmp177;
				_tmp177 = NULL;
				vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_declaration, VALA_CCODE_NODE ((_tmp177 = vala_ccode_function_copy (function))));
				(_tmp177 == NULL ? NULL : (_tmp177 = (g_object_unref (_tmp177), NULL)));
			}
			cblock = vala_ccode_block_new ();
			vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_dispose_fragment));
			if (vala_class_get_destructor (self->priv->_cl) != NULL) {
				vala_ccode_block_add_statement (cblock, vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_destructor_get_body (vala_class_get_destructor (self->priv->_cl)))));
			}
			_tmp178 = NULL;
			_tmp179 = NULL;
			ccall = (_tmp179 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp178 = vala_ccode_identifier_new ("g_slice_free")))), (_tmp178 == NULL ? NULL : (_tmp178 = (g_object_unref (_tmp178), NULL))), _tmp179);
			_tmp181 = NULL;
			_tmp180 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp181 = vala_ccode_identifier_new ((_tmp180 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (self->priv->_cl), FALSE))))));
			(_tmp181 == NULL ? NULL : (_tmp181 = (g_object_unref (_tmp181), NULL)));
			_tmp180 = (g_free (_tmp180), NULL);
			_tmp182 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp182 = vala_ccode_identifier_new ("self"))));
			(_tmp182 == NULL ? NULL : (_tmp182 = (g_object_unref (_tmp182), NULL)));
			_tmp183 = NULL;
			vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((_tmp183 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ccall)))));
			(_tmp183 == NULL ? NULL : (_tmp183 = (g_object_unref (_tmp183), NULL)));
			vala_ccode_function_set_block (function, cblock);
			vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_definition, VALA_CCODE_NODE (function));
			(function == NULL ? NULL : (function = (g_object_unref (function), NULL)));
			(cblock == NULL ? NULL : (cblock = (g_object_unref (cblock), NULL)));
			(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
		}
	}
	_tmp185 = NULL;
	_tmp184 = NULL;
	vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_type_symbol = (_tmp185 = (_tmp184 = old_type_symbol, (_tmp184 == NULL ? NULL : g_object_ref (_tmp184))), (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_type_symbol == NULL ? NULL : (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_type_symbol = (g_object_unref (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_type_symbol), NULL))), _tmp185);
	_tmp187 = NULL;
	_tmp186 = NULL;
	vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_class = (_tmp187 = (_tmp186 = old_class, (_tmp186 == NULL ? NULL : g_object_ref (_tmp186))), (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_class == NULL ? NULL : (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_class = (g_object_unref (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_class), NULL))), _tmp187);
	_tmp189 = NULL;
	_tmp188 = NULL;
	vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_struct = (_tmp189 = (_tmp188 = old_instance_struct, (_tmp188 == NULL ? NULL : g_object_ref (_tmp188))), (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_struct == NULL ? NULL : (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_struct = (g_object_unref (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_struct), NULL))), _tmp189);
	_tmp191 = NULL;
	_tmp190 = NULL;
	vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->type_struct = (_tmp191 = (_tmp190 = old_type_struct, (_tmp190 == NULL ? NULL : g_object_ref (_tmp190))), (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->type_struct == NULL ? NULL : (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->type_struct = (g_object_unref (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->type_struct), NULL))), _tmp191);
	_tmp193 = NULL;
	_tmp192 = NULL;
	vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_priv_struct = (_tmp193 = (_tmp192 = old_instance_priv_struct, (_tmp192 == NULL ? NULL : g_object_ref (_tmp192))), (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_priv_struct == NULL ? NULL : (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_priv_struct = (g_object_unref (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_priv_struct), NULL))), _tmp193);
	_tmp195 = NULL;
	_tmp194 = NULL;
	vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->prop_enum = (_tmp195 = (_tmp194 = old_prop_enum, (_tmp194 == NULL ? NULL : g_object_ref (_tmp194))), (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->prop_enum == NULL ? NULL : (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->prop_enum = (g_object_unref (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->prop_enum), NULL))), _tmp195);
	_tmp197 = NULL;
	_tmp196 = NULL;
	vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->class_init_fragment = (_tmp197 = (_tmp196 = old_class_init_fragment, (_tmp196 == NULL ? NULL : g_object_ref (_tmp196))), (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->class_init_fragment == NULL ? NULL : (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->class_init_fragment = (g_object_unref (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->class_init_fragment), NULL))), _tmp197);
	_tmp199 = NULL;
	_tmp198 = NULL;
	vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_init_fragment = (_tmp199 = (_tmp198 = old_instance_init_fragment, (_tmp198 == NULL ? NULL : g_object_ref (_tmp198))), (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_init_fragment == NULL ? NULL : (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_init_fragment = (g_object_unref (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_init_fragment), NULL))), _tmp199);
	_tmp201 = NULL;
	_tmp200 = NULL;
	vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_dispose_fragment = (_tmp201 = (_tmp200 = old_instance_dispose_fragment, (_tmp200 == NULL ? NULL : g_object_ref (_tmp200))), (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_dispose_fragment == NULL ? NULL : (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_dispose_fragment = (g_object_unref (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_dispose_fragment), NULL))), _tmp201);
	(old_symbol == NULL ? NULL : (old_symbol = (g_object_unref (old_symbol), NULL)));
	(old_type_symbol == NULL ? NULL : (old_type_symbol = (g_object_unref (old_type_symbol), NULL)));
	(old_class == NULL ? NULL : (old_class = (g_object_unref (old_class), NULL)));
	(old_instance_struct == NULL ? NULL : (old_instance_struct = (g_object_unref (old_instance_struct), NULL)));
	(old_type_struct == NULL ? NULL : (old_type_struct = (g_object_unref (old_type_struct), NULL)));
	(old_instance_priv_struct == NULL ? NULL : (old_instance_priv_struct = (g_object_unref (old_instance_priv_struct), NULL)));
	(old_prop_enum == NULL ? NULL : (old_prop_enum = (g_object_unref (old_prop_enum), NULL)));
	(old_class_init_fragment == NULL ? NULL : (old_class_init_fragment = (g_object_unref (old_class_init_fragment), NULL)));
	(old_instance_init_fragment == NULL ? NULL : (old_instance_init_fragment = (g_object_unref (old_instance_init_fragment), NULL)));
	(old_instance_dispose_fragment == NULL ? NULL : (old_instance_dispose_fragment = (g_object_unref (old_instance_dispose_fragment), NULL)));
	(decl_frag == NULL ? NULL : (decl_frag = (g_object_unref (decl_frag), NULL)));
	(def_frag == NULL ? NULL : (def_frag = (g_object_unref (def_frag), NULL)));
}


static void vala_ccode_class_binding_add_class_init_function (ValaCCodeClassBinding* self, ValaClass* cl) {
	char* _tmp1;
	char* _tmp0;
	ValaCCodeFunction* _tmp2;
	ValaCCodeFunction* class_init;
	ValaCCodeFormalParameter* _tmp5;
	char* _tmp4;
	char* _tmp3;
	ValaCCodeBlock* init_block;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeDeclaration* parent_decl;
	char* _tmp7;
	char* _tmp6;
	ValaCCodeVariableDeclarator* _tmp8;
	ValaCCodeVariableDeclarator* parent_var_decl;
	ValaCCodeConstant* _tmp9;
	ValaCCodeFunctionCall* _tmp11;
	ValaCCodeIdentifier* _tmp10;
	ValaCCodeIdentifier* _tmp12;
	ValaCCodeIdentifier* _tmp15;
	char* _tmp14;
	char* _tmp13;
	ValaCCodeAssignment* _tmp16;
	ValaCCodeAssignment* parent_assignment;
	ValaCCodeExpressionStatement* _tmp17;
	GeeList* _tmp18;
	gboolean _tmp19;
	ValaCCodeFragment* _tmp152;
	g_return_if_fail (VALA_IS_CCODE_CLASS_BINDING (self));
	g_return_if_fail (VALA_IS_CLASS (cl));
	_tmp1 = NULL;
	_tmp0 = NULL;
	_tmp2 = NULL;
	class_init = (_tmp2 = vala_ccode_function_new ((_tmp1 = g_strdup_printf ("%s_class_init", (_tmp0 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL)))), "void"), (_tmp1 = (g_free (_tmp1), NULL)), (_tmp0 = (g_free (_tmp0), NULL)), _tmp2);
	_tmp5 = NULL;
	_tmp4 = NULL;
	_tmp3 = NULL;
	vala_ccode_function_add_parameter (class_init, (_tmp5 = vala_ccode_formal_parameter_new ("klass", (_tmp4 = g_strdup_printf ("%sClass *", (_tmp3 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (cl), FALSE)))))));
	(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
	_tmp4 = (g_free (_tmp4), NULL);
	_tmp3 = (g_free (_tmp3), NULL);
	vala_ccode_function_set_modifiers (class_init, VALA_CCODE_MODIFIERS_STATIC);
	init_block = vala_ccode_block_new ();
	vala_ccode_function_set_block (class_init, init_block);
	ccall = NULL;
	/* save pointer to parent class */
	parent_decl = vala_ccode_declaration_new ("gpointer");
	_tmp7 = NULL;
	_tmp6 = NULL;
	_tmp8 = NULL;
	parent_var_decl = (_tmp8 = vala_ccode_variable_declarator_new ((_tmp7 = g_strdup_printf ("%s_parent_class", (_tmp6 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL))))), (_tmp7 = (g_free (_tmp7), NULL)), (_tmp6 = (g_free (_tmp6), NULL)), _tmp8);
	_tmp9 = NULL;
	vala_ccode_variable_declarator_set_initializer (parent_var_decl, VALA_CCODE_EXPRESSION ((_tmp9 = vala_ccode_constant_new ("NULL"))));
	(_tmp9 == NULL ? NULL : (_tmp9 = (g_object_unref (_tmp9), NULL)));
	vala_ccode_declaration_add_declarator (parent_decl, VALA_CCODE_DECLARATOR (parent_var_decl));
	vala_ccode_declaration_set_modifiers (parent_decl, VALA_CCODE_MODIFIERS_STATIC);
	vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_declaration, VALA_CCODE_NODE (parent_decl));
	_tmp11 = NULL;
	_tmp10 = NULL;
	ccall = (_tmp11 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp10 = vala_ccode_identifier_new ("g_type_class_peek_parent")))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), _tmp11);
	(_tmp10 == NULL ? NULL : (_tmp10 = (g_object_unref (_tmp10), NULL)));
	_tmp12 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp12 = vala_ccode_identifier_new ("klass"))));
	(_tmp12 == NULL ? NULL : (_tmp12 = (g_object_unref (_tmp12), NULL)));
	_tmp15 = NULL;
	_tmp14 = NULL;
	_tmp13 = NULL;
	_tmp16 = NULL;
	parent_assignment = (_tmp16 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp15 = vala_ccode_identifier_new ((_tmp14 = g_strdup_printf ("%s_parent_class", (_tmp13 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL))))))), VALA_CCODE_EXPRESSION (ccall), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (_tmp15 == NULL ? NULL : (_tmp15 = (g_object_unref (_tmp15), NULL))), (_tmp14 = (g_free (_tmp14), NULL)), (_tmp13 = (g_free (_tmp13), NULL)), _tmp16);
	_tmp17 = NULL;
	vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((_tmp17 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (parent_assignment)))));
	(_tmp17 == NULL ? NULL : (_tmp17 = (g_object_unref (_tmp17), NULL)));
	/* add struct for private fields */
	_tmp18 = NULL;
	if ((_tmp19 = vala_class_get_has_private_fields (cl) || gee_collection_get_size (GEE_COLLECTION ((_tmp18 = vala_class_get_type_parameters (cl)))) > 0, (_tmp18 == NULL ? NULL : (_tmp18 = (g_object_unref (_tmp18), NULL))), _tmp19)) {
		ValaCCodeFunctionCall* _tmp21;
		ValaCCodeIdentifier* _tmp20;
		ValaCCodeIdentifier* _tmp22;
		ValaCCodeConstant* _tmp25;
		char* _tmp24;
		char* _tmp23;
		ValaCCodeExpressionStatement* _tmp26;
		_tmp21 = NULL;
		_tmp20 = NULL;
		ccall = (_tmp21 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp20 = vala_ccode_identifier_new ("g_type_class_add_private")))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), _tmp21);
		(_tmp20 == NULL ? NULL : (_tmp20 = (g_object_unref (_tmp20), NULL)));
		_tmp22 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp22 = vala_ccode_identifier_new ("klass"))));
		(_tmp22 == NULL ? NULL : (_tmp22 = (g_object_unref (_tmp22), NULL)));
		_tmp25 = NULL;
		_tmp24 = NULL;
		_tmp23 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp25 = vala_ccode_constant_new ((_tmp24 = g_strdup_printf ("sizeof (%sPrivate)", (_tmp23 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (cl), FALSE))))))));
		(_tmp25 == NULL ? NULL : (_tmp25 = (g_object_unref (_tmp25), NULL)));
		_tmp24 = (g_free (_tmp24), NULL);
		_tmp23 = (g_free (_tmp23), NULL);
		_tmp26 = NULL;
		vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((_tmp26 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ccall)))));
		(_tmp26 == NULL ? NULL : (_tmp26 = (g_object_unref (_tmp26), NULL)));
	}
	if (vala_typesymbol_is_subtype_of (VALA_TYPESYMBOL (cl), vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->gobject_type)) {
		ValaCCodeFunctionCall* _tmp28;
		ValaCCodeIdentifier* _tmp27;
		ValaCCodeIdentifier* _tmp29;
		GeeList* _tmp30;
		gboolean _tmp31;
		GeeList* _tmp38;
		gboolean _tmp39;
		GeeList* _tmp55;
		gboolean _tmp56;
		/* set property handlers */
		_tmp28 = NULL;
		_tmp27 = NULL;
		ccall = (_tmp28 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp27 = vala_ccode_identifier_new ("G_OBJECT_CLASS")))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), _tmp28);
		(_tmp27 == NULL ? NULL : (_tmp27 = (g_object_unref (_tmp27), NULL)));
		_tmp29 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp29 = vala_ccode_identifier_new ("klass"))));
		(_tmp29 == NULL ? NULL : (_tmp29 = (g_object_unref (_tmp29), NULL)));
		_tmp30 = NULL;
		if ((_tmp31 = vala_ccode_class_binding_class_has_readable_properties (self, cl) || gee_collection_get_size (GEE_COLLECTION ((_tmp30 = vala_class_get_type_parameters (cl)))) > 0, (_tmp30 == NULL ? NULL : (_tmp30 = (g_object_unref (_tmp30), NULL))), _tmp31)) {
			ValaCCodeExpressionStatement* _tmp37;
			ValaCCodeAssignment* _tmp36;
			ValaCCodeIdentifier* _tmp35;
			char* _tmp34;
			char* _tmp33;
			ValaCCodeMemberAccess* _tmp32;
			_tmp37 = NULL;
			_tmp36 = NULL;
			_tmp35 = NULL;
			_tmp34 = NULL;
			_tmp33 = NULL;
			_tmp32 = NULL;
			vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((_tmp37 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp36 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp32 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (ccall), "get_property"))), VALA_CCODE_EXPRESSION ((_tmp35 = vala_ccode_identifier_new ((_tmp34 = g_strdup_printf ("%s_get_property", (_tmp33 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL))))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
			(_tmp37 == NULL ? NULL : (_tmp37 = (g_object_unref (_tmp37), NULL)));
			(_tmp36 == NULL ? NULL : (_tmp36 = (g_object_unref (_tmp36), NULL)));
			(_tmp35 == NULL ? NULL : (_tmp35 = (g_object_unref (_tmp35), NULL)));
			_tmp34 = (g_free (_tmp34), NULL);
			_tmp33 = (g_free (_tmp33), NULL);
			(_tmp32 == NULL ? NULL : (_tmp32 = (g_object_unref (_tmp32), NULL)));
		}
		_tmp38 = NULL;
		if ((_tmp39 = vala_ccode_class_binding_class_has_writable_properties (self, cl) || gee_collection_get_size (GEE_COLLECTION ((_tmp38 = vala_class_get_type_parameters (cl)))) > 0, (_tmp38 == NULL ? NULL : (_tmp38 = (g_object_unref (_tmp38), NULL))), _tmp39)) {
			ValaCCodeExpressionStatement* _tmp45;
			ValaCCodeAssignment* _tmp44;
			ValaCCodeIdentifier* _tmp43;
			char* _tmp42;
			char* _tmp41;
			ValaCCodeMemberAccess* _tmp40;
			_tmp45 = NULL;
			_tmp44 = NULL;
			_tmp43 = NULL;
			_tmp42 = NULL;
			_tmp41 = NULL;
			_tmp40 = NULL;
			vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((_tmp45 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp44 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp40 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (ccall), "set_property"))), VALA_CCODE_EXPRESSION ((_tmp43 = vala_ccode_identifier_new ((_tmp42 = g_strdup_printf ("%s_set_property", (_tmp41 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL))))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
			(_tmp45 == NULL ? NULL : (_tmp45 = (g_object_unref (_tmp45), NULL)));
			(_tmp44 == NULL ? NULL : (_tmp44 = (g_object_unref (_tmp44), NULL)));
			(_tmp43 == NULL ? NULL : (_tmp43 = (g_object_unref (_tmp43), NULL)));
			_tmp42 = (g_free (_tmp42), NULL);
			_tmp41 = (g_free (_tmp41), NULL);
			(_tmp40 == NULL ? NULL : (_tmp40 = (g_object_unref (_tmp40), NULL)));
		}
		/* set constructor */
		if (vala_class_get_constructor (cl) != NULL) {
			ValaCCodeIdentifier* _tmp46;
			ValaCCodeFunctionCall* _tmp47;
			ValaCCodeFunctionCall* ccast;
			ValaCCodeIdentifier* _tmp48;
			ValaCCodeExpressionStatement* _tmp54;
			ValaCCodeAssignment* _tmp53;
			ValaCCodeIdentifier* _tmp52;
			char* _tmp51;
			char* _tmp50;
			ValaCCodeMemberAccess* _tmp49;
			_tmp46 = NULL;
			_tmp47 = NULL;
			ccast = (_tmp47 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp46 = vala_ccode_identifier_new ("G_OBJECT_CLASS")))), (_tmp46 == NULL ? NULL : (_tmp46 = (g_object_unref (_tmp46), NULL))), _tmp47);
			_tmp48 = NULL;
			vala_ccode_function_call_add_argument (ccast, VALA_CCODE_EXPRESSION ((_tmp48 = vala_ccode_identifier_new ("klass"))));
			(_tmp48 == NULL ? NULL : (_tmp48 = (g_object_unref (_tmp48), NULL)));
			_tmp54 = NULL;
			_tmp53 = NULL;
			_tmp52 = NULL;
			_tmp51 = NULL;
			_tmp50 = NULL;
			_tmp49 = NULL;
			vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((_tmp54 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp53 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp49 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (ccast), "constructor"))), VALA_CCODE_EXPRESSION ((_tmp52 = vala_ccode_identifier_new ((_tmp51 = g_strdup_printf ("%s_constructor", (_tmp50 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL))))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
			(_tmp54 == NULL ? NULL : (_tmp54 = (g_object_unref (_tmp54), NULL)));
			(_tmp53 == NULL ? NULL : (_tmp53 = (g_object_unref (_tmp53), NULL)));
			(_tmp52 == NULL ? NULL : (_tmp52 = (g_object_unref (_tmp52), NULL)));
			_tmp51 = (g_free (_tmp51), NULL);
			_tmp50 = (g_free (_tmp50), NULL);
			(_tmp49 == NULL ? NULL : (_tmp49 = (g_object_unref (_tmp49), NULL)));
			(ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL)));
		}
		/* set dispose function */
		_tmp55 = NULL;
		if ((_tmp56 = gee_collection_get_size (GEE_COLLECTION ((_tmp55 = vala_class_get_fields (cl)))) > 0 || vala_class_get_destructor (cl) != NULL, (_tmp55 == NULL ? NULL : (_tmp55 = (g_object_unref (_tmp55), NULL))), _tmp56)) {
			ValaCCodeIdentifier* _tmp57;
			ValaCCodeFunctionCall* _tmp58;
			ValaCCodeFunctionCall* ccast;
			ValaCCodeIdentifier* _tmp59;
			ValaCCodeExpressionStatement* _tmp65;
			ValaCCodeAssignment* _tmp64;
			ValaCCodeIdentifier* _tmp63;
			char* _tmp62;
			char* _tmp61;
			ValaCCodeMemberAccess* _tmp60;
			_tmp57 = NULL;
			_tmp58 = NULL;
			ccast = (_tmp58 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp57 = vala_ccode_identifier_new ("G_OBJECT_CLASS")))), (_tmp57 == NULL ? NULL : (_tmp57 = (g_object_unref (_tmp57), NULL))), _tmp58);
			_tmp59 = NULL;
			vala_ccode_function_call_add_argument (ccast, VALA_CCODE_EXPRESSION ((_tmp59 = vala_ccode_identifier_new ("klass"))));
			(_tmp59 == NULL ? NULL : (_tmp59 = (g_object_unref (_tmp59), NULL)));
			_tmp65 = NULL;
			_tmp64 = NULL;
			_tmp63 = NULL;
			_tmp62 = NULL;
			_tmp61 = NULL;
			_tmp60 = NULL;
			vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((_tmp65 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp64 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp60 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (ccast), "dispose"))), VALA_CCODE_EXPRESSION ((_tmp63 = vala_ccode_identifier_new ((_tmp62 = g_strdup_printf ("%s_dispose", (_tmp61 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL))))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
			(_tmp65 == NULL ? NULL : (_tmp65 = (g_object_unref (_tmp65), NULL)));
			(_tmp64 == NULL ? NULL : (_tmp64 = (g_object_unref (_tmp64), NULL)));
			(_tmp63 == NULL ? NULL : (_tmp63 = (g_object_unref (_tmp63), NULL)));
			_tmp62 = (g_free (_tmp62), NULL);
			_tmp61 = (g_free (_tmp61), NULL);
			(_tmp60 == NULL ? NULL : (_tmp60 = (g_object_unref (_tmp60), NULL)));
			(ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL)));
		}
	}
	/* connect overridden methods */
	{
		GeeList* m_collection;
		int m_it;
		m_collection = vala_object_type_symbol_get_methods (VALA_OBJECT_TYPE_SYMBOL (cl));
		for (m_it = 0; m_it < gee_collection_get_size (GEE_COLLECTION (m_collection)); m_it = m_it + 1) {
			ValaMethod* m;
			m = ((ValaMethod*) (gee_list_get (GEE_LIST (m_collection), m_it)));
			{
				ValaSymbol* _tmp66;
				ValaSymbol* base_type;
				ValaCCodeIdentifier* _tmp69;
				char* _tmp68;
				char* _tmp67;
				ValaCCodeFunctionCall* _tmp70;
				ValaCCodeFunctionCall* ccast;
				ValaCCodeIdentifier* _tmp71;
				ValaCCodeExpressionStatement* _tmp76;
				ValaCCodeAssignment* _tmp75;
				ValaCCodeIdentifier* _tmp74;
				char* _tmp73;
				ValaCCodeMemberAccess* _tmp72;
				if (vala_method_get_base_method (m) == NULL) {
					(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
					continue;
				}
				_tmp66 = NULL;
				base_type = (_tmp66 = vala_symbol_get_parent_symbol (VALA_SYMBOL (vala_method_get_base_method (m))), (_tmp66 == NULL ? NULL : g_object_ref (_tmp66)));
				_tmp69 = NULL;
				_tmp68 = NULL;
				_tmp67 = NULL;
				_tmp70 = NULL;
				ccast = (_tmp70 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp69 = vala_ccode_identifier_new ((_tmp68 = g_strdup_printf ("%s_CLASS", (_tmp67 = vala_typesymbol_get_upper_case_cname (VALA_TYPESYMBOL ((VALA_CLASS (base_type))), NULL)))))))), (_tmp69 == NULL ? NULL : (_tmp69 = (g_object_unref (_tmp69), NULL))), (_tmp68 = (g_free (_tmp68), NULL)), (_tmp67 = (g_free (_tmp67), NULL)), _tmp70);
				_tmp71 = NULL;
				vala_ccode_function_call_add_argument (ccast, VALA_CCODE_EXPRESSION ((_tmp71 = vala_ccode_identifier_new ("klass"))));
				(_tmp71 == NULL ? NULL : (_tmp71 = (g_object_unref (_tmp71), NULL)));
				_tmp76 = NULL;
				_tmp75 = NULL;
				_tmp74 = NULL;
				_tmp73 = NULL;
				_tmp72 = NULL;
				vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((_tmp76 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp75 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp72 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (ccast), vala_method_get_vfunc_name (vala_method_get_base_method (m))))), VALA_CCODE_EXPRESSION ((_tmp74 = vala_ccode_identifier_new ((_tmp73 = vala_method_get_real_cname (m))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
				(_tmp76 == NULL ? NULL : (_tmp76 = (g_object_unref (_tmp76), NULL)));
				(_tmp75 == NULL ? NULL : (_tmp75 = (g_object_unref (_tmp75), NULL)));
				(_tmp74 == NULL ? NULL : (_tmp74 = (g_object_unref (_tmp74), NULL)));
				_tmp73 = (g_free (_tmp73), NULL);
				(_tmp72 == NULL ? NULL : (_tmp72 = (g_object_unref (_tmp72), NULL)));
				(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
				(base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL)));
				(ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL)));
			}
		}
		(m_collection == NULL ? NULL : (m_collection = (g_object_unref (m_collection), NULL)));
	}
	if (vala_typesymbol_is_subtype_of (VALA_TYPESYMBOL (cl), vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->gobject_type)) {
		GeeList* props;
		/* create type, dup_func, and destroy_func properties for generic types */
		{
			GeeList* type_param_collection;
			int type_param_it;
			type_param_collection = vala_class_get_type_parameters (cl);
			for (type_param_it = 0; type_param_it < gee_collection_get_size (GEE_COLLECTION (type_param_collection)); type_param_it = type_param_it + 1) {
				ValaTypeParameter* type_param;
				type_param = ((ValaTypeParameter*) (gee_list_get (GEE_LIST (type_param_collection), type_param_it)));
				{
					char* func_name;
					char* enum_value;
					ValaCCodeConstant* func_name_constant;
					ValaCCodeFunctionCall* cinst;
					ValaCCodeFunctionCall* cspec;
					char* _tmp78;
					char* _tmp77;
					ValaCCodeConstant* _tmp81;
					char* _tmp80;
					char* _tmp79;
					char* _tmp84;
					char* _tmp83;
					char* _tmp82;
					ValaCCodeFunctionCall* _tmp86;
					ValaCCodeIdentifier* _tmp85;
					ValaCCodeConstant* _tmp87;
					ValaCCodeFunctionCall* _tmp89;
					ValaCCodeIdentifier* _tmp88;
					ValaCCodeConstant* _tmp90;
					ValaCCodeConstant* _tmp91;
					ValaCCodeIdentifier* _tmp92;
					ValaCCodeConstant* _tmp93;
					ValaCCodeExpressionStatement* _tmp94;
					ValaCCodeEnumValue* _tmp95;
					char* _tmp97;
					char* _tmp96;
					ValaCCodeConstant* _tmp100;
					char* _tmp99;
					char* _tmp98;
					char* _tmp103;
					char* _tmp102;
					char* _tmp101;
					ValaCCodeFunctionCall* _tmp105;
					ValaCCodeIdentifier* _tmp104;
					ValaCCodeConstant* _tmp106;
					ValaCCodeFunctionCall* _tmp108;
					ValaCCodeIdentifier* _tmp107;
					ValaCCodeConstant* _tmp109;
					ValaCCodeConstant* _tmp110;
					ValaCCodeConstant* _tmp111;
					ValaCCodeExpressionStatement* _tmp112;
					ValaCCodeEnumValue* _tmp113;
					char* _tmp115;
					char* _tmp114;
					ValaCCodeConstant* _tmp118;
					char* _tmp117;
					char* _tmp116;
					char* _tmp121;
					char* _tmp120;
					char* _tmp119;
					ValaCCodeFunctionCall* _tmp123;
					ValaCCodeIdentifier* _tmp122;
					ValaCCodeConstant* _tmp124;
					ValaCCodeFunctionCall* _tmp126;
					ValaCCodeIdentifier* _tmp125;
					ValaCCodeConstant* _tmp127;
					ValaCCodeConstant* _tmp128;
					ValaCCodeConstant* _tmp129;
					ValaCCodeExpressionStatement* _tmp130;
					ValaCCodeEnumValue* _tmp131;
					func_name = NULL;
					enum_value = NULL;
					func_name_constant = NULL;
					cinst = NULL;
					cspec = NULL;
					_tmp78 = NULL;
					_tmp77 = NULL;
					func_name = (_tmp78 = g_strdup_printf ("%s_type", (_tmp77 = g_utf8_strdown (vala_symbol_get_name (VALA_SYMBOL (type_param)), -1))), (func_name = (g_free (func_name), NULL)), _tmp78);
					_tmp77 = (g_free (_tmp77), NULL);
					_tmp81 = NULL;
					_tmp80 = NULL;
					_tmp79 = NULL;
					func_name_constant = (_tmp81 = vala_ccode_constant_new ((_tmp80 = g_strdup_printf ("\"%s-type\"", (_tmp79 = g_utf8_strdown (vala_symbol_get_name (VALA_SYMBOL (type_param)), -1))))), (func_name_constant == NULL ? NULL : (func_name_constant = (g_object_unref (func_name_constant), NULL))), _tmp81);
					_tmp80 = (g_free (_tmp80), NULL);
					_tmp79 = (g_free (_tmp79), NULL);
					_tmp84 = NULL;
					_tmp83 = NULL;
					_tmp82 = NULL;
					enum_value = (_tmp84 = g_utf8_strup ((_tmp83 = g_strdup_printf ("%s_%s", (_tmp82 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL)), func_name)), -1), (enum_value = (g_free (enum_value), NULL)), _tmp84);
					_tmp83 = (g_free (_tmp83), NULL);
					_tmp82 = (g_free (_tmp82), NULL);
					_tmp86 = NULL;
					_tmp85 = NULL;
					cinst = (_tmp86 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp85 = vala_ccode_identifier_new ("g_object_class_install_property")))), (cinst == NULL ? NULL : (cinst = (g_object_unref (cinst), NULL))), _tmp86);
					(_tmp85 == NULL ? NULL : (_tmp85 = (g_object_unref (_tmp85), NULL)));
					vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION (ccall));
					_tmp87 = NULL;
					vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION ((_tmp87 = vala_ccode_constant_new (enum_value))));
					(_tmp87 == NULL ? NULL : (_tmp87 = (g_object_unref (_tmp87), NULL)));
					_tmp89 = NULL;
					_tmp88 = NULL;
					cspec = (_tmp89 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp88 = vala_ccode_identifier_new ("g_param_spec_gtype")))), (cspec == NULL ? NULL : (cspec = (g_object_unref (cspec), NULL))), _tmp89);
					(_tmp88 == NULL ? NULL : (_tmp88 = (g_object_unref (_tmp88), NULL)));
					vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION (func_name_constant));
					_tmp90 = NULL;
					vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp90 = vala_ccode_constant_new ("\"type\""))));
					(_tmp90 == NULL ? NULL : (_tmp90 = (g_object_unref (_tmp90), NULL)));
					_tmp91 = NULL;
					vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp91 = vala_ccode_constant_new ("\"type\""))));
					(_tmp91 == NULL ? NULL : (_tmp91 = (g_object_unref (_tmp91), NULL)));
					_tmp92 = NULL;
					vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp92 = vala_ccode_identifier_new ("G_TYPE_NONE"))));
					(_tmp92 == NULL ? NULL : (_tmp92 = (g_object_unref (_tmp92), NULL)));
					_tmp93 = NULL;
					vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp93 = vala_ccode_constant_new ("G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY"))));
					(_tmp93 == NULL ? NULL : (_tmp93 = (g_object_unref (_tmp93), NULL)));
					vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION (cspec));
					_tmp94 = NULL;
					vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((_tmp94 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cinst)))));
					(_tmp94 == NULL ? NULL : (_tmp94 = (g_object_unref (_tmp94), NULL)));
					_tmp95 = NULL;
					vala_ccode_enum_add_value (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->prop_enum, (_tmp95 = vala_ccode_enum_value_new (enum_value, NULL)));
					(_tmp95 == NULL ? NULL : (_tmp95 = (g_object_unref (_tmp95), NULL)));
					vala_ccode_struct_add_field (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_priv_struct, "GType", func_name);
					_tmp97 = NULL;
					_tmp96 = NULL;
					func_name = (_tmp97 = g_strdup_printf ("%s_dup_func", (_tmp96 = g_utf8_strdown (vala_symbol_get_name (VALA_SYMBOL (type_param)), -1))), (func_name = (g_free (func_name), NULL)), _tmp97);
					_tmp96 = (g_free (_tmp96), NULL);
					_tmp100 = NULL;
					_tmp99 = NULL;
					_tmp98 = NULL;
					func_name_constant = (_tmp100 = vala_ccode_constant_new ((_tmp99 = g_strdup_printf ("\"%s-dup-func\"", (_tmp98 = g_utf8_strdown (vala_symbol_get_name (VALA_SYMBOL (type_param)), -1))))), (func_name_constant == NULL ? NULL : (func_name_constant = (g_object_unref (func_name_constant), NULL))), _tmp100);
					_tmp99 = (g_free (_tmp99), NULL);
					_tmp98 = (g_free (_tmp98), NULL);
					_tmp103 = NULL;
					_tmp102 = NULL;
					_tmp101 = NULL;
					enum_value = (_tmp103 = g_utf8_strup ((_tmp102 = g_strdup_printf ("%s_%s", (_tmp101 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL)), func_name)), -1), (enum_value = (g_free (enum_value), NULL)), _tmp103);
					_tmp102 = (g_free (_tmp102), NULL);
					_tmp101 = (g_free (_tmp101), NULL);
					_tmp105 = NULL;
					_tmp104 = NULL;
					cinst = (_tmp105 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp104 = vala_ccode_identifier_new ("g_object_class_install_property")))), (cinst == NULL ? NULL : (cinst = (g_object_unref (cinst), NULL))), _tmp105);
					(_tmp104 == NULL ? NULL : (_tmp104 = (g_object_unref (_tmp104), NULL)));
					vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION (ccall));
					_tmp106 = NULL;
					vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION ((_tmp106 = vala_ccode_constant_new (enum_value))));
					(_tmp106 == NULL ? NULL : (_tmp106 = (g_object_unref (_tmp106), NULL)));
					_tmp108 = NULL;
					_tmp107 = NULL;
					cspec = (_tmp108 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp107 = vala_ccode_identifier_new ("g_param_spec_pointer")))), (cspec == NULL ? NULL : (cspec = (g_object_unref (cspec), NULL))), _tmp108);
					(_tmp107 == NULL ? NULL : (_tmp107 = (g_object_unref (_tmp107), NULL)));
					vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION (func_name_constant));
					_tmp109 = NULL;
					vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp109 = vala_ccode_constant_new ("\"dup func\""))));
					(_tmp109 == NULL ? NULL : (_tmp109 = (g_object_unref (_tmp109), NULL)));
					_tmp110 = NULL;
					vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp110 = vala_ccode_constant_new ("\"dup func\""))));
					(_tmp110 == NULL ? NULL : (_tmp110 = (g_object_unref (_tmp110), NULL)));
					_tmp111 = NULL;
					vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp111 = vala_ccode_constant_new ("G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY"))));
					(_tmp111 == NULL ? NULL : (_tmp111 = (g_object_unref (_tmp111), NULL)));
					vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION (cspec));
					_tmp112 = NULL;
					vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((_tmp112 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cinst)))));
					(_tmp112 == NULL ? NULL : (_tmp112 = (g_object_unref (_tmp112), NULL)));
					_tmp113 = NULL;
					vala_ccode_enum_add_value (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->prop_enum, (_tmp113 = vala_ccode_enum_value_new (enum_value, NULL)));
					(_tmp113 == NULL ? NULL : (_tmp113 = (g_object_unref (_tmp113), NULL)));
					vala_ccode_struct_add_field (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_priv_struct, "GBoxedCopyFunc", func_name);
					_tmp115 = NULL;
					_tmp114 = NULL;
					func_name = (_tmp115 = g_strdup_printf ("%s_destroy_func", (_tmp114 = g_utf8_strdown (vala_symbol_get_name (VALA_SYMBOL (type_param)), -1))), (func_name = (g_free (func_name), NULL)), _tmp115);
					_tmp114 = (g_free (_tmp114), NULL);
					_tmp118 = NULL;
					_tmp117 = NULL;
					_tmp116 = NULL;
					func_name_constant = (_tmp118 = vala_ccode_constant_new ((_tmp117 = g_strdup_printf ("\"%s-destroy-func\"", (_tmp116 = g_utf8_strdown (vala_symbol_get_name (VALA_SYMBOL (type_param)), -1))))), (func_name_constant == NULL ? NULL : (func_name_constant = (g_object_unref (func_name_constant), NULL))), _tmp118);
					_tmp117 = (g_free (_tmp117), NULL);
					_tmp116 = (g_free (_tmp116), NULL);
					_tmp121 = NULL;
					_tmp120 = NULL;
					_tmp119 = NULL;
					enum_value = (_tmp121 = g_utf8_strup ((_tmp120 = g_strdup_printf ("%s_%s", (_tmp119 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL)), func_name)), -1), (enum_value = (g_free (enum_value), NULL)), _tmp121);
					_tmp120 = (g_free (_tmp120), NULL);
					_tmp119 = (g_free (_tmp119), NULL);
					_tmp123 = NULL;
					_tmp122 = NULL;
					cinst = (_tmp123 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp122 = vala_ccode_identifier_new ("g_object_class_install_property")))), (cinst == NULL ? NULL : (cinst = (g_object_unref (cinst), NULL))), _tmp123);
					(_tmp122 == NULL ? NULL : (_tmp122 = (g_object_unref (_tmp122), NULL)));
					vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION (ccall));
					_tmp124 = NULL;
					vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION ((_tmp124 = vala_ccode_constant_new (enum_value))));
					(_tmp124 == NULL ? NULL : (_tmp124 = (g_object_unref (_tmp124), NULL)));
					_tmp126 = NULL;
					_tmp125 = NULL;
					cspec = (_tmp126 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp125 = vala_ccode_identifier_new ("g_param_spec_pointer")))), (cspec == NULL ? NULL : (cspec = (g_object_unref (cspec), NULL))), _tmp126);
					(_tmp125 == NULL ? NULL : (_tmp125 = (g_object_unref (_tmp125), NULL)));
					vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION (func_name_constant));
					_tmp127 = NULL;
					vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp127 = vala_ccode_constant_new ("\"destroy func\""))));
					(_tmp127 == NULL ? NULL : (_tmp127 = (g_object_unref (_tmp127), NULL)));
					_tmp128 = NULL;
					vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp128 = vala_ccode_constant_new ("\"destroy func\""))));
					(_tmp128 == NULL ? NULL : (_tmp128 = (g_object_unref (_tmp128), NULL)));
					_tmp129 = NULL;
					vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp129 = vala_ccode_constant_new ("G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY"))));
					(_tmp129 == NULL ? NULL : (_tmp129 = (g_object_unref (_tmp129), NULL)));
					vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION (cspec));
					_tmp130 = NULL;
					vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((_tmp130 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cinst)))));
					(_tmp130 == NULL ? NULL : (_tmp130 = (g_object_unref (_tmp130), NULL)));
					_tmp131 = NULL;
					vala_ccode_enum_add_value (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->prop_enum, (_tmp131 = vala_ccode_enum_value_new (enum_value, NULL)));
					(_tmp131 == NULL ? NULL : (_tmp131 = (g_object_unref (_tmp131), NULL)));
					vala_ccode_struct_add_field (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_priv_struct, "GDestroyNotify", func_name);
					(type_param == NULL ? NULL : (type_param = (g_object_unref (type_param), NULL)));
					func_name = (g_free (func_name), NULL);
					enum_value = (g_free (enum_value), NULL);
					(func_name_constant == NULL ? NULL : (func_name_constant = (g_object_unref (func_name_constant), NULL)));
					(cinst == NULL ? NULL : (cinst = (g_object_unref (cinst), NULL)));
					(cspec == NULL ? NULL : (cspec = (g_object_unref (cspec), NULL)));
				}
			}
			(type_param_collection == NULL ? NULL : (type_param_collection = (g_object_unref (type_param_collection), NULL)));
		}
		/* create properties */
		props = vala_object_type_symbol_get_properties (VALA_OBJECT_TYPE_SYMBOL (cl));
		{
			GeeList* prop_collection;
			int prop_it;
			prop_collection = props;
			for (prop_it = 0; prop_it < gee_collection_get_size (GEE_COLLECTION (prop_collection)); prop_it = prop_it + 1) {
				ValaProperty* prop;
				prop = ((ValaProperty*) (gee_list_get (GEE_LIST (prop_collection), prop_it)));
				{
					/* FIXME: omit real struct types for now since they cannot be expressed as gobject property yet*/
					if (vala_data_type_is_real_struct_type (vala_property_get_property_type (prop))) {
						(prop == NULL ? NULL : (prop = (g_object_unref (prop), NULL)));
						continue;
					}
					if (vala_symbol_get_access (VALA_SYMBOL (prop)) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
						/* don't register private properties*/
						(prop == NULL ? NULL : (prop = (g_object_unref (prop), NULL)));
						continue;
					}
					if (vala_property_get_overrides (prop) || vala_property_get_base_interface_property (prop) != NULL) {
						ValaCCodeIdentifier* _tmp132;
						ValaCCodeFunctionCall* _tmp133;
						ValaCCodeFunctionCall* cinst;
						ValaCCodeConstant* _tmp135;
						char* _tmp134;
						ValaCCodeConstant* _tmp136;
						ValaCCodeExpressionStatement* _tmp137;
						_tmp132 = NULL;
						_tmp133 = NULL;
						cinst = (_tmp133 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp132 = vala_ccode_identifier_new ("g_object_class_override_property")))), (_tmp132 == NULL ? NULL : (_tmp132 = (g_object_unref (_tmp132), NULL))), _tmp133);
						vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION (ccall));
						_tmp135 = NULL;
						_tmp134 = NULL;
						vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION ((_tmp135 = vala_ccode_constant_new ((_tmp134 = vala_property_get_upper_case_cname (prop))))));
						(_tmp135 == NULL ? NULL : (_tmp135 = (g_object_unref (_tmp135), NULL)));
						_tmp134 = (g_free (_tmp134), NULL);
						_tmp136 = NULL;
						vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION ((_tmp136 = vala_property_get_canonical_cconstant (prop))));
						(_tmp136 == NULL ? NULL : (_tmp136 = (g_object_unref (_tmp136), NULL)));
						_tmp137 = NULL;
						vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((_tmp137 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cinst)))));
						(_tmp137 == NULL ? NULL : (_tmp137 = (g_object_unref (_tmp137), NULL)));
						(cinst == NULL ? NULL : (cinst = (g_object_unref (cinst), NULL)));
					} else {
						ValaCCodeIdentifier* _tmp138;
						ValaCCodeFunctionCall* _tmp139;
						ValaCCodeFunctionCall* cinst;
						ValaCCodeConstant* _tmp141;
						char* _tmp140;
						ValaCCodeFunctionCall* _tmp142;
						ValaCCodeExpressionStatement* _tmp143;
						_tmp138 = NULL;
						_tmp139 = NULL;
						cinst = (_tmp139 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp138 = vala_ccode_identifier_new ("g_object_class_install_property")))), (_tmp138 == NULL ? NULL : (_tmp138 = (g_object_unref (_tmp138), NULL))), _tmp139);
						vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION (ccall));
						_tmp141 = NULL;
						_tmp140 = NULL;
						vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION ((_tmp141 = vala_ccode_constant_new ((_tmp140 = vala_property_get_upper_case_cname (prop))))));
						(_tmp141 == NULL ? NULL : (_tmp141 = (g_object_unref (_tmp141), NULL)));
						_tmp140 = (g_free (_tmp140), NULL);
						_tmp142 = NULL;
						vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION ((_tmp142 = vala_ccode_type_symbol_binding_get_param_spec (VALA_CCODE_TYPE_SYMBOL_BINDING (self), prop))));
						(_tmp142 == NULL ? NULL : (_tmp142 = (g_object_unref (_tmp142), NULL)));
						_tmp143 = NULL;
						vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((_tmp143 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cinst)))));
						(_tmp143 == NULL ? NULL : (_tmp143 = (g_object_unref (_tmp143), NULL)));
						(cinst == NULL ? NULL : (cinst = (g_object_unref (cinst), NULL)));
					}
					(prop == NULL ? NULL : (prop = (g_object_unref (prop), NULL)));
				}
			}
		}
		/* create signals */
		{
			GeeList* sig_collection;
			int sig_it;
			sig_collection = vala_object_type_symbol_get_signals (VALA_OBJECT_TYPE_SYMBOL (cl));
			for (sig_it = 0; sig_it < gee_collection_get_size (GEE_COLLECTION (sig_collection)); sig_it = sig_it + 1) {
				ValaSignal* sig;
				sig = ((ValaSignal*) (gee_list_get (GEE_LIST (sig_collection), sig_it)));
				{
					ValaCCodeExpressionStatement* _tmp145;
					ValaCCodeFunctionCall* _tmp144;
					_tmp145 = NULL;
					_tmp144 = NULL;
					vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((_tmp145 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp144 = vala_ccode_type_symbol_binding_get_signal_creation (VALA_CCODE_TYPE_SYMBOL_BINDING (self), sig, VALA_TYPESYMBOL (cl))))))));
					(_tmp145 == NULL ? NULL : (_tmp145 = (g_object_unref (_tmp145), NULL)));
					(_tmp144 == NULL ? NULL : (_tmp144 = (g_object_unref (_tmp144), NULL)));
					(sig == NULL ? NULL : (sig = (g_object_unref (sig), NULL)));
				}
			}
			(sig_collection == NULL ? NULL : (sig_collection = (g_object_unref (sig_collection), NULL)));
		}
		(props == NULL ? NULL : (props = (g_object_unref (props), NULL)));
	} else {
		if (!vala_class_get_is_compact (cl)) {
			/* create type, dup_func, and destroy_func fields for generic types */
			{
				GeeList* type_param_collection;
				int type_param_it;
				type_param_collection = vala_class_get_type_parameters (cl);
				for (type_param_it = 0; type_param_it < gee_collection_get_size (GEE_COLLECTION (type_param_collection)); type_param_it = type_param_it + 1) {
					ValaTypeParameter* type_param;
					type_param = ((ValaTypeParameter*) (gee_list_get (GEE_LIST (type_param_collection), type_param_it)));
					{
						char* func_name;
						char* _tmp147;
						char* _tmp146;
						char* _tmp149;
						char* _tmp148;
						char* _tmp151;
						char* _tmp150;
						func_name = NULL;
						_tmp147 = NULL;
						_tmp146 = NULL;
						func_name = (_tmp147 = g_strdup_printf ("%s_type", (_tmp146 = g_utf8_strdown (vala_symbol_get_name (VALA_SYMBOL (type_param)), -1))), (func_name = (g_free (func_name), NULL)), _tmp147);
						_tmp146 = (g_free (_tmp146), NULL);
						vala_ccode_struct_add_field (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_priv_struct, "GType", func_name);
						_tmp149 = NULL;
						_tmp148 = NULL;
						func_name = (_tmp149 = g_strdup_printf ("%s_dup_func", (_tmp148 = g_utf8_strdown (vala_symbol_get_name (VALA_SYMBOL (type_param)), -1))), (func_name = (g_free (func_name), NULL)), _tmp149);
						_tmp148 = (g_free (_tmp148), NULL);
						vala_ccode_struct_add_field (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_priv_struct, "GBoxedCopyFunc", func_name);
						_tmp151 = NULL;
						_tmp150 = NULL;
						func_name = (_tmp151 = g_strdup_printf ("%s_destroy_func", (_tmp150 = g_utf8_strdown (vala_symbol_get_name (VALA_SYMBOL (type_param)), -1))), (func_name = (g_free (func_name), NULL)), _tmp151);
						_tmp150 = (g_free (_tmp150), NULL);
						vala_ccode_struct_add_field (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_priv_struct, "GDestroyNotify", func_name);
						(type_param == NULL ? NULL : (type_param = (g_object_unref (type_param), NULL)));
						func_name = (g_free (func_name), NULL);
					}
				}
				(type_param_collection == NULL ? NULL : (type_param_collection = (g_object_unref (type_param_collection), NULL)));
			}
		}
	}
	_tmp152 = NULL;
	vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((_tmp152 = vala_ccode_object_type_symbol_binding_register_dbus_info (VALA_CCODE_OBJECT_TYPE_SYMBOL_BINDING (self), VALA_OBJECT_TYPE_SYMBOL (cl)))));
	(_tmp152 == NULL ? NULL : (_tmp152 = (g_object_unref (_tmp152), NULL)));
	vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->class_init_fragment));
	vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_definition, VALA_CCODE_NODE (class_init));
	(class_init == NULL ? NULL : (class_init = (g_object_unref (class_init), NULL)));
	(init_block == NULL ? NULL : (init_block = (g_object_unref (init_block), NULL)));
	(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	(parent_decl == NULL ? NULL : (parent_decl = (g_object_unref (parent_decl), NULL)));
	(parent_var_decl == NULL ? NULL : (parent_var_decl = (g_object_unref (parent_var_decl), NULL)));
	(parent_assignment == NULL ? NULL : (parent_assignment = (g_object_unref (parent_assignment), NULL)));
}


static void vala_ccode_class_binding_add_interface_init_function (ValaCCodeClassBinding* self, ValaClass* cl, ValaInterface* iface) {
	char* _tmp2;
	char* _tmp1;
	char* _tmp0;
	ValaCCodeFunction* _tmp3;
	ValaCCodeFunction* iface_init;
	ValaCCodeFormalParameter* _tmp6;
	char* _tmp5;
	char* _tmp4;
	ValaCCodeBlock* init_block;
	ValaCCodeFunctionCall* ccall;
	char* _tmp8;
	char* _tmp7;
	char* _tmp9;
	char* parent_iface_var;
	char* _tmp11;
	char* _tmp10;
	ValaCCodeDeclaration* _tmp12;
	ValaCCodeDeclaration* parent_decl;
	ValaCCodeVariableDeclarator* parent_var_decl;
	ValaCCodeConstant* _tmp13;
	ValaCCodeFunctionCall* _tmp15;
	ValaCCodeIdentifier* _tmp14;
	ValaCCodeIdentifier* _tmp16;
	ValaCCodeIdentifier* _tmp17;
	ValaCCodeAssignment* _tmp18;
	ValaCCodeAssignment* parent_assignment;
	ValaCCodeExpressionStatement* _tmp19;
	g_return_if_fail (VALA_IS_CCODE_CLASS_BINDING (self));
	g_return_if_fail (VALA_IS_CLASS (cl));
	g_return_if_fail (VALA_IS_INTERFACE (iface));
	_tmp2 = NULL;
	_tmp1 = NULL;
	_tmp0 = NULL;
	_tmp3 = NULL;
	iface_init = (_tmp3 = vala_ccode_function_new ((_tmp2 = g_strdup_printf ("%s_%s_interface_init", (_tmp0 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL)), (_tmp1 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (iface), NULL)))), "void"), (_tmp2 = (g_free (_tmp2), NULL)), (_tmp1 = (g_free (_tmp1), NULL)), (_tmp0 = (g_free (_tmp0), NULL)), _tmp3);
	_tmp6 = NULL;
	_tmp5 = NULL;
	_tmp4 = NULL;
	vala_ccode_function_add_parameter (iface_init, (_tmp6 = vala_ccode_formal_parameter_new ("iface", (_tmp5 = g_strdup_printf ("%s *", (_tmp4 = vala_interface_get_type_cname (iface)))))));
	(_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL)));
	_tmp5 = (g_free (_tmp5), NULL);
	_tmp4 = (g_free (_tmp4), NULL);
	vala_ccode_function_set_modifiers (iface_init, VALA_CCODE_MODIFIERS_STATIC);
	init_block = vala_ccode_block_new ();
	vala_ccode_function_set_block (iface_init, init_block);
	ccall = NULL;
	/* save pointer to parent vtable */
	_tmp8 = NULL;
	_tmp7 = NULL;
	_tmp9 = NULL;
	parent_iface_var = (_tmp9 = g_strdup_printf ("%s_%s_parent_iface", (_tmp7 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL)), (_tmp8 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (iface), NULL))), (_tmp8 = (g_free (_tmp8), NULL)), (_tmp7 = (g_free (_tmp7), NULL)), _tmp9);
	_tmp11 = NULL;
	_tmp10 = NULL;
	_tmp12 = NULL;
	parent_decl = (_tmp12 = vala_ccode_declaration_new ((_tmp11 = g_strconcat ((_tmp10 = vala_interface_get_type_cname (iface)), "*", NULL))), (_tmp11 = (g_free (_tmp11), NULL)), (_tmp10 = (g_free (_tmp10), NULL)), _tmp12);
	parent_var_decl = vala_ccode_variable_declarator_new (parent_iface_var);
	_tmp13 = NULL;
	vala_ccode_variable_declarator_set_initializer (parent_var_decl, VALA_CCODE_EXPRESSION ((_tmp13 = vala_ccode_constant_new ("NULL"))));
	(_tmp13 == NULL ? NULL : (_tmp13 = (g_object_unref (_tmp13), NULL)));
	vala_ccode_declaration_add_declarator (parent_decl, VALA_CCODE_DECLARATOR (parent_var_decl));
	vala_ccode_declaration_set_modifiers (parent_decl, VALA_CCODE_MODIFIERS_STATIC);
	vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_declaration, VALA_CCODE_NODE (parent_decl));
	_tmp15 = NULL;
	_tmp14 = NULL;
	ccall = (_tmp15 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp14 = vala_ccode_identifier_new ("g_type_interface_peek_parent")))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), _tmp15);
	(_tmp14 == NULL ? NULL : (_tmp14 = (g_object_unref (_tmp14), NULL)));
	_tmp16 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp16 = vala_ccode_identifier_new ("iface"))));
	(_tmp16 == NULL ? NULL : (_tmp16 = (g_object_unref (_tmp16), NULL)));
	_tmp17 = NULL;
	_tmp18 = NULL;
	parent_assignment = (_tmp18 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp17 = vala_ccode_identifier_new (parent_iface_var))), VALA_CCODE_EXPRESSION (ccall), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (_tmp17 == NULL ? NULL : (_tmp17 = (g_object_unref (_tmp17), NULL))), _tmp18);
	_tmp19 = NULL;
	vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((_tmp19 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (parent_assignment)))));
	(_tmp19 == NULL ? NULL : (_tmp19 = (g_object_unref (_tmp19), NULL)));
	{
		GeeList* m_collection;
		int m_it;
		m_collection = vala_object_type_symbol_get_methods (VALA_OBJECT_TYPE_SYMBOL (cl));
		for (m_it = 0; m_it < gee_collection_get_size (GEE_COLLECTION (m_collection)); m_it = m_it + 1) {
			ValaMethod* m;
			m = ((ValaMethod*) (gee_list_get (GEE_LIST (m_collection), m_it)));
			{
				ValaSymbol* _tmp20;
				ValaSymbol* base_type;
				ValaCCodeIdentifier* ciface;
				char* cname;
				ValaCCodeExpressionStatement* _tmp25;
				ValaCCodeAssignment* _tmp24;
				ValaCCodeIdentifier* _tmp23;
				ValaCCodeMemberAccess* _tmp22;
				if (vala_method_get_base_interface_method (m) == NULL) {
					(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
					continue;
				}
				_tmp20 = NULL;
				base_type = (_tmp20 = vala_symbol_get_parent_symbol (VALA_SYMBOL (vala_method_get_base_interface_method (m))), (_tmp20 == NULL ? NULL : g_object_ref (_tmp20)));
				if (base_type != VALA_SYMBOL (iface)) {
					(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
					(base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL)));
					continue;
				}
				ciface = vala_ccode_identifier_new ("iface");
				cname = vala_method_get_real_cname (m);
				if (vala_method_get_is_abstract (m) || vala_method_get_is_virtual (m)) {
					char* _tmp21;
					/* FIXME results in C compiler warning*/
					_tmp21 = NULL;
					cname = (_tmp21 = vala_method_get_cname (m), (cname = (g_free (cname), NULL)), _tmp21);
				}
				_tmp25 = NULL;
				_tmp24 = NULL;
				_tmp23 = NULL;
				_tmp22 = NULL;
				vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((_tmp25 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp24 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp22 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (ciface), vala_method_get_vfunc_name (vala_method_get_base_interface_method (m))))), VALA_CCODE_EXPRESSION ((_tmp23 = vala_ccode_identifier_new (cname))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
				(_tmp25 == NULL ? NULL : (_tmp25 = (g_object_unref (_tmp25), NULL)));
				(_tmp24 == NULL ? NULL : (_tmp24 = (g_object_unref (_tmp24), NULL)));
				(_tmp23 == NULL ? NULL : (_tmp23 = (g_object_unref (_tmp23), NULL)));
				(_tmp22 == NULL ? NULL : (_tmp22 = (g_object_unref (_tmp22), NULL)));
				(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
				(base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL)));
				(ciface == NULL ? NULL : (ciface = (g_object_unref (ciface), NULL)));
				cname = (g_free (cname), NULL);
			}
		}
		(m_collection == NULL ? NULL : (m_collection = (g_object_unref (m_collection), NULL)));
	}
	vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_definition, VALA_CCODE_NODE (iface_init));
	(iface_init == NULL ? NULL : (iface_init = (g_object_unref (iface_init), NULL)));
	(init_block == NULL ? NULL : (init_block = (g_object_unref (init_block), NULL)));
	(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	parent_iface_var = (g_free (parent_iface_var), NULL);
	(parent_decl == NULL ? NULL : (parent_decl = (g_object_unref (parent_decl), NULL)));
	(parent_var_decl == NULL ? NULL : (parent_var_decl = (g_object_unref (parent_var_decl), NULL)));
	(parent_assignment == NULL ? NULL : (parent_assignment = (g_object_unref (parent_assignment), NULL)));
}


static void vala_ccode_class_binding_add_instance_init_function (ValaCCodeClassBinding* self, ValaClass* cl) {
	char* _tmp1;
	char* _tmp0;
	ValaCCodeFunction* _tmp2;
	ValaCCodeFunction* instance_init;
	ValaCCodeFormalParameter* _tmp5;
	char* _tmp4;
	char* _tmp3;
	ValaCCodeBlock* init_block;
	GeeList* _tmp6;
	gboolean _tmp7;
	g_return_if_fail (VALA_IS_CCODE_CLASS_BINDING (self));
	g_return_if_fail (VALA_IS_CLASS (cl));
	_tmp1 = NULL;
	_tmp0 = NULL;
	_tmp2 = NULL;
	instance_init = (_tmp2 = vala_ccode_function_new ((_tmp1 = g_strdup_printf ("%s_instance_init", (_tmp0 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL)))), "void"), (_tmp1 = (g_free (_tmp1), NULL)), (_tmp0 = (g_free (_tmp0), NULL)), _tmp2);
	_tmp5 = NULL;
	_tmp4 = NULL;
	_tmp3 = NULL;
	vala_ccode_function_add_parameter (instance_init, (_tmp5 = vala_ccode_formal_parameter_new ("self", (_tmp4 = g_strdup_printf ("%s *", (_tmp3 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (cl), FALSE)))))));
	(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
	_tmp4 = (g_free (_tmp4), NULL);
	_tmp3 = (g_free (_tmp3), NULL);
	vala_ccode_function_set_modifiers (instance_init, VALA_CCODE_MODIFIERS_STATIC);
	init_block = vala_ccode_block_new ();
	vala_ccode_function_set_block (instance_init, init_block);
	_tmp6 = NULL;
	if ((_tmp7 = vala_class_get_has_private_fields (cl) || gee_collection_get_size (GEE_COLLECTION ((_tmp6 = vala_class_get_type_parameters (cl)))) > 0, (_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL))), _tmp7)) {
		ValaCCodeIdentifier* _tmp10;
		char* _tmp9;
		char* _tmp8;
		ValaCCodeFunctionCall* _tmp11;
		ValaCCodeFunctionCall* ccall;
		ValaCCodeIdentifier* _tmp12;
		ValaCCodeExpressionStatement* _tmp16;
		ValaCCodeAssignment* _tmp15;
		ValaCCodeMemberAccess* _tmp14;
		ValaCCodeIdentifier* _tmp13;
		_tmp10 = NULL;
		_tmp9 = NULL;
		_tmp8 = NULL;
		_tmp11 = NULL;
		ccall = (_tmp11 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp10 = vala_ccode_identifier_new ((_tmp9 = g_strdup_printf ("%s_GET_PRIVATE", (_tmp8 = vala_typesymbol_get_upper_case_cname (VALA_TYPESYMBOL (cl), NULL)))))))), (_tmp10 == NULL ? NULL : (_tmp10 = (g_object_unref (_tmp10), NULL))), (_tmp9 = (g_free (_tmp9), NULL)), (_tmp8 = (g_free (_tmp8), NULL)), _tmp11);
		_tmp12 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp12 = vala_ccode_identifier_new ("self"))));
		(_tmp12 == NULL ? NULL : (_tmp12 = (g_object_unref (_tmp12), NULL)));
		_tmp16 = NULL;
		_tmp15 = NULL;
		_tmp14 = NULL;
		_tmp13 = NULL;
		vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((_tmp16 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp15 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp14 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp13 = vala_ccode_identifier_new ("self"))), "priv"))), VALA_CCODE_EXPRESSION (ccall), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
		(_tmp16 == NULL ? NULL : (_tmp16 = (g_object_unref (_tmp16), NULL)));
		(_tmp15 == NULL ? NULL : (_tmp15 = (g_object_unref (_tmp15), NULL)));
		(_tmp14 == NULL ? NULL : (_tmp14 = (g_object_unref (_tmp14), NULL)));
		(_tmp13 == NULL ? NULL : (_tmp13 = (g_object_unref (_tmp13), NULL)));
		(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	}
	vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_init_fragment));
	vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_definition, VALA_CCODE_NODE (instance_init));
	(instance_init == NULL ? NULL : (instance_init = (g_object_unref (instance_init), NULL)));
	(init_block == NULL ? NULL : (init_block = (g_object_unref (init_block), NULL)));
}


static void vala_ccode_class_binding_add_dispose_function (ValaCCodeClassBinding* self, ValaClass* cl) {
	char* _tmp1;
	char* _tmp0;
	ValaCCodeFunction* _tmp2;
	ValaCCodeFunction* function;
	ValaCCodeFormalParameter* _tmp3;
	ValaCCodeFunction* _tmp4;
	ValaCCodeBlock* cblock;
	ValaCCodeIdentifier* _tmp5;
	ValaCCodeFunctionCall* _tmp6;
	ValaCCodeFunctionCall* ccall;
	char* _tmp8;
	char* _tmp7;
	ValaCCodeDeclaration* _tmp9;
	ValaCCodeDeclaration* cdecl_;
	ValaCCodeVariableDeclarator* _tmp10;
	ValaCCodeIdentifier* _tmp11;
	ValaCCodeFunctionCall* _tmp12;
	ValaCCodeFunctionCall* ccast;
	ValaCCodeIdentifier* _tmp15;
	char* _tmp14;
	char* _tmp13;
	ValaCCodeFunctionCall* _tmp17;
	ValaCCodeMemberAccess* _tmp16;
	ValaCCodeIdentifier* _tmp18;
	ValaCCodeExpressionStatement* _tmp19;
	g_return_if_fail (VALA_IS_CCODE_CLASS_BINDING (self));
	g_return_if_fail (VALA_IS_CLASS (cl));
	_tmp1 = NULL;
	_tmp0 = NULL;
	_tmp2 = NULL;
	function = (_tmp2 = vala_ccode_function_new ((_tmp1 = g_strdup_printf ("%s_dispose", (_tmp0 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL)))), "void"), (_tmp1 = (g_free (_tmp1), NULL)), (_tmp0 = (g_free (_tmp0), NULL)), _tmp2);
	vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
	_tmp3 = NULL;
	vala_ccode_function_add_parameter (function, (_tmp3 = vala_ccode_formal_parameter_new ("obj", "GObject *")));
	(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
	_tmp4 = NULL;
	vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_declaration, VALA_CCODE_NODE ((_tmp4 = vala_ccode_function_copy (function))));
	(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
	cblock = vala_ccode_block_new ();
	_tmp5 = NULL;
	_tmp6 = NULL;
	ccall = (_tmp6 = VALA_CCODE_FUNCTION_CALL (vala_instance_cast_new (VALA_CCODE_EXPRESSION ((_tmp5 = vala_ccode_identifier_new ("obj"))), VALA_TYPESYMBOL (cl))), (_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL))), _tmp6);
	_tmp8 = NULL;
	_tmp7 = NULL;
	_tmp9 = NULL;
	cdecl_ = (_tmp9 = vala_ccode_declaration_new ((_tmp8 = g_strdup_printf ("%s *", (_tmp7 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (cl), FALSE))))), (_tmp8 = (g_free (_tmp8), NULL)), (_tmp7 = (g_free (_tmp7), NULL)), _tmp9);
	_tmp10 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp10 = vala_ccode_variable_declarator_new_with_initializer ("self", VALA_CCODE_EXPRESSION (ccall)))));
	(_tmp10 == NULL ? NULL : (_tmp10 = (g_object_unref (_tmp10), NULL)));
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cdecl_));
	if (vala_class_get_destructor (cl) != NULL) {
		vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (VALA_CCODE_BLOCK (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_destructor_get_body (vala_class_get_destructor (cl)))))));
	}
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_dispose_fragment));
	/* chain up to dispose function of the base class*/
	_tmp11 = NULL;
	_tmp12 = NULL;
	ccast = (_tmp12 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp11 = vala_ccode_identifier_new ("G_OBJECT_CLASS")))), (_tmp11 == NULL ? NULL : (_tmp11 = (g_object_unref (_tmp11), NULL))), _tmp12);
	_tmp15 = NULL;
	_tmp14 = NULL;
	_tmp13 = NULL;
	vala_ccode_function_call_add_argument (ccast, VALA_CCODE_EXPRESSION ((_tmp15 = vala_ccode_identifier_new ((_tmp14 = g_strdup_printf ("%s_parent_class", (_tmp13 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL))))))));
	(_tmp15 == NULL ? NULL : (_tmp15 = (g_object_unref (_tmp15), NULL)));
	_tmp14 = (g_free (_tmp14), NULL);
	_tmp13 = (g_free (_tmp13), NULL);
	_tmp17 = NULL;
	_tmp16 = NULL;
	ccall = (_tmp17 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp16 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (ccast), "dispose")))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), _tmp17);
	(_tmp16 == NULL ? NULL : (_tmp16 = (g_object_unref (_tmp16), NULL)));
	_tmp18 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp18 = vala_ccode_identifier_new ("obj"))));
	(_tmp18 == NULL ? NULL : (_tmp18 = (g_object_unref (_tmp18), NULL)));
	_tmp19 = NULL;
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((_tmp19 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ccall)))));
	(_tmp19 == NULL ? NULL : (_tmp19 = (g_object_unref (_tmp19), NULL)));
	vala_ccode_function_set_block (function, cblock);
	vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_definition, VALA_CCODE_NODE (function));
	(function == NULL ? NULL : (function = (g_object_unref (function), NULL)));
	(cblock == NULL ? NULL : (cblock = (g_object_unref (cblock), NULL)));
	(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
	(ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL)));
}


static gboolean vala_ccode_class_binding_class_has_readable_properties (ValaCCodeClassBinding* self, ValaClass* cl) {
	g_return_val_if_fail (VALA_IS_CCODE_CLASS_BINDING (self), FALSE);
	g_return_val_if_fail (VALA_IS_CLASS (cl), FALSE);
	{
		GeeList* prop_collection;
		int prop_it;
		prop_collection = vala_object_type_symbol_get_properties (VALA_OBJECT_TYPE_SYMBOL (cl));
		for (prop_it = 0; prop_it < gee_collection_get_size (GEE_COLLECTION (prop_collection)); prop_it = prop_it + 1) {
			ValaProperty* prop;
			prop = ((ValaProperty*) (gee_list_get (GEE_LIST (prop_collection), prop_it)));
			{
				if (vala_property_get_get_accessor (prop) != NULL) {
					gboolean _tmp0;
					return (_tmp0 = TRUE, (prop == NULL ? NULL : (prop = (g_object_unref (prop), NULL))), (prop_collection == NULL ? NULL : (prop_collection = (g_object_unref (prop_collection), NULL))), _tmp0);
				}
				(prop == NULL ? NULL : (prop = (g_object_unref (prop), NULL)));
			}
		}
		(prop_collection == NULL ? NULL : (prop_collection = (g_object_unref (prop_collection), NULL)));
	}
	return FALSE;
}


static gboolean vala_ccode_class_binding_class_has_writable_properties (ValaCCodeClassBinding* self, ValaClass* cl) {
	g_return_val_if_fail (VALA_IS_CCODE_CLASS_BINDING (self), FALSE);
	g_return_val_if_fail (VALA_IS_CLASS (cl), FALSE);
	{
		GeeList* prop_collection;
		int prop_it;
		prop_collection = vala_object_type_symbol_get_properties (VALA_OBJECT_TYPE_SYMBOL (cl));
		for (prop_it = 0; prop_it < gee_collection_get_size (GEE_COLLECTION (prop_collection)); prop_it = prop_it + 1) {
			ValaProperty* prop;
			prop = ((ValaProperty*) (gee_list_get (GEE_LIST (prop_collection), prop_it)));
			{
				if (vala_property_get_set_accessor (prop) != NULL) {
					gboolean _tmp0;
					return (_tmp0 = TRUE, (prop == NULL ? NULL : (prop = (g_object_unref (prop), NULL))), (prop_collection == NULL ? NULL : (prop_collection = (g_object_unref (prop_collection), NULL))), _tmp0);
				}
				(prop == NULL ? NULL : (prop = (g_object_unref (prop), NULL)));
			}
		}
		(prop_collection == NULL ? NULL : (prop_collection = (g_object_unref (prop_collection), NULL)));
	}
	return FALSE;
}


static void vala_ccode_class_binding_add_get_property_function (ValaCCodeClassBinding* self, ValaClass* cl) {
	char* _tmp1;
	char* _tmp0;
	ValaCCodeFunction* _tmp2;
	ValaCCodeFunction* get_prop;
	ValaCCodeFormalParameter* _tmp3;
	ValaCCodeFormalParameter* _tmp4;
	ValaCCodeFormalParameter* _tmp5;
	ValaCCodeFormalParameter* _tmp6;
	ValaCCodeBlock* block;
	ValaCCodeIdentifier* _tmp7;
	ValaInstanceCast* _tmp8;
	ValaInstanceCast* ccall;
	char* _tmp10;
	char* _tmp9;
	ValaCCodeDeclaration* _tmp11;
	ValaCCodeDeclaration* cdecl_;
	ValaCCodeVariableDeclarator* _tmp12;
	ValaCCodeIdentifier* _tmp13;
	ValaCCodeSwitchStatement* _tmp14;
	ValaCCodeSwitchStatement* cswitch;
	GeeList* props;
	ValaCCodeStatement* _tmp27;
	ValaCCodeBreakStatement* _tmp28;
	g_return_if_fail (VALA_IS_CCODE_CLASS_BINDING (self));
	g_return_if_fail (VALA_IS_CLASS (cl));
	_tmp1 = NULL;
	_tmp0 = NULL;
	_tmp2 = NULL;
	get_prop = (_tmp2 = vala_ccode_function_new ((_tmp1 = g_strdup_printf ("%s_get_property", (_tmp0 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL)))), "void"), (_tmp1 = (g_free (_tmp1), NULL)), (_tmp0 = (g_free (_tmp0), NULL)), _tmp2);
	vala_ccode_function_set_modifiers (get_prop, VALA_CCODE_MODIFIERS_STATIC);
	_tmp3 = NULL;
	vala_ccode_function_add_parameter (get_prop, (_tmp3 = vala_ccode_formal_parameter_new ("object", "GObject *")));
	(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
	_tmp4 = NULL;
	vala_ccode_function_add_parameter (get_prop, (_tmp4 = vala_ccode_formal_parameter_new ("property_id", "guint")));
	(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
	_tmp5 = NULL;
	vala_ccode_function_add_parameter (get_prop, (_tmp5 = vala_ccode_formal_parameter_new ("value", "GValue *")));
	(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
	_tmp6 = NULL;
	vala_ccode_function_add_parameter (get_prop, (_tmp6 = vala_ccode_formal_parameter_new ("pspec", "GParamSpec *")));
	(_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL)));
	block = vala_ccode_block_new ();
	_tmp7 = NULL;
	_tmp8 = NULL;
	ccall = (_tmp8 = vala_instance_cast_new (VALA_CCODE_EXPRESSION ((_tmp7 = vala_ccode_identifier_new ("object"))), VALA_TYPESYMBOL (cl)), (_tmp7 == NULL ? NULL : (_tmp7 = (g_object_unref (_tmp7), NULL))), _tmp8);
	_tmp10 = NULL;
	_tmp9 = NULL;
	_tmp11 = NULL;
	cdecl_ = (_tmp11 = vala_ccode_declaration_new ((_tmp10 = g_strdup_printf ("%s *", (_tmp9 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (cl), FALSE))))), (_tmp10 = (g_free (_tmp10), NULL)), (_tmp9 = (g_free (_tmp9), NULL)), _tmp11);
	_tmp12 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp12 = vala_ccode_variable_declarator_new_with_initializer ("self", VALA_CCODE_EXPRESSION (ccall)))));
	(_tmp12 == NULL ? NULL : (_tmp12 = (g_object_unref (_tmp12), NULL)));
	vala_ccode_block_add_statement (block, VALA_CCODE_NODE (cdecl_));
	_tmp13 = NULL;
	_tmp14 = NULL;
	cswitch = (_tmp14 = vala_ccode_switch_statement_new (VALA_CCODE_EXPRESSION ((_tmp13 = vala_ccode_identifier_new ("property_id")))), (_tmp13 == NULL ? NULL : (_tmp13 = (g_object_unref (_tmp13), NULL))), _tmp14);
	props = vala_object_type_symbol_get_properties (VALA_OBJECT_TYPE_SYMBOL (cl));
	{
		GeeList* prop_collection;
		int prop_it;
		prop_collection = props;
		for (prop_it = 0; prop_it < gee_collection_get_size (GEE_COLLECTION (prop_collection)); prop_it = prop_it + 1) {
			ValaProperty* prop;
			prop = ((ValaProperty*) (gee_list_get (GEE_LIST (prop_collection), prop_it)));
			{
				gboolean is_virtual;
				char* prefix;
				ValaCCodeIdentifier* _tmp17;
				char* _tmp16;
				ValaCCodeCaseStatement* _tmp18;
				ValaCCodeCaseStatement* ccase;
				ValaCCodeIdentifier* _tmp20;
				char* _tmp19;
				ValaCCodeFunctionCall* _tmp21;
				ValaCCodeFunctionCall* ccall;
				ValaCCodeIdentifier* _tmp22;
				ValaCCodeFunctionCall* csetcall;
				ValaCCodeIdentifier* _tmp23;
				ValaCCodeIdentifier* _tmp24;
				ValaCCodeExpressionStatement* _tmp25;
				ValaCCodeBreakStatement* _tmp26;
				/* FIXME: omit real struct types for now since they cannot be expressed as gobject property yet*/
				if (vala_property_get_get_accessor (prop) == NULL || vala_property_get_is_abstract (prop) || vala_data_type_is_real_struct_type (vala_property_get_property_type (prop))) {
					(prop == NULL ? NULL : (prop = (g_object_unref (prop), NULL)));
					continue;
				}
				if (vala_symbol_get_access (VALA_SYMBOL (prop)) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
					/* don't register private properties*/
					(prop == NULL ? NULL : (prop = (g_object_unref (prop), NULL)));
					continue;
				}
				is_virtual = vala_property_get_base_property (prop) != NULL || vala_property_get_base_interface_property (prop) != NULL;
				prefix = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL);
				if (is_virtual) {
					char* _tmp15;
					_tmp15 = NULL;
					prefix = (_tmp15 = g_strconcat (prefix, ("_real"), NULL), (prefix = (g_free (prefix), NULL)), _tmp15);
				}
				_tmp17 = NULL;
				_tmp16 = NULL;
				_tmp18 = NULL;
				ccase = (_tmp18 = vala_ccode_case_statement_new (VALA_CCODE_EXPRESSION ((_tmp17 = vala_ccode_identifier_new ((_tmp16 = vala_property_get_upper_case_cname (prop)))))), (_tmp17 == NULL ? NULL : (_tmp17 = (g_object_unref (_tmp17), NULL))), (_tmp16 = (g_free (_tmp16), NULL)), _tmp18);
				_tmp20 = NULL;
				_tmp19 = NULL;
				_tmp21 = NULL;
				ccall = (_tmp21 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp20 = vala_ccode_identifier_new ((_tmp19 = g_strdup_printf ("%s_get_%s", prefix, vala_symbol_get_name (VALA_SYMBOL (prop)))))))), (_tmp20 == NULL ? NULL : (_tmp20 = (g_object_unref (_tmp20), NULL))), (_tmp19 = (g_free (_tmp19), NULL)), _tmp21);
				_tmp22 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp22 = vala_ccode_identifier_new ("self"))));
				(_tmp22 == NULL ? NULL : (_tmp22 = (g_object_unref (_tmp22), NULL)));
				csetcall = vala_ccode_function_call_new (NULL);
				_tmp23 = NULL;
				vala_ccode_function_call_set_call (csetcall, VALA_CCODE_EXPRESSION ((_tmp23 = vala_ccode_binding_get_value_setter_function (VALA_CCODE_BINDING (self), vala_property_get_property_type (prop)))));
				(_tmp23 == NULL ? NULL : (_tmp23 = (g_object_unref (_tmp23), NULL)));
				_tmp24 = NULL;
				vala_ccode_function_call_add_argument (csetcall, VALA_CCODE_EXPRESSION ((_tmp24 = vala_ccode_identifier_new ("value"))));
				(_tmp24 == NULL ? NULL : (_tmp24 = (g_object_unref (_tmp24), NULL)));
				vala_ccode_function_call_add_argument (csetcall, VALA_CCODE_EXPRESSION (ccall));
				_tmp25 = NULL;
				vala_ccode_case_statement_add_statement (ccase, VALA_CCODE_STATEMENT ((_tmp25 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (csetcall)))));
				(_tmp25 == NULL ? NULL : (_tmp25 = (g_object_unref (_tmp25), NULL)));
				_tmp26 = NULL;
				vala_ccode_case_statement_add_statement (ccase, VALA_CCODE_STATEMENT ((_tmp26 = vala_ccode_break_statement_new ())));
				(_tmp26 == NULL ? NULL : (_tmp26 = (g_object_unref (_tmp26), NULL)));
				vala_ccode_switch_statement_add_case (cswitch, ccase);
				(prop == NULL ? NULL : (prop = (g_object_unref (prop), NULL)));
				prefix = (g_free (prefix), NULL);
				(ccase == NULL ? NULL : (ccase = (g_object_unref (ccase), NULL)));
				(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
				(csetcall == NULL ? NULL : (csetcall = (g_object_unref (csetcall), NULL)));
			}
		}
	}
	_tmp27 = NULL;
	vala_ccode_switch_statement_add_default_statement (cswitch, (_tmp27 = vala_ccode_class_binding_get_invalid_property_id_warn_statement (self)));
	(_tmp27 == NULL ? NULL : (_tmp27 = (g_object_unref (_tmp27), NULL)));
	_tmp28 = NULL;
	vala_ccode_switch_statement_add_default_statement (cswitch, VALA_CCODE_STATEMENT ((_tmp28 = vala_ccode_break_statement_new ())));
	(_tmp28 == NULL ? NULL : (_tmp28 = (g_object_unref (_tmp28), NULL)));
	vala_ccode_block_add_statement (block, VALA_CCODE_NODE (cswitch));
	vala_ccode_function_set_block (get_prop, block);
	vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_definition, VALA_CCODE_NODE (get_prop));
	(get_prop == NULL ? NULL : (get_prop = (g_object_unref (get_prop), NULL)));
	(block == NULL ? NULL : (block = (g_object_unref (block), NULL)));
	(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
	(cswitch == NULL ? NULL : (cswitch = (g_object_unref (cswitch), NULL)));
	(props == NULL ? NULL : (props = (g_object_unref (props), NULL)));
}


static void vala_ccode_class_binding_add_set_property_function (ValaCCodeClassBinding* self, ValaClass* cl) {
	char* _tmp1;
	char* _tmp0;
	ValaCCodeFunction* _tmp2;
	ValaCCodeFunction* set_prop;
	ValaCCodeFormalParameter* _tmp3;
	ValaCCodeFormalParameter* _tmp4;
	ValaCCodeFormalParameter* _tmp5;
	ValaCCodeFormalParameter* _tmp6;
	ValaCCodeBlock* block;
	ValaCCodeIdentifier* _tmp7;
	ValaInstanceCast* _tmp8;
	ValaInstanceCast* ccall;
	char* _tmp10;
	char* _tmp9;
	ValaCCodeDeclaration* _tmp11;
	ValaCCodeDeclaration* cdecl_;
	ValaCCodeVariableDeclarator* _tmp12;
	ValaCCodeIdentifier* _tmp13;
	ValaCCodeSwitchStatement* _tmp14;
	ValaCCodeSwitchStatement* cswitch;
	GeeList* props;
	ValaCCodeStatement* _tmp29;
	ValaCCodeBreakStatement* _tmp30;
	g_return_if_fail (VALA_IS_CCODE_CLASS_BINDING (self));
	g_return_if_fail (VALA_IS_CLASS (cl));
	_tmp1 = NULL;
	_tmp0 = NULL;
	_tmp2 = NULL;
	set_prop = (_tmp2 = vala_ccode_function_new ((_tmp1 = g_strdup_printf ("%s_set_property", (_tmp0 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL)))), "void"), (_tmp1 = (g_free (_tmp1), NULL)), (_tmp0 = (g_free (_tmp0), NULL)), _tmp2);
	vala_ccode_function_set_modifiers (set_prop, VALA_CCODE_MODIFIERS_STATIC);
	_tmp3 = NULL;
	vala_ccode_function_add_parameter (set_prop, (_tmp3 = vala_ccode_formal_parameter_new ("object", "GObject *")));
	(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
	_tmp4 = NULL;
	vala_ccode_function_add_parameter (set_prop, (_tmp4 = vala_ccode_formal_parameter_new ("property_id", "guint")));
	(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
	_tmp5 = NULL;
	vala_ccode_function_add_parameter (set_prop, (_tmp5 = vala_ccode_formal_parameter_new ("value", "const GValue *")));
	(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
	_tmp6 = NULL;
	vala_ccode_function_add_parameter (set_prop, (_tmp6 = vala_ccode_formal_parameter_new ("pspec", "GParamSpec *")));
	(_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL)));
	block = vala_ccode_block_new ();
	_tmp7 = NULL;
	_tmp8 = NULL;
	ccall = (_tmp8 = vala_instance_cast_new (VALA_CCODE_EXPRESSION ((_tmp7 = vala_ccode_identifier_new ("object"))), VALA_TYPESYMBOL (cl)), (_tmp7 == NULL ? NULL : (_tmp7 = (g_object_unref (_tmp7), NULL))), _tmp8);
	_tmp10 = NULL;
	_tmp9 = NULL;
	_tmp11 = NULL;
	cdecl_ = (_tmp11 = vala_ccode_declaration_new ((_tmp10 = g_strdup_printf ("%s *", (_tmp9 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (cl), FALSE))))), (_tmp10 = (g_free (_tmp10), NULL)), (_tmp9 = (g_free (_tmp9), NULL)), _tmp11);
	_tmp12 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp12 = vala_ccode_variable_declarator_new_with_initializer ("self", VALA_CCODE_EXPRESSION (ccall)))));
	(_tmp12 == NULL ? NULL : (_tmp12 = (g_object_unref (_tmp12), NULL)));
	vala_ccode_block_add_statement (block, VALA_CCODE_NODE (cdecl_));
	_tmp13 = NULL;
	_tmp14 = NULL;
	cswitch = (_tmp14 = vala_ccode_switch_statement_new (VALA_CCODE_EXPRESSION ((_tmp13 = vala_ccode_identifier_new ("property_id")))), (_tmp13 == NULL ? NULL : (_tmp13 = (g_object_unref (_tmp13), NULL))), _tmp14);
	props = vala_object_type_symbol_get_properties (VALA_OBJECT_TYPE_SYMBOL (cl));
	{
		GeeList* prop_collection;
		int prop_it;
		prop_collection = props;
		for (prop_it = 0; prop_it < gee_collection_get_size (GEE_COLLECTION (prop_collection)); prop_it = prop_it + 1) {
			ValaProperty* prop;
			prop = ((ValaProperty*) (gee_list_get (GEE_LIST (prop_collection), prop_it)));
			{
				gboolean is_virtual;
				char* prefix;
				ValaCCodeIdentifier* _tmp17;
				char* _tmp16;
				ValaCCodeCaseStatement* _tmp18;
				ValaCCodeCaseStatement* ccase;
				ValaCCodeIdentifier* _tmp20;
				char* _tmp19;
				ValaCCodeFunctionCall* _tmp21;
				ValaCCodeFunctionCall* ccall;
				ValaCCodeIdentifier* _tmp22;
				ValaCCodeFunctionCall* cgetcall;
				ValaCCodeIdentifier* _tmp26;
				ValaCCodeExpressionStatement* _tmp27;
				ValaCCodeBreakStatement* _tmp28;
				/* FIXME: omit real struct types for now since they cannot be expressed as gobject property yet*/
				if (vala_property_get_set_accessor (prop) == NULL || vala_property_get_is_abstract (prop) || vala_data_type_is_real_struct_type (vala_property_get_property_type (prop))) {
					(prop == NULL ? NULL : (prop = (g_object_unref (prop), NULL)));
					continue;
				}
				if (vala_symbol_get_access (VALA_SYMBOL (prop)) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
					/* don't register private properties*/
					(prop == NULL ? NULL : (prop = (g_object_unref (prop), NULL)));
					continue;
				}
				is_virtual = vala_property_get_base_property (prop) != NULL || vala_property_get_base_interface_property (prop) != NULL;
				prefix = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL);
				if (is_virtual) {
					char* _tmp15;
					_tmp15 = NULL;
					prefix = (_tmp15 = g_strconcat (prefix, ("_real"), NULL), (prefix = (g_free (prefix), NULL)), _tmp15);
				}
				_tmp17 = NULL;
				_tmp16 = NULL;
				_tmp18 = NULL;
				ccase = (_tmp18 = vala_ccode_case_statement_new (VALA_CCODE_EXPRESSION ((_tmp17 = vala_ccode_identifier_new ((_tmp16 = vala_property_get_upper_case_cname (prop)))))), (_tmp17 == NULL ? NULL : (_tmp17 = (g_object_unref (_tmp17), NULL))), (_tmp16 = (g_free (_tmp16), NULL)), _tmp18);
				_tmp20 = NULL;
				_tmp19 = NULL;
				_tmp21 = NULL;
				ccall = (_tmp21 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp20 = vala_ccode_identifier_new ((_tmp19 = g_strdup_printf ("%s_set_%s", prefix, vala_symbol_get_name (VALA_SYMBOL (prop)))))))), (_tmp20 == NULL ? NULL : (_tmp20 = (g_object_unref (_tmp20), NULL))), (_tmp19 = (g_free (_tmp19), NULL)), _tmp21);
				_tmp22 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp22 = vala_ccode_identifier_new ("self"))));
				(_tmp22 == NULL ? NULL : (_tmp22 = (g_object_unref (_tmp22), NULL)));
				cgetcall = vala_ccode_function_call_new (NULL);
				if (vala_data_type_get_data_type (vala_property_get_property_type (prop)) != NULL) {
					ValaCCodeIdentifier* _tmp24;
					char* _tmp23;
					_tmp24 = NULL;
					_tmp23 = NULL;
					vala_ccode_function_call_set_call (cgetcall, VALA_CCODE_EXPRESSION ((_tmp24 = vala_ccode_identifier_new ((_tmp23 = vala_typesymbol_get_get_value_function (vala_data_type_get_data_type (vala_property_get_property_type (prop))))))));
					(_tmp24 == NULL ? NULL : (_tmp24 = (g_object_unref (_tmp24), NULL)));
					_tmp23 = (g_free (_tmp23), NULL);
				} else {
					ValaCCodeIdentifier* _tmp25;
					_tmp25 = NULL;
					vala_ccode_function_call_set_call (cgetcall, VALA_CCODE_EXPRESSION ((_tmp25 = vala_ccode_identifier_new ("g_value_get_pointer"))));
					(_tmp25 == NULL ? NULL : (_tmp25 = (g_object_unref (_tmp25), NULL)));
				}
				_tmp26 = NULL;
				vala_ccode_function_call_add_argument (cgetcall, VALA_CCODE_EXPRESSION ((_tmp26 = vala_ccode_identifier_new ("value"))));
				(_tmp26 == NULL ? NULL : (_tmp26 = (g_object_unref (_tmp26), NULL)));
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (cgetcall));
				_tmp27 = NULL;
				vala_ccode_case_statement_add_statement (ccase, VALA_CCODE_STATEMENT ((_tmp27 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ccall)))));
				(_tmp27 == NULL ? NULL : (_tmp27 = (g_object_unref (_tmp27), NULL)));
				_tmp28 = NULL;
				vala_ccode_case_statement_add_statement (ccase, VALA_CCODE_STATEMENT ((_tmp28 = vala_ccode_break_statement_new ())));
				(_tmp28 == NULL ? NULL : (_tmp28 = (g_object_unref (_tmp28), NULL)));
				vala_ccode_switch_statement_add_case (cswitch, ccase);
				(prop == NULL ? NULL : (prop = (g_object_unref (prop), NULL)));
				prefix = (g_free (prefix), NULL);
				(ccase == NULL ? NULL : (ccase = (g_object_unref (ccase), NULL)));
				(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
				(cgetcall == NULL ? NULL : (cgetcall = (g_object_unref (cgetcall), NULL)));
			}
		}
	}
	_tmp29 = NULL;
	vala_ccode_switch_statement_add_default_statement (cswitch, (_tmp29 = vala_ccode_class_binding_get_invalid_property_id_warn_statement (self)));
	(_tmp29 == NULL ? NULL : (_tmp29 = (g_object_unref (_tmp29), NULL)));
	_tmp30 = NULL;
	vala_ccode_switch_statement_add_default_statement (cswitch, VALA_CCODE_STATEMENT ((_tmp30 = vala_ccode_break_statement_new ())));
	(_tmp30 == NULL ? NULL : (_tmp30 = (g_object_unref (_tmp30), NULL)));
	vala_ccode_block_add_statement (block, VALA_CCODE_NODE (cswitch));
	/* type, dup func, and destroy func properties for generic types */
	{
		GeeList* type_param_collection;
		int type_param_it;
		type_param_collection = vala_class_get_type_parameters (cl);
		for (type_param_it = 0; type_param_it < gee_collection_get_size (GEE_COLLECTION (type_param_collection)); type_param_it = type_param_it + 1) {
			ValaTypeParameter* type_param;
			type_param = ((ValaTypeParameter*) (gee_list_get (GEE_LIST (type_param_collection), type_param_it)));
			{
				char* func_name;
				char* enum_value;
				ValaCCodeCaseStatement* ccase;
				ValaCCodeMemberAccess* cfield;
				ValaCCodeFunctionCall* cgetcall;
				char* _tmp32;
				char* _tmp31;
				char* _tmp35;
				char* _tmp34;
				char* _tmp33;
				ValaCCodeCaseStatement* _tmp37;
				ValaCCodeIdentifier* _tmp36;
				ValaCCodeMemberAccess* _tmp40;
				ValaCCodeMemberAccess* _tmp39;
				ValaCCodeIdentifier* _tmp38;
				ValaCCodeFunctionCall* _tmp42;
				ValaCCodeIdentifier* _tmp41;
				ValaCCodeIdentifier* _tmp43;
				ValaCCodeExpressionStatement* _tmp45;
				ValaCCodeAssignment* _tmp44;
				ValaCCodeBreakStatement* _tmp46;
				char* _tmp48;
				char* _tmp47;
				char* _tmp51;
				char* _tmp50;
				char* _tmp49;
				ValaCCodeCaseStatement* _tmp53;
				ValaCCodeIdentifier* _tmp52;
				ValaCCodeMemberAccess* _tmp56;
				ValaCCodeMemberAccess* _tmp55;
				ValaCCodeIdentifier* _tmp54;
				ValaCCodeFunctionCall* _tmp58;
				ValaCCodeIdentifier* _tmp57;
				ValaCCodeIdentifier* _tmp59;
				ValaCCodeExpressionStatement* _tmp61;
				ValaCCodeAssignment* _tmp60;
				ValaCCodeBreakStatement* _tmp62;
				char* _tmp64;
				char* _tmp63;
				char* _tmp67;
				char* _tmp66;
				char* _tmp65;
				ValaCCodeCaseStatement* _tmp69;
				ValaCCodeIdentifier* _tmp68;
				ValaCCodeMemberAccess* _tmp72;
				ValaCCodeMemberAccess* _tmp71;
				ValaCCodeIdentifier* _tmp70;
				ValaCCodeFunctionCall* _tmp74;
				ValaCCodeIdentifier* _tmp73;
				ValaCCodeIdentifier* _tmp75;
				ValaCCodeExpressionStatement* _tmp77;
				ValaCCodeAssignment* _tmp76;
				ValaCCodeBreakStatement* _tmp78;
				func_name = NULL;
				enum_value = NULL;
				ccase = NULL;
				cfield = NULL;
				cgetcall = NULL;
				_tmp32 = NULL;
				_tmp31 = NULL;
				func_name = (_tmp32 = g_strdup_printf ("%s_type", (_tmp31 = g_utf8_strdown (vala_symbol_get_name (VALA_SYMBOL (type_param)), -1))), (func_name = (g_free (func_name), NULL)), _tmp32);
				_tmp31 = (g_free (_tmp31), NULL);
				_tmp35 = NULL;
				_tmp34 = NULL;
				_tmp33 = NULL;
				enum_value = (_tmp35 = g_utf8_strup ((_tmp34 = g_strdup_printf ("%s_%s", (_tmp33 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL)), func_name)), -1), (enum_value = (g_free (enum_value), NULL)), _tmp35);
				_tmp34 = (g_free (_tmp34), NULL);
				_tmp33 = (g_free (_tmp33), NULL);
				_tmp37 = NULL;
				_tmp36 = NULL;
				ccase = (_tmp37 = vala_ccode_case_statement_new (VALA_CCODE_EXPRESSION ((_tmp36 = vala_ccode_identifier_new (enum_value)))), (ccase == NULL ? NULL : (ccase = (g_object_unref (ccase), NULL))), _tmp37);
				(_tmp36 == NULL ? NULL : (_tmp36 = (g_object_unref (_tmp36), NULL)));
				_tmp40 = NULL;
				_tmp39 = NULL;
				_tmp38 = NULL;
				cfield = (_tmp40 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp39 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp38 = vala_ccode_identifier_new ("self"))), "priv"))), func_name), (cfield == NULL ? NULL : (cfield = (g_object_unref (cfield), NULL))), _tmp40);
				(_tmp39 == NULL ? NULL : (_tmp39 = (g_object_unref (_tmp39), NULL)));
				(_tmp38 == NULL ? NULL : (_tmp38 = (g_object_unref (_tmp38), NULL)));
				_tmp42 = NULL;
				_tmp41 = NULL;
				cgetcall = (_tmp42 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp41 = vala_ccode_identifier_new ("g_value_get_gtype")))), (cgetcall == NULL ? NULL : (cgetcall = (g_object_unref (cgetcall), NULL))), _tmp42);
				(_tmp41 == NULL ? NULL : (_tmp41 = (g_object_unref (_tmp41), NULL)));
				_tmp43 = NULL;
				vala_ccode_function_call_add_argument (cgetcall, VALA_CCODE_EXPRESSION ((_tmp43 = vala_ccode_identifier_new ("value"))));
				(_tmp43 == NULL ? NULL : (_tmp43 = (g_object_unref (_tmp43), NULL)));
				_tmp45 = NULL;
				_tmp44 = NULL;
				vala_ccode_case_statement_add_statement (ccase, VALA_CCODE_STATEMENT ((_tmp45 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp44 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (cfield), VALA_CCODE_EXPRESSION (cgetcall), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
				(_tmp45 == NULL ? NULL : (_tmp45 = (g_object_unref (_tmp45), NULL)));
				(_tmp44 == NULL ? NULL : (_tmp44 = (g_object_unref (_tmp44), NULL)));
				_tmp46 = NULL;
				vala_ccode_case_statement_add_statement (ccase, VALA_CCODE_STATEMENT ((_tmp46 = vala_ccode_break_statement_new ())));
				(_tmp46 == NULL ? NULL : (_tmp46 = (g_object_unref (_tmp46), NULL)));
				vala_ccode_switch_statement_add_case (cswitch, ccase);
				_tmp48 = NULL;
				_tmp47 = NULL;
				func_name = (_tmp48 = g_strdup_printf ("%s_dup_func", (_tmp47 = g_utf8_strdown (vala_symbol_get_name (VALA_SYMBOL (type_param)), -1))), (func_name = (g_free (func_name), NULL)), _tmp48);
				_tmp47 = (g_free (_tmp47), NULL);
				_tmp51 = NULL;
				_tmp50 = NULL;
				_tmp49 = NULL;
				enum_value = (_tmp51 = g_utf8_strup ((_tmp50 = g_strdup_printf ("%s_%s", (_tmp49 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL)), func_name)), -1), (enum_value = (g_free (enum_value), NULL)), _tmp51);
				_tmp50 = (g_free (_tmp50), NULL);
				_tmp49 = (g_free (_tmp49), NULL);
				_tmp53 = NULL;
				_tmp52 = NULL;
				ccase = (_tmp53 = vala_ccode_case_statement_new (VALA_CCODE_EXPRESSION ((_tmp52 = vala_ccode_identifier_new (enum_value)))), (ccase == NULL ? NULL : (ccase = (g_object_unref (ccase), NULL))), _tmp53);
				(_tmp52 == NULL ? NULL : (_tmp52 = (g_object_unref (_tmp52), NULL)));
				_tmp56 = NULL;
				_tmp55 = NULL;
				_tmp54 = NULL;
				cfield = (_tmp56 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp55 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp54 = vala_ccode_identifier_new ("self"))), "priv"))), func_name), (cfield == NULL ? NULL : (cfield = (g_object_unref (cfield), NULL))), _tmp56);
				(_tmp55 == NULL ? NULL : (_tmp55 = (g_object_unref (_tmp55), NULL)));
				(_tmp54 == NULL ? NULL : (_tmp54 = (g_object_unref (_tmp54), NULL)));
				_tmp58 = NULL;
				_tmp57 = NULL;
				cgetcall = (_tmp58 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp57 = vala_ccode_identifier_new ("g_value_get_pointer")))), (cgetcall == NULL ? NULL : (cgetcall = (g_object_unref (cgetcall), NULL))), _tmp58);
				(_tmp57 == NULL ? NULL : (_tmp57 = (g_object_unref (_tmp57), NULL)));
				_tmp59 = NULL;
				vala_ccode_function_call_add_argument (cgetcall, VALA_CCODE_EXPRESSION ((_tmp59 = vala_ccode_identifier_new ("value"))));
				(_tmp59 == NULL ? NULL : (_tmp59 = (g_object_unref (_tmp59), NULL)));
				_tmp61 = NULL;
				_tmp60 = NULL;
				vala_ccode_case_statement_add_statement (ccase, VALA_CCODE_STATEMENT ((_tmp61 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp60 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (cfield), VALA_CCODE_EXPRESSION (cgetcall), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
				(_tmp61 == NULL ? NULL : (_tmp61 = (g_object_unref (_tmp61), NULL)));
				(_tmp60 == NULL ? NULL : (_tmp60 = (g_object_unref (_tmp60), NULL)));
				_tmp62 = NULL;
				vala_ccode_case_statement_add_statement (ccase, VALA_CCODE_STATEMENT ((_tmp62 = vala_ccode_break_statement_new ())));
				(_tmp62 == NULL ? NULL : (_tmp62 = (g_object_unref (_tmp62), NULL)));
				vala_ccode_switch_statement_add_case (cswitch, ccase);
				_tmp64 = NULL;
				_tmp63 = NULL;
				func_name = (_tmp64 = g_strdup_printf ("%s_destroy_func", (_tmp63 = g_utf8_strdown (vala_symbol_get_name (VALA_SYMBOL (type_param)), -1))), (func_name = (g_free (func_name), NULL)), _tmp64);
				_tmp63 = (g_free (_tmp63), NULL);
				_tmp67 = NULL;
				_tmp66 = NULL;
				_tmp65 = NULL;
				enum_value = (_tmp67 = g_utf8_strup ((_tmp66 = g_strdup_printf ("%s_%s", (_tmp65 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL)), func_name)), -1), (enum_value = (g_free (enum_value), NULL)), _tmp67);
				_tmp66 = (g_free (_tmp66), NULL);
				_tmp65 = (g_free (_tmp65), NULL);
				_tmp69 = NULL;
				_tmp68 = NULL;
				ccase = (_tmp69 = vala_ccode_case_statement_new (VALA_CCODE_EXPRESSION ((_tmp68 = vala_ccode_identifier_new (enum_value)))), (ccase == NULL ? NULL : (ccase = (g_object_unref (ccase), NULL))), _tmp69);
				(_tmp68 == NULL ? NULL : (_tmp68 = (g_object_unref (_tmp68), NULL)));
				_tmp72 = NULL;
				_tmp71 = NULL;
				_tmp70 = NULL;
				cfield = (_tmp72 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp71 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp70 = vala_ccode_identifier_new ("self"))), "priv"))), func_name), (cfield == NULL ? NULL : (cfield = (g_object_unref (cfield), NULL))), _tmp72);
				(_tmp71 == NULL ? NULL : (_tmp71 = (g_object_unref (_tmp71), NULL)));
				(_tmp70 == NULL ? NULL : (_tmp70 = (g_object_unref (_tmp70), NULL)));
				_tmp74 = NULL;
				_tmp73 = NULL;
				cgetcall = (_tmp74 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp73 = vala_ccode_identifier_new ("g_value_get_pointer")))), (cgetcall == NULL ? NULL : (cgetcall = (g_object_unref (cgetcall), NULL))), _tmp74);
				(_tmp73 == NULL ? NULL : (_tmp73 = (g_object_unref (_tmp73), NULL)));
				_tmp75 = NULL;
				vala_ccode_function_call_add_argument (cgetcall, VALA_CCODE_EXPRESSION ((_tmp75 = vala_ccode_identifier_new ("value"))));
				(_tmp75 == NULL ? NULL : (_tmp75 = (g_object_unref (_tmp75), NULL)));
				_tmp77 = NULL;
				_tmp76 = NULL;
				vala_ccode_case_statement_add_statement (ccase, VALA_CCODE_STATEMENT ((_tmp77 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp76 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (cfield), VALA_CCODE_EXPRESSION (cgetcall), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
				(_tmp77 == NULL ? NULL : (_tmp77 = (g_object_unref (_tmp77), NULL)));
				(_tmp76 == NULL ? NULL : (_tmp76 = (g_object_unref (_tmp76), NULL)));
				_tmp78 = NULL;
				vala_ccode_case_statement_add_statement (ccase, VALA_CCODE_STATEMENT ((_tmp78 = vala_ccode_break_statement_new ())));
				(_tmp78 == NULL ? NULL : (_tmp78 = (g_object_unref (_tmp78), NULL)));
				vala_ccode_switch_statement_add_case (cswitch, ccase);
				(type_param == NULL ? NULL : (type_param = (g_object_unref (type_param), NULL)));
				func_name = (g_free (func_name), NULL);
				enum_value = (g_free (enum_value), NULL);
				(ccase == NULL ? NULL : (ccase = (g_object_unref (ccase), NULL)));
				(cfield == NULL ? NULL : (cfield = (g_object_unref (cfield), NULL)));
				(cgetcall == NULL ? NULL : (cgetcall = (g_object_unref (cgetcall), NULL)));
			}
		}
		(type_param_collection == NULL ? NULL : (type_param_collection = (g_object_unref (type_param_collection), NULL)));
	}
	vala_ccode_function_set_block (set_prop, block);
	vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_definition, VALA_CCODE_NODE (set_prop));
	(set_prop == NULL ? NULL : (set_prop = (g_object_unref (set_prop), NULL)));
	(block == NULL ? NULL : (block = (g_object_unref (block), NULL)));
	(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
	(cswitch == NULL ? NULL : (cswitch = (g_object_unref (cswitch), NULL)));
	(props == NULL ? NULL : (props = (g_object_unref (props), NULL)));
}


static ValaCCodeStatement* vala_ccode_class_binding_get_invalid_property_id_warn_statement (ValaCCodeClassBinding* self) {
	ValaCCodeIdentifier* _tmp0;
	ValaCCodeFunctionCall* _tmp1;
	ValaCCodeFunctionCall* cwarn;
	ValaCCodeIdentifier* _tmp2;
	ValaCCodeIdentifier* _tmp3;
	ValaCCodeIdentifier* _tmp4;
	ValaCCodeStatement* _tmp5;
	g_return_val_if_fail (VALA_IS_CCODE_CLASS_BINDING (self), NULL);
	/* warn on invalid property id*/
	_tmp0 = NULL;
	_tmp1 = NULL;
	cwarn = (_tmp1 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp0 = vala_ccode_identifier_new ("G_OBJECT_WARN_INVALID_PROPERTY_ID")))), (_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL))), _tmp1);
	_tmp2 = NULL;
	vala_ccode_function_call_add_argument (cwarn, VALA_CCODE_EXPRESSION ((_tmp2 = vala_ccode_identifier_new ("object"))));
	(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
	_tmp3 = NULL;
	vala_ccode_function_call_add_argument (cwarn, VALA_CCODE_EXPRESSION ((_tmp3 = vala_ccode_identifier_new ("property_id"))));
	(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
	_tmp4 = NULL;
	vala_ccode_function_call_add_argument (cwarn, VALA_CCODE_EXPRESSION ((_tmp4 = vala_ccode_identifier_new ("pspec"))));
	(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
	_tmp5 = NULL;
	return (_tmp5 = VALA_CCODE_STATEMENT (vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cwarn))), (cwarn == NULL ? NULL : (cwarn = (g_object_unref (cwarn), NULL))), _tmp5);
}


ValaClass* vala_ccode_class_binding_get_cl (ValaCCodeClassBinding* self) {
	g_return_val_if_fail (VALA_IS_CCODE_CLASS_BINDING (self), NULL);
	return self->priv->_cl;
}


void vala_ccode_class_binding_set_cl (ValaCCodeClassBinding* self, ValaClass* value) {
	ValaClass* _tmp2;
	ValaClass* _tmp1;
	g_return_if_fail (VALA_IS_CCODE_CLASS_BINDING (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_cl = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_cl == NULL ? NULL : (self->priv->_cl = (g_object_unref (self->priv->_cl), NULL))), _tmp2);
}


static void vala_ccode_class_binding_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ValaCCodeClassBinding * self;
	self = VALA_CCODE_CLASS_BINDING (object);
	switch (property_id) {
		case VALA_CCODE_CLASS_BINDING_CL:
		g_value_set_object (value, vala_ccode_class_binding_get_cl (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_ccode_class_binding_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ValaCCodeClassBinding * self;
	self = VALA_CCODE_CLASS_BINDING (object);
	switch (property_id) {
		case VALA_CCODE_CLASS_BINDING_CL:
		vala_ccode_class_binding_set_cl (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_ccode_class_binding_class_init (ValaCCodeClassBindingClass * klass) {
	vala_ccode_class_binding_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaCCodeClassBindingPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_ccode_class_binding_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_ccode_class_binding_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_ccode_class_binding_dispose;
	VALA_CCODE_BINDING_CLASS (klass)->emit = vala_ccode_class_binding_real_emit;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CCODE_CLASS_BINDING_CL, g_param_spec_object ("cl", "cl", "cl", VALA_TYPE_CLASS, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_ccode_class_binding_instance_init (ValaCCodeClassBinding * self) {
	self->priv = VALA_CCODE_CLASS_BINDING_GET_PRIVATE (self);
}


static void vala_ccode_class_binding_dispose (GObject * obj) {
	ValaCCodeClassBinding * self;
	self = VALA_CCODE_CLASS_BINDING (obj);
	(self->priv->_cl == NULL ? NULL : (self->priv->_cl = (g_object_unref (self->priv->_cl), NULL)));
	G_OBJECT_CLASS (vala_ccode_class_binding_parent_class)->dispose (obj);
}


GType vala_ccode_class_binding_get_type (void) {
	static GType vala_ccode_class_binding_type_id = 0;
	if (G_UNLIKELY (vala_ccode_class_binding_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeClassBindingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_class_binding_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeClassBinding), 0, (GInstanceInitFunc) vala_ccode_class_binding_instance_init };
		vala_ccode_class_binding_type_id = g_type_register_static (VALA_TYPE_CCODE_OBJECT_TYPE_SYMBOL_BINDING, "ValaCCodeClassBinding", &g_define_type_info, 0);
	}
	return vala_ccode_class_binding_type_id;
}




