/* valavapicheck.vala
 *
 * Copyright (C) 2007  Mathias Hasselmann
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Mathias Hasselmann <mathias.hasselmann@gmx.de>
 */

#include <vapigen/valavapicheck.h>
#include <vala/valacodecontext.h>
#include <vala/valasourcefile.h>
#include <gee/list.h>
#include <gee/set.h>
#include <stdlib.h>
#include <string.h>
#include <gee/arraylist.h>
#include <gee/hashset.h>
#include <gidlmodule.h>
#include <gidlparser.h>
#include <stdio.h>
#include <gee/collection.h>
#include <gidlnode.h>
#include <vala/valasourcereference.h>
#include <vala/valareport.h>
#include <glib/gstdio.h>


#define VALA_TYPE_VAPI_CHECK (vala_vapi_check_get_type ())
#define VALA_VAPI_CHECK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_VAPI_CHECK, ValaVAPICheck))
#define VALA_VAPI_CHECK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_VAPI_CHECK, ValaVAPICheckClass))
#define VALA_IS_VAPI_CHECK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_VAPI_CHECK))
#define VALA_IS_VAPI_CHECK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_VAPI_CHECK))
#define VALA_VAPI_CHECK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_VAPI_CHECK, ValaVAPICheckClass))

typedef struct _ValaVAPICheck ValaVAPICheck;
typedef struct _ValaVAPICheckClass ValaVAPICheckClass;
typedef struct _ValaVAPICheckPrivate ValaVAPICheckPrivate;

struct _ValaVAPICheck {
	GObject parent_instance;
	ValaVAPICheckPrivate * priv;
};

struct _ValaVAPICheckClass {
	GObjectClass parent_class;
};



struct _ValaVAPICheckPrivate {
	ValaCodeContext* _context;
	ValaSourceFile* _gidl;
	ValaSourceFile* _metadata;
	GeeList* _scope;
	GeeSet* _symbols;
};

#define VALA_VAPI_CHECK_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_VAPI_CHECK, ValaVAPICheckPrivate))
enum  {
	VALA_VAPI_CHECK_DUMMY_PROPERTY,
	VALA_VAPI_CHECK_CONTEXT,
	VALA_VAPI_CHECK_GIDL,
	VALA_VAPI_CHECK_METADATA
};
static ValaVAPICheck* vala_vapi_check_new (const char* gidlname, ValaCodeContext* context);
static void _g_list_free_g_idl_module_free (GList* self);
static void vala_vapi_check_parse_gidl (ValaVAPICheck* self);
static void vala_vapi_check_add_symbol (ValaVAPICheck* self, const char* name, const char* separator);
static char* vala_vapi_check_get_scope (ValaVAPICheck* self);
static void vala_vapi_check_enter_scope (ValaVAPICheck* self, const char* name);
static void vala_vapi_check_leave_scope (ValaVAPICheck* self);
static void vala_vapi_check_parse_members (ValaVAPICheck* self, const char* name, GList* members);
static gint vala_vapi_check_check_metadata (ValaVAPICheck* self);
static gint vala_vapi_check_run (ValaVAPICheck* self);
static gint vala_vapi_check_main (char** args, int args_length1);
static ValaCodeContext* vala_vapi_check_get_context (ValaVAPICheck* self);
static void vala_vapi_check_set_context (ValaVAPICheck* self, ValaCodeContext* value);
static ValaSourceFile* vala_vapi_check_get_gidl (ValaVAPICheck* self);
static void vala_vapi_check_set_gidl (ValaVAPICheck* self, ValaSourceFile* value);
static ValaSourceFile* vala_vapi_check_get_metadata (ValaVAPICheck* self);
static void vala_vapi_check_set_metadata (ValaVAPICheck* self, ValaSourceFile* value);
static gpointer vala_vapi_check_parent_class = NULL;
static void vala_vapi_check_dispose (GObject * obj);
static GType vala_vapi_check_get_type (void);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);



static ValaVAPICheck* vala_vapi_check_new (const char* gidlname, ValaCodeContext* context) {
	GParameter * __params;
	GParameter * __params_it;
	ValaSourceFile* _tmp0;
	ValaSourceFile* _tmp4;
	char* _tmp3;
	char* _tmp2;
	char* _tmp1;
	ValaVAPICheck * self;
	g_return_val_if_fail (gidlname != NULL, NULL);
	g_return_val_if_fail (VALA_IS_CODE_CONTEXT (context), NULL);
	__params = g_new0 (GParameter, 3);
	__params_it = __params;
	_tmp0 = NULL;
	__params_it->name = "gidl";
	g_value_init (&__params_it->value, VALA_TYPE_SOURCE_FILE);
	g_value_set_object (&__params_it->value, (_tmp0 = vala_source_file_new (context, gidlname, FALSE)));
	__params_it++;
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
	_tmp4 = NULL;
	_tmp3 = NULL;
	_tmp2 = NULL;
	_tmp1 = NULL;
	__params_it->name = "metadata";
	g_value_init (&__params_it->value, VALA_TYPE_SOURCE_FILE);
	g_value_set_object (&__params_it->value, (_tmp4 = vala_source_file_new (context, (_tmp3 = g_strconcat ((_tmp2 = g_utf8_offset_to_pointer (gidlname, ((glong) 0)), g_strndup (_tmp2, g_utf8_offset_to_pointer (_tmp2, g_utf8_strlen (gidlname, -1) - 5) - _tmp2)), ".metadata", NULL)), FALSE)));
	__params_it++;
	(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
	_tmp3 = (g_free (_tmp3), NULL);
	_tmp1 = (g_free (_tmp1), NULL);
	__params_it->name = "context";
	g_value_init (&__params_it->value, VALA_TYPE_CODE_CONTEXT);
	g_value_set_object (&__params_it->value, context);
	__params_it++;
	self = g_object_newv (VALA_TYPE_VAPI_CHECK, __params_it - __params, __params);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


static void _g_list_free_g_idl_module_free (GList* self) {
	g_list_foreach (self, ((GFunc) g_idl_module_free), NULL);
	g_list_free (self);
}


static void vala_vapi_check_parse_gidl (ValaVAPICheck* self) {
	GError * inner_error;
	GeeList* _tmp0;
	GeeSet* _tmp1;
	g_return_if_fail (VALA_IS_VAPI_CHECK (self));
	inner_error = NULL;
	_tmp0 = NULL;
	self->priv->_scope = (_tmp0 = GEE_LIST (gee_array_list_new (G_TYPE_STRING, ((GBoxedCopyFunc) g_strdup), g_free, g_direct_equal)), (self->priv->_scope == NULL ? NULL : (self->priv->_scope = (g_object_unref (self->priv->_scope), NULL))), _tmp0);
	_tmp1 = NULL;
	self->priv->_symbols = (_tmp1 = GEE_SET (gee_hash_set_new (G_TYPE_STRING, ((GBoxedCopyFunc) g_strdup), g_free, g_str_hash, g_str_equal)), (self->priv->_symbols == NULL ? NULL : (self->priv->_symbols = (g_object_unref (self->priv->_symbols), NULL))), _tmp1);
	{
		{
			GList* module_collection;
			GList* module_it;
			module_collection = g_idl_parse_file (vala_source_file_get_filename (self->priv->_gidl), &inner_error);
			if (inner_error != NULL) {
				if (inner_error->domain == G_MARKUP_ERROR) {
					goto __catch0_g_markup_error;
				}
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
				g_clear_error (&inner_error);
			}
			for (module_it = module_collection; module_it != NULL; module_it = module_it->next) {
				GIdlModule* module;
				module = ((GIdlModule*) module_it->data);
				{
					vala_vapi_check_parse_members (self, module->name, module->entries);
				}
			}
			(module_collection == NULL ? NULL : (module_collection = (_g_list_free_g_idl_module_free (module_collection), NULL)));
		}
	}
	goto __finally0;
	__catch0_g_markup_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			fprintf (stderr, "%s: %s\n", vala_source_file_get_filename (self->priv->_gidl), e->message);
		}
	}
	__finally0:
	;
}


static void vala_vapi_check_add_symbol (ValaVAPICheck* self, const char* name, const char* separator) {
	g_return_if_fail (VALA_IS_VAPI_CHECK (self));
	g_return_if_fail (name != NULL);
	if (NULL != separator) {
		char* _tmp1;
		char* _tmp0;
		char* _tmp2;
		char* fullname;
		_tmp1 = NULL;
		_tmp0 = NULL;
		_tmp2 = NULL;
		fullname = (_tmp2 = g_strconcat ((_tmp1 = g_strconcat ((_tmp0 = vala_vapi_check_get_scope (self)), separator, NULL)), name, NULL), (_tmp1 = (g_free (_tmp1), NULL)), (_tmp0 = (g_free (_tmp0), NULL)), _tmp2);
		gee_collection_add (GEE_COLLECTION (self->priv->_symbols), fullname);
		fullname = (g_free (fullname), NULL);
	} else {
		gee_collection_add (GEE_COLLECTION (self->priv->_symbols), name);
	}
}


static char* vala_vapi_check_get_scope (ValaVAPICheck* self) {
	g_return_val_if_fail (VALA_IS_VAPI_CHECK (self), NULL);
	return ((char*) gee_list_get (((GeeList*) self->priv->_scope), gee_collection_get_size (GEE_COLLECTION (self->priv->_scope)) - 1));
}


static void vala_vapi_check_enter_scope (ValaVAPICheck* self, const char* name) {
	g_return_if_fail (VALA_IS_VAPI_CHECK (self));
	g_return_if_fail (name != NULL);
	gee_collection_add (GEE_COLLECTION (self->priv->_scope), name);
	vala_vapi_check_add_symbol (self, name, NULL);
}


static void vala_vapi_check_leave_scope (ValaVAPICheck* self) {
	g_return_if_fail (VALA_IS_VAPI_CHECK (self));
	gee_list_remove_at (self->priv->_scope, gee_collection_get_size (GEE_COLLECTION (self->priv->_scope)) - 1);
}


static void vala_vapi_check_parse_members (ValaVAPICheck* self, const char* name, GList* members) {
	g_return_if_fail (VALA_IS_VAPI_CHECK (self));
	g_return_if_fail (name != NULL);
	g_return_if_fail (members != NULL);
	vala_vapi_check_enter_scope (self, name);
	{
		GList* node_collection;
		GList* node_it;
		node_collection = members;
		for (node_it = node_collection; node_it != NULL; node_it = node_it->next) {
			GIdlNode* node;
			node = ((GIdlNode*) node_it->data);
			{
				GIdlNodeTypeId _tmp0;
				_tmp0 = node->type;
				if (_tmp0 == G_IDL_NODE_ENUM)
				do {
					vala_vapi_check_parse_members (self, (((GIdlNodeEnum*) node))->gtype_name, (((GIdlNodeEnum*) node))->values);
					break;
				} while (0); else if (_tmp0 == G_IDL_NODE_FUNCTION)
				do {
					vala_vapi_check_parse_members (self, (((GIdlNodeFunction*) node))->symbol, (((GIdlNodeFunction*) node))->parameters);
					break;
				} while (0); else if (_tmp0 == G_IDL_NODE_BOXED)
				do {
					vala_vapi_check_parse_members (self, (((GIdlNodeBoxed*) node))->gtype_name, (((GIdlNodeBoxed*) node))->members);
					break;
				} while (0); else if (_tmp0 == G_IDL_NODE_INTERFACE || _tmp0 == G_IDL_NODE_OBJECT)
				do {
					vala_vapi_check_parse_members (self, (((GIdlNodeInterface*) node))->gtype_name, (((GIdlNodeInterface*) node))->members);
					break;
				} while (0); else if (_tmp0 == G_IDL_NODE_FIELD || _tmp0 == G_IDL_NODE_PARAM)
				do {
					vala_vapi_check_add_symbol (self, node->name, ".");
					break;
				} while (0); else if (_tmp0 == G_IDL_NODE_PROPERTY || _tmp0 == G_IDL_NODE_SIGNAL)
				do {
					vala_vapi_check_add_symbol (self, node->name, "::");
					break;
				} while (0); else if (_tmp0 == G_IDL_NODE_STRUCT)
				do {
					vala_vapi_check_parse_members (self, node->name, (((GIdlNodeStruct*) node))->members);
					break;
				} while (0); else if (_tmp0 == G_IDL_NODE_VALUE || _tmp0 == G_IDL_NODE_VFUNC)
				do {
					break;
				} while (0); else
				do {
					g_warning ("valavapicheck.vala:121: TODO: %s: Implement support for type %d nodes", node->name, node->type);
					break;
				} while (0);
			}
		}
	}
	vala_vapi_check_leave_scope (self);
}


static gint vala_vapi_check_check_metadata (ValaVAPICheck* self) {
	GError * inner_error;
	g_return_val_if_fail (VALA_IS_VAPI_CHECK (self), 0);
	inner_error = NULL;
	{
		GIOChannel* metafile;
		char* line;
		gint lineno;
		GIOStatus _tmp1;
		char* _tmp0;
		gint _tmp5;
		metafile = g_io_channel_new_file (vala_source_file_get_filename (self->priv->_metadata), "r", &inner_error);
		if (inner_error != NULL) {
			if (inner_error->domain == G_FILE_ERROR) {
				goto __catch1_g_file_error;
			}
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
			g_clear_error (&inner_error);
		}
		line = NULL;
		lineno = 1;
		_tmp0 = NULL;
		while (G_IO_STATUS_NORMAL == (_tmp1 = g_io_channel_read_line (metafile, &_tmp0, NULL, NULL, &inner_error), (line = (g_free (line), NULL)), line = _tmp0, _tmp1)) {
			char** _tmp2;
			gint tokens_length1;
			char** tokens;
			const char* _tmp3;
			char* symbol;
			_tmp2 = NULL;
			tokens = (_tmp2 = g_strsplit (line, " ", 2), tokens_length1 = -1, _tmp2);
			_tmp3 = NULL;
			symbol = (_tmp3 = tokens[0], (_tmp3 == NULL ? NULL : g_strdup (_tmp3)));
			if (strlen (symbol) > 0 && !gee_collection_contains (GEE_COLLECTION (self->priv->_symbols), symbol)) {
				ValaSourceReference* src;
				char* _tmp4;
				src = vala_source_reference_new (self->priv->_metadata, lineno, 1, lineno, ((gint) g_utf8_strlen (symbol, -1)));
				_tmp4 = NULL;
				vala_report_error (src, (_tmp4 = g_strdup_printf ("Symbol `%s' not found", symbol)));
				_tmp4 = (g_free (_tmp4), NULL);
				(src == NULL ? NULL : (src = (g_object_unref (src), NULL)));
			}
			lineno = lineno + (1);
			tokens = (_vala_array_free (tokens, tokens_length1, ((GDestroyNotify) g_free)), NULL);
			symbol = (g_free (symbol), NULL);
		}
		return (_tmp5 = 0, (metafile == NULL ? NULL : (metafile = (g_io_channel_unref (metafile), NULL))), (line = (g_free (line), NULL)), _tmp5);
	}
	goto __finally1;
	__catch1_g_file_error:
	{
		GError * error;
		error = inner_error;
		inner_error = NULL;
		{
			char* _tmp6;
			_tmp6 = NULL;
			vala_report_error (NULL, (_tmp6 = g_strdup_printf ("%s: %s", vala_source_file_get_filename (self->priv->_metadata), error->message)));
			_tmp6 = (g_free (_tmp6), NULL);
			return 1;
		}
	}
	__finally1:
	;
}


static gint vala_vapi_check_run (ValaVAPICheck* self) {
	g_return_val_if_fail (VALA_IS_VAPI_CHECK (self), 0);
	if (!g_file_test (vala_source_file_get_filename (self->priv->_gidl), G_FILE_TEST_IS_REGULAR)) {
		char* _tmp0;
		_tmp0 = NULL;
		vala_report_error (NULL, (_tmp0 = g_strdup_printf ("%s not found", vala_source_file_get_filename (self->priv->_gidl))));
		_tmp0 = (g_free (_tmp0), NULL);
		return 2;
	}
	if (!g_file_test (vala_source_file_get_filename (self->priv->_metadata), G_FILE_TEST_IS_REGULAR)) {
		char* _tmp2;
		_tmp2 = NULL;
		vala_report_error (NULL, (_tmp2 = g_strdup_printf ("%s not found", vala_source_file_get_filename (self->priv->_metadata))));
		_tmp2 = (g_free (_tmp2), NULL);
		return 2;
	}
	vala_vapi_check_parse_gidl (self);
	return vala_vapi_check_check_metadata (self);
}


static gint vala_vapi_check_main (char** args, int args_length1) {
	ValaVAPICheck* vapicheck;
	gint _tmp2;
	if (2 != args_length1 || !g_str_has_suffix (args[1], ".gidl")) {
		char* _tmp0;
		_tmp0 = NULL;
		fprintf (stdout, "Usage: %s library.gidl\n", (_tmp0 = g_path_get_basename (args[0])));
		_tmp0 = (g_free (_tmp0), NULL);
		return 2;
	}
	vapicheck = vala_vapi_check_new (args[1], vala_code_context_new ());
	return (_tmp2 = vala_vapi_check_run (vapicheck), (vapicheck == NULL ? NULL : (vapicheck = (g_object_unref (vapicheck), NULL))), _tmp2);
}


int main (int argc, char ** argv) {
	g_type_init ();
	return vala_vapi_check_main (argv, argc);
}


static ValaCodeContext* vala_vapi_check_get_context (ValaVAPICheck* self) {
	g_return_val_if_fail (VALA_IS_VAPI_CHECK (self), NULL);
	return self->priv->_context;
}


static void vala_vapi_check_set_context (ValaVAPICheck* self, ValaCodeContext* value) {
	ValaCodeContext* _tmp2;
	ValaCodeContext* _tmp1;
	g_return_if_fail (VALA_IS_VAPI_CHECK (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_context = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_context == NULL ? NULL : (self->priv->_context = (g_object_unref (self->priv->_context), NULL))), _tmp2);
}


static ValaSourceFile* vala_vapi_check_get_gidl (ValaVAPICheck* self) {
	g_return_val_if_fail (VALA_IS_VAPI_CHECK (self), NULL);
	return self->priv->_gidl;
}


static void vala_vapi_check_set_gidl (ValaVAPICheck* self, ValaSourceFile* value) {
	ValaSourceFile* _tmp2;
	ValaSourceFile* _tmp1;
	g_return_if_fail (VALA_IS_VAPI_CHECK (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_gidl = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_gidl == NULL ? NULL : (self->priv->_gidl = (g_object_unref (self->priv->_gidl), NULL))), _tmp2);
}


static ValaSourceFile* vala_vapi_check_get_metadata (ValaVAPICheck* self) {
	g_return_val_if_fail (VALA_IS_VAPI_CHECK (self), NULL);
	return self->priv->_metadata;
}


static void vala_vapi_check_set_metadata (ValaVAPICheck* self, ValaSourceFile* value) {
	ValaSourceFile* _tmp2;
	ValaSourceFile* _tmp1;
	g_return_if_fail (VALA_IS_VAPI_CHECK (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_metadata = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_metadata == NULL ? NULL : (self->priv->_metadata = (g_object_unref (self->priv->_metadata), NULL))), _tmp2);
}


static void vala_vapi_check_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ValaVAPICheck * self;
	self = VALA_VAPI_CHECK (object);
	switch (property_id) {
		case VALA_VAPI_CHECK_CONTEXT:
		g_value_set_object (value, vala_vapi_check_get_context (self));
		break;
		case VALA_VAPI_CHECK_GIDL:
		g_value_set_object (value, vala_vapi_check_get_gidl (self));
		break;
		case VALA_VAPI_CHECK_METADATA:
		g_value_set_object (value, vala_vapi_check_get_metadata (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_vapi_check_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ValaVAPICheck * self;
	self = VALA_VAPI_CHECK (object);
	switch (property_id) {
		case VALA_VAPI_CHECK_CONTEXT:
		vala_vapi_check_set_context (self, g_value_get_object (value));
		break;
		case VALA_VAPI_CHECK_GIDL:
		vala_vapi_check_set_gidl (self, g_value_get_object (value));
		break;
		case VALA_VAPI_CHECK_METADATA:
		vala_vapi_check_set_metadata (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_vapi_check_class_init (ValaVAPICheckClass * klass) {
	vala_vapi_check_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaVAPICheckPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_vapi_check_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_vapi_check_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_vapi_check_dispose;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_VAPI_CHECK_CONTEXT, g_param_spec_object ("context", "context", "context", VALA_TYPE_CODE_CONTEXT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_VAPI_CHECK_GIDL, g_param_spec_object ("gidl", "gidl", "gidl", VALA_TYPE_SOURCE_FILE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_VAPI_CHECK_METADATA, g_param_spec_object ("metadata", "metadata", "metadata", VALA_TYPE_SOURCE_FILE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void vala_vapi_check_init (ValaVAPICheck * self) {
	self->priv = VALA_VAPI_CHECK_GET_PRIVATE (self);
}


static void vala_vapi_check_dispose (GObject * obj) {
	ValaVAPICheck * self;
	self = VALA_VAPI_CHECK (obj);
	(self->priv->_context == NULL ? NULL : (self->priv->_context = (g_object_unref (self->priv->_context), NULL)));
	(self->priv->_gidl == NULL ? NULL : (self->priv->_gidl = (g_object_unref (self->priv->_gidl), NULL)));
	(self->priv->_metadata == NULL ? NULL : (self->priv->_metadata = (g_object_unref (self->priv->_metadata), NULL)));
	(self->priv->_scope == NULL ? NULL : (self->priv->_scope = (g_object_unref (self->priv->_scope), NULL)));
	(self->priv->_symbols == NULL ? NULL : (self->priv->_symbols = (g_object_unref (self->priv->_symbols), NULL)));
	G_OBJECT_CLASS (vala_vapi_check_parent_class)->dispose (obj);
}


static GType vala_vapi_check_get_type (void) {
	static GType vala_vapi_check_type_id = 0;
	if (G_UNLIKELY (vala_vapi_check_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaVAPICheckClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_vapi_check_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaVAPICheck), 0, (GInstanceInitFunc) vala_vapi_check_init };
		vala_vapi_check_type_id = g_type_register_static (G_TYPE_OBJECT, "ValaVAPICheck", &g_define_type_info, 0);
	}
	return vala_vapi_check_type_id;
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if (array != NULL && destroy_func != NULL) {
		int i;
		if (array_length >= 0)
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL)
			destroy_func (((gpointer*) array)[i]);
		}
		else
		for (i = 0; ((gpointer*) array)[i] != NULL; i = i + 1) {
			destroy_func (((gpointer*) array)[i]);
		}
	}
	g_free (array);
}




