/* valanamedargument.vala
 *
 * Copyright (C) 2006  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valanamedargument.h>
#include <vala/valaexpression.h>
#include <vala/valasourcereference.h>
#include <vala/valacodevisitor.h>




struct _ValaNamedArgumentPrivate {
	char* _name;
	ValaExpression* _argument;
};

#define VALA_NAMED_ARGUMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_NAMED_ARGUMENT, ValaNamedArgumentPrivate))
enum  {
	VALA_NAMED_ARGUMENT_DUMMY_PROPERTY,
	VALA_NAMED_ARGUMENT_NAME,
	VALA_NAMED_ARGUMENT_ARGUMENT
};
static void vala_named_argument_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static gpointer vala_named_argument_parent_class = NULL;
static void vala_named_argument_dispose (GObject * obj);



/**
 * Creates a new named argument.
 *
 * @param name   property name
 * @param arg    property value expression
 * @param source reference to source code
 * @return       newly created named argument
 */
ValaNamedArgument* vala_named_argument_new (const char* _name, ValaExpression* arg, ValaSourceReference* source) {
	GParameter * __params;
	GParameter * __params_it;
	ValaNamedArgument * self;
	g_return_val_if_fail (_name != NULL, NULL);
	g_return_val_if_fail (VALA_IS_EXPRESSION (arg), NULL);
	g_return_val_if_fail (VALA_IS_SOURCE_REFERENCE (source), NULL);
	__params = g_new0 (GParameter, 2);
	__params_it = __params;
	__params_it->name = "name";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, _name);
	__params_it++;
	__params_it->name = "argument";
	g_value_init (&__params_it->value, VALA_TYPE_EXPRESSION);
	g_value_set_object (&__params_it->value, arg);
	__params_it++;
	self = g_object_newv (VALA_TYPE_NAMED_ARGUMENT, __params_it - __params, __params);
	vala_code_node_set_source_reference (VALA_CODE_NODE (self), source);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


static void vala_named_argument_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaNamedArgument * self;
	self = VALA_NAMED_ARGUMENT (base);
	g_return_if_fail (VALA_IS_CODE_VISITOR (visitor));
	vala_code_node_accept (VALA_CODE_NODE (self->priv->_argument), visitor);
	vala_code_visitor_visit_named_argument (visitor, self);
}


char* vala_named_argument_get_name (ValaNamedArgument* self) {
	g_return_val_if_fail (VALA_IS_NAMED_ARGUMENT (self), NULL);
	return self->priv->_name;
}


void vala_named_argument_set_name (ValaNamedArgument* self, const char* value) {
	char* _tmp2;
	const char* _tmp1;
	g_return_if_fail (VALA_IS_NAMED_ARGUMENT (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_name = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_strdup (_tmp1))), (self->priv->_name = (g_free (self->priv->_name), NULL)), _tmp2);
}


ValaExpression* vala_named_argument_get_argument (ValaNamedArgument* self) {
	g_return_val_if_fail (VALA_IS_NAMED_ARGUMENT (self), NULL);
	return self->priv->_argument;
}


void vala_named_argument_set_argument (ValaNamedArgument* self, ValaExpression* value) {
	ValaExpression* _tmp2;
	ValaExpression* _tmp1;
	g_return_if_fail (VALA_IS_NAMED_ARGUMENT (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_argument = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_argument == NULL ? NULL : (self->priv->_argument = (g_object_unref (self->priv->_argument), NULL))), _tmp2);
}


static void vala_named_argument_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ValaNamedArgument * self;
	self = VALA_NAMED_ARGUMENT (object);
	switch (property_id) {
		case VALA_NAMED_ARGUMENT_NAME:
		g_value_set_string (value, vala_named_argument_get_name (self));
		break;
		case VALA_NAMED_ARGUMENT_ARGUMENT:
		g_value_set_object (value, vala_named_argument_get_argument (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_named_argument_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ValaNamedArgument * self;
	self = VALA_NAMED_ARGUMENT (object);
	switch (property_id) {
		case VALA_NAMED_ARGUMENT_NAME:
		vala_named_argument_set_name (self, g_value_get_string (value));
		break;
		case VALA_NAMED_ARGUMENT_ARGUMENT:
		vala_named_argument_set_argument (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_named_argument_class_init (ValaNamedArgumentClass * klass) {
	vala_named_argument_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaNamedArgumentPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_named_argument_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_named_argument_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_named_argument_dispose;
	VALA_CODE_NODE_CLASS (klass)->accept = vala_named_argument_real_accept;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_NAMED_ARGUMENT_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_NAMED_ARGUMENT_ARGUMENT, g_param_spec_object ("argument", "argument", "argument", VALA_TYPE_EXPRESSION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void vala_named_argument_init (ValaNamedArgument * self) {
	self->priv = VALA_NAMED_ARGUMENT_GET_PRIVATE (self);
}


static void vala_named_argument_dispose (GObject * obj) {
	ValaNamedArgument * self;
	self = VALA_NAMED_ARGUMENT (obj);
	self->priv->_name = (g_free (self->priv->_name), NULL);
	(self->priv->_argument == NULL ? NULL : (self->priv->_argument = (g_object_unref (self->priv->_argument), NULL)));
	G_OBJECT_CLASS (vala_named_argument_parent_class)->dispose (obj);
}


GType vala_named_argument_get_type (void) {
	static GType vala_named_argument_type_id = 0;
	if (G_UNLIKELY (vala_named_argument_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaNamedArgumentClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_named_argument_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaNamedArgument), 0, (GInstanceInitFunc) vala_named_argument_init };
		vala_named_argument_type_id = g_type_register_static (VALA_TYPE_CODE_NODE, "ValaNamedArgument", &g_define_type_info, 0);
	}
	return vala_named_argument_type_id;
}




