/* valafieldprototype.vala
 *
 * Copyright (C) 2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALA_VALAFIELDPROTOTYPE_H__
#define __VALA_VALAFIELDPROTOTYPE_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valadatatype.h>
#include <vala/valafield.h>

G_BEGIN_DECLS


#define VALA_TYPE_FIELD_PROTOTYPE (vala_field_prototype_get_type ())
#define VALA_FIELD_PROTOTYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_FIELD_PROTOTYPE, ValaFieldPrototype))
#define VALA_FIELD_PROTOTYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_FIELD_PROTOTYPE, ValaFieldPrototypeClass))
#define VALA_IS_FIELD_PROTOTYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_FIELD_PROTOTYPE))
#define VALA_IS_FIELD_PROTOTYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_FIELD_PROTOTYPE))
#define VALA_FIELD_PROTOTYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_FIELD_PROTOTYPE, ValaFieldPrototypeClass))

typedef struct _ValaFieldPrototype ValaFieldPrototype;
typedef struct _ValaFieldPrototypeClass ValaFieldPrototypeClass;
typedef struct _ValaFieldPrototypePrivate ValaFieldPrototypePrivate;

/**
 * A reference to an instance field without a specific instance.
 */
struct _ValaFieldPrototype {
	ValaDataType parent_instance;
	ValaFieldPrototypePrivate * priv;
};

struct _ValaFieldPrototypeClass {
	ValaDataTypeClass parent_class;
};


ValaFieldPrototype* vala_field_prototype_new (ValaField* field_symbol);
ValaField* vala_field_prototype_get_field_symbol (ValaFieldPrototype* self);
void vala_field_prototype_set_field_symbol (ValaFieldPrototype* self, ValaField* value);
GType vala_field_prototype_get_type (void);


G_END_DECLS

#endif
