/* pango.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "Pango", gir_namespace = "Pango", gir_version = "1.0", lower_case_cprefix = "pango_")]
namespace Pango {
	namespace Scale {
		[CCode (cheader_filename = "pango/pango.h", cname = "PANGO_SCALE_LARGE")]
		public const double LARGE;
		[CCode (cheader_filename = "pango/pango.h", cname = "PANGO_SCALE_MEDIUM")]
		public const double MEDIUM;
		[CCode (cheader_filename = "pango/pango.h", cname = "PANGO_SCALE_SMALL")]
		public const double SMALL;
		[CCode (cheader_filename = "pango/pango.h", cname = "PANGO_SCALE_XX_LARGE")]
		public const double XX_LARGE;
		[CCode (cheader_filename = "pango/pango.h", cname = "PANGO_SCALE_XX_SMALL")]
		public const double XX_SMALL;
		[CCode (cheader_filename = "pango/pango.h", cname = "PANGO_SCALE_X_LARGE")]
		public const double X_LARGE;
		[CCode (cheader_filename = "pango/pango.h", cname = "PANGO_SCALE_X_SMALL")]
		public const double X_SMALL;
	}
	[CCode (cheader_filename = "pango/pango.h")]
	[Compact]
	public class AttrClass {
		public GLib.Callback copy;
		public GLib.Callback destroy;
		public GLib.Callback equal;
		public Pango.AttrType type;
	}
	[CCode (cheader_filename = "pango/pango.h")]
	[Compact]
	public class AttrColor : Pango.Attribute {
		public Pango.Color color;
	}
	[CCode (cheader_filename = "pango/pango.h")]
	[Compact]
	public class AttrFloat : Pango.Attribute {
		public double value;
	}
	[CCode (cheader_filename = "pango/pango.h")]
	[Compact]
	public class AttrFontDesc : Pango.Attribute {
		public weak Pango.FontDescription desc;
		[CCode (has_construct_function = false, type = "PangoAttribute*")]
		public AttrFontDesc (Pango.FontDescription desc);
	}
	[CCode (cheader_filename = "pango/pango.h")]
	[Compact]
	public class AttrInt : Pango.Attribute {
		public int value;
	}
	[CCode (cheader_filename = "pango/pango.h", free_function = "pango_attr_iterator_destroy")]
	[Compact]
	public class AttrIterator {
		public Pango.AttrIterator copy ();
		public void destroy ();
		public unowned Pango.Attribute? @get (Pango.AttrType type);
		public GLib.SList<Pango.Attribute> get_attrs ();
		public void get_font (Pango.FontDescription desc, Pango.Language? language, owned GLib.SList<Pango.Attribute>? extra_attrs);
		public bool next ();
		public void range (out int start, out int end);
	}
	[CCode (cheader_filename = "pango/pango.h")]
	[Compact]
	public class AttrLanguage : Pango.Attribute {
		public weak Pango.Language value;
		[CCode (has_construct_function = false, type = "PangoAttribute*")]
		public AttrLanguage (Pango.Language language);
	}
	[CCode (cheader_filename = "pango/pango.h", ref_function = "pango_attr_list_ref", type_id = "pango_attr_list_get_type ()", unref_function = "pango_attr_list_unref")]
	[Compact]
	public class AttrList {
		[CCode (has_construct_function = false)]
		public AttrList ();
		public void change (owned Pango.Attribute attr);
		public Pango.AttrList copy ();
		public Pango.AttrList? filter (Pango.AttrFilterFunc func);
		public Pango.AttrIterator get_iterator ();
		public void insert (owned Pango.Attribute attr);
		public void insert_before (owned Pango.Attribute attr);
		public Pango.AttrList @ref ();
		public void splice (Pango.AttrList other, int pos, int len);
		public void unref ();
	}
	[CCode (cheader_filename = "pango/pango.h")]
	[Compact]
	public class AttrShape<T> : Pango.Attribute {
		public weak Pango.AttrDataCopyFunc<T> copy_func;
		public T data;
		public weak GLib.DestroyNotify destroy_func;
		public Pango.Rectangle ink_rect;
		public Pango.Rectangle logical_rect;
		[CCode (has_construct_function = false, type = "PangoAttribute*")]
		public AttrShape (Pango.Rectangle ink_rect, Pango.Rectangle logical_rect);
		[CCode (has_construct_function = false, simple_generics = true, type = "PangoAttribute*")]
		public AttrShape.with_data (Pango.Rectangle ink_rect, Pango.Rectangle logical_rect, owned T data, Pango.AttrDataCopyFunc<T> copy_func);
	}
	[CCode (cheader_filename = "pango/pango.h")]
	[Compact]
	public class AttrSize : Pango.Attribute {
		public uint absolute;
		public int size;
		[CCode (has_construct_function = false, type = "PangoAttribute*")]
		public AttrSize (int size);
	}
	[CCode (cheader_filename = "pango/pango.h")]
	[Compact]
	public class AttrString : Pango.Attribute {
		public weak string value;
	}
	[CCode (cheader_filename = "pango/pango.h", free_function = "pango_attribute_destroy")]
	[Compact]
	public class Attribute {
		public uint end_index;
		public weak Pango.AttrClass klass;
		public uint start_index;
		public Pango.Attribute copy ();
		public void destroy ();
		public bool equal (Pango.Attribute attr2);
		public void init (Pango.AttrClass klass);
	}
	[CCode (cheader_filename = "pango/pango.h", type_id = "pango_context_get_type ()")]
	public class Context : GLib.Object {
		[CCode (has_construct_function = false)]
		public Context ();
		public void changed ();
		public Pango.Direction get_base_dir ();
		public Pango.Gravity get_base_gravity ();
		public unowned Pango.FontDescription get_font_description ();
		public unowned Pango.FontMap get_font_map ();
		public Pango.Gravity get_gravity ();
		public Pango.GravityHint get_gravity_hint ();
		public Pango.Language get_language ();
		public unowned Pango.Matrix? get_matrix ();
		public Pango.FontMetrics get_metrics (Pango.FontDescription? desc, Pango.Language? language);
		public uint get_serial ();
		public void list_families ([CCode (array_length_cname = "n_families", array_length_pos = 1.1)] out Pango.FontFamily[] families);
		public Pango.Font load_font (Pango.FontDescription desc);
		public Pango.Fontset load_fontset (Pango.FontDescription desc, Pango.Language language);
		public void set_base_dir (Pango.Direction direction);
		public void set_base_gravity (Pango.Gravity gravity);
		public void set_font_description (Pango.FontDescription desc);
		public void set_font_map (Pango.FontMap font_map);
		public void set_gravity_hint (Pango.GravityHint hint);
		public void set_language (Pango.Language language);
		public void set_matrix (Pango.Matrix? matrix);
	}
	[CCode (cheader_filename = "pango/pango.h", ref_function = "pango_coverage_ref", unref_function = "pango_coverage_unref")]
	[Compact]
	public class Coverage {
		[CCode (has_construct_function = false)]
		public Coverage ();
		public Pango.Coverage copy ();
		public static Pango.Coverage from_bytes (uint8[] bytes);
		public Pango.CoverageLevel @get (int index_);
		public void max (Pango.Coverage other);
		public void @set (int index_, Pango.CoverageLevel level);
		public void to_bytes ([CCode (array_length_cname = "n_bytes", array_length_pos = 1.1)] out uint8[] bytes);
		public void unref ();
	}
	[CCode (cheader_filename = "pango/pango.h")]
	[Compact]
	public class EngineLang {
	}
	[CCode (cheader_filename = "pango/pango.h")]
	[Compact]
	public class EngineShape {
	}
	[CCode (cheader_filename = "pango/pango.h", type_id = "pango_font_get_type ()")]
	public abstract class Font : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Font ();
		public Pango.FontDescription describe ();
		public Pango.FontDescription describe_with_absolute_size ();
		public static void descriptions_free ([CCode (array_length_cname = "n_descs", array_length_pos = 1.1)] owned Pango.FontDescription[]? descs);
		public unowned Pango.EngineShape find_shaper (Pango.Language language, uint32 ch);
		public Pango.Coverage get_coverage (Pango.Language language);
		public unowned Pango.FontMap? get_font_map ();
		public void get_glyph_extents (Pango.Glyph glyph, out Pango.Rectangle ink_rect, out Pango.Rectangle logical_rect);
		public Pango.FontMetrics get_metrics (Pango.Language? language);
	}
	[CCode (cheader_filename = "pango/pango.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "pango_font_description_get_type ()")]
	[Compact]
	public class FontDescription {
		[CCode (has_construct_function = false)]
		public FontDescription ();
		public bool better_match (Pango.FontDescription? old_match, Pango.FontDescription new_match);
		public Pango.FontDescription copy ();
		public Pango.FontDescription copy_static ();
		public bool equal (Pango.FontDescription desc2);
		public void free ();
		public static Pango.FontDescription from_string (string str);
		public unowned string get_family ();
		public Pango.Gravity get_gravity ();
		public Pango.FontMask get_set_fields ();
		public int get_size ();
		public bool get_size_is_absolute ();
		public Pango.Stretch get_stretch ();
		public Pango.Style get_style ();
		public Pango.Variant get_variant ();
		public Pango.Weight get_weight ();
		public uint hash ();
		public void merge (Pango.FontDescription? desc_to_merge, bool replace_existing);
		public void merge_static (Pango.FontDescription desc_to_merge, bool replace_existing);
		public void set_absolute_size (double size);
		public void set_family (string family);
		public void set_family_static (string family);
		public void set_gravity (Pango.Gravity gravity);
		public void set_size (int size);
		public void set_stretch (Pango.Stretch stretch);
		public void set_style (Pango.Style style);
		public void set_variant (Pango.Variant variant);
		public void set_weight (Pango.Weight weight);
		public string to_filename ();
		public string to_string ();
		public void unset_fields (Pango.FontMask to_unset);
	}
	[CCode (cheader_filename = "pango/pango.h", type_id = "pango_font_face_get_type ()")]
	public abstract class FontFace : GLib.Object {
		[CCode (has_construct_function = false)]
		protected FontFace ();
		public Pango.FontDescription describe ();
		public unowned string get_face_name ();
		public bool is_synthesized ();
		public void list_sizes ([CCode (array_length_cname = "n_sizes", array_length_pos = 1.1)] out int[] sizes);
	}
	[CCode (cheader_filename = "pango/pango.h", type_id = "pango_font_family_get_type ()")]
	public abstract class FontFamily : GLib.Object {
		[CCode (has_construct_function = false)]
		protected FontFamily ();
		public unowned string get_name ();
		public bool is_monospace ();
		public void list_faces ([CCode (array_length_cname = "n_faces", array_length_pos = 1.1)] out Pango.FontFace[] faces);
	}
	[CCode (cheader_filename = "pango/pango.h", type_id = "pango_font_map_get_type ()")]
	public abstract class FontMap : GLib.Object {
		[CCode (has_construct_function = false)]
		protected FontMap ();
		public void changed ();
		public Pango.Context create_context ();
		public uint get_serial ();
		public void list_families ([CCode (array_length_cname = "n_families", array_length_pos = 1.1)] out Pango.FontFamily[] families);
		public Pango.Font load_font (Pango.Context context, Pango.FontDescription desc);
		public Pango.Fontset load_fontset (Pango.Context context, Pango.FontDescription desc, Pango.Language language);
	}
	[CCode (cheader_filename = "pango/pango.h", ref_function = "pango_font_metrics_ref", type_id = "pango_font_metrics_get_type ()", unref_function = "pango_font_metrics_unref")]
	[Compact]
	public class FontMetrics {
		public int get_approximate_char_width ();
		public int get_approximate_digit_width ();
		public int get_ascent ();
		public int get_descent ();
		public int get_strikethrough_position ();
		public int get_strikethrough_thickness ();
		public int get_underline_position ();
		public int get_underline_thickness ();
		public Pango.FontMetrics @ref ();
		public void unref ();
	}
	[CCode (cheader_filename = "pango/pango.h", type_id = "pango_fontset_get_type ()")]
	public abstract class Fontset : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Fontset ();
		public void @foreach (Pango.FontsetForeachFunc func);
		public Pango.Font get_font (uint wc);
		public Pango.FontMetrics get_metrics ();
	}
	[CCode (cheader_filename = "pango/pango.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "pango_glyph_item_get_type ()")]
	[Compact]
	public class GlyphItem {
		public weak Pango.GlyphString glyphs;
		public weak Pango.Item item;
		public GLib.SList<Pango.GlyphItem> apply_attrs (string text, Pango.AttrList list);
		public Pango.GlyphItem copy ();
		public void free ();
		public void get_logical_widths (string text, [CCode (array_length = false)] int[] logical_widths);
		public void letter_space (string text, [CCode (array_length = false)] Pango.LogAttr[] log_attrs, int letter_spacing);
		public Pango.GlyphItem split (string text, int split_index);
	}
	[CCode (cheader_filename = "pango/pango.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "pango_glyph_string_get_type ()")]
	[Compact]
	public class GlyphString {
		[CCode (array_length_cname = "num_glyphs")]
		public Pango.GlyphInfo[] glyphs;
		[CCode (array_length_cname = "num_glyphs")]
		public int[] log_clusters;
		public int num_glyphs;
		[CCode (has_construct_function = false)]
		public GlyphString ();
		public Pango.GlyphString copy ();
		public void extents (Pango.Font font, out Pango.Rectangle ink_rect, out Pango.Rectangle logical_rect);
		public void extents_range (int start, int end, Pango.Font font, out Pango.Rectangle ink_rect, out Pango.Rectangle logical_rect);
		public void free ();
		public void get_logical_widths (string text, int length, int embedding_level, [CCode (array_length = false)] int[] logical_widths);
		public int get_width ();
		public void index_to_x (string text, int length, Pango.Analysis analysis, int index_, bool trailing, out int x_pos);
		public void set_size (int new_len);
		public void x_to_index (string text, int length, Pango.Analysis analysis, int x_pos, out int index_, out int trailing);
	}
	[CCode (cheader_filename = "pango/pango.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "pango_item_get_type ()")]
	[Compact]
	public class Item {
		public Pango.Analysis analysis;
		public int length;
		public int num_chars;
		public int offset;
		[CCode (has_construct_function = false)]
		public Item ();
		public Pango.Item copy ();
		public void free ();
		public Pango.Item split (int split_index, int split_offset);
	}
	[CCode (cheader_filename = "pango/pango.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "pango_language_get_type ()")]
	[Compact]
	public class Language {
		public static unowned Pango.Language from_string (string? language);
		public static unowned Pango.Language get_default ();
		public unowned string get_sample_string ();
		[CCode (array_length_pos = 0.1)]
		public unowned Pango.Script[] get_scripts ();
		public bool includes_script (Pango.Script script);
		public bool matches (string range_list);
		public unowned string to_string ();
	}
	[CCode (cheader_filename = "pango/pango.h", type_id = "pango_layout_get_type ()")]
	public class Layout : GLib.Object {
		[CCode (has_construct_function = false)]
		public Layout (Pango.Context context);
		public void context_changed ();
		public Pango.Layout copy ();
		public Pango.Alignment get_alignment ();
		public unowned Pango.AttrList get_attributes ();
		public bool get_auto_dir ();
		public int get_baseline ();
		public int get_character_count ();
		public unowned Pango.Context get_context ();
		public void get_cursor_pos (int index_, out Pango.Rectangle strong_pos, out Pango.Rectangle weak_pos);
		public Pango.EllipsizeMode get_ellipsize ();
		public void get_extents (out Pango.Rectangle ink_rect, out Pango.Rectangle logical_rect);
		public unowned Pango.FontDescription? get_font_description ();
		public int get_height ();
		public int get_indent ();
		public Pango.LayoutIter get_iter ();
		public bool get_justify ();
		public unowned Pango.LayoutLine get_line (int line);
		public int get_line_count ();
		public unowned Pango.LayoutLine get_line_readonly (int line);
		public unowned GLib.SList<Pango.LayoutLine> get_lines ();
		public unowned GLib.SList<Pango.LayoutLine> get_lines_readonly ();
		public void get_log_attrs ([CCode (array_length_cname = "n_attrs", array_length_pos = 1.1)] out Pango.LogAttr[] attrs);
		[CCode (array_length_pos = 0.1)]
		public unowned Pango.LogAttr[] get_log_attrs_readonly ();
		public void get_pixel_extents (out Pango.Rectangle ink_rect, out Pango.Rectangle logical_rect);
		public void get_pixel_size (out int width, out int height);
		public uint get_serial ();
		public bool get_single_paragraph_mode ();
		public void get_size (out int width, out int height);
		public int get_spacing ();
		public Pango.TabArray get_tabs ();
		public unowned string get_text ();
		public int get_unknown_glyphs_count ();
		public int get_width ();
		public Pango.WrapMode get_wrap ();
		public void index_to_line_x (int index_, bool trailing, out int line, out int x_pos);
		public Pango.Rectangle index_to_pos (int index_);
		public bool is_ellipsized ();
		public bool is_wrapped ();
		public void move_cursor_visually (bool strong, int old_index, int old_trailing, int direction, out int new_index, out int new_trailing);
		public void set_alignment (Pango.Alignment alignment);
		public void set_attributes (Pango.AttrList? attrs);
		public void set_auto_dir (bool auto_dir);
		public void set_ellipsize (Pango.EllipsizeMode ellipsize);
		public void set_font_description (Pango.FontDescription? desc);
		public void set_height (int height);
		public void set_indent (int indent);
		public void set_justify (bool justify);
		public void set_markup (string markup, int length);
		public void set_markup_with_accel (string markup, int length, unichar accel_marker, out unichar accel_char);
		public void set_single_paragraph_mode (bool setting);
		public void set_spacing (int spacing);
		public void set_tabs (Pango.TabArray? tabs);
		public void set_text (string text, int length);
		public void set_width (int width);
		public void set_wrap (Pango.WrapMode wrap);
		public bool xy_to_index (int x, int y, out int index_, out int trailing);
	}
	[CCode (cheader_filename = "pango/pango.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "pango_layout_iter_get_type ()")]
	[Compact]
	public class LayoutIter {
		public bool at_last_line ();
		public Pango.LayoutIter copy ();
		public void free ();
		public int get_baseline ();
		public Pango.Rectangle get_char_extents ();
		public void get_cluster_extents (out Pango.Rectangle ink_rect, out Pango.Rectangle logical_rect);
		public int get_index ();
		public unowned Pango.Layout get_layout ();
		public void get_layout_extents (out Pango.Rectangle ink_rect, out Pango.Rectangle logical_rect);
		public Pango.LayoutLine get_line ();
		public void get_line_extents (out Pango.Rectangle ink_rect, out Pango.Rectangle logical_rect);
		public unowned Pango.LayoutLine get_line_readonly ();
		public void get_line_yrange (out int y0_, out int y1_);
		public unowned Pango.LayoutRun get_run ();
		public void get_run_extents (out Pango.Rectangle ink_rect, out Pango.Rectangle logical_rect);
		public unowned Pango.LayoutRun get_run_readonly ();
		public bool next_char ();
		public bool next_cluster ();
		public bool next_line ();
		public bool next_run ();
	}
	[CCode (cheader_filename = "pango/pango.h", ref_function = "pango_layout_line_ref", type_id = "pango_layout_line_get_type ()", unref_function = "pango_layout_line_unref")]
	[Compact]
	public class LayoutLine {
		public uint is_paragraph_start;
		public weak Pango.Layout layout;
		public int length;
		public uint resolved_dir;
		public weak GLib.SList<Pango.LayoutRun> runs;
		public int start_index;
		public void get_extents (out Pango.Rectangle ink_rect, out Pango.Rectangle logical_rect);
		public void get_pixel_extents (out Pango.Rectangle ink_rect, out Pango.Rectangle logical_rect);
		public void get_x_ranges (int start_index, int end_index, [CCode (array_length_cname = "n_ranges", array_length_pos = 3.1)] out int[] ranges);
		public void index_to_x (int index_, bool trailing, out int x_pos);
		public Pango.LayoutLine @ref ();
		public void unref ();
		public bool x_to_index (int x_pos, out int index_, out int trailing);
	}
	[CCode (cheader_filename = "pango/pango.h")]
	public class LayoutRun : Pango.GlyphItem {
		[CCode (has_construct_function = false)]
		protected LayoutRun ();
	}
	[CCode (cheader_filename = "pango/pango.h", type_id = "pango_renderer_get_type ()")]
	public abstract class Renderer : GLib.Object {
		public Pango.Matrix matrix;
		[CCode (has_construct_function = false)]
		protected Renderer ();
		public void activate ();
		[NoWrapper]
		public virtual void begin ();
		public void deactivate ();
		public virtual void draw_error_underline (int x, int y, int width, int height);
		public virtual void draw_glyph (Pango.Font font, Pango.Glyph glyph, double x, double y);
		public virtual void draw_glyph_item (string? text, Pango.GlyphItem glyph_item, int x, int y);
		public virtual void draw_glyphs (Pango.Font font, Pango.GlyphString glyphs, int x, int y);
		public void draw_layout (Pango.Layout layout, int x, int y);
		public void draw_layout_line (Pango.LayoutLine line, int x, int y);
		public virtual void draw_rectangle (Pango.RenderPart part, int x, int y, int width, int height);
		[NoWrapper]
		public virtual void draw_shape (Pango.AttrShape attr, int x, int y);
		public virtual void draw_trapezoid (Pango.RenderPart part, double y1_, double x11, double x21, double y2, double x12, double x22);
		[NoWrapper]
		public virtual void end ();
		public unowned Pango.Color? get_color (Pango.RenderPart part);
		public unowned Pango.Layout get_layout ();
		public unowned Pango.LayoutLine get_layout_line ();
		public unowned Pango.Matrix? get_matrix ();
		public virtual void part_changed (Pango.RenderPart part);
		[NoWrapper]
		public virtual void prepare_run (Pango.LayoutRun run);
		public void set_color (Pango.RenderPart part, Pango.Color? color);
		public void set_matrix (Pango.Matrix? matrix);
	}
	[CCode (cheader_filename = "pango/pango.h")]
	[Compact]
	public class ScriptIter {
		[CCode (has_construct_function = false)]
		public ScriptIter (string text, int length);
		public void free ();
		public void get_range (out string start, out string end, out Pango.Script script);
		public bool next ();
	}
	[CCode (cheader_filename = "pango/pango.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "pango_tab_array_get_type ()")]
	[Compact]
	public class TabArray {
		[CCode (has_construct_function = false)]
		public TabArray (int initial_size, bool positions_in_pixels);
		public Pango.TabArray copy ();
		public void free ();
		public bool get_positions_in_pixels ();
		public int get_size ();
		public void get_tab (int tab_index, out Pango.TabAlign alignment, out int location);
		public void get_tabs (out Pango.TabAlign alignments, [CCode (array_length = false)] out int[] locations);
		public void resize (int new_size);
		public void set_tab (int tab_index, Pango.TabAlign alignment, int location);
		[CCode (has_construct_function = false)]
		public TabArray.with_positions (int size, bool positions_in_pixels, Pango.TabAlign first_alignment, ...);
	}
	[CCode (cheader_filename = "pango/pango.h", has_type_id = false)]
	public struct Analysis {
		public weak Pango.EngineShape shape_engine;
		public weak Pango.EngineLang lang_engine;
		public weak Pango.Font font;
		public uint8 level;
		public uint8 gravity;
		public uint8 flags;
		public uint8 script;
		public weak Pango.Language language;
		public weak GLib.SList<void*> extra_attrs;
	}
	[CCode (cheader_filename = "pango/pango.h", type_id = "pango_color_get_type ()")]
	public struct Color {
		public uint16 red;
		public uint16 green;
		public uint16 blue;
		public Pango.Color? copy ();
		public void free ();
		public bool parse (string spec);
		public string to_string ();
	}
	[CCode (cheader_filename = "pango/pango.h")]
	[SimpleType]
	public struct Glyph : uint32 {
	}
	[CCode (cheader_filename = "pango/pango.h", has_type_id = false)]
	public struct GlyphGeometry {
		public Pango.GlyphUnit width;
		public Pango.GlyphUnit x_offset;
		public Pango.GlyphUnit y_offset;
	}
	[CCode (cheader_filename = "pango/pango.h", has_type_id = false)]
	public struct GlyphInfo {
		public Pango.Glyph glyph;
		public Pango.GlyphGeometry geometry;
		public Pango.GlyphVisAttr attr;
	}
	[CCode (cheader_filename = "pango/pango.h", type_id = "pango_glyph_item_iter_get_type ()")]
	public struct GlyphItemIter {
		public weak Pango.GlyphItem glyph_item;
		public weak string text;
		public int start_glyph;
		public int start_index;
		public int start_char;
		public int end_glyph;
		public int end_index;
		public int end_char;
		public Pango.GlyphItemIter? copy ();
		public void free ();
		public bool init_end (Pango.GlyphItem glyph_item, string text);
		public bool init_start (Pango.GlyphItem glyph_item, string text);
		public bool next_cluster ();
		public bool prev_cluster ();
	}
	[CCode (cheader_filename = "pango/pango.h")]
	[SimpleType]
	public struct GlyphUnit : int32 {
	}
	[CCode (cheader_filename = "pango/pango.h", has_type_id = false)]
	public struct GlyphVisAttr {
		public uint is_cluster_start;
	}
	[CCode (cheader_filename = "pango/pango.h", has_type_id = false)]
	public struct LogAttr {
		public uint is_line_break;
		public uint is_mandatory_break;
		public uint is_char_break;
		public uint is_white;
		public uint is_cursor_position;
		public uint is_word_start;
		public uint is_word_end;
		public uint is_sentence_boundary;
		public uint is_sentence_start;
		public uint is_sentence_end;
		public uint backspace_deletes_character;
		public uint is_expandable_space;
		public uint is_word_boundary;
	}
	[CCode (cheader_filename = "pango/pango.h", type_id = "pango_matrix_get_type ()")]
	public struct Matrix {
		public double xx;
		public double xy;
		public double yx;
		public double yy;
		public double x0;
		public double y0;
		public void concat (Pango.Matrix new_matrix);
		public Pango.Matrix? copy ();
		public void free ();
		public double get_font_scale_factor ();
		public void rotate (double degrees);
		public void scale (double scale_x, double scale_y);
		public void transform_distance (ref double dx, ref double dy);
		public void transform_pixel_rectangle (ref Pango.Rectangle? rect);
		public void transform_point (ref double x, ref double y);
		public void transform_rectangle (ref Pango.Rectangle? rect);
		public void translate (double tx, double ty);
	}
	[CCode (cheader_filename = "pango/pango.h", has_type_id = false)]
	public struct Rectangle {
		public int x;
		public int y;
		public int width;
		public int height;
	}
	[CCode (cheader_filename = "pango/pango.h", has_type_id = false)]
	public struct ScriptForLang {
		[CCode (array_length = false, array_null_terminated = true)]
		public weak char[] lang;
		[CCode (array_length = false, array_null_terminated = true)]
		public weak Pango.Script[] scripts;
	}
	[CCode (cheader_filename = "pango/pango.h", cprefix = "PANGO_ALIGN_", type_id = "pango_alignment_get_type ()")]
	public enum Alignment {
		LEFT,
		CENTER,
		RIGHT
	}
	[CCode (cheader_filename = "pango/pango.h", cprefix = "PANGO_ATTR_", type_id = "pango_attr_type_get_type ()")]
	public enum AttrType {
		INVALID,
		LANGUAGE,
		FAMILY,
		STYLE,
		WEIGHT,
		VARIANT,
		STRETCH,
		SIZE,
		FONT_DESC,
		FOREGROUND,
		BACKGROUND,
		UNDERLINE,
		STRIKETHROUGH,
		RISE,
		SHAPE,
		SCALE,
		FALLBACK,
		LETTER_SPACING,
		UNDERLINE_COLOR,
		STRIKETHROUGH_COLOR,
		ABSOLUTE_SIZE,
		GRAVITY,
		GRAVITY_HINT;
		public static unowned string get_name (Pango.AttrType type);
		public static Pango.AttrType register (string name);
	}
	[CCode (cheader_filename = "pango/pango.h", cprefix = "PANGO_BIDI_TYPE_", type_id = "pango_bidi_type_get_type ()")]
	public enum BidiType {
		L,
		LRE,
		LRO,
		R,
		AL,
		RLE,
		RLO,
		PDF,
		EN,
		ES,
		ET,
		AN,
		CS,
		NSM,
		BN,
		B,
		S,
		WS,
		ON;
		public static Pango.BidiType for_unichar (unichar ch);
	}
	[CCode (cheader_filename = "pango/pango.h", cprefix = "PANGO_COVERAGE_", type_id = "pango_coverage_level_get_type ()")]
	public enum CoverageLevel {
		NONE,
		FALLBACK,
		APPROXIMATE,
		EXACT
	}
	[CCode (cheader_filename = "pango/pango.h", cprefix = "PANGO_DIRECTION_", type_id = "pango_direction_get_type ()")]
	public enum Direction {
		LTR,
		RTL,
		TTB_LTR,
		TTB_RTL,
		WEAK_LTR,
		WEAK_RTL,
		NEUTRAL
	}
	[CCode (cheader_filename = "pango/pango.h", cprefix = "PANGO_ELLIPSIZE_", type_id = "pango_ellipsize_mode_get_type ()")]
	public enum EllipsizeMode {
		NONE,
		START,
		MIDDLE,
		END
	}
	[CCode (cheader_filename = "pango/pango.h", cprefix = "PANGO_FONT_MASK_", type_id = "pango_font_mask_get_type ()")]
	[Flags]
	public enum FontMask {
		FAMILY,
		STYLE,
		VARIANT,
		WEIGHT,
		STRETCH,
		SIZE,
		GRAVITY
	}
	[CCode (cheader_filename = "pango/pango.h", cprefix = "PANGO_GRAVITY_", type_id = "pango_gravity_get_type ()")]
	public enum Gravity {
		SOUTH,
		EAST,
		NORTH,
		WEST,
		AUTO;
		public static Pango.Gravity get_for_matrix (Pango.Matrix matrix);
		public static Pango.Gravity get_for_script (Pango.Script script, Pango.Gravity base_gravity, Pango.GravityHint hint);
		public static Pango.Gravity get_for_script_and_width (Pango.Script script, bool wide, Pango.Gravity base_gravity, Pango.GravityHint hint);
		public static double to_rotation (Pango.Gravity gravity);
	}
	[CCode (cheader_filename = "pango/pango.h", cprefix = "PANGO_GRAVITY_HINT_", type_id = "pango_gravity_hint_get_type ()")]
	public enum GravityHint {
		NATURAL,
		STRONG,
		LINE
	}
	[CCode (cheader_filename = "pango/pango.h", cprefix = "PANGO_RENDER_PART_", type_id = "pango_render_part_get_type ()")]
	public enum RenderPart {
		FOREGROUND,
		BACKGROUND,
		UNDERLINE,
		STRIKETHROUGH
	}
	[CCode (cheader_filename = "pango/pango.h", cprefix = "PANGO_SCRIPT_", type_id = "pango_script_get_type ()")]
	public enum Script {
		INVALID_CODE,
		COMMON,
		INHERITED,
		ARABIC,
		ARMENIAN,
		BENGALI,
		BOPOMOFO,
		CHEROKEE,
		COPTIC,
		CYRILLIC,
		DESERET,
		DEVANAGARI,
		ETHIOPIC,
		GEORGIAN,
		GOTHIC,
		GREEK,
		GUJARATI,
		GURMUKHI,
		HAN,
		HANGUL,
		HEBREW,
		HIRAGANA,
		KANNADA,
		KATAKANA,
		KHMER,
		LAO,
		LATIN,
		MALAYALAM,
		MONGOLIAN,
		MYANMAR,
		OGHAM,
		OLD_ITALIC,
		ORIYA,
		RUNIC,
		SINHALA,
		SYRIAC,
		TAMIL,
		TELUGU,
		THAANA,
		THAI,
		TIBETAN,
		CANADIAN_ABORIGINAL,
		YI,
		TAGALOG,
		HANUNOO,
		BUHID,
		TAGBANWA,
		BRAILLE,
		CYPRIOT,
		LIMBU,
		OSMANYA,
		SHAVIAN,
		LINEAR_B,
		TAI_LE,
		UGARITIC,
		NEW_TAI_LUE,
		BUGINESE,
		GLAGOLITIC,
		TIFINAGH,
		SYLOTI_NAGRI,
		OLD_PERSIAN,
		KHAROSHTHI,
		UNKNOWN,
		BALINESE,
		CUNEIFORM,
		PHOENICIAN,
		PHAGS_PA,
		NKO,
		KAYAH_LI,
		LEPCHA,
		REJANG,
		SUNDANESE,
		SAURASHTRA,
		CHAM,
		OL_CHIKI,
		VAI,
		CARIAN,
		LYCIAN,
		LYDIAN,
		BATAK,
		BRAHMI,
		MANDAIC,
		CHAKMA,
		MEROITIC_CURSIVE,
		MEROITIC_HIEROGLYPHS,
		MIAO,
		SHARADA,
		SORA_SOMPENG,
		TAKRI;
		public static Pango.Script for_unichar (unichar ch);
		public static Pango.Language get_sample_language (Pango.Script script);
	}
	[CCode (cheader_filename = "pango/pango.h", cprefix = "PANGO_STRETCH_", type_id = "pango_stretch_get_type ()")]
	public enum Stretch {
		ULTRA_CONDENSED,
		EXTRA_CONDENSED,
		CONDENSED,
		SEMI_CONDENSED,
		NORMAL,
		SEMI_EXPANDED,
		EXPANDED,
		EXTRA_EXPANDED,
		ULTRA_EXPANDED
	}
	[CCode (cheader_filename = "pango/pango.h", cprefix = "PANGO_STYLE_", type_id = "pango_style_get_type ()")]
	public enum Style {
		NORMAL,
		OBLIQUE,
		ITALIC
	}
	[CCode (cheader_filename = "pango/pango.h", cprefix = "PANGO_TAB_", type_id = "pango_tab_align_get_type ()")]
	public enum TabAlign {
		LEFT
	}
	[CCode (cheader_filename = "pango/pango.h", cprefix = "PANGO_UNDERLINE_", type_id = "pango_underline_get_type ()")]
	public enum Underline {
		NONE,
		SINGLE,
		DOUBLE,
		LOW,
		ERROR
	}
	[CCode (cheader_filename = "pango/pango.h", cprefix = "PANGO_VARIANT_", type_id = "pango_variant_get_type ()")]
	public enum Variant {
		NORMAL,
		SMALL_CAPS
	}
	[CCode (cheader_filename = "pango/pango.h", cprefix = "PANGO_WEIGHT_", type_id = "pango_weight_get_type ()")]
	public enum Weight {
		THIN,
		ULTRALIGHT,
		LIGHT,
		BOOK,
		NORMAL,
		MEDIUM,
		SEMIBOLD,
		BOLD,
		ULTRABOLD,
		HEAVY,
		ULTRAHEAVY
	}
	[CCode (cheader_filename = "pango/pango.h", cprefix = "PANGO_WRAP_", type_id = "pango_wrap_mode_get_type ()")]
	public enum WrapMode {
		WORD,
		CHAR,
		WORD_CHAR
	}
	[CCode (cheader_filename = "pango/pango.h", has_target = false)]
	public delegate T AttrDataCopyFunc<T> (T data);
	[CCode (cheader_filename = "pango/pango.h", instance_pos = 1.9)]
	public delegate bool AttrFilterFunc (Pango.Attribute attribute);
	[CCode (cheader_filename = "pango/pango.h", instance_pos = 2.9)]
	public delegate bool FontsetForeachFunc (Pango.Fontset fontset, Pango.Font font);
	[CCode (cheader_filename = "pango/pango.h", cname = "PANGO_ANALYSIS_FLAG_CENTERED_BASELINE")]
	public const int ANALYSIS_FLAG_CENTERED_BASELINE;
	[CCode (cheader_filename = "pango/pango.h", cname = "PANGO_ATTR_INDEX_FROM_TEXT_BEGINNING")]
	public const int ATTR_INDEX_FROM_TEXT_BEGINNING;
	[CCode (cheader_filename = "pango/pango.h", cname = "PANGO_ENGINE_TYPE_LANG")]
	public const string ENGINE_TYPE_LANG;
	[CCode (cheader_filename = "pango/pango.h", cname = "PANGO_ENGINE_TYPE_SHAPE")]
	public const string ENGINE_TYPE_SHAPE;
	[CCode (cheader_filename = "pango/pango.h", cname = "PANGO_GLYPH_EMPTY")]
	public const Pango.Glyph GLYPH_EMPTY;
	[CCode (cheader_filename = "pango/pango.h", cname = "PANGO_GLYPH_INVALID_INPUT")]
	public const Pango.Glyph GLYPH_INVALID_INPUT;
	[CCode (cheader_filename = "pango/pango.h", cname = "PANGO_GLYPH_UNKNOWN_FLAG")]
	public const Pango.Glyph GLYPH_UNKNOWN_FLAG;
	[CCode (cheader_filename = "pango/pango.h", cname = "PANGO_RENDER_TYPE_NONE")]
	public const string RENDER_TYPE_NONE;
	[CCode (cheader_filename = "pango/pango.h", cname = "PANGO_SCALE")]
	public const int SCALE;
	[CCode (cheader_filename = "pango/pango.h", cname = "PANGO_UNKNOWN_GLYPH_HEIGHT")]
	public const int UNKNOWN_GLYPH_HEIGHT;
	[CCode (cheader_filename = "pango/pango.h", cname = "PANGO_UNKNOWN_GLYPH_WIDTH")]
	public const int UNKNOWN_GLYPH_WIDTH;
	[CCode (cheader_filename = "pango/pango.h")]
	public const int VERSION_MAJOR;
	[CCode (cheader_filename = "pango/pango.h")]
	public const int VERSION_MICRO;
	[CCode (cheader_filename = "pango/pango.h")]
	public const int VERSION_MINOR;
	[CCode (cheader_filename = "pango/pango.h")]
	public const string VERSION_STRING;
	[CCode (cheader_filename = "pango/pango.h")]
	public static Pango.Attribute attr_background_new (uint16 red, uint16 green, uint16 blue);
	[CCode (cheader_filename = "pango/pango.h")]
	public static Pango.Attribute attr_fallback_new (bool enable_fallback);
	[CCode (cheader_filename = "pango/pango.h")]
	public static Pango.Attribute attr_family_new (string family);
	[CCode (cheader_filename = "pango/pango.h")]
	public static Pango.Attribute attr_foreground_new (uint16 red, uint16 green, uint16 blue);
	[CCode (cheader_filename = "pango/pango.h")]
	public static Pango.Attribute attr_gravity_hint_new (Pango.GravityHint hint);
	[CCode (cheader_filename = "pango/pango.h")]
	public static Pango.Attribute attr_gravity_new (Pango.Gravity gravity);
	[CCode (cheader_filename = "pango/pango.h")]
	public static Pango.Attribute attr_letter_spacing_new (int letter_spacing);
	[CCode (cheader_filename = "pango/pango.h")]
	public static Pango.Attribute attr_rise_new (int rise);
	[CCode (cheader_filename = "pango/pango.h")]
	public static Pango.Attribute attr_scale_new (double scale_factor);
	[CCode (cheader_filename = "pango/pango.h")]
	public static Pango.Attribute attr_stretch_new (Pango.Stretch stretch);
	[CCode (cheader_filename = "pango/pango.h")]
	public static Pango.Attribute attr_strikethrough_color_new (uint16 red, uint16 green, uint16 blue);
	[CCode (cheader_filename = "pango/pango.h")]
	public static Pango.Attribute attr_strikethrough_new (bool strikethrough);
	[CCode (cheader_filename = "pango/pango.h")]
	public static Pango.Attribute attr_style_new (Pango.Style style);
	[CCode (cheader_filename = "pango/pango.h")]
	[Deprecated (replacement = "Pango.AttrType.get_name", since = "vala-0.18")]
	public static unowned string attr_type_get_name (Pango.AttrType type);
	[CCode (cheader_filename = "pango/pango.h")]
	[Deprecated (replacement = "Pango.AttrType.get_name", since = "vala-0.18")]
	public static Pango.AttrType attr_type_register (string name);
	[CCode (cheader_filename = "pango/pango.h")]
	public static Pango.Attribute attr_underline_color_new (uint16 red, uint16 green, uint16 blue);
	[CCode (cheader_filename = "pango/pango.h")]
	public static Pango.Attribute attr_underline_new (Pango.Underline underline);
	[CCode (cheader_filename = "pango/pango.h")]
	public static Pango.Attribute attr_variant_new (Pango.Variant variant);
	[CCode (cheader_filename = "pango/pango.h")]
	public static Pango.Attribute attr_weight_new (Pango.Weight weight);
	[CCode (cheader_filename = "pango/pango.h")]
	[Deprecated (replacement = "Pango.BidiType.for_unichar", since = "vala-0.18")]
	public static Pango.BidiType bidi_type_for_unichar (unichar ch);
	[CCode (cheader_filename = "pango/pango.h")]
	public static void @break (string text, int length, Pango.Analysis analysis, [CCode (array_length_cname = "attrs_len", array_length_pos = 4.1)] Pango.LogAttr[] attrs);
	[CCode (cheader_filename = "pango/pango.h")]
	public static void extents_to_pixels (Pango.Rectangle? inclusive, Pango.Rectangle? nearest);
	[CCode (cheader_filename = "pango/pango.h")]
	public static Pango.Direction find_base_dir (string text, int length);
	[CCode (cheader_filename = "pango/pango.h")]
	public static void find_paragraph_boundary (string text, int length, out int paragraph_delimiter_index, out int next_paragraph_start);
	[CCode (cheader_filename = "pango/pango.h")]
	public static void get_log_attrs (string text, int length, int level, Pango.Language language, [CCode (array_length_cname = "attrs_len", array_length_pos = 5.1)] Pango.LogAttr[] log_attrs);
	[CCode (cheader_filename = "pango/pango.h")]
	public static bool get_mirror_char (unichar ch, unichar mirrored_ch);
	[CCode (cheader_filename = "pango/pango.h")]
	[Deprecated (replacement = "Pango.Gravity.get_for_matrix", since = "vala-0.18")]
	public static Pango.Gravity gravity_get_for_matrix (Pango.Matrix matrix);
	[CCode (cheader_filename = "pango/pango.h")]
	[Deprecated (replacement = "Pango.Gravity.get_for_script", since = "vala-0.18")]
	public static Pango.Gravity gravity_get_for_script (Pango.Script script, Pango.Gravity base_gravity, Pango.GravityHint hint);
	[CCode (cheader_filename = "pango/pango.h")]
	[Deprecated (replacement = "Pango.Gravity.get_for_script_and_width", since = "vala-0.18")]
	public static Pango.Gravity gravity_get_for_script_and_width (Pango.Script script, bool wide, Pango.Gravity base_gravity, Pango.GravityHint hint);
	[CCode (cheader_filename = "pango/pango.h")]
	[Deprecated (replacement = "Pango.Gravity.get_to_rotation", since = "vala-0.18")]
	public static double gravity_to_rotation (Pango.Gravity gravity);
	[CCode (cheader_filename = "pango/pango.h")]
	public static bool is_zero_width (unichar ch);
	[CCode (cheader_filename = "pango/pango.h")]
	public static GLib.List<Pango.Item> itemize (Pango.Context context, string text, int start_index, int length, Pango.AttrList attrs, Pango.AttrIterator? cached_iter);
	[CCode (cheader_filename = "pango/pango.h")]
	public static GLib.List<Pango.Item> itemize_with_base_dir (Pango.Context context, Pango.Direction base_dir, string text, int start_index, int length, Pango.AttrList attrs, Pango.AttrIterator? cached_iter);
	[CCode (cheader_filename = "pango/pango.h")]
	public static uint8 log2vis_get_embedding_levels (string text, int length, Pango.Direction pbase_dir);
	[CCode (cheader_filename = "pango/pango.h")]
	public static bool markup_parser_finish (GLib.MarkupParseContext context, out Pango.AttrList attr_list, out string text, out unichar accel_char) throws GLib.Error;
	[CCode (cheader_filename = "pango/pango.h")]
	public static unowned GLib.MarkupParseContext markup_parser_new (unichar accel_marker);
	[CCode (cheader_filename = "pango/pango.h")]
	public static bool parse_enum (GLib.Type type, string? str, out int value, bool warn, out string possible_values);
	[CCode (cheader_filename = "pango/pango.h")]
	public static bool parse_markup (string markup_text, int length, unichar accel_marker, out Pango.AttrList attr_list, out string text, out unichar accel_char) throws GLib.Error;
	[CCode (cheader_filename = "pango/pango.h")]
	public static bool parse_stretch (string str, out Pango.Stretch stretch, bool warn);
	[CCode (cheader_filename = "pango/pango.h")]
	public static bool parse_style (string str, out Pango.Style style, bool warn);
	[CCode (cheader_filename = "pango/pango.h")]
	public static bool parse_variant (string str, out Pango.Variant variant, bool warn);
	[CCode (cheader_filename = "pango/pango.h")]
	public static bool parse_weight (string str, out Pango.Weight weight, bool warn);
	[CCode (cheader_filename = "pango/pango.h")]
	public static void quantize_line_geometry (ref int thickness, ref int position);
	[CCode (cheader_filename = "pango/pango.h")]
	public static int read_line ([CCode (type = "FILE*")] GLib.FileStream stream, GLib.StringBuilder str);
	[CCode (cheader_filename = "pango/pango.h")]
	public static GLib.List<Pango.Item> reorder_items (GLib.List<Pango.Item> logical_items);
	[CCode (cheader_filename = "pango/pango.h")]
	public static bool scan_int (ref string pos, out int @out);
	[CCode (cheader_filename = "pango/pango.h")]
	public static bool scan_string (ref string pos, GLib.StringBuilder @out);
	[CCode (cheader_filename = "pango/pango.h")]
	public static bool scan_word (ref string pos, out unowned GLib.StringBuilder @out);
	[CCode (cheader_filename = "pango/pango.h")]
	[Deprecated (replacement = "Pango.Script.for_unichar", since = "vala-0.18")]
	public static Pango.Script script_for_unichar (unichar ch);
	[CCode (cheader_filename = "pango/pango.h")]
	[Deprecated (replacement = "Pango.Script.get_sample_language", since = "vala-0.18")]
	public static Pango.Language script_get_sample_language (Pango.Script script);
	[CCode (cheader_filename = "pango/pango.h")]
	public static void shape (string text, int length, Pango.Analysis analysis, Pango.GlyphString glyphs);
	[CCode (cheader_filename = "pango/pango.h")]
	public static void shape_full (string item_text, int item_length, string? paragraph_text, int paragraph_length, Pango.Analysis analysis, Pango.GlyphString glyphs);
	[CCode (cheader_filename = "pango/pango.h")]
	public static bool skip_space (ref string pos);
	[CCode (array_length = false, array_null_terminated = true, cheader_filename = "pango/pango.h")]
	public static string[] split_file_list (string str);
	[CCode (cheader_filename = "pango/pango.h")]
	public static string trim_string (string str);
	[CCode (cheader_filename = "pango/pango.h")]
	public static Pango.Direction unichar_direction (unichar ch);
	[CCode (cheader_filename = "pango/pango.h")]
	public static int units_from_double (double d);
	[CCode (cheader_filename = "pango/pango.h")]
	public static double units_to_double (int i);
	[CCode (cheader_filename = "pango/pango.h")]
	public static int version ();
	[CCode (cheader_filename = "pango/pango.h")]
	public static unowned string version_check (int required_major, int required_minor, int required_micro);
	[CCode (cheader_filename = "pango/pango.h")]
	public static unowned string version_string ();
}
