/* valaunresolvedtype.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter, Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#ifndef __VALA_VALAUNRESOLVEDTYPE_H__
#define __VALA_VALAUNRESOLVEDTYPE_H__

#include <glib.h>
#include <glib-object.h>
#include <vala/valadatatype.h>
#include <vala/valaunresolvedsymbol.h>
#include <vala/valasourcereference.h>
#include <vala/valaexpression.h>

G_BEGIN_DECLS


#define VALA_TYPE_UNRESOLVED_TYPE (vala_unresolved_type_get_type ())
#define VALA_UNRESOLVED_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_UNRESOLVED_TYPE, ValaUnresolvedType))
#define VALA_UNRESOLVED_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_UNRESOLVED_TYPE, ValaUnresolvedTypeClass))
#define VALA_IS_UNRESOLVED_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_UNRESOLVED_TYPE))
#define VALA_IS_UNRESOLVED_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_UNRESOLVED_TYPE))
#define VALA_UNRESOLVED_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_UNRESOLVED_TYPE, ValaUnresolvedTypeClass))

typedef struct _ValaUnresolvedType ValaUnresolvedType;
typedef struct _ValaUnresolvedTypeClass ValaUnresolvedTypeClass;
typedef struct _ValaUnresolvedTypePrivate ValaUnresolvedTypePrivate;

/**
 * An unresolved reference to a data type.
 */
struct _ValaUnresolvedType {
	ValaDataType parent_instance;
	ValaUnresolvedTypePrivate * priv;
};
struct _ValaUnresolvedTypeClass {
	ValaDataTypeClass parent_class;
};

ValaUnresolvedType* vala_unresolved_type_new (void);
ValaUnresolvedType* vala_unresolved_type_new_from_symbol (ValaUnresolvedSymbol* symbol, ValaSourceReference* source);
ValaUnresolvedType* vala_unresolved_type_new_from_expression (ValaExpression* expr);
ValaUnresolvedSymbol* vala_unresolved_type_get_unresolved_symbol (ValaUnresolvedType* self);
void vala_unresolved_type_set_unresolved_symbol (ValaUnresolvedType* self, ValaUnresolvedSymbol* value);
gint vala_unresolved_type_get_array_rank (ValaUnresolvedType* self);
void vala_unresolved_type_set_array_rank (ValaUnresolvedType* self, gint value);
gint vala_unresolved_type_get_pointer_level (ValaUnresolvedType* self);
void vala_unresolved_type_set_pointer_level (ValaUnresolvedType* self, gint value);
gboolean vala_unresolved_type_get_is_weak (ValaUnresolvedType* self);
void vala_unresolved_type_set_is_weak (ValaUnresolvedType* self, gboolean value);
GType vala_unresolved_type_get_type (void);


G_END_DECLS

#endif
