/* valalocalvariabledeclaration.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valalocalvariabledeclaration.h>
#include <gee/arraylist.h>
#include <gee/list.h>
#include <gee/readonlycollection.h>
#include <vala/valadatatype.h>
#include <vala/valavariabledeclarator.h>
#include <vala/valasourcereference.h>
#include <vala/valacodevisitor.h>




struct _ValaLocalVariableDeclarationPrivate {
	ValaDataType* _data_type;
	GeeList* variable_declarators;
};
#define VALA_LOCAL_VARIABLE_DECLARATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_LOCAL_VARIABLE_DECLARATION, ValaLocalVariableDeclarationPrivate))
enum  {
	VALA_LOCAL_VARIABLE_DECLARATION_DUMMY_PROPERTY,
	VALA_LOCAL_VARIABLE_DECLARATION_TYPE_REFERENCE
};
static void vala_local_variable_declaration_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_local_variable_declaration_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type);
static gpointer vala_local_variable_declaration_parent_class = NULL;
static void vala_local_variable_declaration_dispose (GObject * obj);



/**
 * Creates a new local variable declaration.
 *
 * @param type_reference   type of the variable
 * @param source_reference reference to source code
 * @return                 newly created local variable declaration
 */
ValaLocalVariableDeclaration* vala_local_variable_declaration_new (ValaDataType* type_reference, ValaSourceReference* source_reference) {
	ValaLocalVariableDeclaration * self;
	g_return_val_if_fail (type_reference == NULL || VALA_IS_DATA_TYPE (type_reference), NULL);
	g_return_val_if_fail (source_reference == NULL || VALA_IS_SOURCE_REFERENCE (source_reference), NULL);
	self = g_object_newv (VALA_TYPE_LOCAL_VARIABLE_DECLARATION, 0, NULL);
	vala_local_variable_declaration_set_type_reference (self, type_reference);
	vala_code_node_set_source_reference (VALA_CODE_NODE (self), source_reference);
	return self;
}


/**
 * Creates a new implicitly typed local variable declaration. The type
 * of the variable is inferred from the expression used to initialize
 * the variable.
 *
 * @param source_reference reference to source code
 * @return                 newly created local variable declaration
 */
ValaLocalVariableDeclaration* vala_local_variable_declaration_new_var_type (ValaSourceReference* source_reference) {
	ValaLocalVariableDeclaration * self;
	g_return_val_if_fail (source_reference == NULL || VALA_IS_SOURCE_REFERENCE (source_reference), NULL);
	self = g_object_newv (VALA_TYPE_LOCAL_VARIABLE_DECLARATION, 0, NULL);
	vala_code_node_set_source_reference (VALA_CODE_NODE (self), source_reference);
	return self;
}


/**
 * Add the specified variable declarator to this local variable
 * declaration.
 *
 * @param declarator a variable declarator
 */
void vala_local_variable_declaration_add_declarator (ValaLocalVariableDeclaration* self, ValaVariableDeclarator* declarator) {
	g_return_if_fail (VALA_IS_LOCAL_VARIABLE_DECLARATION (self));
	g_return_if_fail (declarator == NULL || VALA_IS_VARIABLE_DECLARATOR (declarator));
	gee_collection_add (GEE_COLLECTION (self->priv->variable_declarators), declarator);
}


/**
 * Returns a copy of the list of variable declarators.
 *
 * @return variable declarator list
 */
GeeCollection* vala_local_variable_declaration_get_variable_declarators (ValaLocalVariableDeclaration* self) {
	g_return_val_if_fail (VALA_IS_LOCAL_VARIABLE_DECLARATION (self), NULL);
	return GEE_COLLECTION (gee_read_only_collection_new (VALA_TYPE_VARIABLE_DECLARATOR, ((GBoxedCopyFunc) g_object_ref), g_object_unref, GEE_COLLECTION (self->priv->variable_declarators)));
}


static void vala_local_variable_declaration_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaLocalVariableDeclaration * self;
	self = VALA_LOCAL_VARIABLE_DECLARATION (base);
	g_return_if_fail (visitor == NULL || VALA_IS_CODE_VISITOR (visitor));
	if (vala_local_variable_declaration_get_type_reference (self) != NULL) {
		vala_code_node_accept (VALA_CODE_NODE (vala_local_variable_declaration_get_type_reference (self)), visitor);
	}
	{
		GeeList* decl_collection;
		GeeIterator* decl_it;
		decl_collection = self->priv->variable_declarators;
		decl_it = gee_iterable_iterator (GEE_ITERABLE (decl_collection));
		while (gee_iterator_next (decl_it)) {
			ValaVariableDeclarator* decl;
			decl = ((ValaVariableDeclarator*) gee_iterator_get (decl_it));
			{
				vala_code_node_accept (VALA_CODE_NODE (decl), visitor);
				(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
			}
		}
		(decl_it == NULL ? NULL : (decl_it = (g_object_unref (decl_it), NULL)));
	}
	vala_code_visitor_visit_local_variable_declaration (visitor, self);
}


static void vala_local_variable_declaration_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type) {
	ValaLocalVariableDeclaration * self;
	self = VALA_LOCAL_VARIABLE_DECLARATION (base);
	g_return_if_fail (old_type == NULL || VALA_IS_DATA_TYPE (old_type));
	g_return_if_fail (new_type == NULL || VALA_IS_DATA_TYPE (new_type));
	if (vala_local_variable_declaration_get_type_reference (self) == old_type) {
		vala_local_variable_declaration_set_type_reference (self, new_type);
	}
}


ValaDataType* vala_local_variable_declaration_get_type_reference (ValaLocalVariableDeclaration* self) {
	g_return_val_if_fail (VALA_IS_LOCAL_VARIABLE_DECLARATION (self), NULL);
	return self->priv->_data_type;
}


void vala_local_variable_declaration_set_type_reference (ValaLocalVariableDeclaration* self, ValaDataType* value) {
	ValaDataType* _tmp2;
	ValaDataType* _tmp1;
	g_return_if_fail (VALA_IS_LOCAL_VARIABLE_DECLARATION (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_data_type = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_data_type == NULL ? NULL : (self->priv->_data_type = (g_object_unref (self->priv->_data_type), NULL))), _tmp2);
	vala_code_node_set_parent_node (VALA_CODE_NODE (self->priv->_data_type), VALA_CODE_NODE (self));
}


static void vala_local_variable_declaration_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ValaLocalVariableDeclaration * self;
	self = VALA_LOCAL_VARIABLE_DECLARATION (object);
	switch (property_id) {
		case VALA_LOCAL_VARIABLE_DECLARATION_TYPE_REFERENCE:
		g_value_set_object (value, vala_local_variable_declaration_get_type_reference (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_local_variable_declaration_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ValaLocalVariableDeclaration * self;
	self = VALA_LOCAL_VARIABLE_DECLARATION (object);
	switch (property_id) {
		case VALA_LOCAL_VARIABLE_DECLARATION_TYPE_REFERENCE:
		vala_local_variable_declaration_set_type_reference (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_local_variable_declaration_class_init (ValaLocalVariableDeclarationClass * klass) {
	vala_local_variable_declaration_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaLocalVariableDeclarationPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_local_variable_declaration_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_local_variable_declaration_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_local_variable_declaration_dispose;
	VALA_CODE_NODE_CLASS (klass)->accept = vala_local_variable_declaration_real_accept;
	VALA_CODE_NODE_CLASS (klass)->replace_type = vala_local_variable_declaration_real_replace_type;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_LOCAL_VARIABLE_DECLARATION_TYPE_REFERENCE, g_param_spec_object ("type-reference", "type-reference", "type-reference", VALA_TYPE_DATA_TYPE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_local_variable_declaration_init (ValaLocalVariableDeclaration * self) {
	self->priv = VALA_LOCAL_VARIABLE_DECLARATION_GET_PRIVATE (self);
	self->priv->variable_declarators = GEE_LIST (gee_array_list_new (VALA_TYPE_VARIABLE_DECLARATOR, ((GBoxedCopyFunc) g_object_ref), g_object_unref, g_direct_equal));
}


static void vala_local_variable_declaration_dispose (GObject * obj) {
	ValaLocalVariableDeclaration * self;
	self = VALA_LOCAL_VARIABLE_DECLARATION (obj);
	(self->priv->_data_type == NULL ? NULL : (self->priv->_data_type = (g_object_unref (self->priv->_data_type), NULL)));
	(self->priv->variable_declarators == NULL ? NULL : (self->priv->variable_declarators = (g_object_unref (self->priv->variable_declarators), NULL)));
	G_OBJECT_CLASS (vala_local_variable_declaration_parent_class)->dispose (obj);
}


GType vala_local_variable_declaration_get_type (void) {
	static GType vala_local_variable_declaration_type_id = 0;
	if (G_UNLIKELY (vala_local_variable_declaration_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaLocalVariableDeclarationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_local_variable_declaration_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaLocalVariableDeclaration), 0, (GInstanceInitFunc) vala_local_variable_declaration_init };
		vala_local_variable_declaration_type_id = g_type_register_static (VALA_TYPE_CODE_NODE, "ValaLocalVariableDeclaration", &g_define_type_info, 0);
	}
	return vala_local_variable_declaration_type_id;
}




