/* valaccodeelementaccessbinding.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter, Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#ifndef __GOBJECT_VALACCODEELEMENTACCESSBINDING_H__
#define __GOBJECT_VALACCODEELEMENTACCESSBINDING_H__

#include <glib.h>
#include <glib-object.h>
#include <vala/valacodegenerator.h>
#include <vala/valaelementaccess.h>
#include <gobject/valaccodeexpressionbinding.h>

G_BEGIN_DECLS


#define VALA_TYPE_CCODE_ELEMENT_ACCESS_BINDING (vala_ccode_element_access_binding_get_type ())
#define VALA_CCODE_ELEMENT_ACCESS_BINDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_ELEMENT_ACCESS_BINDING, ValaCCodeElementAccessBinding))
#define VALA_CCODE_ELEMENT_ACCESS_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_ELEMENT_ACCESS_BINDING, ValaCCodeElementAccessBindingClass))
#define VALA_IS_CCODE_ELEMENT_ACCESS_BINDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_ELEMENT_ACCESS_BINDING))
#define VALA_IS_CCODE_ELEMENT_ACCESS_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_ELEMENT_ACCESS_BINDING))
#define VALA_CCODE_ELEMENT_ACCESS_BINDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_ELEMENT_ACCESS_BINDING, ValaCCodeElementAccessBindingClass))

typedef struct _ValaCCodeElementAccessBinding ValaCCodeElementAccessBinding;
typedef struct _ValaCCodeElementAccessBindingClass ValaCCodeElementAccessBindingClass;
typedef struct _ValaCCodeElementAccessBindingPrivate ValaCCodeElementAccessBindingPrivate;

/**
 * The link between an element access and generated code.
 */
struct _ValaCCodeElementAccessBinding {
	ValaCCodeExpressionBinding parent_instance;
	ValaCCodeElementAccessBindingPrivate * priv;
};
struct _ValaCCodeElementAccessBindingClass {
	ValaCCodeExpressionBindingClass parent_class;
};

ValaCCodeElementAccessBinding* vala_ccode_element_access_binding_new (ValaCodeGenerator* codegen, ValaElementAccess* element_access);
ValaElementAccess* vala_ccode_element_access_binding_get_element_access (ValaCCodeElementAccessBinding* self);
void vala_ccode_element_access_binding_set_element_access (ValaCCodeElementAccessBinding* self, ValaElementAccess* value);
GType vala_ccode_element_access_binding_get_type (void);


G_END_DECLS

#endif
