/* valaccodebinding.vala
 *
 * Copyright (C) 2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <gobject/valaccodebinding.h>




struct _ValaCCodeBindingPrivate {
	ValaCCodeGenerator* _codegen;
};
#define VALA_CCODE_BINDING_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_BINDING, ValaCCodeBindingPrivate))
enum  {
	VALA_CCODE_BINDING_DUMMY_PROPERTY,
	VALA_CCODE_BINDING_CODEGEN
};
static gpointer vala_ccode_binding_parent_class = NULL;
static void vala_ccode_binding_dispose (GObject * obj);



ValaCCodeGenerator* vala_ccode_binding_get_codegen (ValaCCodeBinding* self) {
	g_return_val_if_fail (VALA_IS_CCODE_BINDING (self), NULL);
	return self->priv->_codegen;
}


void vala_ccode_binding_set_codegen (ValaCCodeBinding* self, ValaCCodeGenerator* value) {
	ValaCCodeGenerator* _tmp2;
	ValaCCodeGenerator* _tmp1;
	g_return_if_fail (VALA_IS_CCODE_BINDING (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_codegen = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_codegen == NULL ? NULL : (self->priv->_codegen = (g_object_unref (self->priv->_codegen), NULL))), _tmp2);
}


static void vala_ccode_binding_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ValaCCodeBinding * self;
	self = VALA_CCODE_BINDING (object);
	switch (property_id) {
		case VALA_CCODE_BINDING_CODEGEN:
		g_value_set_object (value, vala_ccode_binding_get_codegen (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_ccode_binding_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ValaCCodeBinding * self;
	self = VALA_CCODE_BINDING (object);
	switch (property_id) {
		case VALA_CCODE_BINDING_CODEGEN:
		vala_ccode_binding_set_codegen (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_ccode_binding_class_init (ValaCCodeBindingClass * klass) {
	vala_ccode_binding_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaCCodeBindingPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_ccode_binding_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_ccode_binding_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_ccode_binding_dispose;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CCODE_BINDING_CODEGEN, g_param_spec_object ("codegen", "codegen", "codegen", VALA_TYPE_CCODE_GENERATOR, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_ccode_binding_init (ValaCCodeBinding * self) {
	self->priv = VALA_CCODE_BINDING_GET_PRIVATE (self);
}


static void vala_ccode_binding_dispose (GObject * obj) {
	ValaCCodeBinding * self;
	self = VALA_CCODE_BINDING (obj);
	(self->priv->_codegen == NULL ? NULL : (self->priv->_codegen = (g_object_unref (self->priv->_codegen), NULL)));
	G_OBJECT_CLASS (vala_ccode_binding_parent_class)->dispose (obj);
}


GType vala_ccode_binding_get_type (void) {
	static GType vala_ccode_binding_type_id = 0;
	if (G_UNLIKELY (vala_ccode_binding_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeBindingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_binding_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeBinding), 0, (GInstanceInitFunc) vala_ccode_binding_init };
		vala_ccode_binding_type_id = g_type_register_static (VALA_TYPE_CODE_BINDING, "ValaCCodeBinding", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	}
	return vala_ccode_binding_type_id;
}




