/* valacompiler.c generated by valac, the Vala compiler
 * generated from valacompiler.vala, do not modify */

/* valacompiler.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 1996-2002, 2004, 2005, 2006 Free Software Foundation, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <valacodegen.h>
#include <glib/gstdio.h>
#include <unistd.h>
#include <locale.h>
#include <config.h>
#include <version.h>
#include <gobject/gvaluecollector.h>


#define VALA_TYPE_COMPILER (vala_compiler_get_type ())
#define VALA_COMPILER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_COMPILER, ValaCompiler))
#define VALA_COMPILER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_COMPILER, ValaCompilerClass))
#define VALA_IS_COMPILER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_COMPILER))
#define VALA_IS_COMPILER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_COMPILER))
#define VALA_COMPILER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_COMPILER, ValaCompilerClass))

typedef struct _ValaCompiler ValaCompiler;
typedef struct _ValaCompilerClass ValaCompilerClass;
typedef struct _ValaCompilerPrivate ValaCompilerPrivate;
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_code_visitor_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_visitor_unref (var), NULL)))
#define _vala_ccode_compiler_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_compiler_unref (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_compiler_unref0(var) ((var == NULL) ? NULL : (var = (vala_compiler_unref (var), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
typedef struct _ValaParamSpecCompiler ValaParamSpecCompiler;

struct _ValaCompiler {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCompilerPrivate * priv;
};

struct _ValaCompilerClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCompiler *self);
};

struct _ValaCompilerPrivate {
	ValaCodeContext* context;
};

struct _Block1Data {
	int _ref_count_;
	GMainLoop* loop;
	gint child_status;
};

struct _ValaParamSpecCompiler {
	GParamSpec parent_instance;
};


static gpointer vala_compiler_parent_class = NULL;
static gchar* vala_compiler_basedir;
static gchar* vala_compiler_basedir = NULL;
static gchar* vala_compiler_directory;
static gchar* vala_compiler_directory = NULL;
static gboolean vala_compiler_version;
static gboolean vala_compiler_version = FALSE;
static gchar** vala_compiler_sources;
static gchar** vala_compiler_sources = NULL;
static gchar** vala_compiler_vapi_directories;
static gchar** vala_compiler_vapi_directories = NULL;
static gchar** vala_compiler_gir_directories;
static gchar** vala_compiler_gir_directories = NULL;
static gchar* vala_compiler_vapi_filename;
static gchar* vala_compiler_vapi_filename = NULL;
static gchar* vala_compiler_library;
static gchar* vala_compiler_library = NULL;
static gchar* vala_compiler_gir;
static gchar* vala_compiler_gir = NULL;
static gchar** vala_compiler_packages;
static gchar** vala_compiler_packages = NULL;
static gchar** vala_compiler_fast_vapis;
static gchar** vala_compiler_fast_vapis = NULL;
static gchar* vala_compiler_target_glib;
static gchar* vala_compiler_target_glib = NULL;
static gboolean vala_compiler_ccode_only;
static gboolean vala_compiler_ccode_only = FALSE;
static gchar* vala_compiler_header_filename;
static gchar* vala_compiler_header_filename = NULL;
static gboolean vala_compiler_use_header;
static gboolean vala_compiler_use_header = FALSE;
static gchar* vala_compiler_internal_header_filename;
static gchar* vala_compiler_internal_header_filename = NULL;
static gchar* vala_compiler_internal_vapi_filename;
static gchar* vala_compiler_internal_vapi_filename = NULL;
static gchar* vala_compiler_fast_vapi_filename;
static gchar* vala_compiler_fast_vapi_filename = NULL;
static gchar* vala_compiler_symbols_filename;
static gchar* vala_compiler_symbols_filename = NULL;
static gchar* vala_compiler_includedir;
static gchar* vala_compiler_includedir = NULL;
static gboolean vala_compiler_compile_only;
static gboolean vala_compiler_compile_only = FALSE;
static gchar* vala_compiler_output;
static gchar* vala_compiler_output = NULL;
static gboolean vala_compiler_debug;
static gboolean vala_compiler_debug = FALSE;
static gboolean vala_compiler_thread;
static gboolean vala_compiler_thread = FALSE;
static gboolean vala_compiler_mem_profiler;
static gboolean vala_compiler_mem_profiler = FALSE;
static gboolean vala_compiler_disable_assert;
static gboolean vala_compiler_disable_assert = FALSE;
static gboolean vala_compiler_enable_checking;
static gboolean vala_compiler_enable_checking = FALSE;
static gboolean vala_compiler_deprecated;
static gboolean vala_compiler_deprecated = FALSE;
static gboolean vala_compiler_experimental;
static gboolean vala_compiler_experimental = FALSE;
static gboolean vala_compiler_experimental_non_null;
static gboolean vala_compiler_experimental_non_null = FALSE;
static gboolean vala_compiler_disable_dbus_transformation;
static gboolean vala_compiler_disable_dbus_transformation = FALSE;
static gboolean vala_compiler_disable_warnings;
static gboolean vala_compiler_disable_warnings = FALSE;
static gchar* vala_compiler_cc_command;
static gchar* vala_compiler_cc_command = NULL;
static gchar** vala_compiler_cc_options;
static gchar** vala_compiler_cc_options = NULL;
static gchar* vala_compiler_dump_tree;
static gchar* vala_compiler_dump_tree = NULL;
static gboolean vala_compiler_save_temps;
static gboolean vala_compiler_save_temps = FALSE;
static gchar** vala_compiler_defines;
static gchar** vala_compiler_defines = NULL;
static gboolean vala_compiler_quiet_mode;
static gboolean vala_compiler_quiet_mode = FALSE;
static gboolean vala_compiler_verbose_mode;
static gboolean vala_compiler_verbose_mode = FALSE;
static gchar* vala_compiler_profile;
static gchar* vala_compiler_profile = NULL;
static gboolean vala_compiler_nostdpkg;
static gboolean vala_compiler_nostdpkg = FALSE;
static gboolean vala_compiler_enable_version_header;
static gboolean vala_compiler_enable_version_header = FALSE;
static gboolean vala_compiler_disable_version_header;
static gboolean vala_compiler_disable_version_header = FALSE;
static gboolean vala_compiler_fatal_warnings;
static gboolean vala_compiler_fatal_warnings = FALSE;
static gchar* vala_compiler_dependencies;
static gchar* vala_compiler_dependencies = NULL;
static gchar* vala_compiler_entry_point;
static gchar* vala_compiler_entry_point = NULL;
static gboolean vala_compiler_run_output;
static gboolean vala_compiler_run_output = FALSE;

gpointer vala_compiler_ref (gpointer instance);
void vala_compiler_unref (gpointer instance);
GParamSpec* vala_param_spec_compiler (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_compiler (GValue* value, gpointer v_object);
void vala_value_take_compiler (GValue* value, gpointer v_object);
gpointer vala_value_get_compiler (const GValue* value);
GType vala_compiler_get_type (void) G_GNUC_CONST;
#define VALA_COMPILER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_COMPILER, ValaCompilerPrivate))
enum  {
	VALA_COMPILER_DUMMY_PROPERTY
};
static gint vala_compiler_quit (ValaCompiler* self);
static gint vala_compiler_run (ValaCompiler* self);
static gchar** _vala_array_dup1 (gchar** self, int length);
static gchar** _vala_array_dup2 (gchar** self, int length);
static gint vala_compiler_run_source (gchar** args, int args_length1);
ValaCompiler* vala_compiler_new (void);
ValaCompiler* vala_compiler_construct (GType object_type);
static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
static void _lambda0_ (GPid pid, gint status, Block1Data* _data1_);
static void __lambda0__gchild_watch_func (GPid pid, gint status, gpointer self);
static gint vala_compiler_main (gchar** args, int args_length1);
static void vala_compiler_finalize (ValaCompiler* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GOptionEntry VALA_COMPILER_options[47] = {{"girdir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_gir_directories, "Look for .gir files in DIRECTORY", "DIRECTORY..."}, {"vapidir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_vapi_directories, "Look for package bindings in DIRECTORY", "DIRECTORY..."}, {"pkg", (gchar) 0, 0, G_OPTION_ARG_STRING_ARRAY, &vala_compiler_packages, "Include binding for PACKAGE", "PACKAGE..."}, {"vapi", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_vapi_filename, "Output VAPI file name", "FILE"}, {"library", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_library, "Library name", "NAME"}, {"gir", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_gir, "GObject-Introspection repository file name", "NAME-VERSION.gir"}, {"basedir", 'b', 0, G_OPTION_ARG_FILENAME, &vala_compiler_basedir, "Base source directory", "DIRECTORY"}, {"directory", 'd', 0, G_OPTION_ARG_FILENAME, &vala_compiler_directory, "Output directory", "DIRECTORY"}, {"version", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_version, "Display version number", NULL}, {"ccode", 'C', 0, G_OPTION_ARG_NONE, &vala_compiler_ccode_only, "Output C code", NULL}, {"header", 'H', 0, G_OPTION_ARG_FILENAME, &vala_compiler_header_filename, "Output C header file", "FILE"}, {"use-header", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_use_header, "Use C header file", NULL}, {"includedir", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_includedir, "Directory used to include the C header file", "DIRECTORY"}, {"internal-header", 'h', 0, G_OPTION_ARG_FILENAME, &vala_compiler_internal_header_filename, "Output internal C header file", "FILE"}, {"internal-vapi", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_internal_vapi_filename, "Output vapi with internal api", "FILE"}, {"fast-vapi", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_fast_vapi_filename, "Output vapi without performing symbol resolution", NULL}, {"use-fast-vapi", (gchar) 0, 0, G_OPTION_ARG_STRING_ARRAY, &vala_compiler_fast_vapis, "Use --fast-vapi output during this compile", NULL}, {"deps", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_dependencies, "Write make-style dependency information to this file", NULL}, {"symbols", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_symbols_filename, "Output symbols file", "FILE"}, {"compile", 'c', 0, G_OPTION_ARG_NONE, &vala_compiler_compile_only, "Compile but do not link", NULL}, {"output", 'o', 0, G_OPTION_ARG_FILENAME, &vala_compiler_output, "Place output in file FILE", "FILE"}, {"debug", 'g', 0, G_OPTION_ARG_NONE, &vala_compiler_debug, "Produce debug information", NULL}, {"thread", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_thread, "Enable multithreading support", NULL}, {"enable-mem-profiler", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_mem_profiler, "Enable GLib memory profiler", NULL}, {"define", 'D', 0, G_OPTION_ARG_STRING_ARRAY, &vala_compiler_defines, "Define SYMBOL", "SYMBOL..."}, {"main", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_entry_point, "Use SYMBOL as entry point", "SYMBOL..."}, {"nostdpkg", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_nostdpkg, "Do not include standard packages", NULL}, {"disable-assert", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_disable_assert, "Disable assertions", NULL}, {"enable-checking", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_enable_checking, "Enable additional run-time checks", NULL}, {"enable-deprecated", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_deprecated, "Enable deprecated features", NULL}, {"enable-experimental", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_experimental, "Enable experimental features", NULL}, {"disable-warnings", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_disable_warnings, "Disable warnings", NULL}, {"fatal-warnings", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_fatal_warnings, "Treat warnings as fatal", NULL}, {"enable-experimental-non-null", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_experimental_non_null, "Enable experimental enhancements for non-null types", NULL}, {"disable-dbus-transformation", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_disable_dbus_transformation, "Disable transformation of D-Bus member names", NULL}, {"cc", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_cc_command, "Use COMMAND as C compiler command", "COMMAND"}, {"Xcc", 'X', 0, G_OPTION_ARG_STRING_ARRAY, &vala_compiler_cc_options, "Pass OPTION to the C compiler", "OPTION..."}, {"dump-tree", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_dump_tree, "Write code tree to FILE", "FILE"}, {"save-temps", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_save_temps, "Keep temporary files", NULL}, {"profile", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_profile, "Use the given profile instead of the default", "PROFILE"}, {"quiet", 'q', 0, G_OPTION_ARG_NONE, &vala_compiler_quiet_mode, "Do not print messages to the console", NULL}, {"verbose", 'v', 0, G_OPTION_ARG_NONE, &vala_compiler_verbose_mode, "Print additional messages to the console", NULL}, {"target-glib", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_target_glib, "Target version of glib for code generation", "MAJOR.MINOR"}, {"enable-version-header", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_enable_version_header, "Write vala build version in generated files", NULL}, {"disable-version-header", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_disable_version_header, "Do not write vala build version in generated files", NULL}, {"", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_sources, NULL, "FILE..."}, {NULL}};

static gint vala_compiler_quit (ValaCompiler* self) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	ValaReport* _tmp1_ = NULL;
	gint _tmp2_;
	gboolean _tmp5_ = FALSE;
	ValaReport* _tmp6_ = NULL;
	gint _tmp7_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp1_ = vala_code_context_get_report (self->priv->context);
	_tmp2_ = vala_report_get_errors (_tmp1_);
	if (_tmp2_ == 0) {
		ValaReport* _tmp3_ = NULL;
		gint _tmp4_;
		_tmp3_ = vala_code_context_get_report (self->priv->context);
		_tmp4_ = vala_report_get_warnings (_tmp3_);
		_tmp0_ = _tmp4_ == 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = 0;
		return result;
	}
	_tmp6_ = vala_code_context_get_report (self->priv->context);
	_tmp7_ = vala_report_get_errors (_tmp6_);
	if (_tmp7_ == 0) {
		gboolean _tmp8_ = FALSE;
		if (!vala_compiler_fatal_warnings) {
			_tmp8_ = TRUE;
		} else {
			ValaReport* _tmp9_ = NULL;
			gint _tmp10_;
			_tmp9_ = vala_code_context_get_report (self->priv->context);
			_tmp10_ = vala_report_get_warnings (_tmp9_);
			_tmp8_ = _tmp10_ == 0;
		}
		_tmp5_ = _tmp8_;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		if (!vala_compiler_quiet_mode) {
			ValaReport* _tmp11_ = NULL;
			gint _tmp12_;
			_tmp11_ = vala_code_context_get_report (self->priv->context);
			_tmp12_ = vala_report_get_warnings (_tmp11_);
			fprintf (stdout, "Compilation succeeded - %d warning(s)\n", _tmp12_);
		}
		result = 0;
		return result;
	} else {
		if (!vala_compiler_quiet_mode) {
			ValaReport* _tmp13_ = NULL;
			gint _tmp14_;
			ValaReport* _tmp15_ = NULL;
			gint _tmp16_;
			_tmp13_ = vala_code_context_get_report (self->priv->context);
			_tmp14_ = vala_report_get_errors (_tmp13_);
			_tmp15_ = vala_code_context_get_report (self->priv->context);
			_tmp16_ = vala_report_get_warnings (_tmp15_);
			fprintf (stdout, "Compilation failed: %d error(s), %d warning(s)\n", _tmp14_, _tmp16_);
		}
		result = 1;
		return result;
	}
}


static glong string_pointer_to_offset (const gchar* self, const gchar* pos) {
	glong result = 0L;
	g_return_val_if_fail (self != NULL, 0L);
	g_return_val_if_fail (pos != NULL, 0L);
	result = (glong) (((gchar*) pos) - ((gchar*) self));
	return result;
}


static const gchar* string_offset (const gchar* self, glong offset) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = (const gchar*) (((gchar*) self) + offset);
	return result;
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong _tmp0_;
	glong string_length;
	const gchar* _tmp1_ = NULL;
	const gchar* start;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	string_length = _tmp0_;
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp1_ = string_offset (self, offset);
	start = _tmp1_;
	_tmp2_ = string_offset (start, len);
	_tmp3_ = g_strndup (start, ((gchar*) _tmp2_) - ((gchar*) start));
	result = _tmp3_;
	return result;
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


static gchar** _vala_array_dup2 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	result = ((gchar*) self)[index];
	return result;
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr (self, needle);
	result = _tmp0_ != NULL;
	return result;
}


static gint vala_compiler_run (ValaCompiler* self) {
	gint result = 0;
	ValaCodeContext* _tmp0_ = NULL;
	ValaCodeContext* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	ValaReport* _tmp11_ = NULL;
	ValaReport* _tmp12_ = NULL;
	gboolean _tmp13_ = FALSE;
	gchar** _tmp21_;
	gchar** _tmp22_;
	gchar** _tmp23_;
	gchar** _tmp24_;
	gchar** _tmp25_;
	gchar** _tmp26_;
	ValaProfile _tmp35_;
	gboolean _tmp51_ = FALSE;
	ValaReport* _tmp52_ = NULL;
	gint _tmp53_;
	ValaProfile _tmp58_;
	gboolean has_c_files;
	gchar** _tmp73_;
	gboolean _tmp74_ = FALSE;
	ValaReport* _tmp75_ = NULL;
	gint _tmp76_;
	ValaParser* _tmp81_ = NULL;
	ValaParser* parser;
	ValaGenieParser* _tmp82_ = NULL;
	ValaGenieParser* genie_parser;
	ValaGirParser* _tmp83_ = NULL;
	ValaGirParser* gir_parser;
	gboolean _tmp84_ = FALSE;
	ValaReport* _tmp85_ = NULL;
	gint _tmp86_;
	gboolean _tmp93_ = FALSE;
	ValaReport* _tmp94_ = NULL;
	gint _tmp95_;
	gboolean _tmp100_ = FALSE;
	gboolean _tmp101_ = FALSE;
	gboolean _tmp105_ = FALSE;
	ValaReport* _tmp106_ = NULL;
	gint _tmp107_;
	ValaCodeGenerator* _tmp112_ = NULL;
	gboolean _tmp113_ = FALSE;
	ValaReport* _tmp114_ = NULL;
	gint _tmp115_;
	gboolean _tmp120_ = FALSE;
	gint _tmp172_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = vala_code_context_new ();
	_tmp1_ = _tmp0_;
	_vala_code_context_unref0 (self->priv->context);
	self->priv->context = _tmp1_;
	vala_code_context_push (self->priv->context);
	if (!vala_compiler_ccode_only) {
		_tmp3_ = !vala_compiler_compile_only;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		_tmp2_ = vala_compiler_output == NULL;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		const gchar* _tmp4_ = NULL;
		_tmp4_ = g_utf8_strrchr (vala_compiler_sources[0], (gssize) (-1), (gunichar) '.');
		if (_tmp4_ != NULL) {
			const gchar* _tmp5_ = NULL;
			glong _tmp6_;
			glong dot;
			gchar* _tmp7_ = NULL;
			gchar* _tmp8_;
			gchar* _tmp9_ = NULL;
			gchar* _tmp10_;
			_tmp5_ = g_utf8_strrchr (vala_compiler_sources[0], (gssize) (-1), (gunichar) '.');
			_tmp6_ = string_pointer_to_offset (vala_compiler_sources[0], _tmp5_);
			dot = _tmp6_;
			_tmp7_ = string_substring (vala_compiler_sources[0], (glong) 0, dot);
			_tmp8_ = _tmp7_;
			_tmp9_ = g_path_get_basename (_tmp8_);
			_tmp10_ = _tmp9_;
			_g_free0 (vala_compiler_output);
			vala_compiler_output = _tmp10_;
			_g_free0 (_tmp8_);
		}
	}
	vala_code_context_set_assert (self->priv->context, !vala_compiler_disable_assert);
	vala_code_context_set_checking (self->priv->context, vala_compiler_enable_checking);
	vala_code_context_set_deprecated (self->priv->context, vala_compiler_deprecated);
	vala_code_context_set_experimental (self->priv->context, vala_compiler_experimental);
	vala_code_context_set_experimental_non_null (self->priv->context, vala_compiler_experimental_non_null);
	vala_code_context_set_dbus_transformation (self->priv->context, !vala_compiler_disable_dbus_transformation);
	_tmp11_ = vala_code_context_get_report (self->priv->context);
	vala_report_set_enable_warnings (_tmp11_, !vala_compiler_disable_warnings);
	_tmp12_ = vala_code_context_get_report (self->priv->context);
	vala_report_set_verbose_errors (_tmp12_, !vala_compiler_quiet_mode);
	vala_code_context_set_verbose_mode (self->priv->context, vala_compiler_verbose_mode);
	vala_code_context_set_version_header (self->priv->context, !vala_compiler_disable_version_header);
	vala_code_context_set_ccode_only (self->priv->context, vala_compiler_ccode_only);
	vala_code_context_set_compile_only (self->priv->context, vala_compiler_compile_only);
	vala_code_context_set_header_filename (self->priv->context, vala_compiler_header_filename);
	if (vala_compiler_header_filename == NULL) {
		_tmp13_ = vala_compiler_use_header;
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		vala_report_error (NULL, "--use-header may only be used in combination with --header");
	}
	vala_code_context_set_use_header (self->priv->context, vala_compiler_use_header);
	vala_code_context_set_internal_header_filename (self->priv->context, vala_compiler_internal_header_filename);
	vala_code_context_set_symbols_filename (self->priv->context, vala_compiler_symbols_filename);
	vala_code_context_set_includedir (self->priv->context, vala_compiler_includedir);
	vala_code_context_set_output (self->priv->context, vala_compiler_output);
	if (vala_compiler_basedir == NULL) {
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_;
		_tmp14_ = vala_code_context_realpath (".");
		_tmp15_ = _tmp14_;
		vala_code_context_set_basedir (self->priv->context, _tmp15_);
		_g_free0 (_tmp15_);
	} else {
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_;
		_tmp16_ = vala_code_context_realpath (vala_compiler_basedir);
		_tmp17_ = _tmp16_;
		vala_code_context_set_basedir (self->priv->context, _tmp17_);
		_g_free0 (_tmp17_);
	}
	if (vala_compiler_directory != NULL) {
		gchar* _tmp18_ = NULL;
		gchar* _tmp19_;
		_tmp18_ = vala_code_context_realpath (vala_compiler_directory);
		_tmp19_ = _tmp18_;
		vala_code_context_set_directory (self->priv->context, _tmp19_);
		_g_free0 (_tmp19_);
	} else {
		const gchar* _tmp20_ = NULL;
		_tmp20_ = vala_code_context_get_basedir (self->priv->context);
		vala_code_context_set_directory (self->priv->context, _tmp20_);
	}
	_tmp21_ = (_tmp22_ = vala_compiler_vapi_directories, (_tmp22_ == NULL) ? ((gpointer) _tmp22_) : _vala_array_dup1 (_tmp22_, _vala_array_length (vala_compiler_vapi_directories)));
	_tmp23_ = _tmp21_;
	self->priv->context->vapi_directories = (_vala_array_free (self->priv->context->vapi_directories, self->priv->context->vapi_directories_length1, (GDestroyNotify) g_free), NULL);
	self->priv->context->vapi_directories_length1 = _vala_array_length (vala_compiler_vapi_directories);
	self->priv->context->vapi_directories = _tmp23_;
	_tmp24_ = (_tmp25_ = vala_compiler_gir_directories, (_tmp25_ == NULL) ? ((gpointer) _tmp25_) : _vala_array_dup2 (_tmp25_, _vala_array_length (vala_compiler_gir_directories)));
	_tmp26_ = _tmp24_;
	self->priv->context->gir_directories = (_vala_array_free (self->priv->context->gir_directories, self->priv->context->gir_directories_length1, (GDestroyNotify) g_free), NULL);
	self->priv->context->gir_directories_length1 = _vala_array_length (vala_compiler_gir_directories);
	self->priv->context->gir_directories = _tmp26_;
	vala_code_context_set_debug (self->priv->context, vala_compiler_debug);
	vala_code_context_set_thread (self->priv->context, vala_compiler_thread);
	vala_code_context_set_mem_profiler (self->priv->context, vala_compiler_mem_profiler);
	vala_code_context_set_save_temps (self->priv->context, vala_compiler_save_temps);
	if (g_strcmp0 (vala_compiler_profile, "posix") == 0) {
		vala_code_context_set_profile (self->priv->context, VALA_PROFILE_POSIX);
		vala_code_context_add_define (self->priv->context, "POSIX");
	} else {
		gboolean _tmp27_ = FALSE;
		gboolean _tmp28_ = FALSE;
		if (g_strcmp0 (vala_compiler_profile, "gobject-2.0") == 0) {
			_tmp28_ = TRUE;
		} else {
			_tmp28_ = g_strcmp0 (vala_compiler_profile, "gobject") == 0;
		}
		if (_tmp28_) {
			_tmp27_ = TRUE;
		} else {
			_tmp27_ = vala_compiler_profile == NULL;
		}
		if (_tmp27_) {
			vala_code_context_set_profile (self->priv->context, VALA_PROFILE_GOBJECT);
			vala_code_context_add_define (self->priv->context, "GOBJECT");
		} else {
			if (g_strcmp0 (vala_compiler_profile, "dova") == 0) {
				vala_code_context_set_profile (self->priv->context, VALA_PROFILE_DOVA);
				vala_code_context_add_define (self->priv->context, "DOVA");
			} else {
				gchar* _tmp29_ = NULL;
				gchar* _tmp30_;
				_tmp29_ = g_strdup_printf ("Unknown profile %s", vala_compiler_profile);
				_tmp30_ = _tmp29_;
				vala_report_error (NULL, _tmp30_);
				_g_free0 (_tmp30_);
			}
		}
	}
	vala_compiler_nostdpkg = vala_compiler_nostdpkg | (vala_compiler_fast_vapi_filename != NULL);
	vala_code_context_set_nostdpkg (self->priv->context, vala_compiler_nostdpkg);
	vala_code_context_set_entry_point_name (self->priv->context, vala_compiler_entry_point);
	vala_code_context_set_run_output (self->priv->context, vala_compiler_run_output);
	if (vala_compiler_defines != NULL) {
		{
			gchar** define_collection;
			int define_collection_length1;
			int define_it;
			define_collection = vala_compiler_defines;
			define_collection_length1 = _vala_array_length (vala_compiler_defines);
			for (define_it = 0; define_it < _vala_array_length (vala_compiler_defines); define_it = define_it + 1) {
				gchar* _tmp31_;
				gchar* define;
				_tmp31_ = g_strdup (define_collection[define_it]);
				define = _tmp31_;
				{
					vala_code_context_add_define (self->priv->context, define);
					_g_free0 (define);
				}
			}
		}
	}
	{
		gint i;
		i = 2;
		{
			gboolean _tmp32_;
			_tmp32_ = TRUE;
			while (TRUE) {
				gchar* _tmp33_ = NULL;
				gchar* _tmp34_;
				if (!_tmp32_) {
					i = i + 2;
				}
				_tmp32_ = FALSE;
				if (!(i <= 12)) {
					break;
				}
				_tmp33_ = g_strdup_printf ("VALA_0_%d", i);
				_tmp34_ = _tmp33_;
				vala_code_context_add_define (self->priv->context, _tmp34_);
				_g_free0 (_tmp34_);
			}
		}
	}
	_tmp35_ = vala_code_context_get_profile (self->priv->context);
	if (_tmp35_ == VALA_PROFILE_POSIX) {
		if (!vala_compiler_nostdpkg) {
			vala_code_context_add_external_package (self->priv->context, "posix");
		}
	} else {
		ValaProfile _tmp36_;
		_tmp36_ = vala_code_context_get_profile (self->priv->context);
		if (_tmp36_ == VALA_PROFILE_GOBJECT) {
			gint glib_major;
			gint glib_minor;
			gboolean _tmp37_ = FALSE;
			gint _tmp39_;
			glib_major = 2;
			glib_minor = 16;
			if (vala_compiler_target_glib != NULL) {
				gint _tmp38_;
				_tmp38_ = sscanf (vala_compiler_target_glib, "%d.%d", &glib_major, &glib_minor);
				_tmp37_ = _tmp38_ != 2;
			} else {
				_tmp37_ = FALSE;
			}
			if (_tmp37_) {
				vala_report_error (NULL, "Invalid format for --target-glib");
			}
			vala_code_context_set_target_glib_major (self->priv->context, glib_major);
			vala_code_context_set_target_glib_minor (self->priv->context, glib_minor);
			_tmp39_ = vala_code_context_get_target_glib_major (self->priv->context);
			if (_tmp39_ != 2) {
				vala_report_error (NULL, "This version of valac only supports GLib 2");
			}
			{
				gint i;
				i = 16;
				{
					gboolean _tmp40_;
					_tmp40_ = TRUE;
					while (TRUE) {
						gchar* _tmp41_ = NULL;
						gchar* _tmp42_;
						if (!_tmp40_) {
							i = i + 2;
						}
						_tmp40_ = FALSE;
						if (!(i <= glib_minor)) {
							break;
						}
						_tmp41_ = g_strdup_printf ("GLIB_2_%d", i);
						_tmp42_ = _tmp41_;
						vala_code_context_add_define (self->priv->context, _tmp42_);
						_g_free0 (_tmp42_);
					}
				}
			}
			if (!vala_compiler_nostdpkg) {
				vala_code_context_add_external_package (self->priv->context, "glib-2.0");
				vala_code_context_add_external_package (self->priv->context, "gobject-2.0");
			}
		} else {
			ValaProfile _tmp43_;
			_tmp43_ = vala_code_context_get_profile (self->priv->context);
			if (_tmp43_ == VALA_PROFILE_DOVA) {
				if (!vala_compiler_nostdpkg) {
					vala_code_context_add_external_package (self->priv->context, "dova-core-0.1");
				}
			}
		}
	}
	if (vala_compiler_packages != NULL) {
		gchar** _tmp47_;
		{
			gchar** package_collection;
			int package_collection_length1;
			int package_it;
			package_collection = vala_compiler_packages;
			package_collection_length1 = _vala_array_length (vala_compiler_packages);
			for (package_it = 0; package_it < _vala_array_length (vala_compiler_packages); package_it = package_it + 1) {
				gchar* _tmp44_;
				gchar* package;
				_tmp44_ = g_strdup (package_collection[package_it]);
				package = _tmp44_;
				{
					gboolean _tmp45_ = FALSE;
					ValaProfile _tmp46_;
					vala_code_context_add_external_package (self->priv->context, package);
					_tmp46_ = vala_code_context_get_profile (self->priv->context);
					if (_tmp46_ == VALA_PROFILE_GOBJECT) {
						_tmp45_ = g_strcmp0 (package, "dbus-glib-1") == 0;
					} else {
						_tmp45_ = FALSE;
					}
					if (_tmp45_) {
						vala_code_context_add_define (self->priv->context, "DBUS_GLIB");
					}
					_g_free0 (package);
				}
			}
		}
		_tmp47_ = NULL;
		vala_compiler_packages = (_vala_array_free (vala_compiler_packages, _vala_array_length (vala_compiler_packages), (GDestroyNotify) g_free), NULL);
		vala_compiler_packages = _tmp47_;
	}
	if (vala_compiler_fast_vapis != NULL) {
		{
			gchar** vapi_collection;
			int vapi_collection_length1;
			int vapi_it;
			vapi_collection = vala_compiler_fast_vapis;
			vapi_collection_length1 = _vala_array_length (vala_compiler_fast_vapis);
			for (vapi_it = 0; vapi_it < _vala_array_length (vala_compiler_fast_vapis); vapi_it = vapi_it + 1) {
				gchar* _tmp48_;
				gchar* vapi;
				_tmp48_ = g_strdup (vapi_collection[vapi_it]);
				vapi = _tmp48_;
				{
					gchar* _tmp49_ = NULL;
					gchar* rpath;
					ValaSourceFile* _tmp50_ = NULL;
					ValaSourceFile* source_file;
					_tmp49_ = vala_code_context_realpath (vapi);
					rpath = _tmp49_;
					_tmp50_ = vala_source_file_new (self->priv->context, VALA_SOURCE_FILE_TYPE_FAST, rpath, NULL);
					source_file = _tmp50_;
					vala_code_context_add_source_file (self->priv->context, source_file);
					_vala_source_file_unref0 (source_file);
					_g_free0 (rpath);
					_g_free0 (vapi);
				}
			}
		}
	}
	_tmp52_ = vala_code_context_get_report (self->priv->context);
	_tmp53_ = vala_report_get_errors (_tmp52_);
	if (_tmp53_ > 0) {
		_tmp51_ = TRUE;
	} else {
		gboolean _tmp54_ = FALSE;
		if (vala_compiler_fatal_warnings) {
			ValaReport* _tmp55_ = NULL;
			gint _tmp56_;
			_tmp55_ = vala_code_context_get_report (self->priv->context);
			_tmp56_ = vala_report_get_warnings (_tmp55_);
			_tmp54_ = _tmp56_ > 0;
		} else {
			_tmp54_ = FALSE;
		}
		_tmp51_ = _tmp54_;
	}
	if (_tmp51_) {
		gint _tmp57_;
		_tmp57_ = vala_compiler_quit (self);
		result = _tmp57_;
		return result;
	}
	_tmp58_ = vala_code_context_get_profile (self->priv->context);
	if (_tmp58_ == VALA_PROFILE_GOBJECT) {
		gboolean _tmp59_;
		_tmp59_ = vala_code_context_has_package (self->priv->context, "dbus-glib-1");
		if (_tmp59_) {
			gboolean _tmp60_;
			ValaDBusServerModule* _tmp61_ = NULL;
			ValaDBusServerModule* _tmp62_;
			_tmp60_ = vala_code_context_get_deprecated (self->priv->context);
			if (!_tmp60_) {
				vala_report_warning (NULL, "D-Bus GLib is deprecated, use GDBus");
			}
			_tmp61_ = vala_dbus_server_module_new ();
			_tmp62_ = _tmp61_;
			vala_code_context_set_codegen (self->priv->context, (ValaCodeGenerator*) _tmp62_);
			_vala_code_visitor_unref0 (_tmp62_);
		} else {
			ValaGDBusServerModule* _tmp63_ = NULL;
			ValaGDBusServerModule* _tmp64_;
			_tmp63_ = vala_gd_bus_server_module_new ();
			_tmp64_ = _tmp63_;
			vala_code_context_set_codegen (self->priv->context, (ValaCodeGenerator*) _tmp64_);
			_vala_code_visitor_unref0 (_tmp64_);
		}
	} else {
		ValaProfile _tmp65_;
		_tmp65_ = vala_code_context_get_profile (self->priv->context);
		if (_tmp65_ == VALA_PROFILE_DOVA) {
			ValaDovaErrorModule* _tmp66_ = NULL;
			ValaDovaErrorModule* _tmp67_;
			_tmp66_ = vala_dova_error_module_new ();
			_tmp67_ = _tmp66_;
			vala_code_context_set_codegen (self->priv->context, (ValaCodeGenerator*) _tmp67_);
			_vala_code_visitor_unref0 (_tmp67_);
		} else {
			ValaCCodeDelegateModule* _tmp68_ = NULL;
			ValaCCodeDelegateModule* _tmp69_;
			_tmp68_ = vala_ccode_delegate_module_new ();
			_tmp69_ = _tmp68_;
			vala_code_context_set_codegen (self->priv->context, (ValaCodeGenerator*) _tmp69_);
			_vala_code_visitor_unref0 (_tmp69_);
		}
	}
	has_c_files = FALSE;
	{
		gchar** source_collection;
		int source_collection_length1;
		int source_it;
		source_collection = vala_compiler_sources;
		source_collection_length1 = _vala_array_length (vala_compiler_sources);
		for (source_it = 0; source_it < _vala_array_length (vala_compiler_sources); source_it = source_it + 1) {
			gchar* _tmp70_;
			gchar* source;
			_tmp70_ = g_strdup (source_collection[source_it]);
			source = _tmp70_;
			{
				gboolean _tmp71_;
				_tmp71_ = vala_code_context_add_source_filename (self->priv->context, source, vala_compiler_run_output);
				if (_tmp71_) {
					gboolean _tmp72_;
					_tmp72_ = g_str_has_suffix (source, ".c");
					if (_tmp72_) {
						has_c_files = TRUE;
					}
				}
				_g_free0 (source);
			}
		}
	}
	_tmp73_ = NULL;
	vala_compiler_sources = (_vala_array_free (vala_compiler_sources, _vala_array_length (vala_compiler_sources), (GDestroyNotify) g_free), NULL);
	vala_compiler_sources = _tmp73_;
	_tmp75_ = vala_code_context_get_report (self->priv->context);
	_tmp76_ = vala_report_get_errors (_tmp75_);
	if (_tmp76_ > 0) {
		_tmp74_ = TRUE;
	} else {
		gboolean _tmp77_ = FALSE;
		if (vala_compiler_fatal_warnings) {
			ValaReport* _tmp78_ = NULL;
			gint _tmp79_;
			_tmp78_ = vala_code_context_get_report (self->priv->context);
			_tmp79_ = vala_report_get_warnings (_tmp78_);
			_tmp77_ = _tmp79_ > 0;
		} else {
			_tmp77_ = FALSE;
		}
		_tmp74_ = _tmp77_;
	}
	if (_tmp74_) {
		gint _tmp80_;
		_tmp80_ = vala_compiler_quit (self);
		result = _tmp80_;
		return result;
	}
	_tmp81_ = vala_parser_new ();
	parser = _tmp81_;
	vala_parser_parse (parser, self->priv->context);
	_tmp82_ = vala_genie_parser_new ();
	genie_parser = _tmp82_;
	vala_genie_parser_parse (genie_parser, self->priv->context);
	_tmp83_ = vala_gir_parser_new ();
	gir_parser = _tmp83_;
	vala_gir_parser_parse (gir_parser, self->priv->context);
	_tmp85_ = vala_code_context_get_report (self->priv->context);
	_tmp86_ = vala_report_get_errors (_tmp85_);
	if (_tmp86_ > 0) {
		_tmp84_ = TRUE;
	} else {
		gboolean _tmp87_ = FALSE;
		if (vala_compiler_fatal_warnings) {
			ValaReport* _tmp88_ = NULL;
			gint _tmp89_;
			_tmp88_ = vala_code_context_get_report (self->priv->context);
			_tmp89_ = vala_report_get_warnings (_tmp88_);
			_tmp87_ = _tmp89_ > 0;
		} else {
			_tmp87_ = FALSE;
		}
		_tmp84_ = _tmp87_;
	}
	if (_tmp84_) {
		gint _tmp90_;
		_tmp90_ = vala_compiler_quit (self);
		result = _tmp90_;
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	if (vala_compiler_fast_vapi_filename != NULL) {
		ValaCodeWriter* _tmp91_ = NULL;
		ValaCodeWriter* interface_writer;
		gint _tmp92_;
		_tmp91_ = vala_code_writer_new (VALA_CODE_WRITER_TYPE_FAST);
		interface_writer = _tmp91_;
		vala_code_writer_write_file (interface_writer, self->priv->context, vala_compiler_fast_vapi_filename);
		_tmp92_ = vala_compiler_quit (self);
		result = _tmp92_;
		_vala_code_visitor_unref0 (interface_writer);
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	vala_code_context_check (self->priv->context);
	_tmp94_ = vala_code_context_get_report (self->priv->context);
	_tmp95_ = vala_report_get_errors (_tmp94_);
	if (_tmp95_ > 0) {
		_tmp93_ = TRUE;
	} else {
		gboolean _tmp96_ = FALSE;
		if (vala_compiler_fatal_warnings) {
			ValaReport* _tmp97_ = NULL;
			gint _tmp98_;
			_tmp97_ = vala_code_context_get_report (self->priv->context);
			_tmp98_ = vala_report_get_warnings (_tmp97_);
			_tmp96_ = _tmp98_ > 0;
		} else {
			_tmp96_ = FALSE;
		}
		_tmp93_ = _tmp96_;
	}
	if (_tmp93_) {
		gint _tmp99_;
		_tmp99_ = vala_compiler_quit (self);
		result = _tmp99_;
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	if (!vala_compiler_ccode_only) {
		_tmp101_ = !vala_compiler_compile_only;
	} else {
		_tmp101_ = FALSE;
	}
	if (_tmp101_) {
		_tmp100_ = vala_compiler_library == NULL;
	} else {
		_tmp100_ = FALSE;
	}
	if (_tmp100_) {
		gboolean _tmp102_ = FALSE;
		if (!has_c_files) {
			ValaMethod* _tmp103_ = NULL;
			_tmp103_ = vala_code_context_get_entry_point (self->priv->context);
			_tmp102_ = _tmp103_ == NULL;
		} else {
			_tmp102_ = FALSE;
		}
		if (_tmp102_) {
			vala_report_error (NULL, "program does not contain a static `main' method");
		}
	}
	if (vala_compiler_dump_tree != NULL) {
		ValaCodeWriter* _tmp104_ = NULL;
		ValaCodeWriter* code_writer;
		_tmp104_ = vala_code_writer_new (VALA_CODE_WRITER_TYPE_DUMP);
		code_writer = _tmp104_;
		vala_code_writer_write_file (code_writer, self->priv->context, vala_compiler_dump_tree);
		_vala_code_visitor_unref0 (code_writer);
	}
	_tmp106_ = vala_code_context_get_report (self->priv->context);
	_tmp107_ = vala_report_get_errors (_tmp106_);
	if (_tmp107_ > 0) {
		_tmp105_ = TRUE;
	} else {
		gboolean _tmp108_ = FALSE;
		if (vala_compiler_fatal_warnings) {
			ValaReport* _tmp109_ = NULL;
			gint _tmp110_;
			_tmp109_ = vala_code_context_get_report (self->priv->context);
			_tmp110_ = vala_report_get_warnings (_tmp109_);
			_tmp108_ = _tmp110_ > 0;
		} else {
			_tmp108_ = FALSE;
		}
		_tmp105_ = _tmp108_;
	}
	if (_tmp105_) {
		gint _tmp111_;
		_tmp111_ = vala_compiler_quit (self);
		result = _tmp111_;
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp112_ = vala_code_context_get_codegen (self->priv->context);
	vala_code_generator_emit (_tmp112_, self->priv->context);
	_tmp114_ = vala_code_context_get_report (self->priv->context);
	_tmp115_ = vala_report_get_errors (_tmp114_);
	if (_tmp115_ > 0) {
		_tmp113_ = TRUE;
	} else {
		gboolean _tmp116_ = FALSE;
		if (vala_compiler_fatal_warnings) {
			ValaReport* _tmp117_ = NULL;
			gint _tmp118_;
			_tmp117_ = vala_code_context_get_report (self->priv->context);
			_tmp118_ = vala_report_get_warnings (_tmp117_);
			_tmp116_ = _tmp118_ > 0;
		} else {
			_tmp116_ = FALSE;
		}
		_tmp113_ = _tmp116_;
	}
	if (_tmp113_) {
		gint _tmp119_;
		_tmp119_ = vala_compiler_quit (self);
		result = _tmp119_;
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	if (vala_compiler_vapi_filename == NULL) {
		_tmp120_ = vala_compiler_library != NULL;
	} else {
		_tmp120_ = FALSE;
	}
	if (_tmp120_) {
		gchar* _tmp121_ = NULL;
		gchar* _tmp122_;
		_tmp121_ = g_strdup_printf ("%s.vapi", vala_compiler_library);
		_tmp122_ = _tmp121_;
		_g_free0 (vala_compiler_vapi_filename);
		vala_compiler_vapi_filename = _tmp122_;
	}
	if (vala_compiler_library != NULL) {
		gchar* _tmp147_;
		if (vala_compiler_gir != NULL) {
			ValaProfile _tmp123_;
			gchar* _tmp146_;
			_tmp123_ = vala_code_context_get_profile (self->priv->context);
			if (_tmp123_ == VALA_PROFILE_GOBJECT) {
				glong _tmp124_;
				glong gir_len;
				const gchar* _tmp125_ = NULL;
				const gchar* last_hyphen;
				gboolean _tmp126_ = FALSE;
				_tmp124_ = strlen (vala_compiler_gir);
				gir_len = _tmp124_;
				_tmp125_ = g_utf8_strrchr (vala_compiler_gir, (gssize) gir_len, (gunichar) '-');
				last_hyphen = _tmp125_;
				if (last_hyphen == NULL) {
					_tmp126_ = TRUE;
				} else {
					gboolean _tmp127_;
					_tmp127_ = g_str_has_suffix (vala_compiler_gir, ".gir");
					_tmp126_ = !_tmp127_;
				}
				if (_tmp126_) {
					gchar* _tmp128_ = NULL;
					gchar* _tmp129_;
					_tmp128_ = g_strdup_printf ("GIR file name `%s' is not well-formed, expected NAME-VERSION.gir", vala_compiler_gir);
					_tmp129_ = _tmp128_;
					vala_report_error (NULL, _tmp129_);
					_g_free0 (_tmp129_);
				} else {
					glong _tmp130_;
					glong offset;
					gchar* _tmp131_ = NULL;
					gchar* gir_namespace;
					gchar* _tmp132_ = NULL;
					gchar* gir_version;
					gboolean _tmp133_ = FALSE;
					gboolean _tmp134_ = FALSE;
					gboolean _tmp135_ = FALSE;
					_tmp130_ = string_pointer_to_offset (vala_compiler_gir, last_hyphen);
					offset = _tmp130_;
					_tmp131_ = string_substring (vala_compiler_gir, (glong) 0, offset);
					gir_namespace = _tmp131_;
					_tmp132_ = string_substring (vala_compiler_gir, offset + 1, (gir_len - offset) - 5);
					gir_version = _tmp132_;
					g_strcanon (gir_version, "0123456789.", '?');
					if (g_strcmp0 (gir_namespace, "") == 0) {
						_tmp135_ = TRUE;
					} else {
						_tmp135_ = g_strcmp0 (gir_version, "") == 0;
					}
					if (_tmp135_) {
						_tmp134_ = TRUE;
					} else {
						gchar _tmp136_;
						gboolean _tmp137_;
						_tmp136_ = string_get (gir_version, (glong) 0);
						_tmp137_ = g_ascii_isdigit (_tmp136_);
						_tmp134_ = !_tmp137_;
					}
					if (_tmp134_) {
						_tmp133_ = TRUE;
					} else {
						gboolean _tmp138_;
						_tmp138_ = string_contains (gir_version, "?");
						_tmp133_ = _tmp138_;
					}
					if (_tmp133_) {
						gchar* _tmp139_ = NULL;
						gchar* _tmp140_;
						_tmp139_ = g_strdup_printf ("GIR file name `%s' is not well-formed, expected NAME-VERSION.gir", vala_compiler_gir);
						_tmp140_ = _tmp139_;
						vala_report_error (NULL, _tmp140_);
						_g_free0 (_tmp140_);
					} else {
						ValaGIRWriter* _tmp141_ = NULL;
						ValaGIRWriter* gir_writer;
						gchar* _tmp142_;
						gchar* gir_directory;
						_tmp141_ = vala_gir_writer_new ();
						gir_writer = _tmp141_;
						_tmp142_ = g_strdup (".");
						gir_directory = _tmp142_;
						if (vala_compiler_directory != NULL) {
							const gchar* _tmp143_ = NULL;
							gchar* _tmp144_;
							gchar* _tmp145_;
							_tmp143_ = vala_code_context_get_directory (self->priv->context);
							_tmp144_ = g_strdup (_tmp143_);
							_tmp145_ = _tmp144_;
							_g_free0 (gir_directory);
							gir_directory = _tmp145_;
						}
						vala_gir_writer_write_file (gir_writer, self->priv->context, gir_directory, gir_namespace, gir_version, vala_compiler_library);
						_g_free0 (gir_directory);
						_vala_code_visitor_unref0 (gir_writer);
					}
					_g_free0 (gir_version);
					_g_free0 (gir_namespace);
				}
			}
			_tmp146_ = NULL;
			_g_free0 (vala_compiler_gir);
			vala_compiler_gir = _tmp146_;
		}
		_tmp147_ = NULL;
		_g_free0 (vala_compiler_library);
		vala_compiler_library = _tmp147_;
	}
	if (vala_compiler_vapi_filename != NULL) {
		ValaCodeWriter* _tmp148_ = NULL;
		ValaCodeWriter* interface_writer;
		gboolean _tmp149_ = FALSE;
		_tmp148_ = vala_code_writer_new (VALA_CODE_WRITER_TYPE_EXTERNAL);
		interface_writer = _tmp148_;
		if (vala_compiler_directory != NULL) {
			gboolean _tmp150_;
			_tmp150_ = g_path_is_absolute (vala_compiler_vapi_filename);
			_tmp149_ = !_tmp150_;
		} else {
			_tmp149_ = FALSE;
		}
		if (_tmp149_) {
			const gchar* _tmp151_ = NULL;
			gchar* _tmp152_ = NULL;
			gchar* _tmp153_;
			_tmp151_ = vala_code_context_get_directory (self->priv->context);
			_tmp152_ = g_strdup_printf ("%s%c%s", _tmp151_, (gint) G_DIR_SEPARATOR, vala_compiler_vapi_filename);
			_tmp153_ = _tmp152_;
			_g_free0 (vala_compiler_vapi_filename);
			vala_compiler_vapi_filename = _tmp153_;
		}
		vala_code_writer_write_file (interface_writer, self->priv->context, vala_compiler_vapi_filename);
		_vala_code_visitor_unref0 (interface_writer);
	}
	if (vala_compiler_internal_vapi_filename != NULL) {
		gboolean _tmp154_ = FALSE;
		ValaCodeWriter* _tmp156_ = NULL;
		ValaCodeWriter* interface_writer;
		gchar* _tmp157_;
		gchar* vapi_filename;
		gboolean _tmp158_ = FALSE;
		gchar* _tmp163_;
		if (vala_compiler_internal_header_filename == NULL) {
			_tmp154_ = TRUE;
		} else {
			_tmp154_ = vala_compiler_header_filename == NULL;
		}
		if (_tmp154_) {
			gint _tmp155_;
			vala_report_error (NULL, "--internal-vapi may only be used in combination with --header and --in" \
"ternal-header");
			_tmp155_ = vala_compiler_quit (self);
			result = _tmp155_;
			_vala_code_visitor_unref0 (gir_parser);
			_vala_code_visitor_unref0 (genie_parser);
			_vala_code_visitor_unref0 (parser);
			return result;
		}
		_tmp156_ = vala_code_writer_new (VALA_CODE_WRITER_TYPE_INTERNAL);
		interface_writer = _tmp156_;
		vala_code_writer_set_cheader_override (interface_writer, vala_compiler_header_filename, vala_compiler_internal_header_filename);
		_tmp157_ = g_strdup (vala_compiler_internal_vapi_filename);
		vapi_filename = _tmp157_;
		if (vala_compiler_directory != NULL) {
			gboolean _tmp159_;
			_tmp159_ = g_path_is_absolute (vapi_filename);
			_tmp158_ = !_tmp159_;
		} else {
			_tmp158_ = FALSE;
		}
		if (_tmp158_) {
			const gchar* _tmp160_ = NULL;
			gchar* _tmp161_ = NULL;
			gchar* _tmp162_;
			_tmp160_ = vala_code_context_get_directory (self->priv->context);
			_tmp161_ = g_strdup_printf ("%s%c%s", _tmp160_, (gint) G_DIR_SEPARATOR, vapi_filename);
			_tmp162_ = _tmp161_;
			_g_free0 (vapi_filename);
			vapi_filename = _tmp162_;
		}
		vala_code_writer_write_file (interface_writer, self->priv->context, vapi_filename);
		_tmp163_ = NULL;
		_g_free0 (vala_compiler_internal_vapi_filename);
		vala_compiler_internal_vapi_filename = _tmp163_;
		_g_free0 (vapi_filename);
		_vala_code_visitor_unref0 (interface_writer);
	}
	if (vala_compiler_dependencies != NULL) {
		vala_code_context_write_dependencies (self->priv->context, vala_compiler_dependencies);
	}
	if (!vala_compiler_ccode_only) {
		ValaCCodeCompiler* _tmp164_ = NULL;
		ValaCCodeCompiler* ccompiler;
		gboolean _tmp165_ = FALSE;
		_tmp164_ = vala_ccode_compiler_new ();
		ccompiler = _tmp164_;
		if (vala_compiler_cc_command == NULL) {
			const gchar* _tmp166_ = NULL;
			_tmp166_ = g_getenv ("CC");
			_tmp165_ = _tmp166_ != NULL;
		} else {
			_tmp165_ = FALSE;
		}
		if (_tmp165_) {
			const gchar* _tmp167_ = NULL;
			gchar* _tmp168_;
			gchar* _tmp169_;
			_tmp167_ = g_getenv ("CC");
			_tmp168_ = g_strdup (_tmp167_);
			_tmp169_ = _tmp168_;
			_g_free0 (vala_compiler_cc_command);
			vala_compiler_cc_command = _tmp169_;
		}
		if (vala_compiler_cc_options == NULL) {
			gchar** _tmp170_ = NULL;
			gchar** _tmp171_;
			gint _tmp171__length1;
			_tmp170_ = g_new0 (gchar*, 0 + 1);
			_tmp171_ = _tmp170_;
			_tmp171__length1 = 0;
			vala_ccode_compiler_compile (ccompiler, self->priv->context, vala_compiler_cc_command, _tmp171_, 0);
			_tmp171_ = (_vala_array_free (_tmp171_, _tmp171__length1, (GDestroyNotify) g_free), NULL);
		} else {
			vala_ccode_compiler_compile (ccompiler, self->priv->context, vala_compiler_cc_command, vala_compiler_cc_options, _vala_array_length (vala_compiler_cc_options));
		}
		_vala_ccode_compiler_unref0 (ccompiler);
	}
	_tmp172_ = vala_compiler_quit (self);
	result = _tmp172_;
	_vala_code_visitor_unref0 (gir_parser);
	_vala_code_visitor_unref0 (genie_parser);
	_vala_code_visitor_unref0 (parser);
	return result;
}


static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (Block1Data* _data1_) {
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_main_loop_unref0 (_data1_->loop);
		g_slice_free (Block1Data, _data1_);
	}
}


static void _lambda0_ (GPid pid, gint status, Block1Data* _data1_) {
	_data1_->child_status = (status & 0xff00) >> 8;
	g_main_loop_quit (_data1_->loop);
}


static void __lambda0__gchild_watch_func (GPid pid, gint status, gpointer self) {
	_lambda0_ (pid, status, self);
}


static gint vala_compiler_run_source (gchar** args, int args_length1) {
	gint result = 0;
	gint i;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp7_;
	gchar** _tmp8_ = NULL;
	gchar** _tmp9_;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_;
	gint _tmp15_;
	gint outputfd;
	ValaCompiler* _tmp16_ = NULL;
	ValaCompiler* compiler;
	gint _tmp17_;
	gint ret;
	gint _tmp18_;
	gchar* _tmp19_;
	gchar** _tmp20_ = NULL;
	gint target_args_length1;
	gint _target_args_size_;
	gchar** _tmp21_;
	gchar** target_args;
	Block1Data* _data1_;
	GPid pid = 0;
	GMainLoop* _tmp23_ = NULL;
	GPid _tmp24_;
	GError * _inner_error_ = NULL;
	i = 1;
	if (args[i] != NULL) {
		gboolean _tmp1_;
		_tmp1_ = g_str_has_prefix (args[i], "-");
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint compile_args_length1;
		gint _compile_args_size_;
		gchar** compile_args;
		gchar* _tmp2_;
		gchar** _tmp3_ = NULL;
		gint _tmp4_;
		GOptionContext* _tmp5_ = NULL;
		GOptionContext* opt_context;
		gint temp_args_length1;
		gint _temp_args_size_;
		gchar** _tmp6_;
		gchar** temp_args;
		compile_args_length1 = 0;
		compile_args = NULL;
		_tmp2_ = g_strconcat ("valac ", args[1], NULL);
		g_shell_parse_argv (_tmp2_, &_tmp4_, &_tmp3_, &_inner_error_);
		compile_args = (_vala_array_free (compile_args, compile_args_length1, (GDestroyNotify) g_free), NULL);
		compile_args = _tmp3_;
		compile_args_length1 = _tmp4_;
		_g_free0 (_tmp2_);
		if (_inner_error_ != NULL) {
			compile_args = (_vala_array_free (compile_args, compile_args_length1, (GDestroyNotify) g_free), NULL);
			if (_inner_error_->domain == G_SHELL_ERROR) {
				goto __catch0_g_shell_error;
			}
			if (_inner_error_->domain == G_OPTION_ERROR) {
				goto __catch0_g_option_error;
			}
			compile_args = (_vala_array_free (compile_args, compile_args_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
		_tmp5_ = g_option_context_new ("- Vala");
		opt_context = _tmp5_;
		g_option_context_set_help_enabled (opt_context, TRUE);
		g_option_context_add_main_entries (opt_context, VALA_COMPILER_options, NULL);
		_tmp6_ = compile_args;
		temp_args_length1 = compile_args_length1;
		_temp_args_size_ = temp_args_length1;
		temp_args = _tmp6_;
		g_option_context_parse (opt_context, &temp_args_length1, &temp_args, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_option_context_free0 (opt_context);
			compile_args = (_vala_array_free (compile_args, compile_args_length1, (GDestroyNotify) g_free), NULL);
			if (_inner_error_->domain == G_SHELL_ERROR) {
				goto __catch0_g_shell_error;
			}
			if (_inner_error_->domain == G_OPTION_ERROR) {
				goto __catch0_g_option_error;
			}
			_g_option_context_free0 (opt_context);
			compile_args = (_vala_array_free (compile_args, compile_args_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
		_g_option_context_free0 (opt_context);
		compile_args = (_vala_array_free (compile_args, compile_args_length1, (GDestroyNotify) g_free), NULL);
		goto __finally0;
		__catch0_g_shell_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			fprintf (stdout, "%s\n", e->message);
			result = 1;
			_g_error_free0 (e);
			return result;
		}
		goto __finally0;
		__catch0_g_option_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			fprintf (stdout, "%s\n", e->message);
			fprintf (stdout, "Run '%s --help' to see a full list of available command line options.\n", args[0]);
			result = 1;
			_g_error_free0 (e);
			return result;
		}
		__finally0:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
		i++;
	}
	if (args[i] == NULL) {
		fprintf (stderr, "No source file specified.\n");
		result = 1;
		return result;
	}
	_tmp7_ = g_strdup (args[i]);
	_tmp8_ = g_new0 (gchar*, 1 + 1);
	_tmp8_[0] = _tmp7_;
	_tmp9_ = _tmp8_;
	vala_compiler_sources = (_vala_array_free (vala_compiler_sources, _vala_array_length (vala_compiler_sources), (GDestroyNotify) g_free), NULL);
	vala_compiler_sources = _tmp9_;
	_tmp10_ = g_get_tmp_dir ();
	_tmp11_ = g_path_get_basename (args[i]);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_strdup_printf ("%s/%s.XXXXXX", _tmp10_, _tmp12_);
	_tmp14_ = _tmp13_;
	_g_free0 (vala_compiler_output);
	vala_compiler_output = _tmp14_;
	_g_free0 (_tmp12_);
	_tmp15_ = g_mkstemp (vala_compiler_output);
	outputfd = _tmp15_;
	if (outputfd < 0) {
		result = 1;
		return result;
	}
	vala_compiler_run_output = TRUE;
	vala_compiler_disable_warnings = TRUE;
	vala_compiler_quiet_mode = TRUE;
	_tmp16_ = vala_compiler_new ();
	compiler = _tmp16_;
	_tmp17_ = vala_compiler_run (compiler);
	ret = _tmp17_;
	if (ret != 0) {
		result = ret;
		_vala_compiler_unref0 (compiler);
		return result;
	}
	close (outputfd);
	_tmp18_ = g_chmod (vala_compiler_output, 0700);
	if (_tmp18_ != 0) {
		g_unlink (vala_compiler_output);
		result = 1;
		_vala_compiler_unref0 (compiler);
		return result;
	}
	_tmp19_ = g_strdup (vala_compiler_output);
	_tmp20_ = g_new0 (gchar*, 1 + 1);
	_tmp20_[0] = _tmp19_;
	_tmp21_ = _tmp20_;
	target_args_length1 = 1;
	_target_args_size_ = target_args_length1;
	target_args = _tmp21_;
	while (TRUE) {
		gchar* _tmp22_;
		if (!(i < args_length1)) {
			break;
		}
		_tmp22_ = g_strdup (args[i]);
		_vala_array_add1 (&target_args, &target_args_length1, &_target_args_size_, _tmp22_);
		i++;
	}
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_tmp23_ = g_main_loop_new (NULL, FALSE);
	_data1_->loop = _tmp23_;
	_data1_->child_status = 0;
	g_spawn_async (NULL, target_args, NULL, (G_SPAWN_CHILD_INHERITS_STDIN | G_SPAWN_DO_NOT_REAP_CHILD) | G_SPAWN_FILE_AND_ARGV_ZERO, NULL, NULL, &_tmp24_, &_inner_error_);
	pid = _tmp24_;
	if (_inner_error_ != NULL) {
		block1_data_unref (_data1_);
		if (_inner_error_->domain == G_SPAWN_ERROR) {
			goto __catch1_g_spawn_error;
		}
		block1_data_unref (_data1_);
		target_args = (_vala_array_free (target_args, target_args_length1, (GDestroyNotify) g_free), NULL);
		_vala_compiler_unref0 (compiler);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	g_unlink (vala_compiler_output);
	g_child_watch_add_full (G_PRIORITY_DEFAULT_IDLE, pid, __lambda0__gchild_watch_func, block1_data_ref (_data1_), block1_data_unref);
	g_main_loop_run (_data1_->loop);
	result = _data1_->child_status;
	block1_data_unref (_data1_);
	target_args = (_vala_array_free (target_args, target_args_length1, (GDestroyNotify) g_free), NULL);
	_vala_compiler_unref0 (compiler);
	return result;
	block1_data_unref (_data1_);
	goto __finally1;
	__catch1_g_spawn_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		fprintf (stdout, "%s\n", e->message);
		result = 1;
		_g_error_free0 (e);
		target_args = (_vala_array_free (target_args, target_args_length1, (GDestroyNotify) g_free), NULL);
		_vala_compiler_unref0 (compiler);
		return result;
	}
	__finally1:
	target_args = (_vala_array_free (target_args, target_args_length1, (GDestroyNotify) g_free), NULL);
	_vala_compiler_unref0 (compiler);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return 0;
}


static gint vala_compiler_main (gchar** args, int args_length1) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gboolean _tmp3_;
	GOptionContext* _tmp7_ = NULL;
	GOptionContext* opt_context;
	gboolean _tmp8_ = FALSE;
	ValaCompiler* _tmp9_ = NULL;
	ValaCompiler* compiler;
	gint _tmp10_;
	GError * _inner_error_ = NULL;
	setlocale (LC_ALL, "");
	_tmp1_ = g_path_get_basename (args[0]);
	_tmp2_ = _tmp1_;
	if ((_tmp3_ = g_strcmp0 (_tmp2_, "vala") == 0, _g_free0 (_tmp2_), _tmp3_)) {
		_tmp0_ = TRUE;
	} else {
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		_tmp4_ = g_path_get_basename (args[0]);
		_tmp5_ = _tmp4_;
		_tmp0_ = g_strcmp0 (_tmp5_, "vala" PACKAGE_SUFFIX) == 0;
		_g_free0 (_tmp5_);
	}
	if (_tmp0_) {
		gint _tmp6_;
		_tmp6_ = vala_compiler_run_source (args, args_length1);
		result = _tmp6_;
		return result;
	}
	_tmp7_ = g_option_context_new ("- Vala Compiler");
	opt_context = _tmp7_;
	g_option_context_set_help_enabled (opt_context, TRUE);
	g_option_context_add_main_entries (opt_context, VALA_COMPILER_options, NULL);
	g_option_context_parse (opt_context, &args_length1, &args, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_option_context_free0 (opt_context);
		if (_inner_error_->domain == G_OPTION_ERROR) {
			goto __catch2_g_option_error;
		}
		_g_option_context_free0 (opt_context);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_g_option_context_free0 (opt_context);
	goto __finally2;
	__catch2_g_option_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		fprintf (stdout, "%s\n", e->message);
		fprintf (stdout, "Run '%s --help' to see a full list of available command line options.\n", args[0]);
		result = 1;
		_g_error_free0 (e);
		return result;
	}
	__finally2:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	if (vala_compiler_version) {
		fprintf (stdout, "Vala %s\n", BUILD_VERSION);
		result = 0;
		return result;
	}
	if (vala_compiler_sources == NULL) {
		_tmp8_ = vala_compiler_fast_vapis == NULL;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		fprintf (stderr, "No source file specified.\n");
		result = 1;
		return result;
	}
	_tmp9_ = vala_compiler_new ();
	compiler = _tmp9_;
	_tmp10_ = vala_compiler_run (compiler);
	result = _tmp10_;
	_vala_compiler_unref0 (compiler);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return vala_compiler_main (argv, argc);
}


ValaCompiler* vala_compiler_construct (GType object_type) {
	ValaCompiler* self = NULL;
	self = (ValaCompiler*) g_type_create_instance (object_type);
	return self;
}


ValaCompiler* vala_compiler_new (void) {
	return vala_compiler_construct (VALA_TYPE_COMPILER);
}


static void vala_value_compiler_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void vala_value_compiler_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		vala_compiler_unref (value->data[0].v_pointer);
	}
}


static void vala_value_compiler_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_compiler_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer vala_value_compiler_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* vala_value_compiler_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ValaCompiler* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_compiler_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* vala_value_compiler_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ValaCompiler** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_compiler_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* vala_param_spec_compiler (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ValaParamSpecCompiler* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_TYPE_COMPILER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer vala_value_get_compiler (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_COMPILER), NULL);
	return value->data[0].v_pointer;
}


void vala_value_set_compiler (GValue* value, gpointer v_object) {
	ValaCompiler* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_COMPILER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_COMPILER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_compiler_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_compiler_unref (old);
	}
}


void vala_value_take_compiler (GValue* value, gpointer v_object) {
	ValaCompiler* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_COMPILER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_COMPILER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_compiler_unref (old);
	}
}


static void vala_compiler_class_init (ValaCompilerClass * klass) {
	vala_compiler_parent_class = g_type_class_peek_parent (klass);
	VALA_COMPILER_CLASS (klass)->finalize = vala_compiler_finalize;
	g_type_class_add_private (klass, sizeof (ValaCompilerPrivate));
}


static void vala_compiler_instance_init (ValaCompiler * self) {
	self->priv = VALA_COMPILER_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void vala_compiler_finalize (ValaCompiler* obj) {
	ValaCompiler * self;
	self = VALA_COMPILER (obj);
	_vala_code_context_unref0 (self->priv->context);
}


GType vala_compiler_get_type (void) {
	static volatile gsize vala_compiler_type_id__volatile = 0;
	if (g_once_init_enter (&vala_compiler_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { vala_value_compiler_init, vala_value_compiler_free_value, vala_value_compiler_copy_value, vala_value_compiler_peek_pointer, "p", vala_value_compiler_collect_value, "p", vala_value_compiler_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValaCompilerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_compiler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCompiler), 0, (GInstanceInitFunc) vala_compiler_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType vala_compiler_type_id;
		vala_compiler_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaCompiler", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&vala_compiler_type_id__volatile, vala_compiler_type_id);
	}
	return vala_compiler_type_id__volatile;
}


gpointer vala_compiler_ref (gpointer instance) {
	ValaCompiler* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void vala_compiler_unref (gpointer instance) {
	ValaCompiler* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_COMPILER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



