/* valanamespace.c generated by valac, the Vala compiler
 * generated from valanamespace.vala, do not modify */

/* valanamespace.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>


#define VALA_TYPE_CODE_NODE (vala_code_node_get_type ())
#define VALA_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_NODE, ValaCodeNode))
#define VALA_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))
#define VALA_IS_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_NODE))
#define VALA_IS_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_NODE))
#define VALA_CODE_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))

typedef struct _ValaCodeNode ValaCodeNode;
typedef struct _ValaCodeNodeClass ValaCodeNodeClass;
typedef struct _ValaCodeNodePrivate ValaCodeNodePrivate;

#define VALA_TYPE_CODE_VISITOR (vala_code_visitor_get_type ())
#define VALA_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitor))
#define VALA_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))
#define VALA_IS_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_VISITOR))
#define VALA_IS_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_VISITOR))
#define VALA_CODE_VISITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))

typedef struct _ValaCodeVisitor ValaCodeVisitor;
typedef struct _ValaCodeVisitorClass ValaCodeVisitorClass;

#define VALA_TYPE_SEMANTIC_ANALYZER (vala_semantic_analyzer_get_type ())
#define VALA_SEMANTIC_ANALYZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzer))
#define VALA_SEMANTIC_ANALYZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzerClass))
#define VALA_IS_SEMANTIC_ANALYZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SEMANTIC_ANALYZER))
#define VALA_IS_SEMANTIC_ANALYZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SEMANTIC_ANALYZER))
#define VALA_SEMANTIC_ANALYZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzerClass))

typedef struct _ValaSemanticAnalyzer ValaSemanticAnalyzer;
typedef struct _ValaSemanticAnalyzerClass ValaSemanticAnalyzerClass;

#define VALA_TYPE_CODE_GENERATOR (vala_code_generator_get_type ())
#define VALA_CODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_GENERATOR, ValaCodeGenerator))
#define VALA_CODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_GENERATOR, ValaCodeGeneratorClass))
#define VALA_IS_CODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_GENERATOR))
#define VALA_IS_CODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_GENERATOR))
#define VALA_CODE_GENERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_GENERATOR, ValaCodeGeneratorClass))

typedef struct _ValaCodeGenerator ValaCodeGenerator;
typedef struct _ValaCodeGeneratorClass ValaCodeGeneratorClass;

#define VALA_TYPE_DATA_TYPE (vala_data_type_get_type ())
#define VALA_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DATA_TYPE, ValaDataType))
#define VALA_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))
#define VALA_IS_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DATA_TYPE))
#define VALA_IS_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DATA_TYPE))
#define VALA_DATA_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))

typedef struct _ValaDataType ValaDataType;
typedef struct _ValaDataTypeClass ValaDataTypeClass;

#define VALA_TYPE_EXPRESSION (vala_expression_get_type ())
#define VALA_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_EXPRESSION, ValaExpression))
#define VALA_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_EXPRESSION, ValaExpressionClass))
#define VALA_IS_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_EXPRESSION))
#define VALA_IS_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_EXPRESSION))
#define VALA_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_EXPRESSION, ValaExpressionClass))

typedef struct _ValaExpression ValaExpression;
typedef struct _ValaExpressionClass ValaExpressionClass;

#define VALA_TYPE_SYMBOL (vala_symbol_get_type ())
#define VALA_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SYMBOL, ValaSymbol))
#define VALA_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SYMBOL, ValaSymbolClass))
#define VALA_IS_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SYMBOL))
#define VALA_IS_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SYMBOL))
#define VALA_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SYMBOL, ValaSymbolClass))

typedef struct _ValaSymbol ValaSymbol;
typedef struct _ValaSymbolClass ValaSymbolClass;

#define VALA_TYPE_VARIABLE (vala_variable_get_type ())
#define VALA_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_VARIABLE, ValaVariable))
#define VALA_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_VARIABLE, ValaVariableClass))
#define VALA_IS_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_VARIABLE))
#define VALA_IS_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_VARIABLE))
#define VALA_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_VARIABLE, ValaVariableClass))

typedef struct _ValaVariable ValaVariable;
typedef struct _ValaVariableClass ValaVariableClass;

#define VALA_TYPE_LOCAL_VARIABLE (vala_local_variable_get_type ())
#define VALA_LOCAL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable))
#define VALA_LOCAL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariableClass))
#define VALA_IS_LOCAL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_LOCAL_VARIABLE))
#define VALA_IS_LOCAL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_LOCAL_VARIABLE))
#define VALA_LOCAL_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariableClass))

typedef struct _ValaLocalVariable ValaLocalVariable;
typedef struct _ValaLocalVariableClass ValaLocalVariableClass;

#define VALA_TYPE_ATTRIBUTE (vala_attribute_get_type ())
#define VALA_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ATTRIBUTE, ValaAttribute))
#define VALA_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))
#define VALA_IS_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ATTRIBUTE))
#define VALA_IS_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ATTRIBUTE))
#define VALA_ATTRIBUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))

typedef struct _ValaAttribute ValaAttribute;
typedef struct _ValaAttributeClass ValaAttributeClass;
typedef struct _ValaSymbolPrivate ValaSymbolPrivate;

#define VALA_TYPE_NAMESPACE (vala_namespace_get_type ())
#define VALA_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_NAMESPACE, ValaNamespace))
#define VALA_NAMESPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_NAMESPACE, ValaNamespaceClass))
#define VALA_IS_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_NAMESPACE))
#define VALA_IS_NAMESPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_NAMESPACE))
#define VALA_NAMESPACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_NAMESPACE, ValaNamespaceClass))

typedef struct _ValaNamespace ValaNamespace;
typedef struct _ValaNamespaceClass ValaNamespaceClass;

#define VALA_TYPE_TYPESYMBOL (vala_typesymbol_get_type ())
#define VALA_TYPESYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPESYMBOL, ValaTypeSymbol))
#define VALA_TYPESYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPESYMBOL, ValaTypeSymbolClass))
#define VALA_IS_TYPESYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPESYMBOL))
#define VALA_IS_TYPESYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPESYMBOL))
#define VALA_TYPESYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPESYMBOL, ValaTypeSymbolClass))

typedef struct _ValaTypeSymbol ValaTypeSymbol;
typedef struct _ValaTypeSymbolClass ValaTypeSymbolClass;

#define VALA_TYPE_OBJECT_TYPE_SYMBOL (vala_object_type_symbol_get_type ())
#define VALA_OBJECT_TYPE_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol))
#define VALA_OBJECT_TYPE_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbolClass))
#define VALA_IS_OBJECT_TYPE_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL))
#define VALA_IS_OBJECT_TYPE_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_OBJECT_TYPE_SYMBOL))
#define VALA_OBJECT_TYPE_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbolClass))

typedef struct _ValaObjectTypeSymbol ValaObjectTypeSymbol;
typedef struct _ValaObjectTypeSymbolClass ValaObjectTypeSymbolClass;

#define VALA_TYPE_CLASS (vala_class_get_type ())
#define VALA_CLASS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CLASS, ValaClass))
#define VALA_CLASS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CLASS, ValaClassClass))
#define VALA_IS_CLASS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CLASS))
#define VALA_IS_CLASS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CLASS))
#define VALA_CLASS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CLASS, ValaClassClass))

typedef struct _ValaClass ValaClass;
typedef struct _ValaClassClass ValaClassClass;

#define VALA_TYPE_INTERFACE (vala_interface_get_type ())
#define VALA_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_INTERFACE, ValaInterface))
#define VALA_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_INTERFACE, ValaInterfaceClass))
#define VALA_IS_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_INTERFACE))
#define VALA_IS_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_INTERFACE))
#define VALA_INTERFACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_INTERFACE, ValaInterfaceClass))

typedef struct _ValaInterface ValaInterface;
typedef struct _ValaInterfaceClass ValaInterfaceClass;

#define VALA_TYPE_STRUCT (vala_struct_get_type ())
#define VALA_STRUCT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_STRUCT, ValaStruct))
#define VALA_STRUCT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_STRUCT, ValaStructClass))
#define VALA_IS_STRUCT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_STRUCT))
#define VALA_IS_STRUCT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_STRUCT))
#define VALA_STRUCT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_STRUCT, ValaStructClass))

typedef struct _ValaStruct ValaStruct;
typedef struct _ValaStructClass ValaStructClass;

#define VALA_TYPE_ENUM (vala_enum_get_type ())
#define VALA_ENUM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ENUM, ValaEnum))
#define VALA_ENUM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ENUM, ValaEnumClass))
#define VALA_IS_ENUM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ENUM))
#define VALA_IS_ENUM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ENUM))
#define VALA_ENUM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ENUM, ValaEnumClass))

typedef struct _ValaEnum ValaEnum;
typedef struct _ValaEnumClass ValaEnumClass;

#define VALA_TYPE_ERROR_DOMAIN (vala_error_domain_get_type ())
#define VALA_ERROR_DOMAIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ERROR_DOMAIN, ValaErrorDomain))
#define VALA_ERROR_DOMAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ERROR_DOMAIN, ValaErrorDomainClass))
#define VALA_IS_ERROR_DOMAIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ERROR_DOMAIN))
#define VALA_IS_ERROR_DOMAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ERROR_DOMAIN))
#define VALA_ERROR_DOMAIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ERROR_DOMAIN, ValaErrorDomainClass))

typedef struct _ValaErrorDomain ValaErrorDomain;
typedef struct _ValaErrorDomainClass ValaErrorDomainClass;

#define VALA_TYPE_DELEGATE (vala_delegate_get_type ())
#define VALA_DELEGATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DELEGATE, ValaDelegate))
#define VALA_DELEGATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DELEGATE, ValaDelegateClass))
#define VALA_IS_DELEGATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DELEGATE))
#define VALA_IS_DELEGATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DELEGATE))
#define VALA_DELEGATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DELEGATE, ValaDelegateClass))

typedef struct _ValaDelegate ValaDelegate;
typedef struct _ValaDelegateClass ValaDelegateClass;

#define VALA_TYPE_CONSTANT (vala_constant_get_type ())
#define VALA_CONSTANT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CONSTANT, ValaConstant))
#define VALA_CONSTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CONSTANT, ValaConstantClass))
#define VALA_IS_CONSTANT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CONSTANT))
#define VALA_IS_CONSTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CONSTANT))
#define VALA_CONSTANT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CONSTANT, ValaConstantClass))

typedef struct _ValaConstant ValaConstant;
typedef struct _ValaConstantClass ValaConstantClass;

#define VALA_TYPE_FIELD (vala_field_get_type ())
#define VALA_FIELD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_FIELD, ValaField))
#define VALA_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_FIELD, ValaFieldClass))
#define VALA_IS_FIELD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_FIELD))
#define VALA_IS_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_FIELD))
#define VALA_FIELD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_FIELD, ValaFieldClass))

typedef struct _ValaField ValaField;
typedef struct _ValaFieldClass ValaFieldClass;

#define VALA_TYPE_METHOD (vala_method_get_type ())
#define VALA_METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_METHOD, ValaMethod))
#define VALA_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_METHOD, ValaMethodClass))
#define VALA_IS_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_METHOD))
#define VALA_IS_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_METHOD))
#define VALA_METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_METHOD, ValaMethodClass))

typedef struct _ValaMethod ValaMethod;
typedef struct _ValaMethodClass ValaMethodClass;

#define VALA_TYPE_PROPERTY (vala_property_get_type ())
#define VALA_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_PROPERTY, ValaProperty))
#define VALA_PROPERTY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_PROPERTY, ValaPropertyClass))
#define VALA_IS_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_PROPERTY))
#define VALA_IS_PROPERTY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_PROPERTY))
#define VALA_PROPERTY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_PROPERTY, ValaPropertyClass))

typedef struct _ValaProperty ValaProperty;
typedef struct _ValaPropertyClass ValaPropertyClass;

#define VALA_TYPE_SIGNAL (vala_signal_get_type ())
#define VALA_SIGNAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SIGNAL, ValaSignal))
#define VALA_SIGNAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SIGNAL, ValaSignalClass))
#define VALA_IS_SIGNAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SIGNAL))
#define VALA_IS_SIGNAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SIGNAL))
#define VALA_SIGNAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SIGNAL, ValaSignalClass))

typedef struct _ValaSignal ValaSignal;
typedef struct _ValaSignalClass ValaSignalClass;

#define VALA_TYPE_CONSTRUCTOR (vala_constructor_get_type ())
#define VALA_CONSTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CONSTRUCTOR, ValaConstructor))
#define VALA_CONSTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CONSTRUCTOR, ValaConstructorClass))
#define VALA_IS_CONSTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CONSTRUCTOR))
#define VALA_IS_CONSTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CONSTRUCTOR))
#define VALA_CONSTRUCTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CONSTRUCTOR, ValaConstructorClass))

typedef struct _ValaConstructor ValaConstructor;
typedef struct _ValaConstructorClass ValaConstructorClass;

#define VALA_TYPE_DESTRUCTOR (vala_destructor_get_type ())
#define VALA_DESTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DESTRUCTOR, ValaDestructor))
#define VALA_DESTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DESTRUCTOR, ValaDestructorClass))
#define VALA_IS_DESTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DESTRUCTOR))
#define VALA_IS_DESTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DESTRUCTOR))
#define VALA_DESTRUCTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DESTRUCTOR, ValaDestructorClass))

typedef struct _ValaDestructor ValaDestructor;
typedef struct _ValaDestructorClass ValaDestructorClass;
typedef struct _ValaNamespacePrivate ValaNamespacePrivate;

#define VALA_TYPE_COMMENT (vala_comment_get_type ())
#define VALA_COMMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_COMMENT, ValaComment))
#define VALA_COMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_COMMENT, ValaCommentClass))
#define VALA_IS_COMMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_COMMENT))
#define VALA_IS_COMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_COMMENT))
#define VALA_COMMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_COMMENT, ValaCommentClass))

typedef struct _ValaComment ValaComment;
typedef struct _ValaCommentClass ValaCommentClass;

#define VALA_TYPE_USING_DIRECTIVE (vala_using_directive_get_type ())
#define VALA_USING_DIRECTIVE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_USING_DIRECTIVE, ValaUsingDirective))
#define VALA_USING_DIRECTIVE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_USING_DIRECTIVE, ValaUsingDirectiveClass))
#define VALA_IS_USING_DIRECTIVE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_USING_DIRECTIVE))
#define VALA_IS_USING_DIRECTIVE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_USING_DIRECTIVE))
#define VALA_USING_DIRECTIVE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_USING_DIRECTIVE, ValaUsingDirectiveClass))

typedef struct _ValaUsingDirective ValaUsingDirective;
typedef struct _ValaUsingDirectiveClass ValaUsingDirectiveClass;
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define VALA_TYPE_SOURCE_REFERENCE (vala_source_reference_get_type ())
#define VALA_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReference))
#define VALA_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))
#define VALA_IS_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_IS_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_SOURCE_REFERENCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))

typedef struct _ValaSourceReference ValaSourceReference;
typedef struct _ValaSourceReferenceClass ValaSourceReferenceClass;

#define VALA_TYPE_SYMBOL_ACCESSIBILITY (vala_symbol_accessibility_get_type ())

#define VALA_TYPE_SCOPE (vala_scope_get_type ())
#define VALA_SCOPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SCOPE, ValaScope))
#define VALA_SCOPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SCOPE, ValaScopeClass))
#define VALA_IS_SCOPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SCOPE))
#define VALA_IS_SCOPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SCOPE))
#define VALA_SCOPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SCOPE, ValaScopeClass))

typedef struct _ValaScope ValaScope;
typedef struct _ValaScopeClass ValaScopeClass;

#define VALA_TYPE_SOURCE_FILE (vala_source_file_get_type ())
#define VALA_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFile))
#define VALA_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))
#define VALA_IS_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_FILE))
#define VALA_IS_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_FILE))
#define VALA_SOURCE_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))

typedef struct _ValaSourceFile ValaSourceFile;
typedef struct _ValaSourceFileClass ValaSourceFileClass;
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_comment_unref0(var) ((var == NULL) ? NULL : (var = (vala_comment_unref (var), NULL)))

#define VALA_TYPE_MEMBER_BINDING (vala_member_binding_get_type ())

#define VALA_TYPE_CREATION_METHOD (vala_creation_method_get_type ())
#define VALA_CREATION_METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CREATION_METHOD, ValaCreationMethod))
#define VALA_CREATION_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CREATION_METHOD, ValaCreationMethodClass))
#define VALA_IS_CREATION_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CREATION_METHOD))
#define VALA_IS_CREATION_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CREATION_METHOD))
#define VALA_CREATION_METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CREATION_METHOD, ValaCreationMethodClass))

typedef struct _ValaCreationMethod ValaCreationMethod;
typedef struct _ValaCreationMethodClass ValaCreationMethodClass;

#define VALA_TYPE_VOID_TYPE (vala_void_type_get_type ())
#define VALA_VOID_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_VOID_TYPE, ValaVoidType))
#define VALA_VOID_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_VOID_TYPE, ValaVoidTypeClass))
#define VALA_IS_VOID_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_VOID_TYPE))
#define VALA_IS_VOID_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_VOID_TYPE))
#define VALA_VOID_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_VOID_TYPE, ValaVoidTypeClass))

typedef struct _ValaVoidType ValaVoidType;
typedef struct _ValaVoidTypeClass ValaVoidTypeClass;

#define VALA_TYPE_CODE_CONTEXT (vala_code_context_get_type ())
#define VALA_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContext))
#define VALA_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))
#define VALA_IS_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_CONTEXT))
#define VALA_IS_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_CONTEXT))
#define VALA_CODE_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))

typedef struct _ValaCodeContext ValaCodeContext;
typedef struct _ValaCodeContextClass ValaCodeContextClass;

#define VALA_TYPE_PROFILE (vala_profile_get_type ())
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))

struct _ValaCodeNode {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCodeNodePrivate * priv;
	GList* attributes;
};

struct _ValaCodeNodeClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCodeNode *self);
	void (*accept) (ValaCodeNode* self, ValaCodeVisitor* visitor);
	void (*accept_children) (ValaCodeNode* self, ValaCodeVisitor* visitor);
	gboolean (*check) (ValaCodeNode* self, ValaSemanticAnalyzer* analyzer);
	void (*emit) (ValaCodeNode* self, ValaCodeGenerator* codegen);
	void (*replace_type) (ValaCodeNode* self, ValaDataType* old_type, ValaDataType* new_type);
	void (*replace_expression) (ValaCodeNode* self, ValaExpression* old_node, ValaExpression* new_node);
	gchar* (*to_string) (ValaCodeNode* self);
	void (*get_defined_variables) (ValaCodeNode* self, ValaCollection* collection);
	void (*get_used_variables) (ValaCodeNode* self, ValaCollection* collection);
};

struct _ValaSymbol {
	ValaCodeNode parent_instance;
	ValaSymbolPrivate * priv;
};

struct _ValaSymbolClass {
	ValaCodeNodeClass parent_class;
	gchar* (*get_cprefix) (ValaSymbol* self);
	gchar* (*get_lower_case_cname) (ValaSymbol* self, const gchar* infix);
	gchar* (*get_lower_case_cprefix) (ValaSymbol* self);
	ValaList* (*get_cheader_filenames) (ValaSymbol* self);
	gboolean (*is_instance_member) (ValaSymbol* self);
	gboolean (*is_class_member) (ValaSymbol* self);
	void (*process_deprecated_attribute) (ValaSymbol* self, ValaAttribute* attr);
	void (*add_namespace) (ValaSymbol* self, ValaNamespace* ns);
	void (*add_class) (ValaSymbol* self, ValaClass* cl);
	void (*add_interface) (ValaSymbol* self, ValaInterface* iface);
	void (*add_struct) (ValaSymbol* self, ValaStruct* st);
	void (*add_enum) (ValaSymbol* self, ValaEnum* en);
	void (*add_error_domain) (ValaSymbol* self, ValaErrorDomain* edomain);
	void (*add_delegate) (ValaSymbol* self, ValaDelegate* d);
	void (*add_constant) (ValaSymbol* self, ValaConstant* constant);
	void (*add_field) (ValaSymbol* self, ValaField* f);
	void (*add_method) (ValaSymbol* self, ValaMethod* m);
	void (*add_property) (ValaSymbol* self, ValaProperty* prop);
	void (*add_signal) (ValaSymbol* self, ValaSignal* sig);
	void (*add_constructor) (ValaSymbol* self, ValaConstructor* c);
	void (*add_destructor) (ValaSymbol* self, ValaDestructor* d);
};

struct _ValaNamespace {
	ValaSymbol parent_instance;
	ValaNamespacePrivate * priv;
};

struct _ValaNamespaceClass {
	ValaSymbolClass parent_class;
};

struct _ValaNamespacePrivate {
	ValaList* classes;
	ValaList* interfaces;
	ValaList* structs;
	ValaList* enums;
	ValaList* error_domains;
	ValaList* delegates;
	ValaList* constants;
	ValaList* fields;
	ValaList* methods;
	ValaList* comments;
	ValaList* cprefixes;
	gchar* lower_case_cprefix;
	ValaList* namespaces;
	ValaList* using_directives;
};

typedef enum  {
	VALA_SYMBOL_ACCESSIBILITY_PRIVATE,
	VALA_SYMBOL_ACCESSIBILITY_INTERNAL,
	VALA_SYMBOL_ACCESSIBILITY_PROTECTED,
	VALA_SYMBOL_ACCESSIBILITY_PUBLIC
} ValaSymbolAccessibility;

typedef enum  {
	VALA_MEMBER_BINDING_INSTANCE,
	VALA_MEMBER_BINDING_CLASS,
	VALA_MEMBER_BINDING_STATIC
} ValaMemberBinding;

typedef enum  {
	VALA_PROFILE_POSIX,
	VALA_PROFILE_GOBJECT,
	VALA_PROFILE_DOVA
} ValaProfile;


static gpointer vala_namespace_parent_class = NULL;

gpointer vala_code_node_ref (gpointer instance);
void vala_code_node_unref (gpointer instance);
GParamSpec* vala_param_spec_code_node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_node (GValue* value, gpointer v_object);
void vala_value_take_code_node (GValue* value, gpointer v_object);
gpointer vala_value_get_code_node (const GValue* value);
GType vala_code_node_get_type (void) G_GNUC_CONST;
gpointer vala_code_visitor_ref (gpointer instance);
void vala_code_visitor_unref (gpointer instance);
GParamSpec* vala_param_spec_code_visitor (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_visitor (GValue* value, gpointer v_object);
void vala_value_take_code_visitor (GValue* value, gpointer v_object);
gpointer vala_value_get_code_visitor (const GValue* value);
GType vala_code_visitor_get_type (void) G_GNUC_CONST;
GType vala_semantic_analyzer_get_type (void) G_GNUC_CONST;
GType vala_code_generator_get_type (void) G_GNUC_CONST;
GType vala_data_type_get_type (void) G_GNUC_CONST;
GType vala_expression_get_type (void) G_GNUC_CONST;
GType vala_symbol_get_type (void) G_GNUC_CONST;
GType vala_variable_get_type (void) G_GNUC_CONST;
GType vala_local_variable_get_type (void) G_GNUC_CONST;
GType vala_attribute_get_type (void) G_GNUC_CONST;
GType vala_namespace_get_type (void) G_GNUC_CONST;
GType vala_typesymbol_get_type (void) G_GNUC_CONST;
GType vala_object_type_symbol_get_type (void) G_GNUC_CONST;
GType vala_class_get_type (void) G_GNUC_CONST;
GType vala_interface_get_type (void) G_GNUC_CONST;
GType vala_struct_get_type (void) G_GNUC_CONST;
GType vala_enum_get_type (void) G_GNUC_CONST;
GType vala_error_domain_get_type (void) G_GNUC_CONST;
GType vala_delegate_get_type (void) G_GNUC_CONST;
GType vala_constant_get_type (void) G_GNUC_CONST;
GType vala_field_get_type (void) G_GNUC_CONST;
GType vala_method_get_type (void) G_GNUC_CONST;
GType vala_property_get_type (void) G_GNUC_CONST;
GType vala_signal_get_type (void) G_GNUC_CONST;
GType vala_constructor_get_type (void) G_GNUC_CONST;
GType vala_destructor_get_type (void) G_GNUC_CONST;
gpointer vala_comment_ref (gpointer instance);
void vala_comment_unref (gpointer instance);
GParamSpec* vala_param_spec_comment (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_comment (GValue* value, gpointer v_object);
void vala_value_take_comment (GValue* value, gpointer v_object);
gpointer vala_value_get_comment (const GValue* value);
GType vala_comment_get_type (void) G_GNUC_CONST;
GType vala_using_directive_get_type (void) G_GNUC_CONST;
#define VALA_NAMESPACE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_NAMESPACE, ValaNamespacePrivate))
enum  {
	VALA_NAMESPACE_DUMMY_PROPERTY
};
gpointer vala_source_reference_ref (gpointer instance);
void vala_source_reference_unref (gpointer instance);
GParamSpec* vala_param_spec_source_reference (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_reference (GValue* value, gpointer v_object);
void vala_value_take_source_reference (GValue* value, gpointer v_object);
gpointer vala_value_get_source_reference (const GValue* value);
GType vala_source_reference_get_type (void) G_GNUC_CONST;
ValaNamespace* vala_namespace_new (const gchar* name, ValaSourceReference* source_reference);
ValaNamespace* vala_namespace_construct (GType object_type, const gchar* name, ValaSourceReference* source_reference);
ValaSymbol* vala_symbol_construct (GType object_type, const gchar* name, ValaSourceReference* source_reference, ValaComment* comment);
GType vala_symbol_accessibility_get_type (void) G_GNUC_CONST;
void vala_symbol_set_access (ValaSymbol* self, ValaSymbolAccessibility value);
void vala_namespace_add_using_directive (ValaNamespace* self, ValaUsingDirective* ns);
void vala_namespace_add_comment (ValaNamespace* self, ValaComment* comment);
ValaList* vala_namespace_get_comments (ValaNamespace* self);
static void vala_namespace_real_add_namespace (ValaSymbol* base, ValaNamespace* ns);
gpointer vala_scope_ref (gpointer instance);
void vala_scope_unref (gpointer instance);
GParamSpec* vala_param_spec_scope (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_scope (GValue* value, gpointer v_object);
void vala_value_take_scope (GValue* value, gpointer v_object);
gpointer vala_value_get_scope (const GValue* value);
GType vala_scope_get_type (void) G_GNUC_CONST;
ValaScope* vala_symbol_get_owner (ValaSymbol* self);
ValaSourceReference* vala_code_node_get_source_reference (ValaCodeNode* self);
gpointer vala_source_file_ref (gpointer instance);
void vala_source_file_unref (gpointer instance);
GParamSpec* vala_param_spec_source_file (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_file (GValue* value, gpointer v_object);
void vala_value_take_source_file (GValue* value, gpointer v_object);
gpointer vala_value_get_source_file (const GValue* value);
GType vala_source_file_get_type (void) G_GNUC_CONST;
ValaSourceFile* vala_source_reference_get_file (ValaSourceReference* self);
void vala_source_file_add_node (ValaSourceFile* self, ValaCodeNode* node);
ValaScope* vala_symbol_get_scope (ValaSymbol* self);
ValaSymbol* vala_scope_lookup (ValaScope* self, const gchar* name);
const gchar* vala_symbol_get_name (ValaSymbol* self);
gboolean vala_symbol_get_external_package (ValaSymbol* self);
void vala_code_node_set_source_reference (ValaCodeNode* self, ValaSourceReference* value);
ValaList* vala_namespace_get_namespaces (ValaNamespace* self);
void vala_symbol_add_namespace (ValaSymbol* self, ValaNamespace* ns);
ValaList* vala_namespace_get_classes (ValaNamespace* self);
void vala_symbol_add_class (ValaSymbol* self, ValaClass* cl);
ValaList* vala_namespace_get_structs (ValaNamespace* self);
void vala_symbol_add_struct (ValaSymbol* self, ValaStruct* st);
ValaList* vala_namespace_get_interfaces (ValaNamespace* self);
void vala_symbol_add_interface (ValaSymbol* self, ValaInterface* iface);
ValaList* vala_namespace_get_delegates (ValaNamespace* self);
void vala_symbol_add_delegate (ValaSymbol* self, ValaDelegate* d);
ValaList* vala_namespace_get_enums (ValaNamespace* self);
void vala_symbol_add_enum (ValaSymbol* self, ValaEnum* en);
ValaList* vala_namespace_get_error_domains (ValaNamespace* self);
void vala_symbol_add_error_domain (ValaSymbol* self, ValaErrorDomain* edomain);
ValaList* vala_namespace_get_constants (ValaNamespace* self);
void vala_symbol_add_constant (ValaSymbol* self, ValaConstant* constant);
ValaList* vala_namespace_get_fields (ValaNamespace* self);
void vala_symbol_add_field (ValaSymbol* self, ValaField* f);
ValaList* vala_namespace_get_methods (ValaNamespace* self);
void vala_symbol_add_method (ValaSymbol* self, ValaMethod* m);
void vala_scope_add (ValaScope* self, const gchar* name, ValaSymbol* sym);
static void vala_namespace_real_add_class (ValaSymbol* base, ValaClass* cl);
ValaSymbolAccessibility vala_symbol_get_access (ValaSymbol* self);
static void vala_namespace_real_add_interface (ValaSymbol* base, ValaInterface* iface);
static void vala_namespace_real_add_struct (ValaSymbol* base, ValaStruct* st);
void vala_namespace_remove_struct (ValaNamespace* self, ValaStruct* st);
void vala_scope_remove (ValaScope* self, const gchar* name);
static void vala_namespace_real_add_enum (ValaSymbol* base, ValaEnum* en);
static void vala_namespace_real_add_error_domain (ValaSymbol* base, ValaErrorDomain* edomain);
static void vala_namespace_real_add_delegate (ValaSymbol* base, ValaDelegate* d);
static void vala_namespace_real_add_constant (ValaSymbol* base, ValaConstant* constant);
static void vala_namespace_real_add_field (ValaSymbol* base, ValaField* f);
GType vala_member_binding_get_type (void) G_GNUC_CONST;
ValaMemberBinding vala_field_get_binding (ValaField* self);
void vala_field_set_binding (ValaField* self, ValaMemberBinding value);
void vala_report_error (ValaSourceReference* source, const gchar* message);
void vala_code_node_set_error (ValaCodeNode* self, gboolean value);
static void vala_namespace_real_add_method (ValaSymbol* base, ValaMethod* m);
ValaMemberBinding vala_method_get_binding (ValaMethod* self);
void vala_method_set_binding (ValaMethod* self, ValaMemberBinding value);
GType vala_creation_method_get_type (void) G_GNUC_CONST;
ValaDataType* vala_method_get_return_type (ValaMethod* self);
GType vala_void_type_get_type (void) G_GNUC_CONST;
gpointer vala_code_context_ref (gpointer instance);
void vala_code_context_unref (gpointer instance);
GParamSpec* vala_param_spec_code_context (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_context (GValue* value, gpointer v_object);
void vala_value_take_code_context (GValue* value, gpointer v_object);
gpointer vala_value_get_code_context (const GValue* value);
GType vala_code_context_get_type (void) G_GNUC_CONST;
ValaCodeContext* vala_code_context_get (void);
GType vala_profile_get_type (void) G_GNUC_CONST;
ValaProfile vala_code_context_get_profile (ValaCodeContext* self);
ValaList* vala_method_get_postconditions (ValaMethod* self);
ValaDataType* vala_data_type_copy (ValaDataType* self);
ValaLocalVariable* vala_local_variable_new (ValaDataType* variable_type, const gchar* name, ValaExpression* initializer, ValaSourceReference* source_reference);
ValaLocalVariable* vala_local_variable_construct (GType object_type, ValaDataType* variable_type, const gchar* name, ValaExpression* initializer, ValaSourceReference* source_reference);
void vala_method_set_result_var (ValaMethod* self, ValaLocalVariable* value);
ValaLocalVariable* vala_method_get_result_var (ValaMethod* self);
void vala_local_variable_set_is_result (ValaLocalVariable* self, gboolean value);
static void vala_namespace_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
void vala_code_visitor_visit_namespace (ValaCodeVisitor* self, ValaNamespace* ns);
static void vala_namespace_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
void vala_code_node_accept (ValaCodeNode* self, ValaCodeVisitor* visitor);
static gchar* vala_namespace_real_get_cprefix (ValaSymbol* base);
ValaSymbol* vala_symbol_get_parent_symbol (ValaSymbol* self);
gchar* vala_symbol_get_cprefix (ValaSymbol* self);
ValaList* vala_namespace_get_cprefixes (ValaNamespace* self);
void vala_namespace_add_cprefix (ValaNamespace* self, const gchar* cprefix);
static gchar* vala_namespace_real_get_lower_case_cprefix (ValaSymbol* base);
gchar* vala_symbol_get_lower_case_cprefix (ValaSymbol* self);
gchar* vala_symbol_camel_case_to_lower_case (const gchar* camel_case);
void vala_namespace_set_lower_case_cprefix (ValaNamespace* self, const gchar* cprefix);
static void vala_namespace_process_ccode_attribute (ValaNamespace* self, ValaAttribute* a);
gboolean vala_attribute_has_argument (ValaAttribute* self, const gchar* name);
gchar* vala_attribute_get_string (ValaAttribute* self, const gchar* name);
void vala_symbol_add_cheader_filename (ValaSymbol* self, const gchar* filename);
void vala_source_file_set_gir_namespace (ValaSourceFile* self, const gchar* value);
void vala_source_file_set_gir_version (ValaSourceFile* self, const gchar* value);
void vala_namespace_process_attributes (ValaNamespace* self);
const gchar* vala_attribute_get_name (ValaAttribute* self);
static gboolean vala_namespace_real_check (ValaCodeNode* base, ValaSemanticAnalyzer* analyzer);
gboolean vala_code_node_get_checked (ValaCodeNode* self);
gboolean vala_code_node_get_error (ValaCodeNode* self);
void vala_code_node_set_checked (ValaCodeNode* self, gboolean value);
gboolean vala_code_node_check (ValaCodeNode* self, ValaSemanticAnalyzer* analyzer);
static void vala_namespace_finalize (ValaCodeNode* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


/**
 * Creates a new namespace.
 *
 * @param name             namespace name
 * @param source_reference reference to source code
 * @return                 newly created namespace
 */
ValaNamespace* vala_namespace_construct (GType object_type, const gchar* name, ValaSourceReference* source_reference) {
	ValaNamespace* self = NULL;
	self = (ValaNamespace*) vala_symbol_construct (object_type, name, source_reference, NULL);
	vala_symbol_set_access ((ValaSymbol*) self, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	return self;
}


ValaNamespace* vala_namespace_new (const gchar* name, ValaSourceReference* source_reference) {
	return vala_namespace_construct (VALA_TYPE_NAMESPACE, name, source_reference);
}


/**
 * Adds a new using directive with the specified namespace.
 *
 * @param ns reference to namespace
 */
void vala_namespace_add_using_directive (ValaNamespace* self, ValaUsingDirective* ns) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (ns != NULL);
	vala_collection_add ((ValaCollection*) self->priv->using_directives, ns);
}


void vala_namespace_add_comment (ValaNamespace* self, ValaComment* comment) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (comment != NULL);
	vala_collection_add ((ValaCollection*) self->priv->comments, comment);
}


/**
 * Returns a copy of the list of namespaces.
 *
 * @return comment list
 */
static gpointer _vala_iterable_ref0 (gpointer self) {
	return self ? vala_iterable_ref (self) : NULL;
}


ValaList* vala_namespace_get_comments (ValaNamespace* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = _vala_iterable_ref0 (self->priv->comments);
	result = _tmp0_;
	return result;
}


/**
 * Adds the specified namespace to this source file.
 *
 * @param ns a namespace
 */
static void vala_namespace_real_add_namespace (ValaSymbol* base, ValaNamespace* ns) {
	ValaNamespace * self;
	ValaScope* _tmp0_ = NULL;
	ValaScope* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	ValaSymbol* _tmp5_ = NULL;
	ValaSymbol* _tmp6_;
	gboolean _tmp7_;
	self = (ValaNamespace*) base;
	g_return_if_fail (ns != NULL);
	_tmp0_ = vala_symbol_get_owner ((ValaSymbol*) ns);
	if (_tmp0_ == NULL) {
		ValaSourceReference* _tmp1_ = NULL;
		ValaSourceFile* _tmp2_ = NULL;
		_tmp1_ = vala_code_node_get_source_reference ((ValaCodeNode*) ns);
		_tmp2_ = vala_source_reference_get_file (_tmp1_);
		vala_source_file_add_node (_tmp2_, (ValaCodeNode*) ns);
	}
	_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp4_ = vala_symbol_get_name ((ValaSymbol*) ns);
	_tmp5_ = vala_scope_lookup (_tmp3_, _tmp4_);
	_tmp6_ = _tmp5_;
	if ((_tmp7_ = VALA_IS_NAMESPACE (_tmp6_), _vala_code_node_unref0 (_tmp6_), _tmp7_)) {
		ValaScope* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		ValaSymbol* _tmp10_ = NULL;
		ValaNamespace* old_ns;
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_;
		_tmp8_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp9_ = vala_symbol_get_name ((ValaSymbol*) ns);
		_tmp10_ = vala_scope_lookup (_tmp8_, _tmp9_);
		old_ns = VALA_NAMESPACE (_tmp10_);
		_tmp12_ = vala_symbol_get_external_package ((ValaSymbol*) old_ns);
		if (_tmp12_) {
			gboolean _tmp13_;
			_tmp13_ = vala_symbol_get_external_package ((ValaSymbol*) ns);
			_tmp11_ = !_tmp13_;
		} else {
			_tmp11_ = FALSE;
		}
		if (_tmp11_) {
			ValaSourceReference* _tmp14_ = NULL;
			_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) ns);
			vala_code_node_set_source_reference ((ValaCodeNode*) old_ns, _tmp14_);
		}
		{
			ValaList* _tmp15_;
			ValaList* _using_directive_list;
			gint _tmp16_;
			gint _using_directive_size;
			gint _using_directive_index;
			_tmp15_ = _vala_iterable_ref0 (ns->priv->using_directives);
			_using_directive_list = _tmp15_;
			_tmp16_ = vala_collection_get_size ((ValaCollection*) _using_directive_list);
			_using_directive_size = _tmp16_;
			_using_directive_index = -1;
			while (TRUE) {
				gpointer _tmp17_ = NULL;
				ValaUsingDirective* using_directive;
				_using_directive_index = _using_directive_index + 1;
				if (!(_using_directive_index < _using_directive_size)) {
					break;
				}
				_tmp17_ = vala_list_get (_using_directive_list, _using_directive_index);
				using_directive = (ValaUsingDirective*) _tmp17_;
				vala_namespace_add_using_directive (old_ns, using_directive);
				_vala_code_node_unref0 (using_directive);
			}
			_vala_iterable_unref0 (_using_directive_list);
		}
		{
			ValaList* _tmp18_ = NULL;
			ValaList* _sub_ns_list;
			gint _tmp19_;
			gint _sub_ns_size;
			gint _sub_ns_index;
			_tmp18_ = vala_namespace_get_namespaces (ns);
			_sub_ns_list = _tmp18_;
			_tmp19_ = vala_collection_get_size ((ValaCollection*) _sub_ns_list);
			_sub_ns_size = _tmp19_;
			_sub_ns_index = -1;
			while (TRUE) {
				gpointer _tmp20_ = NULL;
				ValaNamespace* sub_ns;
				_sub_ns_index = _sub_ns_index + 1;
				if (!(_sub_ns_index < _sub_ns_size)) {
					break;
				}
				_tmp20_ = vala_list_get (_sub_ns_list, _sub_ns_index);
				sub_ns = (ValaNamespace*) _tmp20_;
				vala_symbol_add_namespace ((ValaSymbol*) old_ns, sub_ns);
				_vala_code_node_unref0 (sub_ns);
			}
			_vala_iterable_unref0 (_sub_ns_list);
		}
		{
			ValaList* _tmp21_ = NULL;
			ValaList* _cl_list;
			gint _tmp22_;
			gint _cl_size;
			gint _cl_index;
			_tmp21_ = vala_namespace_get_classes (ns);
			_cl_list = _tmp21_;
			_tmp22_ = vala_collection_get_size ((ValaCollection*) _cl_list);
			_cl_size = _tmp22_;
			_cl_index = -1;
			while (TRUE) {
				gpointer _tmp23_ = NULL;
				ValaClass* cl;
				_cl_index = _cl_index + 1;
				if (!(_cl_index < _cl_size)) {
					break;
				}
				_tmp23_ = vala_list_get (_cl_list, _cl_index);
				cl = (ValaClass*) _tmp23_;
				vala_symbol_add_class ((ValaSymbol*) old_ns, cl);
				_vala_code_node_unref0 (cl);
			}
			_vala_iterable_unref0 (_cl_list);
		}
		{
			ValaList* _tmp24_ = NULL;
			ValaList* _st_list;
			gint _tmp25_;
			gint _st_size;
			gint _st_index;
			_tmp24_ = vala_namespace_get_structs (ns);
			_st_list = _tmp24_;
			_tmp25_ = vala_collection_get_size ((ValaCollection*) _st_list);
			_st_size = _tmp25_;
			_st_index = -1;
			while (TRUE) {
				gpointer _tmp26_ = NULL;
				ValaStruct* st;
				_st_index = _st_index + 1;
				if (!(_st_index < _st_size)) {
					break;
				}
				_tmp26_ = vala_list_get (_st_list, _st_index);
				st = (ValaStruct*) _tmp26_;
				vala_symbol_add_struct ((ValaSymbol*) old_ns, st);
				_vala_code_node_unref0 (st);
			}
			_vala_iterable_unref0 (_st_list);
		}
		{
			ValaList* _tmp27_ = NULL;
			ValaList* _iface_list;
			gint _tmp28_;
			gint _iface_size;
			gint _iface_index;
			_tmp27_ = vala_namespace_get_interfaces (ns);
			_iface_list = _tmp27_;
			_tmp28_ = vala_collection_get_size ((ValaCollection*) _iface_list);
			_iface_size = _tmp28_;
			_iface_index = -1;
			while (TRUE) {
				gpointer _tmp29_ = NULL;
				ValaInterface* iface;
				_iface_index = _iface_index + 1;
				if (!(_iface_index < _iface_size)) {
					break;
				}
				_tmp29_ = vala_list_get (_iface_list, _iface_index);
				iface = (ValaInterface*) _tmp29_;
				vala_symbol_add_interface ((ValaSymbol*) old_ns, iface);
				_vala_code_node_unref0 (iface);
			}
			_vala_iterable_unref0 (_iface_list);
		}
		{
			ValaList* _tmp30_ = NULL;
			ValaList* _d_list;
			gint _tmp31_;
			gint _d_size;
			gint _d_index;
			_tmp30_ = vala_namespace_get_delegates (ns);
			_d_list = _tmp30_;
			_tmp31_ = vala_collection_get_size ((ValaCollection*) _d_list);
			_d_size = _tmp31_;
			_d_index = -1;
			while (TRUE) {
				gpointer _tmp32_ = NULL;
				ValaDelegate* d;
				_d_index = _d_index + 1;
				if (!(_d_index < _d_size)) {
					break;
				}
				_tmp32_ = vala_list_get (_d_list, _d_index);
				d = (ValaDelegate*) _tmp32_;
				vala_symbol_add_delegate ((ValaSymbol*) old_ns, d);
				_vala_code_node_unref0 (d);
			}
			_vala_iterable_unref0 (_d_list);
		}
		{
			ValaList* _tmp33_ = NULL;
			ValaList* _en_list;
			gint _tmp34_;
			gint _en_size;
			gint _en_index;
			_tmp33_ = vala_namespace_get_enums (ns);
			_en_list = _tmp33_;
			_tmp34_ = vala_collection_get_size ((ValaCollection*) _en_list);
			_en_size = _tmp34_;
			_en_index = -1;
			while (TRUE) {
				gpointer _tmp35_ = NULL;
				ValaEnum* en;
				_en_index = _en_index + 1;
				if (!(_en_index < _en_size)) {
					break;
				}
				_tmp35_ = vala_list_get (_en_list, _en_index);
				en = (ValaEnum*) _tmp35_;
				vala_symbol_add_enum ((ValaSymbol*) old_ns, en);
				_vala_code_node_unref0 (en);
			}
			_vala_iterable_unref0 (_en_list);
		}
		{
			ValaList* _tmp36_ = NULL;
			ValaList* _ed_list;
			gint _tmp37_;
			gint _ed_size;
			gint _ed_index;
			_tmp36_ = vala_namespace_get_error_domains (ns);
			_ed_list = _tmp36_;
			_tmp37_ = vala_collection_get_size ((ValaCollection*) _ed_list);
			_ed_size = _tmp37_;
			_ed_index = -1;
			while (TRUE) {
				gpointer _tmp38_ = NULL;
				ValaErrorDomain* ed;
				_ed_index = _ed_index + 1;
				if (!(_ed_index < _ed_size)) {
					break;
				}
				_tmp38_ = vala_list_get (_ed_list, _ed_index);
				ed = (ValaErrorDomain*) _tmp38_;
				vala_symbol_add_error_domain ((ValaSymbol*) old_ns, ed);
				_vala_code_node_unref0 (ed);
			}
			_vala_iterable_unref0 (_ed_list);
		}
		{
			ValaList* _tmp39_ = NULL;
			ValaList* _c_list;
			gint _tmp40_;
			gint _c_size;
			gint _c_index;
			_tmp39_ = vala_namespace_get_constants (ns);
			_c_list = _tmp39_;
			_tmp40_ = vala_collection_get_size ((ValaCollection*) _c_list);
			_c_size = _tmp40_;
			_c_index = -1;
			while (TRUE) {
				gpointer _tmp41_ = NULL;
				ValaConstant* c;
				_c_index = _c_index + 1;
				if (!(_c_index < _c_size)) {
					break;
				}
				_tmp41_ = vala_list_get (_c_list, _c_index);
				c = (ValaConstant*) _tmp41_;
				vala_symbol_add_constant ((ValaSymbol*) old_ns, c);
				_vala_code_node_unref0 (c);
			}
			_vala_iterable_unref0 (_c_list);
		}
		{
			ValaList* _tmp42_ = NULL;
			ValaList* _f_list;
			gint _tmp43_;
			gint _f_size;
			gint _f_index;
			_tmp42_ = vala_namespace_get_fields (ns);
			_f_list = _tmp42_;
			_tmp43_ = vala_collection_get_size ((ValaCollection*) _f_list);
			_f_size = _tmp43_;
			_f_index = -1;
			while (TRUE) {
				gpointer _tmp44_ = NULL;
				ValaField* f;
				_f_index = _f_index + 1;
				if (!(_f_index < _f_size)) {
					break;
				}
				_tmp44_ = vala_list_get (_f_list, _f_index);
				f = (ValaField*) _tmp44_;
				vala_symbol_add_field ((ValaSymbol*) old_ns, f);
				_vala_code_node_unref0 (f);
			}
			_vala_iterable_unref0 (_f_list);
		}
		{
			ValaList* _tmp45_ = NULL;
			ValaList* _m_list;
			gint _tmp46_;
			gint _m_size;
			gint _m_index;
			_tmp45_ = vala_namespace_get_methods (ns);
			_m_list = _tmp45_;
			_tmp46_ = vala_collection_get_size ((ValaCollection*) _m_list);
			_m_size = _tmp46_;
			_m_index = -1;
			while (TRUE) {
				gpointer _tmp47_ = NULL;
				ValaMethod* m;
				_m_index = _m_index + 1;
				if (!(_m_index < _m_size)) {
					break;
				}
				_tmp47_ = vala_list_get (_m_list, _m_index);
				m = (ValaMethod*) _tmp47_;
				vala_symbol_add_method ((ValaSymbol*) old_ns, m);
				_vala_code_node_unref0 (m);
			}
			_vala_iterable_unref0 (_m_list);
		}
		{
			ValaList* _tmp48_ = NULL;
			ValaList* _c_list;
			gint _tmp49_;
			gint _c_size;
			gint _c_index;
			_tmp48_ = vala_namespace_get_comments (ns);
			_c_list = _tmp48_;
			_tmp49_ = vala_collection_get_size ((ValaCollection*) _c_list);
			_c_size = _tmp49_;
			_c_index = -1;
			while (TRUE) {
				gpointer _tmp50_ = NULL;
				ValaComment* c;
				_c_index = _c_index + 1;
				if (!(_c_index < _c_size)) {
					break;
				}
				_tmp50_ = vala_list_get (_c_list, _c_index);
				c = (ValaComment*) _tmp50_;
				vala_namespace_add_comment (old_ns, c);
				_vala_comment_unref0 (c);
			}
			_vala_iterable_unref0 (_c_list);
		}
		_vala_code_node_unref0 (old_ns);
	} else {
		ValaScope* _tmp51_ = NULL;
		const gchar* _tmp52_ = NULL;
		vala_collection_add ((ValaCollection*) self->priv->namespaces, ns);
		_tmp51_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp52_ = vala_symbol_get_name ((ValaSymbol*) ns);
		vala_scope_add (_tmp51_, _tmp52_, (ValaSymbol*) ns);
	}
}


/**
 * Returns a copy of the list of namespaces.
 *
 * @return namespace list
 */
ValaList* vala_namespace_get_namespaces (ValaNamespace* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = _vala_iterable_ref0 (self->priv->namespaces);
	result = _tmp0_;
	return result;
}


/**
 * Adds the specified class to this namespace.
 *
 * @param cl a class
 */
static void vala_namespace_real_add_class (ValaSymbol* base, ValaClass* cl) {
	ValaNamespace * self;
	ValaSymbolAccessibility _tmp0_;
	ValaScope* _tmp1_ = NULL;
	ValaScope* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	self = (ValaNamespace*) base;
	g_return_if_fail (cl != NULL);
	_tmp0_ = vala_symbol_get_access ((ValaSymbol*) cl);
	if (_tmp0_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		vala_symbol_set_access ((ValaSymbol*) cl, VALA_SYMBOL_ACCESSIBILITY_INTERNAL);
	}
	_tmp1_ = vala_symbol_get_owner ((ValaSymbol*) cl);
	if (_tmp1_ == NULL) {
		ValaSourceReference* _tmp2_ = NULL;
		ValaSourceFile* _tmp3_ = NULL;
		_tmp2_ = vala_code_node_get_source_reference ((ValaCodeNode*) cl);
		_tmp3_ = vala_source_reference_get_file (_tmp2_);
		vala_source_file_add_node (_tmp3_, (ValaCodeNode*) cl);
	}
	vala_collection_add ((ValaCollection*) self->priv->classes, cl);
	_tmp4_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp5_ = vala_symbol_get_name ((ValaSymbol*) cl);
	vala_scope_add (_tmp4_, _tmp5_, (ValaSymbol*) cl);
}


/**
 * Adds the specified interface to this namespace.
 *
 * @param iface an interface
 */
static void vala_namespace_real_add_interface (ValaSymbol* base, ValaInterface* iface) {
	ValaNamespace * self;
	ValaSymbolAccessibility _tmp0_;
	ValaScope* _tmp1_ = NULL;
	ValaScope* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	self = (ValaNamespace*) base;
	g_return_if_fail (iface != NULL);
	_tmp0_ = vala_symbol_get_access ((ValaSymbol*) iface);
	if (_tmp0_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		vala_symbol_set_access ((ValaSymbol*) iface, VALA_SYMBOL_ACCESSIBILITY_INTERNAL);
	}
	_tmp1_ = vala_symbol_get_owner ((ValaSymbol*) iface);
	if (_tmp1_ == NULL) {
		ValaSourceReference* _tmp2_ = NULL;
		ValaSourceFile* _tmp3_ = NULL;
		_tmp2_ = vala_code_node_get_source_reference ((ValaCodeNode*) iface);
		_tmp3_ = vala_source_reference_get_file (_tmp2_);
		vala_source_file_add_node (_tmp3_, (ValaCodeNode*) iface);
	}
	vala_collection_add ((ValaCollection*) self->priv->interfaces, iface);
	_tmp4_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp5_ = vala_symbol_get_name ((ValaSymbol*) iface);
	vala_scope_add (_tmp4_, _tmp5_, (ValaSymbol*) iface);
}


/**
 * Adds the specified struct to this namespace.
 *
 * @param st a struct
 */
static void vala_namespace_real_add_struct (ValaSymbol* base, ValaStruct* st) {
	ValaNamespace * self;
	ValaSymbolAccessibility _tmp0_;
	ValaScope* _tmp1_ = NULL;
	ValaScope* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	self = (ValaNamespace*) base;
	g_return_if_fail (st != NULL);
	_tmp0_ = vala_symbol_get_access ((ValaSymbol*) st);
	if (_tmp0_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		vala_symbol_set_access ((ValaSymbol*) st, VALA_SYMBOL_ACCESSIBILITY_INTERNAL);
	}
	_tmp1_ = vala_symbol_get_owner ((ValaSymbol*) st);
	if (_tmp1_ == NULL) {
		ValaSourceReference* _tmp2_ = NULL;
		ValaSourceFile* _tmp3_ = NULL;
		_tmp2_ = vala_code_node_get_source_reference ((ValaCodeNode*) st);
		_tmp3_ = vala_source_reference_get_file (_tmp2_);
		vala_source_file_add_node (_tmp3_, (ValaCodeNode*) st);
	}
	vala_collection_add ((ValaCollection*) self->priv->structs, st);
	_tmp4_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp5_ = vala_symbol_get_name ((ValaSymbol*) st);
	vala_scope_add (_tmp4_, _tmp5_, (ValaSymbol*) st);
}


/**
 * Removes the specified struct from this namespace.
 *
 * @param st a struct
 */
void vala_namespace_remove_struct (ValaNamespace* self, ValaStruct* st) {
	ValaScope* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (st != NULL);
	vala_collection_remove ((ValaCollection*) self->priv->structs, st);
	_tmp0_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp1_ = vala_symbol_get_name ((ValaSymbol*) st);
	vala_scope_remove (_tmp0_, _tmp1_);
}


/**
 * Adds the specified enum to this namespace.
 *
 * @param en an enum
 */
static void vala_namespace_real_add_enum (ValaSymbol* base, ValaEnum* en) {
	ValaNamespace * self;
	ValaSymbolAccessibility _tmp0_;
	ValaScope* _tmp1_ = NULL;
	ValaScope* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	self = (ValaNamespace*) base;
	g_return_if_fail (en != NULL);
	_tmp0_ = vala_symbol_get_access ((ValaSymbol*) en);
	if (_tmp0_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		vala_symbol_set_access ((ValaSymbol*) en, VALA_SYMBOL_ACCESSIBILITY_INTERNAL);
	}
	_tmp1_ = vala_symbol_get_owner ((ValaSymbol*) en);
	if (_tmp1_ == NULL) {
		ValaSourceReference* _tmp2_ = NULL;
		ValaSourceFile* _tmp3_ = NULL;
		_tmp2_ = vala_code_node_get_source_reference ((ValaCodeNode*) en);
		_tmp3_ = vala_source_reference_get_file (_tmp2_);
		vala_source_file_add_node (_tmp3_, (ValaCodeNode*) en);
	}
	vala_collection_add ((ValaCollection*) self->priv->enums, en);
	_tmp4_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp5_ = vala_symbol_get_name ((ValaSymbol*) en);
	vala_scope_add (_tmp4_, _tmp5_, (ValaSymbol*) en);
}


/**
 * Adds the specified error domain to this namespace.
 *
 * @param edomain an error domain
 */
static void vala_namespace_real_add_error_domain (ValaSymbol* base, ValaErrorDomain* edomain) {
	ValaNamespace * self;
	ValaSymbolAccessibility _tmp0_;
	ValaScope* _tmp1_ = NULL;
	ValaScope* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	self = (ValaNamespace*) base;
	g_return_if_fail (edomain != NULL);
	_tmp0_ = vala_symbol_get_access ((ValaSymbol*) edomain);
	if (_tmp0_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		vala_symbol_set_access ((ValaSymbol*) edomain, VALA_SYMBOL_ACCESSIBILITY_INTERNAL);
	}
	_tmp1_ = vala_symbol_get_owner ((ValaSymbol*) edomain);
	if (_tmp1_ == NULL) {
		ValaSourceReference* _tmp2_ = NULL;
		ValaSourceFile* _tmp3_ = NULL;
		_tmp2_ = vala_code_node_get_source_reference ((ValaCodeNode*) edomain);
		_tmp3_ = vala_source_reference_get_file (_tmp2_);
		vala_source_file_add_node (_tmp3_, (ValaCodeNode*) edomain);
	}
	vala_collection_add ((ValaCollection*) self->priv->error_domains, edomain);
	_tmp4_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp5_ = vala_symbol_get_name ((ValaSymbol*) edomain);
	vala_scope_add (_tmp4_, _tmp5_, (ValaSymbol*) edomain);
}


/**
 * Adds the specified delegate to this namespace.
 *
 * @param d a delegate
 */
static void vala_namespace_real_add_delegate (ValaSymbol* base, ValaDelegate* d) {
	ValaNamespace * self;
	ValaSymbolAccessibility _tmp0_;
	ValaScope* _tmp1_ = NULL;
	ValaScope* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	self = (ValaNamespace*) base;
	g_return_if_fail (d != NULL);
	_tmp0_ = vala_symbol_get_access ((ValaSymbol*) d);
	if (_tmp0_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		vala_symbol_set_access ((ValaSymbol*) d, VALA_SYMBOL_ACCESSIBILITY_INTERNAL);
	}
	_tmp1_ = vala_symbol_get_owner ((ValaSymbol*) d);
	if (_tmp1_ == NULL) {
		ValaSourceReference* _tmp2_ = NULL;
		ValaSourceFile* _tmp3_ = NULL;
		_tmp2_ = vala_code_node_get_source_reference ((ValaCodeNode*) d);
		_tmp3_ = vala_source_reference_get_file (_tmp2_);
		vala_source_file_add_node (_tmp3_, (ValaCodeNode*) d);
	}
	vala_collection_add ((ValaCollection*) self->priv->delegates, d);
	_tmp4_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp5_ = vala_symbol_get_name ((ValaSymbol*) d);
	vala_scope_add (_tmp4_, _tmp5_, (ValaSymbol*) d);
}


/**
 * Returns a copy of the list of structs.
 *
 * @return struct list
 */
ValaList* vala_namespace_get_structs (ValaNamespace* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = _vala_iterable_ref0 (self->priv->structs);
	result = _tmp0_;
	return result;
}


/**
 * Returns a copy of the list of classes.
 *
 * @return class list
 */
ValaList* vala_namespace_get_classes (ValaNamespace* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = _vala_iterable_ref0 (self->priv->classes);
	result = _tmp0_;
	return result;
}


/**
 * Returns a copy of the list of interfaces.
 *
 * @return interface list
 */
ValaList* vala_namespace_get_interfaces (ValaNamespace* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = _vala_iterable_ref0 (self->priv->interfaces);
	result = _tmp0_;
	return result;
}


/**
 * Returns a copy of the list of enums.
 *
 * @return enum list
 */
ValaList* vala_namespace_get_enums (ValaNamespace* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = _vala_iterable_ref0 (self->priv->enums);
	result = _tmp0_;
	return result;
}


/**
 * Returns a copy of the list of error domains.
 *
 * @return error domain list
 */
ValaList* vala_namespace_get_error_domains (ValaNamespace* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = _vala_iterable_ref0 (self->priv->error_domains);
	result = _tmp0_;
	return result;
}


/**
 * Returns a copy of the list of fields.
 *
 * @return field list
 */
ValaList* vala_namespace_get_fields (ValaNamespace* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = _vala_iterable_ref0 (self->priv->fields);
	result = _tmp0_;
	return result;
}


/**
 * Returns a copy of the list of constants.
 *
 * @return constant list
 */
ValaList* vala_namespace_get_constants (ValaNamespace* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = _vala_iterable_ref0 (self->priv->constants);
	result = _tmp0_;
	return result;
}


/**
 * Returns a copy of the list of delegates.
 *
 * @return delegate list
 */
ValaList* vala_namespace_get_delegates (ValaNamespace* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = _vala_iterable_ref0 (self->priv->delegates);
	result = _tmp0_;
	return result;
}


/**
 * Returns a copy of the list of methods.
 *
 * @return method list
 */
ValaList* vala_namespace_get_methods (ValaNamespace* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = _vala_iterable_ref0 (self->priv->methods);
	result = _tmp0_;
	return result;
}


/**
 * Adds the specified constant to this namespace.
 *
 * @param constant a constant
 */
static void vala_namespace_real_add_constant (ValaSymbol* base, ValaConstant* constant) {
	ValaNamespace * self;
	ValaSymbolAccessibility _tmp0_;
	ValaScope* _tmp1_ = NULL;
	ValaScope* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	self = (ValaNamespace*) base;
	g_return_if_fail (constant != NULL);
	_tmp0_ = vala_symbol_get_access ((ValaSymbol*) constant);
	if (_tmp0_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		vala_symbol_set_access ((ValaSymbol*) constant, VALA_SYMBOL_ACCESSIBILITY_INTERNAL);
	}
	_tmp1_ = vala_symbol_get_owner ((ValaSymbol*) constant);
	if (_tmp1_ == NULL) {
		ValaSourceReference* _tmp2_ = NULL;
		ValaSourceFile* _tmp3_ = NULL;
		_tmp2_ = vala_code_node_get_source_reference ((ValaCodeNode*) constant);
		_tmp3_ = vala_source_reference_get_file (_tmp2_);
		vala_source_file_add_node (_tmp3_, (ValaCodeNode*) constant);
	}
	vala_collection_add ((ValaCollection*) self->priv->constants, constant);
	_tmp4_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp5_ = vala_symbol_get_name ((ValaSymbol*) constant);
	vala_scope_add (_tmp4_, _tmp5_, (ValaSymbol*) constant);
}


/**
 * Adds the specified field to this namespace.
 *
 * @param f a field
 */
static void vala_namespace_real_add_field (ValaSymbol* base, ValaField* f) {
	ValaNamespace * self;
	ValaMemberBinding _tmp0_;
	ValaSymbolAccessibility _tmp1_;
	ValaMemberBinding _tmp2_;
	ValaScope* _tmp6_ = NULL;
	ValaScope* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	self = (ValaNamespace*) base;
	g_return_if_fail (f != NULL);
	_tmp0_ = vala_field_get_binding (f);
	if (_tmp0_ == VALA_MEMBER_BINDING_INSTANCE) {
		vala_field_set_binding (f, VALA_MEMBER_BINDING_STATIC);
	}
	_tmp1_ = vala_symbol_get_access ((ValaSymbol*) f);
	if (_tmp1_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		vala_symbol_set_access ((ValaSymbol*) f, VALA_SYMBOL_ACCESSIBILITY_INTERNAL);
	}
	_tmp2_ = vala_field_get_binding (f);
	if (_tmp2_ == VALA_MEMBER_BINDING_INSTANCE) {
		ValaSourceReference* _tmp3_ = NULL;
		_tmp3_ = vala_code_node_get_source_reference ((ValaCodeNode*) f);
		vala_report_error (_tmp3_, "instance members are not allowed outside of data types");
		vala_code_node_set_error ((ValaCodeNode*) f, TRUE);
		return;
	} else {
		ValaMemberBinding _tmp4_;
		_tmp4_ = vala_field_get_binding (f);
		if (_tmp4_ == VALA_MEMBER_BINDING_CLASS) {
			ValaSourceReference* _tmp5_ = NULL;
			_tmp5_ = vala_code_node_get_source_reference ((ValaCodeNode*) f);
			vala_report_error (_tmp5_, "class members are not allowed outside of classes");
			vala_code_node_set_error ((ValaCodeNode*) f, TRUE);
			return;
		}
	}
	_tmp6_ = vala_symbol_get_owner ((ValaSymbol*) f);
	if (_tmp6_ == NULL) {
		ValaSourceReference* _tmp7_ = NULL;
		ValaSourceFile* _tmp8_ = NULL;
		_tmp7_ = vala_code_node_get_source_reference ((ValaCodeNode*) f);
		_tmp8_ = vala_source_reference_get_file (_tmp7_);
		vala_source_file_add_node (_tmp8_, (ValaCodeNode*) f);
	}
	vala_collection_add ((ValaCollection*) self->priv->fields, f);
	_tmp9_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp10_ = vala_symbol_get_name ((ValaSymbol*) f);
	vala_scope_add (_tmp9_, _tmp10_, (ValaSymbol*) f);
}


/**
 * Adds the specified method to this namespace.
 *
 * @param m a method
 */
static void vala_namespace_real_add_method (ValaSymbol* base, ValaMethod* m) {
	ValaNamespace * self;
	ValaMemberBinding _tmp0_;
	ValaSymbolAccessibility _tmp1_;
	ValaMemberBinding _tmp3_;
	gboolean _tmp7_ = FALSE;
	ValaDataType* _tmp8_ = NULL;
	ValaScope* _tmp24_ = NULL;
	ValaScope* _tmp27_ = NULL;
	const gchar* _tmp28_ = NULL;
	self = (ValaNamespace*) base;
	g_return_if_fail (m != NULL);
	_tmp0_ = vala_method_get_binding (m);
	if (_tmp0_ == VALA_MEMBER_BINDING_INSTANCE) {
		vala_method_set_binding (m, VALA_MEMBER_BINDING_STATIC);
	}
	_tmp1_ = vala_symbol_get_access ((ValaSymbol*) m);
	if (_tmp1_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		vala_symbol_set_access ((ValaSymbol*) m, VALA_SYMBOL_ACCESSIBILITY_INTERNAL);
	}
	if (VALA_IS_CREATION_METHOD (m)) {
		ValaSourceReference* _tmp2_ = NULL;
		_tmp2_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
		vala_report_error (_tmp2_, "construction methods may only be declared within classes and structs");
		vala_code_node_set_error ((ValaCodeNode*) m, TRUE);
		return;
	}
	_tmp3_ = vala_method_get_binding (m);
	if (_tmp3_ == VALA_MEMBER_BINDING_INSTANCE) {
		ValaSourceReference* _tmp4_ = NULL;
		_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
		vala_report_error (_tmp4_, "instance members are not allowed outside of data types");
		vala_code_node_set_error ((ValaCodeNode*) m, TRUE);
		return;
	} else {
		ValaMemberBinding _tmp5_;
		_tmp5_ = vala_method_get_binding (m);
		if (_tmp5_ == VALA_MEMBER_BINDING_CLASS) {
			ValaSourceReference* _tmp6_ = NULL;
			_tmp6_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
			vala_report_error (_tmp6_, "class members are not allowed outside of classes");
			vala_code_node_set_error ((ValaCodeNode*) m, TRUE);
			return;
		}
	}
	_tmp8_ = vala_method_get_return_type (m);
	if (!VALA_IS_VOID_TYPE (_tmp8_)) {
		gboolean _tmp9_ = FALSE;
		ValaCodeContext* _tmp10_ = NULL;
		ValaCodeContext* _tmp11_;
		ValaProfile _tmp12_;
		gboolean _tmp13_;
		_tmp10_ = vala_code_context_get ();
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_code_context_get_profile (_tmp11_);
		if ((_tmp13_ = _tmp12_ == VALA_PROFILE_DOVA, _vala_code_context_unref0 (_tmp11_), _tmp13_)) {
			_tmp9_ = TRUE;
		} else {
			ValaList* _tmp14_ = NULL;
			ValaList* _tmp15_;
			gint _tmp16_;
			_tmp14_ = vala_method_get_postconditions (m);
			_tmp15_ = _tmp14_;
			_tmp16_ = vala_collection_get_size ((ValaCollection*) _tmp15_);
			_tmp9_ = _tmp16_ > 0;
			_vala_iterable_unref0 (_tmp15_);
		}
		_tmp7_ = _tmp9_;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		ValaDataType* _tmp17_ = NULL;
		ValaDataType* _tmp18_ = NULL;
		ValaDataType* _tmp19_;
		ValaSourceReference* _tmp20_ = NULL;
		ValaLocalVariable* _tmp21_ = NULL;
		ValaLocalVariable* _tmp22_;
		ValaLocalVariable* _tmp23_ = NULL;
		_tmp17_ = vala_method_get_return_type (m);
		_tmp18_ = vala_data_type_copy (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp21_ = vala_local_variable_new (_tmp19_, "result", NULL, _tmp20_);
		_tmp22_ = _tmp21_;
		vala_method_set_result_var (m, _tmp22_);
		_vala_code_node_unref0 (_tmp22_);
		_vala_code_node_unref0 (_tmp19_);
		_tmp23_ = vala_method_get_result_var (m);
		vala_local_variable_set_is_result (_tmp23_, TRUE);
	}
	_tmp24_ = vala_symbol_get_owner ((ValaSymbol*) m);
	if (_tmp24_ == NULL) {
		ValaSourceReference* _tmp25_ = NULL;
		ValaSourceFile* _tmp26_ = NULL;
		_tmp25_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
		_tmp26_ = vala_source_reference_get_file (_tmp25_);
		vala_source_file_add_node (_tmp26_, (ValaCodeNode*) m);
	}
	vala_collection_add ((ValaCollection*) self->priv->methods, m);
	_tmp27_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp28_ = vala_symbol_get_name ((ValaSymbol*) m);
	vala_scope_add (_tmp27_, _tmp28_, (ValaSymbol*) m);
}


static void vala_namespace_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaNamespace * self;
	self = (ValaNamespace*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_namespace (visitor, self);
}


static void vala_namespace_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaNamespace * self;
	self = (ValaNamespace*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _tmp0_;
		ValaList* _ns_ref_list;
		gint _tmp1_;
		gint _ns_ref_size;
		gint _ns_ref_index;
		_tmp0_ = _vala_iterable_ref0 (self->priv->using_directives);
		_ns_ref_list = _tmp0_;
		_tmp1_ = vala_collection_get_size ((ValaCollection*) _ns_ref_list);
		_ns_ref_size = _tmp1_;
		_ns_ref_index = -1;
		while (TRUE) {
			gpointer _tmp2_ = NULL;
			ValaUsingDirective* ns_ref;
			_ns_ref_index = _ns_ref_index + 1;
			if (!(_ns_ref_index < _ns_ref_size)) {
				break;
			}
			_tmp2_ = vala_list_get (_ns_ref_list, _ns_ref_index);
			ns_ref = (ValaUsingDirective*) _tmp2_;
			vala_code_node_accept ((ValaCodeNode*) ns_ref, visitor);
			_vala_code_node_unref0 (ns_ref);
		}
		_vala_iterable_unref0 (_ns_ref_list);
	}
	{
		ValaList* _tmp3_;
		ValaList* _ns_list;
		gint _tmp4_;
		gint _ns_size;
		gint _ns_index;
		_tmp3_ = _vala_iterable_ref0 (self->priv->namespaces);
		_ns_list = _tmp3_;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _ns_list);
		_ns_size = _tmp4_;
		_ns_index = -1;
		while (TRUE) {
			gpointer _tmp5_ = NULL;
			ValaNamespace* ns;
			_ns_index = _ns_index + 1;
			if (!(_ns_index < _ns_size)) {
				break;
			}
			_tmp5_ = vala_list_get (_ns_list, _ns_index);
			ns = (ValaNamespace*) _tmp5_;
			vala_code_node_accept ((ValaCodeNode*) ns, visitor);
			_vala_code_node_unref0 (ns);
		}
		_vala_iterable_unref0 (_ns_list);
	}
	{
		ValaList* _tmp6_;
		ValaList* _en_list;
		gint _tmp7_;
		gint _en_size;
		gint _en_index;
		_tmp6_ = _vala_iterable_ref0 (self->priv->enums);
		_en_list = _tmp6_;
		_tmp7_ = vala_collection_get_size ((ValaCollection*) _en_list);
		_en_size = _tmp7_;
		_en_index = -1;
		while (TRUE) {
			gpointer _tmp8_ = NULL;
			ValaEnum* en;
			_en_index = _en_index + 1;
			if (!(_en_index < _en_size)) {
				break;
			}
			_tmp8_ = vala_list_get (_en_list, _en_index);
			en = (ValaEnum*) _tmp8_;
			vala_code_node_accept ((ValaCodeNode*) en, visitor);
			_vala_code_node_unref0 (en);
		}
		_vala_iterable_unref0 (_en_list);
	}
	{
		ValaList* _tmp9_;
		ValaList* _edomain_list;
		gint _tmp10_;
		gint _edomain_size;
		gint _edomain_index;
		_tmp9_ = _vala_iterable_ref0 (self->priv->error_domains);
		_edomain_list = _tmp9_;
		_tmp10_ = vala_collection_get_size ((ValaCollection*) _edomain_list);
		_edomain_size = _tmp10_;
		_edomain_index = -1;
		while (TRUE) {
			gpointer _tmp11_ = NULL;
			ValaErrorDomain* edomain;
			_edomain_index = _edomain_index + 1;
			if (!(_edomain_index < _edomain_size)) {
				break;
			}
			_tmp11_ = vala_list_get (_edomain_list, _edomain_index);
			edomain = (ValaErrorDomain*) _tmp11_;
			vala_code_node_accept ((ValaCodeNode*) edomain, visitor);
			_vala_code_node_unref0 (edomain);
		}
		_vala_iterable_unref0 (_edomain_list);
	}
	{
		ValaList* _tmp12_;
		ValaList* _cl_list;
		gint _tmp13_;
		gint _cl_size;
		gint _cl_index;
		_tmp12_ = _vala_iterable_ref0 (self->priv->classes);
		_cl_list = _tmp12_;
		_tmp13_ = vala_collection_get_size ((ValaCollection*) _cl_list);
		_cl_size = _tmp13_;
		_cl_index = -1;
		while (TRUE) {
			gpointer _tmp14_ = NULL;
			ValaClass* cl;
			_cl_index = _cl_index + 1;
			if (!(_cl_index < _cl_size)) {
				break;
			}
			_tmp14_ = vala_list_get (_cl_list, _cl_index);
			cl = (ValaClass*) _tmp14_;
			vala_code_node_accept ((ValaCodeNode*) cl, visitor);
			_vala_code_node_unref0 (cl);
		}
		_vala_iterable_unref0 (_cl_list);
	}
	{
		ValaList* _tmp15_;
		ValaList* _iface_list;
		gint _tmp16_;
		gint _iface_size;
		gint _iface_index;
		_tmp15_ = _vala_iterable_ref0 (self->priv->interfaces);
		_iface_list = _tmp15_;
		_tmp16_ = vala_collection_get_size ((ValaCollection*) _iface_list);
		_iface_size = _tmp16_;
		_iface_index = -1;
		while (TRUE) {
			gpointer _tmp17_ = NULL;
			ValaInterface* iface;
			_iface_index = _iface_index + 1;
			if (!(_iface_index < _iface_size)) {
				break;
			}
			_tmp17_ = vala_list_get (_iface_list, _iface_index);
			iface = (ValaInterface*) _tmp17_;
			vala_code_node_accept ((ValaCodeNode*) iface, visitor);
			_vala_code_node_unref0 (iface);
		}
		_vala_iterable_unref0 (_iface_list);
	}
	{
		ValaList* _tmp18_;
		ValaList* _st_list;
		gint _tmp19_;
		gint _st_size;
		gint _st_index;
		_tmp18_ = _vala_iterable_ref0 (self->priv->structs);
		_st_list = _tmp18_;
		_tmp19_ = vala_collection_get_size ((ValaCollection*) _st_list);
		_st_size = _tmp19_;
		_st_index = -1;
		while (TRUE) {
			gpointer _tmp20_ = NULL;
			ValaStruct* st;
			_st_index = _st_index + 1;
			if (!(_st_index < _st_size)) {
				break;
			}
			_tmp20_ = vala_list_get (_st_list, _st_index);
			st = (ValaStruct*) _tmp20_;
			vala_code_node_accept ((ValaCodeNode*) st, visitor);
			_vala_code_node_unref0 (st);
		}
		_vala_iterable_unref0 (_st_list);
	}
	{
		ValaList* _tmp21_;
		ValaList* _d_list;
		gint _tmp22_;
		gint _d_size;
		gint _d_index;
		_tmp21_ = _vala_iterable_ref0 (self->priv->delegates);
		_d_list = _tmp21_;
		_tmp22_ = vala_collection_get_size ((ValaCollection*) _d_list);
		_d_size = _tmp22_;
		_d_index = -1;
		while (TRUE) {
			gpointer _tmp23_ = NULL;
			ValaDelegate* d;
			_d_index = _d_index + 1;
			if (!(_d_index < _d_size)) {
				break;
			}
			_tmp23_ = vala_list_get (_d_list, _d_index);
			d = (ValaDelegate*) _tmp23_;
			vala_code_node_accept ((ValaCodeNode*) d, visitor);
			_vala_code_node_unref0 (d);
		}
		_vala_iterable_unref0 (_d_list);
	}
	{
		ValaList* _tmp24_;
		ValaList* _c_list;
		gint _tmp25_;
		gint _c_size;
		gint _c_index;
		_tmp24_ = _vala_iterable_ref0 (self->priv->constants);
		_c_list = _tmp24_;
		_tmp25_ = vala_collection_get_size ((ValaCollection*) _c_list);
		_c_size = _tmp25_;
		_c_index = -1;
		while (TRUE) {
			gpointer _tmp26_ = NULL;
			ValaConstant* c;
			_c_index = _c_index + 1;
			if (!(_c_index < _c_size)) {
				break;
			}
			_tmp26_ = vala_list_get (_c_list, _c_index);
			c = (ValaConstant*) _tmp26_;
			vala_code_node_accept ((ValaCodeNode*) c, visitor);
			_vala_code_node_unref0 (c);
		}
		_vala_iterable_unref0 (_c_list);
	}
	{
		ValaList* _tmp27_;
		ValaList* _f_list;
		gint _tmp28_;
		gint _f_size;
		gint _f_index;
		_tmp27_ = _vala_iterable_ref0 (self->priv->fields);
		_f_list = _tmp27_;
		_tmp28_ = vala_collection_get_size ((ValaCollection*) _f_list);
		_f_size = _tmp28_;
		_f_index = -1;
		while (TRUE) {
			gpointer _tmp29_ = NULL;
			ValaField* f;
			_f_index = _f_index + 1;
			if (!(_f_index < _f_size)) {
				break;
			}
			_tmp29_ = vala_list_get (_f_list, _f_index);
			f = (ValaField*) _tmp29_;
			vala_code_node_accept ((ValaCodeNode*) f, visitor);
			_vala_code_node_unref0 (f);
		}
		_vala_iterable_unref0 (_f_list);
	}
	{
		ValaList* _tmp30_;
		ValaList* _m_list;
		gint _tmp31_;
		gint _m_size;
		gint _m_index;
		_tmp30_ = _vala_iterable_ref0 (self->priv->methods);
		_m_list = _tmp30_;
		_tmp31_ = vala_collection_get_size ((ValaCollection*) _m_list);
		_m_size = _tmp31_;
		_m_index = -1;
		while (TRUE) {
			gpointer _tmp32_ = NULL;
			ValaMethod* m;
			_m_index = _m_index + 1;
			if (!(_m_index < _m_size)) {
				break;
			}
			_tmp32_ = vala_list_get (_m_list, _m_index);
			m = (ValaMethod*) _tmp32_;
			vala_code_node_accept ((ValaCodeNode*) m, visitor);
			_vala_code_node_unref0 (m);
		}
		_vala_iterable_unref0 (_m_list);
	}
}


static gchar* vala_namespace_real_get_cprefix (ValaSymbol* base) {
	ValaNamespace * self;
	gchar* result = NULL;
	gint _tmp0_;
	self = (ValaNamespace*) base;
	_tmp0_ = vala_collection_get_size ((ValaCollection*) self->priv->cprefixes);
	if (_tmp0_ > 0) {
		gpointer _tmp1_ = NULL;
		_tmp1_ = vala_list_get (self->priv->cprefixes, 0);
		result = (gchar*) _tmp1_;
		return result;
	} else {
		const gchar* _tmp2_ = NULL;
		_tmp2_ = vala_symbol_get_name ((ValaSymbol*) self);
		if (NULL != _tmp2_) {
			gchar* parent_prefix;
			ValaSymbol* _tmp3_ = NULL;
			const gchar* _tmp9_ = NULL;
			parent_prefix = NULL;
			_tmp3_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			if (_tmp3_ == NULL) {
				gchar* _tmp4_;
				gchar* _tmp5_;
				_tmp4_ = g_strdup ("");
				_tmp5_ = _tmp4_;
				_g_free0 (parent_prefix);
				parent_prefix = _tmp5_;
			} else {
				ValaSymbol* _tmp6_ = NULL;
				gchar* _tmp7_ = NULL;
				gchar* _tmp8_;
				_tmp6_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
				_tmp7_ = vala_symbol_get_cprefix (_tmp6_);
				_tmp8_ = _tmp7_;
				_g_free0 (parent_prefix);
				parent_prefix = _tmp8_;
			}
			_tmp9_ = vala_symbol_get_name ((ValaSymbol*) self);
			result = g_strconcat (parent_prefix, _tmp9_, NULL);
			_g_free0 (parent_prefix);
			return result;
		} else {
			gchar* _tmp10_;
			_tmp10_ = g_strdup ("");
			result = _tmp10_;
			return result;
		}
	}
}


ValaList* vala_namespace_get_cprefixes (ValaNamespace* self) {
	ValaList* result = NULL;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	ValaList* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = vala_collection_get_size ((ValaCollection*) self->priv->cprefixes);
	if (0 == _tmp1_) {
		const gchar* _tmp2_ = NULL;
		_tmp2_ = vala_symbol_get_name ((ValaSymbol*) self);
		_tmp0_ = NULL != _tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		const gchar* _tmp3_ = NULL;
		_tmp3_ = vala_symbol_get_name ((ValaSymbol*) self);
		vala_collection_add ((ValaCollection*) self->priv->cprefixes, _tmp3_);
	}
	_tmp4_ = _vala_iterable_ref0 (self->priv->cprefixes);
	result = _tmp4_;
	return result;
}


/**
 * Adds a camel case string to be prepended to the name of members of
 * this namespace when used in C code.
 *
 * @param cprefixes the camel case prefixes used in C code
 */
void vala_namespace_add_cprefix (ValaNamespace* self, const gchar* cprefix) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (cprefix != NULL);
	vala_collection_add ((ValaCollection*) self->priv->cprefixes, cprefix);
}


/**
 * Returns the lower case string to be prepended to the name of members
 * of this namespace when used in C code.
 *
 * @return the lower case prefix to be used in C code
 */
static gchar* vala_namespace_real_get_lower_case_cprefix (ValaSymbol* base) {
	ValaNamespace * self;
	gchar* result = NULL;
	gchar* _tmp14_;
	self = (ValaNamespace*) base;
	if (self->priv->lower_case_cprefix == NULL) {
		const gchar* _tmp0_ = NULL;
		_tmp0_ = vala_symbol_get_name ((ValaSymbol*) self);
		if (_tmp0_ == NULL) {
			gchar* _tmp1_;
			gchar* _tmp2_;
			_tmp1_ = g_strdup ("");
			_tmp2_ = _tmp1_;
			_g_free0 (self->priv->lower_case_cprefix);
			self->priv->lower_case_cprefix = _tmp2_;
		} else {
			gchar* parent_prefix;
			ValaSymbol* _tmp3_ = NULL;
			const gchar* _tmp9_ = NULL;
			gchar* _tmp10_ = NULL;
			gchar* _tmp11_;
			gchar* _tmp12_ = NULL;
			gchar* _tmp13_;
			parent_prefix = NULL;
			_tmp3_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			if (_tmp3_ == NULL) {
				gchar* _tmp4_;
				gchar* _tmp5_;
				_tmp4_ = g_strdup ("");
				_tmp5_ = _tmp4_;
				_g_free0 (parent_prefix);
				parent_prefix = _tmp5_;
			} else {
				ValaSymbol* _tmp6_ = NULL;
				gchar* _tmp7_ = NULL;
				gchar* _tmp8_;
				_tmp6_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
				_tmp7_ = vala_symbol_get_lower_case_cprefix (_tmp6_);
				_tmp8_ = _tmp7_;
				_g_free0 (parent_prefix);
				parent_prefix = _tmp8_;
			}
			_tmp9_ = vala_symbol_get_name ((ValaSymbol*) self);
			_tmp10_ = vala_symbol_camel_case_to_lower_case (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = g_strdup_printf ("%s%s_", parent_prefix, _tmp11_);
			_tmp13_ = _tmp12_;
			_g_free0 (self->priv->lower_case_cprefix);
			self->priv->lower_case_cprefix = _tmp13_;
			_g_free0 (_tmp11_);
			_g_free0 (parent_prefix);
		}
	}
	_tmp14_ = g_strdup (self->priv->lower_case_cprefix);
	result = _tmp14_;
	return result;
}


/**
 * Sets the lower case string to be prepended to the name of members of
 * this namespace when used in C code.
 *
 * @param cprefix the lower case prefix to be used in C code
 */
void vala_namespace_set_lower_case_cprefix (ValaNamespace* self, const gchar* cprefix) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cprefix != NULL);
	_tmp0_ = g_strdup (cprefix);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->lower_case_cprefix);
	self->priv->lower_case_cprefix = _tmp1_;
}


static void vala_namespace_process_ccode_attribute (ValaNamespace* self, ValaAttribute* a) {
	gboolean _tmp0_;
	gboolean _tmp5_;
	gboolean _tmp8_;
	gboolean _tmp13_;
	gboolean _tmp18_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (a != NULL);
	_tmp0_ = vala_attribute_has_argument (a, "cprefix");
	if (_tmp0_) {
		gchar* _tmp1_ = NULL;
		gchar* value;
		_tmp1_ = vala_attribute_get_string (a, "cprefix");
		value = _tmp1_;
		if (g_strcmp0 (value, "") == 0) {
			vala_namespace_add_cprefix (self, "");
		} else {
			gchar** _tmp2_;
			gchar** _tmp3_ = NULL;
			_tmp3_ = _tmp2_ = g_strsplit (value, ",", 0);
			{
				gchar** name_collection;
				int name_collection_length1;
				int name_it;
				name_collection = _tmp3_;
				name_collection_length1 = _vala_array_length (_tmp2_);
				for (name_it = 0; name_it < _vala_array_length (_tmp2_); name_it = name_it + 1) {
					gchar* _tmp4_;
					gchar* name;
					_tmp4_ = g_strdup (name_collection[name_it]);
					name = _tmp4_;
					{
						vala_namespace_add_cprefix (self, name);
						_g_free0 (name);
					}
				}
				name_collection = (_vala_array_free (name_collection, name_collection_length1, (GDestroyNotify) g_free), NULL);
			}
		}
		_g_free0 (value);
	}
	_tmp5_ = vala_attribute_has_argument (a, "lower_case_cprefix");
	if (_tmp5_) {
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		_tmp6_ = vala_attribute_get_string (a, "lower_case_cprefix");
		_tmp7_ = _tmp6_;
		vala_namespace_set_lower_case_cprefix (self, _tmp7_);
		_g_free0 (_tmp7_);
	}
	_tmp8_ = vala_attribute_has_argument (a, "cheader_filename");
	if (_tmp8_) {
		gchar* _tmp9_ = NULL;
		gchar* val;
		gchar** _tmp10_;
		gchar** _tmp11_ = NULL;
		_tmp9_ = vala_attribute_get_string (a, "cheader_filename");
		val = _tmp9_;
		_tmp11_ = _tmp10_ = g_strsplit (val, ",", 0);
		{
			gchar** filename_collection;
			int filename_collection_length1;
			int filename_it;
			filename_collection = _tmp11_;
			filename_collection_length1 = _vala_array_length (_tmp10_);
			for (filename_it = 0; filename_it < _vala_array_length (_tmp10_); filename_it = filename_it + 1) {
				gchar* _tmp12_;
				gchar* filename;
				_tmp12_ = g_strdup (filename_collection[filename_it]);
				filename = _tmp12_;
				{
					vala_symbol_add_cheader_filename ((ValaSymbol*) self, filename);
					_g_free0 (filename);
				}
			}
			filename_collection = (_vala_array_free (filename_collection, filename_collection_length1, (GDestroyNotify) g_free), NULL);
		}
		_g_free0 (val);
	}
	_tmp13_ = vala_attribute_has_argument (a, "gir_namespace");
	if (_tmp13_) {
		ValaSourceReference* _tmp14_ = NULL;
		ValaSourceFile* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_;
		_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp15_ = vala_source_reference_get_file (_tmp14_);
		_tmp16_ = vala_attribute_get_string (a, "gir_namespace");
		_tmp17_ = _tmp16_;
		vala_source_file_set_gir_namespace (_tmp15_, _tmp17_);
		_g_free0 (_tmp17_);
	}
	_tmp18_ = vala_attribute_has_argument (a, "gir_version");
	if (_tmp18_) {
		ValaSourceReference* _tmp19_ = NULL;
		ValaSourceFile* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		gchar* _tmp22_;
		_tmp19_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp20_ = vala_source_reference_get_file (_tmp19_);
		_tmp21_ = vala_attribute_get_string (a, "gir_version");
		_tmp22_ = _tmp21_;
		vala_source_file_set_gir_version (_tmp20_, _tmp22_);
		_g_free0 (_tmp22_);
	}
}


/**
 * Process all associated attributes.
 */
static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


void vala_namespace_process_attributes (ValaNamespace* self) {
	g_return_if_fail (self != NULL);
	{
		GList* a_collection;
		GList* a_it;
		a_collection = ((ValaCodeNode*) self)->attributes;
		for (a_it = a_collection; a_it != NULL; a_it = a_it->next) {
			ValaAttribute* _tmp0_;
			ValaAttribute* a;
			_tmp0_ = _vala_code_node_ref0 ((ValaAttribute*) a_it->data);
			a = _tmp0_;
			{
				const gchar* _tmp1_ = NULL;
				_tmp1_ = vala_attribute_get_name (a);
				if (g_strcmp0 (_tmp1_, "CCode") == 0) {
					vala_namespace_process_ccode_attribute (self, a);
				}
				_vala_code_node_unref0 (a);
			}
		}
	}
}


static gboolean vala_namespace_real_check (ValaCodeNode* base, ValaSemanticAnalyzer* analyzer) {
	ValaNamespace * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp5_;
	self = (ValaNamespace*) base;
	g_return_val_if_fail (analyzer != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	if (_tmp0_) {
		gboolean _tmp1_;
		_tmp1_ = vala_code_node_get_error ((ValaCodeNode*) self);
		result = !_tmp1_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	vala_namespace_process_attributes (self);
	{
		ValaList* _tmp2_;
		ValaList* _ns_list;
		gint _tmp3_;
		gint _ns_size;
		gint _ns_index;
		_tmp2_ = _vala_iterable_ref0 (self->priv->namespaces);
		_ns_list = _tmp2_;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _ns_list);
		_ns_size = _tmp3_;
		_ns_index = -1;
		while (TRUE) {
			gpointer _tmp4_ = NULL;
			ValaNamespace* ns;
			_ns_index = _ns_index + 1;
			if (!(_ns_index < _ns_size)) {
				break;
			}
			_tmp4_ = vala_list_get (_ns_list, _ns_index);
			ns = (ValaNamespace*) _tmp4_;
			vala_code_node_check ((ValaCodeNode*) ns, analyzer);
			_vala_code_node_unref0 (ns);
		}
		_vala_iterable_unref0 (_ns_list);
	}
	_tmp5_ = vala_code_node_get_error ((ValaCodeNode*) self);
	result = !_tmp5_;
	return result;
}


static void vala_namespace_class_init (ValaNamespaceClass * klass) {
	vala_namespace_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->finalize = vala_namespace_finalize;
	g_type_class_add_private (klass, sizeof (ValaNamespacePrivate));
	VALA_SYMBOL_CLASS (klass)->add_namespace = vala_namespace_real_add_namespace;
	VALA_SYMBOL_CLASS (klass)->add_class = vala_namespace_real_add_class;
	VALA_SYMBOL_CLASS (klass)->add_interface = vala_namespace_real_add_interface;
	VALA_SYMBOL_CLASS (klass)->add_struct = vala_namespace_real_add_struct;
	VALA_SYMBOL_CLASS (klass)->add_enum = vala_namespace_real_add_enum;
	VALA_SYMBOL_CLASS (klass)->add_error_domain = vala_namespace_real_add_error_domain;
	VALA_SYMBOL_CLASS (klass)->add_delegate = vala_namespace_real_add_delegate;
	VALA_SYMBOL_CLASS (klass)->add_constant = vala_namespace_real_add_constant;
	VALA_SYMBOL_CLASS (klass)->add_field = vala_namespace_real_add_field;
	VALA_SYMBOL_CLASS (klass)->add_method = vala_namespace_real_add_method;
	VALA_CODE_NODE_CLASS (klass)->accept = vala_namespace_real_accept;
	VALA_CODE_NODE_CLASS (klass)->accept_children = vala_namespace_real_accept_children;
	VALA_SYMBOL_CLASS (klass)->get_cprefix = vala_namespace_real_get_cprefix;
	VALA_SYMBOL_CLASS (klass)->get_lower_case_cprefix = vala_namespace_real_get_lower_case_cprefix;
	VALA_CODE_NODE_CLASS (klass)->check = vala_namespace_real_check;
}


static void vala_namespace_instance_init (ValaNamespace * self) {
	ValaArrayList* _tmp0_ = NULL;
	ValaArrayList* _tmp1_ = NULL;
	ValaArrayList* _tmp2_ = NULL;
	ValaArrayList* _tmp3_ = NULL;
	ValaArrayList* _tmp4_ = NULL;
	ValaArrayList* _tmp5_ = NULL;
	ValaArrayList* _tmp6_ = NULL;
	ValaArrayList* _tmp7_ = NULL;
	ValaArrayList* _tmp8_ = NULL;
	ValaArrayList* _tmp9_ = NULL;
	ValaArrayList* _tmp10_ = NULL;
	ValaArrayList* _tmp11_ = NULL;
	ValaArrayList* _tmp12_ = NULL;
	self->priv = VALA_NAMESPACE_GET_PRIVATE (self);
	_tmp0_ = vala_array_list_new (VALA_TYPE_CLASS, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->classes = (ValaList*) _tmp0_;
	_tmp1_ = vala_array_list_new (VALA_TYPE_INTERFACE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->interfaces = (ValaList*) _tmp1_;
	_tmp2_ = vala_array_list_new (VALA_TYPE_STRUCT, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->structs = (ValaList*) _tmp2_;
	_tmp3_ = vala_array_list_new (VALA_TYPE_ENUM, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->enums = (ValaList*) _tmp3_;
	_tmp4_ = vala_array_list_new (VALA_TYPE_ERROR_DOMAIN, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->error_domains = (ValaList*) _tmp4_;
	_tmp5_ = vala_array_list_new (VALA_TYPE_DELEGATE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->delegates = (ValaList*) _tmp5_;
	_tmp6_ = vala_array_list_new (VALA_TYPE_CONSTANT, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->constants = (ValaList*) _tmp6_;
	_tmp7_ = vala_array_list_new (VALA_TYPE_FIELD, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->fields = (ValaList*) _tmp7_;
	_tmp8_ = vala_array_list_new (VALA_TYPE_METHOD, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->methods = (ValaList*) _tmp8_;
	_tmp9_ = vala_array_list_new (VALA_TYPE_COMMENT, (GBoxedCopyFunc) vala_comment_ref, vala_comment_unref, g_direct_equal);
	self->priv->comments = (ValaList*) _tmp9_;
	_tmp10_ = vala_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_direct_equal);
	self->priv->cprefixes = (ValaList*) _tmp10_;
	_tmp11_ = vala_array_list_new (VALA_TYPE_NAMESPACE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->namespaces = (ValaList*) _tmp11_;
	_tmp12_ = vala_array_list_new (VALA_TYPE_USING_DIRECTIVE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->using_directives = (ValaList*) _tmp12_;
}


static void vala_namespace_finalize (ValaCodeNode* obj) {
	ValaNamespace * self;
	self = VALA_NAMESPACE (obj);
	_vala_iterable_unref0 (self->priv->classes);
	_vala_iterable_unref0 (self->priv->interfaces);
	_vala_iterable_unref0 (self->priv->structs);
	_vala_iterable_unref0 (self->priv->enums);
	_vala_iterable_unref0 (self->priv->error_domains);
	_vala_iterable_unref0 (self->priv->delegates);
	_vala_iterable_unref0 (self->priv->constants);
	_vala_iterable_unref0 (self->priv->fields);
	_vala_iterable_unref0 (self->priv->methods);
	_vala_iterable_unref0 (self->priv->comments);
	_vala_iterable_unref0 (self->priv->cprefixes);
	_g_free0 (self->priv->lower_case_cprefix);
	_vala_iterable_unref0 (self->priv->namespaces);
	_vala_iterable_unref0 (self->priv->using_directives);
	VALA_CODE_NODE_CLASS (vala_namespace_parent_class)->finalize (obj);
}


/**
 * Represents a namespace declaration in the source code.
 */
GType vala_namespace_get_type (void) {
	static volatile gsize vala_namespace_type_id__volatile = 0;
	if (g_once_init_enter (&vala_namespace_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaNamespaceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_namespace_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaNamespace), 0, (GInstanceInitFunc) vala_namespace_instance_init, NULL };
		GType vala_namespace_type_id;
		vala_namespace_type_id = g_type_register_static (VALA_TYPE_SYMBOL, "ValaNamespace", &g_define_type_info, 0);
		g_once_init_leave (&vala_namespace_type_id__volatile, vala_namespace_type_id);
	}
	return vala_namespace_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



