/* valafield.c generated by valac, the Vala compiler
 * generated from valafield.vala, do not modify */

/* valafield.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>


#define VALA_TYPE_CODE_NODE (vala_code_node_get_type ())
#define VALA_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_NODE, ValaCodeNode))
#define VALA_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))
#define VALA_IS_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_NODE))
#define VALA_IS_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_NODE))
#define VALA_CODE_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))

typedef struct _ValaCodeNode ValaCodeNode;
typedef struct _ValaCodeNodeClass ValaCodeNodeClass;
typedef struct _ValaCodeNodePrivate ValaCodeNodePrivate;

#define VALA_TYPE_CODE_VISITOR (vala_code_visitor_get_type ())
#define VALA_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitor))
#define VALA_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))
#define VALA_IS_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_VISITOR))
#define VALA_IS_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_VISITOR))
#define VALA_CODE_VISITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))

typedef struct _ValaCodeVisitor ValaCodeVisitor;
typedef struct _ValaCodeVisitorClass ValaCodeVisitorClass;

#define VALA_TYPE_SEMANTIC_ANALYZER (vala_semantic_analyzer_get_type ())
#define VALA_SEMANTIC_ANALYZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzer))
#define VALA_SEMANTIC_ANALYZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzerClass))
#define VALA_IS_SEMANTIC_ANALYZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SEMANTIC_ANALYZER))
#define VALA_IS_SEMANTIC_ANALYZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SEMANTIC_ANALYZER))
#define VALA_SEMANTIC_ANALYZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzerClass))

typedef struct _ValaSemanticAnalyzer ValaSemanticAnalyzer;
typedef struct _ValaSemanticAnalyzerClass ValaSemanticAnalyzerClass;

#define VALA_TYPE_CODE_GENERATOR (vala_code_generator_get_type ())
#define VALA_CODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_GENERATOR, ValaCodeGenerator))
#define VALA_CODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_GENERATOR, ValaCodeGeneratorClass))
#define VALA_IS_CODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_GENERATOR))
#define VALA_IS_CODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_GENERATOR))
#define VALA_CODE_GENERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_GENERATOR, ValaCodeGeneratorClass))

typedef struct _ValaCodeGenerator ValaCodeGenerator;
typedef struct _ValaCodeGeneratorClass ValaCodeGeneratorClass;

#define VALA_TYPE_DATA_TYPE (vala_data_type_get_type ())
#define VALA_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DATA_TYPE, ValaDataType))
#define VALA_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))
#define VALA_IS_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DATA_TYPE))
#define VALA_IS_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DATA_TYPE))
#define VALA_DATA_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))

typedef struct _ValaDataType ValaDataType;
typedef struct _ValaDataTypeClass ValaDataTypeClass;

#define VALA_TYPE_EXPRESSION (vala_expression_get_type ())
#define VALA_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_EXPRESSION, ValaExpression))
#define VALA_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_EXPRESSION, ValaExpressionClass))
#define VALA_IS_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_EXPRESSION))
#define VALA_IS_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_EXPRESSION))
#define VALA_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_EXPRESSION, ValaExpressionClass))

typedef struct _ValaExpression ValaExpression;
typedef struct _ValaExpressionClass ValaExpressionClass;

#define VALA_TYPE_SYMBOL (vala_symbol_get_type ())
#define VALA_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SYMBOL, ValaSymbol))
#define VALA_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SYMBOL, ValaSymbolClass))
#define VALA_IS_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SYMBOL))
#define VALA_IS_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SYMBOL))
#define VALA_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SYMBOL, ValaSymbolClass))

typedef struct _ValaSymbol ValaSymbol;
typedef struct _ValaSymbolClass ValaSymbolClass;

#define VALA_TYPE_VARIABLE (vala_variable_get_type ())
#define VALA_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_VARIABLE, ValaVariable))
#define VALA_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_VARIABLE, ValaVariableClass))
#define VALA_IS_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_VARIABLE))
#define VALA_IS_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_VARIABLE))
#define VALA_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_VARIABLE, ValaVariableClass))

typedef struct _ValaVariable ValaVariable;
typedef struct _ValaVariableClass ValaVariableClass;

#define VALA_TYPE_LOCAL_VARIABLE (vala_local_variable_get_type ())
#define VALA_LOCAL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable))
#define VALA_LOCAL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariableClass))
#define VALA_IS_LOCAL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_LOCAL_VARIABLE))
#define VALA_IS_LOCAL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_LOCAL_VARIABLE))
#define VALA_LOCAL_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariableClass))

typedef struct _ValaLocalVariable ValaLocalVariable;
typedef struct _ValaLocalVariableClass ValaLocalVariableClass;

#define VALA_TYPE_ATTRIBUTE (vala_attribute_get_type ())
#define VALA_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ATTRIBUTE, ValaAttribute))
#define VALA_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))
#define VALA_IS_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ATTRIBUTE))
#define VALA_IS_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ATTRIBUTE))
#define VALA_ATTRIBUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))

typedef struct _ValaAttribute ValaAttribute;
typedef struct _ValaAttributeClass ValaAttributeClass;
typedef struct _ValaSymbolPrivate ValaSymbolPrivate;

#define VALA_TYPE_NAMESPACE (vala_namespace_get_type ())
#define VALA_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_NAMESPACE, ValaNamespace))
#define VALA_NAMESPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_NAMESPACE, ValaNamespaceClass))
#define VALA_IS_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_NAMESPACE))
#define VALA_IS_NAMESPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_NAMESPACE))
#define VALA_NAMESPACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_NAMESPACE, ValaNamespaceClass))

typedef struct _ValaNamespace ValaNamespace;
typedef struct _ValaNamespaceClass ValaNamespaceClass;

#define VALA_TYPE_TYPESYMBOL (vala_typesymbol_get_type ())
#define VALA_TYPESYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPESYMBOL, ValaTypeSymbol))
#define VALA_TYPESYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPESYMBOL, ValaTypeSymbolClass))
#define VALA_IS_TYPESYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPESYMBOL))
#define VALA_IS_TYPESYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPESYMBOL))
#define VALA_TYPESYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPESYMBOL, ValaTypeSymbolClass))

typedef struct _ValaTypeSymbol ValaTypeSymbol;
typedef struct _ValaTypeSymbolClass ValaTypeSymbolClass;

#define VALA_TYPE_OBJECT_TYPE_SYMBOL (vala_object_type_symbol_get_type ())
#define VALA_OBJECT_TYPE_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol))
#define VALA_OBJECT_TYPE_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbolClass))
#define VALA_IS_OBJECT_TYPE_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL))
#define VALA_IS_OBJECT_TYPE_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_OBJECT_TYPE_SYMBOL))
#define VALA_OBJECT_TYPE_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbolClass))

typedef struct _ValaObjectTypeSymbol ValaObjectTypeSymbol;
typedef struct _ValaObjectTypeSymbolClass ValaObjectTypeSymbolClass;

#define VALA_TYPE_CLASS (vala_class_get_type ())
#define VALA_CLASS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CLASS, ValaClass))
#define VALA_CLASS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CLASS, ValaClassClass))
#define VALA_IS_CLASS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CLASS))
#define VALA_IS_CLASS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CLASS))
#define VALA_CLASS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CLASS, ValaClassClass))

typedef struct _ValaClass ValaClass;
typedef struct _ValaClassClass ValaClassClass;

#define VALA_TYPE_INTERFACE (vala_interface_get_type ())
#define VALA_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_INTERFACE, ValaInterface))
#define VALA_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_INTERFACE, ValaInterfaceClass))
#define VALA_IS_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_INTERFACE))
#define VALA_IS_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_INTERFACE))
#define VALA_INTERFACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_INTERFACE, ValaInterfaceClass))

typedef struct _ValaInterface ValaInterface;
typedef struct _ValaInterfaceClass ValaInterfaceClass;

#define VALA_TYPE_STRUCT (vala_struct_get_type ())
#define VALA_STRUCT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_STRUCT, ValaStruct))
#define VALA_STRUCT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_STRUCT, ValaStructClass))
#define VALA_IS_STRUCT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_STRUCT))
#define VALA_IS_STRUCT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_STRUCT))
#define VALA_STRUCT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_STRUCT, ValaStructClass))

typedef struct _ValaStruct ValaStruct;
typedef struct _ValaStructClass ValaStructClass;

#define VALA_TYPE_ENUM (vala_enum_get_type ())
#define VALA_ENUM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ENUM, ValaEnum))
#define VALA_ENUM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ENUM, ValaEnumClass))
#define VALA_IS_ENUM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ENUM))
#define VALA_IS_ENUM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ENUM))
#define VALA_ENUM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ENUM, ValaEnumClass))

typedef struct _ValaEnum ValaEnum;
typedef struct _ValaEnumClass ValaEnumClass;

#define VALA_TYPE_ERROR_DOMAIN (vala_error_domain_get_type ())
#define VALA_ERROR_DOMAIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ERROR_DOMAIN, ValaErrorDomain))
#define VALA_ERROR_DOMAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ERROR_DOMAIN, ValaErrorDomainClass))
#define VALA_IS_ERROR_DOMAIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ERROR_DOMAIN))
#define VALA_IS_ERROR_DOMAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ERROR_DOMAIN))
#define VALA_ERROR_DOMAIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ERROR_DOMAIN, ValaErrorDomainClass))

typedef struct _ValaErrorDomain ValaErrorDomain;
typedef struct _ValaErrorDomainClass ValaErrorDomainClass;

#define VALA_TYPE_DELEGATE (vala_delegate_get_type ())
#define VALA_DELEGATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DELEGATE, ValaDelegate))
#define VALA_DELEGATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DELEGATE, ValaDelegateClass))
#define VALA_IS_DELEGATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DELEGATE))
#define VALA_IS_DELEGATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DELEGATE))
#define VALA_DELEGATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DELEGATE, ValaDelegateClass))

typedef struct _ValaDelegate ValaDelegate;
typedef struct _ValaDelegateClass ValaDelegateClass;

#define VALA_TYPE_CONSTANT (vala_constant_get_type ())
#define VALA_CONSTANT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CONSTANT, ValaConstant))
#define VALA_CONSTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CONSTANT, ValaConstantClass))
#define VALA_IS_CONSTANT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CONSTANT))
#define VALA_IS_CONSTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CONSTANT))
#define VALA_CONSTANT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CONSTANT, ValaConstantClass))

typedef struct _ValaConstant ValaConstant;
typedef struct _ValaConstantClass ValaConstantClass;

#define VALA_TYPE_FIELD (vala_field_get_type ())
#define VALA_FIELD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_FIELD, ValaField))
#define VALA_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_FIELD, ValaFieldClass))
#define VALA_IS_FIELD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_FIELD))
#define VALA_IS_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_FIELD))
#define VALA_FIELD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_FIELD, ValaFieldClass))

typedef struct _ValaField ValaField;
typedef struct _ValaFieldClass ValaFieldClass;

#define VALA_TYPE_METHOD (vala_method_get_type ())
#define VALA_METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_METHOD, ValaMethod))
#define VALA_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_METHOD, ValaMethodClass))
#define VALA_IS_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_METHOD))
#define VALA_IS_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_METHOD))
#define VALA_METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_METHOD, ValaMethodClass))

typedef struct _ValaMethod ValaMethod;
typedef struct _ValaMethodClass ValaMethodClass;

#define VALA_TYPE_PROPERTY (vala_property_get_type ())
#define VALA_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_PROPERTY, ValaProperty))
#define VALA_PROPERTY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_PROPERTY, ValaPropertyClass))
#define VALA_IS_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_PROPERTY))
#define VALA_IS_PROPERTY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_PROPERTY))
#define VALA_PROPERTY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_PROPERTY, ValaPropertyClass))

typedef struct _ValaProperty ValaProperty;
typedef struct _ValaPropertyClass ValaPropertyClass;

#define VALA_TYPE_SIGNAL (vala_signal_get_type ())
#define VALA_SIGNAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SIGNAL, ValaSignal))
#define VALA_SIGNAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SIGNAL, ValaSignalClass))
#define VALA_IS_SIGNAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SIGNAL))
#define VALA_IS_SIGNAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SIGNAL))
#define VALA_SIGNAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SIGNAL, ValaSignalClass))

typedef struct _ValaSignal ValaSignal;
typedef struct _ValaSignalClass ValaSignalClass;

#define VALA_TYPE_CONSTRUCTOR (vala_constructor_get_type ())
#define VALA_CONSTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CONSTRUCTOR, ValaConstructor))
#define VALA_CONSTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CONSTRUCTOR, ValaConstructorClass))
#define VALA_IS_CONSTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CONSTRUCTOR))
#define VALA_IS_CONSTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CONSTRUCTOR))
#define VALA_CONSTRUCTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CONSTRUCTOR, ValaConstructorClass))

typedef struct _ValaConstructor ValaConstructor;
typedef struct _ValaConstructorClass ValaConstructorClass;

#define VALA_TYPE_DESTRUCTOR (vala_destructor_get_type ())
#define VALA_DESTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DESTRUCTOR, ValaDestructor))
#define VALA_DESTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DESTRUCTOR, ValaDestructorClass))
#define VALA_IS_DESTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DESTRUCTOR))
#define VALA_IS_DESTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DESTRUCTOR))
#define VALA_DESTRUCTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DESTRUCTOR, ValaDestructorClass))

typedef struct _ValaDestructor ValaDestructor;
typedef struct _ValaDestructorClass ValaDestructorClass;
typedef struct _ValaVariablePrivate ValaVariablePrivate;

#define VALA_TYPE_LOCKABLE (vala_lockable_get_type ())
#define VALA_LOCKABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_LOCKABLE, ValaLockable))
#define VALA_IS_LOCKABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_LOCKABLE))
#define VALA_LOCKABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), VALA_TYPE_LOCKABLE, ValaLockableIface))

typedef struct _ValaLockable ValaLockable;
typedef struct _ValaLockableIface ValaLockableIface;
typedef struct _ValaFieldPrivate ValaFieldPrivate;

#define VALA_TYPE_MEMBER_BINDING (vala_member_binding_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))

#define VALA_TYPE_SOURCE_REFERENCE (vala_source_reference_get_type ())
#define VALA_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReference))
#define VALA_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))
#define VALA_IS_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_IS_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_SOURCE_REFERENCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))

typedef struct _ValaSourceReference ValaSourceReference;
typedef struct _ValaSourceReferenceClass ValaSourceReferenceClass;

#define VALA_TYPE_COMMENT (vala_comment_get_type ())
#define VALA_COMMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_COMMENT, ValaComment))
#define VALA_COMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_COMMENT, ValaCommentClass))
#define VALA_IS_COMMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_COMMENT))
#define VALA_IS_COMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_COMMENT))
#define VALA_COMMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_COMMENT, ValaCommentClass))

typedef struct _ValaComment ValaComment;
typedef struct _ValaCommentClass ValaCommentClass;
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))

#define VALA_TYPE_SOURCE_FILE (vala_source_file_get_type ())
#define VALA_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFile))
#define VALA_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))
#define VALA_IS_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_FILE))
#define VALA_IS_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_FILE))
#define VALA_SOURCE_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))

typedef struct _ValaSourceFile ValaSourceFile;
typedef struct _ValaSourceFileClass ValaSourceFileClass;

#define VALA_TYPE_VOID_TYPE (vala_void_type_get_type ())
#define VALA_VOID_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_VOID_TYPE, ValaVoidType))
#define VALA_VOID_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_VOID_TYPE, ValaVoidTypeClass))
#define VALA_IS_VOID_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_VOID_TYPE))
#define VALA_IS_VOID_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_VOID_TYPE))
#define VALA_VOID_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_VOID_TYPE, ValaVoidTypeClass))

typedef struct _ValaVoidType ValaVoidType;
typedef struct _ValaVoidTypeClass ValaVoidTypeClass;
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))

struct _ValaCodeNode {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCodeNodePrivate * priv;
	GList* attributes;
};

struct _ValaCodeNodeClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCodeNode *self);
	void (*accept) (ValaCodeNode* self, ValaCodeVisitor* visitor);
	void (*accept_children) (ValaCodeNode* self, ValaCodeVisitor* visitor);
	gboolean (*check) (ValaCodeNode* self, ValaSemanticAnalyzer* analyzer);
	void (*emit) (ValaCodeNode* self, ValaCodeGenerator* codegen);
	void (*replace_type) (ValaCodeNode* self, ValaDataType* old_type, ValaDataType* new_type);
	void (*replace_expression) (ValaCodeNode* self, ValaExpression* old_node, ValaExpression* new_node);
	gchar* (*to_string) (ValaCodeNode* self);
	void (*get_defined_variables) (ValaCodeNode* self, ValaCollection* collection);
	void (*get_used_variables) (ValaCodeNode* self, ValaCollection* collection);
};

struct _ValaSymbol {
	ValaCodeNode parent_instance;
	ValaSymbolPrivate * priv;
};

struct _ValaSymbolClass {
	ValaCodeNodeClass parent_class;
	gchar* (*get_cprefix) (ValaSymbol* self);
	gchar* (*get_lower_case_cname) (ValaSymbol* self, const gchar* infix);
	gchar* (*get_lower_case_cprefix) (ValaSymbol* self);
	ValaList* (*get_cheader_filenames) (ValaSymbol* self);
	gboolean (*is_instance_member) (ValaSymbol* self);
	gboolean (*is_class_member) (ValaSymbol* self);
	void (*process_deprecated_attribute) (ValaSymbol* self, ValaAttribute* attr);
	void (*add_namespace) (ValaSymbol* self, ValaNamespace* ns);
	void (*add_class) (ValaSymbol* self, ValaClass* cl);
	void (*add_interface) (ValaSymbol* self, ValaInterface* iface);
	void (*add_struct) (ValaSymbol* self, ValaStruct* st);
	void (*add_enum) (ValaSymbol* self, ValaEnum* en);
	void (*add_error_domain) (ValaSymbol* self, ValaErrorDomain* edomain);
	void (*add_delegate) (ValaSymbol* self, ValaDelegate* d);
	void (*add_constant) (ValaSymbol* self, ValaConstant* constant);
	void (*add_field) (ValaSymbol* self, ValaField* f);
	void (*add_method) (ValaSymbol* self, ValaMethod* m);
	void (*add_property) (ValaSymbol* self, ValaProperty* prop);
	void (*add_signal) (ValaSymbol* self, ValaSignal* sig);
	void (*add_constructor) (ValaSymbol* self, ValaConstructor* c);
	void (*add_destructor) (ValaSymbol* self, ValaDestructor* d);
};

struct _ValaVariable {
	ValaSymbol parent_instance;
	ValaVariablePrivate * priv;
};

struct _ValaVariableClass {
	ValaSymbolClass parent_class;
};

struct _ValaLockableIface {
	GTypeInterface parent_iface;
	gboolean (*get_lock_used) (ValaLockable* self);
	void (*set_lock_used) (ValaLockable* self, gboolean used);
};

struct _ValaField {
	ValaVariable parent_instance;
	ValaFieldPrivate * priv;
};

struct _ValaFieldClass {
	ValaVariableClass parent_class;
};

typedef enum  {
	VALA_MEMBER_BINDING_INSTANCE,
	VALA_MEMBER_BINDING_CLASS,
	VALA_MEMBER_BINDING_STATIC
} ValaMemberBinding;

struct _ValaFieldPrivate {
	ValaMemberBinding _binding;
	gboolean _is_volatile;
	gboolean _no_array_length;
	gboolean _no_delegate_target;
	gboolean _array_null_terminated;
	gchar* _array_length_type;
	gchar* array_length_cname;
	gchar* array_length_cexpr;
	gchar* cname;
	gboolean lock_used;
};


static gpointer vala_field_parent_class = NULL;
static ValaLockableIface* vala_field_vala_lockable_parent_iface = NULL;

gpointer vala_code_node_ref (gpointer instance);
void vala_code_node_unref (gpointer instance);
GParamSpec* vala_param_spec_code_node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_node (GValue* value, gpointer v_object);
void vala_value_take_code_node (GValue* value, gpointer v_object);
gpointer vala_value_get_code_node (const GValue* value);
GType vala_code_node_get_type (void) G_GNUC_CONST;
gpointer vala_code_visitor_ref (gpointer instance);
void vala_code_visitor_unref (gpointer instance);
GParamSpec* vala_param_spec_code_visitor (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_visitor (GValue* value, gpointer v_object);
void vala_value_take_code_visitor (GValue* value, gpointer v_object);
gpointer vala_value_get_code_visitor (const GValue* value);
GType vala_code_visitor_get_type (void) G_GNUC_CONST;
GType vala_semantic_analyzer_get_type (void) G_GNUC_CONST;
GType vala_code_generator_get_type (void) G_GNUC_CONST;
GType vala_data_type_get_type (void) G_GNUC_CONST;
GType vala_expression_get_type (void) G_GNUC_CONST;
GType vala_symbol_get_type (void) G_GNUC_CONST;
GType vala_variable_get_type (void) G_GNUC_CONST;
GType vala_local_variable_get_type (void) G_GNUC_CONST;
GType vala_attribute_get_type (void) G_GNUC_CONST;
GType vala_namespace_get_type (void) G_GNUC_CONST;
GType vala_typesymbol_get_type (void) G_GNUC_CONST;
GType vala_object_type_symbol_get_type (void) G_GNUC_CONST;
GType vala_class_get_type (void) G_GNUC_CONST;
GType vala_interface_get_type (void) G_GNUC_CONST;
GType vala_struct_get_type (void) G_GNUC_CONST;
GType vala_enum_get_type (void) G_GNUC_CONST;
GType vala_error_domain_get_type (void) G_GNUC_CONST;
GType vala_delegate_get_type (void) G_GNUC_CONST;
GType vala_constant_get_type (void) G_GNUC_CONST;
GType vala_field_get_type (void) G_GNUC_CONST;
GType vala_method_get_type (void) G_GNUC_CONST;
GType vala_property_get_type (void) G_GNUC_CONST;
GType vala_signal_get_type (void) G_GNUC_CONST;
GType vala_constructor_get_type (void) G_GNUC_CONST;
GType vala_destructor_get_type (void) G_GNUC_CONST;
GType vala_lockable_get_type (void) G_GNUC_CONST;
GType vala_member_binding_get_type (void) G_GNUC_CONST;
#define VALA_FIELD_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_FIELD, ValaFieldPrivate))
enum  {
	VALA_FIELD_DUMMY_PROPERTY
};
gpointer vala_source_reference_ref (gpointer instance);
void vala_source_reference_unref (gpointer instance);
GParamSpec* vala_param_spec_source_reference (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_reference (GValue* value, gpointer v_object);
void vala_value_take_source_reference (GValue* value, gpointer v_object);
gpointer vala_value_get_source_reference (const GValue* value);
GType vala_source_reference_get_type (void) G_GNUC_CONST;
gpointer vala_comment_ref (gpointer instance);
void vala_comment_unref (gpointer instance);
GParamSpec* vala_param_spec_comment (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_comment (GValue* value, gpointer v_object);
void vala_value_take_comment (GValue* value, gpointer v_object);
gpointer vala_value_get_comment (const GValue* value);
GType vala_comment_get_type (void) G_GNUC_CONST;
ValaField* vala_field_new (const gchar* name, ValaDataType* variable_type, ValaExpression* initializer, ValaSourceReference* source_reference, ValaComment* comment);
ValaField* vala_field_construct (GType object_type, const gchar* name, ValaDataType* variable_type, ValaExpression* initializer, ValaSourceReference* source_reference, ValaComment* comment);
ValaVariable* vala_variable_new (ValaDataType* variable_type, const gchar* name, ValaExpression* initializer, ValaSourceReference* source_reference, ValaComment* comment);
ValaVariable* vala_variable_construct (GType object_type, ValaDataType* variable_type, const gchar* name, ValaExpression* initializer, ValaSourceReference* source_reference, ValaComment* comment);
static void vala_field_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
void vala_code_visitor_visit_field (ValaCodeVisitor* self, ValaField* f);
static void vala_field_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
ValaDataType* vala_variable_get_variable_type (ValaVariable* self);
void vala_code_node_accept (ValaCodeNode* self, ValaCodeVisitor* visitor);
ValaExpression* vala_variable_get_initializer (ValaVariable* self);
gchar* vala_field_get_cname (ValaField* self);
gchar* vala_field_get_default_cname (ValaField* self);
void vala_field_set_cname (ValaField* self, const gchar* cname);
ValaMemberBinding vala_field_get_binding (ValaField* self);
ValaSymbol* vala_symbol_get_parent_symbol (ValaSymbol* self);
gchar* vala_symbol_get_lower_case_cprefix (ValaSymbol* self);
const gchar* vala_symbol_get_name (ValaSymbol* self);
gchar* vala_field_get_array_length_cname (ValaField* self);
void vala_field_set_array_length_cname (ValaField* self, const gchar* array_length_cname);
gchar* vala_field_get_array_length_cexpr (ValaField* self);
void vala_field_set_array_length_cexpr (ValaField* self, const gchar* array_length_cexpr);
static void vala_field_process_ccode_attribute (ValaField* self, ValaAttribute* a);
gboolean vala_attribute_has_argument (ValaAttribute* self, const gchar* name);
gchar* vala_attribute_get_string (ValaAttribute* self, const gchar* name);
void vala_symbol_add_cheader_filename (ValaSymbol* self, const gchar* filename);
gboolean vala_attribute_get_bool (ValaAttribute* self, const gchar* name);
void vala_field_set_no_array_length (ValaField* self, gboolean value);
void vala_field_set_array_null_terminated (ValaField* self, gboolean value);
void vala_field_set_array_length_type (ValaField* self, const gchar* value);
void vala_field_set_no_delegate_target (ValaField* self, gboolean value);
void vala_field_process_attributes (ValaField* self);
const gchar* vala_attribute_get_name (ValaAttribute* self);
void vala_symbol_process_deprecated_attribute (ValaSymbol* self, ValaAttribute* attr);
static gboolean vala_field_real_get_lock_used (ValaLockable* base);
static void vala_field_real_set_lock_used (ValaLockable* base, gboolean used);
static void vala_field_real_replace_expression (ValaCodeNode* base, ValaExpression* old_node, ValaExpression* new_node);
void vala_variable_set_initializer (ValaVariable* self, ValaExpression* value);
static void vala_field_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type);
void vala_variable_set_variable_type (ValaVariable* self, ValaDataType* value);
gchar* vala_field_get_ctype (ValaField* self);
ValaAttribute* vala_code_node_get_attribute (ValaCodeNode* self, const gchar* name);
void vala_field_set_ctype (ValaField* self, const gchar* ctype);
ValaAttribute* vala_attribute_new (const gchar* name, ValaSourceReference* source_reference);
ValaAttribute* vala_attribute_construct (GType object_type, const gchar* name, ValaSourceReference* source_reference);
void vala_attribute_add_argument (ValaAttribute* self, const gchar* key, const gchar* value);
static gboolean vala_field_real_check (ValaCodeNode* base, ValaSemanticAnalyzer* analyzer);
gboolean vala_code_node_get_checked (ValaCodeNode* self);
gboolean vala_code_node_get_error (ValaCodeNode* self);
void vala_code_node_set_checked (ValaCodeNode* self, gboolean value);
gpointer vala_source_file_ref (gpointer instance);
void vala_source_file_unref (gpointer instance);
GParamSpec* vala_param_spec_source_file (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_file (GValue* value, gpointer v_object);
void vala_value_take_source_file (GValue* value, gpointer v_object);
gpointer vala_value_get_source_file (const GValue* value);
GType vala_source_file_get_type (void) G_GNUC_CONST;
ValaSourceFile* vala_semantic_analyzer_get_current_source_file (ValaSemanticAnalyzer* self);
ValaSymbol* vala_semantic_analyzer_get_current_symbol (ValaSemanticAnalyzer* self);
ValaSourceReference* vala_code_node_get_source_reference (ValaCodeNode* self);
ValaSourceFile* vala_source_reference_get_file (ValaSourceReference* self);
void vala_semantic_analyzer_set_current_source_file (ValaSemanticAnalyzer* self, ValaSourceFile* value);
void vala_semantic_analyzer_set_current_symbol (ValaSemanticAnalyzer* self, ValaSymbol* value);
GType vala_void_type_get_type (void) G_GNUC_CONST;
void vala_code_node_set_error (ValaCodeNode* self, gboolean value);
void vala_report_error (ValaSourceReference* source, const gchar* message);
gboolean vala_code_node_check (ValaCodeNode* self, ValaSemanticAnalyzer* analyzer);
gboolean vala_semantic_analyzer_is_type_accessible (ValaSemanticAnalyzer* self, ValaSymbol* sym, ValaDataType* type);
gchar* vala_code_node_to_string (ValaCodeNode* self);
gchar* vala_symbol_get_full_name (ValaSymbol* self);
void vala_expression_set_target_type (ValaExpression* self, ValaDataType* value);
ValaDataType* vala_expression_get_value_type (ValaExpression* self);
gboolean vala_data_type_compatible (ValaDataType* self, ValaDataType* target_type);
gboolean vala_symbol_get_external (ValaSymbol* self);
gboolean vala_symbol_is_internal_symbol (ValaSymbol* self);
gboolean vala_class_get_is_compact (ValaClass* self);
gboolean vala_symbol_get_external_package (ValaSymbol* self);
gboolean vala_symbol_get_hides (ValaSymbol* self);
ValaSymbol* vala_symbol_get_hidden_member (ValaSymbol* self);
void vala_report_warning (ValaSourceReference* source, const gchar* message);
void vala_field_set_binding (ValaField* self, ValaMemberBinding value);
gboolean vala_field_get_is_volatile (ValaField* self);
void vala_field_set_is_volatile (ValaField* self, gboolean value);
gboolean vala_field_get_no_array_length (ValaField* self);
gboolean vala_field_get_no_delegate_target (ValaField* self);
gboolean vala_field_get_array_null_terminated (ValaField* self);
gboolean vala_field_get_has_array_length_cname (ValaField* self);
gboolean vala_field_get_has_array_length_cexpr (ValaField* self);
const gchar* vala_field_get_array_length_type (ValaField* self);
static void vala_field_finalize (ValaCodeNode* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


/**
 * Creates a new field.
 *
 * @param name   field name
 * @param type   field type
 * @param init   initializer expression
 * @param source reference to source code
 * @return       newly created field
 */
ValaField* vala_field_construct (GType object_type, const gchar* name, ValaDataType* variable_type, ValaExpression* initializer, ValaSourceReference* source_reference, ValaComment* comment) {
	ValaField* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (variable_type != NULL, NULL);
	self = (ValaField*) vala_variable_construct (object_type, variable_type, name, initializer, source_reference, comment);
	return self;
}


ValaField* vala_field_new (const gchar* name, ValaDataType* variable_type, ValaExpression* initializer, ValaSourceReference* source_reference, ValaComment* comment) {
	return vala_field_construct (VALA_TYPE_FIELD, name, variable_type, initializer, source_reference, comment);
}


static void vala_field_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaField * self;
	self = (ValaField*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_field (visitor, self);
}


static void vala_field_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaField * self;
	ValaDataType* _tmp0_ = NULL;
	ValaExpression* _tmp1_ = NULL;
	self = (ValaField*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_variable_get_variable_type ((ValaVariable*) self);
	vala_code_node_accept ((ValaCodeNode*) _tmp0_, visitor);
	_tmp1_ = vala_variable_get_initializer ((ValaVariable*) self);
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_ = NULL;
		_tmp2_ = vala_variable_get_initializer ((ValaVariable*) self);
		vala_code_node_accept ((ValaCodeNode*) _tmp2_, visitor);
	}
}


/**
 * Returns the name of this field as it is used in C code.
 *
 * @return the name to be used in C code
 */
gchar* vala_field_get_cname (ValaField* self) {
	gchar* result = NULL;
	gchar* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->cname == NULL) {
		gchar* _tmp0_ = NULL;
		gchar* _tmp1_;
		_tmp0_ = vala_field_get_default_cname (self);
		_tmp1_ = _tmp0_;
		_g_free0 (self->priv->cname);
		self->priv->cname = _tmp1_;
	}
	_tmp2_ = g_strdup (self->priv->cname);
	result = _tmp2_;
	return result;
}


/**
 * Sets the name of this field as it is used in C code.
 *
 * @param cname the name to be used in C code
 */
void vala_field_set_cname (ValaField* self, const gchar* cname) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cname != NULL);
	_tmp0_ = g_strdup (cname);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->cname);
	self->priv->cname = _tmp1_;
}


/**
 * Returns the default name of this field as it is used in C code.
 *
 * @return the name to be used in C code by default
 */
gchar* vala_field_get_default_cname (ValaField* self) {
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->_binding == VALA_MEMBER_BINDING_STATIC) {
		ValaSymbol* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
		_tmp0_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp1_ = vala_symbol_get_lower_case_cprefix (_tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = vala_symbol_get_name ((ValaSymbol*) self);
		result = (_tmp4_ = g_strconcat (_tmp2_, _tmp3_, NULL), _g_free0 (_tmp2_), _tmp4_);
		return result;
	} else {
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		_tmp5_ = vala_symbol_get_name ((ValaSymbol*) self);
		_tmp6_ = g_strdup (_tmp5_);
		result = _tmp6_;
		return result;
	}
}


/**
 * Returns the name of the array length field as it is used in C code
 *
 * @return the name of the array length field to be used in C code
 */
gchar* vala_field_get_array_length_cname (ValaField* self) {
	gchar* result = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self->priv->array_length_cname);
	result = _tmp0_;
	return result;
}


/**
 * Sets the name of the array length field as it is used in C code
 *
 * @param array_length_cname the name of the array length field to be
 * used in C code
 */
void vala_field_set_array_length_cname (ValaField* self, const gchar* array_length_cname) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (array_length_cname);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->array_length_cname);
	self->priv->array_length_cname = _tmp1_;
}


/**
 * Returns the array length expression as it is used in C code
 *
 * @return the array length expression to be used in C code
 */
gchar* vala_field_get_array_length_cexpr (ValaField* self) {
	gchar* result = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self->priv->array_length_cexpr);
	result = _tmp0_;
	return result;
}


/**
 * Sets the array length expression as it is used in C code
 *
 * @param array_length_cexpr the array length expression to be used in C
 * code
 */
void vala_field_set_array_length_cexpr (ValaField* self, const gchar* array_length_cexpr) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (array_length_cexpr);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->array_length_cexpr);
	self->priv->array_length_cexpr = _tmp1_;
}


static void vala_field_process_ccode_attribute (ValaField* self, ValaAttribute* a) {
	gboolean _tmp0_;
	gboolean _tmp3_;
	gboolean _tmp8_;
	gboolean _tmp10_;
	gboolean _tmp12_;
	gboolean _tmp15_;
	gboolean _tmp18_;
	gboolean _tmp21_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (a != NULL);
	_tmp0_ = vala_attribute_has_argument (a, "cname");
	if (_tmp0_) {
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		_tmp1_ = vala_attribute_get_string (a, "cname");
		_tmp2_ = _tmp1_;
		vala_field_set_cname (self, _tmp2_);
		_g_free0 (_tmp2_);
	}
	_tmp3_ = vala_attribute_has_argument (a, "cheader_filename");
	if (_tmp3_) {
		gchar* _tmp4_ = NULL;
		gchar* val;
		gchar** _tmp5_;
		gchar** _tmp6_ = NULL;
		_tmp4_ = vala_attribute_get_string (a, "cheader_filename");
		val = _tmp4_;
		_tmp6_ = _tmp5_ = g_strsplit (val, ",", 0);
		{
			gchar** filename_collection;
			int filename_collection_length1;
			int filename_it;
			filename_collection = _tmp6_;
			filename_collection_length1 = _vala_array_length (_tmp5_);
			for (filename_it = 0; filename_it < _vala_array_length (_tmp5_); filename_it = filename_it + 1) {
				gchar* _tmp7_;
				gchar* filename;
				_tmp7_ = g_strdup (filename_collection[filename_it]);
				filename = _tmp7_;
				{
					vala_symbol_add_cheader_filename ((ValaSymbol*) self, filename);
					_g_free0 (filename);
				}
			}
			filename_collection = (_vala_array_free (filename_collection, filename_collection_length1, (GDestroyNotify) g_free), NULL);
		}
		_g_free0 (val);
	}
	_tmp8_ = vala_attribute_has_argument (a, "array_length");
	if (_tmp8_) {
		gboolean _tmp9_;
		_tmp9_ = vala_attribute_get_bool (a, "array_length");
		vala_field_set_no_array_length (self, !_tmp9_);
	}
	_tmp10_ = vala_attribute_has_argument (a, "array_null_terminated");
	if (_tmp10_) {
		gboolean _tmp11_;
		_tmp11_ = vala_attribute_get_bool (a, "array_null_terminated");
		vala_field_set_array_null_terminated (self, _tmp11_);
	}
	_tmp12_ = vala_attribute_has_argument (a, "array_length_cname");
	if (_tmp12_) {
		gchar* _tmp13_ = NULL;
		gchar* _tmp14_;
		_tmp13_ = vala_attribute_get_string (a, "array_length_cname");
		_tmp14_ = _tmp13_;
		vala_field_set_array_length_cname (self, _tmp14_);
		_g_free0 (_tmp14_);
	}
	_tmp15_ = vala_attribute_has_argument (a, "array_length_cexpr");
	if (_tmp15_) {
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_;
		_tmp16_ = vala_attribute_get_string (a, "array_length_cexpr");
		_tmp17_ = _tmp16_;
		vala_field_set_array_length_cexpr (self, _tmp17_);
		_g_free0 (_tmp17_);
	}
	_tmp18_ = vala_attribute_has_argument (a, "array_length_type");
	if (_tmp18_) {
		gchar* _tmp19_ = NULL;
		gchar* _tmp20_;
		_tmp19_ = vala_attribute_get_string (a, "array_length_type");
		_tmp20_ = _tmp19_;
		vala_field_set_array_length_type (self, _tmp20_);
		_g_free0 (_tmp20_);
	}
	_tmp21_ = vala_attribute_has_argument (a, "delegate_target");
	if (_tmp21_) {
		gboolean _tmp22_;
		_tmp22_ = vala_attribute_get_bool (a, "delegate_target");
		vala_field_set_no_delegate_target (self, !_tmp22_);
	}
}


/**
 * Process all associated attributes.
 */
static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


void vala_field_process_attributes (ValaField* self) {
	g_return_if_fail (self != NULL);
	{
		GList* a_collection;
		GList* a_it;
		a_collection = ((ValaCodeNode*) self)->attributes;
		for (a_it = a_collection; a_it != NULL; a_it = a_it->next) {
			ValaAttribute* _tmp0_;
			ValaAttribute* a;
			_tmp0_ = _vala_code_node_ref0 ((ValaAttribute*) a_it->data);
			a = _tmp0_;
			{
				const gchar* _tmp1_ = NULL;
				_tmp1_ = vala_attribute_get_name (a);
				if (g_strcmp0 (_tmp1_, "CCode") == 0) {
					vala_field_process_ccode_attribute (self, a);
				} else {
					const gchar* _tmp2_ = NULL;
					_tmp2_ = vala_attribute_get_name (a);
					if (g_strcmp0 (_tmp2_, "Deprecated") == 0) {
						vala_symbol_process_deprecated_attribute ((ValaSymbol*) self, a);
					}
				}
				_vala_code_node_unref0 (a);
			}
		}
	}
}


static gboolean vala_field_real_get_lock_used (ValaLockable* base) {
	ValaField * self;
	gboolean result = FALSE;
	self = (ValaField*) base;
	result = self->priv->lock_used;
	return result;
}


static void vala_field_real_set_lock_used (ValaLockable* base, gboolean used) {
	ValaField * self;
	self = (ValaField*) base;
	self->priv->lock_used = used;
}


static void vala_field_real_replace_expression (ValaCodeNode* base, ValaExpression* old_node, ValaExpression* new_node) {
	ValaField * self;
	ValaExpression* _tmp0_ = NULL;
	self = (ValaField*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_variable_get_initializer ((ValaVariable*) self);
	if (_tmp0_ == old_node) {
		vala_variable_set_initializer ((ValaVariable*) self, new_node);
	}
}


static void vala_field_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type) {
	ValaField * self;
	ValaDataType* _tmp0_ = NULL;
	self = (ValaField*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_variable_get_variable_type ((ValaVariable*) self);
	if (_tmp0_ == old_type) {
		vala_variable_set_variable_type ((ValaVariable*) self, new_type);
	}
}


gchar* vala_field_get_ctype (ValaField* self) {
	gchar* result = NULL;
	ValaAttribute* _tmp0_ = NULL;
	ValaAttribute* attr;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "CCode");
	attr = _tmp0_;
	if (attr == NULL) {
		result = NULL;
		_vala_code_node_unref0 (attr);
		return result;
	}
	_tmp1_ = vala_attribute_get_string (attr, "type");
	result = _tmp1_;
	_vala_code_node_unref0 (attr);
	return result;
}


void vala_field_set_ctype (ValaField* self, const gchar* ctype) {
	ValaAttribute* _tmp0_ = NULL;
	ValaAttribute* attr;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ctype != NULL);
	_tmp0_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "CCode");
	attr = _tmp0_;
	if (attr == NULL) {
		ValaAttribute* _tmp1_ = NULL;
		ValaAttribute* _tmp2_;
		ValaAttribute* _tmp3_;
		_tmp1_ = vala_attribute_new ("CCode", NULL);
		_tmp2_ = _tmp1_;
		_vala_code_node_unref0 (attr);
		attr = _tmp2_;
		_tmp3_ = _vala_code_node_ref0 (attr);
		((ValaCodeNode*) self)->attributes = g_list_append (((ValaCodeNode*) self)->attributes, _tmp3_);
	}
	_tmp4_ = g_strdup_printf ("\"%s\"", ctype);
	_tmp5_ = _tmp4_;
	vala_attribute_add_argument (attr, "type", _tmp5_);
	_g_free0 (_tmp5_);
	_vala_code_node_unref0 (attr);
}


static gpointer _vala_source_file_ref0 (gpointer self) {
	return self ? vala_source_file_ref (self) : NULL;
}


static gboolean vala_field_real_check (ValaCodeNode* base, ValaSemanticAnalyzer* analyzer) {
	ValaField * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	ValaSourceFile* _tmp2_ = NULL;
	ValaSourceFile* _tmp3_;
	ValaSourceFile* old_source_file;
	ValaSymbol* _tmp4_ = NULL;
	ValaSymbol* _tmp5_;
	ValaSymbol* old_symbol;
	ValaSourceReference* _tmp6_ = NULL;
	ValaDataType* _tmp9_ = NULL;
	ValaDataType* _tmp11_ = NULL;
	ValaDataType* _tmp12_ = NULL;
	gboolean _tmp13_;
	ValaExpression* _tmp22_ = NULL;
	gboolean _tmp46_ = FALSE;
	gboolean _tmp49_;
	gboolean field_in_header;
	ValaSymbol* _tmp50_ = NULL;
	gboolean _tmp56_ = FALSE;
	gboolean _tmp57_ = FALSE;
	gboolean _tmp58_;
	gboolean _tmp71_;
	self = (ValaField*) base;
	g_return_val_if_fail (analyzer != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	if (_tmp0_) {
		gboolean _tmp1_;
		_tmp1_ = vala_code_node_get_error ((ValaCodeNode*) self);
		result = !_tmp1_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp2_ = vala_semantic_analyzer_get_current_source_file (analyzer);
	_tmp3_ = _vala_source_file_ref0 (_tmp2_);
	old_source_file = _tmp3_;
	_tmp4_ = vala_semantic_analyzer_get_current_symbol (analyzer);
	_tmp5_ = _vala_code_node_ref0 (_tmp4_);
	old_symbol = _tmp5_;
	_tmp6_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	if (_tmp6_ != NULL) {
		ValaSourceReference* _tmp7_ = NULL;
		ValaSourceFile* _tmp8_ = NULL;
		_tmp7_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp8_ = vala_source_reference_get_file (_tmp7_);
		vala_semantic_analyzer_set_current_source_file (analyzer, _tmp8_);
	}
	vala_semantic_analyzer_set_current_symbol (analyzer, (ValaSymbol*) self);
	_tmp9_ = vala_variable_get_variable_type ((ValaVariable*) self);
	if (VALA_IS_VOID_TYPE (_tmp9_)) {
		ValaSourceReference* _tmp10_ = NULL;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp10_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		vala_report_error (_tmp10_, "'void' not supported as field type");
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	_tmp11_ = vala_variable_get_variable_type ((ValaVariable*) self);
	vala_code_node_check ((ValaCodeNode*) _tmp11_, analyzer);
	_tmp12_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp13_ = vala_semantic_analyzer_is_type_accessible (analyzer, (ValaSymbol*) self, _tmp12_);
	if (!_tmp13_) {
		ValaSourceReference* _tmp14_ = NULL;
		ValaDataType* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_;
		gchar* _tmp18_ = NULL;
		gchar* _tmp19_;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp15_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp16_ = vala_code_node_to_string ((ValaCodeNode*) _tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = g_strdup_printf ("field type `%s` is less accessible than field `%s`", _tmp17_, _tmp19_);
		_tmp21_ = _tmp20_;
		vala_report_error (_tmp14_, _tmp21_);
		_g_free0 (_tmp21_);
		_g_free0 (_tmp19_);
		_g_free0 (_tmp17_);
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	vala_field_process_attributes (self);
	_tmp22_ = vala_variable_get_initializer ((ValaVariable*) self);
	if (_tmp22_ != NULL) {
		ValaExpression* _tmp23_ = NULL;
		ValaDataType* _tmp24_ = NULL;
		ValaExpression* _tmp25_ = NULL;
		gboolean _tmp26_;
		ValaExpression* _tmp27_ = NULL;
		ValaDataType* _tmp28_ = NULL;
		ValaExpression* _tmp30_ = NULL;
		ValaDataType* _tmp31_ = NULL;
		ValaDataType* _tmp32_ = NULL;
		gboolean _tmp33_;
		gboolean _tmp44_;
		_tmp23_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp24_ = vala_variable_get_variable_type ((ValaVariable*) self);
		vala_expression_set_target_type (_tmp23_, _tmp24_);
		_tmp25_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp26_ = vala_code_node_check ((ValaCodeNode*) _tmp25_, analyzer);
		if (!_tmp26_) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp27_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp28_ = vala_expression_get_value_type (_tmp27_);
		if (_tmp28_ == NULL) {
			ValaSourceReference* _tmp29_ = NULL;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp29_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			vala_report_error (_tmp29_, "expression type not allowed as initializer");
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp30_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp31_ = vala_expression_get_value_type (_tmp30_);
		_tmp32_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp33_ = vala_data_type_compatible (_tmp31_, _tmp32_);
		if (!_tmp33_) {
			ValaSourceReference* _tmp34_ = NULL;
			ValaExpression* _tmp35_ = NULL;
			ValaDataType* _tmp36_ = NULL;
			gchar* _tmp37_ = NULL;
			gchar* _tmp38_;
			ValaDataType* _tmp39_ = NULL;
			gchar* _tmp40_ = NULL;
			gchar* _tmp41_;
			gchar* _tmp42_ = NULL;
			gchar* _tmp43_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp34_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp35_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp36_ = vala_expression_get_value_type (_tmp35_);
			_tmp37_ = vala_code_node_to_string ((ValaCodeNode*) _tmp36_);
			_tmp38_ = _tmp37_;
			_tmp39_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp40_ = vala_code_node_to_string ((ValaCodeNode*) _tmp39_);
			_tmp41_ = _tmp40_;
			_tmp42_ = g_strdup_printf ("Cannot convert from `%s' to `%s'", _tmp38_, _tmp41_);
			_tmp43_ = _tmp42_;
			vala_report_error (_tmp34_, _tmp43_);
			_g_free0 (_tmp43_);
			_g_free0 (_tmp41_);
			_g_free0 (_tmp38_);
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp44_ = vala_symbol_get_external ((ValaSymbol*) self);
		if (_tmp44_) {
			ValaSourceReference* _tmp45_ = NULL;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp45_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			vala_report_error (_tmp45_, "External fields cannot use initializers");
		}
	}
	if (self->priv->_binding == VALA_MEMBER_BINDING_INSTANCE) {
		ValaSymbol* _tmp47_ = NULL;
		_tmp47_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp46_ = VALA_IS_INTERFACE (_tmp47_);
	} else {
		_tmp46_ = FALSE;
	}
	if (_tmp46_) {
		ValaSourceReference* _tmp48_ = NULL;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp48_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		vala_report_error (_tmp48_, "Interfaces may not have instance fields");
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	_tmp49_ = vala_symbol_is_internal_symbol ((ValaSymbol*) self);
	field_in_header = !_tmp49_;
	_tmp50_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	if (VALA_IS_CLASS (_tmp50_)) {
		ValaSymbol* _tmp51_ = NULL;
		ValaClass* _tmp52_;
		ValaClass* cl;
		gboolean _tmp53_ = FALSE;
		gboolean _tmp54_;
		_tmp51_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp52_ = _vala_code_node_ref0 (VALA_CLASS (_tmp51_));
		cl = _tmp52_;
		_tmp54_ = vala_class_get_is_compact (cl);
		if (_tmp54_) {
			gboolean _tmp55_;
			_tmp55_ = vala_symbol_is_internal_symbol ((ValaSymbol*) cl);
			_tmp53_ = !_tmp55_;
		} else {
			_tmp53_ = FALSE;
		}
		if (_tmp53_) {
			field_in_header = TRUE;
		}
		_vala_code_node_unref0 (cl);
	}
	_tmp58_ = vala_symbol_get_external_package ((ValaSymbol*) self);
	if (!_tmp58_) {
		gboolean _tmp59_;
		_tmp59_ = vala_symbol_get_hides ((ValaSymbol*) self);
		_tmp57_ = !_tmp59_;
	} else {
		_tmp57_ = FALSE;
	}
	if (_tmp57_) {
		ValaSymbol* _tmp60_ = NULL;
		ValaSymbol* _tmp61_;
		_tmp60_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp61_ = _tmp60_;
		_tmp56_ = _tmp61_ != NULL;
		_vala_code_node_unref0 (_tmp61_);
	} else {
		_tmp56_ = FALSE;
	}
	if (_tmp56_) {
		ValaSourceReference* _tmp62_ = NULL;
		gchar* _tmp63_ = NULL;
		gchar* _tmp64_;
		ValaSymbol* _tmp65_ = NULL;
		ValaSymbol* _tmp66_;
		gchar* _tmp67_ = NULL;
		gchar* _tmp68_;
		gchar* _tmp69_ = NULL;
		gchar* _tmp70_;
		_tmp62_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp63_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp64_ = _tmp63_;
		_tmp65_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp66_ = _tmp65_;
		_tmp67_ = vala_symbol_get_full_name (_tmp66_);
		_tmp68_ = _tmp67_;
		_tmp69_ = g_strdup_printf ("%s hides inherited field `%s'. Use the `new' keyword if hiding was int" \
"entional", _tmp64_, _tmp68_);
		_tmp70_ = _tmp69_;
		vala_report_warning (_tmp62_, _tmp70_);
		_g_free0 (_tmp70_);
		_g_free0 (_tmp68_);
		_vala_code_node_unref0 (_tmp66_);
		_g_free0 (_tmp64_);
	}
	vala_semantic_analyzer_set_current_source_file (analyzer, old_source_file);
	vala_semantic_analyzer_set_current_symbol (analyzer, old_symbol);
	_tmp71_ = vala_code_node_get_error ((ValaCodeNode*) self);
	result = !_tmp71_;
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}


ValaMemberBinding vala_field_get_binding (ValaField* self) {
	ValaMemberBinding result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_binding;
	return result;
}


void vala_field_set_binding (ValaField* self, ValaMemberBinding value) {
	g_return_if_fail (self != NULL);
	self->priv->_binding = value;
}


gboolean vala_field_get_is_volatile (ValaField* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_volatile;
	return result;
}


void vala_field_set_is_volatile (ValaField* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_is_volatile = value;
}


gboolean vala_field_get_no_array_length (ValaField* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_no_array_length;
	return result;
}


void vala_field_set_no_array_length (ValaField* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_no_array_length = value;
}


gboolean vala_field_get_no_delegate_target (ValaField* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_no_delegate_target;
	return result;
}


void vala_field_set_no_delegate_target (ValaField* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_no_delegate_target = value;
}


gboolean vala_field_get_array_null_terminated (ValaField* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_array_null_terminated;
	return result;
}


void vala_field_set_array_null_terminated (ValaField* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_array_null_terminated = value;
}


gboolean vala_field_get_has_array_length_cname (ValaField* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->array_length_cname != NULL;
	return result;
}


gboolean vala_field_get_has_array_length_cexpr (ValaField* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->array_length_cexpr != NULL;
	return result;
}


const gchar* vala_field_get_array_length_type (ValaField* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_array_length_type;
	return result;
}


void vala_field_set_array_length_type (ValaField* self, const gchar* value) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_array_length_type);
	self->priv->_array_length_type = _tmp1_;
}


static void vala_field_class_init (ValaFieldClass * klass) {
	vala_field_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->finalize = vala_field_finalize;
	g_type_class_add_private (klass, sizeof (ValaFieldPrivate));
	VALA_CODE_NODE_CLASS (klass)->accept = vala_field_real_accept;
	VALA_CODE_NODE_CLASS (klass)->accept_children = vala_field_real_accept_children;
	VALA_CODE_NODE_CLASS (klass)->replace_expression = vala_field_real_replace_expression;
	VALA_CODE_NODE_CLASS (klass)->replace_type = vala_field_real_replace_type;
	VALA_CODE_NODE_CLASS (klass)->check = vala_field_real_check;
}


static void vala_field_vala_lockable_interface_init (ValaLockableIface * iface) {
	vala_field_vala_lockable_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_lock_used = (gboolean (*)(ValaLockable*)) vala_field_real_get_lock_used;
	iface->set_lock_used = (void (*)(ValaLockable* ,gboolean)) vala_field_real_set_lock_used;
}


static void vala_field_instance_init (ValaField * self) {
	self->priv = VALA_FIELD_GET_PRIVATE (self);
	self->priv->_binding = VALA_MEMBER_BINDING_INSTANCE;
	self->priv->_array_length_type = NULL;
	self->priv->lock_used = FALSE;
}


static void vala_field_finalize (ValaCodeNode* obj) {
	ValaField * self;
	self = VALA_FIELD (obj);
	_g_free0 (self->priv->_array_length_type);
	_g_free0 (self->priv->array_length_cname);
	_g_free0 (self->priv->array_length_cexpr);
	_g_free0 (self->priv->cname);
	VALA_CODE_NODE_CLASS (vala_field_parent_class)->finalize (obj);
}


/**
 * Represents a type or namespace field.
 */
GType vala_field_get_type (void) {
	static volatile gsize vala_field_type_id__volatile = 0;
	if (g_once_init_enter (&vala_field_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaFieldClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_field_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaField), 0, (GInstanceInitFunc) vala_field_instance_init, NULL };
		static const GInterfaceInfo vala_lockable_info = { (GInterfaceInitFunc) vala_field_vala_lockable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType vala_field_type_id;
		vala_field_type_id = g_type_register_static (VALA_TYPE_VARIABLE, "ValaField", &g_define_type_info, 0);
		g_type_add_interface_static (vala_field_type_id, VALA_TYPE_LOCKABLE, &vala_lockable_info);
		g_once_init_leave (&vala_field_type_id__volatile, vala_field_type_id);
	}
	return vala_field_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



