/* valasignal.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALA_VALASIGNAL_H__
#define __VALA_VALASIGNAL_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee/list.h>
#include <ccode/valaccodeconstant.h>
#include <vala/valamember.h>
#include <vala/valalockable.h>
#include <vala/valacodenode.h>

G_BEGIN_DECLS


#define VALA_TYPE_SIGNAL (vala_signal_get_type ())
#define VALA_SIGNAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SIGNAL, ValaSignal))
#define VALA_SIGNAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SIGNAL, ValaSignalClass))
#define VALA_IS_SIGNAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SIGNAL))
#define VALA_IS_SIGNAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SIGNAL))
#define VALA_SIGNAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SIGNAL, ValaSignalClass))

typedef struct _ValaSignalPrivate ValaSignalPrivate;

/**
 * Represents an object signal. Signals enable objects to provide notifications.
 */
struct _ValaSignal {
	ValaMember parent_instance;
	ValaSignalPrivate * priv;
};
struct _ValaSignalClass {
	ValaMemberClass parent_class;
};

ValaSignal* vala_signal_new (const char* name, ValaDataType* return_type, ValaSourceReference* source_reference);
void vala_signal_add_parameter (ValaSignal* self, ValaFormalParameter* param);
GeeList* vala_signal_get_parameters (ValaSignal* self);
ValaDelegate* vala_signal_get_delegate (ValaSignal* self);
char* vala_signal_get_cname (ValaSignal* self);
void vala_signal_set_cname (ValaSignal* self, const char* cname);
ValaCCodeConstant* vala_signal_get_canonical_cconstant (ValaSignal* self);
void vala_signal_process_attributes (ValaSignal* self);
ValaDataType* vala_signal_get_return_type (ValaSignal* self);
void vala_signal_set_return_type (ValaSignal* self, ValaDataType* value);
gboolean vala_signal_get_has_emitter (ValaSignal* self);
void vala_signal_set_has_emitter (ValaSignal* self, gboolean value);
GType vala_signal_get_type (void);

G_END_DECLS

#endif
