/* gstreamer-audio-0.10.vapi generated by lt-vapigen, do not modify. */

[CCode (cprefix = "Gst", lower_case_cprefix = "gst_")]
namespace Gst {
	[CCode (cprefix = "GST_AUDIO_CHANNEL_POSITION_", cheader_filename = "gst/gst.h")]
	public enum AudioChannelPosition {
		INVALID,
		FRONT_MONO,
		FRONT_LEFT,
		FRONT_RIGHT,
		REAR_CENTER,
		REAR_LEFT,
		REAR_RIGHT,
		LFE,
		FRONT_CENTER,
		FRONT_LEFT_OF_CENTER,
		FRONT_RIGHT_OF_CENTER,
		SIDE_LEFT,
		SIDE_RIGHT,
		NONE,
		NUM,
	}
	[CCode (cprefix = "GST_AUDIO_FIELD_", cheader_filename = "gst/gst.h")]
	public enum AudioFieldFlag {
		RATE,
		CHANNELS,
		ENDIANNESS,
		WIDTH,
		DEPTH,
		SIGNED,
	}
	[CCode (cprefix = "GST_BASE_AUDIO_SINK_SLAVE_", cheader_filename = "gst/gst.h")]
	public enum BaseAudioSinkSlaveMethod {
		RESAMPLE,
		SKEW,
		NONE,
	}
	[CCode (cprefix = "GST_", cheader_filename = "gst/gst.h")]
	public enum BufferFormat {
		UNKNOWN,
		S8,
		U8,
		S16_LE,
		S16_BE,
		U16_LE,
		U16_BE,
		S24_LE,
		S24_BE,
		U24_LE,
		U24_BE,
		S32_LE,
		S32_BE,
		U32_LE,
		U32_BE,
		S24_3LE,
		S24_3BE,
		U24_3LE,
		U24_3BE,
		S20_3LE,
		S20_3BE,
		U20_3LE,
		U20_3BE,
		S18_3LE,
		S18_3BE,
		U18_3LE,
		U18_3BE,
		FLOAT32_LE,
		FLOAT32_BE,
		FLOAT64_LE,
		FLOAT64_BE,
		MU_LAW,
		A_LAW,
		IMA_ADPCM,
		MPEG,
		GSM,
	}
	[CCode (cprefix = "GST_BUFTYPE_", cheader_filename = "gst/gst.h")]
	public enum BufferFormatType {
		LINEAR,
		FLOAT,
		MU_LAW,
		A_LAW,
		IMA_ADPCM,
		MPEG,
		GSM,
	}
	[CCode (cprefix = "GST_SEGSTATE_", cheader_filename = "gst/gst.h")]
	public enum RingBufferSegState {
		INVALID,
		EMPTY,
		FILLED,
		PARTIAL,
	}
	[CCode (cprefix = "GST_RING_BUFFER_STATE_", cheader_filename = "gst/gst.h")]
	public enum RingBufferState {
		STOPPED,
		PAUSED,
		STARTED,
	}
	[CCode (cheader_filename = "gst/gst.h")]
	public class RingBufferSpec {
		public weak Gst.Caps caps;
		public Gst.BufferFormatType type;
		public Gst.BufferFormat format;
		public bool sign;
		public bool bigend;
		public int width;
		public int depth;
		public int rate;
		public int channels;
		public uint64 latency_time;
		public uint64 buffer_time;
		public int segsize;
		public int segtotal;
		public int bytes_per_sample;
		[NoArrayLength]
		public weak uchar[] silence_sample;
		[NoArrayLength]
		public weak pointer[] _gst_reserved;
	}
	[CCode (cheader_filename = "gst/gst.h")]
	public class AudioClock : Gst.SystemClock {
		public Gst.AudioClockGetTimeFunc func;
		public pointer user_data;
		public weak Gst.ClockTime last_time;
		public AudioClock (string name, Gst.AudioClockGetTimeFunc func, pointer user_data);
	}
	[CCode (cheader_filename = "gst/gst.h")]
	public class AudioFilter : Gst.BaseTransform {
		public weak Gst.RingBufferSpec format;
		public static void class_add_pad_templates (pointer klass, Gst.Caps allowed_caps);
	}
	[CCode (cheader_filename = "gst/gst.h")]
	public class AudioSink : Gst.BaseAudioSink {
		public weak GLib.Thread thread;
	}
	[CCode (cheader_filename = "gst/gst.h")]
	public class AudioSrc : Gst.BaseAudioSrc {
		public weak GLib.Thread thread;
	}
	[CCode (cheader_filename = "gst/gst.h")]
	public class BaseAudioSink : Gst.BaseSink {
		public weak Gst.RingBuffer ringbuffer;
		public uint64 next_sample;
		public weak Gst.Clock provided_clock;
		public virtual weak Gst.RingBuffer create_ringbuffer ();
		public bool get_provide_clock ();
		public Gst.BaseAudioSinkSlaveMethod get_slave_method ();
		public void set_provide_clock (bool provide);
		public void set_slave_method (Gst.BaseAudioSinkSlaveMethod method);
		[NoAccessorMethod]
		public weak int64 buffer_time { get; set; }
		[NoAccessorMethod]
		public weak int64 latency_time { get; set; }
		public weak bool provide_clock { get; set; }
		public weak Gst.BaseAudioSinkSlaveMethod slave_method { get; set; }
	}
	[CCode (cheader_filename = "gst/gst.h")]
	public class BaseAudioSrc : Gst.PushSrc {
		public weak Gst.RingBuffer ringbuffer;
		public uint64 next_sample;
		public weak Gst.Clock clock;
		public virtual weak Gst.RingBuffer create_ringbuffer ();
		public bool get_provide_clock ();
		public void set_provide_clock (bool provide);
		[NoAccessorMethod]
		public weak int64 buffer_time { get; set; }
		[NoAccessorMethod]
		public weak int64 latency_time { get; set; }
		public weak bool provide_clock { get; set; }
	}
	[CCode (cheader_filename = "gst/gst.h")]
	public class RingBuffer : Gst.Object {
		public weak GLib.Cond cond;
		public bool open;
		public bool acquired;
		public weak Gst.Buffer data;
		public weak Gst.RingBufferSpec spec;
		public Gst.RingBufferSegState segstate;
		public int samples_per_seg;
		public uchar empty_seg;
		public int state;
		public int segdone;
		public int segbase;
		public int waiting;
		public Gst.RingBufferCallback callback;
		public pointer cb_data;
		public pointer abidata;
		public virtual bool acquire (Gst.RingBufferSpec spec);
		public void advance (uint advance);
		public void clear (int segment);
		public void clear_all ();
		public virtual bool close_device ();
		[NoArrayLength]
		public uint commit (uint64 sample, uchar[] data, uint len);
		[NoArrayLength]
		public uint commit_full (uint64 sample, uchar[] data, int in_samples, int out_samples, int accum);
		public static void debug_spec_buff (Gst.RingBufferSpec spec);
		public static void debug_spec_caps (Gst.RingBufferSpec spec);
		public virtual uint delay ();
		public bool device_is_open ();
		public bool is_acquired ();
		public void may_start (bool allowed);
		public virtual bool open_device ();
		public static bool parse_caps (Gst.RingBufferSpec spec, Gst.Caps caps);
		public virtual bool pause ();
		public bool prepare_read (int segment, uchar readptr, int len);
		[NoArrayLength]
		public uint read (uint64 sample, uchar[] data, uint len);
		public virtual bool release ();
		public uint64 samples_done ();
		public void set_callback (Gst.RingBufferCallback cb, pointer user_data);
		public void set_flushing (bool flushing);
		public void set_sample (uint64 sample);
		public virtual bool start ();
		public virtual bool stop ();
	}
	public static delegate weak Gst.ClockTime AudioClockGetTimeFunc (Gst.Clock clock, pointer user_data);
	public static delegate bool AudioMixerFilterFunc (Gst.Mixer mixer, pointer user_data);
	public static delegate void RingBufferCallback (Gst.RingBuffer rbuf, uchar data, uint len, pointer user_data);
	public const int AUDIO_DEF_RATE;
	public const string AUDIO_FLOAT_PAD_TEMPLATE_CAPS;
	public const string AUDIO_FLOAT_STANDARD_PAD_TEMPLATE_CAPS;
	public const string AUDIO_INT_PAD_TEMPLATE_CAPS;
	public const string AUDIO_INT_STANDARD_PAD_TEMPLATE_CAPS;
	public static weak Gst.Buffer audio_buffer_clip (Gst.Buffer buffer, Gst.Segment segment, int rate, int frame_size);
	public static weak GLib.List audio_default_registry_mixer_filter (Gst.AudioMixerFilterFunc filter_func, bool first, pointer user_data);
	public static weak Gst.ClockTime audio_duration_from_pad_buffer (Gst.Pad pad, Gst.Buffer buf);
	public static Gst.AudioChannelPosition audio_fixate_channel_positions (Gst.Structure str);
	public static int audio_frame_byte_size (Gst.Pad pad);
	public static long audio_frame_length (Gst.Pad pad, Gst.Buffer buf);
	public static Gst.AudioChannelPosition audio_get_channel_positions (Gst.Structure str);
	public static bool audio_is_buffer_framed (Gst.Pad pad, Gst.Buffer buf);
	public static void audio_set_caps_channel_positions_list (Gst.Caps caps, Gst.AudioChannelPosition pos, int num_positions);
	public static void audio_set_channel_positions (Gst.Structure str, Gst.AudioChannelPosition pos);
	public static void audio_set_structure_channel_positions_list (Gst.Structure str, Gst.AudioChannelPosition pos, int num_positions);
	public static void audio_structure_set_int (Gst.Structure structure, Gst.AudioFieldFlag flag);
}
