/* valainvalidtype.vala
 *
 * Copyright (C) 2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALA_VALAINVALIDTYPE_H__
#define __VALA_VALAINVALIDTYPE_H__

#include <glib.h>
#include <glib-object.h>
#include <vala/valadatatype.h>

G_BEGIN_DECLS


#define VALA_TYPE_INVALID_TYPE (vala_invalid_type_get_type ())
#define VALA_INVALID_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_INVALID_TYPE, ValaInvalidType))
#define VALA_INVALID_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_INVALID_TYPE, ValaInvalidTypeClass))
#define VALA_IS_INVALID_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_INVALID_TYPE))
#define VALA_IS_INVALID_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_INVALID_TYPE))
#define VALA_INVALID_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_INVALID_TYPE, ValaInvalidTypeClass))

typedef struct _ValaInvalidType ValaInvalidType;
typedef struct _ValaInvalidTypeClass ValaInvalidTypeClass;
typedef struct _ValaInvalidTypePrivate ValaInvalidTypePrivate;

/**
 * An invalid reference to a data type.
 */
struct _ValaInvalidType {
	ValaDataType parent_instance;
	ValaInvalidTypePrivate * priv;
};
struct _ValaInvalidTypeClass {
	ValaDataTypeClass parent_class;
};

ValaInvalidType* vala_invalid_type_new (void);
GType vala_invalid_type_get_type (void);

G_END_DECLS

#endif
