/* valaparser.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALA_VALAPARSER_H__
#define __VALA_VALAPARSER_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valacodevisitor.h>
#include <vala/valacodecontext.h>
#include <vala/valasourcefile.h>

G_BEGIN_DECLS


#define VALA_TYPE_PARSER (vala_parser_get_type ())
#define VALA_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_PARSER, ValaParser))
#define VALA_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_PARSER, ValaParserClass))
#define VALA_IS_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_PARSER))
#define VALA_IS_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_PARSER))
#define VALA_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_PARSER, ValaParserClass))

typedef struct _ValaParser ValaParser;
typedef struct _ValaParserClass ValaParserClass;
typedef struct _ValaParserPrivate ValaParserPrivate;

/**
 * Code visitor parsing all Vala source files.
 */
struct _ValaParser {
	ValaCodeVisitor parent;
	ValaParserPrivate * priv;
};
struct _ValaParserClass {
	ValaCodeVisitorClass parent;
};

void vala_parser_parse (ValaParser* self, ValaCodeContext* context);
void vala_parser_push_comment (ValaParser* self, const char* comment_item, gboolean file_comment);
char* vala_parser_pop_comment (ValaParser* self);
void vala_parser_parse_file (ValaParser* self, ValaSourceFile* source_file);
ValaParser* vala_parser_new (void);
GType vala_parser_get_type (void);

G_END_DECLS

#endif
