/* valainterfaceregisterfunction.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter, Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <rasa@gmx.ch>
 */

#ifndef __GOBJECT_VALAINTERFACEREGISTERFUNCTION_H__
#define __GOBJECT_VALAINTERFACEREGISTERFUNCTION_H__

#include <glib.h>
#include <glib-object.h>
#include <vala/valainterface.h>
#include <vala/valadatatype.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valasymbol.h>
#include <ccode/valaccodefragment.h>
#include <gobject/valatyperegisterfunction.h>

G_BEGIN_DECLS


#define VALA_TYPE_INTERFACE_REGISTER_FUNCTION (vala_interface_register_function_get_type ())
#define VALA_INTERFACE_REGISTER_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_INTERFACE_REGISTER_FUNCTION, ValaInterfaceRegisterFunction))
#define VALA_INTERFACE_REGISTER_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_INTERFACE_REGISTER_FUNCTION, ValaInterfaceRegisterFunctionClass))
#define VALA_IS_INTERFACE_REGISTER_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_INTERFACE_REGISTER_FUNCTION))
#define VALA_IS_INTERFACE_REGISTER_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_INTERFACE_REGISTER_FUNCTION))
#define VALA_INTERFACE_REGISTER_FUNCTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_INTERFACE_REGISTER_FUNCTION, ValaInterfaceRegisterFunctionClass))

typedef struct _ValaInterfaceRegisterFunction ValaInterfaceRegisterFunction;
typedef struct _ValaInterfaceRegisterFunctionClass ValaInterfaceRegisterFunctionClass;
typedef struct _ValaInterfaceRegisterFunctionPrivate ValaInterfaceRegisterFunctionPrivate;

/**
 * C function to register an interface at runtime.
 */
struct _ValaInterfaceRegisterFunction {
	ValaTypeRegisterFunction parent;
	ValaInterfaceRegisterFunctionPrivate * priv;
};
struct _ValaInterfaceRegisterFunctionClass {
	ValaTypeRegisterFunctionClass parent;
};

ValaInterfaceRegisterFunction* vala_interface_register_function_new (ValaInterface* iface);
ValaInterface* vala_interface_register_function_get_interface_reference (ValaInterfaceRegisterFunction* self);
void vala_interface_register_function_set_interface_reference (ValaInterfaceRegisterFunction* self, ValaInterface* value);
GType vala_interface_register_function_get_type (void);

G_END_DECLS

#endif
