/* valaccodetypedefinition.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __CCODE_VALACCODETYPEDEFINITION_H__
#define __CCODE_VALACCODETYPEDEFINITION_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <ccode/valaccodenode.h>
#include <ccode/valaccodedeclarator.h>
#include <ccode/valaccodewriter.h>

G_BEGIN_DECLS


#define VALA_TYPE_CCODE_TYPE_DEFINITION (vala_ccode_type_definition_get_type ())
#define VALA_CCODE_TYPE_DEFINITION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_TYPE_DEFINITION, ValaCCodeTypeDefinition))
#define VALA_CCODE_TYPE_DEFINITION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_TYPE_DEFINITION, ValaCCodeTypeDefinitionClass))
#define VALA_IS_CCODE_TYPE_DEFINITION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_TYPE_DEFINITION))
#define VALA_IS_CCODE_TYPE_DEFINITION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_TYPE_DEFINITION))
#define VALA_CCODE_TYPE_DEFINITION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_TYPE_DEFINITION, ValaCCodeTypeDefinitionClass))

typedef struct _ValaCCodeTypeDefinition ValaCCodeTypeDefinition;
typedef struct _ValaCCodeTypeDefinitionClass ValaCCodeTypeDefinitionClass;
typedef struct _ValaCCodeTypeDefinitionPrivate ValaCCodeTypeDefinitionPrivate;

/**
 * Represents a typedef in the C code.
 */
struct _ValaCCodeTypeDefinition {
	ValaCCodeNode parent;
	ValaCCodeTypeDefinitionPrivate * priv;
};
struct _ValaCCodeTypeDefinitionClass {
	ValaCCodeNodeClass parent;
};

ValaCCodeTypeDefinition* vala_ccode_type_definition_new (const char* type, ValaCCodeDeclarator* decl);
char* vala_ccode_type_definition_get_type_name (ValaCCodeTypeDefinition* self);
void vala_ccode_type_definition_set_type_name (ValaCCodeTypeDefinition* self, const char* value);
ValaCCodeDeclarator* vala_ccode_type_definition_get_declarator (ValaCCodeTypeDefinition* self);
void vala_ccode_type_definition_set_declarator (ValaCCodeTypeDefinition* self, ValaCCodeDeclarator* value);
GType vala_ccode_type_definition_get_type (void);

G_END_DECLS

#endif
