
#include "testenchant.h"
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <enchant.h>

typedef struct _TestEnchant TestEnchant;
typedef struct _TestEnchantClass TestEnchantClass;
typedef struct _TestEnchantPrivate TestEnchantPrivate;

#define TYPE_TEST_ENCHANT (test_enchant_get_type ())
#define TEST_ENCHANT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TEST_ENCHANT, TestEnchant))
#define TEST_ENCHANT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TEST_ENCHANT, TestEnchantClass))
#define IS_TEST_ENCHANT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TEST_ENCHANT))
#define IS_TEST_ENCHANT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TEST_ENCHANT))
#define TEST_ENCHANT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TEST_ENCHANT, TestEnchantClass))

struct _TestEnchant {
	GObject parent;
	TestEnchantPrivate * priv;
};
struct _TestEnchantClass {
	GObjectClass parent;
};
enum  {
	TEST_ENCHANT_DUMMY_PROPERTY
};
static void test_enchant_info (const char* message);
static void test_enchant_test (const char* message, gboolean result);
static void test_enchant_main (int args_length1, char** args);
static void test_enchant_broker_describe_cb (const char* name, const char* desc, const char* libname);
static void test_enchant_dict_describe_cb (const char* language, const char* provider_name, const char* provider_desc, const char* provider_libname);
static gpointer test_enchant_parent_class = NULL;
static GType test_enchant_get_type (void);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static void test_enchant_info (const char* message)
{
	fprintf (stdout, "INFO: %s\n", message);
}


static void test_enchant_test (const char* message, gboolean result)
{
	fprintf (stdout, "TEST: %s: %s\n", message, (result ? "SUCCESS" : "FAILURE"));
}


static void test_enchant_main (int args_length1, char** args)
{
	EnchantBroker* broker;
	EnchantDict* dict;
	char* _tmp0;
	char* _tmp1;
	char* _tmp2;
	char* _tmp3;
	char** _tmp4;
	gint text_length1;
	char** text;
	char* bad_word;
	gint result;
	broker = enchant_broker_init ();
	dict = NULL;
	_tmp0 = NULL;
	test_enchant_info ((_tmp0 = g_strdup_printf ("providers for broker %p", broker)));
	(_tmp0 = (g_free (_tmp0), NULL));
	enchant_broker_describe (broker, ((EnchantBrokerDescribeFn) test_enchant_broker_describe_cb), NULL);
	_tmp1 = NULL;
	test_enchant_info ((_tmp1 = g_strdup_printf ("dictionaries for broker %p", broker)));
	(_tmp1 = (g_free (_tmp1), NULL));
	enchant_broker_list_dicts (broker, ((EnchantDictDescribeFn) test_enchant_dict_describe_cb), NULL);
	dict = enchant_broker_request_dict (broker, "invalid-tag");
	test_enchant_test ("requesting invalid dictionary", NULL == dict);
	_tmp2 = NULL;
	test_enchant_info ((_tmp2 = g_strdup_printf ("broker error message", enchant_broker_get_error (broker))));
	(_tmp2 = (g_free (_tmp2), NULL));
	dict = enchant_broker_request_dict (broker, "en");
	test_enchant_test ("requesting english dictionary", NULL != dict);
	test_enchant_test ("broker error is null", NULL == enchant_broker_get_error (broker));
	_tmp3 = NULL;
	test_enchant_info ((_tmp3 = g_strdup_printf ("description of dictionary %p", dict)));
	(_tmp3 = (g_free (_tmp3), NULL));
	enchant_dict_describe (dict, ((EnchantDictDescribeFn) test_enchant_dict_describe_cb), NULL);
	_tmp4 = NULL;
	text = (_tmp4 = g_strsplit ("The quick prown fox jummps over the lasy dok", " ", 0), text_length1 = -1, _tmp4);
	{
		char** word_collection;
		int word_it;
		word_collection = text;
		for (word_it = 0; (text_length1 != -1 && word_it < text_length1) || (text_length1 == -1 && word_collection[word_it] != NULL); word_it = word_it + 1) {
			const char* _tmp13;
			char* word;
			_tmp13 = NULL;
			word = (_tmp13 = word_collection[word_it], (_tmp13 == NULL ? NULL : g_strdup (_tmp13)));
			{
				gint suggestions_length1;
				char** suggestions;
				char* result;
				char* _tmp12;
				suggestions = NULL;
				result = NULL;
				do {
					gint _tmp11;
					/* FIXME: Bug 467896*/
					_tmp11 = enchant_dict_check (dict, word, -1);
					if (_tmp11 == 0)
					do {
						char* _tmp5;
						_tmp5 = NULL;
						result = (_tmp5 = g_strdup ("good"), (result = (g_free (result), NULL)), _tmp5);
						break;
					} while (0); else if (_tmp11 == 1)
					do {
						char** _tmp7;
						gint _tmp6;
						char* _tmp9;
						char* _tmp8;
						_tmp7 = NULL;
						suggestions = (_tmp7 = enchant_dict_suggest (dict, word, -1, &_tmp6), suggestions_length1 = _tmp6, _tmp7);
						_tmp9 = NULL;
						_tmp8 = NULL;
						result = (_tmp9 = g_strdup_printf ("bad (%d suggestions: %s)", suggestions_length1, (_tmp8 = g_strjoinv (", ", suggestions))), (result = (g_free (result), NULL)), _tmp9);
						(_tmp8 = (g_free (_tmp8), NULL));
						break;
					} while (0); else if (_tmp11 == -1)
					do {
						char* _tmp10;
						_tmp10 = NULL;
						result = (_tmp10 = g_strdup_printf ("error: %s", enchant_dict_get_error (dict)), (result = (g_free (result), NULL)), _tmp10);
						break;
					} while (0); else
					do {
						g_assert_not_reached ();
						break;
					} while (0);
				} while (FALSE);
				_tmp12 = NULL;
				test_enchant_info ((_tmp12 = g_strdup_printf ("%s: %s", word, result)));
				(_tmp12 = (g_free (_tmp12), NULL));
				(word = (g_free (word), NULL));
				(result = (g_free (result), NULL));
			}
		}
	}
	bad_word = g_strdup ("the:colons:make:this:a:bad:word");
	result = 0;
	result = enchant_dict_is_in_session (dict, bad_word, -1);
	test_enchant_test ("bad word is not in session", 0 == result);
	result = enchant_dict_check (dict, bad_word, -1);
	test_enchant_test ("bad word is rejected", 1 == result);
	test_enchant_info ("adding bad word to session");
	enchant_dict_add_to_session (dict, bad_word, -1);
	result = enchant_dict_is_in_session (dict, bad_word, -1);
	test_enchant_test ("bad word is in session now", 1 == result);
	result = enchant_dict_check (dict, bad_word, -1);
	test_enchant_test ("bad word is accepted now", 0 == result);
	enchant_broker_free_dict (broker, dict);
	dict = NULL;
	(broker == NULL ? NULL : (broker = (enchant_broker_free (broker), NULL)));
	(text = (_vala_array_free (text, text_length1, ((GDestroyNotify) g_free)), NULL));
	(bad_word = (g_free (bad_word), NULL));
}


int main (int argc, char ** argv)
{
	g_type_init ();
	test_enchant_main (argc, argv);
	return 0;
}


static void test_enchant_broker_describe_cb (const char* name, const char* desc, const char* libname)
{
	char* _tmp0;
	_tmp0 = NULL;
	test_enchant_info ((_tmp0 = g_strdup_printf ("- %s (%s) - %s", name, desc, libname)));
	(_tmp0 = (g_free (_tmp0), NULL));
}


static void test_enchant_dict_describe_cb (const char* language, const char* provider_name, const char* provider_desc, const char* provider_libname)
{
	char* _tmp0;
	_tmp0 = NULL;
	test_enchant_info ((_tmp0 = g_strdup_printf ("- %s (%s) - %s", language, provider_desc, provider_libname)));
	(_tmp0 = (g_free (_tmp0), NULL));
}


static void test_enchant_class_init (TestEnchantClass * klass)
{
	test_enchant_parent_class = g_type_class_peek_parent (klass);
}


static void test_enchant_init (TestEnchant * self)
{
}


static GType test_enchant_get_type (void)
{
	static GType test_enchant_type_id = 0;
	if (G_UNLIKELY (test_enchant_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (TestEnchantClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) test_enchant_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TestEnchant), 0, (GInstanceInitFunc) test_enchant_init };
		test_enchant_type_id = g_type_register_static (G_TYPE_OBJECT, "TestEnchant", &g_define_type_info, 0);
	}
	return test_enchant_type_id;
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func)
{
	if (array != NULL && destroy_func != NULL) {
		int i;
		if (array_length >= 0)
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL)
			destroy_func (((gpointer*) array)[i]);
		}
		else
		for (i = 0; ((gpointer*) array)[i] != NULL; i = i + 1) {
			destroy_func (((gpointer*) array)[i]);
		}
	}
	g_free (array);
}




