/* valareferencetransferexpression.vala
 *
 * Copyright (C) 2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "valareferencetransferexpression.h"
#include <vala/valasourcereference.h>
#include <vala/valareferencetransferexpression.h>
#include <vala/valacodevisitor.h>

struct _ValaReferenceTransferExpressionPrivate {
	ValaExpression* _inner;
};
#define VALA_REFERENCE_TRANSFER_EXPRESSION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_REFERENCE_TRANSFER_EXPRESSION, ValaReferenceTransferExpressionPrivate))
enum  {
	VALA_REFERENCE_TRANSFER_EXPRESSION_DUMMY_PROPERTY,
	VALA_REFERENCE_TRANSFER_EXPRESSION_INNER
};
static void vala_reference_transfer_expression_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_reference_transfer_expression_real_replace (ValaCodeNode* base, ValaCodeNode* old_node, ValaCodeNode* new_node);
static gpointer vala_reference_transfer_expression_parent_class = NULL;
static void vala_reference_transfer_expression_dispose (GObject * obj);


/**
 * Creates a new reference transfer expression.
 *
 * @param inner variable whose reference is to be transferred
 * @return      newly created reference transfer expression
 */
ValaReferenceTransferExpression* vala_reference_transfer_expression_new (ValaExpression* inner, ValaSourceReference* source_reference)
{
	GParameter * __params;
	GParameter * __params_it;
	ValaReferenceTransferExpression * self;
	g_return_val_if_fail (VALA_IS_EXPRESSION (inner), NULL);
	g_return_val_if_fail (source_reference == NULL || VALA_IS_SOURCE_REFERENCE (source_reference), NULL);
	__params = g_new0 (GParameter, 1);
	__params_it = __params;
	(__params_it->name = "inner", g_value_init (&__params_it->value, VALA_TYPE_EXPRESSION), g_value_set_object (&__params_it->value, inner), __params_it++);
	self = g_object_newv (VALA_TYPE_REFERENCE_TRANSFER_EXPRESSION, __params_it - __params, __params);
	vala_code_node_set_source_reference (VALA_CODE_NODE (self), source_reference);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


static void vala_reference_transfer_expression_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor)
{
	ValaReferenceTransferExpression * self;
	self = ((ValaReferenceTransferExpression*) base);
	g_return_if_fail (VALA_IS_CODE_VISITOR (visitor));
	vala_code_node_accept (VALA_CODE_NODE (vala_reference_transfer_expression_get_inner (self)), visitor);
	vala_code_visitor_visit_reference_transfer_expression (visitor, self);
}


static void vala_reference_transfer_expression_real_replace (ValaCodeNode* base, ValaCodeNode* old_node, ValaCodeNode* new_node)
{
	ValaReferenceTransferExpression * self;
	self = ((ValaReferenceTransferExpression*) base);
	g_return_if_fail (VALA_IS_CODE_NODE (old_node));
	g_return_if_fail (VALA_IS_CODE_NODE (new_node));
	if (VALA_CODE_NODE (vala_reference_transfer_expression_get_inner (self)) == old_node) {
		vala_reference_transfer_expression_set_inner (self, VALA_EXPRESSION (new_node));
	}
}


ValaExpression* vala_reference_transfer_expression_get_inner (ValaReferenceTransferExpression* self)
{
	g_return_val_if_fail (VALA_IS_REFERENCE_TRANSFER_EXPRESSION (self), NULL);
	return self->priv->_inner;
}


void vala_reference_transfer_expression_set_inner (ValaReferenceTransferExpression* self, ValaExpression* value)
{
	ValaExpression* _tmp1;
	g_return_if_fail (VALA_IS_REFERENCE_TRANSFER_EXPRESSION (self));
	_tmp1 = NULL;
	self->priv->_inner = (_tmp1 = g_object_ref (value), (self->priv->_inner == NULL ? NULL : (self->priv->_inner = (g_object_unref (self->priv->_inner), NULL))), _tmp1);
	vala_code_node_set_parent_node (VALA_CODE_NODE (self->priv->_inner), VALA_CODE_NODE (self));
}


static void vala_reference_transfer_expression_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec)
{
	ValaReferenceTransferExpression * self;
	self = VALA_REFERENCE_TRANSFER_EXPRESSION (object);
	switch (property_id) {
		case VALA_REFERENCE_TRANSFER_EXPRESSION_INNER:
		g_value_set_object (value, vala_reference_transfer_expression_get_inner (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_reference_transfer_expression_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec)
{
	ValaReferenceTransferExpression * self;
	self = VALA_REFERENCE_TRANSFER_EXPRESSION (object);
	switch (property_id) {
		case VALA_REFERENCE_TRANSFER_EXPRESSION_INNER:
		vala_reference_transfer_expression_set_inner (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_reference_transfer_expression_class_init (ValaReferenceTransferExpressionClass * klass)
{
	vala_reference_transfer_expression_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaReferenceTransferExpressionPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_reference_transfer_expression_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_reference_transfer_expression_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_reference_transfer_expression_dispose;
	VALA_CODE_NODE_CLASS (klass)->accept = vala_reference_transfer_expression_real_accept;
	VALA_CODE_NODE_CLASS (klass)->replace = vala_reference_transfer_expression_real_replace;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_REFERENCE_TRANSFER_EXPRESSION_INNER, g_param_spec_object ("inner", "foo", "bar", VALA_TYPE_EXPRESSION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void vala_reference_transfer_expression_init (ValaReferenceTransferExpression * self)
{
	self->priv = VALA_REFERENCE_TRANSFER_EXPRESSION_GET_PRIVATE (self);
}


static void vala_reference_transfer_expression_dispose (GObject * obj)
{
	ValaReferenceTransferExpression * self;
	ValaReferenceTransferExpressionClass * klass;
	GObjectClass * parent_class;
	self = VALA_REFERENCE_TRANSFER_EXPRESSION (obj);
	(self->priv->_inner == NULL ? NULL : (self->priv->_inner = (g_object_unref (self->priv->_inner), NULL)));
	klass = VALA_REFERENCE_TRANSFER_EXPRESSION_CLASS (g_type_class_peek (VALA_TYPE_REFERENCE_TRANSFER_EXPRESSION));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	parent_class->dispose (obj);
}


GType vala_reference_transfer_expression_get_type (void)
{
	static GType vala_reference_transfer_expression_type_id = 0;
	if (G_UNLIKELY (vala_reference_transfer_expression_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaReferenceTransferExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_reference_transfer_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaReferenceTransferExpression), 0, (GInstanceInitFunc) vala_reference_transfer_expression_init };
		vala_reference_transfer_expression_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaReferenceTransferExpression", &g_define_type_info, 0);
	}
	return vala_reference_transfer_expression_type_id;
}




