/* valaformalparameter.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter, Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <rasa@gmx.ch>
 */

#include "valaformalparameter.h"
#include <vala/valatypereference.h>
#include <vala/valaexpression.h>
#include <vala/valasourcereference.h>
#include <vala/valaformalparameter.h>
#include <vala/valacodevisitor.h>
#include <vala/valacallback.h>

struct _ValaFormalParameterPrivate {
	ValaTypeReference* _type_reference;
	gboolean _ellipsis;
	ValaExpression* _default_expression;
	gboolean _no_array_length;
	gboolean _construct_parameter;
};
#define VALA_FORMAL_PARAMETER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_FORMAL_PARAMETER, ValaFormalParameterPrivate))
enum  {
	VALA_FORMAL_PARAMETER_DUMMY_PROPERTY,
	VALA_FORMAL_PARAMETER_TYPE_REFERENCE,
	VALA_FORMAL_PARAMETER_ELLIPSIS,
	VALA_FORMAL_PARAMETER_DEFAULT_EXPRESSION,
	VALA_FORMAL_PARAMETER_NO_ARRAY_LENGTH,
	VALA_FORMAL_PARAMETER_CONSTRUCT_PARAMETER
};
static void vala_formal_parameter_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_formal_parameter_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
static GeeCollection* vala_formal_parameter_real_get_parameters (ValaInvokable* base);
static ValaTypeReference* vala_formal_parameter_real_get_return_type (ValaInvokable* base);
static gboolean vala_formal_parameter_real_is_invokable (ValaInvokable* base);
static GObject * vala_formal_parameter_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gpointer vala_formal_parameter_parent_class = NULL;
static ValaInvokableIface* vala_formal_parameter_vala_invokable_parent_iface = NULL;
static void vala_formal_parameter_dispose (GObject * obj);


/**
 * Creates a new formal parameter.
 *
 * @param name   parameter name
 * @param type   parameter type
 * @param source reference to source code
 * @return       newly created formal parameter
 */
ValaFormalParameter* vala_formal_parameter_new (const char* _name, ValaTypeReference* type, ValaSourceReference* source)
{
	ValaFormalParameter * self;
	g_return_val_if_fail (_name != NULL, NULL);
	g_return_val_if_fail (type == NULL || VALA_IS_TYPE_REFERENCE (type), NULL);
	g_return_val_if_fail (source == NULL || VALA_IS_SOURCE_REFERENCE (source), NULL);
	self = g_object_newv (VALA_TYPE_FORMAL_PARAMETER, 0, NULL);
	vala_symbol_set_name (VALA_SYMBOL (self), _name);
	vala_formal_parameter_set_type_reference (self, type);
	vala_code_node_set_source_reference (VALA_CODE_NODE (self), source);
	return self;
}


/**
 * Creates a new ellipsis parameter representing an indefinite number of
 * parameters.
 */
ValaFormalParameter* vala_formal_parameter_new_with_ellipsis (ValaSourceReference* source)
{
	ValaFormalParameter * self;
	g_return_val_if_fail (source == NULL || VALA_IS_SOURCE_REFERENCE (source), NULL);
	self = g_object_newv (VALA_TYPE_FORMAL_PARAMETER, 0, NULL);
	vala_formal_parameter_set_ellipsis (self, TRUE);
	vala_code_node_set_source_reference (VALA_CODE_NODE (self), source);
	return self;
}


static void vala_formal_parameter_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor)
{
	ValaFormalParameter * self;
	self = ((ValaFormalParameter*) base);
	g_return_if_fail (VALA_IS_CODE_VISITOR (visitor));
	vala_code_visitor_visit_formal_parameter (visitor, self);
}


static void vala_formal_parameter_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor)
{
	ValaFormalParameter * self;
	self = ((ValaFormalParameter*) base);
	g_return_if_fail (VALA_IS_CODE_VISITOR (visitor));
	if (!vala_formal_parameter_get_ellipsis (self)) {
		vala_code_node_accept (VALA_CODE_NODE (vala_formal_parameter_get_type_reference (self)), visitor);
		if (vala_formal_parameter_get_default_expression (self) != NULL) {
			vala_code_node_accept (VALA_CODE_NODE (vala_formal_parameter_get_default_expression (self)), visitor);
		}
	}
}


static GeeCollection* vala_formal_parameter_real_get_parameters (ValaInvokable* base)
{
	ValaFormalParameter * self;
	ValaCallback* _tmp1;
	ValaCallback* cb;
	GeeCollection* _tmp2;
	self = ((ValaFormalParameter*) base);
	if (!vala_invokable_is_invokable (VALA_INVOKABLE (self))) {
		return GEE_COLLECTION (NULL);
	}
	_tmp1 = NULL;
	cb = (_tmp1 = VALA_CALLBACK (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (self))), (_tmp1 == NULL ? NULL : g_object_ref (_tmp1)));
	_tmp2 = NULL;
	return (_tmp2 = vala_callback_get_parameters (cb), (cb == NULL ? NULL : (cb = (g_object_unref (cb), NULL))), _tmp2);
	(cb == NULL ? NULL : (cb = (g_object_unref (cb), NULL)));
}


static ValaTypeReference* vala_formal_parameter_real_get_return_type (ValaInvokable* base)
{
	ValaFormalParameter * self;
	ValaCallback* _tmp1;
	ValaCallback* cb;
	ValaTypeReference* _tmp2;
	ValaTypeReference* _tmp3;
	self = ((ValaFormalParameter*) base);
	if (!vala_invokable_is_invokable (VALA_INVOKABLE (self))) {
		return VALA_TYPE_REFERENCE (NULL);
	}
	_tmp1 = NULL;
	cb = (_tmp1 = VALA_CALLBACK (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (self))), (_tmp1 == NULL ? NULL : g_object_ref (_tmp1)));
	_tmp2 = NULL;
	_tmp3 = NULL;
	return (_tmp3 = (_tmp2 = vala_callback_get_return_type (cb), (_tmp2 == NULL ? NULL : g_object_ref (_tmp2))), (cb == NULL ? NULL : (cb = (g_object_unref (cb), NULL))), _tmp3);
	(cb == NULL ? NULL : (cb = (g_object_unref (cb), NULL)));
}


static gboolean vala_formal_parameter_real_is_invokable (ValaInvokable* base)
{
	ValaFormalParameter * self;
	self = ((ValaFormalParameter*) base);
	return (VALA_IS_CALLBACK (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (self))));
}


ValaTypeReference* vala_formal_parameter_get_type_reference (ValaFormalParameter* self)
{
	g_return_val_if_fail (VALA_IS_FORMAL_PARAMETER (self), NULL);
	return self->priv->_type_reference;
}


void vala_formal_parameter_set_type_reference (ValaFormalParameter* self, ValaTypeReference* value)
{
	ValaTypeReference* _tmp2;
	ValaTypeReference* _tmp1;
	g_return_if_fail (VALA_IS_FORMAL_PARAMETER (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_type_reference = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_type_reference == NULL ? NULL : (self->priv->_type_reference = (g_object_unref (self->priv->_type_reference), NULL))), _tmp2);
}


gboolean vala_formal_parameter_get_ellipsis (ValaFormalParameter* self)
{
	g_return_val_if_fail (VALA_IS_FORMAL_PARAMETER (self), FALSE);
	return self->priv->_ellipsis;
}


void vala_formal_parameter_set_ellipsis (ValaFormalParameter* self, gboolean value)
{
	g_return_if_fail (VALA_IS_FORMAL_PARAMETER (self));
	self->priv->_ellipsis = value;
}


ValaExpression* vala_formal_parameter_get_default_expression (ValaFormalParameter* self)
{
	g_return_val_if_fail (VALA_IS_FORMAL_PARAMETER (self), NULL);
	return self->priv->_default_expression;
}


void vala_formal_parameter_set_default_expression (ValaFormalParameter* self, ValaExpression* value)
{
	ValaExpression* _tmp2;
	ValaExpression* _tmp1;
	g_return_if_fail (VALA_IS_FORMAL_PARAMETER (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_default_expression = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_default_expression == NULL ? NULL : (self->priv->_default_expression = (g_object_unref (self->priv->_default_expression), NULL))), _tmp2);
}


gboolean vala_formal_parameter_get_no_array_length (ValaFormalParameter* self)
{
	g_return_val_if_fail (VALA_IS_FORMAL_PARAMETER (self), FALSE);
	return self->priv->_no_array_length;
}


void vala_formal_parameter_set_no_array_length (ValaFormalParameter* self, gboolean value)
{
	g_return_if_fail (VALA_IS_FORMAL_PARAMETER (self));
	self->priv->_no_array_length = value;
}


gboolean vala_formal_parameter_get_construct_parameter (ValaFormalParameter* self)
{
	g_return_val_if_fail (VALA_IS_FORMAL_PARAMETER (self), FALSE);
	return self->priv->_construct_parameter;
}


void vala_formal_parameter_set_construct_parameter (ValaFormalParameter* self, gboolean value)
{
	g_return_if_fail (VALA_IS_FORMAL_PARAMETER (self));
	self->priv->_construct_parameter = value;
}


static GObject * vala_formal_parameter_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties)
{
	GObject * obj;
	ValaFormalParameterClass * klass;
	GObjectClass * parent_class;
	ValaFormalParameter * self;
	klass = VALA_FORMAL_PARAMETER_CLASS (g_type_class_peek (VALA_TYPE_FORMAL_PARAMETER));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = VALA_FORMAL_PARAMETER (obj);
	{
		vala_symbol_set_access (VALA_SYMBOL (self), VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	}
	return obj;
}


static void vala_formal_parameter_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec)
{
	ValaFormalParameter * self;
	self = VALA_FORMAL_PARAMETER (object);
	switch (property_id) {
		case VALA_FORMAL_PARAMETER_TYPE_REFERENCE:
		g_value_set_object (value, vala_formal_parameter_get_type_reference (self));
		break;
		case VALA_FORMAL_PARAMETER_ELLIPSIS:
		g_value_set_boolean (value, vala_formal_parameter_get_ellipsis (self));
		break;
		case VALA_FORMAL_PARAMETER_DEFAULT_EXPRESSION:
		g_value_set_object (value, vala_formal_parameter_get_default_expression (self));
		break;
		case VALA_FORMAL_PARAMETER_NO_ARRAY_LENGTH:
		g_value_set_boolean (value, vala_formal_parameter_get_no_array_length (self));
		break;
		case VALA_FORMAL_PARAMETER_CONSTRUCT_PARAMETER:
		g_value_set_boolean (value, vala_formal_parameter_get_construct_parameter (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_formal_parameter_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec)
{
	ValaFormalParameter * self;
	self = VALA_FORMAL_PARAMETER (object);
	switch (property_id) {
		case VALA_FORMAL_PARAMETER_TYPE_REFERENCE:
		vala_formal_parameter_set_type_reference (self, g_value_get_object (value));
		break;
		case VALA_FORMAL_PARAMETER_ELLIPSIS:
		vala_formal_parameter_set_ellipsis (self, g_value_get_boolean (value));
		break;
		case VALA_FORMAL_PARAMETER_DEFAULT_EXPRESSION:
		vala_formal_parameter_set_default_expression (self, g_value_get_object (value));
		break;
		case VALA_FORMAL_PARAMETER_NO_ARRAY_LENGTH:
		vala_formal_parameter_set_no_array_length (self, g_value_get_boolean (value));
		break;
		case VALA_FORMAL_PARAMETER_CONSTRUCT_PARAMETER:
		vala_formal_parameter_set_construct_parameter (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_formal_parameter_class_init (ValaFormalParameterClass * klass)
{
	vala_formal_parameter_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaFormalParameterPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_formal_parameter_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_formal_parameter_set_property;
	G_OBJECT_CLASS (klass)->constructor = vala_formal_parameter_constructor;
	G_OBJECT_CLASS (klass)->dispose = vala_formal_parameter_dispose;
	VALA_CODE_NODE_CLASS (klass)->accept = vala_formal_parameter_real_accept;
	VALA_CODE_NODE_CLASS (klass)->accept_children = vala_formal_parameter_real_accept_children;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_FORMAL_PARAMETER_TYPE_REFERENCE, g_param_spec_object ("type-reference", "foo", "bar", VALA_TYPE_TYPE_REFERENCE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_FORMAL_PARAMETER_ELLIPSIS, g_param_spec_boolean ("ellipsis", "foo", "bar", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_FORMAL_PARAMETER_DEFAULT_EXPRESSION, g_param_spec_object ("default-expression", "foo", "bar", VALA_TYPE_EXPRESSION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_FORMAL_PARAMETER_NO_ARRAY_LENGTH, g_param_spec_boolean ("no-array-length", "foo", "bar", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_FORMAL_PARAMETER_CONSTRUCT_PARAMETER, g_param_spec_boolean ("construct-parameter", "foo", "bar", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_formal_parameter_vala_invokable_interface_init (ValaInvokableIface * iface)
{
	vala_formal_parameter_vala_invokable_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_parameters = vala_formal_parameter_real_get_parameters;
	iface->get_return_type = vala_formal_parameter_real_get_return_type;
	iface->is_invokable = vala_formal_parameter_real_is_invokable;
}


static void vala_formal_parameter_init (ValaFormalParameter * self)
{
	self->priv = VALA_FORMAL_PARAMETER_GET_PRIVATE (self);
}


static void vala_formal_parameter_dispose (GObject * obj)
{
	ValaFormalParameter * self;
	ValaFormalParameterClass * klass;
	GObjectClass * parent_class;
	self = VALA_FORMAL_PARAMETER (obj);
	(self->priv->_type_reference == NULL ? NULL : (self->priv->_type_reference = (g_object_unref (self->priv->_type_reference), NULL)));
	(self->priv->_default_expression == NULL ? NULL : (self->priv->_default_expression = (g_object_unref (self->priv->_default_expression), NULL)));
	klass = VALA_FORMAL_PARAMETER_CLASS (g_type_class_peek (VALA_TYPE_FORMAL_PARAMETER));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	parent_class->dispose (obj);
}


GType vala_formal_parameter_get_type (void)
{
	static GType vala_formal_parameter_type_id = 0;
	if (G_UNLIKELY (vala_formal_parameter_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaFormalParameterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_formal_parameter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaFormalParameter), 0, (GInstanceInitFunc) vala_formal_parameter_init };
		static const GInterfaceInfo vala_invokable_info = { (GInterfaceInitFunc) vala_formal_parameter_vala_invokable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		vala_formal_parameter_type_id = g_type_register_static (VALA_TYPE_SYMBOL, "ValaFormalParameter", &g_define_type_info, 0);
		g_type_add_interface_static (vala_formal_parameter_type_id, VALA_TYPE_INVOKABLE, &vala_invokable_info);
	}
	return vala_formal_parameter_type_id;
}




