/* valaifstatement.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "valaifstatement.h"
#include <vala/valablock.h>
#include <vala/valaexpression.h>
#include <vala/valasourcereference.h>
#include <vala/valaifstatement.h>
#include <vala/valacodevisitor.h>

struct _ValaIfStatementPrivate {
	ValaBlock* _true_statement;
	ValaBlock* _false_statement;
	ValaExpression* _condition;
};
#define VALA_IF_STATEMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_IF_STATEMENT, ValaIfStatementPrivate))
enum  {
	VALA_IF_STATEMENT_DUMMY_PROPERTY,
	VALA_IF_STATEMENT_CONDITION,
	VALA_IF_STATEMENT_TRUE_STATEMENT,
	VALA_IF_STATEMENT_FALSE_STATEMENT
};
static void vala_if_statement_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_if_statement_real_replace (ValaCodeNode* base, ValaCodeNode* old_node, ValaCodeNode* new_node);
static gpointer vala_if_statement_parent_class = NULL;
static ValaStatementIface* vala_if_statement_vala_statement_parent_iface = NULL;
static void vala_if_statement_dispose (GObject * obj);


/**
 * Creates a new if statement.
 *
 * @param cond       a boolean condition
 * @param true_stmt  statement to be evaluated if condition is true
 * @param false_stmt statement to be evaluated if condition is false
 * @return           newly created if statement
 */
ValaIfStatement* vala_if_statement_new (ValaExpression* cond, ValaBlock* true_stmt, ValaBlock* false_stmt, ValaSourceReference* source)
{
	GParameter * __params;
	GParameter * __params_it;
	ValaIfStatement * self;
	g_return_val_if_fail (VALA_IS_EXPRESSION (cond), NULL);
	g_return_val_if_fail (VALA_IS_BLOCK (true_stmt), NULL);
	g_return_val_if_fail (false_stmt == NULL || VALA_IS_BLOCK (false_stmt), NULL);
	g_return_val_if_fail (source == NULL || VALA_IS_SOURCE_REFERENCE (source), NULL);
	__params = g_new0 (GParameter, 3);
	__params_it = __params;
	(__params_it->name = "condition", g_value_init (&__params_it->value, VALA_TYPE_EXPRESSION), g_value_set_object (&__params_it->value, cond), __params_it++);
	(__params_it->name = "true-statement", g_value_init (&__params_it->value, VALA_TYPE_BLOCK), g_value_set_object (&__params_it->value, true_stmt), __params_it++);
	(__params_it->name = "false-statement", g_value_init (&__params_it->value, VALA_TYPE_BLOCK), g_value_set_object (&__params_it->value, false_stmt), __params_it++);
	self = g_object_newv (VALA_TYPE_IF_STATEMENT, __params_it - __params, __params);
	vala_code_node_set_source_reference (VALA_CODE_NODE (self), source);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


static void vala_if_statement_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor)
{
	ValaIfStatement * self;
	self = ((ValaIfStatement*) base);
	g_return_if_fail (VALA_IS_CODE_VISITOR (visitor));
	vala_code_node_accept (VALA_CODE_NODE (vala_if_statement_get_condition (self)), visitor);
	vala_code_visitor_visit_end_full_expression (visitor, vala_if_statement_get_condition (self));
	vala_code_node_accept (VALA_CODE_NODE (vala_if_statement_get_true_statement (self)), visitor);
	if (vala_if_statement_get_false_statement (self) != NULL) {
		vala_code_node_accept (VALA_CODE_NODE (vala_if_statement_get_false_statement (self)), visitor);
	}
	vala_code_visitor_visit_if_statement (visitor, self);
}


static void vala_if_statement_real_replace (ValaCodeNode* base, ValaCodeNode* old_node, ValaCodeNode* new_node)
{
	ValaIfStatement * self;
	self = ((ValaIfStatement*) base);
	g_return_if_fail (VALA_IS_CODE_NODE (old_node));
	g_return_if_fail (VALA_IS_CODE_NODE (new_node));
	if (VALA_CODE_NODE (vala_if_statement_get_condition (self)) == old_node) {
		vala_if_statement_set_condition (self, VALA_EXPRESSION (new_node));
	}
}


ValaExpression* vala_if_statement_get_condition (ValaIfStatement* self)
{
	g_return_val_if_fail (VALA_IS_IF_STATEMENT (self), NULL);
	return self->priv->_condition;
}


void vala_if_statement_set_condition (ValaIfStatement* self, ValaExpression* value)
{
	ValaExpression* __temp1;
	g_return_if_fail (VALA_IS_IF_STATEMENT (self));
	__temp1 = NULL;
	self->priv->_condition = (__temp1 = g_object_ref (value), (self->priv->_condition == NULL ? NULL : (self->priv->_condition = (g_object_unref (self->priv->_condition), NULL))), __temp1);
	vala_code_node_set_parent_node (VALA_CODE_NODE (self->priv->_condition), VALA_CODE_NODE (self));
}


ValaBlock* vala_if_statement_get_true_statement (ValaIfStatement* self)
{
	g_return_val_if_fail (VALA_IS_IF_STATEMENT (self), NULL);
	return self->priv->_true_statement;
}


void vala_if_statement_set_true_statement (ValaIfStatement* self, ValaBlock* value)
{
	ValaBlock* __temp3;
	g_return_if_fail (VALA_IS_IF_STATEMENT (self));
	__temp3 = NULL;
	self->priv->_true_statement = (__temp3 = g_object_ref (value), (self->priv->_true_statement == NULL ? NULL : (self->priv->_true_statement = (g_object_unref (self->priv->_true_statement), NULL))), __temp3);
}


ValaBlock* vala_if_statement_get_false_statement (ValaIfStatement* self)
{
	g_return_val_if_fail (VALA_IS_IF_STATEMENT (self), NULL);
	return self->priv->_false_statement;
}


void vala_if_statement_set_false_statement (ValaIfStatement* self, ValaBlock* value)
{
	ValaBlock* __temp6;
	ValaBlock* __temp5;
	g_return_if_fail (VALA_IS_IF_STATEMENT (self));
	__temp6 = NULL;
	__temp5 = NULL;
	self->priv->_false_statement = (__temp6 = (__temp5 = value, (__temp5 == NULL ? NULL : g_object_ref (__temp5))), (self->priv->_false_statement == NULL ? NULL : (self->priv->_false_statement = (g_object_unref (self->priv->_false_statement), NULL))), __temp6);
}


static void vala_if_statement_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec)
{
	ValaIfStatement * self;
	self = VALA_IF_STATEMENT (object);
	switch (property_id) {
		case VALA_IF_STATEMENT_CONDITION:
		g_value_set_object (value, vala_if_statement_get_condition (self));
		break;
		case VALA_IF_STATEMENT_TRUE_STATEMENT:
		g_value_set_object (value, vala_if_statement_get_true_statement (self));
		break;
		case VALA_IF_STATEMENT_FALSE_STATEMENT:
		g_value_set_object (value, vala_if_statement_get_false_statement (self));
		break;
	}
}


static void vala_if_statement_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec)
{
	ValaIfStatement * self;
	self = VALA_IF_STATEMENT (object);
	switch (property_id) {
		case VALA_IF_STATEMENT_CONDITION:
		vala_if_statement_set_condition (self, g_value_get_object (value));
		break;
		case VALA_IF_STATEMENT_TRUE_STATEMENT:
		vala_if_statement_set_true_statement (self, g_value_get_object (value));
		break;
		case VALA_IF_STATEMENT_FALSE_STATEMENT:
		vala_if_statement_set_false_statement (self, g_value_get_object (value));
		break;
	}
}


static void vala_if_statement_class_init (ValaIfStatementClass * klass)
{
	vala_if_statement_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaIfStatementPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_if_statement_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_if_statement_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_if_statement_dispose;
	VALA_CODE_NODE_CLASS (klass)->accept = vala_if_statement_real_accept;
	VALA_CODE_NODE_CLASS (klass)->replace = vala_if_statement_real_replace;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_IF_STATEMENT_CONDITION, g_param_spec_object ("condition", "foo", "bar", VALA_TYPE_EXPRESSION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_IF_STATEMENT_TRUE_STATEMENT, g_param_spec_object ("true-statement", "foo", "bar", VALA_TYPE_BLOCK, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_IF_STATEMENT_FALSE_STATEMENT, g_param_spec_object ("false-statement", "foo", "bar", VALA_TYPE_BLOCK, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void vala_if_statement_vala_statement_interface_init (ValaStatementIface * iface)
{
	vala_if_statement_vala_statement_parent_iface = g_type_interface_peek_parent (iface);
}


static void vala_if_statement_init (ValaIfStatement * self)
{
	self->priv = VALA_IF_STATEMENT_GET_PRIVATE (self);
}


static void vala_if_statement_dispose (GObject * obj)
{
	ValaIfStatement * self;
	ValaIfStatementClass * klass;
	GObjectClass * parent_class;
	self = VALA_IF_STATEMENT (obj);
	(self->priv->_true_statement == NULL ? NULL : (self->priv->_true_statement = (g_object_unref (self->priv->_true_statement), NULL)));
	(self->priv->_false_statement == NULL ? NULL : (self->priv->_false_statement = (g_object_unref (self->priv->_false_statement), NULL)));
	(self->priv->_condition == NULL ? NULL : (self->priv->_condition = (g_object_unref (self->priv->_condition), NULL)));
	klass = VALA_IF_STATEMENT_CLASS (g_type_class_peek (VALA_TYPE_IF_STATEMENT));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	parent_class->dispose (obj);
}


GType vala_if_statement_get_type (void)
{
	static GType vala_if_statement_type_id = 0;
	if (G_UNLIKELY (vala_if_statement_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaIfStatementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_if_statement_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaIfStatement), 0, (GInstanceInitFunc) vala_if_statement_init };
		static const GInterfaceInfo vala_statement_info = { (GInterfaceInitFunc) vala_if_statement_vala_statement_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		vala_if_statement_type_id = g_type_register_static (VALA_TYPE_CODE_NODE, "ValaIfStatement", &g_define_type_info, 0);
		g_type_add_interface_static (vala_if_statement_type_id, VALA_TYPE_STATEMENT, &vala_statement_info);
	}
	return vala_if_statement_type_id;
}




