/* valatyperegisterfunction.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "valatyperegisterfunction.h"
#include <vala/valasymbol.h>
#include <ccode/valaccodeblock.h>
#include <ccode/valaccodedeclaration.h>
#include <ccode/valaccodevariabledeclarator.h>
#include <ccode/valaccodeconstant.h>
#include <ccode/valaccodeexpression.h>
#include <ccode/valaccodedeclarator.h>
#include <ccode/valaccodemodifiers.h>
#include <ccode/valaccodenode.h>
#include <ccode/valaccodefunction.h>
#include <ccode/valaccodeformalparameter.h>
#include <ccode/valaccodereturnstatement.h>
#include <ccode/valaccodeidentifier.h>
#include <ccode/valaccodefunctioncall.h>
#include <ccode/valaccodeexpressionstatement.h>
#include <ccode/valaccodeassignment.h>
#include <ccode/valaccodebinaryexpression.h>
#include <ccode/valaccodeifstatement.h>
#include <ccode/valaccodestatement.h>
#include <gobject/valatyperegisterfunction.h>

struct _ValaTypeRegisterFunctionPrivate {
	ValaCCodeFragment* declaration_fragment;
	ValaCCodeFragment* definition_fragment;
};
#define VALA_TYPE_REGISTER_FUNCTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_TYPE_REGISTER_FUNCTION, ValaTypeRegisterFunctionPrivate))
enum  {
	VALA_TYPE_REGISTER_FUNCTION_DUMMY_PROPERTY
};
static char* vala_type_register_function_real_get_type_flags (ValaTypeRegisterFunction* self);
static ValaCCodeFragment* vala_type_register_function_real_get_type_interface_init_declaration (ValaTypeRegisterFunction* self);
static gpointer vala_type_register_function_parent_class = NULL;
static void vala_type_register_function_dispose (GObject * obj);


/**
 * Constructs the C function from the specified type.
 */
void vala_type_register_function_init_from_type (ValaTypeRegisterFunction* self, gboolean plugin)
{
	char* __temp1;
	ValaDataType* __temp0;
	char* __temp2;
	char* type_id_name;
	ValaCCodeBlock* type_block;
	ValaCCodeDeclaration* cdecl_;
	ValaCCodeVariableDeclarator* __temp4;
	ValaCCodeConstant* __temp3;
	ValaCCodeFunction* fun;
	ValaCCodeBlock* type_init;
	ValaCCodeDeclaration* ctypedecl;
	ValaCCodeVariableDeclarator* __temp29;
	ValaCCodeConstant* __temp28;
	char* __temp27;
	char* __temp26;
	char* __temp25;
	char* __temp24;
	char* __temp23;
	char* __temp22;
	ValaCCodeFragment* __temp30;
	ValaCCodeFunctionCall* reg_call;
	ValaCCodeIdentifier* __temp37;
	char* __temp36;
	ValaCCodeConstant* __temp41;
	char* __temp40;
	char* __temp39;
	ValaDataType* __temp38;
	ValaCCodeIdentifier* __temp42;
	ValaCCodeConstant* __temp44;
	char* __temp43;
	ValaCCodeExpressionStatement* __temp47;
	ValaCCodeAssignment* __temp46;
	ValaCCodeIdentifier* __temp45;
	ValaCCodeFragment* __temp48;
	ValaCCodeReturnStatement* __temp57;
	ValaCCodeIdentifier* __temp56;
	ValaCCodeFunction* __temp58;
	g_return_if_fail (VALA_IS_TYPE_REGISTER_FUNCTION (self));
	__temp1 = NULL;
	__temp0 = NULL;
	__temp2 = NULL;
	type_id_name = (__temp2 = g_strdup_printf ("%s_type_id", (__temp1 = vala_symbol_get_lower_case_cname (VALA_SYMBOL ((__temp0 = vala_type_register_function_get_type_declaration (self))), NULL))), (__temp1 = (g_free (__temp1), NULL)), (__temp0 = (g_object_unref (__temp0), NULL)), __temp2);
	type_block = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
	cdecl_ = vala_ccode_declaration_new ("GType");
	__temp4 = NULL;
	__temp3 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((__temp4 = vala_ccode_variable_declarator_new_with_initializer (type_id_name, VALA_CCODE_EXPRESSION ((__temp3 = vala_ccode_constant_new ("0")))))));
	(__temp4 == NULL ? NULL : (__temp4 = (g_object_unref (__temp4), NULL)));
	(__temp3 == NULL ? NULL : (__temp3 = (g_object_unref (__temp3), NULL)));
	vala_ccode_declaration_set_modifiers (cdecl_, VALA_CCODE_MODIFIERS_STATIC);
	if (!plugin) {
		vala_ccode_block_add_statement (type_block, VALA_CCODE_NODE (cdecl_));
	} else {
		vala_ccode_fragment_append (self->priv->definition_fragment, VALA_CCODE_NODE (cdecl_));
	}
	fun = NULL;
	if (!plugin) {
		ValaCCodeFunction* __temp8;
		char* __temp7;
		char* __temp6;
		ValaDataType* __temp5;
		__temp8 = NULL;
		__temp7 = NULL;
		__temp6 = NULL;
		__temp5 = NULL;
		fun = (__temp8 = vala_ccode_function_new ((__temp7 = g_strdup_printf ("%s_get_type", (__temp6 = vala_symbol_get_lower_case_cname (VALA_SYMBOL ((__temp5 = vala_type_register_function_get_type_declaration (self))), NULL)))), "GType"), (fun == NULL ? NULL : (fun = (g_object_unref (fun), NULL))), __temp8);
		(__temp7 = (g_free (__temp7), NULL));
		(__temp6 = (g_free (__temp6), NULL));
		(__temp5 = (g_object_unref (__temp5), NULL));
	} else {
		ValaCCodeFunction* __temp12;
		char* __temp11;
		char* __temp10;
		ValaDataType* __temp9;
		ValaCCodeFormalParameter* __temp13;
		char* __temp16;
		char* __temp15;
		ValaDataType* __temp14;
		ValaCCodeFunction* __temp17;
		ValaCCodeFunction* get_fun;
		ValaCCodeFunction* __temp18;
		ValaCCodeBlock* __temp19;
		ValaCCodeReturnStatement* __temp21;
		ValaCCodeIdentifier* __temp20;
		__temp12 = NULL;
		__temp11 = NULL;
		__temp10 = NULL;
		__temp9 = NULL;
		fun = (__temp12 = vala_ccode_function_new ((__temp11 = g_strdup_printf ("%s_register_type", (__temp10 = vala_symbol_get_lower_case_cname (VALA_SYMBOL ((__temp9 = vala_type_register_function_get_type_declaration (self))), NULL)))), "GType"), (fun == NULL ? NULL : (fun = (g_object_unref (fun), NULL))), __temp12);
		(__temp11 = (g_free (__temp11), NULL));
		(__temp10 = (g_free (__temp10), NULL));
		(__temp9 = (g_object_unref (__temp9), NULL));
		__temp13 = NULL;
		vala_ccode_function_add_parameter (fun, (__temp13 = vala_ccode_formal_parameter_new ("module", "GTypeModule *")));
		(__temp13 == NULL ? NULL : (__temp13 = (g_object_unref (__temp13), NULL)));
		__temp16 = NULL;
		__temp15 = NULL;
		__temp14 = NULL;
		__temp17 = NULL;
		get_fun = (__temp17 = vala_ccode_function_new ((__temp16 = g_strdup_printf ("%s_get_type", (__temp15 = vala_symbol_get_lower_case_cname (VALA_SYMBOL ((__temp14 = vala_type_register_function_get_type_declaration (self))), NULL)))), "GType"), (__temp16 = (g_free (__temp16), NULL)), (__temp15 = (g_free (__temp15), NULL)), (__temp14 = (g_object_unref (__temp14), NULL)), __temp17);
		__temp18 = NULL;
		vala_ccode_fragment_append (self->priv->declaration_fragment, VALA_CCODE_NODE ((__temp18 = vala_ccode_function_copy (get_fun))));
		(__temp18 = (g_object_unref (__temp18), NULL));
		__temp19 = NULL;
		vala_ccode_function_set_block (get_fun, (__temp19 = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL)));
		(__temp19 == NULL ? NULL : (__temp19 = (g_object_unref (__temp19), NULL)));
		__temp21 = NULL;
		__temp20 = NULL;
		vala_ccode_block_add_statement (vala_ccode_function_get_block (get_fun), VALA_CCODE_NODE ((__temp21 = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION ((__temp20 = vala_ccode_identifier_new (type_id_name)))))));
		(__temp21 == NULL ? NULL : (__temp21 = (g_object_unref (__temp21), NULL)));
		(__temp20 == NULL ? NULL : (__temp20 = (g_object_unref (__temp20), NULL)));
		vala_ccode_fragment_append (self->priv->definition_fragment, VALA_CCODE_NODE (get_fun));
		(get_fun == NULL ? NULL : (get_fun = (g_object_unref (get_fun), NULL)));
	}
	type_init = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
	ctypedecl = vala_ccode_declaration_new ("const GTypeInfo");
	vala_ccode_declaration_set_modifiers (ctypedecl, VALA_CCODE_MODIFIERS_STATIC);
	__temp29 = NULL;
	__temp28 = NULL;
	__temp27 = NULL;
	__temp26 = NULL;
	__temp25 = NULL;
	__temp24 = NULL;
	__temp23 = NULL;
	__temp22 = NULL;
	vala_ccode_declaration_add_declarator (ctypedecl, VALA_CCODE_DECLARATOR ((__temp29 = vala_ccode_variable_declarator_new_with_initializer ("g_define_type_info", VALA_CCODE_EXPRESSION ((__temp28 = vala_ccode_constant_new ((__temp27 = g_strdup_printf ("{ sizeof (%s), (GBaseInitFunc) %s, (GBaseFinalizeFunc) NULL, (GClassInitFunc) %s, (GClassFinalizeFunc) NULL, NULL, %s, 0, (GInstanceInitFunc) %s }", (__temp22 = vala_type_register_function_get_type_struct_name (self)), (__temp23 = vala_type_register_function_get_base_init_func_name (self)), (__temp24 = vala_type_register_function_get_class_init_func_name (self)), (__temp25 = vala_type_register_function_get_instance_struct_size (self)), (__temp26 = vala_type_register_function_get_instance_init_func_name (self)))))))))));
	(__temp29 == NULL ? NULL : (__temp29 = (g_object_unref (__temp29), NULL)));
	(__temp28 == NULL ? NULL : (__temp28 = (g_object_unref (__temp28), NULL)));
	(__temp27 = (g_free (__temp27), NULL));
	(__temp26 = (g_free (__temp26), NULL));
	(__temp25 = (g_free (__temp25), NULL));
	(__temp24 = (g_free (__temp24), NULL));
	(__temp23 = (g_free (__temp23), NULL));
	(__temp22 = (g_free (__temp22), NULL));
	vala_ccode_block_add_statement (type_init, VALA_CCODE_NODE (ctypedecl));
	__temp30 = NULL;
	vala_ccode_block_add_statement (type_init, VALA_CCODE_NODE ((__temp30 = vala_type_register_function_get_type_interface_init_declaration (self))));
	(__temp30 = (g_object_unref (__temp30), NULL));
	reg_call = NULL;
	if (!plugin) {
		ValaCCodeFunctionCall* __temp32;
		ValaCCodeIdentifier* __temp31;
		__temp32 = NULL;
		__temp31 = NULL;
		reg_call = (__temp32 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp31 = vala_ccode_identifier_new ("g_type_register_static")))), (reg_call == NULL ? NULL : (reg_call = (g_object_unref (reg_call), NULL))), __temp32);
		(__temp31 == NULL ? NULL : (__temp31 = (g_object_unref (__temp31), NULL)));
	} else {
		ValaCCodeFunctionCall* __temp34;
		ValaCCodeIdentifier* __temp33;
		ValaCCodeIdentifier* __temp35;
		__temp34 = NULL;
		__temp33 = NULL;
		reg_call = (__temp34 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp33 = vala_ccode_identifier_new ("g_type_module_register_type")))), (reg_call == NULL ? NULL : (reg_call = (g_object_unref (reg_call), NULL))), __temp34);
		(__temp33 == NULL ? NULL : (__temp33 = (g_object_unref (__temp33), NULL)));
		__temp35 = NULL;
		vala_ccode_function_call_add_argument (reg_call, VALA_CCODE_EXPRESSION ((__temp35 = vala_ccode_identifier_new ("module"))));
		(__temp35 == NULL ? NULL : (__temp35 = (g_object_unref (__temp35), NULL)));
	}
	__temp37 = NULL;
	__temp36 = NULL;
	vala_ccode_function_call_add_argument (reg_call, VALA_CCODE_EXPRESSION ((__temp37 = vala_ccode_identifier_new ((__temp36 = vala_type_register_function_get_parent_type_name (self))))));
	(__temp37 == NULL ? NULL : (__temp37 = (g_object_unref (__temp37), NULL)));
	(__temp36 = (g_free (__temp36), NULL));
	__temp41 = NULL;
	__temp40 = NULL;
	__temp39 = NULL;
	__temp38 = NULL;
	vala_ccode_function_call_add_argument (reg_call, VALA_CCODE_EXPRESSION ((__temp41 = vala_ccode_constant_new ((__temp40 = g_strdup_printf ("\"%s\"", (__temp39 = vala_data_type_get_cname ((__temp38 = vala_type_register_function_get_type_declaration (self)), FALSE))))))));
	(__temp41 == NULL ? NULL : (__temp41 = (g_object_unref (__temp41), NULL)));
	(__temp40 = (g_free (__temp40), NULL));
	(__temp39 = (g_free (__temp39), NULL));
	(__temp38 = (g_object_unref (__temp38), NULL));
	__temp42 = NULL;
	vala_ccode_function_call_add_argument (reg_call, VALA_CCODE_EXPRESSION ((__temp42 = vala_ccode_identifier_new ("&g_define_type_info"))));
	(__temp42 == NULL ? NULL : (__temp42 = (g_object_unref (__temp42), NULL)));
	__temp44 = NULL;
	__temp43 = NULL;
	vala_ccode_function_call_add_argument (reg_call, VALA_CCODE_EXPRESSION ((__temp44 = vala_ccode_constant_new ((__temp43 = vala_type_register_function_get_type_flags (self))))));
	(__temp44 == NULL ? NULL : (__temp44 = (g_object_unref (__temp44), NULL)));
	(__temp43 = (g_free (__temp43), NULL));
	__temp47 = NULL;
	__temp46 = NULL;
	__temp45 = NULL;
	vala_ccode_block_add_statement (type_init, VALA_CCODE_NODE ((__temp47 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((__temp46 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((__temp45 = vala_ccode_identifier_new (type_id_name))), VALA_CCODE_EXPRESSION (reg_call), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
	(__temp47 == NULL ? NULL : (__temp47 = (g_object_unref (__temp47), NULL)));
	(__temp46 == NULL ? NULL : (__temp46 = (g_object_unref (__temp46), NULL)));
	(__temp45 == NULL ? NULL : (__temp45 = (g_object_unref (__temp45), NULL)));
	__temp48 = NULL;
	vala_ccode_block_add_statement (type_init, VALA_CCODE_NODE ((__temp48 = vala_type_register_function_get_type_interface_init_statements (self))));
	(__temp48 = (g_object_unref (__temp48), NULL));
	if (!plugin) {
		ValaCCodeIdentifier* __temp49;
		ValaCCodeFunctionCall* __temp50;
		ValaCCodeFunctionCall* cond;
		ValaCCodeBinaryExpression* __temp53;
		ValaCCodeConstant* __temp52;
		ValaCCodeIdentifier* __temp51;
		ValaCCodeIfStatement* cif;
		__temp49 = NULL;
		__temp50 = NULL;
		cond = (__temp50 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp49 = vala_ccode_identifier_new ("G_UNLIKELY")))), (__temp49 == NULL ? NULL : (__temp49 = (g_object_unref (__temp49), NULL))), __temp50);
		__temp53 = NULL;
		__temp52 = NULL;
		__temp51 = NULL;
		vala_ccode_function_call_add_argument (cond, VALA_CCODE_EXPRESSION ((__temp53 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, VALA_CCODE_EXPRESSION ((__temp51 = vala_ccode_identifier_new (type_id_name))), VALA_CCODE_EXPRESSION ((__temp52 = vala_ccode_constant_new ("0")))))));
		(__temp53 == NULL ? NULL : (__temp53 = (g_object_unref (__temp53), NULL)));
		(__temp52 == NULL ? NULL : (__temp52 = (g_object_unref (__temp52), NULL)));
		(__temp51 == NULL ? NULL : (__temp51 = (g_object_unref (__temp51), NULL)));
		cif = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION (cond), VALA_CCODE_STATEMENT (type_init), NULL);
		vala_ccode_block_add_statement (type_block, VALA_CCODE_NODE (cif));
		(cond == NULL ? NULL : (cond = (g_object_unref (cond), NULL)));
		(cif == NULL ? NULL : (cif = (g_object_unref (cif), NULL)));
	} else {
		ValaCCodeBlock* __temp55;
		ValaCCodeBlock* __temp54;
		__temp55 = NULL;
		__temp54 = NULL;
		type_block = (__temp55 = (__temp54 = type_init, (__temp54 == NULL ? NULL : g_object_ref (__temp54))), (type_block == NULL ? NULL : (type_block = (g_object_unref (type_block), NULL))), __temp55);
	}
	__temp57 = NULL;
	__temp56 = NULL;
	vala_ccode_block_add_statement (type_block, VALA_CCODE_NODE ((__temp57 = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION ((__temp56 = vala_ccode_identifier_new (type_id_name)))))));
	(__temp57 == NULL ? NULL : (__temp57 = (g_object_unref (__temp57), NULL)));
	(__temp56 == NULL ? NULL : (__temp56 = (g_object_unref (__temp56), NULL)));
	__temp58 = NULL;
	vala_ccode_fragment_append (self->priv->declaration_fragment, VALA_CCODE_NODE ((__temp58 = vala_ccode_function_copy (fun))));
	(__temp58 = (g_object_unref (__temp58), NULL));
	vala_ccode_function_set_block (fun, type_block);
	vala_ccode_fragment_append (self->priv->definition_fragment, VALA_CCODE_NODE (fun));
	(type_id_name = (g_free (type_id_name), NULL));
	(type_block == NULL ? NULL : (type_block = (g_object_unref (type_block), NULL)));
	(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
	(fun == NULL ? NULL : (fun = (g_object_unref (fun), NULL)));
	(type_init == NULL ? NULL : (type_init = (g_object_unref (type_init), NULL)));
	(ctypedecl == NULL ? NULL : (ctypedecl = (g_object_unref (ctypedecl), NULL)));
	(reg_call == NULL ? NULL : (reg_call = (g_object_unref (reg_call), NULL)));
}


ValaDataType* vala_type_register_function_get_type_declaration (ValaTypeRegisterFunction* self)
{
	return VALA_TYPE_REGISTER_FUNCTION_GET_CLASS (self)->get_type_declaration (self);
}


char* vala_type_register_function_get_type_struct_name (ValaTypeRegisterFunction* self)
{
	return VALA_TYPE_REGISTER_FUNCTION_GET_CLASS (self)->get_type_struct_name (self);
}


char* vala_type_register_function_get_base_init_func_name (ValaTypeRegisterFunction* self)
{
	return VALA_TYPE_REGISTER_FUNCTION_GET_CLASS (self)->get_base_init_func_name (self);
}


char* vala_type_register_function_get_class_init_func_name (ValaTypeRegisterFunction* self)
{
	return VALA_TYPE_REGISTER_FUNCTION_GET_CLASS (self)->get_class_init_func_name (self);
}


char* vala_type_register_function_get_instance_struct_size (ValaTypeRegisterFunction* self)
{
	return VALA_TYPE_REGISTER_FUNCTION_GET_CLASS (self)->get_instance_struct_size (self);
}


char* vala_type_register_function_get_instance_init_func_name (ValaTypeRegisterFunction* self)
{
	return VALA_TYPE_REGISTER_FUNCTION_GET_CLASS (self)->get_instance_init_func_name (self);
}


char* vala_type_register_function_get_parent_type_name (ValaTypeRegisterFunction* self)
{
	return VALA_TYPE_REGISTER_FUNCTION_GET_CLASS (self)->get_parent_type_name (self);
}


/**
 * Returns the set of type flags to be applied when registering.
 *
 * @return type flags
 */
static char* vala_type_register_function_real_get_type_flags (ValaTypeRegisterFunction* self)
{
	g_return_val_if_fail (VALA_IS_TYPE_REGISTER_FUNCTION (self), NULL);
	return g_strdup ("0");
}


char* vala_type_register_function_get_type_flags (ValaTypeRegisterFunction* self)
{
	return VALA_TYPE_REGISTER_FUNCTION_GET_CLASS (self)->get_type_flags (self);
}


/**
 * Returns additional C declarations to setup interfaces.
 *
 * @return C declarations
 */
static ValaCCodeFragment* vala_type_register_function_real_get_type_interface_init_declaration (ValaTypeRegisterFunction* self)
{
	g_return_val_if_fail (VALA_IS_TYPE_REGISTER_FUNCTION (self), NULL);
	return g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL);
}


ValaCCodeFragment* vala_type_register_function_get_type_interface_init_declaration (ValaTypeRegisterFunction* self)
{
	return VALA_TYPE_REGISTER_FUNCTION_GET_CLASS (self)->get_type_interface_init_declaration (self);
}


ValaCCodeFragment* vala_type_register_function_get_type_interface_init_statements (ValaTypeRegisterFunction* self)
{
	return VALA_TYPE_REGISTER_FUNCTION_GET_CLASS (self)->get_type_interface_init_statements (self);
}


/**
 * Returns the declaration for this type register function in C code.
 *
 * @return C function declaration fragment
 */
ValaCCodeFragment* vala_type_register_function_get_declaration (ValaTypeRegisterFunction* self)
{
	ValaCCodeFragment* __temp61;
	g_return_val_if_fail (VALA_IS_TYPE_REGISTER_FUNCTION (self), NULL);
	__temp61 = NULL;
	return (__temp61 = self->priv->declaration_fragment, (__temp61 == NULL ? NULL : g_object_ref (__temp61)));
}


/**
 * Returns the definition for this type register function in C code.
 *
 * @return C function definition fragment
 */
ValaCCodeFragment* vala_type_register_function_get_definition (ValaTypeRegisterFunction* self)
{
	ValaCCodeFragment* __temp63;
	g_return_val_if_fail (VALA_IS_TYPE_REGISTER_FUNCTION (self), NULL);
	__temp63 = NULL;
	return (__temp63 = self->priv->definition_fragment, (__temp63 == NULL ? NULL : g_object_ref (__temp63)));
}


static void vala_type_register_function_class_init (ValaTypeRegisterFunctionClass * klass)
{
	vala_type_register_function_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaTypeRegisterFunctionPrivate));
	G_OBJECT_CLASS (klass)->dispose = vala_type_register_function_dispose;
	VALA_TYPE_REGISTER_FUNCTION_CLASS (klass)->get_type_flags = vala_type_register_function_real_get_type_flags;
	VALA_TYPE_REGISTER_FUNCTION_CLASS (klass)->get_type_interface_init_declaration = vala_type_register_function_real_get_type_interface_init_declaration;
}


static void vala_type_register_function_init (ValaTypeRegisterFunction * self)
{
	self->priv = VALA_TYPE_REGISTER_FUNCTION_GET_PRIVATE (self);
	self->priv->declaration_fragment = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL);
	self->priv->definition_fragment = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL);
}


static void vala_type_register_function_dispose (GObject * obj)
{
	ValaTypeRegisterFunction * self;
	ValaTypeRegisterFunctionClass * klass;
	GObjectClass * parent_class;
	self = VALA_TYPE_REGISTER_FUNCTION (obj);
	(self->priv->declaration_fragment == NULL ? NULL : (self->priv->declaration_fragment = (g_object_unref (self->priv->declaration_fragment), NULL)));
	(self->priv->definition_fragment == NULL ? NULL : (self->priv->definition_fragment = (g_object_unref (self->priv->definition_fragment), NULL)));
	klass = VALA_TYPE_REGISTER_FUNCTION_CLASS (g_type_class_peek (VALA_TYPE_TYPE_REGISTER_FUNCTION));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	parent_class->dispose (obj);
}


GType vala_type_register_function_get_type (void)
{
	static GType vala_type_register_function_type_id = 0;
	if (G_UNLIKELY (vala_type_register_function_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaTypeRegisterFunctionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_type_register_function_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaTypeRegisterFunction), 0, (GInstanceInitFunc) vala_type_register_function_init };
		vala_type_register_function_type_id = g_type_register_static (G_TYPE_OBJECT, "ValaTypeRegisterFunction", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	}
	return vala_type_register_function_type_id;
}




