/* valaccodecastexpression.vala
 *
 * Copyright (C) 2006  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */
#define VALA_FREE_CHECKED(o,f) ((o) == NULL ? NULL : ((o) = (f (o), NULL)))
#define VALA_FREE_UNCHECKED(o,f) ((o) = (f (o), NULL))

#include "valaccodecastexpression.h"
#include <ccode/valaccodecastexpression.h>
#include <ccode/valaccodenode.h>

struct _ValaCCodeCastExpressionPrivate {
	ValaCCodeExpression* _inner;
	char* _type_name;
};
#define VALA_CCODE_CAST_EXPRESSION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_CAST_EXPRESSION, ValaCCodeCastExpressionPrivate))
enum  {
	VALA_CCODE_CAST_EXPRESSION_DUMMY_PROPERTY,
	VALA_CCODE_CAST_EXPRESSION_INNER,
	VALA_CCODE_CAST_EXPRESSION_TYPE_NAME
};
static void vala_ccode_cast_expression_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer);
static gpointer vala_ccode_cast_expression_parent_class = NULL;
static void vala_ccode_cast_expression_dispose (GObject * obj);


ValaCCodeCastExpression* vala_ccode_cast_expression_new (ValaCCodeExpression* expr, const char* type)
{
	GParameter * __params;
	GParameter * __params_it;
	ValaCCodeCastExpression * self;
	g_return_val_if_fail (VALA_IS_CCODE_EXPRESSION (expr), NULL);
	g_return_val_if_fail (type != NULL, NULL);
	__params = g_new0 (GParameter, 2);
	__params_it = __params;
	(__params_it->name = "inner", g_value_init (&__params_it->value, VALA_TYPE_CCODE_EXPRESSION), g_value_set_object (&__params_it->value, expr), __params_it++);
	(__params_it->name = "type-name", g_value_init (&__params_it->value, G_TYPE_STRING), g_value_set_string (&__params_it->value, type), __params_it++);
	self = g_object_newv (VALA_TYPE_CCODE_CAST_EXPRESSION, __params_it - __params, __params);
	return self;
}


static void vala_ccode_cast_expression_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer)
{
	ValaCCodeCastExpression * self;
	self = VALA_CCODE_CAST_EXPRESSION (base);
	g_return_if_fail (VALA_IS_CCODE_WRITER (writer));
	vala_ccode_writer_write_string (writer, "((");
	vala_ccode_writer_write_string (writer, vala_ccode_cast_expression_get_type_name (self));
	vala_ccode_writer_write_string (writer, ") ");
	vala_ccode_node_write (VALA_CCODE_NODE (vala_ccode_cast_expression_get_inner (self)), writer);
	vala_ccode_writer_write_string (writer, ")");
}


ValaCCodeExpression* vala_ccode_cast_expression_get_inner (ValaCCodeCastExpression* self)
{
	g_return_val_if_fail (VALA_IS_CCODE_CAST_EXPRESSION (self), NULL);
	return self->priv->_inner;
}


void vala_ccode_cast_expression_set_inner (ValaCCodeCastExpression* self, ValaCCodeExpression* value)
{
	ValaCCodeExpression* __temp1;
	g_return_if_fail (VALA_IS_CCODE_CAST_EXPRESSION (self));
	__temp1 = NULL;
	self->priv->_inner = (__temp1 = g_object_ref (value), (self->priv->_inner == NULL ? NULL : (self->priv->_inner = (g_object_unref (self->priv->_inner), NULL))), __temp1);
}


char* vala_ccode_cast_expression_get_type_name (ValaCCodeCastExpression* self)
{
	g_return_val_if_fail (VALA_IS_CCODE_CAST_EXPRESSION (self), NULL);
	return self->priv->_type_name;
}


void vala_ccode_cast_expression_set_type_name (ValaCCodeCastExpression* self, const char* value)
{
	char* __temp3;
	g_return_if_fail (VALA_IS_CCODE_CAST_EXPRESSION (self));
	__temp3 = NULL;
	self->priv->_type_name = (__temp3 = g_strdup (value), (self->priv->_type_name = (g_free (self->priv->_type_name), NULL)), __temp3);
}


static void vala_ccode_cast_expression_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec)
{
	ValaCCodeCastExpression * self;
	self = VALA_CCODE_CAST_EXPRESSION (object);
	switch (property_id) {
		case VALA_CCODE_CAST_EXPRESSION_INNER:
		g_value_set_object (value, vala_ccode_cast_expression_get_inner (self));
		break;
		case VALA_CCODE_CAST_EXPRESSION_TYPE_NAME:
		g_value_set_string (value, vala_ccode_cast_expression_get_type_name (self));
		break;
	}
}


static void vala_ccode_cast_expression_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec)
{
	ValaCCodeCastExpression * self;
	self = VALA_CCODE_CAST_EXPRESSION (object);
	switch (property_id) {
		case VALA_CCODE_CAST_EXPRESSION_INNER:
		vala_ccode_cast_expression_set_inner (self, g_value_get_object (value));
		break;
		case VALA_CCODE_CAST_EXPRESSION_TYPE_NAME:
		vala_ccode_cast_expression_set_type_name (self, g_value_get_string (value));
		break;
	}
}


static void vala_ccode_cast_expression_class_init (ValaCCodeCastExpressionClass * klass)
{
	vala_ccode_cast_expression_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaCCodeCastExpressionPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_ccode_cast_expression_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_ccode_cast_expression_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_ccode_cast_expression_dispose;
	VALA_CCODE_NODE_CLASS (klass)->write = vala_ccode_cast_expression_real_write;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CCODE_CAST_EXPRESSION_INNER, g_param_spec_object ("inner", "foo", "bar", VALA_TYPE_CCODE_EXPRESSION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CCODE_CAST_EXPRESSION_TYPE_NAME, g_param_spec_string ("type-name", "foo", "bar", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void vala_ccode_cast_expression_init (ValaCCodeCastExpression * self)
{
	self->priv = VALA_CCODE_CAST_EXPRESSION_GET_PRIVATE (self);
}


static void vala_ccode_cast_expression_dispose (GObject * obj)
{
	ValaCCodeCastExpression * self;
	ValaCCodeCastExpressionClass * klass;
	GObjectClass * parent_class;
	self = VALA_CCODE_CAST_EXPRESSION (obj);
	(self->priv->_inner == NULL ? NULL : (self->priv->_inner = (g_object_unref (self->priv->_inner), NULL)));
	(self->priv->_type_name = (g_free (self->priv->_type_name), NULL));
	klass = VALA_CCODE_CAST_EXPRESSION_CLASS (g_type_class_peek (VALA_TYPE_CCODE_CAST_EXPRESSION));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	parent_class->dispose (obj);
}


GType vala_ccode_cast_expression_get_type ()
{
	static GType vala_ccode_cast_expression_type_id = 0;
	if (G_UNLIKELY (vala_ccode_cast_expression_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeCastExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_cast_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeCastExpression), 0, (GInstanceInitFunc) vala_ccode_cast_expression_init };
		vala_ccode_cast_expression_type_id = g_type_register_static (VALA_TYPE_CCODE_EXPRESSION, "ValaCCodeCastExpression", &g_define_type_info, 0);
	}
	return vala_ccode_cast_expression_type_id;
}




