/* valasymbolresolver.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */
#define VALA_FREE_CHECKED(o,f) ((o) == NULL ? NULL : ((o) = (f (o), NULL)))
#define VALA_FREE_UNCHECKED(o,f) ((o) = (f (o), NULL))

#include "valasymbolresolver.h"
#include <stdlib.h>
#include <string.h>
#include <vala/valasymbol.h>
#include <vala/valasymbolresolver.h>
#include <vala/valacodenode.h>
#include <vala/valareport.h>
#include <vala/valasourcereference.h>
#include <vala/valadatatype.h>
#include <vala/valatypeparameter.h>

struct _ValaSymbolResolverPrivate {
	ValaSymbol* root_symbol;
	ValaSymbol* current_scope;
	GList* current_using_directives;
	ValaClass* object_class;
};
#define VALA_SYMBOL_RESOLVER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_SYMBOL_RESOLVER, ValaSymbolResolverPrivate))
enum  {
	VALA_SYMBOL_RESOLVER_DUMMY_PROPERTY
};
static void vala_symbol_resolver_real_visit_source_file (ValaCodeVisitor* base, ValaSourceFile* file);
static void vala_symbol_resolver_real_visit_namespace (ValaCodeVisitor* base, ValaNamespace* ns);
static void vala_symbol_resolver_real_visit_class (ValaCodeVisitor* base, ValaClass* cl);
static void vala_symbol_resolver_real_visit_struct (ValaCodeVisitor* base, ValaStruct* st);
static void vala_symbol_resolver_real_visit_interface (ValaCodeVisitor* base, ValaInterface* iface);
static void vala_symbol_resolver_real_visit_enum (ValaCodeVisitor* base, ValaEnum* en);
static void vala_symbol_resolver_real_visit_callback (ValaCodeVisitor* base, ValaCallback* cb);
static void vala_symbol_resolver_real_visit_constant (ValaCodeVisitor* base, ValaConstant* c);
static void vala_symbol_resolver_real_visit_field (ValaCodeVisitor* base, ValaField* f);
static void vala_symbol_resolver_real_visit_method (ValaCodeVisitor* base, ValaMethod* m);
static void vala_symbol_resolver_real_visit_creation_method (ValaCodeVisitor* base, ValaCreationMethod* m);
static void vala_symbol_resolver_real_visit_formal_parameter (ValaCodeVisitor* base, ValaFormalParameter* p);
static void vala_symbol_resolver_real_visit_property (ValaCodeVisitor* base, ValaProperty* prop);
static void vala_symbol_resolver_real_visit_property_accessor (ValaCodeVisitor* base, ValaPropertyAccessor* acc);
static void vala_symbol_resolver_real_visit_signal (ValaCodeVisitor* base, ValaSignal* sig);
static void vala_symbol_resolver_real_visit_constructor (ValaCodeVisitor* base, ValaConstructor* c);
static void vala_symbol_resolver_real_visit_destructor (ValaCodeVisitor* base, ValaDestructor* d);
static void vala_symbol_resolver_real_visit_namespace_reference (ValaCodeVisitor* base, ValaNamespaceReference* ns);
static void vala_symbol_resolver_real_visit_type_reference (ValaCodeVisitor* base, ValaTypeReference* type);
static gpointer vala_symbol_resolver_parent_class = NULL;
static void vala_symbol_resolver_dispose (GObject * obj);


/**
 * Resolve symbol names in the specified code context.
 *
 * @param context a code context
 */
void vala_symbol_resolver_resolve (ValaSymbolResolver* self, ValaCodeContext* context)
{
	ValaSymbol* __temp0;
	ValaSymbol* __temp2;
	ValaSymbol* __temp1;
	ValaSymbol* glib_ns;
	g_return_if_fail (VALA_IS_SYMBOL_RESOLVER (self));
	g_return_if_fail (VALA_IS_CODE_CONTEXT (context));
	__temp0 = NULL;
	self->priv->root_symbol = (__temp0 = vala_code_context_get_root (context), (self->priv->root_symbol == NULL ? NULL : (self->priv->root_symbol = (g_object_unref (self->priv->root_symbol), NULL))), __temp0);
	__temp2 = NULL;
	__temp1 = NULL;
	self->priv->current_scope = (__temp2 = (__temp1 = self->priv->root_symbol, (__temp1 == NULL ? NULL : g_object_ref (__temp1))), (self->priv->current_scope == NULL ? NULL : (self->priv->current_scope = (g_object_unref (self->priv->current_scope), NULL))), __temp2);
	/* TODO: don't require GLib namespace in symbol resolver*/
	glib_ns = vala_symbol_lookup (self->priv->root_symbol, "GLib");
	if (glib_ns != NULL) {
		ValaClass* __temp5;
		ValaClass* __temp4;
		ValaSymbol* __temp3;
		__temp5 = NULL;
		__temp4 = NULL;
		__temp3 = NULL;
		self->priv->object_class = (__temp5 = (__temp4 = VALA_CLASS (vala_symbol_get_node ((__temp3 = vala_symbol_lookup (glib_ns, "Object")))), (__temp4 == NULL ? NULL : g_object_ref (__temp4))), (self->priv->object_class == NULL ? NULL : (self->priv->object_class = (g_object_unref (self->priv->object_class), NULL))), __temp5);
		(__temp3 == NULL ? NULL : (__temp3 = (g_object_unref (__temp3), NULL)));
	}
	vala_code_context_accept (context, VALA_CODE_VISITOR (self));
	(glib_ns == NULL ? NULL : (glib_ns = (g_object_unref (glib_ns), NULL)));
}


static void vala_symbol_resolver_real_visit_source_file (ValaCodeVisitor* base, ValaSourceFile* file)
{
	ValaSymbolResolver * self;
	GList* __temp6;
	GList* __temp7;
	self = VALA_SYMBOL_RESOLVER (base);
	g_return_if_fail (VALA_IS_SOURCE_FILE (file));
	__temp6 = NULL;
	self->priv->current_using_directives = (__temp6 = vala_source_file_get_using_directives (file), (self->priv->current_using_directives == NULL ? NULL : (self->priv->current_using_directives = (g_list_free (self->priv->current_using_directives), NULL))), __temp6);
	vala_source_file_accept_children (file, VALA_CODE_VISITOR (self));
	__temp7 = NULL;
	self->priv->current_using_directives = (__temp7 = NULL, (self->priv->current_using_directives == NULL ? NULL : (self->priv->current_using_directives = (g_list_free (self->priv->current_using_directives), NULL))), __temp7);
}


static void vala_symbol_resolver_real_visit_namespace (ValaCodeVisitor* base, ValaNamespace* ns)
{
	ValaSymbolResolver * self;
	ValaSymbol* __temp9;
	ValaSymbol* __temp8;
	ValaSymbol* __temp11;
	ValaSymbol* __temp10;
	self = VALA_SYMBOL_RESOLVER (base);
	g_return_if_fail (VALA_IS_NAMESPACE (ns));
	__temp9 = NULL;
	__temp8 = NULL;
	self->priv->current_scope = (__temp9 = (__temp8 = vala_code_node_get_symbol (VALA_CODE_NODE (ns)), (__temp8 == NULL ? NULL : g_object_ref (__temp8))), (self->priv->current_scope == NULL ? NULL : (self->priv->current_scope = (g_object_unref (self->priv->current_scope), NULL))), __temp9);
	vala_code_node_accept_children (VALA_CODE_NODE (ns), VALA_CODE_VISITOR (self));
	/* don't use current_scope.parent_symbol as that would be null
	 if the current namespace is SourceFile.global_namespace*/
	__temp11 = NULL;
	__temp10 = NULL;
	self->priv->current_scope = (__temp11 = (__temp10 = self->priv->root_symbol, (__temp10 == NULL ? NULL : g_object_ref (__temp10))), (self->priv->current_scope == NULL ? NULL : (self->priv->current_scope = (g_object_unref (self->priv->current_scope), NULL))), __temp11);
}


static void vala_symbol_resolver_real_visit_class (ValaCodeVisitor* base, ValaClass* cl)
{
	ValaSymbolResolver * self;
	ValaSymbol* __temp13;
	ValaSymbol* __temp12;
	ValaSymbol* __temp20;
	ValaSymbol* __temp19;
	self = VALA_SYMBOL_RESOLVER (base);
	g_return_if_fail (VALA_IS_CLASS (cl));
	__temp13 = NULL;
	__temp12 = NULL;
	self->priv->current_scope = (__temp13 = (__temp12 = vala_code_node_get_symbol (VALA_CODE_NODE (cl)), (__temp12 == NULL ? NULL : g_object_ref (__temp12))), (self->priv->current_scope == NULL ? NULL : (self->priv->current_scope = (g_object_unref (self->priv->current_scope), NULL))), __temp13);
	vala_code_node_accept_children (VALA_CODE_NODE (cl), VALA_CODE_VISITOR (self));
	{
		GList* __temp18;
		GList* type_it;
		__temp18 = NULL;
		__temp18 = vala_class_get_base_types (cl);
		for (type_it = __temp18; type_it != NULL; type_it = type_it->next) {
			ValaTypeReference* type;
			type = type_it->data;
			{
				if (VALA_IS_CLASS (vala_type_reference_get_data_type (type))) {
					if (vala_class_get_base_class (cl) != NULL) {
						char* __temp17;
						char* __temp16;
						char* __temp15;
						char* __temp14;
						__temp17 = NULL;
						__temp16 = NULL;
						__temp15 = NULL;
						__temp14 = NULL;
						vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (type)), (__temp17 = g_strdup_printf ("%s: Classes cannot have multiple base classes (`%s' and `%s')", (__temp14 = vala_symbol_get_full_name (vala_code_node_get_symbol (VALA_CODE_NODE (cl)))), (__temp15 = vala_symbol_get_full_name (vala_code_node_get_symbol (VALA_CODE_NODE (vala_class_get_base_class (cl))))), (__temp16 = vala_symbol_get_full_name (vala_code_node_get_symbol (VALA_CODE_NODE (vala_type_reference_get_data_type (type))))))));
						(__temp17 = (g_free (__temp17), NULL));
						(__temp16 = (g_free (__temp16), NULL));
						(__temp15 = (g_free (__temp15), NULL));
						(__temp14 = (g_free (__temp14), NULL));
						return;
					}
					(vala_class_set_base_class (cl, VALA_CLASS (vala_type_reference_get_data_type (type))), vala_class_get_base_class (cl));
				}
			}
		}
		(__temp18 == NULL ? NULL : (__temp18 = (g_list_free (__temp18), NULL)));
	}
	if (vala_class_get_base_class (cl) == NULL && cl != self->priv->object_class) {
		ValaTypeReference* object_type;
		object_type = vala_type_reference_new ();
		(vala_type_reference_set_data_type (object_type, VALA_DATA_TYPE (self->priv->object_class)), vala_type_reference_get_data_type (object_type));
		vala_class_add_base_type (cl, object_type);
		(vala_class_set_base_class (cl, self->priv->object_class), vala_class_get_base_class (cl));
		(object_type == NULL ? NULL : (object_type = (g_object_unref (object_type), NULL)));
	}
	__temp20 = NULL;
	__temp19 = NULL;
	self->priv->current_scope = (__temp20 = (__temp19 = vala_symbol_get_parent_symbol (self->priv->current_scope), (__temp19 == NULL ? NULL : g_object_ref (__temp19))), (self->priv->current_scope == NULL ? NULL : (self->priv->current_scope = (g_object_unref (self->priv->current_scope), NULL))), __temp20);
}


static void vala_symbol_resolver_real_visit_struct (ValaCodeVisitor* base, ValaStruct* st)
{
	ValaSymbolResolver * self;
	ValaSymbol* __temp22;
	ValaSymbol* __temp21;
	ValaSymbol* __temp24;
	ValaSymbol* __temp23;
	self = VALA_SYMBOL_RESOLVER (base);
	g_return_if_fail (VALA_IS_STRUCT (st));
	__temp22 = NULL;
	__temp21 = NULL;
	self->priv->current_scope = (__temp22 = (__temp21 = vala_code_node_get_symbol (VALA_CODE_NODE (st)), (__temp21 == NULL ? NULL : g_object_ref (__temp21))), (self->priv->current_scope == NULL ? NULL : (self->priv->current_scope = (g_object_unref (self->priv->current_scope), NULL))), __temp22);
	vala_code_node_accept_children (VALA_CODE_NODE (st), VALA_CODE_VISITOR (self));
	__temp24 = NULL;
	__temp23 = NULL;
	self->priv->current_scope = (__temp24 = (__temp23 = vala_symbol_get_parent_symbol (self->priv->current_scope), (__temp23 == NULL ? NULL : g_object_ref (__temp23))), (self->priv->current_scope == NULL ? NULL : (self->priv->current_scope = (g_object_unref (self->priv->current_scope), NULL))), __temp24);
}


static void vala_symbol_resolver_real_visit_interface (ValaCodeVisitor* base, ValaInterface* iface)
{
	ValaSymbolResolver * self;
	ValaSymbol* __temp26;
	ValaSymbol* __temp25;
	ValaSymbol* __temp28;
	ValaSymbol* __temp27;
	self = VALA_SYMBOL_RESOLVER (base);
	g_return_if_fail (VALA_IS_INTERFACE (iface));
	__temp26 = NULL;
	__temp25 = NULL;
	self->priv->current_scope = (__temp26 = (__temp25 = vala_code_node_get_symbol (VALA_CODE_NODE (iface)), (__temp25 == NULL ? NULL : g_object_ref (__temp25))), (self->priv->current_scope == NULL ? NULL : (self->priv->current_scope = (g_object_unref (self->priv->current_scope), NULL))), __temp26);
	vala_code_node_accept_children (VALA_CODE_NODE (iface), VALA_CODE_VISITOR (self));
	__temp28 = NULL;
	__temp27 = NULL;
	self->priv->current_scope = (__temp28 = (__temp27 = vala_symbol_get_parent_symbol (self->priv->current_scope), (__temp27 == NULL ? NULL : g_object_ref (__temp27))), (self->priv->current_scope == NULL ? NULL : (self->priv->current_scope = (g_object_unref (self->priv->current_scope), NULL))), __temp28);
}


static void vala_symbol_resolver_real_visit_enum (ValaCodeVisitor* base, ValaEnum* en)
{
	ValaSymbolResolver * self;
	ValaSymbol* __temp30;
	ValaSymbol* __temp29;
	ValaSymbol* __temp32;
	ValaSymbol* __temp31;
	self = VALA_SYMBOL_RESOLVER (base);
	g_return_if_fail (VALA_IS_ENUM (en));
	__temp30 = NULL;
	__temp29 = NULL;
	self->priv->current_scope = (__temp30 = (__temp29 = vala_code_node_get_symbol (VALA_CODE_NODE (en)), (__temp29 == NULL ? NULL : g_object_ref (__temp29))), (self->priv->current_scope == NULL ? NULL : (self->priv->current_scope = (g_object_unref (self->priv->current_scope), NULL))), __temp30);
	vala_code_node_accept_children (VALA_CODE_NODE (en), VALA_CODE_VISITOR (self));
	__temp32 = NULL;
	__temp31 = NULL;
	self->priv->current_scope = (__temp32 = (__temp31 = vala_symbol_get_parent_symbol (self->priv->current_scope), (__temp31 == NULL ? NULL : g_object_ref (__temp31))), (self->priv->current_scope == NULL ? NULL : (self->priv->current_scope = (g_object_unref (self->priv->current_scope), NULL))), __temp32);
}


static void vala_symbol_resolver_real_visit_callback (ValaCodeVisitor* base, ValaCallback* cb)
{
	ValaSymbolResolver * self;
	ValaSymbol* __temp34;
	ValaSymbol* __temp33;
	ValaSymbol* __temp36;
	ValaSymbol* __temp35;
	self = VALA_SYMBOL_RESOLVER (base);
	g_return_if_fail (VALA_IS_CALLBACK (cb));
	__temp34 = NULL;
	__temp33 = NULL;
	self->priv->current_scope = (__temp34 = (__temp33 = vala_code_node_get_symbol (VALA_CODE_NODE (cb)), (__temp33 == NULL ? NULL : g_object_ref (__temp33))), (self->priv->current_scope == NULL ? NULL : (self->priv->current_scope = (g_object_unref (self->priv->current_scope), NULL))), __temp34);
	vala_code_node_accept_children (VALA_CODE_NODE (cb), VALA_CODE_VISITOR (self));
	__temp36 = NULL;
	__temp35 = NULL;
	self->priv->current_scope = (__temp36 = (__temp35 = vala_symbol_get_parent_symbol (self->priv->current_scope), (__temp35 == NULL ? NULL : g_object_ref (__temp35))), (self->priv->current_scope == NULL ? NULL : (self->priv->current_scope = (g_object_unref (self->priv->current_scope), NULL))), __temp36);
}


static void vala_symbol_resolver_real_visit_constant (ValaCodeVisitor* base, ValaConstant* c)
{
	ValaSymbolResolver * self;
	self = VALA_SYMBOL_RESOLVER (base);
	g_return_if_fail (VALA_IS_CONSTANT (c));
	vala_code_node_accept_children (VALA_CODE_NODE (c), VALA_CODE_VISITOR (self));
}


static void vala_symbol_resolver_real_visit_field (ValaCodeVisitor* base, ValaField* f)
{
	ValaSymbolResolver * self;
	self = VALA_SYMBOL_RESOLVER (base);
	g_return_if_fail (VALA_IS_FIELD (f));
	vala_code_node_accept_children (VALA_CODE_NODE (f), VALA_CODE_VISITOR (self));
}


static void vala_symbol_resolver_real_visit_method (ValaCodeVisitor* base, ValaMethod* m)
{
	ValaSymbolResolver * self;
	self = VALA_SYMBOL_RESOLVER (base);
	g_return_if_fail (VALA_IS_METHOD (m));
	vala_code_node_accept_children (VALA_CODE_NODE (m), VALA_CODE_VISITOR (self));
}


static void vala_symbol_resolver_real_visit_creation_method (ValaCodeVisitor* base, ValaCreationMethod* m)
{
	ValaSymbolResolver * self;
	self = VALA_SYMBOL_RESOLVER (base);
	g_return_if_fail (VALA_IS_CREATION_METHOD (m));
	vala_code_node_accept_children (VALA_CODE_NODE (m), VALA_CODE_VISITOR (self));
}


static void vala_symbol_resolver_real_visit_formal_parameter (ValaCodeVisitor* base, ValaFormalParameter* p)
{
	ValaSymbolResolver * self;
	self = VALA_SYMBOL_RESOLVER (base);
	g_return_if_fail (VALA_IS_FORMAL_PARAMETER (p));
	vala_code_node_accept_children (VALA_CODE_NODE (p), VALA_CODE_VISITOR (self));
}


static void vala_symbol_resolver_real_visit_property (ValaCodeVisitor* base, ValaProperty* prop)
{
	ValaSymbolResolver * self;
	self = VALA_SYMBOL_RESOLVER (base);
	g_return_if_fail (VALA_IS_PROPERTY (prop));
	vala_code_node_accept_children (VALA_CODE_NODE (prop), VALA_CODE_VISITOR (self));
}


static void vala_symbol_resolver_real_visit_property_accessor (ValaCodeVisitor* base, ValaPropertyAccessor* acc)
{
	ValaSymbolResolver * self;
	self = VALA_SYMBOL_RESOLVER (base);
	g_return_if_fail (VALA_IS_PROPERTY_ACCESSOR (acc));
	vala_code_node_accept_children (VALA_CODE_NODE (acc), VALA_CODE_VISITOR (self));
}


static void vala_symbol_resolver_real_visit_signal (ValaCodeVisitor* base, ValaSignal* sig)
{
	ValaSymbolResolver * self;
	self = VALA_SYMBOL_RESOLVER (base);
	g_return_if_fail (VALA_IS_SIGNAL (sig));
	vala_code_node_accept_children (VALA_CODE_NODE (sig), VALA_CODE_VISITOR (self));
}


static void vala_symbol_resolver_real_visit_constructor (ValaCodeVisitor* base, ValaConstructor* c)
{
	ValaSymbolResolver * self;
	self = VALA_SYMBOL_RESOLVER (base);
	g_return_if_fail (VALA_IS_CONSTRUCTOR (c));
	vala_code_node_accept_children (VALA_CODE_NODE (c), VALA_CODE_VISITOR (self));
}


static void vala_symbol_resolver_real_visit_destructor (ValaCodeVisitor* base, ValaDestructor* d)
{
	ValaSymbolResolver * self;
	self = VALA_SYMBOL_RESOLVER (base);
	g_return_if_fail (VALA_IS_DESTRUCTOR (d));
	vala_code_node_accept_children (VALA_CODE_NODE (d), VALA_CODE_VISITOR (self));
}


static void vala_symbol_resolver_real_visit_namespace_reference (ValaCodeVisitor* base, ValaNamespaceReference* ns)
{
	ValaSymbolResolver * self;
	ValaSymbol* __temp37;
	self = VALA_SYMBOL_RESOLVER (base);
	g_return_if_fail (VALA_IS_NAMESPACE_REFERENCE (ns));
	__temp37 = NULL;
	(vala_namespace_reference_set_namespace_symbol (ns, (__temp37 = vala_symbol_lookup (self->priv->current_scope, vala_namespace_reference_get_name (ns)))), vala_namespace_reference_get_namespace_symbol (ns));
	(__temp37 == NULL ? NULL : (__temp37 = (g_object_unref (__temp37), NULL)));
	if (vala_namespace_reference_get_namespace_symbol (ns) == NULL) {
		char* __temp38;
		(vala_code_node_set_error (VALA_CODE_NODE (ns), TRUE), vala_code_node_get_error (VALA_CODE_NODE (ns)));
		__temp38 = NULL;
		vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (ns)), (__temp38 = g_strdup_printf ("The namespace name `%s' could not be found", vala_namespace_reference_get_name (ns))));
		(__temp38 = (g_free (__temp38), NULL));
		return;
	}
}


static void vala_symbol_resolver_real_visit_type_reference (ValaCodeVisitor* base, ValaTypeReference* type)
{
	ValaSymbolResolver * self;
	self = VALA_SYMBOL_RESOLVER (base);
	g_return_if_fail (VALA_IS_TYPE_REFERENCE (type));
	if (vala_type_reference_get_type_name (type) == NULL || g_utf8_collate (vala_type_reference_get_type_name (type), "void") == 0) {
		/* reset transfers_ownership*/
		(vala_type_reference_set_transfers_ownership (type, FALSE), vala_type_reference_get_transfers_ownership (type));
		return;
	}
	if (vala_type_reference_get_namespace_name (type) == NULL) {
		ValaSymbol* sym;
		ValaSymbol* __temp39;
		ValaSymbol* scope;
		sym = NULL;
		__temp39 = NULL;
		scope = (__temp39 = self->priv->current_scope, (__temp39 == NULL ? NULL : g_object_ref (__temp39)));
		while (sym == NULL && scope != NULL) {
			ValaSymbol* __temp40;
			ValaSymbol* __temp42;
			ValaSymbol* __temp41;
			__temp40 = NULL;
			sym = (__temp40 = vala_symbol_lookup (scope, vala_type_reference_get_type_name (type)), (sym == NULL ? NULL : (sym = (g_object_unref (sym), NULL))), __temp40);
			__temp42 = NULL;
			__temp41 = NULL;
			scope = (__temp42 = (__temp41 = vala_symbol_get_parent_symbol (scope), (__temp41 == NULL ? NULL : g_object_ref (__temp41))), (scope == NULL ? NULL : (scope = (g_object_unref (scope), NULL))), __temp42);
			if (sym != NULL && !(VALA_IS_DATA_TYPE (vala_symbol_get_node (sym))) && !(VALA_IS_TYPE_PARAMETER (vala_symbol_get_node (sym)))) {
				ValaSymbol* __temp43;
				/* ignore non-type symbols*/
				__temp43 = NULL;
				sym = (__temp43 = NULL, (sym == NULL ? NULL : (sym = (g_object_unref (sym), NULL))), __temp43);
			}
		}
		if (sym == NULL) {
			{
				GList* __temp49;
				GList* ns_it;
				__temp49 = NULL;
				__temp49 = self->priv->current_using_directives;
				for (ns_it = __temp49; ns_it != NULL; ns_it = ns_it->next) {
					ValaNamespaceReference* ns;
					ns = ns_it->data;
					{
						ValaSymbol* local_sym;
						if (vala_code_node_get_error (VALA_CODE_NODE (ns))) {
							continue;
						}
						local_sym = vala_symbol_lookup (vala_namespace_reference_get_namespace_symbol (ns), vala_type_reference_get_type_name (type));
						if (local_sym != NULL) {
							ValaSymbol* __temp48;
							ValaSymbol* __temp47;
							if (sym != NULL) {
								char* __temp46;
								char* __temp45;
								char* __temp44;
								__temp46 = NULL;
								__temp45 = NULL;
								__temp44 = NULL;
								vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (type)), (__temp46 = g_strdup_printf ("`%s' is an ambiguous reference between `%s' and `%s'", vala_type_reference_get_type_name (type), (__temp44 = vala_symbol_get_full_name (sym)), (__temp45 = vala_symbol_get_full_name (local_sym)))));
								(__temp46 = (g_free (__temp46), NULL));
								(__temp45 = (g_free (__temp45), NULL));
								(__temp44 = (g_free (__temp44), NULL));
								(local_sym == NULL ? NULL : (local_sym = (g_object_unref (local_sym), NULL)));
								(sym == NULL ? NULL : (sym = (g_object_unref (sym), NULL)));
								(scope == NULL ? NULL : (scope = (g_object_unref (scope), NULL)));
								return;
							}
							__temp48 = NULL;
							__temp47 = NULL;
							sym = (__temp48 = (__temp47 = local_sym, (__temp47 == NULL ? NULL : g_object_ref (__temp47))), (sym == NULL ? NULL : (sym = (g_object_unref (sym), NULL))), __temp48);
						}
						(local_sym == NULL ? NULL : (local_sym = (g_object_unref (local_sym), NULL)));
					}
				}
			}
		}
		if (sym == NULL) {
			char* __temp50;
			__temp50 = NULL;
			vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (type)), (__temp50 = g_strdup_printf ("The type name `%s' could not be found", vala_type_reference_get_type_name (type))));
			(__temp50 = (g_free (__temp50), NULL));
			(sym == NULL ? NULL : (sym = (g_object_unref (sym), NULL)));
			(scope == NULL ? NULL : (scope = (g_object_unref (scope), NULL)));
			return;
		}
		if (VALA_IS_TYPE_PARAMETER (vala_symbol_get_node (sym))) {
			(vala_type_reference_set_type_parameter (type, VALA_TYPE_PARAMETER (vala_symbol_get_node (sym))), vala_type_reference_get_type_parameter (type));
		} else {
			(vala_type_reference_set_data_type (type, VALA_DATA_TYPE (vala_symbol_get_node (sym))), vala_type_reference_get_data_type (type));
		}
		(sym == NULL ? NULL : (sym = (g_object_unref (sym), NULL)));
		(scope == NULL ? NULL : (scope = (g_object_unref (scope), NULL)));
	} else {
		ValaSymbol* ns_symbol;
		ValaSymbol* sym;
		ns_symbol = vala_symbol_lookup (self->priv->root_symbol, vala_type_reference_get_namespace_name (type));
		if (ns_symbol == NULL) {
			char* __temp51;
			(vala_code_node_set_error (VALA_CODE_NODE (type), TRUE), vala_code_node_get_error (VALA_CODE_NODE (type)));
			__temp51 = NULL;
			vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (type)), (__temp51 = g_strdup_printf ("The namespace name `%s' could not be found", vala_type_reference_get_namespace_name (type))));
			(__temp51 = (g_free (__temp51), NULL));
			(ns_symbol == NULL ? NULL : (ns_symbol = (g_object_unref (ns_symbol), NULL)));
			return;
		}
		sym = vala_symbol_lookup (ns_symbol, vala_type_reference_get_type_name (type));
		if (sym == NULL) {
			char* __temp52;
			__temp52 = NULL;
			vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (type)), (__temp52 = g_strdup_printf ("The type name `%s' does not exist in the namespace `%s'", vala_type_reference_get_type_name (type), vala_type_reference_get_namespace_name (type))));
			(__temp52 = (g_free (__temp52), NULL));
			(ns_symbol == NULL ? NULL : (ns_symbol = (g_object_unref (ns_symbol), NULL)));
			(sym == NULL ? NULL : (sym = (g_object_unref (sym), NULL)));
			return;
		}
		(vala_type_reference_set_data_type (type, VALA_DATA_TYPE (vala_symbol_get_node (sym))), vala_type_reference_get_data_type (type));
		(ns_symbol == NULL ? NULL : (ns_symbol = (g_object_unref (ns_symbol), NULL)));
		(sym == NULL ? NULL : (sym = (g_object_unref (sym), NULL)));
	}
	if (vala_type_reference_get_pointer_level (type) > 0) {
		ValaTypeReference* referent_type;
		ValaPointer* __temp54;
		if (vala_type_reference_get_data_type (type) == NULL) {
			char* __temp53;
			(vala_code_node_set_error (VALA_CODE_NODE (type), TRUE), vala_code_node_get_error (VALA_CODE_NODE (type)));
			__temp53 = NULL;
			vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (type)), (__temp53 = g_strdup_printf ("Pointer to `%s' not supported", vala_type_reference_get_type_name (type))));
			(__temp53 = (g_free (__temp53), NULL));
			return;
		}
		referent_type = vala_type_reference_new ();
		(vala_type_reference_set_data_type (referent_type, vala_type_reference_get_data_type (type)), vala_type_reference_get_data_type (referent_type));
		(vala_type_reference_set_pointer_level (referent_type, vala_type_reference_get_pointer_level (type) - 1), vala_type_reference_get_pointer_level (referent_type));
		if (vala_data_type_is_reference_type (vala_type_reference_get_data_type (type))) {
			(vala_type_reference_set_takes_ownership (referent_type, vala_type_reference_get_takes_ownership (type)), vala_type_reference_get_takes_ownership (referent_type));
		}
		__temp54 = NULL;
		(vala_type_reference_set_data_type (type, VALA_DATA_TYPE ((__temp54 = vala_data_type_get_pointer (vala_type_reference_get_data_type (referent_type))))), vala_type_reference_get_data_type (type));
		(__temp54 = (g_object_unref (__temp54), NULL));
		vala_type_reference_add_type_argument (type, referent_type);
		vala_code_visitor_visit_type_reference (VALA_CODE_VISITOR (self), referent_type);
		(referent_type == NULL ? NULL : (referent_type = (g_object_unref (referent_type), NULL)));
	}
	/* check for array */
	if (vala_type_reference_get_array_rank (type) > 0) {
		ValaTypeReference* element_type;
		element_type = vala_type_reference_new ();
		(vala_type_reference_set_data_type (element_type, vala_type_reference_get_data_type (type)), vala_type_reference_get_data_type (element_type));
		(vala_type_reference_set_type_parameter (element_type, vala_type_reference_get_type_parameter (type)), vala_type_reference_get_type_parameter (element_type));
		{
			GList* __temp55;
			GList* type_arg_it;
			__temp55 = NULL;
			__temp55 = vala_type_reference_get_type_arguments (type);
			for (type_arg_it = __temp55; type_arg_it != NULL; type_arg_it = type_arg_it->next) {
				ValaTypeReference* type_arg;
				type_arg = type_arg_it->data;
				{
					vala_type_reference_add_type_argument (element_type, type_arg);
				}
			}
			(__temp55 == NULL ? NULL : (__temp55 = (g_list_free (__temp55), NULL)));
		}
		vala_type_reference_remove_all_type_arguments (type);
		if (vala_type_reference_get_data_type (type) != NULL) {
			ValaArray* __temp56;
			if (vala_data_type_is_reference_type (vala_type_reference_get_data_type (type))) {
				(vala_type_reference_set_takes_ownership (element_type, vala_type_reference_get_takes_ownership (type)), vala_type_reference_get_takes_ownership (element_type));
			}
			__temp56 = NULL;
			(vala_type_reference_set_data_type (type, VALA_DATA_TYPE ((__temp56 = vala_data_type_get_array (vala_type_reference_get_data_type (element_type), vala_type_reference_get_array_rank (type))))), vala_type_reference_get_data_type (type));
			(__temp56 = (g_object_unref (__temp56), NULL));
		} else {
			ValaArray* __temp57;
			__temp57 = NULL;
			(vala_type_reference_set_data_type (type, VALA_DATA_TYPE ((__temp57 = vala_type_parameter_get_array (vala_type_reference_get_type_parameter (element_type), vala_type_reference_get_array_rank (type))))), vala_type_reference_get_data_type (type));
			(__temp57 = (g_object_unref (__temp57), NULL));
			(vala_type_reference_set_type_parameter (type, NULL), vala_type_reference_get_type_parameter (type));
		}
		vala_type_reference_add_type_argument (type, element_type);
		(element_type == NULL ? NULL : (element_type = (g_object_unref (element_type), NULL)));
	}
	if (vala_type_reference_get_data_type (type) != NULL && !vala_data_type_is_reference_type (vala_type_reference_get_data_type (type))) {
		/* reset takes_ownership and transfers_ownership of
		 * value-types for contexts where types are ref by
		 * default (field declarations and method return types)
		 */
		(vala_type_reference_set_takes_ownership (type, FALSE), vala_type_reference_get_takes_ownership (type));
		(vala_type_reference_set_transfers_ownership (type, FALSE), vala_type_reference_get_transfers_ownership (type));
	}
}


static void vala_symbol_resolver_class_init (ValaSymbolResolverClass * klass)
{
	vala_symbol_resolver_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaSymbolResolverPrivate));
	G_OBJECT_CLASS (klass)->dispose = vala_symbol_resolver_dispose;
	VALA_CODE_VISITOR_CLASS (klass)->visit_source_file = vala_symbol_resolver_real_visit_source_file;
	VALA_CODE_VISITOR_CLASS (klass)->visit_namespace = vala_symbol_resolver_real_visit_namespace;
	VALA_CODE_VISITOR_CLASS (klass)->visit_class = vala_symbol_resolver_real_visit_class;
	VALA_CODE_VISITOR_CLASS (klass)->visit_struct = vala_symbol_resolver_real_visit_struct;
	VALA_CODE_VISITOR_CLASS (klass)->visit_interface = vala_symbol_resolver_real_visit_interface;
	VALA_CODE_VISITOR_CLASS (klass)->visit_enum = vala_symbol_resolver_real_visit_enum;
	VALA_CODE_VISITOR_CLASS (klass)->visit_callback = vala_symbol_resolver_real_visit_callback;
	VALA_CODE_VISITOR_CLASS (klass)->visit_constant = vala_symbol_resolver_real_visit_constant;
	VALA_CODE_VISITOR_CLASS (klass)->visit_field = vala_symbol_resolver_real_visit_field;
	VALA_CODE_VISITOR_CLASS (klass)->visit_method = vala_symbol_resolver_real_visit_method;
	VALA_CODE_VISITOR_CLASS (klass)->visit_creation_method = vala_symbol_resolver_real_visit_creation_method;
	VALA_CODE_VISITOR_CLASS (klass)->visit_formal_parameter = vala_symbol_resolver_real_visit_formal_parameter;
	VALA_CODE_VISITOR_CLASS (klass)->visit_property = vala_symbol_resolver_real_visit_property;
	VALA_CODE_VISITOR_CLASS (klass)->visit_property_accessor = vala_symbol_resolver_real_visit_property_accessor;
	VALA_CODE_VISITOR_CLASS (klass)->visit_signal = vala_symbol_resolver_real_visit_signal;
	VALA_CODE_VISITOR_CLASS (klass)->visit_constructor = vala_symbol_resolver_real_visit_constructor;
	VALA_CODE_VISITOR_CLASS (klass)->visit_destructor = vala_symbol_resolver_real_visit_destructor;
	VALA_CODE_VISITOR_CLASS (klass)->visit_namespace_reference = vala_symbol_resolver_real_visit_namespace_reference;
	VALA_CODE_VISITOR_CLASS (klass)->visit_type_reference = vala_symbol_resolver_real_visit_type_reference;
}


static void vala_symbol_resolver_init (ValaSymbolResolver * self)
{
	self->priv = VALA_SYMBOL_RESOLVER_GET_PRIVATE (self);
}


static void vala_symbol_resolver_dispose (GObject * obj)
{
	ValaSymbolResolver * self;
	ValaSymbolResolverClass * klass;
	GObjectClass * parent_class;
	self = VALA_SYMBOL_RESOLVER (obj);
	(self->priv->root_symbol == NULL ? NULL : (self->priv->root_symbol = (g_object_unref (self->priv->root_symbol), NULL)));
	(self->priv->current_scope == NULL ? NULL : (self->priv->current_scope = (g_object_unref (self->priv->current_scope), NULL)));
	(self->priv->current_using_directives == NULL ? NULL : (self->priv->current_using_directives = (g_list_free (self->priv->current_using_directives), NULL)));
	(self->priv->object_class == NULL ? NULL : (self->priv->object_class = (g_object_unref (self->priv->object_class), NULL)));
	klass = VALA_SYMBOL_RESOLVER_CLASS (g_type_class_peek (VALA_TYPE_SYMBOL_RESOLVER));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	parent_class->dispose (obj);
}


GType vala_symbol_resolver_get_type ()
{
	static GType vala_symbol_resolver_type_id = 0;
	if (G_UNLIKELY (vala_symbol_resolver_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaSymbolResolverClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_symbol_resolver_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaSymbolResolver), 0, (GInstanceInitFunc) vala_symbol_resolver_init };
		vala_symbol_resolver_type_id = g_type_register_static (VALA_TYPE_CODE_VISITOR, "ValaSymbolResolver", &g_define_type_info, 0);
	}
	return vala_symbol_resolver_type_id;
}




