/* valaforstatement.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */
#define VALA_FREE_CHECKED(o,f) ((o) == NULL ? NULL : ((o) = (f (o), NULL)))
#define VALA_FREE_UNCHECKED(o,f) ((o) = (f (o), NULL))

#include "valaforstatement.h"
#include <vala/valaexpression.h>
#include <vala/valasourcereference.h>
#include <vala/valaforstatement.h>
#include <vala/valacodevisitor.h>

struct _ValaForStatementPrivate {
	ValaStatement* _body;
	GList* initializer;
	GList* iterator;
	ValaExpression* _condition;
};
#define VALA_FOR_STATEMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_FOR_STATEMENT, ValaForStatementPrivate))
enum  {
	VALA_FOR_STATEMENT_DUMMY_PROPERTY,
	VALA_FOR_STATEMENT_CONDITION,
	VALA_FOR_STATEMENT_BODY
};
static void vala_for_statement_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_for_statement_real_replace (ValaCodeNode* base, ValaCodeNode* old_node, ValaCodeNode* new_node);
static gpointer vala_for_statement_parent_class = NULL;
static void vala_for_statement_dispose (GObject * obj);


/**
 * Creates a new for statement.
 *
 * @param cond   loop condition
 * @param body   loop body
 * @param source reference to source code
 * @return       newly created for statement
 */
ValaForStatement* vala_for_statement_new (ValaExpression* cond, ValaStatement* _body, ValaSourceReference* source)
{
	GParameter * __params;
	GParameter * __params_it;
	ValaForStatement * self;
	g_return_val_if_fail (cond == NULL || VALA_IS_EXPRESSION (cond), NULL);
	g_return_val_if_fail (_body == NULL || VALA_IS_STATEMENT (_body), NULL);
	g_return_val_if_fail (source == NULL || VALA_IS_SOURCE_REFERENCE (source), NULL);
	__params = g_new0 (GParameter, 3);
	__params_it = __params;
	(__params_it->name = "condition", g_value_init (&__params_it->value, VALA_TYPE_EXPRESSION), g_value_set_object (&__params_it->value, cond), __params_it++);
	(__params_it->name = "body", g_value_init (&__params_it->value, VALA_TYPE_STATEMENT), g_value_set_object (&__params_it->value, _body), __params_it++);
	(__params_it->name = "source-reference", g_value_init (&__params_it->value, VALA_TYPE_SOURCE_REFERENCE), g_value_set_object (&__params_it->value, source), __params_it++);
	self = g_object_newv (VALA_TYPE_FOR_STATEMENT, __params_it - __params, __params);
	return self;
}


/**
 * Appends the specified expression to the list of initializers.
 *
 * @param init an initializer expression
 */
void vala_for_statement_add_initializer (ValaForStatement* self, ValaExpression* init)
{
	g_return_if_fail (VALA_IS_FOR_STATEMENT (self));
	g_return_if_fail (VALA_IS_EXPRESSION (init));
	(vala_code_node_set_parent_node (VALA_CODE_NODE (init), VALA_CODE_NODE (self)), vala_code_node_get_parent_node (VALA_CODE_NODE (init)));
	self->priv->initializer = g_list_append (self->priv->initializer, g_object_ref (init));
}


/**
 * Returns a copy of the list of initializers.
 *
 * @return initializer list
 */
GList* vala_for_statement_get_initializer (ValaForStatement* self)
{
	g_return_val_if_fail (VALA_IS_FOR_STATEMENT (self), NULL);
	return g_list_copy (self->priv->initializer);
}


/**
 * Appends the specified expression to the iterator.
 *
 * @param iter an iterator expression
 */
void vala_for_statement_add_iterator (ValaForStatement* self, ValaExpression* iter)
{
	g_return_if_fail (VALA_IS_FOR_STATEMENT (self));
	g_return_if_fail (VALA_IS_EXPRESSION (iter));
	(vala_code_node_set_parent_node (VALA_CODE_NODE (iter), VALA_CODE_NODE (self)), vala_code_node_get_parent_node (VALA_CODE_NODE (iter)));
	self->priv->iterator = g_list_append (self->priv->iterator, g_object_ref (iter));
}


/**
 * Returns a copy of the iterator.
 *
 * @return iterator
 */
GList* vala_for_statement_get_iterator (ValaForStatement* self)
{
	g_return_val_if_fail (VALA_IS_FOR_STATEMENT (self), NULL);
	return g_list_copy (self->priv->iterator);
}


static void vala_for_statement_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor)
{
	ValaForStatement * self;
	self = VALA_FOR_STATEMENT (base);
	g_return_if_fail (VALA_IS_CODE_VISITOR (visitor));
	{
		GList* __temp2;
		GList* init_expr_it;
		__temp2 = NULL;
		__temp2 = self->priv->initializer;
		for (init_expr_it = __temp2; init_expr_it != NULL; init_expr_it = init_expr_it->next) {
			ValaExpression* init_expr;
			init_expr = init_expr_it->data;
			{
				vala_code_node_accept (VALA_CODE_NODE (init_expr), visitor);
				vala_code_visitor_visit_end_full_expression (visitor, init_expr);
			}
		}
	}
	vala_code_node_accept (VALA_CODE_NODE (vala_for_statement_get_condition (self)), visitor);
	vala_code_visitor_visit_end_full_expression (visitor, vala_for_statement_get_condition (self));
	{
		GList* __temp3;
		GList* it_expr_it;
		__temp3 = NULL;
		__temp3 = self->priv->iterator;
		for (it_expr_it = __temp3; it_expr_it != NULL; it_expr_it = it_expr_it->next) {
			ValaExpression* it_expr;
			it_expr = it_expr_it->data;
			{
				vala_code_node_accept (VALA_CODE_NODE (it_expr), visitor);
				vala_code_visitor_visit_end_full_expression (visitor, it_expr);
			}
		}
	}
	vala_code_node_accept (VALA_CODE_NODE (vala_for_statement_get_body (self)), visitor);
	vala_code_visitor_visit_for_statement (visitor, self);
}


static void vala_for_statement_real_replace (ValaCodeNode* base, ValaCodeNode* old_node, ValaCodeNode* new_node)
{
	ValaForStatement * self;
	GList* iter;
	self = VALA_FOR_STATEMENT (base);
	g_return_if_fail (VALA_IS_CODE_NODE (old_node));
	g_return_if_fail (VALA_IS_CODE_NODE (new_node));
	iter = NULL;
	if (VALA_CODE_NODE (vala_for_statement_get_condition (self)) == old_node) {
		(vala_for_statement_set_condition (self, VALA_EXPRESSION (new_node)), vala_for_statement_get_condition (self));
		return;
	}
	for (iter = self->priv->initializer; iter != NULL; iter = iter->next) {
		if (iter->data == old_node) {
			GList* silbling;
			silbling = iter->next;
			self->priv->initializer = g_list_delete_link (self->priv->initializer, iter);
			self->priv->initializer = g_list_insert_before (self->priv->initializer, silbling, g_object_ref (new_node));
			return;
		}
	}
	for (iter = self->priv->iterator; iter != NULL; iter = iter->next) {
		if (iter->data == old_node) {
			GList* silbling;
			silbling = iter->next;
			self->priv->iterator = g_list_delete_link (self->priv->iterator, iter);
			self->priv->iterator = g_list_insert_before (self->priv->iterator, silbling, g_object_ref (new_node));
			return;
		}
	}
}


ValaExpression* vala_for_statement_get_condition (ValaForStatement* self)
{
	g_return_val_if_fail (VALA_IS_FOR_STATEMENT (self), NULL);
	return self->priv->_condition;
}


void vala_for_statement_set_condition (ValaForStatement* self, ValaExpression* value)
{
	ValaExpression* __temp5;
	g_return_if_fail (VALA_IS_FOR_STATEMENT (self));
	__temp5 = NULL;
	self->priv->_condition = (__temp5 = g_object_ref (value), (self->priv->_condition == NULL ? NULL : (self->priv->_condition = (g_object_unref (self->priv->_condition), NULL))), __temp5);
	(vala_code_node_set_parent_node (VALA_CODE_NODE (self->priv->_condition), VALA_CODE_NODE (self)), vala_code_node_get_parent_node (VALA_CODE_NODE (self->priv->_condition)));
}


ValaStatement* vala_for_statement_get_body (ValaForStatement* self)
{
	g_return_val_if_fail (VALA_IS_FOR_STATEMENT (self), NULL);
	return self->priv->_body;
}


void vala_for_statement_set_body (ValaForStatement* self, ValaStatement* value)
{
	ValaStatement* __temp8;
	ValaStatement* __temp7;
	g_return_if_fail (VALA_IS_FOR_STATEMENT (self));
	__temp8 = NULL;
	__temp7 = NULL;
	self->priv->_body = (__temp8 = (__temp7 = value, (__temp7 == NULL ? NULL : g_object_ref (__temp7))), (self->priv->_body == NULL ? NULL : (self->priv->_body = (g_object_unref (self->priv->_body), NULL))), __temp8);
}


static void vala_for_statement_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec)
{
	ValaForStatement * self;
	self = VALA_FOR_STATEMENT (object);
	switch (property_id) {
		case VALA_FOR_STATEMENT_CONDITION:
		g_value_set_object (value, vala_for_statement_get_condition (self));
		break;
		case VALA_FOR_STATEMENT_BODY:
		g_value_set_object (value, vala_for_statement_get_body (self));
		break;
	}
}


static void vala_for_statement_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec)
{
	ValaForStatement * self;
	self = VALA_FOR_STATEMENT (object);
	switch (property_id) {
		case VALA_FOR_STATEMENT_CONDITION:
		vala_for_statement_set_condition (self, g_value_get_object (value));
		break;
		case VALA_FOR_STATEMENT_BODY:
		vala_for_statement_set_body (self, g_value_get_object (value));
		break;
	}
}


static void vala_for_statement_class_init (ValaForStatementClass * klass)
{
	vala_for_statement_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaForStatementPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_for_statement_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_for_statement_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_for_statement_dispose;
	VALA_CODE_NODE_CLASS (klass)->accept = vala_for_statement_real_accept;
	VALA_CODE_NODE_CLASS (klass)->replace = vala_for_statement_real_replace;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_FOR_STATEMENT_CONDITION, g_param_spec_object ("condition", "foo", "bar", VALA_TYPE_EXPRESSION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_FOR_STATEMENT_BODY, g_param_spec_object ("body", "foo", "bar", VALA_TYPE_STATEMENT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_for_statement_init (ValaForStatement * self)
{
	self->priv = VALA_FOR_STATEMENT_GET_PRIVATE (self);
}


static void vala_for_statement_dispose (GObject * obj)
{
	ValaForStatement * self;
	ValaForStatementClass * klass;
	GObjectClass * parent_class;
	self = VALA_FOR_STATEMENT (obj);
	(self->priv->_body == NULL ? NULL : (self->priv->_body = (g_object_unref (self->priv->_body), NULL)));
	(self->priv->initializer == NULL ? NULL : (self->priv->initializer = (g_list_foreach (self->priv->initializer, (GFunc) g_object_unref, NULL), g_list_free (self->priv->initializer), NULL)));
	(self->priv->iterator == NULL ? NULL : (self->priv->iterator = (g_list_foreach (self->priv->iterator, (GFunc) g_object_unref, NULL), g_list_free (self->priv->iterator), NULL)));
	(self->priv->_condition == NULL ? NULL : (self->priv->_condition = (g_object_unref (self->priv->_condition), NULL)));
	klass = VALA_FOR_STATEMENT_CLASS (g_type_class_peek (VALA_TYPE_FOR_STATEMENT));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	parent_class->dispose (obj);
}


GType vala_for_statement_get_type ()
{
	static GType vala_for_statement_type_id = 0;
	if (G_UNLIKELY (vala_for_statement_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaForStatementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_for_statement_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaForStatement), 0, (GInstanceInitFunc) vala_for_statement_init };
		vala_for_statement_type_id = g_type_register_static (VALA_TYPE_STATEMENT, "ValaForStatement", &g_define_type_info, 0);
	}
	return vala_for_statement_type_id;
}




